"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ParameterMapping = exports.MappingValue = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
;
/**
 * Represents a Mapping Value.
 */
class MappingValue {
    constructor(value) {
        this.value = value;
    }
    /**
     * Creates a header mapping value.
     */
    static requestHeader(name) { return new MappingValue(`$request.header.${name}`); }
    /**
     * Creates a query string mapping value.
     */
    static requestQueryString(name) { return new MappingValue(`$request.querystring.${name}`); }
    /**
     * Creates a request body mapping value.
     */
    static requestBody(name) { return new MappingValue(`$request.body.${name}`); }
    /**
     * Creates a request path mapping value.
     */
    static requestPath() { return new MappingValue('$request.path'); }
    /**
     * Creates a request path parameter mapping value.
     */
    static requestPathParam(name) { return new MappingValue(`$request.path.${name}`); }
    /**
     * Creates a context variable mapping value.
     */
    static contextVariable(variableName) { return new MappingValue(`$context.${variableName}`); }
    /**
     * Creates a stage variable mapping value.
     */
    static stageVariable(variableName) { return new MappingValue(`$stageVariables.${variableName}`); }
    /**
     * Creates a custom mapping value.
     */
    static custom(value) { return new MappingValue(value); }
}
exports.MappingValue = MappingValue;
_a = JSII_RTTI_SYMBOL_1;
MappingValue[_a] = { fqn: "monocdk.aws_apigatewayv2.MappingValue", version: "1.191.0" };
/**
* Creates an empty mapping value.
*/
MappingValue.NONE = new MappingValue('');
/**
 * Represents a Parameter Mapping.
 */
class ParameterMapping {
    constructor() {
        this.mappings = {};
    }
    /**
     * Creates a mapping from an object.
     */
    static fromObject(obj) {
        const mapping = new ParameterMapping();
        for (const [k, m] of Object.entries(obj)) {
            mapping.custom(k, m.value);
        }
        return mapping;
    }
    /**
     * Creates a mapping to append a header.
     */
    appendHeader(name, value) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_apigatewayv2_MappingValue(value);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.appendHeader);
            }
            throw error;
        }
        this.mappings[`append:header.${name}`] = value.value;
        return this;
    }
    /**
     * Creates a mapping to overwrite a header.
     */
    overwriteHeader(name, value) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_apigatewayv2_MappingValue(value);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.overwriteHeader);
            }
            throw error;
        }
        this.mappings[`overwrite:header.${name}`] = value.value;
        return this;
    }
    /**
     * Creates a mapping to remove a header.
     */
    removeHeader(name) {
        this.mappings[`remove:header.${name}`] = '';
        return this;
    }
    /**
     * Creates a mapping to append a query string.
     */
    appendQueryString(name, value) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_apigatewayv2_MappingValue(value);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.appendQueryString);
            }
            throw error;
        }
        this.mappings[`append:querystring.${name}`] = value.value;
        return this;
    }
    /**
     * Creates a mapping to overwrite a querystring.
     */
    overwriteQueryString(name, value) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_apigatewayv2_MappingValue(value);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.overwriteQueryString);
            }
            throw error;
        }
        this.mappings[`overwrite:querystring.${name}`] = value.value;
        return this;
    }
    /**
     * Creates a mapping to remove a querystring.
     */
    removeQueryString(name) {
        this.mappings[`remove:querystring.${name}`] = '';
        return this;
    }
    /**
     * Creates a mapping to overwrite a path.
     */
    overwritePath(value) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_apigatewayv2_MappingValue(value);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.overwritePath);
            }
            throw error;
        }
        this.mappings['overwrite:path'] = value.value;
        return this;
    }
    /**
     * Creates a custom mapping.
     */
    custom(key, value) {
        this.mappings[key] = value;
        return this;
    }
}
exports.ParameterMapping = ParameterMapping;
_b = JSII_RTTI_SYMBOL_1;
ParameterMapping[_b] = { fqn: "monocdk.aws_apigatewayv2.ParameterMapping", version: "1.191.0" };
//# sourceMappingURL=data:application/json;base64,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