"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebSocketRouteIntegration = exports.WebSocketIntegration = exports.WebSocketIntegrationType = void 0;
const jsiiDeprecationWarnings = require("../../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../../core");
const apigatewayv2_generated_1 = require("../apigatewayv2.generated");
/**
 * WebSocket Integration Types
 */
var WebSocketIntegrationType;
(function (WebSocketIntegrationType) {
    /**
     * AWS Proxy Integration Type
     */
    WebSocketIntegrationType["AWS_PROXY"] = "AWS_PROXY";
    /**
     * Mock Integration Type
     */
    WebSocketIntegrationType["MOCK"] = "MOCK";
})(WebSocketIntegrationType = exports.WebSocketIntegrationType || (exports.WebSocketIntegrationType = {}));
/**
 * The integration for an API route.
 * @resource AWS::ApiGatewayV2::Integration
 */
class WebSocketIntegration extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings.monocdk_aws_apigatewayv2_WebSocketIntegrationProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, WebSocketIntegration);
            }
            throw error;
        }
        const integ = new apigatewayv2_generated_1.CfnIntegration(this, 'Resource', {
            apiId: props.webSocketApi.apiId,
            integrationType: props.integrationType,
            integrationUri: props.integrationUri,
        });
        this.integrationId = integ.ref;
        this.webSocketApi = props.webSocketApi;
    }
}
exports.WebSocketIntegration = WebSocketIntegration;
_a = JSII_RTTI_SYMBOL_1;
WebSocketIntegration[_a] = { fqn: "monocdk.aws_apigatewayv2.WebSocketIntegration", version: "1.191.0" };
/**
 * The interface that various route integration classes will inherit.
 */
class WebSocketRouteIntegration {
    /**
     * Initialize an integration for a route on websocket api.
     * @param id id of the underlying `WebSocketIntegration` construct.
     */
    constructor(id) {
        this.id = id;
    }
    /**
     * Internal method called when binding this integration to the route.
     * @internal
     */
    _bindToRoute(options) {
        if (this.integration && this.integration.webSocketApi.node.addr !== options.route.webSocketApi.node.addr) {
            throw new Error('A single integration cannot be associated with multiple APIs.');
        }
        if (!this.integration) {
            const config = this.bind(options);
            this.integration = new WebSocketIntegration(options.scope, this.id, {
                webSocketApi: options.route.webSocketApi,
                integrationType: config.type,
                integrationUri: config.uri,
            });
        }
        return { integrationId: this.integration.integrationId };
    }
}
exports.WebSocketRouteIntegration = WebSocketRouteIntegration;
_b = JSII_RTTI_SYMBOL_1;
WebSocketRouteIntegration[_b] = { fqn: "monocdk.aws_apigatewayv2.WebSocketRouteIntegration", version: "1.191.0" };
//# sourceMappingURL=data:application/json;base64,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