"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GatewayRoute = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("../../core");
const appmesh_generated_1 = require("./appmesh.generated");
const utils_1 = require("./private/utils");
const virtual_gateway_1 = require("./virtual-gateway");
/**
 * GatewayRoute represents a new or existing gateway route attached to a VirtualGateway and Mesh
 *
 * @see https://docs.aws.amazon.com/app-mesh/latest/userguide/gateway-routes.html
 */
class GatewayRoute extends cdk.Resource {
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.gatewayRouteName || cdk.Lazy.string({ produce: () => cdk.Names.uniqueId(this) }),
        });
        try {
            jsiiDeprecationWarnings.monocdk_aws_appmesh_GatewayRouteProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, GatewayRoute);
            }
            throw error;
        }
        this.virtualGateway = props.virtualGateway;
        const routeSpecConfig = props.routeSpec.bind(this);
        const gatewayRoute = new appmesh_generated_1.CfnGatewayRoute(this, 'Resource', {
            gatewayRouteName: this.physicalName,
            meshName: props.virtualGateway.mesh.meshName,
            meshOwner: utils_1.renderMeshOwner(this.env.account, this.virtualGateway.mesh.env.account),
            spec: {
                httpRoute: routeSpecConfig.httpSpecConfig,
                http2Route: routeSpecConfig.http2SpecConfig,
                grpcRoute: routeSpecConfig.grpcSpecConfig,
                priority: routeSpecConfig.priority,
            },
            virtualGatewayName: this.virtualGateway.virtualGatewayName,
        });
        this.gatewayRouteName = this.getResourceNameAttribute(gatewayRoute.attrGatewayRouteName);
        this.gatewayRouteArn = this.getResourceArnAttribute(gatewayRoute.ref, {
            service: 'appmesh',
            resource: `mesh/${props.virtualGateway.mesh.meshName}/virtualRouter/${this.virtualGateway.virtualGatewayName}/gatewayRoute`,
            resourceName: this.physicalName,
        });
    }
    /**
     * Import an existing GatewayRoute given an ARN
     */
    static fromGatewayRouteArn(scope, id, gatewayRouteArn) {
        return new class extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.gatewayRouteArn = gatewayRouteArn;
                this.gatewayRouteName = cdk.Fn.select(4, cdk.Fn.split('/', cdk.Stack.of(scope).splitArn(gatewayRouteArn, cdk.ArnFormat.SLASH_RESOURCE_NAME).resourceName));
                this.virtualGateway = virtual_gateway_1.VirtualGateway.fromVirtualGatewayArn(this, 'virtualGateway', gatewayRouteArn);
            }
        }(scope, id);
    }
    /**
     * Import an existing GatewayRoute given attributes
     */
    static fromGatewayRouteAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_appmesh_GatewayRouteAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromGatewayRouteAttributes);
            }
            throw error;
        }
        return new class extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.gatewayRouteName = attrs.gatewayRouteName;
                this.gatewayRouteArn = cdk.Stack.of(scope).formatArn({
                    service: 'appmesh',
                    resource: `mesh/${attrs.virtualGateway.mesh.meshName}/virtualGateway/${attrs.virtualGateway.virtualGatewayName}/gatewayRoute`,
                    resourceName: this.gatewayRouteName,
                });
                this.virtualGateway = attrs.virtualGateway;
            }
        }(scope, id);
    }
}
exports.GatewayRoute = GatewayRoute;
_a = JSII_RTTI_SYMBOL_1;
GatewayRoute[_a] = { fqn: "monocdk.aws_appmesh.GatewayRoute", version: "1.191.0" };
//# sourceMappingURL=data:application/json;base64,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