"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MutualTlsCertificate = exports.TlsCertificate = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Represents a TLS certificate
 */
class TlsCertificate {
    /**
     * Returns an File TLS Certificate
     */
    static file(certificateChainPath, privateKeyPath) {
        return new FileTlsCertificate(certificateChainPath, privateKeyPath);
    }
    /**
     * Returns an ACM TLS Certificate
     */
    static acm(certificate) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_certificatemanager_ICertificate(certificate);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.acm);
            }
            throw error;
        }
        return new AcmTlsCertificate(certificate);
    }
    /**
     * Returns an SDS TLS Certificate
     */
    static sds(secretName) {
        return new SdsTlsCertificate(secretName);
    }
}
exports.TlsCertificate = TlsCertificate;
_a = JSII_RTTI_SYMBOL_1;
TlsCertificate[_a] = { fqn: "monocdk.aws_appmesh.TlsCertificate", version: "1.191.0" };
/**
 * Represents a TLS certificate that is supported for mutual TLS authentication.
 */
class MutualTlsCertificate extends TlsCertificate {
    constructor() {
        super(...arguments);
        // TypeScript uses structural typing, so we need a property different from TlsCertificate
        this.differentiator = false;
    }
}
exports.MutualTlsCertificate = MutualTlsCertificate;
_b = JSII_RTTI_SYMBOL_1;
MutualTlsCertificate[_b] = { fqn: "monocdk.aws_appmesh.MutualTlsCertificate", version: "1.191.0" };
/**
 * Represents a ACM provided TLS certificate
 */
class AcmTlsCertificate extends TlsCertificate {
    constructor(certificate) {
        super();
        this.acmCertificate = certificate;
    }
    bind(_scope) {
        return {
            tlsCertificate: {
                acm: {
                    certificateArn: this.acmCertificate.certificateArn,
                },
            },
        };
    }
}
/**
 * Represents a file provided TLS certificate
 */
class FileTlsCertificate extends MutualTlsCertificate {
    constructor(certificateChainPath, privateKeyPath) {
        super();
        this.certificateChain = certificateChainPath;
        this.privateKey = privateKeyPath;
    }
    bind(_scope) {
        return {
            tlsCertificate: {
                file: {
                    certificateChain: this.certificateChain,
                    privateKey: this.privateKey,
                },
            },
        };
    }
}
/**
 * Represents a SDS provided TLS certificate
 */
class SdsTlsCertificate extends MutualTlsCertificate {
    constructor(secretName) {
        super();
        this.secretName = secretName;
    }
    bind(_scope) {
        return {
            tlsCertificate: {
                sds: {
                    secretName: this.secretName,
                },
            },
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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