"use strict";
var _a, _b, _c, _d, _e, _f, _g, _h, _j;
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpenSearchDataSource = exports.ElasticsearchDataSource = exports.RdsDataSource = exports.LambdaDataSource = exports.HttpDataSource = exports.DynamoDbDataSource = exports.NoneDataSource = exports.BackedDataSource = exports.BaseDataSource = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_iam_1 = require("../../aws-iam");
const core_1 = require("../../core");
const appsync_function_1 = require("./appsync-function");
const appsync_generated_1 = require("./appsync.generated");
const resolver_1 = require("./resolver");
// v2 - keep this import as a separate section to reduce merge conflict when forward merging with the v2 branch.
// eslint-disable-next-line
const core_2 = require("../../core");
/**
 * Abstract AppSync datasource implementation. Do not use directly but use subclasses for concrete datasources
 */
class BaseDataSource extends core_2.Construct {
    constructor(scope, id, props, extended) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings.monocdk_aws_appsync_BackedDataSourceProps(props);
            jsiiDeprecationWarnings.monocdk_aws_appsync_ExtendedDataSourceProps(extended);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, BaseDataSource);
            }
            throw error;
        }
        if (extended.type !== 'NONE') {
            this.serviceRole = props.serviceRole || new aws_iam_1.Role(this, 'ServiceRole', { assumedBy: new aws_iam_1.ServicePrincipal('appsync') });
        }
        // Replace unsupported characters from DataSource name. The only allowed pattern is: {[_A-Za-z][_0-9A-Za-z]*}
        const name = (props.name ?? id).replace(/[\W]+/g, '');
        this.ds = new appsync_generated_1.CfnDataSource(this, 'Resource', {
            apiId: props.api.apiId,
            name: name,
            description: props.description,
            serviceRoleArn: this.serviceRole?.roleArn,
            ...extended,
        });
        this.name = name;
        this.api = props.api;
    }
    /**
     * creates a new resolver for this datasource and API using the given properties
     */
    createResolver(props) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_appsync_BaseResolverProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.createResolver);
            }
            throw error;
        }
        return new resolver_1.Resolver(this, `${props.typeName}${props.fieldName}Resolver`, {
            api: this.api,
            dataSource: this,
            ...props,
        });
    }
    /**
     * creates a new appsync function for this datasource and API using the given properties
     */
    createFunction(props) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_appsync_BaseAppsyncFunctionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.createFunction);
            }
            throw error;
        }
        return new appsync_function_1.AppsyncFunction(this, `${props.name}Function`, {
            api: this.api,
            dataSource: this,
            ...props,
        });
    }
}
exports.BaseDataSource = BaseDataSource;
_a = JSII_RTTI_SYMBOL_1;
BaseDataSource[_a] = { fqn: "monocdk.aws_appsync.BaseDataSource", version: "1.191.0" };
/**
 * Abstract AppSync datasource implementation. Do not use directly but use subclasses for resource backed datasources
 */
class BackedDataSource extends BaseDataSource {
    constructor(scope, id, props, extended) {
        super(scope, id, props, extended);
        try {
            jsiiDeprecationWarnings.monocdk_aws_appsync_BackedDataSourceProps(props);
            jsiiDeprecationWarnings.monocdk_aws_appsync_ExtendedDataSourceProps(extended);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, BackedDataSource);
            }
            throw error;
        }
        this.grantPrincipal = this.serviceRole;
    }
}
exports.BackedDataSource = BackedDataSource;
_b = JSII_RTTI_SYMBOL_1;
BackedDataSource[_b] = { fqn: "monocdk.aws_appsync.BackedDataSource", version: "1.191.0" };
/**
 * An AppSync dummy datasource
 */
class NoneDataSource extends BaseDataSource {
    constructor(scope, id, props) {
        super(scope, id, props, {
            type: 'NONE',
        });
        try {
            jsiiDeprecationWarnings.monocdk_aws_appsync_NoneDataSourceProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, NoneDataSource);
            }
            throw error;
        }
    }
}
exports.NoneDataSource = NoneDataSource;
_c = JSII_RTTI_SYMBOL_1;
NoneDataSource[_c] = { fqn: "monocdk.aws_appsync.NoneDataSource", version: "1.191.0" };
/**
 * An AppSync datasource backed by a DynamoDB table
 */
class DynamoDbDataSource extends BackedDataSource {
    constructor(scope, id, props) {
        super(scope, id, props, {
            type: 'AMAZON_DYNAMODB',
            dynamoDbConfig: {
                tableName: props.table.tableName,
                awsRegion: props.table.env.region,
                useCallerCredentials: props.useCallerCredentials,
            },
        });
        try {
            jsiiDeprecationWarnings.monocdk_aws_appsync_DynamoDbDataSourceProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, DynamoDbDataSource);
            }
            throw error;
        }
        if (props.readOnlyAccess) {
            props.table.grantReadData(this);
        }
        else {
            props.table.grantReadWriteData(this);
        }
    }
}
exports.DynamoDbDataSource = DynamoDbDataSource;
_d = JSII_RTTI_SYMBOL_1;
DynamoDbDataSource[_d] = { fqn: "monocdk.aws_appsync.DynamoDbDataSource", version: "1.191.0" };
/**
 * An AppSync datasource backed by a http endpoint
 */
class HttpDataSource extends BackedDataSource {
    constructor(scope, id, props) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_appsync_HttpDataSourceProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, HttpDataSource);
            }
            throw error;
        }
        const authorizationConfig = props.authorizationConfig ? {
            authorizationType: 'AWS_IAM',
            awsIamConfig: props.authorizationConfig,
        } : undefined;
        super(scope, id, props, {
            type: 'HTTP',
            httpConfig: {
                endpoint: props.endpoint,
                authorizationConfig,
            },
        });
    }
}
exports.HttpDataSource = HttpDataSource;
_e = JSII_RTTI_SYMBOL_1;
HttpDataSource[_e] = { fqn: "monocdk.aws_appsync.HttpDataSource", version: "1.191.0" };
/**
 * An AppSync datasource backed by a Lambda function
 */
class LambdaDataSource extends BackedDataSource {
    constructor(scope, id, props) {
        super(scope, id, props, {
            type: 'AWS_LAMBDA',
            lambdaConfig: {
                lambdaFunctionArn: props.lambdaFunction.functionArn,
            },
        });
        try {
            jsiiDeprecationWarnings.monocdk_aws_appsync_LambdaDataSourceProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, LambdaDataSource);
            }
            throw error;
        }
        props.lambdaFunction.grantInvoke(this);
    }
}
exports.LambdaDataSource = LambdaDataSource;
_f = JSII_RTTI_SYMBOL_1;
LambdaDataSource[_f] = { fqn: "monocdk.aws_appsync.LambdaDataSource", version: "1.191.0" };
/**
 * An AppSync datasource backed by RDS
 */
class RdsDataSource extends BackedDataSource {
    constructor(scope, id, props) {
        super(scope, id, props, {
            type: 'RELATIONAL_DATABASE',
            relationalDatabaseConfig: {
                rdsHttpEndpointConfig: {
                    awsRegion: props.serverlessCluster.env.region,
                    dbClusterIdentifier: core_1.Lazy.string({
                        produce: () => {
                            return core_1.Stack.of(this).formatArn({
                                service: 'rds',
                                resource: `cluster:${props.serverlessCluster.clusterIdentifier}`,
                            });
                        },
                    }),
                    awsSecretStoreArn: props.secretStore.secretArn,
                    databaseName: props.databaseName,
                },
                relationalDatabaseSourceType: 'RDS_HTTP_ENDPOINT',
            },
        });
        try {
            jsiiDeprecationWarnings.monocdk_aws_appsync_RdsDataSourceProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, RdsDataSource);
            }
            throw error;
        }
        const clusterArn = core_1.Stack.of(this).formatArn({
            service: 'rds',
            resource: `cluster:${props.serverlessCluster.clusterIdentifier}`,
        });
        props.secretStore.grantRead(this);
        // Change to grant with RDS grant becomes implemented
        props.serverlessCluster.grantDataApiAccess(this);
        aws_iam_1.Grant.addToPrincipal({
            grantee: this,
            actions: [
                'rds-data:DeleteItems',
                'rds-data:ExecuteSql',
                'rds-data:GetItems',
                'rds-data:InsertItems',
                'rds-data:UpdateItems',
            ],
            resourceArns: [clusterArn, `${clusterArn}:*`],
            scope: this,
        });
    }
}
exports.RdsDataSource = RdsDataSource;
_g = JSII_RTTI_SYMBOL_1;
RdsDataSource[_g] = { fqn: "monocdk.aws_appsync.RdsDataSource", version: "1.191.0" };
/**
 * An Appsync datasource backed by Elasticsearch
 *
 * @deprecated - use `OpenSearchDataSource`
 */
class ElasticsearchDataSource extends BackedDataSource {
    constructor(scope, id, props) {
        super(scope, id, props, {
            type: 'AMAZON_ELASTICSEARCH',
            elasticsearchConfig: {
                awsRegion: props.domain.env.region,
                endpoint: `https://${props.domain.domainEndpoint}`,
            },
        });
        try {
            jsiiDeprecationWarnings.print("monocdk.aws_appsync.ElasticsearchDataSource", "- use `OpenSearchDataSource`");
            jsiiDeprecationWarnings.monocdk_aws_appsync_ElasticsearchDataSourceProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, ElasticsearchDataSource);
            }
            throw error;
        }
        props.domain.grantReadWrite(this);
    }
}
exports.ElasticsearchDataSource = ElasticsearchDataSource;
_h = JSII_RTTI_SYMBOL_1;
ElasticsearchDataSource[_h] = { fqn: "monocdk.aws_appsync.ElasticsearchDataSource", version: "1.191.0" };
/**
 * An Appsync datasource backed by OpenSearch
 */
class OpenSearchDataSource extends BackedDataSource {
    constructor(scope, id, props) {
        super(scope, id, props, {
            type: 'AMAZON_OPENSEARCH_SERVICE',
            openSearchServiceConfig: {
                awsRegion: props.domain.env.region,
                endpoint: `https://${props.domain.domainEndpoint}`,
            },
        });
        try {
            jsiiDeprecationWarnings.monocdk_aws_appsync_OpenSearchDataSourceProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, OpenSearchDataSource);
            }
            throw error;
        }
        props.domain.grantReadWrite(this);
    }
}
exports.OpenSearchDataSource = OpenSearchDataSource;
_j = JSII_RTTI_SYMBOL_1;
OpenSearchDataSource[_j] = { fqn: "monocdk.aws_appsync.OpenSearchDataSource", version: "1.191.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZGF0YS1zb3VyY2UuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJkYXRhLXNvdXJjZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7QUFFQSwyQ0FBNkY7QUFLN0YscUNBQXNEO0FBRXRELHlEQUErRTtBQUMvRSwyREFBb0Q7QUFFcEQseUNBQXlEO0FBRXpELGdIQUFnSDtBQUNoSCwyQkFBMkI7QUFDM0IscUNBQXdEO0FBbUZ4RDs7R0FFRztBQUNILE1BQXNCLGNBQWUsU0FBUSxnQkFBYTtJQWF4RCxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQTRCLEVBQUUsUUFBaUM7UUFDdkcsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQzs7Ozs7OzsrQ0FkQyxjQUFjOzs7O1FBZ0JoQyxJQUFJLFFBQVEsQ0FBQyxJQUFJLEtBQUssTUFBTSxFQUFFO1lBQzVCLElBQUksQ0FBQyxXQUFXLEdBQUcsS0FBSyxDQUFDLFdBQVcsSUFBSSxJQUFJLGNBQUksQ0FBQyxJQUFJLEVBQUUsYUFBYSxFQUFFLEVBQUUsU0FBUyxFQUFFLElBQUksMEJBQWdCLENBQUMsU0FBUyxDQUFDLEVBQUUsQ0FBQyxDQUFDO1NBQ3ZIO1FBQ0QsNkdBQTZHO1FBQzdHLE1BQU0sSUFBSSxHQUFHLENBQUMsS0FBSyxDQUFDLElBQUksSUFBSSxFQUFFLENBQUMsQ0FBQyxPQUFPLENBQUMsUUFBUSxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBQ3RELElBQUksQ0FBQyxFQUFFLEdBQUcsSUFBSSxpQ0FBYSxDQUFDLElBQUksRUFBRSxVQUFVLEVBQUU7WUFDNUMsS0FBSyxFQUFFLEtBQUssQ0FBQyxHQUFHLENBQUMsS0FBSztZQUN0QixJQUFJLEVBQUUsSUFBSTtZQUNWLFdBQVcsRUFBRSxLQUFLLENBQUMsV0FBVztZQUM5QixjQUFjLEVBQUUsSUFBSSxDQUFDLFdBQVcsRUFBRSxPQUFPO1lBQ3pDLEdBQUcsUUFBUTtTQUNaLENBQUMsQ0FBQztRQUNILElBQUksQ0FBQyxJQUFJLEdBQUcsSUFBSSxDQUFDO1FBQ2pCLElBQUksQ0FBQyxHQUFHLEdBQUcsS0FBSyxDQUFDLEdBQUcsQ0FBQztLQUN0QjtJQUVEOztPQUVHO0lBQ0ksY0FBYyxDQUFDLEtBQXdCOzs7Ozs7Ozs7O1FBQzVDLE9BQU8sSUFBSSxtQkFBUSxDQUFDLElBQUksRUFBRSxHQUFHLEtBQUssQ0FBQyxRQUFRLEdBQUcsS0FBSyxDQUFDLFNBQVMsVUFBVSxFQUFFO1lBQ3ZFLEdBQUcsRUFBRSxJQUFJLENBQUMsR0FBRztZQUNiLFVBQVUsRUFBRSxJQUFJO1lBQ2hCLEdBQUcsS0FBSztTQUNULENBQUMsQ0FBQztLQUNKO0lBRUQ7O09BRUc7SUFDSSxjQUFjLENBQUMsS0FBK0I7Ozs7Ozs7Ozs7UUFDbkQsT0FBTyxJQUFJLGtDQUFlLENBQUMsSUFBSSxFQUFFLEdBQUcsS0FBSyxDQUFDLElBQUksVUFBVSxFQUFFO1lBQ3hELEdBQUcsRUFBRSxJQUFJLENBQUMsR0FBRztZQUNiLFVBQVUsRUFBRSxJQUFJO1lBQ2hCLEdBQUcsS0FBSztTQUNULENBQUMsQ0FBQztLQUNKOztBQXBESCx3Q0FxREM7OztBQUVEOztHQUVHO0FBQ0gsTUFBc0IsZ0JBQWlCLFNBQVEsY0FBYztJQU0zRCxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQTRCLEVBQUUsUUFBaUM7UUFDdkcsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUUsS0FBSyxFQUFFLFFBQVEsQ0FBQyxDQUFDOzs7Ozs7OytDQVBoQixnQkFBZ0I7Ozs7UUFTbEMsSUFBSSxDQUFDLGNBQWMsR0FBRyxJQUFJLENBQUMsV0FBWSxDQUFDO0tBQ3pDOztBQVZILDRDQVdDOzs7QUFRRDs7R0FFRztBQUNILE1BQWEsY0FBZSxTQUFRLGNBQWM7SUFDaEQsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUEwQjtRQUNsRSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRSxLQUFLLEVBQUU7WUFDdEIsSUFBSSxFQUFFLE1BQU07U0FDYixDQUFDLENBQUM7Ozs7OzsrQ0FKTSxjQUFjOzs7O0tBS3hCOztBQUxILHdDQU1DOzs7QUF3QkQ7O0dBRUc7QUFDSCxNQUFhLGtCQUFtQixTQUFRLGdCQUFnQjtJQUN0RCxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQThCO1FBQ3RFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLEtBQUssRUFBRTtZQUN0QixJQUFJLEVBQUUsaUJBQWlCO1lBQ3ZCLGNBQWMsRUFBRTtnQkFDZCxTQUFTLEVBQUUsS0FBSyxDQUFDLEtBQUssQ0FBQyxTQUFTO2dCQUNoQyxTQUFTLEVBQUUsS0FBSyxDQUFDLEtBQUssQ0FBQyxHQUFHLENBQUMsTUFBTTtnQkFDakMsb0JBQW9CLEVBQUUsS0FBSyxDQUFDLG9CQUFvQjthQUNqRDtTQUNGLENBQUMsQ0FBQzs7Ozs7OytDQVRNLGtCQUFrQjs7OztRQVUzQixJQUFJLEtBQUssQ0FBQyxjQUFjLEVBQUU7WUFDeEIsS0FBSyxDQUFDLEtBQUssQ0FBQyxhQUFhLENBQUMsSUFBSSxDQUFDLENBQUM7U0FDakM7YUFBTTtZQUNMLEtBQUssQ0FBQyxLQUFLLENBQUMsa0JBQWtCLENBQUMsSUFBSSxDQUFDLENBQUM7U0FDdEM7S0FDRjs7QUFmSCxnREFnQkM7OztBQW1DRDs7R0FFRztBQUNILE1BQWEsY0FBZSxTQUFRLGdCQUFnQjtJQUNsRCxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQTBCOzs7Ozs7K0NBRHpELGNBQWM7Ozs7UUFFdkIsTUFBTSxtQkFBbUIsR0FBRyxLQUFLLENBQUMsbUJBQW1CLENBQUMsQ0FBQyxDQUFDO1lBQ3RELGlCQUFpQixFQUFFLFNBQVM7WUFDNUIsWUFBWSxFQUFFLEtBQUssQ0FBQyxtQkFBbUI7U0FDeEMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDO1FBQ2QsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUUsS0FBSyxFQUFFO1lBQ3RCLElBQUksRUFBRSxNQUFNO1lBQ1osVUFBVSxFQUFFO2dCQUNWLFFBQVEsRUFBRSxLQUFLLENBQUMsUUFBUTtnQkFDeEIsbUJBQW1CO2FBQ3BCO1NBQ0YsQ0FBQyxDQUFDO0tBQ0o7O0FBYkgsd0NBY0M7OztBQVlEOztHQUVHO0FBQ0gsTUFBYSxnQkFBaUIsU0FBUSxnQkFBZ0I7SUFDcEQsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUE0QjtRQUNwRSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRSxLQUFLLEVBQUU7WUFDdEIsSUFBSSxFQUFFLFlBQVk7WUFDbEIsWUFBWSxFQUFFO2dCQUNaLGlCQUFpQixFQUFFLEtBQUssQ0FBQyxjQUFjLENBQUMsV0FBVzthQUNwRDtTQUNGLENBQUMsQ0FBQzs7Ozs7OytDQVBNLGdCQUFnQjs7OztRQVF6QixLQUFLLENBQUMsY0FBYyxDQUFDLFdBQVcsQ0FBQyxJQUFJLENBQUMsQ0FBQztLQUN4Qzs7QUFUSCw0Q0FVQzs7O0FBc0JEOztHQUVHO0FBQ0gsTUFBYSxhQUFjLFNBQVEsZ0JBQWdCO0lBQ2pELFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBeUI7UUFDakUsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUUsS0FBSyxFQUFFO1lBQ3RCLElBQUksRUFBRSxxQkFBcUI7WUFDM0Isd0JBQXdCLEVBQUU7Z0JBQ3hCLHFCQUFxQixFQUFFO29CQUNyQixTQUFTLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLEdBQUcsQ0FBQyxNQUFNO29CQUM3QyxtQkFBbUIsRUFBRSxXQUFJLENBQUMsTUFBTSxDQUFDO3dCQUMvQixPQUFPLEVBQUUsR0FBRyxFQUFFOzRCQUNaLE9BQU8sWUFBSyxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxTQUFTLENBQUM7Z0NBQzlCLE9BQU8sRUFBRSxLQUFLO2dDQUNkLFFBQVEsRUFBRSxXQUFXLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxpQkFBaUIsRUFBRTs2QkFDakUsQ0FBQyxDQUFDO3dCQUNMLENBQUM7cUJBQ0YsQ0FBQztvQkFDRixpQkFBaUIsRUFBRSxLQUFLLENBQUMsV0FBVyxDQUFDLFNBQVM7b0JBQzlDLFlBQVksRUFBRSxLQUFLLENBQUMsWUFBWTtpQkFDakM7Z0JBQ0QsNEJBQTRCLEVBQUUsbUJBQW1CO2FBQ2xEO1NBQ0YsQ0FBQyxDQUFDOzs7Ozs7K0NBcEJNLGFBQWE7Ozs7UUFxQnRCLE1BQU0sVUFBVSxHQUFHLFlBQUssQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLENBQUMsU0FBUyxDQUFDO1lBQzFDLE9BQU8sRUFBRSxLQUFLO1lBQ2QsUUFBUSxFQUFFLFdBQVcsS0FBSyxDQUFDLGlCQUFpQixDQUFDLGlCQUFpQixFQUFFO1NBQ2pFLENBQUMsQ0FBQztRQUNILEtBQUssQ0FBQyxXQUFXLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxDQUFDO1FBRWxDLHFEQUFxRDtRQUVyRCxLQUFLLENBQUMsaUJBQWlCLENBQUMsa0JBQWtCLENBQUMsSUFBSSxDQUFDLENBQUM7UUFFakQsZUFBSyxDQUFDLGNBQWMsQ0FBQztZQUNuQixPQUFPLEVBQUUsSUFBSTtZQUNiLE9BQU8sRUFBRTtnQkFDUCxzQkFBc0I7Z0JBQ3RCLHFCQUFxQjtnQkFDckIsbUJBQW1CO2dCQUNuQixzQkFBc0I7Z0JBQ3RCLHNCQUFzQjthQUN2QjtZQUNELFlBQVksRUFBRSxDQUFDLFVBQVUsRUFBRSxHQUFHLFVBQVUsSUFBSSxDQUFDO1lBQzdDLEtBQUssRUFBRSxJQUFJO1NBQ1osQ0FBQyxDQUFDO0tBQ0o7O0FBM0NILHNDQTRDQzs7O0FBY0Q7Ozs7R0FJRztBQUNILE1BQWEsdUJBQXdCLFNBQVEsZ0JBQWdCO0lBQzNELFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBbUM7UUFDM0UsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUUsS0FBSyxFQUFFO1lBQ3RCLElBQUksRUFBRSxzQkFBc0I7WUFDNUIsbUJBQW1CLEVBQUU7Z0JBQ25CLFNBQVMsRUFBRSxLQUFLLENBQUMsTUFBTSxDQUFDLEdBQUcsQ0FBQyxNQUFNO2dCQUNsQyxRQUFRLEVBQUUsV0FBVyxLQUFLLENBQUMsTUFBTSxDQUFDLGNBQWMsRUFBRTthQUNuRDtTQUNGLENBQUMsQ0FBQzs7Ozs7OzsrQ0FSTSx1QkFBdUI7Ozs7UUFVaEMsS0FBSyxDQUFDLE1BQU0sQ0FBQyxjQUFjLENBQUMsSUFBSSxDQUFDLENBQUM7S0FDbkM7O0FBWEgsMERBWUM7OztBQVlEOztHQUVHO0FBQ0gsTUFBYSxvQkFBcUIsU0FBUSxnQkFBZ0I7SUFDeEQsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUFnQztRQUN4RSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRSxLQUFLLEVBQUU7WUFDdEIsSUFBSSxFQUFFLDJCQUEyQjtZQUNqQyx1QkFBdUIsRUFBRTtnQkFDdkIsU0FBUyxFQUFFLEtBQUssQ0FBQyxNQUFNLENBQUMsR0FBRyxDQUFDLE1BQU07Z0JBQ2xDLFFBQVEsRUFBRSxXQUFXLEtBQUssQ0FBQyxNQUFNLENBQUMsY0FBYyxFQUFFO2FBQ25EO1NBQ0YsQ0FBQyxDQUFDOzs7Ozs7K0NBUk0sb0JBQW9COzs7O1FBVTdCLEtBQUssQ0FBQyxNQUFNLENBQUMsY0FBYyxDQUFDLElBQUksQ0FBQyxDQUFDO0tBQ25DOztBQVhILG9EQVlDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgSVRhYmxlIH0gZnJvbSAnLi4vLi4vYXdzLWR5bmFtb2RiJztcbmltcG9ydCB7IElEb21haW4gYXMgSUVsYXN0aWNzZWFyY2hEb21haW4gfSBmcm9tICcuLi8uLi9hd3MtZWxhc3RpY3NlYXJjaCc7XG5pbXBvcnQgeyBHcmFudCwgSUdyYW50YWJsZSwgSVByaW5jaXBhbCwgSVJvbGUsIFJvbGUsIFNlcnZpY2VQcmluY2lwYWwgfSBmcm9tICcuLi8uLi9hd3MtaWFtJztcbmltcG9ydCB7IElGdW5jdGlvbiB9IGZyb20gJy4uLy4uL2F3cy1sYW1iZGEnO1xuaW1wb3J0IHsgSURvbWFpbiBhcyBJT3BlblNlYXJjaERvbWFpbiB9IGZyb20gJy4uLy4uL2F3cy1vcGVuc2VhcmNoc2VydmljZSc7XG5pbXBvcnQgeyBJU2VydmVybGVzc0NsdXN0ZXIgfSBmcm9tICcuLi8uLi9hd3MtcmRzJztcbmltcG9ydCB7IElTZWNyZXQgfSBmcm9tICcuLi8uLi9hd3Mtc2VjcmV0c21hbmFnZXInO1xuaW1wb3J0IHsgSVJlc29sdmFibGUsIExhenksIFN0YWNrIH0gZnJvbSAnLi4vLi4vY29yZSc7XG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcbmltcG9ydCB7IEJhc2VBcHBzeW5jRnVuY3Rpb25Qcm9wcywgQXBwc3luY0Z1bmN0aW9uIH0gZnJvbSAnLi9hcHBzeW5jLWZ1bmN0aW9uJztcbmltcG9ydCB7IENmbkRhdGFTb3VyY2UgfSBmcm9tICcuL2FwcHN5bmMuZ2VuZXJhdGVkJztcbmltcG9ydCB7IElHcmFwaHFsQXBpIH0gZnJvbSAnLi9ncmFwaHFsYXBpLWJhc2UnO1xuaW1wb3J0IHsgQmFzZVJlc29sdmVyUHJvcHMsIFJlc29sdmVyIH0gZnJvbSAnLi9yZXNvbHZlcic7XG5cbi8vIHYyIC0ga2VlcCB0aGlzIGltcG9ydCBhcyBhIHNlcGFyYXRlIHNlY3Rpb24gdG8gcmVkdWNlIG1lcmdlIGNvbmZsaWN0IHdoZW4gZm9yd2FyZCBtZXJnaW5nIHdpdGggdGhlIHYyIGJyYW5jaC5cbi8vIGVzbGludC1kaXNhYmxlLW5leHQtbGluZVxuaW1wb3J0IHsgQ29uc3RydWN0IGFzIENvcmVDb25zdHJ1Y3QgfSBmcm9tICcuLi8uLi9jb3JlJztcblxuLyoqXG4gKiBCYXNlIHByb3BlcnRpZXMgZm9yIGFuIEFwcFN5bmMgZGF0YXNvdXJjZVxuICovXG5leHBvcnQgaW50ZXJmYWNlIEJhc2VEYXRhU291cmNlUHJvcHMge1xuICAvKipcbiAgICogVGhlIEFQSSB0byBhdHRhY2ggdGhpcyBkYXRhIHNvdXJjZSB0b1xuICAgKi9cbiAgcmVhZG9ubHkgYXBpOiBJR3JhcGhxbEFwaTtcbiAgLyoqXG4gICAqIFRoZSBuYW1lIG9mIHRoZSBkYXRhIHNvdXJjZVxuICAgKlxuICAgKiBAZGVmYXVsdCAtIGlkIG9mIGRhdGEgc291cmNlXG4gICAqL1xuICByZWFkb25seSBuYW1lPzogc3RyaW5nO1xuICAvKipcbiAgICogdGhlIGRlc2NyaXB0aW9uIG9mIHRoZSBkYXRhIHNvdXJjZVxuICAgKlxuICAgKiBAZGVmYXVsdCAtIE5vbmVcbiAgICovXG4gIHJlYWRvbmx5IGRlc2NyaXB0aW9uPzogc3RyaW5nO1xufVxuXG4vKipcbiAqIHByb3BlcnRpZXMgZm9yIGFuIEFwcFN5bmMgZGF0YXNvdXJjZSBiYWNrZWQgYnkgYSByZXNvdXJjZVxuICovXG5leHBvcnQgaW50ZXJmYWNlIEJhY2tlZERhdGFTb3VyY2VQcm9wcyBleHRlbmRzIEJhc2VEYXRhU291cmNlUHJvcHMge1xuICAvKipcbiAgICogVGhlIElBTSBzZXJ2aWNlIHJvbGUgdG8gYmUgYXNzdW1lZCBieSBBcHBTeW5jIHRvIGludGVyYWN0IHdpdGggdGhlIGRhdGEgc291cmNlXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gIENyZWF0ZSBhIG5ldyByb2xlXG4gICAqL1xuICByZWFkb25seSBzZXJ2aWNlUm9sZT86IElSb2xlO1xufVxuXG4vKipcbiAqIHByb3BzIHVzZWQgYnkgaW1wbGVtZW50YXRpb25zIG9mIEJhc2VEYXRhU291cmNlIHRvIHByb3ZpZGUgY29uZmlndXJhdGlvbi4gU2hvdWxkIG5vdCBiZSB1c2VkIGRpcmVjdGx5LlxuICovXG5leHBvcnQgaW50ZXJmYWNlIEV4dGVuZGVkRGF0YVNvdXJjZVByb3BzIHtcbiAgLyoqXG4gICAqIHRoZSB0eXBlIG9mIHRoZSBBcHBTeW5jIGRhdGFzb3VyY2VcbiAgICovXG4gIHJlYWRvbmx5IHR5cGU6IHN0cmluZztcbiAgLyoqXG4gICAqIGNvbmZpZ3VyYXRpb24gZm9yIER5bmFtb0RCIERhdGFzb3VyY2VcbiAgICpcbiAgICogQGRlZmF1bHQgLSBObyBjb25maWdcbiAgICovXG4gIHJlYWRvbmx5IGR5bmFtb0RiQ29uZmlnPzogQ2ZuRGF0YVNvdXJjZS5EeW5hbW9EQkNvbmZpZ1Byb3BlcnR5IHwgSVJlc29sdmFibGU7XG4gIC8qKlxuICAgKiBjb25maWd1cmF0aW9uIGZvciBFbGFzdGljc2VhcmNoIGRhdGEgc291cmNlXG4gICAqXG4gICAqIEBkZXByZWNhdGVkIC0gdXNlIGBvcGVuU2VhcmNoQ29uZmlnYFxuICAgKiBAZGVmYXVsdCAtIE5vIGNvbmZpZ1xuICAgKi9cbiAgcmVhZG9ubHkgZWxhc3RpY3NlYXJjaENvbmZpZz86IENmbkRhdGFTb3VyY2UuRWxhc3RpY3NlYXJjaENvbmZpZ1Byb3BlcnR5IHwgSVJlc29sdmFibGU7XG4gIC8qKlxuICAgKiBjb25maWd1cmF0aW9uIGZvciBPcGVuU2VhcmNoIGRhdGEgc291cmNlXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gTm8gY29uZmlnXG4gICAqL1xuICByZWFkb25seSBvcGVuU2VhcmNoU2VydmljZUNvbmZpZz86IENmbkRhdGFTb3VyY2UuT3BlblNlYXJjaFNlcnZpY2VDb25maWdQcm9wZXJ0eSB8IElSZXNvbHZhYmxlO1xuICAvKipcbiAgICogY29uZmlndXJhdGlvbiBmb3IgSFRUUCBEYXRhc291cmNlXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gTm8gY29uZmlnXG4gICAqL1xuICByZWFkb25seSBodHRwQ29uZmlnPzogQ2ZuRGF0YVNvdXJjZS5IdHRwQ29uZmlnUHJvcGVydHkgfCBJUmVzb2x2YWJsZTtcbiAgLyoqXG4gICAqIGNvbmZpZ3VyYXRpb24gZm9yIExhbWJkYSBEYXRhc291cmNlXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gTm8gY29uZmlnXG4gICAqL1xuICByZWFkb25seSBsYW1iZGFDb25maWc/OiBDZm5EYXRhU291cmNlLkxhbWJkYUNvbmZpZ1Byb3BlcnR5IHwgSVJlc29sdmFibGU7XG4gIC8qKlxuICAgKiBjb25maWd1cmF0aW9uIGZvciBSRFMgRGF0YXNvdXJjZVxuICAgKlxuICAgKiBAZGVmYXVsdCAtIE5vIGNvbmZpZ1xuICAgKi9cbiAgcmVhZG9ubHkgcmVsYXRpb25hbERhdGFiYXNlQ29uZmlnPzogQ2ZuRGF0YVNvdXJjZS5SZWxhdGlvbmFsRGF0YWJhc2VDb25maWdQcm9wZXJ0eSB8IElSZXNvbHZhYmxlO1xufVxuXG4vKipcbiAqIEFic3RyYWN0IEFwcFN5bmMgZGF0YXNvdXJjZSBpbXBsZW1lbnRhdGlvbi4gRG8gbm90IHVzZSBkaXJlY3RseSBidXQgdXNlIHN1YmNsYXNzZXMgZm9yIGNvbmNyZXRlIGRhdGFzb3VyY2VzXG4gKi9cbmV4cG9ydCBhYnN0cmFjdCBjbGFzcyBCYXNlRGF0YVNvdXJjZSBleHRlbmRzIENvcmVDb25zdHJ1Y3Qge1xuICAvKipcbiAgICogdGhlIG5hbWUgb2YgdGhlIGRhdGEgc291cmNlXG4gICAqL1xuICBwdWJsaWMgcmVhZG9ubHkgbmFtZTogc3RyaW5nO1xuICAvKipcbiAgICogdGhlIHVuZGVybHlpbmcgQ0ZOIGRhdGEgc291cmNlIHJlc291cmNlXG4gICAqL1xuICBwdWJsaWMgcmVhZG9ubHkgZHM6IENmbkRhdGFTb3VyY2U7XG5cbiAgcHJvdGVjdGVkIGFwaTogSUdyYXBocWxBcGk7XG4gIHByb3RlY3RlZCBzZXJ2aWNlUm9sZT86IElSb2xlO1xuXG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBCYWNrZWREYXRhU291cmNlUHJvcHMsIGV4dGVuZGVkOiBFeHRlbmRlZERhdGFTb3VyY2VQcm9wcykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCk7XG5cbiAgICBpZiAoZXh0ZW5kZWQudHlwZSAhPT0gJ05PTkUnKSB7XG4gICAgICB0aGlzLnNlcnZpY2VSb2xlID0gcHJvcHMuc2VydmljZVJvbGUgfHwgbmV3IFJvbGUodGhpcywgJ1NlcnZpY2VSb2xlJywgeyBhc3N1bWVkQnk6IG5ldyBTZXJ2aWNlUHJpbmNpcGFsKCdhcHBzeW5jJykgfSk7XG4gICAgfVxuICAgIC8vIFJlcGxhY2UgdW5zdXBwb3J0ZWQgY2hhcmFjdGVycyBmcm9tIERhdGFTb3VyY2UgbmFtZS4gVGhlIG9ubHkgYWxsb3dlZCBwYXR0ZXJuIGlzOiB7W19BLVphLXpdW18wLTlBLVphLXpdKn1cbiAgICBjb25zdCBuYW1lID0gKHByb3BzLm5hbWUgPz8gaWQpLnJlcGxhY2UoL1tcXFddKy9nLCAnJyk7XG4gICAgdGhpcy5kcyA9IG5ldyBDZm5EYXRhU291cmNlKHRoaXMsICdSZXNvdXJjZScsIHtcbiAgICAgIGFwaUlkOiBwcm9wcy5hcGkuYXBpSWQsXG4gICAgICBuYW1lOiBuYW1lLFxuICAgICAgZGVzY3JpcHRpb246IHByb3BzLmRlc2NyaXB0aW9uLFxuICAgICAgc2VydmljZVJvbGVBcm46IHRoaXMuc2VydmljZVJvbGU/LnJvbGVBcm4sXG4gICAgICAuLi5leHRlbmRlZCxcbiAgICB9KTtcbiAgICB0aGlzLm5hbWUgPSBuYW1lO1xuICAgIHRoaXMuYXBpID0gcHJvcHMuYXBpO1xuICB9XG5cbiAgLyoqXG4gICAqIGNyZWF0ZXMgYSBuZXcgcmVzb2x2ZXIgZm9yIHRoaXMgZGF0YXNvdXJjZSBhbmQgQVBJIHVzaW5nIHRoZSBnaXZlbiBwcm9wZXJ0aWVzXG4gICAqL1xuICBwdWJsaWMgY3JlYXRlUmVzb2x2ZXIocHJvcHM6IEJhc2VSZXNvbHZlclByb3BzKTogUmVzb2x2ZXIge1xuICAgIHJldHVybiBuZXcgUmVzb2x2ZXIodGhpcywgYCR7cHJvcHMudHlwZU5hbWV9JHtwcm9wcy5maWVsZE5hbWV9UmVzb2x2ZXJgLCB7XG4gICAgICBhcGk6IHRoaXMuYXBpLFxuICAgICAgZGF0YVNvdXJjZTogdGhpcyxcbiAgICAgIC4uLnByb3BzLFxuICAgIH0pO1xuICB9XG5cbiAgLyoqXG4gICAqIGNyZWF0ZXMgYSBuZXcgYXBwc3luYyBmdW5jdGlvbiBmb3IgdGhpcyBkYXRhc291cmNlIGFuZCBBUEkgdXNpbmcgdGhlIGdpdmVuIHByb3BlcnRpZXNcbiAgICovXG4gIHB1YmxpYyBjcmVhdGVGdW5jdGlvbihwcm9wczogQmFzZUFwcHN5bmNGdW5jdGlvblByb3BzKTogQXBwc3luY0Z1bmN0aW9uIHtcbiAgICByZXR1cm4gbmV3IEFwcHN5bmNGdW5jdGlvbih0aGlzLCBgJHtwcm9wcy5uYW1lfUZ1bmN0aW9uYCwge1xuICAgICAgYXBpOiB0aGlzLmFwaSxcbiAgICAgIGRhdGFTb3VyY2U6IHRoaXMsXG4gICAgICAuLi5wcm9wcyxcbiAgICB9KTtcbiAgfVxufVxuXG4vKipcbiAqIEFic3RyYWN0IEFwcFN5bmMgZGF0YXNvdXJjZSBpbXBsZW1lbnRhdGlvbi4gRG8gbm90IHVzZSBkaXJlY3RseSBidXQgdXNlIHN1YmNsYXNzZXMgZm9yIHJlc291cmNlIGJhY2tlZCBkYXRhc291cmNlc1xuICovXG5leHBvcnQgYWJzdHJhY3QgY2xhc3MgQmFja2VkRGF0YVNvdXJjZSBleHRlbmRzIEJhc2VEYXRhU291cmNlIGltcGxlbWVudHMgSUdyYW50YWJsZSB7XG4gIC8qKlxuICAgKiB0aGUgcHJpbmNpcGFsIG9mIHRoZSBkYXRhIHNvdXJjZSB0byBiZSBJR3JhbnRhYmxlXG4gICAqL1xuICBwdWJsaWMgcmVhZG9ubHkgZ3JhbnRQcmluY2lwYWw6IElQcmluY2lwYWw7XG5cbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IEJhY2tlZERhdGFTb3VyY2VQcm9wcywgZXh0ZW5kZWQ6IEV4dGVuZGVkRGF0YVNvdXJjZVByb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkLCBwcm9wcywgZXh0ZW5kZWQpO1xuXG4gICAgdGhpcy5ncmFudFByaW5jaXBhbCA9IHRoaXMuc2VydmljZVJvbGUhO1xuICB9XG59XG5cbi8qKlxuICogUHJvcGVydGllcyBmb3IgYW4gQXBwU3luYyBkdW1teSBkYXRhc291cmNlXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgTm9uZURhdGFTb3VyY2VQcm9wcyBleHRlbmRzIEJhc2VEYXRhU291cmNlUHJvcHMge1xufVxuXG4vKipcbiAqIEFuIEFwcFN5bmMgZHVtbXkgZGF0YXNvdXJjZVxuICovXG5leHBvcnQgY2xhc3MgTm9uZURhdGFTb3VyY2UgZXh0ZW5kcyBCYXNlRGF0YVNvdXJjZSB7XG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBOb25lRGF0YVNvdXJjZVByb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkLCBwcm9wcywge1xuICAgICAgdHlwZTogJ05PTkUnLFxuICAgIH0pO1xuICB9XG59XG5cbi8qKlxuICogUHJvcGVydGllcyBmb3IgYW4gQXBwU3luYyBEeW5hbW9EQiBkYXRhc291cmNlXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgRHluYW1vRGJEYXRhU291cmNlUHJvcHMgZXh0ZW5kcyBCYWNrZWREYXRhU291cmNlUHJvcHMge1xuICAvKipcbiAgICogVGhlIER5bmFtb0RCIHRhYmxlIGJhY2tpbmcgdGhpcyBkYXRhIHNvdXJjZVxuICAgKi9cbiAgcmVhZG9ubHkgdGFibGU6IElUYWJsZTtcbiAgLyoqXG4gICAqIFNwZWNpZnkgd2hldGhlciB0aGlzIERTIGlzIHJlYWQgb25seSBvciBoYXMgcmVhZCBhbmQgd3JpdGUgcGVybWlzc2lvbnMgdG8gdGhlIER5bmFtb0RCIHRhYmxlXG4gICAqXG4gICAqIEBkZWZhdWx0IGZhbHNlXG4gICAqL1xuICByZWFkb25seSByZWFkT25seUFjY2Vzcz86IGJvb2xlYW47XG4gIC8qKlxuICAgKiB1c2UgY3JlZGVudGlhbHMgb2YgY2FsbGVyIHRvIGFjY2VzcyBEeW5hbW9EQlxuICAgKlxuICAgKiBAZGVmYXVsdCBmYWxzZVxuICAgKi9cbiAgcmVhZG9ubHkgdXNlQ2FsbGVyQ3JlZGVudGlhbHM/OiBib29sZWFuO1xufVxuXG4vKipcbiAqIEFuIEFwcFN5bmMgZGF0YXNvdXJjZSBiYWNrZWQgYnkgYSBEeW5hbW9EQiB0YWJsZVxuICovXG5leHBvcnQgY2xhc3MgRHluYW1vRGJEYXRhU291cmNlIGV4dGVuZHMgQmFja2VkRGF0YVNvdXJjZSB7XG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBEeW5hbW9EYkRhdGFTb3VyY2VQcm9wcykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCwgcHJvcHMsIHtcbiAgICAgIHR5cGU6ICdBTUFaT05fRFlOQU1PREInLFxuICAgICAgZHluYW1vRGJDb25maWc6IHtcbiAgICAgICAgdGFibGVOYW1lOiBwcm9wcy50YWJsZS50YWJsZU5hbWUsXG4gICAgICAgIGF3c1JlZ2lvbjogcHJvcHMudGFibGUuZW52LnJlZ2lvbixcbiAgICAgICAgdXNlQ2FsbGVyQ3JlZGVudGlhbHM6IHByb3BzLnVzZUNhbGxlckNyZWRlbnRpYWxzLFxuICAgICAgfSxcbiAgICB9KTtcbiAgICBpZiAocHJvcHMucmVhZE9ubHlBY2Nlc3MpIHtcbiAgICAgIHByb3BzLnRhYmxlLmdyYW50UmVhZERhdGEodGhpcyk7XG4gICAgfSBlbHNlIHtcbiAgICAgIHByb3BzLnRhYmxlLmdyYW50UmVhZFdyaXRlRGF0YSh0aGlzKTtcbiAgICB9XG4gIH1cbn1cblxuLyoqXG4gKiBUaGUgYXV0aG9yaXphdGlvbiBjb25maWcgaW4gY2FzZSB0aGUgSFRUUCBlbmRwb2ludCByZXF1aXJlcyBhdXRob3JpemF0aW9uXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgQXdzSWFtQ29uZmlnIHtcbiAgLyoqXG4gICAqIFRoZSBzaWduaW5nIHJlZ2lvbiBmb3IgQVdTIElBTSBhdXRob3JpemF0aW9uXG4gICAqL1xuICByZWFkb25seSBzaWduaW5nUmVnaW9uOiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFRoZSBzaWduaW5nIHNlcnZpY2UgbmFtZSBmb3IgQVdTIElBTSBhdXRob3JpemF0aW9uXG4gICAqL1xuICByZWFkb25seSBzaWduaW5nU2VydmljZU5hbWU6IHN0cmluZztcbn1cblxuLyoqXG4gKiBQcm9wZXJ0aWVzIGZvciBhbiBBcHBTeW5jIGh0dHAgZGF0YXNvdXJjZVxuICovXG5leHBvcnQgaW50ZXJmYWNlIEh0dHBEYXRhU291cmNlUHJvcHMgZXh0ZW5kcyBCYXNlRGF0YVNvdXJjZVByb3BzIHtcbiAgLyoqXG4gICAqIFRoZSBodHRwIGVuZHBvaW50XG4gICAqL1xuICByZWFkb25seSBlbmRwb2ludDogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBUaGUgYXV0aG9yaXphdGlvbiBjb25maWcgaW4gY2FzZSB0aGUgSFRUUCBlbmRwb2ludCByZXF1aXJlcyBhdXRob3JpemF0aW9uXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gbm9uZVxuICAgKlxuICAgKi9cbiAgcmVhZG9ubHkgYXV0aG9yaXphdGlvbkNvbmZpZz86IEF3c0lhbUNvbmZpZztcbn1cblxuLyoqXG4gKiBBbiBBcHBTeW5jIGRhdGFzb3VyY2UgYmFja2VkIGJ5IGEgaHR0cCBlbmRwb2ludFxuICovXG5leHBvcnQgY2xhc3MgSHR0cERhdGFTb3VyY2UgZXh0ZW5kcyBCYWNrZWREYXRhU291cmNlIHtcbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IEh0dHBEYXRhU291cmNlUHJvcHMpIHtcbiAgICBjb25zdCBhdXRob3JpemF0aW9uQ29uZmlnID0gcHJvcHMuYXV0aG9yaXphdGlvbkNvbmZpZyA/IHtcbiAgICAgIGF1dGhvcml6YXRpb25UeXBlOiAnQVdTX0lBTScsXG4gICAgICBhd3NJYW1Db25maWc6IHByb3BzLmF1dGhvcml6YXRpb25Db25maWcsXG4gICAgfSA6IHVuZGVmaW5lZDtcbiAgICBzdXBlcihzY29wZSwgaWQsIHByb3BzLCB7XG4gICAgICB0eXBlOiAnSFRUUCcsXG4gICAgICBodHRwQ29uZmlnOiB7XG4gICAgICAgIGVuZHBvaW50OiBwcm9wcy5lbmRwb2ludCxcbiAgICAgICAgYXV0aG9yaXphdGlvbkNvbmZpZyxcbiAgICAgIH0sXG4gICAgfSk7XG4gIH1cbn1cblxuLyoqXG4gKiBQcm9wZXJ0aWVzIGZvciBhbiBBcHBTeW5jIExhbWJkYSBkYXRhc291cmNlXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgTGFtYmRhRGF0YVNvdXJjZVByb3BzIGV4dGVuZHMgQmFja2VkRGF0YVNvdXJjZVByb3BzIHtcbiAgLyoqXG4gICAqIFRoZSBMYW1iZGEgZnVuY3Rpb24gdG8gY2FsbCB0byBpbnRlcmFjdCB3aXRoIHRoaXMgZGF0YSBzb3VyY2VcbiAgICovXG4gIHJlYWRvbmx5IGxhbWJkYUZ1bmN0aW9uOiBJRnVuY3Rpb247XG59XG5cbi8qKlxuICogQW4gQXBwU3luYyBkYXRhc291cmNlIGJhY2tlZCBieSBhIExhbWJkYSBmdW5jdGlvblxuICovXG5leHBvcnQgY2xhc3MgTGFtYmRhRGF0YVNvdXJjZSBleHRlbmRzIEJhY2tlZERhdGFTb3VyY2Uge1xuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogTGFtYmRhRGF0YVNvdXJjZVByb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkLCBwcm9wcywge1xuICAgICAgdHlwZTogJ0FXU19MQU1CREEnLFxuICAgICAgbGFtYmRhQ29uZmlnOiB7XG4gICAgICAgIGxhbWJkYUZ1bmN0aW9uQXJuOiBwcm9wcy5sYW1iZGFGdW5jdGlvbi5mdW5jdGlvbkFybixcbiAgICAgIH0sXG4gICAgfSk7XG4gICAgcHJvcHMubGFtYmRhRnVuY3Rpb24uZ3JhbnRJbnZva2UodGhpcyk7XG4gIH1cbn1cblxuLyoqXG4gKiBQcm9wZXJ0aWVzIGZvciBhbiBBcHBTeW5jIFJEUyBkYXRhc291cmNlXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgUmRzRGF0YVNvdXJjZVByb3BzIGV4dGVuZHMgQmFja2VkRGF0YVNvdXJjZVByb3BzIHtcbiAgLyoqXG4gICAqIFRoZSBzZXJ2ZXJsZXNzIGNsdXN0ZXIgdG8gY2FsbCB0byBpbnRlcmFjdCB3aXRoIHRoaXMgZGF0YSBzb3VyY2VcbiAgICovXG4gIHJlYWRvbmx5IHNlcnZlcmxlc3NDbHVzdGVyOiBJU2VydmVybGVzc0NsdXN0ZXI7XG4gIC8qKlxuICAgKiBUaGUgc2VjcmV0IGNvbnRhaW5pbmcgdGhlIGNyZWRlbnRpYWxzIGZvciB0aGUgZGF0YWJhc2VcbiAgICovXG4gIHJlYWRvbmx5IHNlY3JldFN0b3JlOiBJU2VjcmV0O1xuICAvKipcbiAgICogVGhlIG5hbWUgb2YgdGhlIGRhdGFiYXNlIHRvIHVzZSB3aXRoaW4gdGhlIGNsdXN0ZXJcbiAgICpcbiAgICogQGRlZmF1bHQgLSBOb25lXG4gICAqL1xuICByZWFkb25seSBkYXRhYmFzZU5hbWU/OiBzdHJpbmc7XG59XG5cbi8qKlxuICogQW4gQXBwU3luYyBkYXRhc291cmNlIGJhY2tlZCBieSBSRFNcbiAqL1xuZXhwb3J0IGNsYXNzIFJkc0RhdGFTb3VyY2UgZXh0ZW5kcyBCYWNrZWREYXRhU291cmNlIHtcbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IFJkc0RhdGFTb3VyY2VQcm9wcykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCwgcHJvcHMsIHtcbiAgICAgIHR5cGU6ICdSRUxBVElPTkFMX0RBVEFCQVNFJyxcbiAgICAgIHJlbGF0aW9uYWxEYXRhYmFzZUNvbmZpZzoge1xuICAgICAgICByZHNIdHRwRW5kcG9pbnRDb25maWc6IHtcbiAgICAgICAgICBhd3NSZWdpb246IHByb3BzLnNlcnZlcmxlc3NDbHVzdGVyLmVudi5yZWdpb24sXG4gICAgICAgICAgZGJDbHVzdGVySWRlbnRpZmllcjogTGF6eS5zdHJpbmcoe1xuICAgICAgICAgICAgcHJvZHVjZTogKCkgPT4ge1xuICAgICAgICAgICAgICByZXR1cm4gU3RhY2sub2YodGhpcykuZm9ybWF0QXJuKHtcbiAgICAgICAgICAgICAgICBzZXJ2aWNlOiAncmRzJyxcbiAgICAgICAgICAgICAgICByZXNvdXJjZTogYGNsdXN0ZXI6JHtwcm9wcy5zZXJ2ZXJsZXNzQ2x1c3Rlci5jbHVzdGVySWRlbnRpZmllcn1gLFxuICAgICAgICAgICAgICB9KTtcbiAgICAgICAgICAgIH0sXG4gICAgICAgICAgfSksXG4gICAgICAgICAgYXdzU2VjcmV0U3RvcmVBcm46IHByb3BzLnNlY3JldFN0b3JlLnNlY3JldEFybixcbiAgICAgICAgICBkYXRhYmFzZU5hbWU6IHByb3BzLmRhdGFiYXNlTmFtZSxcbiAgICAgICAgfSxcbiAgICAgICAgcmVsYXRpb25hbERhdGFiYXNlU291cmNlVHlwZTogJ1JEU19IVFRQX0VORFBPSU5UJyxcbiAgICAgIH0sXG4gICAgfSk7XG4gICAgY29uc3QgY2x1c3RlckFybiA9IFN0YWNrLm9mKHRoaXMpLmZvcm1hdEFybih7XG4gICAgICBzZXJ2aWNlOiAncmRzJyxcbiAgICAgIHJlc291cmNlOiBgY2x1c3Rlcjoke3Byb3BzLnNlcnZlcmxlc3NDbHVzdGVyLmNsdXN0ZXJJZGVudGlmaWVyfWAsXG4gICAgfSk7XG4gICAgcHJvcHMuc2VjcmV0U3RvcmUuZ3JhbnRSZWFkKHRoaXMpO1xuXG4gICAgLy8gQ2hhbmdlIHRvIGdyYW50IHdpdGggUkRTIGdyYW50IGJlY29tZXMgaW1wbGVtZW50ZWRcblxuICAgIHByb3BzLnNlcnZlcmxlc3NDbHVzdGVyLmdyYW50RGF0YUFwaUFjY2Vzcyh0aGlzKTtcblxuICAgIEdyYW50LmFkZFRvUHJpbmNpcGFsKHtcbiAgICAgIGdyYW50ZWU6IHRoaXMsXG4gICAgICBhY3Rpb25zOiBbXG4gICAgICAgICdyZHMtZGF0YTpEZWxldGVJdGVtcycsXG4gICAgICAgICdyZHMtZGF0YTpFeGVjdXRlU3FsJyxcbiAgICAgICAgJ3Jkcy1kYXRhOkdldEl0ZW1zJyxcbiAgICAgICAgJ3Jkcy1kYXRhOkluc2VydEl0ZW1zJyxcbiAgICAgICAgJ3Jkcy1kYXRhOlVwZGF0ZUl0ZW1zJyxcbiAgICAgIF0sXG4gICAgICByZXNvdXJjZUFybnM6IFtjbHVzdGVyQXJuLCBgJHtjbHVzdGVyQXJufToqYF0sXG4gICAgICBzY29wZTogdGhpcyxcbiAgICB9KTtcbiAgfVxufVxuXG4vKipcbiAqIFByb3BlcnRpZXMgZm9yIHRoZSBFbGFzdGljc2VhcmNoIERhdGEgU291cmNlXG4gKlxuICogQGRlcHJlY2F0ZWQgLSB1c2UgYE9wZW5TZWFyY2hEYXRhU291cmNlUHJvcHNgIHdpdGggYE9wZW5TZWFyY2hEYXRhU291cmNlYFxuICovXG5leHBvcnQgaW50ZXJmYWNlIEVsYXN0aWNzZWFyY2hEYXRhU291cmNlUHJvcHMgZXh0ZW5kcyBCYWNrZWREYXRhU291cmNlUHJvcHMge1xuICAvKipcbiAgICogVGhlIGVsYXN0aWNzZWFyY2ggZG9tYWluIGNvbnRhaW5pbmcgdGhlIGVuZHBvaW50IGZvciB0aGUgZGF0YSBzb3VyY2VcbiAgICovXG4gIHJlYWRvbmx5IGRvbWFpbjogSUVsYXN0aWNzZWFyY2hEb21haW47XG59XG5cbi8qKlxuICogQW4gQXBwc3luYyBkYXRhc291cmNlIGJhY2tlZCBieSBFbGFzdGljc2VhcmNoXG4gKlxuICogQGRlcHJlY2F0ZWQgLSB1c2UgYE9wZW5TZWFyY2hEYXRhU291cmNlYFxuICovXG5leHBvcnQgY2xhc3MgRWxhc3RpY3NlYXJjaERhdGFTb3VyY2UgZXh0ZW5kcyBCYWNrZWREYXRhU291cmNlIHtcbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IEVsYXN0aWNzZWFyY2hEYXRhU291cmNlUHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQsIHByb3BzLCB7XG4gICAgICB0eXBlOiAnQU1BWk9OX0VMQVNUSUNTRUFSQ0gnLFxuICAgICAgZWxhc3RpY3NlYXJjaENvbmZpZzoge1xuICAgICAgICBhd3NSZWdpb246IHByb3BzLmRvbWFpbi5lbnYucmVnaW9uLFxuICAgICAgICBlbmRwb2ludDogYGh0dHBzOi8vJHtwcm9wcy5kb21haW4uZG9tYWluRW5kcG9pbnR9YCxcbiAgICAgIH0sXG4gICAgfSk7XG5cbiAgICBwcm9wcy5kb21haW4uZ3JhbnRSZWFkV3JpdGUodGhpcyk7XG4gIH1cbn1cblxuLyoqXG4gKiBQcm9wZXJ0aWVzIGZvciB0aGUgT3BlblNlYXJjaCBEYXRhIFNvdXJjZVxuICovXG5leHBvcnQgaW50ZXJmYWNlIE9wZW5TZWFyY2hEYXRhU291cmNlUHJvcHMgZXh0ZW5kcyBCYWNrZWREYXRhU291cmNlUHJvcHMge1xuICAvKipcbiAgICogVGhlIE9wZW5TZWFyY2ggZG9tYWluIGNvbnRhaW5pbmcgdGhlIGVuZHBvaW50IGZvciB0aGUgZGF0YSBzb3VyY2VcbiAgICovXG4gIHJlYWRvbmx5IGRvbWFpbjogSU9wZW5TZWFyY2hEb21haW47XG59XG5cbi8qKlxuICogQW4gQXBwc3luYyBkYXRhc291cmNlIGJhY2tlZCBieSBPcGVuU2VhcmNoXG4gKi9cbmV4cG9ydCBjbGFzcyBPcGVuU2VhcmNoRGF0YVNvdXJjZSBleHRlbmRzIEJhY2tlZERhdGFTb3VyY2Uge1xuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogT3BlblNlYXJjaERhdGFTb3VyY2VQcm9wcykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCwgcHJvcHMsIHtcbiAgICAgIHR5cGU6ICdBTUFaT05fT1BFTlNFQVJDSF9TRVJWSUNFJyxcbiAgICAgIG9wZW5TZWFyY2hTZXJ2aWNlQ29uZmlnOiB7XG4gICAgICAgIGF3c1JlZ2lvbjogcHJvcHMuZG9tYWluLmVudi5yZWdpb24sXG4gICAgICAgIGVuZHBvaW50OiBgaHR0cHM6Ly8ke3Byb3BzLmRvbWFpbi5kb21haW5FbmRwb2ludH1gLFxuICAgICAgfSxcbiAgICB9KTtcblxuICAgIHByb3BzLmRvbWFpbi5ncmFudFJlYWRXcml0ZSh0aGlzKTtcbiAgfVxufVxuIl19