"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FunctionHook = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const sns = require("../../aws-sns");
const subs = require("../../aws-sns-subscriptions");
const common_1 = require("./common");
const topic_hook_1 = require("./topic-hook");
/**
 * Use a Lambda Function as a hook target
 *
 * Internally creates a Topic to make the connection.
 */
class FunctionHook {
    /**
     * @param fn Function to invoke in response to a lifecycle event
     * @param encryptionKey If provided, this key is used to encrypt the contents of the SNS topic.
     */
    constructor(fn, encryptionKey) {
        this.fn = fn;
        this.encryptionKey = encryptionKey;
        try {
            jsiiDeprecationWarnings.monocdk_aws_lambda_IFunction(fn);
            jsiiDeprecationWarnings.monocdk_aws_kms_IKey(encryptionKey);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, FunctionHook);
            }
            throw error;
        }
    }
    /**
     * If the `IRole` does not exist in `options`, will create an `IRole` and an SNS Topic and attach both to the lifecycle hook.
     * If the `IRole` does exist in `options`, will only create an SNS Topic and attach it to the lifecycle hook.
     */
    bind(_scope, options) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_autoscaling_BindHookTargetOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        const topic = new sns.Topic(_scope, 'Topic', {
            masterKey: this.encryptionKey,
        });
        const role = common_1.createRole(_scope, options.role);
        // Per: https://docs.aws.amazon.com/sns/latest/dg/sns-key-management.html#sns-what-permissions-for-sse
        // Topic's grantPublish() is in a base class that does not know there is a kms key, and so does not
        // grant appropriate permissions to the kms key. We do that here to ensure the correct permissions
        // are in place.
        this.encryptionKey?.grant(role, 'kms:Decrypt', 'kms:GenerateDataKey');
        topic.addSubscription(new subs.LambdaSubscription(this.fn));
        return new topic_hook_1.TopicHook(topic).bind(_scope, { lifecycleHook: options.lifecycleHook, role });
    }
}
exports.FunctionHook = FunctionHook;
_a = JSII_RTTI_SYMBOL_1;
FunctionHook[_a] = { fqn: "monocdk.aws_autoscaling_hooktargets.FunctionHook", version: "1.191.0" };
//# sourceMappingURL=data:application/json;base64,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