"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.QueueHook = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const common_1 = require("./common");
/**
 * Use an SQS queue as a hook target
 */
class QueueHook {
    constructor(queue) {
        this.queue = queue;
        try {
            jsiiDeprecationWarnings.monocdk_aws_sqs_IQueue(queue);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, QueueHook);
            }
            throw error;
        }
    }
    /**
     * If an `IRole` is found in `options`, grant it access to send messages.
     * Otherwise, create a new `IRole` and grant it access to send messages.
     *
     * @returns the `IRole` with access to send messages and the ARN of the queue it has access to send messages to.
     */
    bind(_scope, options) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_autoscaling_BindHookTargetOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        const role = common_1.createRole(_scope, options.role);
        this.queue.grantSendMessages(role);
        return {
            notificationTargetArn: this.queue.queueArn,
            createdRole: role,
        };
    }
}
exports.QueueHook = QueueHook;
_a = JSII_RTTI_SYMBOL_1;
QueueHook[_a] = { fqn: "monocdk.aws_autoscaling_hooktargets.QueueHook", version: "1.191.0" };
//# sourceMappingURL=data:application/json;base64,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