"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AutoScalingGroupRequireImdsv2Aspect = void 0;
const jsiiDeprecationWarnings = require("../../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("../../../core");
const auto_scaling_group_1 = require("../auto-scaling-group");
/**
 * Aspect that makes IMDSv2 required on instances deployed by AutoScalingGroups.
 */
class AutoScalingGroupRequireImdsv2Aspect {
    constructor() {
    }
    visit(node) {
        try {
            jsiiDeprecationWarnings.monocdk_IConstruct(node);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.visit);
            }
            throw error;
        }
        if (!(node instanceof auto_scaling_group_1.AutoScalingGroup)) {
            return;
        }
        const launchConfig = node.node.tryFindChild('LaunchConfig');
        if (cdk.isResolvableObject(launchConfig.metadataOptions)) {
            this.warn(node, 'CfnLaunchConfiguration.MetadataOptions field is a CDK token.');
            return;
        }
        launchConfig.metadataOptions = {
            ...launchConfig.metadataOptions,
            httpTokens: 'required',
        };
    }
    /**
     * Adds a warning annotation to a node.
     *
     * @param node The scope to add the warning to.
     * @param message The warning message.
     */
    warn(node, message) {
        try {
            jsiiDeprecationWarnings.monocdk_IConstruct(node);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.warn);
            }
            throw error;
        }
        cdk.Annotations.of(node).addWarning(`${AutoScalingGroupRequireImdsv2Aspect.name} failed on node ${node.node.id}: ${message}`);
    }
}
exports.AutoScalingGroupRequireImdsv2Aspect = AutoScalingGroupRequireImdsv2Aspect;
_a = JSII_RTTI_SYMBOL_1;
AutoScalingGroupRequireImdsv2Aspect[_a] = { fqn: "monocdk.aws_autoscaling.AutoScalingGroupRequireImdsv2Aspect", version: "1.191.0" };
//# sourceMappingURL=data:application/json;base64,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