"use strict";
var _a, _b, _c, _d, _e, _f;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnWarmPool = exports.CfnScheduledAction = exports.CfnScalingPolicy = exports.CfnLifecycleHook = exports.CfnLaunchConfiguration = exports.CfnAutoScalingGroup = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright 2012-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
// Generated from the AWS CloudFormation Resource Specification
// See: docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-resource-specification.html
// @cfn2ts:meta@ {"generated":"2023-01-31T17:52:07.096Z","fingerprint":"s8LRcUebSNMek5yn20wtbwYM540Jj+KNE3BEsyB0sJM="}
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
const cdk = require("../../core");
const cfn_parse = require("../../core/lib/helpers-internal");
/**
 * Determine whether the given properties match those of a `CfnAutoScalingGroupProps`
 *
 * @param properties - the TypeScript properties of a `CfnAutoScalingGroupProps`
 *
 * @returns the result of the validation.
 */
function CfnAutoScalingGroupPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('autoScalingGroupName', cdk.validateString)(properties.autoScalingGroupName));
    errors.collect(cdk.propertyValidator('availabilityZones', cdk.listValidator(cdk.validateString))(properties.availabilityZones));
    errors.collect(cdk.propertyValidator('capacityRebalance', cdk.validateBoolean)(properties.capacityRebalance));
    errors.collect(cdk.propertyValidator('context', cdk.validateString)(properties.context));
    errors.collect(cdk.propertyValidator('cooldown', cdk.validateString)(properties.cooldown));
    errors.collect(cdk.propertyValidator('defaultInstanceWarmup', cdk.validateNumber)(properties.defaultInstanceWarmup));
    errors.collect(cdk.propertyValidator('desiredCapacity', cdk.validateString)(properties.desiredCapacity));
    errors.collect(cdk.propertyValidator('desiredCapacityType', cdk.validateString)(properties.desiredCapacityType));
    errors.collect(cdk.propertyValidator('healthCheckGracePeriod', cdk.validateNumber)(properties.healthCheckGracePeriod));
    errors.collect(cdk.propertyValidator('healthCheckType', cdk.validateString)(properties.healthCheckType));
    errors.collect(cdk.propertyValidator('instanceId', cdk.validateString)(properties.instanceId));
    errors.collect(cdk.propertyValidator('launchConfigurationName', cdk.validateString)(properties.launchConfigurationName));
    errors.collect(cdk.propertyValidator('launchTemplate', CfnAutoScalingGroup_LaunchTemplateSpecificationPropertyValidator)(properties.launchTemplate));
    errors.collect(cdk.propertyValidator('lifecycleHookSpecificationList', cdk.listValidator(CfnAutoScalingGroup_LifecycleHookSpecificationPropertyValidator))(properties.lifecycleHookSpecificationList));
    errors.collect(cdk.propertyValidator('loadBalancerNames', cdk.listValidator(cdk.validateString))(properties.loadBalancerNames));
    errors.collect(cdk.propertyValidator('maxInstanceLifetime', cdk.validateNumber)(properties.maxInstanceLifetime));
    errors.collect(cdk.propertyValidator('maxSize', cdk.requiredValidator)(properties.maxSize));
    errors.collect(cdk.propertyValidator('maxSize', cdk.validateString)(properties.maxSize));
    errors.collect(cdk.propertyValidator('metricsCollection', cdk.listValidator(CfnAutoScalingGroup_MetricsCollectionPropertyValidator))(properties.metricsCollection));
    errors.collect(cdk.propertyValidator('minSize', cdk.requiredValidator)(properties.minSize));
    errors.collect(cdk.propertyValidator('minSize', cdk.validateString)(properties.minSize));
    errors.collect(cdk.propertyValidator('mixedInstancesPolicy', CfnAutoScalingGroup_MixedInstancesPolicyPropertyValidator)(properties.mixedInstancesPolicy));
    errors.collect(cdk.propertyValidator('newInstancesProtectedFromScaleIn', cdk.validateBoolean)(properties.newInstancesProtectedFromScaleIn));
    errors.collect(cdk.propertyValidator('notificationConfigurations', cdk.listValidator(CfnAutoScalingGroup_NotificationConfigurationPropertyValidator))(properties.notificationConfigurations));
    errors.collect(cdk.propertyValidator('placementGroup', cdk.validateString)(properties.placementGroup));
    errors.collect(cdk.propertyValidator('serviceLinkedRoleArn', cdk.validateString)(properties.serviceLinkedRoleArn));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(CfnAutoScalingGroup_TagPropertyPropertyValidator))(properties.tags));
    errors.collect(cdk.propertyValidator('targetGroupArns', cdk.listValidator(cdk.validateString))(properties.targetGroupArns));
    errors.collect(cdk.propertyValidator('terminationPolicies', cdk.listValidator(cdk.validateString))(properties.terminationPolicies));
    errors.collect(cdk.propertyValidator('vpcZoneIdentifier', cdk.listValidator(cdk.validateString))(properties.vpcZoneIdentifier));
    return errors.wrap('supplied properties not correct for "CfnAutoScalingGroupProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::AutoScalingGroup` resource
 *
 * @param properties - the TypeScript properties of a `CfnAutoScalingGroupProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::AutoScalingGroup` resource.
 */
// @ts-ignore TS6133
function cfnAutoScalingGroupPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAutoScalingGroupPropsValidator(properties).assertSuccess();
    return {
        MaxSize: cdk.stringToCloudFormation(properties.maxSize),
        MinSize: cdk.stringToCloudFormation(properties.minSize),
        AutoScalingGroupName: cdk.stringToCloudFormation(properties.autoScalingGroupName),
        AvailabilityZones: cdk.listMapper(cdk.stringToCloudFormation)(properties.availabilityZones),
        CapacityRebalance: cdk.booleanToCloudFormation(properties.capacityRebalance),
        Context: cdk.stringToCloudFormation(properties.context),
        Cooldown: cdk.stringToCloudFormation(properties.cooldown),
        DefaultInstanceWarmup: cdk.numberToCloudFormation(properties.defaultInstanceWarmup),
        DesiredCapacity: cdk.stringToCloudFormation(properties.desiredCapacity),
        DesiredCapacityType: cdk.stringToCloudFormation(properties.desiredCapacityType),
        HealthCheckGracePeriod: cdk.numberToCloudFormation(properties.healthCheckGracePeriod),
        HealthCheckType: cdk.stringToCloudFormation(properties.healthCheckType),
        InstanceId: cdk.stringToCloudFormation(properties.instanceId),
        LaunchConfigurationName: cdk.stringToCloudFormation(properties.launchConfigurationName),
        LaunchTemplate: cfnAutoScalingGroupLaunchTemplateSpecificationPropertyToCloudFormation(properties.launchTemplate),
        LifecycleHookSpecificationList: cdk.listMapper(cfnAutoScalingGroupLifecycleHookSpecificationPropertyToCloudFormation)(properties.lifecycleHookSpecificationList),
        LoadBalancerNames: cdk.listMapper(cdk.stringToCloudFormation)(properties.loadBalancerNames),
        MaxInstanceLifetime: cdk.numberToCloudFormation(properties.maxInstanceLifetime),
        MetricsCollection: cdk.listMapper(cfnAutoScalingGroupMetricsCollectionPropertyToCloudFormation)(properties.metricsCollection),
        MixedInstancesPolicy: cfnAutoScalingGroupMixedInstancesPolicyPropertyToCloudFormation(properties.mixedInstancesPolicy),
        NewInstancesProtectedFromScaleIn: cdk.booleanToCloudFormation(properties.newInstancesProtectedFromScaleIn),
        NotificationConfigurations: cdk.listMapper(cfnAutoScalingGroupNotificationConfigurationPropertyToCloudFormation)(properties.notificationConfigurations),
        PlacementGroup: cdk.stringToCloudFormation(properties.placementGroup),
        ServiceLinkedRoleARN: cdk.stringToCloudFormation(properties.serviceLinkedRoleArn),
        Tags: cdk.listMapper(cfnAutoScalingGroupTagPropertyPropertyToCloudFormation)(properties.tags),
        TargetGroupARNs: cdk.listMapper(cdk.stringToCloudFormation)(properties.targetGroupArns),
        TerminationPolicies: cdk.listMapper(cdk.stringToCloudFormation)(properties.terminationPolicies),
        VPCZoneIdentifier: cdk.listMapper(cdk.stringToCloudFormation)(properties.vpcZoneIdentifier),
    };
}
// @ts-ignore TS6133
function CfnAutoScalingGroupPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('maxSize', 'MaxSize', cfn_parse.FromCloudFormation.getString(properties.MaxSize));
    ret.addPropertyResult('minSize', 'MinSize', cfn_parse.FromCloudFormation.getString(properties.MinSize));
    ret.addPropertyResult('autoScalingGroupName', 'AutoScalingGroupName', properties.AutoScalingGroupName != null ? cfn_parse.FromCloudFormation.getString(properties.AutoScalingGroupName) : undefined);
    ret.addPropertyResult('availabilityZones', 'AvailabilityZones', properties.AvailabilityZones != null ? cfn_parse.FromCloudFormation.getStringArray(properties.AvailabilityZones) : undefined);
    ret.addPropertyResult('capacityRebalance', 'CapacityRebalance', properties.CapacityRebalance != null ? cfn_parse.FromCloudFormation.getBoolean(properties.CapacityRebalance) : undefined);
    ret.addPropertyResult('context', 'Context', properties.Context != null ? cfn_parse.FromCloudFormation.getString(properties.Context) : undefined);
    ret.addPropertyResult('cooldown', 'Cooldown', properties.Cooldown != null ? cfn_parse.FromCloudFormation.getString(properties.Cooldown) : undefined);
    ret.addPropertyResult('defaultInstanceWarmup', 'DefaultInstanceWarmup', properties.DefaultInstanceWarmup != null ? cfn_parse.FromCloudFormation.getNumber(properties.DefaultInstanceWarmup) : undefined);
    ret.addPropertyResult('desiredCapacity', 'DesiredCapacity', properties.DesiredCapacity != null ? cfn_parse.FromCloudFormation.getString(properties.DesiredCapacity) : undefined);
    ret.addPropertyResult('desiredCapacityType', 'DesiredCapacityType', properties.DesiredCapacityType != null ? cfn_parse.FromCloudFormation.getString(properties.DesiredCapacityType) : undefined);
    ret.addPropertyResult('healthCheckGracePeriod', 'HealthCheckGracePeriod', properties.HealthCheckGracePeriod != null ? cfn_parse.FromCloudFormation.getNumber(properties.HealthCheckGracePeriod) : undefined);
    ret.addPropertyResult('healthCheckType', 'HealthCheckType', properties.HealthCheckType != null ? cfn_parse.FromCloudFormation.getString(properties.HealthCheckType) : undefined);
    ret.addPropertyResult('instanceId', 'InstanceId', properties.InstanceId != null ? cfn_parse.FromCloudFormation.getString(properties.InstanceId) : undefined);
    ret.addPropertyResult('launchConfigurationName', 'LaunchConfigurationName', properties.LaunchConfigurationName != null ? cfn_parse.FromCloudFormation.getString(properties.LaunchConfigurationName) : undefined);
    ret.addPropertyResult('launchTemplate', 'LaunchTemplate', properties.LaunchTemplate != null ? CfnAutoScalingGroupLaunchTemplateSpecificationPropertyFromCloudFormation(properties.LaunchTemplate) : undefined);
    ret.addPropertyResult('lifecycleHookSpecificationList', 'LifecycleHookSpecificationList', properties.LifecycleHookSpecificationList != null ? cfn_parse.FromCloudFormation.getArray(CfnAutoScalingGroupLifecycleHookSpecificationPropertyFromCloudFormation)(properties.LifecycleHookSpecificationList) : undefined);
    ret.addPropertyResult('loadBalancerNames', 'LoadBalancerNames', properties.LoadBalancerNames != null ? cfn_parse.FromCloudFormation.getStringArray(properties.LoadBalancerNames) : undefined);
    ret.addPropertyResult('maxInstanceLifetime', 'MaxInstanceLifetime', properties.MaxInstanceLifetime != null ? cfn_parse.FromCloudFormation.getNumber(properties.MaxInstanceLifetime) : undefined);
    ret.addPropertyResult('metricsCollection', 'MetricsCollection', properties.MetricsCollection != null ? cfn_parse.FromCloudFormation.getArray(CfnAutoScalingGroupMetricsCollectionPropertyFromCloudFormation)(properties.MetricsCollection) : undefined);
    ret.addPropertyResult('mixedInstancesPolicy', 'MixedInstancesPolicy', properties.MixedInstancesPolicy != null ? CfnAutoScalingGroupMixedInstancesPolicyPropertyFromCloudFormation(properties.MixedInstancesPolicy) : undefined);
    ret.addPropertyResult('newInstancesProtectedFromScaleIn', 'NewInstancesProtectedFromScaleIn', properties.NewInstancesProtectedFromScaleIn != null ? cfn_parse.FromCloudFormation.getBoolean(properties.NewInstancesProtectedFromScaleIn) : undefined);
    ret.addPropertyResult('notificationConfigurations', 'NotificationConfigurations', properties.NotificationConfigurations != null ? cfn_parse.FromCloudFormation.getArray(CfnAutoScalingGroupNotificationConfigurationPropertyFromCloudFormation)(properties.NotificationConfigurations) : undefined);
    ret.addPropertyResult('placementGroup', 'PlacementGroup', properties.PlacementGroup != null ? cfn_parse.FromCloudFormation.getString(properties.PlacementGroup) : undefined);
    ret.addPropertyResult('serviceLinkedRoleArn', 'ServiceLinkedRoleARN', properties.ServiceLinkedRoleARN != null ? cfn_parse.FromCloudFormation.getString(properties.ServiceLinkedRoleARN) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(CfnAutoScalingGroupTagPropertyPropertyFromCloudFormation)(properties.Tags) : undefined);
    ret.addPropertyResult('targetGroupArns', 'TargetGroupARNs', properties.TargetGroupARNs != null ? cfn_parse.FromCloudFormation.getStringArray(properties.TargetGroupARNs) : undefined);
    ret.addPropertyResult('terminationPolicies', 'TerminationPolicies', properties.TerminationPolicies != null ? cfn_parse.FromCloudFormation.getStringArray(properties.TerminationPolicies) : undefined);
    ret.addPropertyResult('vpcZoneIdentifier', 'VPCZoneIdentifier', properties.VPCZoneIdentifier != null ? cfn_parse.FromCloudFormation.getStringArray(properties.VPCZoneIdentifier) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::AutoScaling::AutoScalingGroup`
 *
 * The `AWS::AutoScaling::AutoScalingGroup` resource defines an Amazon EC2 Auto Scaling group, which is a collection of Amazon EC2 instances that are treated as a logical grouping for the purposes of automatic scaling and management.
 *
 * For more information about Amazon EC2 Auto Scaling, see the [Amazon EC2 Auto Scaling User Guide](https://docs.aws.amazon.com/autoscaling/ec2/userguide/what-is-amazon-ec2-auto-scaling.html) .
 *
 * > Amazon EC2 Auto Scaling configures instances launched as part of an Auto Scaling group using either a [launch template](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html) or a launch configuration. We strongly recommend that you do not use launch configurations. They do not provide full functionality for Amazon EC2 Auto Scaling or Amazon EC2. For more information, see [Launch configurations](https://docs.aws.amazon.com/autoscaling/ec2/userguide/launch-configurations.html) in the *Amazon EC2 Auto Scaling User Guide* .
 *
 * @cloudformationResource AWS::AutoScaling::AutoScalingGroup
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html
 */
class CfnAutoScalingGroup extends cdk.CfnResource {
    /**
     * Create a new `AWS::AutoScaling::AutoScalingGroup`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnAutoScalingGroup.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.monocdk_Construct(scope);
            jsiiDeprecationWarnings.monocdk_aws_autoscaling_CfnAutoScalingGroupProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnAutoScalingGroup);
            }
            throw error;
        }
        cdk.requireProperty(props, 'maxSize', this);
        cdk.requireProperty(props, 'minSize', this);
        this.maxSize = props.maxSize;
        this.minSize = props.minSize;
        this.autoScalingGroupName = props.autoScalingGroupName;
        this.availabilityZones = props.availabilityZones;
        this.capacityRebalance = props.capacityRebalance;
        this.context = props.context;
        this.cooldown = props.cooldown;
        this.defaultInstanceWarmup = props.defaultInstanceWarmup;
        this.desiredCapacity = props.desiredCapacity;
        this.desiredCapacityType = props.desiredCapacityType;
        this.healthCheckGracePeriod = props.healthCheckGracePeriod;
        this.healthCheckType = props.healthCheckType;
        this.instanceId = props.instanceId;
        this.launchConfigurationName = props.launchConfigurationName;
        this.launchTemplate = props.launchTemplate;
        this.lifecycleHookSpecificationList = props.lifecycleHookSpecificationList;
        this.loadBalancerNames = props.loadBalancerNames;
        this.maxInstanceLifetime = props.maxInstanceLifetime;
        this.metricsCollection = props.metricsCollection;
        this.mixedInstancesPolicy = props.mixedInstancesPolicy;
        this.newInstancesProtectedFromScaleIn = props.newInstancesProtectedFromScaleIn;
        this.notificationConfigurations = props.notificationConfigurations;
        this.placementGroup = props.placementGroup;
        this.serviceLinkedRoleArn = props.serviceLinkedRoleArn;
        this.tags = new cdk.TagManager(cdk.TagType.AUTOSCALING_GROUP, "AWS::AutoScaling::AutoScalingGroup", props.tags, { tagPropertyName: 'tags' });
        this.targetGroupArns = props.targetGroupArns;
        this.terminationPolicies = props.terminationPolicies;
        this.vpcZoneIdentifier = props.vpcZoneIdentifier;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnAutoScalingGroupPropsFromCloudFormation(resourceProperties);
        const ret = new CfnAutoScalingGroup(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.monocdk_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnAutoScalingGroup.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            maxSize: this.maxSize,
            minSize: this.minSize,
            autoScalingGroupName: this.autoScalingGroupName,
            availabilityZones: this.availabilityZones,
            capacityRebalance: this.capacityRebalance,
            context: this.context,
            cooldown: this.cooldown,
            defaultInstanceWarmup: this.defaultInstanceWarmup,
            desiredCapacity: this.desiredCapacity,
            desiredCapacityType: this.desiredCapacityType,
            healthCheckGracePeriod: this.healthCheckGracePeriod,
            healthCheckType: this.healthCheckType,
            instanceId: this.instanceId,
            launchConfigurationName: this.launchConfigurationName,
            launchTemplate: this.launchTemplate,
            lifecycleHookSpecificationList: this.lifecycleHookSpecificationList,
            loadBalancerNames: this.loadBalancerNames,
            maxInstanceLifetime: this.maxInstanceLifetime,
            metricsCollection: this.metricsCollection,
            mixedInstancesPolicy: this.mixedInstancesPolicy,
            newInstancesProtectedFromScaleIn: this.newInstancesProtectedFromScaleIn,
            notificationConfigurations: this.notificationConfigurations,
            placementGroup: this.placementGroup,
            serviceLinkedRoleArn: this.serviceLinkedRoleArn,
            tags: this.tags.renderTags(),
            targetGroupArns: this.targetGroupArns,
            terminationPolicies: this.terminationPolicies,
            vpcZoneIdentifier: this.vpcZoneIdentifier,
        };
    }
    renderProperties(props) {
        return cfnAutoScalingGroupPropsToCloudFormation(props);
    }
}
exports.CfnAutoScalingGroup = CfnAutoScalingGroup;
_a = JSII_RTTI_SYMBOL_1;
CfnAutoScalingGroup[_a] = { fqn: "monocdk.aws_autoscaling.CfnAutoScalingGroup", version: "1.191.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnAutoScalingGroup.CFN_RESOURCE_TYPE_NAME = "AWS::AutoScaling::AutoScalingGroup";
/**
 * Determine whether the given properties match those of a `AcceleratorCountRequestProperty`
 *
 * @param properties - the TypeScript properties of a `AcceleratorCountRequestProperty`
 *
 * @returns the result of the validation.
 */
function CfnAutoScalingGroup_AcceleratorCountRequestPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('max', cdk.validateNumber)(properties.max));
    errors.collect(cdk.propertyValidator('min', cdk.validateNumber)(properties.min));
    return errors.wrap('supplied properties not correct for "AcceleratorCountRequestProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::AutoScalingGroup.AcceleratorCountRequest` resource
 *
 * @param properties - the TypeScript properties of a `AcceleratorCountRequestProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::AutoScalingGroup.AcceleratorCountRequest` resource.
 */
// @ts-ignore TS6133
function cfnAutoScalingGroupAcceleratorCountRequestPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAutoScalingGroup_AcceleratorCountRequestPropertyValidator(properties).assertSuccess();
    return {
        Max: cdk.numberToCloudFormation(properties.max),
        Min: cdk.numberToCloudFormation(properties.min),
    };
}
// @ts-ignore TS6133
function CfnAutoScalingGroupAcceleratorCountRequestPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('max', 'Max', properties.Max != null ? cfn_parse.FromCloudFormation.getNumber(properties.Max) : undefined);
    ret.addPropertyResult('min', 'Min', properties.Min != null ? cfn_parse.FromCloudFormation.getNumber(properties.Min) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `AcceleratorTotalMemoryMiBRequestProperty`
 *
 * @param properties - the TypeScript properties of a `AcceleratorTotalMemoryMiBRequestProperty`
 *
 * @returns the result of the validation.
 */
function CfnAutoScalingGroup_AcceleratorTotalMemoryMiBRequestPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('max', cdk.validateNumber)(properties.max));
    errors.collect(cdk.propertyValidator('min', cdk.validateNumber)(properties.min));
    return errors.wrap('supplied properties not correct for "AcceleratorTotalMemoryMiBRequestProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::AutoScalingGroup.AcceleratorTotalMemoryMiBRequest` resource
 *
 * @param properties - the TypeScript properties of a `AcceleratorTotalMemoryMiBRequestProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::AutoScalingGroup.AcceleratorTotalMemoryMiBRequest` resource.
 */
// @ts-ignore TS6133
function cfnAutoScalingGroupAcceleratorTotalMemoryMiBRequestPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAutoScalingGroup_AcceleratorTotalMemoryMiBRequestPropertyValidator(properties).assertSuccess();
    return {
        Max: cdk.numberToCloudFormation(properties.max),
        Min: cdk.numberToCloudFormation(properties.min),
    };
}
// @ts-ignore TS6133
function CfnAutoScalingGroupAcceleratorTotalMemoryMiBRequestPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('max', 'Max', properties.Max != null ? cfn_parse.FromCloudFormation.getNumber(properties.Max) : undefined);
    ret.addPropertyResult('min', 'Min', properties.Min != null ? cfn_parse.FromCloudFormation.getNumber(properties.Min) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `BaselineEbsBandwidthMbpsRequestProperty`
 *
 * @param properties - the TypeScript properties of a `BaselineEbsBandwidthMbpsRequestProperty`
 *
 * @returns the result of the validation.
 */
function CfnAutoScalingGroup_BaselineEbsBandwidthMbpsRequestPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('max', cdk.validateNumber)(properties.max));
    errors.collect(cdk.propertyValidator('min', cdk.validateNumber)(properties.min));
    return errors.wrap('supplied properties not correct for "BaselineEbsBandwidthMbpsRequestProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::AutoScalingGroup.BaselineEbsBandwidthMbpsRequest` resource
 *
 * @param properties - the TypeScript properties of a `BaselineEbsBandwidthMbpsRequestProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::AutoScalingGroup.BaselineEbsBandwidthMbpsRequest` resource.
 */
// @ts-ignore TS6133
function cfnAutoScalingGroupBaselineEbsBandwidthMbpsRequestPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAutoScalingGroup_BaselineEbsBandwidthMbpsRequestPropertyValidator(properties).assertSuccess();
    return {
        Max: cdk.numberToCloudFormation(properties.max),
        Min: cdk.numberToCloudFormation(properties.min),
    };
}
// @ts-ignore TS6133
function CfnAutoScalingGroupBaselineEbsBandwidthMbpsRequestPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('max', 'Max', properties.Max != null ? cfn_parse.FromCloudFormation.getNumber(properties.Max) : undefined);
    ret.addPropertyResult('min', 'Min', properties.Min != null ? cfn_parse.FromCloudFormation.getNumber(properties.Min) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `InstanceRequirementsProperty`
 *
 * @param properties - the TypeScript properties of a `InstanceRequirementsProperty`
 *
 * @returns the result of the validation.
 */
function CfnAutoScalingGroup_InstanceRequirementsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('acceleratorCount', CfnAutoScalingGroup_AcceleratorCountRequestPropertyValidator)(properties.acceleratorCount));
    errors.collect(cdk.propertyValidator('acceleratorManufacturers', cdk.listValidator(cdk.validateString))(properties.acceleratorManufacturers));
    errors.collect(cdk.propertyValidator('acceleratorNames', cdk.listValidator(cdk.validateString))(properties.acceleratorNames));
    errors.collect(cdk.propertyValidator('acceleratorTotalMemoryMiB', CfnAutoScalingGroup_AcceleratorTotalMemoryMiBRequestPropertyValidator)(properties.acceleratorTotalMemoryMiB));
    errors.collect(cdk.propertyValidator('acceleratorTypes', cdk.listValidator(cdk.validateString))(properties.acceleratorTypes));
    errors.collect(cdk.propertyValidator('allowedInstanceTypes', cdk.listValidator(cdk.validateString))(properties.allowedInstanceTypes));
    errors.collect(cdk.propertyValidator('bareMetal', cdk.validateString)(properties.bareMetal));
    errors.collect(cdk.propertyValidator('baselineEbsBandwidthMbps', CfnAutoScalingGroup_BaselineEbsBandwidthMbpsRequestPropertyValidator)(properties.baselineEbsBandwidthMbps));
    errors.collect(cdk.propertyValidator('burstablePerformance', cdk.validateString)(properties.burstablePerformance));
    errors.collect(cdk.propertyValidator('cpuManufacturers', cdk.listValidator(cdk.validateString))(properties.cpuManufacturers));
    errors.collect(cdk.propertyValidator('excludedInstanceTypes', cdk.listValidator(cdk.validateString))(properties.excludedInstanceTypes));
    errors.collect(cdk.propertyValidator('instanceGenerations', cdk.listValidator(cdk.validateString))(properties.instanceGenerations));
    errors.collect(cdk.propertyValidator('localStorage', cdk.validateString)(properties.localStorage));
    errors.collect(cdk.propertyValidator('localStorageTypes', cdk.listValidator(cdk.validateString))(properties.localStorageTypes));
    errors.collect(cdk.propertyValidator('memoryGiBPerVCpu', CfnAutoScalingGroup_MemoryGiBPerVCpuRequestPropertyValidator)(properties.memoryGiBPerVCpu));
    errors.collect(cdk.propertyValidator('memoryMiB', CfnAutoScalingGroup_MemoryMiBRequestPropertyValidator)(properties.memoryMiB));
    errors.collect(cdk.propertyValidator('networkBandwidthGbps', CfnAutoScalingGroup_NetworkBandwidthGbpsRequestPropertyValidator)(properties.networkBandwidthGbps));
    errors.collect(cdk.propertyValidator('networkInterfaceCount', CfnAutoScalingGroup_NetworkInterfaceCountRequestPropertyValidator)(properties.networkInterfaceCount));
    errors.collect(cdk.propertyValidator('onDemandMaxPricePercentageOverLowestPrice', cdk.validateNumber)(properties.onDemandMaxPricePercentageOverLowestPrice));
    errors.collect(cdk.propertyValidator('requireHibernateSupport', cdk.validateBoolean)(properties.requireHibernateSupport));
    errors.collect(cdk.propertyValidator('spotMaxPricePercentageOverLowestPrice', cdk.validateNumber)(properties.spotMaxPricePercentageOverLowestPrice));
    errors.collect(cdk.propertyValidator('totalLocalStorageGb', CfnAutoScalingGroup_TotalLocalStorageGBRequestPropertyValidator)(properties.totalLocalStorageGb));
    errors.collect(cdk.propertyValidator('vCpuCount', CfnAutoScalingGroup_VCpuCountRequestPropertyValidator)(properties.vCpuCount));
    return errors.wrap('supplied properties not correct for "InstanceRequirementsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::AutoScalingGroup.InstanceRequirements` resource
 *
 * @param properties - the TypeScript properties of a `InstanceRequirementsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::AutoScalingGroup.InstanceRequirements` resource.
 */
// @ts-ignore TS6133
function cfnAutoScalingGroupInstanceRequirementsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAutoScalingGroup_InstanceRequirementsPropertyValidator(properties).assertSuccess();
    return {
        AcceleratorCount: cfnAutoScalingGroupAcceleratorCountRequestPropertyToCloudFormation(properties.acceleratorCount),
        AcceleratorManufacturers: cdk.listMapper(cdk.stringToCloudFormation)(properties.acceleratorManufacturers),
        AcceleratorNames: cdk.listMapper(cdk.stringToCloudFormation)(properties.acceleratorNames),
        AcceleratorTotalMemoryMiB: cfnAutoScalingGroupAcceleratorTotalMemoryMiBRequestPropertyToCloudFormation(properties.acceleratorTotalMemoryMiB),
        AcceleratorTypes: cdk.listMapper(cdk.stringToCloudFormation)(properties.acceleratorTypes),
        AllowedInstanceTypes: cdk.listMapper(cdk.stringToCloudFormation)(properties.allowedInstanceTypes),
        BareMetal: cdk.stringToCloudFormation(properties.bareMetal),
        BaselineEbsBandwidthMbps: cfnAutoScalingGroupBaselineEbsBandwidthMbpsRequestPropertyToCloudFormation(properties.baselineEbsBandwidthMbps),
        BurstablePerformance: cdk.stringToCloudFormation(properties.burstablePerformance),
        CpuManufacturers: cdk.listMapper(cdk.stringToCloudFormation)(properties.cpuManufacturers),
        ExcludedInstanceTypes: cdk.listMapper(cdk.stringToCloudFormation)(properties.excludedInstanceTypes),
        InstanceGenerations: cdk.listMapper(cdk.stringToCloudFormation)(properties.instanceGenerations),
        LocalStorage: cdk.stringToCloudFormation(properties.localStorage),
        LocalStorageTypes: cdk.listMapper(cdk.stringToCloudFormation)(properties.localStorageTypes),
        MemoryGiBPerVCpu: cfnAutoScalingGroupMemoryGiBPerVCpuRequestPropertyToCloudFormation(properties.memoryGiBPerVCpu),
        MemoryMiB: cfnAutoScalingGroupMemoryMiBRequestPropertyToCloudFormation(properties.memoryMiB),
        NetworkBandwidthGbps: cfnAutoScalingGroupNetworkBandwidthGbpsRequestPropertyToCloudFormation(properties.networkBandwidthGbps),
        NetworkInterfaceCount: cfnAutoScalingGroupNetworkInterfaceCountRequestPropertyToCloudFormation(properties.networkInterfaceCount),
        OnDemandMaxPricePercentageOverLowestPrice: cdk.numberToCloudFormation(properties.onDemandMaxPricePercentageOverLowestPrice),
        RequireHibernateSupport: cdk.booleanToCloudFormation(properties.requireHibernateSupport),
        SpotMaxPricePercentageOverLowestPrice: cdk.numberToCloudFormation(properties.spotMaxPricePercentageOverLowestPrice),
        TotalLocalStorageGB: cfnAutoScalingGroupTotalLocalStorageGBRequestPropertyToCloudFormation(properties.totalLocalStorageGb),
        VCpuCount: cfnAutoScalingGroupVCpuCountRequestPropertyToCloudFormation(properties.vCpuCount),
    };
}
// @ts-ignore TS6133
function CfnAutoScalingGroupInstanceRequirementsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('acceleratorCount', 'AcceleratorCount', properties.AcceleratorCount != null ? CfnAutoScalingGroupAcceleratorCountRequestPropertyFromCloudFormation(properties.AcceleratorCount) : undefined);
    ret.addPropertyResult('acceleratorManufacturers', 'AcceleratorManufacturers', properties.AcceleratorManufacturers != null ? cfn_parse.FromCloudFormation.getStringArray(properties.AcceleratorManufacturers) : undefined);
    ret.addPropertyResult('acceleratorNames', 'AcceleratorNames', properties.AcceleratorNames != null ? cfn_parse.FromCloudFormation.getStringArray(properties.AcceleratorNames) : undefined);
    ret.addPropertyResult('acceleratorTotalMemoryMiB', 'AcceleratorTotalMemoryMiB', properties.AcceleratorTotalMemoryMiB != null ? CfnAutoScalingGroupAcceleratorTotalMemoryMiBRequestPropertyFromCloudFormation(properties.AcceleratorTotalMemoryMiB) : undefined);
    ret.addPropertyResult('acceleratorTypes', 'AcceleratorTypes', properties.AcceleratorTypes != null ? cfn_parse.FromCloudFormation.getStringArray(properties.AcceleratorTypes) : undefined);
    ret.addPropertyResult('allowedInstanceTypes', 'AllowedInstanceTypes', properties.AllowedInstanceTypes != null ? cfn_parse.FromCloudFormation.getStringArray(properties.AllowedInstanceTypes) : undefined);
    ret.addPropertyResult('bareMetal', 'BareMetal', properties.BareMetal != null ? cfn_parse.FromCloudFormation.getString(properties.BareMetal) : undefined);
    ret.addPropertyResult('baselineEbsBandwidthMbps', 'BaselineEbsBandwidthMbps', properties.BaselineEbsBandwidthMbps != null ? CfnAutoScalingGroupBaselineEbsBandwidthMbpsRequestPropertyFromCloudFormation(properties.BaselineEbsBandwidthMbps) : undefined);
    ret.addPropertyResult('burstablePerformance', 'BurstablePerformance', properties.BurstablePerformance != null ? cfn_parse.FromCloudFormation.getString(properties.BurstablePerformance) : undefined);
    ret.addPropertyResult('cpuManufacturers', 'CpuManufacturers', properties.CpuManufacturers != null ? cfn_parse.FromCloudFormation.getStringArray(properties.CpuManufacturers) : undefined);
    ret.addPropertyResult('excludedInstanceTypes', 'ExcludedInstanceTypes', properties.ExcludedInstanceTypes != null ? cfn_parse.FromCloudFormation.getStringArray(properties.ExcludedInstanceTypes) : undefined);
    ret.addPropertyResult('instanceGenerations', 'InstanceGenerations', properties.InstanceGenerations != null ? cfn_parse.FromCloudFormation.getStringArray(properties.InstanceGenerations) : undefined);
    ret.addPropertyResult('localStorage', 'LocalStorage', properties.LocalStorage != null ? cfn_parse.FromCloudFormation.getString(properties.LocalStorage) : undefined);
    ret.addPropertyResult('localStorageTypes', 'LocalStorageTypes', properties.LocalStorageTypes != null ? cfn_parse.FromCloudFormation.getStringArray(properties.LocalStorageTypes) : undefined);
    ret.addPropertyResult('memoryGiBPerVCpu', 'MemoryGiBPerVCpu', properties.MemoryGiBPerVCpu != null ? CfnAutoScalingGroupMemoryGiBPerVCpuRequestPropertyFromCloudFormation(properties.MemoryGiBPerVCpu) : undefined);
    ret.addPropertyResult('memoryMiB', 'MemoryMiB', properties.MemoryMiB != null ? CfnAutoScalingGroupMemoryMiBRequestPropertyFromCloudFormation(properties.MemoryMiB) : undefined);
    ret.addPropertyResult('networkBandwidthGbps', 'NetworkBandwidthGbps', properties.NetworkBandwidthGbps != null ? CfnAutoScalingGroupNetworkBandwidthGbpsRequestPropertyFromCloudFormation(properties.NetworkBandwidthGbps) : undefined);
    ret.addPropertyResult('networkInterfaceCount', 'NetworkInterfaceCount', properties.NetworkInterfaceCount != null ? CfnAutoScalingGroupNetworkInterfaceCountRequestPropertyFromCloudFormation(properties.NetworkInterfaceCount) : undefined);
    ret.addPropertyResult('onDemandMaxPricePercentageOverLowestPrice', 'OnDemandMaxPricePercentageOverLowestPrice', properties.OnDemandMaxPricePercentageOverLowestPrice != null ? cfn_parse.FromCloudFormation.getNumber(properties.OnDemandMaxPricePercentageOverLowestPrice) : undefined);
    ret.addPropertyResult('requireHibernateSupport', 'RequireHibernateSupport', properties.RequireHibernateSupport != null ? cfn_parse.FromCloudFormation.getBoolean(properties.RequireHibernateSupport) : undefined);
    ret.addPropertyResult('spotMaxPricePercentageOverLowestPrice', 'SpotMaxPricePercentageOverLowestPrice', properties.SpotMaxPricePercentageOverLowestPrice != null ? cfn_parse.FromCloudFormation.getNumber(properties.SpotMaxPricePercentageOverLowestPrice) : undefined);
    ret.addPropertyResult('totalLocalStorageGb', 'TotalLocalStorageGB', properties.TotalLocalStorageGB != null ? CfnAutoScalingGroupTotalLocalStorageGBRequestPropertyFromCloudFormation(properties.TotalLocalStorageGB) : undefined);
    ret.addPropertyResult('vCpuCount', 'VCpuCount', properties.VCpuCount != null ? CfnAutoScalingGroupVCpuCountRequestPropertyFromCloudFormation(properties.VCpuCount) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `InstancesDistributionProperty`
 *
 * @param properties - the TypeScript properties of a `InstancesDistributionProperty`
 *
 * @returns the result of the validation.
 */
function CfnAutoScalingGroup_InstancesDistributionPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('onDemandAllocationStrategy', cdk.validateString)(properties.onDemandAllocationStrategy));
    errors.collect(cdk.propertyValidator('onDemandBaseCapacity', cdk.validateNumber)(properties.onDemandBaseCapacity));
    errors.collect(cdk.propertyValidator('onDemandPercentageAboveBaseCapacity', cdk.validateNumber)(properties.onDemandPercentageAboveBaseCapacity));
    errors.collect(cdk.propertyValidator('spotAllocationStrategy', cdk.validateString)(properties.spotAllocationStrategy));
    errors.collect(cdk.propertyValidator('spotInstancePools', cdk.validateNumber)(properties.spotInstancePools));
    errors.collect(cdk.propertyValidator('spotMaxPrice', cdk.validateString)(properties.spotMaxPrice));
    return errors.wrap('supplied properties not correct for "InstancesDistributionProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::AutoScalingGroup.InstancesDistribution` resource
 *
 * @param properties - the TypeScript properties of a `InstancesDistributionProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::AutoScalingGroup.InstancesDistribution` resource.
 */
// @ts-ignore TS6133
function cfnAutoScalingGroupInstancesDistributionPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAutoScalingGroup_InstancesDistributionPropertyValidator(properties).assertSuccess();
    return {
        OnDemandAllocationStrategy: cdk.stringToCloudFormation(properties.onDemandAllocationStrategy),
        OnDemandBaseCapacity: cdk.numberToCloudFormation(properties.onDemandBaseCapacity),
        OnDemandPercentageAboveBaseCapacity: cdk.numberToCloudFormation(properties.onDemandPercentageAboveBaseCapacity),
        SpotAllocationStrategy: cdk.stringToCloudFormation(properties.spotAllocationStrategy),
        SpotInstancePools: cdk.numberToCloudFormation(properties.spotInstancePools),
        SpotMaxPrice: cdk.stringToCloudFormation(properties.spotMaxPrice),
    };
}
// @ts-ignore TS6133
function CfnAutoScalingGroupInstancesDistributionPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('onDemandAllocationStrategy', 'OnDemandAllocationStrategy', properties.OnDemandAllocationStrategy != null ? cfn_parse.FromCloudFormation.getString(properties.OnDemandAllocationStrategy) : undefined);
    ret.addPropertyResult('onDemandBaseCapacity', 'OnDemandBaseCapacity', properties.OnDemandBaseCapacity != null ? cfn_parse.FromCloudFormation.getNumber(properties.OnDemandBaseCapacity) : undefined);
    ret.addPropertyResult('onDemandPercentageAboveBaseCapacity', 'OnDemandPercentageAboveBaseCapacity', properties.OnDemandPercentageAboveBaseCapacity != null ? cfn_parse.FromCloudFormation.getNumber(properties.OnDemandPercentageAboveBaseCapacity) : undefined);
    ret.addPropertyResult('spotAllocationStrategy', 'SpotAllocationStrategy', properties.SpotAllocationStrategy != null ? cfn_parse.FromCloudFormation.getString(properties.SpotAllocationStrategy) : undefined);
    ret.addPropertyResult('spotInstancePools', 'SpotInstancePools', properties.SpotInstancePools != null ? cfn_parse.FromCloudFormation.getNumber(properties.SpotInstancePools) : undefined);
    ret.addPropertyResult('spotMaxPrice', 'SpotMaxPrice', properties.SpotMaxPrice != null ? cfn_parse.FromCloudFormation.getString(properties.SpotMaxPrice) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `LaunchTemplateProperty`
 *
 * @param properties - the TypeScript properties of a `LaunchTemplateProperty`
 *
 * @returns the result of the validation.
 */
function CfnAutoScalingGroup_LaunchTemplatePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('launchTemplateSpecification', cdk.requiredValidator)(properties.launchTemplateSpecification));
    errors.collect(cdk.propertyValidator('launchTemplateSpecification', CfnAutoScalingGroup_LaunchTemplateSpecificationPropertyValidator)(properties.launchTemplateSpecification));
    errors.collect(cdk.propertyValidator('overrides', cdk.listValidator(CfnAutoScalingGroup_LaunchTemplateOverridesPropertyValidator))(properties.overrides));
    return errors.wrap('supplied properties not correct for "LaunchTemplateProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::AutoScalingGroup.LaunchTemplate` resource
 *
 * @param properties - the TypeScript properties of a `LaunchTemplateProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::AutoScalingGroup.LaunchTemplate` resource.
 */
// @ts-ignore TS6133
function cfnAutoScalingGroupLaunchTemplatePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAutoScalingGroup_LaunchTemplatePropertyValidator(properties).assertSuccess();
    return {
        LaunchTemplateSpecification: cfnAutoScalingGroupLaunchTemplateSpecificationPropertyToCloudFormation(properties.launchTemplateSpecification),
        Overrides: cdk.listMapper(cfnAutoScalingGroupLaunchTemplateOverridesPropertyToCloudFormation)(properties.overrides),
    };
}
// @ts-ignore TS6133
function CfnAutoScalingGroupLaunchTemplatePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('launchTemplateSpecification', 'LaunchTemplateSpecification', CfnAutoScalingGroupLaunchTemplateSpecificationPropertyFromCloudFormation(properties.LaunchTemplateSpecification));
    ret.addPropertyResult('overrides', 'Overrides', properties.Overrides != null ? cfn_parse.FromCloudFormation.getArray(CfnAutoScalingGroupLaunchTemplateOverridesPropertyFromCloudFormation)(properties.Overrides) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `LaunchTemplateOverridesProperty`
 *
 * @param properties - the TypeScript properties of a `LaunchTemplateOverridesProperty`
 *
 * @returns the result of the validation.
 */
function CfnAutoScalingGroup_LaunchTemplateOverridesPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('instanceRequirements', CfnAutoScalingGroup_InstanceRequirementsPropertyValidator)(properties.instanceRequirements));
    errors.collect(cdk.propertyValidator('instanceType', cdk.validateString)(properties.instanceType));
    errors.collect(cdk.propertyValidator('launchTemplateSpecification', CfnAutoScalingGroup_LaunchTemplateSpecificationPropertyValidator)(properties.launchTemplateSpecification));
    errors.collect(cdk.propertyValidator('weightedCapacity', cdk.validateString)(properties.weightedCapacity));
    return errors.wrap('supplied properties not correct for "LaunchTemplateOverridesProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::AutoScalingGroup.LaunchTemplateOverrides` resource
 *
 * @param properties - the TypeScript properties of a `LaunchTemplateOverridesProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::AutoScalingGroup.LaunchTemplateOverrides` resource.
 */
// @ts-ignore TS6133
function cfnAutoScalingGroupLaunchTemplateOverridesPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAutoScalingGroup_LaunchTemplateOverridesPropertyValidator(properties).assertSuccess();
    return {
        InstanceRequirements: cfnAutoScalingGroupInstanceRequirementsPropertyToCloudFormation(properties.instanceRequirements),
        InstanceType: cdk.stringToCloudFormation(properties.instanceType),
        LaunchTemplateSpecification: cfnAutoScalingGroupLaunchTemplateSpecificationPropertyToCloudFormation(properties.launchTemplateSpecification),
        WeightedCapacity: cdk.stringToCloudFormation(properties.weightedCapacity),
    };
}
// @ts-ignore TS6133
function CfnAutoScalingGroupLaunchTemplateOverridesPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('instanceRequirements', 'InstanceRequirements', properties.InstanceRequirements != null ? CfnAutoScalingGroupInstanceRequirementsPropertyFromCloudFormation(properties.InstanceRequirements) : undefined);
    ret.addPropertyResult('instanceType', 'InstanceType', properties.InstanceType != null ? cfn_parse.FromCloudFormation.getString(properties.InstanceType) : undefined);
    ret.addPropertyResult('launchTemplateSpecification', 'LaunchTemplateSpecification', properties.LaunchTemplateSpecification != null ? CfnAutoScalingGroupLaunchTemplateSpecificationPropertyFromCloudFormation(properties.LaunchTemplateSpecification) : undefined);
    ret.addPropertyResult('weightedCapacity', 'WeightedCapacity', properties.WeightedCapacity != null ? cfn_parse.FromCloudFormation.getString(properties.WeightedCapacity) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `LaunchTemplateSpecificationProperty`
 *
 * @param properties - the TypeScript properties of a `LaunchTemplateSpecificationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAutoScalingGroup_LaunchTemplateSpecificationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('launchTemplateId', cdk.validateString)(properties.launchTemplateId));
    errors.collect(cdk.propertyValidator('launchTemplateName', cdk.validateString)(properties.launchTemplateName));
    errors.collect(cdk.propertyValidator('version', cdk.requiredValidator)(properties.version));
    errors.collect(cdk.propertyValidator('version', cdk.validateString)(properties.version));
    return errors.wrap('supplied properties not correct for "LaunchTemplateSpecificationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::AutoScalingGroup.LaunchTemplateSpecification` resource
 *
 * @param properties - the TypeScript properties of a `LaunchTemplateSpecificationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::AutoScalingGroup.LaunchTemplateSpecification` resource.
 */
// @ts-ignore TS6133
function cfnAutoScalingGroupLaunchTemplateSpecificationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAutoScalingGroup_LaunchTemplateSpecificationPropertyValidator(properties).assertSuccess();
    return {
        LaunchTemplateId: cdk.stringToCloudFormation(properties.launchTemplateId),
        LaunchTemplateName: cdk.stringToCloudFormation(properties.launchTemplateName),
        Version: cdk.stringToCloudFormation(properties.version),
    };
}
// @ts-ignore TS6133
function CfnAutoScalingGroupLaunchTemplateSpecificationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('launchTemplateId', 'LaunchTemplateId', properties.LaunchTemplateId != null ? cfn_parse.FromCloudFormation.getString(properties.LaunchTemplateId) : undefined);
    ret.addPropertyResult('launchTemplateName', 'LaunchTemplateName', properties.LaunchTemplateName != null ? cfn_parse.FromCloudFormation.getString(properties.LaunchTemplateName) : undefined);
    ret.addPropertyResult('version', 'Version', cfn_parse.FromCloudFormation.getString(properties.Version));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `LifecycleHookSpecificationProperty`
 *
 * @param properties - the TypeScript properties of a `LifecycleHookSpecificationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAutoScalingGroup_LifecycleHookSpecificationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('defaultResult', cdk.validateString)(properties.defaultResult));
    errors.collect(cdk.propertyValidator('heartbeatTimeout', cdk.validateNumber)(properties.heartbeatTimeout));
    errors.collect(cdk.propertyValidator('lifecycleHookName', cdk.requiredValidator)(properties.lifecycleHookName));
    errors.collect(cdk.propertyValidator('lifecycleHookName', cdk.validateString)(properties.lifecycleHookName));
    errors.collect(cdk.propertyValidator('lifecycleTransition', cdk.requiredValidator)(properties.lifecycleTransition));
    errors.collect(cdk.propertyValidator('lifecycleTransition', cdk.validateString)(properties.lifecycleTransition));
    errors.collect(cdk.propertyValidator('notificationMetadata', cdk.validateString)(properties.notificationMetadata));
    errors.collect(cdk.propertyValidator('notificationTargetArn', cdk.validateString)(properties.notificationTargetArn));
    errors.collect(cdk.propertyValidator('roleArn', cdk.validateString)(properties.roleArn));
    return errors.wrap('supplied properties not correct for "LifecycleHookSpecificationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::AutoScalingGroup.LifecycleHookSpecification` resource
 *
 * @param properties - the TypeScript properties of a `LifecycleHookSpecificationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::AutoScalingGroup.LifecycleHookSpecification` resource.
 */
// @ts-ignore TS6133
function cfnAutoScalingGroupLifecycleHookSpecificationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAutoScalingGroup_LifecycleHookSpecificationPropertyValidator(properties).assertSuccess();
    return {
        DefaultResult: cdk.stringToCloudFormation(properties.defaultResult),
        HeartbeatTimeout: cdk.numberToCloudFormation(properties.heartbeatTimeout),
        LifecycleHookName: cdk.stringToCloudFormation(properties.lifecycleHookName),
        LifecycleTransition: cdk.stringToCloudFormation(properties.lifecycleTransition),
        NotificationMetadata: cdk.stringToCloudFormation(properties.notificationMetadata),
        NotificationTargetARN: cdk.stringToCloudFormation(properties.notificationTargetArn),
        RoleARN: cdk.stringToCloudFormation(properties.roleArn),
    };
}
// @ts-ignore TS6133
function CfnAutoScalingGroupLifecycleHookSpecificationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('defaultResult', 'DefaultResult', properties.DefaultResult != null ? cfn_parse.FromCloudFormation.getString(properties.DefaultResult) : undefined);
    ret.addPropertyResult('heartbeatTimeout', 'HeartbeatTimeout', properties.HeartbeatTimeout != null ? cfn_parse.FromCloudFormation.getNumber(properties.HeartbeatTimeout) : undefined);
    ret.addPropertyResult('lifecycleHookName', 'LifecycleHookName', cfn_parse.FromCloudFormation.getString(properties.LifecycleHookName));
    ret.addPropertyResult('lifecycleTransition', 'LifecycleTransition', cfn_parse.FromCloudFormation.getString(properties.LifecycleTransition));
    ret.addPropertyResult('notificationMetadata', 'NotificationMetadata', properties.NotificationMetadata != null ? cfn_parse.FromCloudFormation.getString(properties.NotificationMetadata) : undefined);
    ret.addPropertyResult('notificationTargetArn', 'NotificationTargetARN', properties.NotificationTargetARN != null ? cfn_parse.FromCloudFormation.getString(properties.NotificationTargetARN) : undefined);
    ret.addPropertyResult('roleArn', 'RoleARN', properties.RoleARN != null ? cfn_parse.FromCloudFormation.getString(properties.RoleARN) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `MemoryGiBPerVCpuRequestProperty`
 *
 * @param properties - the TypeScript properties of a `MemoryGiBPerVCpuRequestProperty`
 *
 * @returns the result of the validation.
 */
function CfnAutoScalingGroup_MemoryGiBPerVCpuRequestPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('max', cdk.validateNumber)(properties.max));
    errors.collect(cdk.propertyValidator('min', cdk.validateNumber)(properties.min));
    return errors.wrap('supplied properties not correct for "MemoryGiBPerVCpuRequestProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::AutoScalingGroup.MemoryGiBPerVCpuRequest` resource
 *
 * @param properties - the TypeScript properties of a `MemoryGiBPerVCpuRequestProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::AutoScalingGroup.MemoryGiBPerVCpuRequest` resource.
 */
// @ts-ignore TS6133
function cfnAutoScalingGroupMemoryGiBPerVCpuRequestPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAutoScalingGroup_MemoryGiBPerVCpuRequestPropertyValidator(properties).assertSuccess();
    return {
        Max: cdk.numberToCloudFormation(properties.max),
        Min: cdk.numberToCloudFormation(properties.min),
    };
}
// @ts-ignore TS6133
function CfnAutoScalingGroupMemoryGiBPerVCpuRequestPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('max', 'Max', properties.Max != null ? cfn_parse.FromCloudFormation.getNumber(properties.Max) : undefined);
    ret.addPropertyResult('min', 'Min', properties.Min != null ? cfn_parse.FromCloudFormation.getNumber(properties.Min) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `MemoryMiBRequestProperty`
 *
 * @param properties - the TypeScript properties of a `MemoryMiBRequestProperty`
 *
 * @returns the result of the validation.
 */
function CfnAutoScalingGroup_MemoryMiBRequestPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('max', cdk.validateNumber)(properties.max));
    errors.collect(cdk.propertyValidator('min', cdk.validateNumber)(properties.min));
    return errors.wrap('supplied properties not correct for "MemoryMiBRequestProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::AutoScalingGroup.MemoryMiBRequest` resource
 *
 * @param properties - the TypeScript properties of a `MemoryMiBRequestProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::AutoScalingGroup.MemoryMiBRequest` resource.
 */
// @ts-ignore TS6133
function cfnAutoScalingGroupMemoryMiBRequestPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAutoScalingGroup_MemoryMiBRequestPropertyValidator(properties).assertSuccess();
    return {
        Max: cdk.numberToCloudFormation(properties.max),
        Min: cdk.numberToCloudFormation(properties.min),
    };
}
// @ts-ignore TS6133
function CfnAutoScalingGroupMemoryMiBRequestPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('max', 'Max', properties.Max != null ? cfn_parse.FromCloudFormation.getNumber(properties.Max) : undefined);
    ret.addPropertyResult('min', 'Min', properties.Min != null ? cfn_parse.FromCloudFormation.getNumber(properties.Min) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `MetricsCollectionProperty`
 *
 * @param properties - the TypeScript properties of a `MetricsCollectionProperty`
 *
 * @returns the result of the validation.
 */
function CfnAutoScalingGroup_MetricsCollectionPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('granularity', cdk.requiredValidator)(properties.granularity));
    errors.collect(cdk.propertyValidator('granularity', cdk.validateString)(properties.granularity));
    errors.collect(cdk.propertyValidator('metrics', cdk.listValidator(cdk.validateString))(properties.metrics));
    return errors.wrap('supplied properties not correct for "MetricsCollectionProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::AutoScalingGroup.MetricsCollection` resource
 *
 * @param properties - the TypeScript properties of a `MetricsCollectionProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::AutoScalingGroup.MetricsCollection` resource.
 */
// @ts-ignore TS6133
function cfnAutoScalingGroupMetricsCollectionPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAutoScalingGroup_MetricsCollectionPropertyValidator(properties).assertSuccess();
    return {
        Granularity: cdk.stringToCloudFormation(properties.granularity),
        Metrics: cdk.listMapper(cdk.stringToCloudFormation)(properties.metrics),
    };
}
// @ts-ignore TS6133
function CfnAutoScalingGroupMetricsCollectionPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('granularity', 'Granularity', cfn_parse.FromCloudFormation.getString(properties.Granularity));
    ret.addPropertyResult('metrics', 'Metrics', properties.Metrics != null ? cfn_parse.FromCloudFormation.getStringArray(properties.Metrics) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `MixedInstancesPolicyProperty`
 *
 * @param properties - the TypeScript properties of a `MixedInstancesPolicyProperty`
 *
 * @returns the result of the validation.
 */
function CfnAutoScalingGroup_MixedInstancesPolicyPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('instancesDistribution', CfnAutoScalingGroup_InstancesDistributionPropertyValidator)(properties.instancesDistribution));
    errors.collect(cdk.propertyValidator('launchTemplate', cdk.requiredValidator)(properties.launchTemplate));
    errors.collect(cdk.propertyValidator('launchTemplate', CfnAutoScalingGroup_LaunchTemplatePropertyValidator)(properties.launchTemplate));
    return errors.wrap('supplied properties not correct for "MixedInstancesPolicyProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::AutoScalingGroup.MixedInstancesPolicy` resource
 *
 * @param properties - the TypeScript properties of a `MixedInstancesPolicyProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::AutoScalingGroup.MixedInstancesPolicy` resource.
 */
// @ts-ignore TS6133
function cfnAutoScalingGroupMixedInstancesPolicyPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAutoScalingGroup_MixedInstancesPolicyPropertyValidator(properties).assertSuccess();
    return {
        InstancesDistribution: cfnAutoScalingGroupInstancesDistributionPropertyToCloudFormation(properties.instancesDistribution),
        LaunchTemplate: cfnAutoScalingGroupLaunchTemplatePropertyToCloudFormation(properties.launchTemplate),
    };
}
// @ts-ignore TS6133
function CfnAutoScalingGroupMixedInstancesPolicyPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('instancesDistribution', 'InstancesDistribution', properties.InstancesDistribution != null ? CfnAutoScalingGroupInstancesDistributionPropertyFromCloudFormation(properties.InstancesDistribution) : undefined);
    ret.addPropertyResult('launchTemplate', 'LaunchTemplate', CfnAutoScalingGroupLaunchTemplatePropertyFromCloudFormation(properties.LaunchTemplate));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `NetworkBandwidthGbpsRequestProperty`
 *
 * @param properties - the TypeScript properties of a `NetworkBandwidthGbpsRequestProperty`
 *
 * @returns the result of the validation.
 */
function CfnAutoScalingGroup_NetworkBandwidthGbpsRequestPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('max', cdk.validateNumber)(properties.max));
    errors.collect(cdk.propertyValidator('min', cdk.validateNumber)(properties.min));
    return errors.wrap('supplied properties not correct for "NetworkBandwidthGbpsRequestProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::AutoScalingGroup.NetworkBandwidthGbpsRequest` resource
 *
 * @param properties - the TypeScript properties of a `NetworkBandwidthGbpsRequestProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::AutoScalingGroup.NetworkBandwidthGbpsRequest` resource.
 */
// @ts-ignore TS6133
function cfnAutoScalingGroupNetworkBandwidthGbpsRequestPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAutoScalingGroup_NetworkBandwidthGbpsRequestPropertyValidator(properties).assertSuccess();
    return {
        Max: cdk.numberToCloudFormation(properties.max),
        Min: cdk.numberToCloudFormation(properties.min),
    };
}
// @ts-ignore TS6133
function CfnAutoScalingGroupNetworkBandwidthGbpsRequestPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('max', 'Max', properties.Max != null ? cfn_parse.FromCloudFormation.getNumber(properties.Max) : undefined);
    ret.addPropertyResult('min', 'Min', properties.Min != null ? cfn_parse.FromCloudFormation.getNumber(properties.Min) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `NetworkInterfaceCountRequestProperty`
 *
 * @param properties - the TypeScript properties of a `NetworkInterfaceCountRequestProperty`
 *
 * @returns the result of the validation.
 */
function CfnAutoScalingGroup_NetworkInterfaceCountRequestPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('max', cdk.validateNumber)(properties.max));
    errors.collect(cdk.propertyValidator('min', cdk.validateNumber)(properties.min));
    return errors.wrap('supplied properties not correct for "NetworkInterfaceCountRequestProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::AutoScalingGroup.NetworkInterfaceCountRequest` resource
 *
 * @param properties - the TypeScript properties of a `NetworkInterfaceCountRequestProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::AutoScalingGroup.NetworkInterfaceCountRequest` resource.
 */
// @ts-ignore TS6133
function cfnAutoScalingGroupNetworkInterfaceCountRequestPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAutoScalingGroup_NetworkInterfaceCountRequestPropertyValidator(properties).assertSuccess();
    return {
        Max: cdk.numberToCloudFormation(properties.max),
        Min: cdk.numberToCloudFormation(properties.min),
    };
}
// @ts-ignore TS6133
function CfnAutoScalingGroupNetworkInterfaceCountRequestPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('max', 'Max', properties.Max != null ? cfn_parse.FromCloudFormation.getNumber(properties.Max) : undefined);
    ret.addPropertyResult('min', 'Min', properties.Min != null ? cfn_parse.FromCloudFormation.getNumber(properties.Min) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `NotificationConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `NotificationConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAutoScalingGroup_NotificationConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('notificationTypes', cdk.listValidator(cdk.validateString))(properties.notificationTypes));
    errors.collect(cdk.propertyValidator('topicArn', cdk.requiredValidator)(properties.topicArn));
    errors.collect(cdk.propertyValidator('topicArn', cdk.validateString)(properties.topicArn));
    return errors.wrap('supplied properties not correct for "NotificationConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::AutoScalingGroup.NotificationConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `NotificationConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::AutoScalingGroup.NotificationConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAutoScalingGroupNotificationConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAutoScalingGroup_NotificationConfigurationPropertyValidator(properties).assertSuccess();
    return {
        NotificationTypes: cdk.listMapper(cdk.stringToCloudFormation)(properties.notificationTypes),
        TopicARN: cdk.stringToCloudFormation(properties.topicArn),
    };
}
// @ts-ignore TS6133
function CfnAutoScalingGroupNotificationConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('notificationTypes', 'NotificationTypes', properties.NotificationTypes != null ? cfn_parse.FromCloudFormation.getStringArray(properties.NotificationTypes) : undefined);
    ret.addPropertyResult('topicArn', 'TopicARN', cfn_parse.FromCloudFormation.getString(properties.TopicARN));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `TagPropertyProperty`
 *
 * @param properties - the TypeScript properties of a `TagPropertyProperty`
 *
 * @returns the result of the validation.
 */
function CfnAutoScalingGroup_TagPropertyPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('key', cdk.requiredValidator)(properties.key));
    errors.collect(cdk.propertyValidator('key', cdk.validateString)(properties.key));
    errors.collect(cdk.propertyValidator('propagateAtLaunch', cdk.requiredValidator)(properties.propagateAtLaunch));
    errors.collect(cdk.propertyValidator('propagateAtLaunch', cdk.validateBoolean)(properties.propagateAtLaunch));
    errors.collect(cdk.propertyValidator('value', cdk.requiredValidator)(properties.value));
    errors.collect(cdk.propertyValidator('value', cdk.validateString)(properties.value));
    return errors.wrap('supplied properties not correct for "TagPropertyProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::AutoScalingGroup.TagProperty` resource
 *
 * @param properties - the TypeScript properties of a `TagPropertyProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::AutoScalingGroup.TagProperty` resource.
 */
// @ts-ignore TS6133
function cfnAutoScalingGroupTagPropertyPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAutoScalingGroup_TagPropertyPropertyValidator(properties).assertSuccess();
    return {
        Key: cdk.stringToCloudFormation(properties.key),
        PropagateAtLaunch: cdk.booleanToCloudFormation(properties.propagateAtLaunch),
        Value: cdk.stringToCloudFormation(properties.value),
    };
}
// @ts-ignore TS6133
function CfnAutoScalingGroupTagPropertyPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('key', 'Key', cfn_parse.FromCloudFormation.getString(properties.Key));
    ret.addPropertyResult('propagateAtLaunch', 'PropagateAtLaunch', cfn_parse.FromCloudFormation.getBoolean(properties.PropagateAtLaunch));
    ret.addPropertyResult('value', 'Value', cfn_parse.FromCloudFormation.getString(properties.Value));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `TotalLocalStorageGBRequestProperty`
 *
 * @param properties - the TypeScript properties of a `TotalLocalStorageGBRequestProperty`
 *
 * @returns the result of the validation.
 */
function CfnAutoScalingGroup_TotalLocalStorageGBRequestPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('max', cdk.validateNumber)(properties.max));
    errors.collect(cdk.propertyValidator('min', cdk.validateNumber)(properties.min));
    return errors.wrap('supplied properties not correct for "TotalLocalStorageGBRequestProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::AutoScalingGroup.TotalLocalStorageGBRequest` resource
 *
 * @param properties - the TypeScript properties of a `TotalLocalStorageGBRequestProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::AutoScalingGroup.TotalLocalStorageGBRequest` resource.
 */
// @ts-ignore TS6133
function cfnAutoScalingGroupTotalLocalStorageGBRequestPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAutoScalingGroup_TotalLocalStorageGBRequestPropertyValidator(properties).assertSuccess();
    return {
        Max: cdk.numberToCloudFormation(properties.max),
        Min: cdk.numberToCloudFormation(properties.min),
    };
}
// @ts-ignore TS6133
function CfnAutoScalingGroupTotalLocalStorageGBRequestPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('max', 'Max', properties.Max != null ? cfn_parse.FromCloudFormation.getNumber(properties.Max) : undefined);
    ret.addPropertyResult('min', 'Min', properties.Min != null ? cfn_parse.FromCloudFormation.getNumber(properties.Min) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `VCpuCountRequestProperty`
 *
 * @param properties - the TypeScript properties of a `VCpuCountRequestProperty`
 *
 * @returns the result of the validation.
 */
function CfnAutoScalingGroup_VCpuCountRequestPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('max', cdk.validateNumber)(properties.max));
    errors.collect(cdk.propertyValidator('min', cdk.validateNumber)(properties.min));
    return errors.wrap('supplied properties not correct for "VCpuCountRequestProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::AutoScalingGroup.VCpuCountRequest` resource
 *
 * @param properties - the TypeScript properties of a `VCpuCountRequestProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::AutoScalingGroup.VCpuCountRequest` resource.
 */
// @ts-ignore TS6133
function cfnAutoScalingGroupVCpuCountRequestPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAutoScalingGroup_VCpuCountRequestPropertyValidator(properties).assertSuccess();
    return {
        Max: cdk.numberToCloudFormation(properties.max),
        Min: cdk.numberToCloudFormation(properties.min),
    };
}
// @ts-ignore TS6133
function CfnAutoScalingGroupVCpuCountRequestPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('max', 'Max', properties.Max != null ? cfn_parse.FromCloudFormation.getNumber(properties.Max) : undefined);
    ret.addPropertyResult('min', 'Min', properties.Min != null ? cfn_parse.FromCloudFormation.getNumber(properties.Min) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnLaunchConfigurationProps`
 *
 * @param properties - the TypeScript properties of a `CfnLaunchConfigurationProps`
 *
 * @returns the result of the validation.
 */
function CfnLaunchConfigurationPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('associatePublicIpAddress', cdk.validateBoolean)(properties.associatePublicIpAddress));
    errors.collect(cdk.propertyValidator('blockDeviceMappings', cdk.listValidator(CfnLaunchConfiguration_BlockDeviceMappingPropertyValidator))(properties.blockDeviceMappings));
    errors.collect(cdk.propertyValidator('classicLinkVpcId', cdk.validateString)(properties.classicLinkVpcId));
    errors.collect(cdk.propertyValidator('classicLinkVpcSecurityGroups', cdk.listValidator(cdk.validateString))(properties.classicLinkVpcSecurityGroups));
    errors.collect(cdk.propertyValidator('ebsOptimized', cdk.validateBoolean)(properties.ebsOptimized));
    errors.collect(cdk.propertyValidator('iamInstanceProfile', cdk.validateString)(properties.iamInstanceProfile));
    errors.collect(cdk.propertyValidator('imageId', cdk.requiredValidator)(properties.imageId));
    errors.collect(cdk.propertyValidator('imageId', cdk.validateString)(properties.imageId));
    errors.collect(cdk.propertyValidator('instanceId', cdk.validateString)(properties.instanceId));
    errors.collect(cdk.propertyValidator('instanceMonitoring', cdk.validateBoolean)(properties.instanceMonitoring));
    errors.collect(cdk.propertyValidator('instanceType', cdk.requiredValidator)(properties.instanceType));
    errors.collect(cdk.propertyValidator('instanceType', cdk.validateString)(properties.instanceType));
    errors.collect(cdk.propertyValidator('kernelId', cdk.validateString)(properties.kernelId));
    errors.collect(cdk.propertyValidator('keyName', cdk.validateString)(properties.keyName));
    errors.collect(cdk.propertyValidator('launchConfigurationName', cdk.validateString)(properties.launchConfigurationName));
    errors.collect(cdk.propertyValidator('metadataOptions', CfnLaunchConfiguration_MetadataOptionsPropertyValidator)(properties.metadataOptions));
    errors.collect(cdk.propertyValidator('placementTenancy', cdk.validateString)(properties.placementTenancy));
    errors.collect(cdk.propertyValidator('ramDiskId', cdk.validateString)(properties.ramDiskId));
    errors.collect(cdk.propertyValidator('securityGroups', cdk.listValidator(cdk.validateString))(properties.securityGroups));
    errors.collect(cdk.propertyValidator('spotPrice', cdk.validateString)(properties.spotPrice));
    errors.collect(cdk.propertyValidator('userData', cdk.validateString)(properties.userData));
    return errors.wrap('supplied properties not correct for "CfnLaunchConfigurationProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::LaunchConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `CfnLaunchConfigurationProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::LaunchConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnLaunchConfigurationPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnLaunchConfigurationPropsValidator(properties).assertSuccess();
    return {
        ImageId: cdk.stringToCloudFormation(properties.imageId),
        InstanceType: cdk.stringToCloudFormation(properties.instanceType),
        AssociatePublicIpAddress: cdk.booleanToCloudFormation(properties.associatePublicIpAddress),
        BlockDeviceMappings: cdk.listMapper(cfnLaunchConfigurationBlockDeviceMappingPropertyToCloudFormation)(properties.blockDeviceMappings),
        ClassicLinkVPCId: cdk.stringToCloudFormation(properties.classicLinkVpcId),
        ClassicLinkVPCSecurityGroups: cdk.listMapper(cdk.stringToCloudFormation)(properties.classicLinkVpcSecurityGroups),
        EbsOptimized: cdk.booleanToCloudFormation(properties.ebsOptimized),
        IamInstanceProfile: cdk.stringToCloudFormation(properties.iamInstanceProfile),
        InstanceId: cdk.stringToCloudFormation(properties.instanceId),
        InstanceMonitoring: cdk.booleanToCloudFormation(properties.instanceMonitoring),
        KernelId: cdk.stringToCloudFormation(properties.kernelId),
        KeyName: cdk.stringToCloudFormation(properties.keyName),
        LaunchConfigurationName: cdk.stringToCloudFormation(properties.launchConfigurationName),
        MetadataOptions: cfnLaunchConfigurationMetadataOptionsPropertyToCloudFormation(properties.metadataOptions),
        PlacementTenancy: cdk.stringToCloudFormation(properties.placementTenancy),
        RamDiskId: cdk.stringToCloudFormation(properties.ramDiskId),
        SecurityGroups: cdk.listMapper(cdk.stringToCloudFormation)(properties.securityGroups),
        SpotPrice: cdk.stringToCloudFormation(properties.spotPrice),
        UserData: cdk.stringToCloudFormation(properties.userData),
    };
}
// @ts-ignore TS6133
function CfnLaunchConfigurationPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('imageId', 'ImageId', cfn_parse.FromCloudFormation.getString(properties.ImageId));
    ret.addPropertyResult('instanceType', 'InstanceType', cfn_parse.FromCloudFormation.getString(properties.InstanceType));
    ret.addPropertyResult('associatePublicIpAddress', 'AssociatePublicIpAddress', properties.AssociatePublicIpAddress != null ? cfn_parse.FromCloudFormation.getBoolean(properties.AssociatePublicIpAddress) : undefined);
    ret.addPropertyResult('blockDeviceMappings', 'BlockDeviceMappings', properties.BlockDeviceMappings != null ? cfn_parse.FromCloudFormation.getArray(CfnLaunchConfigurationBlockDeviceMappingPropertyFromCloudFormation)(properties.BlockDeviceMappings) : undefined);
    ret.addPropertyResult('classicLinkVpcId', 'ClassicLinkVPCId', properties.ClassicLinkVPCId != null ? cfn_parse.FromCloudFormation.getString(properties.ClassicLinkVPCId) : undefined);
    ret.addPropertyResult('classicLinkVpcSecurityGroups', 'ClassicLinkVPCSecurityGroups', properties.ClassicLinkVPCSecurityGroups != null ? cfn_parse.FromCloudFormation.getStringArray(properties.ClassicLinkVPCSecurityGroups) : undefined);
    ret.addPropertyResult('ebsOptimized', 'EbsOptimized', properties.EbsOptimized != null ? cfn_parse.FromCloudFormation.getBoolean(properties.EbsOptimized) : undefined);
    ret.addPropertyResult('iamInstanceProfile', 'IamInstanceProfile', properties.IamInstanceProfile != null ? cfn_parse.FromCloudFormation.getString(properties.IamInstanceProfile) : undefined);
    ret.addPropertyResult('instanceId', 'InstanceId', properties.InstanceId != null ? cfn_parse.FromCloudFormation.getString(properties.InstanceId) : undefined);
    ret.addPropertyResult('instanceMonitoring', 'InstanceMonitoring', properties.InstanceMonitoring != null ? cfn_parse.FromCloudFormation.getBoolean(properties.InstanceMonitoring) : undefined);
    ret.addPropertyResult('kernelId', 'KernelId', properties.KernelId != null ? cfn_parse.FromCloudFormation.getString(properties.KernelId) : undefined);
    ret.addPropertyResult('keyName', 'KeyName', properties.KeyName != null ? cfn_parse.FromCloudFormation.getString(properties.KeyName) : undefined);
    ret.addPropertyResult('launchConfigurationName', 'LaunchConfigurationName', properties.LaunchConfigurationName != null ? cfn_parse.FromCloudFormation.getString(properties.LaunchConfigurationName) : undefined);
    ret.addPropertyResult('metadataOptions', 'MetadataOptions', properties.MetadataOptions != null ? CfnLaunchConfigurationMetadataOptionsPropertyFromCloudFormation(properties.MetadataOptions) : undefined);
    ret.addPropertyResult('placementTenancy', 'PlacementTenancy', properties.PlacementTenancy != null ? cfn_parse.FromCloudFormation.getString(properties.PlacementTenancy) : undefined);
    ret.addPropertyResult('ramDiskId', 'RamDiskId', properties.RamDiskId != null ? cfn_parse.FromCloudFormation.getString(properties.RamDiskId) : undefined);
    ret.addPropertyResult('securityGroups', 'SecurityGroups', properties.SecurityGroups != null ? cfn_parse.FromCloudFormation.getStringArray(properties.SecurityGroups) : undefined);
    ret.addPropertyResult('spotPrice', 'SpotPrice', properties.SpotPrice != null ? cfn_parse.FromCloudFormation.getString(properties.SpotPrice) : undefined);
    ret.addPropertyResult('userData', 'UserData', properties.UserData != null ? cfn_parse.FromCloudFormation.getString(properties.UserData) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::AutoScaling::LaunchConfiguration`
 *
 * The `AWS::AutoScaling::LaunchConfiguration` resource specifies the launch configuration that can be used by an Auto Scaling group to configure Amazon EC2 instances.
 *
 * When you update the launch configuration for an Auto Scaling group, CloudFormation deletes that resource and creates a new launch configuration with the updated properties and a new name. Existing instances are not affected. To update existing instances when you update the `AWS::AutoScaling::LaunchConfiguration` resource, you can specify an [UpdatePolicy attribute](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-updatepolicy.html) for the group. You can find sample update policies for rolling updates in [Auto scaling template snippets](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/quickref-autoscaling.html) .
 *
 * > Amazon EC2 Auto Scaling configures instances launched as part of an Auto Scaling group using either a [launch template](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html) or a launch configuration. We strongly recommend that you do not use launch configurations. They do not provide full functionality for Amazon EC2 Auto Scaling or Amazon EC2. For more information, see [Launch configurations](https://docs.aws.amazon.com/autoscaling/ec2/userguide/launch-configurations.html) in the *Amazon EC2 Auto Scaling User Guide* .
 *
 * @cloudformationResource AWS::AutoScaling::LaunchConfiguration
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-launchconfiguration.html
 */
class CfnLaunchConfiguration extends cdk.CfnResource {
    /**
     * Create a new `AWS::AutoScaling::LaunchConfiguration`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnLaunchConfiguration.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.monocdk_Construct(scope);
            jsiiDeprecationWarnings.monocdk_aws_autoscaling_CfnLaunchConfigurationProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnLaunchConfiguration);
            }
            throw error;
        }
        cdk.requireProperty(props, 'imageId', this);
        cdk.requireProperty(props, 'instanceType', this);
        this.imageId = props.imageId;
        this.instanceType = props.instanceType;
        this.associatePublicIpAddress = props.associatePublicIpAddress;
        this.blockDeviceMappings = props.blockDeviceMappings;
        this.classicLinkVpcId = props.classicLinkVpcId;
        this.classicLinkVpcSecurityGroups = props.classicLinkVpcSecurityGroups;
        this.ebsOptimized = props.ebsOptimized;
        this.iamInstanceProfile = props.iamInstanceProfile;
        this.instanceId = props.instanceId;
        this.instanceMonitoring = props.instanceMonitoring;
        this.kernelId = props.kernelId;
        this.keyName = props.keyName;
        this.launchConfigurationName = props.launchConfigurationName;
        this.metadataOptions = props.metadataOptions;
        this.placementTenancy = props.placementTenancy;
        this.ramDiskId = props.ramDiskId;
        this.securityGroups = props.securityGroups;
        this.spotPrice = props.spotPrice;
        this.userData = props.userData;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnLaunchConfigurationPropsFromCloudFormation(resourceProperties);
        const ret = new CfnLaunchConfiguration(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.monocdk_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnLaunchConfiguration.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            imageId: this.imageId,
            instanceType: this.instanceType,
            associatePublicIpAddress: this.associatePublicIpAddress,
            blockDeviceMappings: this.blockDeviceMappings,
            classicLinkVpcId: this.classicLinkVpcId,
            classicLinkVpcSecurityGroups: this.classicLinkVpcSecurityGroups,
            ebsOptimized: this.ebsOptimized,
            iamInstanceProfile: this.iamInstanceProfile,
            instanceId: this.instanceId,
            instanceMonitoring: this.instanceMonitoring,
            kernelId: this.kernelId,
            keyName: this.keyName,
            launchConfigurationName: this.launchConfigurationName,
            metadataOptions: this.metadataOptions,
            placementTenancy: this.placementTenancy,
            ramDiskId: this.ramDiskId,
            securityGroups: this.securityGroups,
            spotPrice: this.spotPrice,
            userData: this.userData,
        };
    }
    renderProperties(props) {
        return cfnLaunchConfigurationPropsToCloudFormation(props);
    }
}
exports.CfnLaunchConfiguration = CfnLaunchConfiguration;
_b = JSII_RTTI_SYMBOL_1;
CfnLaunchConfiguration[_b] = { fqn: "monocdk.aws_autoscaling.CfnLaunchConfiguration", version: "1.191.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnLaunchConfiguration.CFN_RESOURCE_TYPE_NAME = "AWS::AutoScaling::LaunchConfiguration";
/**
 * Determine whether the given properties match those of a `BlockDeviceProperty`
 *
 * @param properties - the TypeScript properties of a `BlockDeviceProperty`
 *
 * @returns the result of the validation.
 */
function CfnLaunchConfiguration_BlockDevicePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('deleteOnTermination', cdk.validateBoolean)(properties.deleteOnTermination));
    errors.collect(cdk.propertyValidator('encrypted', cdk.validateBoolean)(properties.encrypted));
    errors.collect(cdk.propertyValidator('iops', cdk.validateNumber)(properties.iops));
    errors.collect(cdk.propertyValidator('snapshotId', cdk.validateString)(properties.snapshotId));
    errors.collect(cdk.propertyValidator('throughput', cdk.validateNumber)(properties.throughput));
    errors.collect(cdk.propertyValidator('volumeSize', cdk.validateNumber)(properties.volumeSize));
    errors.collect(cdk.propertyValidator('volumeType', cdk.validateString)(properties.volumeType));
    return errors.wrap('supplied properties not correct for "BlockDeviceProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::LaunchConfiguration.BlockDevice` resource
 *
 * @param properties - the TypeScript properties of a `BlockDeviceProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::LaunchConfiguration.BlockDevice` resource.
 */
// @ts-ignore TS6133
function cfnLaunchConfigurationBlockDevicePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnLaunchConfiguration_BlockDevicePropertyValidator(properties).assertSuccess();
    return {
        DeleteOnTermination: cdk.booleanToCloudFormation(properties.deleteOnTermination),
        Encrypted: cdk.booleanToCloudFormation(properties.encrypted),
        Iops: cdk.numberToCloudFormation(properties.iops),
        SnapshotId: cdk.stringToCloudFormation(properties.snapshotId),
        Throughput: cdk.numberToCloudFormation(properties.throughput),
        VolumeSize: cdk.numberToCloudFormation(properties.volumeSize),
        VolumeType: cdk.stringToCloudFormation(properties.volumeType),
    };
}
// @ts-ignore TS6133
function CfnLaunchConfigurationBlockDevicePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('deleteOnTermination', 'DeleteOnTermination', properties.DeleteOnTermination != null ? cfn_parse.FromCloudFormation.getBoolean(properties.DeleteOnTermination) : undefined);
    ret.addPropertyResult('encrypted', 'Encrypted', properties.Encrypted != null ? cfn_parse.FromCloudFormation.getBoolean(properties.Encrypted) : undefined);
    ret.addPropertyResult('iops', 'Iops', properties.Iops != null ? cfn_parse.FromCloudFormation.getNumber(properties.Iops) : undefined);
    ret.addPropertyResult('snapshotId', 'SnapshotId', properties.SnapshotId != null ? cfn_parse.FromCloudFormation.getString(properties.SnapshotId) : undefined);
    ret.addPropertyResult('throughput', 'Throughput', properties.Throughput != null ? cfn_parse.FromCloudFormation.getNumber(properties.Throughput) : undefined);
    ret.addPropertyResult('volumeSize', 'VolumeSize', properties.VolumeSize != null ? cfn_parse.FromCloudFormation.getNumber(properties.VolumeSize) : undefined);
    ret.addPropertyResult('volumeType', 'VolumeType', properties.VolumeType != null ? cfn_parse.FromCloudFormation.getString(properties.VolumeType) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `BlockDeviceMappingProperty`
 *
 * @param properties - the TypeScript properties of a `BlockDeviceMappingProperty`
 *
 * @returns the result of the validation.
 */
function CfnLaunchConfiguration_BlockDeviceMappingPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('deviceName', cdk.requiredValidator)(properties.deviceName));
    errors.collect(cdk.propertyValidator('deviceName', cdk.validateString)(properties.deviceName));
    errors.collect(cdk.propertyValidator('ebs', CfnLaunchConfiguration_BlockDevicePropertyValidator)(properties.ebs));
    errors.collect(cdk.propertyValidator('noDevice', cdk.validateBoolean)(properties.noDevice));
    errors.collect(cdk.propertyValidator('virtualName', cdk.validateString)(properties.virtualName));
    return errors.wrap('supplied properties not correct for "BlockDeviceMappingProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::LaunchConfiguration.BlockDeviceMapping` resource
 *
 * @param properties - the TypeScript properties of a `BlockDeviceMappingProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::LaunchConfiguration.BlockDeviceMapping` resource.
 */
// @ts-ignore TS6133
function cfnLaunchConfigurationBlockDeviceMappingPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnLaunchConfiguration_BlockDeviceMappingPropertyValidator(properties).assertSuccess();
    return {
        DeviceName: cdk.stringToCloudFormation(properties.deviceName),
        Ebs: cfnLaunchConfigurationBlockDevicePropertyToCloudFormation(properties.ebs),
        NoDevice: cdk.booleanToCloudFormation(properties.noDevice),
        VirtualName: cdk.stringToCloudFormation(properties.virtualName),
    };
}
// @ts-ignore TS6133
function CfnLaunchConfigurationBlockDeviceMappingPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('deviceName', 'DeviceName', cfn_parse.FromCloudFormation.getString(properties.DeviceName));
    ret.addPropertyResult('ebs', 'Ebs', properties.Ebs != null ? CfnLaunchConfigurationBlockDevicePropertyFromCloudFormation(properties.Ebs) : undefined);
    ret.addPropertyResult('noDevice', 'NoDevice', properties.NoDevice != null ? cfn_parse.FromCloudFormation.getBoolean(properties.NoDevice) : undefined);
    ret.addPropertyResult('virtualName', 'VirtualName', properties.VirtualName != null ? cfn_parse.FromCloudFormation.getString(properties.VirtualName) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `MetadataOptionsProperty`
 *
 * @param properties - the TypeScript properties of a `MetadataOptionsProperty`
 *
 * @returns the result of the validation.
 */
function CfnLaunchConfiguration_MetadataOptionsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('httpEndpoint', cdk.validateString)(properties.httpEndpoint));
    errors.collect(cdk.propertyValidator('httpPutResponseHopLimit', cdk.validateNumber)(properties.httpPutResponseHopLimit));
    errors.collect(cdk.propertyValidator('httpTokens', cdk.validateString)(properties.httpTokens));
    return errors.wrap('supplied properties not correct for "MetadataOptionsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::LaunchConfiguration.MetadataOptions` resource
 *
 * @param properties - the TypeScript properties of a `MetadataOptionsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::LaunchConfiguration.MetadataOptions` resource.
 */
// @ts-ignore TS6133
function cfnLaunchConfigurationMetadataOptionsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnLaunchConfiguration_MetadataOptionsPropertyValidator(properties).assertSuccess();
    return {
        HttpEndpoint: cdk.stringToCloudFormation(properties.httpEndpoint),
        HttpPutResponseHopLimit: cdk.numberToCloudFormation(properties.httpPutResponseHopLimit),
        HttpTokens: cdk.stringToCloudFormation(properties.httpTokens),
    };
}
// @ts-ignore TS6133
function CfnLaunchConfigurationMetadataOptionsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('httpEndpoint', 'HttpEndpoint', properties.HttpEndpoint != null ? cfn_parse.FromCloudFormation.getString(properties.HttpEndpoint) : undefined);
    ret.addPropertyResult('httpPutResponseHopLimit', 'HttpPutResponseHopLimit', properties.HttpPutResponseHopLimit != null ? cfn_parse.FromCloudFormation.getNumber(properties.HttpPutResponseHopLimit) : undefined);
    ret.addPropertyResult('httpTokens', 'HttpTokens', properties.HttpTokens != null ? cfn_parse.FromCloudFormation.getString(properties.HttpTokens) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnLifecycleHookProps`
 *
 * @param properties - the TypeScript properties of a `CfnLifecycleHookProps`
 *
 * @returns the result of the validation.
 */
function CfnLifecycleHookPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('autoScalingGroupName', cdk.requiredValidator)(properties.autoScalingGroupName));
    errors.collect(cdk.propertyValidator('autoScalingGroupName', cdk.validateString)(properties.autoScalingGroupName));
    errors.collect(cdk.propertyValidator('defaultResult', cdk.validateString)(properties.defaultResult));
    errors.collect(cdk.propertyValidator('heartbeatTimeout', cdk.validateNumber)(properties.heartbeatTimeout));
    errors.collect(cdk.propertyValidator('lifecycleHookName', cdk.validateString)(properties.lifecycleHookName));
    errors.collect(cdk.propertyValidator('lifecycleTransition', cdk.requiredValidator)(properties.lifecycleTransition));
    errors.collect(cdk.propertyValidator('lifecycleTransition', cdk.validateString)(properties.lifecycleTransition));
    errors.collect(cdk.propertyValidator('notificationMetadata', cdk.validateString)(properties.notificationMetadata));
    errors.collect(cdk.propertyValidator('notificationTargetArn', cdk.validateString)(properties.notificationTargetArn));
    errors.collect(cdk.propertyValidator('roleArn', cdk.validateString)(properties.roleArn));
    return errors.wrap('supplied properties not correct for "CfnLifecycleHookProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::LifecycleHook` resource
 *
 * @param properties - the TypeScript properties of a `CfnLifecycleHookProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::LifecycleHook` resource.
 */
// @ts-ignore TS6133
function cfnLifecycleHookPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnLifecycleHookPropsValidator(properties).assertSuccess();
    return {
        AutoScalingGroupName: cdk.stringToCloudFormation(properties.autoScalingGroupName),
        LifecycleTransition: cdk.stringToCloudFormation(properties.lifecycleTransition),
        DefaultResult: cdk.stringToCloudFormation(properties.defaultResult),
        HeartbeatTimeout: cdk.numberToCloudFormation(properties.heartbeatTimeout),
        LifecycleHookName: cdk.stringToCloudFormation(properties.lifecycleHookName),
        NotificationMetadata: cdk.stringToCloudFormation(properties.notificationMetadata),
        NotificationTargetARN: cdk.stringToCloudFormation(properties.notificationTargetArn),
        RoleARN: cdk.stringToCloudFormation(properties.roleArn),
    };
}
// @ts-ignore TS6133
function CfnLifecycleHookPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('autoScalingGroupName', 'AutoScalingGroupName', cfn_parse.FromCloudFormation.getString(properties.AutoScalingGroupName));
    ret.addPropertyResult('lifecycleTransition', 'LifecycleTransition', cfn_parse.FromCloudFormation.getString(properties.LifecycleTransition));
    ret.addPropertyResult('defaultResult', 'DefaultResult', properties.DefaultResult != null ? cfn_parse.FromCloudFormation.getString(properties.DefaultResult) : undefined);
    ret.addPropertyResult('heartbeatTimeout', 'HeartbeatTimeout', properties.HeartbeatTimeout != null ? cfn_parse.FromCloudFormation.getNumber(properties.HeartbeatTimeout) : undefined);
    ret.addPropertyResult('lifecycleHookName', 'LifecycleHookName', properties.LifecycleHookName != null ? cfn_parse.FromCloudFormation.getString(properties.LifecycleHookName) : undefined);
    ret.addPropertyResult('notificationMetadata', 'NotificationMetadata', properties.NotificationMetadata != null ? cfn_parse.FromCloudFormation.getString(properties.NotificationMetadata) : undefined);
    ret.addPropertyResult('notificationTargetArn', 'NotificationTargetARN', properties.NotificationTargetARN != null ? cfn_parse.FromCloudFormation.getString(properties.NotificationTargetARN) : undefined);
    ret.addPropertyResult('roleArn', 'RoleARN', properties.RoleARN != null ? cfn_parse.FromCloudFormation.getString(properties.RoleARN) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::AutoScaling::LifecycleHook`
 *
 * The `AWS::AutoScaling::LifecycleHook` resource specifies lifecycle hooks for an Auto Scaling group. These hooks let you create solutions that are aware of events in the Auto Scaling instance lifecycle, and then perform a custom action on instances when the corresponding lifecycle event occurs. A lifecycle hook provides a specified amount of time (one hour by default) to wait for the action to complete before the instance transitions to the next state.
 *
 * Use lifecycle hooks to prepare new instances for use or to delay them from being registered behind a load balancer before their configuration has been applied completely. You can also use lifecycle hooks to prepare running instances to be terminated by, for example, downloading logs or other data.
 *
 * For more information, see [Amazon EC2 Auto Scaling lifecycle hooks](https://docs.aws.amazon.com/autoscaling/ec2/userguide/lifecycle-hooks.html) in the *Amazon EC2 Auto Scaling User Guide* .
 *
 * @cloudformationResource AWS::AutoScaling::LifecycleHook
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-lifecyclehook.html
 */
class CfnLifecycleHook extends cdk.CfnResource {
    /**
     * Create a new `AWS::AutoScaling::LifecycleHook`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnLifecycleHook.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.monocdk_Construct(scope);
            jsiiDeprecationWarnings.monocdk_aws_autoscaling_CfnLifecycleHookProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnLifecycleHook);
            }
            throw error;
        }
        cdk.requireProperty(props, 'autoScalingGroupName', this);
        cdk.requireProperty(props, 'lifecycleTransition', this);
        this.autoScalingGroupName = props.autoScalingGroupName;
        this.lifecycleTransition = props.lifecycleTransition;
        this.defaultResult = props.defaultResult;
        this.heartbeatTimeout = props.heartbeatTimeout;
        this.lifecycleHookName = props.lifecycleHookName;
        this.notificationMetadata = props.notificationMetadata;
        this.notificationTargetArn = props.notificationTargetArn;
        this.roleArn = props.roleArn;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnLifecycleHookPropsFromCloudFormation(resourceProperties);
        const ret = new CfnLifecycleHook(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.monocdk_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnLifecycleHook.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            autoScalingGroupName: this.autoScalingGroupName,
            lifecycleTransition: this.lifecycleTransition,
            defaultResult: this.defaultResult,
            heartbeatTimeout: this.heartbeatTimeout,
            lifecycleHookName: this.lifecycleHookName,
            notificationMetadata: this.notificationMetadata,
            notificationTargetArn: this.notificationTargetArn,
            roleArn: this.roleArn,
        };
    }
    renderProperties(props) {
        return cfnLifecycleHookPropsToCloudFormation(props);
    }
}
exports.CfnLifecycleHook = CfnLifecycleHook;
_c = JSII_RTTI_SYMBOL_1;
CfnLifecycleHook[_c] = { fqn: "monocdk.aws_autoscaling.CfnLifecycleHook", version: "1.191.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnLifecycleHook.CFN_RESOURCE_TYPE_NAME = "AWS::AutoScaling::LifecycleHook";
/**
 * Determine whether the given properties match those of a `CfnScalingPolicyProps`
 *
 * @param properties - the TypeScript properties of a `CfnScalingPolicyProps`
 *
 * @returns the result of the validation.
 */
function CfnScalingPolicyPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('adjustmentType', cdk.validateString)(properties.adjustmentType));
    errors.collect(cdk.propertyValidator('autoScalingGroupName', cdk.requiredValidator)(properties.autoScalingGroupName));
    errors.collect(cdk.propertyValidator('autoScalingGroupName', cdk.validateString)(properties.autoScalingGroupName));
    errors.collect(cdk.propertyValidator('cooldown', cdk.validateString)(properties.cooldown));
    errors.collect(cdk.propertyValidator('estimatedInstanceWarmup', cdk.validateNumber)(properties.estimatedInstanceWarmup));
    errors.collect(cdk.propertyValidator('metricAggregationType', cdk.validateString)(properties.metricAggregationType));
    errors.collect(cdk.propertyValidator('minAdjustmentMagnitude', cdk.validateNumber)(properties.minAdjustmentMagnitude));
    errors.collect(cdk.propertyValidator('policyType', cdk.validateString)(properties.policyType));
    errors.collect(cdk.propertyValidator('predictiveScalingConfiguration', CfnScalingPolicy_PredictiveScalingConfigurationPropertyValidator)(properties.predictiveScalingConfiguration));
    errors.collect(cdk.propertyValidator('scalingAdjustment', cdk.validateNumber)(properties.scalingAdjustment));
    errors.collect(cdk.propertyValidator('stepAdjustments', cdk.listValidator(CfnScalingPolicy_StepAdjustmentPropertyValidator))(properties.stepAdjustments));
    errors.collect(cdk.propertyValidator('targetTrackingConfiguration', CfnScalingPolicy_TargetTrackingConfigurationPropertyValidator)(properties.targetTrackingConfiguration));
    return errors.wrap('supplied properties not correct for "CfnScalingPolicyProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::ScalingPolicy` resource
 *
 * @param properties - the TypeScript properties of a `CfnScalingPolicyProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::ScalingPolicy` resource.
 */
// @ts-ignore TS6133
function cfnScalingPolicyPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnScalingPolicyPropsValidator(properties).assertSuccess();
    return {
        AutoScalingGroupName: cdk.stringToCloudFormation(properties.autoScalingGroupName),
        AdjustmentType: cdk.stringToCloudFormation(properties.adjustmentType),
        Cooldown: cdk.stringToCloudFormation(properties.cooldown),
        EstimatedInstanceWarmup: cdk.numberToCloudFormation(properties.estimatedInstanceWarmup),
        MetricAggregationType: cdk.stringToCloudFormation(properties.metricAggregationType),
        MinAdjustmentMagnitude: cdk.numberToCloudFormation(properties.minAdjustmentMagnitude),
        PolicyType: cdk.stringToCloudFormation(properties.policyType),
        PredictiveScalingConfiguration: cfnScalingPolicyPredictiveScalingConfigurationPropertyToCloudFormation(properties.predictiveScalingConfiguration),
        ScalingAdjustment: cdk.numberToCloudFormation(properties.scalingAdjustment),
        StepAdjustments: cdk.listMapper(cfnScalingPolicyStepAdjustmentPropertyToCloudFormation)(properties.stepAdjustments),
        TargetTrackingConfiguration: cfnScalingPolicyTargetTrackingConfigurationPropertyToCloudFormation(properties.targetTrackingConfiguration),
    };
}
// @ts-ignore TS6133
function CfnScalingPolicyPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('autoScalingGroupName', 'AutoScalingGroupName', cfn_parse.FromCloudFormation.getString(properties.AutoScalingGroupName));
    ret.addPropertyResult('adjustmentType', 'AdjustmentType', properties.AdjustmentType != null ? cfn_parse.FromCloudFormation.getString(properties.AdjustmentType) : undefined);
    ret.addPropertyResult('cooldown', 'Cooldown', properties.Cooldown != null ? cfn_parse.FromCloudFormation.getString(properties.Cooldown) : undefined);
    ret.addPropertyResult('estimatedInstanceWarmup', 'EstimatedInstanceWarmup', properties.EstimatedInstanceWarmup != null ? cfn_parse.FromCloudFormation.getNumber(properties.EstimatedInstanceWarmup) : undefined);
    ret.addPropertyResult('metricAggregationType', 'MetricAggregationType', properties.MetricAggregationType != null ? cfn_parse.FromCloudFormation.getString(properties.MetricAggregationType) : undefined);
    ret.addPropertyResult('minAdjustmentMagnitude', 'MinAdjustmentMagnitude', properties.MinAdjustmentMagnitude != null ? cfn_parse.FromCloudFormation.getNumber(properties.MinAdjustmentMagnitude) : undefined);
    ret.addPropertyResult('policyType', 'PolicyType', properties.PolicyType != null ? cfn_parse.FromCloudFormation.getString(properties.PolicyType) : undefined);
    ret.addPropertyResult('predictiveScalingConfiguration', 'PredictiveScalingConfiguration', properties.PredictiveScalingConfiguration != null ? CfnScalingPolicyPredictiveScalingConfigurationPropertyFromCloudFormation(properties.PredictiveScalingConfiguration) : undefined);
    ret.addPropertyResult('scalingAdjustment', 'ScalingAdjustment', properties.ScalingAdjustment != null ? cfn_parse.FromCloudFormation.getNumber(properties.ScalingAdjustment) : undefined);
    ret.addPropertyResult('stepAdjustments', 'StepAdjustments', properties.StepAdjustments != null ? cfn_parse.FromCloudFormation.getArray(CfnScalingPolicyStepAdjustmentPropertyFromCloudFormation)(properties.StepAdjustments) : undefined);
    ret.addPropertyResult('targetTrackingConfiguration', 'TargetTrackingConfiguration', properties.TargetTrackingConfiguration != null ? CfnScalingPolicyTargetTrackingConfigurationPropertyFromCloudFormation(properties.TargetTrackingConfiguration) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::AutoScaling::ScalingPolicy`
 *
 * The `AWS::AutoScaling::ScalingPolicy` resource specifies an Amazon EC2 Auto Scaling scaling policy so that the Auto Scaling group can scale the number of instances available for your application.
 *
 * For more information about using scaling policies to scale your Auto Scaling group automatically, see [Dynamic scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scale-based-on-demand.html) and [Predictive scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-predictive-scaling.html) in the *Amazon EC2 Auto Scaling User Guide* .
 *
 * @cloudformationResource AWS::AutoScaling::ScalingPolicy
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-scalingpolicy.html
 */
class CfnScalingPolicy extends cdk.CfnResource {
    /**
     * Create a new `AWS::AutoScaling::ScalingPolicy`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnScalingPolicy.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.monocdk_Construct(scope);
            jsiiDeprecationWarnings.monocdk_aws_autoscaling_CfnScalingPolicyProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnScalingPolicy);
            }
            throw error;
        }
        cdk.requireProperty(props, 'autoScalingGroupName', this);
        this.attrArn = cdk.Token.asString(this.getAtt('Arn'));
        this.attrPolicyName = cdk.Token.asString(this.getAtt('PolicyName'));
        this.autoScalingGroupName = props.autoScalingGroupName;
        this.adjustmentType = props.adjustmentType;
        this.cooldown = props.cooldown;
        this.estimatedInstanceWarmup = props.estimatedInstanceWarmup;
        this.metricAggregationType = props.metricAggregationType;
        this.minAdjustmentMagnitude = props.minAdjustmentMagnitude;
        this.policyType = props.policyType;
        this.predictiveScalingConfiguration = props.predictiveScalingConfiguration;
        this.scalingAdjustment = props.scalingAdjustment;
        this.stepAdjustments = props.stepAdjustments;
        this.targetTrackingConfiguration = props.targetTrackingConfiguration;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnScalingPolicyPropsFromCloudFormation(resourceProperties);
        const ret = new CfnScalingPolicy(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.monocdk_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnScalingPolicy.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            autoScalingGroupName: this.autoScalingGroupName,
            adjustmentType: this.adjustmentType,
            cooldown: this.cooldown,
            estimatedInstanceWarmup: this.estimatedInstanceWarmup,
            metricAggregationType: this.metricAggregationType,
            minAdjustmentMagnitude: this.minAdjustmentMagnitude,
            policyType: this.policyType,
            predictiveScalingConfiguration: this.predictiveScalingConfiguration,
            scalingAdjustment: this.scalingAdjustment,
            stepAdjustments: this.stepAdjustments,
            targetTrackingConfiguration: this.targetTrackingConfiguration,
        };
    }
    renderProperties(props) {
        return cfnScalingPolicyPropsToCloudFormation(props);
    }
}
exports.CfnScalingPolicy = CfnScalingPolicy;
_d = JSII_RTTI_SYMBOL_1;
CfnScalingPolicy[_d] = { fqn: "monocdk.aws_autoscaling.CfnScalingPolicy", version: "1.191.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnScalingPolicy.CFN_RESOURCE_TYPE_NAME = "AWS::AutoScaling::ScalingPolicy";
/**
 * Determine whether the given properties match those of a `CustomizedMetricSpecificationProperty`
 *
 * @param properties - the TypeScript properties of a `CustomizedMetricSpecificationProperty`
 *
 * @returns the result of the validation.
 */
function CfnScalingPolicy_CustomizedMetricSpecificationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('dimensions', cdk.listValidator(CfnScalingPolicy_MetricDimensionPropertyValidator))(properties.dimensions));
    errors.collect(cdk.propertyValidator('metricName', cdk.requiredValidator)(properties.metricName));
    errors.collect(cdk.propertyValidator('metricName', cdk.validateString)(properties.metricName));
    errors.collect(cdk.propertyValidator('namespace', cdk.requiredValidator)(properties.namespace));
    errors.collect(cdk.propertyValidator('namespace', cdk.validateString)(properties.namespace));
    errors.collect(cdk.propertyValidator('statistic', cdk.requiredValidator)(properties.statistic));
    errors.collect(cdk.propertyValidator('statistic', cdk.validateString)(properties.statistic));
    errors.collect(cdk.propertyValidator('unit', cdk.validateString)(properties.unit));
    return errors.wrap('supplied properties not correct for "CustomizedMetricSpecificationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::ScalingPolicy.CustomizedMetricSpecification` resource
 *
 * @param properties - the TypeScript properties of a `CustomizedMetricSpecificationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::ScalingPolicy.CustomizedMetricSpecification` resource.
 */
// @ts-ignore TS6133
function cfnScalingPolicyCustomizedMetricSpecificationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnScalingPolicy_CustomizedMetricSpecificationPropertyValidator(properties).assertSuccess();
    return {
        Dimensions: cdk.listMapper(cfnScalingPolicyMetricDimensionPropertyToCloudFormation)(properties.dimensions),
        MetricName: cdk.stringToCloudFormation(properties.metricName),
        Namespace: cdk.stringToCloudFormation(properties.namespace),
        Statistic: cdk.stringToCloudFormation(properties.statistic),
        Unit: cdk.stringToCloudFormation(properties.unit),
    };
}
// @ts-ignore TS6133
function CfnScalingPolicyCustomizedMetricSpecificationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('dimensions', 'Dimensions', properties.Dimensions != null ? cfn_parse.FromCloudFormation.getArray(CfnScalingPolicyMetricDimensionPropertyFromCloudFormation)(properties.Dimensions) : undefined);
    ret.addPropertyResult('metricName', 'MetricName', cfn_parse.FromCloudFormation.getString(properties.MetricName));
    ret.addPropertyResult('namespace', 'Namespace', cfn_parse.FromCloudFormation.getString(properties.Namespace));
    ret.addPropertyResult('statistic', 'Statistic', cfn_parse.FromCloudFormation.getString(properties.Statistic));
    ret.addPropertyResult('unit', 'Unit', properties.Unit != null ? cfn_parse.FromCloudFormation.getString(properties.Unit) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `MetricProperty`
 *
 * @param properties - the TypeScript properties of a `MetricProperty`
 *
 * @returns the result of the validation.
 */
function CfnScalingPolicy_MetricPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('dimensions', cdk.listValidator(CfnScalingPolicy_MetricDimensionPropertyValidator))(properties.dimensions));
    errors.collect(cdk.propertyValidator('metricName', cdk.requiredValidator)(properties.metricName));
    errors.collect(cdk.propertyValidator('metricName', cdk.validateString)(properties.metricName));
    errors.collect(cdk.propertyValidator('namespace', cdk.requiredValidator)(properties.namespace));
    errors.collect(cdk.propertyValidator('namespace', cdk.validateString)(properties.namespace));
    return errors.wrap('supplied properties not correct for "MetricProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::ScalingPolicy.Metric` resource
 *
 * @param properties - the TypeScript properties of a `MetricProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::ScalingPolicy.Metric` resource.
 */
// @ts-ignore TS6133
function cfnScalingPolicyMetricPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnScalingPolicy_MetricPropertyValidator(properties).assertSuccess();
    return {
        Dimensions: cdk.listMapper(cfnScalingPolicyMetricDimensionPropertyToCloudFormation)(properties.dimensions),
        MetricName: cdk.stringToCloudFormation(properties.metricName),
        Namespace: cdk.stringToCloudFormation(properties.namespace),
    };
}
// @ts-ignore TS6133
function CfnScalingPolicyMetricPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('dimensions', 'Dimensions', properties.Dimensions != null ? cfn_parse.FromCloudFormation.getArray(CfnScalingPolicyMetricDimensionPropertyFromCloudFormation)(properties.Dimensions) : undefined);
    ret.addPropertyResult('metricName', 'MetricName', cfn_parse.FromCloudFormation.getString(properties.MetricName));
    ret.addPropertyResult('namespace', 'Namespace', cfn_parse.FromCloudFormation.getString(properties.Namespace));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `MetricDataQueryProperty`
 *
 * @param properties - the TypeScript properties of a `MetricDataQueryProperty`
 *
 * @returns the result of the validation.
 */
function CfnScalingPolicy_MetricDataQueryPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('expression', cdk.validateString)(properties.expression));
    errors.collect(cdk.propertyValidator('id', cdk.requiredValidator)(properties.id));
    errors.collect(cdk.propertyValidator('id', cdk.validateString)(properties.id));
    errors.collect(cdk.propertyValidator('label', cdk.validateString)(properties.label));
    errors.collect(cdk.propertyValidator('metricStat', CfnScalingPolicy_MetricStatPropertyValidator)(properties.metricStat));
    errors.collect(cdk.propertyValidator('returnData', cdk.validateBoolean)(properties.returnData));
    return errors.wrap('supplied properties not correct for "MetricDataQueryProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::ScalingPolicy.MetricDataQuery` resource
 *
 * @param properties - the TypeScript properties of a `MetricDataQueryProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::ScalingPolicy.MetricDataQuery` resource.
 */
// @ts-ignore TS6133
function cfnScalingPolicyMetricDataQueryPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnScalingPolicy_MetricDataQueryPropertyValidator(properties).assertSuccess();
    return {
        Expression: cdk.stringToCloudFormation(properties.expression),
        Id: cdk.stringToCloudFormation(properties.id),
        Label: cdk.stringToCloudFormation(properties.label),
        MetricStat: cfnScalingPolicyMetricStatPropertyToCloudFormation(properties.metricStat),
        ReturnData: cdk.booleanToCloudFormation(properties.returnData),
    };
}
// @ts-ignore TS6133
function CfnScalingPolicyMetricDataQueryPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('expression', 'Expression', properties.Expression != null ? cfn_parse.FromCloudFormation.getString(properties.Expression) : undefined);
    ret.addPropertyResult('id', 'Id', cfn_parse.FromCloudFormation.getString(properties.Id));
    ret.addPropertyResult('label', 'Label', properties.Label != null ? cfn_parse.FromCloudFormation.getString(properties.Label) : undefined);
    ret.addPropertyResult('metricStat', 'MetricStat', properties.MetricStat != null ? CfnScalingPolicyMetricStatPropertyFromCloudFormation(properties.MetricStat) : undefined);
    ret.addPropertyResult('returnData', 'ReturnData', properties.ReturnData != null ? cfn_parse.FromCloudFormation.getBoolean(properties.ReturnData) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `MetricDimensionProperty`
 *
 * @param properties - the TypeScript properties of a `MetricDimensionProperty`
 *
 * @returns the result of the validation.
 */
function CfnScalingPolicy_MetricDimensionPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('name', cdk.requiredValidator)(properties.name));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('value', cdk.requiredValidator)(properties.value));
    errors.collect(cdk.propertyValidator('value', cdk.validateString)(properties.value));
    return errors.wrap('supplied properties not correct for "MetricDimensionProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::ScalingPolicy.MetricDimension` resource
 *
 * @param properties - the TypeScript properties of a `MetricDimensionProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::ScalingPolicy.MetricDimension` resource.
 */
// @ts-ignore TS6133
function cfnScalingPolicyMetricDimensionPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnScalingPolicy_MetricDimensionPropertyValidator(properties).assertSuccess();
    return {
        Name: cdk.stringToCloudFormation(properties.name),
        Value: cdk.stringToCloudFormation(properties.value),
    };
}
// @ts-ignore TS6133
function CfnScalingPolicyMetricDimensionPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('name', 'Name', cfn_parse.FromCloudFormation.getString(properties.Name));
    ret.addPropertyResult('value', 'Value', cfn_parse.FromCloudFormation.getString(properties.Value));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `MetricStatProperty`
 *
 * @param properties - the TypeScript properties of a `MetricStatProperty`
 *
 * @returns the result of the validation.
 */
function CfnScalingPolicy_MetricStatPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('metric', cdk.requiredValidator)(properties.metric));
    errors.collect(cdk.propertyValidator('metric', CfnScalingPolicy_MetricPropertyValidator)(properties.metric));
    errors.collect(cdk.propertyValidator('stat', cdk.requiredValidator)(properties.stat));
    errors.collect(cdk.propertyValidator('stat', cdk.validateString)(properties.stat));
    errors.collect(cdk.propertyValidator('unit', cdk.validateString)(properties.unit));
    return errors.wrap('supplied properties not correct for "MetricStatProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::ScalingPolicy.MetricStat` resource
 *
 * @param properties - the TypeScript properties of a `MetricStatProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::ScalingPolicy.MetricStat` resource.
 */
// @ts-ignore TS6133
function cfnScalingPolicyMetricStatPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnScalingPolicy_MetricStatPropertyValidator(properties).assertSuccess();
    return {
        Metric: cfnScalingPolicyMetricPropertyToCloudFormation(properties.metric),
        Stat: cdk.stringToCloudFormation(properties.stat),
        Unit: cdk.stringToCloudFormation(properties.unit),
    };
}
// @ts-ignore TS6133
function CfnScalingPolicyMetricStatPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('metric', 'Metric', CfnScalingPolicyMetricPropertyFromCloudFormation(properties.Metric));
    ret.addPropertyResult('stat', 'Stat', cfn_parse.FromCloudFormation.getString(properties.Stat));
    ret.addPropertyResult('unit', 'Unit', properties.Unit != null ? cfn_parse.FromCloudFormation.getString(properties.Unit) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `PredefinedMetricSpecificationProperty`
 *
 * @param properties - the TypeScript properties of a `PredefinedMetricSpecificationProperty`
 *
 * @returns the result of the validation.
 */
function CfnScalingPolicy_PredefinedMetricSpecificationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('predefinedMetricType', cdk.requiredValidator)(properties.predefinedMetricType));
    errors.collect(cdk.propertyValidator('predefinedMetricType', cdk.validateString)(properties.predefinedMetricType));
    errors.collect(cdk.propertyValidator('resourceLabel', cdk.validateString)(properties.resourceLabel));
    return errors.wrap('supplied properties not correct for "PredefinedMetricSpecificationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::ScalingPolicy.PredefinedMetricSpecification` resource
 *
 * @param properties - the TypeScript properties of a `PredefinedMetricSpecificationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::ScalingPolicy.PredefinedMetricSpecification` resource.
 */
// @ts-ignore TS6133
function cfnScalingPolicyPredefinedMetricSpecificationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnScalingPolicy_PredefinedMetricSpecificationPropertyValidator(properties).assertSuccess();
    return {
        PredefinedMetricType: cdk.stringToCloudFormation(properties.predefinedMetricType),
        ResourceLabel: cdk.stringToCloudFormation(properties.resourceLabel),
    };
}
// @ts-ignore TS6133
function CfnScalingPolicyPredefinedMetricSpecificationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('predefinedMetricType', 'PredefinedMetricType', cfn_parse.FromCloudFormation.getString(properties.PredefinedMetricType));
    ret.addPropertyResult('resourceLabel', 'ResourceLabel', properties.ResourceLabel != null ? cfn_parse.FromCloudFormation.getString(properties.ResourceLabel) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `PredictiveScalingConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `PredictiveScalingConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnScalingPolicy_PredictiveScalingConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('maxCapacityBreachBehavior', cdk.validateString)(properties.maxCapacityBreachBehavior));
    errors.collect(cdk.propertyValidator('maxCapacityBuffer', cdk.validateNumber)(properties.maxCapacityBuffer));
    errors.collect(cdk.propertyValidator('metricSpecifications', cdk.requiredValidator)(properties.metricSpecifications));
    errors.collect(cdk.propertyValidator('metricSpecifications', cdk.listValidator(CfnScalingPolicy_PredictiveScalingMetricSpecificationPropertyValidator))(properties.metricSpecifications));
    errors.collect(cdk.propertyValidator('mode', cdk.validateString)(properties.mode));
    errors.collect(cdk.propertyValidator('schedulingBufferTime', cdk.validateNumber)(properties.schedulingBufferTime));
    return errors.wrap('supplied properties not correct for "PredictiveScalingConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::ScalingPolicy.PredictiveScalingConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `PredictiveScalingConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::ScalingPolicy.PredictiveScalingConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnScalingPolicyPredictiveScalingConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnScalingPolicy_PredictiveScalingConfigurationPropertyValidator(properties).assertSuccess();
    return {
        MaxCapacityBreachBehavior: cdk.stringToCloudFormation(properties.maxCapacityBreachBehavior),
        MaxCapacityBuffer: cdk.numberToCloudFormation(properties.maxCapacityBuffer),
        MetricSpecifications: cdk.listMapper(cfnScalingPolicyPredictiveScalingMetricSpecificationPropertyToCloudFormation)(properties.metricSpecifications),
        Mode: cdk.stringToCloudFormation(properties.mode),
        SchedulingBufferTime: cdk.numberToCloudFormation(properties.schedulingBufferTime),
    };
}
// @ts-ignore TS6133
function CfnScalingPolicyPredictiveScalingConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('maxCapacityBreachBehavior', 'MaxCapacityBreachBehavior', properties.MaxCapacityBreachBehavior != null ? cfn_parse.FromCloudFormation.getString(properties.MaxCapacityBreachBehavior) : undefined);
    ret.addPropertyResult('maxCapacityBuffer', 'MaxCapacityBuffer', properties.MaxCapacityBuffer != null ? cfn_parse.FromCloudFormation.getNumber(properties.MaxCapacityBuffer) : undefined);
    ret.addPropertyResult('metricSpecifications', 'MetricSpecifications', cfn_parse.FromCloudFormation.getArray(CfnScalingPolicyPredictiveScalingMetricSpecificationPropertyFromCloudFormation)(properties.MetricSpecifications));
    ret.addPropertyResult('mode', 'Mode', properties.Mode != null ? cfn_parse.FromCloudFormation.getString(properties.Mode) : undefined);
    ret.addPropertyResult('schedulingBufferTime', 'SchedulingBufferTime', properties.SchedulingBufferTime != null ? cfn_parse.FromCloudFormation.getNumber(properties.SchedulingBufferTime) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `PredictiveScalingCustomizedCapacityMetricProperty`
 *
 * @param properties - the TypeScript properties of a `PredictiveScalingCustomizedCapacityMetricProperty`
 *
 * @returns the result of the validation.
 */
function CfnScalingPolicy_PredictiveScalingCustomizedCapacityMetricPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('metricDataQueries', cdk.requiredValidator)(properties.metricDataQueries));
    errors.collect(cdk.propertyValidator('metricDataQueries', cdk.listValidator(CfnScalingPolicy_MetricDataQueryPropertyValidator))(properties.metricDataQueries));
    return errors.wrap('supplied properties not correct for "PredictiveScalingCustomizedCapacityMetricProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::ScalingPolicy.PredictiveScalingCustomizedCapacityMetric` resource
 *
 * @param properties - the TypeScript properties of a `PredictiveScalingCustomizedCapacityMetricProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::ScalingPolicy.PredictiveScalingCustomizedCapacityMetric` resource.
 */
// @ts-ignore TS6133
function cfnScalingPolicyPredictiveScalingCustomizedCapacityMetricPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnScalingPolicy_PredictiveScalingCustomizedCapacityMetricPropertyValidator(properties).assertSuccess();
    return {
        MetricDataQueries: cdk.listMapper(cfnScalingPolicyMetricDataQueryPropertyToCloudFormation)(properties.metricDataQueries),
    };
}
// @ts-ignore TS6133
function CfnScalingPolicyPredictiveScalingCustomizedCapacityMetricPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('metricDataQueries', 'MetricDataQueries', cfn_parse.FromCloudFormation.getArray(CfnScalingPolicyMetricDataQueryPropertyFromCloudFormation)(properties.MetricDataQueries));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `PredictiveScalingCustomizedLoadMetricProperty`
 *
 * @param properties - the TypeScript properties of a `PredictiveScalingCustomizedLoadMetricProperty`
 *
 * @returns the result of the validation.
 */
function CfnScalingPolicy_PredictiveScalingCustomizedLoadMetricPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('metricDataQueries', cdk.requiredValidator)(properties.metricDataQueries));
    errors.collect(cdk.propertyValidator('metricDataQueries', cdk.listValidator(CfnScalingPolicy_MetricDataQueryPropertyValidator))(properties.metricDataQueries));
    return errors.wrap('supplied properties not correct for "PredictiveScalingCustomizedLoadMetricProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::ScalingPolicy.PredictiveScalingCustomizedLoadMetric` resource
 *
 * @param properties - the TypeScript properties of a `PredictiveScalingCustomizedLoadMetricProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::ScalingPolicy.PredictiveScalingCustomizedLoadMetric` resource.
 */
// @ts-ignore TS6133
function cfnScalingPolicyPredictiveScalingCustomizedLoadMetricPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnScalingPolicy_PredictiveScalingCustomizedLoadMetricPropertyValidator(properties).assertSuccess();
    return {
        MetricDataQueries: cdk.listMapper(cfnScalingPolicyMetricDataQueryPropertyToCloudFormation)(properties.metricDataQueries),
    };
}
// @ts-ignore TS6133
function CfnScalingPolicyPredictiveScalingCustomizedLoadMetricPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('metricDataQueries', 'MetricDataQueries', cfn_parse.FromCloudFormation.getArray(CfnScalingPolicyMetricDataQueryPropertyFromCloudFormation)(properties.MetricDataQueries));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `PredictiveScalingCustomizedScalingMetricProperty`
 *
 * @param properties - the TypeScript properties of a `PredictiveScalingCustomizedScalingMetricProperty`
 *
 * @returns the result of the validation.
 */
function CfnScalingPolicy_PredictiveScalingCustomizedScalingMetricPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('metricDataQueries', cdk.requiredValidator)(properties.metricDataQueries));
    errors.collect(cdk.propertyValidator('metricDataQueries', cdk.listValidator(CfnScalingPolicy_MetricDataQueryPropertyValidator))(properties.metricDataQueries));
    return errors.wrap('supplied properties not correct for "PredictiveScalingCustomizedScalingMetricProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::ScalingPolicy.PredictiveScalingCustomizedScalingMetric` resource
 *
 * @param properties - the TypeScript properties of a `PredictiveScalingCustomizedScalingMetricProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::ScalingPolicy.PredictiveScalingCustomizedScalingMetric` resource.
 */
// @ts-ignore TS6133
function cfnScalingPolicyPredictiveScalingCustomizedScalingMetricPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnScalingPolicy_PredictiveScalingCustomizedScalingMetricPropertyValidator(properties).assertSuccess();
    return {
        MetricDataQueries: cdk.listMapper(cfnScalingPolicyMetricDataQueryPropertyToCloudFormation)(properties.metricDataQueries),
    };
}
// @ts-ignore TS6133
function CfnScalingPolicyPredictiveScalingCustomizedScalingMetricPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('metricDataQueries', 'MetricDataQueries', cfn_parse.FromCloudFormation.getArray(CfnScalingPolicyMetricDataQueryPropertyFromCloudFormation)(properties.MetricDataQueries));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `PredictiveScalingMetricSpecificationProperty`
 *
 * @param properties - the TypeScript properties of a `PredictiveScalingMetricSpecificationProperty`
 *
 * @returns the result of the validation.
 */
function CfnScalingPolicy_PredictiveScalingMetricSpecificationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('customizedCapacityMetricSpecification', CfnScalingPolicy_PredictiveScalingCustomizedCapacityMetricPropertyValidator)(properties.customizedCapacityMetricSpecification));
    errors.collect(cdk.propertyValidator('customizedLoadMetricSpecification', CfnScalingPolicy_PredictiveScalingCustomizedLoadMetricPropertyValidator)(properties.customizedLoadMetricSpecification));
    errors.collect(cdk.propertyValidator('customizedScalingMetricSpecification', CfnScalingPolicy_PredictiveScalingCustomizedScalingMetricPropertyValidator)(properties.customizedScalingMetricSpecification));
    errors.collect(cdk.propertyValidator('predefinedLoadMetricSpecification', CfnScalingPolicy_PredictiveScalingPredefinedLoadMetricPropertyValidator)(properties.predefinedLoadMetricSpecification));
    errors.collect(cdk.propertyValidator('predefinedMetricPairSpecification', CfnScalingPolicy_PredictiveScalingPredefinedMetricPairPropertyValidator)(properties.predefinedMetricPairSpecification));
    errors.collect(cdk.propertyValidator('predefinedScalingMetricSpecification', CfnScalingPolicy_PredictiveScalingPredefinedScalingMetricPropertyValidator)(properties.predefinedScalingMetricSpecification));
    errors.collect(cdk.propertyValidator('targetValue', cdk.requiredValidator)(properties.targetValue));
    errors.collect(cdk.propertyValidator('targetValue', cdk.validateNumber)(properties.targetValue));
    return errors.wrap('supplied properties not correct for "PredictiveScalingMetricSpecificationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::ScalingPolicy.PredictiveScalingMetricSpecification` resource
 *
 * @param properties - the TypeScript properties of a `PredictiveScalingMetricSpecificationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::ScalingPolicy.PredictiveScalingMetricSpecification` resource.
 */
// @ts-ignore TS6133
function cfnScalingPolicyPredictiveScalingMetricSpecificationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnScalingPolicy_PredictiveScalingMetricSpecificationPropertyValidator(properties).assertSuccess();
    return {
        CustomizedCapacityMetricSpecification: cfnScalingPolicyPredictiveScalingCustomizedCapacityMetricPropertyToCloudFormation(properties.customizedCapacityMetricSpecification),
        CustomizedLoadMetricSpecification: cfnScalingPolicyPredictiveScalingCustomizedLoadMetricPropertyToCloudFormation(properties.customizedLoadMetricSpecification),
        CustomizedScalingMetricSpecification: cfnScalingPolicyPredictiveScalingCustomizedScalingMetricPropertyToCloudFormation(properties.customizedScalingMetricSpecification),
        PredefinedLoadMetricSpecification: cfnScalingPolicyPredictiveScalingPredefinedLoadMetricPropertyToCloudFormation(properties.predefinedLoadMetricSpecification),
        PredefinedMetricPairSpecification: cfnScalingPolicyPredictiveScalingPredefinedMetricPairPropertyToCloudFormation(properties.predefinedMetricPairSpecification),
        PredefinedScalingMetricSpecification: cfnScalingPolicyPredictiveScalingPredefinedScalingMetricPropertyToCloudFormation(properties.predefinedScalingMetricSpecification),
        TargetValue: cdk.numberToCloudFormation(properties.targetValue),
    };
}
// @ts-ignore TS6133
function CfnScalingPolicyPredictiveScalingMetricSpecificationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('customizedCapacityMetricSpecification', 'CustomizedCapacityMetricSpecification', properties.CustomizedCapacityMetricSpecification != null ? CfnScalingPolicyPredictiveScalingCustomizedCapacityMetricPropertyFromCloudFormation(properties.CustomizedCapacityMetricSpecification) : undefined);
    ret.addPropertyResult('customizedLoadMetricSpecification', 'CustomizedLoadMetricSpecification', properties.CustomizedLoadMetricSpecification != null ? CfnScalingPolicyPredictiveScalingCustomizedLoadMetricPropertyFromCloudFormation(properties.CustomizedLoadMetricSpecification) : undefined);
    ret.addPropertyResult('customizedScalingMetricSpecification', 'CustomizedScalingMetricSpecification', properties.CustomizedScalingMetricSpecification != null ? CfnScalingPolicyPredictiveScalingCustomizedScalingMetricPropertyFromCloudFormation(properties.CustomizedScalingMetricSpecification) : undefined);
    ret.addPropertyResult('predefinedLoadMetricSpecification', 'PredefinedLoadMetricSpecification', properties.PredefinedLoadMetricSpecification != null ? CfnScalingPolicyPredictiveScalingPredefinedLoadMetricPropertyFromCloudFormation(properties.PredefinedLoadMetricSpecification) : undefined);
    ret.addPropertyResult('predefinedMetricPairSpecification', 'PredefinedMetricPairSpecification', properties.PredefinedMetricPairSpecification != null ? CfnScalingPolicyPredictiveScalingPredefinedMetricPairPropertyFromCloudFormation(properties.PredefinedMetricPairSpecification) : undefined);
    ret.addPropertyResult('predefinedScalingMetricSpecification', 'PredefinedScalingMetricSpecification', properties.PredefinedScalingMetricSpecification != null ? CfnScalingPolicyPredictiveScalingPredefinedScalingMetricPropertyFromCloudFormation(properties.PredefinedScalingMetricSpecification) : undefined);
    ret.addPropertyResult('targetValue', 'TargetValue', cfn_parse.FromCloudFormation.getNumber(properties.TargetValue));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `PredictiveScalingPredefinedLoadMetricProperty`
 *
 * @param properties - the TypeScript properties of a `PredictiveScalingPredefinedLoadMetricProperty`
 *
 * @returns the result of the validation.
 */
function CfnScalingPolicy_PredictiveScalingPredefinedLoadMetricPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('predefinedMetricType', cdk.requiredValidator)(properties.predefinedMetricType));
    errors.collect(cdk.propertyValidator('predefinedMetricType', cdk.validateString)(properties.predefinedMetricType));
    errors.collect(cdk.propertyValidator('resourceLabel', cdk.validateString)(properties.resourceLabel));
    return errors.wrap('supplied properties not correct for "PredictiveScalingPredefinedLoadMetricProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::ScalingPolicy.PredictiveScalingPredefinedLoadMetric` resource
 *
 * @param properties - the TypeScript properties of a `PredictiveScalingPredefinedLoadMetricProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::ScalingPolicy.PredictiveScalingPredefinedLoadMetric` resource.
 */
// @ts-ignore TS6133
function cfnScalingPolicyPredictiveScalingPredefinedLoadMetricPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnScalingPolicy_PredictiveScalingPredefinedLoadMetricPropertyValidator(properties).assertSuccess();
    return {
        PredefinedMetricType: cdk.stringToCloudFormation(properties.predefinedMetricType),
        ResourceLabel: cdk.stringToCloudFormation(properties.resourceLabel),
    };
}
// @ts-ignore TS6133
function CfnScalingPolicyPredictiveScalingPredefinedLoadMetricPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('predefinedMetricType', 'PredefinedMetricType', cfn_parse.FromCloudFormation.getString(properties.PredefinedMetricType));
    ret.addPropertyResult('resourceLabel', 'ResourceLabel', properties.ResourceLabel != null ? cfn_parse.FromCloudFormation.getString(properties.ResourceLabel) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `PredictiveScalingPredefinedMetricPairProperty`
 *
 * @param properties - the TypeScript properties of a `PredictiveScalingPredefinedMetricPairProperty`
 *
 * @returns the result of the validation.
 */
function CfnScalingPolicy_PredictiveScalingPredefinedMetricPairPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('predefinedMetricType', cdk.requiredValidator)(properties.predefinedMetricType));
    errors.collect(cdk.propertyValidator('predefinedMetricType', cdk.validateString)(properties.predefinedMetricType));
    errors.collect(cdk.propertyValidator('resourceLabel', cdk.validateString)(properties.resourceLabel));
    return errors.wrap('supplied properties not correct for "PredictiveScalingPredefinedMetricPairProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::ScalingPolicy.PredictiveScalingPredefinedMetricPair` resource
 *
 * @param properties - the TypeScript properties of a `PredictiveScalingPredefinedMetricPairProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::ScalingPolicy.PredictiveScalingPredefinedMetricPair` resource.
 */
// @ts-ignore TS6133
function cfnScalingPolicyPredictiveScalingPredefinedMetricPairPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnScalingPolicy_PredictiveScalingPredefinedMetricPairPropertyValidator(properties).assertSuccess();
    return {
        PredefinedMetricType: cdk.stringToCloudFormation(properties.predefinedMetricType),
        ResourceLabel: cdk.stringToCloudFormation(properties.resourceLabel),
    };
}
// @ts-ignore TS6133
function CfnScalingPolicyPredictiveScalingPredefinedMetricPairPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('predefinedMetricType', 'PredefinedMetricType', cfn_parse.FromCloudFormation.getString(properties.PredefinedMetricType));
    ret.addPropertyResult('resourceLabel', 'ResourceLabel', properties.ResourceLabel != null ? cfn_parse.FromCloudFormation.getString(properties.ResourceLabel) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `PredictiveScalingPredefinedScalingMetricProperty`
 *
 * @param properties - the TypeScript properties of a `PredictiveScalingPredefinedScalingMetricProperty`
 *
 * @returns the result of the validation.
 */
function CfnScalingPolicy_PredictiveScalingPredefinedScalingMetricPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('predefinedMetricType', cdk.requiredValidator)(properties.predefinedMetricType));
    errors.collect(cdk.propertyValidator('predefinedMetricType', cdk.validateString)(properties.predefinedMetricType));
    errors.collect(cdk.propertyValidator('resourceLabel', cdk.validateString)(properties.resourceLabel));
    return errors.wrap('supplied properties not correct for "PredictiveScalingPredefinedScalingMetricProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::ScalingPolicy.PredictiveScalingPredefinedScalingMetric` resource
 *
 * @param properties - the TypeScript properties of a `PredictiveScalingPredefinedScalingMetricProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::ScalingPolicy.PredictiveScalingPredefinedScalingMetric` resource.
 */
// @ts-ignore TS6133
function cfnScalingPolicyPredictiveScalingPredefinedScalingMetricPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnScalingPolicy_PredictiveScalingPredefinedScalingMetricPropertyValidator(properties).assertSuccess();
    return {
        PredefinedMetricType: cdk.stringToCloudFormation(properties.predefinedMetricType),
        ResourceLabel: cdk.stringToCloudFormation(properties.resourceLabel),
    };
}
// @ts-ignore TS6133
function CfnScalingPolicyPredictiveScalingPredefinedScalingMetricPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('predefinedMetricType', 'PredefinedMetricType', cfn_parse.FromCloudFormation.getString(properties.PredefinedMetricType));
    ret.addPropertyResult('resourceLabel', 'ResourceLabel', properties.ResourceLabel != null ? cfn_parse.FromCloudFormation.getString(properties.ResourceLabel) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `StepAdjustmentProperty`
 *
 * @param properties - the TypeScript properties of a `StepAdjustmentProperty`
 *
 * @returns the result of the validation.
 */
function CfnScalingPolicy_StepAdjustmentPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('metricIntervalLowerBound', cdk.validateNumber)(properties.metricIntervalLowerBound));
    errors.collect(cdk.propertyValidator('metricIntervalUpperBound', cdk.validateNumber)(properties.metricIntervalUpperBound));
    errors.collect(cdk.propertyValidator('scalingAdjustment', cdk.requiredValidator)(properties.scalingAdjustment));
    errors.collect(cdk.propertyValidator('scalingAdjustment', cdk.validateNumber)(properties.scalingAdjustment));
    return errors.wrap('supplied properties not correct for "StepAdjustmentProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::ScalingPolicy.StepAdjustment` resource
 *
 * @param properties - the TypeScript properties of a `StepAdjustmentProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::ScalingPolicy.StepAdjustment` resource.
 */
// @ts-ignore TS6133
function cfnScalingPolicyStepAdjustmentPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnScalingPolicy_StepAdjustmentPropertyValidator(properties).assertSuccess();
    return {
        MetricIntervalLowerBound: cdk.numberToCloudFormation(properties.metricIntervalLowerBound),
        MetricIntervalUpperBound: cdk.numberToCloudFormation(properties.metricIntervalUpperBound),
        ScalingAdjustment: cdk.numberToCloudFormation(properties.scalingAdjustment),
    };
}
// @ts-ignore TS6133
function CfnScalingPolicyStepAdjustmentPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('metricIntervalLowerBound', 'MetricIntervalLowerBound', properties.MetricIntervalLowerBound != null ? cfn_parse.FromCloudFormation.getNumber(properties.MetricIntervalLowerBound) : undefined);
    ret.addPropertyResult('metricIntervalUpperBound', 'MetricIntervalUpperBound', properties.MetricIntervalUpperBound != null ? cfn_parse.FromCloudFormation.getNumber(properties.MetricIntervalUpperBound) : undefined);
    ret.addPropertyResult('scalingAdjustment', 'ScalingAdjustment', cfn_parse.FromCloudFormation.getNumber(properties.ScalingAdjustment));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `TargetTrackingConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `TargetTrackingConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnScalingPolicy_TargetTrackingConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('customizedMetricSpecification', CfnScalingPolicy_CustomizedMetricSpecificationPropertyValidator)(properties.customizedMetricSpecification));
    errors.collect(cdk.propertyValidator('disableScaleIn', cdk.validateBoolean)(properties.disableScaleIn));
    errors.collect(cdk.propertyValidator('predefinedMetricSpecification', CfnScalingPolicy_PredefinedMetricSpecificationPropertyValidator)(properties.predefinedMetricSpecification));
    errors.collect(cdk.propertyValidator('targetValue', cdk.requiredValidator)(properties.targetValue));
    errors.collect(cdk.propertyValidator('targetValue', cdk.validateNumber)(properties.targetValue));
    return errors.wrap('supplied properties not correct for "TargetTrackingConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::ScalingPolicy.TargetTrackingConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `TargetTrackingConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::ScalingPolicy.TargetTrackingConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnScalingPolicyTargetTrackingConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnScalingPolicy_TargetTrackingConfigurationPropertyValidator(properties).assertSuccess();
    return {
        CustomizedMetricSpecification: cfnScalingPolicyCustomizedMetricSpecificationPropertyToCloudFormation(properties.customizedMetricSpecification),
        DisableScaleIn: cdk.booleanToCloudFormation(properties.disableScaleIn),
        PredefinedMetricSpecification: cfnScalingPolicyPredefinedMetricSpecificationPropertyToCloudFormation(properties.predefinedMetricSpecification),
        TargetValue: cdk.numberToCloudFormation(properties.targetValue),
    };
}
// @ts-ignore TS6133
function CfnScalingPolicyTargetTrackingConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('customizedMetricSpecification', 'CustomizedMetricSpecification', properties.CustomizedMetricSpecification != null ? CfnScalingPolicyCustomizedMetricSpecificationPropertyFromCloudFormation(properties.CustomizedMetricSpecification) : undefined);
    ret.addPropertyResult('disableScaleIn', 'DisableScaleIn', properties.DisableScaleIn != null ? cfn_parse.FromCloudFormation.getBoolean(properties.DisableScaleIn) : undefined);
    ret.addPropertyResult('predefinedMetricSpecification', 'PredefinedMetricSpecification', properties.PredefinedMetricSpecification != null ? CfnScalingPolicyPredefinedMetricSpecificationPropertyFromCloudFormation(properties.PredefinedMetricSpecification) : undefined);
    ret.addPropertyResult('targetValue', 'TargetValue', cfn_parse.FromCloudFormation.getNumber(properties.TargetValue));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnScheduledActionProps`
 *
 * @param properties - the TypeScript properties of a `CfnScheduledActionProps`
 *
 * @returns the result of the validation.
 */
function CfnScheduledActionPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('autoScalingGroupName', cdk.requiredValidator)(properties.autoScalingGroupName));
    errors.collect(cdk.propertyValidator('autoScalingGroupName', cdk.validateString)(properties.autoScalingGroupName));
    errors.collect(cdk.propertyValidator('desiredCapacity', cdk.validateNumber)(properties.desiredCapacity));
    errors.collect(cdk.propertyValidator('endTime', cdk.validateString)(properties.endTime));
    errors.collect(cdk.propertyValidator('maxSize', cdk.validateNumber)(properties.maxSize));
    errors.collect(cdk.propertyValidator('minSize', cdk.validateNumber)(properties.minSize));
    errors.collect(cdk.propertyValidator('recurrence', cdk.validateString)(properties.recurrence));
    errors.collect(cdk.propertyValidator('startTime', cdk.validateString)(properties.startTime));
    errors.collect(cdk.propertyValidator('timeZone', cdk.validateString)(properties.timeZone));
    return errors.wrap('supplied properties not correct for "CfnScheduledActionProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::ScheduledAction` resource
 *
 * @param properties - the TypeScript properties of a `CfnScheduledActionProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::ScheduledAction` resource.
 */
// @ts-ignore TS6133
function cfnScheduledActionPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnScheduledActionPropsValidator(properties).assertSuccess();
    return {
        AutoScalingGroupName: cdk.stringToCloudFormation(properties.autoScalingGroupName),
        DesiredCapacity: cdk.numberToCloudFormation(properties.desiredCapacity),
        EndTime: cdk.stringToCloudFormation(properties.endTime),
        MaxSize: cdk.numberToCloudFormation(properties.maxSize),
        MinSize: cdk.numberToCloudFormation(properties.minSize),
        Recurrence: cdk.stringToCloudFormation(properties.recurrence),
        StartTime: cdk.stringToCloudFormation(properties.startTime),
        TimeZone: cdk.stringToCloudFormation(properties.timeZone),
    };
}
// @ts-ignore TS6133
function CfnScheduledActionPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('autoScalingGroupName', 'AutoScalingGroupName', cfn_parse.FromCloudFormation.getString(properties.AutoScalingGroupName));
    ret.addPropertyResult('desiredCapacity', 'DesiredCapacity', properties.DesiredCapacity != null ? cfn_parse.FromCloudFormation.getNumber(properties.DesiredCapacity) : undefined);
    ret.addPropertyResult('endTime', 'EndTime', properties.EndTime != null ? cfn_parse.FromCloudFormation.getString(properties.EndTime) : undefined);
    ret.addPropertyResult('maxSize', 'MaxSize', properties.MaxSize != null ? cfn_parse.FromCloudFormation.getNumber(properties.MaxSize) : undefined);
    ret.addPropertyResult('minSize', 'MinSize', properties.MinSize != null ? cfn_parse.FromCloudFormation.getNumber(properties.MinSize) : undefined);
    ret.addPropertyResult('recurrence', 'Recurrence', properties.Recurrence != null ? cfn_parse.FromCloudFormation.getString(properties.Recurrence) : undefined);
    ret.addPropertyResult('startTime', 'StartTime', properties.StartTime != null ? cfn_parse.FromCloudFormation.getString(properties.StartTime) : undefined);
    ret.addPropertyResult('timeZone', 'TimeZone', properties.TimeZone != null ? cfn_parse.FromCloudFormation.getString(properties.TimeZone) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::AutoScaling::ScheduledAction`
 *
 * The `AWS::AutoScaling::ScheduledAction` resource specifies an Amazon EC2 Auto Scaling scheduled action so that the Auto Scaling group can change the number of instances available for your application in response to predictable load changes.
 *
 * When you update a stack with an Auto Scaling group and scheduled action, CloudFormation always sets the min size, max size, and desired capacity properties of your group to the values that are defined in the `AWS::AutoScaling::AutoScalingGroup` section of your template. However, you might not want CloudFormation to do that when you have a scheduled action in effect. You can use an [UpdatePolicy attribute](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-updatepolicy.html) to prevent CloudFormation from changing the min size, max size, or desired capacity property values during a stack update unless you modified the individual values in your template. If you have rolling updates enabled, before you can update the Auto Scaling group, you must suspend scheduled actions by specifying an [UpdatePolicy attribute](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-updatepolicy.html) for the Auto Scaling group. You can find a sample update policy for rolling updates in [Auto scaling template snippets](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/quickref-autoscaling.html) .
 *
 * For more information, see [Scheduled scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/schedule_time.html) and [Suspending and resuming scaling processes](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-suspend-resume-processes.html) in the *Amazon EC2 Auto Scaling User Guide* .
 *
 * @cloudformationResource AWS::AutoScaling::ScheduledAction
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-scheduledaction.html
 */
class CfnScheduledAction extends cdk.CfnResource {
    /**
     * Create a new `AWS::AutoScaling::ScheduledAction`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnScheduledAction.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.monocdk_Construct(scope);
            jsiiDeprecationWarnings.monocdk_aws_autoscaling_CfnScheduledActionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnScheduledAction);
            }
            throw error;
        }
        cdk.requireProperty(props, 'autoScalingGroupName', this);
        this.attrScheduledActionName = cdk.Token.asString(this.getAtt('ScheduledActionName'));
        this.autoScalingGroupName = props.autoScalingGroupName;
        this.desiredCapacity = props.desiredCapacity;
        this.endTime = props.endTime;
        this.maxSize = props.maxSize;
        this.minSize = props.minSize;
        this.recurrence = props.recurrence;
        this.startTime = props.startTime;
        this.timeZone = props.timeZone;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnScheduledActionPropsFromCloudFormation(resourceProperties);
        const ret = new CfnScheduledAction(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.monocdk_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnScheduledAction.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            autoScalingGroupName: this.autoScalingGroupName,
            desiredCapacity: this.desiredCapacity,
            endTime: this.endTime,
            maxSize: this.maxSize,
            minSize: this.minSize,
            recurrence: this.recurrence,
            startTime: this.startTime,
            timeZone: this.timeZone,
        };
    }
    renderProperties(props) {
        return cfnScheduledActionPropsToCloudFormation(props);
    }
}
exports.CfnScheduledAction = CfnScheduledAction;
_e = JSII_RTTI_SYMBOL_1;
CfnScheduledAction[_e] = { fqn: "monocdk.aws_autoscaling.CfnScheduledAction", version: "1.191.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnScheduledAction.CFN_RESOURCE_TYPE_NAME = "AWS::AutoScaling::ScheduledAction";
/**
 * Determine whether the given properties match those of a `CfnWarmPoolProps`
 *
 * @param properties - the TypeScript properties of a `CfnWarmPoolProps`
 *
 * @returns the result of the validation.
 */
function CfnWarmPoolPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('autoScalingGroupName', cdk.requiredValidator)(properties.autoScalingGroupName));
    errors.collect(cdk.propertyValidator('autoScalingGroupName', cdk.validateString)(properties.autoScalingGroupName));
    errors.collect(cdk.propertyValidator('instanceReusePolicy', CfnWarmPool_InstanceReusePolicyPropertyValidator)(properties.instanceReusePolicy));
    errors.collect(cdk.propertyValidator('maxGroupPreparedCapacity', cdk.validateNumber)(properties.maxGroupPreparedCapacity));
    errors.collect(cdk.propertyValidator('minSize', cdk.validateNumber)(properties.minSize));
    errors.collect(cdk.propertyValidator('poolState', cdk.validateString)(properties.poolState));
    return errors.wrap('supplied properties not correct for "CfnWarmPoolProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::WarmPool` resource
 *
 * @param properties - the TypeScript properties of a `CfnWarmPoolProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::WarmPool` resource.
 */
// @ts-ignore TS6133
function cfnWarmPoolPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnWarmPoolPropsValidator(properties).assertSuccess();
    return {
        AutoScalingGroupName: cdk.stringToCloudFormation(properties.autoScalingGroupName),
        InstanceReusePolicy: cfnWarmPoolInstanceReusePolicyPropertyToCloudFormation(properties.instanceReusePolicy),
        MaxGroupPreparedCapacity: cdk.numberToCloudFormation(properties.maxGroupPreparedCapacity),
        MinSize: cdk.numberToCloudFormation(properties.minSize),
        PoolState: cdk.stringToCloudFormation(properties.poolState),
    };
}
// @ts-ignore TS6133
function CfnWarmPoolPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('autoScalingGroupName', 'AutoScalingGroupName', cfn_parse.FromCloudFormation.getString(properties.AutoScalingGroupName));
    ret.addPropertyResult('instanceReusePolicy', 'InstanceReusePolicy', properties.InstanceReusePolicy != null ? CfnWarmPoolInstanceReusePolicyPropertyFromCloudFormation(properties.InstanceReusePolicy) : undefined);
    ret.addPropertyResult('maxGroupPreparedCapacity', 'MaxGroupPreparedCapacity', properties.MaxGroupPreparedCapacity != null ? cfn_parse.FromCloudFormation.getNumber(properties.MaxGroupPreparedCapacity) : undefined);
    ret.addPropertyResult('minSize', 'MinSize', properties.MinSize != null ? cfn_parse.FromCloudFormation.getNumber(properties.MinSize) : undefined);
    ret.addPropertyResult('poolState', 'PoolState', properties.PoolState != null ? cfn_parse.FromCloudFormation.getString(properties.PoolState) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::AutoScaling::WarmPool`
 *
 * The `AWS::AutoScaling::WarmPool` resource creates a pool of pre-initialized EC2 instances that sits alongside the Auto Scaling group. Whenever your application needs to scale out, the Auto Scaling group can draw on the warm pool to meet its new desired capacity.
 *
 * When you create a warm pool, you can define a minimum size. When your Auto Scaling group scales out and the size of the warm pool shrinks, Amazon EC2 Auto Scaling launches new instances into the warm pool to maintain its minimum size.
 *
 * For more information, see [Warm pools for Amazon EC2 Auto Scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-warm-pools.html) in the *Amazon EC2 Auto Scaling User Guide* .
 *
 * > CloudFormation supports the `UpdatePolicy` attribute for Auto Scaling groups. During an update, if `UpdatePolicy` is set to `AutoScalingRollingUpdate` , CloudFormation replaces `InService` instances only. Instances in the warm pool are not replaced. The difference in which instances are replaced can potentially result in different instance configurations after the stack update completes. If `UpdatePolicy` is set to `AutoScalingReplacingUpdate` , you do not encounter this issue because CloudFormation replaces both the Auto Scaling group and the warm pool.
 *
 * @cloudformationResource AWS::AutoScaling::WarmPool
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-warmpool.html
 */
class CfnWarmPool extends cdk.CfnResource {
    /**
     * Create a new `AWS::AutoScaling::WarmPool`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnWarmPool.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.monocdk_Construct(scope);
            jsiiDeprecationWarnings.monocdk_aws_autoscaling_CfnWarmPoolProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnWarmPool);
            }
            throw error;
        }
        cdk.requireProperty(props, 'autoScalingGroupName', this);
        this.autoScalingGroupName = props.autoScalingGroupName;
        this.instanceReusePolicy = props.instanceReusePolicy;
        this.maxGroupPreparedCapacity = props.maxGroupPreparedCapacity;
        this.minSize = props.minSize;
        this.poolState = props.poolState;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnWarmPoolPropsFromCloudFormation(resourceProperties);
        const ret = new CfnWarmPool(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.monocdk_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnWarmPool.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            autoScalingGroupName: this.autoScalingGroupName,
            instanceReusePolicy: this.instanceReusePolicy,
            maxGroupPreparedCapacity: this.maxGroupPreparedCapacity,
            minSize: this.minSize,
            poolState: this.poolState,
        };
    }
    renderProperties(props) {
        return cfnWarmPoolPropsToCloudFormation(props);
    }
}
exports.CfnWarmPool = CfnWarmPool;
_f = JSII_RTTI_SYMBOL_1;
CfnWarmPool[_f] = { fqn: "monocdk.aws_autoscaling.CfnWarmPool", version: "1.191.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnWarmPool.CFN_RESOURCE_TYPE_NAME = "AWS::AutoScaling::WarmPool";
/**
 * Determine whether the given properties match those of a `InstanceReusePolicyProperty`
 *
 * @param properties - the TypeScript properties of a `InstanceReusePolicyProperty`
 *
 * @returns the result of the validation.
 */
function CfnWarmPool_InstanceReusePolicyPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('reuseOnScaleIn', cdk.validateBoolean)(properties.reuseOnScaleIn));
    return errors.wrap('supplied properties not correct for "InstanceReusePolicyProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::AutoScaling::WarmPool.InstanceReusePolicy` resource
 *
 * @param properties - the TypeScript properties of a `InstanceReusePolicyProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::AutoScaling::WarmPool.InstanceReusePolicy` resource.
 */
// @ts-ignore TS6133
function cfnWarmPoolInstanceReusePolicyPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnWarmPool_InstanceReusePolicyPropertyValidator(properties).assertSuccess();
    return {
        ReuseOnScaleIn: cdk.booleanToCloudFormation(properties.reuseOnScaleIn),
    };
}
// @ts-ignore TS6133
function CfnWarmPoolInstanceReusePolicyPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('reuseOnScaleIn', 'ReuseOnScaleIn', properties.ReuseOnScaleIn != null ? cfn_parse.FromCloudFormation.getBoolean(properties.ReuseOnScaleIn) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXV0b3NjYWxpbmcuZ2VuZXJhdGVkLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiYXV0b3NjYWxpbmcuZ2VuZXJhdGVkLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7OztBQUFBLCtFQUErRTtBQUMvRSwrREFBK0Q7QUFDL0QsOEZBQThGO0FBQzlGLHNIQUFzSDtBQUV0SCw0QkFBNEIsQ0FBQyxpRUFBaUU7QUFFOUYsa0NBQWtDO0FBQ2xDLDZEQUE2RDtBQWlRN0Q7Ozs7OztHQU1HO0FBQ0gsU0FBUyxpQ0FBaUMsQ0FBQyxVQUFlO0lBQ3RELElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxHQUFHLENBQUMsa0JBQWtCLENBQUM7S0FBRTtJQUNuRSxNQUFNLE1BQU0sR0FBRyxJQUFJLEdBQUcsQ0FBQyxpQkFBaUIsRUFBRSxDQUFDO0lBQzNDLElBQUksT0FBTyxVQUFVLEtBQUssUUFBUSxFQUFFO1FBQ2hDLE1BQU0sQ0FBQyxPQUFPLENBQUMsSUFBSSxHQUFHLENBQUMsZ0JBQWdCLENBQUMsb0NBQW9DLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLENBQUM7S0FDL0c7SUFDRCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxzQkFBc0IsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLG9CQUFvQixDQUFDLENBQUMsQ0FBQztJQUNuSCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxtQkFBbUIsRUFBRSxHQUFHLENBQUMsYUFBYSxDQUFDLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLENBQUM7SUFDaEksTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsbUJBQW1CLEVBQUUsR0FBRyxDQUFDLGVBQWUsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLENBQUM7SUFDOUcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsU0FBUyxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQztJQUN6RixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxVQUFVLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxRQUFRLENBQUMsQ0FBQyxDQUFDO0lBQzNGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLHVCQUF1QixFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMscUJBQXFCLENBQUMsQ0FBQyxDQUFDO0lBQ3JILE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGlCQUFpQixFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsZUFBZSxDQUFDLENBQUMsQ0FBQztJQUN6RyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxxQkFBcUIsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLG1CQUFtQixDQUFDLENBQUMsQ0FBQztJQUNqSCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyx3QkFBd0IsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLHNCQUFzQixDQUFDLENBQUMsQ0FBQztJQUN2SCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxpQkFBaUIsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLGVBQWUsQ0FBQyxDQUFDLENBQUM7SUFDekcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsWUFBWSxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQztJQUMvRixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyx5QkFBeUIsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLHVCQUF1QixDQUFDLENBQUMsQ0FBQztJQUN6SCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxnQkFBZ0IsRUFBRSxnRUFBZ0UsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxjQUFjLENBQUMsQ0FBQyxDQUFDO0lBQ3JKLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGdDQUFnQyxFQUFFLEdBQUcsQ0FBQyxhQUFhLENBQUMsK0RBQStELENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyw4QkFBOEIsQ0FBQyxDQUFDLENBQUM7SUFDdk0sTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsbUJBQW1CLEVBQUUsR0FBRyxDQUFDLGFBQWEsQ0FBQyxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxDQUFDO0lBQ2hJLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLHFCQUFxQixFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsbUJBQW1CLENBQUMsQ0FBQyxDQUFDO0lBQ2pILE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFNBQVMsRUFBRSxHQUFHLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxVQUFVLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQztJQUM1RixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxTQUFTLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDO0lBQ3pGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLG1CQUFtQixFQUFFLEdBQUcsQ0FBQyxhQUFhLENBQUMsc0RBQXNELENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLENBQUM7SUFDcEssTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsU0FBUyxFQUFFLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDO0lBQzVGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFNBQVMsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUM7SUFDekYsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsc0JBQXNCLEVBQUUseURBQXlELENBQUMsQ0FBQyxVQUFVLENBQUMsb0JBQW9CLENBQUMsQ0FBQyxDQUFDO0lBQzFKLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGtDQUFrQyxFQUFFLEdBQUcsQ0FBQyxlQUFlLENBQUMsQ0FBQyxVQUFVLENBQUMsZ0NBQWdDLENBQUMsQ0FBQyxDQUFDO0lBQzVJLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLDRCQUE0QixFQUFFLEdBQUcsQ0FBQyxhQUFhLENBQUMsOERBQThELENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQywwQkFBMEIsQ0FBQyxDQUFDLENBQUM7SUFDOUwsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsZ0JBQWdCLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxjQUFjLENBQUMsQ0FBQyxDQUFDO0lBQ3ZHLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLHNCQUFzQixFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsb0JBQW9CLENBQUMsQ0FBQyxDQUFDO0lBQ25ILE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLE1BQU0sRUFBRSxHQUFHLENBQUMsYUFBYSxDQUFDLGdEQUFnRCxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQztJQUNwSSxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxpQkFBaUIsRUFBRSxHQUFHLENBQUMsYUFBYSxDQUFDLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxlQUFlLENBQUMsQ0FBQyxDQUFDO0lBQzVILE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLHFCQUFxQixFQUFFLEdBQUcsQ0FBQyxhQUFhLENBQUMsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDLG1CQUFtQixDQUFDLENBQUMsQ0FBQztJQUNwSSxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxtQkFBbUIsRUFBRSxHQUFHLENBQUMsYUFBYSxDQUFDLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLENBQUM7SUFDaEksT0FBTyxNQUFNLENBQUMsSUFBSSxDQUFDLGdFQUFnRSxDQUFDLENBQUM7QUFDekYsQ0FBQztBQUVEOzs7Ozs7R0FNRztBQUNILG9CQUFvQjtBQUNwQixTQUFTLHdDQUF3QyxDQUFDLFVBQWU7SUFDN0QsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLFVBQVUsQ0FBQztLQUFFO0lBQ3ZELGlDQUFpQyxDQUFDLFVBQVUsQ0FBQyxDQUFDLGFBQWEsRUFBRSxDQUFDO0lBQzlELE9BQU87UUFDSCxPQUFPLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUM7UUFDdkQsT0FBTyxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsT0FBTyxDQUFDO1FBQ3ZELG9CQUFvQixFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsb0JBQW9CLENBQUM7UUFDakYsaUJBQWlCLEVBQUUsR0FBRyxDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUMsc0JBQXNCLENBQUMsQ0FBQyxVQUFVLENBQUMsaUJBQWlCLENBQUM7UUFDM0YsaUJBQWlCLEVBQUUsR0FBRyxDQUFDLHVCQUF1QixDQUFDLFVBQVUsQ0FBQyxpQkFBaUIsQ0FBQztRQUM1RSxPQUFPLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUM7UUFDdkQsUUFBUSxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsUUFBUSxDQUFDO1FBQ3pELHFCQUFxQixFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMscUJBQXFCLENBQUM7UUFDbkYsZUFBZSxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsZUFBZSxDQUFDO1FBQ3ZFLG1CQUFtQixFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsbUJBQW1CLENBQUM7UUFDL0Usc0JBQXNCLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxzQkFBc0IsQ0FBQztRQUNyRixlQUFlLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxlQUFlLENBQUM7UUFDdkUsVUFBVSxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDO1FBQzdELHVCQUF1QixFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsdUJBQXVCLENBQUM7UUFDdkYsY0FBYyxFQUFFLHNFQUFzRSxDQUFDLFVBQVUsQ0FBQyxjQUFjLENBQUM7UUFDakgsOEJBQThCLEVBQUUsR0FBRyxDQUFDLFVBQVUsQ0FBQyxxRUFBcUUsQ0FBQyxDQUFDLFVBQVUsQ0FBQyw4QkFBOEIsQ0FBQztRQUNoSyxpQkFBaUIsRUFBRSxHQUFHLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxpQkFBaUIsQ0FBQztRQUMzRixtQkFBbUIsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLG1CQUFtQixDQUFDO1FBQy9FLGlCQUFpQixFQUFFLEdBQUcsQ0FBQyxVQUFVLENBQUMsNERBQTRELENBQUMsQ0FBQyxVQUFVLENBQUMsaUJBQWlCLENBQUM7UUFDN0gsb0JBQW9CLEVBQUUsK0RBQStELENBQUMsVUFBVSxDQUFDLG9CQUFvQixDQUFDO1FBQ3RILGdDQUFnQyxFQUFFLEdBQUcsQ0FBQyx1QkFBdUIsQ0FBQyxVQUFVLENBQUMsZ0NBQWdDLENBQUM7UUFDMUcsMEJBQTBCLEVBQUUsR0FBRyxDQUFDLFVBQVUsQ0FBQyxvRUFBb0UsQ0FBQyxDQUFDLFVBQVUsQ0FBQywwQkFBMEIsQ0FBQztRQUN2SixjQUFjLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxjQUFjLENBQUM7UUFDckUsb0JBQW9CLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxvQkFBb0IsQ0FBQztRQUNqRixJQUFJLEVBQUUsR0FBRyxDQUFDLFVBQVUsQ0FBQyxzREFBc0QsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUM7UUFDN0YsZUFBZSxFQUFFLEdBQUcsQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDLHNCQUFzQixDQUFDLENBQUMsVUFBVSxDQUFDLGVBQWUsQ0FBQztRQUN2RixtQkFBbUIsRUFBRSxHQUFHLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxtQkFBbUIsQ0FBQztRQUMvRixpQkFBaUIsRUFBRSxHQUFHLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxpQkFBaUIsQ0FBQztLQUM5RixDQUFDO0FBQ04sQ0FBQztBQUVELG9CQUFvQjtBQUNwQixTQUFTLDBDQUEwQyxDQUFDLFVBQWU7SUFDL0QsVUFBVSxHQUFHLFVBQVUsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDO0lBQ2xELElBQUksT0FBTyxVQUFVLEtBQUssUUFBUSxFQUFFO1FBQ2hDLE9BQU8sSUFBSSxTQUFTLENBQUMsd0JBQXdCLENBQUMsVUFBVSxDQUFDLENBQUM7S0FDN0Q7SUFDRCxNQUFNLEdBQUcsR0FBRyxJQUFJLFNBQVMsQ0FBQyxnQ0FBZ0MsRUFBNEIsQ0FBQztJQUN2RixHQUFHLENBQUMsaUJBQWlCLENBQUMsU0FBUyxFQUFFLFNBQVMsRUFBRSxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDO0lBQ3hHLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxTQUFTLEVBQUUsU0FBUyxFQUFFLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUM7SUFDeEcsR0FBRyxDQUFDLGlCQUFpQixDQUFDLHNCQUFzQixFQUFFLHNCQUFzQixFQUFFLFVBQVUsQ0FBQyxvQkFBb0IsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLG9CQUFvQixDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ3JNLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxtQkFBbUIsRUFBRSxtQkFBbUIsRUFBRSxVQUFVLENBQUMsaUJBQWlCLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsY0FBYyxDQUFDLFVBQVUsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUM5TCxHQUFHLENBQUMsaUJBQWlCLENBQUMsbUJBQW1CLEVBQUUsbUJBQW1CLEVBQUUsVUFBVSxDQUFDLGlCQUFpQixJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDMUwsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFNBQVMsRUFBRSxTQUFTLEVBQUUsVUFBVSxDQUFDLE9BQU8sSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUNqSixHQUFHLENBQUMsaUJBQWlCLENBQUMsVUFBVSxFQUFFLFVBQVUsRUFBRSxVQUFVLENBQUMsUUFBUSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsUUFBUSxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ3JKLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyx1QkFBdUIsRUFBRSx1QkFBdUIsRUFBRSxVQUFVLENBQUMscUJBQXFCLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUN6TSxHQUFHLENBQUMsaUJBQWlCLENBQUMsaUJBQWlCLEVBQUUsaUJBQWlCLEVBQUUsVUFBVSxDQUFDLGVBQWUsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLGVBQWUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUNqTCxHQUFHLENBQUMsaUJBQWlCLENBQUMscUJBQXFCLEVBQUUscUJBQXFCLEVBQUUsVUFBVSxDQUFDLG1CQUFtQixJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsbUJBQW1CLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDak0sR0FBRyxDQUFDLGlCQUFpQixDQUFDLHdCQUF3QixFQUFFLHdCQUF3QixFQUFFLFVBQVUsQ0FBQyxzQkFBc0IsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLHNCQUFzQixDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQzdNLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxpQkFBaUIsRUFBRSxpQkFBaUIsRUFBRSxVQUFVLENBQUMsZUFBZSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsZUFBZSxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ2pMLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxZQUFZLEVBQUUsWUFBWSxFQUFFLFVBQVUsQ0FBQyxVQUFVLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDN0osR0FBRyxDQUFDLGlCQUFpQixDQUFDLHlCQUF5QixFQUFFLHlCQUF5QixFQUFFLFVBQVUsQ0FBQyx1QkFBdUIsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLHVCQUF1QixDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ2pOLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxnQkFBZ0IsRUFBRSxnQkFBZ0IsRUFBRSxVQUFVLENBQUMsY0FBYyxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsd0VBQXdFLENBQUMsVUFBVSxDQUFDLGNBQWMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUMvTSxHQUFHLENBQUMsaUJBQWlCLENBQUMsZ0NBQWdDLEVBQUUsZ0NBQWdDLEVBQUUsVUFBVSxDQUFDLDhCQUE4QixJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFFBQVEsQ0FBQyx1RUFBdUUsQ0FBQyxDQUFDLFVBQVUsQ0FBQyw4QkFBOEIsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUNyVCxHQUFHLENBQUMsaUJBQWlCLENBQUMsbUJBQW1CLEVBQUUsbUJBQW1CLEVBQUUsVUFBVSxDQUFDLGlCQUFpQixJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLGNBQWMsQ0FBQyxVQUFVLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDOUwsR0FBRyxDQUFDLGlCQUFpQixDQUFDLHFCQUFxQixFQUFFLHFCQUFxQixFQUFFLFVBQVUsQ0FBQyxtQkFBbUIsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLG1CQUFtQixDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ2pNLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxtQkFBbUIsRUFBRSxtQkFBbUIsRUFBRSxVQUFVLENBQUMsaUJBQWlCLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsUUFBUSxDQUFDLDhEQUE4RCxDQUFDLENBQUMsVUFBVSxDQUFDLGlCQUFpQixDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ3hQLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxzQkFBc0IsRUFBRSxzQkFBc0IsRUFBRSxVQUFVLENBQUMsb0JBQW9CLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxpRUFBaUUsQ0FBQyxVQUFVLENBQUMsb0JBQW9CLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDaE8sR0FBRyxDQUFDLGlCQUFpQixDQUFDLGtDQUFrQyxFQUFFLGtDQUFrQyxFQUFFLFVBQVUsQ0FBQyxnQ0FBZ0MsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLGdDQUFnQyxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ3RQLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyw0QkFBNEIsRUFBRSw0QkFBNEIsRUFBRSxVQUFVLENBQUMsMEJBQTBCLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsUUFBUSxDQUFDLHNFQUFzRSxDQUFDLENBQUMsVUFBVSxDQUFDLDBCQUEwQixDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ3BTLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxnQkFBZ0IsRUFBRSxnQkFBZ0IsRUFBRSxVQUFVLENBQUMsY0FBYyxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsY0FBYyxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQzdLLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxzQkFBc0IsRUFBRSxzQkFBc0IsRUFBRSxVQUFVLENBQUMsb0JBQW9CLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUNyTSxHQUFHLENBQUMsaUJBQWlCLENBQUMsTUFBTSxFQUFFLE1BQU0sRUFBRSxVQUFVLENBQUMsSUFBSSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFFBQVEsQ0FBQyx3REFBd0QsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBZ0IsQ0FBQyxDQUFDO0lBQ3JNLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxpQkFBaUIsRUFBRSxpQkFBaUIsRUFBRSxVQUFVLENBQUMsZUFBZSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLGNBQWMsQ0FBQyxVQUFVLENBQUMsZUFBZSxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ3RMLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxxQkFBcUIsRUFBRSxxQkFBcUIsRUFBRSxVQUFVLENBQUMsbUJBQW1CLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsY0FBYyxDQUFDLFVBQVUsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUN0TSxHQUFHLENBQUMsaUJBQWlCLENBQUMsbUJBQW1CLEVBQUUsbUJBQW1CLEVBQUUsVUFBVSxDQUFDLGlCQUFpQixJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLGNBQWMsQ0FBQyxVQUFVLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDOUwsR0FBRyxDQUFDLGdDQUFnQyxDQUFDLFVBQVUsQ0FBQyxDQUFDO0lBQ2pELE9BQU8sR0FBRyxDQUFDO0FBQ2YsQ0FBQztBQUVEOzs7Ozs7Ozs7Ozs7O0dBYUc7QUFDSCxNQUFhLG1CQUFvQixTQUFRLEdBQUcsQ0FBQyxXQUFXO0lBNlFwRDs7Ozs7O09BTUc7SUFDSCxZQUFZLEtBQW9CLEVBQUUsRUFBVSxFQUFFLEtBQStCO1FBQ3pFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLEVBQUUsSUFBSSxFQUFFLG1CQUFtQixDQUFDLHNCQUFzQixFQUFFLFVBQVUsRUFBRSxLQUFLLEVBQUUsQ0FBQyxDQUFDOzs7Ozs7OytDQXJSckYsbUJBQW1COzs7O1FBc1J4QixHQUFHLENBQUMsZUFBZSxDQUFDLEtBQUssRUFBRSxTQUFTLEVBQUUsSUFBSSxDQUFDLENBQUM7UUFDNUMsR0FBRyxDQUFDLGVBQWUsQ0FBQyxLQUFLLEVBQUUsU0FBUyxFQUFFLElBQUksQ0FBQyxDQUFDO1FBRTVDLElBQUksQ0FBQyxPQUFPLEdBQUcsS0FBSyxDQUFDLE9BQU8sQ0FBQztRQUM3QixJQUFJLENBQUMsT0FBTyxHQUFHLEtBQUssQ0FBQyxPQUFPLENBQUM7UUFDN0IsSUFBSSxDQUFDLG9CQUFvQixHQUFHLEtBQUssQ0FBQyxvQkFBb0IsQ0FBQztRQUN2RCxJQUFJLENBQUMsaUJBQWlCLEdBQUcsS0FBSyxDQUFDLGlCQUFpQixDQUFDO1FBQ2pELElBQUksQ0FBQyxpQkFBaUIsR0FBRyxLQUFLLENBQUMsaUJBQWlCLENBQUM7UUFDakQsSUFBSSxDQUFDLE9BQU8sR0FBRyxLQUFLLENBQUMsT0FBTyxDQUFDO1FBQzdCLElBQUksQ0FBQyxRQUFRLEdBQUcsS0FBSyxDQUFDLFFBQVEsQ0FBQztRQUMvQixJQUFJLENBQUMscUJBQXFCLEdBQUcsS0FBSyxDQUFDLHFCQUFxQixDQUFDO1FBQ3pELElBQUksQ0FBQyxlQUFlLEdBQUcsS0FBSyxDQUFDLGVBQWUsQ0FBQztRQUM3QyxJQUFJLENBQUMsbUJBQW1CLEdBQUcsS0FBSyxDQUFDLG1CQUFtQixDQUFDO1FBQ3JELElBQUksQ0FBQyxzQkFBc0IsR0FBRyxLQUFLLENBQUMsc0JBQXNCLENBQUM7UUFDM0QsSUFBSSxDQUFDLGVBQWUsR0FBRyxLQUFLLENBQUMsZUFBZSxDQUFDO1FBQzdDLElBQUksQ0FBQyxVQUFVLEdBQUcsS0FBSyxDQUFDLFVBQVUsQ0FBQztRQUNuQyxJQUFJLENBQUMsdUJBQXVCLEdBQUcsS0FBSyxDQUFDLHVCQUF1QixDQUFDO1FBQzdELElBQUksQ0FBQyxjQUFjLEdBQUcsS0FBSyxDQUFDLGNBQWMsQ0FBQztRQUMzQyxJQUFJLENBQUMsOEJBQThCLEdBQUcsS0FBSyxDQUFDLDhCQUE4QixDQUFDO1FBQzNFLElBQUksQ0FBQyxpQkFBaUIsR0FBRyxLQUFLLENBQUMsaUJBQWlCLENBQUM7UUFDakQsSUFBSSxDQUFDLG1CQUFtQixHQUFHLEtBQUssQ0FBQyxtQkFBbUIsQ0FBQztRQUNyRCxJQUFJLENBQUMsaUJBQWlCLEdBQUcsS0FBSyxDQUFDLGlCQUFpQixDQUFDO1FBQ2pELElBQUksQ0FBQyxvQkFBb0IsR0FBRyxLQUFLLENBQUMsb0JBQW9CLENBQUM7UUFDdkQsSUFBSSxDQUFDLGdDQUFnQyxHQUFHLEtBQUssQ0FBQyxnQ0FBZ0MsQ0FBQztRQUMvRSxJQUFJLENBQUMsMEJBQTBCLEdBQUcsS0FBSyxDQUFDLDBCQUEwQixDQUFDO1FBQ25FLElBQUksQ0FBQyxjQUFjLEdBQUcsS0FBSyxDQUFDLGNBQWMsQ0FBQztRQUMzQyxJQUFJLENBQUMsb0JBQW9CLEdBQUcsS0FBSyxDQUFDLG9CQUFvQixDQUFDO1FBQ3ZELElBQUksQ0FBQyxJQUFJLEdBQUcsSUFBSSxHQUFHLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQyxPQUFPLENBQUMsaUJBQWlCLEVBQUUsb0NBQW9DLEVBQUUsS0FBSyxDQUFDLElBQUksRUFBRSxFQUFFLGVBQWUsRUFBRSxNQUFNLEVBQUUsQ0FBQyxDQUFDO1FBQzdJLElBQUksQ0FBQyxlQUFlLEdBQUcsS0FBSyxDQUFDLGVBQWUsQ0FBQztRQUM3QyxJQUFJLENBQUMsbUJBQW1CLEdBQUcsS0FBSyxDQUFDLG1CQUFtQixDQUFDO1FBQ3JELElBQUksQ0FBQyxpQkFBaUIsR0FBRyxLQUFLLENBQUMsaUJBQWlCLENBQUM7S0FDcEQ7SUEvU0Q7Ozs7OztPQU1HO0lBQ0ksTUFBTSxDQUFDLG1CQUFtQixDQUFDLEtBQW9CLEVBQUUsRUFBVSxFQUFFLGtCQUF1QixFQUFFLE9BQTRDO1FBQ3JJLGtCQUFrQixHQUFHLGtCQUFrQixJQUFJLEVBQUUsQ0FBQztRQUM5QyxNQUFNLGtCQUFrQixHQUFHLE9BQU8sQ0FBQyxNQUFNLENBQUMsVUFBVSxDQUFDLGtCQUFrQixDQUFDLFVBQVUsQ0FBQyxDQUFDO1FBQ3BGLE1BQU0sV0FBVyxHQUFHLDBDQUEwQyxDQUFDLGtCQUFrQixDQUFDLENBQUM7UUFDbkYsTUFBTSxHQUFHLEdBQUcsSUFBSSxtQkFBbUIsQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLFdBQVcsQ0FBQyxLQUFLLENBQUMsQ0FBQztRQUNsRSxLQUFLLE1BQU0sQ0FBQyxPQUFPLEVBQUUsT0FBTyxDQUFDLElBQUksTUFBTSxDQUFDLE9BQU8sQ0FBQyxXQUFXLENBQUMsZUFBZSxDQUFDLEVBQUc7WUFDM0UsR0FBRyxDQUFDLG1CQUFtQixDQUFDLE9BQU8sRUFBRSxPQUFPLENBQUMsQ0FBQztTQUM3QztRQUNELE9BQU8sQ0FBQyxNQUFNLENBQUMsZ0JBQWdCLENBQUMsR0FBRyxFQUFFLGtCQUFrQixFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBQzdELE9BQU8sR0FBRyxDQUFDO0tBQ2Q7SUFnU0Q7Ozs7O09BS0c7SUFDSSxPQUFPLENBQUMsU0FBNEI7Ozs7Ozs7Ozs7UUFDdkMsU0FBUyxDQUFDLFlBQVksQ0FBQyw2QkFBNkIsRUFBRSxtQkFBbUIsQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDO1FBQ2xHLFNBQVMsQ0FBQyxZQUFZLENBQUMsOEJBQThCLEVBQUUsSUFBSSxDQUFDLGFBQWEsQ0FBQyxDQUFDO0tBQzlFO0lBRUQsSUFBYyxhQUFhO1FBQ3ZCLE9BQU87WUFDSCxPQUFPLEVBQUUsSUFBSSxDQUFDLE9BQU87WUFDckIsT0FBTyxFQUFFLElBQUksQ0FBQyxPQUFPO1lBQ3JCLG9CQUFvQixFQUFFLElBQUksQ0FBQyxvQkFBb0I7WUFDL0MsaUJBQWlCLEVBQUUsSUFBSSxDQUFDLGlCQUFpQjtZQUN6QyxpQkFBaUIsRUFBRSxJQUFJLENBQUMsaUJBQWlCO1lBQ3pDLE9BQU8sRUFBRSxJQUFJLENBQUMsT0FBTztZQUNyQixRQUFRLEVBQUUsSUFBSSxDQUFDLFFBQVE7WUFDdkIscUJBQXFCLEVBQUUsSUFBSSxDQUFDLHFCQUFxQjtZQUNqRCxlQUFlLEVBQUUsSUFBSSxDQUFDLGVBQWU7WUFDckMsbUJBQW1CLEVBQUUsSUFBSSxDQUFDLG1CQUFtQjtZQUM3QyxzQkFBc0IsRUFBRSxJQUFJLENBQUMsc0JBQXNCO1lBQ25ELGVBQWUsRUFBRSxJQUFJLENBQUMsZUFBZTtZQUNyQyxVQUFVLEVBQUUsSUFBSSxDQUFDLFVBQVU7WUFDM0IsdUJBQXVCLEVBQUUsSUFBSSxDQUFDLHVCQUF1QjtZQUNyRCxjQUFjLEVBQUUsSUFBSSxDQUFDLGNBQWM7WUFDbkMsOEJBQThCLEVBQUUsSUFBSSxDQUFDLDhCQUE4QjtZQUNuRSxpQkFBaUIsRUFBRSxJQUFJLENBQUMsaUJBQWlCO1lBQ3pDLG1CQUFtQixFQUFFLElBQUksQ0FBQyxtQkFBbUI7WUFDN0MsaUJBQWlCLEVBQUUsSUFBSSxDQUFDLGlCQUFpQjtZQUN6QyxvQkFBb0IsRUFBRSxJQUFJLENBQUMsb0JBQW9CO1lBQy9DLGdDQUFnQyxFQUFFLElBQUksQ0FBQyxnQ0FBZ0M7WUFDdkUsMEJBQTBCLEVBQUUsSUFBSSxDQUFDLDBCQUEwQjtZQUMzRCxjQUFjLEVBQUUsSUFBSSxDQUFDLGNBQWM7WUFDbkMsb0JBQW9CLEVBQUUsSUFBSSxDQUFDLG9CQUFvQjtZQUMvQyxJQUFJLEVBQUUsSUFBSSxDQUFDLElBQUksQ0FBQyxVQUFVLEVBQUU7WUFDNUIsZUFBZSxFQUFFLElBQUksQ0FBQyxlQUFlO1lBQ3JDLG1CQUFtQixFQUFFLElBQUksQ0FBQyxtQkFBbUI7WUFDN0MsaUJBQWlCLEVBQUUsSUFBSSxDQUFDLGlCQUFpQjtTQUM1QyxDQUFDO0tBQ0w7SUFFUyxnQkFBZ0IsQ0FBQyxLQUEyQjtRQUNsRCxPQUFPLHdDQUF3QyxDQUFDLEtBQUssQ0FBQyxDQUFDO0tBQzFEOztBQXJXTCxrREFzV0M7OztBQXJXRzs7R0FFRztBQUNvQiwwQ0FBc0IsR0FBRyxvQ0FBb0MsQ0FBQztBQTZYekY7Ozs7OztHQU1HO0FBQ0gsU0FBUyw0REFBNEQsQ0FBQyxVQUFlO0lBQ2pGLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxHQUFHLENBQUMsa0JBQWtCLENBQUM7S0FBRTtJQUNuRSxNQUFNLE1BQU0sR0FBRyxJQUFJLEdBQUcsQ0FBQyxpQkFBaUIsRUFBRSxDQUFDO0lBQzNDLElBQUksT0FBTyxVQUFVLEtBQUssUUFBUSxFQUFFO1FBQ2hDLE1BQU0sQ0FBQyxPQUFPLENBQUMsSUFBSSxHQUFHLENBQUMsZ0JBQWdCLENBQUMsb0NBQW9DLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLENBQUM7S0FDL0c7SUFDRCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxLQUFLLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDO0lBQ2pGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLEtBQUssRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUM7SUFDakYsT0FBTyxNQUFNLENBQUMsSUFBSSxDQUFDLHVFQUF1RSxDQUFDLENBQUM7QUFDaEcsQ0FBQztBQUVEOzs7Ozs7R0FNRztBQUNILG9CQUFvQjtBQUNwQixTQUFTLGtFQUFrRSxDQUFDLFVBQWU7SUFDdkYsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLFVBQVUsQ0FBQztLQUFFO0lBQ3ZELDREQUE0RCxDQUFDLFVBQVUsQ0FBQyxDQUFDLGFBQWEsRUFBRSxDQUFDO0lBQ3pGLE9BQU87UUFDSCxHQUFHLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUM7UUFDL0MsR0FBRyxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDO0tBQ2xELENBQUM7QUFDTixDQUFDO0FBRUQsb0JBQW9CO0FBQ3BCLFNBQVMsb0VBQW9FLENBQUMsVUFBZTtJQUN6RixJQUFJLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUNwQyxPQUFPLElBQUksU0FBUyxDQUFDLHdCQUF3QixDQUFDLFVBQVUsQ0FBQyxDQUFDO0tBQzdEO0lBQ0QsVUFBVSxHQUFHLFVBQVUsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDO0lBQ2xELElBQUksT0FBTyxVQUFVLEtBQUssUUFBUSxFQUFFO1FBQ2hDLE9BQU8sSUFBSSxTQUFTLENBQUMsd0JBQXdCLENBQUMsVUFBVSxDQUFDLENBQUM7S0FDN0Q7SUFDRCxNQUFNLEdBQUcsR0FBRyxJQUFJLFNBQVMsQ0FBQyxnQ0FBZ0MsRUFBdUQsQ0FBQztJQUNsSCxHQUFHLENBQUMsaUJBQWlCLENBQUMsS0FBSyxFQUFFLEtBQUssRUFBRSxVQUFVLENBQUMsR0FBRyxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ2pJLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxLQUFLLEVBQUUsS0FBSyxFQUFFLFVBQVUsQ0FBQyxHQUFHLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDakksR0FBRyxDQUFDLGdDQUFnQyxDQUFDLFVBQVUsQ0FBQyxDQUFDO0lBQ2pELE9BQU8sR0FBRyxDQUFDO0FBQ2YsQ0FBQztBQTJCRDs7Ozs7O0dBTUc7QUFDSCxTQUFTLHFFQUFxRSxDQUFDLFVBQWU7SUFDMUYsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQztLQUFFO0lBQ25FLE1BQU0sTUFBTSxHQUFHLElBQUksR0FBRyxDQUFDLGlCQUFpQixFQUFFLENBQUM7SUFDM0MsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsTUFBTSxDQUFDLE9BQU8sQ0FBQyxJQUFJLEdBQUcsQ0FBQyxnQkFBZ0IsQ0FBQyxvQ0FBb0MsR0FBRyxJQUFJLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUMsQ0FBQztLQUMvRztJQUNELE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLEtBQUssRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUM7SUFDakYsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsS0FBSyxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQztJQUNqRixPQUFPLE1BQU0sQ0FBQyxJQUFJLENBQUMsZ0ZBQWdGLENBQUMsQ0FBQztBQUN6RyxDQUFDO0FBRUQ7Ozs7OztHQU1HO0FBQ0gsb0JBQW9CO0FBQ3BCLFNBQVMsMkVBQTJFLENBQUMsVUFBZTtJQUNoRyxJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sVUFBVSxDQUFDO0tBQUU7SUFDdkQscUVBQXFFLENBQUMsVUFBVSxDQUFDLENBQUMsYUFBYSxFQUFFLENBQUM7SUFDbEcsT0FBTztRQUNILEdBQUcsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQztRQUMvQyxHQUFHLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUM7S0FDbEQsQ0FBQztBQUNOLENBQUM7QUFFRCxvQkFBb0I7QUFDcEIsU0FBUyw2RUFBNkUsQ0FBQyxVQUFlO0lBQ2xHLElBQUksR0FBRyxDQUFDLGtCQUFrQixDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQ3BDLE9BQU8sSUFBSSxTQUFTLENBQUMsd0JBQXdCLENBQUMsVUFBVSxDQUFDLENBQUM7S0FDN0Q7SUFDRCxVQUFVLEdBQUcsVUFBVSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUM7SUFDbEQsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsT0FBTyxJQUFJLFNBQVMsQ0FBQyx3QkFBd0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztLQUM3RDtJQUNELE1BQU0sR0FBRyxHQUFHLElBQUksU0FBUyxDQUFDLGdDQUFnQyxFQUFnRSxDQUFDO0lBQzNILEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxLQUFLLEVBQUUsS0FBSyxFQUFFLFVBQVUsQ0FBQyxHQUFHLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDakksR0FBRyxDQUFDLGlCQUFpQixDQUFDLEtBQUssRUFBRSxLQUFLLEVBQUUsVUFBVSxDQUFDLEdBQUcsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUNqSSxHQUFHLENBQUMsZ0NBQWdDLENBQUMsVUFBVSxDQUFDLENBQUM7SUFDakQsT0FBTyxHQUFHLENBQUM7QUFDZixDQUFDO0FBMkJEOzs7Ozs7R0FNRztBQUNILFNBQVMsb0VBQW9FLENBQUMsVUFBZTtJQUN6RixJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sR0FBRyxDQUFDLGtCQUFrQixDQUFDO0tBQUU7SUFDbkUsTUFBTSxNQUFNLEdBQUcsSUFBSSxHQUFHLENBQUMsaUJBQWlCLEVBQUUsQ0FBQztJQUMzQyxJQUFJLE9BQU8sVUFBVSxLQUFLLFFBQVEsRUFBRTtRQUNoQyxNQUFNLENBQUMsT0FBTyxDQUFDLElBQUksR0FBRyxDQUFDLGdCQUFnQixDQUFDLG9DQUFvQyxHQUFHLElBQUksQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxDQUFDO0tBQy9HO0lBQ0QsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsS0FBSyxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQztJQUNqRixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxLQUFLLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDO0lBQ2pGLE9BQU8sTUFBTSxDQUFDLElBQUksQ0FBQywrRUFBK0UsQ0FBQyxDQUFDO0FBQ3hHLENBQUM7QUFFRDs7Ozs7O0dBTUc7QUFDSCxvQkFBb0I7QUFDcEIsU0FBUywwRUFBMEUsQ0FBQyxVQUFlO0lBQy9GLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxVQUFVLENBQUM7S0FBRTtJQUN2RCxvRUFBb0UsQ0FBQyxVQUFVLENBQUMsQ0FBQyxhQUFhLEVBQUUsQ0FBQztJQUNqRyxPQUFPO1FBQ0gsR0FBRyxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDO1FBQy9DLEdBQUcsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQztLQUNsRCxDQUFDO0FBQ04sQ0FBQztBQUVELG9CQUFvQjtBQUNwQixTQUFTLDRFQUE0RSxDQUFDLFVBQWU7SUFDakcsSUFBSSxHQUFHLENBQUMsa0JBQWtCLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFDcEMsT0FBTyxJQUFJLFNBQVMsQ0FBQyx3QkFBd0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztLQUM3RDtJQUNELFVBQVUsR0FBRyxVQUFVLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQztJQUNsRCxJQUFJLE9BQU8sVUFBVSxLQUFLLFFBQVEsRUFBRTtRQUNoQyxPQUFPLElBQUksU0FBUyxDQUFDLHdCQUF3QixDQUFDLFVBQVUsQ0FBQyxDQUFDO0tBQzdEO0lBQ0QsTUFBTSxHQUFHLEdBQUcsSUFBSSxTQUFTLENBQUMsZ0NBQWdDLEVBQStELENBQUM7SUFDMUgsR0FBRyxDQUFDLGlCQUFpQixDQUFDLEtBQUssRUFBRSxLQUFLLEVBQUUsVUFBVSxDQUFDLEdBQUcsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUNqSSxHQUFHLENBQUMsaUJBQWlCLENBQUMsS0FBSyxFQUFFLEtBQUssRUFBRSxVQUFVLENBQUMsR0FBRyxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ2pJLEdBQUcsQ0FBQyxnQ0FBZ0MsQ0FBQyxVQUFVLENBQUMsQ0FBQztJQUNqRCxPQUFPLEdBQUcsQ0FBQztBQUNmLENBQUM7QUErUEQ7Ozs7OztHQU1HO0FBQ0gsU0FBUyx5REFBeUQsQ0FBQyxVQUFlO0lBQzlFLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxHQUFHLENBQUMsa0JBQWtCLENBQUM7S0FBRTtJQUNuRSxNQUFNLE1BQU0sR0FBRyxJQUFJLEdBQUcsQ0FBQyxpQkFBaUIsRUFBRSxDQUFDO0lBQzNDLElBQUksT0FBTyxVQUFVLEtBQUssUUFBUSxFQUFFO1FBQ2hDLE1BQU0sQ0FBQyxPQUFPLENBQUMsSUFBSSxHQUFHLENBQUMsZ0JBQWdCLENBQUMsb0NBQW9DLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLENBQUM7S0FDL0c7SUFDRCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxrQkFBa0IsRUFBRSw0REFBNEQsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDLENBQUM7SUFDckosTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsMEJBQTBCLEVBQUUsR0FBRyxDQUFDLGFBQWEsQ0FBQyxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUMsd0JBQXdCLENBQUMsQ0FBQyxDQUFDO0lBQzlJLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGtCQUFrQixFQUFFLEdBQUcsQ0FBQyxhQUFhLENBQUMsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDLGdCQUFnQixDQUFDLENBQUMsQ0FBQztJQUM5SCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQywyQkFBMkIsRUFBRSxxRUFBcUUsQ0FBQyxDQUFDLFVBQVUsQ0FBQyx5QkFBeUIsQ0FBQyxDQUFDLENBQUM7SUFDaEwsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsa0JBQWtCLEVBQUUsR0FBRyxDQUFDLGFBQWEsQ0FBQyxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUMsZ0JBQWdCLENBQUMsQ0FBQyxDQUFDO0lBQzlILE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLHNCQUFzQixFQUFFLEdBQUcsQ0FBQyxhQUFhLENBQUMsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDLG9CQUFvQixDQUFDLENBQUMsQ0FBQztJQUN0SSxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxXQUFXLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQUMsQ0FBQyxDQUFDO0lBQzdGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLDBCQUEwQixFQUFFLG9FQUFvRSxDQUFDLENBQUMsVUFBVSxDQUFDLHdCQUF3QixDQUFDLENBQUMsQ0FBQztJQUM3SyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxzQkFBc0IsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLG9CQUFvQixDQUFDLENBQUMsQ0FBQztJQUNuSCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxrQkFBa0IsRUFBRSxHQUFHLENBQUMsYUFBYSxDQUFDLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDLENBQUM7SUFDOUgsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsdUJBQXVCLEVBQUUsR0FBRyxDQUFDLGFBQWEsQ0FBQyxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUMscUJBQXFCLENBQUMsQ0FBQyxDQUFDO0lBQ3hJLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLHFCQUFxQixFQUFFLEdBQUcsQ0FBQyxhQUFhLENBQUMsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDLG1CQUFtQixDQUFDLENBQUMsQ0FBQztJQUNwSSxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxjQUFjLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxZQUFZLENBQUMsQ0FBQyxDQUFDO0lBQ25HLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLG1CQUFtQixFQUFFLEdBQUcsQ0FBQyxhQUFhLENBQUMsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDLGlCQUFpQixDQUFDLENBQUMsQ0FBQztJQUNoSSxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxrQkFBa0IsRUFBRSw0REFBNEQsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDLENBQUM7SUFDckosTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsV0FBVyxFQUFFLHFEQUFxRCxDQUFDLENBQUMsVUFBVSxDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUM7SUFDaEksTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsc0JBQXNCLEVBQUUsZ0VBQWdFLENBQUMsQ0FBQyxVQUFVLENBQUMsb0JBQW9CLENBQUMsQ0FBQyxDQUFDO0lBQ2pLLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLHVCQUF1QixFQUFFLGlFQUFpRSxDQUFDLENBQUMsVUFBVSxDQUFDLHFCQUFxQixDQUFDLENBQUMsQ0FBQztJQUNwSyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQywyQ0FBMkMsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLHlDQUF5QyxDQUFDLENBQUMsQ0FBQztJQUM3SixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyx5QkFBeUIsRUFBRSxHQUFHLENBQUMsZUFBZSxDQUFDLENBQUMsVUFBVSxDQUFDLHVCQUF1QixDQUFDLENBQUMsQ0FBQztJQUMxSCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyx1Q0FBdUMsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLHFDQUFxQyxDQUFDLENBQUMsQ0FBQztJQUNySixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxxQkFBcUIsRUFBRSwrREFBK0QsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDLENBQUM7SUFDOUosTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsV0FBVyxFQUFFLHFEQUFxRCxDQUFDLENBQUMsVUFBVSxDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUM7SUFDaEksT0FBTyxNQUFNLENBQUMsSUFBSSxDQUFDLG9FQUFvRSxDQUFDLENBQUM7QUFDN0YsQ0FBQztBQUVEOzs7Ozs7R0FNRztBQUNILG9CQUFvQjtBQUNwQixTQUFTLCtEQUErRCxDQUFDLFVBQWU7SUFDcEYsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLFVBQVUsQ0FBQztLQUFFO0lBQ3ZELHlEQUF5RCxDQUFDLFVBQVUsQ0FBQyxDQUFDLGFBQWEsRUFBRSxDQUFDO0lBQ3RGLE9BQU87UUFDSCxnQkFBZ0IsRUFBRSxrRUFBa0UsQ0FBQyxVQUFVLENBQUMsZ0JBQWdCLENBQUM7UUFDakgsd0JBQXdCLEVBQUUsR0FBRyxDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUMsc0JBQXNCLENBQUMsQ0FBQyxVQUFVLENBQUMsd0JBQXdCLENBQUM7UUFDekcsZ0JBQWdCLEVBQUUsR0FBRyxDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUMsc0JBQXNCLENBQUMsQ0FBQyxVQUFVLENBQUMsZ0JBQWdCLENBQUM7UUFDekYseUJBQXlCLEVBQUUsMkVBQTJFLENBQUMsVUFBVSxDQUFDLHlCQUF5QixDQUFDO1FBQzVJLGdCQUFnQixFQUFFLEdBQUcsQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDLHNCQUFzQixDQUFDLENBQUMsVUFBVSxDQUFDLGdCQUFnQixDQUFDO1FBQ3pGLG9CQUFvQixFQUFFLEdBQUcsQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDLHNCQUFzQixDQUFDLENBQUMsVUFBVSxDQUFDLG9CQUFvQixDQUFDO1FBQ2pHLFNBQVMsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLFNBQVMsQ0FBQztRQUMzRCx3QkFBd0IsRUFBRSwwRUFBMEUsQ0FBQyxVQUFVLENBQUMsd0JBQXdCLENBQUM7UUFDekksb0JBQW9CLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxvQkFBb0IsQ0FBQztRQUNqRixnQkFBZ0IsRUFBRSxHQUFHLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxnQkFBZ0IsQ0FBQztRQUN6RixxQkFBcUIsRUFBRSxHQUFHLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxxQkFBcUIsQ0FBQztRQUNuRyxtQkFBbUIsRUFBRSxHQUFHLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxtQkFBbUIsQ0FBQztRQUMvRixZQUFZLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxZQUFZLENBQUM7UUFDakUsaUJBQWlCLEVBQUUsR0FBRyxDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUMsc0JBQXNCLENBQUMsQ0FBQyxVQUFVLENBQUMsaUJBQWlCLENBQUM7UUFDM0YsZ0JBQWdCLEVBQUUsa0VBQWtFLENBQUMsVUFBVSxDQUFDLGdCQUFnQixDQUFDO1FBQ2pILFNBQVMsRUFBRSwyREFBMkQsQ0FBQyxVQUFVLENBQUMsU0FBUyxDQUFDO1FBQzVGLG9CQUFvQixFQUFFLHNFQUFzRSxDQUFDLFVBQVUsQ0FBQyxvQkFBb0IsQ0FBQztRQUM3SCxxQkFBcUIsRUFBRSx1RUFBdUUsQ0FBQyxVQUFVLENBQUMscUJBQXFCLENBQUM7UUFDaEkseUNBQXlDLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyx5Q0FBeUMsQ0FBQztRQUMzSCx1QkFBdUIsRUFBRSxHQUFHLENBQUMsdUJBQXVCLENBQUMsVUFBVSxDQUFDLHVCQUF1QixDQUFDO1FBQ3hGLHFDQUFxQyxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMscUNBQXFDLENBQUM7UUFDbkgsbUJBQW1CLEVBQUUscUVBQXFFLENBQUMsVUFBVSxDQUFDLG1CQUFtQixDQUFDO1FBQzFILFNBQVMsRUFBRSwyREFBMkQsQ0FBQyxVQUFVLENBQUMsU0FBUyxDQUFDO0tBQy9GLENBQUM7QUFDTixDQUFDO0FBRUQsb0JBQW9CO0FBQ3BCLFNBQVMsaUVBQWlFLENBQUMsVUFBZTtJQUN0RixJQUFJLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUNwQyxPQUFPLElBQUksU0FBUyxDQUFDLHdCQUF3QixDQUFDLFVBQVUsQ0FBQyxDQUFDO0tBQzdEO0lBQ0QsVUFBVSxHQUFHLFVBQVUsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDO0lBQ2xELElBQUksT0FBTyxVQUFVLEtBQUssUUFBUSxFQUFFO1FBQ2hDLE9BQU8sSUFBSSxTQUFTLENBQUMsd0JBQXdCLENBQUMsVUFBVSxDQUFDLENBQUM7S0FDN0Q7SUFDRCxNQUFNLEdBQUcsR0FBRyxJQUFJLFNBQVMsQ0FBQyxnQ0FBZ0MsRUFBb0QsQ0FBQztJQUMvRyxHQUFHLENBQUMsaUJBQWlCLENBQUMsa0JBQWtCLEVBQUUsa0JBQWtCLEVBQUUsVUFBVSxDQUFDLGdCQUFnQixJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsb0VBQW9FLENBQUMsVUFBVSxDQUFDLGdCQUFnQixDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ25OLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQywwQkFBMEIsRUFBRSwwQkFBMEIsRUFBRSxVQUFVLENBQUMsd0JBQXdCLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsY0FBYyxDQUFDLFVBQVUsQ0FBQyx3QkFBd0IsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUMxTixHQUFHLENBQUMsaUJBQWlCLENBQUMsa0JBQWtCLEVBQUUsa0JBQWtCLEVBQUUsVUFBVSxDQUFDLGdCQUFnQixJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLGNBQWMsQ0FBQyxVQUFVLENBQUMsZ0JBQWdCLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDMUwsR0FBRyxDQUFDLGlCQUFpQixDQUFDLDJCQUEyQixFQUFFLDJCQUEyQixFQUFFLFVBQVUsQ0FBQyx5QkFBeUIsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLDZFQUE2RSxDQUFDLFVBQVUsQ0FBQyx5QkFBeUIsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUNoUSxHQUFHLENBQUMsaUJBQWlCLENBQUMsa0JBQWtCLEVBQUUsa0JBQWtCLEVBQUUsVUFBVSxDQUFDLGdCQUFnQixJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLGNBQWMsQ0FBQyxVQUFVLENBQUMsZ0JBQWdCLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDMUwsR0FBRyxDQUFDLGlCQUFpQixDQUFDLHNCQUFzQixFQUFFLHNCQUFzQixFQUFFLFVBQVUsQ0FBQyxvQkFBb0IsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxjQUFjLENBQUMsVUFBVSxDQUFDLG9CQUFvQixDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQzFNLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxXQUFXLEVBQUUsV0FBVyxFQUFFLFVBQVUsQ0FBQyxTQUFTLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDekosR0FBRyxDQUFDLGlCQUFpQixDQUFDLDBCQUEwQixFQUFFLDBCQUEwQixFQUFFLFVBQVUsQ0FBQyx3QkFBd0IsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLDRFQUE0RSxDQUFDLFVBQVUsQ0FBQyx3QkFBd0IsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUMzUCxHQUFHLENBQUMsaUJBQWlCLENBQUMsc0JBQXNCLEVBQUUsc0JBQXNCLEVBQUUsVUFBVSxDQUFDLG9CQUFvQixJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsb0JBQW9CLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDck0sR0FBRyxDQUFDLGlCQUFpQixDQUFDLGtCQUFrQixFQUFFLGtCQUFrQixFQUFFLFVBQVUsQ0FBQyxnQkFBZ0IsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxjQUFjLENBQUMsVUFBVSxDQUFDLGdCQUFnQixDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQzFMLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyx1QkFBdUIsRUFBRSx1QkFBdUIsRUFBRSxVQUFVLENBQUMscUJBQXFCLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsY0FBYyxDQUFDLFVBQVUsQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUM5TSxHQUFHLENBQUMsaUJBQWlCLENBQUMscUJBQXFCLEVBQUUscUJBQXFCLEVBQUUsVUFBVSxDQUFDLG1CQUFtQixJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLGNBQWMsQ0FBQyxVQUFVLENBQUMsbUJBQW1CLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDdE0sR0FBRyxDQUFDLGlCQUFpQixDQUFDLGNBQWMsRUFBRSxjQUFjLEVBQUUsVUFBVSxDQUFDLFlBQVksSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLFlBQVksQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUNySyxHQUFHLENBQUMsaUJBQWlCLENBQUMsbUJBQW1CLEVBQUUsbUJBQW1CLEVBQUUsVUFBVSxDQUFDLGlCQUFpQixJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLGNBQWMsQ0FBQyxVQUFVLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDOUwsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGtCQUFrQixFQUFFLGtCQUFrQixFQUFFLFVBQVUsQ0FBQyxnQkFBZ0IsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLG9FQUFvRSxDQUFDLFVBQVUsQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUNuTixHQUFHLENBQUMsaUJBQWlCLENBQUMsV0FBVyxFQUFFLFdBQVcsRUFBRSxVQUFVLENBQUMsU0FBUyxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsNkRBQTZELENBQUMsVUFBVSxDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUNoTCxHQUFHLENBQUMsaUJBQWlCLENBQUMsc0JBQXNCLEVBQUUsc0JBQXNCLEVBQUUsVUFBVSxDQUFDLG9CQUFvQixJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsd0VBQXdFLENBQUMsVUFBVSxDQUFDLG9CQUFvQixDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ3ZPLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyx1QkFBdUIsRUFBRSx1QkFBdUIsRUFBRSxVQUFVLENBQUMscUJBQXFCLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyx5RUFBeUUsQ0FBQyxVQUFVLENBQUMscUJBQXFCLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDNU8sR0FBRyxDQUFDLGlCQUFpQixDQUFDLDJDQUEyQyxFQUFFLDJDQUEyQyxFQUFFLFVBQVUsQ0FBQyx5Q0FBeUMsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLHlDQUF5QyxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ3pSLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyx5QkFBeUIsRUFBRSx5QkFBeUIsRUFBRSxVQUFVLENBQUMsdUJBQXVCLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyx1QkFBdUIsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUNsTixHQUFHLENBQUMsaUJBQWlCLENBQUMsdUNBQXVDLEVBQUUsdUNBQXVDLEVBQUUsVUFBVSxDQUFDLHFDQUFxQyxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMscUNBQXFDLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDelEsR0FBRyxDQUFDLGlCQUFpQixDQUFDLHFCQUFxQixFQUFFLHFCQUFxQixFQUFFLFVBQVUsQ0FBQyxtQkFBbUIsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLHVFQUF1RSxDQUFDLFVBQVUsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUNsTyxHQUFHLENBQUMsaUJBQWlCLENBQUMsV0FBVyxFQUFFLFdBQVcsRUFBRSxVQUFVLENBQUMsU0FBUyxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsNkRBQTZELENBQUMsVUFBVSxDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUNoTCxHQUFHLENBQUMsZ0NBQWdDLENBQUMsVUFBVSxDQUFDLENBQUM7SUFDakQsT0FBTyxHQUFHLENBQUM7QUFDZixDQUFDO0FBbUZEOzs7Ozs7R0FNRztBQUNILFNBQVMsMERBQTBELENBQUMsVUFBZTtJQUMvRSxJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sR0FBRyxDQUFDLGtCQUFrQixDQUFDO0tBQUU7SUFDbkUsTUFBTSxNQUFNLEdBQUcsSUFBSSxHQUFHLENBQUMsaUJBQWlCLEVBQUUsQ0FBQztJQUMzQyxJQUFJLE9BQU8sVUFBVSxLQUFLLFFBQVEsRUFBRTtRQUNoQyxNQUFNLENBQUMsT0FBTyxDQUFDLElBQUksR0FBRyxDQUFDLGdCQUFnQixDQUFDLG9DQUFvQyxHQUFHLElBQUksQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxDQUFDO0tBQy9HO0lBQ0QsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsNEJBQTRCLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQywwQkFBMEIsQ0FBQyxDQUFDLENBQUM7SUFDL0gsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsc0JBQXNCLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDLENBQUM7SUFDbkgsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMscUNBQXFDLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxtQ0FBbUMsQ0FBQyxDQUFDLENBQUM7SUFDakosTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsd0JBQXdCLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDLENBQUM7SUFDdkgsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsbUJBQW1CLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLENBQUM7SUFDN0csTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsY0FBYyxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsWUFBWSxDQUFDLENBQUMsQ0FBQztJQUNuRyxPQUFPLE1BQU0sQ0FBQyxJQUFJLENBQUMscUVBQXFFLENBQUMsQ0FBQztBQUM5RixDQUFDO0FBRUQ7Ozs7OztHQU1HO0FBQ0gsb0JBQW9CO0FBQ3BCLFNBQVMsZ0VBQWdFLENBQUMsVUFBZTtJQUNyRixJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sVUFBVSxDQUFDO0tBQUU7SUFDdkQsMERBQTBELENBQUMsVUFBVSxDQUFDLENBQUMsYUFBYSxFQUFFLENBQUM7SUFDdkYsT0FBTztRQUNILDBCQUEwQixFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsMEJBQTBCLENBQUM7UUFDN0Ysb0JBQW9CLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxvQkFBb0IsQ0FBQztRQUNqRixtQ0FBbUMsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLG1DQUFtQyxDQUFDO1FBQy9HLHNCQUFzQixFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsc0JBQXNCLENBQUM7UUFDckYsaUJBQWlCLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxpQkFBaUIsQ0FBQztRQUMzRSxZQUFZLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxZQUFZLENBQUM7S0FDcEUsQ0FBQztBQUNOLENBQUM7QUFFRCxvQkFBb0I7QUFDcEIsU0FBUyxrRUFBa0UsQ0FBQyxVQUFlO0lBQ3ZGLElBQUksR0FBRyxDQUFDLGtCQUFrQixDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQ3BDLE9BQU8sSUFBSSxTQUFTLENBQUMsd0JBQXdCLENBQUMsVUFBVSxDQUFDLENBQUM7S0FDN0Q7SUFDRCxVQUFVLEdBQUcsVUFBVSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUM7SUFDbEQsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsT0FBTyxJQUFJLFNBQVMsQ0FBQyx3QkFBd0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztLQUM3RDtJQUNELE1BQU0sR0FBRyxHQUFHLElBQUksU0FBUyxDQUFDLGdDQUFnQyxFQUFxRCxDQUFDO0lBQ2hILEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyw0QkFBNEIsRUFBRSw0QkFBNEIsRUFBRSxVQUFVLENBQUMsMEJBQTBCLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQywwQkFBMEIsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUM3TixHQUFHLENBQUMsaUJBQWlCLENBQUMsc0JBQXNCLEVBQUUsc0JBQXNCLEVBQUUsVUFBVSxDQUFDLG9CQUFvQixJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsb0JBQW9CLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDck0sR0FBRyxDQUFDLGlCQUFpQixDQUFDLHFDQUFxQyxFQUFFLHFDQUFxQyxFQUFFLFVBQVUsQ0FBQyxtQ0FBbUMsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLG1DQUFtQyxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ2pRLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyx3QkFBd0IsRUFBRSx3QkFBd0IsRUFBRSxVQUFVLENBQUMsc0JBQXNCLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUM3TSxHQUFHLENBQUMsaUJBQWlCLENBQUMsbUJBQW1CLEVBQUUsbUJBQW1CLEVBQUUsVUFBVSxDQUFDLGlCQUFpQixJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDekwsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGNBQWMsRUFBRSxjQUFjLEVBQUUsVUFBVSxDQUFDLFlBQVksSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLFlBQVksQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUNySyxHQUFHLENBQUMsZ0NBQWdDLENBQUMsVUFBVSxDQUFDLENBQUM7SUFDakQsT0FBTyxHQUFHLENBQUM7QUFDZixDQUFDO0FBNkJEOzs7Ozs7R0FNRztBQUNILFNBQVMsbURBQW1ELENBQUMsVUFBZTtJQUN4RSxJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sR0FBRyxDQUFDLGtCQUFrQixDQUFDO0tBQUU7SUFDbkUsTUFBTSxNQUFNLEdBQUcsSUFBSSxHQUFHLENBQUMsaUJBQWlCLEVBQUUsQ0FBQztJQUMzQyxJQUFJLE9BQU8sVUFBVSxLQUFLLFFBQVEsRUFBRTtRQUNoQyxNQUFNLENBQUMsT0FBTyxDQUFDLElBQUksR0FBRyxDQUFDLGdCQUFnQixDQUFDLG9DQUFvQyxHQUFHLElBQUksQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxDQUFDO0tBQy9HO0lBQ0QsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsNkJBQTZCLEVBQUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLENBQUMsVUFBVSxDQUFDLDJCQUEyQixDQUFDLENBQUMsQ0FBQztJQUNwSSxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyw2QkFBNkIsRUFBRSxnRUFBZ0UsQ0FBQyxDQUFDLFVBQVUsQ0FBQywyQkFBMkIsQ0FBQyxDQUFDLENBQUM7SUFDL0ssTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsV0FBVyxFQUFFLEdBQUcsQ0FBQyxhQUFhLENBQUMsNERBQTRELENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQUMsQ0FBQyxDQUFDO0lBQzFKLE9BQU8sTUFBTSxDQUFDLElBQUksQ0FBQyw4REFBOEQsQ0FBQyxDQUFDO0FBQ3ZGLENBQUM7QUFFRDs7Ozs7O0dBTUc7QUFDSCxvQkFBb0I7QUFDcEIsU0FBUyx5REFBeUQsQ0FBQyxVQUFlO0lBQzlFLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxVQUFVLENBQUM7S0FBRTtJQUN2RCxtREFBbUQsQ0FBQyxVQUFVLENBQUMsQ0FBQyxhQUFhLEVBQUUsQ0FBQztJQUNoRixPQUFPO1FBQ0gsMkJBQTJCLEVBQUUsc0VBQXNFLENBQUMsVUFBVSxDQUFDLDJCQUEyQixDQUFDO1FBQzNJLFNBQVMsRUFBRSxHQUFHLENBQUMsVUFBVSxDQUFDLGtFQUFrRSxDQUFDLENBQUMsVUFBVSxDQUFDLFNBQVMsQ0FBQztLQUN0SCxDQUFDO0FBQ04sQ0FBQztBQUVELG9CQUFvQjtBQUNwQixTQUFTLDJEQUEyRCxDQUFDLFVBQWU7SUFDaEYsSUFBSSxHQUFHLENBQUMsa0JBQWtCLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFDcEMsT0FBTyxJQUFJLFNBQVMsQ0FBQyx3QkFBd0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztLQUM3RDtJQUNELFVBQVUsR0FBRyxVQUFVLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQztJQUNsRCxJQUFJLE9BQU8sVUFBVSxLQUFLLFFBQVEsRUFBRTtRQUNoQyxPQUFPLElBQUksU0FBUyxDQUFDLHdCQUF3QixDQUFDLFVBQVUsQ0FBQyxDQUFDO0tBQzdEO0lBQ0QsTUFBTSxHQUFHLEdBQUcsSUFBSSxTQUFTLENBQUMsZ0NBQWdDLEVBQThDLENBQUM7SUFDekcsR0FBRyxDQUFDLGlCQUFpQixDQUFDLDZCQUE2QixFQUFFLDZCQUE2QixFQUFFLHdFQUF3RSxDQUFDLFVBQVUsQ0FBQywyQkFBMkIsQ0FBQyxDQUFDLENBQUM7SUFDdE0sR0FBRyxDQUFDLGlCQUFpQixDQUFDLFdBQVcsRUFBRSxXQUFXLEVBQUUsVUFBVSxDQUFDLFNBQVMsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxRQUFRLENBQUMsb0VBQW9FLENBQUMsQ0FBQyxVQUFVLENBQUMsU0FBUyxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQzlOLEdBQUcsQ0FBQyxnQ0FBZ0MsQ0FBQyxVQUFVLENBQUMsQ0FBQztJQUNqRCxPQUFPLEdBQUcsQ0FBQztBQUNmLENBQUM7QUE0REQ7Ozs7OztHQU1HO0FBQ0gsU0FBUyw0REFBNEQsQ0FBQyxVQUFlO0lBQ2pGLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxHQUFHLENBQUMsa0JBQWtCLENBQUM7S0FBRTtJQUNuRSxNQUFNLE1BQU0sR0FBRyxJQUFJLEdBQUcsQ0FBQyxpQkFBaUIsRUFBRSxDQUFDO0lBQzNDLElBQUksT0FBTyxVQUFVLEtBQUssUUFBUSxFQUFFO1FBQ2hDLE1BQU0sQ0FBQyxPQUFPLENBQUMsSUFBSSxHQUFHLENBQUMsZ0JBQWdCLENBQUMsb0NBQW9DLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLENBQUM7S0FDL0c7SUFDRCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxzQkFBc0IsRUFBRSx5REFBeUQsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDLENBQUM7SUFDMUosTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsY0FBYyxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsWUFBWSxDQUFDLENBQUMsQ0FBQztJQUNuRyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyw2QkFBNkIsRUFBRSxnRUFBZ0UsQ0FBQyxDQUFDLFVBQVUsQ0FBQywyQkFBMkIsQ0FBQyxDQUFDLENBQUM7SUFDL0ssTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsa0JBQWtCLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDLENBQUM7SUFDM0csT0FBTyxNQUFNLENBQUMsSUFBSSxDQUFDLHVFQUF1RSxDQUFDLENBQUM7QUFDaEcsQ0FBQztBQUVEOzs7Ozs7R0FNRztBQUNILG9CQUFvQjtBQUNwQixTQUFTLGtFQUFrRSxDQUFDLFVBQWU7SUFDdkYsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLFVBQVUsQ0FBQztLQUFFO0lBQ3ZELDREQUE0RCxDQUFDLFVBQVUsQ0FBQyxDQUFDLGFBQWEsRUFBRSxDQUFDO0lBQ3pGLE9BQU87UUFDSCxvQkFBb0IsRUFBRSwrREFBK0QsQ0FBQyxVQUFVLENBQUMsb0JBQW9CLENBQUM7UUFDdEgsWUFBWSxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsWUFBWSxDQUFDO1FBQ2pFLDJCQUEyQixFQUFFLHNFQUFzRSxDQUFDLFVBQVUsQ0FBQywyQkFBMkIsQ0FBQztRQUMzSSxnQkFBZ0IsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLGdCQUFnQixDQUFDO0tBQzVFLENBQUM7QUFDTixDQUFDO0FBRUQsb0JBQW9CO0FBQ3BCLFNBQVMsb0VBQW9FLENBQUMsVUFBZTtJQUN6RixJQUFJLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUNwQyxPQUFPLElBQUksU0FBUyxDQUFDLHdCQUF3QixDQUFDLFVBQVUsQ0FBQyxDQUFDO0tBQzdEO0lBQ0QsVUFBVSxHQUFHLFVBQVUsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDO0lBQ2xELElBQUksT0FBTyxVQUFVLEtBQUssUUFBUSxFQUFFO1FBQ2hDLE9BQU8sSUFBSSxTQUFTLENBQUMsd0JBQXdCLENBQUMsVUFBVSxDQUFDLENBQUM7S0FDN0Q7SUFDRCxNQUFNLEdBQUcsR0FBRyxJQUFJLFNBQVMsQ0FBQyxnQ0FBZ0MsRUFBdUQsQ0FBQztJQUNsSCxHQUFHLENBQUMsaUJBQWlCLENBQUMsc0JBQXNCLEVBQUUsc0JBQXNCLEVBQUUsVUFBVSxDQUFDLG9CQUFvQixJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsaUVBQWlFLENBQUMsVUFBVSxDQUFDLG9CQUFvQixDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ2hPLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxjQUFjLEVBQUUsY0FBYyxFQUFFLFVBQVUsQ0FBQyxZQUFZLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxZQUFZLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDckssR0FBRyxDQUFDLGlCQUFpQixDQUFDLDZCQUE2QixFQUFFLDZCQUE2QixFQUFFLFVBQVUsQ0FBQywyQkFBMkIsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLHdFQUF3RSxDQUFDLFVBQVUsQ0FBQywyQkFBMkIsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUNuUSxHQUFHLENBQUMsaUJBQWlCLENBQUMsa0JBQWtCLEVBQUUsa0JBQWtCLEVBQUUsVUFBVSxDQUFDLGdCQUFnQixJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsZ0JBQWdCLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDckwsR0FBRyxDQUFDLGdDQUFnQyxDQUFDLFVBQVUsQ0FBQyxDQUFDO0lBQ2pELE9BQU8sR0FBRyxDQUFDO0FBQ2YsQ0FBQztBQW9ERDs7Ozs7O0dBTUc7QUFDSCxTQUFTLGdFQUFnRSxDQUFDLFVBQWU7SUFDckYsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQztLQUFFO0lBQ25FLE1BQU0sTUFBTSxHQUFHLElBQUksR0FBRyxDQUFDLGlCQUFpQixFQUFFLENBQUM7SUFDM0MsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsTUFBTSxDQUFDLE9BQU8sQ0FBQyxJQUFJLEdBQUcsQ0FBQyxnQkFBZ0IsQ0FBQyxvQ0FBb0MsR0FBRyxJQUFJLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUMsQ0FBQztLQUMvRztJQUNELE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGtCQUFrQixFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsZ0JBQWdCLENBQUMsQ0FBQyxDQUFDO0lBQzNHLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLG9CQUFvQixFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsa0JBQWtCLENBQUMsQ0FBQyxDQUFDO0lBQy9HLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFNBQVMsRUFBRSxHQUFHLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxVQUFVLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQztJQUM1RixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxTQUFTLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDO0lBQ3pGLE9BQU8sTUFBTSxDQUFDLElBQUksQ0FBQywyRUFBMkUsQ0FBQyxDQUFDO0FBQ3BHLENBQUM7QUFFRDs7Ozs7O0dBTUc7QUFDSCxvQkFBb0I7QUFDcEIsU0FBUyxzRUFBc0UsQ0FBQyxVQUFlO0lBQzNGLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxVQUFVLENBQUM7S0FBRTtJQUN2RCxnRUFBZ0UsQ0FBQyxVQUFVLENBQUMsQ0FBQyxhQUFhLEVBQUUsQ0FBQztJQUM3RixPQUFPO1FBQ0gsZ0JBQWdCLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxnQkFBZ0IsQ0FBQztRQUN6RSxrQkFBa0IsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLGtCQUFrQixDQUFDO1FBQzdFLE9BQU8sRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLE9BQU8sQ0FBQztLQUMxRCxDQUFDO0FBQ04sQ0FBQztBQUVELG9CQUFvQjtBQUNwQixTQUFTLHdFQUF3RSxDQUFDLFVBQWU7SUFDN0YsSUFBSSxHQUFHLENBQUMsa0JBQWtCLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFDcEMsT0FBTyxJQUFJLFNBQVMsQ0FBQyx3QkFBd0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztLQUM3RDtJQUNELFVBQVUsR0FBRyxVQUFVLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQztJQUNsRCxJQUFJLE9BQU8sVUFBVSxLQUFLLFFBQVEsRUFBRTtRQUNoQyxPQUFPLElBQUksU0FBUyxDQUFDLHdCQUF3QixDQUFDLFVBQVUsQ0FBQyxDQUFDO0tBQzdEO0lBQ0QsTUFBTSxHQUFHLEdBQUcsSUFBSSxTQUFTLENBQUMsZ0NBQWdDLEVBQTJELENBQUM7SUFDdEgsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGtCQUFrQixFQUFFLGtCQUFrQixFQUFFLFVBQVUsQ0FBQyxnQkFBZ0IsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLGdCQUFnQixDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ3JMLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxvQkFBb0IsRUFBRSxvQkFBb0IsRUFBRSxVQUFVLENBQUMsa0JBQWtCLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUM3TCxHQUFHLENBQUMsaUJBQWlCLENBQUMsU0FBUyxFQUFFLFNBQVMsRUFBRSxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDO0lBQ3hHLEdBQUcsQ0FBQyxnQ0FBZ0MsQ0FBQyxVQUFVLENBQUMsQ0FBQztJQUNqRCxPQUFPLEdBQUcsQ0FBQztBQUNmLENBQUM7QUFrRUQ7Ozs7OztHQU1HO0FBQ0gsU0FBUywrREFBK0QsQ0FBQyxVQUFlO0lBQ3BGLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxHQUFHLENBQUMsa0JBQWtCLENBQUM7S0FBRTtJQUNuRSxNQUFNLE1BQU0sR0FBRyxJQUFJLEdBQUcsQ0FBQyxpQkFBaUIsRUFBRSxDQUFDO0lBQzNDLElBQUksT0FBTyxVQUFVLEtBQUssUUFBUSxFQUFFO1FBQ2hDLE1BQU0sQ0FBQyxPQUFPLENBQUMsSUFBSSxHQUFHLENBQUMsZ0JBQWdCLENBQUMsb0NBQW9DLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLENBQUM7S0FDL0c7SUFDRCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxlQUFlLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxhQUFhLENBQUMsQ0FBQyxDQUFDO0lBQ3JHLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGtCQUFrQixFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsZ0JBQWdCLENBQUMsQ0FBQyxDQUFDO0lBQzNHLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLG1CQUFtQixFQUFFLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLENBQUM7SUFDaEgsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsbUJBQW1CLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLENBQUM7SUFDN0csTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMscUJBQXFCLEVBQUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLENBQUMsVUFBVSxDQUFDLG1CQUFtQixDQUFDLENBQUMsQ0FBQztJQUNwSCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxxQkFBcUIsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLG1CQUFtQixDQUFDLENBQUMsQ0FBQztJQUNqSCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxzQkFBc0IsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLG9CQUFvQixDQUFDLENBQUMsQ0FBQztJQUNuSCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyx1QkFBdUIsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLHFCQUFxQixDQUFDLENBQUMsQ0FBQztJQUNySCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxTQUFTLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDO0lBQ3pGLE9BQU8sTUFBTSxDQUFDLElBQUksQ0FBQywwRUFBMEUsQ0FBQyxDQUFDO0FBQ25HLENBQUM7QUFFRDs7Ozs7O0dBTUc7QUFDSCxvQkFBb0I7QUFDcEIsU0FBUyxxRUFBcUUsQ0FBQyxVQUFlO0lBQzFGLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxVQUFVLENBQUM7S0FBRTtJQUN2RCwrREFBK0QsQ0FBQyxVQUFVLENBQUMsQ0FBQyxhQUFhLEVBQUUsQ0FBQztJQUM1RixPQUFPO1FBQ0gsYUFBYSxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsYUFBYSxDQUFDO1FBQ25FLGdCQUFnQixFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsZ0JBQWdCLENBQUM7UUFDekUsaUJBQWlCLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxpQkFBaUIsQ0FBQztRQUMzRSxtQkFBbUIsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLG1CQUFtQixDQUFDO1FBQy9FLG9CQUFvQixFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsb0JBQW9CLENBQUM7UUFDakYscUJBQXFCLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxxQkFBcUIsQ0FBQztRQUNuRixPQUFPLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUM7S0FDMUQsQ0FBQztBQUNOLENBQUM7QUFFRCxvQkFBb0I7QUFDcEIsU0FBUyx1RUFBdUUsQ0FBQyxVQUFlO0lBQzVGLElBQUksR0FBRyxDQUFDLGtCQUFrQixDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQ3BDLE9BQU8sSUFBSSxTQUFTLENBQUMsd0JBQXdCLENBQUMsVUFBVSxDQUFDLENBQUM7S0FDN0Q7SUFDRCxVQUFVLEdBQUcsVUFBVSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUM7SUFDbEQsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsT0FBTyxJQUFJLFNBQVMsQ0FBQyx3QkFBd0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztLQUM3RDtJQUNELE1BQU0sR0FBRyxHQUFHLElBQUksU0FBUyxDQUFDLGdDQUFnQyxFQUEwRCxDQUFDO0lBQ3JILEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxlQUFlLEVBQUUsZUFBZSxFQUFFLFVBQVUsQ0FBQyxhQUFhLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxhQUFhLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDekssR0FBRyxDQUFDLGlCQUFpQixDQUFDLGtCQUFrQixFQUFFLGtCQUFrQixFQUFFLFVBQVUsQ0FBQyxnQkFBZ0IsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLGdCQUFnQixDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ3JMLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxtQkFBbUIsRUFBRSxtQkFBbUIsRUFBRSxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLENBQUM7SUFDdEksR0FBRyxDQUFDLGlCQUFpQixDQUFDLHFCQUFxQixFQUFFLHFCQUFxQixFQUFFLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLG1CQUFtQixDQUFDLENBQUMsQ0FBQztJQUM1SSxHQUFHLENBQUMsaUJBQWlCLENBQUMsc0JBQXNCLEVBQUUsc0JBQXNCLEVBQUUsVUFBVSxDQUFDLG9CQUFvQixJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsb0JBQW9CLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDck0sR0FBRyxDQUFDLGlCQUFpQixDQUFDLHVCQUF1QixFQUFFLHVCQUF1QixFQUFFLFVBQVUsQ0FBQyxxQkFBcUIsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLHFCQUFxQixDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ3pNLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxTQUFTLEVBQUUsU0FBUyxFQUFFLFVBQVUsQ0FBQyxPQUFPLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDakosR0FBRyxDQUFDLGdDQUFnQyxDQUFDLFVBQVUsQ0FBQyxDQUFDO0lBQ2pELE9BQU8sR0FBRyxDQUFDO0FBQ2YsQ0FBQztBQTJCRDs7Ozs7O0dBTUc7QUFDSCxTQUFTLDREQUE0RCxDQUFDLFVBQWU7SUFDakYsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQztLQUFFO0lBQ25FLE1BQU0sTUFBTSxHQUFHLElBQUksR0FBRyxDQUFDLGlCQUFpQixFQUFFLENBQUM7SUFDM0MsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsTUFBTSxDQUFDLE9BQU8sQ0FBQyxJQUFJLEdBQUcsQ0FBQyxnQkFBZ0IsQ0FBQyxvQ0FBb0MsR0FBRyxJQUFJLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUMsQ0FBQztLQUMvRztJQUNELE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLEtBQUssRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUM7SUFDakYsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsS0FBSyxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQztJQUNqRixPQUFPLE1BQU0sQ0FBQyxJQUFJLENBQUMsdUVBQXVFLENBQUMsQ0FBQztBQUNoRyxDQUFDO0FBRUQ7Ozs7OztHQU1HO0FBQ0gsb0JBQW9CO0FBQ3BCLFNBQVMsa0VBQWtFLENBQUMsVUFBZTtJQUN2RixJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sVUFBVSxDQUFDO0tBQUU7SUFDdkQsNERBQTRELENBQUMsVUFBVSxDQUFDLENBQUMsYUFBYSxFQUFFLENBQUM7SUFDekYsT0FBTztRQUNILEdBQUcsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQztRQUMvQyxHQUFHLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUM7S0FDbEQsQ0FBQztBQUNOLENBQUM7QUFFRCxvQkFBb0I7QUFDcEIsU0FBUyxvRUFBb0UsQ0FBQyxVQUFlO0lBQ3pGLElBQUksR0FBRyxDQUFDLGtCQUFrQixDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQ3BDLE9BQU8sSUFBSSxTQUFTLENBQUMsd0JBQXdCLENBQUMsVUFBVSxDQUFDLENBQUM7S0FDN0Q7SUFDRCxVQUFVLEdBQUcsVUFBVSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUM7SUFDbEQsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsT0FBTyxJQUFJLFNBQVMsQ0FBQyx3QkFBd0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztLQUM3RDtJQUNELE1BQU0sR0FBRyxHQUFHLElBQUksU0FBUyxDQUFDLGdDQUFnQyxFQUF1RCxDQUFDO0lBQ2xILEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxLQUFLLEVBQUUsS0FBSyxFQUFFLFVBQVUsQ0FBQyxHQUFHLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDakksR0FBRyxDQUFDLGlCQUFpQixDQUFDLEtBQUssRUFBRSxLQUFLLEVBQUUsVUFBVSxDQUFDLEdBQUcsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUNqSSxHQUFHLENBQUMsZ0NBQWdDLENBQUMsVUFBVSxDQUFDLENBQUM7SUFDakQsT0FBTyxHQUFHLENBQUM7QUFDZixDQUFDO0FBMkJEOzs7Ozs7R0FNRztBQUNILFNBQVMscURBQXFELENBQUMsVUFBZTtJQUMxRSxJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sR0FBRyxDQUFDLGtCQUFrQixDQUFDO0tBQUU7SUFDbkUsTUFBTSxNQUFNLEdBQUcsSUFBSSxHQUFHLENBQUMsaUJBQWlCLEVBQUUsQ0FBQztJQUMzQyxJQUFJLE9BQU8sVUFBVSxLQUFLLFFBQVEsRUFBRTtRQUNoQyxNQUFNLENBQUMsT0FBTyxDQUFDLElBQUksR0FBRyxDQUFDLGdCQUFnQixDQUFDLG9DQUFvQyxHQUFHLElBQUksQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxDQUFDO0tBQy9HO0lBQ0QsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsS0FBSyxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQztJQUNqRixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxLQUFLLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDO0lBQ2pGLE9BQU8sTUFBTSxDQUFDLElBQUksQ0FBQyxnRUFBZ0UsQ0FBQyxDQUFDO0FBQ3pGLENBQUM7QUFFRDs7Ozs7O0dBTUc7QUFDSCxvQkFBb0I7QUFDcEIsU0FBUywyREFBMkQsQ0FBQyxVQUFlO0lBQ2hGLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxVQUFVLENBQUM7S0FBRTtJQUN2RCxxREFBcUQsQ0FBQyxVQUFVLENBQUMsQ0FBQyxhQUFhLEVBQUUsQ0FBQztJQUNsRixPQUFPO1FBQ0gsR0FBRyxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDO1FBQy9DLEdBQUcsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQztLQUNsRCxDQUFDO0FBQ04sQ0FBQztBQUVELG9CQUFvQjtBQUNwQixTQUFTLDZEQUE2RCxDQUFDLFVBQWU7SUFDbEYsSUFBSSxHQUFHLENBQUMsa0JBQWtCLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFDcEMsT0FBTyxJQUFJLFNBQVMsQ0FBQyx3QkFBd0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztLQUM3RDtJQUNELFVBQVUsR0FBRyxVQUFVLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQztJQUNsRCxJQUFJLE9BQU8sVUFBVSxLQUFLLFFBQVEsRUFBRTtRQUNoQyxPQUFPLElBQUksU0FBUyxDQUFDLHdCQUF3QixDQUFDLFVBQVUsQ0FBQyxDQUFDO0tBQzdEO0lBQ0QsTUFBTSxHQUFHLEdBQUcsSUFBSSxTQUFTLENBQUMsZ0NBQWdDLEVBQWdELENBQUM7SUFDM0csR0FBRyxDQUFDLGlCQUFpQixDQUFDLEtBQUssRUFBRSxLQUFLLEVBQUUsVUFBVSxDQUFDLEdBQUcsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUNqSSxHQUFHLENBQUMsaUJBQWlCLENBQUMsS0FBSyxFQUFFLEtBQUssRUFBRSxVQUFVLENBQUMsR0FBRyxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ2pJLEdBQUcsQ0FBQyxnQ0FBZ0MsQ0FBQyxVQUFVLENBQUMsQ0FBQztJQUNqRCxPQUFPLEdBQUcsQ0FBQztBQUNmLENBQUM7QUF3REQ7Ozs7OztHQU1HO0FBQ0gsU0FBUyxzREFBc0QsQ0FBQyxVQUFlO0lBQzNFLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxHQUFHLENBQUMsa0JBQWtCLENBQUM7S0FBRTtJQUNuRSxNQUFNLE1BQU0sR0FBRyxJQUFJLEdBQUcsQ0FBQyxpQkFBaUIsRUFBRSxDQUFDO0lBQzNDLElBQUksT0FBTyxVQUFVLEtBQUssUUFBUSxFQUFFO1FBQ2hDLE1BQU0sQ0FBQyxPQUFPLENBQUMsSUFBSSxHQUFHLENBQUMsZ0JBQWdCLENBQUMsb0NBQW9DLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLENBQUM7S0FDL0c7SUFDRCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxhQUFhLEVBQUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLENBQUMsVUFBVSxDQUFDLFdBQVcsQ0FBQyxDQUFDLENBQUM7SUFDcEcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsYUFBYSxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsV0FBVyxDQUFDLENBQUMsQ0FBQztJQUNqRyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxTQUFTLEVBQUUsR0FBRyxDQUFDLGFBQWEsQ0FBQyxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQztJQUM1RyxPQUFPLE1BQU0sQ0FBQyxJQUFJLENBQUMsaUVBQWlFLENBQUMsQ0FBQztBQUMxRixDQUFDO0FBRUQ7Ozs7OztHQU1HO0FBQ0gsb0JBQW9CO0FBQ3BCLFNBQVMsNERBQTRELENBQUMsVUFBZTtJQUNqRixJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sVUFBVSxDQUFDO0tBQUU7SUFDdkQsc0RBQXNELENBQUMsVUFBVSxDQUFDLENBQUMsYUFBYSxFQUFFLENBQUM7SUFDbkYsT0FBTztRQUNILFdBQVcsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLFdBQVcsQ0FBQztRQUMvRCxPQUFPLEVBQUUsR0FBRyxDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUMsc0JBQXNCLENBQUMsQ0FBQyxVQUFVLENBQUMsT0FBTyxDQUFDO0tBQzFFLENBQUM7QUFDTixDQUFDO0FBRUQsb0JBQW9CO0FBQ3BCLFNBQVMsOERBQThELENBQUMsVUFBZTtJQUNuRixJQUFJLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUNwQyxPQUFPLElBQUksU0FBUyxDQUFDLHdCQUF3QixDQUFDLFVBQVUsQ0FBQyxDQUFDO0tBQzdEO0lBQ0QsVUFBVSxHQUFHLFVBQVUsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDO0lBQ2xELElBQUksT0FBTyxVQUFVLEtBQUssUUFBUSxFQUFFO1FBQ2hDLE9BQU8sSUFBSSxTQUFTLENBQUMsd0JBQXdCLENBQUMsVUFBVSxDQUFDLENBQUM7S0FDN0Q7SUFDRCxNQUFNLEdBQUcsR0FBRyxJQUFJLFNBQVMsQ0FBQyxnQ0FBZ0MsRUFBaUQsQ0FBQztJQUM1RyxHQUFHLENBQUMsaUJBQWlCLENBQUMsYUFBYSxFQUFFLGFBQWEsRUFBRSxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxXQUFXLENBQUMsQ0FBQyxDQUFDO0lBQ3BILEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxTQUFTLEVBQUUsU0FBUyxFQUFFLFVBQVUsQ0FBQyxPQUFPLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsY0FBYyxDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDdEosR0FBRyxDQUFDLGdDQUFnQyxDQUFDLFVBQVUsQ0FBQyxDQUFDO0lBQ2pELE9BQU8sR0FBRyxDQUFDO0FBQ2YsQ0FBQztBQXdDRDs7Ozs7O0dBTUc7QUFDSCxTQUFTLHlEQUF5RCxDQUFDLFVBQWU7SUFDOUUsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQztLQUFFO0lBQ25FLE1BQU0sTUFBTSxHQUFHLElBQUksR0FBRyxDQUFDLGlCQUFpQixFQUFFLENBQUM7SUFDM0MsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsTUFBTSxDQUFDLE9BQU8sQ0FBQyxJQUFJLEdBQUcsQ0FBQyxnQkFBZ0IsQ0FBQyxvQ0FBb0MsR0FBRyxJQUFJLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUMsQ0FBQztLQUMvRztJQUNELE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLHVCQUF1QixFQUFFLDBEQUEwRCxDQUFDLENBQUMsVUFBVSxDQUFDLHFCQUFxQixDQUFDLENBQUMsQ0FBQztJQUM3SixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxnQkFBZ0IsRUFBRSxHQUFHLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxVQUFVLENBQUMsY0FBYyxDQUFDLENBQUMsQ0FBQztJQUMxRyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxnQkFBZ0IsRUFBRSxtREFBbUQsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxjQUFjLENBQUMsQ0FBQyxDQUFDO0lBQ3hJLE9BQU8sTUFBTSxDQUFDLElBQUksQ0FBQyxvRUFBb0UsQ0FBQyxDQUFDO0FBQzdGLENBQUM7QUFFRDs7Ozs7O0dBTUc7QUFDSCxvQkFBb0I7QUFDcEIsU0FBUywrREFBK0QsQ0FBQyxVQUFlO0lBQ3BGLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxVQUFVLENBQUM7S0FBRTtJQUN2RCx5REFBeUQsQ0FBQyxVQUFVLENBQUMsQ0FBQyxhQUFhLEVBQUUsQ0FBQztJQUN0RixPQUFPO1FBQ0gscUJBQXFCLEVBQUUsZ0VBQWdFLENBQUMsVUFBVSxDQUFDLHFCQUFxQixDQUFDO1FBQ3pILGNBQWMsRUFBRSx5REFBeUQsQ0FBQyxVQUFVLENBQUMsY0FBYyxDQUFDO0tBQ3ZHLENBQUM7QUFDTixDQUFDO0FBRUQsb0JBQW9CO0FBQ3BCLFNBQVMsaUVBQWlFLENBQUMsVUFBZTtJQUN0RixJQUFJLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUNwQyxPQUFPLElBQUksU0FBUyxDQUFDLHdCQUF3QixDQUFDLFVBQVUsQ0FBQyxDQUFDO0tBQzdEO0lBQ0QsVUFBVSxHQUFHLFVBQVUsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDO0lBQ2xELElBQUksT0FBTyxVQUFVLEtBQUssUUFBUSxFQUFFO1FBQ2hDLE9BQU8sSUFBSSxTQUFTLENBQUMsd0JBQXdCLENBQUMsVUFBVSxDQUFDLENBQUM7S0FDN0Q7SUFDRCxNQUFNLEdBQUcsR0FBRyxJQUFJLFNBQVMsQ0FBQyxnQ0FBZ0MsRUFBb0QsQ0FBQztJQUMvRyxHQUFHLENBQUMsaUJBQWlCLENBQUMsdUJBQXVCLEVBQUUsdUJBQXVCLEVBQUUsVUFBVSxDQUFDLHFCQUFxQixJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsa0VBQWtFLENBQUMsVUFBVSxDQUFDLHFCQUFxQixDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ3JPLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxnQkFBZ0IsRUFBRSxnQkFBZ0IsRUFBRSwyREFBMkQsQ0FBQyxVQUFVLENBQUMsY0FBYyxDQUFDLENBQUMsQ0FBQztJQUNsSixHQUFHLENBQUMsZ0NBQWdDLENBQUMsVUFBVSxDQUFDLENBQUM7SUFDakQsT0FBTyxHQUFHLENBQUM7QUFDZixDQUFDO0FBNkJEOzs7Ozs7R0FNRztBQUNILFNBQVMsZ0VBQWdFLENBQUMsVUFBZTtJQUNyRixJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sR0FBRyxDQUFDLGtCQUFrQixDQUFDO0tBQUU7SUFDbkUsTUFBTSxNQUFNLEdBQUcsSUFBSSxHQUFHLENBQUMsaUJBQWlCLEVBQUUsQ0FBQztJQUMzQyxJQUFJLE9BQU8sVUFBVSxLQUFLLFFBQVEsRUFBRTtRQUNoQyxNQUFNLENBQUMsT0FBTyxDQUFDLElBQUksR0FBRyxDQUFDLGdCQUFnQixDQUFDLG9DQUFvQyxHQUFHLElBQUksQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxDQUFDO0tBQy9HO0lBQ0QsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsS0FBSyxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQztJQUNqRixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxLQUFLLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDO0lBQ2pGLE9BQU8sTUFBTSxDQUFDLElBQUksQ0FBQywyRUFBMkUsQ0FBQyxDQUFDO0FBQ3BHLENBQUM7QUFFRDs7Ozs7O0dBTUc7QUFDSCxvQkFBb0I7QUFDcEIsU0FBUyxzRUFBc0UsQ0FBQyxVQUFlO0lBQzNGLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxVQUFVLENBQUM7S0FBRTtJQUN2RCxnRUFBZ0UsQ0FBQyxVQUFVLENBQUMsQ0FBQyxhQUFhLEVBQUUsQ0FBQztJQUM3RixPQUFPO1FBQ0gsR0FBRyxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDO1FBQy9DLEdBQUcsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQztLQUNsRCxDQUFDO0FBQ04sQ0FBQztBQUVELG9CQUFvQjtBQUNwQixTQUFTLHdFQUF3RSxDQUFDLFVBQWU7SUFDN0YsSUFBSSxHQUFHLENBQUMsa0JBQWtCLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFDcEMsT0FBTyxJQUFJLFNBQVMsQ0FBQyx3QkFBd0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztLQUM3RDtJQUNELFVBQVUsR0FBRyxVQUFVLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQztJQUNsRCxJQUFJLE9BQU8sVUFBVSxLQUFLLFFBQVEsRUFBRTtRQUNoQyxPQUFPLElBQUksU0FBUyxDQUFDLHdCQUF3QixDQUFDLFVBQVUsQ0FBQyxDQUFDO0tBQzdEO0lBQ0QsTUFBTSxHQUFHLEdBQUcsSUFBSSxTQUFTLENBQUMsZ0NBQWdDLEVBQTJELENBQUM7SUFDdEgsR0FBRyxDQUFDLGlCQUFpQixDQUFDLEtBQUssRUFBRSxLQUFLLEVBQUUsVUFBVSxDQUFDLEdBQUcsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUNqSSxHQUFHLENBQUMsaUJBQWlCLENBQUMsS0FBSyxFQUFFLEtBQUssRUFBRSxVQUFVLENBQUMsR0FBRyxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ2pJLEdBQUcsQ0FBQyxnQ0FBZ0MsQ0FBQyxVQUFVLENBQUMsQ0FBQztJQUNqRCxPQUFPLEdBQUcsQ0FBQztBQUNmLENBQUM7QUEyQkQ7Ozs7OztHQU1HO0FBQ0gsU0FBUyxpRUFBaUUsQ0FBQyxVQUFlO0lBQ3RGLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxHQUFHLENBQUMsa0JBQWtCLENBQUM7S0FBRTtJQUNuRSxNQUFNLE1BQU0sR0FBRyxJQUFJLEdBQUcsQ0FBQyxpQkFBaUIsRUFBRSxDQUFDO0lBQzNDLElBQUksT0FBTyxVQUFVLEtBQUssUUFBUSxFQUFFO1FBQ2hDLE1BQU0sQ0FBQyxPQUFPLENBQUMsSUFBSSxHQUFHLENBQUMsZ0JBQWdCLENBQUMsb0NBQW9DLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLENBQUM7S0FDL0c7SUFDRCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxLQUFLLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDO0lBQ2pGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLEtBQUssRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUM7SUFDakYsT0FBTyxNQUFNLENBQUMsSUFBSSxDQUFDLDRFQUE0RSxDQUFDLENBQUM7QUFDckcsQ0FBQztBQUVEOzs7Ozs7R0FNRztBQUNILG9CQUFvQjtBQUNwQixTQUFTLHVFQUF1RSxDQUFDLFVBQWU7SUFDNUYsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLFVBQVUsQ0FBQztLQUFFO0lBQ3ZELGlFQUFpRSxDQUFDLFVBQVUsQ0FBQyxDQUFDLGFBQWEsRUFBRSxDQUFDO0lBQzlGLE9BQU87UUFDSCxHQUFHLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUM7UUFDL0MsR0FBRyxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDO0tBQ2xELENBQUM7QUFDTixDQUFDO0FBRUQsb0JBQW9CO0FBQ3BCLFNBQVMseUVBQXlFLENBQUMsVUFBZTtJQUM5RixJQUFJLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUNwQyxPQUFPLElBQUksU0FBUyxDQUFDLHdCQUF3QixDQUFDLFVBQVUsQ0FBQyxDQUFDO0tBQzdEO0lBQ0QsVUFBVSxHQUFHLFVBQVUsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDO0lBQ2xELElBQUksT0FBTyxVQUFVLEtBQUssUUFBUSxFQUFFO1FBQ2hDLE9BQU8sSUFBSSxTQUFTLENBQUMsd0JBQXdCLENBQUMsVUFBVSxDQUFDLENBQUM7S0FDN0Q7SUFDRCxNQUFNLEdBQUcsR0FBRyxJQUFJLFNBQVMsQ0FBQyxnQ0FBZ0MsRUFBNEQsQ0FBQztJQUN2SCxHQUFHLENBQUMsaUJBQWlCLENBQUMsS0FBSyxFQUFFLEtBQUssRUFBRSxVQUFVLENBQUMsR0FBRyxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ2pJLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxLQUFLLEVBQUUsS0FBSyxFQUFFLFVBQVUsQ0FBQyxHQUFHLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDakksR0FBRyxDQUFDLGdDQUFnQyxDQUFDLFVBQVUsQ0FBQyxDQUFDO0lBQ2pELE9BQU8sR0FBRyxDQUFDO0FBQ2YsQ0FBQztBQXVDRDs7Ozs7O0dBTUc7QUFDSCxTQUFTLDhEQUE4RCxDQUFDLFVBQWU7SUFDbkYsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQztLQUFFO0lBQ25FLE1BQU0sTUFBTSxHQUFHLElBQUksR0FBRyxDQUFDLGlCQUFpQixFQUFFLENBQUM7SUFDM0MsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsTUFBTSxDQUFDLE9BQU8sQ0FBQyxJQUFJLEdBQUcsQ0FBQyxnQkFBZ0IsQ0FBQyxvQ0FBb0MsR0FBRyxJQUFJLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUMsQ0FBQztLQUMvRztJQUNELE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLG1CQUFtQixFQUFFLEdBQUcsQ0FBQyxhQUFhLENBQUMsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDLGlCQUFpQixDQUFDLENBQUMsQ0FBQztJQUNoSSxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxVQUFVLEVBQUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLENBQUMsVUFBVSxDQUFDLFFBQVEsQ0FBQyxDQUFDLENBQUM7SUFDOUYsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsVUFBVSxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsUUFBUSxDQUFDLENBQUMsQ0FBQztJQUMzRixPQUFPLE1BQU0sQ0FBQyxJQUFJLENBQUMseUVBQXlFLENBQUMsQ0FBQztBQUNsRyxDQUFDO0FBRUQ7Ozs7OztHQU1HO0FBQ0gsb0JBQW9CO0FBQ3BCLFNBQVMsb0VBQW9FLENBQUMsVUFBZTtJQUN6RixJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sVUFBVSxDQUFDO0tBQUU7SUFDdkQsOERBQThELENBQUMsVUFBVSxDQUFDLENBQUMsYUFBYSxFQUFFLENBQUM7SUFDM0YsT0FBTztRQUNILGlCQUFpQixFQUFFLEdBQUcsQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDLHNCQUFzQixDQUFDLENBQUMsVUFBVSxDQUFDLGlCQUFpQixDQUFDO1FBQzNGLFFBQVEsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLFFBQVEsQ0FBQztLQUM1RCxDQUFDO0FBQ04sQ0FBQztBQUVELG9CQUFvQjtBQUNwQixTQUFTLHNFQUFzRSxDQUFDLFVBQWU7SUFDM0YsSUFBSSxHQUFHLENBQUMsa0JBQWtCLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFDcEMsT0FBTyxJQUFJLFNBQVMsQ0FBQyx3QkFBd0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztLQUM3RDtJQUNELFVBQVUsR0FBRyxVQUFVLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQztJQUNsRCxJQUFJLE9BQU8sVUFBVSxLQUFLLFFBQVEsRUFBRTtRQUNoQyxPQUFPLElBQUksU0FBUyxDQUFDLHdCQUF3QixDQUFDLFVBQVUsQ0FBQyxDQUFDO0tBQzdEO0lBQ0QsTUFBTSxHQUFHLEdBQUcsSUFBSSxTQUFTLENBQUMsZ0NBQWdDLEVBQXlELENBQUM7SUFDcEgsR0FBRyxDQUFDLGlCQUFpQixDQUFDLG1CQUFtQixFQUFFLG1CQUFtQixFQUFFLFVBQVUsQ0FBQyxpQkFBaUIsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxjQUFjLENBQUMsVUFBVSxDQUFDLGlCQUFpQixDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQzlMLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxVQUFVLEVBQUUsVUFBVSxFQUFFLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLFFBQVEsQ0FBQyxDQUFDLENBQUM7SUFDM0csR0FBRyxDQUFDLGdDQUFnQyxDQUFDLFVBQVUsQ0FBQyxDQUFDO0lBQ2pELE9BQU8sR0FBRyxDQUFDO0FBQ2YsQ0FBQztBQXlDRDs7Ozs7O0dBTUc7QUFDSCxTQUFTLGdEQUFnRCxDQUFDLFVBQWU7SUFDckUsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQztLQUFFO0lBQ25FLE1BQU0sTUFBTSxHQUFHLElBQUksR0FBRyxDQUFDLGlCQUFpQixFQUFFLENBQUM7SUFDM0MsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsTUFBTSxDQUFDLE9BQU8sQ0FBQyxJQUFJLEdBQUcsQ0FBQyxnQkFBZ0IsQ0FBQyxvQ0FBb0MsR0FBRyxJQUFJLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUMsQ0FBQztLQUMvRztJQUNELE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLEtBQUssRUFBRSxHQUFHLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQztJQUNwRixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxLQUFLLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDO0lBQ2pGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLG1CQUFtQixFQUFFLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLENBQUM7SUFDaEgsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsbUJBQW1CLEVBQUUsR0FBRyxDQUFDLGVBQWUsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLENBQUM7SUFDOUcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsT0FBTyxFQUFFLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDO0lBQ3hGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLE9BQU8sRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUM7SUFDckYsT0FBTyxNQUFNLENBQUMsSUFBSSxDQUFDLDJEQUEyRCxDQUFDLENBQUM7QUFDcEYsQ0FBQztBQUVEOzs7Ozs7R0FNRztBQUNILG9CQUFvQjtBQUNwQixTQUFTLHNEQUFzRCxDQUFDLFVBQWU7SUFDM0UsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLFVBQVUsQ0FBQztLQUFFO0lBQ3ZELGdEQUFnRCxDQUFDLFVBQVUsQ0FBQyxDQUFDLGFBQWEsRUFBRSxDQUFDO0lBQzdFLE9BQU87UUFDSCxHQUFHLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUM7UUFDL0MsaUJBQWlCLEVBQUUsR0FBRyxDQUFDLHVCQUF1QixDQUFDLFVBQVUsQ0FBQyxpQkFBaUIsQ0FBQztRQUM1RSxLQUFLLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxLQUFLLENBQUM7S0FDdEQsQ0FBQztBQUNOLENBQUM7QUFFRCxvQkFBb0I7QUFDcEIsU0FBUyx3REFBd0QsQ0FBQyxVQUFlO0lBQzdFLElBQUksR0FBRyxDQUFDLGtCQUFrQixDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQ3BDLE9BQU8sSUFBSSxTQUFTLENBQUMsd0JBQXdCLENBQUMsVUFBVSxDQUFDLENBQUM7S0FDN0Q7SUFDRCxVQUFVLEdBQUcsVUFBVSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUM7SUFDbEQsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsT0FBTyxJQUFJLFNBQVMsQ0FBQyx3QkFBd0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztLQUM3RDtJQUNELE1BQU0sR0FBRyxHQUFHLElBQUksU0FBUyxDQUFDLGdDQUFnQyxFQUEyQyxDQUFDO0lBQ3RHLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxLQUFLLEVBQUUsS0FBSyxFQUFFLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUM7SUFDNUYsR0FBRyxDQUFDLGlCQUFpQixDQUFDLG1CQUFtQixFQUFFLG1CQUFtQixFQUFFLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLGlCQUFpQixDQUFDLENBQUMsQ0FBQztJQUN2SSxHQUFHLENBQUMsaUJBQWlCLENBQUMsT0FBTyxFQUFFLE9BQU8sRUFBRSxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDO0lBQ2xHLEdBQUcsQ0FBQyxnQ0FBZ0MsQ0FBQyxVQUFVLENBQUMsQ0FBQztJQUNqRCxPQUFPLEdBQUcsQ0FBQztBQUNmLENBQUM7QUEyQkQ7Ozs7OztHQU1HO0FBQ0gsU0FBUywrREFBK0QsQ0FBQyxVQUFlO0lBQ3BGLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxHQUFHLENBQUMsa0JBQWtCLENBQUM7S0FBRTtJQUNuRSxNQUFNLE1BQU0sR0FBRyxJQUFJLEdBQUcsQ0FBQyxpQkFBaUIsRUFBRSxDQUFDO0lBQzNDLElBQUksT0FBTyxVQUFVLEtBQUssUUFBUSxFQUFFO1FBQ2hDLE1BQU0sQ0FBQyxPQUFPLENBQUMsSUFBSSxHQUFHLENBQUMsZ0JBQWdCLENBQUMsb0NBQW9DLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLENBQUM7S0FDL0c7SUFDRCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxLQUFLLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDO0lBQ2pGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLEtBQUssRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUM7SUFDakYsT0FBTyxNQUFNLENBQUMsSUFBSSxDQUFDLDBFQUEwRSxDQUFDLENBQUM7QUFDbkcsQ0FBQztBQUVEOzs7Ozs7R0FNRztBQUNILG9CQUFvQjtBQUNwQixTQUFTLHFFQUFxRSxDQUFDLFVBQWU7SUFDMUYsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLFVBQVUsQ0FBQztLQUFFO0lBQ3ZELCtEQUErRCxDQUFDLFVBQVUsQ0FBQyxDQUFDLGFBQWEsRUFBRSxDQUFDO0lBQzVGLE9BQU87UUFDSCxHQUFHLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUM7UUFDL0MsR0FBRyxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDO0tBQ2xELENBQUM7QUFDTixDQUFDO0FBRUQsb0JBQW9CO0FBQ3BCLFNBQVMsdUVBQXVFLENBQUMsVUFBZTtJQUM1RixJQUFJLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUNwQyxPQUFPLElBQUksU0FBUyxDQUFDLHdCQUF3QixDQUFDLFVBQVUsQ0FBQyxDQUFDO0tBQzdEO0lBQ0QsVUFBVSxHQUFHLFVBQVUsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDO0lBQ2xELElBQUksT0FBTyxVQUFVLEtBQUssUUFBUSxFQUFFO1FBQ2hDLE9BQU8sSUFBSSxTQUFTLENBQUMsd0JBQXdCLENBQUMsVUFBVSxDQUFDLENBQUM7S0FDN0Q7SUFDRCxNQUFNLEdBQUcsR0FBRyxJQUFJLFNBQVMsQ0FBQyxnQ0FBZ0MsRUFBMEQsQ0FBQztJQUNySCxHQUFHLENBQUMsaUJBQWlCLENBQUMsS0FBSyxFQUFFLEtBQUssRUFBRSxVQUFVLENBQUMsR0FBRyxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ2pJLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxLQUFLLEVBQUUsS0FBSyxFQUFFLFVBQVUsQ0FBQyxHQUFHLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDakksR0FBRyxDQUFDLGdDQUFnQyxDQUFDLFVBQVUsQ0FBQyxDQUFDO0lBQ2pELE9BQU8sR0FBRyxDQUFDO0FBQ2YsQ0FBQztBQTJCRDs7Ozs7O0dBTUc7QUFDSCxTQUFTLHFEQUFxRCxDQUFDLFVBQWU7SUFDMUUsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQztLQUFFO0lBQ25FLE1BQU0sTUFBTSxHQUFHLElBQUksR0FBRyxDQUFDLGlCQUFpQixFQUFFLENBQUM7SUFDM0MsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsTUFBTSxDQUFDLE9BQU8sQ0FBQyxJQUFJLEdBQUcsQ0FBQyxnQkFBZ0IsQ0FBQyxvQ0FBb0MsR0FBRyxJQUFJLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUMsQ0FBQztLQUMvRztJQUNELE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLEtBQUssRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUM7SUFDakYsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsS0FBSyxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQztJQUNqRixPQUFPLE1BQU0sQ0FBQyxJQUFJLENBQUMsZ0VBQWdFLENBQUMsQ0FBQztBQUN6RixDQUFDO0FBRUQ7Ozs7OztHQU1HO0FBQ0gsb0JBQW9CO0FBQ3BCLFNBQVMsMkRBQTJELENBQUMsVUFBZTtJQUNoRixJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sVUFBVSxDQUFDO0tBQUU7SUFDdkQscURBQXFELENBQUMsVUFBVSxDQUFDLENBQUMsYUFBYSxFQUFFLENBQUM7SUFDbEYsT0FBTztRQUNILEdBQUcsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQztRQUMvQyxHQUFHLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUM7S0FDbEQsQ0FBQztBQUNOLENBQUM7QUFFRCxvQkFBb0I7QUFDcEIsU0FBUyw2REFBNkQsQ0FBQyxVQUFlO0lBQ2xGLElBQUksR0FBRyxDQUFDLGtCQUFrQixDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQ3BDLE9BQU8sSUFBSSxTQUFTLENBQUMsd0JBQXdCLENBQUMsVUFBVSxDQUFDLENBQUM7S0FDN0Q7SUFDRCxVQUFVLEdBQUcsVUFBVSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUM7SUFDbEQsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsT0FBTyxJQUFJLFNBQVMsQ0FBQyx3QkFBd0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztLQUM3RDtJQUNELE1BQU0sR0FBRyxHQUFHLElBQUksU0FBUyxDQUFDLGdDQUFnQyxFQUFnRCxDQUFDO0lBQzNHLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxLQUFLLEVBQUUsS0FBSyxFQUFFLFVBQVUsQ0FBQyxHQUFHLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDakksR0FBRyxDQUFDLGlCQUFpQixDQUFDLEtBQUssRUFBRSxLQUFLLEVBQUUsVUFBVSxDQUFDLEdBQUcsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUNqSSxHQUFHLENBQUMsZ0NBQWdDLENBQUMsVUFBVSxDQUFDLENBQUM7SUFDakQsT0FBTyxHQUFHLENBQUM7QUFDZixDQUFDO0FBOEtEOzs7Ozs7R0FNRztBQUNILFNBQVMsb0NBQW9DLENBQUMsVUFBZTtJQUN6RCxJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sR0FBRyxDQUFDLGtCQUFrQixDQUFDO0tBQUU7SUFDbkUsTUFBTSxNQUFNLEdBQUcsSUFBSSxHQUFHLENBQUMsaUJBQWlCLEVBQUUsQ0FBQztJQUMzQyxJQUFJLE9BQU8sVUFBVSxLQUFLLFFBQVEsRUFBRTtRQUNoQyxNQUFNLENBQUMsT0FBTyxDQUFDLElBQUksR0FBRyxDQUFDLGdCQUFnQixDQUFDLG9DQUFvQyxHQUFHLElBQUksQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxDQUFDO0tBQy9HO0lBQ0QsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsMEJBQTBCLEVBQUUsR0FBRyxDQUFDLGVBQWUsQ0FBQyxDQUFDLFVBQVUsQ0FBQyx3QkFBd0IsQ0FBQyxDQUFDLENBQUM7SUFDNUgsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMscUJBQXFCLEVBQUUsR0FBRyxDQUFDLGFBQWEsQ0FBQywwREFBMEQsQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDLG1CQUFtQixDQUFDLENBQUMsQ0FBQztJQUM1SyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxrQkFBa0IsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLGdCQUFnQixDQUFDLENBQUMsQ0FBQztJQUMzRyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyw4QkFBOEIsRUFBRSxHQUFHLENBQUMsYUFBYSxDQUFDLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyw0QkFBNEIsQ0FBQyxDQUFDLENBQUM7SUFDdEosTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsY0FBYyxFQUFFLEdBQUcsQ0FBQyxlQUFlLENBQUMsQ0FBQyxVQUFVLENBQUMsWUFBWSxDQUFDLENBQUMsQ0FBQztJQUNwRyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxvQkFBb0IsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLGtCQUFrQixDQUFDLENBQUMsQ0FBQztJQUMvRyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxTQUFTLEVBQUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLENBQUMsVUFBVSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUM7SUFDNUYsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsU0FBUyxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQztJQUN6RixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxZQUFZLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDO0lBQy9GLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLG9CQUFvQixFQUFFLEdBQUcsQ0FBQyxlQUFlLENBQUMsQ0FBQyxVQUFVLENBQUMsa0JBQWtCLENBQUMsQ0FBQyxDQUFDO0lBQ2hILE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGNBQWMsRUFBRSxHQUFHLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxVQUFVLENBQUMsWUFBWSxDQUFDLENBQUMsQ0FBQztJQUN0RyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxjQUFjLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxZQUFZLENBQUMsQ0FBQyxDQUFDO0lBQ25HLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFVBQVUsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLFFBQVEsQ0FBQyxDQUFDLENBQUM7SUFDM0YsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsU0FBUyxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQztJQUN6RixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyx5QkFBeUIsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLHVCQUF1QixDQUFDLENBQUMsQ0FBQztJQUN6SCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxpQkFBaUIsRUFBRSx1REFBdUQsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxlQUFlLENBQUMsQ0FBQyxDQUFDO0lBQzlJLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGtCQUFrQixFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsZ0JBQWdCLENBQUMsQ0FBQyxDQUFDO0lBQzNHLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFdBQVcsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUM7SUFDN0YsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsZ0JBQWdCLEVBQUUsR0FBRyxDQUFDLGFBQWEsQ0FBQyxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUMsY0FBYyxDQUFDLENBQUMsQ0FBQztJQUMxSCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxXQUFXLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQUMsQ0FBQyxDQUFDO0lBQzdGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFVBQVUsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLFFBQVEsQ0FBQyxDQUFDLENBQUM7SUFDM0YsT0FBTyxNQUFNLENBQUMsSUFBSSxDQUFDLG1FQUFtRSxDQUFDLENBQUM7QUFDNUYsQ0FBQztBQUVEOzs7Ozs7R0FNRztBQUNILG9CQUFvQjtBQUNwQixTQUFTLDJDQUEyQyxDQUFDLFVBQWU7SUFDaEUsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLFVBQVUsQ0FBQztLQUFFO0lBQ3ZELG9DQUFvQyxDQUFDLFVBQVUsQ0FBQyxDQUFDLGFBQWEsRUFBRSxDQUFDO0lBQ2pFLE9BQU87UUFDSCxPQUFPLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUM7UUFDdkQsWUFBWSxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsWUFBWSxDQUFDO1FBQ2pFLHdCQUF3QixFQUFFLEdBQUcsQ0FBQyx1QkFBdUIsQ0FBQyxVQUFVLENBQUMsd0JBQXdCLENBQUM7UUFDMUYsbUJBQW1CLEVBQUUsR0FBRyxDQUFDLFVBQVUsQ0FBQyxnRUFBZ0UsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxtQkFBbUIsQ0FBQztRQUNySSxnQkFBZ0IsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLGdCQUFnQixDQUFDO1FBQ3pFLDRCQUE0QixFQUFFLEdBQUcsQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDLHNCQUFzQixDQUFDLENBQUMsVUFBVSxDQUFDLDRCQUE0QixDQUFDO1FBQ2pILFlBQVksRUFBRSxHQUFHLENBQUMsdUJBQXVCLENBQUMsVUFBVSxDQUFDLFlBQVksQ0FBQztRQUNsRSxrQkFBa0IsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLGtCQUFrQixDQUFDO1FBQzdFLFVBQVUsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQztRQUM3RCxrQkFBa0IsRUFBRSxHQUFHLENBQUMsdUJBQXVCLENBQUMsVUFBVSxDQUFDLGtCQUFrQixDQUFDO1FBQzlFLFFBQVEsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLFFBQVEsQ0FBQztRQUN6RCxPQUFPLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUM7UUFDdkQsdUJBQXVCLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyx1QkFBdUIsQ0FBQztRQUN2RixlQUFlLEVBQUUsNkRBQTZELENBQUMsVUFBVSxDQUFDLGVBQWUsQ0FBQztRQUMxRyxnQkFBZ0IsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLGdCQUFnQixDQUFDO1FBQ3pFLFNBQVMsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLFNBQVMsQ0FBQztRQUMzRCxjQUFjLEVBQUUsR0FBRyxDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUMsc0JBQXNCLENBQUMsQ0FBQyxVQUFVLENBQUMsY0FBYyxDQUFDO1FBQ3JGLFNBQVMsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLFNBQVMsQ0FBQztRQUMzRCxRQUFRLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxRQUFRLENBQUM7S0FDNUQsQ0FBQztBQUNOLENBQUM7QUFFRCxvQkFBb0I7QUFDcEIsU0FBUyw2Q0FBNkMsQ0FBQyxVQUFlO0lBQ2xFLFVBQVUsR0FBRyxVQUFVLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQztJQUNsRCxJQUFJLE9BQU8sVUFBVSxLQUFLLFFBQVEsRUFBRTtRQUNoQyxPQUFPLElBQUksU0FBUyxDQUFDLHdCQUF3QixDQUFDLFVBQVUsQ0FBQyxDQUFDO0tBQzdEO0lBQ0QsTUFBTSxHQUFHLEdBQUcsSUFBSSxTQUFTLENBQUMsZ0NBQWdDLEVBQStCLENBQUM7SUFDMUYsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFNBQVMsRUFBRSxTQUFTLEVBQUUsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQztJQUN4RyxHQUFHLENBQUMsaUJBQWlCLENBQUMsY0FBYyxFQUFFLGNBQWMsRUFBRSxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxZQUFZLENBQUMsQ0FBQyxDQUFDO0lBQ3ZILEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQywwQkFBMEIsRUFBRSwwQkFBMEIsRUFBRSxVQUFVLENBQUMsd0JBQXdCLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyx3QkFBd0IsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUN0TixHQUFHLENBQUMsaUJBQWlCLENBQUMscUJBQXFCLEVBQUUscUJBQXFCLEVBQUUsVUFBVSxDQUFDLG1CQUFtQixJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFFBQVEsQ0FBQyxrRUFBa0UsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUNwUSxHQUFHLENBQUMsaUJBQWlCLENBQUMsa0JBQWtCLEVBQUUsa0JBQWtCLEVBQUUsVUFBVSxDQUFDLGdCQUFnQixJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsZ0JBQWdCLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDckwsR0FBRyxDQUFDLGlCQUFpQixDQUFDLDhCQUE4QixFQUFFLDhCQUE4QixFQUFFLFVBQVUsQ0FBQyw0QkFBNEIsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxjQUFjLENBQUMsVUFBVSxDQUFDLDRCQUE0QixDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQzFPLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxjQUFjLEVBQUUsY0FBYyxFQUFFLFVBQVUsQ0FBQyxZQUFZLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxZQUFZLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDdEssR0FBRyxDQUFDLGlCQUFpQixDQUFDLG9CQUFvQixFQUFFLG9CQUFvQixFQUFFLFVBQVUsQ0FBQyxrQkFBa0IsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLGtCQUFrQixDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQzdMLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxZQUFZLEVBQUUsWUFBWSxFQUFFLFVBQVUsQ0FBQyxVQUFVLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDN0osR0FBRyxDQUFDLGlCQUFpQixDQUFDLG9CQUFvQixFQUFFLG9CQUFvQixFQUFFLFVBQVUsQ0FBQyxrQkFBa0IsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLGtCQUFrQixDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQzlMLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxVQUFVLEVBQUUsVUFBVSxFQUFFLFVBQVUsQ0FBQyxRQUFRLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxRQUFRLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDckosR0FBRyxDQUFDLGlCQUFpQixDQUFDLFNBQVMsRUFBRSxTQUFTLEVBQUUsVUFBVSxDQUFDLE9BQU8sSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUNqSixHQUFHLENBQUMsaUJBQWlCLENBQUMseUJBQXlCLEVBQUUseUJBQXlCLEVBQUUsVUFBVSxDQUFDLHVCQUF1QixJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsdUJBQXVCLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDak4sR0FBRyxDQUFDLGlCQUFpQixDQUFDLGlCQUFpQixFQUFFLGlCQUFpQixFQUFFLFVBQVUsQ0FBQyxlQUFlLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQywrREFBK0QsQ0FBQyxVQUFVLENBQUMsZUFBZSxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQzFNLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxrQkFBa0IsRUFBRSxrQkFBa0IsRUFBRSxVQUFVLENBQUMsZ0JBQWdCLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUNyTCxHQUFHLENBQUMsaUJBQWlCLENBQUMsV0FBVyxFQUFFLFdBQVcsRUFBRSxVQUFVLENBQUMsU0FBUyxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsU0FBUyxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ3pKLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxnQkFBZ0IsRUFBRSxnQkFBZ0IsRUFBRSxVQUFVLENBQUMsY0FBYyxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLGNBQWMsQ0FBQyxVQUFVLENBQUMsY0FBYyxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ2xMLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxXQUFXLEVBQUUsV0FBVyxFQUFFLFVBQVUsQ0FBQyxTQUFTLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDekosR0FBRyxDQUFDLGlCQUFpQixDQUFDLFVBQVUsRUFBRSxVQUFVLEVBQUUsVUFBVSxDQUFDLFFBQVEsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLFFBQVEsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUNySixHQUFHLENBQUMsZ0NBQWdDLENBQUMsVUFBVSxDQUFDLENBQUM7SUFDakQsT0FBTyxHQUFHLENBQUM7QUFDZixDQUFDO0FBRUQ7Ozs7Ozs7Ozs7Ozs7R0FhRztBQUNILE1BQWEsc0JBQXVCLFNBQVEsR0FBRyxDQUFDLFdBQVc7SUEwTHZEOzs7Ozs7T0FNRztJQUNILFlBQVksS0FBb0IsRUFBRSxFQUFVLEVBQUUsS0FBa0M7UUFDNUUsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUUsRUFBRSxJQUFJLEVBQUUsc0JBQXNCLENBQUMsc0JBQXNCLEVBQUUsVUFBVSxFQUFFLEtBQUssRUFBRSxDQUFDLENBQUM7Ozs7Ozs7K0NBbE14RixzQkFBc0I7Ozs7UUFtTTNCLEdBQUcsQ0FBQyxlQUFlLENBQUMsS0FBSyxFQUFFLFNBQVMsRUFBRSxJQUFJLENBQUMsQ0FBQztRQUM1QyxHQUFHLENBQUMsZUFBZSxDQUFDLEtBQUssRUFBRSxjQUFjLEVBQUUsSUFBSSxDQUFDLENBQUM7UUFFakQsSUFBSSxDQUFDLE9BQU8sR0FBRyxLQUFLLENBQUMsT0FBTyxDQUFDO1FBQzdCLElBQUksQ0FBQyxZQUFZLEdBQUcsS0FBSyxDQUFDLFlBQVksQ0FBQztRQUN2QyxJQUFJLENBQUMsd0JBQXdCLEdBQUcsS0FBSyxDQUFDLHdCQUF3QixDQUFDO1FBQy9ELElBQUksQ0FBQyxtQkFBbUIsR0FBRyxLQUFLLENBQUMsbUJBQW1CLENBQUM7UUFDckQsSUFBSSxDQUFDLGdCQUFnQixHQUFHLEtBQUssQ0FBQyxnQkFBZ0IsQ0FBQztRQUMvQyxJQUFJLENBQUMsNEJBQTRCLEdBQUcsS0FBSyxDQUFDLDRCQUE0QixDQUFDO1FBQ3ZFLElBQUksQ0FBQyxZQUFZLEdBQUcsS0FBSyxDQUFDLFlBQVksQ0FBQztRQUN2QyxJQUFJLENBQUMsa0JBQWtCLEdBQUcsS0FBSyxDQUFDLGtCQUFrQixDQUFDO1FBQ25ELElBQUksQ0FBQyxVQUFVLEdBQUcsS0FBSyxDQUFDLFVBQVUsQ0FBQztRQUNuQyxJQUFJLENBQUMsa0JBQWtCLEdBQUcsS0FBSyxDQUFDLGtCQUFrQixDQUFDO1FBQ25ELElBQUksQ0FBQyxRQUFRLEdBQUcsS0FBSyxDQUFDLFFBQVEsQ0FBQztRQUMvQixJQUFJLENBQUMsT0FBTyxHQUFHLEtBQUssQ0FBQyxPQUFPLENBQUM7UUFDN0IsSUFBSSxDQUFDLHVCQUF1QixHQUFHLEtBQUssQ0FBQyx1QkFBdUIsQ0FBQztRQUM3RCxJQUFJLENBQUMsZUFBZSxHQUFHLEtBQUssQ0FBQyxlQUFlLENBQUM7UUFDN0MsSUFBSSxDQUFDLGdCQUFnQixHQUFHLEtBQUssQ0FBQyxnQkFBZ0IsQ0FBQztRQUMvQyxJQUFJLENBQUMsU0FBUyxHQUFHLEtBQUssQ0FBQyxTQUFTLENBQUM7UUFDakMsSUFBSSxDQUFDLGNBQWMsR0FBRyxLQUFLLENBQUMsY0FBYyxDQUFDO1FBQzNDLElBQUksQ0FBQyxTQUFTLEdBQUcsS0FBSyxDQUFDLFNBQVMsQ0FBQztRQUNqQyxJQUFJLENBQUMsUUFBUSxHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUM7S0FDbEM7SUFuTkQ7Ozs7OztPQU1HO0lBQ0ksTUFBTSxDQUFDLG1CQUFtQixDQUFDLEtBQW9CLEVBQUUsRUFBVSxFQUFFLGtCQUF1QixFQUFFLE9BQTRDO1FBQ3JJLGtCQUFrQixHQUFHLGtCQUFrQixJQUFJLEVBQUUsQ0FBQztRQUM5QyxNQUFNLGtCQUFrQixHQUFHLE9BQU8sQ0FBQyxNQUFNLENBQUMsVUFBVSxDQUFDLGtCQUFrQixDQUFDLFVBQVUsQ0FBQyxDQUFDO1FBQ3BGLE1BQU0sV0FBVyxHQUFHLDZDQUE2QyxDQUFDLGtCQUFrQixDQUFDLENBQUM7UUFDdEYsTUFBTSxHQUFHLEdBQUcsSUFBSSxzQkFBc0IsQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLFdBQVcsQ0FBQyxLQUFLLENBQUMsQ0FBQztRQUNyRSxLQUFLLE1BQU0sQ0FBQyxPQUFPLEVBQUUsT0FBTyxDQUFDLElBQUksTUFBTSxDQUFDLE9BQU8sQ0FBQyxXQUFXLENBQUMsZUFBZSxDQUFDLEVBQUc7WUFDM0UsR0FBRyxDQUFDLG1CQUFtQixDQUFDLE9BQU8sRUFBRSxPQUFPLENBQUMsQ0FBQztTQUM3QztRQUNELE9BQU8sQ0FBQyxNQUFNLENBQUMsZ0JBQWdCLENBQUMsR0FBRyxFQUFFLGtCQUFrQixFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBQzdELE9BQU8sR0FBRyxDQUFDO0tBQ2Q7SUFvTUQ7Ozs7O09BS0c7SUFDSSxPQUFPLENBQUMsU0FBNEI7Ozs7Ozs7Ozs7UUFDdkMsU0FBUyxDQUFDLFlBQVksQ0FBQyw2QkFBNkIsRUFBRSxzQkFBc0IsQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDO1FBQ3JHLFNBQVMsQ0FBQyxZQUFZLENBQUMsOEJBQThCLEVBQUUsSUFBSSxDQUFDLGFBQWEsQ0FBQyxDQUFDO0tBQzlFO0lBRUQsSUFBYyxhQUFhO1FBQ3ZCLE9BQU87WUFDSCxPQUFPLEVBQUUsSUFBSSxDQUFDLE9BQU87WUFDckIsWUFBWSxFQUFFLElBQUksQ0FBQyxZQUFZO1lBQy9CLHdCQUF3QixFQUFFLElBQUksQ0FBQyx3QkFBd0I7WUFDdkQsbUJBQW1CLEVBQUUsSUFBSSxDQUFDLG1CQUFtQjtZQUM3QyxnQkFBZ0IsRUFBRSxJQUFJLENBQUMsZ0JBQWdCO1lBQ3ZDLDRCQUE0QixFQUFFLElBQUksQ0FBQyw0QkFBNEI7WUFDL0QsWUFBWSxFQUFFLElBQUksQ0FBQyxZQUFZO1lBQy9CLGtCQUFrQixFQUFFLElBQUksQ0FBQyxrQkFBa0I7WUFDM0MsVUFBVSxFQUFFLElBQUksQ0FBQyxVQUFVO1lBQzNCLGtCQUFrQixFQUFFLElBQUksQ0FBQyxrQkFBa0I7WUFDM0MsUUFBUSxFQUFFLElBQUksQ0FBQyxRQUFRO1lBQ3ZCLE9BQU8sRUFBRSxJQUFJLENBQUMsT0FBTztZQUNyQix1QkFBdUIsRUFBRSxJQUFJLENBQUMsdUJBQXVCO1lBQ3JELGVBQWUsRUFBRSxJQUFJLENBQUMsZUFBZTtZQUNyQyxnQkFBZ0IsRUFBRSxJQUFJLENBQUMsZ0JBQWdCO1lBQ3ZDLFNBQVMsRUFBRSxJQUFJLENBQUMsU0FBUztZQUN6QixjQUFjLEVBQUUsSUFBSSxDQUFDLGNBQWM7WUFDbkMsU0FBUyxFQUFFLElBQUksQ0FBQyxTQUFTO1lBQ3pCLFFBQVEsRUFBRSxJQUFJLENBQUMsUUFBUTtTQUMxQixDQUFDO0tBQ0w7SUFFUyxnQkFBZ0IsQ0FBQyxLQUEyQjtRQUNsRCxPQUFPLDJDQUEyQyxDQUFDLEtBQUssQ0FBQyxDQUFDO0tBQzdEOztBQWhRTCx3REFpUUM7OztBQWhRRzs7R0FFRztBQUNvQiw2Q0FBc0IsR0FBRyx1Q0FBdUMsQ0FBQztBQWdWNUY7Ozs7OztHQU1HO0FBQ0gsU0FBUyxtREFBbUQsQ0FBQyxVQUFlO0lBQ3hFLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxHQUFHLENBQUMsa0JBQWtCLENBQUM7S0FBRTtJQUNuRSxNQUFNLE1BQU0sR0FBRyxJQUFJLEdBQUcsQ0FBQyxpQkFBaUIsRUFBRSxDQUFDO0lBQzNDLElBQUksT0FBTyxVQUFVLEtBQUssUUFBUSxFQUFFO1FBQ2hDLE1BQU0sQ0FBQyxPQUFPLENBQUMsSUFBSSxHQUFHLENBQUMsZ0JBQWdCLENBQUMsb0NBQW9DLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLENBQUM7S0FDL0c7SUFDRCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxxQkFBcUIsRUFBRSxHQUFHLENBQUMsZUFBZSxDQUFDLENBQUMsVUFBVSxDQUFDLG1CQUFtQixDQUFDLENBQUMsQ0FBQztJQUNsSCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxXQUFXLEVBQUUsR0FBRyxDQUFDLGVBQWUsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQUMsQ0FBQyxDQUFDO0lBQzlGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLE1BQU0sRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUM7SUFDbkYsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsWUFBWSxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQztJQUMvRixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxZQUFZLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDO0lBQy9GLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFlBQVksRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUM7SUFDL0YsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsWUFBWSxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQztJQUMvRixPQUFPLE1BQU0sQ0FBQyxJQUFJLENBQUMsMkRBQTJELENBQUMsQ0FBQztBQUNwRixDQUFDO0FBRUQ7Ozs7OztHQU1HO0FBQ0gsb0JBQW9CO0FBQ3BCLFNBQVMseURBQXlELENBQUMsVUFBZTtJQUM5RSxJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sVUFBVSxDQUFDO0tBQUU7SUFDdkQsbURBQW1ELENBQUMsVUFBVSxDQUFDLENBQUMsYUFBYSxFQUFFLENBQUM7SUFDaEYsT0FBTztRQUNILG1CQUFtQixFQUFFLEdBQUcsQ0FBQyx1QkFBdUIsQ0FBQyxVQUFVLENBQUMsbUJBQW1CLENBQUM7UUFDaEYsU0FBUyxFQUFFLEdBQUcsQ0FBQyx1QkFBdUIsQ0FBQyxVQUFVLENBQUMsU0FBUyxDQUFDO1FBQzVELElBQUksRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQztRQUNqRCxVQUFVLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUM7UUFDN0QsVUFBVSxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDO1FBQzdELFVBQVUsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQztRQUM3RCxVQUFVLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUM7S0FDaEUsQ0FBQztBQUNOLENBQUM7QUFFRCxvQkFBb0I7QUFDcEIsU0FBUywyREFBMkQsQ0FBQyxVQUFlO0lBQ2hGLElBQUksR0FBRyxDQUFDLGtCQUFrQixDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQ3BDLE9BQU8sSUFBSSxTQUFTLENBQUMsd0JBQXdCLENBQUMsVUFBVSxDQUFDLENBQUM7S0FDN0Q7SUFDRCxVQUFVLEdBQUcsVUFBVSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUM7SUFDbEQsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsT0FBTyxJQUFJLFNBQVMsQ0FBQyx3QkFBd0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztLQUM3RDtJQUNELE1BQU0sR0FBRyxHQUFHLElBQUksU0FBUyxDQUFDLGdDQUFnQyxFQUE4QyxDQUFDO0lBQ3pHLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxxQkFBcUIsRUFBRSxxQkFBcUIsRUFBRSxVQUFVLENBQUMsbUJBQW1CLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUNsTSxHQUFHLENBQUMsaUJBQWlCLENBQUMsV0FBVyxFQUFFLFdBQVcsRUFBRSxVQUFVLENBQUMsU0FBUyxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsU0FBUyxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQzFKLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxNQUFNLEVBQUUsTUFBTSxFQUFFLFVBQVUsQ0FBQyxJQUFJLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDckksR0FBRyxDQUFDLGlCQUFpQixDQUFDLFlBQVksRUFBRSxZQUFZLEVBQUUsVUFBVSxDQUFDLFVBQVUsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUM3SixHQUFHLENBQUMsaUJBQWlCLENBQUMsWUFBWSxFQUFFLFlBQVksRUFBRSxVQUFVLENBQUMsVUFBVSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQzdKLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxZQUFZLEVBQUUsWUFBWSxFQUFFLFVBQVUsQ0FBQyxVQUFVLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDN0osR0FBRyxDQUFDLGlCQUFpQixDQUFDLFlBQVksRUFBRSxZQUFZLEVBQUUsVUFBVSxDQUFDLFVBQVUsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUM3SixHQUFHLENBQUMsZ0NBQWdDLENBQUMsVUFBVSxDQUFDLENBQUM7SUFDakQsT0FBTyxHQUFHLENBQUM7QUFDZixDQUFDO0FBK0NEOzs7Ozs7R0FNRztBQUNILFNBQVMsMERBQTBELENBQUMsVUFBZTtJQUMvRSxJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sR0FBRyxDQUFDLGtCQUFrQixDQUFDO0tBQUU7SUFDbkUsTUFBTSxNQUFNLEdBQUcsSUFBSSxHQUFHLENBQUMsaUJBQWlCLEVBQUUsQ0FBQztJQUMzQyxJQUFJLE9BQU8sVUFBVSxLQUFLLFFBQVEsRUFBRTtRQUNoQyxNQUFNLENBQUMsT0FBTyxDQUFDLElBQUksR0FBRyxDQUFDLGdCQUFnQixDQUFDLG9DQUFvQyxHQUFHLElBQUksQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxDQUFDO0tBQy9HO0lBQ0QsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsWUFBWSxFQUFFLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDO0lBQ2xHLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFlBQVksRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUM7SUFDL0YsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsS0FBSyxFQUFFLG1EQUFtRCxDQUFDLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUM7SUFDbEgsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsVUFBVSxFQUFFLEdBQUcsQ0FBQyxlQUFlLENBQUMsQ0FBQyxVQUFVLENBQUMsUUFBUSxDQUFDLENBQUMsQ0FBQztJQUM1RixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxhQUFhLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxXQUFXLENBQUMsQ0FBQyxDQUFDO0lBQ2pHLE9BQU8sTUFBTSxDQUFDLElBQUksQ0FBQyxrRUFBa0UsQ0FBQyxDQUFDO0FBQzNGLENBQUM7QUFFRDs7Ozs7O0dBTUc7QUFDSCxvQkFBb0I7QUFDcEIsU0FBUyxnRUFBZ0UsQ0FBQyxVQUFlO0lBQ3JGLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxVQUFVLENBQUM7S0FBRTtJQUN2RCwwREFBMEQsQ0FBQyxVQUFVLENBQUMsQ0FBQyxhQUFhLEVBQUUsQ0FBQztJQUN2RixPQUFPO1FBQ0gsVUFBVSxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDO1FBQzdELEdBQUcsRUFBRSx5REFBeUQsQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDO1FBQzlFLFFBQVEsRUFBRSxHQUFHLENBQUMsdUJBQXVCLENBQUMsVUFBVSxDQUFDLFFBQVEsQ0FBQztRQUMxRCxXQUFXLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxXQUFXLENBQUM7S0FDbEUsQ0FBQztBQUNOLENBQUM7QUFFRCxvQkFBb0I7QUFDcEIsU0FBUyxrRUFBa0UsQ0FBQyxVQUFlO0lBQ3ZGLElBQUksR0FBRyxDQUFDLGtCQUFrQixDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQ3BDLE9BQU8sSUFBSSxTQUFTLENBQUMsd0JBQXdCLENBQUMsVUFBVSxDQUFDLENBQUM7S0FDN0Q7SUFDRCxVQUFVLEdBQUcsVUFBVSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUM7SUFDbEQsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsT0FBTyxJQUFJLFNBQVMsQ0FBQyx3QkFBd0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztLQUM3RDtJQUNELE1BQU0sR0FBRyxHQUFHLElBQUksU0FBUyxDQUFDLGdDQUFnQyxFQUFxRCxDQUFDO0lBQ2hILEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxZQUFZLEVBQUUsWUFBWSxFQUFFLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUM7SUFDakgsR0FBRyxDQUFDLGlCQUFpQixDQUFDLEtBQUssRUFBRSxLQUFLLEVBQUUsVUFBVSxDQUFDLEdBQUcsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLDJEQUEyRCxDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDdEosR0FBRyxDQUFDLGlCQUFpQixDQUFDLFVBQVUsRUFBRSxVQUFVLEVBQUUsVUFBVSxDQUFDLFFBQVEsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLFFBQVEsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUN0SixHQUFHLENBQUMsaUJBQWlCLENBQUMsYUFBYSxFQUFFLGFBQWEsRUFBRSxVQUFVLENBQUMsV0FBVyxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsV0FBVyxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ2pLLEdBQUcsQ0FBQyxnQ0FBZ0MsQ0FBQyxVQUFVLENBQUMsQ0FBQztJQUNqRCxPQUFPLEdBQUcsQ0FBQztBQUNmLENBQUM7QUEyQ0Q7Ozs7OztHQU1HO0FBQ0gsU0FBUyx1REFBdUQsQ0FBQyxVQUFlO0lBQzVFLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxHQUFHLENBQUMsa0JBQWtCLENBQUM7S0FBRTtJQUNuRSxNQUFNLE1BQU0sR0FBRyxJQUFJLEdBQUcsQ0FBQyxpQkFBaUIsRUFBRSxDQUFDO0lBQzNDLElBQUksT0FBTyxVQUFVLEtBQUssUUFBUSxFQUFFO1FBQ2hDLE1BQU0sQ0FBQyxPQUFPLENBQUMsSUFBSSxHQUFHLENBQUMsZ0JBQWdCLENBQUMsb0NBQW9DLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLENBQUM7S0FDL0c7SUFDRCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxjQUFjLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxZQUFZLENBQUMsQ0FBQyxDQUFDO0lBQ25HLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLHlCQUF5QixFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsdUJBQXVCLENBQUMsQ0FBQyxDQUFDO0lBQ3pILE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFlBQVksRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUM7SUFDL0YsT0FBTyxNQUFNLENBQUMsSUFBSSxDQUFDLCtEQUErRCxDQUFDLENBQUM7QUFDeEYsQ0FBQztBQUVEOzs7Ozs7R0FNRztBQUNILG9CQUFvQjtBQUNwQixTQUFTLDZEQUE2RCxDQUFDLFVBQWU7SUFDbEYsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLFVBQVUsQ0FBQztLQUFFO0lBQ3ZELHVEQUF1RCxDQUFDLFVBQVUsQ0FBQyxDQUFDLGFBQWEsRUFBRSxDQUFDO0lBQ3BGLE9BQU87UUFDSCxZQUFZLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxZQUFZLENBQUM7UUFDakUsdUJBQXVCLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyx1QkFBdUIsQ0FBQztRQUN2RixVQUFVLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUM7S0FDaEUsQ0FBQztBQUNOLENBQUM7QUFFRCxvQkFBb0I7QUFDcEIsU0FBUywrREFBK0QsQ0FBQyxVQUFlO0lBQ3BGLElBQUksR0FBRyxDQUFDLGtCQUFrQixDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQ3BDLE9BQU8sSUFBSSxTQUFTLENBQUMsd0JBQXdCLENBQUMsVUFBVSxDQUFDLENBQUM7S0FDN0Q7SUFDRCxVQUFVLEdBQUcsVUFBVSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUM7SUFDbEQsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsT0FBTyxJQUFJLFNBQVMsQ0FBQyx3QkFBd0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztLQUM3RDtJQUNELE1BQU0sR0FBRyxHQUFHLElBQUksU0FBUyxDQUFDLGdDQUFnQyxFQUFrRCxDQUFDO0lBQzdHLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxjQUFjLEVBQUUsY0FBYyxFQUFFLFVBQVUsQ0FBQyxZQUFZLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxZQUFZLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDckssR0FBRyxDQUFDLGlCQUFpQixDQUFDLHlCQUF5QixFQUFFLHlCQUF5QixFQUFFLFVBQVUsQ0FBQyx1QkFBdUIsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLHVCQUF1QixDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ2pOLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxZQUFZLEVBQUUsWUFBWSxFQUFFLFVBQVUsQ0FBQyxVQUFVLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDN0osR0FBRyxDQUFDLGdDQUFnQyxDQUFDLFVBQVUsQ0FBQyxDQUFDO0lBQ2pELE9BQU8sR0FBRyxDQUFDO0FBQ2YsQ0FBQztBQTRFRDs7Ozs7O0dBTUc7QUFDSCxTQUFTLDhCQUE4QixDQUFDLFVBQWU7SUFDbkQsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQztLQUFFO0lBQ25FLE1BQU0sTUFBTSxHQUFHLElBQUksR0FBRyxDQUFDLGlCQUFpQixFQUFFLENBQUM7SUFDM0MsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsTUFBTSxDQUFDLE9BQU8sQ0FBQyxJQUFJLEdBQUcsQ0FBQyxnQkFBZ0IsQ0FBQyxvQ0FBb0MsR0FBRyxJQUFJLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUMsQ0FBQztLQUMvRztJQUNELE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLHNCQUFzQixFQUFFLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDLENBQUM7SUFDdEgsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsc0JBQXNCLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDLENBQUM7SUFDbkgsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsZUFBZSxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsYUFBYSxDQUFDLENBQUMsQ0FBQztJQUNyRyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxrQkFBa0IsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLGdCQUFnQixDQUFDLENBQUMsQ0FBQztJQUMzRyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxtQkFBbUIsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLGlCQUFpQixDQUFDLENBQUMsQ0FBQztJQUM3RyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxxQkFBcUIsRUFBRSxHQUFHLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxVQUFVLENBQUMsbUJBQW1CLENBQUMsQ0FBQyxDQUFDO0lBQ3BILE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLHFCQUFxQixFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsbUJBQW1CLENBQUMsQ0FBQyxDQUFDO0lBQ2pILE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLHNCQUFzQixFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsb0JBQW9CLENBQUMsQ0FBQyxDQUFDO0lBQ25ILE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLHVCQUF1QixFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMscUJBQXFCLENBQUMsQ0FBQyxDQUFDO0lBQ3JILE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFNBQVMsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUM7SUFDekYsT0FBTyxNQUFNLENBQUMsSUFBSSxDQUFDLDZEQUE2RCxDQUFDLENBQUM7QUFDdEYsQ0FBQztBQUVEOzs7Ozs7R0FNRztBQUNILG9CQUFvQjtBQUNwQixTQUFTLHFDQUFxQyxDQUFDLFVBQWU7SUFDMUQsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLFVBQVUsQ0FBQztLQUFFO0lBQ3ZELDhCQUE4QixDQUFDLFVBQVUsQ0FBQyxDQUFDLGFBQWEsRUFBRSxDQUFDO0lBQzNELE9BQU87UUFDSCxvQkFBb0IsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLG9CQUFvQixDQUFDO1FBQ2pGLG1CQUFtQixFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsbUJBQW1CLENBQUM7UUFDL0UsYUFBYSxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsYUFBYSxDQUFDO1FBQ25FLGdCQUFnQixFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsZ0JBQWdCLENBQUM7UUFDekUsaUJBQWlCLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxpQkFBaUIsQ0FBQztRQUMzRSxvQkFBb0IsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLG9CQUFvQixDQUFDO1FBQ2pGLHFCQUFxQixFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMscUJBQXFCLENBQUM7UUFDbkYsT0FBTyxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsT0FBTyxDQUFDO0tBQzFELENBQUM7QUFDTixDQUFDO0FBRUQsb0JBQW9CO0FBQ3BCLFNBQVMsdUNBQXVDLENBQUMsVUFBZTtJQUM1RCxVQUFVLEdBQUcsVUFBVSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUM7SUFDbEQsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsT0FBTyxJQUFJLFNBQVMsQ0FBQyx3QkFBd0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztLQUM3RDtJQUNELE1BQU0sR0FBRyxHQUFHLElBQUksU0FBUyxDQUFDLGdDQUFnQyxFQUF5QixDQUFDO0lBQ3BGLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxzQkFBc0IsRUFBRSxzQkFBc0IsRUFBRSxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDLENBQUM7SUFDL0ksR0FBRyxDQUFDLGlCQUFpQixDQUFDLHFCQUFxQixFQUFFLHFCQUFxQixFQUFFLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLG1CQUFtQixDQUFDLENBQUMsQ0FBQztJQUM1SSxHQUFHLENBQUMsaUJBQWlCLENBQUMsZUFBZSxFQUFFLGVBQWUsRUFBRSxVQUFVLENBQUMsYUFBYSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsYUFBYSxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ3pLLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxrQkFBa0IsRUFBRSxrQkFBa0IsRUFBRSxVQUFVLENBQUMsZ0JBQWdCLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUNyTCxHQUFHLENBQUMsaUJBQWlCLENBQUMsbUJBQW1CLEVBQUUsbUJBQW1CLEVBQUUsVUFBVSxDQUFDLGlCQUFpQixJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDekwsR0FBRyxDQUFDLGlCQUFpQixDQUFDLHNCQUFzQixFQUFFLHNCQUFzQixFQUFFLFVBQVUsQ0FBQyxvQkFBb0IsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLG9CQUFvQixDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ3JNLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyx1QkFBdUIsRUFBRSx1QkFBdUIsRUFBRSxVQUFVLENBQUMscUJBQXFCLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUN6TSxHQUFHLENBQUMsaUJBQWlCLENBQUMsU0FBUyxFQUFFLFNBQVMsRUFBRSxVQUFVLENBQUMsT0FBTyxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ2pKLEdBQUcsQ0FBQyxnQ0FBZ0MsQ0FBQyxVQUFVLENBQUMsQ0FBQztJQUNqRCxPQUFPLEdBQUcsQ0FBQztBQUNmLENBQUM7QUFFRDs7Ozs7Ozs7Ozs7OztHQWFHO0FBQ0gsTUFBYSxnQkFBaUIsU0FBUSxHQUFHLENBQUMsV0FBVztJQXdGakQ7Ozs7OztPQU1HO0lBQ0gsWUFBWSxLQUFvQixFQUFFLEVBQVUsRUFBRSxLQUE0QjtRQUN0RSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRSxFQUFFLElBQUksRUFBRSxnQkFBZ0IsQ0FBQyxzQkFBc0IsRUFBRSxVQUFVLEVBQUUsS0FBSyxFQUFFLENBQUMsQ0FBQzs7Ozs7OzsrQ0FoR2xGLGdCQUFnQjs7OztRQWlHckIsR0FBRyxDQUFDLGVBQWUsQ0FBQyxLQUFLLEVBQUUsc0JBQXNCLEVBQUUsSUFBSSxDQUFDLENBQUM7UUFDekQsR0FBRyxDQUFDLGVBQWUsQ0FBQyxLQUFLLEVBQUUscUJBQXFCLEVBQUUsSUFBSSxDQUFDLENBQUM7UUFFeEQsSUFBSSxDQUFDLG9CQUFvQixHQUFHLEtBQUssQ0FBQyxvQkFBb0IsQ0FBQztRQUN2RCxJQUFJLENBQUMsbUJBQW1CLEdBQUcsS0FBSyxDQUFDLG1CQUFtQixDQUFDO1FBQ3JELElBQUksQ0FBQyxhQUFhLEdBQUcsS0FBSyxDQUFDLGFBQWEsQ0FBQztRQUN6QyxJQUFJLENBQUMsZ0JBQWdCLEdBQUcsS0FBSyxDQUFDLGdCQUFnQixDQUFDO1FBQy9DLElBQUksQ0FBQyxpQkFBaUIsR0FBRyxLQUFLLENBQUMsaUJBQWlCLENBQUM7UUFDakQsSUFBSSxDQUFDLG9CQUFvQixHQUFHLEtBQUssQ0FBQyxvQkFBb0IsQ0FBQztRQUN2RCxJQUFJLENBQUMscUJBQXFCLEdBQUcsS0FBSyxDQUFDLHFCQUFxQixDQUFDO1FBQ3pELElBQUksQ0FBQyxPQUFPLEdBQUcsS0FBSyxDQUFDLE9BQU8sQ0FBQztLQUNoQztJQXRHRDs7Ozs7O09BTUc7SUFDSSxNQUFNLENBQUMsbUJBQW1CLENBQUMsS0FBb0IsRUFBRSxFQUFVLEVBQUUsa0JBQXVCLEVBQUUsT0FBNEM7UUFDckksa0JBQWtCLEdBQUcsa0JBQWtCLElBQUksRUFBRSxDQUFDO1FBQzlDLE1BQU0sa0JBQWtCLEdBQUcsT0FBTyxDQUFDLE1BQU0sQ0FBQyxVQUFVLENBQUMsa0JBQWtCLENBQUMsVUFBVSxDQUFDLENBQUM7UUFDcEYsTUFBTSxXQUFXLEdBQUcsdUNBQXVDLENBQUMsa0JBQWtCLENBQUMsQ0FBQztRQUNoRixNQUFNLEdBQUcsR0FBRyxJQUFJLGdCQUFnQixDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUUsV0FBVyxDQUFDLEtBQUssQ0FBQyxDQUFDO1FBQy9ELEtBQUssTUFBTSxDQUFDLE9BQU8sRUFBRSxPQUFPLENBQUMsSUFBSSxNQUFNLENBQUMsT0FBTyxDQUFDLFdBQVcsQ0FBQyxlQUFlLENBQUMsRUFBRztZQUMzRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsT0FBTyxFQUFFLE9BQU8sQ0FBQyxDQUFDO1NBQzdDO1FBQ0QsT0FBTyxDQUFDLE1BQU0sQ0FBQyxnQkFBZ0IsQ0FBQyxHQUFHLEVBQUUsa0JBQWtCLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFDN0QsT0FBTyxHQUFHLENBQUM7S0FDZDtJQXVGRDs7Ozs7T0FLRztJQUNJLE9BQU8sQ0FBQyxTQUE0Qjs7Ozs7Ozs7OztRQUN2QyxTQUFTLENBQUMsWUFBWSxDQUFDLDZCQUE2QixFQUFFLGdCQUFnQixDQUFDLHNCQUFzQixDQUFDLENBQUM7UUFDL0YsU0FBUyxDQUFDLFlBQVksQ0FBQyw4QkFBOEIsRUFBRSxJQUFJLENBQUMsYUFBYSxDQUFDLENBQUM7S0FDOUU7SUFFRCxJQUFjLGFBQWE7UUFDdkIsT0FBTztZQUNILG9CQUFvQixFQUFFLElBQUksQ0FBQyxvQkFBb0I7WUFDL0MsbUJBQW1CLEVBQUUsSUFBSSxDQUFDLG1CQUFtQjtZQUM3QyxhQUFhLEVBQUUsSUFBSSxDQUFDLGFBQWE7WUFDakMsZ0JBQWdCLEVBQUUsSUFBSSxDQUFDLGdCQUFnQjtZQUN2QyxpQkFBaUIsRUFBRSxJQUFJLENBQUMsaUJBQWlCO1lBQ3pDLG9CQUFvQixFQUFFLElBQUksQ0FBQyxvQkFBb0I7WUFDL0MscUJBQXFCLEVBQUUsSUFBSSxDQUFDLHFCQUFxQjtZQUNqRCxPQUFPLEVBQUUsSUFBSSxDQUFDLE9BQU87U0FDeEIsQ0FBQztLQUNMO0lBRVMsZ0JBQWdCLENBQUMsS0FBMkI7UUFDbEQsT0FBTyxxQ0FBcUMsQ0FBQyxLQUFLLENBQUMsQ0FBQztLQUN2RDs7QUF4SUwsNENBeUlDOzs7QUF4SUc7O0dBRUc7QUFDb0IsdUNBQXNCLEdBQUcsaUNBQWlDLENBQUM7QUF5UXRGOzs7Ozs7R0FNRztBQUNILFNBQVMsOEJBQThCLENBQUMsVUFBZTtJQUNuRCxJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sR0FBRyxDQUFDLGtCQUFrQixDQUFDO0tBQUU7SUFDbkUsTUFBTSxNQUFNLEdBQUcsSUFBSSxHQUFHLENBQUMsaUJBQWlCLEVBQUUsQ0FBQztJQUMzQyxJQUFJLE9BQU8sVUFBVSxLQUFLLFFBQVEsRUFBRTtRQUNoQyxNQUFNLENBQUMsT0FBTyxDQUFDLElBQUksR0FBRyxDQUFDLGdCQUFnQixDQUFDLG9DQUFvQyxHQUFHLElBQUksQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxDQUFDO0tBQy9HO0lBQ0QsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsZ0JBQWdCLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxjQUFjLENBQUMsQ0FBQyxDQUFDO0lBQ3ZHLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLHNCQUFzQixFQUFFLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDLENBQUM7SUFDdEgsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsc0JBQXNCLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDLENBQUM7SUFDbkgsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsVUFBVSxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsUUFBUSxDQUFDLENBQUMsQ0FBQztJQUMzRixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyx5QkFBeUIsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLHVCQUF1QixDQUFDLENBQUMsQ0FBQztJQUN6SCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyx1QkFBdUIsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLHFCQUFxQixDQUFDLENBQUMsQ0FBQztJQUNySCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyx3QkFBd0IsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLHNCQUFzQixDQUFDLENBQUMsQ0FBQztJQUN2SCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxZQUFZLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDO0lBQy9GLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGdDQUFnQyxFQUFFLGdFQUFnRSxDQUFDLENBQUMsVUFBVSxDQUFDLDhCQUE4QixDQUFDLENBQUMsQ0FBQztJQUNyTCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxtQkFBbUIsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLGlCQUFpQixDQUFDLENBQUMsQ0FBQztJQUM3RyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxpQkFBaUIsRUFBRSxHQUFHLENBQUMsYUFBYSxDQUFDLGdEQUFnRCxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUMsZUFBZSxDQUFDLENBQUMsQ0FBQztJQUMxSixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyw2QkFBNkIsRUFBRSw2REFBNkQsQ0FBQyxDQUFDLFVBQVUsQ0FBQywyQkFBMkIsQ0FBQyxDQUFDLENBQUM7SUFDNUssT0FBTyxNQUFNLENBQUMsSUFBSSxDQUFDLDZEQUE2RCxDQUFDLENBQUM7QUFDdEYsQ0FBQztBQUVEOzs7Ozs7R0FNRztBQUNILG9CQUFvQjtBQUNwQixTQUFTLHFDQUFxQyxDQUFDLFVBQWU7SUFDMUQsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLFVBQVUsQ0FBQztLQUFFO0lBQ3ZELDhCQUE4QixDQUFDLFVBQVUsQ0FBQyxDQUFDLGFBQWEsRUFBRSxDQUFDO0lBQzNELE9BQU87UUFDSCxvQkFBb0IsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLG9CQUFvQixDQUFDO1FBQ2pGLGNBQWMsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLGNBQWMsQ0FBQztRQUNyRSxRQUFRLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxRQUFRLENBQUM7UUFDekQsdUJBQXVCLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyx1QkFBdUIsQ0FBQztRQUN2RixxQkFBcUIsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLHFCQUFxQixDQUFDO1FBQ25GLHNCQUFzQixFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsc0JBQXNCLENBQUM7UUFDckYsVUFBVSxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDO1FBQzdELDhCQUE4QixFQUFFLHNFQUFzRSxDQUFDLFVBQVUsQ0FBQyw4QkFBOEIsQ0FBQztRQUNqSixpQkFBaUIsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLGlCQUFpQixDQUFDO1FBQzNFLGVBQWUsRUFBRSxHQUFHLENBQUMsVUFBVSxDQUFDLHNEQUFzRCxDQUFDLENBQUMsVUFBVSxDQUFDLGVBQWUsQ0FBQztRQUNuSCwyQkFBMkIsRUFBRSxtRUFBbUUsQ0FBQyxVQUFVLENBQUMsMkJBQTJCLENBQUM7S0FDM0ksQ0FBQztBQUNOLENBQUM7QUFFRCxvQkFBb0I7QUFDcEIsU0FBUyx1Q0FBdUMsQ0FBQyxVQUFlO0lBQzVELFVBQVUsR0FBRyxVQUFVLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQztJQUNsRCxJQUFJLE9BQU8sVUFBVSxLQUFLLFFBQVEsRUFBRTtRQUNoQyxPQUFPLElBQUksU0FBUyxDQUFDLHdCQUF3QixDQUFDLFVBQVUsQ0FBQyxDQUFDO0tBQzdEO0lBQ0QsTUFBTSxHQUFHLEdBQUcsSUFBSSxTQUFTLENBQUMsZ0NBQWdDLEVBQXlCLENBQUM7SUFDcEYsR0FBRyxDQUFDLGlCQUFpQixDQUFDLHNCQUFzQixFQUFFLHNCQUFzQixFQUFFLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLG9CQUFvQixDQUFDLENBQUMsQ0FBQztJQUMvSSxHQUFHLENBQUMsaUJBQWlCLENBQUMsZ0JBQWdCLEVBQUUsZ0JBQWdCLEVBQUUsVUFBVSxDQUFDLGNBQWMsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLGNBQWMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUM3SyxHQUFHLENBQUMsaUJBQWlCLENBQUMsVUFBVSxFQUFFLFVBQVUsRUFBRSxVQUFVLENBQUMsUUFBUSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsUUFBUSxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ3JKLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyx5QkFBeUIsRUFBRSx5QkFBeUIsRUFBRSxVQUFVLENBQUMsdUJBQXVCLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyx1QkFBdUIsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUNqTixHQUFHLENBQUMsaUJBQWlCLENBQUMsdUJBQXVCLEVBQUUsdUJBQXVCLEVBQUUsVUFBVSxDQUFDLHFCQUFxQixJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMscUJBQXFCLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDek0sR0FBRyxDQUFDLGlCQUFpQixDQUFDLHdCQUF3QixFQUFFLHdCQUF3QixFQUFFLFVBQVUsQ0FBQyxzQkFBc0IsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLHNCQUFzQixDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQzdNLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxZQUFZLEVBQUUsWUFBWSxFQUFFLFVBQVUsQ0FBQyxVQUFVLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDN0osR0FBRyxDQUFDLGlCQUFpQixDQUFDLGdDQUFnQyxFQUFFLGdDQUFnQyxFQUFFLFVBQVUsQ0FBQyw4QkFBOEIsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLHdFQUF3RSxDQUFDLFVBQVUsQ0FBQyw4QkFBOEIsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUMvUSxHQUFHLENBQUMsaUJBQWlCLENBQUMsbUJBQW1CLEVBQUUsbUJBQW1CLEVBQUUsVUFBVSxDQUFDLGlCQUFpQixJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDekwsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGlCQUFpQixFQUFFLGlCQUFpQixFQUFFLFVBQVUsQ0FBQyxlQUFlLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsUUFBUSxDQUFDLHdEQUF3RCxDQUFDLENBQUMsVUFBVSxDQUFDLGVBQWUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUMxTyxHQUFHLENBQUMsaUJBQWlCLENBQUMsNkJBQTZCLEVBQUUsNkJBQTZCLEVBQUUsVUFBVSxDQUFDLDJCQUEyQixJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMscUVBQXFFLENBQUMsVUFBVSxDQUFDLDJCQUEyQixDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ2hRLEdBQUcsQ0FBQyxnQ0FBZ0MsQ0FBQyxVQUFVLENBQUMsQ0FBQztJQUNqRCxPQUFPLEdBQUcsQ0FBQztBQUNmLENBQUM7QUFFRDs7Ozs7Ozs7Ozs7R0FXRztBQUNILE1BQWEsZ0JBQWlCLFNBQVEsR0FBRyxDQUFDLFdBQVc7SUE0SmpEOzs7Ozs7T0FNRztJQUNILFlBQVksS0FBb0IsRUFBRSxFQUFVLEVBQUUsS0FBNEI7UUFDdEUsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUUsRUFBRSxJQUFJLEVBQUUsZ0JBQWdCLENBQUMsc0JBQXNCLEVBQUUsVUFBVSxFQUFFLEtBQUssRUFBRSxDQUFDLENBQUM7Ozs7Ozs7K0NBcEtsRixnQkFBZ0I7Ozs7UUFxS3JCLEdBQUcsQ0FBQyxlQUFlLENBQUMsS0FBSyxFQUFFLHNCQUFzQixFQUFFLElBQUksQ0FBQyxDQUFDO1FBQ3pELElBQUksQ0FBQyxPQUFPLEdBQUcsR0FBRyxDQUFDLEtBQUssQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDO1FBQ3RELElBQUksQ0FBQyxjQUFjLEdBQUcsR0FBRyxDQUFDLEtBQUssQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxZQUFZLENBQUMsQ0FBQyxDQUFDO1FBRXBFLElBQUksQ0FBQyxvQkFBb0IsR0FBRyxLQUFLLENBQUMsb0JBQW9CLENBQUM7UUFDdkQsSUFBSSxDQUFDLGNBQWMsR0FBRyxLQUFLLENBQUMsY0FBYyxDQUFDO1FBQzNDLElBQUksQ0FBQyxRQUFRLEdBQUcsS0FBSyxDQUFDLFFBQVEsQ0FBQztRQUMvQixJQUFJLENBQUMsdUJBQXVCLEdBQUcsS0FBSyxDQUFDLHVCQUF1QixDQUFDO1FBQzdELElBQUksQ0FBQyxxQkFBcUIsR0FBRyxLQUFLLENBQUMscUJBQXFCLENBQUM7UUFDekQsSUFBSSxDQUFDLHNCQUFzQixHQUFHLEtBQUssQ0FBQyxzQkFBc0IsQ0FBQztRQUMzRCxJQUFJLENBQUMsVUFBVSxHQUFHLEtBQUssQ0FBQyxVQUFVLENBQUM7UUFDbkMsSUFBSSxDQUFDLDhCQUE4QixHQUFHLEtBQUssQ0FBQyw4QkFBOEIsQ0FBQztRQUMzRSxJQUFJLENBQUMsaUJBQWlCLEdBQUcsS0FBSyxDQUFDLGlCQUFpQixDQUFDO1FBQ2pELElBQUksQ0FBQyxlQUFlLEdBQUcsS0FBSyxDQUFDLGVBQWUsQ0FBQztRQUM3QyxJQUFJLENBQUMsMkJBQTJCLEdBQUcsS0FBSyxDQUFDLDJCQUEyQixDQUFDO0tBQ3hFO0lBOUtEOzs7Ozs7T0FNRztJQUNJLE1BQU0sQ0FBQyxtQkFBbUIsQ0FBQyxLQUFvQixFQUFFLEVBQVUsRUFBRSxrQkFBdUIsRUFBRSxPQUE0QztRQUNySSxrQkFBa0IsR0FBRyxrQkFBa0IsSUFBSSxFQUFFLENBQUM7UUFDOUMsTUFBTSxrQkFBa0IsR0FBRyxPQUFPLENBQUMsTUFBTSxDQUFDLFVBQVUsQ0FBQyxrQkFBa0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztRQUNwRixNQUFNLFdBQVcsR0FBRyx1Q0FBdUMsQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDO1FBQ2hGLE1BQU0sR0FBRyxHQUFHLElBQUksZ0JBQWdCLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRSxXQUFXLENBQUMsS0FBSyxDQUFDLENBQUM7UUFDL0QsS0FBSyxNQUFNLENBQUMsT0FBTyxFQUFFLE9BQU8sQ0FBQyxJQUFJLE1BQU0sQ0FBQyxPQUFPLENBQUMsV0FBVyxDQUFDLGVBQWUsQ0FBQyxFQUFHO1lBQzNFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxPQUFPLEVBQUUsT0FBTyxDQUFDLENBQUM7U0FDN0M7UUFDRCxPQUFPLENBQUMsTUFBTSxDQUFDLGdCQUFnQixDQUFDLEdBQUcsRUFBRSxrQkFBa0IsRUFBRSxFQUFFLENBQUMsQ0FBQztRQUM3RCxPQUFPLEdBQUcsQ0FBQztLQUNkO0lBK0pEOzs7OztPQUtHO0lBQ0ksT0FBTyxDQUFDLFNBQTRCOzs7Ozs7Ozs7O1FBQ3ZDLFNBQVMsQ0FBQyxZQUFZLENBQUMsNkJBQTZCLEVBQUUsZ0JBQWdCLENBQUMsc0JBQXNCLENBQUMsQ0FBQztRQUMvRixTQUFTLENBQUMsWUFBWSxDQUFDLDhCQUE4QixFQUFFLElBQUksQ0FBQyxhQUFhLENBQUMsQ0FBQztLQUM5RTtJQUVELElBQWMsYUFBYTtRQUN2QixPQUFPO1lBQ0gsb0JBQW9CLEVBQUUsSUFBSSxDQUFDLG9CQUFvQjtZQUMvQyxjQUFjLEVBQUUsSUFBSSxDQUFDLGNBQWM7WUFDbkMsUUFBUSxFQUFFLElBQUksQ0FBQyxRQUFRO1lBQ3ZCLHVCQUF1QixFQUFFLElBQUksQ0FBQyx1QkFBdUI7WUFDckQscUJBQXFCLEVBQUUsSUFBSSxDQUFDLHFCQUFxQjtZQUNqRCxzQkFBc0IsRUFBRSxJQUFJLENBQUMsc0JBQXNCO1lBQ25ELFVBQVUsRUFBRSxJQUFJLENBQUMsVUFBVTtZQUMzQiw4QkFBOEIsRUFBRSxJQUFJLENBQUMsOEJBQThCO1lBQ25FLGlCQUFpQixFQUFFLElBQUksQ0FBQyxpQkFBaUI7WUFDekMsZUFBZSxFQUFFLElBQUksQ0FBQyxlQUFlO1lBQ3JDLDJCQUEyQixFQUFFLElBQUksQ0FBQywyQkFBMkI7U0FDaEUsQ0FBQztLQUNMO0lBRVMsZ0JBQWdCLENBQUMsS0FBMkI7UUFDbEQsT0FBTyxxQ0FBcUMsQ0FBQyxLQUFLLENBQUMsQ0FBQztLQUN2RDs7QUFuTkwsNENBb05DOzs7QUFuTkc7O0dBRUc7QUFDb0IsdUNBQXNCLEdBQUcsaUNBQWlDLENBQUM7QUF3UXRGOzs7Ozs7R0FNRztBQUNILFNBQVMsK0RBQStELENBQUMsVUFBZTtJQUNwRixJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sR0FBRyxDQUFDLGtCQUFrQixDQUFDO0tBQUU7SUFDbkUsTUFBTSxNQUFNLEdBQUcsSUFBSSxHQUFHLENBQUMsaUJBQWlCLEVBQUUsQ0FBQztJQUMzQyxJQUFJLE9BQU8sVUFBVSxLQUFLLFFBQVEsRUFBRTtRQUNoQyxNQUFNLENBQUMsT0FBTyxDQUFDLElBQUksR0FBRyxDQUFDLGdCQUFnQixDQUFDLG9DQUFvQyxHQUFHLElBQUksQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxDQUFDO0tBQy9HO0lBQ0QsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsWUFBWSxFQUFFLEdBQUcsQ0FBQyxhQUFhLENBQUMsaURBQWlELENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDO0lBQ2pKLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFlBQVksRUFBRSxHQUFHLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQztJQUNsRyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxZQUFZLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDO0lBQy9GLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFdBQVcsRUFBRSxHQUFHLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxVQUFVLENBQUMsU0FBUyxDQUFDLENBQUMsQ0FBQztJQUNoRyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxXQUFXLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQUMsQ0FBQyxDQUFDO0lBQzdGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFdBQVcsRUFBRSxHQUFHLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxVQUFVLENBQUMsU0FBUyxDQUFDLENBQUMsQ0FBQztJQUNoRyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxXQUFXLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQUMsQ0FBQyxDQUFDO0lBQzdGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLE1BQU0sRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUM7SUFDbkYsT0FBTyxNQUFNLENBQUMsSUFBSSxDQUFDLDZFQUE2RSxDQUFDLENBQUM7QUFDdEcsQ0FBQztBQUVEOzs7Ozs7R0FNRztBQUNILG9CQUFvQjtBQUNwQixTQUFTLHFFQUFxRSxDQUFDLFVBQWU7SUFDMUYsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLFVBQVUsQ0FBQztLQUFFO0lBQ3ZELCtEQUErRCxDQUFDLFVBQVUsQ0FBQyxDQUFDLGFBQWEsRUFBRSxDQUFDO0lBQzVGLE9BQU87UUFDSCxVQUFVLEVBQUUsR0FBRyxDQUFDLFVBQVUsQ0FBQyx1REFBdUQsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUM7UUFDMUcsVUFBVSxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDO1FBQzdELFNBQVMsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLFNBQVMsQ0FBQztRQUMzRCxTQUFTLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQUM7UUFDM0QsSUFBSSxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDO0tBQ3BELENBQUM7QUFDTixDQUFDO0FBRUQsb0JBQW9CO0FBQ3BCLFNBQVMsdUVBQXVFLENBQUMsVUFBZTtJQUM1RixJQUFJLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUNwQyxPQUFPLElBQUksU0FBUyxDQUFDLHdCQUF3QixDQUFDLFVBQVUsQ0FBQyxDQUFDO0tBQzdEO0lBQ0QsVUFBVSxHQUFHLFVBQVUsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDO0lBQ2xELElBQUksT0FBTyxVQUFVLEtBQUssUUFBUSxFQUFFO1FBQ2hDLE9BQU8sSUFBSSxTQUFTLENBQUMsd0JBQXdCLENBQUMsVUFBVSxDQUFDLENBQUM7S0FDN0Q7SUFDRCxNQUFNLEdBQUcsR0FBRyxJQUFJLFNBQVMsQ0FBQyxnQ0FBZ0MsRUFBMEQsQ0FBQztJQUNySCxHQUFHLENBQUMsaUJBQWlCLENBQUMsWUFBWSxFQUFFLFlBQVksRUFBRSxVQUFVLENBQUMsVUFBVSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFFBQVEsQ0FBQyx5REFBeUQsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDdk4sR0FBRyxDQUFDLGlCQUFpQixDQUFDLFlBQVksRUFBRSxZQUFZLEVBQUUsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQztJQUNqSCxHQUFHLENBQUMsaUJBQWlCLENBQUMsV0FBVyxFQUFFLFdBQVcsRUFBRSxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQUMsQ0FBQyxDQUFDO0lBQzlHLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxXQUFXLEVBQUUsV0FBVyxFQUFFLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUM7SUFDOUcsR0FBRyxDQUFDLGlCQUFpQixDQUFDLE1BQU0sRUFBRSxNQUFNLEVBQUUsVUFBVSxDQUFDLElBQUksSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUNySSxHQUFHLENBQUMsZ0NBQWdDLENBQUMsVUFBVSxDQUFDLENBQUM7SUFDakQsT0FBTyxHQUFHLENBQUM7QUFDZixDQUFDO0FBcUNEOzs7Ozs7R0FNRztBQUNILFNBQVMsd0NBQXdDLENBQUMsVUFBZTtJQUM3RCxJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sR0FBRyxDQUFDLGtCQUFrQixDQUFDO0tBQUU7SUFDbkUsTUFBTSxNQUFNLEdBQUcsSUFBSSxHQUFHLENBQUMsaUJBQWlCLEVBQUUsQ0FBQztJQUMzQyxJQUFJLE9BQU8sVUFBVSxLQUFLLFFBQVEsRUFBRTtRQUNoQyxNQUFNLENBQUMsT0FBTyxDQUFDLElBQUksR0FBRyxDQUFDLGdCQUFnQixDQUFDLG9DQUFvQyxHQUFHLElBQUksQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxDQUFDO0tBQy9HO0lBQ0QsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsWUFBWSxFQUFFLEdBQUcsQ0FBQyxhQUFhLENBQUMsaURBQWlELENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDO0lBQ2pKLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFlBQVksRUFBRSxHQUFHLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQztJQUNsRyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxZQUFZLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDO0lBQy9GLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFdBQVcsRUFBRSxHQUFHLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxVQUFVLENBQUMsU0FBUyxDQUFDLENBQUMsQ0FBQztJQUNoRyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxXQUFXLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQUMsQ0FBQyxDQUFDO0lBQzdGLE9BQU8sTUFBTSxDQUFDLElBQUksQ0FBQyxzREFBc0QsQ0FBQyxDQUFDO0FBQy9FLENBQUM7QUFFRDs7Ozs7O0dBTUc7QUFDSCxvQkFBb0I7QUFDcEIsU0FBUyw4Q0FBOEMsQ0FBQyxVQUFlO0lBQ25FLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxVQUFVLENBQUM7S0FBRTtJQUN2RCx3Q0FBd0MsQ0FBQyxVQUFVLENBQUMsQ0FBQyxhQUFhLEVBQUUsQ0FBQztJQUNyRSxPQUFPO1FBQ0gsVUFBVSxFQUFFLEdBQUcsQ0FBQyxVQUFVLENBQUMsdURBQXVELENBQUMsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDO1FBQzFHLFVBQVUsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQztRQUM3RCxTQUFTLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQUM7S0FDOUQsQ0FBQztBQUNOLENBQUM7QUFFRCxvQkFBb0I7QUFDcEIsU0FBUyxnREFBZ0QsQ0FBQyxVQUFlO0lBQ3JFLElBQUksR0FBRyxDQUFDLGtCQUFrQixDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQ3BDLE9BQU8sSUFBSSxTQUFTLENBQUMsd0JBQXdCLENBQUMsVUFBVSxDQUFDLENBQUM7S0FDN0Q7SUFDRCxVQUFVLEdBQUcsVUFBVSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUM7SUFDbEQsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsT0FBTyxJQUFJLFNBQVMsQ0FBQyx3QkFBd0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztLQUM3RDtJQUNELE1BQU0sR0FBRyxHQUFHLElBQUksU0FBUyxDQUFDLGdDQUFnQyxFQUFtQyxDQUFDO0lBQzlGLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxZQUFZLEVBQUUsWUFBWSxFQUFFLFVBQVUsQ0FBQyxVQUFVLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsUUFBUSxDQUFDLHlEQUF5RCxDQUFDLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUN2TixHQUFHLENBQUMsaUJBQWlCLENBQUMsWUFBWSxFQUFFLFlBQVksRUFBRSxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDO0lBQ2pILEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxXQUFXLEVBQUUsV0FBVyxFQUFFLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUM7SUFDOUcsR0FBRyxDQUFDLGdDQUFnQyxDQUFDLFVBQVUsQ0FBQyxDQUFDO0lBQ2pELE9BQU8sR0FBRyxDQUFDO0FBQ2YsQ0FBQztBQWlFRDs7Ozs7O0dBTUc7QUFDSCxTQUFTLGlEQUFpRCxDQUFDLFVBQWU7SUFDdEUsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQztLQUFFO0lBQ25FLE1BQU0sTUFBTSxHQUFHLElBQUksR0FBRyxDQUFDLGlCQUFpQixFQUFFLENBQUM7SUFDM0MsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsTUFBTSxDQUFDLE9BQU8sQ0FBQyxJQUFJLEdBQUcsQ0FBQyxnQkFBZ0IsQ0FBQyxvQ0FBb0MsR0FBRyxJQUFJLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUMsQ0FBQztLQUMvRztJQUNELE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFlBQVksRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUM7SUFDL0YsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsSUFBSSxFQUFFLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDO0lBQ2xGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLElBQUksRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUM7SUFDL0UsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsT0FBTyxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQztJQUNyRixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxZQUFZLEVBQUUsNENBQTRDLENBQUMsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQztJQUN6SCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxZQUFZLEVBQUUsR0FBRyxDQUFDLGVBQWUsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDO0lBQ2hHLE9BQU8sTUFBTSxDQUFDLElBQUksQ0FBQywrREFBK0QsQ0FBQyxDQUFDO0FBQ3hGLENBQUM7QUFFRDs7Ozs7O0dBTUc7QUFDSCxvQkFBb0I7QUFDcEIsU0FBUyx1REFBdUQsQ0FBQyxVQUFlO0lBQzVFLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxVQUFVLENBQUM7S0FBRTtJQUN2RCxpREFBaUQsQ0FBQyxVQUFVLENBQUMsQ0FBQyxhQUFhLEVBQUUsQ0FBQztJQUM5RSxPQUFPO1FBQ0gsVUFBVSxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDO1FBQzdELEVBQUUsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLEVBQUUsQ0FBQztRQUM3QyxLQUFLLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxLQUFLLENBQUM7UUFDbkQsVUFBVSxFQUFFLGtEQUFrRCxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUM7UUFDckYsVUFBVSxFQUFFLEdBQUcsQ0FBQyx1QkFBdUIsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDO0tBQ2pFLENBQUM7QUFDTixDQUFDO0FBRUQsb0JBQW9CO0FBQ3BCLFNBQVMseURBQXlELENBQUMsVUFBZTtJQUM5RSxJQUFJLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUNwQyxPQUFPLElBQUksU0FBUyxDQUFDLHdCQUF3QixDQUFDLFVBQVUsQ0FBQyxDQUFDO0tBQzdEO0lBQ0QsVUFBVSxHQUFHLFVBQVUsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDO0lBQ2xELElBQUksT0FBTyxVQUFVLEtBQUssUUFBUSxFQUFFO1FBQ2hDLE9BQU8sSUFBSSxTQUFTLENBQUMsd0JBQXdCLENBQUMsVUFBVSxDQUFDLENBQUM7S0FDN0Q7SUFDRCxNQUFNLEdBQUcsR0FBRyxJQUFJLFNBQVMsQ0FBQyxnQ0FBZ0MsRUFBNEMsQ0FBQztJQUN2RyxHQUFHLENBQUMsaUJBQWlCLENBQUMsWUFBWSxFQUFFLFlBQVksRUFBRSxVQUFVLENBQUMsVUFBVSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQzdKLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLEVBQUUsSUFBSSxFQUFFLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUM7SUFDekYsR0FBRyxDQUFDLGlCQUFpQixDQUFDLE9BQU8sRUFBRSxPQUFPLEVBQUUsVUFBVSxDQUFDLEtBQUssSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUN6SSxHQUFHLENBQUMsaUJBQWlCLENBQUMsWUFBWSxFQUFFLFlBQVksRUFBRSxVQUFVLENBQUMsVUFBVSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsb0RBQW9ELENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUMzSyxHQUFHLENBQUMsaUJBQWlCLENBQUMsWUFBWSxFQUFFLFlBQVksRUFBRSxVQUFVLENBQUMsVUFBVSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQzlKLEdBQUcsQ0FBQyxnQ0FBZ0MsQ0FBQyxVQUFVLENBQUMsQ0FBQztJQUNqRCxPQUFPLEdBQUcsQ0FBQztBQUNmLENBQUM7QUEyQkQ7Ozs7OztHQU1HO0FBQ0gsU0FBUyxpREFBaUQsQ0FBQyxVQUFlO0lBQ3RFLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxHQUFHLENBQUMsa0JBQWtCLENBQUM7S0FBRTtJQUNuRSxNQUFNLE1BQU0sR0FBRyxJQUFJLEdBQUcsQ0FBQyxpQkFBaUIsRUFBRSxDQUFDO0lBQzNDLElBQUksT0FBTyxVQUFVLEtBQUssUUFBUSxFQUFFO1FBQ2hDLE1BQU0sQ0FBQyxPQUFPLENBQUMsSUFBSSxHQUFHLENBQUMsZ0JBQWdCLENBQUMsb0NBQW9DLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLENBQUM7S0FDL0c7SUFDRCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxNQUFNLEVBQUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUM7SUFDdEYsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsTUFBTSxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQztJQUNuRixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxPQUFPLEVBQUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLENBQUMsVUFBVSxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUM7SUFDeEYsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsT0FBTyxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQztJQUNyRixPQUFPLE1BQU0sQ0FBQyxJQUFJLENBQUMsK0RBQStELENBQUMsQ0FBQztBQUN4RixDQUFDO0FBRUQ7Ozs7OztHQU1HO0FBQ0gsb0JBQW9CO0FBQ3BCLFNBQVMsdURBQXVELENBQUMsVUFBZTtJQUM1RSxJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sVUFBVSxDQUFDO0tBQUU7SUFDdkQsaURBQWlELENBQUMsVUFBVSxDQUFDLENBQUMsYUFBYSxFQUFFLENBQUM7SUFDOUUsT0FBTztRQUNILElBQUksRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQztRQUNqRCxLQUFLLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxLQUFLLENBQUM7S0FDdEQsQ0FBQztBQUNOLENBQUM7QUFFRCxvQkFBb0I7QUFDcEIsU0FBUyx5REFBeUQsQ0FBQyxVQUFlO0lBQzlFLElBQUksR0FBRyxDQUFDLGtCQUFrQixDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQ3BDLE9BQU8sSUFBSSxTQUFTLENBQUMsd0JBQXdCLENBQUMsVUFBVSxDQUFDLENBQUM7S0FDN0Q7SUFDRCxVQUFVLEdBQUcsVUFBVSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUM7SUFDbEQsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsT0FBTyxJQUFJLFNBQVMsQ0FBQyx3QkFBd0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztLQUM3RDtJQUNELE1BQU0sR0FBRyxHQUFHLElBQUksU0FBUyxDQUFDLGdDQUFnQyxFQUE0QyxDQUFDO0lBQ3ZHLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxNQUFNLEVBQUUsTUFBTSxFQUFFLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUM7SUFDL0YsR0FBRyxDQUFDLGlCQUFpQixDQUFDLE9BQU8sRUFBRSxPQUFPLEVBQUUsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQztJQUNsRyxHQUFHLENBQUMsZ0NBQWdDLENBQUMsVUFBVSxDQUFDLENBQUM7SUFDakQsT0FBTyxHQUFHLENBQUM7QUFDZixDQUFDO0FBdUNEOzs7Ozs7R0FNRztBQUNILFNBQVMsNENBQTRDLENBQUMsVUFBZTtJQUNqRSxJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sR0FBRyxDQUFDLGtCQUFrQixDQUFDO0tBQUU7SUFDbkUsTUFBTSxNQUFNLEdBQUcsSUFBSSxHQUFHLENBQUMsaUJBQWlCLEVBQUUsQ0FBQztJQUMzQyxJQUFJLE9BQU8sVUFBVSxLQUFLLFFBQVEsRUFBRTtRQUNoQyxNQUFNLENBQUMsT0FBTyxDQUFDLElBQUksR0FBRyxDQUFDLGdCQUFnQixDQUFDLG9DQUFvQyxHQUFHLElBQUksQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxDQUFDO0tBQy9HO0lBQ0QsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsUUFBUSxFQUFFLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDO0lBQzFGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFFBQVEsRUFBRSx3Q0FBd0MsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDO0lBQzdHLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLE1BQU0sRUFBRSxHQUFHLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQztJQUN0RixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxNQUFNLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDO0lBQ25GLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLE1BQU0sRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUM7SUFDbkYsT0FBTyxNQUFNLENBQUMsSUFBSSxDQUFDLDBEQUEwRCxDQUFDLENBQUM7QUFDbkYsQ0FBQztBQUVEOzs7Ozs7R0FNRztBQUNILG9CQUFvQjtBQUNwQixTQUFTLGtEQUFrRCxDQUFDLFVBQWU7SUFDdkUsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLFVBQVUsQ0FBQztLQUFFO0lBQ3ZELDRDQUE0QyxDQUFDLFVBQVUsQ0FBQyxDQUFDLGFBQWEsRUFBRSxDQUFDO0lBQ3pFLE9BQU87UUFDSCxNQUFNLEVBQUUsOENBQThDLENBQUMsVUFBVSxDQUFDLE1BQU0sQ0FBQztRQUN6RSxJQUFJLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUM7UUFDakQsSUFBSSxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDO0tBQ3BELENBQUM7QUFDTixDQUFDO0FBRUQsb0JBQW9CO0FBQ3BCLFNBQVMsb0RBQW9ELENBQUMsVUFBZTtJQUN6RSxJQUFJLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUNwQyxPQUFPLElBQUksU0FBUyxDQUFDLHdCQUF3QixDQUFDLFVBQVUsQ0FBQyxDQUFDO0tBQzdEO0lBQ0QsVUFBVSxHQUFHLFVBQVUsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDO0lBQ2xELElBQUksT0FBTyxVQUFVLEtBQUssUUFBUSxFQUFFO1FBQ2hDLE9BQU8sSUFBSSxTQUFTLENBQUMsd0JBQXdCLENBQUMsVUFBVSxDQUFDLENBQUM7S0FDN0Q7SUFDRCxNQUFNLEdBQUcsR0FBRyxJQUFJLFNBQVMsQ0FBQyxnQ0FBZ0MsRUFBdUMsQ0FBQztJQUNsRyxHQUFHLENBQUMsaUJBQWlCLENBQUMsUUFBUSxFQUFFLFFBQVEsRUFBRSxnREFBZ0QsQ0FBQyxVQUFVLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQztJQUMvRyxHQUFHLENBQUMsaUJBQWlCLENBQUMsTUFBTSxFQUFFLE1BQU0sRUFBRSxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDO0lBQy9GLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxNQUFNLEVBQUUsTUFBTSxFQUFFLFVBQVUsQ0FBQyxJQUFJLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDckksR0FBRyxDQUFDLGdDQUFnQyxDQUFDLFVBQVUsQ0FBQyxDQUFDO0lBQ2pELE9BQU8sR0FBRyxDQUFDO0FBQ2YsQ0FBQztBQTZDRDs7Ozs7O0dBTUc7QUFDSCxTQUFTLCtEQUErRCxDQUFDLFVBQWU7SUFDcEYsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQztLQUFFO0lBQ25FLE1BQU0sTUFBTSxHQUFHLElBQUksR0FBRyxDQUFDLGlCQUFpQixFQUFFLENBQUM7SUFDM0MsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsTUFBTSxDQUFDLE9BQU8sQ0FBQyxJQUFJLEdBQUcsQ0FBQyxnQkFBZ0IsQ0FBQyxvQ0FBb0MsR0FBRyxJQUFJLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUMsQ0FBQztLQUMvRztJQUNELE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLHNCQUFzQixFQUFFLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDLENBQUM7SUFDdEgsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsc0JBQXNCLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDLENBQUM7SUFDbkgsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsZUFBZSxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsYUFBYSxDQUFDLENBQUMsQ0FBQztJQUNyRyxPQUFPLE1BQU0sQ0FBQyxJQUFJLENBQUMsNkVBQTZFLENBQUMsQ0FBQztBQUN0RyxDQUFDO0FBRUQ7Ozs7OztHQU1HO0FBQ0gsb0JBQW9CO0FBQ3BCLFNBQVMscUVBQXFFLENBQUMsVUFBZTtJQUMxRixJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sVUFBVSxDQUFDO0tBQUU7SUFDdkQsK0RBQStELENBQUMsVUFBVSxDQUFDLENBQUMsYUFBYSxFQUFFLENBQUM7SUFDNUYsT0FBTztRQUNILG9CQUFvQixFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsb0JBQW9CLENBQUM7UUFDakYsYUFBYSxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsYUFBYSxDQUFDO0tBQ3RFLENBQUM7QUFDTixDQUFDO0FBRUQsb0JBQW9CO0FBQ3BCLFNBQVMsdUVBQXVFLENBQUMsVUFBZTtJQUM1RixJQUFJLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUNwQyxPQUFPLElBQUksU0FBUyxDQUFDLHdCQUF3QixDQUFDLFVBQVUsQ0FBQyxDQUFDO0tBQzdEO0lBQ0QsVUFBVSxHQUFHLFVBQVUsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDO0lBQ2xELElBQUksT0FBTyxVQUFVLEtBQUssUUFBUSxFQUFFO1FBQ2hDLE9BQU8sSUFBSSxTQUFTLENBQUMsd0JBQXdCLENBQUMsVUFBVSxDQUFDLENBQUM7S0FDN0Q7SUFDRCxNQUFNLEdBQUcsR0FBRyxJQUFJLFNBQVMsQ0FBQyxnQ0FBZ0MsRUFBMEQsQ0FBQztJQUNySCxHQUFHLENBQUMsaUJBQWlCLENBQUMsc0JBQXNCLEVBQUUsc0JBQXNCLEVBQUUsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsb0JBQW9CLENBQUMsQ0FBQyxDQUFDO0lBQy9JLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxlQUFlLEVBQUUsZUFBZSxFQUFFLFVBQVUsQ0FBQyxhQUFhLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxhQUFhLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDekssR0FBRyxDQUFDLGdDQUFnQyxDQUFDLFVBQVUsQ0FBQyxDQUFDO0lBQ2pELE9BQU8sR0FBRyxDQUFDO0FBQ2YsQ0FBQztBQTRERDs7Ozs7O0dBTUc7QUFDSCxTQUFTLGdFQUFnRSxDQUFDLFVBQWU7SUFDckYsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQztLQUFFO0lBQ25FLE1BQU0sTUFBTSxHQUFHLElBQUksR0FBRyxDQUFDLGlCQUFpQixFQUFFLENBQUM7SUFDM0MsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsTUFBTSxDQUFDLE9BQU8sQ0FBQyxJQUFJLEdBQUcsQ0FBQyxnQkFBZ0IsQ0FBQyxvQ0FBb0MsR0FBRyxJQUFJLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUMsQ0FBQztLQUMvRztJQUNELE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLDJCQUEyQixFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMseUJBQXlCLENBQUMsQ0FBQyxDQUFDO0lBQzdILE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLG1CQUFtQixFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxDQUFDO0lBQzdHLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLHNCQUFzQixFQUFFLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDLENBQUM7SUFDdEgsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsc0JBQXNCLEVBQUUsR0FBRyxDQUFDLGFBQWEsQ0FBQyxzRUFBc0UsQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDLG9CQUFvQixDQUFDLENBQUMsQ0FBQztJQUMxTCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxNQUFNLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDO0lBQ25GLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLHNCQUFzQixFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsb0JBQW9CLENBQUMsQ0FBQyxDQUFDO0lBQ25ILE9BQU8sTUFBTSxDQUFDLElBQUksQ0FBQyw4RUFBOEUsQ0FBQyxDQUFDO0FBQ3ZHLENBQUM7QUFFRDs7Ozs7O0dBTUc7QUFDSCxvQkFBb0I7QUFDcEIsU0FBUyxzRUFBc0UsQ0FBQyxVQUFlO0lBQzNGLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxVQUFVLENBQUM7S0FBRTtJQUN2RCxnRUFBZ0UsQ0FBQyxVQUFVLENBQUMsQ0FBQyxhQUFhLEVBQUUsQ0FBQztJQUM3RixPQUFPO1FBQ0gseUJBQXlCLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyx5QkFBeUIsQ0FBQztRQUMzRixpQkFBaUIsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLGlCQUFpQixDQUFDO1FBQzNFLG9CQUFvQixFQUFFLEdBQUcsQ0FBQyxVQUFVLENBQUMsNEVBQTRFLENBQUMsQ0FBQyxVQUFVLENBQUMsb0JBQW9CLENBQUM7UUFDbkosSUFBSSxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDO1FBQ2pELG9CQUFvQixFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsb0JBQW9CLENBQUM7S0FDcEYsQ0FBQztBQUNOLENBQUM7QUFFRCxvQkFBb0I7QUFDcEIsU0FBUyx3RUFBd0UsQ0FBQyxVQUFlO0lBQzdGLElBQUksR0FBRyxDQUFDLGtCQUFrQixDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQ3BDLE9BQU8sSUFBSSxTQUFTLENBQUMsd0JBQXdCLENBQUMsVUFBVSxDQUFDLENBQUM7S0FDN0Q7SUFDRCxVQUFVLEdBQUcsVUFBVSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUM7SUFDbEQsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsT0FBTyxJQUFJLFNBQVMsQ0FBQyx3QkFBd0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztLQUM3RDtJQUNELE1BQU0sR0FBRyxHQUFHLElBQUksU0FBUyxDQUFDLGdDQUFnQyxFQUEyRCxDQUFDO0lBQ3RILEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQywyQkFBMkIsRUFBRSwyQkFBMkIsRUFBRSxVQUFVLENBQUMseUJBQXlCLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyx5QkFBeUIsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUN6TixHQUFHLENBQUMsaUJBQWlCLENBQUMsbUJBQW1CLEVBQUUsbUJBQW1CLEVBQUUsVUFBVSxDQUFDLGlCQUFpQixJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDekwsR0FBRyxDQUFDLGlCQUFpQixDQUFDLHNCQUFzQixFQUFFLHNCQUFzQixFQUFFLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxRQUFRLENBQUMsOEVBQThFLENBQUMsQ0FBQyxVQUFVLENBQUMsb0JBQW9CLENBQUMsQ0FBQyxDQUFDO0lBQzlOLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxNQUFNLEVBQUUsTUFBTSxFQUFFLFVBQVUsQ0FBQyxJQUFJLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDckksR0FBRyxDQUFDLGlCQUFpQixDQUFDLHNCQUFzQixFQUFFLHNCQUFzQixFQUFFLFVBQVUsQ0FBQyxvQkFBb0IsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLG9CQUFvQixDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ3JNLEdBQUcsQ0FBQyxnQ0FBZ0MsQ0FBQyxVQUFVLENBQUMsQ0FBQztJQUNqRCxPQUFPLEdBQUcsQ0FBQztBQUNmLENBQUM7QUFxQkQ7Ozs7OztHQU1HO0FBQ0gsU0FBUywyRUFBMkUsQ0FBQyxVQUFlO0lBQ2hHLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxHQUFHLENBQUMsa0JBQWtCLENBQUM7S0FBRTtJQUNuRSxNQUFNLE1BQU0sR0FBRyxJQUFJLEdBQUcsQ0FBQyxpQkFBaUIsRUFBRSxDQUFDO0lBQzNDLElBQUksT0FBTyxVQUFVLEtBQUssUUFBUSxFQUFFO1FBQ2hDLE1BQU0sQ0FBQyxPQUFPLENBQUMsSUFBSSxHQUFHLENBQUMsZ0JBQWdCLENBQUMsb0NBQW9DLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLENBQUM7S0FDL0c7SUFDRCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxtQkFBbUIsRUFBRSxHQUFHLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxVQUFVLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxDQUFDO0lBQ2hILE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLG1CQUFtQixFQUFFLEdBQUcsQ0FBQyxhQUFhLENBQUMsaURBQWlELENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLENBQUM7SUFDL0osT0FBTyxNQUFNLENBQUMsSUFBSSxDQUFDLHlGQUF5RixDQUFDLENBQUM7QUFDbEgsQ0FBQztBQUVEOzs7Ozs7R0FNRztBQUNILG9CQUFvQjtBQUNwQixTQUFTLGlGQUFpRixDQUFDLFVBQWU7SUFDdEcsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLFVBQVUsQ0FBQztLQUFFO0lBQ3ZELDJFQUEyRSxDQUFDLFVBQVUsQ0FBQyxDQUFDLGFBQWEsRUFBRSxDQUFDO0lBQ3hHLE9BQU87UUFDSCxpQkFBaUIsRUFBRSxHQUFHLENBQUMsVUFBVSxDQUFDLHVEQUF1RCxDQUFDLENBQUMsVUFBVSxDQUFDLGlCQUFpQixDQUFDO0tBQzNILENBQUM7QUFDTixDQUFDO0FBRUQsb0JBQW9CO0FBQ3BCLFNBQVMsbUZBQW1GLENBQUMsVUFBZTtJQUN4RyxJQUFJLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUNwQyxPQUFPLElBQUksU0FBUyxDQUFDLHdCQUF3QixDQUFDLFVBQVUsQ0FBQyxDQUFDO0tBQzdEO0lBQ0QsVUFBVSxHQUFHLFVBQVUsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDO0lBQ2xELElBQUksT0FBTyxVQUFVLEtBQUssUUFBUSxFQUFFO1FBQ2hDLE9BQU8sSUFBSSxTQUFTLENBQUMsd0JBQXdCLENBQUMsVUFBVSxDQUFDLENBQUM7S0FDN0Q7SUFDRCxNQUFNLEdBQUcsR0FBRyxJQUFJLFNBQVMsQ0FBQyxnQ0FBZ0MsRUFBc0UsQ0FBQztJQUNqSSxHQUFHLENBQUMsaUJBQWlCLENBQUMsbUJBQW1CLEVBQUUsbUJBQW1CLEVBQUUsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFFBQVEsQ0FBQyx5REFBeUQsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLENBQUM7SUFDaE0sR0FBRyxDQUFDLGdDQUFnQyxDQUFDLFVBQVUsQ0FBQyxDQUFDO0lBQ2pELE9BQU8sR0FBRyxDQUFDO0FBQ2YsQ0FBQztBQXFCRDs7Ozs7O0dBTUc7QUFDSCxTQUFTLHVFQUF1RSxDQUFDLFVBQWU7SUFDNUYsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQztLQUFFO0lBQ25FLE1BQU0sTUFBTSxHQUFHLElBQUksR0FBRyxDQUFDLGlCQUFpQixFQUFFLENBQUM7SUFDM0MsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsTUFBTSxDQUFDLE9BQU8sQ0FBQyxJQUFJLEdBQUcsQ0FBQyxnQkFBZ0IsQ0FBQyxvQ0FBb0MsR0FBRyxJQUFJLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUMsQ0FBQztLQUMvRztJQUNELE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLG1CQUFtQixFQUFFLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLENBQUM7SUFDaEgsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsbUJBQW1CLEVBQUUsR0FBRyxDQUFDLGFBQWEsQ0FBQyxpREFBaUQsQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDLGlCQUFpQixDQUFDLENBQUMsQ0FBQztJQUMvSixPQUFPLE1BQU0sQ0FBQyxJQUFJLENBQUMscUZBQXFGLENBQUMsQ0FBQztBQUM5RyxDQUFDO0FBRUQ7Ozs7OztHQU1HO0FBQ0gsb0JBQW9CO0FBQ3BCLFNBQVMsNkVBQTZFLENBQUMsVUFBZTtJQUNsRyxJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sVUFBVSxDQUFDO0tBQUU7SUFDdkQsdUVBQXVFLENBQUMsVUFBVSxDQUFDLENBQUMsYUFBYSxFQUFFLENBQUM7SUFDcEcsT0FBTztRQUNILGlCQUFpQixFQUFFLEdBQUcsQ0FBQyxVQUFVLENBQUMsdURBQXVELENBQUMsQ0FBQyxVQUFVLENBQUMsaUJBQWlCLENBQUM7S0FDM0gsQ0FBQztBQUNOLENBQUM7QUFFRCxvQkFBb0I7QUFDcEIsU0FBUywrRUFBK0UsQ0FBQyxVQUFlO0lBQ3BHLElBQUksR0FBRyxDQUFDLGtCQUFrQixDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQ3BDLE9BQU8sSUFBSSxTQUFTLENBQUMsd0JBQXdCLENBQUMsVUFBVSxDQUFDLENBQUM7S0FDN0Q7SUFDRCxVQUFVLEdBQUcsVUFBVSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUM7SUFDbEQsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsT0FBTyxJQUFJLFNBQVMsQ0FBQyx3QkFBd0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztLQUM3RDtJQUNELE1BQU0sR0FBRyxHQUFHLElBQUksU0FBUyxDQUFDLGdDQUFnQyxFQUFrRSxDQUFDO0lBQzdILEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxtQkFBbUIsRUFBRSxtQkFBbUIsRUFBRSxTQUFTLENBQUMsa0JBQWtCLENBQUMsUUFBUSxDQUFDLHlEQUF5RCxDQUFDLENBQUMsVUFBVSxDQUFDLGlCQUFpQixDQUFDLENBQUMsQ0FBQztJQUNoTSxHQUFHLENBQUMsZ0NBQWdDLENBQUMsVUFBVSxDQUFDLENBQUM7SUFDakQsT0FBTyxHQUFHLENBQUM7QUFDZixDQUFDO0FBcUJEOzs7Ozs7R0FNRztBQUNILFNBQVMsMEVBQTBFLENBQUMsVUFBZTtJQUMvRixJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sR0FBRyxDQUFDLGtCQUFrQixDQUFDO0tBQUU7SUFDbkUsTUFBTSxNQUFNLEdBQUcsSUFBSSxHQUFHLENBQUMsaUJBQWlCLEVBQUUsQ0FBQztJQUMzQyxJQUFJLE9BQU8sVUFBVSxLQUFLLFFBQVEsRUFBRTtRQUNoQyxNQUFNLENBQUMsT0FBTyxDQUFDLElBQUksR0FBRyxDQUFDLGdCQUFnQixDQUFDLG9DQUFvQyxHQUFHLElBQUksQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxDQUFDO0tBQy9HO0lBQ0QsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsbUJBQW1CLEVBQUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLENBQUMsVUFBVSxDQUFDLGlCQUFpQixDQUFDLENBQUMsQ0FBQztJQUNoSCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxtQkFBbUIsRUFBRSxHQUFHLENBQUMsYUFBYSxDQUFDLGlEQUFpRCxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxDQUFDO0lBQy9KLE9BQU8sTUFBTSxDQUFDLElBQUksQ0FBQyx3RkFBd0YsQ0FBQyxDQUFDO0FBQ2pILENBQUM7QUFFRDs7Ozs7O0dBTUc7QUFDSCxvQkFBb0I7QUFDcEIsU0FBUyxnRkFBZ0YsQ0FBQyxVQUFlO0lBQ3JHLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxVQUFVLENBQUM7S0FBRTtJQUN2RCwwRUFBMEUsQ0FBQyxVQUFVLENBQUMsQ0FBQyxhQUFhLEVBQUUsQ0FBQztJQUN2RyxPQUFPO1FBQ0gsaUJBQWlCLEVBQUUsR0FBRyxDQUFDLFVBQVUsQ0FBQyx1REFBdUQsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxpQkFBaUIsQ0FBQztLQUMzSCxDQUFDO0FBQ04sQ0FBQztBQUVELG9CQUFvQjtBQUNwQixTQUFTLGtGQUFrRixDQUFDLFVBQWU7SUFDdkcsSUFBSSxHQUFHLENBQUMsa0JBQWtCLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFDcEMsT0FBTyxJQUFJLFNBQVMsQ0FBQyx3QkFBd0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztLQUM3RDtJQUNELFVBQVUsR0FBRyxVQUFVLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQztJQUNsRCxJQUFJLE9BQU8sVUFBVSxLQUFLLFFBQVEsRUFBRTtRQUNoQyxPQUFPLElBQUksU0FBUyxDQUFDLHdCQUF3QixDQUFDLFVBQVUsQ0FBQyxDQUFDO0tBQzdEO0lBQ0QsTUFBTSxHQUFHLEdBQUcsSUFBSSxTQUFTLENBQUMsZ0NBQWdDLEVBQXFFLENBQUM7SUFDaEksR0FBRyxDQUFDLGlCQUFpQixDQUFDLG1CQUFtQixFQUFFLG1CQUFtQixFQUFFLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxRQUFRLENBQUMseURBQXlELENBQUMsQ0FBQyxVQUFVLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxDQUFDO0lBQ2hNLEdBQUcsQ0FBQyxnQ0FBZ0MsQ0FBQyxVQUFVLENBQUMsQ0FBQztJQUNqRCxPQUFPLEdBQUcsQ0FBQztBQUNmLENBQUM7QUF1RUQ7Ozs7OztHQU1HO0FBQ0gsU0FBUyxzRUFBc0UsQ0FBQyxVQUFlO0lBQzNGLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxHQUFHLENBQUMsa0JBQWtCLENBQUM7S0FBRTtJQUNuRSxNQUFNLE1BQU0sR0FBRyxJQUFJLEdBQUcsQ0FBQyxpQkFBaUIsRUFBRSxDQUFDO0lBQzNDLElBQUksT0FBTyxVQUFVLEtBQUssUUFBUSxFQUFFO1FBQ2hDLE1BQU0sQ0FBQyxPQUFPLENBQUMsSUFBSSxHQUFHLENBQUMsZ0JBQWdCLENBQUMsb0NBQW9DLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLENBQUM7S0FDL0c7SUFDRCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyx1Q0FBdUMsRUFBRSwyRUFBMkUsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxxQ0FBcUMsQ0FBQyxDQUFDLENBQUM7SUFDOU0sTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsbUNBQW1DLEVBQUUsdUVBQXVFLENBQUMsQ0FBQyxVQUFVLENBQUMsaUNBQWlDLENBQUMsQ0FBQyxDQUFDO0lBQ2xNLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLHNDQUFzQyxFQUFFLDBFQUEwRSxDQUFDLENBQUMsVUFBVSxDQUFDLG9DQUFvQyxDQUFDLENBQUMsQ0FBQztJQUMzTSxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxtQ0FBbUMsRUFBRSx1RUFBdUUsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxpQ0FBaUMsQ0FBQyxDQUFDLENBQUM7SUFDbE0sTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsbUNBQW1DLEVBQUUsdUVBQXVFLENBQUMsQ0FBQyxVQUFVLENBQUMsaUNBQWlDLENBQUMsQ0FBQyxDQUFDO0lBQ2xNLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLHNDQUFzQyxFQUFFLDBFQUEwRSxDQUFDLENBQUMsVUFBVSxDQUFDLG9DQUFvQyxDQUFDLENBQUMsQ0FBQztJQUMzTSxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxhQUFhLEVBQUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLENBQUMsVUFBVSxDQUFDLFdBQVcsQ0FBQyxDQUFDLENBQUM7SUFDcEcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsYUFBYSxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsV0FBVyxDQUFDLENBQUMsQ0FBQztJQUNqRyxPQUFPLE1BQU0sQ0FBQyxJQUFJLENBQUMsb0ZBQW9GLENBQUMsQ0FBQztBQUM3RyxDQUFDO0FBRUQ7Ozs7OztHQU1HO0FBQ0gsb0JBQW9CO0FBQ3BCLFNBQVMsNEVBQTRFLENBQUMsVUFBZTtJQUNqRyxJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sVUFBVSxDQUFDO0tBQUU7SUFDdkQsc0VBQXNFLENBQUMsVUFBVSxDQUFDLENBQUMsYUFBYSxFQUFFLENBQUM7SUFDbkcsT0FBTztRQUNILHFDQUFxQyxFQUFFLGlGQUFpRixDQUFDLFVBQVUsQ0FBQyxxQ0FBcUMsQ0FBQztRQUMxSyxpQ0FBaUMsRUFBRSw2RUFBNkUsQ0FBQyxVQUFVLENBQUMsaUNBQWlDLENBQUM7UUFDOUosb0NBQW9DLEVBQUUsZ0ZBQWdGLENBQUMsVUFBVSxDQUFDLG9DQUFvQyxDQUFDO1FBQ3ZLLGlDQUFpQyxFQUFFLDZFQUE2RSxDQUFDLFVBQVUsQ0FBQyxpQ0FBaUMsQ0FBQztRQUM5SixpQ0FBaUMsRUFBRSw2RUFBNkUsQ0FBQyxVQUFVLENBQUMsaUNBQWlDLENBQUM7UUFDOUosb0NBQW9DLEVBQUUsZ0ZBQWdGLENBQUMsVUFBVSxDQUFDLG9DQUFvQyxDQUFDO1FBQ3ZLLFdBQVcsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLFdBQVcsQ0FBQztLQUNsRSxDQUFDO0FBQ04sQ0FBQztBQUVELG9CQUFvQjtBQUNwQixTQUFTLDhFQUE4RSxDQUFDLFVBQWU7SUFDbkcsSUFBSSxHQUFHLENBQUMsa0JBQWtCLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFDcEMsT0FBTyxJQUFJLFNBQVMsQ0FBQyx3QkFBd0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztLQUM3RDtJQUNELFVBQVUsR0FBRyxVQUFVLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQztJQUNsRCxJQUFJLE9BQU8sVUFBVSxLQUFLLFFBQVEsRUFBRTtRQUNoQyxPQUFPLElBQUksU0FBUyxDQUFDLHdCQUF3QixDQUFDLFVBQVUsQ0FBQyxDQUFDO0tBQzdEO0lBQ0QsTUFBTSxHQUFHLEdBQUcsSUFBSSxTQUFTLENBQUMsZ0NBQWdDLEVBQWlFLENBQUM7SUFDNUgsR0FBRyxDQUFDLGlCQUFpQixDQUFDLHVDQUF1QyxFQUFFLHVDQUF1QyxFQUFFLFVBQVUsQ0FBQyxxQ0FBcUMsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLG1GQUFtRixDQUFDLFVBQVUsQ0FBQyxxQ0FBcUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUN0VCxHQUFHLENBQUMsaUJBQWlCLENBQUMsbUNBQW1DLEVBQUUsbUNBQW1DLEVBQUUsVUFBVSxDQUFDLGlDQUFpQyxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsK0VBQStFLENBQUMsVUFBVSxDQUFDLGlDQUFpQyxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ2xTLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxzQ0FBc0MsRUFBRSxzQ0FBc0MsRUFBRSxVQUFVLENBQUMsb0NBQW9DLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxrRkFBa0YsQ0FBQyxVQUFVLENBQUMsb0NBQW9DLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDalQsR0FBRyxDQUFDLGlCQUFpQixDQUFDLG1DQUFtQyxFQUFFLG1DQUFtQyxFQUFFLFVBQVUsQ0FBQyxpQ0FBaUMsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLCtFQUErRSxDQUFDLFVBQVUsQ0FBQyxpQ0FBaUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUNsUyxHQUFHLENBQUMsaUJBQWlCLENBQUMsbUNBQW1DLEVBQUUsbUNBQW1DLEVBQUUsVUFBVSxDQUFDLGlDQUFpQyxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsK0VBQStFLENBQUMsVUFBVSxDQUFDLGlDQUFpQyxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ2xTLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxzQ0FBc0MsRUFBRSxzQ0FBc0MsRUFBRSxVQUFVLENBQUMsb0NBQW9DLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxrRkFBa0YsQ0FBQyxVQUFVLENBQUMsb0NBQW9DLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDalQsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGFBQWEsRUFBRSxhQUFhLEVBQUUsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsV0FBVyxDQUFDLENBQUMsQ0FBQztJQUNwSCxHQUFHLENBQUMsZ0NBQWdDLENBQUMsVUFBVSxDQUFDLENBQUM7SUFDakQsT0FBTyxHQUFHLENBQUM7QUFDZixDQUFDO0FBd0NEOzs7Ozs7R0FNRztBQUNILFNBQVMsdUVBQXVFLENBQUMsVUFBZTtJQUM1RixJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sR0FBRyxDQUFDLGtCQUFrQixDQUFDO0tBQUU7SUFDbkUsTUFBTSxNQUFNLEdBQUcsSUFBSSxHQUFHLENBQUMsaUJBQWlCLEVBQUUsQ0FBQztJQUMzQyxJQUFJLE9BQU8sVUFBVSxLQUFLLFFBQVEsRUFBRTtRQUNoQyxNQUFNLENBQUMsT0FBTyxDQUFDLElBQUksR0FBRyxDQUFDLGdCQUFnQixDQUFDLG9DQUFvQyxHQUFHLElBQUksQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxDQUFDO0tBQy9HO0lBQ0QsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsc0JBQXNCLEVBQUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLENBQUMsVUFBVSxDQUFDLG9CQUFvQixDQUFDLENBQUMsQ0FBQztJQUN0SCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxzQkFBc0IsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLG9CQUFvQixDQUFDLENBQUMsQ0FBQztJQUNuSCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxlQUFlLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxhQUFhLENBQUMsQ0FBQyxDQUFDO0lBQ3JHLE9BQU8sTUFBTSxDQUFDLElBQUksQ0FBQyxxRkFBcUYsQ0FBQyxDQUFDO0FBQzlHLENBQUM7QUFFRDs7Ozs7O0dBTUc7QUFDSCxvQkFBb0I7QUFDcEIsU0FBUyw2RUFBNkUsQ0FBQyxVQUFlO0lBQ2xHLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxVQUFVLENBQUM7S0FBRTtJQUN2RCx1RUFBdUUsQ0FBQyxVQUFVLENBQUMsQ0FBQyxhQUFhLEVBQUUsQ0FBQztJQUNwRyxPQUFPO1FBQ0gsb0JBQW9CLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxvQkFBb0IsQ0FBQztRQUNqRixhQUFhLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxhQUFhLENBQUM7S0FDdEUsQ0FBQztBQUNOLENBQUM7QUFFRCxvQkFBb0I7QUFDcEIsU0FBUywrRUFBK0UsQ0FBQyxVQUFlO0lBQ3BHLElBQUksR0FBRyxDQUFDLGtCQUFrQixDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQ3BDLE9BQU8sSUFBSSxTQUFTLENBQUMsd0JBQXdCLENBQUMsVUFBVSxDQUFDLENBQUM7S0FDN0Q7SUFDRCxVQUFVLEdBQUcsVUFBVSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUM7SUFDbEQsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsT0FBTyxJQUFJLFNBQVMsQ0FBQyx3QkFBd0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztLQUM3RDtJQUNELE1BQU0sR0FBRyxHQUFHLElBQUksU0FBUyxDQUFDLGdDQUFnQyxFQUFrRSxDQUFDO0lBQzdILEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxzQkFBc0IsRUFBRSxzQkFBc0IsRUFBRSxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDLENBQUM7SUFDL0ksR0FBRyxDQUFDLGlCQUFpQixDQUFDLGVBQWUsRUFBRSxlQUFlLEVBQUUsVUFBVSxDQUFDLGFBQWEsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLGFBQWEsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUN6SyxHQUFHLENBQUMsZ0NBQWdDLENBQUMsVUFBVSxDQUFDLENBQUM7SUFDakQsT0FBTyxHQUFHLENBQUM7QUFDZixDQUFDO0FBd0NEOzs7Ozs7R0FNRztBQUNILFNBQVMsdUVBQXVFLENBQUMsVUFBZTtJQUM1RixJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sR0FBRyxDQUFDLGtCQUFrQixDQUFDO0tBQUU7SUFDbkUsTUFBTSxNQUFNLEdBQUcsSUFBSSxHQUFHLENBQUMsaUJBQWlCLEVBQUUsQ0FBQztJQUMzQyxJQUFJLE9BQU8sVUFBVSxLQUFLLFFBQVEsRUFBRTtRQUNoQyxNQUFNLENBQUMsT0FBTyxDQUFDLElBQUksR0FBRyxDQUFDLGdCQUFnQixDQUFDLG9DQUFvQyxHQUFHLElBQUksQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxDQUFDO0tBQy9HO0lBQ0QsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsc0JBQXNCLEVBQUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLENBQUMsVUFBVSxDQUFDLG9CQUFvQixDQUFDLENBQUMsQ0FBQztJQUN0SCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxzQkFBc0IsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLG9CQUFvQixDQUFDLENBQUMsQ0FBQztJQUNuSCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxlQUFlLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxhQUFhLENBQUMsQ0FBQyxDQUFDO0lBQ3JHLE9BQU8sTUFBTSxDQUFDLElBQUksQ0FBQyxxRkFBcUYsQ0FBQyxDQUFDO0FBQzlHLENBQUM7QUFFRDs7Ozs7O0dBTUc7QUFDSCxvQkFBb0I7QUFDcEIsU0FBUyw2RUFBNkUsQ0FBQyxVQUFlO0lBQ2xHLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxVQUFVLENBQUM7S0FBRTtJQUN2RCx1RUFBdUUsQ0FBQyxVQUFVLENBQUMsQ0FBQyxhQUFhLEVBQUUsQ0FBQztJQUNwRyxPQUFPO1FBQ0gsb0JBQW9CLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxvQkFBb0IsQ0FBQztRQUNqRixhQUFhLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxhQUFhLENBQUM7S0FDdEUsQ0FBQztBQUNOLENBQUM7QUFFRCxvQkFBb0I7QUFDcEIsU0FBUywrRUFBK0UsQ0FBQyxVQUFlO0lBQ3BHLElBQUksR0FBRyxDQUFDLGtCQUFrQixDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQ3BDLE9BQU8sSUFBSSxTQUFTLENBQUMsd0JBQXdCLENBQUMsVUFBVSxDQUFDLENBQUM7S0FDN0Q7SUFDRCxVQUFVLEdBQUcsVUFBVSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUM7SUFDbEQsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsT0FBTyxJQUFJLFNBQVMsQ0FBQyx3QkFBd0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztLQUM3RDtJQUNELE1BQU0sR0FBRyxHQUFHLElBQUksU0FBUyxDQUFDLGdDQUFnQyxFQUFrRSxDQUFDO0lBQzdILEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxzQkFBc0IsRUFBRSxzQkFBc0IsRUFBRSxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDLENBQUM7SUFDL0ksR0FBRyxDQUFDLGlCQUFpQixDQUFDLGVBQWUsRUFBRSxlQUFlLEVBQUUsVUFBVSxDQUFDLGFBQWEsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLGFBQWEsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUN6SyxHQUFHLENBQUMsZ0NBQWdDLENBQUMsVUFBVSxDQUFDLENBQUM7SUFDakQsT0FBTyxHQUFHLENBQUM7QUFDZixDQUFDO0FBd0NEOzs7Ozs7R0FNRztBQUNILFNBQVMsMEVBQTBFLENBQUMsVUFBZTtJQUMvRixJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sR0FBRyxDQUFDLGtCQUFrQixDQUFDO0tBQUU7SUFDbkUsTUFBTSxNQUFNLEdBQUcsSUFBSSxHQUFHLENBQUMsaUJBQWlCLEVBQUUsQ0FBQztJQUMzQyxJQUFJLE9BQU8sVUFBVSxLQUFLLFFBQVEsRUFBRTtRQUNoQyxNQUFNLENBQUMsT0FBTyxDQUFDLElBQUksR0FBRyxDQUFDLGdCQUFnQixDQUFDLG9DQUFvQyxHQUFHLElBQUksQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxDQUFDO0tBQy9HO0lBQ0QsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsc0JBQXNCLEVBQUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLENBQUMsVUFBVSxDQUFDLG9CQUFvQixDQUFDLENBQUMsQ0FBQztJQUN0SCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxzQkFBc0IsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLG9CQUFvQixDQUFDLENBQUMsQ0FBQztJQUNuSCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxlQUFlLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxhQUFhLENBQUMsQ0FBQyxDQUFDO0lBQ3JHLE9BQU8sTUFBTSxDQUFDLElBQUksQ0FBQyx3RkFBd0YsQ0FBQyxDQUFDO0FBQ2pILENBQUM7QUFFRDs7Ozs7O0dBTUc7QUFDSCxvQkFBb0I7QUFDcEIsU0FBUyxnRkFBZ0YsQ0FBQyxVQUFlO0lBQ3JHLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxVQUFVLENBQUM7S0FBRTtJQUN2RCwwRUFBMEUsQ0FBQyxVQUFVLENBQUMsQ0FBQyxhQUFhLEVBQUUsQ0FBQztJQUN2RyxPQUFPO1FBQ0gsb0JBQW9CLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxvQkFBb0IsQ0FBQztRQUNqRixhQUFhLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxhQUFhLENBQUM7S0FDdEUsQ0FBQztBQUNOLENBQUM7QUFFRCxvQkFBb0I7QUFDcEIsU0FBUyxrRkFBa0YsQ0FBQyxVQUFlO0lBQ3ZHLElBQUksR0FBRyxDQUFDLGtCQUFrQixDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQ3BDLE9BQU8sSUFBSSxTQUFTLENBQUMsd0JBQXdCLENBQUMsVUFBVSxDQUFDLENBQUM7S0FDN0Q7SUFDRCxVQUFVLEdBQUcsVUFBVSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUM7SUFDbEQsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsT0FBTyxJQUFJLFNBQVMsQ0FBQyx3QkFBd0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztLQUM3RDtJQUNELE1BQU0sR0FBRyxHQUFHLElBQUksU0FBUyxDQUFDLGdDQUFnQyxFQUFxRSxDQUFDO0lBQ2hJLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxzQkFBc0IsRUFBRSxzQkFBc0IsRUFBRSxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDLENBQUM7SUFDL0ksR0FBRyxDQUFDLGlCQUFpQixDQUFDLGVBQWUsRUFBRSxlQUFlLEVBQUUsVUFBVSxDQUFDLGFBQWEsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLGFBQWEsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUN6SyxHQUFHLENBQUMsZ0NBQWdDLENBQUMsVUFBVSxDQUFDLENBQUM7SUFDakQsT0FBTyxHQUFHLENBQUM7QUFDZixDQUFDO0FBcUREOzs7Ozs7R0FNRztBQUNILFNBQVMsZ0RBQWdELENBQUMsVUFBZTtJQUNyRSxJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sR0FBRyxDQUFDLGtCQUFrQixDQUFDO0tBQUU7SUFDbkUsTUFBTSxNQUFNLEdBQUcsSUFBSSxHQUFHLENBQUMsaUJBQWlCLEVBQUUsQ0FBQztJQUMzQyxJQUFJLE9BQU8sVUFBVSxLQUFLLFFBQVEsRUFBRTtRQUNoQyxNQUFNLENBQUMsT0FBTyxDQUFDLElBQUksR0FBRyxDQUFDLGdCQUFnQixDQUFDLG9DQUFvQyxHQUFHLElBQUksQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxDQUFDO0tBQy9HO0lBQ0QsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsMEJBQTBCLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyx3QkFBd0IsQ0FBQyxDQUFDLENBQUM7SUFDM0gsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsMEJBQTBCLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyx3QkFBd0IsQ0FBQyxDQUFDLENBQUM7SUFDM0gsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsbUJBQW1CLEVBQUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLENBQUMsVUFBVSxDQUFDLGlCQUFpQixDQUFDLENBQUMsQ0FBQztJQUNoSCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxtQkFBbUIsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLGlCQUFpQixDQUFDLENBQUMsQ0FBQztJQUM3RyxPQUFPLE1BQU0sQ0FBQyxJQUFJLENBQUMsOERBQThELENBQUMsQ0FBQztBQUN2RixDQUFDO0FBRUQ7Ozs7OztHQU1HO0FBQ0gsb0JBQW9CO0FBQ3BCLFNBQVMsc0RBQXNELENBQUMsVUFBZTtJQUMzRSxJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sVUFBVSxDQUFDO0tBQUU7SUFDdkQsZ0RBQWdELENBQUMsVUFBVSxDQUFDLENBQUMsYUFBYSxFQUFFLENBQUM7SUFDN0UsT0FBTztRQUNILHdCQUF3QixFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsd0JBQXdCLENBQUM7UUFDekYsd0JBQXdCLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyx3QkFBd0IsQ0FBQztRQUN6RixpQkFBaUIsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLGlCQUFpQixDQUFDO0tBQzlFLENBQUM7QUFDTixDQUFDO0FBRUQsb0JBQW9CO0FBQ3BCLFNBQVMsd0RBQXdELENBQUMsVUFBZTtJQUM3RSxJQUFJLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUNwQyxPQUFPLElBQUksU0FBUyxDQUFDLHdCQUF3QixDQUFDLFVBQVUsQ0FBQyxDQUFDO0tBQzdEO0lBQ0QsVUFBVSxHQUFHLFVBQVUsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDO0lBQ2xELElBQUksT0FBTyxVQUFVLEtBQUssUUFBUSxFQUFFO1FBQ2hDLE9BQU8sSUFBSSxTQUFTLENBQUMsd0JBQXdCLENBQUMsVUFBVSxDQUFDLENBQUM7S0FDN0Q7SUFDRCxNQUFNLEdBQUcsR0FBRyxJQUFJLFNBQVMsQ0FBQyxnQ0FBZ0MsRUFBMkMsQ0FBQztJQUN0RyxHQUFHLENBQUMsaUJBQWlCLENBQUMsMEJBQTBCLEVBQUUsMEJBQTBCLEVBQUUsVUFBVSxDQUFDLHdCQUF3QixJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsd0JBQXdCLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDck4sR0FBRyxDQUFDLGlCQUFpQixDQUFDLDBCQUEwQixFQUFFLDBCQUEwQixFQUFFLFVBQVUsQ0FBQyx3QkFBd0IsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLHdCQUF3QixDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ3JOLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxtQkFBbUIsRUFBRSxtQkFBbUIsRUFBRSxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLENBQUM7SUFDdEksR0FBRyxDQUFDLGdDQUFnQyxDQUFDLFVBQVUsQ0FBQyxDQUFDO0lBQ2pELE9BQU8sR0FBRyxDQUFDO0FBQ2YsQ0FBQztBQTJDRDs7Ozs7O0dBTUc7QUFDSCxTQUFTLDZEQUE2RCxDQUFDLFVBQWU7SUFDbEYsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQztLQUFFO0lBQ25FLE1BQU0sTUFBTSxHQUFHLElBQUksR0FBRyxDQUFDLGlCQUFpQixFQUFFLENBQUM7SUFDM0MsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsTUFBTSxDQUFDLE9BQU8sQ0FBQyxJQUFJLEdBQUcsQ0FBQyxnQkFBZ0IsQ0FBQyxvQ0FBb0MsR0FBRyxJQUFJLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUMsQ0FBQztLQUMvRztJQUNELE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLCtCQUErQixFQUFFLCtEQUErRCxDQUFDLENBQUMsVUFBVSxDQUFDLDZCQUE2QixDQUFDLENBQUMsQ0FBQztJQUNsTCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxnQkFBZ0IsRUFBRSxHQUFHLENBQUMsZUFBZSxDQUFDLENBQUMsVUFBVSxDQUFDLGNBQWMsQ0FBQyxDQUFDLENBQUM7SUFDeEcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsK0JBQStCLEVBQUUsK0RBQStELENBQUMsQ0FBQyxVQUFVLENBQUMsNkJBQTZCLENBQUMsQ0FBQyxDQUFDO0lBQ2xMLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGFBQWEsRUFBRSxHQUFHLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxVQUFVLENBQUMsV0FBVyxDQUFDLENBQUMsQ0FBQztJQUNwRyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxhQUFhLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxXQUFXLENBQUMsQ0FBQyxDQUFDO0lBQ2pHLE9BQU8sTUFBTSxDQUFDLElBQUksQ0FBQywyRUFBMkUsQ0FBQyxDQUFDO0FBQ3BHLENBQUM7QUFFRDs7Ozs7O0dBTUc7QUFDSCxvQkFBb0I7QUFDcEIsU0FBUyxtRUFBbUUsQ0FBQyxVQUFlO0lBQ3hGLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxVQUFVLENBQUM7S0FBRTtJQUN2RCw2REFBNkQsQ0FBQyxVQUFVLENBQUMsQ0FBQyxhQUFhLEVBQUUsQ0FBQztJQUMxRixPQUFPO1FBQ0gsNkJBQTZCLEVBQUUscUVBQXFFLENBQUMsVUFBVSxDQUFDLDZCQUE2QixDQUFDO1FBQzlJLGNBQWMsRUFBRSxHQUFHLENBQUMsdUJBQXVCLENBQUMsVUFBVSxDQUFDLGNBQWMsQ0FBQztRQUN0RSw2QkFBNkIsRUFBRSxxRUFBcUUsQ0FBQyxVQUFVLENBQUMsNkJBQTZCLENBQUM7UUFDOUksV0FBVyxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsV0FBVyxDQUFDO0tBQ2xFLENBQUM7QUFDTixDQUFDO0FBRUQsb0JBQW9CO0FBQ3BCLFNBQVMscUVBQXFFLENBQUMsVUFBZTtJQUMxRixJQUFJLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUNwQyxPQUFPLElBQUksU0FBUyxDQUFDLHdCQUF3QixDQUFDLFVBQVUsQ0FBQyxDQUFDO0tBQzdEO0lBQ0QsVUFBVSxHQUFHLFVBQVUsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDO0lBQ2xELElBQUksT0FBTyxVQUFVLEtBQUssUUFBUSxFQUFFO1FBQ2hDLE9BQU8sSUFBSSxTQUFTLENBQUMsd0JBQXdCLENBQUMsVUFBVSxDQUFDLENBQUM7S0FDN0Q7SUFDRCxNQUFNLEdBQUcsR0FBRyxJQUFJLFNBQVMsQ0FBQyxnQ0FBZ0MsRUFBd0QsQ0FBQztJQUNuSCxHQUFHLENBQUMsaUJBQWlCLENBQUMsK0JBQStCLEVBQUUsK0JBQStCLEVBQUUsVUFBVSxDQUFDLDZCQUE2QixJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsdUVBQXVFLENBQUMsVUFBVSxDQUFDLDZCQUE2QixDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQzFRLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxnQkFBZ0IsRUFBRSxnQkFBZ0IsRUFBRSxVQUFVLENBQUMsY0FBYyxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsY0FBYyxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQzlLLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQywrQkFBK0IsRUFBRSwrQkFBK0IsRUFBRSxVQUFVLENBQUMsNkJBQTZCLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyx1RUFBdUUsQ0FBQyxVQUFVLENBQUMsNkJBQTZCLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDMVEsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGFBQWEsRUFBRSxhQUFhLEVBQUUsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsV0FBVyxDQUFDLENBQUMsQ0FBQztJQUNwSCxHQUFHLENBQUMsZ0NBQWdDLENBQUMsVUFBVSxDQUFDLENBQUM7SUFDakQsT0FBTyxHQUFHLENBQUM7QUFDZixDQUFDO0FBK0VEOzs7Ozs7R0FNRztBQUNILFNBQVMsZ0NBQWdDLENBQUMsVUFBZTtJQUNyRCxJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sR0FBRyxDQUFDLGtCQUFrQixDQUFDO0tBQUU7SUFDbkUsTUFBTSxNQUFNLEdBQUcsSUFBSSxHQUFHLENBQUMsaUJBQWlCLEVBQUUsQ0FBQztJQUMzQyxJQUFJLE9BQU8sVUFBVSxLQUFLLFFBQVEsRUFBRTtRQUNoQyxNQUFNLENBQUMsT0FBTyxDQUFDLElBQUksR0FBRyxDQUFDLGdCQUFnQixDQUFDLG9DQUFvQyxHQUFHLElBQUksQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxDQUFDO0tBQy9HO0lBQ0QsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsc0JBQXNCLEVBQUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLENBQUMsVUFBVSxDQUFDLG9CQUFvQixDQUFDLENBQUMsQ0FBQztJQUN0SCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxzQkFBc0IsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLG9CQUFvQixDQUFDLENBQUMsQ0FBQztJQUNuSCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxpQkFBaUIsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLGVBQWUsQ0FBQyxDQUFDLENBQUM7SUFDekcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsU0FBUyxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQztJQUN6RixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxTQUFTLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDO0lBQ3pGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFNBQVMsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUM7SUFDekYsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsWUFBWSxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQztJQUMvRixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxXQUFXLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQUMsQ0FBQyxDQUFDO0lBQzdGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFVBQVUsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLFFBQVEsQ0FBQyxDQUFDLENBQUM7SUFDM0YsT0FBTyxNQUFNLENBQUMsSUFBSSxDQUFDLCtEQUErRCxDQUFDLENBQUM7QUFDeEYsQ0FBQztBQUVEOzs7Ozs7R0FNRztBQUNILG9CQUFvQjtBQUNwQixTQUFTLHVDQUF1QyxDQUFDLFVBQWU7SUFDNUQsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLFVBQVUsQ0FBQztLQUFFO0lBQ3ZELGdDQUFnQyxDQUFDLFVBQVUsQ0FBQyxDQUFDLGFBQWEsRUFBRSxDQUFDO0lBQzdELE9BQU87UUFDSCxvQkFBb0IsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLG9CQUFvQixDQUFDO1FBQ2pGLGVBQWUsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLGVBQWUsQ0FBQztRQUN2RSxPQUFPLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUM7UUFDdkQsT0FBTyxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsT0FBTyxDQUFDO1FBQ3ZELE9BQU8sRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLE9BQU8sQ0FBQztRQUN2RCxVQUFVLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUM7UUFDN0QsU0FBUyxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsU0FBUyxDQUFDO1FBQzNELFFBQVEsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLFFBQVEsQ0FBQztLQUM1RCxDQUFDO0FBQ04sQ0FBQztBQUVELG9CQUFvQjtBQUNwQixTQUFTLHlDQUF5QyxDQUFDLFVBQWU7SUFDOUQsVUFBVSxHQUFHLFVBQVUsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDO0lBQ2xELElBQUksT0FBTyxVQUFVLEtBQUssUUFBUSxFQUFFO1FBQ2hDLE9BQU8sSUFBSSxTQUFTLENBQUMsd0JBQXdCLENBQUMsVUFBVSxDQUFDLENBQUM7S0FDN0Q7SUFDRCxNQUFNLEdBQUcsR0FBRyxJQUFJLFNBQVMsQ0FBQyxnQ0FBZ0MsRUFBMkIsQ0FBQztJQUN0RixHQUFHLENBQUMsaUJBQWlCLENBQUMsc0JBQXNCLEVBQUUsc0JBQXNCLEVBQUUsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsb0JBQW9CLENBQUMsQ0FBQyxDQUFDO0lBQy9JLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxpQkFBaUIsRUFBRSxpQkFBaUIsRUFBRSxVQUFVLENBQUMsZUFBZSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsZUFBZSxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ2pMLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxTQUFTLEVBQUUsU0FBUyxFQUFFLFVBQVUsQ0FBQyxPQUFPLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDakosR0FBRyxDQUFDLGlCQUFpQixDQUFDLFNBQVMsRUFBRSxTQUFTLEVBQUUsVUFBVSxDQUFDLE9BQU8sSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUNqSixHQUFHLENBQUMsaUJBQWlCLENBQUMsU0FBUyxFQUFFLFNBQVMsRUFBRSxVQUFVLENBQUMsT0FBTyxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ2pKLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxZQUFZLEVBQUUsWUFBWSxFQUFFLFVBQVUsQ0FBQyxVQUFVLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDN0osR0FBRyxDQUFDLGlCQUFpQixDQUFDLFdBQVcsRUFBRSxXQUFXLEVBQUUsVUFBVSxDQUFDLFNBQVMsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUN6SixHQUFHLENBQUMsaUJBQWlCLENBQUMsVUFBVSxFQUFFLFVBQVUsRUFBRSxVQUFVLENBQUMsUUFBUSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsUUFBUSxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ3JKLEdBQUcsQ0FBQyxnQ0FBZ0MsQ0FBQyxVQUFVLENBQUMsQ0FBQztJQUNqRCxPQUFPLEdBQUcsQ0FBQztBQUNmLENBQUM7QUFFRDs7Ozs7Ozs7Ozs7OztHQWFHO0FBQ0gsTUFBYSxrQkFBbUIsU0FBUSxHQUFHLENBQUMsV0FBVztJQWlHbkQ7Ozs7OztPQU1HO0lBQ0gsWUFBWSxLQUFvQixFQUFFLEVBQVUsRUFBRSxLQUE4QjtRQUN4RSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRSxFQUFFLElBQUksRUFBRSxrQkFBa0IsQ0FBQyxzQkFBc0IsRUFBRSxVQUFVLEVBQUUsS0FBSyxFQUFFLENBQUMsQ0FBQzs7Ozs7OzsrQ0F6R3BGLGtCQUFrQjs7OztRQTBHdkIsR0FBRyxDQUFDLGVBQWUsQ0FBQyxLQUFLLEVBQUUsc0JBQXNCLEVBQUUsSUFBSSxDQUFDLENBQUM7UUFDekQsSUFBSSxDQUFDLHVCQUF1QixHQUFHLEdBQUcsQ0FBQyxLQUFLLENBQUMsUUFBUSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMscUJBQXFCLENBQUMsQ0FBQyxDQUFDO1FBRXRGLElBQUksQ0FBQyxvQkFBb0IsR0FBRyxLQUFLLENBQUMsb0JBQW9CLENBQUM7UUFDdkQsSUFBSSxDQUFDLGVBQWUsR0FBRyxLQUFLLENBQUMsZUFBZSxDQUFDO1FBQzdDLElBQUksQ0FBQyxPQUFPLEdBQUcsS0FBSyxDQUFDLE9BQU8sQ0FBQztRQUM3QixJQUFJLENBQUMsT0FBTyxHQUFHLEtBQUssQ0FBQyxPQUFPLENBQUM7UUFDN0IsSUFBSSxDQUFDLE9BQU8sR0FBRyxLQUFLLENBQUMsT0FBTyxDQUFDO1FBQzdCLElBQUksQ0FBQyxVQUFVLEdBQUcsS0FBSyxDQUFDLFVBQVUsQ0FBQztRQUNuQyxJQUFJLENBQUMsU0FBUyxHQUFHLEtBQUssQ0FBQyxTQUFTLENBQUM7UUFDakMsSUFBSSxDQUFDLFFBQVEsR0FBRyxLQUFLLENBQUMsUUFBUSxDQUFDO0tBQ2xDO0lBL0dEOzs7Ozs7T0FNRztJQUNJLE1BQU0sQ0FBQyxtQkFBbUIsQ0FBQyxLQUFvQixFQUFFLEVBQVUsRUFBRSxrQkFBdUIsRUFBRSxPQUE0QztRQUNySSxrQkFBa0IsR0FBRyxrQkFBa0IsSUFBSSxFQUFFLENBQUM7UUFDOUMsTUFBTSxrQkFBa0IsR0FBRyxPQUFPLENBQUMsTUFBTSxDQUFDLFVBQVUsQ0FBQyxrQkFBa0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztRQUNwRixNQUFNLFdBQVcsR0FBRyx5Q0FBeUMsQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDO1FBQ2xGLE1BQU0sR0FBRyxHQUFHLElBQUksa0JBQWtCLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRSxXQUFXLENBQUMsS0FBSyxDQUFDLENBQUM7UUFDakUsS0FBSyxNQUFNLENBQUMsT0FBTyxFQUFFLE9BQU8sQ0FBQyxJQUFJLE1BQU0sQ0FBQyxPQUFPLENBQUMsV0FBVyxDQUFDLGVBQWUsQ0FBQyxFQUFHO1lBQzNFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxPQUFPLEVBQUUsT0FBTyxDQUFDLENBQUM7U0FDN0M7UUFDRCxPQUFPLENBQUMsTUFBTSxDQUFDLGdCQUFnQixDQUFDLEdBQUcsRUFBRSxrQkFBa0IsRUFBRSxFQUFFLENBQUMsQ0FBQztRQUM3RCxPQUFPLEdBQUcsQ0FBQztLQUNkO0lBZ0dEOzs7OztPQUtHO0lBQ0ksT0FBTyxDQUFDLFNBQTRCOzs7Ozs7Ozs7O1FBQ3ZDLFNBQVMsQ0FBQyxZQUFZLENBQUMsNkJBQTZCLEVBQUUsa0JBQWtCLENBQUMsc0JBQXNCLENBQUMsQ0FBQztRQUNqRyxTQUFTLENBQUMsWUFBWSxDQUFDLDhCQUE4QixFQUFFLElBQUksQ0FBQyxhQUFhLENBQUMsQ0FBQztLQUM5RTtJQUVELElBQWMsYUFBYTtRQUN2QixPQUFPO1lBQ0gsb0JBQW9CLEVBQUUsSUFBSSxDQUFDLG9CQUFvQjtZQUMvQyxlQUFlLEVBQUUsSUFBSSxDQUFDLGVBQWU7WUFDckMsT0FBTyxFQUFFLElBQUksQ0FBQyxPQUFPO1lBQ3JCLE9BQU8sRUFBRSxJQUFJLENBQUMsT0FBTztZQUNyQixPQUFPLEVBQUUsSUFBSSxDQUFDLE9BQU87WUFDckIsVUFBVSxFQUFFLElBQUksQ0FBQyxVQUFVO1lBQzNCLFNBQVMsRUFBRSxJQUFJLENBQUMsU0FBUztZQUN6QixRQUFRLEVBQUUsSUFBSSxDQUFDLFFBQVE7U0FDMUIsQ0FBQztLQUNMO0lBRVMsZ0JBQWdCLENBQUMsS0FBMkI7UUFDbEQsT0FBTyx1Q0FBdUMsQ0FBQyxLQUFLLENBQUMsQ0FBQztLQUN6RDs7QUFqSkwsZ0RBa0pDOzs7QUFqSkc7O0dBRUc7QUFDb0IseUNBQXNCLEdBQUcsbUNBQW1DLENBQUM7QUFvTXhGOzs7Ozs7R0FNRztBQUNILFNBQVMseUJBQXlCLENBQUMsVUFBZTtJQUM5QyxJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sR0FBRyxDQUFDLGtCQUFrQixDQUFDO0tBQUU7SUFDbkUsTUFBTSxNQUFNLEdBQUcsSUFBSSxHQUFHLENBQUMsaUJBQWlCLEVBQUUsQ0FBQztJQUMzQyxJQUFJLE9BQU8sVUFBVSxLQUFLLFFBQVEsRUFBRTtRQUNoQyxNQUFNLENBQUMsT0FBTyxDQUFDLElBQUksR0FBRyxDQUFDLGdCQUFnQixDQUFDLG9DQUFvQyxHQUFHLElBQUksQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxDQUFDO0tBQy9HO0lBQ0QsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsc0JBQXNCLEVBQUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLENBQUMsVUFBVSxDQUFDLG9CQUFvQixDQUFDLENBQUMsQ0FBQztJQUN0SCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxzQkFBc0IsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLG9CQUFvQixDQUFDLENBQUMsQ0FBQztJQUNuSCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxxQkFBcUIsRUFBRSxnREFBZ0QsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDLENBQUM7SUFDL0ksTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsMEJBQTBCLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyx3QkFBd0IsQ0FBQyxDQUFDLENBQUM7SUFDM0gsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsU0FBUyxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQztJQUN6RixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxXQUFXLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQUMsQ0FBQyxDQUFDO0lBQzdGLE9BQU8sTUFBTSxDQUFDLElBQUksQ0FBQyx3REFBd0QsQ0FBQyxDQUFDO0FBQ2pGLENBQUM7QUFFRDs7Ozs7O0dBTUc7QUFDSCxvQkFBb0I7QUFDcEIsU0FBUyxnQ0FBZ0MsQ0FBQyxVQUFlO0lBQ3JELElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxVQUFVLENBQUM7S0FBRTtJQUN2RCx5QkFBeUIsQ0FBQyxVQUFVLENBQUMsQ0FBQyxhQUFhLEVBQUUsQ0FBQztJQUN0RCxPQUFPO1FBQ0gsb0JBQW9CLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxvQkFBb0IsQ0FBQztRQUNqRixtQkFBbUIsRUFBRSxzREFBc0QsQ0FBQyxVQUFVLENBQUMsbUJBQW1CLENBQUM7UUFDM0csd0JBQXdCLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyx3QkFBd0IsQ0FBQztRQUN6RixPQUFPLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUM7UUFDdkQsU0FBUyxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsU0FBUyxDQUFDO0tBQzlELENBQUM7QUFDTixDQUFDO0FBRUQsb0JBQW9CO0FBQ3BCLFNBQVMsa0NBQWtDLENBQUMsVUFBZTtJQUN2RCxVQUFVLEdBQUcsVUFBVSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUM7SUFDbEQsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsT0FBTyxJQUFJLFNBQVMsQ0FBQyx3QkFBd0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztLQUM3RDtJQUNELE1BQU0sR0FBRyxHQUFHLElBQUksU0FBUyxDQUFDLGdDQUFnQyxFQUFvQixDQUFDO0lBQy9FLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxzQkFBc0IsRUFBRSxzQkFBc0IsRUFBRSxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDLENBQUM7SUFDL0ksR0FBRyxDQUFDLGlCQUFpQixDQUFDLHFCQUFxQixFQUFFLHFCQUFxQixFQUFFLFVBQVUsQ0FBQyxtQkFBbUIsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLHdEQUF3RCxDQUFDLFVBQVUsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUNuTixHQUFHLENBQUMsaUJBQWlCLENBQUMsMEJBQTBCLEVBQUUsMEJBQTBCLEVBQUUsVUFBVSxDQUFDLHdCQUF3QixJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsd0JBQXdCLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDck4sR0FBRyxDQUFDLGlCQUFpQixDQUFDLFNBQVMsRUFBRSxTQUFTLEVBQUUsVUFBVSxDQUFDLE9BQU8sSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUNqSixHQUFHLENBQUMsaUJBQWlCLENBQUMsV0FBVyxFQUFFLFdBQVcsRUFBRSxVQUFVLENBQUMsU0FBUyxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsU0FBUyxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ3pKLEdBQUcsQ0FBQyxnQ0FBZ0MsQ0FBQyxVQUFVLENBQUMsQ0FBQztJQUNqRCxPQUFPLEdBQUcsQ0FBQztBQUNmLENBQUM7QUFFRDs7Ozs7Ozs7Ozs7Ozs7O0dBZUc7QUFDSCxNQUFhLFdBQVksU0FBUSxHQUFHLENBQUMsV0FBVztJQWtFNUM7Ozs7OztPQU1HO0lBQ0gsWUFBWSxLQUFvQixFQUFFLEVBQVUsRUFBRSxLQUF1QjtRQUNqRSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRSxFQUFFLElBQUksRUFBRSxXQUFXLENBQUMsc0JBQXNCLEVBQUUsVUFBVSxFQUFFLEtBQUssRUFBRSxDQUFDLENBQUM7Ozs7Ozs7K0NBMUU3RSxXQUFXOzs7O1FBMkVoQixHQUFHLENBQUMsZUFBZSxDQUFDLEtBQUssRUFBRSxzQkFBc0IsRUFBRSxJQUFJLENBQUMsQ0FBQztRQUV6RCxJQUFJLENBQUMsb0JBQW9CLEdBQUcsS0FBSyxDQUFDLG9CQUFvQixDQUFDO1FBQ3ZELElBQUksQ0FBQyxtQkFBbUIsR0FBRyxLQUFLLENBQUMsbUJBQW1CLENBQUM7UUFDckQsSUFBSSxDQUFDLHdCQUF3QixHQUFHLEtBQUssQ0FBQyx3QkFBd0IsQ0FBQztRQUMvRCxJQUFJLENBQUMsT0FBTyxHQUFHLEtBQUssQ0FBQyxPQUFPLENBQUM7UUFDN0IsSUFBSSxDQUFDLFNBQVMsR0FBRyxLQUFLLENBQUMsU0FBUyxDQUFDO0tBQ3BDO0lBNUVEOzs7Ozs7T0FNRztJQUNJLE1BQU0sQ0FBQyxtQkFBbUIsQ0FBQyxLQUFvQixFQUFFLEVBQVUsRUFBRSxrQkFBdUIsRUFBRSxPQUE0QztRQUNySSxrQkFBa0IsR0FBRyxrQkFBa0IsSUFBSSxFQUFFLENBQUM7UUFDOUMsTUFBTSxrQkFBa0IsR0FBRyxPQUFPLENBQUMsTUFBTSxDQUFDLFVBQVUsQ0FBQyxrQkFBa0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztRQUNwRixNQUFNLFdBQVcsR0FBRyxrQ0FBa0MsQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDO1FBQzNFLE1BQU0sR0FBRyxHQUFHLElBQUksV0FBVyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUUsV0FBVyxDQUFDLEtBQUssQ0FBQyxDQUFDO1FBQzFELEtBQUssTUFBTSxDQUFDLE9BQU8sRUFBRSxPQUFPLENBQUMsSUFBSSxNQUFNLENBQUMsT0FBTyxDQUFDLFdBQVcsQ0FBQyxlQUFlLENBQUMsRUFBRztZQUMzRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsT0FBTyxFQUFFLE9BQU8sQ0FBQyxDQUFDO1NBQzdDO1FBQ0QsT0FBTyxDQUFDLE1BQU0sQ0FBQyxnQkFBZ0IsQ0FBQyxHQUFHLEVBQUUsa0JBQWtCLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFDN0QsT0FBTyxHQUFHLENBQUM7S0FDZDtJQTZERDs7Ozs7T0FLRztJQUNJLE9BQU8sQ0FBQyxTQUE0Qjs7Ozs7Ozs7OztRQUN2QyxTQUFTLENBQUMsWUFBWSxDQUFDLDZCQUE2QixFQUFFLFdBQVcsQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDO1FBQzFGLFNBQVMsQ0FBQyxZQUFZLENBQUMsOEJBQThCLEVBQUUsSUFBSSxDQUFDLGFBQWEsQ0FBQyxDQUFDO0tBQzlFO0lBRUQsSUFBYyxhQUFhO1FBQ3ZCLE9BQU87WUFDSCxvQkFBb0IsRUFBRSxJQUFJLENBQUMsb0JBQW9CO1lBQy9DLG1CQUFtQixFQUFFLElBQUksQ0FBQyxtQkFBbUI7WUFDN0Msd0JBQXdCLEVBQUUsSUFBSSxDQUFDLHdCQUF3QjtZQUN2RCxPQUFPLEVBQUUsSUFBSSxDQUFDLE9BQU87WUFDckIsU0FBUyxFQUFFLElBQUksQ0FBQyxTQUFTO1NBQzVCLENBQUM7S0FDTDtJQUVTLGdCQUFnQixDQUFDLEtBQTJCO1FBQ2xELE9BQU8sZ0NBQWdDLENBQUMsS0FBSyxDQUFDLENBQUM7S0FDbEQ7O0FBM0dMLGtDQTRHQzs7O0FBM0dHOztHQUVHO0FBQ29CLGtDQUFzQixHQUFHLDRCQUE0QixDQUFDO0FBK0hqRjs7Ozs7O0dBTUc7QUFDSCxTQUFTLGdEQUFnRCxDQUFDLFVBQWU7SUFDckUsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQztLQUFFO0lBQ25FLE1BQU0sTUFBTSxHQUFHLElBQUksR0FBRyxDQUFDLGlCQUFpQixFQUFFLENBQUM7SUFDM0MsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsTUFBTSxDQUFDLE9BQU8sQ0FBQyxJQUFJLEdBQUcsQ0FBQyxnQkFBZ0IsQ0FBQyxvQ0FBb0MsR0FBRyxJQUFJLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUMsQ0FBQztLQUMvRztJQUNELE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGdCQUFnQixFQUFFLEdBQUcsQ0FBQyxlQUFlLENBQUMsQ0FBQyxVQUFVLENBQUMsY0FBYyxDQUFDLENBQUMsQ0FBQztJQUN4RyxPQUFPLE1BQU0sQ0FBQyxJQUFJLENBQUMsbUVBQW1FLENBQUMsQ0FBQztBQUM1RixDQUFDO0FBRUQ7Ozs7OztHQU1HO0FBQ0gsb0JBQW9CO0FBQ3BCLFNBQVMsc0RBQXNELENBQUMsVUFBZTtJQUMzRSxJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sVUFBVSxDQUFDO0tBQUU7SUFDdkQsZ0RBQWdELENBQUMsVUFBVSxDQUFDLENBQUMsYUFBYSxFQUFFLENBQUM7SUFDN0UsT0FBTztRQUNILGNBQWMsRUFBRSxHQUFHLENBQUMsdUJBQXVCLENBQUMsVUFBVSxDQUFDLGNBQWMsQ0FBQztLQUN6RSxDQUFDO0FBQ04sQ0FBQztBQUVELG9CQUFvQjtBQUNwQixTQUFTLHdEQUF3RCxDQUFDLFVBQWU7SUFDN0UsSUFBSSxHQUFHLENBQUMsa0JBQWtCLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFDcEMsT0FBTyxJQUFJLFNBQVMsQ0FBQyx3QkFBd0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztLQUM3RDtJQUNELFVBQVUsR0FBRyxVQUFVLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQztJQUNsRCxJQUFJLE9BQU8sVUFBVSxLQUFLLFFBQVEsRUFBRTtRQUNoQyxPQUFPLElBQUksU0FBUyxDQUFDLHdCQUF3QixDQUFDLFVBQVUsQ0FBQyxDQUFDO0tBQzdEO0lBQ0QsTUFBTSxHQUFHLEdBQUcsSUFBSSxTQUFTLENBQUMsZ0NBQWdDLEVBQTJDLENBQUM7SUFDdEcsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGdCQUFnQixFQUFFLGdCQUFnQixFQUFFLFVBQVUsQ0FBQyxjQUFjLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxjQUFjLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDOUssR0FBRyxDQUFDLGdDQUFnQyxDQUFDLFVBQVUsQ0FBQyxDQUFDO0lBQ2pELE9BQU8sR0FBRyxDQUFDO0FBQ2YsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbIi8vIENvcHlyaWdodCAyMDEyLTIwMjMgQW1hem9uLmNvbSwgSW5jLiBvciBpdHMgYWZmaWxpYXRlcy4gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cbi8vIEdlbmVyYXRlZCBmcm9tIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gUmVzb3VyY2UgU3BlY2lmaWNhdGlvblxuLy8gU2VlOiBkb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvY2ZuLXJlc291cmNlLXNwZWNpZmljYXRpb24uaHRtbFxuLy8gQGNmbjJ0czptZXRhQCB7XCJnZW5lcmF0ZWRcIjpcIjIwMjMtMDEtMzFUMTc6NTI6MDcuMDk2WlwiLFwiZmluZ2VycHJpbnRcIjpcInM4TFJjVWViU05NZWs1eW4yMHd0YndZTTU0MEpqK0tORTNCRXN5QjBzSk09XCJ9XG5cbi8qIGVzbGludC1kaXNhYmxlIG1heC1sZW4gKi8gLy8gVGhpcyBpcyBnZW5lcmF0ZWQgY29kZSAtIGxpbmUgbGVuZ3RocyBhcmUgZGlmZmljdWx0IHRvIGNvbnRyb2xcblxuaW1wb3J0ICogYXMgY2RrIGZyb20gJy4uLy4uL2NvcmUnO1xuaW1wb3J0ICogYXMgY2ZuX3BhcnNlIGZyb20gJy4uLy4uL2NvcmUvbGliL2hlbHBlcnMtaW50ZXJuYWwnO1xuXG4vKipcbiAqIFByb3BlcnRpZXMgZm9yIGRlZmluaW5nIGEgYENmbkF1dG9TY2FsaW5nR3JvdXBgXG4gKlxuICogQHN0cnVjdFxuICogQHN0YWJpbGl0eSBleHRlcm5hbFxuICpcbiAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXMtZ3JvdXAuaHRtbFxuICovXG5leHBvcnQgaW50ZXJmYWNlIENmbkF1dG9TY2FsaW5nR3JvdXBQcm9wcyB7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgbWF4aW11bSBzaXplIG9mIHRoZSBncm91cC5cbiAgICAgKlxuICAgICAqID4gV2l0aCBhIG1peGVkIGluc3RhbmNlcyBwb2xpY3kgdGhhdCB1c2VzIGluc3RhbmNlIHdlaWdodGluZywgQW1hem9uIEVDMiBBdXRvIFNjYWxpbmcgbWF5IG5lZWQgdG8gZ28gYWJvdmUgYE1heFNpemVgIHRvIG1lZXQgeW91ciBjYXBhY2l0eSByZXF1aXJlbWVudHMuIEluIHRoaXMgZXZlbnQsIEFtYXpvbiBFQzIgQXV0byBTY2FsaW5nIHdpbGwgbmV2ZXIgZ28gYWJvdmUgYE1heFNpemVgIGJ5IG1vcmUgdGhhbiB5b3VyIGxhcmdlc3QgaW5zdGFuY2Ugd2VpZ2h0ICh3ZWlnaHRzIHRoYXQgZGVmaW5lIGhvdyBtYW55IHVuaXRzIGVhY2ggaW5zdGFuY2UgY29udHJpYnV0ZXMgdG8gdGhlIGRlc2lyZWQgY2FwYWNpdHkgb2YgdGhlIGdyb3VwKS5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXMtZ3JvdXAuaHRtbCNjZm4tYXMtZ3JvdXAtbWF4c2l6ZVxuICAgICAqL1xuICAgIHJlYWRvbmx5IG1heFNpemU6IHN0cmluZztcblxuICAgIC8qKlxuICAgICAqIFRoZSBtaW5pbXVtIHNpemUgb2YgdGhlIGdyb3VwLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hcy1ncm91cC5odG1sI2Nmbi1hcy1ncm91cC1taW5zaXplXG4gICAgICovXG4gICAgcmVhZG9ubHkgbWluU2l6ZTogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogVGhlIG5hbWUgb2YgdGhlIEF1dG8gU2NhbGluZyBncm91cC4gVGhpcyBuYW1lIG11c3QgYmUgdW5pcXVlIHBlciBSZWdpb24gcGVyIGFjY291bnQuXG4gICAgICpcbiAgICAgKiBUaGUgbmFtZSBjYW4gY29udGFpbiBhbnkgQVNDSUkgY2hhcmFjdGVyIDMzIHRvIDEyNiBpbmNsdWRpbmcgbW9zdCBwdW5jdHVhdGlvbiBjaGFyYWN0ZXJzLCBkaWdpdHMsIGFuZCB1cHBlciBhbmQgbG93ZXJjYXNlZCBsZXR0ZXJzLlxuICAgICAqXG4gICAgICogPiBZb3UgY2Fubm90IHVzZSBhIGNvbG9uICg6KSBpbiB0aGUgbmFtZS5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXMtZ3JvdXAuaHRtbCNjZm4tYXV0b3NjYWxpbmctYXV0b3NjYWxpbmdncm91cC1hdXRvc2NhbGluZ2dyb3VwbmFtZVxuICAgICAqL1xuICAgIHJlYWRvbmx5IGF1dG9TY2FsaW5nR3JvdXBOYW1lPzogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogQSBsaXN0IG9mIEF2YWlsYWJpbGl0eSBab25lcyB3aGVyZSBpbnN0YW5jZXMgaW4gdGhlIEF1dG8gU2NhbGluZyBncm91cCBjYW4gYmUgY3JlYXRlZC4gVXNlZCBmb3IgbGF1bmNoaW5nIGludG8gdGhlIGRlZmF1bHQgVlBDIHN1Ym5ldCBpbiBlYWNoIEF2YWlsYWJpbGl0eSBab25lIHdoZW4gbm90IHVzaW5nIHRoZSBgVlBDWm9uZUlkZW50aWZpZXJgIHByb3BlcnR5LCBvciBmb3IgYXR0YWNoaW5nIGEgbmV0d29yayBpbnRlcmZhY2Ugd2hlbiBhbiBleGlzdGluZyBuZXR3b3JrIGludGVyZmFjZSBJRCBpcyBzcGVjaWZpZWQgaW4gYSBsYXVuY2ggdGVtcGxhdGUuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWFzLWdyb3VwLmh0bWwjY2ZuLWFzLWdyb3VwLWF2YWlsYWJpbGl0eXpvbmVzXG4gICAgICovXG4gICAgcmVhZG9ubHkgYXZhaWxhYmlsaXR5Wm9uZXM/OiBzdHJpbmdbXTtcblxuICAgIC8qKlxuICAgICAqIEluZGljYXRlcyB3aGV0aGVyIENhcGFjaXR5IFJlYmFsYW5jaW5nIGlzIGVuYWJsZWQuIE90aGVyd2lzZSwgQ2FwYWNpdHkgUmViYWxhbmNpbmcgaXMgZGlzYWJsZWQuIFdoZW4geW91IHR1cm4gb24gQ2FwYWNpdHkgUmViYWxhbmNpbmcsIEFtYXpvbiBFQzIgQXV0byBTY2FsaW5nIGF0dGVtcHRzIHRvIGxhdW5jaCBhIFNwb3QgSW5zdGFuY2Ugd2hlbmV2ZXIgQW1hem9uIEVDMiBub3RpZmllcyB0aGF0IGEgU3BvdCBJbnN0YW5jZSBpcyBhdCBhbiBlbGV2YXRlZCByaXNrIG9mIGludGVycnVwdGlvbi4gQWZ0ZXIgbGF1bmNoaW5nIGEgbmV3IGluc3RhbmNlLCBpdCB0aGVuIHRlcm1pbmF0ZXMgYW4gb2xkIGluc3RhbmNlLiBGb3IgbW9yZSBpbmZvcm1hdGlvbiwgc2VlIFtVc2UgQ2FwYWNpdHkgUmViYWxhbmNpbmcgdG8gaGFuZGxlIEFtYXpvbiBFQzIgU3BvdCBJbnRlcnJ1cHRpb25zXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vYXV0b3NjYWxpbmcvZWMyL3VzZXJndWlkZS9lYzItYXV0by1zY2FsaW5nLWNhcGFjaXR5LXJlYmFsYW5jaW5nLmh0bWwpIGluIHRoZSBpbiB0aGUgKkFtYXpvbiBFQzIgQXV0byBTY2FsaW5nIFVzZXIgR3VpZGUqIC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXMtZ3JvdXAuaHRtbCNjZm4tYXMtZ3JvdXAtY2FwYWNpdHlyZWJhbGFuY2VcbiAgICAgKi9cbiAgICByZWFkb25seSBjYXBhY2l0eVJlYmFsYW5jZT86IGJvb2xlYW4gfCBjZGsuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBSZXNlcnZlZC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXMtZ3JvdXAuaHRtbCNjZm4tYXMtZ3JvdXAtY29udGV4dFxuICAgICAqL1xuICAgIHJlYWRvbmx5IGNvbnRleHQ/OiBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiAqT25seSBuZWVkZWQgaWYgeW91IHVzZSBzaW1wbGUgc2NhbGluZyBwb2xpY2llcy4qXG4gICAgICpcbiAgICAgKiBUaGUgYW1vdW50IG9mIHRpbWUsIGluIHNlY29uZHMsIGJldHdlZW4gb25lIHNjYWxpbmcgYWN0aXZpdHkgZW5kaW5nIGFuZCBhbm90aGVyIG9uZSBzdGFydGluZyBkdWUgdG8gc2ltcGxlIHNjYWxpbmcgcG9saWNpZXMuIEZvciBtb3JlIGluZm9ybWF0aW9uLCBzZWUgW1NjYWxpbmcgY29vbGRvd25zIGZvciBBbWF6b24gRUMyIEF1dG8gU2NhbGluZ10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2F1dG9zY2FsaW5nL2VjMi91c2VyZ3VpZGUvQ29vbGRvd24uaHRtbCkgaW4gdGhlICpBbWF6b24gRUMyIEF1dG8gU2NhbGluZyBVc2VyIEd1aWRlKiAuXG4gICAgICpcbiAgICAgKiBEZWZhdWx0OiBgMzAwYCBzZWNvbmRzXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWFzLWdyb3VwLmh0bWwjY2ZuLWFzLWdyb3VwLWNvb2xkb3duXG4gICAgICovXG4gICAgcmVhZG9ubHkgY29vbGRvd24/OiBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgYW1vdW50IG9mIHRpbWUsIGluIHNlY29uZHMsIHVudGlsIGEgbmV3bHkgbGF1bmNoZWQgaW5zdGFuY2UgY2FuIGNvbnRyaWJ1dGUgdG8gdGhlIEFtYXpvbiBDbG91ZFdhdGNoIG1ldHJpY3MuIFRoaXMgZGVsYXkgbGV0cyBhbiBpbnN0YW5jZSBmaW5pc2ggaW5pdGlhbGl6aW5nIGJlZm9yZSBBbWF6b24gRUMyIEF1dG8gU2NhbGluZyBhZ2dyZWdhdGVzIGluc3RhbmNlIG1ldHJpY3MsIHJlc3VsdGluZyBpbiBtb3JlIHJlbGlhYmxlIHVzYWdlIGRhdGEuIFNldCB0aGlzIHZhbHVlIGVxdWFsIHRvIHRoZSBhbW91bnQgb2YgdGltZSB0aGF0IGl0IHRha2VzIGZvciByZXNvdXJjZSBjb25zdW1wdGlvbiB0byBiZWNvbWUgc3RhYmxlIGFmdGVyIGFuIGluc3RhbmNlIHJlYWNoZXMgdGhlIGBJblNlcnZpY2VgIHN0YXRlLiBGb3IgbW9yZSBpbmZvcm1hdGlvbiwgc2VlIFtTZXQgdGhlIGRlZmF1bHQgaW5zdGFuY2Ugd2FybXVwIGZvciBhbiBBdXRvIFNjYWxpbmcgZ3JvdXBdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9hdXRvc2NhbGluZy9lYzIvdXNlcmd1aWRlL2VjMi1hdXRvLXNjYWxpbmctZGVmYXVsdC1pbnN0YW5jZS13YXJtdXAuaHRtbCkgaW4gdGhlICpBbWF6b24gRUMyIEF1dG8gU2NhbGluZyBVc2VyIEd1aWRlKiAuXG4gICAgICpcbiAgICAgKiA+IFRvIG1hbmFnZSB5b3VyIHdhcm0tdXAgc2V0dGluZ3MgYXQgdGhlIGdyb3VwIGxldmVsLCB3ZSByZWNvbW1lbmQgdGhhdCB5b3Ugc2V0IHRoZSBkZWZhdWx0IGluc3RhbmNlIHdhcm11cCwgKmV2ZW4gaWYgaXRzIHZhbHVlIGlzIHNldCB0byAwIHNlY29uZHMqIC4gVGhpcyBhbHNvIG9wdGltaXplcyB0aGUgcGVyZm9ybWFuY2Ugb2Ygc2NhbGluZyBwb2xpY2llcyB0aGF0IHNjYWxlIGNvbnRpbnVvdXNseSwgc3VjaCBhcyB0YXJnZXQgdHJhY2tpbmcgYW5kIHN0ZXAgc2NhbGluZyBwb2xpY2llcy5cbiAgICAgKiA+XG4gICAgICogPiBJZiB5b3UgbmVlZCB0byByZW1vdmUgYSB2YWx1ZSB0aGF0IHlvdSBwcmV2aW91c2x5IHNldCwgaW5jbHVkZSB0aGUgcHJvcGVydHkgYnV0IHNwZWNpZnkgYC0xYCBmb3IgdGhlIHZhbHVlLiBIb3dldmVyLCB3ZSBzdHJvbmdseSByZWNvbW1lbmQga2VlcGluZyB0aGUgZGVmYXVsdCBpbnN0YW5jZSB3YXJtdXAgZW5hYmxlZCBieSBzcGVjaWZ5aW5nIGEgbWluaW11bSB2YWx1ZSBvZiBgMGAgLlxuICAgICAqXG4gICAgICogRGVmYXVsdDogTm9uZVxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hcy1ncm91cC5odG1sI2Nmbi1hcy1ncm91cC1kZWZhdWx0aW5zdGFuY2V3YXJtdXBcbiAgICAgKi9cbiAgICByZWFkb25seSBkZWZhdWx0SW5zdGFuY2VXYXJtdXA/OiBudW1iZXI7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgZGVzaXJlZCBjYXBhY2l0eSBpcyB0aGUgaW5pdGlhbCBjYXBhY2l0eSBvZiB0aGUgQXV0byBTY2FsaW5nIGdyb3VwIGF0IHRoZSB0aW1lIG9mIGl0cyBjcmVhdGlvbiBhbmQgdGhlIGNhcGFjaXR5IGl0IGF0dGVtcHRzIHRvIG1haW50YWluLiBJdCBjYW4gc2NhbGUgYmV5b25kIHRoaXMgY2FwYWNpdHkgaWYgeW91IGNvbmZpZ3VyZSBhdXRvbWF0aWMgc2NhbGluZy5cbiAgICAgKlxuICAgICAqIFRoZSBudW1iZXIgbXVzdCBiZSBncmVhdGVyIHRoYW4gb3IgZXF1YWwgdG8gdGhlIG1pbmltdW0gc2l6ZSBvZiB0aGUgZ3JvdXAgYW5kIGxlc3MgdGhhbiBvciBlcXVhbCB0byB0aGUgbWF4aW11bSBzaXplIG9mIHRoZSBncm91cC4gSWYgeW91IGRvIG5vdCBzcGVjaWZ5IGEgZGVzaXJlZCBjYXBhY2l0eSB3aGVuIGNyZWF0aW5nIHRoZSBzdGFjaywgdGhlIGRlZmF1bHQgaXMgdGhlIG1pbmltdW0gc2l6ZSBvZiB0aGUgZ3JvdXAuXG4gICAgICpcbiAgICAgKiBDbG91ZEZvcm1hdGlvbiBtYXJrcyB0aGUgQXV0byBTY2FsaW5nIGdyb3VwIGFzIHN1Y2Nlc3NmdWwgKGJ5IHNldHRpbmcgaXRzIHN0YXR1cyB0byBDUkVBVEVfQ09NUExFVEUpIHdoZW4gdGhlIGRlc2lyZWQgY2FwYWNpdHkgaXMgcmVhY2hlZC4gSG93ZXZlciwgaWYgYSBtYXhpbXVtIFNwb3QgcHJpY2UgaXMgc2V0IGluIHRoZSBsYXVuY2ggdGVtcGxhdGUgb3IgbGF1bmNoIGNvbmZpZ3VyYXRpb24gdGhhdCB5b3Ugc3BlY2lmaWVkLCB0aGVuIGRlc2lyZWQgY2FwYWNpdHkgaXMgbm90IHVzZWQgYXMgYSBjcml0ZXJpYSBmb3Igc3VjY2Vzcy4gV2hldGhlciB5b3VyIHJlcXVlc3QgaXMgZnVsZmlsbGVkIGRlcGVuZHMgb24gU3BvdCBJbnN0YW5jZSBjYXBhY2l0eSBhbmQgeW91ciBtYXhpbXVtIHByaWNlLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hcy1ncm91cC5odG1sI2Nmbi1hcy1ncm91cC1kZXNpcmVkY2FwYWNpdHlcbiAgICAgKi9cbiAgICByZWFkb25seSBkZXNpcmVkQ2FwYWNpdHk/OiBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgdW5pdCBvZiBtZWFzdXJlbWVudCBmb3IgdGhlIHZhbHVlIHNwZWNpZmllZCBmb3IgZGVzaXJlZCBjYXBhY2l0eS4gQW1hem9uIEVDMiBBdXRvIFNjYWxpbmcgc3VwcG9ydHMgYERlc2lyZWRDYXBhY2l0eVR5cGVgIGZvciBhdHRyaWJ1dGUtYmFzZWQgaW5zdGFuY2UgdHlwZSBzZWxlY3Rpb24gb25seS4gRm9yIG1vcmUgaW5mb3JtYXRpb24sIHNlZSBbQ3JlYXRpbmcgYW4gQXV0byBTY2FsaW5nIGdyb3VwIHVzaW5nIGF0dHJpYnV0ZS1iYXNlZCBpbnN0YW5jZSB0eXBlIHNlbGVjdGlvbl0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2F1dG9zY2FsaW5nL2VjMi91c2VyZ3VpZGUvY3JlYXRlLWFzZy1pbnN0YW5jZS10eXBlLXJlcXVpcmVtZW50cy5odG1sKSBpbiB0aGUgKkFtYXpvbiBFQzIgQXV0byBTY2FsaW5nIFVzZXIgR3VpZGUqIC5cbiAgICAgKlxuICAgICAqIEJ5IGRlZmF1bHQsIEFtYXpvbiBFQzIgQXV0byBTY2FsaW5nIHNwZWNpZmllcyBgdW5pdHNgICwgd2hpY2ggdHJhbnNsYXRlcyBpbnRvIG51bWJlciBvZiBpbnN0YW5jZXMuXG4gICAgICpcbiAgICAgKiBWYWxpZCB2YWx1ZXM6IGB1bml0c2AgfCBgdmNwdWAgfCBgbWVtb3J5LW1pYmBcbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXMtZ3JvdXAuaHRtbCNjZm4tYXMtZ3JvdXAtZGVzaXJlZGNhcGFjaXR5dHlwZVxuICAgICAqL1xuICAgIHJlYWRvbmx5IGRlc2lyZWRDYXBhY2l0eVR5cGU/OiBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgYW1vdW50IG9mIHRpbWUsIGluIHNlY29uZHMsIHRoYXQgQW1hem9uIEVDMiBBdXRvIFNjYWxpbmcgd2FpdHMgYmVmb3JlIGNoZWNraW5nIHRoZSBoZWFsdGggc3RhdHVzIG9mIGFuIEVDMiBpbnN0YW5jZSB0aGF0IGhhcyBjb21lIGludG8gc2VydmljZSBhbmQgbWFya2luZyBpdCB1bmhlYWx0aHkgZHVlIHRvIGEgZmFpbGVkIGhlYWx0aCBjaGVjay4gVGhpcyBpcyB1c2VmdWwgaWYgeW91ciBpbnN0YW5jZXMgZG8gbm90IGltbWVkaWF0ZWx5IHBhc3MgdGhlaXIgaGVhbHRoIGNoZWNrcyBhZnRlciB0aGV5IGVudGVyIHRoZSBgSW5TZXJ2aWNlYCBzdGF0ZS4gRm9yIG1vcmUgaW5mb3JtYXRpb24sIHNlZSBbU2V0IHRoZSBoZWFsdGggY2hlY2sgZ3JhY2UgcGVyaW9kIGZvciBhbiBBdXRvIFNjYWxpbmcgZ3JvdXBdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9hdXRvc2NhbGluZy9lYzIvdXNlcmd1aWRlL2hlYWx0aC1jaGVjay1ncmFjZS1wZXJpb2QuaHRtbCkgaW4gdGhlICpBbWF6b24gRUMyIEF1dG8gU2NhbGluZyBVc2VyIEd1aWRlKiAuXG4gICAgICpcbiAgICAgKiBEZWZhdWx0OiBgMGAgc2Vjb25kc1xuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hcy1ncm91cC5odG1sI2Nmbi1hcy1ncm91cC1oZWFsdGhjaGVja2dyYWNlcGVyaW9kXG4gICAgICovXG4gICAgcmVhZG9ubHkgaGVhbHRoQ2hlY2tHcmFjZVBlcmlvZD86IG51bWJlcjtcblxuICAgIC8qKlxuICAgICAqIERldGVybWluZXMgd2hldGhlciBhbnkgYWRkaXRpb25hbCBoZWFsdGggY2hlY2tzIGFyZSBwZXJmb3JtZWQgb24gdGhlIGluc3RhbmNlcyBpbiB0aGlzIGdyb3VwLiBBbWF6b24gRUMyIGhlYWx0aCBjaGVja3MgYXJlIGFsd2F5cyBvbi4gRm9yIG1vcmUgaW5mb3JtYXRpb24sIHNlZSBbSGVhbHRoIGNoZWNrcyBmb3IgQXV0byBTY2FsaW5nIGluc3RhbmNlc10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2F1dG9zY2FsaW5nL2VjMi91c2VyZ3VpZGUvaGVhbHRoY2hlY2suaHRtbCkgaW4gdGhlICpBbWF6b24gRUMyIEF1dG8gU2NhbGluZyBVc2VyIEd1aWRlKiAuXG4gICAgICpcbiAgICAgKiBUaGUgdmFsaWQgdmFsdWVzIGFyZSBgRUMyYCAoZGVmYXVsdCksIGBFTEJgICwgYW5kIGBWUENfTEFUVElDRWAgLiBUaGUgYFZQQ19MQVRUSUNFYCBoZWFsdGggY2hlY2sgdHlwZSBpcyByZXNlcnZlZCBmb3IgdXNlIHdpdGggVlBDIExhdHRpY2UsIHdoaWNoIGlzIGluIHByZXZpZXcgcmVsZWFzZSBhbmQgaXMgc3ViamVjdCB0byBjaGFuZ2UuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWFzLWdyb3VwLmh0bWwjY2ZuLWFzLWdyb3VwLWhlYWx0aGNoZWNrdHlwZVxuICAgICAqL1xuICAgIHJlYWRvbmx5IGhlYWx0aENoZWNrVHlwZT86IHN0cmluZztcblxuICAgIC8qKlxuICAgICAqIFRoZSBJRCBvZiB0aGUgaW5zdGFuY2UgdXNlZCB0byBiYXNlIHRoZSBsYXVuY2ggY29uZmlndXJhdGlvbiBvbi4gRm9yIG1vcmUgaW5mb3JtYXRpb24sIHNlZSBbQ3JlYXRlIGFuIEF1dG8gU2NhbGluZyBncm91cCB1c2luZyBhbiBFQzIgaW5zdGFuY2VdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9hdXRvc2NhbGluZy9lYzIvdXNlcmd1aWRlL2NyZWF0ZS1hc2ctZnJvbS1pbnN0YW5jZS5odG1sKSBpbiB0aGUgKkFtYXpvbiBFQzIgQXV0byBTY2FsaW5nIFVzZXIgR3VpZGUqIC5cbiAgICAgKlxuICAgICAqIElmIHlvdSBzcGVjaWZ5IGBMYXVuY2hUZW1wbGF0ZWAgLCBgTWl4ZWRJbnN0YW5jZXNQb2xpY3lgICwgb3IgYExhdW5jaENvbmZpZ3VyYXRpb25OYW1lYCAsIGRvbid0IHNwZWNpZnkgYEluc3RhbmNlSWRgIC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXMtZ3JvdXAuaHRtbCNjZm4tYXMtZ3JvdXAtaW5zdGFuY2VpZFxuICAgICAqL1xuICAgIHJlYWRvbmx5IGluc3RhbmNlSWQ/OiBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgbmFtZSBvZiB0aGUgbGF1bmNoIGNvbmZpZ3VyYXRpb24gdG8gdXNlIHRvIGxhdW5jaCBpbnN0YW5jZXMuXG4gICAgICpcbiAgICAgKiBSZXF1aXJlZCBvbmx5IGlmIHlvdSBkb24ndCBzcGVjaWZ5IGBMYXVuY2hUZW1wbGF0ZWAgLCBgTWl4ZWRJbnN0YW5jZXNQb2xpY3lgICwgb3IgYEluc3RhbmNlSWRgIC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXMtZ3JvdXAuaHRtbCNjZm4tYXMtZ3JvdXAtbGF1bmNoY29uZmlndXJhdGlvbm5hbWVcbiAgICAgKi9cbiAgICByZWFkb25seSBsYXVuY2hDb25maWd1cmF0aW9uTmFtZT86IHN0cmluZztcblxuICAgIC8qKlxuICAgICAqIEluZm9ybWF0aW9uIHVzZWQgdG8gc3BlY2lmeSB0aGUgbGF1bmNoIHRlbXBsYXRlIGFuZCB2ZXJzaW9uIHRvIHVzZSB0byBsYXVuY2ggaW5zdGFuY2VzLiBZb3UgY2FuIGFsdGVybmF0aXZlbHkgYXNzb2NpYXRlIGEgbGF1bmNoIHRlbXBsYXRlIHRvIHRoZSBBdXRvIFNjYWxpbmcgZ3JvdXAgYnkgc3BlY2lmeWluZyBhIGBNaXhlZEluc3RhbmNlc1BvbGljeWAgLiBGb3IgbW9yZSBpbmZvcm1hdGlvbiBhYm91dCBjcmVhdGluZyBsYXVuY2ggdGVtcGxhdGVzLCBzZWUgW0NyZWF0ZSBhIGxhdW5jaCB0ZW1wbGF0ZSBmb3IgYW4gQXV0byBTY2FsaW5nIGdyb3VwXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vYXV0b3NjYWxpbmcvZWMyL3VzZXJndWlkZS9jcmVhdGUtbGF1bmNoLXRlbXBsYXRlLmh0bWwpIGluIHRoZSAqQW1hem9uIEVDMiBBdXRvIFNjYWxpbmcgVXNlciBHdWlkZSogLlxuICAgICAqXG4gICAgICogSWYgeW91IG9taXQgdGhpcyBwcm9wZXJ0eSwgeW91IG11c3Qgc3BlY2lmeSBgTWl4ZWRJbnN0YW5jZXNQb2xpY3lgICwgYExhdW5jaENvbmZpZ3VyYXRpb25OYW1lYCAsIG9yIGBJbnN0YW5jZUlkYCAuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWFzLWdyb3VwLmh0bWwjY2ZuLWFzLWdyb3VwLWxhdW5jaHRlbXBsYXRlXG4gICAgICovXG4gICAgcmVhZG9ubHkgbGF1bmNoVGVtcGxhdGU/OiBDZm5BdXRvU2NhbGluZ0dyb3VwLkxhdW5jaFRlbXBsYXRlU3BlY2lmaWNhdGlvblByb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogT25lIG9yIG1vcmUgbGlmZWN5Y2xlIGhvb2tzIHRvIGFkZCB0byB0aGUgQXV0byBTY2FsaW5nIGdyb3VwIGJlZm9yZSBpbnN0YW5jZXMgYXJlIGxhdW5jaGVkLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hcy1ncm91cC5odG1sI2Nmbi1hdXRvc2NhbGluZy1hdXRvc2NhbGluZ2dyb3VwLWxpZmVjeWNsZWhvb2tzcGVjaWZpY2F0aW9ubGlzdFxuICAgICAqL1xuICAgIHJlYWRvbmx5IGxpZmVjeWNsZUhvb2tTcGVjaWZpY2F0aW9uTGlzdD86IEFycmF5PENmbkF1dG9TY2FsaW5nR3JvdXAuTGlmZWN5Y2xlSG9va1NwZWNpZmljYXRpb25Qcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZT4gfCBjZGsuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBBIGxpc3Qgb2YgQ2xhc3NpYyBMb2FkIEJhbGFuY2VycyBhc3NvY2lhdGVkIHdpdGggdGhpcyBBdXRvIFNjYWxpbmcgZ3JvdXAuIEZvciBBcHBsaWNhdGlvbiBMb2FkIEJhbGFuY2VycywgTmV0d29yayBMb2FkIEJhbGFuY2VycywgYW5kIEdhdGV3YXkgTG9hZCBCYWxhbmNlciwgc3BlY2lmeSB0aGUgYFRhcmdldEdyb3VwQVJOc2AgcHJvcGVydHkgaW5zdGVhZC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXMtZ3JvdXAuaHRtbCNjZm4tYXMtZ3JvdXAtbG9hZGJhbGFuY2VybmFtZXNcbiAgICAgKi9cbiAgICByZWFkb25seSBsb2FkQmFsYW5jZXJOYW1lcz86IHN0cmluZ1tdO1xuXG4gICAgLyoqXG4gICAgICogVGhlIG1heGltdW0gYW1vdW50IG9mIHRpbWUsIGluIHNlY29uZHMsIHRoYXQgYW4gaW5zdGFuY2UgY2FuIGJlIGluIHNlcnZpY2UuIFRoZSBkZWZhdWx0IGlzIG51bGwuIElmIHNwZWNpZmllZCwgdGhlIHZhbHVlIG11c3QgYmUgZWl0aGVyIDAgb3IgYSBudW1iZXIgZXF1YWwgdG8gb3IgZ3JlYXRlciB0aGFuIDg2LDQwMCBzZWNvbmRzICgxIGRheSkuIEZvciBtb3JlIGluZm9ybWF0aW9uLCBzZWUgW1JlcGxhY2luZyBBdXRvIFNjYWxpbmcgaW5zdGFuY2VzIGJhc2VkIG9uIG1heGltdW0gaW5zdGFuY2UgbGlmZXRpbWVdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9hdXRvc2NhbGluZy9lYzIvdXNlcmd1aWRlL2FzZy1tYXgtaW5zdGFuY2UtbGlmZXRpbWUuaHRtbCkgaW4gdGhlICpBbWF6b24gRUMyIEF1dG8gU2NhbGluZyBVc2VyIEd1aWRlKiAuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWFzLWdyb3VwLmh0bWwjY2ZuLWFzLWdyb3VwLW1heGluc3RhbmNlbGlmZXRpbWVcbiAgICAgKi9cbiAgICByZWFkb25seSBtYXhJbnN0YW5jZUxpZmV0aW1lPzogbnVtYmVyO1xuXG4gICAgLyoqXG4gICAgICogRW5hYmxlcyB0aGUgbW9uaXRvcmluZyBvZiBncm91cCBtZXRyaWNzIG9mIGFuIEF1dG8gU2NhbGluZyBncm91cC4gQnkgZGVmYXVsdCwgdGhlc2UgbWV0cmljcyBhcmUgZGlzYWJsZWQuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWFzLWdyb3VwLmh0bWwjY2ZuLWFzLWdyb3VwLW1ldHJpY3Njb2xsZWN0aW9uXG4gICAgICovXG4gICAgcmVhZG9ubHkgbWV0cmljc0NvbGxlY3Rpb24/OiBBcnJheTxDZm5BdXRvU2NhbGluZ0dyb3VwLk1ldHJpY3NDb2xsZWN0aW9uUHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGU+IHwgY2RrLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQW4gZW1iZWRkZWQgb2JqZWN0IHRoYXQgc3BlY2lmaWVzIGEgbWl4ZWQgaW5zdGFuY2VzIHBvbGljeS5cbiAgICAgKlxuICAgICAqIFRoZSBwb2xpY3kgaW5jbHVkZXMgcHJvcGVydGllcyB0aGF0IG5vdCBvbmx5IGRlZmluZSB0aGUgZGlzdHJpYnV0aW9uIG9mIE9uLURlbWFuZCBJbnN0YW5jZXMgYW5kIFNwb3QgSW5zdGFuY2VzLCB0aGUgbWF4aW11bSBwcmljZSB0byBwYXkgZm9yIFNwb3QgSW5zdGFuY2VzIChvcHRpb25hbCksIGFuZCBob3cgdGhlIEF1dG8gU2NhbGluZyBncm91cCBhbGxvY2F0ZXMgaW5zdGFuY2UgdHlwZXMgdG8gZnVsZmlsbCBPbi1EZW1hbmQgYW5kIFNwb3QgY2FwYWNpdGllcywgYnV0IGFsc28gdGhlIHByb3BlcnRpZXMgdGhhdCBzcGVjaWZ5IHRoZSBpbnN0YW5jZSBjb25maWd1cmF0aW9uIGluZm9ybWF0aW9u4oCUdGhlIGxhdW5jaCB0ZW1wbGF0ZSBhbmQgaW5zdGFuY2UgdHlwZXMuIFRoZSBwb2xpY3kgY2FuIGFsc28gaW5jbHVkZSBhIHdlaWdodCBmb3IgZWFjaCBpbnN0YW5jZSB0eXBlIGFuZCBkaWZmZXJlbnQgbGF1bmNoIHRlbXBsYXRlcyBmb3IgaW5kaXZpZHVhbCBpbnN0YW5jZSB0eXBlcy5cbiAgICAgKlxuICAgICAqIEZvciBtb3JlIGluZm9ybWF0aW9uLCBzZWUgW0F1dG8gU2NhbGluZyBncm91cHMgd2l0aCBtdWx0aXBsZSBpbnN0YW5jZSB0eXBlcyBhbmQgcHVyY2hhc2Ugb3B0aW9uc10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2F1dG9zY2FsaW5nL2VjMi91c2VyZ3VpZGUvZWMyLWF1dG8tc2NhbGluZy1taXhlZC1pbnN0YW5jZXMtZ3JvdXBzLmh0bWwpIGluIHRoZSAqQW1hem9uIEVDMiBBdXRvIFNjYWxpbmcgVXNlciBHdWlkZSogLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hcy1ncm91cC5odG1sI2Nmbi1hcy1ncm91cC1taXhlZGluc3RhbmNlc3BvbGljeVxuICAgICAqL1xuICAgIHJlYWRvbmx5IG1peGVkSW5zdGFuY2VzUG9saWN5PzogQ2ZuQXV0b1NjYWxpbmdHcm91cC5NaXhlZEluc3RhbmNlc1BvbGljeVByb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogSW5kaWNhdGVzIHdoZXRoZXIgbmV3bHkgbGF1bmNoZWQgaW5zdGFuY2VzIGFyZSBwcm90ZWN0ZWQgZnJvbSB0ZXJtaW5hdGlvbiBieSBBbWF6b24gRUMyIEF1dG8gU2NhbGluZyB3aGVuIHNjYWxpbmcgaW4uIEZvciBtb3JlIGluZm9ybWF0aW9uIGFib3V0IHByZXZlbnRpbmcgaW5zdGFuY2VzIGZyb20gdGVybWluYXRpbmcgb24gc2NhbGUgaW4sIHNlZSBbVXNpbmcgaW5zdGFuY2Ugc2NhbGUtaW4gcHJvdGVjdGlvbl0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2F1dG9zY2FsaW5nL2VjMi91c2VyZ3VpZGUvZWMyLWF1dG8tc2NhbGluZy1pbnN0YW5jZS1wcm90ZWN0aW9uLmh0bWwpIGluIHRoZSAqQW1hem9uIEVDMiBBdXRvIFNjYWxpbmcgVXNlciBHdWlkZSogLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hcy1ncm91cC5odG1sI2Nmbi1hcy1ncm91cC1uZXdpbnN0YW5jZXNwcm90ZWN0ZWRmcm9tc2NhbGVpblxuICAgICAqL1xuICAgIHJlYWRvbmx5IG5ld0luc3RhbmNlc1Byb3RlY3RlZEZyb21TY2FsZUluPzogYm9vbGVhbiB8IGNkay5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIENvbmZpZ3VyZXMgYW4gQXV0byBTY2FsaW5nIGdyb3VwIHRvIHNlbmQgbm90aWZpY2F0aW9ucyB3aGVuIHNwZWNpZmllZCBldmVudHMgdGFrZSBwbGFjZS5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXMtZ3JvdXAuaHRtbCNjZm4tYXMtZ3JvdXAtbm90aWZpY2F0aW9uY29uZmlndXJhdGlvbnNcbiAgICAgKi9cbiAgICByZWFkb25seSBub3RpZmljYXRpb25Db25maWd1cmF0aW9ucz86IEFycmF5PENmbkF1dG9TY2FsaW5nR3JvdXAuTm90aWZpY2F0aW9uQ29uZmlndXJhdGlvblByb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlPiB8IGNkay5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFRoZSBuYW1lIG9mIHRoZSBwbGFjZW1lbnQgZ3JvdXAgaW50byB3aGljaCB0byBsYXVuY2ggeW91ciBpbnN0YW5jZXMuIEZvciBtb3JlIGluZm9ybWF0aW9uLCBzZWUgW1BsYWNlbWVudCBncm91cHNdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NFQzIvbGF0ZXN0L1VzZXJHdWlkZS9wbGFjZW1lbnQtZ3JvdXBzLmh0bWwpIGluIHRoZSAqQW1hem9uIEVDMiBVc2VyIEd1aWRlIGZvciBMaW51eCBJbnN0YW5jZXMqIC5cbiAgICAgKlxuICAgICAqID4gQSAqY2x1c3RlciogcGxhY2VtZW50IGdyb3VwIGlzIGEgbG9naWNhbCBncm91cGluZyBvZiBpbnN0YW5jZXMgd2l0aGluIGEgc2luZ2xlIEF2YWlsYWJpbGl0eSBab25lLiBZb3UgY2Fubm90IHNwZWNpZnkgbXVsdGlwbGUgQXZhaWxhYmlsaXR5IFpvbmVzIGFuZCBhIGNsdXN0ZXIgcGxhY2VtZW50IGdyb3VwLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hcy1ncm91cC5odG1sI2Nmbi1hcy1ncm91cC1wbGFjZW1lbnRncm91cFxuICAgICAqL1xuICAgIHJlYWRvbmx5IHBsYWNlbWVudEdyb3VwPzogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogVGhlIEFtYXpvbiBSZXNvdXJjZSBOYW1lIChBUk4pIG9mIHRoZSBzZXJ2aWNlLWxpbmtlZCByb2xlIHRoYXQgdGhlIEF1dG8gU2NhbGluZyBncm91cCB1c2VzIHRvIGNhbGwgb3RoZXIgQVdTIHNlcnZpY2Ugb24geW91ciBiZWhhbGYuIEJ5IGRlZmF1bHQsIEFtYXpvbiBFQzIgQXV0byBTY2FsaW5nIHVzZXMgYSBzZXJ2aWNlLWxpbmtlZCByb2xlIG5hbWVkIGBBV1NTZXJ2aWNlUm9sZUZvckF1dG9TY2FsaW5nYCAsIHdoaWNoIGl0IGNyZWF0ZXMgaWYgaXQgZG9lcyBub3QgZXhpc3QuIEZvciBtb3JlIGluZm9ybWF0aW9uLCBzZWUgW1NlcnZpY2UtbGlua2VkIHJvbGVzXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vYXV0b3NjYWxpbmcvZWMyL3VzZXJndWlkZS9hdXRvc2NhbGluZy1zZXJ2aWNlLWxpbmtlZC1yb2xlLmh0bWwpIGluIHRoZSAqQW1hem9uIEVDMiBBdXRvIFNjYWxpbmcgVXNlciBHdWlkZSogLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hcy1ncm91cC5odG1sI2Nmbi1hdXRvc2NhbGluZy1hdXRvc2NhbGluZ2dyb3VwLXNlcnZpY2VsaW5rZWRyb2xlYXJuXG4gICAgICovXG4gICAgcmVhZG9ubHkgc2VydmljZUxpbmtlZFJvbGVBcm4/OiBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBPbmUgb3IgbW9yZSB0YWdzLiBZb3UgY2FuIHRhZyB5b3VyIEF1dG8gU2NhbGluZyBncm91cCBhbmQgcHJvcGFnYXRlIHRoZSB0YWdzIHRvIHRoZSBBbWF6b24gRUMyIGluc3RhbmNlcyBpdCBsYXVuY2hlcy4gVGFncyBhcmUgbm90IHByb3BhZ2F0ZWQgdG8gQW1hem9uIEVCUyB2b2x1bWVzLiBUbyBhZGQgdGFncyB0byBBbWF6b24gRUJTIHZvbHVtZXMsIHNwZWNpZnkgdGhlIHRhZ3MgaW4gYSBsYXVuY2ggdGVtcGxhdGUgYnV0IHVzZSBjYXV0aW9uLiBJZiB0aGUgbGF1bmNoIHRlbXBsYXRlIHNwZWNpZmllcyBhbiBpbnN0YW5jZSB0YWcgd2l0aCBhIGtleSB0aGF0IGlzIGFsc28gc3BlY2lmaWVkIGZvciB0aGUgQXV0byBTY2FsaW5nIGdyb3VwLCBBbWF6b24gRUMyIEF1dG8gU2NhbGluZyBvdmVycmlkZXMgdGhlIHZhbHVlIG9mIHRoYXQgaW5zdGFuY2UgdGFnIHdpdGggdGhlIHZhbHVlIHNwZWNpZmllZCBieSB0aGUgQXV0byBTY2FsaW5nIGdyb3VwLiBGb3IgbW9yZSBpbmZvcm1hdGlvbiwgc2VlIFtUYWcgQXV0byBTY2FsaW5nIGdyb3VwcyBhbmQgaW5zdGFuY2VzXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vYXV0b3NjYWxpbmcvZWMyL3VzZXJndWlkZS9lYzItYXV0by1zY2FsaW5nLXRhZ2dpbmcuaHRtbCkgaW4gdGhlICpBbWF6b24gRUMyIEF1dG8gU2NhbGluZyBVc2VyIEd1aWRlKiAuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWFzLWdyb3VwLmh0bWwjY2ZuLWFzLWdyb3VwLXRhZ3NcbiAgICAgKi9cbiAgICByZWFkb25seSB0YWdzPzogQ2ZuQXV0b1NjYWxpbmdHcm91cC5UYWdQcm9wZXJ0eVByb3BlcnR5W107XG5cbiAgICAvKipcbiAgICAgKiBUaGUgQW1hem9uIFJlc291cmNlIE5hbWVzIChBUk4pIG9mIHRoZSBFbGFzdGljIExvYWQgQmFsYW5jaW5nIHRhcmdldCBncm91cHMgdG8gYXNzb2NpYXRlIHdpdGggdGhlIEF1dG8gU2NhbGluZyBncm91cC4gSW5zdGFuY2VzIGFyZSByZWdpc3RlcmVkIGFzIHRhcmdldHMgd2l0aCB0aGUgdGFyZ2V0IGdyb3Vwcy4gVGhlIHRhcmdldCBncm91cHMgcmVjZWl2ZSBpbmNvbWluZyB0cmFmZmljIGFuZCByb3V0ZSByZXF1ZXN0cyB0byBvbmUgb3IgbW9yZSByZWdpc3RlcmVkIHRhcmdldHMuIEZvciBtb3JlIGluZm9ybWF0aW9uLCBzZWUgW1VzZSBFbGFzdGljIExvYWQgQmFsYW5jaW5nIHRvIGRpc3RyaWJ1dGUgdHJhZmZpYyBhY3Jvc3MgdGhlIGluc3RhbmNlcyBpbiB5b3VyIEF1dG8gU2NhbGluZyBncm91cF0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2F1dG9zY2FsaW5nL2VjMi91c2VyZ3VpZGUvYXV0b3NjYWxpbmctbG9hZC1iYWxhbmNlci5odG1sKSBpbiB0aGUgKkFtYXpvbiBFQzIgQXV0byBTY2FsaW5nIFVzZXIgR3VpZGUqIC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXMtZ3JvdXAuaHRtbCNjZm4tYXMtZ3JvdXAtdGFyZ2V0Z3JvdXBhcm5zXG4gICAgICovXG4gICAgcmVhZG9ubHkgdGFyZ2V0R3JvdXBBcm5zPzogc3RyaW5nW107XG5cbiAgICAvKipcbiAgICAgKiBBIHBvbGljeSBvciBhIGxpc3Qgb2YgcG9saWNpZXMgdGhhdCBhcmUgdXNlZCB0byBzZWxlY3QgdGhlIGluc3RhbmNlIHRvIHRlcm1pbmF0ZS4gVGhlc2UgcG9saWNpZXMgYXJlIGV4ZWN1dGVkIGluIHRoZSBvcmRlciB0aGF0IHlvdSBsaXN0IHRoZW0uIEZvciBtb3JlIGluZm9ybWF0aW9uLCBzZWUgW1dvcmsgd2l0aCBBbWF6b24gRUMyIEF1dG8gU2NhbGluZyB0ZXJtaW5hdGlvbiBwb2xpY2llc10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2F1dG9zY2FsaW5nL2VjMi91c2VyZ3VpZGUvZWMyLWF1dG8tc2NhbGluZy10ZXJtaW5hdGlvbi1wb2xpY2llcy5odG1sKSBpbiB0aGUgKkFtYXpvbiBFQzIgQXV0byBTY2FsaW5nIFVzZXIgR3VpZGUqIC5cbiAgICAgKlxuICAgICAqIFZhbGlkIHZhbHVlczogYERlZmF1bHRgIHwgYEFsbG9jYXRpb25TdHJhdGVneWAgfCBgQ2xvc2VzdFRvTmV4dEluc3RhbmNlSG91cmAgfCBgTmV3ZXN0SW5zdGFuY2VgIHwgYE9sZGVzdEluc3RhbmNlYCB8IGBPbGRlc3RMYXVuY2hDb25maWd1cmF0aW9uYCB8IGBPbGRlc3RMYXVuY2hUZW1wbGF0ZWAgfCBgYXJuOmF3czpsYW1iZGE6cmVnaW9uOmFjY291bnQtaWQ6ZnVuY3Rpb246bXktZnVuY3Rpb246bXktYWxpYXNgXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWFzLWdyb3VwLmh0bWwjY2ZuLWFzLWdyb3VwLXRlcm1wb2xpY3lcbiAgICAgKi9cbiAgICByZWFkb25seSB0ZXJtaW5hdGlvblBvbGljaWVzPzogc3RyaW5nW107XG5cbiAgICAvKipcbiAgICAgKiBBIGxpc3Qgb2Ygc3VibmV0IElEcyBmb3IgYSB2aXJ0dWFsIHByaXZhdGUgY2xvdWQgKFZQQykgd2hlcmUgaW5zdGFuY2VzIGluIHRoZSBBdXRvIFNjYWxpbmcgZ3JvdXAgY2FuIGJlIGNyZWF0ZWQuXG4gICAgICpcbiAgICAgKiBJZiB0aGlzIHJlc291cmNlIHNwZWNpZmllcyBwdWJsaWMgc3VibmV0cyBhbmQgaXMgYWxzbyBpbiBhIFZQQyB0aGF0IGlzIGRlZmluZWQgaW4gdGhlIHNhbWUgc3RhY2sgdGVtcGxhdGUsIHlvdSBtdXN0IHVzZSB0aGUgW0RlcGVuZHNPbiBhdHRyaWJ1dGVdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1hdHRyaWJ1dGUtZGVwZW5kc29uLmh0bWwpIHRvIGRlY2xhcmUgYSBkZXBlbmRlbmN5IG9uIHRoZSBbVlBDLWdhdGV3YXkgYXR0YWNobWVudF0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWVjMi12cGMtZ2F0ZXdheS1hdHRhY2htZW50Lmh0bWwpIC5cbiAgICAgKlxuICAgICAqID4gV2hlbiB5b3UgdXBkYXRlIGBWUENab25lSWRlbnRpZmllcmAgLCB0aGlzIHJldGFpbnMgdGhlIHNhbWUgQXV0byBTY2FsaW5nIGdyb3VwIGFuZCByZXBsYWNlcyBvbGQgaW5zdGFuY2VzIHdpdGggbmV3IG9uZXMsIGFjY29yZGluZyB0byB0aGUgc3BlY2lmaWVkIHN1Ym5ldHMuIFlvdSBjYW4gb3B0aW9uYWxseSBzcGVjaWZ5IGhvdyBDbG91ZEZvcm1hdGlvbiBoYW5kbGVzIHRoZXNlIHVwZGF0ZXMgYnkgdXNpbmcgYW4gW1VwZGF0ZVBvbGljeSBhdHRyaWJ1dGVdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1hdHRyaWJ1dGUtdXBkYXRlcG9saWN5Lmh0bWwpIC5cbiAgICAgKlxuICAgICAqIFJlcXVpcmVkIHRvIGxhdW5jaCBpbnN0YW5jZXMgaW50byBhIG5vbmRlZmF1bHQgVlBDLiBJZiB5b3Ugc3BlY2lmeSBgVlBDWm9uZUlkZW50aWZpZXJgIHdpdGggYEF2YWlsYWJpbGl0eVpvbmVzYCAsIHRoZSBzdWJuZXRzIHRoYXQgeW91IHNwZWNpZnkgZm9yIHRoaXMgcHJvcGVydHkgbXVzdCByZXNpZGUgaW4gdGhvc2UgQXZhaWxhYmlsaXR5IFpvbmVzLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hcy1ncm91cC5odG1sI2Nmbi1hcy1ncm91cC12cGN6b25laWRlbnRpZmllclxuICAgICAqL1xuICAgIHJlYWRvbmx5IHZwY1pvbmVJZGVudGlmaWVyPzogc3RyaW5nW107XG59XG5cbi8qKlxuICogRGV0ZXJtaW5lIHdoZXRoZXIgdGhlIGdpdmVuIHByb3BlcnRpZXMgbWF0Y2ggdGhvc2Ugb2YgYSBgQ2ZuQXV0b1NjYWxpbmdHcm91cFByb3BzYFxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBDZm5BdXRvU2NhbGluZ0dyb3VwUHJvcHNgXG4gKlxuICogQHJldHVybnMgdGhlIHJlc3VsdCBvZiB0aGUgdmFsaWRhdGlvbi5cbiAqL1xuZnVuY3Rpb24gQ2ZuQXV0b1NjYWxpbmdHcm91cFByb3BzVmFsaWRhdG9yKHByb3BlcnRpZXM6IGFueSk6IGNkay5WYWxpZGF0aW9uUmVzdWx0IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBjZGsuVkFMSURBVElPTl9TVUNDRVNTOyB9XG4gICAgY29uc3QgZXJyb3JzID0gbmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0cygpO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgZXJyb3JzLmNvbGxlY3QobmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0KCdFeHBlY3RlZCBhbiBvYmplY3QsIGJ1dCByZWNlaXZlZDogJyArIEpTT04uc3RyaW5naWZ5KHByb3BlcnRpZXMpKSk7XG4gICAgfVxuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignYXV0b1NjYWxpbmdHcm91cE5hbWUnLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuYXV0b1NjYWxpbmdHcm91cE5hbWUpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2F2YWlsYWJpbGl0eVpvbmVzJywgY2RrLmxpc3RWYWxpZGF0b3IoY2RrLnZhbGlkYXRlU3RyaW5nKSkocHJvcGVydGllcy5hdmFpbGFiaWxpdHlab25lcykpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignY2FwYWNpdHlSZWJhbGFuY2UnLCBjZGsudmFsaWRhdGVCb29sZWFuKShwcm9wZXJ0aWVzLmNhcGFjaXR5UmViYWxhbmNlKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdjb250ZXh0JywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmNvbnRleHQpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2Nvb2xkb3duJywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmNvb2xkb3duKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdkZWZhdWx0SW5zdGFuY2VXYXJtdXAnLCBjZGsudmFsaWRhdGVOdW1iZXIpKHByb3BlcnRpZXMuZGVmYXVsdEluc3RhbmNlV2FybXVwKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdkZXNpcmVkQ2FwYWNpdHknLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuZGVzaXJlZENhcGFjaXR5KSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdkZXNpcmVkQ2FwYWNpdHlUeXBlJywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmRlc2lyZWRDYXBhY2l0eVR5cGUpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2hlYWx0aENoZWNrR3JhY2VQZXJpb2QnLCBjZGsudmFsaWRhdGVOdW1iZXIpKHByb3BlcnRpZXMuaGVhbHRoQ2hlY2tHcmFjZVBlcmlvZCkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignaGVhbHRoQ2hlY2tUeXBlJywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmhlYWx0aENoZWNrVHlwZSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignaW5zdGFuY2VJZCcsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5pbnN0YW5jZUlkKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdsYXVuY2hDb25maWd1cmF0aW9uTmFtZScsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5sYXVuY2hDb25maWd1cmF0aW9uTmFtZSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignbGF1bmNoVGVtcGxhdGUnLCBDZm5BdXRvU2NhbGluZ0dyb3VwX0xhdW5jaFRlbXBsYXRlU3BlY2lmaWNhdGlvblByb3BlcnR5VmFsaWRhdG9yKShwcm9wZXJ0aWVzLmxhdW5jaFRlbXBsYXRlKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdsaWZlY3ljbGVIb29rU3BlY2lmaWNhdGlvbkxpc3QnLCBjZGsubGlzdFZhbGlkYXRvcihDZm5BdXRvU2NhbGluZ0dyb3VwX0xpZmVjeWNsZUhvb2tTcGVjaWZpY2F0aW9uUHJvcGVydHlWYWxpZGF0b3IpKShwcm9wZXJ0aWVzLmxpZmVjeWNsZUhvb2tTcGVjaWZpY2F0aW9uTGlzdCkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignbG9hZEJhbGFuY2VyTmFtZXMnLCBjZGsubGlzdFZhbGlkYXRvcihjZGsudmFsaWRhdGVTdHJpbmcpKShwcm9wZXJ0aWVzLmxvYWRCYWxhbmNlck5hbWVzKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdtYXhJbnN0YW5jZUxpZmV0aW1lJywgY2RrLnZhbGlkYXRlTnVtYmVyKShwcm9wZXJ0aWVzLm1heEluc3RhbmNlTGlmZXRpbWUpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ21heFNpemUnLCBjZGsucmVxdWlyZWRWYWxpZGF0b3IpKHByb3BlcnRpZXMubWF4U2l6ZSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignbWF4U2l6ZScsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5tYXhTaXplKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdtZXRyaWNzQ29sbGVjdGlvbicsIGNkay5saXN0VmFsaWRhdG9yKENmbkF1dG9TY2FsaW5nR3JvdXBfTWV0cmljc0NvbGxlY3Rpb25Qcm9wZXJ0eVZhbGlkYXRvcikpKHByb3BlcnRpZXMubWV0cmljc0NvbGxlY3Rpb24pKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ21pblNpemUnLCBjZGsucmVxdWlyZWRWYWxpZGF0b3IpKHByb3BlcnRpZXMubWluU2l6ZSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignbWluU2l6ZScsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5taW5TaXplKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdtaXhlZEluc3RhbmNlc1BvbGljeScsIENmbkF1dG9TY2FsaW5nR3JvdXBfTWl4ZWRJbnN0YW5jZXNQb2xpY3lQcm9wZXJ0eVZhbGlkYXRvcikocHJvcGVydGllcy5taXhlZEluc3RhbmNlc1BvbGljeSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignbmV3SW5zdGFuY2VzUHJvdGVjdGVkRnJvbVNjYWxlSW4nLCBjZGsudmFsaWRhdGVCb29sZWFuKShwcm9wZXJ0aWVzLm5ld0luc3RhbmNlc1Byb3RlY3RlZEZyb21TY2FsZUluKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdub3RpZmljYXRpb25Db25maWd1cmF0aW9ucycsIGNkay5saXN0VmFsaWRhdG9yKENmbkF1dG9TY2FsaW5nR3JvdXBfTm90aWZpY2F0aW9uQ29uZmlndXJhdGlvblByb3BlcnR5VmFsaWRhdG9yKSkocHJvcGVydGllcy5ub3RpZmljYXRpb25Db25maWd1cmF0aW9ucykpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigncGxhY2VtZW50R3JvdXAnLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMucGxhY2VtZW50R3JvdXApKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3NlcnZpY2VMaW5rZWRSb2xlQXJuJywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLnNlcnZpY2VMaW5rZWRSb2xlQXJuKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCd0YWdzJywgY2RrLmxpc3RWYWxpZGF0b3IoQ2ZuQXV0b1NjYWxpbmdHcm91cF9UYWdQcm9wZXJ0eVByb3BlcnR5VmFsaWRhdG9yKSkocHJvcGVydGllcy50YWdzKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCd0YXJnZXRHcm91cEFybnMnLCBjZGsubGlzdFZhbGlkYXRvcihjZGsudmFsaWRhdGVTdHJpbmcpKShwcm9wZXJ0aWVzLnRhcmdldEdyb3VwQXJucykpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigndGVybWluYXRpb25Qb2xpY2llcycsIGNkay5saXN0VmFsaWRhdG9yKGNkay52YWxpZGF0ZVN0cmluZykpKHByb3BlcnRpZXMudGVybWluYXRpb25Qb2xpY2llcykpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigndnBjWm9uZUlkZW50aWZpZXInLCBjZGsubGlzdFZhbGlkYXRvcihjZGsudmFsaWRhdGVTdHJpbmcpKShwcm9wZXJ0aWVzLnZwY1pvbmVJZGVudGlmaWVyKSk7XG4gICAgcmV0dXJuIGVycm9ycy53cmFwKCdzdXBwbGllZCBwcm9wZXJ0aWVzIG5vdCBjb3JyZWN0IGZvciBcIkNmbkF1dG9TY2FsaW5nR3JvdXBQcm9wc1wiJyk7XG59XG5cbi8qKlxuICogUmVuZGVycyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6QXV0b1NjYWxpbmc6OkF1dG9TY2FsaW5nR3JvdXBgIHJlc291cmNlXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYENmbkF1dG9TY2FsaW5nR3JvdXBQcm9wc2BcbiAqXG4gKiBAcmV0dXJucyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6QXV0b1NjYWxpbmc6OkF1dG9TY2FsaW5nR3JvdXBgIHJlc291cmNlLlxuICovXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gY2ZuQXV0b1NjYWxpbmdHcm91cFByb3BzVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBhbnkge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIHByb3BlcnRpZXM7IH1cbiAgICBDZm5BdXRvU2NhbGluZ0dyb3VwUHJvcHNWYWxpZGF0b3IocHJvcGVydGllcykuYXNzZXJ0U3VjY2VzcygpO1xuICAgIHJldHVybiB7XG4gICAgICAgIE1heFNpemU6IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMubWF4U2l6ZSksXG4gICAgICAgIE1pblNpemU6IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMubWluU2l6ZSksXG4gICAgICAgIEF1dG9TY2FsaW5nR3JvdXBOYW1lOiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLmF1dG9TY2FsaW5nR3JvdXBOYW1lKSxcbiAgICAgICAgQXZhaWxhYmlsaXR5Wm9uZXM6IGNkay5saXN0TWFwcGVyKGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKShwcm9wZXJ0aWVzLmF2YWlsYWJpbGl0eVpvbmVzKSxcbiAgICAgICAgQ2FwYWNpdHlSZWJhbGFuY2U6IGNkay5ib29sZWFuVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLmNhcGFjaXR5UmViYWxhbmNlKSxcbiAgICAgICAgQ29udGV4dDogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5jb250ZXh0KSxcbiAgICAgICAgQ29vbGRvd246IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuY29vbGRvd24pLFxuICAgICAgICBEZWZhdWx0SW5zdGFuY2VXYXJtdXA6IGNkay5udW1iZXJUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuZGVmYXVsdEluc3RhbmNlV2FybXVwKSxcbiAgICAgICAgRGVzaXJlZENhcGFjaXR5OiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLmRlc2lyZWRDYXBhY2l0eSksXG4gICAgICAgIERlc2lyZWRDYXBhY2l0eVR5cGU6IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuZGVzaXJlZENhcGFjaXR5VHlwZSksXG4gICAgICAgIEhlYWx0aENoZWNrR3JhY2VQZXJpb2Q6IGNkay5udW1iZXJUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuaGVhbHRoQ2hlY2tHcmFjZVBlcmlvZCksXG4gICAgICAgIEhlYWx0aENoZWNrVHlwZTogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5oZWFsdGhDaGVja1R5cGUpLFxuICAgICAgICBJbnN0YW5jZUlkOiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLmluc3RhbmNlSWQpLFxuICAgICAgICBMYXVuY2hDb25maWd1cmF0aW9uTmFtZTogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5sYXVuY2hDb25maWd1cmF0aW9uTmFtZSksXG4gICAgICAgIExhdW5jaFRlbXBsYXRlOiBjZm5BdXRvU2NhbGluZ0dyb3VwTGF1bmNoVGVtcGxhdGVTcGVjaWZpY2F0aW9uUHJvcGVydHlUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMubGF1bmNoVGVtcGxhdGUpLFxuICAgICAgICBMaWZlY3ljbGVIb29rU3BlY2lmaWNhdGlvbkxpc3Q6IGNkay5saXN0TWFwcGVyKGNmbkF1dG9TY2FsaW5nR3JvdXBMaWZlY3ljbGVIb29rU3BlY2lmaWNhdGlvblByb3BlcnR5VG9DbG91ZEZvcm1hdGlvbikocHJvcGVydGllcy5saWZlY3ljbGVIb29rU3BlY2lmaWNhdGlvbkxpc3QpLFxuICAgICAgICBMb2FkQmFsYW5jZXJOYW1lczogY2RrLmxpc3RNYXBwZXIoY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24pKHByb3BlcnRpZXMubG9hZEJhbGFuY2VyTmFtZXMpLFxuICAgICAgICBNYXhJbnN0YW5jZUxpZmV0aW1lOiBjZGsubnVtYmVyVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLm1heEluc3RhbmNlTGlmZXRpbWUpLFxuICAgICAgICBNZXRyaWNzQ29sbGVjdGlvbjogY2RrLmxpc3RNYXBwZXIoY2ZuQXV0b1NjYWxpbmdHcm91cE1ldHJpY3NDb2xsZWN0aW9uUHJvcGVydHlUb0Nsb3VkRm9ybWF0aW9uKShwcm9wZXJ0aWVzLm1ldHJpY3NDb2xsZWN0aW9uKSxcbiAgICAgICAgTWl4ZWRJbnN0YW5jZXNQb2xpY3k6IGNmbkF1dG9TY2FsaW5nR3JvdXBNaXhlZEluc3RhbmNlc1BvbGljeVByb3BlcnR5VG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLm1peGVkSW5zdGFuY2VzUG9saWN5KSxcbiAgICAgICAgTmV3SW5zdGFuY2VzUHJvdGVjdGVkRnJvbVNjYWxlSW46IGNkay5ib29sZWFuVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLm5ld0luc3RhbmNlc1Byb3RlY3RlZEZyb21TY2FsZUluKSxcbiAgICAgICAgTm90aWZpY2F0aW9uQ29uZmlndXJhdGlvbnM6IGNkay5saXN0TWFwcGVyKGNmbkF1dG9TY2FsaW5nR3JvdXBOb3RpZmljYXRpb25Db25maWd1cmF0aW9uUHJvcGVydHlUb0Nsb3VkRm9ybWF0aW9uKShwcm9wZXJ0aWVzLm5vdGlmaWNhdGlvbkNvbmZpZ3VyYXRpb25zKSxcbiAgICAgICAgUGxhY2VtZW50R3JvdXA6IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMucGxhY2VtZW50R3JvdXApLFxuICAgICAgICBTZXJ2aWNlTGlua2VkUm9sZUFSTjogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5zZXJ2aWNlTGlua2VkUm9sZUFybiksXG4gICAgICAgIFRhZ3M6IGNkay5saXN0TWFwcGVyKGNmbkF1dG9TY2FsaW5nR3JvdXBUYWdQcm9wZXJ0eVByb3BlcnR5VG9DbG91ZEZvcm1hdGlvbikocHJvcGVydGllcy50YWdzKSxcbiAgICAgICAgVGFyZ2V0R3JvdXBBUk5zOiBjZGsubGlzdE1hcHBlcihjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbikocHJvcGVydGllcy50YXJnZXRHcm91cEFybnMpLFxuICAgICAgICBUZXJtaW5hdGlvblBvbGljaWVzOiBjZGsubGlzdE1hcHBlcihjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbikocHJvcGVydGllcy50ZXJtaW5hdGlvblBvbGljaWVzKSxcbiAgICAgICAgVlBDWm9uZUlkZW50aWZpZXI6IGNkay5saXN0TWFwcGVyKGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKShwcm9wZXJ0aWVzLnZwY1pvbmVJZGVudGlmaWVyKSxcbiAgICB9O1xufVxuXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gQ2ZuQXV0b1NjYWxpbmdHcm91cFByb3BzRnJvbUNsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQ8Q2ZuQXV0b1NjYWxpbmdHcm91cFByb3BzPiB7XG4gICAgcHJvcGVydGllcyA9IHByb3BlcnRpZXMgPT0gbnVsbCA/IHt9IDogcHJvcGVydGllcztcbiAgICBpZiAodHlwZW9mIHByb3BlcnRpZXMgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIHJldHVybiBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdChwcm9wZXJ0aWVzKTtcbiAgICB9XG4gICAgY29uc3QgcmV0ID0gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25Qcm9wZXJ0eU9iamVjdDxDZm5BdXRvU2NhbGluZ0dyb3VwUHJvcHM+KCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdtYXhTaXplJywgJ01heFNpemUnLCBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLk1heFNpemUpKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ21pblNpemUnLCAnTWluU2l6ZScsIGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuTWluU2l6ZSkpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnYXV0b1NjYWxpbmdHcm91cE5hbWUnLCAnQXV0b1NjYWxpbmdHcm91cE5hbWUnLCBwcm9wZXJ0aWVzLkF1dG9TY2FsaW5nR3JvdXBOYW1lICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLkF1dG9TY2FsaW5nR3JvdXBOYW1lKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdhdmFpbGFiaWxpdHlab25lcycsICdBdmFpbGFiaWxpdHlab25lcycsIHByb3BlcnRpZXMuQXZhaWxhYmlsaXR5Wm9uZXMgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nQXJyYXkocHJvcGVydGllcy5BdmFpbGFiaWxpdHlab25lcykgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnY2FwYWNpdHlSZWJhbGFuY2UnLCAnQ2FwYWNpdHlSZWJhbGFuY2UnLCBwcm9wZXJ0aWVzLkNhcGFjaXR5UmViYWxhbmNlICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldEJvb2xlYW4ocHJvcGVydGllcy5DYXBhY2l0eVJlYmFsYW5jZSkgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnY29udGV4dCcsICdDb250ZXh0JywgcHJvcGVydGllcy5Db250ZXh0ICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLkNvbnRleHQpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2Nvb2xkb3duJywgJ0Nvb2xkb3duJywgcHJvcGVydGllcy5Db29sZG93biAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5Db29sZG93bikgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnZGVmYXVsdEluc3RhbmNlV2FybXVwJywgJ0RlZmF1bHRJbnN0YW5jZVdhcm11cCcsIHByb3BlcnRpZXMuRGVmYXVsdEluc3RhbmNlV2FybXVwICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldE51bWJlcihwcm9wZXJ0aWVzLkRlZmF1bHRJbnN0YW5jZVdhcm11cCkgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnZGVzaXJlZENhcGFjaXR5JywgJ0Rlc2lyZWRDYXBhY2l0eScsIHByb3BlcnRpZXMuRGVzaXJlZENhcGFjaXR5ICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLkRlc2lyZWRDYXBhY2l0eSkgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnZGVzaXJlZENhcGFjaXR5VHlwZScsICdEZXNpcmVkQ2FwYWNpdHlUeXBlJywgcHJvcGVydGllcy5EZXNpcmVkQ2FwYWNpdHlUeXBlICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLkRlc2lyZWRDYXBhY2l0eVR5cGUpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2hlYWx0aENoZWNrR3JhY2VQZXJpb2QnLCAnSGVhbHRoQ2hlY2tHcmFjZVBlcmlvZCcsIHByb3BlcnRpZXMuSGVhbHRoQ2hlY2tHcmFjZVBlcmlvZCAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXROdW1iZXIocHJvcGVydGllcy5IZWFsdGhDaGVja0dyYWNlUGVyaW9kKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdoZWFsdGhDaGVja1R5cGUnLCAnSGVhbHRoQ2hlY2tUeXBlJywgcHJvcGVydGllcy5IZWFsdGhDaGVja1R5cGUgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuSGVhbHRoQ2hlY2tUeXBlKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdpbnN0YW5jZUlkJywgJ0luc3RhbmNlSWQnLCBwcm9wZXJ0aWVzLkluc3RhbmNlSWQgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuSW5zdGFuY2VJZCkgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnbGF1bmNoQ29uZmlndXJhdGlvbk5hbWUnLCAnTGF1bmNoQ29uZmlndXJhdGlvbk5hbWUnLCBwcm9wZXJ0aWVzLkxhdW5jaENvbmZpZ3VyYXRpb25OYW1lICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLkxhdW5jaENvbmZpZ3VyYXRpb25OYW1lKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdsYXVuY2hUZW1wbGF0ZScsICdMYXVuY2hUZW1wbGF0ZScsIHByb3BlcnRpZXMuTGF1bmNoVGVtcGxhdGUgIT0gbnVsbCA/IENmbkF1dG9TY2FsaW5nR3JvdXBMYXVuY2hUZW1wbGF0ZVNwZWNpZmljYXRpb25Qcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLkxhdW5jaFRlbXBsYXRlKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdsaWZlY3ljbGVIb29rU3BlY2lmaWNhdGlvbkxpc3QnLCAnTGlmZWN5Y2xlSG9va1NwZWNpZmljYXRpb25MaXN0JywgcHJvcGVydGllcy5MaWZlY3ljbGVIb29rU3BlY2lmaWNhdGlvbkxpc3QgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0QXJyYXkoQ2ZuQXV0b1NjYWxpbmdHcm91cExpZmVjeWNsZUhvb2tTcGVjaWZpY2F0aW9uUHJvcGVydHlGcm9tQ2xvdWRGb3JtYXRpb24pKHByb3BlcnRpZXMuTGlmZWN5Y2xlSG9va1NwZWNpZmljYXRpb25MaXN0KSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdsb2FkQmFsYW5jZXJOYW1lcycsICdMb2FkQmFsYW5jZXJOYW1lcycsIHByb3BlcnRpZXMuTG9hZEJhbGFuY2VyTmFtZXMgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nQXJyYXkocHJvcGVydGllcy5Mb2FkQmFsYW5jZXJOYW1lcykgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnbWF4SW5zdGFuY2VMaWZldGltZScsICdNYXhJbnN0YW5jZUxpZmV0aW1lJywgcHJvcGVydGllcy5NYXhJbnN0YW5jZUxpZmV0aW1lICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldE51bWJlcihwcm9wZXJ0aWVzLk1heEluc3RhbmNlTGlmZXRpbWUpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ21ldHJpY3NDb2xsZWN0aW9uJywgJ01ldHJpY3NDb2xsZWN0aW9uJywgcHJvcGVydGllcy5NZXRyaWNzQ29sbGVjdGlvbiAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRBcnJheShDZm5BdXRvU2NhbGluZ0dyb3VwTWV0cmljc0NvbGxlY3Rpb25Qcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbikocHJvcGVydGllcy5NZXRyaWNzQ29sbGVjdGlvbikgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnbWl4ZWRJbnN0YW5jZXNQb2xpY3knLCAnTWl4ZWRJbnN0YW5jZXNQb2xpY3knLCBwcm9wZXJ0aWVzLk1peGVkSW5zdGFuY2VzUG9saWN5ICE9IG51bGwgPyBDZm5BdXRvU2NhbGluZ0dyb3VwTWl4ZWRJbnN0YW5jZXNQb2xpY3lQcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLk1peGVkSW5zdGFuY2VzUG9saWN5KSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCduZXdJbnN0YW5jZXNQcm90ZWN0ZWRGcm9tU2NhbGVJbicsICdOZXdJbnN0YW5jZXNQcm90ZWN0ZWRGcm9tU2NhbGVJbicsIHByb3BlcnRpZXMuTmV3SW5zdGFuY2VzUHJvdGVjdGVkRnJvbVNjYWxlSW4gIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0Qm9vbGVhbihwcm9wZXJ0aWVzLk5ld0luc3RhbmNlc1Byb3RlY3RlZEZyb21TY2FsZUluKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdub3RpZmljYXRpb25Db25maWd1cmF0aW9ucycsICdOb3RpZmljYXRpb25Db25maWd1cmF0aW9ucycsIHByb3BlcnRpZXMuTm90aWZpY2F0aW9uQ29uZmlndXJhdGlvbnMgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0QXJyYXkoQ2ZuQXV0b1NjYWxpbmdHcm91cE5vdGlmaWNhdGlvbkNvbmZpZ3VyYXRpb25Qcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbikocHJvcGVydGllcy5Ob3RpZmljYXRpb25Db25maWd1cmF0aW9ucykgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgncGxhY2VtZW50R3JvdXAnLCAnUGxhY2VtZW50R3JvdXAnLCBwcm9wZXJ0aWVzLlBsYWNlbWVudEdyb3VwICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLlBsYWNlbWVudEdyb3VwKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdzZXJ2aWNlTGlua2VkUm9sZUFybicsICdTZXJ2aWNlTGlua2VkUm9sZUFSTicsIHByb3BlcnRpZXMuU2VydmljZUxpbmtlZFJvbGVBUk4gIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuU2VydmljZUxpbmtlZFJvbGVBUk4pIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ3RhZ3MnLCAnVGFncycsIHByb3BlcnRpZXMuVGFncyAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRBcnJheShDZm5BdXRvU2NhbGluZ0dyb3VwVGFnUHJvcGVydHlQcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbikocHJvcGVydGllcy5UYWdzKSA6IHVuZGVmaW5lZCBhcyBhbnkpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgndGFyZ2V0R3JvdXBBcm5zJywgJ1RhcmdldEdyb3VwQVJOcycsIHByb3BlcnRpZXMuVGFyZ2V0R3JvdXBBUk5zICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZ0FycmF5KHByb3BlcnRpZXMuVGFyZ2V0R3JvdXBBUk5zKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCd0ZXJtaW5hdGlvblBvbGljaWVzJywgJ1Rlcm1pbmF0aW9uUG9saWNpZXMnLCBwcm9wZXJ0aWVzLlRlcm1pbmF0aW9uUG9saWNpZXMgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nQXJyYXkocHJvcGVydGllcy5UZXJtaW5hdGlvblBvbGljaWVzKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCd2cGNab25lSWRlbnRpZmllcicsICdWUENab25lSWRlbnRpZmllcicsIHByb3BlcnRpZXMuVlBDWm9uZUlkZW50aWZpZXIgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nQXJyYXkocHJvcGVydGllcy5WUENab25lSWRlbnRpZmllcikgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRVbnJlY29nbml6ZWRQcm9wZXJ0aWVzQXNFeHRyYShwcm9wZXJ0aWVzKTtcbiAgICByZXR1cm4gcmV0O1xufVxuXG4vKipcbiAqIEEgQ2xvdWRGb3JtYXRpb24gYEFXUzo6QXV0b1NjYWxpbmc6OkF1dG9TY2FsaW5nR3JvdXBgXG4gKlxuICogVGhlIGBBV1M6OkF1dG9TY2FsaW5nOjpBdXRvU2NhbGluZ0dyb3VwYCByZXNvdXJjZSBkZWZpbmVzIGFuIEFtYXpvbiBFQzIgQXV0byBTY2FsaW5nIGdyb3VwLCB3aGljaCBpcyBhIGNvbGxlY3Rpb24gb2YgQW1hem9uIEVDMiBpbnN0YW5jZXMgdGhhdCBhcmUgdHJlYXRlZCBhcyBhIGxvZ2ljYWwgZ3JvdXBpbmcgZm9yIHRoZSBwdXJwb3NlcyBvZiBhdXRvbWF0aWMgc2NhbGluZyBhbmQgbWFuYWdlbWVudC5cbiAqXG4gKiBGb3IgbW9yZSBpbmZvcm1hdGlvbiBhYm91dCBBbWF6b24gRUMyIEF1dG8gU2NhbGluZywgc2VlIHRoZSBbQW1hem9uIEVDMiBBdXRvIFNjYWxpbmcgVXNlciBHdWlkZV0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2F1dG9zY2FsaW5nL2VjMi91c2VyZ3VpZGUvd2hhdC1pcy1hbWF6b24tZWMyLWF1dG8tc2NhbGluZy5odG1sKSAuXG4gKlxuICogPiBBbWF6b24gRUMyIEF1dG8gU2NhbGluZyBjb25maWd1cmVzIGluc3RhbmNlcyBsYXVuY2hlZCBhcyBwYXJ0IG9mIGFuIEF1dG8gU2NhbGluZyBncm91cCB1c2luZyBlaXRoZXIgYSBbbGF1bmNoIHRlbXBsYXRlXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZWMyLWxhdW5jaHRlbXBsYXRlLmh0bWwpIG9yIGEgbGF1bmNoIGNvbmZpZ3VyYXRpb24uIFdlIHN0cm9uZ2x5IHJlY29tbWVuZCB0aGF0IHlvdSBkbyBub3QgdXNlIGxhdW5jaCBjb25maWd1cmF0aW9ucy4gVGhleSBkbyBub3QgcHJvdmlkZSBmdWxsIGZ1bmN0aW9uYWxpdHkgZm9yIEFtYXpvbiBFQzIgQXV0byBTY2FsaW5nIG9yIEFtYXpvbiBFQzIuIEZvciBtb3JlIGluZm9ybWF0aW9uLCBzZWUgW0xhdW5jaCBjb25maWd1cmF0aW9uc10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2F1dG9zY2FsaW5nL2VjMi91c2VyZ3VpZGUvbGF1bmNoLWNvbmZpZ3VyYXRpb25zLmh0bWwpIGluIHRoZSAqQW1hem9uIEVDMiBBdXRvIFNjYWxpbmcgVXNlciBHdWlkZSogLlxuICpcbiAqIEBjbG91ZGZvcm1hdGlvblJlc291cmNlIEFXUzo6QXV0b1NjYWxpbmc6OkF1dG9TY2FsaW5nR3JvdXBcbiAqIEBzdGFiaWxpdHkgZXh0ZXJuYWxcbiAqXG4gKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWFzLWdyb3VwLmh0bWxcbiAqL1xuZXhwb3J0IGNsYXNzIENmbkF1dG9TY2FsaW5nR3JvdXAgZXh0ZW5kcyBjZGsuQ2ZuUmVzb3VyY2UgaW1wbGVtZW50cyBjZGsuSUluc3BlY3RhYmxlIHtcbiAgICAvKipcbiAgICAgKiBUaGUgQ2xvdWRGb3JtYXRpb24gcmVzb3VyY2UgdHlwZSBuYW1lIGZvciB0aGlzIHJlc291cmNlIGNsYXNzLlxuICAgICAqL1xuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgQ0ZOX1JFU09VUkNFX1RZUEVfTkFNRSA9IFwiQVdTOjpBdXRvU2NhbGluZzo6QXV0b1NjYWxpbmdHcm91cFwiO1xuXG4gICAgLyoqXG4gICAgICogQSBmYWN0b3J5IG1ldGhvZCB0aGF0IGNyZWF0ZXMgYSBuZXcgaW5zdGFuY2Ugb2YgdGhpcyBjbGFzcyBmcm9tIGFuIG9iamVjdFxuICAgICAqIGNvbnRhaW5pbmcgdGhlIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgdGhpcyByZXNvdXJjZS5cbiAgICAgKiBVc2VkIGluIHRoZSBAYXdzLWNkay9jbG91ZGZvcm1hdGlvbi1pbmNsdWRlIG1vZHVsZS5cbiAgICAgKlxuICAgICAqIEBpbnRlcm5hbFxuICAgICAqL1xuICAgIHB1YmxpYyBzdGF0aWMgX2Zyb21DbG91ZEZvcm1hdGlvbihzY29wZTogY2RrLkNvbnN0cnVjdCwgaWQ6IHN0cmluZywgcmVzb3VyY2VBdHRyaWJ1dGVzOiBhbnksIG9wdGlvbnM6IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25PcHRpb25zKTogQ2ZuQXV0b1NjYWxpbmdHcm91cCB7XG4gICAgICAgIHJlc291cmNlQXR0cmlidXRlcyA9IHJlc291cmNlQXR0cmlidXRlcyB8fCB7fTtcbiAgICAgICAgY29uc3QgcmVzb3VyY2VQcm9wZXJ0aWVzID0gb3B0aW9ucy5wYXJzZXIucGFyc2VWYWx1ZShyZXNvdXJjZUF0dHJpYnV0ZXMuUHJvcGVydGllcyk7XG4gICAgICAgIGNvbnN0IHByb3BzUmVzdWx0ID0gQ2ZuQXV0b1NjYWxpbmdHcm91cFByb3BzRnJvbUNsb3VkRm9ybWF0aW9uKHJlc291cmNlUHJvcGVydGllcyk7XG4gICAgICAgIGNvbnN0IHJldCA9IG5ldyBDZm5BdXRvU2NhbGluZ0dyb3VwKHNjb3BlLCBpZCwgcHJvcHNSZXN1bHQudmFsdWUpO1xuICAgICAgICBmb3IgKGNvbnN0IFtwcm9wS2V5LCBwcm9wVmFsXSBvZiBPYmplY3QuZW50cmllcyhwcm9wc1Jlc3VsdC5leHRyYVByb3BlcnRpZXMpKSAge1xuICAgICAgICAgICAgcmV0LmFkZFByb3BlcnR5T3ZlcnJpZGUocHJvcEtleSwgcHJvcFZhbCk7XG4gICAgICAgIH1cbiAgICAgICAgb3B0aW9ucy5wYXJzZXIuaGFuZGxlQXR0cmlidXRlcyhyZXQsIHJlc291cmNlQXR0cmlidXRlcywgaWQpO1xuICAgICAgICByZXR1cm4gcmV0O1xuICAgIH1cblxuICAgIC8qKlxuICAgICAqIFRoZSBtYXhpbXVtIHNpemUgb2YgdGhlIGdyb3VwLlxuICAgICAqXG4gICAgICogPiBXaXRoIGEgbWl4ZWQgaW5zdGFuY2VzIHBvbGljeSB0aGF0IHVzZXMgaW5zdGFuY2Ugd2VpZ2h0aW5nLCBBbWF6b24gRUMyIEF1dG8gU2NhbGluZyBtYXkgbmVlZCB0byBnbyBhYm92ZSBgTWF4U2l6ZWAgdG8gbWVldCB5b3VyIGNhcGFjaXR5IHJlcXVpcmVtZW50cy4gSW4gdGhpcyBldmVudCwgQW1hem9uIEVDMiBBdXRvIFNjYWxpbmcgd2lsbCBuZXZlciBnbyBhYm92ZSBgTWF4U2l6ZWAgYnkgbW9yZSB0aGFuIHlvdXIgbGFyZ2VzdCBpbnN0YW5jZSB3ZWlnaHQgKHdlaWdodHMgdGhhdCBkZWZpbmUgaG93IG1hbnkgdW5pdHMgZWFjaCBpbnN0YW5jZSBjb250cmlidXRlcyB0byB0aGUgZGVzaXJlZCBjYXBhY2l0eSBvZiB0aGUgZ3JvdXApLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hcy1ncm91cC5odG1sI2Nmbi1hcy1ncm91cC1tYXhzaXplXG4gICAgICovXG4gICAgcHVibGljIG1heFNpemU6IHN0cmluZztcblxuICAgIC8qKlxuICAgICAqIFRoZSBtaW5pbXVtIHNpemUgb2YgdGhlIGdyb3VwLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hcy1ncm91cC5odG1sI2Nmbi1hcy1ncm91cC1taW5zaXplXG4gICAgICovXG4gICAgcHVibGljIG1pblNpemU6IHN0cmluZztcblxuICAgIC8qKlxuICAgICAqIFRoZSBuYW1lIG9mIHRoZSBBdXRvIFNjYWxpbmcgZ3JvdXAuIFRoaXMgbmFtZSBtdXN0IGJlIHVuaXF1ZSBwZXIgUmVnaW9uIHBlciBhY2NvdW50LlxuICAgICAqXG4gICAgICogVGhlIG5hbWUgY2FuIGNvbnRhaW4gYW55IEFTQ0lJIGNoYXJhY3RlciAzMyB0byAxMjYgaW5jbHVkaW5nIG1vc3QgcHVuY3R1YXRpb24gY2hhcmFjdGVycywgZGlnaXRzLCBhbmQgdXBwZXIgYW5kIGxvd2VyY2FzZWQgbGV0dGVycy5cbiAgICAgKlxuICAgICAqID4gWW91IGNhbm5vdCB1c2UgYSBjb2xvbiAoOikgaW4gdGhlIG5hbWUuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWFzLWdyb3VwLmh0bWwjY2ZuLWF1dG9zY2FsaW5nLWF1dG9zY2FsaW5nZ3JvdXAtYXV0b3NjYWxpbmdncm91cG5hbWVcbiAgICAgKi9cbiAgICBwdWJsaWMgYXV0b1NjYWxpbmdHcm91cE5hbWU6IHN0cmluZyB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIEEgbGlzdCBvZiBBdmFpbGFiaWxpdHkgWm9uZXMgd2hlcmUgaW5zdGFuY2VzIGluIHRoZSBBdXRvIFNjYWxpbmcgZ3JvdXAgY2FuIGJlIGNyZWF0ZWQuIFVzZWQgZm9yIGxhdW5jaGluZyBpbnRvIHRoZSBkZWZhdWx0IFZQQyBzdWJuZXQgaW4gZWFjaCBBdmFpbGFiaWxpdHkgWm9uZSB3aGVuIG5vdCB1c2luZyB0aGUgYFZQQ1pvbmVJZGVudGlmaWVyYCBwcm9wZXJ0eSwgb3IgZm9yIGF0dGFjaGluZyBhIG5ldHdvcmsgaW50ZXJmYWNlIHdoZW4gYW4gZXhpc3RpbmcgbmV0d29yayBpbnRlcmZhY2UgSUQgaXMgc3BlY2lmaWVkIGluIGEgbGF1bmNoIHRlbXBsYXRlLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hcy1ncm91cC5odG1sI2Nmbi1hcy1ncm91cC1hdmFpbGFiaWxpdHl6b25lc1xuICAgICAqL1xuICAgIHB1YmxpYyBhdmFpbGFiaWxpdHlab25lczogc3RyaW5nW10gfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBJbmRpY2F0ZXMgd2hldGhlciBDYXBhY2l0eSBSZWJhbGFuY2luZyBpcyBlbmFibGVkLiBPdGhlcndpc2UsIENhcGFjaXR5IFJlYmFsYW5jaW5nIGlzIGRpc2FibGVkLiBXaGVuIHlvdSB0dXJuIG9uIENhcGFjaXR5IFJlYmFsYW5jaW5nLCBBbWF6b24gRUMyIEF1dG8gU2NhbGluZyBhdHRlbXB0cyB0byBsYXVuY2ggYSBTcG90IEluc3RhbmNlIHdoZW5ldmVyIEFtYXpvbiBFQzIgbm90aWZpZXMgdGhhdCBhIFNwb3QgSW5zdGFuY2UgaXMgYXQgYW4gZWxldmF0ZWQgcmlzayBvZiBpbnRlcnJ1cHRpb24uIEFmdGVyIGxhdW5jaGluZyBhIG5ldyBpbnN0YW5jZSwgaXQgdGhlbiB0ZXJtaW5hdGVzIGFuIG9sZCBpbnN0YW5jZS4gRm9yIG1vcmUgaW5mb3JtYXRpb24sIHNlZSBbVXNlIENhcGFjaXR5IFJlYmFsYW5jaW5nIHRvIGhhbmRsZSBBbWF6b24gRUMyIFNwb3QgSW50ZXJydXB0aW9uc10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2F1dG9zY2FsaW5nL2VjMi91c2VyZ3VpZGUvZWMyLWF1dG8tc2NhbGluZy1jYXBhY2l0eS1yZWJhbGFuY2luZy5odG1sKSBpbiB0aGUgaW4gdGhlICpBbWF6b24gRUMyIEF1dG8gU2NhbGluZyBVc2VyIEd1aWRlKiAuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWFzLWdyb3VwLmh0bWwjY2ZuLWFzLWdyb3VwLWNhcGFjaXR5cmViYWxhbmNlXG4gICAgICovXG4gICAgcHVibGljIGNhcGFjaXR5UmViYWxhbmNlOiBib29sZWFuIHwgY2RrLklSZXNvbHZhYmxlIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogUmVzZXJ2ZWQuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWFzLWdyb3VwLmh0bWwjY2ZuLWFzLWdyb3VwLWNvbnRleHRcbiAgICAgKi9cbiAgICBwdWJsaWMgY29udGV4dDogc3RyaW5nIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogKk9ubHkgbmVlZGVkIGlmIHlvdSB1c2Ugc2ltcGxlIHNjYWxpbmcgcG9saWNpZXMuKlxuICAgICAqXG4gICAgICogVGhlIGFtb3VudCBvZiB0aW1lLCBpbiBzZWNvbmRzLCBiZXR3ZWVuIG9uZSBzY2FsaW5nIGFjdGl2aXR5IGVuZGluZyBhbmQgYW5vdGhlciBvbmUgc3RhcnRpbmcgZHVlIHRvIHNpbXBsZSBzY2FsaW5nIHBvbGljaWVzLiBGb3IgbW9yZSBpbmZvcm1hdGlvbiwgc2VlIFtTY2FsaW5nIGNvb2xkb3ducyBmb3IgQW1hem9uIEVDMiBBdXRvIFNjYWxpbmddKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9hdXRvc2NhbGluZy9lYzIvdXNlcmd1aWRlL0Nvb2xkb3duLmh0bWwpIGluIHRoZSAqQW1hem9uIEVDMiBBdXRvIFNjYWxpbmcgVXNlciBHdWlkZSogLlxuICAgICAqXG4gICAgICogRGVmYXVsdDogYDMwMGAgc2Vjb25kc1xuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hcy1ncm91cC5odG1sI2Nmbi1hcy1ncm91cC1jb29sZG93blxuICAgICAqL1xuICAgIHB1YmxpYyBjb29sZG93bjogc3RyaW5nIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogVGhlIGFtb3VudCBvZiB0aW1lLCBpbiBzZWNvbmRzLCB1bnRpbCBhIG5ld2x5IGxhdW5jaGVkIGluc3RhbmNlIGNhbiBjb250cmlidXRlIHRvIHRoZSBBbWF6b24gQ2xvdWRXYXRjaCBtZXRyaWNzLiBUaGlzIGRlbGF5IGxldHMgYW4gaW5zdGFuY2UgZmluaXNoIGluaXRpYWxpemluZyBiZWZvcmUgQW1hem9uIEVDMiBBdXRvIFNjYWxpbmcgYWdncmVnYXRlcyBpbnN0YW5jZSBtZXRyaWNzLCByZXN1bHRpbmcgaW4gbW9yZSByZWxpYWJsZSB1c2FnZSBkYXRhLiBTZXQgdGhpcyB2YWx1ZSBlcXVhbCB0byB0aGUgYW1vdW50IG9mIHRpbWUgdGhhdCBpdCB0YWtlcyBmb3IgcmVzb3VyY2UgY29uc3VtcHRpb24gdG8gYmVjb21lIHN0YWJsZSBhZnRlciBhbiBpbnN0YW5jZSByZWFjaGVzIHRoZSBgSW5TZXJ2aWNlYCBzdGF0ZS4gRm9yIG1vcmUgaW5mb3JtYXRpb24sIHNlZSBbU2V0IHRoZSBkZWZhdWx0IGluc3RhbmNlIHdhcm11cCBmb3IgYW4gQXV0byBTY2FsaW5nIGdyb3VwXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vYXV0b3NjYWxpbmcvZWMyL3VzZXJndWlkZS9lYzItYXV0by1zY2FsaW5nLWRlZmF1bHQtaW5zdGFuY2Utd2FybXVwLmh0bWwpIGluIHRoZSAqQW1hem9uIEVDMiBBdXRvIFNjYWxpbmcgVXNlciBHdWlkZSogLlxuICAgICAqXG4gICAgICogPiBUbyBtYW5hZ2UgeW91ciB3YXJtLXVwIHNldHRpbmdzIGF0IHRoZSBncm91cCBsZXZlbCwgd2UgcmVjb21tZW5kIHRoYXQgeW91IHNldCB0aGUgZGVmYXVsdCBpbnN0YW5jZSB3YXJtdXAsICpldmVuIGlmIGl0cyB2YWx1ZSBpcyBzZXQgdG8gMCBzZWNvbmRzKiAuIFRoaXMgYWxzbyBvcHRpbWl6ZXMgdGhlIHBlcmZvcm1hbmNlIG9mIHNjYWxpbmcgcG9saWNpZXMgdGhhdCBzY2FsZSBjb250aW51b3VzbHksIHN1Y2ggYXMgdGFyZ2V0IHRyYWNraW5nIGFuZCBzdGVwIHNjYWxpbmcgcG9saWNpZXMuXG4gICAgICogPlxuICAgICAqID4gSWYgeW91IG5lZWQgdG8gcmVtb3ZlIGEgdmFsdWUgdGhhdCB5b3UgcHJldmlvdXNseSBzZXQsIGluY2x1ZGUgdGhlIHByb3BlcnR5IGJ1dCBzcGVjaWZ5IGAtMWAgZm9yIHRoZSB2YWx1ZS4gSG93ZXZlciwgd2Ugc3Ryb25nbHkgcmVjb21tZW5kIGtlZXBpbmcgdGhlIGRlZmF1bHQgaW5zdGFuY2Ugd2FybXVwIGVuYWJsZWQgYnkgc3BlY2lmeWluZyBhIG1pbmltdW0gdmFsdWUgb2YgYDBgIC5cbiAgICAgKlxuICAgICAqIERlZmF1bHQ6IE5vbmVcbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXMtZ3JvdXAuaHRtbCNjZm4tYXMtZ3JvdXAtZGVmYXVsdGluc3RhbmNld2FybXVwXG4gICAgICovXG4gICAgcHVibGljIGRlZmF1bHRJbnN0YW5jZVdhcm11cDogbnVtYmVyIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogVGhlIGRlc2lyZWQgY2FwYWNpdHkgaXMgdGhlIGluaXRpYWwgY2FwYWNpdHkgb2YgdGhlIEF1dG8gU2NhbGluZyBncm91cCBhdCB0aGUgdGltZSBvZiBpdHMgY3JlYXRpb24gYW5kIHRoZSBjYXBhY2l0eSBpdCBhdHRlbXB0cyB0byBtYWludGFpbi4gSXQgY2FuIHNjYWxlIGJleW9uZCB0aGlzIGNhcGFjaXR5IGlmIHlvdSBjb25maWd1cmUgYXV0b21hdGljIHNjYWxpbmcuXG4gICAgICpcbiAgICAgKiBUaGUgbnVtYmVyIG11c3QgYmUgZ3JlYXRlciB0aGFuIG9yIGVxdWFsIHRvIHRoZSBtaW5pbXVtIHNpemUgb2YgdGhlIGdyb3VwIGFuZCBsZXNzIHRoYW4gb3IgZXF1YWwgdG8gdGhlIG1heGltdW0gc2l6ZSBvZiB0aGUgZ3JvdXAuIElmIHlvdSBkbyBub3Qgc3BlY2lmeSBhIGRlc2lyZWQgY2FwYWNpdHkgd2hlbiBjcmVhdGluZyB0aGUgc3RhY2ssIHRoZSBkZWZhdWx0IGlzIHRoZSBtaW5pbXVtIHNpemUgb2YgdGhlIGdyb3VwLlxuICAgICAqXG4gICAgICogQ2xvdWRGb3JtYXRpb24gbWFya3MgdGhlIEF1dG8gU2NhbGluZyBncm91cCBhcyBzdWNjZXNzZnVsIChieSBzZXR0aW5nIGl0cyBzdGF0dXMgdG8gQ1JFQVRFX0NPTVBMRVRFKSB3aGVuIHRoZSBkZXNpcmVkIGNhcGFjaXR5IGlzIHJlYWNoZWQuIEhvd2V2ZXIsIGlmIGEgbWF4aW11bSBTcG90IHByaWNlIGlzIHNldCBpbiB0aGUgbGF1bmNoIHRlbXBsYXRlIG9yIGxhdW5jaCBjb25maWd1cmF0aW9uIHRoYXQgeW91IHNwZWNpZmllZCwgdGhlbiBkZXNpcmVkIGNhcGFjaXR5IGlzIG5vdCB1c2VkIGFzIGEgY3JpdGVyaWEgZm9yIHN1Y2Nlc3MuIFdoZXRoZXIgeW91ciByZXF1ZXN0IGlzIGZ1bGZpbGxlZCBkZXBlbmRzIG9uIFNwb3QgSW5zdGFuY2UgY2FwYWNpdHkgYW5kIHlvdXIgbWF4aW11bSBwcmljZS5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXMtZ3JvdXAuaHRtbCNjZm4tYXMtZ3JvdXAtZGVzaXJlZGNhcGFjaXR5XG4gICAgICovXG4gICAgcHVibGljIGRlc2lyZWRDYXBhY2l0eTogc3RyaW5nIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogVGhlIHVuaXQgb2YgbWVhc3VyZW1lbnQgZm9yIHRoZSB2YWx1ZSBzcGVjaWZpZWQgZm9yIGRlc2lyZWQgY2FwYWNpdHkuIEFtYXpvbiBFQzIgQXV0byBTY2FsaW5nIHN1cHBvcnRzIGBEZXNpcmVkQ2FwYWNpdHlUeXBlYCBmb3IgYXR0cmlidXRlLWJhc2VkIGluc3RhbmNlIHR5cGUgc2VsZWN0aW9uIG9ubHkuIEZvciBtb3JlIGluZm9ybWF0aW9uLCBzZWUgW0NyZWF0aW5nIGFuIEF1dG8gU2NhbGluZyBncm91cCB1c2luZyBhdHRyaWJ1dGUtYmFzZWQgaW5zdGFuY2UgdHlwZSBzZWxlY3Rpb25dKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9hdXRvc2NhbGluZy9lYzIvdXNlcmd1aWRlL2NyZWF0ZS1hc2ctaW5zdGFuY2UtdHlwZS1yZXF1aXJlbWVudHMuaHRtbCkgaW4gdGhlICpBbWF6b24gRUMyIEF1dG8gU2NhbGluZyBVc2VyIEd1aWRlKiAuXG4gICAgICpcbiAgICAgKiBCeSBkZWZhdWx0LCBBbWF6b24gRUMyIEF1dG8gU2NhbGluZyBzcGVjaWZpZXMgYHVuaXRzYCAsIHdoaWNoIHRyYW5zbGF0ZXMgaW50byBudW1iZXIgb2YgaW5zdGFuY2VzLlxuICAgICAqXG4gICAgICogVmFsaWQgdmFsdWVzOiBgdW5pdHNgIHwgYHZjcHVgIHwgYG1lbW9yeS1taWJgXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWFzLWdyb3VwLmh0bWwjY2ZuLWFzLWdyb3VwLWRlc2lyZWRjYXBhY2l0eXR5cGVcbiAgICAgKi9cbiAgICBwdWJsaWMgZGVzaXJlZENhcGFjaXR5VHlwZTogc3RyaW5nIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogVGhlIGFtb3VudCBvZiB0aW1lLCBpbiBzZWNvbmRzLCB0aGF0IEFtYXpvbiBFQzIgQXV0byBTY2FsaW5nIHdhaXRzIGJlZm9yZSBjaGVja2luZyB0aGUgaGVhbHRoIHN0YXR1cyBvZiBhbiBFQzIgaW5zdGFuY2UgdGhhdCBoYXMgY29tZSBpbnRvIHNlcnZpY2UgYW5kIG1hcmtpbmcgaXQgdW5oZWFsdGh5IGR1ZSB0byBhIGZhaWxlZCBoZWFsdGggY2hlY2suIFRoaXMgaXMgdXNlZnVsIGlmIHlvdXIgaW5zdGFuY2VzIGRvIG5vdCBpbW1lZGlhdGVseSBwYXNzIHRoZWlyIGhlYWx0aCBjaGVja3MgYWZ0ZXIgdGhleSBlbnRlciB0aGUgYEluU2VydmljZWAgc3RhdGUuIEZvciBtb3JlIGluZm9ybWF0aW9uLCBzZWUgW1NldCB0aGUgaGVhbHRoIGNoZWNrIGdyYWNlIHBlcmlvZCBmb3IgYW4gQXV0byBTY2FsaW5nIGdyb3VwXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vYXV0b3NjYWxpbmcvZWMyL3VzZXJndWlkZS9oZWFsdGgtY2hlY2stZ3JhY2UtcGVyaW9kLmh0bWwpIGluIHRoZSAqQW1hem9uIEVDMiBBdXRvIFNjYWxpbmcgVXNlciBHdWlkZSogLlxuICAgICAqXG4gICAgICogRGVmYXVsdDogYDBgIHNlY29uZHNcbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXMtZ3JvdXAuaHRtbCNjZm4tYXMtZ3JvdXAtaGVhbHRoY2hlY2tncmFjZXBlcmlvZFxuICAgICAqL1xuICAgIHB1YmxpYyBoZWFsdGhDaGVja0dyYWNlUGVyaW9kOiBudW1iZXIgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBEZXRlcm1pbmVzIHdoZXRoZXIgYW55IGFkZGl0aW9uYWwgaGVhbHRoIGNoZWNrcyBhcmUgcGVyZm9ybWVkIG9uIHRoZSBpbnN0YW5jZXMgaW4gdGhpcyBncm91cC4gQW1hem9uIEVDMiBoZWFsdGggY2hlY2tzIGFyZSBhbHdheXMgb24uIEZvciBtb3JlIGluZm9ybWF0aW9uLCBzZWUgW0hlYWx0aCBjaGVja3MgZm9yIEF1dG8gU2NhbGluZyBpbnN0YW5jZXNdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9hdXRvc2NhbGluZy9lYzIvdXNlcmd1aWRlL2hlYWx0aGNoZWNrLmh0bWwpIGluIHRoZSAqQW1hem9uIEVDMiBBdXRvIFNjYWxpbmcgVXNlciBHdWlkZSogLlxuICAgICAqXG4gICAgICogVGhlIHZhbGlkIHZhbHVlcyBhcmUgYEVDMmAgKGRlZmF1bHQpLCBgRUxCYCAsIGFuZCBgVlBDX0xBVFRJQ0VgIC4gVGhlIGBWUENfTEFUVElDRWAgaGVhbHRoIGNoZWNrIHR5cGUgaXMgcmVzZXJ2ZWQgZm9yIHVzZSB3aXRoIFZQQyBMYXR0aWNlLCB3aGljaCBpcyBpbiBwcmV2aWV3IHJlbGVhc2UgYW5kIGlzIHN1YmplY3QgdG8gY2hhbmdlLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hcy1ncm91cC5odG1sI2Nmbi1hcy1ncm91cC1oZWFsdGhjaGVja3R5cGVcbiAgICAgKi9cbiAgICBwdWJsaWMgaGVhbHRoQ2hlY2tUeXBlOiBzdHJpbmcgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgSUQgb2YgdGhlIGluc3RhbmNlIHVzZWQgdG8gYmFzZSB0aGUgbGF1bmNoIGNvbmZpZ3VyYXRpb24gb24uIEZvciBtb3JlIGluZm9ybWF0aW9uLCBzZWUgW0NyZWF0ZSBhbiBBdXRvIFNjYWxpbmcgZ3JvdXAgdXNpbmcgYW4gRUMyIGluc3RhbmNlXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vYXV0b3NjYWxpbmcvZWMyL3VzZXJndWlkZS9jcmVhdGUtYXNnLWZyb20taW5zdGFuY2UuaHRtbCkgaW4gdGhlICpBbWF6b24gRUMyIEF1dG8gU2NhbGluZyBVc2VyIEd1aWRlKiAuXG4gICAgICpcbiAgICAgKiBJZiB5b3Ugc3BlY2lmeSBgTGF1bmNoVGVtcGxhdGVgICwgYE1peGVkSW5zdGFuY2VzUG9saWN5YCAsIG9yIGBMYXVuY2hDb25maWd1cmF0aW9uTmFtZWAgLCBkb24ndCBzcGVjaWZ5IGBJbnN0YW5jZUlkYCAuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWFzLWdyb3VwLmh0bWwjY2ZuLWFzLWdyb3VwLWluc3RhbmNlaWRcbiAgICAgKi9cbiAgICBwdWJsaWMgaW5zdGFuY2VJZDogc3RyaW5nIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogVGhlIG5hbWUgb2YgdGhlIGxhdW5jaCBjb25maWd1cmF0aW9uIHRvIHVzZSB0byBsYXVuY2ggaW5zdGFuY2VzLlxuICAgICAqXG4gICAgICogUmVxdWlyZWQgb25seSBpZiB5b3UgZG9uJ3Qgc3BlY2lmeSBgTGF1bmNoVGVtcGxhdGVgICwgYE1peGVkSW5zdGFuY2VzUG9saWN5YCAsIG9yIGBJbnN0YW5jZUlkYCAuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWFzLWdyb3VwLmh0bWwjY2ZuLWFzLWdyb3VwLWxhdW5jaGNvbmZpZ3VyYXRpb25uYW1lXG4gICAgICovXG4gICAgcHVibGljIGxhdW5jaENvbmZpZ3VyYXRpb25OYW1lOiBzdHJpbmcgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBJbmZvcm1hdGlvbiB1c2VkIHRvIHNwZWNpZnkgdGhlIGxhdW5jaCB0ZW1wbGF0ZSBhbmQgdmVyc2lvbiB0byB1c2UgdG8gbGF1bmNoIGluc3RhbmNlcy4gWW91IGNhbiBhbHRlcm5hdGl2ZWx5IGFzc29jaWF0ZSBhIGxhdW5jaCB0ZW1wbGF0ZSB0byB0aGUgQXV0byBTY2FsaW5nIGdyb3VwIGJ5IHNwZWNpZnlpbmcgYSBgTWl4ZWRJbnN0YW5jZXNQb2xpY3lgIC4gRm9yIG1vcmUgaW5mb3JtYXRpb24gYWJvdXQgY3JlYXRpbmcgbGF1bmNoIHRlbXBsYXRlcywgc2VlIFtDcmVhdGUgYSBsYXVuY2ggdGVtcGxhdGUgZm9yIGFuIEF1dG8gU2NhbGluZyBncm91cF0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2F1dG9zY2FsaW5nL2VjMi91c2VyZ3VpZGUvY3JlYXRlLWxhdW5jaC10ZW1wbGF0ZS5odG1sKSBpbiB0aGUgKkFtYXpvbiBFQzIgQXV0byBTY2FsaW5nIFVzZXIgR3VpZGUqIC5cbiAgICAgKlxuICAgICAqIElmIHlvdSBvbWl0IHRoaXMgcHJvcGVydHksIHlvdSBtdXN0IHNwZWNpZnkgYE1peGVkSW5zdGFuY2VzUG9saWN5YCAsIGBMYXVuY2hDb25maWd1cmF0aW9uTmFtZWAgLCBvciBgSW5zdGFuY2VJZGAgLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hcy1ncm91cC5odG1sI2Nmbi1hcy1ncm91cC1sYXVuY2h0ZW1wbGF0ZVxuICAgICAqL1xuICAgIHB1YmxpYyBsYXVuY2hUZW1wbGF0ZTogQ2ZuQXV0b1NjYWxpbmdHcm91cC5MYXVuY2hUZW1wbGF0ZVNwZWNpZmljYXRpb25Qcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZSB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIE9uZSBvciBtb3JlIGxpZmVjeWNsZSBob29rcyB0byBhZGQgdG8gdGhlIEF1dG8gU2NhbGluZyBncm91cCBiZWZvcmUgaW5zdGFuY2VzIGFyZSBsYXVuY2hlZC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXMtZ3JvdXAuaHRtbCNjZm4tYXV0b3NjYWxpbmctYXV0b3NjYWxpbmdncm91cC1saWZlY3ljbGVob29rc3BlY2lmaWNhdGlvbmxpc3RcbiAgICAgKi9cbiAgICBwdWJsaWMgbGlmZWN5Y2xlSG9va1NwZWNpZmljYXRpb25MaXN0OiBBcnJheTxDZm5BdXRvU2NhbGluZ0dyb3VwLkxpZmVjeWNsZUhvb2tTcGVjaWZpY2F0aW9uUHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGU+IHwgY2RrLklSZXNvbHZhYmxlIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogQSBsaXN0IG9mIENsYXNzaWMgTG9hZCBCYWxhbmNlcnMgYXNzb2NpYXRlZCB3aXRoIHRoaXMgQXV0byBTY2FsaW5nIGdyb3VwLiBGb3IgQXBwbGljYXRpb24gTG9hZCBCYWxhbmNlcnMsIE5ldHdvcmsgTG9hZCBCYWxhbmNlcnMsIGFuZCBHYXRld2F5IExvYWQgQmFsYW5jZXIsIHNwZWNpZnkgdGhlIGBUYXJnZXRHcm91cEFSTnNgIHByb3BlcnR5IGluc3RlYWQuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWFzLWdyb3VwLmh0bWwjY2ZuLWFzLWdyb3VwLWxvYWRiYWxhbmNlcm5hbWVzXG4gICAgICovXG4gICAgcHVibGljIGxvYWRCYWxhbmNlck5hbWVzOiBzdHJpbmdbXSB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIFRoZSBtYXhpbXVtIGFtb3VudCBvZiB0aW1lLCBpbiBzZWNvbmRzLCB0aGF0IGFuIGluc3RhbmNlIGNhbiBiZSBpbiBzZXJ2aWNlLiBUaGUgZGVmYXVsdCBpcyBudWxsLiBJZiBzcGVjaWZpZWQsIHRoZSB2YWx1ZSBtdXN0IGJlIGVpdGhlciAwIG9yIGEgbnVtYmVyIGVxdWFsIHRvIG9yIGdyZWF0ZXIgdGhhbiA4Niw0MDAgc2Vjb25kcyAoMSBkYXkpLiBGb3IgbW9yZSBpbmZvcm1hdGlvbiwgc2VlIFtSZXBsYWNpbmcgQXV0byBTY2FsaW5nIGluc3RhbmNlcyBiYXNlZCBvbiBtYXhpbXVtIGluc3RhbmNlIGxpZmV0aW1lXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vYXV0b3NjYWxpbmcvZWMyL3VzZXJndWlkZS9hc2ctbWF4LWluc3RhbmNlLWxpZmV0aW1lLmh0bWwpIGluIHRoZSAqQW1hem9uIEVDMiBBdXRvIFNjYWxpbmcgVXNlciBHdWlkZSogLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hcy1ncm91cC5odG1sI2Nmbi1hcy1ncm91cC1tYXhpbnN0YW5jZWxpZmV0aW1lXG4gICAgICovXG4gICAgcHVibGljIG1heEluc3RhbmNlTGlmZXRpbWU6IG51bWJlciB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIEVuYWJsZXMgdGhlIG1vbml0b3Jpbmcgb2YgZ3JvdXAgbWV0cmljcyBvZiBhbiBBdXRvIFNjYWxpbmcgZ3JvdXAuIEJ5IGRlZmF1bHQsIHRoZXNlIG1ldHJpY3MgYXJlIGRpc2FibGVkLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hcy1ncm91cC5odG1sI2Nmbi1hcy1ncm91cC1tZXRyaWNzY29sbGVjdGlvblxuICAgICAqL1xuICAgIHB1YmxpYyBtZXRyaWNzQ29sbGVjdGlvbjogQXJyYXk8Q2ZuQXV0b1NjYWxpbmdHcm91cC5NZXRyaWNzQ29sbGVjdGlvblByb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlPiB8IGNkay5JUmVzb2x2YWJsZSB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIEFuIGVtYmVkZGVkIG9iamVjdCB0aGF0IHNwZWNpZmllcyBhIG1peGVkIGluc3RhbmNlcyBwb2xpY3kuXG4gICAgICpcbiAgICAgKiBUaGUgcG9saWN5IGluY2x1ZGVzIHByb3BlcnRpZXMgdGhhdCBub3Qgb25seSBkZWZpbmUgdGhlIGRpc3RyaWJ1dGlvbiBvZiBPbi1EZW1hbmQgSW5zdGFuY2VzIGFuZCBTcG90IEluc3RhbmNlcywgdGhlIG1heGltdW0gcHJpY2UgdG8gcGF5IGZvciBTcG90IEluc3RhbmNlcyAob3B0aW9uYWwpLCBhbmQgaG93IHRoZSBBdXRvIFNjYWxpbmcgZ3JvdXAgYWxsb2NhdGVzIGluc3RhbmNlIHR5cGVzIHRvIGZ1bGZpbGwgT24tRGVtYW5kIGFuZCBTcG90IGNhcGFjaXRpZXMsIGJ1dCBhbHNvIHRoZSBwcm9wZXJ0aWVzIHRoYXQgc3BlY2lmeSB0aGUgaW5zdGFuY2UgY29uZmlndXJhdGlvbiBpbmZvcm1hdGlvbuKAlHRoZSBsYXVuY2ggdGVtcGxhdGUgYW5kIGluc3RhbmNlIHR5cGVzLiBUaGUgcG9saWN5IGNhbiBhbHNvIGluY2x1ZGUgYSB3ZWlnaHQgZm9yIGVhY2ggaW5zdGFuY2UgdHlwZSBhbmQgZGlmZmVyZW50IGxhdW5jaCB0ZW1wbGF0ZXMgZm9yIGluZGl2aWR1YWwgaW5zdGFuY2UgdHlwZXMuXG4gICAgICpcbiAgICAgKiBGb3IgbW9yZSBpbmZvcm1hdGlvbiwgc2VlIFtBdXRvIFNjYWxpbmcgZ3JvdXBzIHdpdGggbXVsdGlwbGUgaW5zdGFuY2UgdHlwZXMgYW5kIHB1cmNoYXNlIG9wdGlvbnNdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9hdXRvc2NhbGluZy9lYzIvdXNlcmd1aWRlL2VjMi1hdXRvLXNjYWxpbmctbWl4ZWQtaW5zdGFuY2VzLWdyb3Vwcy5odG1sKSBpbiB0aGUgKkFtYXpvbiBFQzIgQXV0byBTY2FsaW5nIFVzZXIgR3VpZGUqIC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXMtZ3JvdXAuaHRtbCNjZm4tYXMtZ3JvdXAtbWl4ZWRpbnN0YW5jZXNwb2xpY3lcbiAgICAgKi9cbiAgICBwdWJsaWMgbWl4ZWRJbnN0YW5jZXNQb2xpY3k6IENmbkF1dG9TY2FsaW5nR3JvdXAuTWl4ZWRJbnN0YW5jZXNQb2xpY3lQcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZSB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIEluZGljYXRlcyB3aGV0aGVyIG5ld2x5IGxhdW5jaGVkIGluc3RhbmNlcyBhcmUgcHJvdGVjdGVkIGZyb20gdGVybWluYXRpb24gYnkgQW1hem9uIEVDMiBBdXRvIFNjYWxpbmcgd2hlbiBzY2FsaW5nIGluLiBGb3IgbW9yZSBpbmZvcm1hdGlvbiBhYm91dCBwcmV2ZW50aW5nIGluc3RhbmNlcyBmcm9tIHRlcm1pbmF0aW5nIG9uIHNjYWxlIGluLCBzZWUgW1VzaW5nIGluc3RhbmNlIHNjYWxlLWluIHByb3RlY3Rpb25dKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9hdXRvc2NhbGluZy9lYzIvdXNlcmd1aWRlL2VjMi1hdXRvLXNjYWxpbmctaW5zdGFuY2UtcHJvdGVjdGlvbi5odG1sKSBpbiB0aGUgKkFtYXpvbiBFQzIgQXV0byBTY2FsaW5nIFVzZXIgR3VpZGUqIC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXMtZ3JvdXAuaHRtbCNjZm4tYXMtZ3JvdXAtbmV3aW5zdGFuY2VzcHJvdGVjdGVkZnJvbXNjYWxlaW5cbiAgICAgKi9cbiAgICBwdWJsaWMgbmV3SW5zdGFuY2VzUHJvdGVjdGVkRnJvbVNjYWxlSW46IGJvb2xlYW4gfCBjZGsuSVJlc29sdmFibGUgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBDb25maWd1cmVzIGFuIEF1dG8gU2NhbGluZyBncm91cCB0byBzZW5kIG5vdGlmaWNhdGlvbnMgd2hlbiBzcGVjaWZpZWQgZXZlbnRzIHRha2UgcGxhY2UuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWFzLWdyb3VwLmh0bWwjY2ZuLWFzLWdyb3VwLW5vdGlmaWNhdGlvbmNvbmZpZ3VyYXRpb25zXG4gICAgICovXG4gICAgcHVibGljIG5vdGlmaWNhdGlvbkNvbmZpZ3VyYXRpb25zOiBBcnJheTxDZm5BdXRvU2NhbGluZ0dyb3VwLk5vdGlmaWNhdGlvbkNvbmZpZ3VyYXRpb25Qcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZT4gfCBjZGsuSVJlc29sdmFibGUgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgbmFtZSBvZiB0aGUgcGxhY2VtZW50IGdyb3VwIGludG8gd2hpY2ggdG8gbGF1bmNoIHlvdXIgaW5zdGFuY2VzLiBGb3IgbW9yZSBpbmZvcm1hdGlvbiwgc2VlIFtQbGFjZW1lbnQgZ3JvdXBzXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTRUMyL2xhdGVzdC9Vc2VyR3VpZGUvcGxhY2VtZW50LWdyb3Vwcy5odG1sKSBpbiB0aGUgKkFtYXpvbiBFQzIgVXNlciBHdWlkZSBmb3IgTGludXggSW5zdGFuY2VzKiAuXG4gICAgICpcbiAgICAgKiA+IEEgKmNsdXN0ZXIqIHBsYWNlbWVudCBncm91cCBpcyBhIGxvZ2ljYWwgZ3JvdXBpbmcgb2YgaW5zdGFuY2VzIHdpdGhpbiBhIHNpbmdsZSBBdmFpbGFiaWxpdHkgWm9uZS4gWW91IGNhbm5vdCBzcGVjaWZ5IG11bHRpcGxlIEF2YWlsYWJpbGl0eSBab25lcyBhbmQgYSBjbHVzdGVyIHBsYWNlbWVudCBncm91cC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXMtZ3JvdXAuaHRtbCNjZm4tYXMtZ3JvdXAtcGxhY2VtZW50Z3JvdXBcbiAgICAgKi9cbiAgICBwdWJsaWMgcGxhY2VtZW50R3JvdXA6IHN0cmluZyB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIFRoZSBBbWF6b24gUmVzb3VyY2UgTmFtZSAoQVJOKSBvZiB0aGUgc2VydmljZS1saW5rZWQgcm9sZSB0aGF0IHRoZSBBdXRvIFNjYWxpbmcgZ3JvdXAgdXNlcyB0byBjYWxsIG90aGVyIEFXUyBzZXJ2aWNlIG9uIHlvdXIgYmVoYWxmLiBCeSBkZWZhdWx0LCBBbWF6b24gRUMyIEF1dG8gU2NhbGluZyB1c2VzIGEgc2VydmljZS1saW5rZWQgcm9sZSBuYW1lZCBgQVdTU2VydmljZVJvbGVGb3JBdXRvU2NhbGluZ2AgLCB3aGljaCBpdCBjcmVhdGVzIGlmIGl0IGRvZXMgbm90IGV4aXN0LiBGb3IgbW9yZSBpbmZvcm1hdGlvbiwgc2VlIFtTZXJ2aWNlLWxpbmtlZCByb2xlc10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2F1dG9zY2FsaW5nL2VjMi91c2VyZ3VpZGUvYXV0b3NjYWxpbmctc2VydmljZS1saW5rZWQtcm9sZS5odG1sKSBpbiB0aGUgKkFtYXpvbiBFQzIgQXV0byBTY2FsaW5nIFVzZXIgR3VpZGUqIC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXMtZ3JvdXAuaHRtbCNjZm4tYXV0b3NjYWxpbmctYXV0b3NjYWxpbmdncm91cC1zZXJ2aWNlbGlua2Vkcm9sZWFyblxuICAgICAqL1xuICAgIHB1YmxpYyBzZXJ2aWNlTGlua2VkUm9sZUFybjogc3RyaW5nIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogT25lIG9yIG1vcmUgdGFncy4gWW91IGNhbiB0YWcgeW91ciBBdXRvIFNjYWxpbmcgZ3JvdXAgYW5kIHByb3BhZ2F0ZSB0aGUgdGFncyB0byB0aGUgQW1hem9uIEVDMiBpbnN0YW5jZXMgaXQgbGF1bmNoZXMuIFRhZ3MgYXJlIG5vdCBwcm9wYWdhdGVkIHRvIEFtYXpvbiBFQlMgdm9sdW1lcy4gVG8gYWRkIHRhZ3MgdG8gQW1hem9uIEVCUyB2b2x1bWVzLCBzcGVjaWZ5IHRoZSB0YWdzIGluIGEgbGF1bmNoIHRlbXBsYXRlIGJ1dCB1c2UgY2F1dGlvbi4gSWYgdGhlIGxhdW5jaCB0ZW1wbGF0ZSBzcGVjaWZpZXMgYW4gaW5zdGFuY2UgdGFnIHdpdGggYSBrZXkgdGhhdCBpcyBhbHNvIHNwZWNpZmllZCBmb3IgdGhlIEF1dG8gU2NhbGluZyBncm91cCwgQW1hem9uIEVDMiBBdXRvIFNjYWxpbmcgb3ZlcnJpZGVzIHRoZSB2YWx1ZSBvZiB0aGF0IGluc3RhbmNlIHRhZyB3aXRoIHRoZSB2YWx1ZSBzcGVjaWZpZWQgYnkgdGhlIEF1dG8gU2NhbGluZyBncm91cC4gRm9yIG1vcmUgaW5mb3JtYXRpb24sIHNlZSBbVGFnIEF1dG8gU2NhbGluZyBncm91cHMgYW5kIGluc3RhbmNlc10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2F1dG9zY2FsaW5nL2VjMi91c2VyZ3VpZGUvZWMyLWF1dG8tc2NhbGluZy10YWdnaW5nLmh0bWwpIGluIHRoZSAqQW1hem9uIEVDMiBBdXRvIFNjYWxpbmcgVXNlciBHdWlkZSogLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hcy1ncm91cC5odG1sI2Nmbi1hcy1ncm91cC10YWdzXG4gICAgICovXG4gICAgcHVibGljIHJlYWRvbmx5IHRhZ3M6IGNkay5UYWdNYW5hZ2VyO1xuXG4gICAgLyoqXG4gICAgICogVGhlIEFtYXpvbiBSZXNvdXJjZSBOYW1lcyAoQVJOKSBvZiB0aGUgRWxhc3RpYyBMb2FkIEJhbGFuY2luZyB0YXJnZXQgZ3JvdXBzIHRvIGFzc29jaWF0ZSB3aXRoIHRoZSBBdXRvIFNjYWxpbmcgZ3JvdXAuIEluc3RhbmNlcyBhcmUgcmVnaXN0ZXJlZCBhcyB0YXJnZXRzIHdpdGggdGhlIHRhcmdldCBncm91cHMuIFRoZSB0YXJnZXQgZ3JvdXBzIHJlY2VpdmUgaW5jb21pbmcgdHJhZmZpYyBhbmQgcm91dGUgcmVxdWVzdHMgdG8gb25lIG9yIG1vcmUgcmVnaXN0ZXJlZCB0YXJnZXRzLiBGb3IgbW9yZSBpbmZvcm1hdGlvbiwgc2VlIFtVc2UgRWxhc3RpYyBMb2FkIEJhbGFuY2luZyB0byBkaXN0cmlidXRlIHRyYWZmaWMgYWNyb3NzIHRoZSBpbnN0YW5jZXMgaW4geW91ciBBdXRvIFNjYWxpbmcgZ3JvdXBdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9hdXRvc2NhbGluZy9lYzIvdXNlcmd1aWRlL2F1dG9zY2FsaW5nLWxvYWQtYmFsYW5jZXIuaHRtbCkgaW4gdGhlICpBbWF6b24gRUMyIEF1dG8gU2NhbGluZyBVc2VyIEd1aWRlKiAuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWFzLWdyb3VwLmh0bWwjY2ZuLWFzLWdyb3VwLXRhcmdldGdyb3VwYXJuc1xuICAgICAqL1xuICAgIHB1YmxpYyB0YXJnZXRHcm91cEFybnM6IHN0cmluZ1tdIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogQSBwb2xpY3kgb3IgYSBsaXN0IG9mIHBvbGljaWVzIHRoYXQgYXJlIHVzZWQgdG8gc2VsZWN0IHRoZSBpbnN0YW5jZSB0byB0ZXJtaW5hdGUuIFRoZXNlIHBvbGljaWVzIGFyZSBleGVjdXRlZCBpbiB0aGUgb3JkZXIgdGhhdCB5b3UgbGlzdCB0aGVtLiBGb3IgbW9yZSBpbmZvcm1hdGlvbiwgc2VlIFtXb3JrIHdpdGggQW1hem9uIEVDMiBBdXRvIFNjYWxpbmcgdGVybWluYXRpb24gcG9saWNpZXNdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9hdXRvc2NhbGluZy9lYzIvdXNlcmd1aWRlL2VjMi1hdXRvLXNjYWxpbmctdGVybWluYXRpb24tcG9saWNpZXMuaHRtbCkgaW4gdGhlICpBbWF6b24gRUMyIEF1dG8gU2NhbGluZyBVc2VyIEd1aWRlKiAuXG4gICAgICpcbiAgICAgKiBWYWxpZCB2YWx1ZXM6IGBEZWZhdWx0YCB8IGBBbGxvY2F0aW9uU3RyYXRlZ3lgIHwgYENsb3Nlc3RUb05leHRJbnN0YW5jZUhvdXJgIHwgYE5ld2VzdEluc3RhbmNlYCB8IGBPbGRlc3RJbnN0YW5jZWAgfCBgT2xkZXN0TGF1bmNoQ29uZmlndXJhdGlvbmAgfCBgT2xkZXN0TGF1bmNoVGVtcGxhdGVgIHwgYGFybjphd3M6bGFtYmRhOnJlZ2lvbjphY2NvdW50LWlkOmZ1bmN0aW9uOm15LWZ1bmN0aW9uOm15LWFsaWFzYFxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hcy1ncm91cC5odG1sI2Nmbi1hcy1ncm91cC10ZXJtcG9saWN5XG4gICAgICovXG4gICAgcHVibGljIHRlcm1pbmF0aW9uUG9saWNpZXM6IHN0cmluZ1tdIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogQSBsaXN0IG9mIHN1Ym5ldCBJRHMgZm9yIGEgdmlydHVhbCBwcml2YXRlIGNsb3VkIChWUEMpIHdoZXJlIGluc3RhbmNlcyBpbiB0aGUgQXV0byBTY2FsaW5nIGdyb3VwIGNhbiBiZSBjcmVhdGVkLlxuICAgICAqXG4gICAgICogSWYgdGhpcyByZXNvdXJjZSBzcGVjaWZpZXMgcHVibGljIHN1Ym5ldHMgYW5kIGlzIGFsc28gaW4gYSBWUEMgdGhhdCBpcyBkZWZpbmVkIGluIHRoZSBzYW1lIHN0YWNrIHRlbXBsYXRlLCB5b3UgbXVzdCB1c2UgdGhlIFtEZXBlbmRzT24gYXR0cmlidXRlXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtYXR0cmlidXRlLWRlcGVuZHNvbi5odG1sKSB0byBkZWNsYXJlIGEgZGVwZW5kZW5jeSBvbiB0aGUgW1ZQQy1nYXRld2F5IGF0dGFjaG1lbnRdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1lYzItdnBjLWdhdGV3YXktYXR0YWNobWVudC5odG1sKSAuXG4gICAgICpcbiAgICAgKiA+IFdoZW4geW91IHVwZGF0ZSBgVlBDWm9uZUlkZW50aWZpZXJgICwgdGhpcyByZXRhaW5zIHRoZSBzYW1lIEF1dG8gU2NhbGluZyBncm91cCBhbmQgcmVwbGFjZXMgb2xkIGluc3RhbmNlcyB3aXRoIG5ldyBvbmVzLCBhY2NvcmRpbmcgdG8gdGhlIHNwZWNpZmllZCBzdWJuZXRzLiBZb3UgY2FuIG9wdGlvbmFsbHkgc3BlY2lmeSBob3cgQ2xvdWRGb3JtYXRpb24gaGFuZGxlcyB0aGVzZSB1cGRhdGVzIGJ5IHVzaW5nIGFuIFtVcGRhdGVQb2xpY3kgYXR0cmlidXRlXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtYXR0cmlidXRlLXVwZGF0ZXBvbGljeS5odG1sKSAuXG4gICAgICpcbiAgICAgKiBSZXF1aXJlZCB0byBsYXVuY2ggaW5zdGFuY2VzIGludG8gYSBub25kZWZhdWx0IFZQQy4gSWYgeW91IHNwZWNpZnkgYFZQQ1pvbmVJZGVudGlmaWVyYCB3aXRoIGBBdmFpbGFiaWxpdHlab25lc2AgLCB0aGUgc3VibmV0cyB0aGF0IHlvdSBzcGVjaWZ5IGZvciB0aGlzIHByb3BlcnR5IG11c3QgcmVzaWRlIGluIHRob3NlIEF2YWlsYWJpbGl0eSBab25lcy5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXMtZ3JvdXAuaHRtbCNjZm4tYXMtZ3JvdXAtdnBjem9uZWlkZW50aWZpZXJcbiAgICAgKi9cbiAgICBwdWJsaWMgdnBjWm9uZUlkZW50aWZpZXI6IHN0cmluZ1tdIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogQ3JlYXRlIGEgbmV3IGBBV1M6OkF1dG9TY2FsaW5nOjpBdXRvU2NhbGluZ0dyb3VwYC5cbiAgICAgKlxuICAgICAqIEBwYXJhbSBzY29wZSAtIHNjb3BlIGluIHdoaWNoIHRoaXMgcmVzb3VyY2UgaXMgZGVmaW5lZFxuICAgICAqIEBwYXJhbSBpZCAgICAtIHNjb3BlZCBpZCBvZiB0aGUgcmVzb3VyY2VcbiAgICAgKiBAcGFyYW0gcHJvcHMgLSByZXNvdXJjZSBwcm9wZXJ0aWVzXG4gICAgICovXG4gICAgY29uc3RydWN0b3Ioc2NvcGU6IGNkay5Db25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBDZm5BdXRvU2NhbGluZ0dyb3VwUHJvcHMpIHtcbiAgICAgICAgc3VwZXIoc2NvcGUsIGlkLCB7IHR5cGU6IENmbkF1dG9TY2FsaW5nR3JvdXAuQ0ZOX1JFU09VUkNFX1RZUEVfTkFNRSwgcHJvcGVydGllczogcHJvcHMgfSk7XG4gICAgICAgIGNkay5yZXF1aXJlUHJvcGVydHkocHJvcHMsICdtYXhTaXplJywgdGhpcyk7XG4gICAgICAgIGNkay5yZXF1aXJlUHJvcGVydHkocHJvcHMsICdtaW5TaXplJywgdGhpcyk7XG5cbiAgICAgICAgdGhpcy5tYXhTaXplID0gcHJvcHMubWF4U2l6ZTtcbiAgICAgICAgdGhpcy5taW5TaXplID0gcHJvcHMubWluU2l6ZTtcbiAgICAgICAgdGhpcy5hdXRvU2NhbGluZ0dyb3VwTmFtZSA9IHByb3BzLmF1dG9TY2FsaW5nR3JvdXBOYW1lO1xuICAgICAgICB0aGlzLmF2YWlsYWJpbGl0eVpvbmVzID0gcHJvcHMuYXZhaWxhYmlsaXR5Wm9uZXM7XG4gICAgICAgIHRoaXMuY2FwYWNpdHlSZWJhbGFuY2UgPSBwcm9wcy5jYXBhY2l0eVJlYmFsYW5jZTtcbiAgICAgICAgdGhpcy5jb250ZXh0ID0gcHJvcHMuY29udGV4dDtcbiAgICAgICAgdGhpcy5jb29sZG93biA9IHByb3BzLmNvb2xkb3duO1xuICAgICAgICB0aGlzLmRlZmF1bHRJbnN0YW5jZVdhcm11cCA9IHByb3BzLmRlZmF1bHRJbnN0YW5jZVdhcm11cDtcbiAgICAgICAgdGhpcy5kZXNpcmVkQ2FwYWNpdHkgPSBwcm9wcy5kZXNpcmVkQ2FwYWNpdHk7XG4gICAgICAgIHRoaXMuZGVzaXJlZENhcGFjaXR5VHlwZSA9IHByb3BzLmRlc2lyZWRDYXBhY2l0eVR5cGU7XG4gICAgICAgIHRoaXMuaGVhbHRoQ2hlY2tHcmFjZVBlcmlvZCA9IHByb3BzLmhlYWx0aENoZWNrR3JhY2VQZXJpb2Q7XG4gICAgICAgIHRoaXMuaGVhbHRoQ2hlY2tUeXBlID0gcHJvcHMuaGVhbHRoQ2hlY2tUeXBlO1xuICAgICAgICB0aGlzLmluc3RhbmNlSWQgPSBwcm9wcy5pbnN0YW5jZUlkO1xuICAgICAgICB0aGlzLmxhdW5jaENvbmZpZ3VyYXRpb25OYW1lID0gcHJvcHMubGF1bmNoQ29uZmlndXJhdGlvbk5hbWU7XG4gICAgICAgIHRoaXMubGF1bmNoVGVtcGxhdGUgPSBwcm9wcy5sYXVuY2hUZW1wbGF0ZTtcbiAgICAgICAgdGhpcy5saWZlY3ljbGVIb29rU3BlY2lmaWNhdGlvbkxpc3QgPSBwcm9wcy5saWZlY3ljbGVIb29rU3BlY2lmaWNhdGlvbkxpc3Q7XG4gICAgICAgIHRoaXMubG9hZEJhbGFuY2VyTmFtZXMgPSBwcm9wcy5sb2FkQmFsYW5jZXJOYW1lcztcbiAgICAgICAgdGhpcy5tYXhJbnN0YW5jZUxpZmV0aW1lID0gcHJvcHMubWF4SW5zdGFuY2VMaWZldGltZTtcbiAgICAgICAgdGhpcy5tZXRyaWNzQ29sbGVjdGlvbiA9IHByb3BzLm1ldHJpY3NDb2xsZWN0aW9uO1xuICAgICAgICB0aGlzLm1peGVkSW5zdGFuY2VzUG9saWN5ID0gcHJvcHMubWl4ZWRJbnN0YW5jZXNQb2xpY3k7XG4gICAgICAgIHRoaXMubmV3SW5zdGFuY2VzUHJvdGVjdGVkRnJvbVNjYWxlSW4gPSBwcm9wcy5uZXdJbnN0YW5jZXNQcm90ZWN0ZWRGcm9tU2NhbGVJbjtcbiAgICAgICAgdGhpcy5ub3RpZmljYXRpb25Db25maWd1cmF0aW9ucyA9IHByb3BzLm5vdGlmaWNhdGlvbkNvbmZpZ3VyYXRpb25zO1xuICAgICAgICB0aGlzLnBsYWNlbWVudEdyb3VwID0gcHJvcHMucGxhY2VtZW50R3JvdXA7XG4gICAgICAgIHRoaXMuc2VydmljZUxpbmtlZFJvbGVBcm4gPSBwcm9wcy5zZXJ2aWNlTGlua2VkUm9sZUFybjtcbiAgICAgICAgdGhpcy50YWdzID0gbmV3IGNkay5UYWdNYW5hZ2VyKGNkay5UYWdUeXBlLkFVVE9TQ0FMSU5HX0dST1VQLCBcIkFXUzo6QXV0b1NjYWxpbmc6OkF1dG9TY2FsaW5nR3JvdXBcIiwgcHJvcHMudGFncywgeyB0YWdQcm9wZXJ0eU5hbWU6ICd0YWdzJyB9KTtcbiAgICAgICAgdGhpcy50YXJnZXRHcm91cEFybnMgPSBwcm9wcy50YXJnZXRHcm91cEFybnM7XG4gICAgICAgIHRoaXMudGVybWluYXRpb25Qb2xpY2llcyA9IHByb3BzLnRlcm1pbmF0aW9uUG9saWNpZXM7XG4gICAgICAgIHRoaXMudnBjWm9uZUlkZW50aWZpZXIgPSBwcm9wcy52cGNab25lSWRlbnRpZmllcjtcbiAgICB9XG5cbiAgICAvKipcbiAgICAgKiBFeGFtaW5lcyB0aGUgQ2xvdWRGb3JtYXRpb24gcmVzb3VyY2UgYW5kIGRpc2Nsb3NlcyBhdHRyaWJ1dGVzLlxuICAgICAqXG4gICAgICogQHBhcmFtIGluc3BlY3RvciAtIHRyZWUgaW5zcGVjdG9yIHRvIGNvbGxlY3QgYW5kIHByb2Nlc3MgYXR0cmlidXRlc1xuICAgICAqXG4gICAgICovXG4gICAgcHVibGljIGluc3BlY3QoaW5zcGVjdG9yOiBjZGsuVHJlZUluc3BlY3Rvcikge1xuICAgICAgICBpbnNwZWN0b3IuYWRkQXR0cmlidXRlKFwiYXdzOmNkazpjbG91ZGZvcm1hdGlvbjp0eXBlXCIsIENmbkF1dG9TY2FsaW5nR3JvdXAuQ0ZOX1JFU09VUkNFX1RZUEVfTkFNRSk7XG4gICAgICAgIGluc3BlY3Rvci5hZGRBdHRyaWJ1dGUoXCJhd3M6Y2RrOmNsb3VkZm9ybWF0aW9uOnByb3BzXCIsIHRoaXMuY2ZuUHJvcGVydGllcyk7XG4gICAgfVxuXG4gICAgcHJvdGVjdGVkIGdldCBjZm5Qcm9wZXJ0aWVzKCk6IHsgW2tleTogc3RyaW5nXTogYW55IH0gIHtcbiAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICAgIG1heFNpemU6IHRoaXMubWF4U2l6ZSxcbiAgICAgICAgICAgIG1pblNpemU6IHRoaXMubWluU2l6ZSxcbiAgICAgICAgICAgIGF1dG9TY2FsaW5nR3JvdXBOYW1lOiB0aGlzLmF1dG9TY2FsaW5nR3JvdXBOYW1lLFxuICAgICAgICAgICAgYXZhaWxhYmlsaXR5Wm9uZXM6IHRoaXMuYXZhaWxhYmlsaXR5Wm9uZXMsXG4gICAgICAgICAgICBjYXBhY2l0eVJlYmFsYW5jZTogdGhpcy5jYXBhY2l0eVJlYmFsYW5jZSxcbiAgICAgICAgICAgIGNvbnRleHQ6IHRoaXMuY29udGV4dCxcbiAgICAgICAgICAgIGNvb2xkb3duOiB0aGlzLmNvb2xkb3duLFxuICAgICAgICAgICAgZGVmYXVsdEluc3RhbmNlV2FybXVwOiB0aGlzLmRlZmF1bHRJbnN0YW5jZVdhcm11cCxcbiAgICAgICAgICAgIGRlc2lyZWRDYXBhY2l0eTogdGhpcy5kZXNpcmVkQ2FwYWNpdHksXG4gICAgICAgICAgICBkZXNpcmVkQ2FwYWNpdHlUeXBlOiB0aGlzLmRlc2lyZWRDYXBhY2l0eVR5cGUsXG4gICAgICAgICAgICBoZWFsdGhDaGVja0dyYWNlUGVyaW9kOiB0aGlzLmhlYWx0aENoZWNrR3JhY2VQZXJpb2QsXG4gICAgICAgICAgICBoZWFsdGhDaGVja1R5cGU6IHRoaXMuaGVhbHRoQ2hlY2tUeXBlLFxuICAgICAgICAgICAgaW5zdGFuY2VJZDogdGhpcy5pbnN0YW5jZUlkLFxuICAgICAgICAgICAgbGF1bmNoQ29uZmlndXJhdGlvbk5hbWU6IHRoaXMubGF1bmNoQ29uZmlndXJhdGlvbk5hbWUsXG4gICAgICAgICAgICBsYXVuY2hUZW1wbGF0ZTogdGhpcy5sYXVuY2hUZW1wbGF0ZSxcbiAgICAgICAgICAgIGxpZmVjeWNsZUhvb2tTcGVjaWZpY2F0aW9uTGlzdDogdGhpcy5saWZlY3ljbGVIb29rU3BlY2lmaWNhdGlvbkxpc3QsXG4gICAgICAgICAgICBsb2FkQmFsYW5jZXJOYW1lczogdGhpcy5sb2FkQmFsYW5jZXJOYW1lcyxcbiAgICAgICAgICAgIG1heEluc3RhbmNlTGlmZXRpbWU6IHRoaXMubWF4SW5zdGFuY2VMaWZldGltZSxcbiAgICAgICAgICAgIG1ldHJpY3NDb2xsZWN0aW9uOiB0aGlzLm1ldHJpY3NDb2xsZWN0aW9uLFxuICAgICAgICAgICAgbWl4ZWRJbnN0YW5jZXNQb2xpY3k6IHRoaXMubWl4ZWRJbnN0YW5jZXNQb2xpY3ksXG4gICAgICAgICAgICBuZXdJbnN0YW5jZXNQcm90ZWN0ZWRGcm9tU2NhbGVJbjogdGhpcy5uZXdJbnN0YW5jZXNQcm90ZWN0ZWRGcm9tU2NhbGVJbixcbiAgICAgICAgICAgIG5vdGlmaWNhdGlvbkNvbmZpZ3VyYXRpb25zOiB0aGlzLm5vdGlmaWNhdGlvbkNvbmZpZ3VyYXRpb25zLFxuICAgICAgICAgICAgcGxhY2VtZW50R3JvdXA6IHRoaXMucGxhY2VtZW50R3JvdXAsXG4gICAgICAgICAgICBzZXJ2aWNlTGlua2VkUm9sZUFybjogdGhpcy5zZXJ2aWNlTGlua2VkUm9sZUFybixcbiAgICAgICAgICAgIHRhZ3M6IHRoaXMudGFncy5yZW5kZXJUYWdzKCksXG4gICAgICAgICAgICB0YXJnZXRHcm91cEFybnM6IHRoaXMudGFyZ2V0R3JvdXBBcm5zLFxuICAgICAgICAgICAgdGVybWluYXRpb25Qb2xpY2llczogdGhpcy50ZXJtaW5hdGlvblBvbGljaWVzLFxuICAgICAgICAgICAgdnBjWm9uZUlkZW50aWZpZXI6IHRoaXMudnBjWm9uZUlkZW50aWZpZXIsXG4gICAgICAgIH07XG4gICAgfVxuXG4gICAgcHJvdGVjdGVkIHJlbmRlclByb3BlcnRpZXMocHJvcHM6IHtba2V5OiBzdHJpbmddOiBhbnl9KTogeyBba2V5OiBzdHJpbmddOiBhbnkgfSAge1xuICAgICAgICByZXR1cm4gY2ZuQXV0b1NjYWxpbmdHcm91cFByb3BzVG9DbG91ZEZvcm1hdGlvbihwcm9wcyk7XG4gICAgfVxufVxuXG5leHBvcnQgbmFtZXNwYWNlIENmbkF1dG9TY2FsaW5nR3JvdXAge1xuICAgIC8qKlxuICAgICAqIGBBY2NlbGVyYXRvckNvdW50UmVxdWVzdGAgaXMgYSBwcm9wZXJ0eSBvZiB0aGUgYEluc3RhbmNlUmVxdWlyZW1lbnRzYCBwcm9wZXJ0eSBvZiB0aGUgW0FXUzo6QXV0b1NjYWxpbmc6OkF1dG9TY2FsaW5nR3JvdXAgTGF1bmNoVGVtcGxhdGVPdmVycmlkZXNdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWF1dG9zY2FsaW5nLWF1dG9zY2FsaW5nZ3JvdXAtbGF1bmNodGVtcGxhdGVvdmVycmlkZXMuaHRtbCkgcHJvcGVydHkgdHlwZSB0aGF0IGRlc2NyaWJlcyB0aGUgbWluaW11bSBhbmQgbWF4aW11bSBudW1iZXIgb2YgYWNjZWxlcmF0b3JzIGZvciBhbiBpbnN0YW5jZSB0eXBlLlxuICAgICAqXG4gICAgICogQHN0cnVjdFxuICAgICAqIEBzdGFiaWxpdHkgZXh0ZXJuYWxcbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXV0b3NjYWxpbmctYXV0b3NjYWxpbmdncm91cC1hY2NlbGVyYXRvcmNvdW50cmVxdWVzdC5odG1sXG4gICAgICovXG4gICAgZXhwb3J0IGludGVyZmFjZSBBY2NlbGVyYXRvckNvdW50UmVxdWVzdFByb3BlcnR5IHtcbiAgICAgICAgLyoqXG4gICAgICAgICAqIFRoZSBtYXhpbXVtIHZhbHVlLlxuICAgICAgICAgKlxuICAgICAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWF1dG9zY2FsaW5nLWF1dG9zY2FsaW5nZ3JvdXAtYWNjZWxlcmF0b3Jjb3VudHJlcXVlc3QuaHRtbCNjZm4tYXV0b3NjYWxpbmctYXV0b3NjYWxpbmdncm91cC1hY2NlbGVyYXRvcmNvdW50cmVxdWVzdC1tYXhcbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IG1heD86IG51bWJlcjtcbiAgICAgICAgLyoqXG4gICAgICAgICAqIFRoZSBtaW5pbXVtIHZhbHVlLlxuICAgICAgICAgKlxuICAgICAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWF1dG9zY2FsaW5nLWF1dG9zY2FsaW5nZ3JvdXAtYWNjZWxlcmF0b3Jjb3VudHJlcXVlc3QuaHRtbCNjZm4tYXV0b3NjYWxpbmctYXV0b3NjYWxpbmdncm91cC1hY2NlbGVyYXRvcmNvdW50cmVxdWVzdC1taW5cbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IG1pbj86IG51bWJlcjtcbiAgICB9XG59XG5cbi8qKlxuICogRGV0ZXJtaW5lIHdoZXRoZXIgdGhlIGdpdmVuIHByb3BlcnRpZXMgbWF0Y2ggdGhvc2Ugb2YgYSBgQWNjZWxlcmF0b3JDb3VudFJlcXVlc3RQcm9wZXJ0eWBcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgQWNjZWxlcmF0b3JDb3VudFJlcXVlc3RQcm9wZXJ0eWBcbiAqXG4gKiBAcmV0dXJucyB0aGUgcmVzdWx0IG9mIHRoZSB2YWxpZGF0aW9uLlxuICovXG5mdW5jdGlvbiBDZm5BdXRvU2NhbGluZ0dyb3VwX0FjY2VsZXJhdG9yQ291bnRSZXF1ZXN0UHJvcGVydHlWYWxpZGF0b3IocHJvcGVydGllczogYW55KTogY2RrLlZhbGlkYXRpb25SZXN1bHQge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIGNkay5WQUxJREFUSU9OX1NVQ0NFU1M7IH1cbiAgICBjb25zdCBlcnJvcnMgPSBuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHRzKCk7XG4gICAgaWYgKHR5cGVvZiBwcm9wZXJ0aWVzICE9PSAnb2JqZWN0Jykge1xuICAgICAgICBlcnJvcnMuY29sbGVjdChuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHQoJ0V4cGVjdGVkIGFuIG9iamVjdCwgYnV0IHJlY2VpdmVkOiAnICsgSlNPTi5zdHJpbmdpZnkocHJvcGVydGllcykpKTtcbiAgICB9XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdtYXgnLCBjZGsudmFsaWRhdGVOdW1iZXIpKHByb3BlcnRpZXMubWF4KSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdtaW4nLCBjZGsudmFsaWRhdGVOdW1iZXIpKHByb3BlcnRpZXMubWluKSk7XG4gICAgcmV0dXJuIGVycm9ycy53cmFwKCdzdXBwbGllZCBwcm9wZXJ0aWVzIG5vdCBjb3JyZWN0IGZvciBcIkFjY2VsZXJhdG9yQ291bnRSZXF1ZXN0UHJvcGVydHlcIicpO1xufVxuXG4vKipcbiAqIFJlbmRlcnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OkF1dG9TY2FsaW5nOjpBdXRvU2NhbGluZ0dyb3VwLkFjY2VsZXJhdG9yQ291bnRSZXF1ZXN0YCByZXNvdXJjZVxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBBY2NlbGVyYXRvckNvdW50UmVxdWVzdFByb3BlcnR5YFxuICpcbiAqIEByZXR1cm5zIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpBdXRvU2NhbGluZzo6QXV0b1NjYWxpbmdHcm91cC5BY2NlbGVyYXRvckNvdW50UmVxdWVzdGAgcmVzb3VyY2UuXG4gKi9cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBjZm5BdXRvU2NhbGluZ0dyb3VwQWNjZWxlcmF0b3JDb3VudFJlcXVlc3RQcm9wZXJ0eVRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogYW55IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBwcm9wZXJ0aWVzOyB9XG4gICAgQ2ZuQXV0b1NjYWxpbmdHcm91cF9BY2NlbGVyYXRvckNvdW50UmVxdWVzdFByb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXMpLmFzc2VydFN1Y2Nlc3MoKTtcbiAgICByZXR1cm4ge1xuICAgICAgICBNYXg6IGNkay5udW1iZXJUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMubWF4KSxcbiAgICAgICAgTWluOiBjZGsubnVtYmVyVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLm1pbiksXG4gICAgfTtcbn1cblxuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIENmbkF1dG9TY2FsaW5nR3JvdXBBY2NlbGVyYXRvckNvdW50UmVxdWVzdFByb3BlcnR5RnJvbUNsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQ8Q2ZuQXV0b1NjYWxpbmdHcm91cC5BY2NlbGVyYXRvckNvdW50UmVxdWVzdFByb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlPiB7XG4gICAgaWYgKGNkay5pc1Jlc29sdmFibGVPYmplY3QocHJvcGVydGllcykpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0KHByb3BlcnRpZXMpO1xuICAgIH1cbiAgICBwcm9wZXJ0aWVzID0gcHJvcGVydGllcyA9PSBudWxsID8ge30gOiBwcm9wZXJ0aWVzO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0KHByb3BlcnRpZXMpO1xuICAgIH1cbiAgICBjb25zdCByZXQgPSBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblByb3BlcnR5T2JqZWN0PENmbkF1dG9TY2FsaW5nR3JvdXAuQWNjZWxlcmF0b3JDb3VudFJlcXVlc3RQcm9wZXJ0eT4oKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ21heCcsICdNYXgnLCBwcm9wZXJ0aWVzLk1heCAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXROdW1iZXIocHJvcGVydGllcy5NYXgpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ21pbicsICdNaW4nLCBwcm9wZXJ0aWVzLk1pbiAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXROdW1iZXIocHJvcGVydGllcy5NaW4pIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkVW5yZWNvZ25pemVkUHJvcGVydGllc0FzRXh0cmEocHJvcGVydGllcyk7XG4gICAgcmV0dXJuIHJldDtcbn1cblxuZXhwb3J0IG5hbWVzcGFjZSBDZm5BdXRvU2NhbGluZ0dyb3VwIHtcbiAgICAvKipcbiAgICAgKiBgQWNjZWxlcmF0b3JUb3RhbE1lbW9yeU1pQlJlcXVlc3RgIGlzIGEgcHJvcGVydHkgb2YgdGhlIGBJbnN0YW5jZVJlcXVpcmVtZW50c2AgcHJvcGVydHkgb2YgdGhlIFtBV1M6OkF1dG9TY2FsaW5nOjpBdXRvU2NhbGluZ0dyb3VwIExhdW5jaFRlbXBsYXRlT3ZlcnJpZGVzXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hdXRvc2NhbGluZy1hdXRvc2NhbGluZ2dyb3VwLWxhdW5jaHRlbXBsYXRlb3ZlcnJpZGVzLmh0bWwpIHByb3BlcnR5IHR5cGUgdGhhdCBkZXNjcmliZXMgdGhlIG1pbmltdW0gYW5kIG1heGltdW0gdG90YWwgbWVtb3J5IHNpemUgZm9yIHRoZSBhY2NlbGVyYXRvcnMgZm9yIGFuIGluc3RhbmNlIHR5cGUsIGluIE1pQi5cbiAgICAgKlxuICAgICAqIEBzdHJ1Y3RcbiAgICAgKiBAc3RhYmlsaXR5IGV4dGVybmFsXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWF1dG9zY2FsaW5nLWF1dG9zY2FsaW5nZ3JvdXAtYWNjZWxlcmF0b3J0b3RhbG1lbW9yeW1pYnJlcXVlc3QuaHRtbFxuICAgICAqL1xuICAgIGV4cG9ydCBpbnRlcmZhY2UgQWNjZWxlcmF0b3JUb3RhbE1lbW9yeU1pQlJlcXVlc3RQcm9wZXJ0eSB7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBUaGUgbWVtb3J5IG1heGltdW0gaW4gTWlCLlxuICAgICAgICAgKlxuICAgICAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWF1dG9zY2FsaW5nLWF1dG9zY2FsaW5nZ3JvdXAtYWNjZWxlcmF0b3J0b3RhbG1lbW9yeW1pYnJlcXVlc3QuaHRtbCNjZm4tYXV0b3NjYWxpbmctYXV0b3NjYWxpbmdncm91cC1hY2NlbGVyYXRvcnRvdGFsbWVtb3J5bWlicmVxdWVzdC1tYXhcbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IG1heD86IG51bWJlcjtcbiAgICAgICAgLyoqXG4gICAgICAgICAqIFRoZSBtZW1vcnkgbWluaW11bSBpbiBNaUIuXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXV0b3NjYWxpbmctYXV0b3NjYWxpbmdncm91cC1hY2NlbGVyYXRvcnRvdGFsbWVtb3J5bWlicmVxdWVzdC5odG1sI2Nmbi1hdXRvc2NhbGluZy1hdXRvc2NhbGluZ2dyb3VwLWFjY2VsZXJhdG9ydG90YWxtZW1vcnltaWJyZXF1ZXN0LW1pblxuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgbWluPzogbnVtYmVyO1xuICAgIH1cbn1cblxuLyoqXG4gKiBEZXRlcm1pbmUgd2hldGhlciB0aGUgZ2l2ZW4gcHJvcGVydGllcyBtYXRjaCB0aG9zZSBvZiBhIGBBY2NlbGVyYXRvclRvdGFsTWVtb3J5TWlCUmVxdWVzdFByb3BlcnR5YFxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBBY2NlbGVyYXRvclRvdGFsTWVtb3J5TWlCUmVxdWVzdFByb3BlcnR5YFxuICpcbiAqIEByZXR1cm5zIHRoZSByZXN1bHQgb2YgdGhlIHZhbGlkYXRpb24uXG4gKi9cbmZ1bmN0aW9uIENmbkF1dG9TY2FsaW5nR3JvdXBfQWNjZWxlcmF0b3JUb3RhbE1lbW9yeU1pQlJlcXVlc3RQcm9wZXJ0eVZhbGlkYXRvcihwcm9wZXJ0aWVzOiBhbnkpOiBjZGsuVmFsaWRhdGlvblJlc3VsdCB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gY2RrLlZBTElEQVRJT05fU1VDQ0VTUzsgfVxuICAgIGNvbnN0IGVycm9ycyA9IG5ldyBjZGsuVmFsaWRhdGlvblJlc3VsdHMoKTtcbiAgICBpZiAodHlwZW9mIHByb3BlcnRpZXMgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIGVycm9ycy5jb2xsZWN0KG5ldyBjZGsuVmFsaWRhdGlvblJlc3VsdCgnRXhwZWN0ZWQgYW4gb2JqZWN0LCBidXQgcmVjZWl2ZWQ6ICcgKyBKU09OLnN0cmluZ2lmeShwcm9wZXJ0aWVzKSkpO1xuICAgIH1cbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ21heCcsIGNkay52YWxpZGF0ZU51bWJlcikocHJvcGVydGllcy5tYXgpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ21pbicsIGNkay52YWxpZGF0ZU51bWJlcikocHJvcGVydGllcy5taW4pKTtcbiAgICByZXR1cm4gZXJyb3JzLndyYXAoJ3N1cHBsaWVkIHByb3BlcnRpZXMgbm90IGNvcnJlY3QgZm9yIFwiQWNjZWxlcmF0b3JUb3RhbE1lbW9yeU1pQlJlcXVlc3RQcm9wZXJ0eVwiJyk7XG59XG5cbi8qKlxuICogUmVuZGVycyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6QXV0b1NjYWxpbmc6OkF1dG9TY2FsaW5nR3JvdXAuQWNjZWxlcmF0b3JUb3RhbE1lbW9yeU1pQlJlcXVlc3RgIHJlc291cmNlXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYEFjY2VsZXJhdG9yVG90YWxNZW1vcnlNaUJSZXF1ZXN0UHJvcGVydHlgXG4gKlxuICogQHJldHVybnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OkF1dG9TY2FsaW5nOjpBdXRvU2NhbGluZ0dyb3VwLkFjY2VsZXJhdG9yVG90YWxNZW1vcnlNaUJSZXF1ZXN0YCByZXNvdXJjZS5cbiAqL1xuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIGNmbkF1dG9TY2FsaW5nR3JvdXBBY2NlbGVyYXRvclRvdGFsTWVtb3J5TWlCUmVxdWVzdFByb3BlcnR5VG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBhbnkge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIHByb3BlcnRpZXM7IH1cbiAgICBDZm5BdXRvU2NhbGluZ0dyb3VwX0FjY2VsZXJhdG9yVG90YWxNZW1vcnlNaUJSZXF1ZXN0UHJvcGVydHlWYWxpZGF0b3IocHJvcGVydGllcykuYXNzZXJ0U3VjY2VzcygpO1xuICAgIHJldHVybiB7XG4gICAgICAgIE1heDogY2RrLm51bWJlclRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5tYXgpLFxuICAgICAgICBNaW46IGNkay5udW1iZXJUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMubWluKSxcbiAgICB9O1xufVxuXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gQ2ZuQXV0b1NjYWxpbmdHcm91cEFjY2VsZXJhdG9yVG90YWxNZW1vcnlNaUJSZXF1ZXN0UHJvcGVydHlGcm9tQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdDxDZm5BdXRvU2NhbGluZ0dyb3VwLkFjY2VsZXJhdG9yVG90YWxNZW1vcnlNaUJSZXF1ZXN0UHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGU+IHtcbiAgICBpZiAoY2RrLmlzUmVzb2x2YWJsZU9iamVjdChwcm9wZXJ0aWVzKSkge1xuICAgICAgICByZXR1cm4gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQocHJvcGVydGllcyk7XG4gICAgfVxuICAgIHByb3BlcnRpZXMgPSBwcm9wZXJ0aWVzID09IG51bGwgPyB7fSA6IHByb3BlcnRpZXM7XG4gICAgaWYgKHR5cGVvZiBwcm9wZXJ0aWVzICE9PSAnb2JqZWN0Jykge1xuICAgICAgICByZXR1cm4gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQocHJvcGVydGllcyk7XG4gICAgfVxuICAgIGNvbnN0IHJldCA9IG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUHJvcGVydHlPYmplY3Q8Q2ZuQXV0b1NjYWxpbmdHcm91cC5BY2NlbGVyYXRvclRvdGFsTWVtb3J5TWlCUmVxdWVzdFByb3BlcnR5PigpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnbWF4JywgJ01heCcsIHByb3BlcnRpZXMuTWF4ICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldE51bWJlcihwcm9wZXJ0aWVzLk1heCkgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnbWluJywgJ01pbicsIHByb3BlcnRpZXMuTWluICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldE51bWJlcihwcm9wZXJ0aWVzLk1pbikgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRVbnJlY29nbml6ZWRQcm9wZXJ0aWVzQXNFeHRyYShwcm9wZXJ0aWVzKTtcbiAgICByZXR1cm4gcmV0O1xufVxuXG5leHBvcnQgbmFtZXNwYWNlIENmbkF1dG9TY2FsaW5nR3JvdXAge1xuICAgIC8qKlxuICAgICAqIGBCYXNlbGluZUVic0JhbmR3aWR0aE1icHNSZXF1ZXN0YCBpcyBhIHByb3BlcnR5IG9mIHRoZSBgSW5zdGFuY2VSZXF1aXJlbWVudHNgIHByb3BlcnR5IG9mIHRoZSBbQVdTOjpBdXRvU2NhbGluZzo6QXV0b1NjYWxpbmdHcm91cCBMYXVuY2hUZW1wbGF0ZU92ZXJyaWRlc10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXV0b3NjYWxpbmctYXV0b3NjYWxpbmdncm91cC1sYXVuY2h0ZW1wbGF0ZW92ZXJyaWRlcy5odG1sKSBwcm9wZXJ0eSB0eXBlIHRoYXQgZGVzY3JpYmVzIHRoZSBtaW5pbXVtIGFuZCBtYXhpbXVtIGJhc2VsaW5lIGJhbmR3aWR0aCBwZXJmb3JtYW5jZSBmb3IgYW4gaW5zdGFuY2UgdHlwZSwgaW4gTWJwcy5cbiAgICAgKlxuICAgICAqIEBzdHJ1Y3RcbiAgICAgKiBAc3RhYmlsaXR5IGV4dGVybmFsXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWF1dG9zY2FsaW5nLWF1dG9zY2FsaW5nZ3JvdXAtYmFzZWxpbmVlYnNiYW5kd2lkdGhtYnBzcmVxdWVzdC5odG1sXG4gICAgICovXG4gICAgZXhwb3J0IGludGVyZmFjZSBCYXNlbGluZUVic0JhbmR3aWR0aE1icHNSZXF1ZXN0UHJvcGVydHkge1xuICAgICAgICAvKipcbiAgICAgICAgICogVGhlIG1heGltdW0gdmFsdWUgaW4gTWJwcy5cbiAgICAgICAgICpcbiAgICAgICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hdXRvc2NhbGluZy1hdXRvc2NhbGluZ2dyb3VwLWJhc2VsaW5lZWJzYmFuZHdpZHRobWJwc3JlcXVlc3QuaHRtbCNjZm4tYXV0b3NjYWxpbmctYXV0b3NjYWxpbmdncm91cC1iYXNlbGluZWVic2JhbmR3aWR0aG1icHNyZXF1ZXN0LW1heFxuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgbWF4PzogbnVtYmVyO1xuICAgICAgICAvKipcbiAgICAgICAgICogVGhlIG1pbmltdW0gdmFsdWUgaW4gTWJwcy5cbiAgICAgICAgICpcbiAgICAgICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hdXRvc2NhbGluZy1hdXRvc2NhbGluZ2dyb3VwLWJhc2VsaW5lZWJzYmFuZHdpZHRobWJwc3JlcXVlc3QuaHRtbCNjZm4tYXV0b3NjYWxpbmctYXV0b3NjYWxpbmdncm91cC1iYXNlbGluZWVic2JhbmR3aWR0aG1icHNyZXF1ZXN0LW1pblxuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgbWluPzogbnVtYmVyO1xuICAgIH1cbn1cblxuLyoqXG4gKiBEZXRlcm1pbmUgd2hldGhlciB0aGUgZ2l2ZW4gcHJvcGVydGllcyBtYXRjaCB0aG9zZSBvZiBhIGBCYXNlbGluZUVic0JhbmR3aWR0aE1icHNSZXF1ZXN0UHJvcGVydHlgXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYEJhc2VsaW5lRWJzQmFuZHdpZHRoTWJwc1JlcXVlc3RQcm9wZXJ0eWBcbiAqXG4gKiBAcmV0dXJucyB0aGUgcmVzdWx0IG9mIHRoZSB2YWxpZGF0aW9uLlxuICovXG5mdW5jdGlvbiBDZm5BdXRvU2NhbGluZ0dyb3VwX0Jhc2VsaW5lRWJzQmFuZHdpZHRoTWJwc1JlcXVlc3RQcm9wZXJ0eVZhbGlkYXRvcihwcm9wZXJ0aWVzOiBhbnkpOiBjZGsuVmFsaWRhdGlvblJlc3VsdCB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gY2RrLlZBTElEQVRJT05fU1VDQ0VTUzsgfVxuICAgIGNvbnN0IGVycm9ycyA9IG5ldyBjZGsuVmFsaWRhdGlvblJlc3VsdHMoKTtcbiAgICBpZiAodHlwZW9mIHByb3BlcnRpZXMgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIGVycm9ycy5jb2xsZWN0KG5ldyBjZGsuVmFsaWRhdGlvblJlc3VsdCgnRXhwZWN0ZWQgYW4gb2JqZWN0LCBidXQgcmVjZWl2ZWQ6ICcgKyBKU09OLnN0cmluZ2lmeShwcm9wZXJ0aWVzKSkpO1xuICAgIH1cbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ21heCcsIGNkay52YWxpZGF0ZU51bWJlcikocHJvcGVydGllcy5tYXgpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ21pbicsIGNkay52YWxpZGF0ZU51bWJlcikocHJvcGVydGllcy5taW4pKTtcbiAgICByZXR1cm4gZXJyb3JzLndyYXAoJ3N1cHBsaWVkIHByb3BlcnRpZXMgbm90IGNvcnJlY3QgZm9yIFwiQmFzZWxpbmVFYnNCYW5kd2lkdGhNYnBzUmVxdWVzdFByb3BlcnR5XCInKTtcbn1cblxuLyoqXG4gKiBSZW5kZXJzIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpBdXRvU2NhbGluZzo6QXV0b1NjYWxpbmdHcm91cC5CYXNlbGluZUVic0JhbmR3aWR0aE1icHNSZXF1ZXN0YCByZXNvdXJjZVxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBCYXNlbGluZUVic0JhbmR3aWR0aE1icHNSZXF1ZXN0UHJvcGVydHlgXG4gKlxuICogQHJldHVybnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OkF1dG9TY2FsaW5nOjpBdXRvU2NhbGluZ0dyb3VwLkJhc2VsaW5lRWJzQmFuZHdpZHRoTWJwc1JlcXVlc3RgIHJlc291cmNlLlxuICovXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gY2ZuQXV0b1NjYWxpbmdHcm91cEJhc2VsaW5lRWJzQmFuZHdpZHRoTWJwc1JlcXVlc3RQcm9wZXJ0eVRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogYW55IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBwcm9wZXJ0aWVzOyB9XG4gICAgQ2ZuQXV0b1NjYWxpbmdHcm91cF9CYXNlbGluZUVic0JhbmR3aWR0aE1icHNSZXF1ZXN0UHJvcGVydHlWYWxpZGF0b3IocHJvcGVydGllcykuYXNzZXJ0U3VjY2VzcygpO1xuICAgIHJldHVybiB7XG4gICAgICAgIE1heDogY2RrLm51bWJlclRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5tYXgpLFxuICAgICAgICBNaW46IGNkay5udW1iZXJUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMubWluKSxcbiAgICB9O1xufVxuXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gQ2ZuQXV0b1NjYWxpbmdHcm91cEJhc2VsaW5lRWJzQmFuZHdpZHRoTWJwc1JlcXVlc3RQcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0PENmbkF1dG9TY2FsaW5nR3JvdXAuQmFzZWxpbmVFYnNCYW5kd2lkdGhNYnBzUmVxdWVzdFByb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlPiB7XG4gICAgaWYgKGNkay5pc1Jlc29sdmFibGVPYmplY3QocHJvcGVydGllcykpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0KHByb3BlcnRpZXMpO1xuICAgIH1cbiAgICBwcm9wZXJ0aWVzID0gcHJvcGVydGllcyA9PSBudWxsID8ge30gOiBwcm9wZXJ0aWVzO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0KHByb3BlcnRpZXMpO1xuICAgIH1cbiAgICBjb25zdCByZXQgPSBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblByb3BlcnR5T2JqZWN0PENmbkF1dG9TY2FsaW5nR3JvdXAuQmFzZWxpbmVFYnNCYW5kd2lkdGhNYnBzUmVxdWVzdFByb3BlcnR5PigpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnbWF4JywgJ01heCcsIHByb3BlcnRpZXMuTWF4ICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldE51bWJlcihwcm9wZXJ0aWVzLk1heCkgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnbWluJywgJ01pbicsIHByb3BlcnRpZXMuTWluICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldE51bWJlcihwcm9wZXJ0aWVzLk1pbikgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRVbnJlY29nbml6ZWRQcm9wZXJ0aWVzQXNFeHRyYShwcm9wZXJ0aWVzKTtcbiAgICByZXR1cm4gcmV0O1xufVxuXG5leHBvcnQgbmFtZXNwYWNlIENmbkF1dG9TY2FsaW5nR3JvdXAge1xuICAgIC8qKlxuICAgICAqIFRoZSBhdHRyaWJ1dGVzIGZvciB0aGUgaW5zdGFuY2UgdHlwZXMgZm9yIGEgbWl4ZWQgaW5zdGFuY2VzIHBvbGljeS4gQW1hem9uIEVDMiBBdXRvIFNjYWxpbmcgdXNlcyB5b3VyIHNwZWNpZmllZCByZXF1aXJlbWVudHMgdG8gaWRlbnRpZnkgaW5zdGFuY2UgdHlwZXMuIFRoZW4sIGl0IHVzZXMgeW91ciBPbi1EZW1hbmQgYW5kIFNwb3QgYWxsb2NhdGlvbiBzdHJhdGVnaWVzIHRvIGxhdW5jaCBpbnN0YW5jZXMgZnJvbSB0aGVzZSBpbnN0YW5jZSB0eXBlcy5cbiAgICAgKlxuICAgICAqIFdoZW4geW91IHNwZWNpZnkgbXVsdGlwbGUgYXR0cmlidXRlcywgeW91IGdldCBpbnN0YW5jZSB0eXBlcyB0aGF0IHNhdGlzZnkgYWxsIG9mIHRoZSBzcGVjaWZpZWQgYXR0cmlidXRlcy4gSWYgeW91IHNwZWNpZnkgbXVsdGlwbGUgdmFsdWVzIGZvciBhbiBhdHRyaWJ1dGUsIHlvdSBnZXQgaW5zdGFuY2UgdHlwZXMgdGhhdCBzYXRpc2Z5IGFueSBvZiB0aGUgc3BlY2lmaWVkIHZhbHVlcy5cbiAgICAgKlxuICAgICAqIFRvIGxpbWl0IHRoZSBsaXN0IG9mIGluc3RhbmNlIHR5cGVzIGZyb20gd2hpY2ggQW1hem9uIEVDMiBBdXRvIFNjYWxpbmcgY2FuIGlkZW50aWZ5IG1hdGNoaW5nIGluc3RhbmNlIHR5cGVzLCB5b3UgY2FuIHVzZSBvbmUgb2YgdGhlIGZvbGxvd2luZyBwYXJhbWV0ZXJzLCBidXQgbm90IGJvdGggaW4gdGhlIHNhbWUgcmVxdWVzdDpcbiAgICAgKlxuICAgICAqIC0gYEFsbG93ZWRJbnN0YW5jZVR5cGVzYCAtIFRoZSBpbnN0YW5jZSB0eXBlcyB0byBpbmNsdWRlIGluIHRoZSBsaXN0LiBBbGwgb3RoZXIgaW5zdGFuY2UgdHlwZXMgYXJlIGlnbm9yZWQsIGV2ZW4gaWYgdGhleSBtYXRjaCB5b3VyIHNwZWNpZmllZCBhdHRyaWJ1dGVzLlxuICAgICAqIC0gYEV4Y2x1ZGVkSW5zdGFuY2VUeXBlc2AgLSBUaGUgaW5zdGFuY2UgdHlwZXMgdG8gZXhjbHVkZSBmcm9tIHRoZSBsaXN0LCBldmVuIGlmIHRoZXkgbWF0Y2ggeW91ciBzcGVjaWZpZWQgYXR0cmlidXRlcy5cbiAgICAgKlxuICAgICAqID4gWW91IG11c3Qgc3BlY2lmeSBgVkNwdUNvdW50YCBhbmQgYE1lbW9yeU1pQmAgLiBBbGwgb3RoZXIgYXR0cmlidXRlcyBhcmUgb3B0aW9uYWwuIEFueSB1bnNwZWNpZmllZCBvcHRpb25hbCBhdHRyaWJ1dGUgaXMgc2V0IHRvIGl0cyBkZWZhdWx0LlxuICAgICAqXG4gICAgICogRm9yIGFuIGV4YW1wbGUgdGVtcGxhdGUsIHNlZSBbQXV0byBzY2FsaW5nIHRlbXBsYXRlIHNuaXBwZXRzXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9xdWlja3JlZi1hdXRvc2NhbGluZy5odG1sKSAuXG4gICAgICpcbiAgICAgKiBGb3IgbW9yZSBpbmZvcm1hdGlvbiwgc2VlIFtDcmVhdGluZyBhbiBBdXRvIFNjYWxpbmcgZ3JvdXAgdXNpbmcgYXR0cmlidXRlLWJhc2VkIGluc3RhbmNlIHR5cGUgc2VsZWN0aW9uXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vYXV0b3NjYWxpbmcvZWMyL3VzZXJndWlkZS9jcmVhdGUtYXNnLWluc3RhbmNlLXR5cGUtcmVxdWlyZW1lbnRzLmh0bWwpIGluIHRoZSAqQW1hem9uIEVDMiBBdXRvIFNjYWxpbmcgVXNlciBHdWlkZSogLiBGb3IgaGVscCBkZXRlcm1pbmluZyB3aGljaCBpbnN0YW5jZSB0eXBlcyBtYXRjaCB5b3VyIGF0dHJpYnV0ZXMgYmVmb3JlIHlvdSBhcHBseSB0aGVtIHRvIHlvdXIgQXV0byBTY2FsaW5nIGdyb3VwLCBzZWUgW1ByZXZpZXcgaW5zdGFuY2UgdHlwZXMgd2l0aCBzcGVjaWZpZWQgYXR0cmlidXRlc10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0VDMi9sYXRlc3QvVXNlckd1aWRlL2VjMi1mbGVldC1hdHRyaWJ1dGUtYmFzZWQtaW5zdGFuY2UtdHlwZS1zZWxlY3Rpb24uaHRtbCNlYzJmbGVldC1nZXQtaW5zdGFuY2UtdHlwZXMtZnJvbS1pbnN0YW5jZS1yZXF1aXJlbWVudHMpIGluIHRoZSAqQW1hem9uIEVDMiBVc2VyIEd1aWRlIGZvciBMaW51eCBJbnN0YW5jZXMqIC5cbiAgICAgKlxuICAgICAqIGBJbnN0YW5jZVJlcXVpcmVtZW50c2AgaXMgYSBwcm9wZXJ0eSBvZiB0aGUgYExhdW5jaFRlbXBsYXRlT3ZlcnJpZGVzYCBwcm9wZXJ0eSBvZiB0aGUgW0FXUzo6QXV0b1NjYWxpbmc6OkF1dG9TY2FsaW5nR3JvdXAgTGF1bmNoVGVtcGxhdGVdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWF1dG9zY2FsaW5nLWF1dG9zY2FsaW5nZ3JvdXAtbGF1bmNodGVtcGxhdGUuaHRtbCkgcHJvcGVydHkgdHlwZS5cbiAgICAgKlxuICAgICAqIEBzdHJ1Y3RcbiAgICAgKiBAc3RhYmlsaXR5IGV4dGVybmFsXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2Nmbi1hcy1taXhlZGluc3RhbmNlc3BvbGljeS1pbnN0YW5jZXJlcXVpcmVtZW50cy5odG1sXG4gICAgICovXG4gICAgZXhwb3J0IGludGVyZmFjZSBJbnN0YW5jZVJlcXVpcmVtZW50c1Byb3BlcnR5IHtcbiAgICAgICAgLyoqXG4gICAgICAgICAqIFRoZSBtaW5pbXVtIGFuZCBtYXhpbXVtIG51bWJlciBvZiBhY2NlbGVyYXRvcnMgKEdQVXMsIEZQR0FzLCBvciBBV1MgSW5mZXJlbnRpYSBjaGlwcykgZm9yIGFuIGluc3RhbmNlIHR5cGUuXG4gICAgICAgICAqXG4gICAgICAgICAqIFRvIGV4Y2x1ZGUgYWNjZWxlcmF0b3ItZW5hYmxlZCBpbnN0YW5jZSB0eXBlcywgc2V0IGBNYXhgIHRvIGAwYCAuXG4gICAgICAgICAqXG4gICAgICAgICAqIERlZmF1bHQ6IE5vIG1pbmltdW0gb3IgbWF4aW11bSBsaW1pdHNcbiAgICAgICAgICpcbiAgICAgICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9jZm4tYXMtbWl4ZWRpbnN0YW5jZXNwb2xpY3ktaW5zdGFuY2VyZXF1aXJlbWVudHMuaHRtbCNjZm4tYXV0b3NjYWxpbmctYXV0b3NjYWxpbmdncm91cC1pbnN0YW5jZXJlcXVpcmVtZW50cy1hY2NlbGVyYXRvcmNvdW50XG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBhY2NlbGVyYXRvckNvdW50PzogQ2ZuQXV0b1NjYWxpbmdHcm91cC5BY2NlbGVyYXRvckNvdW50UmVxdWVzdFByb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlO1xuICAgICAgICAvKipcbiAgICAgICAgICogSW5kaWNhdGVzIHdoZXRoZXIgaW5zdGFuY2UgdHlwZXMgbXVzdCBoYXZlIGFjY2VsZXJhdG9ycyBieSBzcGVjaWZpYyBtYW51ZmFjdHVyZXJzLlxuICAgICAgICAgKlxuICAgICAgICAgKiAtIEZvciBpbnN0YW5jZSB0eXBlcyB3aXRoIE5WSURJQSBkZXZpY2VzLCBzcGVjaWZ5IGBudmlkaWFgIC5cbiAgICAgICAgICogLSBGb3IgaW5zdGFuY2UgdHlwZXMgd2l0aCBBTUQgZGV2aWNlcywgc3BlY2lmeSBgYW1kYCAuXG4gICAgICAgICAqIC0gRm9yIGluc3RhbmNlIHR5cGVzIHdpdGggQVdTIGRldmljZXMsIHNwZWNpZnkgYGFtYXpvbi13ZWItc2VydmljZXNgIC5cbiAgICAgICAgICogLSBGb3IgaW5zdGFuY2UgdHlwZXMgd2l0aCBYaWxpbnggZGV2aWNlcywgc3BlY2lmeSBgeGlsaW54YCAuXG4gICAgICAgICAqXG4gICAgICAgICAqIERlZmF1bHQ6IEFueSBtYW51ZmFjdHVyZXJcbiAgICAgICAgICpcbiAgICAgICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9jZm4tYXMtbWl4ZWRpbnN0YW5jZXNwb2xpY3ktaW5zdGFuY2VyZXF1aXJlbWVudHMuaHRtbCNjZm4tYXV0b3NjYWxpbmctYXV0b3NjYWxpbmdncm91cC1pbnN0YW5jZXJlcXVpcmVtZW50cy1hY2NlbGVyYXRvcm1hbnVmYWN0dXJlcnNcbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IGFjY2VsZXJhdG9yTWFudWZhY3R1cmVycz86IHN0cmluZ1tdO1xuICAgICAgICAvKipcbiAgICAgICAgICogTGlzdHMgdGhlIGFjY2VsZXJhdG9ycyB0aGF0IG11c3QgYmUgb24gYW4gaW5zdGFuY2UgdHlwZS5cbiAgICAgICAgICpcbiAgICAgICAgICogLSBGb3IgaW5zdGFuY2UgdHlwZXMgd2l0aCBOVklESUEgQTEwMCBHUFVzLCBzcGVjaWZ5IGBhMTAwYCAuXG4gICAgICAgICAqIC0gRm9yIGluc3RhbmNlIHR5cGVzIHdpdGggTlZJRElBIFYxMDAgR1BVcywgc3BlY2lmeSBgdjEwMGAgLlxuICAgICAgICAgKiAtIEZvciBpbnN0YW5jZSB0eXBlcyB3aXRoIE5WSURJQSBLODAgR1BVcywgc3BlY2lmeSBgazgwYCAuXG4gICAgICAgICAqIC0gRm9yIGluc3RhbmNlIHR5cGVzIHdpdGggTlZJRElBIFQ0IEdQVXMsIHNwZWNpZnkgYHQ0YCAuXG4gICAgICAgICAqIC0gRm9yIGluc3RhbmNlIHR5cGVzIHdpdGggTlZJRElBIE02MCBHUFVzLCBzcGVjaWZ5IGBtNjBgIC5cbiAgICAgICAgICogLSBGb3IgaW5zdGFuY2UgdHlwZXMgd2l0aCBBTUQgUmFkZW9uIFBybyBWNTIwIEdQVXMsIHNwZWNpZnkgYHJhZGVvbi1wcm8tdjUyMGAgLlxuICAgICAgICAgKiAtIEZvciBpbnN0YW5jZSB0eXBlcyB3aXRoIFhpbGlueCBWVTlQIEZQR0FzLCBzcGVjaWZ5IGB2dTlwYCAuXG4gICAgICAgICAqXG4gICAgICAgICAqIERlZmF1bHQ6IEFueSBhY2NlbGVyYXRvclxuICAgICAgICAgKlxuICAgICAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2Nmbi1hcy1taXhlZGluc3RhbmNlc3BvbGljeS1pbnN0YW5jZXJlcXVpcmVtZW50cy5odG1sI2Nmbi1hdXRvc2NhbGluZy1hdXRvc2NhbGluZ2dyb3VwLWluc3RhbmNlcmVxdWlyZW1lbnRzLWFjY2VsZXJhdG9ybmFtZXNcbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IGFjY2VsZXJhdG9yTmFtZXM/OiBzdHJpbmdbXTtcbiAgICAgICAgLyoqXG4gICAgICAgICAqIFRoZSBtaW5pbXVtIGFuZCBtYXhpbXVtIHRvdGFsIG1lbW9yeSBzaXplIGZvciB0aGUgYWNjZWxlcmF0b3JzIG9uIGFuIGluc3RhbmNlIHR5cGUsIGluIE1pQi5cbiAgICAgICAgICpcbiAgICAgICAgICogRGVmYXVsdDogTm8gbWluaW11bSBvciBtYXhpbXVtIGxpbWl0c1xuICAgICAgICAgKlxuICAgICAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2Nmbi1hcy1taXhlZGluc3RhbmNlc3BvbGljeS1pbnN0YW5jZXJlcXVpcmVtZW50cy5odG1sI2Nmbi1hdXRvc2NhbGluZy1hdXRvc2NhbGluZ2dyb3VwLWluc3RhbmNlcmVxdWlyZW1lbnRzLWFjY2VsZXJhdG9ydG90YWxtZW1vcnltaWJcbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IGFjY2VsZXJhdG9yVG90YWxNZW1vcnlNaUI/OiBDZm5BdXRvU2NhbGluZ0dyb3VwLkFjY2VsZXJhdG9yVG90YWxNZW1vcnlNaUJSZXF1ZXN0UHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGU7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBMaXN0cyB0aGUgYWNjZWxlcmF0b3IgdHlwZXMgdGhhdCBtdXN0IGJlIG9uIGFuIGluc3RhbmNlIHR5cGUuXG4gICAgICAgICAqXG4gICAgICAgICAqIC0gRm9yIGluc3RhbmNlIHR5cGVzIHdpdGggR1BVIGFjY2VsZXJhdG9ycywgc3BlY2lmeSBgZ3B1YCAuXG4gICAgICAgICAqIC0gRm9yIGluc3RhbmNlIHR5cGVzIHdpdGggRlBHQSBhY2NlbGVyYXRvcnMsIHNwZWNpZnkgYGZwZ2FgIC5cbiAgICAgICAgICogLSBGb3IgaW5zdGFuY2UgdHlwZXMgd2l0aCBpbmZlcmVuY2UgYWNjZWxlcmF0b3JzLCBzcGVjaWZ5IGBpbmZlcmVuY2VgIC5cbiAgICAgICAgICpcbiAgICAgICAgICogRGVmYXVsdDogQW55IGFjY2VsZXJhdG9yIHR5cGVcbiAgICAgICAgICpcbiAgICAgICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9jZm4tYXMtbWl4ZWRpbnN0YW5jZXNwb2xpY3ktaW5zdGFuY2VyZXF1aXJlbWVudHMuaHRtbCNjZm4tYXV0b3NjYWxpbmctYXV0b3NjYWxpbmdncm91cC1pbnN0YW5jZXJlcXVpcmVtZW50cy1hY2NlbGVyYXRvcnR5cGVzXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBhY2NlbGVyYXRvclR5cGVzPzogc3RyaW5nW107XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBUaGUgaW5zdGFuY2UgdHlwZXMgdG8gYXBwbHkgeW91ciBzcGVjaWZpZWQgYXR0cmlidXRlcyBhZ2FpbnN0LiBBbGwgb3RoZXIgaW5zdGFuY2UgdHlwZXMgYXJlIGlnbm9yZWQsIGV2ZW4gaWYgdGhleSBtYXRjaCB5b3VyIHNwZWNpZmllZCBhdHRyaWJ1dGVzLlxuICAgICAgICAgKlxuICAgICAgICAgKiBZb3UgY2FuIHVzZSBzdHJpbmdzIHdpdGggb25lIG9yIG1vcmUgd2lsZCBjYXJkcywgcmVwcmVzZW50ZWQgYnkgYW4gYXN0ZXJpc2sgKCBgKmAgKSwgdG8gYWxsb3cgYW4gaW5zdGFuY2UgdHlwZSwgc2l6ZSwgb3IgZ2VuZXJhdGlvbi4gVGhlIGZvbGxvd2luZyBhcmUgZXhhbXBsZXM6IGBtNS44eGxhcmdlYCAsIGBjNSouKmAgLCBgbTVhLipgICwgYHIqYCAsIGAqMypgIC5cbiAgICAgICAgICpcbiAgICAgICAgICogRm9yIGV4YW1wbGUsIGlmIHlvdSBzcGVjaWZ5IGBjNSpgICwgQW1hem9uIEVDMiBBdXRvIFNjYWxpbmcgd2lsbCBhbGxvdyB0aGUgZW50aXJlIEM1IGluc3RhbmNlIGZhbWlseSwgd2hpY2ggaW5jbHVkZXMgYWxsIEM1YSBhbmQgQzVuIGluc3RhbmNlIHR5cGVzLiBJZiB5b3Ugc3BlY2lmeSBgbTVhLipgICwgQW1hem9uIEVDMiBBdXRvIFNjYWxpbmcgd2lsbCBhbGxvdyBhbGwgdGhlIE01YSBpbnN0YW5jZSB0eXBlcywgYnV0IG5vdCB0aGUgTTVuIGluc3RhbmNlIHR5cGVzLlxuICAgICAgICAgKlxuICAgICAgICAgKiA+IElmIHlvdSBzcGVjaWZ5IGBBbGxvd2VkSW5zdGFuY2VUeXBlc2AgLCB5b3UgY2FuJ3Qgc3BlY2lmeSBgRXhjbHVkZWRJbnN0YW5jZVR5cGVzYCAuXG4gICAgICAgICAqXG4gICAgICAgICAqIERlZmF1bHQ6IEFsbCBpbnN0YW5jZSB0eXBlc1xuICAgICAgICAgKlxuICAgICAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2Nmbi1hcy1taXhlZGluc3RhbmNlc3BvbGljeS1pbnN0YW5jZXJlcXVpcmVtZW50cy5odG1sI2Nmbi1hdXRvc2NhbGluZy1hdXRvc2NhbGluZ2dyb3VwLWluc3RhbmNlcmVxdWlyZW1lbnRzLWFsbG93ZWRpbnN0YW5jZXR5cGVzXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBhbGxvd2VkSW5zdGFuY2VUeXBlcz86IHN0cmluZ1tdO1xuICAgICAgICAvKipcbiAgICAgICAgICogSW5kaWNhdGVzIHdoZXRoZXIgYmFyZSBtZXRhbCBpbnN0YW5jZSB0eXBlcyBhcmUgaW5jbHVkZWQsIGV4Y2x1ZGVkLCBvciByZXF1aXJlZC5cbiAgICAgICAgICpcbiAgICAgICAgICogRGVmYXVsdDogYGV4Y2x1ZGVkYFxuICAgICAgICAgKlxuICAgICAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2Nmbi1hcy1taXhlZGluc3RhbmNlc3BvbGljeS1pbnN0YW5jZXJlcXVpcmVtZW50cy5odG1sI2Nmbi1hdXRvc2NhbGluZy1hdXRvc2NhbGluZ2dyb3VwLWluc3RhbmNlcmVxdWlyZW1lbnRzLWJhcmVtZXRhbFxuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgYmFyZU1ldGFsPzogc3RyaW5nO1xuICAgICAgICAvKipcbiAgICAgICAgICogVGhlIG1pbmltdW0gYW5kIG1heGltdW0gYmFzZWxpbmUgYmFuZHdpZHRoIHBlcmZvcm1hbmNlIGZvciBhbiBpbnN0YW5jZSB0eXBlLCBpbiBNYnBzLiBGb3IgbW9yZSBpbmZvcm1hdGlvbiwgc2VlIFtBbWF6b24gRUJT4oCTb3B0aW1pemVkIGluc3RhbmNlc10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0VDMi9sYXRlc3QvVXNlckd1aWRlL2Vicy1vcHRpbWl6ZWQuaHRtbCkgaW4gdGhlICpBbWF6b24gRUMyIFVzZXIgR3VpZGUgZm9yIExpbnV4IEluc3RhbmNlcyogLlxuICAgICAgICAgKlxuICAgICAgICAgKiBEZWZhdWx0OiBObyBtaW5pbXVtIG9yIG1heGltdW0gbGltaXRzXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvY2ZuLWFzLW1peGVkaW5zdGFuY2VzcG9saWN5LWluc3RhbmNlcmVxdWlyZW1lbnRzLmh0bWwjY2ZuLWF1dG9zY2FsaW5nLWF1dG9zY2FsaW5nZ3JvdXAtaW5zdGFuY2VyZXF1aXJlbWVudHMtYmFzZWxpbmVlYnNiYW5kd2lkdGhtYnBzXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBiYXNlbGluZUVic0JhbmR3aWR0aE1icHM/OiBDZm5BdXRvU2NhbGluZ0dyb3VwLkJhc2VsaW5lRWJzQmFuZHdpZHRoTWJwc1JlcXVlc3RQcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZTtcbiAgICAgICAgLyoqXG4gICAgICAgICAqIEluZGljYXRlcyB3aGV0aGVyIGJ1cnN0YWJsZSBwZXJmb3JtYW5jZSBpbnN0YW5jZSB0eXBlcyBhcmUgaW5jbHVkZWQsIGV4Y2x1ZGVkLCBvciByZXF1aXJlZC4gRm9yIG1vcmUgaW5mb3JtYXRpb24sIHNlZSBbQnVyc3RhYmxlIHBlcmZvcm1hbmNlIGluc3RhbmNlc10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0VDMi9sYXRlc3QvVXNlckd1aWRlL2J1cnN0YWJsZS1wZXJmb3JtYW5jZS1pbnN0YW5jZXMuaHRtbCkgaW4gdGhlICpBbWF6b24gRUMyIFVzZXIgR3VpZGUgZm9yIExpbnV4IEluc3RhbmNlcyogLlxuICAgICAgICAgKlxuICAgICAgICAgKiBEZWZhdWx0OiBgZXhjbHVkZWRgXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvY2ZuLWFzLW1peGVkaW5zdGFuY2VzcG9saWN5LWluc3RhbmNlcmVxdWlyZW1lbnRzLmh0bWwjY2ZuLWF1dG9zY2FsaW5nLWF1dG9zY2FsaW5nZ3JvdXAtaW5zdGFuY2VyZXF1aXJlbWVudHMtYnVyc3RhYmxlcGVyZm9ybWFuY2VcbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IGJ1cnN0YWJsZVBlcmZvcm1hbmNlPzogc3RyaW5nO1xuICAgICAgICAvKipcbiAgICAgICAgICogTGlzdHMgd2hpY2ggc3BlY2lmaWMgQ1BVIG1hbnVmYWN0dXJlcnMgdG8gaW5jbHVkZS5cbiAgICAgICAgICpcbiAgICAgICAgICogLSBGb3IgaW5zdGFuY2UgdHlwZXMgd2l0aCBJbnRlbCBDUFVzLCBzcGVjaWZ5IGBpbnRlbGAgLlxuICAgICAgICAgKiAtIEZvciBpbnN0YW5jZSB0eXBlcyB3aXRoIEFNRCBDUFVzLCBzcGVjaWZ5IGBhbWRgIC5cbiAgICAgICAgICogLSBGb3IgaW5zdGFuY2UgdHlwZXMgd2l0aCBBV1MgQ1BVcywgc3BlY2lmeSBgYW1hem9uLXdlYi1zZXJ2aWNlc2AgLlxuICAgICAgICAgKlxuICAgICAgICAgKiA+IERvbid0IGNvbmZ1c2UgdGhlIENQVSBoYXJkd2FyZSBtYW51ZmFjdHVyZXIgd2l0aCB0aGUgQ1BVIGhhcmR3YXJlIGFyY2hpdGVjdHVyZS4gSW5zdGFuY2VzIHdpbGwgYmUgbGF1bmNoZWQgd2l0aCBhIGNvbXBhdGlibGUgQ1BVIGFyY2hpdGVjdHVyZSBiYXNlZCBvbiB0aGUgQW1hem9uIE1hY2hpbmUgSW1hZ2UgKEFNSSkgdGhhdCB5b3Ugc3BlY2lmeSBpbiB5b3VyIGxhdW5jaCB0ZW1wbGF0ZS5cbiAgICAgICAgICpcbiAgICAgICAgICogRGVmYXVsdDogQW55IG1hbnVmYWN0dXJlclxuICAgICAgICAgKlxuICAgICAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2Nmbi1hcy1taXhlZGluc3RhbmNlc3BvbGljeS1pbnN0YW5jZXJlcXVpcmVtZW50cy5odG1sI2Nmbi1hdXRvc2NhbGluZy1hdXRvc2NhbGluZ2dyb3VwLWluc3RhbmNlcmVxdWlyZW1lbnRzLWNwdW1hbnVmYWN0dXJlcnNcbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IGNwdU1hbnVmYWN0dXJlcnM/OiBzdHJpbmdbXTtcbiAgICAgICAgLyoqXG4gICAgICAgICAqIFRoZSBpbnN0YW5jZSB0eXBlcyB0byBleGNsdWRlLiBZb3UgY2FuIHVzZSBzdHJpbmdzIHdpdGggb25lIG9yIG1vcmUgd2lsZCBjYXJkcywgcmVwcmVzZW50ZWQgYnkgYW4gYXN0ZXJpc2sgKCBgKmAgKSwgdG8gZXhjbHVkZSBhbiBpbnN0YW5jZSBmYW1pbHksIHR5cGUsIHNpemUsIG9yIGdlbmVyYXRpb24uIFRoZSBmb2xsb3dpbmcgYXJlIGV4YW1wbGVzOiBgbTUuOHhsYXJnZWAgLCBgYzUqLipgICwgYG01YS4qYCAsIGByKmAgLCBgKjMqYCAuXG4gICAgICAgICAqXG4gICAgICAgICAqIEZvciBleGFtcGxlLCBpZiB5b3Ugc3BlY2lmeSBgYzUqYCAsIHlvdSBhcmUgZXhjbHVkaW5nIHRoZSBlbnRpcmUgQzUgaW5zdGFuY2UgZmFtaWx5LCB3aGljaCBpbmNsdWRlcyBhbGwgQzVhIGFuZCBDNW4gaW5zdGFuY2UgdHlwZXMuIElmIHlvdSBzcGVjaWZ5IGBtNWEuKmAgLCBBbWF6b24gRUMyIEF1dG8gU2NhbGluZyB3aWxsIGV4Y2x1ZGUgYWxsIHRoZSBNNWEgaW5zdGFuY2UgdHlwZXMsIGJ1dCBub3QgdGhlIE01biBpbnN0YW5jZSB0eXBlcy5cbiAgICAgICAgICpcbiAgICAgICAgICogPiBJZiB5b3Ugc3BlY2lmeSBgRXhjbHVkZWRJbnN0YW5jZVR5cGVzYCAsIHlvdSBjYW4ndCBzcGVjaWZ5IGBBbGxvd2VkSW5zdGFuY2VUeXBlc2AgLlxuICAgICAgICAgKlxuICAgICAgICAgKiBEZWZhdWx0OiBObyBleGNsdWRlZCBpbnN0YW5jZSB0eXBlc1xuICAgICAgICAgKlxuICAgICAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2Nmbi1hcy1taXhlZGluc3RhbmNlc3BvbGljeS1pbnN0YW5jZXJlcXVpcmVtZW50cy5odG1sI2Nmbi1hdXRvc2NhbGluZy1hdXRvc2NhbGluZ2dyb3VwLWluc3RhbmNlcmVxdWlyZW1lbnRzLWV4Y2x1ZGVkaW5zdGFuY2V0eXBlc1xuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgZXhjbHVkZWRJbnN0YW5jZVR5cGVzPzogc3RyaW5nW107XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBJbmRpY2F0ZXMgd2hldGhlciBjdXJyZW50IG9yIHByZXZpb3VzIGdlbmVyYXRpb24gaW5zdGFuY2UgdHlwZXMgYXJlIGluY2x1ZGVkLlxuICAgICAgICAgKlxuICAgICAgICAgKiAtIEZvciBjdXJyZW50IGdlbmVyYXRpb24gaW5zdGFuY2UgdHlwZXMsIHNwZWNpZnkgYGN1cnJlbnRgIC4gVGhlIGN1cnJlbnQgZ2VuZXJhdGlvbiBpbmNsdWRlcyBFQzIgaW5zdGFuY2UgdHlwZXMgY3VycmVudGx5IHJlY29tbWVuZGVkIGZvciB1c2UuIFRoaXMgdHlwaWNhbGx5IGluY2x1ZGVzIHRoZSBsYXRlc3QgdHdvIHRvIHRocmVlIGdlbmVyYXRpb25zIGluIGVhY2ggaW5zdGFuY2UgZmFtaWx5LiBGb3IgbW9yZSBpbmZvcm1hdGlvbiwgc2VlIFtJbnN0YW5jZSB0eXBlc10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0VDMi9sYXRlc3QvVXNlckd1aWRlL2luc3RhbmNlLXR5cGVzLmh0bWwpIGluIHRoZSAqQW1hem9uIEVDMiBVc2VyIEd1aWRlIGZvciBMaW51eCBJbnN0YW5jZXMqIC5cbiAgICAgICAgICogLSBGb3IgcHJldmlvdXMgZ2VuZXJhdGlvbiBpbnN0YW5jZSB0eXBlcywgc3BlY2lmeSBgcHJldmlvdXNgIC5cbiAgICAgICAgICpcbiAgICAgICAgICogRGVmYXVsdDogQW55IGN1cnJlbnQgb3IgcHJldmlvdXMgZ2VuZXJhdGlvblxuICAgICAgICAgKlxuICAgICAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2Nmbi1hcy1taXhlZGluc3RhbmNlc3BvbGljeS1pbnN0YW5jZXJlcXVpcmVtZW50cy5odG1sI2Nmbi1hdXRvc2NhbGluZy1hdXRvc2NhbGluZ2dyb3VwLWluc3RhbmNlcmVxdWlyZW1lbnRzLWluc3RhbmNlZ2VuZXJhdGlvbnNcbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IGluc3RhbmNlR2VuZXJhdGlvbnM/OiBzdHJpbmdbXTtcbiAgICAgICAgLyoqXG4gICAgICAgICAqIEluZGljYXRlcyB3aGV0aGVyIGluc3RhbmNlIHR5cGVzIHdpdGggaW5zdGFuY2Ugc3RvcmUgdm9sdW1lcyBhcmUgaW5jbHVkZWQsIGV4Y2x1ZGVkLCBvciByZXF1aXJlZC4gRm9yIG1vcmUgaW5mb3JtYXRpb24sIHNlZSBbQW1hem9uIEVDMiBpbnN0YW5jZSBzdG9yZV0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0VDMi9sYXRlc3QvVXNlckd1aWRlL0luc3RhbmNlU3RvcmFnZS5odG1sKSBpbiB0aGUgKkFtYXpvbiBFQzIgVXNlciBHdWlkZSBmb3IgTGludXggSW5zdGFuY2VzKiAuXG4gICAgICAgICAqXG4gICAgICAgICAqIERlZmF1bHQ6IGBpbmNsdWRlZGBcbiAgICAgICAgICpcbiAgICAgICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9jZm4tYXMtbWl4ZWRpbnN0YW5jZXNwb2xpY3ktaW5zdGFuY2VyZXF1aXJlbWVudHMuaHRtbCNjZm4tYXV0b3NjYWxpbmctYXV0b3NjYWxpbmdncm91cC1pbnN0YW5jZXJlcXVpcmVtZW50cy1sb2NhbHN0b3JhZ2VcbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IGxvY2FsU3RvcmFnZT86IHN0cmluZztcbiAgICAgICAgLyoqXG4gICAgICAgICAqIEluZGljYXRlcyB0aGUgdHlwZSBvZiBsb2NhbCBzdG9yYWdlIHRoYXQgaXMgcmVxdWlyZWQuXG4gICAgICAgICAqXG4gICAgICAgICAqIC0gRm9yIGluc3RhbmNlIHR5cGVzIHdpdGggaGFyZCBkaXNrIGRyaXZlIChIREQpIHN0b3JhZ2UsIHNwZWNpZnkgYGhkZGAgLlxuICAgICAgICAgKiAtIEZvciBpbnN0YW5jZSB0eXBlcyB3aXRoIHNvbGlkIHN0YXRlIGRyaXZlIChTU0QpIHN0b3JhZ2UsIHNwZWNpZnkgYHNzZGAgLlxuICAgICAgICAgKlxuICAgICAgICAgKiBEZWZhdWx0OiBBbnkgbG9jYWwgc3RvcmFnZSB0eXBlXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvY2ZuLWFzLW1peGVkaW5zdGFuY2VzcG9saWN5LWluc3RhbmNlcmVxdWlyZW1lbnRzLmh0bWwjY2ZuLWF1dG9zY2FsaW5nLWF1dG9zY2FsaW5nZ3JvdXAtaW5zdGFuY2VyZXF1aXJlbWVudHMtbG9jYWxzdG9yYWdldHlwZXNcbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IGxvY2FsU3RvcmFnZVR5cGVzPzogc3RyaW5nW107XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBUaGUgbWluaW11bSBhbmQgbWF4aW11bSBhbW91bnQgb2YgbWVtb3J5IHBlciB2Q1BVIGZvciBhbiBpbnN0YW5jZSB0eXBlLCBpbiBHaUIuXG4gICAgICAgICAqXG4gICAgICAgICAqIERlZmF1bHQ6IE5vIG1pbmltdW0gb3IgbWF4aW11bSBsaW1pdHNcbiAgICAgICAgICpcbiAgICAgICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9jZm4tYXMtbWl4ZWRpbnN0YW5jZXNwb2xpY3ktaW5zdGFuY2VyZXF1aXJlbWVudHMuaHRtbCNjZm4tYXV0b3NjYWxpbmctYXV0b3NjYWxpbmdncm91cC1pbnN0YW5jZXJlcXVpcmVtZW50cy1tZW1vcnlnaWJwZXJ2Y3B1XG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBtZW1vcnlHaUJQZXJWQ3B1PzogQ2ZuQXV0b1NjYWxpbmdHcm91cC5NZW1vcnlHaUJQZXJWQ3B1UmVxdWVzdFByb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlO1xuICAgICAgICAvKipcbiAgICAgICAgICogVGhlIG1pbmltdW0gYW5kIG1heGltdW0gaW5zdGFuY2UgbWVtb3J5IHNpemUgZm9yIGFuIGluc3RhbmNlIHR5cGUsIGluIE1pQi5cbiAgICAgICAgICpcbiAgICAgICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9jZm4tYXMtbWl4ZWRpbnN0YW5jZXNwb2xpY3ktaW5zdGFuY2VyZXF1aXJlbWVudHMuaHRtbCNjZm4tYXV0b3NjYWxpbmctYXV0b3NjYWxpbmdncm91cC1pbnN0YW5jZXJlcXVpcmVtZW50cy1tZW1vcnltaWJcbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IG1lbW9yeU1pQj86IENmbkF1dG9TY2FsaW5nR3JvdXAuTWVtb3J5TWlCUmVxdWVzdFByb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlO1xuICAgICAgICAvKipcbiAgICAgICAgICogVGhlIG1pbmltdW0gYW5kIG1heGltdW0gYW1vdW50IG9mIG5ldHdvcmsgYmFuZHdpZHRoLCBpbiBnaWdhYml0cyBwZXIgc2Vjb25kIChHYnBzKS5cbiAgICAgICAgICpcbiAgICAgICAgICogRGVmYXVsdDogTm8gbWluaW11bSBvciBtYXhpbXVtIGxpbWl0c1xuICAgICAgICAgKlxuICAgICAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2Nmbi1hcy1taXhlZGluc3RhbmNlc3BvbGljeS1pbnN0YW5jZXJlcXVpcmVtZW50cy5odG1sI2Nmbi1hdXRvc2NhbGluZy1hdXRvc2NhbGluZ2dyb3VwLWluc3RhbmNlcmVxdWlyZW1lbnRzLW5ldHdvcmtiYW5kd2lkdGhnYnBzXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBuZXR3b3JrQmFuZHdpZHRoR2Jwcz86IENmbkF1dG9TY2FsaW5nR3JvdXAuTmV0d29ya0JhbmR3aWR0aEdicHNSZXF1ZXN0UHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGU7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBUaGUgbWluaW11bSBhbmQgbWF4aW11bSBudW1iZXIgb2YgbmV0d29yayBpbnRlcmZhY2VzIGZvciBhbiBpbnN0YW5jZSB0eXBlLlxuICAgICAgICAgKlxuICAgICAgICAgKiBEZWZhdWx0OiBObyBtaW5pbXVtIG9yIG1heGltdW0gbGltaXRzXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvY2ZuLWFzLW1peGVkaW5zdGFuY2VzcG9saWN5LWluc3RhbmNlcmVxdWlyZW1lbnRzLmh0bWwjY2ZuLWF1dG9zY2FsaW5nLWF1dG9zY2FsaW5nZ3JvdXAtaW5zdGFuY2VyZXF1aXJlbWVudHMtbmV0d29ya2ludGVyZmFjZWNvdW50XG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBuZXR3b3JrSW50ZXJmYWNlQ291bnQ/OiBDZm5BdXRvU2NhbGluZ0dyb3VwLk5ldHdvcmtJbnRlcmZhY2VDb3VudFJlcXVlc3RQcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZTtcbiAgICAgICAgLyoqXG4gICAgICAgICAqIFRoZSBwcmljZSBwcm90ZWN0aW9uIHRocmVzaG9sZCBmb3IgT24tRGVtYW5kIEluc3RhbmNlcy4gVGhpcyBpcyB0aGUgbWF4aW11bSB5b3XigJlsbCBwYXkgZm9yIGFuIE9uLURlbWFuZCBJbnN0YW5jZSwgZXhwcmVzc2VkIGFzIGEgcGVyY2VudGFnZSBoaWdoZXIgdGhhbiB0aGUgbGVhc3QgZXhwZW5zaXZlIGN1cnJlbnQgZ2VuZXJhdGlvbiBNLCBDLCBvciBSIGluc3RhbmNlIHR5cGUgd2l0aCB5b3VyIHNwZWNpZmllZCBhdHRyaWJ1dGVzLiBXaGVuIEFtYXpvbiBFQzIgQXV0byBTY2FsaW5nIHNlbGVjdHMgaW5zdGFuY2UgdHlwZXMgd2l0aCB5b3VyIGF0dHJpYnV0ZXMsIHdlIHdpbGwgZXhjbHVkZSBpbnN0YW5jZSB0eXBlcyB3aG9zZSBwcmljZSBpcyBoaWdoZXIgdGhhbiB5b3VyIHRocmVzaG9sZC4gVGhlIHBhcmFtZXRlciBhY2NlcHRzIGFuIGludGVnZXIsIHdoaWNoIEFtYXpvbiBFQzIgQXV0byBTY2FsaW5nIGludGVycHJldHMgYXMgYSBwZXJjZW50YWdlLiBUbyB0dXJuIG9mZiBwcmljZSBwcm90ZWN0aW9uLCBzcGVjaWZ5IGEgaGlnaCB2YWx1ZSwgc3VjaCBhcyBgOTk5OTk5YCAuXG4gICAgICAgICAqXG4gICAgICAgICAqIElmIHlvdSBzZXQgYERlc2lyZWRDYXBhY2l0eVR5cGVgIHRvIGB2Y3B1YCBvciBgbWVtb3J5LW1pYmAgLCB0aGUgcHJpY2UgcHJvdGVjdGlvbiB0aHJlc2hvbGQgaXMgYXBwbGllZCBiYXNlZCBvbiB0aGUgcGVyIHZDUFUgb3IgcGVyIG1lbW9yeSBwcmljZSBpbnN0ZWFkIG9mIHRoZSBwZXIgaW5zdGFuY2UgcHJpY2UuXG4gICAgICAgICAqXG4gICAgICAgICAqIERlZmF1bHQ6IGAyMGBcbiAgICAgICAgICpcbiAgICAgICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9jZm4tYXMtbWl4ZWRpbnN0YW5jZXNwb2xpY3ktaW5zdGFuY2VyZXF1aXJlbWVudHMuaHRtbCNjZm4tYXV0b3NjYWxpbmctYXV0b3NjYWxpbmdncm91cC1pbnN0YW5jZXJlcXVpcmVtZW50cy1vbmRlbWFuZG1heHByaWNlcGVyY2VudGFnZW92ZXJsb3dlc3RwcmljZVxuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgb25EZW1hbmRNYXhQcmljZVBlcmNlbnRhZ2VPdmVyTG93ZXN0UHJpY2U/OiBudW1iZXI7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBJbmRpY2F0ZXMgd2hldGhlciBpbnN0YW5jZSB0eXBlcyBtdXN0IHByb3ZpZGUgT24tRGVtYW5kIEluc3RhbmNlIGhpYmVybmF0aW9uIHN1cHBvcnQuXG4gICAgICAgICAqXG4gICAgICAgICAqIERlZmF1bHQ6IGBmYWxzZWBcbiAgICAgICAgICpcbiAgICAgICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9jZm4tYXMtbWl4ZWRpbnN0YW5jZXNwb2xpY3ktaW5zdGFuY2VyZXF1aXJlbWVudHMuaHRtbCNjZm4tYXV0b3NjYWxpbmctYXV0b3NjYWxpbmdncm91cC1pbnN0YW5jZXJlcXVpcmVtZW50cy1yZXF1aXJlaGliZXJuYXRlc3VwcG9ydFxuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgcmVxdWlyZUhpYmVybmF0ZVN1cHBvcnQ/OiBib29sZWFuIHwgY2RrLklSZXNvbHZhYmxlO1xuICAgICAgICAvKipcbiAgICAgICAgICogVGhlIHByaWNlIHByb3RlY3Rpb24gdGhyZXNob2xkIGZvciBTcG90IEluc3RhbmNlcy4gVGhpcyBpcyB0aGUgbWF4aW11bSB5b3XigJlsbCBwYXkgZm9yIGEgU3BvdCBJbnN0YW5jZSwgZXhwcmVzc2VkIGFzIGEgcGVyY2VudGFnZSBoaWdoZXIgdGhhbiB0aGUgbGVhc3QgZXhwZW5zaXZlIGN1cnJlbnQgZ2VuZXJhdGlvbiBNLCBDLCBvciBSIGluc3RhbmNlIHR5cGUgd2l0aCB5b3VyIHNwZWNpZmllZCBhdHRyaWJ1dGVzLiBXaGVuIEFtYXpvbiBFQzIgQXV0byBTY2FsaW5nIHNlbGVjdHMgaW5zdGFuY2UgdHlwZXMgd2l0aCB5b3VyIGF0dHJpYnV0ZXMsIHdlIHdpbGwgZXhjbHVkZSBpbnN0YW5jZSB0eXBlcyB3aG9zZSBwcmljZSBpcyBoaWdoZXIgdGhhbiB5b3VyIHRocmVzaG9sZC4gVGhlIHBhcmFtZXRlciBhY2NlcHRzIGFuIGludGVnZXIsIHdoaWNoIEFtYXpvbiBFQzIgQXV0byBTY2FsaW5nIGludGVycHJldHMgYXMgYSBwZXJjZW50YWdlLiBUbyB0dXJuIG9mZiBwcmljZSBwcm90ZWN0aW9uLCBzcGVjaWZ5IGEgaGlnaCB2YWx1ZSwgc3VjaCBhcyBgOTk5OTk5YCAuXG4gICAgICAgICAqXG4gICAgICAgICAqIElmIHlvdSBzZXQgYERlc2lyZWRDYXBhY2l0eVR5cGVgIHRvIGB2Y3B1YCBvciBgbWVtb3J5LW1pYmAgLCB0aGUgcHJpY2UgcHJvdGVjdGlvbiB0aHJlc2hvbGQgaXMgYXBwbGllZCBiYXNlZCBvbiB0aGUgcGVyIHZDUFUgb3IgcGVyIG1lbW9yeSBwcmljZSBpbnN0ZWFkIG9mIHRoZSBwZXIgaW5zdGFuY2UgcHJpY2UuXG4gICAgICAgICAqXG4gICAgICAgICAqIERlZmF1bHQ6IGAxMDBgXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvY2ZuLWFzLW1peGVkaW5zdGFuY2VzcG9saWN5LWluc3RhbmNlcmVxdWlyZW1lbnRzLmh0bWwjY2ZuLWF1dG9zY2FsaW5nLWF1dG9zY2FsaW5nZ3JvdXAtaW5zdGFuY2VyZXF1aXJlbWVudHMtc3BvdG1heHByaWNlcGVyY2VudGFnZW92ZXJsb3dlc3RwcmljZVxuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgc3BvdE1heFByaWNlUGVyY2VudGFnZU92ZXJMb3dlc3RQcmljZT86IG51bWJlcjtcbiAgICAgICAgLyoqXG4gICAgICAgICAqIFRoZSBtaW5pbXVtIGFuZCBtYXhpbXVtIHRvdGFsIGxvY2FsIHN0b3JhZ2Ugc2l6ZSBmb3IgYW4gaW5zdGFuY2UgdHlwZSwgaW4gR0IuXG4gICAgICAgICAqXG4gICAgICAgICAqIERlZmF1bHQ6IE5vIG1pbmltdW0gb3IgbWF4aW11bSBsaW1pdHNcbiAgICAgICAgICpcbiAgICAgICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9jZm4tYXMtbWl4ZWRpbnN0YW5jZXNwb2xpY3ktaW5zdGFuY2VyZXF1aXJlbWVudHMuaHRtbCNjZm4tYXV0b3NjYWxpbmctYXV0b3NjYWxpbmdncm91cC1pbnN0YW5jZXJlcXVpcmVtZW50cy10b3RhbGxvY2Fsc3RvcmFnZWdiXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSB0b3RhbExvY2FsU3RvcmFnZUdiPzogQ2ZuQXV0b1NjYWxpbmdHcm91cC5Ub3RhbExvY2FsU3RvcmFnZUdCUmVxdWVzdFByb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlO1xuICAgICAgICAvKipcbiAgICAgICAgICogVGhlIG1pbmltdW0gYW5kIG1heGltdW0gbnVtYmVyIG9mIHZDUFVzIGZvciBhbiBpbnN0YW5jZSB0eXBlLlxuICAgICAgICAgKlxuICAgICAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2Nmbi1hcy1taXhlZGluc3RhbmNlc3BvbGljeS1pbnN0YW5jZXJlcXVpcmVtZW50cy5odG1sI2Nmbi1hdXRvc2NhbGluZy1hdXRvc2NhbGluZ2dyb3VwLWluc3RhbmNlcmVxdWlyZW1lbnRzLXZjcHVjb3VudFxuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgdkNwdUNvdW50PzogQ2ZuQXV0b1NjYWxpbmdHcm91cC5WQ3B1Q291bnRSZXF1ZXN0UHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGU7XG4gICAgfVxufVxuXG4vKipcbiAqIERldGVybWluZSB3aGV0aGVyIHRoZSBnaXZlbiBwcm9wZXJ0aWVzIG1hdGNoIHRob3NlIG9mIGEgYEluc3RhbmNlUmVxdWlyZW1lbnRzUHJvcGVydHlgXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYEluc3RhbmNlUmVxdWlyZW1lbnRzUHJvcGVydHlgXG4gKlxuICogQHJldHVybnMgdGhlIHJlc3VsdCBvZiB0aGUgdmFsaWRhdGlvbi5cbiAqL1xuZnVuY3Rpb24gQ2ZuQXV0b1NjYWxpbmdHcm91cF9JbnN0YW5jZVJlcXVpcmVtZW50c1Byb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXM6IGFueSk6IGNkay5WYWxpZGF0aW9uUmVzdWx0IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBjZGsuVkFMSURBVElPTl9TVUNDRVNTOyB9XG4gICAgY29uc3QgZXJyb3JzID0gbmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0cygpO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgZXJyb3JzLmNvbGxlY3QobmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0KCdFeHBlY3RlZCBhbiBvYmplY3QsIGJ1dCByZWNlaXZlZDogJyArIEpTT04uc3RyaW5naWZ5KHByb3BlcnRpZXMpKSk7XG4gICAgfVxuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignYWNjZWxlcmF0b3JDb3VudCcsIENmbkF1dG9TY2FsaW5nR3JvdXBfQWNjZWxlcmF0b3JDb3VudFJlcXVlc3RQcm9wZXJ0eVZhbGlkYXRvcikocHJvcGVydGllcy5hY2NlbGVyYXRvckNvdW50KSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdhY2NlbGVyYXRvck1hbnVmYWN0dXJlcnMnLCBjZGsubGlzdFZhbGlkYXRvcihjZGsudmFsaWRhdGVTdHJpbmcpKShwcm9wZXJ0aWVzLmFjY2VsZXJhdG9yTWFudWZhY3R1cmVycykpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignYWNjZWxlcmF0b3JOYW1lcycsIGNkay5saXN0VmFsaWRhdG9yKGNkay52YWxpZGF0ZVN0cmluZykpKHByb3BlcnRpZXMuYWNjZWxlcmF0b3JOYW1lcykpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignYWNjZWxlcmF0b3JUb3RhbE1lbW9yeU1pQicsIENmbkF1dG9TY2FsaW5nR3JvdXBfQWNjZWxlcmF0b3JUb3RhbE1lbW9yeU1pQlJlcXVlc3RQcm9wZXJ0eVZhbGlkYXRvcikocHJvcGVydGllcy5hY2NlbGVyYXRvclRvdGFsTWVtb3J5TWlCKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdhY2NlbGVyYXRvclR5cGVzJywgY2RrLmxpc3RWYWxpZGF0b3IoY2RrLnZhbGlkYXRlU3RyaW5nKSkocHJvcGVydGllcy5hY2NlbGVyYXRvclR5cGVzKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdhbGxvd2VkSW5zdGFuY2VUeXBlcycsIGNkay5saXN0VmFsaWRhdG9yKGNkay52YWxpZGF0ZVN0cmluZykpKHByb3BlcnRpZXMuYWxsb3dlZEluc3RhbmNlVHlwZXMpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2JhcmVNZXRhbCcsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5iYXJlTWV0YWwpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2Jhc2VsaW5lRWJzQmFuZHdpZHRoTWJwcycsIENmbkF1dG9TY2FsaW5nR3JvdXBfQmFzZWxpbmVFYnNCYW5kd2lkdGhNYnBzUmVxdWVzdFByb3BlcnR5VmFsaWRhdG9yKShwcm9wZXJ0aWVzLmJhc2VsaW5lRWJzQmFuZHdpZHRoTWJwcykpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignYnVyc3RhYmxlUGVyZm9ybWFuY2UnLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuYnVyc3RhYmxlUGVyZm9ybWFuY2UpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2NwdU1hbnVmYWN0dXJlcnMnLCBjZGsubGlzdFZhbGlkYXRvcihjZGsudmFsaWRhdGVTdHJpbmcpKShwcm9wZXJ0aWVzLmNwdU1hbnVmYWN0dXJlcnMpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2V4Y2x1ZGVkSW5zdGFuY2VUeXBlcycsIGNkay5saXN0VmFsaWRhdG9yKGNkay52YWxpZGF0ZVN0cmluZykpKHByb3BlcnRpZXMuZXhjbHVkZWRJbnN0YW5jZVR5cGVzKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdpbnN0YW5jZUdlbmVyYXRpb25zJywgY2RrLmxpc3RWYWxpZGF0b3IoY2RrLnZhbGlkYXRlU3RyaW5nKSkocHJvcGVydGllcy5pbnN0YW5jZUdlbmVyYXRpb25zKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdsb2NhbFN0b3JhZ2UnLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMubG9jYWxTdG9yYWdlKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdsb2NhbFN0b3JhZ2VUeXBlcycsIGNkay5saXN0VmFsaWRhdG9yKGNkay52YWxpZGF0ZVN0cmluZykpKHByb3BlcnRpZXMubG9jYWxTdG9yYWdlVHlwZXMpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ21lbW9yeUdpQlBlclZDcHUnLCBDZm5BdXRvU2NhbGluZ0dyb3VwX01lbW9yeUdpQlBlclZDcHVSZXF1ZXN0UHJvcGVydHlWYWxpZGF0b3IpKHByb3BlcnRpZXMubWVtb3J5R2lCUGVyVkNwdSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignbWVtb3J5TWlCJywgQ2ZuQXV0b1NjYWxpbmdHcm91cF9NZW1vcnlNaUJSZXF1ZXN0UHJvcGVydHlWYWxpZGF0b3IpKHByb3BlcnRpZXMubWVtb3J5TWlCKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCduZXR3b3JrQmFuZHdpZHRoR2JwcycsIENmbkF1dG9TY2FsaW5nR3JvdXBfTmV0d29ya0JhbmR3aWR0aEdicHNSZXF1ZXN0UHJvcGVydHlWYWxpZGF0b3IpKHByb3BlcnRpZXMubmV0d29ya0JhbmR3aWR0aEdicHMpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ25ldHdvcmtJbnRlcmZhY2VDb3VudCcsIENmbkF1dG9TY2FsaW5nR3JvdXBfTmV0d29ya0ludGVyZmFjZUNvdW50UmVxdWVzdFByb3BlcnR5VmFsaWRhdG9yKShwcm9wZXJ0aWVzLm5ldHdvcmtJbnRlcmZhY2VDb3VudCkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignb25EZW1hbmRNYXhQcmljZVBlcmNlbnRhZ2VPdmVyTG93ZXN0UHJpY2UnLCBjZGsudmFsaWRhdGVOdW1iZXIpKHByb3BlcnRpZXMub25EZW1hbmRNYXhQcmljZVBlcmNlbnRhZ2VPdmVyTG93ZXN0UHJpY2UpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3JlcXVpcmVIaWJlcm5hdGVTdXBwb3J0JywgY2RrLnZhbGlkYXRlQm9vbGVhbikocHJvcGVydGllcy5yZXF1aXJlSGliZXJuYXRlU3VwcG9ydCkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignc3BvdE1heFByaWNlUGVyY2VudGFnZU92ZXJMb3dlc3RQcmljZScsIGNkay52YWxpZGF0ZU51bWJlcikocHJvcGVydGllcy5zcG90TWF4UHJpY2VQZXJjZW50YWdlT3Zlckxvd2VzdFByaWNlKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCd0b3RhbExvY2FsU3RvcmFnZUdiJywgQ2ZuQXV0b1NjYWxpbmdHcm91cF9Ub3RhbExvY2FsU3RvcmFnZUdCUmVxdWVzdFByb3BlcnR5VmFsaWRhdG9yKShwcm9wZXJ0aWVzLnRvdGFsTG9jYWxTdG9yYWdlR2IpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3ZDcHVDb3VudCcsIENmbkF1dG9TY2FsaW5nR3JvdXBfVkNwdUNvdW50UmVxdWVzdFByb3BlcnR5VmFsaWRhdG9yKShwcm9wZXJ0aWVzLnZDcHVDb3VudCkpO1xuICAgIHJldHVybiBlcnJvcnMud3JhcCgnc3VwcGxpZWQgcHJvcGVydGllcyBub3QgY29ycmVjdCBmb3IgXCJJbnN0YW5jZVJlcXVpcmVtZW50c1Byb3BlcnR5XCInKTtcbn1cblxuLyoqXG4gKiBSZW5kZXJzIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpBdXRvU2NhbGluZzo6QXV0b1NjYWxpbmdHcm91cC5JbnN0YW5jZVJlcXVpcmVtZW50c2AgcmVzb3VyY2VcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgSW5zdGFuY2VSZXF1aXJlbWVudHNQcm9wZXJ0eWBcbiAqXG4gKiBAcmV0dXJucyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6QXV0b1NjYWxpbmc6OkF1dG9TY2FsaW5nR3JvdXAuSW5zdGFuY2VSZXF1aXJlbWVudHNgIHJlc291cmNlLlxuICovXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gY2ZuQXV0b1NjYWxpbmdHcm91cEluc3RhbmNlUmVxdWlyZW1lbnRzUHJvcGVydHlUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGFueSB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gcHJvcGVydGllczsgfVxuICAgIENmbkF1dG9TY2FsaW5nR3JvdXBfSW5zdGFuY2VSZXF1aXJlbWVudHNQcm9wZXJ0eVZhbGlkYXRvcihwcm9wZXJ0aWVzKS5hc3NlcnRTdWNjZXNzKCk7XG4gICAgcmV0dXJuIHtcbiAgICAgICAgQWNjZWxlcmF0b3JDb3VudDogY2ZuQXV0b1NjYWxpbmdHcm91cEFjY2VsZXJhdG9yQ291bnRSZXF1ZXN0UHJvcGVydHlUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuYWNjZWxlcmF0b3JDb3VudCksXG4gICAgICAgIEFjY2VsZXJhdG9yTWFudWZhY3R1cmVyczogY2RrLmxpc3RNYXBwZXIoY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24pKHByb3BlcnRpZXMuYWNjZWxlcmF0b3JNYW51ZmFjdHVyZXJzKSxcbiAgICAgICAgQWNjZWxlcmF0b3JOYW1lczogY2RrLmxpc3RNYXBwZXIoY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24pKHByb3BlcnRpZXMuYWNjZWxlcmF0b3JOYW1lcyksXG4gICAgICAgIEFjY2VsZXJhdG9yVG90YWxNZW1vcnlNaUI6IGNmbkF1dG9TY2FsaW5nR3JvdXBBY2NlbGVyYXRvclRvdGFsTWVtb3J5TWlCUmVxdWVzdFByb3BlcnR5VG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLmFjY2VsZXJhdG9yVG90YWxNZW1vcnlNaUIpLFxuICAgICAgICBBY2NlbGVyYXRvclR5cGVzOiBjZGsubGlzdE1hcHBlcihjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbikocHJvcGVydGllcy5hY2NlbGVyYXRvclR5cGVzKSxcbiAgICAgICAgQWxsb3dlZEluc3RhbmNlVHlwZXM6IGNkay5saXN0TWFwcGVyKGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKShwcm9wZXJ0aWVzLmFsbG93ZWRJbnN0YW5jZVR5cGVzKSxcbiAgICAgICAgQmFyZU1ldGFsOiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLmJhcmVNZXRhbCksXG4gICAgICAgIEJhc2VsaW5lRWJzQmFuZHdpZHRoTWJwczogY2ZuQXV0b1NjYWxpbmdHcm91cEJhc2VsaW5lRWJzQmFuZHdpZHRoTWJwc1JlcXVlc3RQcm9wZXJ0eVRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5iYXNlbGluZUVic0JhbmR3aWR0aE1icHMpLFxuICAgICAgICBCdXJzdGFibGVQZXJmb3JtYW5jZTogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5idXJzdGFibGVQZXJmb3JtYW5jZSksXG4gICAgICAgIENwdU1hbnVmYWN0dXJlcnM6IGNkay5saXN0TWFwcGVyKGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKShwcm9wZXJ0aWVzLmNwdU1hbnVmYWN0dXJlcnMpLFxuICAgICAgICBFeGNsdWRlZEluc3RhbmNlVHlwZXM6IGNkay5saXN0TWFwcGVyKGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKShwcm9wZXJ0aWVzLmV4Y2x1ZGVkSW5zdGFuY2VUeXBlcyksXG4gICAgICAgIEluc3RhbmNlR2VuZXJhdGlvbnM6IGNkay5saXN0TWFwcGVyKGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKShwcm9wZXJ0aWVzLmluc3RhbmNlR2VuZXJhdGlvbnMpLFxuICAgICAgICBMb2NhbFN0b3JhZ2U6IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMubG9jYWxTdG9yYWdlKSxcbiAgICAgICAgTG9jYWxTdG9yYWdlVHlwZXM6IGNkay5saXN0TWFwcGVyKGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKShwcm9wZXJ0aWVzLmxvY2FsU3RvcmFnZVR5cGVzKSxcbiAgICAgICAgTWVtb3J5R2lCUGVyVkNwdTogY2ZuQXV0b1NjYWxpbmdHcm91cE1lbW9yeUdpQlBlclZDcHVSZXF1ZXN0UHJvcGVydHlUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMubWVtb3J5R2lCUGVyVkNwdSksXG4gICAgICAgIE1lbW9yeU1pQjogY2ZuQXV0b1NjYWxpbmdHcm91cE1lbW9yeU1pQlJlcXVlc3RQcm9wZXJ0eVRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5tZW1vcnlNaUIpLFxuICAgICAgICBOZXR3b3JrQmFuZHdpZHRoR2JwczogY2ZuQXV0b1NjYWxpbmdHcm91cE5ldHdvcmtCYW5kd2lkdGhHYnBzUmVxdWVzdFByb3BlcnR5VG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLm5ldHdvcmtCYW5kd2lkdGhHYnBzKSxcbiAgICAgICAgTmV0d29ya0ludGVyZmFjZUNvdW50OiBjZm5BdXRvU2NhbGluZ0dyb3VwTmV0d29ya0ludGVyZmFjZUNvdW50UmVxdWVzdFByb3BlcnR5VG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLm5ldHdvcmtJbnRlcmZhY2VDb3VudCksXG4gICAgICAgIE9uRGVtYW5kTWF4UHJpY2VQZXJjZW50YWdlT3Zlckxvd2VzdFByaWNlOiBjZGsubnVtYmVyVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLm9uRGVtYW5kTWF4UHJpY2VQZXJjZW50YWdlT3Zlckxvd2VzdFByaWNlKSxcbiAgICAgICAgUmVxdWlyZUhpYmVybmF0ZVN1cHBvcnQ6IGNkay5ib29sZWFuVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLnJlcXVpcmVIaWJlcm5hdGVTdXBwb3J0KSxcbiAgICAgICAgU3BvdE1heFByaWNlUGVyY2VudGFnZU92ZXJMb3dlc3RQcmljZTogY2RrLm51bWJlclRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5zcG90TWF4UHJpY2VQZXJjZW50YWdlT3Zlckxvd2VzdFByaWNlKSxcbiAgICAgICAgVG90YWxMb2NhbFN0b3JhZ2VHQjogY2ZuQXV0b1NjYWxpbmdHcm91cFRvdGFsTG9jYWxTdG9yYWdlR0JSZXF1ZXN0UHJvcGVydHlUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMudG90YWxMb2NhbFN0b3JhZ2VHYiksXG4gICAgICAgIFZDcHVDb3VudDogY2ZuQXV0b1NjYWxpbmdHcm91cFZDcHVDb3VudFJlcXVlc3RQcm9wZXJ0eVRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy52Q3B1Q291bnQpLFxuICAgIH07XG59XG5cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBDZm5BdXRvU2NhbGluZ0dyb3VwSW5zdGFuY2VSZXF1aXJlbWVudHNQcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0PENmbkF1dG9TY2FsaW5nR3JvdXAuSW5zdGFuY2VSZXF1aXJlbWVudHNQcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZT4ge1xuICAgIGlmIChjZGsuaXNSZXNvbHZhYmxlT2JqZWN0KHByb3BlcnRpZXMpKSB7XG4gICAgICAgIHJldHVybiBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdChwcm9wZXJ0aWVzKTtcbiAgICB9XG4gICAgcHJvcGVydGllcyA9IHByb3BlcnRpZXMgPT0gbnVsbCA/IHt9IDogcHJvcGVydGllcztcbiAgICBpZiAodHlwZW9mIHByb3BlcnRpZXMgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIHJldHVybiBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdChwcm9wZXJ0aWVzKTtcbiAgICB9XG4gICAgY29uc3QgcmV0ID0gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25Qcm9wZXJ0eU9iamVjdDxDZm5BdXRvU2NhbGluZ0dyb3VwLkluc3RhbmNlUmVxdWlyZW1lbnRzUHJvcGVydHk+KCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdhY2NlbGVyYXRvckNvdW50JywgJ0FjY2VsZXJhdG9yQ291bnQnLCBwcm9wZXJ0aWVzLkFjY2VsZXJhdG9yQ291bnQgIT0gbnVsbCA/IENmbkF1dG9TY2FsaW5nR3JvdXBBY2NlbGVyYXRvckNvdW50UmVxdWVzdFByb3BlcnR5RnJvbUNsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuQWNjZWxlcmF0b3JDb3VudCkgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnYWNjZWxlcmF0b3JNYW51ZmFjdHVyZXJzJywgJ0FjY2VsZXJhdG9yTWFudWZhY3R1cmVycycsIHByb3BlcnRpZXMuQWNjZWxlcmF0b3JNYW51ZmFjdHVyZXJzICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZ0FycmF5KHByb3BlcnRpZXMuQWNjZWxlcmF0b3JNYW51ZmFjdHVyZXJzKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdhY2NlbGVyYXRvck5hbWVzJywgJ0FjY2VsZXJhdG9yTmFtZXMnLCBwcm9wZXJ0aWVzLkFjY2VsZXJhdG9yTmFtZXMgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nQXJyYXkocHJvcGVydGllcy5BY2NlbGVyYXRvck5hbWVzKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdhY2NlbGVyYXRvclRvdGFsTWVtb3J5TWlCJywgJ0FjY2VsZXJhdG9yVG90YWxNZW1vcnlNaUInLCBwcm9wZXJ0aWVzLkFjY2VsZXJhdG9yVG90YWxNZW1vcnlNaUIgIT0gbnVsbCA/IENmbkF1dG9TY2FsaW5nR3JvdXBBY2NlbGVyYXRvclRvdGFsTWVtb3J5TWlCUmVxdWVzdFByb3BlcnR5RnJvbUNsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuQWNjZWxlcmF0b3JUb3RhbE1lbW9yeU1pQikgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnYWNjZWxlcmF0b3JUeXBlcycsICdBY2NlbGVyYXRvclR5cGVzJywgcHJvcGVydGllcy5BY2NlbGVyYXRvclR5cGVzICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZ0FycmF5KHByb3BlcnRpZXMuQWNjZWxlcmF0b3JUeXBlcykgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnYWxsb3dlZEluc3RhbmNlVHlwZXMnLCAnQWxsb3dlZEluc3RhbmNlVHlwZXMnLCBwcm9wZXJ0aWVzLkFsbG93ZWRJbnN0YW5jZVR5cGVzICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZ0FycmF5KHByb3BlcnRpZXMuQWxsb3dlZEluc3RhbmNlVHlwZXMpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2JhcmVNZXRhbCcsICdCYXJlTWV0YWwnLCBwcm9wZXJ0aWVzLkJhcmVNZXRhbCAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5CYXJlTWV0YWwpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2Jhc2VsaW5lRWJzQmFuZHdpZHRoTWJwcycsICdCYXNlbGluZUVic0JhbmR3aWR0aE1icHMnLCBwcm9wZXJ0aWVzLkJhc2VsaW5lRWJzQmFuZHdpZHRoTWJwcyAhPSBudWxsID8gQ2ZuQXV0b1NjYWxpbmdHcm91cEJhc2VsaW5lRWJzQmFuZHdpZHRoTWJwc1JlcXVlc3RQcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLkJhc2VsaW5lRWJzQmFuZHdpZHRoTWJwcykgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnYnVyc3RhYmxlUGVyZm9ybWFuY2UnLCAnQnVyc3RhYmxlUGVyZm9ybWFuY2UnLCBwcm9wZXJ0aWVzLkJ1cnN0YWJsZVBlcmZvcm1hbmNlICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLkJ1cnN0YWJsZVBlcmZvcm1hbmNlKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdjcHVNYW51ZmFjdHVyZXJzJywgJ0NwdU1hbnVmYWN0dXJlcnMnLCBwcm9wZXJ0aWVzLkNwdU1hbnVmYWN0dXJlcnMgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nQXJyYXkocHJvcGVydGllcy5DcHVNYW51ZmFjdHVyZXJzKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdleGNsdWRlZEluc3RhbmNlVHlwZXMnLCAnRXhjbHVkZWRJbnN0YW5jZVR5cGVzJywgcHJvcGVydGllcy5FeGNsdWRlZEluc3RhbmNlVHlwZXMgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nQXJyYXkocHJvcGVydGllcy5FeGNsdWRlZEluc3RhbmNlVHlwZXMpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2luc3RhbmNlR2VuZXJhdGlvbnMnLCAnSW5zdGFuY2VHZW5lcmF0aW9ucycsIHByb3BlcnRpZXMuSW5zdGFuY2VHZW5lcmF0aW9ucyAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmdBcnJheShwcm9wZXJ0aWVzLkluc3RhbmNlR2VuZXJhdGlvbnMpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2xvY2FsU3RvcmFnZScsICdMb2NhbFN0b3JhZ2UnLCBwcm9wZXJ0aWVzLkxvY2FsU3RvcmFnZSAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5Mb2NhbFN0b3JhZ2UpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2xvY2FsU3RvcmFnZVR5cGVzJywgJ0xvY2FsU3RvcmFnZVR5cGVzJywgcHJvcGVydGllcy5Mb2NhbFN0b3JhZ2VUeXBlcyAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmdBcnJheShwcm9wZXJ0aWVzLkxvY2FsU3RvcmFnZVR5cGVzKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdtZW1vcnlHaUJQZXJWQ3B1JywgJ01lbW9yeUdpQlBlclZDcHUnLCBwcm9wZXJ0aWVzLk1lbW9yeUdpQlBlclZDcHUgIT0gbnVsbCA/IENmbkF1dG9TY2FsaW5nR3JvdXBNZW1vcnlHaUJQZXJWQ3B1UmVxdWVzdFByb3BlcnR5RnJvbUNsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuTWVtb3J5R2lCUGVyVkNwdSkgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnbWVtb3J5TWlCJywgJ01lbW9yeU1pQicsIHByb3BlcnRpZXMuTWVtb3J5TWlCICE9IG51bGwgPyBDZm5BdXRvU2NhbGluZ0dyb3VwTWVtb3J5TWlCUmVxdWVzdFByb3BlcnR5RnJvbUNsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuTWVtb3J5TWlCKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCduZXR3b3JrQmFuZHdpZHRoR2JwcycsICdOZXR3b3JrQmFuZHdpZHRoR2JwcycsIHByb3BlcnRpZXMuTmV0d29ya0JhbmR3aWR0aEdicHMgIT0gbnVsbCA/IENmbkF1dG9TY2FsaW5nR3JvdXBOZXR3b3JrQmFuZHdpZHRoR2Jwc1JlcXVlc3RQcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLk5ldHdvcmtCYW5kd2lkdGhHYnBzKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCduZXR3b3JrSW50ZXJmYWNlQ291bnQnLCAnTmV0d29ya0ludGVyZmFjZUNvdW50JywgcHJvcGVydGllcy5OZXR3b3JrSW50ZXJmYWNlQ291bnQgIT0gbnVsbCA/IENmbkF1dG9TY2FsaW5nR3JvdXBOZXR3b3JrSW50ZXJmYWNlQ291bnRSZXF1ZXN0UHJvcGVydHlGcm9tQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5OZXR3b3JrSW50ZXJmYWNlQ291bnQpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ29uRGVtYW5kTWF4UHJpY2VQZXJjZW50YWdlT3Zlckxvd2VzdFByaWNlJywgJ09uRGVtYW5kTWF4UHJpY2VQZXJjZW50YWdlT3Zlckxvd2VzdFByaWNlJywgcHJvcGVydGllcy5PbkRlbWFuZE1heFByaWNlUGVyY2VudGFnZU92ZXJMb3dlc3RQcmljZSAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXROdW1iZXIocHJvcGVydGllcy5PbkRlbWFuZE1heFByaWNlUGVyY2VudGFnZU92ZXJMb3dlc3RQcmljZSkgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgncmVxdWlyZUhpYmVybmF0ZVN1cHBvcnQnLCAnUmVxdWlyZUhpYmVybmF0ZVN1cHBvcnQnLCBwcm9wZXJ0aWVzLlJlcXVpcmVIaWJlcm5hdGVTdXBwb3J0ICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldEJvb2xlYW4ocHJvcGVydGllcy5SZXF1aXJlSGliZXJuYXRlU3VwcG9ydCkgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnc3BvdE1heFByaWNlUGVyY2VudGFnZU92ZXJMb3dlc3RQcmljZScsICdTcG90TWF4UHJpY2VQZXJjZW50YWdlT3Zlckxvd2VzdFByaWNlJywgcHJvcGVydGllcy5TcG90TWF4UHJpY2VQZXJjZW50YWdlT3Zlckxvd2VzdFByaWNlICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldE51bWJlcihwcm9wZXJ0aWVzLlNwb3RNYXhQcmljZVBlcmNlbnRhZ2VPdmVyTG93ZXN0UHJpY2UpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ3RvdGFsTG9jYWxTdG9yYWdlR2InLCAnVG90YWxMb2NhbFN0b3JhZ2VHQicsIHByb3BlcnRpZXMuVG90YWxMb2NhbFN0b3JhZ2VHQiAhPSBudWxsID8gQ2ZuQXV0b1NjYWxpbmdHcm91cFRvdGFsTG9jYWxTdG9yYWdlR0JSZXF1ZXN0UHJvcGVydHlGcm9tQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5Ub3RhbExvY2FsU3RvcmFnZUdCKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCd2Q3B1Q291bnQnLCAnVkNwdUNvdW50JywgcHJvcGVydGllcy5WQ3B1Q291bnQgIT0gbnVsbCA/IENmbkF1dG9TY2FsaW5nR3JvdXBWQ3B1Q291bnRSZXF1ZXN0UHJvcGVydHlGcm9tQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5WQ3B1Q291bnQpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkVW5yZWNvZ25pemVkUHJvcGVydGllc0FzRXh0cmEocHJvcGVydGllcyk7XG4gICAgcmV0dXJuIHJldDtcbn1cblxuZXhwb3J0IG5hbWVzcGFjZSBDZm5BdXRvU2NhbGluZ0dyb3VwIHtcbiAgICAvKipcbiAgICAgKiBVc2UgdGhpcyBzdHJ1Y3R1cmUgdG8gc3BlY2lmeSB0aGUgZGlzdHJpYnV0aW9uIG9mIE9uLURlbWFuZCBJbnN0YW5jZXMgYW5kIFNwb3QgSW5zdGFuY2VzIGFuZCB0aGUgYWxsb2NhdGlvbiBzdHJhdGVnaWVzIHVzZWQgdG8gZnVsZmlsbCBPbi1EZW1hbmQgYW5kIFNwb3QgY2FwYWNpdGllcyBmb3IgYSBtaXhlZCBpbnN0YW5jZXMgcG9saWN5LlxuICAgICAqXG4gICAgICogRm9yIG1vcmUgaW5mb3JtYXRpb24sIHNlZSBbQXV0byBTY2FsaW5nIGdyb3VwcyB3aXRoIG11bHRpcGxlIGluc3RhbmNlIHR5cGVzIGFuZCBwdXJjaGFzZSBvcHRpb25zXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vYXV0b3NjYWxpbmcvZWMyL3VzZXJndWlkZS9lYzItYXV0by1zY2FsaW5nLW1peGVkLWluc3RhbmNlcy1ncm91cHMuaHRtbCkgaW4gdGhlICpBbWF6b24gRUMyIEF1dG8gU2NhbGluZyBVc2VyIEd1aWRlKiAuXG4gICAgICpcbiAgICAgKiBgSW5zdGFuY2VzRGlzdHJpYnV0aW9uYCBpcyBhIHByb3BlcnR5IG9mIHRoZSBbQVdTOjpBdXRvU2NhbGluZzo6QXV0b1NjYWxpbmdHcm91cCBNaXhlZEluc3RhbmNlc1BvbGljeV0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXV0b3NjYWxpbmctYXV0b3NjYWxpbmdncm91cC1taXhlZGluc3RhbmNlc3BvbGljeS5odG1sKSBwcm9wZXJ0eSB0eXBlLlxuICAgICAqXG4gICAgICogQHN0cnVjdFxuICAgICAqIEBzdGFiaWxpdHkgZXh0ZXJuYWxcbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvY2ZuLWFzLW1peGVkaW5zdGFuY2VzcG9saWN5LWluc3RhbmNlc2Rpc3RyaWJ1dGlvbi5odG1sXG4gICAgICovXG4gICAgZXhwb3J0IGludGVyZmFjZSBJbnN0YW5jZXNEaXN0cmlidXRpb25Qcm9wZXJ0eSB7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBUaGUgYWxsb2NhdGlvbiBzdHJhdGVneSB0byBhcHBseSB0byB5b3VyIE9uLURlbWFuZCBJbnN0YW5jZXMgd2hlbiB0aGV5IGFyZSBsYXVuY2hlZC4gUG9zc2libGUgaW5zdGFuY2UgdHlwZXMgYXJlIGRldGVybWluZWQgYnkgdGhlIGxhdW5jaCB0ZW1wbGF0ZSBvdmVycmlkZXMgdGhhdCB5b3Ugc3BlY2lmeS5cbiAgICAgICAgICpcbiAgICAgICAgICogVGhlIGZvbGxvd2luZyBsaXN0cyB0aGUgdmFsaWQgdmFsdWVzOlxuICAgICAgICAgKlxuICAgICAgICAgKiAtICoqbG93ZXN0LXByaWNlKiogLSBVc2VzIHByaWNlIHRvIGRldGVybWluZSB3aGljaCBpbnN0YW5jZSB0eXBlcyBhcmUgdGhlIGhpZ2hlc3QgcHJpb3JpdHksIGxhdW5jaGluZyB0aGUgbG93ZXN0IHByaWNlZCBpbnN0YW5jZSB0eXBlcyB3aXRoaW4gYW4gQXZhaWxhYmlsaXR5IFpvbmUgZmlyc3QuIFRoaXMgaXMgdGhlIGRlZmF1bHQgdmFsdWUgZm9yIEF1dG8gU2NhbGluZyBncm91cHMgdGhhdCBzcGVjaWZ5IGBJbnN0YW5jZVJlcXVpcmVtZW50c2AgLlxuICAgICAgICAgKiAtICoqcHJpb3JpdGl6ZWQqKiAtIFlvdSBzZXQgdGhlIG9yZGVyIG9mIGluc3RhbmNlIHR5cGVzIGZvciB0aGUgbGF1bmNoIHRlbXBsYXRlIG92ZXJyaWRlcyBmcm9tIGhpZ2hlc3QgdG8gbG93ZXN0IHByaW9yaXR5IChmcm9tIGZpcnN0IHRvIGxhc3QgaW4gdGhlIGxpc3QpLiBBbWF6b24gRUMyIEF1dG8gU2NhbGluZyBsYXVuY2hlcyB5b3VyIGhpZ2hlc3QgcHJpb3JpdHkgaW5zdGFuY2UgdHlwZXMgZmlyc3QuIElmIGFsbCB5b3VyIE9uLURlbWFuZCBjYXBhY2l0eSBjYW5ub3QgYmUgZnVsZmlsbGVkIHVzaW5nIHlvdXIgaGlnaGVzdCBwcmlvcml0eSBpbnN0YW5jZSB0eXBlLCB0aGVuIEFtYXpvbiBFQzIgQXV0byBTY2FsaW5nIGxhdW5jaGVzIHRoZSByZW1haW5pbmcgY2FwYWNpdHkgdXNpbmcgdGhlIHNlY29uZCBwcmlvcml0eSBpbnN0YW5jZSB0eXBlLCBhbmQgc28gb24uIFRoaXMgaXMgdGhlIGRlZmF1bHQgdmFsdWUgZm9yIEF1dG8gU2NhbGluZyBncm91cHMgdGhhdCBkb24ndCBzcGVjaWZ5IGBJbnN0YW5jZVJlcXVpcmVtZW50c2AgYW5kIGNhbm5vdCBiZSB1c2VkIGZvciBncm91cHMgdGhhdCBkby5cbiAgICAgICAgICpcbiAgICAgICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9jZm4tYXMtbWl4ZWRpbnN0YW5jZXNwb2xpY3ktaW5zdGFuY2VzZGlzdHJpYnV0aW9uLmh0bWwjY2ZuLWF1dG9zY2FsaW5nLWF1dG9zY2FsaW5nZ3JvdXAtaW5zdGFuY2VzZGlzdHJpYnV0aW9uLW9uZGVtYW5kYWxsb2NhdGlvbnN0cmF0ZWd5XG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBvbkRlbWFuZEFsbG9jYXRpb25TdHJhdGVneT86IHN0cmluZztcbiAgICAgICAgLyoqXG4gICAgICAgICAqIFRoZSBtaW5pbXVtIGFtb3VudCBvZiB0aGUgQXV0byBTY2FsaW5nIGdyb3VwJ3MgY2FwYWNpdHkgdGhhdCBtdXN0IGJlIGZ1bGZpbGxlZCBieSBPbi1EZW1hbmQgSW5zdGFuY2VzLiBUaGlzIGJhc2UgcG9ydGlvbiBpcyBsYXVuY2hlZCBmaXJzdCBhcyB5b3VyIGdyb3VwIHNjYWxlcy5cbiAgICAgICAgICpcbiAgICAgICAgICogVGhpcyBudW1iZXIgaGFzIHRoZSBzYW1lIHVuaXQgb2YgbWVhc3VyZW1lbnQgYXMgdGhlIGdyb3VwJ3MgZGVzaXJlZCBjYXBhY2l0eS4gSWYgeW91IGNoYW5nZSB0aGUgZGVmYXVsdCB1bml0IG9mIG1lYXN1cmVtZW50IChudW1iZXIgb2YgaW5zdGFuY2VzKSBieSBzcGVjaWZ5aW5nIHdlaWdodGVkIGNhcGFjaXR5IHZhbHVlcyBpbiB5b3VyIGxhdW5jaCB0ZW1wbGF0ZSBvdmVycmlkZXMgbGlzdCwgb3IgYnkgY2hhbmdpbmcgdGhlIGRlZmF1bHQgZGVzaXJlZCBjYXBhY2l0eSB0eXBlIHNldHRpbmcgb2YgdGhlIGdyb3VwLCB5b3UgbXVzdCBzcGVjaWZ5IHRoaXMgbnVtYmVyIHVzaW5nIHRoZSBzYW1lIHVuaXQgb2YgbWVhc3VyZW1lbnQuXG4gICAgICAgICAqXG4gICAgICAgICAqIERlZmF1bHQ6IDBcbiAgICAgICAgICpcbiAgICAgICAgICogPiBBbiB1cGRhdGUgdG8gdGhpcyBzZXR0aW5nIG1lYW5zIGEgZ3JhZHVhbCByZXBsYWNlbWVudCBvZiBpbnN0YW5jZXMgdG8gYWRqdXN0IHRoZSBjdXJyZW50IE9uLURlbWFuZCBJbnN0YW5jZSBsZXZlbHMuIFdoZW4gcmVwbGFjaW5nIGluc3RhbmNlcywgQW1hem9uIEVDMiBBdXRvIFNjYWxpbmcgbGF1bmNoZXMgbmV3IGluc3RhbmNlcyBiZWZvcmUgdGVybWluYXRpbmcgdGhlIHByZXZpb3VzIG9uZXMuXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvY2ZuLWFzLW1peGVkaW5zdGFuY2VzcG9saWN5LWluc3RhbmNlc2Rpc3RyaWJ1dGlvbi5odG1sI2Nmbi1hdXRvc2NhbGluZy1hdXRvc2NhbGluZ2dyb3VwLWluc3RhbmNlc2Rpc3RyaWJ1dGlvbi1vbmRlbWFuZGJhc2VjYXBhY2l0eVxuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgb25EZW1hbmRCYXNlQ2FwYWNpdHk/OiBudW1iZXI7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBDb250cm9scyB0aGUgcGVyY2VudGFnZXMgb2YgT24tRGVtYW5kIEluc3RhbmNlcyBhbmQgU3BvdCBJbnN0YW5jZXMgZm9yIHlvdXIgYWRkaXRpb25hbCBjYXBhY2l0eSBiZXlvbmQgYE9uRGVtYW5kQmFzZUNhcGFjaXR5YCAuIEV4cHJlc3NlZCBhcyBhIG51bWJlciAoZm9yIGV4YW1wbGUsIDIwIHNwZWNpZmllcyAyMCUgT24tRGVtYW5kIEluc3RhbmNlcywgODAlIFNwb3QgSW5zdGFuY2VzKS4gSWYgc2V0IHRvIDEwMCwgb25seSBPbi1EZW1hbmQgSW5zdGFuY2VzIGFyZSB1c2VkLlxuICAgICAgICAgKlxuICAgICAgICAgKiBEZWZhdWx0OiAxMDBcbiAgICAgICAgICpcbiAgICAgICAgICogPiBBbiB1cGRhdGUgdG8gdGhpcyBzZXR0aW5nIG1lYW5zIGEgZ3JhZHVhbCByZXBsYWNlbWVudCBvZiBpbnN0YW5jZXMgdG8gYWRqdXN0IHRoZSBjdXJyZW50IE9uLURlbWFuZCBhbmQgU3BvdCBJbnN0YW5jZSBsZXZlbHMgZm9yIHlvdXIgYWRkaXRpb25hbCBjYXBhY2l0eSBoaWdoZXIgdGhhbiB0aGUgYmFzZSBjYXBhY2l0eS4gV2hlbiByZXBsYWNpbmcgaW5zdGFuY2VzLCBBbWF6b24gRUMyIEF1dG8gU2NhbGluZyBsYXVuY2hlcyBuZXcgaW5zdGFuY2VzIGJlZm9yZSB0ZXJtaW5hdGluZyB0aGUgcHJldmlvdXMgb25lcy5cbiAgICAgICAgICpcbiAgICAgICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9jZm4tYXMtbWl4ZWRpbnN0YW5jZXNwb2xpY3ktaW5zdGFuY2VzZGlzdHJpYnV0aW9uLmh0bWwjY2ZuLWF1dG9zY2FsaW5nLWF1dG9zY2FsaW5nZ3JvdXAtaW5zdGFuY2VzZGlzdHJpYnV0aW9uLW9uZGVtYW5kcGVyY2VudGFnZWFib3ZlYmFzZWNhcGFjaXR5XG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBvbkRlbWFuZFBlcmNlbnRhZ2VBYm92ZUJhc2VDYXBhY2l0eT86IG51bWJlcjtcbiAgICAgICAgLyoqXG4gICAgICAgICAqIFRoZSBhbGxvY2F0aW9uIHN0cmF0ZWd5IHRvIGFwcGx5IHRvIHlvdXIgU3BvdCBJbnN0YW5jZXMgd2hlbiB0aGV5IGFyZSBsYXVuY2hlZC4gUG9zc2libGUgaW5zdGFuY2UgdHlwZXMgYXJlIGRldGVybWluZWQgYnkgdGhlIGxhdW5jaCB0ZW1wbGF0ZSBvdmVycmlkZXMgdGhhdCB5b3Ugc3BlY2lmeS5cbiAgICAgICAgICpcbiAgICAgICAgICogVGhlIGZvbGxvd2luZyBsaXN0cyB0aGUgdmFsaWQgdmFsdWVzOlxuICAgICAgICAgKlxuICAgICAgICAgKiAtICoqY2FwYWNpdHktb3B0aW1pemVkKiogLSBSZXF1ZXN0cyBTcG90IEluc3RhbmNlcyB1c2luZyBwb29scyB0aGF0IGFyZSBvcHRpbWFsbHkgY2hvc2VuIGJhc2VkIG9uIHRoZSBhdmFpbGFibGUgU3BvdCBjYXBhY2l0eS4gVGhpcyBzdHJhdGVneSBoYXMgdGhlIGxvd2VzdCByaXNrIG9mIGludGVycnVwdGlvbi4gVG8gZ2l2ZSBjZXJ0YWluIGluc3RhbmNlIHR5cGVzIGEgaGlnaGVyIGNoYW5jZSBvZiBsYXVuY2hpbmcgZmlyc3QsIHVzZSBgY2FwYWNpdHktb3B0aW1pemVkLXByaW9yaXRpemVkYCAuXG4gICAgICAgICAqIC0gKipjYXBhY2l0eS1vcHRpbWl6ZWQtcHJpb3JpdGl6ZWQqKiAtIFlvdSBzZXQgdGhlIG9yZGVyIG9mIGluc3RhbmNlIHR5cGVzIGZvciB0aGUgbGF1bmNoIHRlbXBsYXRlIG92ZXJyaWRlcyBmcm9tIGhpZ2hlc3QgdG8gbG93ZXN0IHByaW9yaXR5IChmcm9tIGZpcnN0IHRvIGxhc3QgaW4gdGhlIGxpc3QpLiBBbWF6b24gRUMyIEF1dG8gU2NhbGluZyBob25vcnMgdGhlIGluc3RhbmNlIHR5cGUgcHJpb3JpdGllcyBvbiBhIGJlc3QgZWZmb3J0IGJhc2lzIGJ1dCBvcHRpbWl6ZXMgZm9yIGNhcGFjaXR5IGZpcnN0LiBOb3RlIHRoYXQgaWYgdGhlIE9uLURlbWFuZCBhbGxvY2F0aW9uIHN0cmF0ZWd5IGlzIHNldCB0byBgcHJpb3JpdGl6ZWRgICwgdGhlIHNhbWUgcHJpb3JpdHkgaXMgYXBwbGllZCB3aGVuIGZ1bGZpbGxpbmcgT24tRGVtYW5kIGNhcGFjaXR5LiBUaGlzIGlzIG5vdCBhIHZhbGlkIHZhbHVlIGZvciBBdXRvIFNjYWxpbmcgZ3JvdXBzIHRoYXQgc3BlY2lmeSBgSW5zdGFuY2VSZXF1aXJlbWVudHNgIC5cbiAgICAgICAgICogLSAqKmxvd2VzdC1wcmljZSoqIC0gUmVxdWVzdHMgU3BvdCBJbnN0YW5jZXMgdXNpbmcgdGhlIGxvd2VzdCBwcmljZWQgcG9vbHMgd2l0aGluIGFuIEF2YWlsYWJpbGl0eSBab25lLCBhY3Jvc3MgdGhlIG51bWJlciBvZiBTcG90IHBvb2xzIHRoYXQgeW91IHNwZWNpZnkgZm9yIHRoZSBgU3BvdEluc3RhbmNlUG9vbHNgIHByb3BlcnR5LiBUbyBlbnN1cmUgdGhhdCB5b3VyIGRlc2lyZWQgY2FwYWNpdHkgaXMgbWV0LCB5b3UgbWlnaHQgcmVjZWl2ZSBTcG90IEluc3RhbmNlcyBmcm9tIHNldmVyYWwgcG9vbHMuIFRoaXMgaXMgdGhlIGRlZmF1bHQgdmFsdWUsIGJ1dCBpdCBtaWdodCBsZWFkIHRvIGhpZ2ggaW50ZXJydXB0aW9uIHJhdGVzIGJlY2F1c2UgdGhpcyBzdHJhdGVneSBvbmx5IGNvbnNpZGVycyBpbnN0YW5jZSBwcmljZSBhbmQgbm90IGF2YWlsYWJsZSBjYXBhY2l0eS5cbiAgICAgICAgICogLSAqKnByaWNlLWNhcGFjaXR5LW9wdGltaXplZCAocmVjb21tZW5kZWQpKiogLSBUaGUgcHJpY2UgYW5kIGNhcGFjaXR5IG9wdGltaXplZCBhbGxvY2F0aW9uIHN0cmF0ZWd5IGxvb2tzIGF0IGJvdGggcHJpY2UgYW5kIGNhcGFjaXR5IHRvIHNlbGVjdCB0aGUgU3BvdCBJbnN0YW5jZSBwb29scyB0aGF0IGFyZSB0aGUgbGVhc3QgbGlrZWx5IHRvIGJlIGludGVycnVwdGVkIGFuZCBoYXZlIHRoZSBsb3dlc3QgcG9zc2libGUgcHJpY2UuXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvY2ZuLWFzLW1peGVkaW5zdGFuY2VzcG9saWN5LWluc3RhbmNlc2Rpc3RyaWJ1dGlvbi5odG1sI2Nmbi1hdXRvc2NhbGluZy1hdXRvc2NhbGluZ2dyb3VwLWluc3RhbmNlc2Rpc3RyaWJ1dGlvbi1zcG90YWxsb2NhdGlvbnN0cmF0ZWd5XG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBzcG90QWxsb2NhdGlvblN0cmF0ZWd5Pzogc3RyaW5nO1xuICAgICAgICAvKipcbiAgICAgICAgICogVGhlIG51bWJlciBvZiBTcG90IEluc3RhbmNlIHBvb2xzIGFjcm9zcyB3aGljaCB0byBhbGxvY2F0ZSB5b3VyIFNwb3QgSW5zdGFuY2VzLiBUaGUgU3BvdCBwb29scyBhcmUgZGV0ZXJtaW5lZCBmcm9tIHRoZSBkaWZmZXJlbnQgaW5zdGFuY2UgdHlwZXMgaW4gdGhlIG92ZXJyaWRlcy4gVmFsaWQgb25seSB3aGVuIHRoZSBgU3BvdEFsbG9jYXRpb25TdHJhdGVneWAgaXMgYGxvd2VzdC1wcmljZWAgLiBWYWx1ZSBtdXN0IGJlIGluIHRoZSByYW5nZSBvZiAx4oCTMjAuXG4gICAgICAgICAqXG4gICAgICAgICAqIERlZmF1bHQ6IDJcbiAgICAgICAgICpcbiAgICAgICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9jZm4tYXMtbWl4ZWRpbnN0YW5jZXNwb2xpY3ktaW5zdGFuY2VzZGlzdHJpYnV0aW9uLmh0bWwjY2ZuLWF1dG9zY2FsaW5nLWF1dG9zY2FsaW5nZ3JvdXAtaW5zdGFuY2VzZGlzdHJpYnV0aW9uLXNwb3RpbnN0YW5jZXBvb2xzXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBzcG90SW5zdGFuY2VQb29scz86IG51bWJlcjtcbiAgICAgICAgLyoqXG4gICAgICAgICAqIFRoZSBtYXhpbXVtIHByaWNlIHBlciB1bml0IGhvdXIgdGhhdCB5b3UgYXJlIHdpbGxpbmcgdG8gcGF5IGZvciBhIFNwb3QgSW5zdGFuY2UuIElmIHlvdXIgbWF4aW11bSBwcmljZSBpcyBsb3dlciB0aGFuIHRoZSBTcG90IHByaWNlIGZvciB0aGUgaW5zdGFuY2UgdHlwZXMgdGhhdCB5b3Ugc2VsZWN0ZWQsIHlvdXIgU3BvdCBJbnN0YW5jZXMgYXJlIG5vdCBsYXVuY2hlZC4gV2UgZG8gbm90IHJlY29tbWVuZCBzcGVjaWZ5aW5nIGEgbWF4aW11bSBwcmljZSBiZWNhdXNlIGl0IGNhbiBsZWFkIHRvIGluY3JlYXNlZCBpbnRlcnJ1cHRpb25zLiBXaGVuIFNwb3QgSW5zdGFuY2VzIGxhdW5jaCwgeW91IHBheSB0aGUgY3VycmVudCBTcG90IHByaWNlLiBUbyByZW1vdmUgYSBtYXhpbXVtIHByaWNlIHRoYXQgeW91IHByZXZpb3VzbHkgc2V0LCBpbmNsdWRlIHRoZSBwcm9wZXJ0eSBidXQgc3BlY2lmeSBhbiBlbXB0eSBzdHJpbmcgKFwiXCIpIGZvciB0aGUgdmFsdWUuXG4gICAgICAgICAqXG4gICAgICAgICAqID4gSWYgeW91IHNwZWNpZnkgYSBtYXhpbXVtIHByaWNlLCB5b3VyIGluc3RhbmNlcyB3aWxsIGJlIGludGVycnVwdGVkIG1vcmUgZnJlcXVlbnRseSB0aGFuIGlmIHlvdSBkbyBub3Qgc3BlY2lmeSBvbmUuXG4gICAgICAgICAqXG4gICAgICAgICAqIFZhbGlkIFJhbmdlOiBNaW5pbXVtIHZhbHVlIG9mIDAuMDAxXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvY2ZuLWFzLW1peGVkaW5zdGFuY2VzcG9saWN5LWluc3RhbmNlc2Rpc3RyaWJ1dGlvbi5odG1sI2Nmbi1hdXRvc2NhbGluZy1hdXRvc2NhbGluZ2dyb3VwLWluc3RhbmNlc2Rpc3RyaWJ1dGlvbi1zcG90bWF4cHJpY2VcbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IHNwb3RNYXhQcmljZT86IHN0cmluZztcbiAgICB9XG59XG5cbi8qKlxuICogRGV0ZXJtaW5lIHdoZXRoZXIgdGhlIGdpdmVuIHByb3BlcnRpZXMgbWF0Y2ggdGhvc2Ugb2YgYSBgSW5zdGFuY2VzRGlzdHJpYnV0aW9uUHJvcGVydHlgXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYEluc3RhbmNlc0Rpc3RyaWJ1dGlvblByb3BlcnR5YFxuICpcbiAqIEByZXR1cm5zIHRoZSByZXN1bHQgb2YgdGhlIHZhbGlkYXRpb24uXG4gKi9cbmZ1bmN0aW9uIENmbkF1dG9TY2FsaW5nR3JvdXBfSW5zdGFuY2VzRGlzdHJpYnV0aW9uUHJvcGVydHlWYWxpZGF0b3IocHJvcGVydGllczogYW55KTogY2RrLlZhbGlkYXRpb25SZXN1bHQge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIGNkay5WQUxJREFUSU9OX1NVQ0NFU1M7IH1cbiAgICBjb25zdCBlcnJvcnMgPSBuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHRzKCk7XG4gICAgaWYgKHR5cGVvZiBwcm9wZXJ0aWVzICE9PSAnb2JqZWN0Jykge1xuICAgICAgICBlcnJvcnMuY29sbGVjdChuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHQoJ0V4cGVjdGVkIGFuIG9iamVjdCwgYnV0IHJlY2VpdmVkOiAnICsgSlNPTi5zdHJpbmdpZnkocHJvcGVydGllcykpKTtcbiAgICB9XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdvbkRlbWFuZEFsbG9jYXRpb25TdHJhdGVneScsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5vbkRlbWFuZEFsbG9jYXRpb25TdHJhdGVneSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignb25EZW1hbmRCYXNlQ2FwYWNpdHknLCBjZGsudmFsaWRhdGVOdW1iZXIpKHByb3BlcnRpZXMub25EZW1hbmRCYXNlQ2FwYWNpdHkpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ29uRGVtYW5kUGVyY2VudGFnZUFib3ZlQmFzZUNhcGFjaXR5JywgY2RrLnZhbGlkYXRlTnVtYmVyKShwcm9wZXJ0aWVzLm9uRGVtYW5kUGVyY2VudGFnZUFib3ZlQmFzZUNhcGFjaXR5KSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdzcG90QWxsb2NhdGlvblN0cmF0ZWd5JywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLnNwb3RBbGxvY2F0aW9uU3RyYXRlZ3kpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3Nwb3RJbnN0YW5jZVBvb2xzJywgY2RrLnZhbGlkYXRlTnVtYmVyKShwcm9wZXJ0aWVzLnNwb3RJbnN0YW5jZVBvb2xzKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdzcG90TWF4UHJpY2UnLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuc3BvdE1heFByaWNlKSk7XG4gICAgcmV0dXJuIGVycm9ycy53cmFwKCdzdXBwbGllZCBwcm9wZXJ0aWVzIG5vdCBjb3JyZWN0IGZvciBcIkluc3RhbmNlc0Rpc3RyaWJ1dGlvblByb3BlcnR5XCInKTtcbn1cblxuLyoqXG4gKiBSZW5kZXJzIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpBdXRvU2NhbGluZzo6QXV0b1NjYWxpbmdHcm91cC5JbnN0YW5jZXNEaXN0cmlidXRpb25gIHJlc291cmNlXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYEluc3RhbmNlc0Rpc3RyaWJ1dGlvblByb3BlcnR5YFxuICpcbiAqIEByZXR1cm5zIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpBdXRvU2NhbGluZzo6QXV0b1NjYWxpbmdHcm91cC5JbnN0YW5jZXNEaXN0cmlidXRpb25gIHJlc291cmNlLlxuICovXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gY2ZuQXV0b1NjYWxpbmdHcm91cEluc3RhbmNlc0Rpc3RyaWJ1dGlvblByb3BlcnR5VG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBhbnkge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIHByb3BlcnRpZXM7IH1cbiAgICBDZm5BdXRvU2NhbGluZ0dyb3VwX0luc3RhbmNlc0Rpc3RyaWJ1dGlvblByb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXMpLmFzc2VydFN1Y2Nlc3MoKTtcbiAgICByZXR1cm4ge1xuICAgICAgICBPbkRlbWFuZEFsbG9jYXRpb25TdHJhdGVneTogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5vbkRlbWFuZEFsbG9jYXRpb25TdHJhdGVneSksXG4gICAgICAgIE9uRGVtYW5kQmFzZUNhcGFjaXR5OiBjZGsubnVtYmVyVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLm9uRGVtYW5kQmFzZUNhcGFjaXR5KSxcbiAgICAgICAgT25EZW1hbmRQZXJjZW50YWdlQWJvdmVCYXNlQ2FwYWNpdHk6IGNkay5udW1iZXJUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMub25EZW1hbmRQZXJjZW50YWdlQWJvdmVCYXNlQ2FwYWNpdHkpLFxuICAgICAgICBTcG90QWxsb2NhdGlvblN0cmF0ZWd5OiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLnNwb3RBbGxvY2F0aW9uU3RyYXRlZ3kpLFxuICAgICAgICBTcG90SW5zdGFuY2VQb29sczogY2RrLm51bWJlclRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5zcG90SW5zdGFuY2VQb29scyksXG4gICAgICAgIFNwb3RNYXhQcmljZTogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5zcG90TWF4UHJpY2UpLFxuICAgIH07XG59XG5cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBDZm5BdXRvU2NhbGluZ0dyb3VwSW5zdGFuY2VzRGlzdHJpYnV0aW9uUHJvcGVydHlGcm9tQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdDxDZm5BdXRvU2NhbGluZ0dyb3VwLkluc3RhbmNlc0Rpc3RyaWJ1dGlvblByb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlPiB7XG4gICAgaWYgKGNkay5pc1Jlc29sdmFibGVPYmplY3QocHJvcGVydGllcykpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0KHByb3BlcnRpZXMpO1xuICAgIH1cbiAgICBwcm9wZXJ0aWVzID0gcHJvcGVydGllcyA9PSBudWxsID8ge30gOiBwcm9wZXJ0aWVzO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0KHByb3BlcnRpZXMpO1xuICAgIH1cbiAgICBjb25zdCByZXQgPSBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblByb3BlcnR5T2JqZWN0PENmbkF1dG9TY2FsaW5nR3JvdXAuSW5zdGFuY2VzRGlzdHJpYnV0aW9uUHJvcGVydHk+KCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdvbkRlbWFuZEFsbG9jYXRpb25TdHJhdGVneScsICdPbkRlbWFuZEFsbG9jYXRpb25TdHJhdGVneScsIHByb3BlcnRpZXMuT25EZW1hbmRBbGxvY2F0aW9uU3RyYXRlZ3kgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuT25EZW1hbmRBbGxvY2F0aW9uU3RyYXRlZ3kpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ29uRGVtYW5kQmFzZUNhcGFjaXR5JywgJ09uRGVtYW5kQmFzZUNhcGFjaXR5JywgcHJvcGVydGllcy5PbkRlbWFuZEJhc2VDYXBhY2l0eSAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXROdW1iZXIocHJvcGVydGllcy5PbkRlbWFuZEJhc2VDYXBhY2l0eSkgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnb25EZW1hbmRQZXJjZW50YWdlQWJvdmVCYXNlQ2FwYWNpdHknLCAnT25EZW1hbmRQZXJjZW50YWdlQWJvdmVCYXNlQ2FwYWNpdHknLCBwcm9wZXJ0aWVzLk9uRGVtYW5kUGVyY2VudGFnZUFib3ZlQmFzZUNhcGFjaXR5ICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldE51bWJlcihwcm9wZXJ0aWVzLk9uRGVtYW5kUGVyY2VudGFnZUFib3ZlQmFzZUNhcGFjaXR5KSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdzcG90QWxsb2NhdGlvblN0cmF0ZWd5JywgJ1Nwb3RBbGxvY2F0aW9uU3RyYXRlZ3knLCBwcm9wZXJ0aWVzLlNwb3RBbGxvY2F0aW9uU3RyYXRlZ3kgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuU3BvdEFsbG9jYXRpb25TdHJhdGVneSkgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnc3BvdEluc3RhbmNlUG9vbHMnLCAnU3BvdEluc3RhbmNlUG9vbHMnLCBwcm9wZXJ0aWVzLlNwb3RJbnN0YW5jZVBvb2xzICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldE51bWJlcihwcm9wZXJ0aWVzLlNwb3RJbnN0YW5jZVBvb2xzKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdzcG90TWF4UHJpY2UnLCAnU3BvdE1heFByaWNlJywgcHJvcGVydGllcy5TcG90TWF4UHJpY2UgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuU3BvdE1heFByaWNlKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFVucmVjb2duaXplZFByb3BlcnRpZXNBc0V4dHJhKHByb3BlcnRpZXMpO1xuICAgIHJldHVybiByZXQ7XG59XG5cbmV4cG9ydCBuYW1lc3BhY2UgQ2ZuQXV0b1NjYWxpbmdHcm91cCB7XG4gICAgLyoqXG4gICAgICogVXNlIHRoaXMgc3RydWN0dXJlIHRvIHNwZWNpZnkgdGhlIGxhdW5jaCB0ZW1wbGF0ZXMgYW5kIGluc3RhbmNlIHR5cGVzIChvdmVycmlkZXMpIGZvciBhIG1peGVkIGluc3RhbmNlcyBwb2xpY3kuXG4gICAgICpcbiAgICAgKiBgTGF1bmNoVGVtcGxhdGVgIGlzIGEgcHJvcGVydHkgb2YgdGhlIFtBV1M6OkF1dG9TY2FsaW5nOjpBdXRvU2NhbGluZ0dyb3VwIE1peGVkSW5zdGFuY2VzUG9saWN5XShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hdXRvc2NhbGluZy1hdXRvc2NhbGluZ2dyb3VwLW1peGVkaW5zdGFuY2VzcG9saWN5Lmh0bWwpIHByb3BlcnR5IHR5cGUuXG4gICAgICpcbiAgICAgKiBAc3RydWN0XG4gICAgICogQHN0YWJpbGl0eSBleHRlcm5hbFxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9jZm4tYXMtbWl4ZWRpbnN0YW5jZXNwb2xpY3ktbGF1bmNodGVtcGxhdGUuaHRtbFxuICAgICAqL1xuICAgIGV4cG9ydCBpbnRlcmZhY2UgTGF1bmNoVGVtcGxhdGVQcm9wZXJ0eSB7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBUaGUgbGF1bmNoIHRlbXBsYXRlLlxuICAgICAgICAgKlxuICAgICAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2Nmbi1hcy1taXhlZGluc3RhbmNlc3BvbGljeS1sYXVuY2h0ZW1wbGF0ZS5odG1sI2Nmbi1hcy1ncm91cC1sYXVuY2h0ZW1wbGF0ZVxuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgbGF1bmNoVGVtcGxhdGVTcGVjaWZpY2F0aW9uOiBDZm5BdXRvU2NhbGluZ0dyb3VwLkxhdW5jaFRlbXBsYXRlU3BlY2lmaWNhdGlvblByb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlO1xuICAgICAgICAvKipcbiAgICAgICAgICogQW55IHByb3BlcnRpZXMgdGhhdCB5b3Ugc3BlY2lmeSBvdmVycmlkZSB0aGUgc2FtZSBwcm9wZXJ0aWVzIGluIHRoZSBsYXVuY2ggdGVtcGxhdGUuXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvY2ZuLWFzLW1peGVkaW5zdGFuY2VzcG9saWN5LWxhdW5jaHRlbXBsYXRlLmh0bWwjY2ZuLWFzLW1peGVkaW5zdGFuY2VzcG9saWN5LW92ZXJyaWRlc1xuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgb3ZlcnJpZGVzPzogQXJyYXk8Q2ZuQXV0b1NjYWxpbmdHcm91cC5MYXVuY2hUZW1wbGF0ZU92ZXJyaWRlc1Byb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlPiB8IGNkay5JUmVzb2x2YWJsZTtcbiAgICB9XG59XG5cbi8qKlxuICogRGV0ZXJtaW5lIHdoZXRoZXIgdGhlIGdpdmVuIHByb3BlcnRpZXMgbWF0Y2ggdGhvc2Ugb2YgYSBgTGF1bmNoVGVtcGxhdGVQcm9wZXJ0eWBcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgTGF1bmNoVGVtcGxhdGVQcm9wZXJ0eWBcbiAqXG4gKiBAcmV0dXJucyB0aGUgcmVzdWx0IG9mIHRoZSB2YWxpZGF0aW9uLlxuICovXG5mdW5jdGlvbiBDZm5BdXRvU2NhbGluZ0dyb3VwX0xhdW5jaFRlbXBsYXRlUHJvcGVydHlWYWxpZGF0b3IocHJvcGVydGllczogYW55KTogY2RrLlZhbGlkYXRpb25SZXN1bHQge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIGNkay5WQUxJREFUSU9OX1NVQ0NFU1M7IH1cbiAgICBjb25zdCBlcnJvcnMgPSBuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHRzKCk7XG4gICAgaWYgKHR5cGVvZiBwcm9wZXJ0aWVzICE9PSAnb2JqZWN0Jykge1xuICAgICAgICBlcnJvcnMuY29sbGVjdChuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHQoJ0V4cGVjdGVkIGFuIG9iamVjdCwgYnV0IHJlY2VpdmVkOiAnICsgSlNPTi5zdHJpbmdpZnkocHJvcGVydGllcykpKTtcbiAgICB9XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdsYXVuY2hUZW1wbGF0ZVNwZWNpZmljYXRpb24nLCBjZGsucmVxdWlyZWRWYWxpZGF0b3IpKHByb3BlcnRpZXMubGF1bmNoVGVtcGxhdGVTcGVjaWZpY2F0aW9uKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdsYXVuY2hUZW1wbGF0ZVNwZWNpZmljYXRpb24nLCBDZm5BdXRvU2NhbGluZ0dyb3VwX0xhdW5jaFRlbXBsYXRlU3BlY2lmaWNhdGlvblByb3BlcnR5VmFsaWRhdG9yKShwcm9wZXJ0aWVzLmxhdW5jaFRlbXBsYXRlU3BlY2lmaWNhdGlvbikpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignb3ZlcnJpZGVzJywgY2RrLmxpc3RWYWxpZGF0b3IoQ2ZuQXV0b1NjYWxpbmdHcm91cF9MYXVuY2hUZW1wbGF0ZU92ZXJyaWRlc1Byb3BlcnR5VmFsaWRhdG9yKSkocHJvcGVydGllcy5vdmVycmlkZXMpKTtcbiAgICByZXR1cm4gZXJyb3JzLndyYXAoJ3N1cHBsaWVkIHByb3BlcnRpZXMgbm90IGNvcnJlY3QgZm9yIFwiTGF1bmNoVGVtcGxhdGVQcm9wZXJ0eVwiJyk7XG59XG5cbi8qKlxuICogUmVuZGVycyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6QXV0b1NjYWxpbmc6OkF1dG9TY2FsaW5nR3JvdXAuTGF1bmNoVGVtcGxhdGVgIHJlc291cmNlXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYExhdW5jaFRlbXBsYXRlUHJvcGVydHlgXG4gKlxuICogQHJldHVybnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OkF1dG9TY2FsaW5nOjpBdXRvU2NhbGluZ0dyb3VwLkxhdW5jaFRlbXBsYXRlYCByZXNvdXJjZS5cbiAqL1xuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIGNmbkF1dG9TY2FsaW5nR3JvdXBMYXVuY2hUZW1wbGF0ZVByb3BlcnR5VG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBhbnkge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIHByb3BlcnRpZXM7IH1cbiAgICBDZm5BdXRvU2NhbGluZ0dyb3VwX0xhdW5jaFRlbXBsYXRlUHJvcGVydHlWYWxpZGF0b3IocHJvcGVydGllcykuYXNzZXJ0U3VjY2VzcygpO1xuICAgIHJldHVybiB7XG4gICAgICAgIExhdW5jaFRlbXBsYXRlU3BlY2lmaWNhdGlvbjogY2ZuQXV0b1NjYWxpbmdHcm91cExhdW5jaFRlbXBsYXRlU3BlY2lmaWNhdGlvblByb3BlcnR5VG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLmxhdW5jaFRlbXBsYXRlU3BlY2lmaWNhdGlvbiksXG4gICAgICAgIE92ZXJyaWRlczogY2RrLmxpc3RNYXBwZXIoY2ZuQXV0b1NjYWxpbmdHcm91cExhdW5jaFRlbXBsYXRlT3ZlcnJpZGVzUHJvcGVydHlUb0Nsb3VkRm9ybWF0aW9uKShwcm9wZXJ0aWVzLm92ZXJyaWRlcyksXG4gICAgfTtcbn1cblxuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIENmbkF1dG9TY2FsaW5nR3JvdXBMYXVuY2hUZW1wbGF0ZVByb3BlcnR5RnJvbUNsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQ8Q2ZuQXV0b1NjYWxpbmdHcm91cC5MYXVuY2hUZW1wbGF0ZVByb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlPiB7XG4gICAgaWYgKGNkay5pc1Jlc29sdmFibGVPYmplY3QocHJvcGVydGllcykpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0KHByb3BlcnRpZXMpO1xuICAgIH1cbiAgICBwcm9wZXJ0aWVzID0gcHJvcGVydGllcyA9PSBudWxsID8ge30gOiBwcm9wZXJ0aWVzO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0KHByb3BlcnRpZXMpO1xuICAgIH1cbiAgICBjb25zdCByZXQgPSBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblByb3BlcnR5T2JqZWN0PENmbkF1dG9TY2FsaW5nR3JvdXAuTGF1bmNoVGVtcGxhdGVQcm9wZXJ0eT4oKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2xhdW5jaFRlbXBsYXRlU3BlY2lmaWNhdGlvbicsICdMYXVuY2hUZW1wbGF0ZVNwZWNpZmljYXRpb24nLCBDZm5BdXRvU2NhbGluZ0dyb3VwTGF1bmNoVGVtcGxhdGVTcGVjaWZpY2F0aW9uUHJvcGVydHlGcm9tQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5MYXVuY2hUZW1wbGF0ZVNwZWNpZmljYXRpb24pKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ292ZXJyaWRlcycsICdPdmVycmlkZXMnLCBwcm9wZXJ0aWVzLk92ZXJyaWRlcyAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRBcnJheShDZm5BdXRvU2NhbGluZ0dyb3VwTGF1bmNoVGVtcGxhdGVPdmVycmlkZXNQcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbikocHJvcGVydGllcy5PdmVycmlkZXMpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkVW5yZWNvZ25pemVkUHJvcGVydGllc0FzRXh0cmEocHJvcGVydGllcyk7XG4gICAgcmV0dXJuIHJldDtcbn1cblxuZXhwb3J0IG5hbWVzcGFjZSBDZm5BdXRvU2NhbGluZ0dyb3VwIHtcbiAgICAvKipcbiAgICAgKiBVc2UgdGhpcyBzdHJ1Y3R1cmUgdG8gbGV0IEFtYXpvbiBFQzIgQXV0byBTY2FsaW5nIGRvIHRoZSBmb2xsb3dpbmcgd2hlbiB0aGUgQXV0byBTY2FsaW5nIGdyb3VwIGhhcyBhIG1peGVkIGluc3RhbmNlcyBwb2xpY3k6XG4gICAgICpcbiAgICAgKiAtIE92ZXJyaWRlIHRoZSBpbnN0YW5jZSB0eXBlIHRoYXQgaXMgc3BlY2lmaWVkIGluIHRoZSBsYXVuY2ggdGVtcGxhdGUuXG4gICAgICogLSBVc2UgbXVsdGlwbGUgaW5zdGFuY2UgdHlwZXMuXG4gICAgICpcbiAgICAgKiBTcGVjaWZ5IHRoZSBpbnN0YW5jZSB0eXBlcyB0aGF0IHlvdSB3YW50LCBvciBkZWZpbmUgeW91ciBpbnN0YW5jZSByZXF1aXJlbWVudHMgaW5zdGVhZCBhbmQgbGV0IEFtYXpvbiBFQzIgQXV0byBTY2FsaW5nIHByb3Zpc2lvbiB0aGUgYXZhaWxhYmxlIGluc3RhbmNlIHR5cGVzIHRoYXQgbWVldCB5b3VyIHJlcXVpcmVtZW50cy4gVGhpcyBjYW4gcHJvdmlkZSBBbWF6b24gRUMyIEF1dG8gU2NhbGluZyB3aXRoIGEgbGFyZ2VyIHNlbGVjdGlvbiBvZiBpbnN0YW5jZSB0eXBlcyB0byBjaG9vc2UgZnJvbSB3aGVuIGZ1bGZpbGxpbmcgU3BvdCBhbmQgT24tRGVtYW5kIGNhcGFjaXRpZXMuIFlvdSBjYW4gdmlldyB3aGljaCBpbnN0YW5jZSB0eXBlcyBhcmUgbWF0Y2hlZCBiZWZvcmUgeW91IGFwcGx5IHRoZSBpbnN0YW5jZSByZXF1aXJlbWVudHMgdG8geW91ciBBdXRvIFNjYWxpbmcgZ3JvdXAuXG4gICAgICpcbiAgICAgKiBBZnRlciB5b3UgZGVmaW5lIHlvdXIgaW5zdGFuY2UgcmVxdWlyZW1lbnRzLCB5b3UgZG9uJ3QgaGF2ZSB0byBrZWVwIHVwZGF0aW5nIHRoZXNlIHNldHRpbmdzIHRvIGdldCBuZXcgRUMyIGluc3RhbmNlIHR5cGVzIGF1dG9tYXRpY2FsbHkuIEFtYXpvbiBFQzIgQXV0byBTY2FsaW5nIHVzZXMgdGhlIGluc3RhbmNlIHJlcXVpcmVtZW50cyBvZiB0aGUgQXV0byBTY2FsaW5nIGdyb3VwIHRvIGRldGVybWluZSB3aGV0aGVyIGEgbmV3IEVDMiBpbnN0YW5jZSB0eXBlIGNhbiBiZSB1c2VkLlxuICAgICAqXG4gICAgICogYExhdW5jaFRlbXBsYXRlT3ZlcnJpZGVzYCBpcyBhIHByb3BlcnR5IG9mIHRoZSBbQVdTOjpBdXRvU2NhbGluZzo6QXV0b1NjYWxpbmdHcm91cCBMYXVuY2hUZW1wbGF0ZV0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXV0b3NjYWxpbmctYXV0b3NjYWxpbmdncm91cC1sYXVuY2h0ZW1wbGF0ZS5odG1sKSBwcm9wZXJ0eSB0eXBlLlxuICAgICAqXG4gICAgICogQHN0cnVjdFxuICAgICAqIEBzdGFiaWxpdHkgZXh0ZXJuYWxcbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvY2ZuLWFzLW1peGVkaW5zdGFuY2VzcG9saWN5LWxhdW5jaHRlbXBsYXRlb3ZlcnJpZGVzLmh0bWxcbiAgICAgKi9cbiAgICBleHBvcnQgaW50ZXJmYWNlIExhdW5jaFRlbXBsYXRlT3ZlcnJpZGVzUHJvcGVydHkge1xuICAgICAgICAvKipcbiAgICAgICAgICogVGhlIGluc3RhbmNlIHJlcXVpcmVtZW50cy4gQW1hem9uIEVDMiBBdXRvIFNjYWxpbmcgdXNlcyB5b3VyIHNwZWNpZmllZCByZXF1aXJlbWVudHMgdG8gaWRlbnRpZnkgaW5zdGFuY2UgdHlwZXMuIFRoZW4sIGl0IHVzZXMgeW91ciBPbi1EZW1hbmQgYW5kIFNwb3QgYWxsb2NhdGlvbiBzdHJhdGVnaWVzIHRvIGxhdW5jaCBpbnN0YW5jZXMgZnJvbSB0aGVzZSBpbnN0YW5jZSB0eXBlcy5cbiAgICAgICAgICpcbiAgICAgICAgICogWW91IGNhbiBzcGVjaWZ5IHVwIHRvIGZvdXIgc2VwYXJhdGUgc2V0cyBvZiBpbnN0YW5jZSByZXF1aXJlbWVudHMgcGVyIEF1dG8gU2NhbGluZyBncm91cC4gVGhpcyBpcyB1c2VmdWwgZm9yIHByb3Zpc2lvbmluZyBpbnN0YW5jZXMgZnJvbSBkaWZmZXJlbnQgQW1hem9uIE1hY2hpbmUgSW1hZ2VzIChBTUlzKSBpbiB0aGUgc2FtZSBBdXRvIFNjYWxpbmcgZ3JvdXAuIFRvIGRvIHRoaXMsIGNyZWF0ZSB0aGUgQU1JcyBhbmQgY3JlYXRlIGEgbmV3IGxhdW5jaCB0ZW1wbGF0ZSBmb3IgZWFjaCBBTUkuIFRoZW4sIGNyZWF0ZSBhIGNvbXBhdGlibGUgc2V0IG9mIGluc3RhbmNlIHJlcXVpcmVtZW50cyBmb3IgZWFjaCBsYXVuY2ggdGVtcGxhdGUuXG4gICAgICAgICAqXG4gICAgICAgICAqID4gSWYgeW91IHNwZWNpZnkgYEluc3RhbmNlUmVxdWlyZW1lbnRzYCAsIHlvdSBjYW4ndCBzcGVjaWZ5IGBJbnN0YW5jZVR5cGVgIC5cbiAgICAgICAgICpcbiAgICAgICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9jZm4tYXMtbWl4ZWRpbnN0YW5jZXNwb2xpY3ktbGF1bmNodGVtcGxhdGVvdmVycmlkZXMuaHRtbCNjZm4tYXMtbWl4ZWRpbnN0YW5jZXNwb2xpY3ktaW5zdGFuY2VyZXF1aXJlbWVudHNcbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IGluc3RhbmNlUmVxdWlyZW1lbnRzPzogQ2ZuQXV0b1NjYWxpbmdHcm91cC5JbnN0YW5jZVJlcXVpcmVtZW50c1Byb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlO1xuICAgICAgICAvKipcbiAgICAgICAgICogVGhlIGluc3RhbmNlIHR5cGUsIHN1Y2ggYXMgYG0zLnhsYXJnZWAgLiBZb3UgbXVzdCBzcGVjaWZ5IGFuIGluc3RhbmNlIHR5cGUgdGhhdCBpcyBzdXBwb3J0ZWQgaW4geW91ciByZXF1ZXN0ZWQgUmVnaW9uIGFuZCBBdmFpbGFiaWxpdHkgWm9uZXMuIEZvciBtb3JlIGluZm9ybWF0aW9uLCBzZWUgW0luc3RhbmNlIHR5cGVzXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTRUMyL2xhdGVzdC9Vc2VyR3VpZGUvaW5zdGFuY2UtdHlwZXMuaHRtbCkgaW4gdGhlICpBbWF6b24gRWxhc3RpYyBDb21wdXRlIENsb3VkIFVzZXIgR3VpZGUqIC5cbiAgICAgICAgICpcbiAgICAgICAgICogWW91IGNhbiBzcGVjaWZ5IHVwIHRvIDQwIGluc3RhbmNlIHR5cGVzIHBlciBBdXRvIFNjYWxpbmcgZ3JvdXAuXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvY2ZuLWFzLW1peGVkaW5zdGFuY2VzcG9saWN5LWxhdW5jaHRlbXBsYXRlb3ZlcnJpZGVzLmh0bWwjY2ZuLWF1dG9zY2FsaW5nLWF1dG9zY2FsaW5nZ3JvdXAtbGF1bmNodGVtcGxhdGVvdmVycmlkZXMtaW5zdGFuY2V0eXBlXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBpbnN0YW5jZVR5cGU/OiBzdHJpbmc7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBQcm92aWRlcyBhIGxhdW5jaCB0ZW1wbGF0ZSBmb3IgdGhlIHNwZWNpZmllZCBpbnN0YW5jZSB0eXBlIG9yIHNldCBvZiBpbnN0YW5jZSByZXF1aXJlbWVudHMuIEZvciBleGFtcGxlLCBzb21lIGluc3RhbmNlIHR5cGVzIG1pZ2h0IHJlcXVpcmUgYSBsYXVuY2ggdGVtcGxhdGUgd2l0aCBhIGRpZmZlcmVudCBBTUkuIElmIG5vdCBwcm92aWRlZCwgQW1hem9uIEVDMiBBdXRvIFNjYWxpbmcgdXNlcyB0aGUgbGF1bmNoIHRlbXBsYXRlIHRoYXQncyBzcGVjaWZpZWQgaW4gdGhlIGBMYXVuY2hUZW1wbGF0ZWAgZGVmaW5pdGlvbi4gRm9yIG1vcmUgaW5mb3JtYXRpb24sIHNlZSBbU3BlY2lmeWluZyBhIGRpZmZlcmVudCBsYXVuY2ggdGVtcGxhdGUgZm9yIGFuIGluc3RhbmNlIHR5cGVdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9hdXRvc2NhbGluZy9lYzIvdXNlcmd1aWRlL2VjMi1hdXRvLXNjYWxpbmctbWl4ZWQtaW5zdGFuY2VzLWdyb3Vwcy1sYXVuY2gtdGVtcGxhdGUtb3ZlcnJpZGVzLmh0bWwpIGluIHRoZSAqQW1hem9uIEVDMiBBdXRvIFNjYWxpbmcgVXNlciBHdWlkZSogLlxuICAgICAgICAgKlxuICAgICAgICAgKiBZb3UgY2FuIHNwZWNpZnkgdXAgdG8gMjAgbGF1bmNoIHRlbXBsYXRlcyBwZXIgQXV0byBTY2FsaW5nIGdyb3VwLiBUaGUgbGF1bmNoIHRlbXBsYXRlcyBzcGVjaWZpZWQgaW4gdGhlIG92ZXJyaWRlcyBhbmQgaW4gdGhlIGBMYXVuY2hUZW1wbGF0ZWAgZGVmaW5pdGlvbiBjb3VudCB0b3dhcmRzIHRoaXMgbGltaXQuXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvY2ZuLWFzLW1peGVkaW5zdGFuY2VzcG9saWN5LWxhdW5jaHRlbXBsYXRlb3ZlcnJpZGVzLmh0bWwjY2ZuLWF1dG9zY2FsaW5nLWF1dG9zY2FsaW5nZ3JvdXAtbGF1bmNodGVtcGxhdGVvdmVycmlkZXMtbGF1bmNodGVtcGxhdGVzcGVjaWZpY2F0aW9uXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBsYXVuY2hUZW1wbGF0ZVNwZWNpZmljYXRpb24/OiBDZm5BdXRvU2NhbGluZ0dyb3VwLkxhdW5jaFRlbXBsYXRlU3BlY2lmaWNhdGlvblByb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlO1xuICAgICAgICAvKipcbiAgICAgICAgICogSWYgeW91IHByb3ZpZGUgYSBsaXN0IG9mIGluc3RhbmNlIHR5cGVzIHRvIHVzZSwgeW91IGNhbiBzcGVjaWZ5IHRoZSBudW1iZXIgb2YgY2FwYWNpdHkgdW5pdHMgcHJvdmlkZWQgYnkgZWFjaCBpbnN0YW5jZSB0eXBlIGluIHRlcm1zIG9mIHZpcnR1YWwgQ1BVcywgbWVtb3J5LCBzdG9yYWdlLCB0aHJvdWdocHV0LCBvciBvdGhlciByZWxhdGl2ZSBwZXJmb3JtYW5jZSBjaGFyYWN0ZXJpc3RpYy4gV2hlbiBhIFNwb3Qgb3IgT24tRGVtYW5kIEluc3RhbmNlIGlzIGxhdW5jaGVkLCB0aGUgY2FwYWNpdHkgdW5pdHMgY291bnQgdG93YXJkIHRoZSBkZXNpcmVkIGNhcGFjaXR5LiBBbWF6b24gRUMyIEF1dG8gU2NhbGluZyBsYXVuY2hlcyBpbnN0YW5jZXMgdW50aWwgdGhlIGRlc2lyZWQgY2FwYWNpdHkgaXMgdG90YWxseSBmdWxmaWxsZWQsIGV2ZW4gaWYgdGhpcyByZXN1bHRzIGluIGFuIG92ZXJhZ2UuIEZvciBleGFtcGxlLCBpZiB0aGVyZSBhcmUgdHdvIHVuaXRzIHJlbWFpbmluZyB0byBmdWxmaWxsIGNhcGFjaXR5LCBhbmQgQW1hem9uIEVDMiBBdXRvIFNjYWxpbmcgY2FuIG9ubHkgbGF1bmNoIGFuIGluc3RhbmNlIHdpdGggYSBgV2VpZ2h0ZWRDYXBhY2l0eWAgb2YgZml2ZSB1bml0cywgdGhlIGluc3RhbmNlIGlzIGxhdW5jaGVkLCBhbmQgdGhlIGRlc2lyZWQgY2FwYWNpdHkgaXMgZXhjZWVkZWQgYnkgdGhyZWUgdW5pdHMuIEZvciBtb3JlIGluZm9ybWF0aW9uLCBzZWUgW0NvbmZpZ3VyZSBpbnN0YW5jZSB3ZWlnaHRpbmcgZm9yIEFtYXpvbiBFQzIgQXV0byBTY2FsaW5nXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vYXV0b3NjYWxpbmcvZWMyL3VzZXJndWlkZS9lYzItYXV0by1zY2FsaW5nLW1peGVkLWluc3RhbmNlcy1ncm91cHMtaW5zdGFuY2Utd2VpZ2h0aW5nLmh0bWwpIGluIHRoZSAqQW1hem9uIEVDMiBBdXRvIFNjYWxpbmcgVXNlciBHdWlkZSogLiBWYWx1ZSBtdXN0IGJlIGluIHRoZSByYW5nZSBvZiAxLTk5OS5cbiAgICAgICAgICpcbiAgICAgICAgICogSWYgeW91IHNwZWNpZnkgYSB2YWx1ZSBmb3IgYFdlaWdodGVkQ2FwYWNpdHlgIGZvciBvbmUgaW5zdGFuY2UgdHlwZSwgeW91IG11c3Qgc3BlY2lmeSBhIHZhbHVlIGZvciBgV2VpZ2h0ZWRDYXBhY2l0eWAgZm9yIGFsbCBvZiB0aGVtLlxuICAgICAgICAgKlxuICAgICAgICAgKiA+IEV2ZXJ5IEF1dG8gU2NhbGluZyBncm91cCBoYXMgdGhyZWUgc2l6ZSBwYXJhbWV0ZXJzICggYERlc2lyZWRDYXBhY2l0eWAgLCBgTWF4U2l6ZWAgLCBhbmQgYE1pblNpemVgICkuIFVzdWFsbHksIHlvdSBzZXQgdGhlc2Ugc2l6ZXMgYmFzZWQgb24gYSBzcGVjaWZpYyBudW1iZXIgb2YgaW5zdGFuY2VzLiBIb3dldmVyLCBpZiB5b3UgY29uZmlndXJlIGEgbWl4ZWQgaW5zdGFuY2VzIHBvbGljeSB0aGF0IGRlZmluZXMgd2VpZ2h0cyBmb3IgdGhlIGluc3RhbmNlIHR5cGVzLCB5b3UgbXVzdCBzcGVjaWZ5IHRoZXNlIHNpemVzIHdpdGggdGhlIHNhbWUgdW5pdHMgdGhhdCB5b3UgdXNlIGZvciB3ZWlnaHRpbmcgaW5zdGFuY2VzLlxuICAgICAgICAgKlxuICAgICAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2Nmbi1hcy1taXhlZGluc3RhbmNlc3BvbGljeS1sYXVuY2h0ZW1wbGF0ZW92ZXJyaWRlcy5odG1sI2Nmbi1hdXRvc2NhbGluZy1hdXRvc2NhbGluZ2dyb3VwLWxhdW5jaHRlbXBsYXRlb3ZlcnJpZGVzLXdlaWdodGVkY2FwYWNpdHlcbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IHdlaWdodGVkQ2FwYWNpdHk/OiBzdHJpbmc7XG4gICAgfVxufVxuXG4vKipcbiAqIERldGVybWluZSB3aGV0aGVyIHRoZSBnaXZlbiBwcm9wZXJ0aWVzIG1hdGNoIHRob3NlIG9mIGEgYExhdW5jaFRlbXBsYXRlT3ZlcnJpZGVzUHJvcGVydHlgXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYExhdW5jaFRlbXBsYXRlT3ZlcnJpZGVzUHJvcGVydHlgXG4gKlxuICogQHJldHVybnMgdGhlIHJlc3VsdCBvZiB0aGUgdmFsaWRhdGlvbi5cbiAqL1xuZnVuY3Rpb24gQ2ZuQXV0b1NjYWxpbmdHcm91cF9MYXVuY2hUZW1wbGF0ZU92ZXJyaWRlc1Byb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXM6IGFueSk6IGNkay5WYWxpZGF0aW9uUmVzdWx0IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBjZGsuVkFMSURBVElPTl9TVUNDRVNTOyB9XG4gICAgY29uc3QgZXJyb3JzID0gbmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0cygpO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgZXJyb3JzLmNvbGxlY3QobmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0KCdFeHBlY3RlZCBhbiBvYmplY3QsIGJ1dCByZWNlaXZlZDogJyArIEpTT04uc3RyaW5naWZ5KHByb3BlcnRpZXMpKSk7XG4gICAgfVxuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignaW5zdGFuY2VSZXF1aXJlbWVudHMnLCBDZm5BdXRvU2NhbGluZ0dyb3VwX0luc3RhbmNlUmVxdWlyZW1lbnRzUHJvcGVydHlWYWxpZGF0b3IpKHByb3BlcnRpZXMuaW5zdGFuY2VSZXF1aXJlbWVudHMpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2luc3RhbmNlVHlwZScsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5pbnN0YW5jZVR5cGUpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2xhdW5jaFRlbXBsYXRlU3BlY2lmaWNhdGlvbicsIENmbkF1dG9TY2FsaW5nR3JvdXBfTGF1bmNoVGVtcGxhdGVTcGVjaWZpY2F0aW9uUHJvcGVydHlWYWxpZGF0b3IpKHByb3BlcnRpZXMubGF1bmNoVGVtcGxhdGVTcGVjaWZpY2F0aW9uKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCd3ZWlnaHRlZENhcGFjaXR5JywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLndlaWdodGVkQ2FwYWNpdHkpKTtcbiAgICByZXR1cm4gZXJyb3JzLndyYXAoJ3N1cHBsaWVkIHByb3BlcnRpZXMgbm90IGNvcnJlY3QgZm9yIFwiTGF1bmNoVGVtcGxhdGVPdmVycmlkZXNQcm9wZXJ0eVwiJyk7XG59XG5cbi8qKlxuICogUmVuZGVycyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6QXV0b1NjYWxpbmc6OkF1dG9TY2FsaW5nR3JvdXAuTGF1bmNoVGVtcGxhdGVPdmVycmlkZXNgIHJlc291cmNlXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYExhdW5jaFRlbXBsYXRlT3ZlcnJpZGVzUHJvcGVydHlgXG4gKlxuICogQHJldHVybnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OkF1dG9TY2FsaW5nOjpBdXRvU2NhbGluZ0dyb3VwLkxhdW5jaFRlbXBsYXRlT3ZlcnJpZGVzYCByZXNvdXJjZS5cbiAqL1xuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIGNmbkF1dG9TY2FsaW5nR3JvdXBMYXVuY2hUZW1wbGF0ZU92ZXJyaWRlc1Byb3BlcnR5VG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBhbnkge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIHByb3BlcnRpZXM7IH1cbiAgICBDZm5BdXRvU2NhbGluZ0dyb3VwX0xhdW5jaFRlbXBsYXRlT3ZlcnJpZGVzUHJvcGVydHlWYWxpZGF0b3IocHJvcGVydGllcykuYXNzZXJ0U3VjY2VzcygpO1xuICAgIHJldHVybiB7XG4gICAgICAgIEluc3RhbmNlUmVxdWlyZW1lbnRzOiBjZm5BdXRvU2NhbGluZ0dyb3VwSW5zdGFuY2VSZXF1aXJlbWVudHNQcm9wZXJ0eVRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5pbnN0YW5jZVJlcXVpcmVtZW50cyksXG4gICAgICAgIEluc3RhbmNlVHlwZTogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5pbnN0YW5jZVR5cGUpLFxuICAgICAgICBMYXVuY2hUZW1wbGF0ZVNwZWNpZmljYXRpb246IGNmbkF1dG9TY2FsaW5nR3JvdXBMYXVuY2hUZW1wbGF0ZVNwZWNpZmljYXRpb25Qcm9wZXJ0eVRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5sYXVuY2hUZW1wbGF0ZVNwZWNpZmljYXRpb24pLFxuICAgICAgICBXZWlnaHRlZENhcGFjaXR5OiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLndlaWdodGVkQ2FwYWNpdHkpLFxuICAgIH07XG59XG5cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBDZm5BdXRvU2NhbGluZ0dyb3VwTGF1bmNoVGVtcGxhdGVPdmVycmlkZXNQcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0PENmbkF1dG9TY2FsaW5nR3JvdXAuTGF1bmNoVGVtcGxhdGVPdmVycmlkZXNQcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZT4ge1xuICAgIGlmIChjZGsuaXNSZXNvbHZhYmxlT2JqZWN0KHByb3BlcnRpZXMpKSB7XG4gICAgICAgIHJldHVybiBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdChwcm9wZXJ0aWVzKTtcbiAgICB9XG4gICAgcHJvcGVydGllcyA9IHByb3BlcnRpZXMgPT0gbnVsbCA/IHt9IDogcHJvcGVydGllcztcbiAgICBpZiAodHlwZW9mIHByb3BlcnRpZXMgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIHJldHVybiBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdChwcm9wZXJ0aWVzKTtcbiAgICB9XG4gICAgY29uc3QgcmV0ID0gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25Qcm9wZXJ0eU9iamVjdDxDZm5BdXRvU2NhbGluZ0dyb3VwLkxhdW5jaFRlbXBsYXRlT3ZlcnJpZGVzUHJvcGVydHk+KCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdpbnN0YW5jZVJlcXVpcmVtZW50cycsICdJbnN0YW5jZVJlcXVpcmVtZW50cycsIHByb3BlcnRpZXMuSW5zdGFuY2VSZXF1aXJlbWVudHMgIT0gbnVsbCA/IENmbkF1dG9TY2FsaW5nR3JvdXBJbnN0YW5jZVJlcXVpcmVtZW50c1Byb3BlcnR5RnJvbUNsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuSW5zdGFuY2VSZXF1aXJlbWVudHMpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2luc3RhbmNlVHlwZScsICdJbnN0YW5jZVR5cGUnLCBwcm9wZXJ0aWVzLkluc3RhbmNlVHlwZSAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5JbnN0YW5jZVR5cGUpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2xhdW5jaFRlbXBsYXRlU3BlY2lmaWNhdGlvbicsICdMYXVuY2hUZW1wbGF0ZVNwZWNpZmljYXRpb24nLCBwcm9wZXJ0aWVzLkxhdW5jaFRlbXBsYXRlU3BlY2lmaWNhdGlvbiAhPSBudWxsID8gQ2ZuQXV0b1NjYWxpbmdHcm91cExhdW5jaFRlbXBsYXRlU3BlY2lmaWNhdGlvblByb3BlcnR5RnJvbUNsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuTGF1bmNoVGVtcGxhdGVTcGVjaWZpY2F0aW9uKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCd3ZWlnaHRlZENhcGFjaXR5JywgJ1dlaWdodGVkQ2FwYWNpdHknLCBwcm9wZXJ0aWVzLldlaWdodGVkQ2FwYWNpdHkgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuV2VpZ2h0ZWRDYXBhY2l0eSkgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRVbnJlY29nbml6ZWRQcm9wZXJ0aWVzQXNFeHRyYShwcm9wZXJ0aWVzKTtcbiAgICByZXR1cm4gcmV0O1xufVxuXG5leHBvcnQgbmFtZXNwYWNlIENmbkF1dG9TY2FsaW5nR3JvdXAge1xuICAgIC8qKlxuICAgICAqIFNwZWNpZmllcyBhIGxhdW5jaCB0ZW1wbGF0ZSB0byB1c2Ugd2hlbiBwcm92aXNpb25pbmcgRUMyIGluc3RhbmNlcyBmb3IgYW4gQXV0byBTY2FsaW5nIGdyb3VwLlxuICAgICAqXG4gICAgICogWW91IG11c3Qgc3BlY2lmeSB0aGUgZm9sbG93aW5nOlxuICAgICAqXG4gICAgICogLSBUaGUgSUQgb3IgdGhlIG5hbWUgb2YgdGhlIGxhdW5jaCB0ZW1wbGF0ZSwgYnV0IG5vdCBib3RoLlxuICAgICAqIC0gVGhlIHZlcnNpb24gb2YgdGhlIGxhdW5jaCB0ZW1wbGF0ZS5cbiAgICAgKlxuICAgICAqIGBMYXVuY2hUZW1wbGF0ZVNwZWNpZmljYXRpb25gIGlzIHByb3BlcnR5IG9mIHRoZSBbQVdTOjpBdXRvU2NhbGluZzo6QXV0b1NjYWxpbmdHcm91cF0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXMtZ3JvdXAuaHRtbCkgcmVzb3VyY2UuIEl0IGlzIGFsc28gYSBwcm9wZXJ0eSBvZiB0aGUgW0FXUzo6QXV0b1NjYWxpbmc6OkF1dG9TY2FsaW5nR3JvdXAgTGF1bmNoVGVtcGxhdGVdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWF1dG9zY2FsaW5nLWF1dG9zY2FsaW5nZ3JvdXAtbGF1bmNodGVtcGxhdGUuaHRtbCkgYW5kIFtBV1M6OkF1dG9TY2FsaW5nOjpBdXRvU2NhbGluZ0dyb3VwIExhdW5jaFRlbXBsYXRlT3ZlcnJpZGVzXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hdXRvc2NhbGluZy1hdXRvc2NhbGluZ2dyb3VwLWxhdW5jaHRlbXBsYXRlb3ZlcnJpZGVzLmh0bWwpIHByb3BlcnR5IHR5cGVzLlxuICAgICAqXG4gICAgICogRm9yIGluZm9ybWF0aW9uIGFib3V0IGNyZWF0aW5nIGEgbGF1bmNoIHRlbXBsYXRlLCBzZWUgW0FXUzo6RUMyOjpMYXVuY2hUZW1wbGF0ZV0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWVjMi1sYXVuY2h0ZW1wbGF0ZS5odG1sKSBhbmQgW0NyZWF0ZSBhIGxhdW5jaCB0ZW1wbGF0ZSBmb3IgYW4gQXV0byBTY2FsaW5nIGdyb3VwXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vYXV0b3NjYWxpbmcvZWMyL3VzZXJndWlkZS9jcmVhdGUtbGF1bmNoLXRlbXBsYXRlLmh0bWwpIGluIHRoZSAqQW1hem9uIEVDMiBBdXRvIFNjYWxpbmcgVXNlciBHdWlkZSogLlxuICAgICAqXG4gICAgICogRm9yIGV4YW1wbGVzIG9mIGxhdW5jaCB0ZW1wbGF0ZXMsIHNlZSBbQXV0byBzY2FsaW5nIHRlbXBsYXRlIHNuaXBwZXRzXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9xdWlja3JlZi1hdXRvc2NhbGluZy5odG1sKSBhbmQgdGhlIFtFeGFtcGxlc10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWVjMi1sYXVuY2h0ZW1wbGF0ZS5odG1sI2F3cy1yZXNvdXJjZS1lYzItbGF1bmNodGVtcGxhdGUtLWV4YW1wbGVzKSBzZWN0aW9uIGluIHRoZSBgQVdTOjpFQzI6OkxhdW5jaFRlbXBsYXRlYCByZXNvdXJjZS5cbiAgICAgKlxuICAgICAqIEBzdHJ1Y3RcbiAgICAgKiBAc3RhYmlsaXR5IGV4dGVybmFsXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWF1dG9zY2FsaW5nLWF1dG9zY2FsaW5nZ3JvdXAtbGF1bmNodGVtcGxhdGVzcGVjaWZpY2F0aW9uLmh0bWxcbiAgICAgKi9cbiAgICBleHBvcnQgaW50ZXJmYWNlIExhdW5jaFRlbXBsYXRlU3BlY2lmaWNhdGlvblByb3BlcnR5IHtcbiAgICAgICAgLyoqXG4gICAgICAgICAqIFRoZSBJRCBvZiB0aGUgbGF1bmNoIHRlbXBsYXRlLlxuICAgICAgICAgKlxuICAgICAgICAgKiBZb3UgbXVzdCBzcGVjaWZ5IHRoZSBgTGF1bmNoVGVtcGxhdGVJRGAgb3IgdGhlIGBMYXVuY2hUZW1wbGF0ZU5hbWVgICwgYnV0IG5vdCBib3RoLlxuICAgICAgICAgKlxuICAgICAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWF1dG9zY2FsaW5nLWF1dG9zY2FsaW5nZ3JvdXAtbGF1bmNodGVtcGxhdGVzcGVjaWZpY2F0aW9uLmh0bWwjY2ZuLWF1dG9zY2FsaW5nLWF1dG9zY2FsaW5nZ3JvdXAtbGF1bmNodGVtcGxhdGVzcGVjaWZpY2F0aW9uLWxhdW5jaHRlbXBsYXRlaWRcbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IGxhdW5jaFRlbXBsYXRlSWQ/OiBzdHJpbmc7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBUaGUgbmFtZSBvZiB0aGUgbGF1bmNoIHRlbXBsYXRlLlxuICAgICAgICAgKlxuICAgICAgICAgKiBZb3UgbXVzdCBzcGVjaWZ5IHRoZSBgTGF1bmNoVGVtcGxhdGVOYW1lYCBvciB0aGUgYExhdW5jaFRlbXBsYXRlSURgICwgYnV0IG5vdCBib3RoLlxuICAgICAgICAgKlxuICAgICAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWF1dG9zY2FsaW5nLWF1dG9zY2FsaW5nZ3JvdXAtbGF1bmNodGVtcGxhdGVzcGVjaWZpY2F0aW9uLmh0bWwjY2ZuLWF1dG9zY2FsaW5nLWF1dG9zY2FsaW5nZ3JvdXAtbGF1bmNodGVtcGxhdGVzcGVjaWZpY2F0aW9uLWxhdW5jaHRlbXBsYXRlbmFtZVxuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgbGF1bmNoVGVtcGxhdGVOYW1lPzogc3RyaW5nO1xuICAgICAgICAvKipcbiAgICAgICAgICogVGhlIHZlcnNpb24gbnVtYmVyIG9mIHRoZSBsYXVuY2ggdGVtcGxhdGUuXG4gICAgICAgICAqXG4gICAgICAgICAqIFNwZWNpZnlpbmcgYCRMYXRlc3RgIG9yIGAkRGVmYXVsdGAgZm9yIHRoZSB0ZW1wbGF0ZSB2ZXJzaW9uIG51bWJlciBpcyBub3Qgc3VwcG9ydGVkLiBIb3dldmVyLCB5b3UgY2FuIHNwZWNpZnkgYExhdGVzdFZlcnNpb25OdW1iZXJgIG9yIGBEZWZhdWx0VmVyc2lvbk51bWJlcmAgdXNpbmcgdGhlIGBGbjo6R2V0QXR0YCBpbnRyaW5zaWMgZnVuY3Rpb24uIEZvciBtb3JlIGluZm9ybWF0aW9uLCBzZWUgW0ZuOjpHZXRBdHRdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2ludHJpbnNpYy1mdW5jdGlvbi1yZWZlcmVuY2UtZ2V0YXR0Lmh0bWwpIC5cbiAgICAgICAgICpcbiAgICAgICAgICogPiBGb3IgYW4gZXhhbXBsZSBvZiB1c2luZyB0aGUgYEZuOjpHZXRBdHRgIGZ1bmN0aW9uLCBzZWUgdGhlIFtFeGFtcGxlc10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXMtZ3JvdXAuaHRtbCNhd3MtcHJvcGVydGllcy1hcy1ncm91cC0tZXhhbXBsZXMpIHNlY3Rpb24gb2YgdGhlIGBBV1M6OkF1dG9TY2FsaW5nOjpBdXRvU2NhbGluZ0dyb3VwYCByZXNvdXJjZS5cbiAgICAgICAgICpcbiAgICAgICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hdXRvc2NhbGluZy1hdXRvc2NhbGluZ2dyb3VwLWxhdW5jaHRlbXBsYXRlc3BlY2lmaWNhdGlvbi5odG1sI2Nmbi1hdXRvc2NhbGluZy1hdXRvc2NhbGluZ2dyb3VwLWxhdW5jaHRlbXBsYXRlc3BlY2lmaWNhdGlvbi12ZXJzaW9uXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSB2ZXJzaW9uOiBzdHJpbmc7XG4gICAgfVxufVxuXG4vKipcbiAqIERldGVybWluZSB3aGV0aGVyIHRoZSBnaXZlbiBwcm9wZXJ0aWVzIG1hdGNoIHRob3NlIG9mIGEgYExhdW5jaFRlbXBsYXRlU3BlY2lmaWNhdGlvblByb3BlcnR5YFxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBMYXVuY2hUZW1wbGF0ZVNwZWNpZmljYXRpb25Qcm9wZXJ0eWBcbiAqXG4gKiBAcmV0dXJucyB0aGUgcmVzdWx0IG9mIHRoZSB2YWxpZGF0aW9uLlxuICovXG5mdW5jdGlvbiBDZm5BdXRvU2NhbGluZ0dyb3VwX0xhdW5jaFRlbXBsYXRlU3BlY2lmaWNhdGlvblByb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXM6IGFueSk6IGNkay5WYWxpZGF0aW9uUmVzdWx0IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBjZGsuVkFMSURBVElPTl9TVUNDRVNTOyB9XG4gICAgY29uc3QgZXJyb3JzID0gbmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0cygpO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgZXJyb3JzLmNvbGxlY3QobmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0KCdFeHBlY3RlZCBhbiBvYmplY3QsIGJ1dCByZWNlaXZlZDogJyArIEpTT04uc3RyaW5naWZ5KHByb3BlcnRpZXMpKSk7XG4gICAgfVxuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignbGF1bmNoVGVtcGxhdGVJZCcsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5sYXVuY2hUZW1wbGF0ZUlkKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdsYXVuY2hUZW1wbGF0ZU5hbWUnLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMubGF1bmNoVGVtcGxhdGVOYW1lKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCd2ZXJzaW9uJywgY2RrLnJlcXVpcmVkVmFsaWRhdG9yKShwcm9wZXJ0aWVzLnZlcnNpb24pKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3ZlcnNpb24nLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMudmVyc2lvbikpO1xuICAgIHJldHVybiBlcnJvcnMud3JhcCgnc3VwcGxpZWQgcHJvcGVydGllcyBub3QgY29ycmVjdCBmb3IgXCJMYXVuY2hUZW1wbGF0ZVNwZWNpZmljYXRpb25Qcm9wZXJ0eVwiJyk7XG59XG5cbi8qKlxuICogUmVuZGVycyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6QXV0b1NjYWxpbmc6OkF1dG9TY2FsaW5nR3JvdXAuTGF1bmNoVGVtcGxhdGVTcGVjaWZpY2F0aW9uYCByZXNvdXJjZVxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBMYXVuY2hUZW1wbGF0ZVNwZWNpZmljYXRpb25Qcm9wZXJ0eWBcbiAqXG4gKiBAcmV0dXJucyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6QXV0b1NjYWxpbmc6OkF1dG9TY2FsaW5nR3JvdXAuTGF1bmNoVGVtcGxhdGVTcGVjaWZpY2F0aW9uYCByZXNvdXJjZS5cbiAqL1xuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIGNmbkF1dG9TY2FsaW5nR3JvdXBMYXVuY2hUZW1wbGF0ZVNwZWNpZmljYXRpb25Qcm9wZXJ0eVRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogYW55IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBwcm9wZXJ0aWVzOyB9XG4gICAgQ2ZuQXV0b1NjYWxpbmdHcm91cF9MYXVuY2hUZW1wbGF0ZVNwZWNpZmljYXRpb25Qcm9wZXJ0eVZhbGlkYXRvcihwcm9wZXJ0aWVzKS5hc3NlcnRTdWNjZXNzKCk7XG4gICAgcmV0dXJuIHtcbiAgICAgICAgTGF1bmNoVGVtcGxhdGVJZDogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5sYXVuY2hUZW1wbGF0ZUlkKSxcbiAgICAgICAgTGF1bmNoVGVtcGxhdGVOYW1lOiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLmxhdW5jaFRlbXBsYXRlTmFtZSksXG4gICAgICAgIFZlcnNpb246IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMudmVyc2lvbiksXG4gICAgfTtcbn1cblxuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIENmbkF1dG9TY2FsaW5nR3JvdXBMYXVuY2hUZW1wbGF0ZVNwZWNpZmljYXRpb25Qcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0PENmbkF1dG9TY2FsaW5nR3JvdXAuTGF1bmNoVGVtcGxhdGVTcGVjaWZpY2F0aW9uUHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGU+IHtcbiAgICBpZiAoY2RrLmlzUmVzb2x2YWJsZU9iamVjdChwcm9wZXJ0aWVzKSkge1xuICAgICAgICByZXR1cm4gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQocHJvcGVydGllcyk7XG4gICAgfVxuICAgIHByb3BlcnRpZXMgPSBwcm9wZXJ0aWVzID09IG51bGwgPyB7fSA6IHByb3BlcnRpZXM7XG4gICAgaWYgKHR5cGVvZiBwcm9wZXJ0aWVzICE9PSAnb2JqZWN0Jykge1xuICAgICAgICByZXR1cm4gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQocHJvcGVydGllcyk7XG4gICAgfVxuICAgIGNvbnN0IHJldCA9IG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUHJvcGVydHlPYmplY3Q8Q2ZuQXV0b1NjYWxpbmdHcm91cC5MYXVuY2hUZW1wbGF0ZVNwZWNpZmljYXRpb25Qcm9wZXJ0eT4oKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2xhdW5jaFRlbXBsYXRlSWQnLCAnTGF1bmNoVGVtcGxhdGVJZCcsIHByb3BlcnRpZXMuTGF1bmNoVGVtcGxhdGVJZCAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5MYXVuY2hUZW1wbGF0ZUlkKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdsYXVuY2hUZW1wbGF0ZU5hbWUnLCAnTGF1bmNoVGVtcGxhdGVOYW1lJywgcHJvcGVydGllcy5MYXVuY2hUZW1wbGF0ZU5hbWUgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuTGF1bmNoVGVtcGxhdGVOYW1lKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCd2ZXJzaW9uJywgJ1ZlcnNpb24nLCBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLlZlcnNpb24pKTtcbiAgICByZXQuYWRkVW5yZWNvZ25pemVkUHJvcGVydGllc0FzRXh0cmEocHJvcGVydGllcyk7XG4gICAgcmV0dXJuIHJldDtcbn1cblxuZXhwb3J0IG5hbWVzcGFjZSBDZm5BdXRvU2NhbGluZ0dyb3VwIHtcbiAgICAvKipcbiAgICAgKiBgTGlmZWN5Y2xlSG9va1NwZWNpZmljYXRpb25gIHNwZWNpZmllcyBhIGxpZmVjeWNsZSBob29rIGZvciB0aGUgYExpZmVjeWNsZUhvb2tTcGVjaWZpY2F0aW9uTGlzdGAgcHJvcGVydHkgb2YgdGhlIFtBV1M6OkF1dG9TY2FsaW5nOjpBdXRvU2NhbGluZ0dyb3VwXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hcy1ncm91cC5odG1sKSByZXNvdXJjZS4gQSBsaWZlY3ljbGUgaG9vayBzcGVjaWZpZXMgYWN0aW9ucyB0byBwZXJmb3JtIHdoZW4gQW1hem9uIEVDMiBBdXRvIFNjYWxpbmcgbGF1bmNoZXMgb3IgdGVybWluYXRlcyBpbnN0YW5jZXMuXG4gICAgICpcbiAgICAgKiBGb3IgbW9yZSBpbmZvcm1hdGlvbiwgc2VlIFtBbWF6b24gRUMyIEF1dG8gU2NhbGluZyBsaWZlY3ljbGUgaG9va3NdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9hdXRvc2NhbGluZy9lYzIvdXNlcmd1aWRlL2xpZmVjeWNsZS1ob29rcy5odG1sKSBpbiB0aGUgKkFtYXpvbiBFQzIgQXV0byBTY2FsaW5nIFVzZXIgR3VpZGUqIC4gWW91IGNhbiBmaW5kIGEgc2FtcGxlIHRlbXBsYXRlIHNuaXBwZXQgaW4gdGhlIFtFeGFtcGxlc10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWFzLWxpZmVjeWNsZWhvb2suaHRtbCNhd3MtcmVzb3VyY2UtYXMtbGlmZWN5Y2xlaG9vay0tZXhhbXBsZXMpIHNlY3Rpb24gb2YgdGhlIGBBV1M6OkF1dG9TY2FsaW5nOjpMaWZlY3ljbGVIb29rYCByZXNvdXJjZS5cbiAgICAgKlxuICAgICAqIEBzdHJ1Y3RcbiAgICAgKiBAc3RhYmlsaXR5IGV4dGVybmFsXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWF1dG9zY2FsaW5nLWF1dG9zY2FsaW5nZ3JvdXAtbGlmZWN5Y2xlaG9va3NwZWNpZmljYXRpb24uaHRtbFxuICAgICAqL1xuICAgIGV4cG9ydCBpbnRlcmZhY2UgTGlmZWN5Y2xlSG9va1NwZWNpZmljYXRpb25Qcm9wZXJ0eSB7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBUaGUgYWN0aW9uIHRoZSBBdXRvIFNjYWxpbmcgZ3JvdXAgdGFrZXMgd2hlbiB0aGUgbGlmZWN5Y2xlIGhvb2sgdGltZW91dCBlbGFwc2VzIG9yIGlmIGFuIHVuZXhwZWN0ZWQgZmFpbHVyZSBvY2N1cnMuIFRoZSBkZWZhdWx0IHZhbHVlIGlzIGBBQkFORE9OYCAuXG4gICAgICAgICAqXG4gICAgICAgICAqIFZhbGlkIHZhbHVlczogYENPTlRJTlVFYCB8IGBBQkFORE9OYFxuICAgICAgICAgKlxuICAgICAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWF1dG9zY2FsaW5nLWF1dG9zY2FsaW5nZ3JvdXAtbGlmZWN5Y2xlaG9va3NwZWNpZmljYXRpb24uaHRtbCNjZm4tYXV0b3NjYWxpbmctYXV0b3NjYWxpbmdncm91cC1saWZlY3ljbGVob29rc3BlY2lmaWNhdGlvbi1kZWZhdWx0cmVzdWx0XG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBkZWZhdWx0UmVzdWx0Pzogc3RyaW5nO1xuICAgICAgICAvKipcbiAgICAgICAgICogVGhlIG1heGltdW0gdGltZSwgaW4gc2Vjb25kcywgdGhhdCBjYW4gZWxhcHNlIGJlZm9yZSB0aGUgbGlmZWN5Y2xlIGhvb2sgdGltZXMgb3V0LiBUaGUgcmFuZ2UgaXMgZnJvbSBgMzBgIHRvIGA3MjAwYCBzZWNvbmRzLiBUaGUgZGVmYXVsdCB2YWx1ZSBpcyBgMzYwMGAgc2Vjb25kcyAoMSBob3VyKS5cbiAgICAgICAgICpcbiAgICAgICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hdXRvc2NhbGluZy1hdXRvc2NhbGluZ2dyb3VwLWxpZmVjeWNsZWhvb2tzcGVjaWZpY2F0aW9uLmh0bWwjY2ZuLWF1dG9zY2FsaW5nLWF1dG9zY2FsaW5nZ3JvdXAtbGlmZWN5Y2xlaG9va3NwZWNpZmljYXRpb24taGVhcnRiZWF0dGltZW91dFxuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgaGVhcnRiZWF0VGltZW91dD86IG51bWJlcjtcbiAgICAgICAgLyoqXG4gICAgICAgICAqIFRoZSBuYW1lIG9mIHRoZSBsaWZlY3ljbGUgaG9vay5cbiAgICAgICAgICpcbiAgICAgICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hdXRvc2NhbGluZy1hdXRvc2NhbGluZ2dyb3VwLWxpZmVjeWNsZWhvb2tzcGVjaWZpY2F0aW9uLmh0bWwjY2ZuLWF1dG9zY2FsaW5nLWF1dG9zY2FsaW5nZ3JvdXAtbGlmZWN5Y2xlaG9va3NwZWNpZmljYXRpb24tbGlmZWN5Y2xlaG9va25hbWVcbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IGxpZmVjeWNsZUhvb2tOYW1lOiBzdHJpbmc7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBUaGUgbGlmZWN5Y2xlIHRyYW5zaXRpb24uIEZvciBBdXRvIFNjYWxpbmcgZ3JvdXBzLCB0aGVyZSBhcmUgdHdvIG1ham9yIGxpZmVjeWNsZSB0cmFuc2l0aW9ucy5cbiAgICAgICAgICpcbiAgICAgICAgICogLSBUbyBjcmVhdGUgYSBsaWZlY3ljbGUgaG9vayBmb3Igc2NhbGUtb3V0IGV2ZW50cywgc3BlY2lmeSBgYXV0b3NjYWxpbmc6RUMyX0lOU1RBTkNFX0xBVU5DSElOR2AgLlxuICAgICAgICAgKiAtIFRvIGNyZWF0ZSBhIGxpZmVjeWNsZSBob29rIGZvciBzY2FsZS1pbiBldmVudHMsIHNwZWNpZnkgYGF1dG9zY2FsaW5nOkVDMl9JTlNUQU5DRV9URVJNSU5BVElOR2AgLlxuICAgICAgICAgKlxuICAgICAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWF1dG9zY2FsaW5nLWF1dG9zY2FsaW5nZ3JvdXAtbGlmZWN5Y2xlaG9va3NwZWNpZmljYXRpb24uaHRtbCNjZm4tYXV0b3NjYWxpbmctYXV0b3NjYWxpbmdncm91cC1saWZlY3ljbGVob29rc3BlY2lmaWNhdGlvbi1saWZlY3ljbGV0cmFuc2l0aW9uXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBsaWZlY3ljbGVUcmFuc2l0aW9uOiBzdHJpbmc7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBBZGRpdGlvbmFsIGluZm9ybWF0aW9uIHRoYXQgeW91IHdhbnQgdG8gaW5jbHVkZSBhbnkgdGltZSBBbWF6b24gRUMyIEF1dG8gU2NhbGluZyBzZW5kcyBhIG1lc3NhZ2UgdG8gdGhlIG5vdGlmaWNhdGlvbiB0YXJnZXQuXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXV0b3NjYWxpbmctYXV0b3NjYWxpbmdncm91cC1saWZlY3ljbGVob29rc3BlY2lmaWNhdGlvbi5odG1sI2Nmbi1hdXRvc2NhbGluZy1hdXRvc2NhbGluZ2dyb3VwLWxpZmVjeWNsZWhvb2tzcGVjaWZpY2F0aW9uLW5vdGlmaWNhdGlvbm1ldGFkYXRhXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBub3RpZmljYXRpb25NZXRhZGF0YT86IHN0cmluZztcbiAgICAgICAgLyoqXG4gICAgICAgICAqIFRoZSBBbWF6b24gUmVzb3VyY2UgTmFtZSAoQVJOKSBvZiB0aGUgbm90aWZpY2F0aW9uIHRhcmdldCB0aGF0IEFtYXpvbiBFQzIgQXV0byBTY2FsaW5nIHNlbmRzIG5vdGlmaWNhdGlvbnMgdG8gd2hlbiBhbiBpbnN0YW5jZSBpcyBpbiBhIHdhaXQgc3RhdGUgZm9yIHRoZSBsaWZlY3ljbGUgaG9vay4gWW91IGNhbiBzcGVjaWZ5IGFuIEFtYXpvbiBTTlMgdG9waWMgb3IgYW4gQW1hem9uIFNRUyBxdWV1ZS5cbiAgICAgICAgICpcbiAgICAgICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hdXRvc2NhbGluZy1hdXRvc2NhbGluZ2dyb3VwLWxpZmVjeWNsZWhvb2tzcGVjaWZpY2F0aW9uLmh0bWwjY2ZuLWF1dG9zY2FsaW5nLWF1dG9zY2FsaW5nZ3JvdXAtbGlmZWN5Y2xlaG9va3NwZWNpZmljYXRpb24tbm90aWZpY2F0aW9udGFyZ2V0YXJuXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBub3RpZmljYXRpb25UYXJnZXRBcm4/OiBzdHJpbmc7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBUaGUgQVJOIG9mIHRoZSBJQU0gcm9sZSB0aGF0IGFsbG93cyB0aGUgQXV0byBTY2FsaW5nIGdyb3VwIHRvIHB1Ymxpc2ggdG8gdGhlIHNwZWNpZmllZCBub3RpZmljYXRpb24gdGFyZ2V0LiBGb3IgaW5mb3JtYXRpb24gYWJvdXQgY3JlYXRpbmcgdGhpcyByb2xlLCBzZWUgW0NvbmZpZ3VyZSBhIG5vdGlmaWNhdGlvbiB0YXJnZXQgZm9yIGEgbGlmZWN5Y2xlIGhvb2tdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9hdXRvc2NhbGluZy9lYzIvdXNlcmd1aWRlL3ByZXBhcmUtZm9yLWxpZmVjeWNsZS1ub3RpZmljYXRpb25zLmh0bWwjbGlmZWN5Y2xlLWhvb2stbm90aWZpY2F0aW9uLXRhcmdldCkgaW4gdGhlICpBbWF6b24gRUMyIEF1dG8gU2NhbGluZyBVc2VyIEd1aWRlKiAuXG4gICAgICAgICAqXG4gICAgICAgICAqIFZhbGlkIG9ubHkgaWYgdGhlIG5vdGlmaWNhdGlvbiB0YXJnZXQgaXMgYW4gQW1hem9uIFNOUyB0b3BpYyBvciBhbiBBbWF6b24gU1FTIHF1ZXVlLlxuICAgICAgICAgKlxuICAgICAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWF1dG9zY2FsaW5nLWF1dG9zY2FsaW5nZ3JvdXAtbGlmZWN5Y2xlaG9va3NwZWNpZmljYXRpb24uaHRtbCNjZm4tYXV0b3NjYWxpbmctYXV0b3NjYWxpbmdncm91cC1saWZlY3ljbGVob29rc3BlY2lmaWNhdGlvbi1yb2xlYXJuXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSByb2xlQXJuPzogc3RyaW5nO1xuICAgIH1cbn1cblxuLyoqXG4gKiBEZXRlcm1pbmUgd2hldGhlciB0aGUgZ2l2ZW4gcHJvcGVydGllcyBtYXRjaCB0aG9zZSBvZiBhIGBMaWZlY3ljbGVIb29rU3BlY2lmaWNhdGlvblByb3BlcnR5YFxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBMaWZlY3ljbGVIb29rU3BlY2lmaWNhdGlvblByb3BlcnR5YFxuICpcbiAqIEByZXR1cm5zIHRoZSByZXN1bHQgb2YgdGhlIHZhbGlkYXRpb24uXG4gKi9cbmZ1bmN0aW9uIENmbkF1dG9TY2FsaW5nR3JvdXBfTGlmZWN5Y2xlSG9va1NwZWNpZmljYXRpb25Qcm9wZXJ0eVZhbGlkYXRvcihwcm9wZXJ0aWVzOiBhbnkpOiBjZGsuVmFsaWRhdGlvblJlc3VsdCB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gY2RrLlZBTElEQVRJT05fU1VDQ0VTUzsgfVxuICAgIGNvbnN0IGVycm9ycyA9IG5ldyBjZGsuVmFsaWRhdGlvblJlc3VsdHMoKTtcbiAgICBpZiAodHlwZW9mIHByb3BlcnRpZXMgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIGVycm9ycy5jb2xsZWN0KG5ldyBjZGsuVmFsaWRhdGlvblJlc3VsdCgnRXhwZWN0ZWQgYW4gb2JqZWN0LCBidXQgcmVjZWl2ZWQ6ICcgKyBKU09OLnN0cmluZ2lmeShwcm9wZXJ0aWVzKSkpO1xuICAgIH1cbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2RlZmF1bHRSZXN1bHQnLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuZGVmYXVsdFJlc3VsdCkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignaGVhcnRiZWF0VGltZW91dCcsIGNkay52YWxpZGF0ZU51bWJlcikocHJvcGVydGllcy5oZWFydGJlYXRUaW1lb3V0KSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdsaWZlY3ljbGVIb29rTmFtZScsIGNkay5yZXF1aXJlZFZhbGlkYXRvcikocHJvcGVydGllcy5saWZlY3ljbGVIb29rTmFtZSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignbGlmZWN5Y2xlSG9va05hbWUnLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMubGlmZWN5Y2xlSG9va05hbWUpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2xpZmVjeWNsZVRyYW5zaXRpb24nLCBjZGsucmVxdWlyZWRWYWxpZGF0b3IpKHByb3BlcnRpZXMubGlmZWN5Y2xlVHJhbnNpdGlvbikpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignbGlmZWN5Y2xlVHJhbnNpdGlvbicsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5saWZlY3ljbGVUcmFuc2l0aW9uKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdub3RpZmljYXRpb25NZXRhZGF0YScsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5ub3RpZmljYXRpb25NZXRhZGF0YSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignbm90aWZpY2F0aW9uVGFyZ2V0QXJuJywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLm5vdGlmaWNhdGlvblRhcmdldEFybikpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigncm9sZUFybicsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5yb2xlQXJuKSk7XG4gICAgcmV0dXJuIGVycm9ycy53cmFwKCdzdXBwbGllZCBwcm9wZXJ0aWVzIG5vdCBjb3JyZWN0IGZvciBcIkxpZmVjeWNsZUhvb2tTcGVjaWZpY2F0aW9uUHJvcGVydHlcIicpO1xufVxuXG4vKipcbiAqIFJlbmRlcnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OkF1dG9TY2FsaW5nOjpBdXRvU2NhbGluZ0dyb3VwLkxpZmVjeWNsZUhvb2tTcGVjaWZpY2F0aW9uYCByZXNvdXJjZVxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBMaWZlY3ljbGVIb29rU3BlY2lmaWNhdGlvblByb3BlcnR5YFxuICpcbiAqIEByZXR1cm5zIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpBdXRvU2NhbGluZzo6QXV0b1NjYWxpbmdHcm91cC5MaWZlY3ljbGVIb29rU3BlY2lmaWNhdGlvbmAgcmVzb3VyY2UuXG4gKi9cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBjZm5BdXRvU2NhbGluZ0dyb3VwTGlmZWN5Y2xlSG9va1NwZWNpZmljYXRpb25Qcm9wZXJ0eVRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogYW55IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBwcm9wZXJ0aWVzOyB9XG4gICAgQ2ZuQXV0b1NjYWxpbmdHcm91cF9MaWZlY3ljbGVIb29rU3BlY2lmaWNhdGlvblByb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXMpLmFzc2VydFN1Y2Nlc3MoKTtcbiAgICByZXR1cm4ge1xuICAgICAgICBEZWZhdWx0UmVzdWx0OiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLmRlZmF1bHRSZXN1bHQpLFxuICAgICAgICBIZWFydGJlYXRUaW1lb3V0OiBjZGsubnVtYmVyVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLmhlYXJ0YmVhdFRpbWVvdXQpLFxuICAgICAgICBMaWZlY3ljbGVIb29rTmFtZTogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5saWZlY3ljbGVIb29rTmFtZSksXG4gICAgICAgIExpZmVjeWNsZVRyYW5zaXRpb246IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMubGlmZWN5Y2xlVHJhbnNpdGlvbiksXG4gICAgICAgIE5vdGlmaWNhdGlvbk1ldGFkYXRhOiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLm5vdGlmaWNhdGlvbk1ldGFkYXRhKSxcbiAgICAgICAgTm90aWZpY2F0aW9uVGFyZ2V0QVJOOiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLm5vdGlmaWNhdGlvblRhcmdldEFybiksXG4gICAgICAgIFJvbGVBUk46IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMucm9sZUFybiksXG4gICAgfTtcbn1cblxuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIENmbkF1dG9TY2FsaW5nR3JvdXBMaWZlY3ljbGVIb29rU3BlY2lmaWNhdGlvblByb3BlcnR5RnJvbUNsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQ8Q2ZuQXV0b1NjYWxpbmdHcm91cC5MaWZlY3ljbGVIb29rU3BlY2lmaWNhdGlvblByb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlPiB7XG4gICAgaWYgKGNkay5pc1Jlc29sdmFibGVPYmplY3QocHJvcGVydGllcykpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0KHByb3BlcnRpZXMpO1xuICAgIH1cbiAgICBwcm9wZXJ0aWVzID0gcHJvcGVydGllcyA9PSBudWxsID8ge30gOiBwcm9wZXJ0aWVzO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0KHByb3BlcnRpZXMpO1xuICAgIH1cbiAgICBjb25zdCByZXQgPSBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblByb3BlcnR5T2JqZWN0PENmbkF1dG9TY2FsaW5nR3JvdXAuTGlmZWN5Y2xlSG9va1NwZWNpZmljYXRpb25Qcm9wZXJ0eT4oKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2RlZmF1bHRSZXN1bHQnLCAnRGVmYXVsdFJlc3VsdCcsIHByb3BlcnRpZXMuRGVmYXVsdFJlc3VsdCAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5EZWZhdWx0UmVzdWx0KSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdoZWFydGJlYXRUaW1lb3V0JywgJ0hlYXJ0YmVhdFRpbWVvdXQnLCBwcm9wZXJ0aWVzLkhlYXJ0YmVhdFRpbWVvdXQgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0TnVtYmVyKHByb3BlcnRpZXMuSGVhcnRiZWF0VGltZW91dCkgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnbGlmZWN5Y2xlSG9va05hbWUnLCAnTGlmZWN5Y2xlSG9va05hbWUnLCBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLkxpZmVjeWNsZUhvb2tOYW1lKSk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdsaWZlY3ljbGVUcmFuc2l0aW9uJywgJ0xpZmVjeWNsZVRyYW5zaXRpb24nLCBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLkxpZmVjeWNsZVRyYW5zaXRpb24pKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ25vdGlmaWNhdGlvbk1ldGFkYXRhJywgJ05vdGlmaWNhdGlvbk1ldGFkYXRhJywgcHJvcGVydGllcy5Ob3RpZmljYXRpb25NZXRhZGF0YSAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5Ob3RpZmljYXRpb25NZXRhZGF0YSkgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnbm90aWZpY2F0aW9uVGFyZ2V0QXJuJywgJ05vdGlmaWNhdGlvblRhcmdldEFSTicsIHByb3BlcnRpZXMuTm90aWZpY2F0aW9uVGFyZ2V0QVJOICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLk5vdGlmaWNhdGlvblRhcmdldEFSTikgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgncm9sZUFybicsICdSb2xlQVJOJywgcHJvcGVydGllcy5Sb2xlQVJOICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLlJvbGVBUk4pIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkVW5yZWNvZ25pemVkUHJvcGVydGllc0FzRXh0cmEocHJvcGVydGllcyk7XG4gICAgcmV0dXJuIHJldDtcbn1cblxuZXhwb3J0IG5hbWVzcGFjZSBDZm5BdXRvU2NhbGluZ0dyb3VwIHtcbiAgICAvKipcbiAgICAgKiBgTWVtb3J5R2lCUGVyVkNwdVJlcXVlc3RgIGlzIGEgcHJvcGVydHkgb2YgdGhlIGBJbnN0YW5jZVJlcXVpcmVtZW50c2AgcHJvcGVydHkgb2YgdGhlIFtBV1M6OkF1dG9TY2FsaW5nOjpBdXRvU2NhbGluZ0dyb3VwIExhdW5jaFRlbXBsYXRlT3ZlcnJpZGVzXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hdXRvc2NhbGluZy1hdXRvc2NhbGluZ2dyb3VwLWxhdW5jaHRlbXBsYXRlb3ZlcnJpZGVzLmh0bWwpIHByb3BlcnR5IHR5cGUgdGhhdCBkZXNjcmliZXMgdGhlIG1pbmltdW0gYW5kIG1heGltdW0gYW1vdW50IG9mIG1lbW9yeSBwZXIgdkNQVSBmb3IgYW4gaW5zdGFuY2UgdHlwZSwgaW4gR2lCLlxuICAgICAqXG4gICAgICogQHN0cnVjdFxuICAgICAqIEBzdGFiaWxpdHkgZXh0ZXJuYWxcbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXV0b3NjYWxpbmctYXV0b3NjYWxpbmdncm91cC1tZW1vcnlnaWJwZXJ2Y3B1cmVxdWVzdC5odG1sXG4gICAgICovXG4gICAgZXhwb3J0IGludGVyZmFjZSBNZW1vcnlHaUJQZXJWQ3B1UmVxdWVzdFByb3BlcnR5IHtcbiAgICAgICAgLyoqXG4gICAgICAgICAqIFRoZSBtZW1vcnkgbWF4aW11bSBpbiBHaUIuXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXV0b3NjYWxpbmctYXV0b3NjYWxpbmdncm91cC1tZW1vcnlnaWJwZXJ2Y3B1cmVxdWVzdC5odG1sI2Nmbi1hdXRvc2NhbGluZy1hdXRvc2NhbGluZ2dyb3VwLW1lbW9yeWdpYnBlcnZjcHVyZXF1ZXN0LW1heFxuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgbWF4PzogbnVtYmVyO1xuICAgICAgICAvKipcbiAgICAgICAgICogVGhlIG1lbW9yeSBtaW5pbXVtIGluIEdpQi5cbiAgICAgICAgICpcbiAgICAgICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hdXRvc2NhbGluZy1hdXRvc2NhbGluZ2dyb3VwLW1lbW9yeWdpYnBlcnZjcHVyZXF1ZXN0Lmh0bWwjY2ZuLWF1dG9zY2FsaW5nLWF1dG9zY2FsaW5nZ3JvdXAtbWVtb3J5Z2licGVydmNwdXJlcXVlc3QtbWluXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBtaW4/OiBudW1iZXI7XG4gICAgfVxufVxuXG4vKipcbiAqIERldGVybWluZSB3aGV0aGVyIHRoZSBnaXZlbiBwcm9wZXJ0aWVzIG1hdGNoIHRob3NlIG9mIGEgYE1lbW9yeUdpQlBlclZDcHVSZXF1ZXN0UHJvcGVydHlgXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYE1lbW9yeUdpQlBlclZDcHVSZXF1ZXN0UHJvcGVydHlgXG4gKlxuICogQHJldHVybnMgdGhlIHJlc3VsdCBvZiB0aGUgdmFsaWRhdGlvbi5cbiAqL1xuZnVuY3Rpb24gQ2ZuQXV0b1NjYWxpbmdHcm91cF9NZW1vcnlHaUJQZXJWQ3B1UmVxdWVzdFByb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXM6IGFueSk6IGNkay5WYWxpZGF0aW9uUmVzdWx0IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBjZGsuVkFMSURBVElPTl9TVUNDRVNTOyB9XG4gICAgY29uc3QgZXJyb3JzID0gbmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0cygpO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgZXJyb3JzLmNvbGxlY3QobmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0KCdFeHBlY3RlZCBhbiBvYmplY3QsIGJ1dCByZWNlaXZlZDogJyArIEpTT04uc3RyaW5naWZ5KHByb3BlcnRpZXMpKSk7XG4gICAgfVxuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignbWF4JywgY2RrLnZhbGlkYXRlTnVtYmVyKShwcm9wZXJ0aWVzLm1heCkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignbWluJywgY2RrLnZhbGlkYXRlTnVtYmVyKShwcm9wZXJ0aWVzLm1pbikpO1xuICAgIHJldHVybiBlcnJvcnMud3JhcCgnc3VwcGxpZWQgcHJvcGVydGllcyBub3QgY29ycmVjdCBmb3IgXCJNZW1vcnlHaUJQZXJWQ3B1UmVxdWVzdFByb3BlcnR5XCInKTtcbn1cblxuLyoqXG4gKiBSZW5kZXJzIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpBdXRvU2NhbGluZzo6QXV0b1NjYWxpbmdHcm91cC5NZW1vcnlHaUJQZXJWQ3B1UmVxdWVzdGAgcmVzb3VyY2VcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgTWVtb3J5R2lCUGVyVkNwdVJlcXVlc3RQcm9wZXJ0eWBcbiAqXG4gKiBAcmV0dXJucyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6QXV0b1NjYWxpbmc6OkF1dG9TY2FsaW5nR3JvdXAuTWVtb3J5R2lCUGVyVkNwdVJlcXVlc3RgIHJlc291cmNlLlxuICovXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gY2ZuQXV0b1NjYWxpbmdHcm91cE1lbW9yeUdpQlBlclZDcHVSZXF1ZXN0UHJvcGVydHlUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGFueSB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gcHJvcGVydGllczsgfVxuICAgIENmbkF1dG9TY2FsaW5nR3JvdXBfTWVtb3J5R2lCUGVyVkNwdVJlcXVlc3RQcm9wZXJ0eVZhbGlkYXRvcihwcm9wZXJ0aWVzKS5hc3NlcnRTdWNjZXNzKCk7XG4gICAgcmV0dXJuIHtcbiAgICAgICAgTWF4OiBjZGsubnVtYmVyVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLm1heCksXG4gICAgICAgIE1pbjogY2RrLm51bWJlclRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5taW4pLFxuICAgIH07XG59XG5cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBDZm5BdXRvU2NhbGluZ0dyb3VwTWVtb3J5R2lCUGVyVkNwdVJlcXVlc3RQcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0PENmbkF1dG9TY2FsaW5nR3JvdXAuTWVtb3J5R2lCUGVyVkNwdVJlcXVlc3RQcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZT4ge1xuICAgIGlmIChjZGsuaXNSZXNvbHZhYmxlT2JqZWN0KHByb3BlcnRpZXMpKSB7XG4gICAgICAgIHJldHVybiBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdChwcm9wZXJ0aWVzKTtcbiAgICB9XG4gICAgcHJvcGVydGllcyA9IHByb3BlcnRpZXMgPT0gbnVsbCA/IHt9IDogcHJvcGVydGllcztcbiAgICBpZiAodHlwZW9mIHByb3BlcnRpZXMgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIHJldHVybiBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdChwcm9wZXJ0aWVzKTtcbiAgICB9XG4gICAgY29uc3QgcmV0ID0gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25Qcm9wZXJ0eU9iamVjdDxDZm5BdXRvU2NhbGluZ0dyb3VwLk1lbW9yeUdpQlBlclZDcHVSZXF1ZXN0UHJvcGVydHk+KCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdtYXgnLCAnTWF4JywgcHJvcGVydGllcy5NYXggIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0TnVtYmVyKHByb3BlcnRpZXMuTWF4KSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdtaW4nLCAnTWluJywgcHJvcGVydGllcy5NaW4gIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0TnVtYmVyKHByb3BlcnRpZXMuTWluKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFVucmVjb2duaXplZFByb3BlcnRpZXNBc0V4dHJhKHByb3BlcnRpZXMpO1xuICAgIHJldHVybiByZXQ7XG59XG5cbmV4cG9ydCBuYW1lc3BhY2UgQ2ZuQXV0b1NjYWxpbmdHcm91cCB7XG4gICAgLyoqXG4gICAgICogYE1lbW9yeU1pQlJlcXVlc3RgIGlzIGEgcHJvcGVydHkgb2YgdGhlIGBJbnN0YW5jZVJlcXVpcmVtZW50c2AgcHJvcGVydHkgb2YgdGhlIFtBV1M6OkF1dG9TY2FsaW5nOjpBdXRvU2NhbGluZ0dyb3VwIExhdW5jaFRlbXBsYXRlT3ZlcnJpZGVzXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hdXRvc2NhbGluZy1hdXRvc2NhbGluZ2dyb3VwLWxhdW5jaHRlbXBsYXRlb3ZlcnJpZGVzLmh0bWwpIHByb3BlcnR5IHR5cGUgdGhhdCBkZXNjcmliZXMgdGhlIG1pbmltdW0gYW5kIG1heGltdW0gaW5zdGFuY2UgbWVtb3J5IHNpemUgZm9yIGFuIGluc3RhbmNlIHR5cGUsIGluIE1pQi5cbiAgICAgKlxuICAgICAqIEBzdHJ1Y3RcbiAgICAgKiBAc3RhYmlsaXR5IGV4dGVybmFsXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWF1dG9zY2FsaW5nLWF1dG9zY2FsaW5nZ3JvdXAtbWVtb3J5bWlicmVxdWVzdC5odG1sXG4gICAgICovXG4gICAgZXhwb3J0IGludGVyZmFjZSBNZW1vcnlNaUJSZXF1ZXN0UHJvcGVydHkge1xuICAgICAgICAvKipcbiAgICAgICAgICogVGhlIG1lbW9yeSBtYXhpbXVtIGluIE1pQi5cbiAgICAgICAgICpcbiAgICAgICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hdXRvc2NhbGluZy1hdXRvc2NhbGluZ2dyb3VwLW1lbW9yeW1pYnJlcXVlc3QuaHRtbCNjZm4tYXV0b3NjYWxpbmctYXV0b3NjYWxpbmdncm91cC1tZW1vcnltaWJyZXF1ZXN0LW1heFxuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgbWF4PzogbnVtYmVyO1xuICAgICAgICAvKipcbiAgICAgICAgICogVGhlIG1lbW9yeSBtaW5pbXVtIGluIE1pQi5cbiAgICAgICAgICpcbiAgICAgICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hdXRvc2NhbGluZy1hdXRvc2NhbGluZ2dyb3VwLW1lbW9yeW1pYnJlcXVlc3QuaHRtbCNjZm4tYXV0b3NjYWxpbmctYXV0b3NjYWxpbmdncm91cC1tZW1vcnltaWJyZXF1ZXN0LW1pblxuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgbWluPzogbnVtYmVyO1xuICAgIH1cbn1cblxuLyoqXG4gKiBEZXRlcm1pbmUgd2hldGhlciB0aGUgZ2l2ZW4gcHJvcGVydGllcyBtYXRjaCB0aG9zZSBvZiBhIGBNZW1vcnlNaUJSZXF1ZXN0UHJvcGVydHlgXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYE1lbW9yeU1pQlJlcXVlc3RQcm9wZXJ0eWBcbiAqXG4gKiBAcmV0dXJucyB0aGUgcmVzdWx0IG9mIHRoZSB2YWxpZGF0aW9uLlxuICovXG5mdW5jdGlvbiBDZm5BdXRvU2NhbGluZ0dyb3VwX01lbW9yeU1pQlJlcXVlc3RQcm9wZXJ0eVZhbGlkYXRvcihwcm9wZXJ0aWVzOiBhbnkpOiBjZGsuVmFsaWRhdGlvblJlc3VsdCB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gY2RrLlZBTElEQVRJT05fU1VDQ0VTUzsgfVxuICAgIGNvbnN0IGVycm9ycyA9IG5ldyBjZGsuVmFsaWRhdGlvblJlc3VsdHMoKTtcbiAgICBpZiAodHlwZW9mIHByb3BlcnRpZXMgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIGVycm9ycy5jb2xsZWN0KG5ldyBjZGsuVmFsaWRhdGlvblJlc3VsdCgnRXhwZWN0ZWQgYW4gb2JqZWN0LCBidXQgcmVjZWl2ZWQ6ICcgKyBKU09OLnN0cmluZ2lmeShwcm9wZXJ0aWVzKSkpO1xuICAgIH1cbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ21heCcsIGNkay52YWxpZGF0ZU51bWJlcikocHJvcGVydGllcy5tYXgpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ21pbicsIGNkay52YWxpZGF0ZU51bWJlcikocHJvcGVydGllcy5taW4pKTtcbiAgICByZXR1cm4gZXJyb3JzLndyYXAoJ3N1cHBsaWVkIHByb3BlcnRpZXMgbm90IGNvcnJlY3QgZm9yIFwiTWVtb3J5TWlCUmVxdWVzdFByb3BlcnR5XCInKTtcbn1cblxuLyoqXG4gKiBSZW5kZXJzIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpBdXRvU2NhbGluZzo6QXV0b1NjYWxpbmdHcm91cC5NZW1vcnlNaUJSZXF1ZXN0YCByZXNvdXJjZVxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBNZW1vcnlNaUJSZXF1ZXN0UHJvcGVydHlgXG4gKlxuICogQHJldHVybnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OkF1dG9TY2FsaW5nOjpBdXRvU2NhbGluZ0dyb3VwLk1lbW9yeU1pQlJlcXVlc3RgIHJlc291cmNlLlxuICovXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gY2ZuQXV0b1NjYWxpbmdHcm91cE1lbW9yeU1pQlJlcXVlc3RQcm9wZXJ0eVRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogYW55IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBwcm9wZXJ0aWVzOyB9XG4gICAgQ2ZuQXV0b1NjYWxpbmdHcm91cF9NZW1vcnlNaUJSZXF1ZXN0UHJvcGVydHlWYWxpZGF0b3IocHJvcGVydGllcykuYXNzZXJ0U3VjY2VzcygpO1xuICAgIHJldHVybiB7XG4gICAgICAgIE1heDogY2RrLm51bWJlclRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5tYXgpLFxuICAgICAgICBNaW46IGNkay5udW1iZXJUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMubWluKSxcbiAgICB9O1xufVxuXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gQ2ZuQXV0b1NjYWxpbmdHcm91cE1lbW9yeU1pQlJlcXVlc3RQcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0PENmbkF1dG9TY2FsaW5nR3JvdXAuTWVtb3J5TWlCUmVxdWVzdFByb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlPiB7XG4gICAgaWYgKGNkay5pc1Jlc29sdmFibGVPYmplY3QocHJvcGVydGllcykpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0KHByb3BlcnRpZXMpO1xuICAgIH1cbiAgICBwcm9wZXJ0aWVzID0gcHJvcGVydGllcyA9PSBudWxsID8ge30gOiBwcm9wZXJ0aWVzO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0KHByb3BlcnRpZXMpO1xuICAgIH1cbiAgICBjb25zdCByZXQgPSBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblByb3BlcnR5T2JqZWN0PENmbkF1dG9TY2FsaW5nR3JvdXAuTWVtb3J5TWlCUmVxdWVzdFByb3BlcnR5PigpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnbWF4JywgJ01heCcsIHByb3BlcnRpZXMuTWF4ICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldE51bWJlcihwcm9wZXJ0aWVzLk1heCkgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnbWluJywgJ01pbicsIHByb3BlcnRpZXMuTWluICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldE51bWJlcihwcm9wZXJ0aWVzLk1pbikgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRVbnJlY29nbml6ZWRQcm9wZXJ0aWVzQXNFeHRyYShwcm9wZXJ0aWVzKTtcbiAgICByZXR1cm4gcmV0O1xufVxuXG5leHBvcnQgbmFtZXNwYWNlIENmbkF1dG9TY2FsaW5nR3JvdXAge1xuICAgIC8qKlxuICAgICAqIGBNZXRyaWNzQ29sbGVjdGlvbmAgaXMgYSBwcm9wZXJ0eSBvZiB0aGUgW0FXUzo6QXV0b1NjYWxpbmc6OkF1dG9TY2FsaW5nR3JvdXBdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWFzLWdyb3VwLmh0bWwpIHJlc291cmNlIHRoYXQgZGVzY3JpYmVzIHRoZSBncm91cCBtZXRyaWNzIHRoYXQgYW4gQW1hem9uIEVDMiBBdXRvIFNjYWxpbmcgZ3JvdXAgc2VuZHMgdG8gQW1hem9uIENsb3VkV2F0Y2guIFRoZXNlIG1ldHJpY3MgZGVzY3JpYmUgdGhlIGdyb3VwIHJhdGhlciB0aGFuIGFueSBvZiBpdHMgaW5zdGFuY2VzLlxuICAgICAqXG4gICAgICogRm9yIG1vcmUgaW5mb3JtYXRpb24sIHNlZSBbTW9uaXRvciBDbG91ZFdhdGNoIG1ldHJpY3MgZm9yIHlvdXIgQXV0byBTY2FsaW5nIGdyb3VwcyBhbmQgaW5zdGFuY2VzXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vYXV0b3NjYWxpbmcvZWMyL3VzZXJndWlkZS9hcy1pbnN0YW5jZS1tb25pdG9yaW5nLmh0bWwpIGluIHRoZSAqQW1hem9uIEVDMiBBdXRvIFNjYWxpbmcgVXNlciBHdWlkZSogLiBZb3UgY2FuIGZpbmQgYSBzYW1wbGUgdGVtcGxhdGUgc25pcHBldCBpbiB0aGUgW0V4YW1wbGVzXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hcy1ncm91cC5odG1sI2F3cy1wcm9wZXJ0aWVzLWFzLWdyb3VwLS1leGFtcGxlcykgc2VjdGlvbiBvZiB0aGUgYEFXUzo6QXV0b1NjYWxpbmc6OkF1dG9TY2FsaW5nR3JvdXBgIHJlc291cmNlLlxuICAgICAqXG4gICAgICogQHN0cnVjdFxuICAgICAqIEBzdGFiaWxpdHkgZXh0ZXJuYWxcbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXMtbWV0cmljc2NvbGxlY3Rpb24uaHRtbFxuICAgICAqL1xuICAgIGV4cG9ydCBpbnRlcmZhY2UgTWV0cmljc0NvbGxlY3Rpb25Qcm9wZXJ0eSB7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBUaGUgZnJlcXVlbmN5IGF0IHdoaWNoIEFtYXpvbiBFQzIgQXV0byBTY2FsaW5nIHNlbmRzIGFnZ3JlZ2F0ZWQgZGF0YSB0byBDbG91ZFdhdGNoLiBUaGUgb25seSB2YWxpZCB2YWx1ZSBpcyBgMU1pbnV0ZWAgLlxuICAgICAgICAgKlxuICAgICAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWFzLW1ldHJpY3Njb2xsZWN0aW9uLmh0bWwjY2ZuLWFzLW1ldHJpY3Njb2xsZWN0aW9uLWdyYW51bGFyaXR5XG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBncmFudWxhcml0eTogc3RyaW5nO1xuICAgICAgICAvKipcbiAgICAgICAgICogSWRlbnRpZmllcyB0aGUgbWV0cmljcyB0byBlbmFibGUuXG4gICAgICAgICAqXG4gICAgICAgICAqIFlvdSBjYW4gc3BlY2lmeSBvbmUgb3IgbW9yZSBvZiB0aGUgZm9sbG93aW5nIG1ldHJpY3M6XG4gICAgICAgICAqXG4gICAgICAgICAqIC0gYEdyb3VwTWluU2l6ZWBcbiAgICAgICAgICogLSBgR3JvdXBNYXhTaXplYFxuICAgICAgICAgKiAtIGBHcm91cERlc2lyZWRDYXBhY2l0eWBcbiAgICAgICAgICogLSBgR3JvdXBJblNlcnZpY2VJbnN0YW5jZXNgXG4gICAgICAgICAqIC0gYEdyb3VwUGVuZGluZ0luc3RhbmNlc2BcbiAgICAgICAgICogLSBgR3JvdXBTdGFuZGJ5SW5zdGFuY2VzYFxuICAgICAgICAgKiAtIGBHcm91cFRlcm1pbmF0aW5nSW5zdGFuY2VzYFxuICAgICAgICAgKiAtIGBHcm91cFRvdGFsSW5zdGFuY2VzYFxuICAgICAgICAgKiAtIGBHcm91cEluU2VydmljZUNhcGFjaXR5YFxuICAgICAgICAgKiAtIGBHcm91cFBlbmRpbmdDYXBhY2l0eWBcbiAgICAgICAgICogLSBgR3JvdXBTdGFuZGJ5Q2FwYWNpdHlgXG4gICAgICAgICAqIC0gYEdyb3VwVGVybWluYXRpbmdDYXBhY2l0eWBcbiAgICAgICAgICogLSBgR3JvdXBUb3RhbENhcGFjaXR5YFxuICAgICAgICAgKiAtIGBXYXJtUG9vbERlc2lyZWRDYXBhY2l0eWBcbiAgICAgICAgICogLSBgV2FybVBvb2xXYXJtZWRDYXBhY2l0eWBcbiAgICAgICAgICogLSBgV2FybVBvb2xQZW5kaW5nQ2FwYWNpdHlgXG4gICAgICAgICAqIC0gYFdhcm1Qb29sVGVybWluYXRpbmdDYXBhY2l0eWBcbiAgICAgICAgICogLSBgV2FybVBvb2xUb3RhbENhcGFjaXR5YFxuICAgICAgICAgKiAtIGBHcm91cEFuZFdhcm1Qb29sRGVzaXJlZENhcGFjaXR5YFxuICAgICAgICAgKiAtIGBHcm91cEFuZFdhcm1Qb29sVG90YWxDYXBhY2l0eWBcbiAgICAgICAgICpcbiAgICAgICAgICogSWYgeW91IHNwZWNpZnkgYEdyYW51bGFyaXR5YCBhbmQgZG9uJ3Qgc3BlY2lmeSBhbnkgbWV0cmljcywgYWxsIG1ldHJpY3MgYXJlIGVuYWJsZWQuXG4gICAgICAgICAqXG4gICAgICAgICAqIEZvciBtb3JlIGluZm9ybWF0aW9uLCBzZWUgW0F1dG8gU2NhbGluZyBncm91cCBtZXRyaWNzXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vYXV0b3NjYWxpbmcvZWMyL3VzZXJndWlkZS9lYzItYXV0by1zY2FsaW5nLWNsb3Vkd2F0Y2gtbW9uaXRvcmluZy5odG1sI2FzLWdyb3VwLW1ldHJpY3MpIGluIHRoZSAqQW1hem9uIEVDMiBBdXRvIFNjYWxpbmcgVXNlciBHdWlkZSogLlxuICAgICAgICAgKlxuICAgICAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWFzLW1ldHJpY3Njb2xsZWN0aW9uLmh0bWwjY2ZuLWFzLW1ldHJpY3Njb2xsZWN0aW9uLW1ldHJpY3NcbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IG1ldHJpY3M/OiBzdHJpbmdbXTtcbiAgICB9XG59XG5cbi8qKlxuICogRGV0ZXJtaW5lIHdoZXRoZXIgdGhlIGdpdmVuIHByb3BlcnRpZXMgbWF0Y2ggdGhvc2Ugb2YgYSBgTWV0cmljc0NvbGxlY3Rpb25Qcm9wZXJ0eWBcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgTWV0cmljc0NvbGxlY3Rpb25Qcm9wZXJ0eWBcbiAqXG4gKiBAcmV0dXJucyB0aGUgcmVzdWx0IG9mIHRoZSB2YWxpZGF0aW9uLlxuICovXG5mdW5jdGlvbiBDZm5BdXRvU2NhbGluZ0dyb3VwX01ldHJpY3NDb2xsZWN0aW9uUHJvcGVydHlWYWxpZGF0b3IocHJvcGVydGllczogYW55KTogY2RrLlZhbGlkYXRpb25SZXN1bHQge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIGNkay5WQUxJREFUSU9OX1NVQ0NFU1M7IH1cbiAgICBjb25zdCBlcnJvcnMgPSBuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHRzKCk7XG4gICAgaWYgKHR5cGVvZiBwcm9wZXJ0aWVzICE9PSAnb2JqZWN0Jykge1xuICAgICAgICBlcnJvcnMuY29sbGVjdChuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHQoJ0V4cGVjdGVkIGFuIG9iamVjdCwgYnV0IHJlY2VpdmVkOiAnICsgSlNPTi5zdHJpbmdpZnkocHJvcGVydGllcykpKTtcbiAgICB9XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdncmFudWxhcml0eScsIGNkay5yZXF1aXJlZFZhbGlkYXRvcikocHJvcGVydGllcy5ncmFudWxhcml0eSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignZ3JhbnVsYXJpdHknLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuZ3JhbnVsYXJpdHkpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ21ldHJpY3MnLCBjZGsubGlzdFZhbGlkYXRvcihjZGsudmFsaWRhdGVTdHJpbmcpKShwcm9wZXJ0aWVzLm1ldHJpY3MpKTtcbiAgICByZXR1cm4gZXJyb3JzLndyYXAoJ3N1cHBsaWVkIHByb3BlcnRpZXMgbm90IGNvcnJlY3QgZm9yIFwiTWV0cmljc0NvbGxlY3Rpb25Qcm9wZXJ0eVwiJyk7XG59XG5cbi8qKlxuICogUmVuZGVycyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6QXV0b1NjYWxpbmc6OkF1dG9TY2FsaW5nR3JvdXAuTWV0cmljc0NvbGxlY3Rpb25gIHJlc291cmNlXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYE1ldHJpY3NDb2xsZWN0aW9uUHJvcGVydHlgXG4gKlxuICogQHJldHVybnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OkF1dG9TY2FsaW5nOjpBdXRvU2NhbGluZ0dyb3VwLk1ldHJpY3NDb2xsZWN0aW9uYCByZXNvdXJjZS5cbiAqL1xuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIGNmbkF1dG9TY2FsaW5nR3JvdXBNZXRyaWNzQ29sbGVjdGlvblByb3BlcnR5VG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBhbnkge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIHByb3BlcnRpZXM7IH1cbiAgICBDZm5BdXRvU2NhbGluZ0dyb3VwX01ldHJpY3NDb2xsZWN0aW9uUHJvcGVydHlWYWxpZGF0b3IocHJvcGVydGllcykuYXNzZXJ0U3VjY2VzcygpO1xuICAgIHJldHVybiB7XG4gICAgICAgIEdyYW51bGFyaXR5OiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLmdyYW51bGFyaXR5KSxcbiAgICAgICAgTWV0cmljczogY2RrLmxpc3RNYXBwZXIoY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24pKHByb3BlcnRpZXMubWV0cmljcyksXG4gICAgfTtcbn1cblxuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIENmbkF1dG9TY2FsaW5nR3JvdXBNZXRyaWNzQ29sbGVjdGlvblByb3BlcnR5RnJvbUNsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQ8Q2ZuQXV0b1NjYWxpbmdHcm91cC5NZXRyaWNzQ29sbGVjdGlvblByb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlPiB7XG4gICAgaWYgKGNkay5pc1Jlc29sdmFibGVPYmplY3QocHJvcGVydGllcykpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0KHByb3BlcnRpZXMpO1xuICAgIH1cbiAgICBwcm9wZXJ0aWVzID0gcHJvcGVydGllcyA9PSBudWxsID8ge30gOiBwcm9wZXJ0aWVzO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0KHByb3BlcnRpZXMpO1xuICAgIH1cbiAgICBjb25zdCByZXQgPSBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblByb3BlcnR5T2JqZWN0PENmbkF1dG9TY2FsaW5nR3JvdXAuTWV0cmljc0NvbGxlY3Rpb25Qcm9wZXJ0eT4oKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2dyYW51bGFyaXR5JywgJ0dyYW51bGFyaXR5JywgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5HcmFudWxhcml0eSkpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnbWV0cmljcycsICdNZXRyaWNzJywgcHJvcGVydGllcy5NZXRyaWNzICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZ0FycmF5KHByb3BlcnRpZXMuTWV0cmljcykgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRVbnJlY29nbml6ZWRQcm9wZXJ0aWVzQXNFeHRyYShwcm9wZXJ0aWVzKTtcbiAgICByZXR1cm4gcmV0O1xufVxuXG5leHBvcnQgbmFtZXNwYWNlIENmbkF1dG9TY2FsaW5nR3JvdXAge1xuICAgIC8qKlxuICAgICAqIFVzZSB0aGlzIHN0cnVjdHVyZSB0byBsYXVuY2ggbXVsdGlwbGUgaW5zdGFuY2UgdHlwZXMgYW5kIE9uLURlbWFuZCBJbnN0YW5jZXMgYW5kIFNwb3QgSW5zdGFuY2VzIHdpdGhpbiBhIHNpbmdsZSBBdXRvIFNjYWxpbmcgZ3JvdXAuXG4gICAgICpcbiAgICAgKiBBIG1peGVkIGluc3RhbmNlcyBwb2xpY3kgY29udGFpbnMgaW5mb3JtYXRpb24gdGhhdCBBbWF6b24gRUMyIEF1dG8gU2NhbGluZyBjYW4gdXNlIHRvIGxhdW5jaCBpbnN0YW5jZXMgYW5kIGhlbHAgb3B0aW1pemUgeW91ciBjb3N0cy4gRm9yIG1vcmUgaW5mb3JtYXRpb24sIHNlZSBbQXV0byBTY2FsaW5nIGdyb3VwcyB3aXRoIG11bHRpcGxlIGluc3RhbmNlIHR5cGVzIGFuZCBwdXJjaGFzZSBvcHRpb25zXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vYXV0b3NjYWxpbmcvZWMyL3VzZXJndWlkZS9lYzItYXV0by1zY2FsaW5nLW1peGVkLWluc3RhbmNlcy1ncm91cHMuaHRtbCkgaW4gdGhlICpBbWF6b24gRUMyIEF1dG8gU2NhbGluZyBVc2VyIEd1aWRlKiAuXG4gICAgICpcbiAgICAgKiBZb3UgY2FuIGNyZWF0ZSBhIG1peGVkIGluc3RhbmNlcyBwb2xpY3kgZm9yIG5ldyBhbmQgZXhpc3RpbmcgQXV0byBTY2FsaW5nIGdyb3Vwcy4gWW91IG11c3QgdXNlIGEgbGF1bmNoIHRlbXBsYXRlIHRvIGNvbmZpZ3VyZSB0aGUgcG9saWN5LiBZb3UgY2Fubm90IHVzZSBhIGxhdW5jaCBjb25maWd1cmF0aW9uLlxuICAgICAqXG4gICAgICogVGhlcmUgYXJlIGtleSBkaWZmZXJlbmNlcyBiZXR3ZWVuIFNwb3QgSW5zdGFuY2VzIGFuZCBPbi1EZW1hbmQgSW5zdGFuY2VzOlxuICAgICAqXG4gICAgICogLSBUaGUgcHJpY2UgZm9yIFNwb3QgSW5zdGFuY2VzIHZhcmllcyBiYXNlZCBvbiBkZW1hbmRcbiAgICAgKiAtIEFtYXpvbiBFQzIgY2FuIHRlcm1pbmF0ZSBhbiBpbmRpdmlkdWFsIFNwb3QgSW5zdGFuY2UgYXMgdGhlIGF2YWlsYWJpbGl0eSBvZiwgb3IgcHJpY2UgZm9yLCBTcG90IEluc3RhbmNlcyBjaGFuZ2VzXG4gICAgICpcbiAgICAgKiBXaGVuIGEgU3BvdCBJbnN0YW5jZSBpcyB0ZXJtaW5hdGVkLCBBbWF6b24gRUMyIEF1dG8gU2NhbGluZyBncm91cCBhdHRlbXB0cyB0byBsYXVuY2ggYSByZXBsYWNlbWVudCBpbnN0YW5jZSB0byBtYWludGFpbiB0aGUgZGVzaXJlZCBjYXBhY2l0eSBmb3IgdGhlIGdyb3VwLlxuICAgICAqXG4gICAgICogYE1peGVkSW5zdGFuY2VzUG9saWN5YCBpcyBhIHByb3BlcnR5IG9mIHRoZSBbQVdTOjpBdXRvU2NhbGluZzo6QXV0b1NjYWxpbmdHcm91cF0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXMtZ3JvdXAuaHRtbCkgcmVzb3VyY2UuXG4gICAgICpcbiAgICAgKiBAc3RydWN0XG4gICAgICogQHN0YWJpbGl0eSBleHRlcm5hbFxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9jZm4tYXMtZ3JvdXAtbWl4ZWRpbnN0YW5jZXNwb2xpY3kuaHRtbFxuICAgICAqL1xuICAgIGV4cG9ydCBpbnRlcmZhY2UgTWl4ZWRJbnN0YW5jZXNQb2xpY3lQcm9wZXJ0eSB7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBUaGUgaW5zdGFuY2VzIGRpc3RyaWJ1dGlvbi5cbiAgICAgICAgICpcbiAgICAgICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9jZm4tYXMtZ3JvdXAtbWl4ZWRpbnN0YW5jZXNwb2xpY3kuaHRtbCNjZm4tYXMtbWl4ZWRpbnN0YW5jZXNwb2xpY3ktaW5zdGFuY2VzZGlzdHJpYnV0aW9uXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBpbnN0YW5jZXNEaXN0cmlidXRpb24/OiBDZm5BdXRvU2NhbGluZ0dyb3VwLkluc3RhbmNlc0Rpc3RyaWJ1dGlvblByb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlO1xuICAgICAgICAvKipcbiAgICAgICAgICogT25lIG9yIG1vcmUgbGF1bmNoIHRlbXBsYXRlcyBhbmQgdGhlIGluc3RhbmNlIHR5cGVzIChvdmVycmlkZXMpIHRoYXQgYXJlIHVzZWQgdG8gbGF1bmNoIEVDMiBpbnN0YW5jZXMgdG8gZnVsZmlsbCBPbi1EZW1hbmQgYW5kIFNwb3QgY2FwYWNpdGllcy5cbiAgICAgICAgICpcbiAgICAgICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9jZm4tYXMtZ3JvdXAtbWl4ZWRpbnN0YW5jZXNwb2xpY3kuaHRtbCNjZm4tYXMtbWl4ZWRpbnN0YW5jZXNwb2xpY3ktbGF1bmNodGVtcGxhdGVcbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IGxhdW5jaFRlbXBsYXRlOiBDZm5BdXRvU2NhbGluZ0dyb3VwLkxhdW5jaFRlbXBsYXRlUHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGU7XG4gICAgfVxufVxuXG4vKipcbiAqIERldGVybWluZSB3aGV0aGVyIHRoZSBnaXZlbiBwcm9wZXJ0aWVzIG1hdGNoIHRob3NlIG9mIGEgYE1peGVkSW5zdGFuY2VzUG9saWN5UHJvcGVydHlgXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYE1peGVkSW5zdGFuY2VzUG9saWN5UHJvcGVydHlgXG4gKlxuICogQHJldHVybnMgdGhlIHJlc3VsdCBvZiB0aGUgdmFsaWRhdGlvbi5cbiAqL1xuZnVuY3Rpb24gQ2ZuQXV0b1NjYWxpbmdHcm91cF9NaXhlZEluc3RhbmNlc1BvbGljeVByb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXM6IGFueSk6IGNkay5WYWxpZGF0aW9uUmVzdWx0IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBjZGsuVkFMSURBVElPTl9TVUNDRVNTOyB9XG4gICAgY29uc3QgZXJyb3JzID0gbmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0cygpO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgZXJyb3JzLmNvbGxlY3QobmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0KCdFeHBlY3RlZCBhbiBvYmplY3QsIGJ1dCByZWNlaXZlZDogJyArIEpTT04uc3RyaW5naWZ5KHByb3BlcnRpZXMpKSk7XG4gICAgfVxuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignaW5zdGFuY2VzRGlzdHJpYnV0aW9uJywgQ2ZuQXV0b1NjYWxpbmdHcm91cF9JbnN0YW5jZXNEaXN0cmlidXRpb25Qcm9wZXJ0eVZhbGlkYXRvcikocHJvcGVydGllcy5pbnN0YW5jZXNEaXN0cmlidXRpb24pKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2xhdW5jaFRlbXBsYXRlJywgY2RrLnJlcXVpcmVkVmFsaWRhdG9yKShwcm9wZXJ0aWVzLmxhdW5jaFRlbXBsYXRlKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdsYXVuY2hUZW1wbGF0ZScsIENmbkF1dG9TY2FsaW5nR3JvdXBfTGF1bmNoVGVtcGxhdGVQcm9wZXJ0eVZhbGlkYXRvcikocHJvcGVydGllcy5sYXVuY2hUZW1wbGF0ZSkpO1xuICAgIHJldHVybiBlcnJvcnMud3JhcCgnc3VwcGxpZWQgcHJvcGVydGllcyBub3QgY29ycmVjdCBmb3IgXCJNaXhlZEluc3RhbmNlc1BvbGljeVByb3BlcnR5XCInKTtcbn1cblxuLyoqXG4gKiBSZW5kZXJzIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpBdXRvU2NhbGluZzo6QXV0b1NjYWxpbmdHcm91cC5NaXhlZEluc3RhbmNlc1BvbGljeWAgcmVzb3VyY2VcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgTWl4ZWRJbnN0YW5jZXNQb2xpY3lQcm9wZXJ0eWBcbiAqXG4gKiBAcmV0dXJucyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6QXV0b1NjYWxpbmc6OkF1dG9TY2FsaW5nR3JvdXAuTWl4ZWRJbnN0YW5jZXNQb2xpY3lgIHJlc291cmNlLlxuICovXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gY2ZuQXV0b1NjYWxpbmdHcm91cE1peGVkSW5zdGFuY2VzUG9saWN5UHJvcGVydHlUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGFueSB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gcHJvcGVydGllczsgfVxuICAgIENmbkF1dG9TY2FsaW5nR3JvdXBfTWl4ZWRJbnN0YW5jZXNQb2xpY3lQcm9wZXJ0eVZhbGlkYXRvcihwcm9wZXJ0aWVzKS5hc3NlcnRTdWNjZXNzKCk7XG4gICAgcmV0dXJuIHtcbiAgICAgICAgSW5zdGFuY2VzRGlzdHJpYnV0aW9uOiBjZm5BdXRvU2NhbGluZ0dyb3VwSW5zdGFuY2VzRGlzdHJpYnV0aW9uUHJvcGVydHlUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuaW5zdGFuY2VzRGlzdHJpYnV0aW9uKSxcbiAgICAgICAgTGF1bmNoVGVtcGxhdGU6IGNmbkF1dG9TY2FsaW5nR3JvdXBMYXVuY2hUZW1wbGF0ZVByb3BlcnR5VG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLmxhdW5jaFRlbXBsYXRlKSxcbiAgICB9O1xufVxuXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gQ2ZuQXV0b1NjYWxpbmdHcm91cE1peGVkSW5zdGFuY2VzUG9saWN5UHJvcGVydHlGcm9tQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdDxDZm5BdXRvU2NhbGluZ0dyb3VwLk1peGVkSW5zdGFuY2VzUG9saWN5UHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGU+IHtcbiAgICBpZiAoY2RrLmlzUmVzb2x2YWJsZU9iamVjdChwcm9wZXJ0aWVzKSkge1xuICAgICAgICByZXR1cm4gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQocHJvcGVydGllcyk7XG4gICAgfVxuICAgIHByb3BlcnRpZXMgPSBwcm9wZXJ0aWVzID09IG51bGwgPyB7fSA6IHByb3BlcnRpZXM7XG4gICAgaWYgKHR5cGVvZiBwcm9wZXJ0aWVzICE9PSAnb2JqZWN0Jykge1xuICAgICAgICByZXR1cm4gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQocHJvcGVydGllcyk7XG4gICAgfVxuICAgIGNvbnN0IHJldCA9IG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUHJvcGVydHlPYmplY3Q8Q2ZuQXV0b1NjYWxpbmdHcm91cC5NaXhlZEluc3RhbmNlc1BvbGljeVByb3BlcnR5PigpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnaW5zdGFuY2VzRGlzdHJpYnV0aW9uJywgJ0luc3RhbmNlc0Rpc3RyaWJ1dGlvbicsIHByb3BlcnRpZXMuSW5zdGFuY2VzRGlzdHJpYnV0aW9uICE9IG51bGwgPyBDZm5BdXRvU2NhbGluZ0dyb3VwSW5zdGFuY2VzRGlzdHJpYnV0aW9uUHJvcGVydHlGcm9tQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5JbnN0YW5jZXNEaXN0cmlidXRpb24pIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2xhdW5jaFRlbXBsYXRlJywgJ0xhdW5jaFRlbXBsYXRlJywgQ2ZuQXV0b1NjYWxpbmdHcm91cExhdW5jaFRlbXBsYXRlUHJvcGVydHlGcm9tQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5MYXVuY2hUZW1wbGF0ZSkpO1xuICAgIHJldC5hZGRVbnJlY29nbml6ZWRQcm9wZXJ0aWVzQXNFeHRyYShwcm9wZXJ0aWVzKTtcbiAgICByZXR1cm4gcmV0O1xufVxuXG5leHBvcnQgbmFtZXNwYWNlIENmbkF1dG9TY2FsaW5nR3JvdXAge1xuICAgIC8qKlxuICAgICAqIGBOZXR3b3JrQmFuZHdpZHRoR2Jwc1JlcXVlc3RgIGlzIGEgcHJvcGVydHkgb2YgdGhlIGBJbnN0YW5jZVJlcXVpcmVtZW50c2AgcHJvcGVydHkgb2YgdGhlIFtBV1M6OkF1dG9TY2FsaW5nOjpBdXRvU2NhbGluZ0dyb3VwIExhdW5jaFRlbXBsYXRlT3ZlcnJpZGVzXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hdXRvc2NhbGluZy1hdXRvc2NhbGluZ2dyb3VwLWxhdW5jaHRlbXBsYXRlb3ZlcnJpZGVzLmh0bWwpIHByb3BlcnR5IHR5cGUgdGhhdCBkZXNjcmliZXMgdGhlIG1pbmltdW0gYW5kIG1heGltdW0gbmV0d29yayBiYW5kd2lkdGggZm9yIGFuIGluc3RhbmNlIHR5cGUsIGluIEdicHMuXG4gICAgICpcbiAgICAgKiA+IFNldHRpbmcgdGhlIG1pbmltdW0gYmFuZHdpZHRoIGRvZXMgbm90IGd1YXJhbnRlZSB0aGF0IHlvdXIgaW5zdGFuY2Ugd2lsbCBhY2hpZXZlIHRoZSBtaW5pbXVtIGJhbmR3aWR0aC4gQW1hem9uIEVDMiB3aWxsIGlkZW50aWZ5IGluc3RhbmNlIHR5cGVzIHRoYXQgc3VwcG9ydCB0aGUgc3BlY2lmaWVkIG1pbmltdW0gYmFuZHdpZHRoLCBidXQgdGhlIGFjdHVhbCBiYW5kd2lkdGggb2YgeW91ciBpbnN0YW5jZSBtaWdodCBnbyBiZWxvdyB0aGUgc3BlY2lmaWVkIG1pbmltdW0gYXQgdGltZXMuIEZvciBtb3JlIGluZm9ybWF0aW9uLCBzZWUgW0F2YWlsYWJsZSBpbnN0YW5jZSBiYW5kd2lkdGhdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NFQzIvbGF0ZXN0L1VzZXJHdWlkZS9lYzItaW5zdGFuY2UtbmV0d29yay1iYW5kd2lkdGguaHRtbCNhdmFpbGFibGUtaW5zdGFuY2UtYmFuZHdpZHRoKSBpbiB0aGUgKkFtYXpvbiBFQzIgVXNlciBHdWlkZSBmb3IgTGludXggSW5zdGFuY2VzKiAuXG4gICAgICpcbiAgICAgKiBAc3RydWN0XG4gICAgICogQHN0YWJpbGl0eSBleHRlcm5hbFxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hdXRvc2NhbGluZy1hdXRvc2NhbGluZ2dyb3VwLW5ldHdvcmtiYW5kd2lkdGhnYnBzcmVxdWVzdC5odG1sXG4gICAgICovXG4gICAgZXhwb3J0IGludGVyZmFjZSBOZXR3b3JrQmFuZHdpZHRoR2Jwc1JlcXVlc3RQcm9wZXJ0eSB7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBUaGUgbWF4aW11bSBhbW91bnQgb2YgbmV0d29yayBiYW5kd2lkdGgsIGluIGdpZ2FiaXRzIHBlciBzZWNvbmQgKEdicHMpLlxuICAgICAgICAgKlxuICAgICAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWF1dG9zY2FsaW5nLWF1dG9zY2FsaW5nZ3JvdXAtbmV0d29ya2JhbmR3aWR0aGdicHNyZXF1ZXN0Lmh0bWwjY2ZuLWF1dG9zY2FsaW5nLWF1dG9zY2FsaW5nZ3JvdXAtbmV0d29ya2JhbmR3aWR0aGdicHNyZXF1ZXN0LW1heFxuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgbWF4PzogbnVtYmVyO1xuICAgICAgICAvKipcbiAgICAgICAgICogVGhlIG1pbmltdW0gYW1vdW50IG9mIG5ldHdvcmsgYmFuZHdpZHRoLCBpbiBnaWdhYml0cyBwZXIgc2Vjb25kIChHYnBzKS5cbiAgICAgICAgICpcbiAgICAgICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hdXRvc2NhbGluZy1hdXRvc2NhbGluZ2dyb3VwLW5ldHdvcmtiYW5kd2lkdGhnYnBzcmVxdWVzdC5odG1sI2Nmbi1hdXRvc2NhbGluZy1hdXRvc2NhbGluZ2dyb3VwLW5ldHdvcmtiYW5kd2lkdGhnYnBzcmVxdWVzdC1taW5cbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IG1pbj86IG51bWJlcjtcbiAgICB9XG59XG5cbi8qKlxuICogRGV0ZXJtaW5lIHdoZXRoZXIgdGhlIGdpdmVuIHByb3BlcnRpZXMgbWF0Y2ggdGhvc2Ugb2YgYSBgTmV0d29ya0JhbmR3aWR0aEdicHNSZXF1ZXN0UHJvcGVydHlgXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYE5ldHdvcmtCYW5kd2lkdGhHYnBzUmVxdWVzdFByb3BlcnR5YFxuICpcbiAqIEByZXR1cm5zIHRoZSByZXN1bHQgb2YgdGhlIHZhbGlkYXRpb24uXG4gKi9cbmZ1bmN0aW9uIENmbkF1dG9TY2FsaW5nR3JvdXBfTmV0d29ya0JhbmR3aWR0aEdicHNSZXF1ZXN0UHJvcGVydHlWYWxpZGF0b3IocHJvcGVydGllczogYW55KTogY2RrLlZhbGlkYXRpb25SZXN1bHQge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIGNkay5WQUxJREFUSU9OX1NVQ0NFU1M7IH1cbiAgICBjb25zdCBlcnJvcnMgPSBuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHRzKCk7XG4gICAgaWYgKHR5cGVvZiBwcm9wZXJ0aWVzICE9PSAnb2JqZWN0Jykge1xuICAgICAgICBlcnJvcnMuY29sbGVjdChuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHQoJ0V4cGVjdGVkIGFuIG9iamVjdCwgYnV0IHJlY2VpdmVkOiAnICsgSlNPTi5zdHJpbmdpZnkocHJvcGVydGllcykpKTtcbiAgICB9XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdtYXgnLCBjZGsudmFsaWRhdGVOdW1iZXIpKHByb3BlcnRpZXMubWF4KSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdtaW4nLCBjZGsudmFsaWRhdGVOdW1iZXIpKHByb3BlcnRpZXMubWluKSk7XG4gICAgcmV0dXJuIGVycm9ycy53cmFwKCdzdXBwbGllZCBwcm9wZXJ0aWVzIG5vdCBjb3JyZWN0IGZvciBcIk5ldHdvcmtCYW5kd2lkdGhHYnBzUmVxdWVzdFByb3BlcnR5XCInKTtcbn1cblxuLyoqXG4gKiBSZW5kZXJzIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpBdXRvU2NhbGluZzo6QXV0b1NjYWxpbmdHcm91cC5OZXR3b3JrQmFuZHdpZHRoR2Jwc1JlcXVlc3RgIHJlc291cmNlXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYE5ldHdvcmtCYW5kd2lkdGhHYnBzUmVxdWVzdFByb3BlcnR5YFxuICpcbiAqIEByZXR1cm5zIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpBdXRvU2NhbGluZzo6QXV0b1NjYWxpbmdHcm91cC5OZXR3b3JrQmFuZHdpZHRoR2Jwc1JlcXVlc3RgIHJlc291cmNlLlxuICovXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gY2ZuQXV0b1NjYWxpbmdHcm91cE5ldHdvcmtCYW5kd2lkdGhHYnBzUmVxdWVzdFByb3BlcnR5VG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBhbnkge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIHByb3BlcnRpZXM7IH1cbiAgICBDZm5BdXRvU2NhbGluZ0dyb3VwX05ldHdvcmtCYW5kd2lkdGhHYnBzUmVxdWVzdFByb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXMpLmFzc2VydFN1Y2Nlc3MoKTtcbiAgICByZXR1cm4ge1xuICAgICAgICBNYXg6IGNkay5udW1iZXJUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMubWF4KSxcbiAgICAgICAgTWluOiBjZGsubnVtYmVyVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLm1pbiksXG4gICAgfTtcbn1cblxuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIENmbkF1dG9TY2FsaW5nR3JvdXBOZXR3b3JrQmFuZHdpZHRoR2Jwc1JlcXVlc3RQcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0PENmbkF1dG9TY2FsaW5nR3JvdXAuTmV0d29ya0JhbmR3aWR0aEdicHNSZXF1ZXN0UHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGU+IHtcbiAgICBpZiAoY2RrLmlzUmVzb2x2YWJsZU9iamVjdChwcm9wZXJ0aWVzKSkge1xuICAgICAgICByZXR1cm4gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQocHJvcGVydGllcyk7XG4gICAgfVxuICAgIHByb3BlcnRpZXMgPSBwcm9wZXJ0aWVzID09IG51bGwgPyB7fSA6IHByb3BlcnRpZXM7XG4gICAgaWYgKHR5cGVvZiBwcm9wZXJ0aWVzICE9PSAnb2JqZWN0Jykge1xuICAgICAgICByZXR1cm4gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQocHJvcGVydGllcyk7XG4gICAgfVxuICAgIGNvbnN0IHJldCA9IG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUHJvcGVydHlPYmplY3Q8Q2ZuQXV0b1NjYWxpbmdHcm91cC5OZXR3b3JrQmFuZHdpZHRoR2Jwc1JlcXVlc3RQcm9wZXJ0eT4oKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ21heCcsICdNYXgnLCBwcm9wZXJ0aWVzLk1heCAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXROdW1iZXIocHJvcGVydGllcy5NYXgpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ21pbicsICdNaW4nLCBwcm9wZXJ0aWVzLk1pbiAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXROdW1iZXIocHJvcGVydGllcy5NaW4pIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkVW5yZWNvZ25pemVkUHJvcGVydGllc0FzRXh0cmEocHJvcGVydGllcyk7XG4gICAgcmV0dXJuIHJldDtcbn1cblxuZXhwb3J0IG5hbWVzcGFjZSBDZm5BdXRvU2NhbGluZ0dyb3VwIHtcbiAgICAvKipcbiAgICAgKiBgTmV0d29ya0ludGVyZmFjZUNvdW50UmVxdWVzdGAgaXMgYSBwcm9wZXJ0eSBvZiB0aGUgYEluc3RhbmNlUmVxdWlyZW1lbnRzYCBwcm9wZXJ0eSBvZiB0aGUgW0FXUzo6QXV0b1NjYWxpbmc6OkF1dG9TY2FsaW5nR3JvdXAgTGF1bmNoVGVtcGxhdGVPdmVycmlkZXNdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWF1dG9zY2FsaW5nLWF1dG9zY2FsaW5nZ3JvdXAtbGF1bmNodGVtcGxhdGVvdmVycmlkZXMuaHRtbCkgcHJvcGVydHkgdHlwZSB0aGF0IGRlc2NyaWJlcyB0aGUgbWluaW11bSBhbmQgbWF4aW11bSBudW1iZXIgb2YgbmV0d29yayBpbnRlcmZhY2VzIGZvciBhbiBpbnN0YW5jZSB0eXBlLlxuICAgICAqXG4gICAgICogQHN0cnVjdFxuICAgICAqIEBzdGFiaWxpdHkgZXh0ZXJuYWxcbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXV0b3NjYWxpbmctYXV0b3NjYWxpbmdncm91cC1uZXR3b3JraW50ZXJmYWNlY291bnRyZXF1ZXN0Lmh0bWxcbiAgICAgKi9cbiAgICBleHBvcnQgaW50ZXJmYWNlIE5ldHdvcmtJbnRlcmZhY2VDb3VudFJlcXVlc3RQcm9wZXJ0eSB7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBUaGUgbWF4aW11bSBudW1iZXIgb2YgbmV0d29yayBpbnRlcmZhY2VzLlxuICAgICAgICAgKlxuICAgICAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWF1dG9zY2FsaW5nLWF1dG9zY2FsaW5nZ3JvdXAtbmV0d29ya2ludGVyZmFjZWNvdW50cmVxdWVzdC5odG1sI2Nmbi1hdXRvc2NhbGluZy1hdXRvc2NhbGluZ2dyb3VwLW5ldHdvcmtpbnRlcmZhY2Vjb3VudHJlcXVlc3QtbWF4XG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBtYXg/OiBudW1iZXI7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBUaGUgbWluaW11bSBudW1iZXIgb2YgbmV0d29yayBpbnRlcmZhY2VzLlxuICAgICAgICAgKlxuICAgICAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWF1dG9zY2FsaW5nLWF1dG9zY2FsaW5nZ3JvdXAtbmV0d29ya2ludGVyZmFjZWNvdW50cmVxdWVzdC5odG1sI2Nmbi1hdXRvc2NhbGluZy1hdXRvc2NhbGluZ2dyb3VwLW5ldHdvcmtpbnRlcmZhY2Vjb3VudHJlcXVlc3QtbWluXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBtaW4/OiBudW1iZXI7XG4gICAgfVxufVxuXG4vKipcbiAqIERldGVybWluZSB3aGV0aGVyIHRoZSBnaXZlbiBwcm9wZXJ0aWVzIG1hdGNoIHRob3NlIG9mIGEgYE5ldHdvcmtJbnRlcmZhY2VDb3VudFJlcXVlc3RQcm9wZXJ0eWBcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgTmV0d29ya0ludGVyZmFjZUNvdW50UmVxdWVzdFByb3BlcnR5YFxuICpcbiAqIEByZXR1cm5zIHRoZSByZXN1bHQgb2YgdGhlIHZhbGlkYXRpb24uXG4gKi9cbmZ1bmN0aW9uIENmbkF1dG9TY2FsaW5nR3JvdXBfTmV0d29ya0ludGVyZmFjZUNvdW50UmVxdWVzdFByb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXM6IGFueSk6IGNkay5WYWxpZGF0aW9uUmVzdWx0IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBjZGsuVkFMSURBVElPTl9TVUNDRVNTOyB9XG4gICAgY29uc3QgZXJyb3JzID0gbmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0cygpO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgZXJyb3JzLmNvbGxlY3QobmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0KCdFeHBlY3RlZCBhbiBvYmplY3QsIGJ1dCByZWNlaXZlZDogJyArIEpTT04uc3RyaW5naWZ5KHByb3BlcnRpZXMpKSk7XG4gICAgfVxuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignbWF4JywgY2RrLnZhbGlkYXRlTnVtYmVyKShwcm9wZXJ0aWVzLm1heCkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignbWluJywgY2RrLnZhbGlkYXRlTnVtYmVyKShwcm9wZXJ0aWVzLm1pbikpO1xuICAgIHJldHVybiBlcnJvcnMud3JhcCgnc3VwcGxpZWQgcHJvcGVydGllcyBub3QgY29ycmVjdCBmb3IgXCJOZXR3b3JrSW50ZXJmYWNlQ291bnRSZXF1ZXN0UHJvcGVydHlcIicpO1xufVxuXG4vKipcbiAqIFJlbmRlcnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OkF1dG9TY2FsaW5nOjpBdXRvU2NhbGluZ0dyb3VwLk5ldHdvcmtJbnRlcmZhY2VDb3VudFJlcXVlc3RgIHJlc291cmNlXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYE5ldHdvcmtJbnRlcmZhY2VDb3VudFJlcXVlc3RQcm9wZXJ0eWBcbiAqXG4gKiBAcmV0dXJucyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6QXV0b1NjYWxpbmc6OkF1dG9TY2FsaW5nR3JvdXAuTmV0d29ya0ludGVyZmFjZUNvdW50UmVxdWVzdGAgcmVzb3VyY2UuXG4gKi9cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBjZm5BdXRvU2NhbGluZ0dyb3VwTmV0d29ya0ludGVyZmFjZUNvdW50UmVxdWVzdFByb3BlcnR5VG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBhbnkge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIHByb3BlcnRpZXM7IH1cbiAgICBDZm5BdXRvU2NhbGluZ0dyb3VwX05ldHdvcmtJbnRlcmZhY2VDb3VudFJlcXVlc3RQcm9wZXJ0eVZhbGlkYXRvcihwcm9wZXJ0aWVzKS5hc3NlcnRTdWNjZXNzKCk7XG4gICAgcmV0dXJuIHtcbiAgICAgICAgTWF4OiBjZGsubnVtYmVyVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLm1heCksXG4gICAgICAgIE1pbjogY2RrLm51bWJlclRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5taW4pLFxuICAgIH07XG59XG5cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBDZm5BdXRvU2NhbGluZ0dyb3VwTmV0d29ya0ludGVyZmFjZUNvdW50UmVxdWVzdFByb3BlcnR5RnJvbUNsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQ8Q2ZuQXV0b1NjYWxpbmdHcm91cC5OZXR3b3JrSW50ZXJmYWNlQ291bnRSZXF1ZXN0UHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGU+IHtcbiAgICBpZiAoY2RrLmlzUmVzb2x2YWJsZU9iamVjdChwcm9wZXJ0aWVzKSkge1xuICAgICAgICByZXR1cm4gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQocHJvcGVydGllcyk7XG4gICAgfVxuICAgIHByb3BlcnRpZXMgPSBwcm9wZXJ0aWVzID09IG51bGwgPyB7fSA6IHByb3BlcnRpZXM7XG4gICAgaWYgKHR5cGVvZiBwcm9wZXJ0aWVzICE9PSAnb2JqZWN0Jykge1xuICAgICAgICByZXR1cm4gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQocHJvcGVydGllcyk7XG4gICAgfVxuICAgIGNvbnN0IHJldCA9IG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUHJvcGVydHlPYmplY3Q8Q2ZuQXV0b1NjYWxpbmdHcm91cC5OZXR3b3JrSW50ZXJmYWNlQ291bnRSZXF1ZXN0UHJvcGVydHk+KCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdtYXgnLCAnTWF4JywgcHJvcGVydGllcy5NYXggIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0TnVtYmVyKHByb3BlcnRpZXMuTWF4KSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdtaW4nLCAnTWluJywgcHJvcGVydGllcy5NaW4gIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0TnVtYmVyKHByb3BlcnRpZXMuTWluKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFVucmVjb2duaXplZFByb3BlcnRpZXNBc0V4dHJhKHByb3BlcnRpZXMpO1xuICAgIHJldHVybiByZXQ7XG59XG5cbmV4cG9ydCBuYW1lc3BhY2UgQ2ZuQXV0b1NjYWxpbmdHcm91cCB7XG4gICAgLyoqXG4gICAgICogQSBzdHJ1Y3R1cmUgdGhhdCBzcGVjaWZpZXMgYW4gQW1hem9uIFNOUyBub3RpZmljYXRpb24gY29uZmlndXJhdGlvbiBmb3IgdGhlIGBOb3RpZmljYXRpb25Db25maWd1cmF0aW9uc2AgcHJvcGVydHkgb2YgdGhlIFtBV1M6OkF1dG9TY2FsaW5nOjpBdXRvU2NhbGluZ0dyb3VwXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hcy1ncm91cC5odG1sKSByZXNvdXJjZS5cbiAgICAgKlxuICAgICAqIEZvciBhbiBleGFtcGxlIHRlbXBsYXRlIHNuaXBwZXQsIHNlZSBbQXV0byBzY2FsaW5nIHRlbXBsYXRlIHNuaXBwZXRzXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9xdWlja3JlZi1hdXRvc2NhbGluZy5odG1sKSAuXG4gICAgICpcbiAgICAgKiBGb3IgbW9yZSBpbmZvcm1hdGlvbiwgc2VlIFtHZXQgQW1hem9uIFNOUyBub3RpZmljYXRpb25zIHdoZW4geW91ciBBdXRvIFNjYWxpbmcgZ3JvdXAgc2NhbGVzXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vYXV0b3NjYWxpbmcvZWMyL3VzZXJndWlkZS9BU0dldHRpbmdOb3RpZmljYXRpb25zLmh0bWwpIGluIHRoZSAqQW1hem9uIEVDMiBBdXRvIFNjYWxpbmcgVXNlciBHdWlkZSogLlxuICAgICAqXG4gICAgICogQHN0cnVjdFxuICAgICAqIEBzdGFiaWxpdHkgZXh0ZXJuYWxcbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXMtbm90aWZpY2F0aW9uY29uZmlndXJhdGlvbnMuaHRtbFxuICAgICAqL1xuICAgIGV4cG9ydCBpbnRlcmZhY2UgTm90aWZpY2F0aW9uQ29uZmlndXJhdGlvblByb3BlcnR5IHtcbiAgICAgICAgLyoqXG4gICAgICAgICAqIEEgbGlzdCBvZiBldmVudCB0eXBlcyB0aGF0IHNlbmQgYSBub3RpZmljYXRpb24uIEV2ZW50IHR5cGVzIGNhbiBpbmNsdWRlIGFueSBvZiB0aGUgZm9sbG93aW5nIHR5cGVzLlxuICAgICAgICAgKlxuICAgICAgICAgKiAqQWxsb3dlZCB2YWx1ZXMqIDpcbiAgICAgICAgICpcbiAgICAgICAgICogLSBgYXV0b3NjYWxpbmc6RUMyX0lOU1RBTkNFX0xBVU5DSGBcbiAgICAgICAgICogLSBgYXV0b3NjYWxpbmc6RUMyX0lOU1RBTkNFX0xBVU5DSF9FUlJPUmBcbiAgICAgICAgICogLSBgYXV0b3NjYWxpbmc6RUMyX0lOU1RBTkNFX1RFUk1JTkFURWBcbiAgICAgICAgICogLSBgYXV0b3NjYWxpbmc6RUMyX0lOU1RBTkNFX1RFUk1JTkFURV9FUlJPUmBcbiAgICAgICAgICogLSBgYXV0b3NjYWxpbmc6VEVTVF9OT1RJRklDQVRJT05gXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXMtbm90aWZpY2F0aW9uY29uZmlndXJhdGlvbnMuaHRtbCNjZm4tYXMtZ3JvdXAtbm90aWZpY2F0aW9uY29uZmlndXJhdGlvbnMtbm90aWZpY2F0aW9udHlwZXNcbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IG5vdGlmaWNhdGlvblR5cGVzPzogc3RyaW5nW107XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBUaGUgQW1hem9uIFJlc291cmNlIE5hbWUgKEFSTikgb2YgdGhlIEFtYXpvbiBTTlMgdG9waWMuXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXMtbm90aWZpY2F0aW9uY29uZmlndXJhdGlvbnMuaHRtbCNjZm4tYXV0b3NjYWxpbmctYXV0b3NjYWxpbmdncm91cC1ub3RpZmljYXRpb25jb25maWd1cmF0aW9ucy10b3BpY2FyblxuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgdG9waWNBcm46IHN0cmluZztcbiAgICB9XG59XG5cbi8qKlxuICogRGV0ZXJtaW5lIHdoZXRoZXIgdGhlIGdpdmVuIHByb3BlcnRpZXMgbWF0Y2ggdGhvc2Ugb2YgYSBgTm90aWZpY2F0aW9uQ29uZmlndXJhdGlvblByb3BlcnR5YFxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBOb3RpZmljYXRpb25Db25maWd1cmF0aW9uUHJvcGVydHlgXG4gKlxuICogQHJldHVybnMgdGhlIHJlc3VsdCBvZiB0aGUgdmFsaWRhdGlvbi5cbiAqL1xuZnVuY3Rpb24gQ2ZuQXV0b1NjYWxpbmdHcm91cF9Ob3RpZmljYXRpb25Db25maWd1cmF0aW9uUHJvcGVydHlWYWxpZGF0b3IocHJvcGVydGllczogYW55KTogY2RrLlZhbGlkYXRpb25SZXN1bHQge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIGNkay5WQUxJREFUSU9OX1NVQ0NFU1M7IH1cbiAgICBjb25zdCBlcnJvcnMgPSBuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHRzKCk7XG4gICAgaWYgKHR5cGVvZiBwcm9wZXJ0aWVzICE9PSAnb2JqZWN0Jykge1xuICAgICAgICBlcnJvcnMuY29sbGVjdChuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHQoJ0V4cGVjdGVkIGFuIG9iamVjdCwgYnV0IHJlY2VpdmVkOiAnICsgSlNPTi5zdHJpbmdpZnkocHJvcGVydGllcykpKTtcbiAgICB9XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdub3RpZmljYXRpb25UeXBlcycsIGNkay5saXN0VmFsaWRhdG9yKGNkay52YWxpZGF0ZVN0cmluZykpKHByb3BlcnRpZXMubm90aWZpY2F0aW9uVHlwZXMpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3RvcGljQXJuJywgY2RrLnJlcXVpcmVkVmFsaWRhdG9yKShwcm9wZXJ0aWVzLnRvcGljQXJuKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCd0b3BpY0FybicsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy50b3BpY0FybikpO1xuICAgIHJldHVybiBlcnJvcnMud3JhcCgnc3VwcGxpZWQgcHJvcGVydGllcyBub3QgY29ycmVjdCBmb3IgXCJOb3RpZmljYXRpb25Db25maWd1cmF0aW9uUHJvcGVydHlcIicpO1xufVxuXG4vKipcbiAqIFJlbmRlcnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OkF1dG9TY2FsaW5nOjpBdXRvU2NhbGluZ0dyb3VwLk5vdGlmaWNhdGlvbkNvbmZpZ3VyYXRpb25gIHJlc291cmNlXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYE5vdGlmaWNhdGlvbkNvbmZpZ3VyYXRpb25Qcm9wZXJ0eWBcbiAqXG4gKiBAcmV0dXJucyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6QXV0b1NjYWxpbmc6OkF1dG9TY2FsaW5nR3JvdXAuTm90aWZpY2F0aW9uQ29uZmlndXJhdGlvbmAgcmVzb3VyY2UuXG4gKi9cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBjZm5BdXRvU2NhbGluZ0dyb3VwTm90aWZpY2F0aW9uQ29uZmlndXJhdGlvblByb3BlcnR5VG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBhbnkge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIHByb3BlcnRpZXM7IH1cbiAgICBDZm5BdXRvU2NhbGluZ0dyb3VwX05vdGlmaWNhdGlvbkNvbmZpZ3VyYXRpb25Qcm9wZXJ0eVZhbGlkYXRvcihwcm9wZXJ0aWVzKS5hc3NlcnRTdWNjZXNzKCk7XG4gICAgcmV0dXJuIHtcbiAgICAgICAgTm90aWZpY2F0aW9uVHlwZXM6IGNkay5saXN0TWFwcGVyKGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKShwcm9wZXJ0aWVzLm5vdGlmaWNhdGlvblR5cGVzKSxcbiAgICAgICAgVG9waWNBUk46IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMudG9waWNBcm4pLFxuICAgIH07XG59XG5cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBDZm5BdXRvU2NhbGluZ0dyb3VwTm90aWZpY2F0aW9uQ29uZmlndXJhdGlvblByb3BlcnR5RnJvbUNsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQ8Q2ZuQXV0b1NjYWxpbmdHcm91cC5Ob3RpZmljYXRpb25Db25maWd1cmF0aW9uUHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGU+IHtcbiAgICBpZiAoY2RrLmlzUmVzb2x2YWJsZU9iamVjdChwcm9wZXJ0aWVzKSkge1xuICAgICAgICByZXR1cm4gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQocHJvcGVydGllcyk7XG4gICAgfVxuICAgIHByb3BlcnRpZXMgPSBwcm9wZXJ0aWVzID09IG51bGwgPyB7fSA6IHByb3BlcnRpZXM7XG4gICAgaWYgKHR5cGVvZiBwcm9wZXJ0aWVzICE9PSAnb2JqZWN0Jykge1xuICAgICAgICByZXR1cm4gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQocHJvcGVydGllcyk7XG4gICAgfVxuICAgIGNvbnN0IHJldCA9IG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUHJvcGVydHlPYmplY3Q8Q2ZuQXV0b1NjYWxpbmdHcm91cC5Ob3RpZmljYXRpb25Db25maWd1cmF0aW9uUHJvcGVydHk+KCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdub3RpZmljYXRpb25UeXBlcycsICdOb3RpZmljYXRpb25UeXBlcycsIHByb3BlcnRpZXMuTm90aWZpY2F0aW9uVHlwZXMgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nQXJyYXkocHJvcGVydGllcy5Ob3RpZmljYXRpb25UeXBlcykgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgndG9waWNBcm4nLCAnVG9waWNBUk4nLCBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLlRvcGljQVJOKSk7XG4gICAgcmV0LmFkZFVucmVjb2duaXplZFByb3BlcnRpZXNBc0V4dHJhKHByb3BlcnRpZXMpO1xuICAgIHJldHVybiByZXQ7XG59XG5cbmV4cG9ydCBuYW1lc3BhY2UgQ2ZuQXV0b1NjYWxpbmdHcm91cCB7XG4gICAgLyoqXG4gICAgICogQSBzdHJ1Y3R1cmUgdGhhdCBzcGVjaWZpZXMgYSB0YWcgZm9yIHRoZSBgVGFnc2AgcHJvcGVydHkgb2YgW0FXUzo6QXV0b1NjYWxpbmc6OkF1dG9TY2FsaW5nR3JvdXBdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWFzLWdyb3VwLmh0bWwpIHJlc291cmNlLlxuICAgICAqXG4gICAgICogRm9yIG1vcmUgaW5mb3JtYXRpb24sIHNlZSBbVGFnIEF1dG8gU2NhbGluZyBncm91cHMgYW5kIGluc3RhbmNlc10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2F1dG9zY2FsaW5nL2VjMi91c2VyZ3VpZGUvYXV0b3NjYWxpbmctdGFnZ2luZy5odG1sKSBpbiB0aGUgKkFtYXpvbiBFQzIgQXV0byBTY2FsaW5nIFVzZXIgR3VpZGUqIC4gWW91IGNhbiBmaW5kIGEgc2FtcGxlIHRlbXBsYXRlIHNuaXBwZXQgaW4gdGhlIFtFeGFtcGxlc10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXMtZ3JvdXAuaHRtbCNhd3MtcHJvcGVydGllcy1hcy1ncm91cC0tZXhhbXBsZXMpIHNlY3Rpb24gb2YgdGhlIGBBV1M6OkF1dG9TY2FsaW5nOjpBdXRvU2NhbGluZ0dyb3VwYCByZXNvdXJjZS5cbiAgICAgKlxuICAgICAqIENsb3VkRm9ybWF0aW9uIGFkZHMgdGhlIGZvbGxvd2luZyB0YWdzIHRvIGFsbCBBdXRvIFNjYWxpbmcgZ3JvdXBzIGFuZCBhc3NvY2lhdGVkIGluc3RhbmNlczpcbiAgICAgKlxuICAgICAqIC0gYXdzOmNsb3VkZm9ybWF0aW9uOnN0YWNrLW5hbWVcbiAgICAgKiAtIGF3czpjbG91ZGZvcm1hdGlvbjpzdGFjay1pZFxuICAgICAqIC0gYXdzOmNsb3VkZm9ybWF0aW9uOmxvZ2ljYWwtaWRcbiAgICAgKlxuICAgICAqIEBzdHJ1Y3RcbiAgICAgKiBAc3RhYmlsaXR5IGV4dGVybmFsXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWFzLXRhZ3MuaHRtbFxuICAgICAqL1xuICAgIGV4cG9ydCBpbnRlcmZhY2UgVGFnUHJvcGVydHlQcm9wZXJ0eSB7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBUaGUgdGFnIGtleS5cbiAgICAgICAgICpcbiAgICAgICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hcy10YWdzLmh0bWwjY2ZuLWFzLXRhZ3MtS2V5XG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBrZXk6IHN0cmluZztcbiAgICAgICAgLyoqXG4gICAgICAgICAqIFNldCB0byBgdHJ1ZWAgaWYgeW91IHdhbnQgQ2xvdWRGb3JtYXRpb24gdG8gY29weSB0aGUgdGFnIHRvIEVDMiBpbnN0YW5jZXMgdGhhdCBhcmUgbGF1bmNoZWQgYXMgcGFydCBvZiB0aGUgQXV0byBTY2FsaW5nIGdyb3VwLiBTZXQgdG8gYGZhbHNlYCBpZiB5b3Ugd2FudCB0aGUgdGFnIGF0dGFjaGVkIG9ubHkgdG8gdGhlIEF1dG8gU2NhbGluZyBncm91cCBhbmQgbm90IGNvcGllZCB0byBhbnkgaW5zdGFuY2VzIGxhdW5jaGVkIGFzIHBhcnQgb2YgdGhlIEF1dG8gU2NhbGluZyBncm91cC5cbiAgICAgICAgICpcbiAgICAgICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hcy10YWdzLmh0bWwjY2ZuLWFzLXRhZ3MtUHJvcGFnYXRlQXRMYXVuY2hcbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IHByb3BhZ2F0ZUF0TGF1bmNoOiBib29sZWFuIHwgY2RrLklSZXNvbHZhYmxlO1xuICAgICAgICAvKipcbiAgICAgICAgICogVGhlIHRhZyB2YWx1ZS5cbiAgICAgICAgICpcbiAgICAgICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hcy10YWdzLmh0bWwjY2ZuLWFzLXRhZ3MtVmFsdWVcbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IHZhbHVlOiBzdHJpbmc7XG4gICAgfVxufVxuXG4vKipcbiAqIERldGVybWluZSB3aGV0aGVyIHRoZSBnaXZlbiBwcm9wZXJ0aWVzIG1hdGNoIHRob3NlIG9mIGEgYFRhZ1Byb3BlcnR5UHJvcGVydHlgXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYFRhZ1Byb3BlcnR5UHJvcGVydHlgXG4gKlxuICogQHJldHVybnMgdGhlIHJlc3VsdCBvZiB0aGUgdmFsaWRhdGlvbi5cbiAqL1xuZnVuY3Rpb24gQ2ZuQXV0b1NjYWxpbmdHcm91cF9UYWdQcm9wZXJ0eVByb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXM6IGFueSk6IGNkay5WYWxpZGF0aW9uUmVzdWx0IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBjZGsuVkFMSURBVElPTl9TVUNDRVNTOyB9XG4gICAgY29uc3QgZXJyb3JzID0gbmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0cygpO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgZXJyb3JzLmNvbGxlY3QobmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0KCdFeHBlY3RlZCBhbiBvYmplY3QsIGJ1dCByZWNlaXZlZDogJyArIEpTT04uc3RyaW5naWZ5KHByb3BlcnRpZXMpKSk7XG4gICAgfVxuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigna2V5JywgY2RrLnJlcXVpcmVkVmFsaWRhdG9yKShwcm9wZXJ0aWVzLmtleSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigna2V5JywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmtleSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigncHJvcGFnYXRlQXRMYXVuY2gnLCBjZGsucmVxdWlyZWRWYWxpZGF0b3IpKHByb3BlcnRpZXMucHJvcGFnYXRlQXRMYXVuY2gpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3Byb3BhZ2F0ZUF0TGF1bmNoJywgY2RrLnZhbGlkYXRlQm9vbGVhbikocHJvcGVydGllcy5wcm9wYWdhdGVBdExhdW5jaCkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigndmFsdWUnLCBjZGsucmVxdWlyZWRWYWxpZGF0b3IpKHByb3BlcnRpZXMudmFsdWUpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3ZhbHVlJywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLnZhbHVlKSk7XG4gICAgcmV0dXJuIGVycm9ycy53cmFwKCdzdXBwbGllZCBwcm9wZXJ0aWVzIG5vdCBjb3JyZWN0IGZvciBcIlRhZ1Byb3BlcnR5UHJvcGVydHlcIicpO1xufVxuXG4vKipcbiAqIFJlbmRlcnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OkF1dG9TY2FsaW5nOjpBdXRvU2NhbGluZ0dyb3VwLlRhZ1Byb3BlcnR5YCByZXNvdXJjZVxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBUYWdQcm9wZXJ0eVByb3BlcnR5YFxuICpcbiAqIEByZXR1cm5zIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpBdXRvU2NhbGluZzo6QXV0b1NjYWxpbmdHcm91cC5UYWdQcm9wZXJ0eWAgcmVzb3VyY2UuXG4gKi9cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBjZm5BdXRvU2NhbGluZ0dyb3VwVGFnUHJvcGVydHlQcm9wZXJ0eVRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogYW55IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBwcm9wZXJ0aWVzOyB9XG4gICAgQ2ZuQXV0b1NjYWxpbmdHcm91cF9UYWdQcm9wZXJ0eVByb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXMpLmFzc2VydFN1Y2Nlc3MoKTtcbiAgICByZXR1cm4ge1xuICAgICAgICBLZXk6IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMua2V5KSxcbiAgICAgICAgUHJvcGFnYXRlQXRMYXVuY2g6IGNkay5ib29sZWFuVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLnByb3BhZ2F0ZUF0TGF1bmNoKSxcbiAgICAgICAgVmFsdWU6IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMudmFsdWUpLFxuICAgIH07XG59XG5cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBDZm5BdXRvU2NhbGluZ0dyb3VwVGFnUHJvcGVydHlQcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0PENmbkF1dG9TY2FsaW5nR3JvdXAuVGFnUHJvcGVydHlQcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZT4ge1xuICAgIGlmIChjZGsuaXNSZXNvbHZhYmxlT2JqZWN0KHByb3BlcnRpZXMpKSB7XG4gICAgICAgIHJldHVybiBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdChwcm9wZXJ0aWVzKTtcbiAgICB9XG4gICAgcHJvcGVydGllcyA9IHByb3BlcnRpZXMgPT0gbnVsbCA/IHt9IDogcHJvcGVydGllcztcbiAgICBpZiAodHlwZW9mIHByb3BlcnRpZXMgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIHJldHVybiBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdChwcm9wZXJ0aWVzKTtcbiAgICB9XG4gICAgY29uc3QgcmV0ID0gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25Qcm9wZXJ0eU9iamVjdDxDZm5BdXRvU2NhbGluZ0dyb3VwLlRhZ1Byb3BlcnR5UHJvcGVydHk+KCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdrZXknLCAnS2V5JywgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5LZXkpKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ3Byb3BhZ2F0ZUF0TGF1bmNoJywgJ1Byb3BhZ2F0ZUF0TGF1bmNoJywgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRCb29sZWFuKHByb3BlcnRpZXMuUHJvcGFnYXRlQXRMYXVuY2gpKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ3ZhbHVlJywgJ1ZhbHVlJywgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5WYWx1ZSkpO1xuICAgIHJldC5hZGRVbnJlY29nbml6ZWRQcm9wZXJ0aWVzQXNFeHRyYShwcm9wZXJ0aWVzKTtcbiAgICByZXR1cm4gcmV0O1xufVxuXG5leHBvcnQgbmFtZXNwYWNlIENmbkF1dG9TY2FsaW5nR3JvdXAge1xuICAgIC8qKlxuICAgICAqIGBUb3RhbExvY2FsU3RvcmFnZUdCUmVxdWVzdGAgaXMgYSBwcm9wZXJ0eSBvZiB0aGUgYEluc3RhbmNlUmVxdWlyZW1lbnRzYCBwcm9wZXJ0eSBvZiB0aGUgW0FXUzo6QXV0b1NjYWxpbmc6OkF1dG9TY2FsaW5nR3JvdXAgTGF1bmNoVGVtcGxhdGVPdmVycmlkZXNdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWF1dG9zY2FsaW5nLWF1dG9zY2FsaW5nZ3JvdXAtbGF1bmNodGVtcGxhdGVvdmVycmlkZXMuaHRtbCkgcHJvcGVydHkgdHlwZSB0aGF0IGRlc2NyaWJlcyB0aGUgbWluaW11bSBhbmQgbWF4aW11bSB0b3RhbCBsb2NhbCBzdG9yYWdlIHNpemUgZm9yIGFuIGluc3RhbmNlIHR5cGUsIGluIEdCLlxuICAgICAqXG4gICAgICogQHN0cnVjdFxuICAgICAqIEBzdGFiaWxpdHkgZXh0ZXJuYWxcbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXV0b3NjYWxpbmctYXV0b3NjYWxpbmdncm91cC10b3RhbGxvY2Fsc3RvcmFnZWdicmVxdWVzdC5odG1sXG4gICAgICovXG4gICAgZXhwb3J0IGludGVyZmFjZSBUb3RhbExvY2FsU3RvcmFnZUdCUmVxdWVzdFByb3BlcnR5IHtcbiAgICAgICAgLyoqXG4gICAgICAgICAqIFRoZSBzdG9yYWdlIG1heGltdW0gaW4gR0IuXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXV0b3NjYWxpbmctYXV0b3NjYWxpbmdncm91cC10b3RhbGxvY2Fsc3RvcmFnZWdicmVxdWVzdC5odG1sI2Nmbi1hdXRvc2NhbGluZy1hdXRvc2NhbGluZ2dyb3VwLXRvdGFsbG9jYWxzdG9yYWdlZ2JyZXF1ZXN0LW1heFxuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgbWF4PzogbnVtYmVyO1xuICAgICAgICAvKipcbiAgICAgICAgICogVGhlIHN0b3JhZ2UgbWluaW11bSBpbiBHQi5cbiAgICAgICAgICpcbiAgICAgICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hdXRvc2NhbGluZy1hdXRvc2NhbGluZ2dyb3VwLXRvdGFsbG9jYWxzdG9yYWdlZ2JyZXF1ZXN0Lmh0bWwjY2ZuLWF1dG9zY2FsaW5nLWF1dG9zY2FsaW5nZ3JvdXAtdG90YWxsb2NhbHN0b3JhZ2VnYnJlcXVlc3QtbWluXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBtaW4/OiBudW1iZXI7XG4gICAgfVxufVxuXG4vKipcbiAqIERldGVybWluZSB3aGV0aGVyIHRoZSBnaXZlbiBwcm9wZXJ0aWVzIG1hdGNoIHRob3NlIG9mIGEgYFRvdGFsTG9jYWxTdG9yYWdlR0JSZXF1ZXN0UHJvcGVydHlgXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYFRvdGFsTG9jYWxTdG9yYWdlR0JSZXF1ZXN0UHJvcGVydHlgXG4gKlxuICogQHJldHVybnMgdGhlIHJlc3VsdCBvZiB0aGUgdmFsaWRhdGlvbi5cbiAqL1xuZnVuY3Rpb24gQ2ZuQXV0b1NjYWxpbmdHcm91cF9Ub3RhbExvY2FsU3RvcmFnZUdCUmVxdWVzdFByb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXM6IGFueSk6IGNkay5WYWxpZGF0aW9uUmVzdWx0IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBjZGsuVkFMSURBVElPTl9TVUNDRVNTOyB9XG4gICAgY29uc3QgZXJyb3JzID0gbmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0cygpO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgZXJyb3JzLmNvbGxlY3QobmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0KCdFeHBlY3RlZCBhbiBvYmplY3QsIGJ1dCByZWNlaXZlZDogJyArIEpTT04uc3RyaW5naWZ5KHByb3BlcnRpZXMpKSk7XG4gICAgfVxuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignbWF4JywgY2RrLnZhbGlkYXRlTnVtYmVyKShwcm9wZXJ0aWVzLm1heCkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignbWluJywgY2RrLnZhbGlkYXRlTnVtYmVyKShwcm9wZXJ0aWVzLm1pbikpO1xuICAgIHJldHVybiBlcnJvcnMud3JhcCgnc3VwcGxpZWQgcHJvcGVydGllcyBub3QgY29ycmVjdCBmb3IgXCJUb3RhbExvY2FsU3RvcmFnZUdCUmVxdWVzdFByb3BlcnR5XCInKTtcbn1cblxuLyoqXG4gKiBSZW5kZXJzIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpBdXRvU2NhbGluZzo6QXV0b1NjYWxpbmdHcm91cC5Ub3RhbExvY2FsU3RvcmFnZUdCUmVxdWVzdGAgcmVzb3VyY2VcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgVG90YWxMb2NhbFN0b3JhZ2VHQlJlcXVlc3RQcm9wZXJ0eWBcbiAqXG4gKiBAcmV0dXJucyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6QXV0b1NjYWxpbmc6OkF1dG9TY2FsaW5nR3JvdXAuVG90YWxMb2NhbFN0b3JhZ2VHQlJlcXVlc3RgIHJlc291cmNlLlxuICovXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gY2ZuQXV0b1NjYWxpbmdHcm91cFRvdGFsTG9jYWxTdG9yYWdlR0JSZXF1ZXN0UHJvcGVydHlUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGFueSB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gcHJvcGVydGllczsgfVxuICAgIENmbkF1dG9TY2FsaW5nR3JvdXBfVG90YWxMb2NhbFN0b3JhZ2VHQlJlcXVlc3RQcm9wZXJ0eVZhbGlkYXRvcihwcm9wZXJ0aWVzKS5hc3NlcnRTdWNjZXNzKCk7XG4gICAgcmV0dXJuIHtcbiAgICAgICAgTWF4OiBjZGsubnVtYmVyVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLm1heCksXG4gICAgICAgIE1pbjogY2RrLm51bWJlclRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5taW4pLFxuICAgIH07XG59XG5cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBDZm5BdXRvU2NhbGluZ0dyb3VwVG90YWxMb2NhbFN0b3JhZ2VHQlJlcXVlc3RQcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0PENmbkF1dG9TY2FsaW5nR3JvdXAuVG90YWxMb2NhbFN0b3JhZ2VHQlJlcXVlc3RQcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZT4ge1xuICAgIGlmIChjZGsuaXNSZXNvbHZhYmxlT2JqZWN0KHByb3BlcnRpZXMpKSB7XG4gICAgICAgIHJldHVybiBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdChwcm9wZXJ0aWVzKTtcbiAgICB9XG4gICAgcHJvcGVydGllcyA9IHByb3BlcnRpZXMgPT0gbnVsbCA/IHt9IDogcHJvcGVydGllcztcbiAgICBpZiAodHlwZW9mIHByb3BlcnRpZXMgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIHJldHVybiBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdChwcm9wZXJ0aWVzKTtcbiAgICB9XG4gICAgY29uc3QgcmV0ID0gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25Qcm9wZXJ0eU9iamVjdDxDZm5BdXRvU2NhbGluZ0dyb3VwLlRvdGFsTG9jYWxTdG9yYWdlR0JSZXF1ZXN0UHJvcGVydHk+KCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdtYXgnLCAnTWF4JywgcHJvcGVydGllcy5NYXggIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0TnVtYmVyKHByb3BlcnRpZXMuTWF4KSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdtaW4nLCAnTWluJywgcHJvcGVydGllcy5NaW4gIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0TnVtYmVyKHByb3BlcnRpZXMuTWluKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFVucmVjb2duaXplZFByb3BlcnRpZXNBc0V4dHJhKHByb3BlcnRpZXMpO1xuICAgIHJldHVybiByZXQ7XG59XG5cbmV4cG9ydCBuYW1lc3BhY2UgQ2ZuQXV0b1NjYWxpbmdHcm91cCB7XG4gICAgLyoqXG4gICAgICogYFZDcHVDb3VudFJlcXVlc3RgIGlzIGEgcHJvcGVydHkgb2YgdGhlIGBJbnN0YW5jZVJlcXVpcmVtZW50c2AgcHJvcGVydHkgb2YgdGhlIFtBV1M6OkF1dG9TY2FsaW5nOjpBdXRvU2NhbGluZ0dyb3VwIExhdW5jaFRlbXBsYXRlT3ZlcnJpZGVzXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hdXRvc2NhbGluZy1hdXRvc2NhbGluZ2dyb3VwLWxhdW5jaHRlbXBsYXRlb3ZlcnJpZGVzLmh0bWwpIHByb3BlcnR5IHR5cGUgdGhhdCBkZXNjcmliZXMgdGhlIG1pbmltdW0gYW5kIG1heGltdW0gbnVtYmVyIG9mIHZDUFVzIGZvciBhbiBpbnN0YW5jZSB0eXBlLlxuICAgICAqXG4gICAgICogQHN0cnVjdFxuICAgICAqIEBzdGFiaWxpdHkgZXh0ZXJuYWxcbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXV0b3NjYWxpbmctYXV0b3NjYWxpbmdncm91cC12Y3B1Y291bnRyZXF1ZXN0Lmh0bWxcbiAgICAgKi9cbiAgICBleHBvcnQgaW50ZXJmYWNlIFZDcHVDb3VudFJlcXVlc3RQcm9wZXJ0eSB7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBUaGUgbWF4aW11bSBudW1iZXIgb2YgdkNQVXMuXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXV0b3NjYWxpbmctYXV0b3NjYWxpbmdncm91cC12Y3B1Y291bnRyZXF1ZXN0Lmh0bWwjY2ZuLWF1dG9zY2FsaW5nLWF1dG9zY2FsaW5nZ3JvdXAtdmNwdWNvdW50cmVxdWVzdC1tYXhcbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IG1heD86IG51bWJlcjtcbiAgICAgICAgLyoqXG4gICAgICAgICAqIFRoZSBtaW5pbXVtIG51bWJlciBvZiB2Q1BVcy5cbiAgICAgICAgICpcbiAgICAgICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hdXRvc2NhbGluZy1hdXRvc2NhbGluZ2dyb3VwLXZjcHVjb3VudHJlcXVlc3QuaHRtbCNjZm4tYXV0b3NjYWxpbmctYXV0b3NjYWxpbmdncm91cC12Y3B1Y291bnRyZXF1ZXN0LW1pblxuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgbWluPzogbnVtYmVyO1xuICAgIH1cbn1cblxuLyoqXG4gKiBEZXRlcm1pbmUgd2hldGhlciB0aGUgZ2l2ZW4gcHJvcGVydGllcyBtYXRjaCB0aG9zZSBvZiBhIGBWQ3B1Q291bnRSZXF1ZXN0UHJvcGVydHlgXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYFZDcHVDb3VudFJlcXVlc3RQcm9wZXJ0eWBcbiAqXG4gKiBAcmV0dXJucyB0aGUgcmVzdWx0IG9mIHRoZSB2YWxpZGF0aW9uLlxuICovXG5mdW5jdGlvbiBDZm5BdXRvU2NhbGluZ0dyb3VwX1ZDcHVDb3VudFJlcXVlc3RQcm9wZXJ0eVZhbGlkYXRvcihwcm9wZXJ0aWVzOiBhbnkpOiBjZGsuVmFsaWRhdGlvblJlc3VsdCB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gY2RrLlZBTElEQVRJT05fU1VDQ0VTUzsgfVxuICAgIGNvbnN0IGVycm9ycyA9IG5ldyBjZGsuVmFsaWRhdGlvblJlc3VsdHMoKTtcbiAgICBpZiAodHlwZW9mIHByb3BlcnRpZXMgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIGVycm9ycy5jb2xsZWN0KG5ldyBjZGsuVmFsaWRhdGlvblJlc3VsdCgnRXhwZWN0ZWQgYW4gb2JqZWN0LCBidXQgcmVjZWl2ZWQ6ICcgKyBKU09OLnN0cmluZ2lmeShwcm9wZXJ0aWVzKSkpO1xuICAgIH1cbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ21heCcsIGNkay52YWxpZGF0ZU51bWJlcikocHJvcGVydGllcy5tYXgpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ21pbicsIGNkay52YWxpZGF0ZU51bWJlcikocHJvcGVydGllcy5taW4pKTtcbiAgICByZXR1cm4gZXJyb3JzLndyYXAoJ3N1cHBsaWVkIHByb3BlcnRpZXMgbm90IGNvcnJlY3QgZm9yIFwiVkNwdUNvdW50UmVxdWVzdFByb3BlcnR5XCInKTtcbn1cblxuLyoqXG4gKiBSZW5kZXJzIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpBdXRvU2NhbGluZzo6QXV0b1NjYWxpbmdHcm91cC5WQ3B1Q291bnRSZXF1ZXN0YCByZXNvdXJjZVxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBWQ3B1Q291bnRSZXF1ZXN0UHJvcGVydHlgXG4gKlxuICogQHJldHVybnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OkF1dG9TY2FsaW5nOjpBdXRvU2NhbGluZ0dyb3VwLlZDcHVDb3VudFJlcXVlc3RgIHJlc291cmNlLlxuICovXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gY2ZuQXV0b1NjYWxpbmdHcm91cFZDcHVDb3VudFJlcXVlc3RQcm9wZXJ0eVRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogYW55IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBwcm9wZXJ0aWVzOyB9XG4gICAgQ2ZuQXV0b1NjYWxpbmdHcm91cF9WQ3B1Q291bnRSZXF1ZXN0UHJvcGVydHlWYWxpZGF0b3IocHJvcGVydGllcykuYXNzZXJ0U3VjY2VzcygpO1xuICAgIHJldHVybiB7XG4gICAgICAgIE1heDogY2RrLm51bWJlclRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5tYXgpLFxuICAgICAgICBNaW46IGNkay5udW1iZXJUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMubWluKSxcbiAgICB9O1xufVxuXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gQ2ZuQXV0b1NjYWxpbmdHcm91cFZDcHVDb3VudFJlcXVlc3RQcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0PENmbkF1dG9TY2FsaW5nR3JvdXAuVkNwdUNvdW50UmVxdWVzdFByb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlPiB7XG4gICAgaWYgKGNkay5pc1Jlc29sdmFibGVPYmplY3QocHJvcGVydGllcykpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0KHByb3BlcnRpZXMpO1xuICAgIH1cbiAgICBwcm9wZXJ0aWVzID0gcHJvcGVydGllcyA9PSBudWxsID8ge30gOiBwcm9wZXJ0aWVzO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0KHByb3BlcnRpZXMpO1xuICAgIH1cbiAgICBjb25zdCByZXQgPSBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblByb3BlcnR5T2JqZWN0PENmbkF1dG9TY2FsaW5nR3JvdXAuVkNwdUNvdW50UmVxdWVzdFByb3BlcnR5PigpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnbWF4JywgJ01heCcsIHByb3BlcnRpZXMuTWF4ICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldE51bWJlcihwcm9wZXJ0aWVzLk1heCkgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnbWluJywgJ01pbicsIHByb3BlcnRpZXMuTWluICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldE51bWJlcihwcm9wZXJ0aWVzLk1pbikgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRVbnJlY29nbml6ZWRQcm9wZXJ0aWVzQXNFeHRyYShwcm9wZXJ0aWVzKTtcbiAgICByZXR1cm4gcmV0O1xufVxuXG4vKipcbiAqIFByb3BlcnRpZXMgZm9yIGRlZmluaW5nIGEgYENmbkxhdW5jaENvbmZpZ3VyYXRpb25gXG4gKlxuICogQHN0cnVjdFxuICogQHN0YWJpbGl0eSBleHRlcm5hbFxuICpcbiAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWF1dG9zY2FsaW5nLWxhdW5jaGNvbmZpZ3VyYXRpb24uaHRtbFxuICovXG5leHBvcnQgaW50ZXJmYWNlIENmbkxhdW5jaENvbmZpZ3VyYXRpb25Qcm9wcyB7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgSUQgb2YgdGhlIEFtYXpvbiBNYWNoaW5lIEltYWdlIChBTUkpIHRoYXQgd2FzIGFzc2lnbmVkIGR1cmluZyByZWdpc3RyYXRpb24uIEZvciBtb3JlIGluZm9ybWF0aW9uLCBzZWUgW0ZpbmRpbmcgYSBMaW51eCBBTUldKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NFQzIvbGF0ZXN0L1VzZXJHdWlkZS9maW5kaW5nLWFuLWFtaS5odG1sKSBpbiB0aGUgKkFtYXpvbiBFQzIgVXNlciBHdWlkZSBmb3IgTGludXggSW5zdGFuY2VzKiAuXG4gICAgICpcbiAgICAgKiBJZiB5b3Ugc3BlY2lmeSBgSW5zdGFuY2VJZGAgLCBhbiBgSW1hZ2VJZGAgaXMgbm90IHJlcXVpcmVkLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtYXV0b3NjYWxpbmctbGF1bmNoY29uZmlndXJhdGlvbi5odG1sI2Nmbi1hdXRvc2NhbGluZy1sYXVuY2hjb25maWd1cmF0aW9uLWltYWdlaWRcbiAgICAgKi9cbiAgICByZWFkb25seSBpbWFnZUlkOiBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBTcGVjaWZpZXMgdGhlIGluc3RhbmNlIHR5cGUgb2YgdGhlIEVDMiBpbnN0YW5jZS4gRm9yIGluZm9ybWF0aW9uIGFib3V0IGF2YWlsYWJsZSBpbnN0YW5jZSB0eXBlcywgc2VlIFtBdmFpbGFibGUgaW5zdGFuY2UgdHlwZXNdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NFQzIvbGF0ZXN0L1VzZXJHdWlkZS9pbnN0YW5jZS10eXBlcy5odG1sI0F2YWlsYWJsZUluc3RhbmNlVHlwZXMpIGluIHRoZSAqQW1hem9uIEVDMiBVc2VyIEd1aWRlIGZvciBMaW51eCBJbnN0YW5jZXMqIC5cbiAgICAgKlxuICAgICAqIElmIHlvdSBzcGVjaWZ5IGBJbnN0YW5jZUlkYCAsIGFuIGBJbnN0YW5jZVR5cGVgIGlzIG5vdCByZXF1aXJlZC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWF1dG9zY2FsaW5nLWxhdW5jaGNvbmZpZ3VyYXRpb24uaHRtbCNjZm4tYXV0b3NjYWxpbmctbGF1bmNoY29uZmlndXJhdGlvbi1pbnN0YW5jZXR5cGVcbiAgICAgKi9cbiAgICByZWFkb25seSBpbnN0YW5jZVR5cGU6IHN0cmluZztcblxuICAgIC8qKlxuICAgICAqIFNwZWNpZmllcyB3aGV0aGVyIHRvIGFzc2lnbiBhIHB1YmxpYyBJUHY0IGFkZHJlc3MgdG8gdGhlIGdyb3VwJ3MgaW5zdGFuY2VzLiBJZiB0aGUgaW5zdGFuY2UgaXMgbGF1bmNoZWQgaW50byBhIGRlZmF1bHQgc3VibmV0LCB0aGUgZGVmYXVsdCBpcyB0byBhc3NpZ24gYSBwdWJsaWMgSVB2NCBhZGRyZXNzLCB1bmxlc3MgeW91IGRpc2FibGVkIHRoZSBvcHRpb24gdG8gYXNzaWduIGEgcHVibGljIElQdjQgYWRkcmVzcyBvbiB0aGUgc3VibmV0LiBJZiB0aGUgaW5zdGFuY2UgaXMgbGF1bmNoZWQgaW50byBhIG5vbmRlZmF1bHQgc3VibmV0LCB0aGUgZGVmYXVsdCBpcyBub3QgdG8gYXNzaWduIGEgcHVibGljIElQdjQgYWRkcmVzcywgdW5sZXNzIHlvdSBlbmFibGVkIHRoZSBvcHRpb24gdG8gYXNzaWduIGEgcHVibGljIElQdjQgYWRkcmVzcyBvbiB0aGUgc3VibmV0LlxuICAgICAqXG4gICAgICogSWYgeW91IHNwZWNpZnkgYHRydWVgICwgZWFjaCBpbnN0YW5jZSBpbiB0aGUgQXV0byBTY2FsaW5nIGdyb3VwIHJlY2VpdmVzIGEgdW5pcXVlIHB1YmxpYyBJUHY0IGFkZHJlc3MuIEZvciBtb3JlIGluZm9ybWF0aW9uLCBzZWUgW0xhdW5jaGluZyBBdXRvIFNjYWxpbmcgaW5zdGFuY2VzIGluIGEgVlBDXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vYXV0b3NjYWxpbmcvZWMyL3VzZXJndWlkZS9hc2ctaW4tdnBjLmh0bWwpIGluIHRoZSAqQW1hem9uIEVDMiBBdXRvIFNjYWxpbmcgVXNlciBHdWlkZSogLlxuICAgICAqXG4gICAgICogSWYgeW91IHNwZWNpZnkgdGhpcyBwcm9wZXJ0eSwgeW91IG11c3Qgc3BlY2lmeSBhdCBsZWFzdCBvbmUgc3VibmV0IGZvciBgVlBDWm9uZUlkZW50aWZpZXJgIHdoZW4geW91IGNyZWF0ZSB5b3VyIGdyb3VwLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtYXV0b3NjYWxpbmctbGF1bmNoY29uZmlndXJhdGlvbi5odG1sI2Nmbi1hdXRvc2NhbGluZy1sYXVuY2hjb25maWd1cmF0aW9uLWFzc29jaWF0ZXB1YmxpY2lwYWRkcmVzc1xuICAgICAqL1xuICAgIHJlYWRvbmx5IGFzc29jaWF0ZVB1YmxpY0lwQWRkcmVzcz86IGJvb2xlYW4gfCBjZGsuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgYmxvY2sgZGV2aWNlIG1hcHBpbmcgZW50cmllcyB0aGF0IGRlZmluZSB0aGUgYmxvY2sgZGV2aWNlcyB0byBhdHRhY2ggdG8gdGhlIGluc3RhbmNlcyBhdCBsYXVuY2guIEJ5IGRlZmF1bHQsIHRoZSBibG9jayBkZXZpY2VzIHNwZWNpZmllZCBpbiB0aGUgYmxvY2sgZGV2aWNlIG1hcHBpbmcgZm9yIHRoZSBBTUkgYXJlIHVzZWQuIEZvciBtb3JlIGluZm9ybWF0aW9uLCBzZWUgW0Jsb2NrIGRldmljZSBtYXBwaW5nc10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0VDMi9sYXRlc3QvVXNlckd1aWRlL2Jsb2NrLWRldmljZS1tYXBwaW5nLWNvbmNlcHRzLmh0bWwpIGluIHRoZSAqQW1hem9uIEVDMiBVc2VyIEd1aWRlIGZvciBMaW51eCBJbnN0YW5jZXMqIC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWF1dG9zY2FsaW5nLWxhdW5jaGNvbmZpZ3VyYXRpb24uaHRtbCNjZm4tYXV0b3NjYWxpbmctbGF1bmNoY29uZmlndXJhdGlvbi1ibG9ja2RldmljZW1hcHBpbmdzXG4gICAgICovXG4gICAgcmVhZG9ubHkgYmxvY2tEZXZpY2VNYXBwaW5ncz86IEFycmF5PENmbkxhdW5jaENvbmZpZ3VyYXRpb24uQmxvY2tEZXZpY2VNYXBwaW5nUHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGU+IHwgY2RrLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQXZhaWxhYmxlIGZvciBiYWNrd2FyZCBjb21wYXRpYmlsaXR5LlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtYXV0b3NjYWxpbmctbGF1bmNoY29uZmlndXJhdGlvbi5odG1sI2Nmbi1hdXRvc2NhbGluZy1sYXVuY2hjb25maWd1cmF0aW9uLWNsYXNzaWNsaW5rdnBjaWRcbiAgICAgKi9cbiAgICByZWFkb25seSBjbGFzc2ljTGlua1ZwY0lkPzogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogQXZhaWxhYmxlIGZvciBiYWNrd2FyZCBjb21wYXRpYmlsaXR5LlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtYXV0b3NjYWxpbmctbGF1bmNoY29uZmlndXJhdGlvbi5odG1sI2Nmbi1hdXRvc2NhbGluZy1sYXVuY2hjb25maWd1cmF0aW9uLWNsYXNzaWNsaW5rdnBjc2VjdXJpdHlncm91cHNcbiAgICAgKi9cbiAgICByZWFkb25seSBjbGFzc2ljTGlua1ZwY1NlY3VyaXR5R3JvdXBzPzogc3RyaW5nW107XG5cbiAgICAvKipcbiAgICAgKiBTcGVjaWZpZXMgd2hldGhlciB0aGUgbGF1bmNoIGNvbmZpZ3VyYXRpb24gaXMgb3B0aW1pemVkIGZvciBFQlMgSS9PICggYHRydWVgICkgb3Igbm90ICggYGZhbHNlYCApLiBUaGUgb3B0aW1pemF0aW9uIHByb3ZpZGVzIGRlZGljYXRlZCB0aHJvdWdocHV0IHRvIEFtYXpvbiBFQlMgYW5kIGFuIG9wdGltaXplZCBjb25maWd1cmF0aW9uIHN0YWNrIHRvIHByb3ZpZGUgb3B0aW1hbCBJL08gcGVyZm9ybWFuY2UuIFRoaXMgb3B0aW1pemF0aW9uIGlzIG5vdCBhdmFpbGFibGUgd2l0aCBhbGwgaW5zdGFuY2UgdHlwZXMuIEFkZGl0aW9uYWwgZmVlcyBhcmUgaW5jdXJyZWQgd2hlbiB5b3UgZW5hYmxlIEVCUyBvcHRpbWl6YXRpb24gZm9yIGFuIGluc3RhbmNlIHR5cGUgdGhhdCBpcyBub3QgRUJTLW9wdGltaXplZCBieSBkZWZhdWx0LiBGb3IgbW9yZSBpbmZvcm1hdGlvbiwgc2VlIFtBbWF6b24gRUJTLW9wdGltaXplZCBpbnN0YW5jZXNdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NFQzIvbGF0ZXN0L1VzZXJHdWlkZS9FQlNPcHRpbWl6ZWQuaHRtbCkgaW4gdGhlICpBbWF6b24gRUMyIFVzZXIgR3VpZGUgZm9yIExpbnV4IEluc3RhbmNlcyogLlxuICAgICAqXG4gICAgICogVGhlIGRlZmF1bHQgdmFsdWUgaXMgYGZhbHNlYCAuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1hdXRvc2NhbGluZy1sYXVuY2hjb25maWd1cmF0aW9uLmh0bWwjY2ZuLWF1dG9zY2FsaW5nLWxhdW5jaGNvbmZpZ3VyYXRpb24tZWJzb3B0aW1pemVkXG4gICAgICovXG4gICAgcmVhZG9ubHkgZWJzT3B0aW1pemVkPzogYm9vbGVhbiB8IGNkay5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFRoZSBuYW1lIG9yIHRoZSBBbWF6b24gUmVzb3VyY2UgTmFtZSAoQVJOKSBvZiB0aGUgaW5zdGFuY2UgcHJvZmlsZSBhc3NvY2lhdGVkIHdpdGggdGhlIElBTSByb2xlIGZvciB0aGUgaW5zdGFuY2UuIFRoZSBpbnN0YW5jZSBwcm9maWxlIGNvbnRhaW5zIHRoZSBJQU0gcm9sZS4gRm9yIG1vcmUgaW5mb3JtYXRpb24sIHNlZSBbSUFNIHJvbGUgZm9yIGFwcGxpY2F0aW9ucyB0aGF0IHJ1biBvbiBBbWF6b24gRUMyIGluc3RhbmNlc10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2F1dG9zY2FsaW5nL2VjMi91c2VyZ3VpZGUvdXMtaWFtLXJvbGUuaHRtbCkgaW4gdGhlICpBbWF6b24gRUMyIEF1dG8gU2NhbGluZyBVc2VyIEd1aWRlKiAuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1hdXRvc2NhbGluZy1sYXVuY2hjb25maWd1cmF0aW9uLmh0bWwjY2ZuLWF1dG9zY2FsaW5nLWxhdW5jaGNvbmZpZ3VyYXRpb24taWFtaW5zdGFuY2Vwcm9maWxlXG4gICAgICovXG4gICAgcmVhZG9ubHkgaWFtSW5zdGFuY2VQcm9maWxlPzogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogVGhlIElEIG9mIHRoZSBBbWF6b24gRUMyIGluc3RhbmNlIHRvIHVzZSB0byBjcmVhdGUgdGhlIGxhdW5jaCBjb25maWd1cmF0aW9uLiBXaGVuIHlvdSB1c2UgYW4gaW5zdGFuY2UgdG8gY3JlYXRlIGEgbGF1bmNoIGNvbmZpZ3VyYXRpb24sIGFsbCBwcm9wZXJ0aWVzIGFyZSBkZXJpdmVkIGZyb20gdGhlIGluc3RhbmNlIHdpdGggdGhlIGV4Y2VwdGlvbiBvZiBgQmxvY2tEZXZpY2VNYXBwaW5nYCBhbmQgYEFzc29jaWF0ZVB1YmxpY0lwQWRkcmVzc2AgLiBZb3UgY2FuIG92ZXJyaWRlIGFueSBwcm9wZXJ0aWVzIGZyb20gdGhlIGluc3RhbmNlIGJ5IHNwZWNpZnlpbmcgdGhlbSBpbiB0aGUgbGF1bmNoIGNvbmZpZ3VyYXRpb24uXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1hdXRvc2NhbGluZy1sYXVuY2hjb25maWd1cmF0aW9uLmh0bWwjY2ZuLWF1dG9zY2FsaW5nLWxhdW5jaGNvbmZpZ3VyYXRpb24taW5zdGFuY2VpZFxuICAgICAqL1xuICAgIHJlYWRvbmx5IGluc3RhbmNlSWQ/OiBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBDb250cm9scyB3aGV0aGVyIGluc3RhbmNlcyBpbiB0aGlzIGdyb3VwIGFyZSBsYXVuY2hlZCB3aXRoIGRldGFpbGVkICggYHRydWVgICkgb3IgYmFzaWMgKCBgZmFsc2VgICkgbW9uaXRvcmluZy5cbiAgICAgKlxuICAgICAqIFRoZSBkZWZhdWx0IHZhbHVlIGlzIGB0cnVlYCAoZW5hYmxlZCkuXG4gICAgICpcbiAgICAgKiA+IFdoZW4gZGV0YWlsZWQgbW9uaXRvcmluZyBpcyBlbmFibGVkLCBBbWF6b24gQ2xvdWRXYXRjaCBnZW5lcmF0ZXMgbWV0cmljcyBldmVyeSBtaW51dGUgYW5kIHlvdXIgYWNjb3VudCBpcyBjaGFyZ2VkIGEgZmVlLiBXaGVuIHlvdSBkaXNhYmxlIGRldGFpbGVkIG1vbml0b3JpbmcsIENsb3VkV2F0Y2ggZ2VuZXJhdGVzIG1ldHJpY3MgZXZlcnkgNSBtaW51dGVzLiBGb3IgbW9yZSBpbmZvcm1hdGlvbiwgc2VlIFtDb25maWd1cmUgTW9uaXRvcmluZyBmb3IgQXV0byBTY2FsaW5nIEluc3RhbmNlc10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2F1dG9zY2FsaW5nL2xhdGVzdC91c2VyZ3VpZGUvZW5hYmxlLWFzLWluc3RhbmNlLW1ldHJpY3MuaHRtbCkgaW4gdGhlICpBbWF6b24gRUMyIEF1dG8gU2NhbGluZyBVc2VyIEd1aWRlKiAuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1hdXRvc2NhbGluZy1sYXVuY2hjb25maWd1cmF0aW9uLmh0bWwjY2ZuLWF1dG9zY2FsaW5nLWxhdW5jaGNvbmZpZ3VyYXRpb24taW5zdGFuY2Vtb25pdG9yaW5nXG4gICAgICovXG4gICAgcmVhZG9ubHkgaW5zdGFuY2VNb25pdG9yaW5nPzogYm9vbGVhbiB8IGNkay5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFRoZSBJRCBvZiB0aGUga2VybmVsIGFzc29jaWF0ZWQgd2l0aCB0aGUgQU1JLlxuICAgICAqXG4gICAgICogPiBXZSByZWNvbW1lbmQgdGhhdCB5b3UgdXNlIFBWLUdSVUIgaW5zdGVhZCBvZiBrZXJuZWxzIGFuZCBSQU0gZGlza3MuIEZvciBtb3JlIGluZm9ybWF0aW9uLCBzZWUgW1VzZXIgcHJvdmlkZWQga2VybmVsc10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0VDMi9sYXRlc3QvVXNlckd1aWRlL1VzZXJQcm92aWRlZEtlcm5lbHMuaHRtbCkgaW4gdGhlICpBbWF6b24gRUMyIFVzZXIgR3VpZGUgZm9yIExpbnV4IEluc3RhbmNlcyogLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtYXV0b3NjYWxpbmctbGF1bmNoY29uZmlndXJhdGlvbi5odG1sI2Nmbi1hdXRvc2NhbGluZy1sYXVuY2hjb25maWd1cmF0aW9uLWtlcm5lbGlkXG4gICAgICovXG4gICAgcmVhZG9ubHkga2VybmVsSWQ/OiBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgbmFtZSBvZiB0aGUga2V5IHBhaXIuIEZvciBtb3JlIGluZm9ybWF0aW9uLCBzZWUgW0FtYXpvbiBFQzIga2V5IHBhaXJzIGFuZCBMaW51eCBpbnN0YW5jZXNdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NFQzIvbGF0ZXN0L1VzZXJHdWlkZS9lYzIta2V5LXBhaXJzLmh0bWwpIGluIHRoZSAqQW1hem9uIEVDMiBVc2VyIEd1aWRlIGZvciBMaW51eCBJbnN0YW5jZXMqIC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWF1dG9zY2FsaW5nLWxhdW5jaGNvbmZpZ3VyYXRpb24uaHRtbCNjZm4tYXV0b3NjYWxpbmctbGF1bmNoY29uZmlndXJhdGlvbi1rZXluYW1lXG4gICAgICovXG4gICAgcmVhZG9ubHkga2V5TmFtZT86IHN0cmluZztcblxuICAgIC8qKlxuICAgICAqIFRoZSBuYW1lIG9mIHRoZSBsYXVuY2ggY29uZmlndXJhdGlvbi4gVGhpcyBuYW1lIG11c3QgYmUgdW5pcXVlIHBlciBSZWdpb24gcGVyIGFjY291bnQuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1hdXRvc2NhbGluZy1sYXVuY2hjb25maWd1cmF0aW9uLmh0bWwjY2ZuLWF1dG9zY2FsaW5nLWxhdW5jaGNvbmZpZ3VyYXRpb24tbGF1bmNoY29uZmlndXJhdGlvbm5hbWVcbiAgICAgKi9cbiAgICByZWFkb25seSBsYXVuY2hDb25maWd1cmF0aW9uTmFtZT86IHN0cmluZztcblxuICAgIC8qKlxuICAgICAqIFRoZSBtZXRhZGF0YSBvcHRpb25zIGZvciB0aGUgaW5zdGFuY2VzLiBGb3IgbW9yZSBpbmZvcm1hdGlvbiwgc2VlIFtDb25maWd1cmluZyB0aGUgSW5zdGFuY2UgTWV0YWRhdGEgT3B0aW9uc10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2F1dG9zY2FsaW5nL2VjMi91c2VyZ3VpZGUvY3JlYXRlLWxhdW5jaC1jb25maWcuaHRtbCNsYXVuY2gtY29uZmlndXJhdGlvbnMtaW1kcykgaW4gdGhlICpBbWF6b24gRUMyIEF1dG8gU2NhbGluZyBVc2VyIEd1aWRlKiAuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1hdXRvc2NhbGluZy1sYXVuY2hjb25maWd1cmF0aW9uLmh0bWwjY2ZuLWF1dG9zY2FsaW5nLWxhdW5jaGNvbmZpZ3VyYXRpb24tbWV0YWRhdGFvcHRpb25zXG4gICAgICovXG4gICAgcmVhZG9ubHkgbWV0YWRhdGFPcHRpb25zPzogQ2ZuTGF1bmNoQ29uZmlndXJhdGlvbi5NZXRhZGF0YU9wdGlvbnNQcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFRoZSB0ZW5hbmN5IG9mIHRoZSBpbnN0YW5jZSwgZWl0aGVyIGBkZWZhdWx0YCBvciBgZGVkaWNhdGVkYCAuIEFuIGluc3RhbmNlIHdpdGggYGRlZGljYXRlZGAgdGVuYW5jeSBydW5zIG9uIGlzb2xhdGVkLCBzaW5nbGUtdGVuYW50IGhhcmR3YXJlIGFuZCBjYW4gb25seSBiZSBsYXVuY2hlZCBpbnRvIGEgVlBDLiBUbyBsYXVuY2ggZGVkaWNhdGVkIGluc3RhbmNlcyBpbnRvIGEgc2hhcmVkIHRlbmFuY3kgVlBDIChhIFZQQyB3aXRoIHRoZSBpbnN0YW5jZSBwbGFjZW1lbnQgdGVuYW5jeSBhdHRyaWJ1dGUgc2V0IHRvIGBkZWZhdWx0YCApLCB5b3UgbXVzdCBzZXQgdGhlIHZhbHVlIG9mIHRoaXMgcHJvcGVydHkgdG8gYGRlZGljYXRlZGAgLiBGb3IgbW9yZSBpbmZvcm1hdGlvbiwgc2VlIFtDb25maWd1cmluZyBpbnN0YW5jZSB0ZW5hbmN5IHdpdGggQW1hem9uIEVDMiBBdXRvIFNjYWxpbmddKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9hdXRvc2NhbGluZy9lYzIvdXNlcmd1aWRlL2F1dG8tc2NhbGluZy1kZWRpY2F0ZWQtaW5zdGFuY2VzLmh0bWwpIGluIHRoZSAqQW1hem9uIEVDMiBBdXRvIFNjYWxpbmcgVXNlciBHdWlkZSogLlxuICAgICAqXG4gICAgICogSWYgeW91IHNwZWNpZnkgYFBsYWNlbWVudFRlbmFuY3lgICwgeW91IG11c3Qgc3BlY2lmeSBhdCBsZWFzdCBvbmUgc3VibmV0IGZvciBgVlBDWm9uZUlkZW50aWZpZXJgIHdoZW4geW91IGNyZWF0ZSB5b3VyIGdyb3VwLlxuICAgICAqXG4gICAgICogVmFsaWQgdmFsdWVzOiBgZGVmYXVsdGAgfCBgZGVkaWNhdGVkYFxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtYXV0b3NjYWxpbmctbGF1bmNoY29uZmlndXJhdGlvbi5odG1sI2Nmbi1hdXRvc2NhbGluZy1sYXVuY2hjb25maWd1cmF0aW9uLXBsYWNlbWVudHRlbmFuY3lcbiAgICAgKi9cbiAgICByZWFkb25seSBwbGFjZW1lbnRUZW5hbmN5Pzogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogVGhlIElEIG9mIHRoZSBSQU0gZGlzayB0byBzZWxlY3QuXG4gICAgICpcbiAgICAgKiA+IFdlIHJlY29tbWVuZCB0aGF0IHlvdSB1c2UgUFYtR1JVQiBpbnN0ZWFkIG9mIGtlcm5lbHMgYW5kIFJBTSBkaXNrcy4gRm9yIG1vcmUgaW5mb3JtYXRpb24sIHNlZSBbVXNlciBwcm92aWRlZCBrZXJuZWxzXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTRUMyL2xhdGVzdC9Vc2VyR3VpZGUvVXNlclByb3ZpZGVkS2VybmVscy5odG1sKSBpbiB0aGUgKkFtYXpvbiBFQzIgVXNlciBHdWlkZSBmb3IgTGludXggSW5zdGFuY2VzKiAuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1hdXRvc2NhbGluZy1sYXVuY2hjb25maWd1cmF0aW9uLmh0bWwjY2ZuLWF1dG9zY2FsaW5nLWxhdW5jaGNvbmZpZ3VyYXRpb24tcmFtZGlza2lkXG4gICAgICovXG4gICAgcmVhZG9ubHkgcmFtRGlza0lkPzogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogQSBsaXN0IHRoYXQgY29udGFpbnMgdGhlIHNlY3VyaXR5IGdyb3VwcyB0byBhc3NpZ24gdG8gdGhlIGluc3RhbmNlcyBpbiB0aGUgQXV0byBTY2FsaW5nIGdyb3VwLiBUaGUgbGlzdCBjYW4gY29udGFpbiBib3RoIHRoZSBJRHMgb2YgZXhpc3Rpbmcgc2VjdXJpdHkgZ3JvdXBzIGFuZCByZWZlcmVuY2VzIHRvIFtTZWN1cml0eUdyb3VwXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1lYzItc2VjdXJpdHktZ3JvdXAuaHRtbCkgcmVzb3VyY2VzIGNyZWF0ZWQgaW4gdGhlIHRlbXBsYXRlLlxuICAgICAqXG4gICAgICogRm9yIG1vcmUgaW5mb3JtYXRpb24sIHNlZSBbQ29udHJvbCB0cmFmZmljIHRvIHJlc291cmNlcyB1c2luZyBzZWN1cml0eSBncm91cHNdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BbWF6b25WUEMvbGF0ZXN0L1VzZXJHdWlkZS9WUENfU2VjdXJpdHlHcm91cHMuaHRtbCkgaW4gdGhlICpBbWF6b24gVmlydHVhbCBQcml2YXRlIENsb3VkIFVzZXIgR3VpZGUqIC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWF1dG9zY2FsaW5nLWxhdW5jaGNvbmZpZ3VyYXRpb24uaHRtbCNjZm4tYXV0b3NjYWxpbmctbGF1bmNoY29uZmlndXJhdGlvbi1zZWN1cml0eWdyb3Vwc1xuICAgICAqL1xuICAgIHJlYWRvbmx5IHNlY3VyaXR5R3JvdXBzPzogc3RyaW5nW107XG5cbiAgICAvKipcbiAgICAgKiBUaGUgbWF4aW11bSBob3VybHkgcHJpY2UgdG8gYmUgcGFpZCBmb3IgYW55IFNwb3QgSW5zdGFuY2UgbGF1bmNoZWQgdG8gZnVsZmlsbCB0aGUgcmVxdWVzdC4gU3BvdCBJbnN0YW5jZXMgYXJlIGxhdW5jaGVkIHdoZW4gdGhlIHByaWNlIHlvdSBzcGVjaWZ5IGV4Y2VlZHMgdGhlIGN1cnJlbnQgU3BvdCBwcmljZS4gRm9yIG1vcmUgaW5mb3JtYXRpb24sIHNlZSBbUmVxdWVzdCBTcG90IEluc3RhbmNlcyBmb3IgZmF1bHQtdG9sZXJhbnQgYW5kIGZsZXhpYmxlIGFwcGxpY2F0aW9uc10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2F1dG9zY2FsaW5nL2VjMi91c2VyZ3VpZGUvbGF1bmNoLXRlbXBsYXRlLXNwb3QtaW5zdGFuY2VzLmh0bWwpIGluIHRoZSAqQW1hem9uIEVDMiBBdXRvIFNjYWxpbmcgVXNlciBHdWlkZSogLlxuICAgICAqXG4gICAgICogVmFsaWQgUmFuZ2U6IE1pbmltdW0gdmFsdWUgb2YgMC4wMDFcbiAgICAgKlxuICAgICAqID4gV2hlbiB5b3UgY2hhbmdlIHlvdXIgbWF4aW11bSBwcmljZSBieSBjcmVhdGluZyBhIG5ldyBsYXVuY2ggY29uZmlndXJhdGlvbiwgcnVubmluZyBpbnN0YW5jZXMgd2lsbCBjb250aW51ZSB0byBydW4gYXMgbG9uZyBhcyB0aGUgbWF4aW11bSBwcmljZSBmb3IgdGhvc2UgcnVubmluZyBpbnN0YW5jZXMgaXMgaGlnaGVyIHRoYW4gdGhlIGN1cnJlbnQgU3BvdCBwcmljZS5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWF1dG9zY2FsaW5nLWxhdW5jaGNvbmZpZ3VyYXRpb24uaHRtbCNjZm4tYXV0b3NjYWxpbmctbGF1bmNoY29uZmlndXJhdGlvbi1zcG90cHJpY2VcbiAgICAgKi9cbiAgICByZWFkb25seSBzcG90UHJpY2U/OiBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgQmFzZTY0LWVuY29kZWQgdXNlciBkYXRhIHRvIG1ha2UgYXZhaWxhYmxlIHRvIHRoZSBsYXVuY2hlZCBFQzIgaW5zdGFuY2VzLiBGb3IgbW9yZSBpbmZvcm1hdGlvbiwgc2VlIFtJbnN0YW5jZSBtZXRhZGF0YSBhbmQgdXNlciBkYXRhXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTRUMyL2xhdGVzdC9Vc2VyR3VpZGUvZWMyLWluc3RhbmNlLW1ldGFkYXRhLmh0bWwpIGluIHRoZSAqQW1hem9uIEVDMiBVc2VyIEd1aWRlIGZvciBMaW51eCBJbnN0YW5jZXMqIC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWF1dG9zY2FsaW5nLWxhdW5jaGNvbmZpZ3VyYXRpb24uaHRtbCNjZm4tYXV0b3NjYWxpbmctbGF1bmNoY29uZmlndXJhdGlvbi11c2VyZGF0YVxuICAgICAqL1xuICAgIHJlYWRvbmx5IHVzZXJEYXRhPzogc3RyaW5nO1xufVxuXG4vKipcbiAqIERldGVybWluZSB3aGV0aGVyIHRoZSBnaXZlbiBwcm9wZXJ0aWVzIG1hdGNoIHRob3NlIG9mIGEgYENmbkxhdW5jaENvbmZpZ3VyYXRpb25Qcm9wc2BcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgQ2ZuTGF1bmNoQ29uZmlndXJhdGlvblByb3BzYFxuICpcbiAqIEByZXR1cm5zIHRoZSByZXN1bHQgb2YgdGhlIHZhbGlkYXRpb24uXG4gKi9cbmZ1bmN0aW9uIENmbkxhdW5jaENvbmZpZ3VyYXRpb25Qcm9wc1ZhbGlkYXRvcihwcm9wZXJ0aWVzOiBhbnkpOiBjZGsuVmFsaWRhdGlvblJlc3VsdCB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gY2RrLlZBTElEQVRJT05fU1VDQ0VTUzsgfVxuICAgIGNvbnN0IGVycm9ycyA9IG5ldyBjZGsuVmFsaWRhdGlvblJlc3VsdHMoKTtcbiAgICBpZiAodHlwZW9mIHByb3BlcnRpZXMgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIGVycm9ycy5jb2xsZWN0KG5ldyBjZGsuVmFsaWRhdGlvblJlc3VsdCgnRXhwZWN0ZWQgYW4gb2JqZWN0LCBidXQgcmVjZWl2ZWQ6ICcgKyBKU09OLnN0cmluZ2lmeShwcm9wZXJ0aWVzKSkpO1xuICAgIH1cbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2Fzc29jaWF0ZVB1YmxpY0lwQWRkcmVzcycsIGNkay52YWxpZGF0ZUJvb2xlYW4pKHByb3BlcnRpZXMuYXNzb2NpYXRlUHVibGljSXBBZGRyZXNzKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdibG9ja0RldmljZU1hcHBpbmdzJywgY2RrLmxpc3RWYWxpZGF0b3IoQ2ZuTGF1bmNoQ29uZmlndXJhdGlvbl9CbG9ja0RldmljZU1hcHBpbmdQcm9wZXJ0eVZhbGlkYXRvcikpKHByb3BlcnRpZXMuYmxvY2tEZXZpY2VNYXBwaW5ncykpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignY2xhc3NpY0xpbmtWcGNJZCcsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5jbGFzc2ljTGlua1ZwY0lkKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdjbGFzc2ljTGlua1ZwY1NlY3VyaXR5R3JvdXBzJywgY2RrLmxpc3RWYWxpZGF0b3IoY2RrLnZhbGlkYXRlU3RyaW5nKSkocHJvcGVydGllcy5jbGFzc2ljTGlua1ZwY1NlY3VyaXR5R3JvdXBzKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdlYnNPcHRpbWl6ZWQnLCBjZGsudmFsaWRhdGVCb29sZWFuKShwcm9wZXJ0aWVzLmVic09wdGltaXplZCkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignaWFtSW5zdGFuY2VQcm9maWxlJywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmlhbUluc3RhbmNlUHJvZmlsZSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignaW1hZ2VJZCcsIGNkay5yZXF1aXJlZFZhbGlkYXRvcikocHJvcGVydGllcy5pbWFnZUlkKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdpbWFnZUlkJywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmltYWdlSWQpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2luc3RhbmNlSWQnLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuaW5zdGFuY2VJZCkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignaW5zdGFuY2VNb25pdG9yaW5nJywgY2RrLnZhbGlkYXRlQm9vbGVhbikocHJvcGVydGllcy5pbnN0YW5jZU1vbml0b3JpbmcpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2luc3RhbmNlVHlwZScsIGNkay5yZXF1aXJlZFZhbGlkYXRvcikocHJvcGVydGllcy5pbnN0YW5jZVR5cGUpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2luc3RhbmNlVHlwZScsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5pbnN0YW5jZVR5cGUpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2tlcm5lbElkJywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmtlcm5lbElkKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdrZXlOYW1lJywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmtleU5hbWUpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2xhdW5jaENvbmZpZ3VyYXRpb25OYW1lJywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmxhdW5jaENvbmZpZ3VyYXRpb25OYW1lKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdtZXRhZGF0YU9wdGlvbnMnLCBDZm5MYXVuY2hDb25maWd1cmF0aW9uX01ldGFkYXRhT3B0aW9uc1Byb3BlcnR5VmFsaWRhdG9yKShwcm9wZXJ0aWVzLm1ldGFkYXRhT3B0aW9ucykpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigncGxhY2VtZW50VGVuYW5jeScsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5wbGFjZW1lbnRUZW5hbmN5KSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdyYW1EaXNrSWQnLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMucmFtRGlza0lkKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdzZWN1cml0eUdyb3VwcycsIGNkay5saXN0VmFsaWRhdG9yKGNkay52YWxpZGF0ZVN0cmluZykpKHByb3BlcnRpZXMuc2VjdXJpdHlHcm91cHMpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3Nwb3RQcmljZScsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5zcG90UHJpY2UpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3VzZXJEYXRhJywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLnVzZXJEYXRhKSk7XG4gICAgcmV0dXJuIGVycm9ycy53cmFwKCdzdXBwbGllZCBwcm9wZXJ0aWVzIG5vdCBjb3JyZWN0IGZvciBcIkNmbkxhdW5jaENvbmZpZ3VyYXRpb25Qcm9wc1wiJyk7XG59XG5cbi8qKlxuICogUmVuZGVycyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6QXV0b1NjYWxpbmc6OkxhdW5jaENvbmZpZ3VyYXRpb25gIHJlc291cmNlXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYENmbkxhdW5jaENvbmZpZ3VyYXRpb25Qcm9wc2BcbiAqXG4gKiBAcmV0dXJucyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6QXV0b1NjYWxpbmc6OkxhdW5jaENvbmZpZ3VyYXRpb25gIHJlc291cmNlLlxuICovXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gY2ZuTGF1bmNoQ29uZmlndXJhdGlvblByb3BzVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBhbnkge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIHByb3BlcnRpZXM7IH1cbiAgICBDZm5MYXVuY2hDb25maWd1cmF0aW9uUHJvcHNWYWxpZGF0b3IocHJvcGVydGllcykuYXNzZXJ0U3VjY2VzcygpO1xuICAgIHJldHVybiB7XG4gICAgICAgIEltYWdlSWQ6IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuaW1hZ2VJZCksXG4gICAgICAgIEluc3RhbmNlVHlwZTogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5pbnN0YW5jZVR5cGUpLFxuICAgICAgICBBc3NvY2lhdGVQdWJsaWNJcEFkZHJlc3M6IGNkay5ib29sZWFuVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLmFzc29jaWF0ZVB1YmxpY0lwQWRkcmVzcyksXG4gICAgICAgIEJsb2NrRGV2aWNlTWFwcGluZ3M6IGNkay5saXN0TWFwcGVyKGNmbkxhdW5jaENvbmZpZ3VyYXRpb25CbG9ja0RldmljZU1hcHBpbmdQcm9wZXJ0eVRvQ2xvdWRGb3JtYXRpb24pKHByb3BlcnRpZXMuYmxvY2tEZXZpY2VNYXBwaW5ncyksXG4gICAgICAgIENsYXNzaWNMaW5rVlBDSWQ6IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuY2xhc3NpY0xpbmtWcGNJZCksXG4gICAgICAgIENsYXNzaWNMaW5rVlBDU2VjdXJpdHlHcm91cHM6IGNkay5saXN0TWFwcGVyKGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKShwcm9wZXJ0aWVzLmNsYXNzaWNMaW5rVnBjU2VjdXJpdHlHcm91cHMpLFxuICAgICAgICBFYnNPcHRpbWl6ZWQ6IGNkay5ib29sZWFuVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLmVic09wdGltaXplZCksXG4gICAgICAgIElhbUluc3RhbmNlUHJvZmlsZTogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5pYW1JbnN0YW5jZVByb2ZpbGUpLFxuICAgICAgICBJbnN0YW5jZUlkOiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLmluc3RhbmNlSWQpLFxuICAgICAgICBJbnN0YW5jZU1vbml0b3Jpbmc6IGNkay5ib29sZWFuVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLmluc3RhbmNlTW9uaXRvcmluZyksXG4gICAgICAgIEtlcm5lbElkOiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLmtlcm5lbElkKSxcbiAgICAgICAgS2V5TmFtZTogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5rZXlOYW1lKSxcbiAgICAgICAgTGF1bmNoQ29uZmlndXJhdGlvbk5hbWU6IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMubGF1bmNoQ29uZmlndXJhdGlvbk5hbWUpLFxuICAgICAgICBNZXRhZGF0YU9wdGlvbnM6IGNmbkxhdW5jaENvbmZpZ3VyYXRpb25NZXRhZGF0YU9wdGlvbnNQcm9wZXJ0eVRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5tZXRhZGF0YU9wdGlvbnMpLFxuICAgICAgICBQbGFjZW1lbnRUZW5hbmN5OiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLnBsYWNlbWVudFRlbmFuY3kpLFxuICAgICAgICBSYW1EaXNrSWQ6IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMucmFtRGlza0lkKSxcbiAgICAgICAgU2VjdXJpdHlHcm91cHM6IGNkay5saXN0TWFwcGVyKGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKShwcm9wZXJ0aWVzLnNlY3VyaXR5R3JvdXBzKSxcbiAgICAgICAgU3BvdFByaWNlOiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLnNwb3RQcmljZSksXG4gICAgICAgIFVzZXJEYXRhOiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLnVzZXJEYXRhKSxcbiAgICB9O1xufVxuXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gQ2ZuTGF1bmNoQ29uZmlndXJhdGlvblByb3BzRnJvbUNsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQ8Q2ZuTGF1bmNoQ29uZmlndXJhdGlvblByb3BzPiB7XG4gICAgcHJvcGVydGllcyA9IHByb3BlcnRpZXMgPT0gbnVsbCA/IHt9IDogcHJvcGVydGllcztcbiAgICBpZiAodHlwZW9mIHByb3BlcnRpZXMgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIHJldHVybiBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdChwcm9wZXJ0aWVzKTtcbiAgICB9XG4gICAgY29uc3QgcmV0ID0gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25Qcm9wZXJ0eU9iamVjdDxDZm5MYXVuY2hDb25maWd1cmF0aW9uUHJvcHM+KCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdpbWFnZUlkJywgJ0ltYWdlSWQnLCBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLkltYWdlSWQpKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2luc3RhbmNlVHlwZScsICdJbnN0YW5jZVR5cGUnLCBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLkluc3RhbmNlVHlwZSkpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnYXNzb2NpYXRlUHVibGljSXBBZGRyZXNzJywgJ0Fzc29jaWF0ZVB1YmxpY0lwQWRkcmVzcycsIHByb3BlcnRpZXMuQXNzb2NpYXRlUHVibGljSXBBZGRyZXNzICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldEJvb2xlYW4ocHJvcGVydGllcy5Bc3NvY2lhdGVQdWJsaWNJcEFkZHJlc3MpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2Jsb2NrRGV2aWNlTWFwcGluZ3MnLCAnQmxvY2tEZXZpY2VNYXBwaW5ncycsIHByb3BlcnRpZXMuQmxvY2tEZXZpY2VNYXBwaW5ncyAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRBcnJheShDZm5MYXVuY2hDb25maWd1cmF0aW9uQmxvY2tEZXZpY2VNYXBwaW5nUHJvcGVydHlGcm9tQ2xvdWRGb3JtYXRpb24pKHByb3BlcnRpZXMuQmxvY2tEZXZpY2VNYXBwaW5ncykgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnY2xhc3NpY0xpbmtWcGNJZCcsICdDbGFzc2ljTGlua1ZQQ0lkJywgcHJvcGVydGllcy5DbGFzc2ljTGlua1ZQQ0lkICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLkNsYXNzaWNMaW5rVlBDSWQpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2NsYXNzaWNMaW5rVnBjU2VjdXJpdHlHcm91cHMnLCAnQ2xhc3NpY0xpbmtWUENTZWN1cml0eUdyb3VwcycsIHByb3BlcnRpZXMuQ2xhc3NpY0xpbmtWUENTZWN1cml0eUdyb3VwcyAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmdBcnJheShwcm9wZXJ0aWVzLkNsYXNzaWNMaW5rVlBDU2VjdXJpdHlHcm91cHMpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2Vic09wdGltaXplZCcsICdFYnNPcHRpbWl6ZWQnLCBwcm9wZXJ0aWVzLkVic09wdGltaXplZCAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRCb29sZWFuKHByb3BlcnRpZXMuRWJzT3B0aW1pemVkKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdpYW1JbnN0YW5jZVByb2ZpbGUnLCAnSWFtSW5zdGFuY2VQcm9maWxlJywgcHJvcGVydGllcy5JYW1JbnN0YW5jZVByb2ZpbGUgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuSWFtSW5zdGFuY2VQcm9maWxlKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdpbnN0YW5jZUlkJywgJ0luc3RhbmNlSWQnLCBwcm9wZXJ0aWVzLkluc3RhbmNlSWQgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuSW5zdGFuY2VJZCkgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnaW5zdGFuY2VNb25pdG9yaW5nJywgJ0luc3RhbmNlTW9uaXRvcmluZycsIHByb3BlcnRpZXMuSW5zdGFuY2VNb25pdG9yaW5nICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldEJvb2xlYW4ocHJvcGVydGllcy5JbnN0YW5jZU1vbml0b3JpbmcpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2tlcm5lbElkJywgJ0tlcm5lbElkJywgcHJvcGVydGllcy5LZXJuZWxJZCAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5LZXJuZWxJZCkgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgna2V5TmFtZScsICdLZXlOYW1lJywgcHJvcGVydGllcy5LZXlOYW1lICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLktleU5hbWUpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2xhdW5jaENvbmZpZ3VyYXRpb25OYW1lJywgJ0xhdW5jaENvbmZpZ3VyYXRpb25OYW1lJywgcHJvcGVydGllcy5MYXVuY2hDb25maWd1cmF0aW9uTmFtZSAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5MYXVuY2hDb25maWd1cmF0aW9uTmFtZSkgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnbWV0YWRhdGFPcHRpb25zJywgJ01ldGFkYXRhT3B0aW9ucycsIHByb3BlcnRpZXMuTWV0YWRhdGFPcHRpb25zICE9IG51bGwgPyBDZm5MYXVuY2hDb25maWd1cmF0aW9uTWV0YWRhdGFPcHRpb25zUHJvcGVydHlGcm9tQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5NZXRhZGF0YU9wdGlvbnMpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ3BsYWNlbWVudFRlbmFuY3knLCAnUGxhY2VtZW50VGVuYW5jeScsIHByb3BlcnRpZXMuUGxhY2VtZW50VGVuYW5jeSAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5QbGFjZW1lbnRUZW5hbmN5KSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdyYW1EaXNrSWQnLCAnUmFtRGlza0lkJywgcHJvcGVydGllcy5SYW1EaXNrSWQgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuUmFtRGlza0lkKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdzZWN1cml0eUdyb3VwcycsICdTZWN1cml0eUdyb3VwcycsIHByb3BlcnRpZXMuU2VjdXJpdHlHcm91cHMgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nQXJyYXkocHJvcGVydGllcy5TZWN1cml0eUdyb3VwcykgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnc3BvdFByaWNlJywgJ1Nwb3RQcmljZScsIHByb3BlcnRpZXMuU3BvdFByaWNlICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLlNwb3RQcmljZSkgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgndXNlckRhdGEnLCAnVXNlckRhdGEnLCBwcm9wZXJ0aWVzLlVzZXJEYXRhICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLlVzZXJEYXRhKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFVucmVjb2duaXplZFByb3BlcnRpZXNBc0V4dHJhKHByb3BlcnRpZXMpO1xuICAgIHJldHVybiByZXQ7XG59XG5cbi8qKlxuICogQSBDbG91ZEZvcm1hdGlvbiBgQVdTOjpBdXRvU2NhbGluZzo6TGF1bmNoQ29uZmlndXJhdGlvbmBcbiAqXG4gKiBUaGUgYEFXUzo6QXV0b1NjYWxpbmc6OkxhdW5jaENvbmZpZ3VyYXRpb25gIHJlc291cmNlIHNwZWNpZmllcyB0aGUgbGF1bmNoIGNvbmZpZ3VyYXRpb24gdGhhdCBjYW4gYmUgdXNlZCBieSBhbiBBdXRvIFNjYWxpbmcgZ3JvdXAgdG8gY29uZmlndXJlIEFtYXpvbiBFQzIgaW5zdGFuY2VzLlxuICpcbiAqIFdoZW4geW91IHVwZGF0ZSB0aGUgbGF1bmNoIGNvbmZpZ3VyYXRpb24gZm9yIGFuIEF1dG8gU2NhbGluZyBncm91cCwgQ2xvdWRGb3JtYXRpb24gZGVsZXRlcyB0aGF0IHJlc291cmNlIGFuZCBjcmVhdGVzIGEgbmV3IGxhdW5jaCBjb25maWd1cmF0aW9uIHdpdGggdGhlIHVwZGF0ZWQgcHJvcGVydGllcyBhbmQgYSBuZXcgbmFtZS4gRXhpc3RpbmcgaW5zdGFuY2VzIGFyZSBub3QgYWZmZWN0ZWQuIFRvIHVwZGF0ZSBleGlzdGluZyBpbnN0YW5jZXMgd2hlbiB5b3UgdXBkYXRlIHRoZSBgQVdTOjpBdXRvU2NhbGluZzo6TGF1bmNoQ29uZmlndXJhdGlvbmAgcmVzb3VyY2UsIHlvdSBjYW4gc3BlY2lmeSBhbiBbVXBkYXRlUG9saWN5IGF0dHJpYnV0ZV0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLWF0dHJpYnV0ZS11cGRhdGVwb2xpY3kuaHRtbCkgZm9yIHRoZSBncm91cC4gWW91IGNhbiBmaW5kIHNhbXBsZSB1cGRhdGUgcG9saWNpZXMgZm9yIHJvbGxpbmcgdXBkYXRlcyBpbiBbQXV0byBzY2FsaW5nIHRlbXBsYXRlIHNuaXBwZXRzXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9xdWlja3JlZi1hdXRvc2NhbGluZy5odG1sKSAuXG4gKlxuICogPiBBbWF6b24gRUMyIEF1dG8gU2NhbGluZyBjb25maWd1cmVzIGluc3RhbmNlcyBsYXVuY2hlZCBhcyBwYXJ0IG9mIGFuIEF1dG8gU2NhbGluZyBncm91cCB1c2luZyBlaXRoZXIgYSBbbGF1bmNoIHRlbXBsYXRlXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZWMyLWxhdW5jaHRlbXBsYXRlLmh0bWwpIG9yIGEgbGF1bmNoIGNvbmZpZ3VyYXRpb24uIFdlIHN0cm9uZ2x5IHJlY29tbWVuZCB0aGF0IHlvdSBkbyBub3QgdXNlIGxhdW5jaCBjb25maWd1cmF0aW9ucy4gVGhleSBkbyBub3QgcHJvdmlkZSBmdWxsIGZ1bmN0aW9uYWxpdHkgZm9yIEFtYXpvbiBFQzIgQXV0byBTY2FsaW5nIG9yIEFtYXpvbiBFQzIuIEZvciBtb3JlIGluZm9ybWF0aW9uLCBzZWUgW0xhdW5jaCBjb25maWd1cmF0aW9uc10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2F1dG9zY2FsaW5nL2VjMi91c2VyZ3VpZGUvbGF1bmNoLWNvbmZpZ3VyYXRpb25zLmh0bWwpIGluIHRoZSAqQW1hem9uIEVDMiBBdXRvIFNjYWxpbmcgVXNlciBHdWlkZSogLlxuICpcbiAqIEBjbG91ZGZvcm1hdGlvblJlc291cmNlIEFXUzo6QXV0b1NjYWxpbmc6OkxhdW5jaENvbmZpZ3VyYXRpb25cbiAqIEBzdGFiaWxpdHkgZXh0ZXJuYWxcbiAqXG4gKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1hdXRvc2NhbGluZy1sYXVuY2hjb25maWd1cmF0aW9uLmh0bWxcbiAqL1xuZXhwb3J0IGNsYXNzIENmbkxhdW5jaENvbmZpZ3VyYXRpb24gZXh0ZW5kcyBjZGsuQ2ZuUmVzb3VyY2UgaW1wbGVtZW50cyBjZGsuSUluc3BlY3RhYmxlIHtcbiAgICAvKipcbiAgICAgKiBUaGUgQ2xvdWRGb3JtYXRpb24gcmVzb3VyY2UgdHlwZSBuYW1lIGZvciB0aGlzIHJlc291cmNlIGNsYXNzLlxuICAgICAqL1xuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgQ0ZOX1JFU09VUkNFX1RZUEVfTkFNRSA9IFwiQVdTOjpBdXRvU2NhbGluZzo6TGF1bmNoQ29uZmlndXJhdGlvblwiO1xuXG4gICAgLyoqXG4gICAgICogQSBmYWN0b3J5IG1ldGhvZCB0aGF0IGNyZWF0ZXMgYSBuZXcgaW5zdGFuY2Ugb2YgdGhpcyBjbGFzcyBmcm9tIGFuIG9iamVjdFxuICAgICAqIGNvbnRhaW5pbmcgdGhlIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgdGhpcyByZXNvdXJjZS5cbiAgICAgKiBVc2VkIGluIHRoZSBAYXdzLWNkay9jbG91ZGZvcm1hdGlvbi1pbmNsdWRlIG1vZHVsZS5cbiAgICAgKlxuICAgICAqIEBpbnRlcm5hbFxuICAgICAqL1xuICAgIHB1YmxpYyBzdGF0aWMgX2Zyb21DbG91ZEZvcm1hdGlvbihzY29wZTogY2RrLkNvbnN0cnVjdCwgaWQ6IHN0cmluZywgcmVzb3VyY2VBdHRyaWJ1dGVzOiBhbnksIG9wdGlvbnM6IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25PcHRpb25zKTogQ2ZuTGF1bmNoQ29uZmlndXJhdGlvbiB7XG4gICAgICAgIHJlc291cmNlQXR0cmlidXRlcyA9IHJlc291cmNlQXR0cmlidXRlcyB8fCB7fTtcbiAgICAgICAgY29uc3QgcmVzb3VyY2VQcm9wZXJ0aWVzID0gb3B0aW9ucy5wYXJzZXIucGFyc2VWYWx1ZShyZXNvdXJjZUF0dHJpYnV0ZXMuUHJvcGVydGllcyk7XG4gICAgICAgIGNvbnN0IHByb3BzUmVzdWx0ID0gQ2ZuTGF1bmNoQ29uZmlndXJhdGlvblByb3BzRnJvbUNsb3VkRm9ybWF0aW9uKHJlc291cmNlUHJvcGVydGllcyk7XG4gICAgICAgIGNvbnN0IHJldCA9IG5ldyBDZm5MYXVuY2hDb25maWd1cmF0aW9uKHNjb3BlLCBpZCwgcHJvcHNSZXN1bHQudmFsdWUpO1xuICAgICAgICBmb3IgKGNvbnN0IFtwcm9wS2V5LCBwcm9wVmFsXSBvZiBPYmplY3QuZW50cmllcyhwcm9wc1Jlc3VsdC5leHRyYVByb3BlcnRpZXMpKSAge1xuICAgICAgICAgICAgcmV0LmFkZFByb3BlcnR5T3ZlcnJpZGUocHJvcEtleSwgcHJvcFZhbCk7XG4gICAgICAgIH1cbiAgICAgICAgb3B0aW9ucy5wYXJzZXIuaGFuZGxlQXR0cmlidXRlcyhyZXQsIHJlc291cmNlQXR0cmlidXRlcywgaWQpO1xuICAgICAgICByZXR1cm4gcmV0O1xuICAgIH1cblxuICAgIC8qKlxuICAgICAqIFRoZSBJRCBvZiB0aGUgQW1hem9uIE1hY2hpbmUgSW1hZ2UgKEFNSSkgdGhhdCB3YXMgYXNzaWduZWQgZHVyaW5nIHJlZ2lzdHJhdGlvbi4gRm9yIG1vcmUgaW5mb3JtYXRpb24sIHNlZSBbRmluZGluZyBhIExpbnV4IEFNSV0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0VDMi9sYXRlc3QvVXNlckd1aWRlL2ZpbmRpbmctYW4tYW1pLmh0bWwpIGluIHRoZSAqQW1hem9uIEVDMiBVc2VyIEd1aWRlIGZvciBMaW51eCBJbnN0YW5jZXMqIC5cbiAgICAgKlxuICAgICAqIElmIHlvdSBzcGVjaWZ5IGBJbnN0YW5jZUlkYCAsIGFuIGBJbWFnZUlkYCBpcyBub3QgcmVxdWlyZWQuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1hdXRvc2NhbGluZy1sYXVuY2hjb25maWd1cmF0aW9uLmh0bWwjY2ZuLWF1dG9zY2FsaW5nLWxhdW5jaGNvbmZpZ3VyYXRpb24taW1hZ2VpZFxuICAgICAqL1xuICAgIHB1YmxpYyBpbWFnZUlkOiBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBTcGVjaWZpZXMgdGhlIGluc3RhbmNlIHR5cGUgb2YgdGhlIEVDMiBpbnN0YW5jZS4gRm9yIGluZm9ybWF0aW9uIGFib3V0IGF2YWlsYWJsZSBpbnN0YW5jZSB0eXBlcywgc2VlIFtBdmFpbGFibGUgaW5zdGFuY2UgdHlwZXNdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NFQzIvbGF0ZXN0L1VzZXJHdWlkZS9pbnN0YW5jZS10eXBlcy5odG1sI0F2YWlsYWJsZUluc3RhbmNlVHlwZXMpIGluIHRoZSAqQW1hem9uIEVDMiBVc2VyIEd1aWRlIGZvciBMaW51eCBJbnN0YW5jZXMqIC5cbiAgICAgKlxuICAgICAqIElmIHlvdSBzcGVjaWZ5IGBJbnN0YW5jZUlkYCAsIGFuIGBJbnN0YW5jZVR5cGVgIGlzIG5vdCByZXF1aXJlZC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWF1dG9zY2FsaW5nLWxhdW5jaGNvbmZpZ3VyYXRpb24uaHRtbCNjZm4tYXV0b3NjYWxpbmctbGF1bmNoY29uZmlndXJhdGlvbi1pbnN0YW5jZXR5cGVcbiAgICAgKi9cbiAgICBwdWJsaWMgaW5zdGFuY2VUeXBlOiBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBTcGVjaWZpZXMgd2hldGhlciB0byBhc3NpZ24gYSBwdWJsaWMgSVB2NCBhZGRyZXNzIHRvIHRoZSBncm91cCdzIGluc3RhbmNlcy4gSWYgdGhlIGluc3RhbmNlIGlzIGxhdW5jaGVkIGludG8gYSBkZWZhdWx0IHN1Ym5ldCwgdGhlIGRlZmF1bHQgaXMgdG8gYXNzaWduIGEgcHVibGljIElQdjQgYWRkcmVzcywgdW5sZXNzIHlvdSBkaXNhYmxlZCB0aGUgb3B0aW9uIHRvIGFzc2lnbiBhIHB1YmxpYyBJUHY0IGFkZHJlc3Mgb24gdGhlIHN1Ym5ldC4gSWYgdGhlIGluc3RhbmNlIGlzIGxhdW5jaGVkIGludG8gYSBub25kZWZhdWx0IHN1Ym5ldCwgdGhlIGRlZmF1bHQgaXMgbm90IHRvIGFzc2lnbiBhIHB1YmxpYyBJUHY0IGFkZHJlc3MsIHVubGVzcyB5b3UgZW5hYmxlZCB0aGUgb3B0aW9uIHRvIGFzc2lnbiBhIHB1YmxpYyBJUHY0IGFkZHJlc3Mgb24gdGhlIHN1Ym5ldC5cbiAgICAgKlxuICAgICAqIElmIHlvdSBzcGVjaWZ5IGB0cnVlYCAsIGVhY2ggaW5zdGFuY2UgaW4gdGhlIEF1dG8gU2NhbGluZyBncm91cCByZWNlaXZlcyBhIHVuaXF1ZSBwdWJsaWMgSVB2NCBhZGRyZXNzLiBGb3IgbW9yZSBpbmZvcm1hdGlvbiwgc2VlIFtMYXVuY2hpbmcgQXV0byBTY2FsaW5nIGluc3RhbmNlcyBpbiBhIFZQQ10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2F1dG9zY2FsaW5nL2VjMi91c2VyZ3VpZGUvYXNnLWluLXZwYy5odG1sKSBpbiB0aGUgKkFtYXpvbiBFQzIgQXV0byBTY2FsaW5nIFVzZXIgR3VpZGUqIC5cbiAgICAgKlxuICAgICAqIElmIHlvdSBzcGVjaWZ5IHRoaXMgcHJvcGVydHksIHlvdSBtdXN0IHNwZWNpZnkgYXQgbGVhc3Qgb25lIHN1Ym5ldCBmb3IgYFZQQ1pvbmVJZGVudGlmaWVyYCB3aGVuIHlvdSBjcmVhdGUgeW91ciBncm91cC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWF1dG9zY2FsaW5nLWxhdW5jaGNvbmZpZ3VyYXRpb24uaHRtbCNjZm4tYXV0b3NjYWxpbmctbGF1bmNoY29uZmlndXJhdGlvbi1hc3NvY2lhdGVwdWJsaWNpcGFkZHJlc3NcbiAgICAgKi9cbiAgICBwdWJsaWMgYXNzb2NpYXRlUHVibGljSXBBZGRyZXNzOiBib29sZWFuIHwgY2RrLklSZXNvbHZhYmxlIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogVGhlIGJsb2NrIGRldmljZSBtYXBwaW5nIGVudHJpZXMgdGhhdCBkZWZpbmUgdGhlIGJsb2NrIGRldmljZXMgdG8gYXR0YWNoIHRvIHRoZSBpbnN0YW5jZXMgYXQgbGF1bmNoLiBCeSBkZWZhdWx0LCB0aGUgYmxvY2sgZGV2aWNlcyBzcGVjaWZpZWQgaW4gdGhlIGJsb2NrIGRldmljZSBtYXBwaW5nIGZvciB0aGUgQU1JIGFyZSB1c2VkLiBGb3IgbW9yZSBpbmZvcm1hdGlvbiwgc2VlIFtCbG9jayBkZXZpY2UgbWFwcGluZ3NdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NFQzIvbGF0ZXN0L1VzZXJHdWlkZS9ibG9jay1kZXZpY2UtbWFwcGluZy1jb25jZXB0cy5odG1sKSBpbiB0aGUgKkFtYXpvbiBFQzIgVXNlciBHdWlkZSBmb3IgTGludXggSW5zdGFuY2VzKiAuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1hdXRvc2NhbGluZy1sYXVuY2hjb25maWd1cmF0aW9uLmh0bWwjY2ZuLWF1dG9zY2FsaW5nLWxhdW5jaGNvbmZpZ3VyYXRpb24tYmxvY2tkZXZpY2VtYXBwaW5nc1xuICAgICAqL1xuICAgIHB1YmxpYyBibG9ja0RldmljZU1hcHBpbmdzOiBBcnJheTxDZm5MYXVuY2hDb25maWd1cmF0aW9uLkJsb2NrRGV2aWNlTWFwcGluZ1Byb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlPiB8IGNkay5JUmVzb2x2YWJsZSB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIEF2YWlsYWJsZSBmb3IgYmFja3dhcmQgY29tcGF0aWJpbGl0eS5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWF1dG9zY2FsaW5nLWxhdW5jaGNvbmZpZ3VyYXRpb24uaHRtbCNjZm4tYXV0b3NjYWxpbmctbGF1bmNoY29uZmlndXJhdGlvbi1jbGFzc2ljbGlua3ZwY2lkXG4gICAgICovXG4gICAgcHVibGljIGNsYXNzaWNMaW5rVnBjSWQ6IHN0cmluZyB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIEF2YWlsYWJsZSBmb3IgYmFja3dhcmQgY29tcGF0aWJpbGl0eS5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWF1dG9zY2FsaW5nLWxhdW5jaGNvbmZpZ3VyYXRpb24uaHRtbCNjZm4tYXV0b3NjYWxpbmctbGF1bmNoY29uZmlndXJhdGlvbi1jbGFzc2ljbGlua3ZwY3NlY3VyaXR5Z3JvdXBzXG4gICAgICovXG4gICAgcHVibGljIGNsYXNzaWNMaW5rVnBjU2VjdXJpdHlHcm91cHM6IHN0cmluZ1tdIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogU3BlY2lmaWVzIHdoZXRoZXIgdGhlIGxhdW5jaCBjb25maWd1cmF0aW9uIGlzIG9wdGltaXplZCBmb3IgRUJTIEkvTyAoIGB0cnVlYCApIG9yIG5vdCAoIGBmYWxzZWAgKS4gVGhlIG9wdGltaXphdGlvbiBwcm92aWRlcyBkZWRpY2F0ZWQgdGhyb3VnaHB1dCB0byBBbWF6b24gRUJTIGFuZCBhbiBvcHRpbWl6ZWQgY29uZmlndXJhdGlvbiBzdGFjayB0byBwcm92aWRlIG9wdGltYWwgSS9PIHBlcmZvcm1hbmNlLiBUaGlzIG9wdGltaXphdGlvbiBpcyBub3QgYXZhaWxhYmxlIHdpdGggYWxsIGluc3RhbmNlIHR5cGVzLiBBZGRpdGlvbmFsIGZlZXMgYXJlIGluY3VycmVkIHdoZW4geW91IGVuYWJsZSBFQlMgb3B0aW1pemF0aW9uIGZvciBhbiBpbnN0YW5jZSB0eXBlIHRoYXQgaXMgbm90IEVCUy1vcHRpbWl6ZWQgYnkgZGVmYXVsdC4gRm9yIG1vcmUgaW5mb3JtYXRpb24sIHNlZSBbQW1hem9uIEVCUy1vcHRpbWl6ZWQgaW5zdGFuY2VzXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTRUMyL2xhdGVzdC9Vc2VyR3VpZGUvRUJTT3B0aW1pemVkLmh0bWwpIGluIHRoZSAqQW1hem9uIEVDMiBVc2VyIEd1aWRlIGZvciBMaW51eCBJbnN0YW5jZXMqIC5cbiAgICAgKlxuICAgICAqIFRoZSBkZWZhdWx0IHZhbHVlIGlzIGBmYWxzZWAgLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtYXV0b3NjYWxpbmctbGF1bmNoY29uZmlndXJhdGlvbi5odG1sI2Nmbi1hdXRvc2NhbGluZy1sYXVuY2hjb25maWd1cmF0aW9uLWVic29wdGltaXplZFxuICAgICAqL1xuICAgIHB1YmxpYyBlYnNPcHRpbWl6ZWQ6IGJvb2xlYW4gfCBjZGsuSVJlc29sdmFibGUgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgbmFtZSBvciB0aGUgQW1hem9uIFJlc291cmNlIE5hbWUgKEFSTikgb2YgdGhlIGluc3RhbmNlIHByb2ZpbGUgYXNzb2NpYXRlZCB3aXRoIHRoZSBJQU0gcm9sZSBmb3IgdGhlIGluc3RhbmNlLiBUaGUgaW5zdGFuY2UgcHJvZmlsZSBjb250YWlucyB0aGUgSUFNIHJvbGUuIEZvciBtb3JlIGluZm9ybWF0aW9uLCBzZWUgW0lBTSByb2xlIGZvciBhcHBsaWNhdGlvbnMgdGhhdCBydW4gb24gQW1hem9uIEVDMiBpbnN0YW5jZXNdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9hdXRvc2NhbGluZy9lYzIvdXNlcmd1aWRlL3VzLWlhbS1yb2xlLmh0bWwpIGluIHRoZSAqQW1hem9uIEVDMiBBdXRvIFNjYWxpbmcgVXNlciBHdWlkZSogLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtYXV0b3NjYWxpbmctbGF1bmNoY29uZmlndXJhdGlvbi5odG1sI2Nmbi1hdXRvc2NhbGluZy1sYXVuY2hjb25maWd1cmF0aW9uLWlhbWluc3RhbmNlcHJvZmlsZVxuICAgICAqL1xuICAgIHB1YmxpYyBpYW1JbnN0YW5jZVByb2ZpbGU6IHN0cmluZyB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIFRoZSBJRCBvZiB0aGUgQW1hem9uIEVDMiBpbnN0YW5jZSB0byB1c2UgdG8gY3JlYXRlIHRoZSBsYXVuY2ggY29uZmlndXJhdGlvbi4gV2hlbiB5b3UgdXNlIGFuIGluc3RhbmNlIHRvIGNyZWF0ZSBhIGxhdW5jaCBjb25maWd1cmF0aW9uLCBhbGwgcHJvcGVydGllcyBhcmUgZGVyaXZlZCBmcm9tIHRoZSBpbnN0YW5jZSB3aXRoIHRoZSBleGNlcHRpb24gb2YgYEJsb2NrRGV2aWNlTWFwcGluZ2AgYW5kIGBBc3NvY2lhdGVQdWJsaWNJcEFkZHJlc3NgIC4gWW91IGNhbiBvdmVycmlkZSBhbnkgcHJvcGVydGllcyBmcm9tIHRoZSBpbnN0YW5jZSBieSBzcGVjaWZ5aW5nIHRoZW0gaW4gdGhlIGxhdW5jaCBjb25maWd1cmF0aW9uLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtYXV0b3NjYWxpbmctbGF1bmNoY29uZmlndXJhdGlvbi5odG1sI2Nmbi1hdXRvc2NhbGluZy1sYXVuY2hjb25maWd1cmF0aW9uLWluc3RhbmNlaWRcbiAgICAgKi9cbiAgICBwdWJsaWMgaW5zdGFuY2VJZDogc3RyaW5nIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogQ29udHJvbHMgd2hldGhlciBpbnN0YW5jZXMgaW4gdGhpcyBncm91cCBhcmUgbGF1bmNoZWQgd2l0aCBkZXRhaWxlZCAoIGB0cnVlYCApIG9yIGJhc2ljICggYGZhbHNlYCApIG1vbml0b3JpbmcuXG4gICAgICpcbiAgICAgKiBUaGUgZGVmYXVsdCB2YWx1ZSBpcyBgdHJ1ZWAgKGVuYWJsZWQpLlxuICAgICAqXG4gICAgICogPiBXaGVuIGRldGFpbGVkIG1vbml0b3JpbmcgaXMgZW5hYmxlZCwgQW1hem9uIENsb3VkV2F0Y2ggZ2VuZXJhdGVzIG1ldHJpY3MgZXZlcnkgbWludXRlIGFuZCB5b3VyIGFjY291bnQgaXMgY2hhcmdlZCBhIGZlZS4gV2hlbiB5b3UgZGlzYWJsZSBkZXRhaWxlZCBtb25pdG9yaW5nLCBDbG91ZFdhdGNoIGdlbmVyYXRlcyBtZXRyaWNzIGV2ZXJ5IDUgbWludXRlcy4gRm9yIG1vcmUgaW5mb3JtYXRpb24sIHNlZSBbQ29uZmlndXJlIE1vbml0b3JpbmcgZm9yIEF1dG8gU2NhbGluZyBJbnN0YW5jZXNdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9hdXRvc2NhbGluZy9sYXRlc3QvdXNlcmd1aWRlL2VuYWJsZS1hcy1pbnN0YW5jZS1tZXRyaWNzLmh0bWwpIGluIHRoZSAqQW1hem9uIEVDMiBBdXRvIFNjYWxpbmcgVXNlciBHdWlkZSogLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtYXV0b3NjYWxpbmctbGF1bmNoY29uZmlndXJhdGlvbi5odG1sI2Nmbi1hdXRvc2NhbGluZy1sYXVuY2hjb25maWd1cmF0aW9uLWluc3RhbmNlbW9uaXRvcmluZ1xuICAgICAqL1xuICAgIHB1YmxpYyBpbnN0YW5jZU1vbml0b3Jpbmc6IGJvb2xlYW4gfCBjZGsuSVJlc29sdmFibGUgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgSUQgb2YgdGhlIGtlcm5lbCBhc3NvY2lhdGVkIHdpdGggdGhlIEFNSS5cbiAgICAgKlxuICAgICAqID4gV2UgcmVjb21tZW5kIHRoYXQgeW91IHVzZSBQVi1HUlVCIGluc3RlYWQgb2Yga2VybmVscyBhbmQgUkFNIGRpc2tzLiBGb3IgbW9yZSBpbmZvcm1hdGlvbiwgc2VlIFtVc2VyIHByb3ZpZGVkIGtlcm5lbHNdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NFQzIvbGF0ZXN0L1VzZXJHdWlkZS9Vc2VyUHJvdmlkZWRLZXJuZWxzLmh0bWwpIGluIHRoZSAqQW1hem9uIEVDMiBVc2VyIEd1aWRlIGZvciBMaW51eCBJbnN0YW5jZXMqIC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWF1dG9zY2FsaW5nLWxhdW5jaGNvbmZpZ3VyYXRpb24uaHRtbCNjZm4tYXV0b3NjYWxpbmctbGF1bmNoY29uZmlndXJhdGlvbi1rZXJuZWxpZFxuICAgICAqL1xuICAgIHB1YmxpYyBrZXJuZWxJZDogc3RyaW5nIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogVGhlIG5hbWUgb2YgdGhlIGtleSBwYWlyLiBGb3IgbW9yZSBpbmZvcm1hdGlvbiwgc2VlIFtBbWF6b24gRUMyIGtleSBwYWlycyBhbmQgTGludXggaW5zdGFuY2VzXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTRUMyL2xhdGVzdC9Vc2VyR3VpZGUvZWMyLWtleS1wYWlycy5odG1sKSBpbiB0aGUgKkFtYXpvbiBFQzIgVXNlciBHdWlkZSBmb3IgTGludXggSW5zdGFuY2VzKiAuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1hdXRvc2NhbGluZy1sYXVuY2hjb25maWd1cmF0aW9uLmh0bWwjY2ZuLWF1dG9zY2FsaW5nLWxhdW5jaGNvbmZpZ3VyYXRpb24ta2V5bmFtZVxuICAgICAqL1xuICAgIHB1YmxpYyBrZXlOYW1lOiBzdHJpbmcgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgbmFtZSBvZiB0aGUgbGF1bmNoIGNvbmZpZ3VyYXRpb24uIFRoaXMgbmFtZSBtdXN0IGJlIHVuaXF1ZSBwZXIgUmVnaW9uIHBlciBhY2NvdW50LlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtYXV0b3NjYWxpbmctbGF1bmNoY29uZmlndXJhdGlvbi5odG1sI2Nmbi1hdXRvc2NhbGluZy1sYXVuY2hjb25maWd1cmF0aW9uLWxhdW5jaGNvbmZpZ3VyYXRpb25uYW1lXG4gICAgICovXG4gICAgcHVibGljIGxhdW5jaENvbmZpZ3VyYXRpb25OYW1lOiBzdHJpbmcgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgbWV0YWRhdGEgb3B0aW9ucyBmb3IgdGhlIGluc3RhbmNlcy4gRm9yIG1vcmUgaW5mb3JtYXRpb24sIHNlZSBbQ29uZmlndXJpbmcgdGhlIEluc3RhbmNlIE1ldGFkYXRhIE9wdGlvbnNdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9hdXRvc2NhbGluZy9lYzIvdXNlcmd1aWRlL2NyZWF0ZS1sYXVuY2gtY29uZmlnLmh0bWwjbGF1bmNoLWNvbmZpZ3VyYXRpb25zLWltZHMpIGluIHRoZSAqQW1hem9uIEVDMiBBdXRvIFNjYWxpbmcgVXNlciBHdWlkZSogLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtYXV0b3NjYWxpbmctbGF1bmNoY29uZmlndXJhdGlvbi5odG1sI2Nmbi1hdXRvc2NhbGluZy1sYXVuY2hjb25maWd1cmF0aW9uLW1ldGFkYXRhb3B0aW9uc1xuICAgICAqL1xuICAgIHB1YmxpYyBtZXRhZGF0YU9wdGlvbnM6IENmbkxhdW5jaENvbmZpZ3VyYXRpb24uTWV0YWRhdGFPcHRpb25zUHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGUgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgdGVuYW5jeSBvZiB0aGUgaW5zdGFuY2UsIGVpdGhlciBgZGVmYXVsdGAgb3IgYGRlZGljYXRlZGAgLiBBbiBpbnN0YW5jZSB3aXRoIGBkZWRpY2F0ZWRgIHRlbmFuY3kgcnVucyBvbiBpc29sYXRlZCwgc2luZ2xlLXRlbmFudCBoYXJkd2FyZSBhbmQgY2FuIG9ubHkgYmUgbGF1bmNoZWQgaW50byBhIFZQQy4gVG8gbGF1bmNoIGRlZGljYXRlZCBpbnN0YW5jZXMgaW50byBhIHNoYXJlZCB0ZW5hbmN5IFZQQyAoYSBWUEMgd2l0aCB0aGUgaW5zdGFuY2UgcGxhY2VtZW50IHRlbmFuY3kgYXR0cmlidXRlIHNldCB0byBgZGVmYXVsdGAgKSwgeW91IG11c3Qgc2V0IHRoZSB2YWx1ZSBvZiB0aGlzIHByb3BlcnR5IHRvIGBkZWRpY2F0ZWRgIC4gRm9yIG1vcmUgaW5mb3JtYXRpb24sIHNlZSBbQ29uZmlndXJpbmcgaW5zdGFuY2UgdGVuYW5jeSB3aXRoIEFtYXpvbiBFQzIgQXV0byBTY2FsaW5nXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vYXV0b3NjYWxpbmcvZWMyL3VzZXJndWlkZS9hdXRvLXNjYWxpbmctZGVkaWNhdGVkLWluc3RhbmNlcy5odG1sKSBpbiB0aGUgKkFtYXpvbiBFQzIgQXV0byBTY2FsaW5nIFVzZXIgR3VpZGUqIC5cbiAgICAgKlxuICAgICAqIElmIHlvdSBzcGVjaWZ5IGBQbGFjZW1lbnRUZW5hbmN5YCAsIHlvdSBtdXN0IHNwZWNpZnkgYXQgbGVhc3Qgb25lIHN1Ym5ldCBmb3IgYFZQQ1pvbmVJZGVudGlmaWVyYCB3aGVuIHlvdSBjcmVhdGUgeW91ciBncm91cC5cbiAgICAgKlxuICAgICAqIFZhbGlkIHZhbHVlczogYGRlZmF1bHRgIHwgYGRlZGljYXRlZGBcbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWF1dG9zY2FsaW5nLWxhdW5jaGNvbmZpZ3VyYXRpb24uaHRtbCNjZm4tYXV0b3NjYWxpbmctbGF1bmNoY29uZmlndXJhdGlvbi1wbGFjZW1lbnR0ZW5hbmN5XG4gICAgICovXG4gICAgcHVibGljIHBsYWNlbWVudFRlbmFuY3k6IHN0cmluZyB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIFRoZSBJRCBvZiB0aGUgUkFNIGRpc2sgdG8gc2VsZWN0LlxuICAgICAqXG4gICAgICogPiBXZSByZWNvbW1lbmQgdGhhdCB5b3UgdXNlIFBWLUdSVUIgaW5zdGVhZCBvZiBrZXJuZWxzIGFuZCBSQU0gZGlza3MuIEZvciBtb3JlIGluZm9ybWF0aW9uLCBzZWUgW1VzZXIgcHJvdmlkZWQga2VybmVsc10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0VDMi9sYXRlc3QvVXNlckd1aWRlL1VzZXJQcm92aWRlZEtlcm5lbHMuaHRtbCkgaW4gdGhlICpBbWF6b24gRUMyIFVzZXIgR3VpZGUgZm9yIExpbnV4IEluc3RhbmNlcyogLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtYXV0b3NjYWxpbmctbGF1bmNoY29uZmlndXJhdGlvbi5odG1sI2Nmbi1hdXRvc2NhbGluZy1sYXVuY2hjb25maWd1cmF0aW9uLXJhbWRpc2tpZFxuICAgICAqL1xuICAgIHB1YmxpYyByYW1EaXNrSWQ6IHN0cmluZyB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIEEgbGlzdCB0aGF0IGNvbnRhaW5zIHRoZSBzZWN1cml0eSBncm91cHMgdG8gYXNzaWduIHRvIHRoZSBpbnN0YW5jZXMgaW4gdGhlIEF1dG8gU2NhbGluZyBncm91cC4gVGhlIGxpc3QgY2FuIGNvbnRhaW4gYm90aCB0aGUgSURzIG9mIGV4aXN0aW5nIHNlY3VyaXR5IGdyb3VwcyBhbmQgcmVmZXJlbmNlcyB0byBbU2VjdXJpdHlHcm91cF0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtZWMyLXNlY3VyaXR5LWdyb3VwLmh0bWwpIHJlc291cmNlcyBjcmVhdGVkIGluIHRoZSB0ZW1wbGF0ZS5cbiAgICAgKlxuICAgICAqIEZvciBtb3JlIGluZm9ybWF0aW9uLCBzZWUgW0NvbnRyb2wgdHJhZmZpYyB0byByZXNvdXJjZXMgdXNpbmcgc2VjdXJpdHkgZ3JvdXBzXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQW1hem9uVlBDL2xhdGVzdC9Vc2VyR3VpZGUvVlBDX1NlY3VyaXR5R3JvdXBzLmh0bWwpIGluIHRoZSAqQW1hem9uIFZpcnR1YWwgUHJpdmF0ZSBDbG91ZCBVc2VyIEd1aWRlKiAuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1hdXRvc2NhbGluZy1sYXVuY2hjb25maWd1cmF0aW9uLmh0bWwjY2ZuLWF1dG9zY2FsaW5nLWxhdW5jaGNvbmZpZ3VyYXRpb24tc2VjdXJpdHlncm91cHNcbiAgICAgKi9cbiAgICBwdWJsaWMgc2VjdXJpdHlHcm91cHM6IHN0cmluZ1tdIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogVGhlIG1heGltdW0gaG91cmx5IHByaWNlIHRvIGJlIHBhaWQgZm9yIGFueSBTcG90IEluc3RhbmNlIGxhdW5jaGVkIHRvIGZ1bGZpbGwgdGhlIHJlcXVlc3QuIFNwb3QgSW5zdGFuY2VzIGFyZSBsYXVuY2hlZCB3aGVuIHRoZSBwcmljZSB5b3Ugc3BlY2lmeSBleGNlZWRzIHRoZSBjdXJyZW50IFNwb3QgcHJpY2UuIEZvciBtb3JlIGluZm9ybWF0aW9uLCBzZWUgW1JlcXVlc3QgU3BvdCBJbnN0YW5jZXMgZm9yIGZhdWx0LXRvbGVyYW50IGFuZCBmbGV4aWJsZSBhcHBsaWNhdGlvbnNdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9hdXRvc2NhbGluZy9lYzIvdXNlcmd1aWRlL2xhdW5jaC10ZW1wbGF0ZS1zcG90LWluc3RhbmNlcy5odG1sKSBpbiB0aGUgKkFtYXpvbiBFQzIgQXV0byBTY2FsaW5nIFVzZXIgR3VpZGUqIC5cbiAgICAgKlxuICAgICAqIFZhbGlkIFJhbmdlOiBNaW5pbXVtIHZhbHVlIG9mIDAuMDAxXG4gICAgICpcbiAgICAgKiA+IFdoZW4geW91IGNoYW5nZSB5b3VyIG1heGltdW0gcHJpY2UgYnkgY3JlYXRpbmcgYSBuZXcgbGF1bmNoIGNvbmZpZ3VyYXRpb24sIHJ1bm5pbmcgaW5zdGFuY2VzIHdpbGwgY29udGludWUgdG8gcnVuIGFzIGxvbmcgYXMgdGhlIG1heGltdW0gcHJpY2UgZm9yIHRob3NlIHJ1bm5pbmcgaW5zdGFuY2VzIGlzIGhpZ2hlciB0aGFuIHRoZSBjdXJyZW50IFNwb3QgcHJpY2UuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1hdXRvc2NhbGluZy1sYXVuY2hjb25maWd1cmF0aW9uLmh0bWwjY2ZuLWF1dG9zY2FsaW5nLWxhdW5jaGNvbmZpZ3VyYXRpb24tc3BvdHByaWNlXG4gICAgICovXG4gICAgcHVibGljIHNwb3RQcmljZTogc3RyaW5nIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogVGhlIEJhc2U2NC1lbmNvZGVkIHVzZXIgZGF0YSB0byBtYWtlIGF2YWlsYWJsZSB0byB0aGUgbGF1bmNoZWQgRUMyIGluc3RhbmNlcy4gRm9yIG1vcmUgaW5mb3JtYXRpb24sIHNlZSBbSW5zdGFuY2UgbWV0YWRhdGEgYW5kIHVzZXIgZGF0YV0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0VDMi9sYXRlc3QvVXNlckd1aWRlL2VjMi1pbnN0YW5jZS1tZXRhZGF0YS5odG1sKSBpbiB0aGUgKkFtYXpvbiBFQzIgVXNlciBHdWlkZSBmb3IgTGludXggSW5zdGFuY2VzKiAuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1hdXRvc2NhbGluZy1sYXVuY2hjb25maWd1cmF0aW9uLmh0bWwjY2ZuLWF1dG9zY2FsaW5nLWxhdW5jaGNvbmZpZ3VyYXRpb24tdXNlcmRhdGFcbiAgICAgKi9cbiAgICBwdWJsaWMgdXNlckRhdGE6IHN0cmluZyB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIENyZWF0ZSBhIG5ldyBgQVdTOjpBdXRvU2NhbGluZzo6TGF1bmNoQ29uZmlndXJhdGlvbmAuXG4gICAgICpcbiAgICAgKiBAcGFyYW0gc2NvcGUgLSBzY29wZSBpbiB3aGljaCB0aGlzIHJlc291cmNlIGlzIGRlZmluZWRcbiAgICAgKiBAcGFyYW0gaWQgICAgLSBzY29wZWQgaWQgb2YgdGhlIHJlc291cmNlXG4gICAgICogQHBhcmFtIHByb3BzIC0gcmVzb3VyY2UgcHJvcGVydGllc1xuICAgICAqL1xuICAgIGNvbnN0cnVjdG9yKHNjb3BlOiBjZGsuQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogQ2ZuTGF1bmNoQ29uZmlndXJhdGlvblByb3BzKSB7XG4gICAgICAgIHN1cGVyKHNjb3BlLCBpZCwgeyB0eXBlOiBDZm5MYXVuY2hDb25maWd1cmF0aW9uLkNGTl9SRVNPVVJDRV9UWVBFX05BTUUsIHByb3BlcnRpZXM6IHByb3BzIH0pO1xuICAgICAgICBjZGsucmVxdWlyZVByb3BlcnR5KHByb3BzLCAnaW1hZ2VJZCcsIHRoaXMpO1xuICAgICAgICBjZGsucmVxdWlyZVByb3BlcnR5KHByb3BzLCAnaW5zdGFuY2VUeXBlJywgdGhpcyk7XG5cbiAgICAgICAgdGhpcy5pbWFnZUlkID0gcHJvcHMuaW1hZ2VJZDtcbiAgICAgICAgdGhpcy5pbnN0YW5jZVR5cGUgPSBwcm9wcy5pbnN0YW5jZVR5cGU7XG4gICAgICAgIHRoaXMuYXNzb2NpYXRlUHVibGljSXBBZGRyZXNzID0gcHJvcHMuYXNzb2NpYXRlUHVibGljSXBBZGRyZXNzO1xuICAgICAgICB0aGlzLmJsb2NrRGV2aWNlTWFwcGluZ3MgPSBwcm9wcy5ibG9ja0RldmljZU1hcHBpbmdzO1xuICAgICAgICB0aGlzLmNsYXNzaWNMaW5rVnBjSWQgPSBwcm9wcy5jbGFzc2ljTGlua1ZwY0lkO1xuICAgICAgICB0aGlzLmNsYXNzaWNMaW5rVnBjU2VjdXJpdHlHcm91cHMgPSBwcm9wcy5jbGFzc2ljTGlua1ZwY1NlY3VyaXR5R3JvdXBzO1xuICAgICAgICB0aGlzLmVic09wdGltaXplZCA9IHByb3BzLmVic09wdGltaXplZDtcbiAgICAgICAgdGhpcy5pYW1JbnN0YW5jZVByb2ZpbGUgPSBwcm9wcy5pYW1JbnN0YW5jZVByb2ZpbGU7XG4gICAgICAgIHRoaXMuaW5zdGFuY2VJZCA9IHByb3BzLmluc3RhbmNlSWQ7XG4gICAgICAgIHRoaXMuaW5zdGFuY2VNb25pdG9yaW5nID0gcHJvcHMuaW5zdGFuY2VNb25pdG9yaW5nO1xuICAgICAgICB0aGlzLmtlcm5lbElkID0gcHJvcHMua2VybmVsSWQ7XG4gICAgICAgIHRoaXMua2V5TmFtZSA9IHByb3BzLmtleU5hbWU7XG4gICAgICAgIHRoaXMubGF1bmNoQ29uZmlndXJhdGlvbk5hbWUgPSBwcm9wcy5sYXVuY2hDb25maWd1cmF0aW9uTmFtZTtcbiAgICAgICAgdGhpcy5tZXRhZGF0YU9wdGlvbnMgPSBwcm9wcy5tZXRhZGF0YU9wdGlvbnM7XG4gICAgICAgIHRoaXMucGxhY2VtZW50VGVuYW5jeSA9IHByb3BzLnBsYWNlbWVudFRlbmFuY3k7XG4gICAgICAgIHRoaXMucmFtRGlza0lkID0gcHJvcHMucmFtRGlza0lkO1xuICAgICAgICB0aGlzLnNlY3VyaXR5R3JvdXBzID0gcHJvcHMuc2VjdXJpdHlHcm91cHM7XG4gICAgICAgIHRoaXMuc3BvdFByaWNlID0gcHJvcHMuc3BvdFByaWNlO1xuICAgICAgICB0aGlzLnVzZXJEYXRhID0gcHJvcHMudXNlckRhdGE7XG4gICAgfVxuXG4gICAgLyoqXG4gICAgICogRXhhbWluZXMgdGhlIENsb3VkRm9ybWF0aW9uIHJlc291cmNlIGFuZCBkaXNjbG9zZXMgYXR0cmlidXRlcy5cbiAgICAgKlxuICAgICAqIEBwYXJhbSBpbnNwZWN0b3IgLSB0cmVlIGluc3BlY3RvciB0byBjb2xsZWN0IGFuZCBwcm9jZXNzIGF0dHJpYnV0ZXNcbiAgICAgKlxuICAgICAqL1xuICAgIHB1YmxpYyBpbnNwZWN0KGluc3BlY3RvcjogY2RrLlRyZWVJbnNwZWN0b3IpIHtcbiAgICAgICAgaW5zcGVjdG9yLmFkZEF0dHJpYnV0ZShcImF3czpjZGs6Y2xvdWRmb3JtYXRpb246dHlwZVwiLCBDZm5MYXVuY2hDb25maWd1cmF0aW9uLkNGTl9SRVNPVVJDRV9UWVBFX05BTUUpO1xuICAgICAgICBpbnNwZWN0b3IuYWRkQXR0cmlidXRlKFwiYXdzOmNkazpjbG91ZGZvcm1hdGlvbjpwcm9wc1wiLCB0aGlzLmNmblByb3BlcnRpZXMpO1xuICAgIH1cblxuICAgIHByb3RlY3RlZCBnZXQgY2ZuUHJvcGVydGllcygpOiB7IFtrZXk6IHN0cmluZ106IGFueSB9ICB7XG4gICAgICAgIHJldHVybiB7XG4gICAgICAgICAgICBpbWFnZUlkOiB0aGlzLmltYWdlSWQsXG4gICAgICAgICAgICBpbnN0YW5jZVR5cGU6IHRoaXMuaW5zdGFuY2VUeXBlLFxuICAgICAgICAgICAgYXNzb2NpYXRlUHVibGljSXBBZGRyZXNzOiB0aGlzLmFzc29jaWF0ZVB1YmxpY0lwQWRkcmVzcyxcbiAgICAgICAgICAgIGJsb2NrRGV2aWNlTWFwcGluZ3M6IHRoaXMuYmxvY2tEZXZpY2VNYXBwaW5ncyxcbiAgICAgICAgICAgIGNsYXNzaWNMaW5rVnBjSWQ6IHRoaXMuY2xhc3NpY0xpbmtWcGNJZCxcbiAgICAgICAgICAgIGNsYXNzaWNMaW5rVnBjU2VjdXJpdHlHcm91cHM6IHRoaXMuY2xhc3NpY0xpbmtWcGNTZWN1cml0eUdyb3VwcyxcbiAgICAgICAgICAgIGVic09wdGltaXplZDogdGhpcy5lYnNPcHRpbWl6ZWQsXG4gICAgICAgICAgICBpYW1JbnN0YW5jZVByb2ZpbGU6IHRoaXMuaWFtSW5zdGFuY2VQcm9maWxlLFxuICAgICAgICAgICAgaW5zdGFuY2VJZDogdGhpcy5pbnN0YW5jZUlkLFxuICAgICAgICAgICAgaW5zdGFuY2VNb25pdG9yaW5nOiB0aGlzLmluc3RhbmNlTW9uaXRvcmluZyxcbiAgICAgICAgICAgIGtlcm5lbElkOiB0aGlzLmtlcm5lbElkLFxuICAgICAgICAgICAga2V5TmFtZTogdGhpcy5rZXlOYW1lLFxuICAgICAgICAgICAgbGF1bmNoQ29uZmlndXJhdGlvbk5hbWU6IHRoaXMubGF1bmNoQ29uZmlndXJhdGlvbk5hbWUsXG4gICAgICAgICAgICBtZXRhZGF0YU9wdGlvbnM6IHRoaXMubWV0YWRhdGFPcHRpb25zLFxuICAgICAgICAgICAgcGxhY2VtZW50VGVuYW5jeTogdGhpcy5wbGFjZW1lbnRUZW5hbmN5LFxuICAgICAgICAgICAgcmFtRGlza0lkOiB0aGlzLnJhbURpc2tJZCxcbiAgICAgICAgICAgIHNlY3VyaXR5R3JvdXBzOiB0aGlzLnNlY3VyaXR5R3JvdXBzLFxuICAgICAgICAgICAgc3BvdFByaWNlOiB0aGlzLnNwb3RQcmljZSxcbiAgICAgICAgICAgIHVzZXJEYXRhOiB0aGlzLnVzZXJEYXRhLFxuICAgICAgICB9O1xuICAgIH1cblxuICAgIHByb3RlY3RlZCByZW5kZXJQcm9wZXJ0aWVzKHByb3BzOiB7W2tleTogc3RyaW5nXTogYW55fSk6IHsgW2tleTogc3RyaW5nXTogYW55IH0gIHtcbiAgICAgICAgcmV0dXJuIGNmbkxhdW5jaENvbmZpZ3VyYXRpb25Qcm9wc1RvQ2xvdWRGb3JtYXRpb24ocHJvcHMpO1xuICAgIH1cbn1cblxuZXhwb3J0IG5hbWVzcGFjZSBDZm5MYXVuY2hDb25maWd1cmF0aW9uIHtcbiAgICAvKipcbiAgICAgKiBgQmxvY2tEZXZpY2VgIGlzIGEgcHJvcGVydHkgb2YgdGhlIGBFQlNgIHByb3BlcnR5IG9mIHRoZSBbQVdTOjpBdXRvU2NhbGluZzo6TGF1bmNoQ29uZmlndXJhdGlvbiBCbG9ja0RldmljZU1hcHBpbmddKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWFzLWxhdW5jaGNvbmZpZy1ibG9ja2Rldi1tYXBwaW5nLmh0bWwpIHByb3BlcnR5IHR5cGUgdGhhdCBkZXNjcmliZXMgYW4gQW1hem9uIEVCUyB2b2x1bWUuXG4gICAgICpcbiAgICAgKiBAc3RydWN0XG4gICAgICogQHN0YWJpbGl0eSBleHRlcm5hbFxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hdXRvc2NhbGluZy1sYXVuY2hjb25maWd1cmF0aW9uLWJsb2NrZGV2aWNlLmh0bWxcbiAgICAgKi9cbiAgICBleHBvcnQgaW50ZXJmYWNlIEJsb2NrRGV2aWNlUHJvcGVydHkge1xuICAgICAgICAvKipcbiAgICAgICAgICogSW5kaWNhdGVzIHdoZXRoZXIgdGhlIHZvbHVtZSBpcyBkZWxldGVkIG9uIGluc3RhbmNlIHRlcm1pbmF0aW9uLiBGb3IgQW1hem9uIEVDMiBBdXRvIFNjYWxpbmcsIHRoZSBkZWZhdWx0IHZhbHVlIGlzIGB0cnVlYCAuXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXV0b3NjYWxpbmctbGF1bmNoY29uZmlndXJhdGlvbi1ibG9ja2RldmljZS5odG1sI2Nmbi1hdXRvc2NhbGluZy1sYXVuY2hjb25maWd1cmF0aW9uLWJsb2NrZGV2aWNlLWRlbGV0ZW9udGVybWluYXRpb25cbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IGRlbGV0ZU9uVGVybWluYXRpb24/OiBib29sZWFuIHwgY2RrLklSZXNvbHZhYmxlO1xuICAgICAgICAvKipcbiAgICAgICAgICogU3BlY2lmaWVzIHdoZXRoZXIgdGhlIHZvbHVtZSBzaG91bGQgYmUgZW5jcnlwdGVkLiBFbmNyeXB0ZWQgRUJTIHZvbHVtZXMgY2FuIG9ubHkgYmUgYXR0YWNoZWQgdG8gaW5zdGFuY2VzIHRoYXQgc3VwcG9ydCBBbWF6b24gRUJTIGVuY3J5cHRpb24uIEZvciBtb3JlIGluZm9ybWF0aW9uLCBzZWUgW1N1cHBvcnRlZCBpbnN0YW5jZSB0eXBlc10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0VDMi9sYXRlc3QvVXNlckd1aWRlL0VCU0VuY3J5cHRpb24uaHRtbCNFQlNFbmNyeXB0aW9uX3N1cHBvcnRlZF9pbnN0YW5jZXMpIC4gSWYgeW91ciBBTUkgdXNlcyBlbmNyeXB0ZWQgdm9sdW1lcywgeW91IGNhbiBhbHNvIG9ubHkgbGF1bmNoIGl0IG9uIHN1cHBvcnRlZCBpbnN0YW5jZSB0eXBlcy5cbiAgICAgICAgICpcbiAgICAgICAgICogPiBJZiB5b3UgYXJlIGNyZWF0aW5nIGEgdm9sdW1lIGZyb20gYSBzbmFwc2hvdCwgeW91IGNhbm5vdCBjcmVhdGUgYW4gdW5lbmNyeXB0ZWQgdm9sdW1lIGZyb20gYW4gZW5jcnlwdGVkIHNuYXBzaG90LiBBbHNvLCB5b3UgY2Fubm90IHNwZWNpZnkgYSBLTVMga2V5IElEIHdoZW4gdXNpbmcgYSBsYXVuY2ggY29uZmlndXJhdGlvbi5cbiAgICAgICAgICogPlxuICAgICAgICAgKiA+IElmIHlvdSBlbmFibGUgZW5jcnlwdGlvbiBieSBkZWZhdWx0LCB0aGUgRUJTIHZvbHVtZXMgdGhhdCB5b3UgY3JlYXRlIGFyZSBhbHdheXMgZW5jcnlwdGVkLCBlaXRoZXIgdXNpbmcgdGhlIEFXUyBtYW5hZ2VkIEtNUyBrZXkgb3IgYSBjdXN0b21lci1tYW5hZ2VkIEtNUyBrZXksIHJlZ2FyZGxlc3Mgb2Ygd2hldGhlciB0aGUgc25hcHNob3Qgd2FzIGVuY3J5cHRlZC5cbiAgICAgICAgICogPlxuICAgICAgICAgKiA+IEZvciBtb3JlIGluZm9ybWF0aW9uLCBzZWUgW1VzZSBBV1MgS01TIGtleXMgdG8gZW5jcnlwdCBBbWF6b24gRUJTIHZvbHVtZXNdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9hdXRvc2NhbGluZy9lYzIvdXNlcmd1aWRlL2VjMi1hdXRvLXNjYWxpbmctZGF0YS1wcm90ZWN0aW9uLmh0bWwjZW5jcnlwdGlvbikgaW4gdGhlICpBbWF6b24gRUMyIEF1dG8gU2NhbGluZyBVc2VyIEd1aWRlKiAuXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXV0b3NjYWxpbmctbGF1bmNoY29uZmlndXJhdGlvbi1ibG9ja2RldmljZS5odG1sI2Nmbi1hdXRvc2NhbGluZy1sYXVuY2hjb25maWd1cmF0aW9uLWJsb2NrZGV2aWNlLWVuY3J5cHRlZFxuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgZW5jcnlwdGVkPzogYm9vbGVhbiB8IGNkay5JUmVzb2x2YWJsZTtcbiAgICAgICAgLyoqXG4gICAgICAgICAqIFRoZSBudW1iZXIgb2YgaW5wdXQvb3V0cHV0IChJL08pIG9wZXJhdGlvbnMgcGVyIHNlY29uZCAoSU9QUykgdG8gcHJvdmlzaW9uIGZvciB0aGUgdm9sdW1lLiBGb3IgYGdwM2AgYW5kIGBpbzFgIHZvbHVtZXMsIHRoaXMgcmVwcmVzZW50cyB0aGUgbnVtYmVyIG9mIElPUFMgdGhhdCBhcmUgcHJvdmlzaW9uZWQgZm9yIHRoZSB2b2x1bWUuIEZvciBgZ3AyYCB2b2x1bWVzLCB0aGlzIHJlcHJlc2VudHMgdGhlIGJhc2VsaW5lIHBlcmZvcm1hbmNlIG9mIHRoZSB2b2x1bWUgYW5kIHRoZSByYXRlIGF0IHdoaWNoIHRoZSB2b2x1bWUgYWNjdW11bGF0ZXMgSS9PIGNyZWRpdHMgZm9yIGJ1cnN0aW5nLlxuICAgICAgICAgKlxuICAgICAgICAgKiBUaGUgZm9sbG93aW5nIGFyZSB0aGUgc3VwcG9ydGVkIHZhbHVlcyBmb3IgZWFjaCB2b2x1bWUgdHlwZTpcbiAgICAgICAgICpcbiAgICAgICAgICogLSBgZ3AzYCA6IDMsMDAwLTE2LDAwMCBJT1BTXG4gICAgICAgICAqIC0gYGlvMWAgOiAxMDAtNjQsMDAwIElPUFNcbiAgICAgICAgICpcbiAgICAgICAgICogRm9yIGBpbzFgIHZvbHVtZXMsIHdlIGd1YXJhbnRlZSA2NCwwMDAgSU9QUyBvbmx5IGZvciBbSW5zdGFuY2VzIGJ1aWx0IG9uIHRoZSBOaXRybyBTeXN0ZW1dKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NFQzIvbGF0ZXN0L1VzZXJHdWlkZS9pbnN0YW5jZS10eXBlcy5odG1sI2VjMi1uaXRyby1pbnN0YW5jZXMpIC4gT3RoZXIgaW5zdGFuY2UgZmFtaWxpZXMgZ3VhcmFudGVlIHBlcmZvcm1hbmNlIHVwIHRvIDMyLDAwMCBJT1BTLlxuICAgICAgICAgKlxuICAgICAgICAgKiBgSW9wc2AgaXMgc3VwcG9ydGVkIHdoZW4gdGhlIHZvbHVtZSB0eXBlIGlzIGBncDNgIG9yIGBpbzFgIGFuZCByZXF1aXJlZCBvbmx5IHdoZW4gdGhlIHZvbHVtZSB0eXBlIGlzIGBpbzFgIC4gKE5vdCB1c2VkIHdpdGggYHN0YW5kYXJkYCAsIGBncDJgICwgYHN0MWAgLCBvciBgc2MxYCB2b2x1bWVzLilcbiAgICAgICAgICpcbiAgICAgICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hdXRvc2NhbGluZy1sYXVuY2hjb25maWd1cmF0aW9uLWJsb2NrZGV2aWNlLmh0bWwjY2ZuLWF1dG9zY2FsaW5nLWxhdW5jaGNvbmZpZ3VyYXRpb24tYmxvY2tkZXZpY2UtaW9wc1xuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgaW9wcz86IG51bWJlcjtcbiAgICAgICAgLyoqXG4gICAgICAgICAqIFRoZSBzbmFwc2hvdCBJRCBvZiB0aGUgdm9sdW1lIHRvIHVzZS5cbiAgICAgICAgICpcbiAgICAgICAgICogWW91IG11c3Qgc3BlY2lmeSBlaXRoZXIgYSBgVm9sdW1lU2l6ZWAgb3IgYSBgU25hcHNob3RJZGAgLlxuICAgICAgICAgKlxuICAgICAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWF1dG9zY2FsaW5nLWxhdW5jaGNvbmZpZ3VyYXRpb24tYmxvY2tkZXZpY2UuaHRtbCNjZm4tYXV0b3NjYWxpbmctbGF1bmNoY29uZmlndXJhdGlvbi1ibG9ja2RldmljZS1zbmFwc2hvdGlkXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBzbmFwc2hvdElkPzogc3RyaW5nO1xuICAgICAgICAvKipcbiAgICAgICAgICogVGhlIHRocm91Z2hwdXQgKE1pQnBzKSB0byBwcm92aXNpb24gZm9yIGEgYGdwM2Agdm9sdW1lLlxuICAgICAgICAgKlxuICAgICAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWF1dG9zY2FsaW5nLWxhdW5jaGNvbmZpZ3VyYXRpb24tYmxvY2tkZXZpY2UuaHRtbCNjZm4tYXV0b3NjYWxpbmctbGF1bmNoY29uZmlndXJhdGlvbi1ibG9ja2RldmljZS10aHJvdWdocHV0XG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSB0aHJvdWdocHV0PzogbnVtYmVyO1xuICAgICAgICAvKipcbiAgICAgICAgICogVGhlIHZvbHVtZSBzaXplLCBpbiBHaUJzLiBUaGUgZm9sbG93aW5nIGFyZSB0aGUgc3VwcG9ydGVkIHZvbHVtZXMgc2l6ZXMgZm9yIGVhY2ggdm9sdW1lIHR5cGU6XG4gICAgICAgICAqXG4gICAgICAgICAqIC0gYGdwMmAgYW5kIGBncDNgIDogMS0xNiwzODRcbiAgICAgICAgICogLSBgaW8xYCA6IDQtMTYsMzg0XG4gICAgICAgICAqIC0gYHN0MWAgYW5kIGBzYzFgIDogMTI1LTE2LDM4NFxuICAgICAgICAgKiAtIGBzdGFuZGFyZGAgOiAxLTEsMDI0XG4gICAgICAgICAqXG4gICAgICAgICAqIFlvdSBtdXN0IHNwZWNpZnkgZWl0aGVyIGEgYFNuYXBzaG90SWRgIG9yIGEgYFZvbHVtZVNpemVgIC4gSWYgeW91IHNwZWNpZnkgYm90aCBgU25hcHNob3RJZGAgYW5kIGBWb2x1bWVTaXplYCAsIHRoZSB2b2x1bWUgc2l6ZSBtdXN0IGJlIGVxdWFsIG9yIGdyZWF0ZXIgdGhhbiB0aGUgc2l6ZSBvZiB0aGUgc25hcHNob3QuXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXV0b3NjYWxpbmctbGF1bmNoY29uZmlndXJhdGlvbi1ibG9ja2RldmljZS5odG1sI2Nmbi1hdXRvc2NhbGluZy1sYXVuY2hjb25maWd1cmF0aW9uLWJsb2NrZGV2aWNlLXZvbHVtZXNpemVcbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IHZvbHVtZVNpemU/OiBudW1iZXI7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBUaGUgdm9sdW1lIHR5cGUuIEZvciBtb3JlIGluZm9ybWF0aW9uLCBzZWUgW0FtYXpvbiBFQlMgdm9sdW1lIHR5cGVzXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTRUMyL2xhdGVzdC9Vc2VyR3VpZGUvRUJTVm9sdW1lVHlwZXMuaHRtbCkgaW4gdGhlICpBbWF6b24gRUMyIFVzZXIgR3VpZGUgZm9yIExpbnV4IEluc3RhbmNlcyogLlxuICAgICAgICAgKlxuICAgICAgICAgKiBWYWxpZCB2YWx1ZXM6IGBzdGFuZGFyZGAgfCBgaW8xYCB8IGBncDJgIHwgYHN0MWAgfCBgc2MxYCB8IGBncDNgXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXV0b3NjYWxpbmctbGF1bmNoY29uZmlndXJhdGlvbi1ibG9ja2RldmljZS5odG1sI2Nmbi1hdXRvc2NhbGluZy1sYXVuY2hjb25maWd1cmF0aW9uLWJsb2NrZGV2aWNlLXZvbHVtZXR5cGVcbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IHZvbHVtZVR5cGU/OiBzdHJpbmc7XG4gICAgfVxufVxuXG4vKipcbiAqIERldGVybWluZSB3aGV0aGVyIHRoZSBnaXZlbiBwcm9wZXJ0aWVzIG1hdGNoIHRob3NlIG9mIGEgYEJsb2NrRGV2aWNlUHJvcGVydHlgXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYEJsb2NrRGV2aWNlUHJvcGVydHlgXG4gKlxuICogQHJldHVybnMgdGhlIHJlc3VsdCBvZiB0aGUgdmFsaWRhdGlvbi5cbiAqL1xuZnVuY3Rpb24gQ2ZuTGF1bmNoQ29uZmlndXJhdGlvbl9CbG9ja0RldmljZVByb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXM6IGFueSk6IGNkay5WYWxpZGF0aW9uUmVzdWx0IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBjZGsuVkFMSURBVElPTl9TVUNDRVNTOyB9XG4gICAgY29uc3QgZXJyb3JzID0gbmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0cygpO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgZXJyb3JzLmNvbGxlY3QobmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0KCdFeHBlY3RlZCBhbiBvYmplY3QsIGJ1dCByZWNlaXZlZDogJyArIEpTT04uc3RyaW5naWZ5KHByb3BlcnRpZXMpKSk7XG4gICAgfVxuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignZGVsZXRlT25UZXJtaW5hdGlvbicsIGNkay52YWxpZGF0ZUJvb2xlYW4pKHByb3BlcnRpZXMuZGVsZXRlT25UZXJtaW5hdGlvbikpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignZW5jcnlwdGVkJywgY2RrLnZhbGlkYXRlQm9vbGVhbikocHJvcGVydGllcy5lbmNyeXB0ZWQpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2lvcHMnLCBjZGsudmFsaWRhdGVOdW1iZXIpKHByb3BlcnRpZXMuaW9wcykpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignc25hcHNob3RJZCcsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5zbmFwc2hvdElkKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCd0aHJvdWdocHV0JywgY2RrLnZhbGlkYXRlTnVtYmVyKShwcm9wZXJ0aWVzLnRocm91Z2hwdXQpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3ZvbHVtZVNpemUnLCBjZGsudmFsaWRhdGVOdW1iZXIpKHByb3BlcnRpZXMudm9sdW1lU2l6ZSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigndm9sdW1lVHlwZScsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy52b2x1bWVUeXBlKSk7XG4gICAgcmV0dXJuIGVycm9ycy53cmFwKCdzdXBwbGllZCBwcm9wZXJ0aWVzIG5vdCBjb3JyZWN0IGZvciBcIkJsb2NrRGV2aWNlUHJvcGVydHlcIicpO1xufVxuXG4vKipcbiAqIFJlbmRlcnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OkF1dG9TY2FsaW5nOjpMYXVuY2hDb25maWd1cmF0aW9uLkJsb2NrRGV2aWNlYCByZXNvdXJjZVxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBCbG9ja0RldmljZVByb3BlcnR5YFxuICpcbiAqIEByZXR1cm5zIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpBdXRvU2NhbGluZzo6TGF1bmNoQ29uZmlndXJhdGlvbi5CbG9ja0RldmljZWAgcmVzb3VyY2UuXG4gKi9cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBjZm5MYXVuY2hDb25maWd1cmF0aW9uQmxvY2tEZXZpY2VQcm9wZXJ0eVRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogYW55IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBwcm9wZXJ0aWVzOyB9XG4gICAgQ2ZuTGF1bmNoQ29uZmlndXJhdGlvbl9CbG9ja0RldmljZVByb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXMpLmFzc2VydFN1Y2Nlc3MoKTtcbiAgICByZXR1cm4ge1xuICAgICAgICBEZWxldGVPblRlcm1pbmF0aW9uOiBjZGsuYm9vbGVhblRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5kZWxldGVPblRlcm1pbmF0aW9uKSxcbiAgICAgICAgRW5jcnlwdGVkOiBjZGsuYm9vbGVhblRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5lbmNyeXB0ZWQpLFxuICAgICAgICBJb3BzOiBjZGsubnVtYmVyVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLmlvcHMpLFxuICAgICAgICBTbmFwc2hvdElkOiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLnNuYXBzaG90SWQpLFxuICAgICAgICBUaHJvdWdocHV0OiBjZGsubnVtYmVyVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLnRocm91Z2hwdXQpLFxuICAgICAgICBWb2x1bWVTaXplOiBjZGsubnVtYmVyVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLnZvbHVtZVNpemUpLFxuICAgICAgICBWb2x1bWVUeXBlOiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLnZvbHVtZVR5cGUpLFxuICAgIH07XG59XG5cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBDZm5MYXVuY2hDb25maWd1cmF0aW9uQmxvY2tEZXZpY2VQcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0PENmbkxhdW5jaENvbmZpZ3VyYXRpb24uQmxvY2tEZXZpY2VQcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZT4ge1xuICAgIGlmIChjZGsuaXNSZXNvbHZhYmxlT2JqZWN0KHByb3BlcnRpZXMpKSB7XG4gICAgICAgIHJldHVybiBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdChwcm9wZXJ0aWVzKTtcbiAgICB9XG4gICAgcHJvcGVydGllcyA9IHByb3BlcnRpZXMgPT0gbnVsbCA/IHt9IDogcHJvcGVydGllcztcbiAgICBpZiAodHlwZW9mIHByb3BlcnRpZXMgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIHJldHVybiBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdChwcm9wZXJ0aWVzKTtcbiAgICB9XG4gICAgY29uc3QgcmV0ID0gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25Qcm9wZXJ0eU9iamVjdDxDZm5MYXVuY2hDb25maWd1cmF0aW9uLkJsb2NrRGV2aWNlUHJvcGVydHk+KCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdkZWxldGVPblRlcm1pbmF0aW9uJywgJ0RlbGV0ZU9uVGVybWluYXRpb24nLCBwcm9wZXJ0aWVzLkRlbGV0ZU9uVGVybWluYXRpb24gIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0Qm9vbGVhbihwcm9wZXJ0aWVzLkRlbGV0ZU9uVGVybWluYXRpb24pIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2VuY3J5cHRlZCcsICdFbmNyeXB0ZWQnLCBwcm9wZXJ0aWVzLkVuY3J5cHRlZCAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRCb29sZWFuKHByb3BlcnRpZXMuRW5jcnlwdGVkKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdpb3BzJywgJ0lvcHMnLCBwcm9wZXJ0aWVzLklvcHMgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0TnVtYmVyKHByb3BlcnRpZXMuSW9wcykgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnc25hcHNob3RJZCcsICdTbmFwc2hvdElkJywgcHJvcGVydGllcy5TbmFwc2hvdElkICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLlNuYXBzaG90SWQpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ3Rocm91Z2hwdXQnLCAnVGhyb3VnaHB1dCcsIHByb3BlcnRpZXMuVGhyb3VnaHB1dCAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXROdW1iZXIocHJvcGVydGllcy5UaHJvdWdocHV0KSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCd2b2x1bWVTaXplJywgJ1ZvbHVtZVNpemUnLCBwcm9wZXJ0aWVzLlZvbHVtZVNpemUgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0TnVtYmVyKHByb3BlcnRpZXMuVm9sdW1lU2l6ZSkgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgndm9sdW1lVHlwZScsICdWb2x1bWVUeXBlJywgcHJvcGVydGllcy5Wb2x1bWVUeXBlICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLlZvbHVtZVR5cGUpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkVW5yZWNvZ25pemVkUHJvcGVydGllc0FzRXh0cmEocHJvcGVydGllcyk7XG4gICAgcmV0dXJuIHJldDtcbn1cblxuZXhwb3J0IG5hbWVzcGFjZSBDZm5MYXVuY2hDb25maWd1cmF0aW9uIHtcbiAgICAvKipcbiAgICAgKiBgQmxvY2tEZXZpY2VNYXBwaW5nYCBzcGVjaWZpZXMgYSBibG9jayBkZXZpY2UgbWFwcGluZyBmb3IgdGhlIGBCbG9ja0RldmljZU1hcHBpbmdzYCBwcm9wZXJ0eSBvZiB0aGUgW0FXUzo6QXV0b1NjYWxpbmc6OkxhdW5jaENvbmZpZ3VyYXRpb25dKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWFzLWxhdW5jaGNvbmZpZy5odG1sKSByZXNvdXJjZS5cbiAgICAgKlxuICAgICAqIEVhY2ggaW5zdGFuY2UgdGhhdCBpcyBsYXVuY2hlZCBoYXMgYW4gYXNzb2NpYXRlZCByb290IGRldmljZSB2b2x1bWUsIGVpdGhlciBhbiBBbWF6b24gRUJTIHZvbHVtZSBvciBhbiBpbnN0YW5jZSBzdG9yZSB2b2x1bWUuIFlvdSBjYW4gdXNlIGJsb2NrIGRldmljZSBtYXBwaW5ncyB0byBzcGVjaWZ5IGFkZGl0aW9uYWwgRUJTIHZvbHVtZXMgb3IgaW5zdGFuY2Ugc3RvcmUgdm9sdW1lcyB0byBhdHRhY2ggdG8gYW4gaW5zdGFuY2Ugd2hlbiBpdCBpcyBsYXVuY2hlZC5cbiAgICAgKlxuICAgICAqIEZvciBtb3JlIGluZm9ybWF0aW9uLCBzZWUgW0V4YW1wbGUgYmxvY2sgZGV2aWNlIG1hcHBpbmddKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NFQzIvbGF0ZXN0L1VzZXJHdWlkZS9ibG9jay1kZXZpY2UtbWFwcGluZy1jb25jZXB0cy5odG1sI2Jsb2NrLWRldmljZS1tYXBwaW5nLWV4KSBpbiB0aGUgKkFtYXpvbiBFQzIgVXNlciBHdWlkZSBmb3IgTGludXggSW5zdGFuY2VzKiAuXG4gICAgICpcbiAgICAgKiBAc3RydWN0XG4gICAgICogQHN0YWJpbGl0eSBleHRlcm5hbFxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hdXRvc2NhbGluZy1sYXVuY2hjb25maWd1cmF0aW9uLWJsb2NrZGV2aWNlbWFwcGluZy5odG1sXG4gICAgICovXG4gICAgZXhwb3J0IGludGVyZmFjZSBCbG9ja0RldmljZU1hcHBpbmdQcm9wZXJ0eSB7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBUaGUgZGV2aWNlIG5hbWUgYXNzaWduZWQgdG8gdGhlIHZvbHVtZSAoZm9yIGV4YW1wbGUsIGAvZGV2L3NkaGAgb3IgYHh2ZGhgICkuIEZvciBtb3JlIGluZm9ybWF0aW9uLCBzZWUgW0RldmljZSBuYW1pbmcgb24gTGludXggaW5zdGFuY2VzXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTRUMyL2xhdGVzdC9Vc2VyR3VpZGUvZGV2aWNlX25hbWluZy5odG1sKSBpbiB0aGUgKkFtYXpvbiBFQzIgVXNlciBHdWlkZSBmb3IgTGludXggSW5zdGFuY2VzKiAuXG4gICAgICAgICAqXG4gICAgICAgICAqID4gVG8gZGVmaW5lIGEgYmxvY2sgZGV2aWNlIG1hcHBpbmcsIHNldCB0aGUgZGV2aWNlIG5hbWUgYW5kIGV4YWN0bHkgb25lIG9mIHRoZSBmb2xsb3dpbmcgcHJvcGVydGllczogYEVic2AgLCBgTm9EZXZpY2VgICwgb3IgYFZpcnR1YWxOYW1lYCAuXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXV0b3NjYWxpbmctbGF1bmNoY29uZmlndXJhdGlvbi1ibG9ja2RldmljZW1hcHBpbmcuaHRtbCNjZm4tYXV0b3NjYWxpbmctbGF1bmNoY29uZmlndXJhdGlvbi1ibG9ja2RldmljZW1hcHBpbmctZGV2aWNlbmFtZVxuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgZGV2aWNlTmFtZTogc3RyaW5nO1xuICAgICAgICAvKipcbiAgICAgICAgICogSW5mb3JtYXRpb24gdG8gYXR0YWNoIGFuIEVCUyB2b2x1bWUgdG8gYW4gaW5zdGFuY2UgYXQgbGF1bmNoLlxuICAgICAgICAgKlxuICAgICAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWF1dG9zY2FsaW5nLWxhdW5jaGNvbmZpZ3VyYXRpb24tYmxvY2tkZXZpY2VtYXBwaW5nLmh0bWwjY2ZuLWF1dG9zY2FsaW5nLWxhdW5jaGNvbmZpZ3VyYXRpb24tYmxvY2tkZXZpY2VtYXBwaW5nLWVic1xuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgZWJzPzogQ2ZuTGF1bmNoQ29uZmlndXJhdGlvbi5CbG9ja0RldmljZVByb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlO1xuICAgICAgICAvKipcbiAgICAgICAgICogU2V0dGluZyB0aGlzIHZhbHVlIHRvIGB0cnVlYCBwcmV2ZW50cyBhIHZvbHVtZSB0aGF0IGlzIGluY2x1ZGVkIGluIHRoZSBibG9jayBkZXZpY2UgbWFwcGluZyBvZiB0aGUgQU1JIGZyb20gYmVpbmcgbWFwcGVkIHRvIHRoZSBzcGVjaWZpZWQgZGV2aWNlIG5hbWUgYXQgbGF1bmNoLlxuICAgICAgICAgKlxuICAgICAgICAgKiBJZiBgTm9EZXZpY2VgIGlzIGB0cnVlYCBmb3IgdGhlIHJvb3QgZGV2aWNlLCBpbnN0YW5jZXMgbWlnaHQgZmFpbCB0aGUgRUMyIGhlYWx0aCBjaGVjay4gSW4gdGhhdCBjYXNlLCBBbWF6b24gRUMyIEF1dG8gU2NhbGluZyBsYXVuY2hlcyByZXBsYWNlbWVudCBpbnN0YW5jZXMuXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXV0b3NjYWxpbmctbGF1bmNoY29uZmlndXJhdGlvbi1ibG9ja2RldmljZW1hcHBpbmcuaHRtbCNjZm4tYXV0b3NjYWxpbmctbGF1bmNoY29uZmlndXJhdGlvbi1ibG9ja2RldmljZW1hcHBpbmctbm9kZXZpY2VcbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IG5vRGV2aWNlPzogYm9vbGVhbiB8IGNkay5JUmVzb2x2YWJsZTtcbiAgICAgICAgLyoqXG4gICAgICAgICAqIFRoZSBuYW1lIG9mIHRoZSBpbnN0YW5jZSBzdG9yZSB2b2x1bWUgKHZpcnR1YWwgZGV2aWNlKSB0byBhdHRhY2ggdG8gYW4gaW5zdGFuY2UgYXQgbGF1bmNoLiBUaGUgbmFtZSBtdXN0IGJlIGluIHRoZSBmb3JtIGVwaGVtZXJhbCAqWCogd2hlcmUgKlgqIGlzIGEgbnVtYmVyIHN0YXJ0aW5nIGZyb20gemVybyAoMCksIGZvciBleGFtcGxlLCBgZXBoZW1lcmFsMGAgLlxuICAgICAgICAgKlxuICAgICAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWF1dG9zY2FsaW5nLWxhdW5jaGNvbmZpZ3VyYXRpb24tYmxvY2tkZXZpY2VtYXBwaW5nLmh0bWwjY2ZuLWF1dG9zY2FsaW5nLWxhdW5jaGNvbmZpZ3VyYXRpb24tYmxvY2tkZXZpY2VtYXBwaW5nLXZpcnR1YWxuYW1lXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSB2aXJ0dWFsTmFtZT86IHN0cmluZztcbiAgICB9XG59XG5cbi8qKlxuICogRGV0ZXJtaW5lIHdoZXRoZXIgdGhlIGdpdmVuIHByb3BlcnRpZXMgbWF0Y2ggdGhvc2Ugb2YgYSBgQmxvY2tEZXZpY2VNYXBwaW5nUHJvcGVydHlgXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYEJsb2NrRGV2aWNlTWFwcGluZ1Byb3BlcnR5YFxuICpcbiAqIEByZXR1cm5zIHRoZSByZXN1bHQgb2YgdGhlIHZhbGlkYXRpb24uXG4gKi9cbmZ1bmN0aW9uIENmbkxhdW5jaENvbmZpZ3VyYXRpb25fQmxvY2tEZXZpY2VNYXBwaW5nUHJvcGVydHlWYWxpZGF0b3IocHJvcGVydGllczogYW55KTogY2RrLlZhbGlkYXRpb25SZXN1bHQge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIGNkay5WQUxJREFUSU9OX1NVQ0NFU1M7IH1cbiAgICBjb25zdCBlcnJvcnMgPSBuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHRzKCk7XG4gICAgaWYgKHR5cGVvZiBwcm9wZXJ0aWVzICE9PSAnb2JqZWN0Jykge1xuICAgICAgICBlcnJvcnMuY29sbGVjdChuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHQoJ0V4cGVjdGVkIGFuIG9iamVjdCwgYnV0IHJlY2VpdmVkOiAnICsgSlNPTi5zdHJpbmdpZnkocHJvcGVydGllcykpKTtcbiAgICB9XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdkZXZpY2VOYW1lJywgY2RrLnJlcXVpcmVkVmFsaWRhdG9yKShwcm9wZXJ0aWVzLmRldmljZU5hbWUpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2RldmljZU5hbWUnLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuZGV2aWNlTmFtZSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignZWJzJywgQ2ZuTGF1bmNoQ29uZmlndXJhdGlvbl9CbG9ja0RldmljZVByb3BlcnR5VmFsaWRhdG9yKShwcm9wZXJ0aWVzLmVicykpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignbm9EZXZpY2UnLCBjZGsudmFsaWRhdGVCb29sZWFuKShwcm9wZXJ0aWVzLm5vRGV2aWNlKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCd2aXJ0dWFsTmFtZScsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy52aXJ0dWFsTmFtZSkpO1xuICAgIHJldHVybiBlcnJvcnMud3JhcCgnc3VwcGxpZWQgcHJvcGVydGllcyBub3QgY29ycmVjdCBmb3IgXCJCbG9ja0RldmljZU1hcHBpbmdQcm9wZXJ0eVwiJyk7XG59XG5cbi8qKlxuICogUmVuZGVycyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6QXV0b1NjYWxpbmc6OkxhdW5jaENvbmZpZ3VyYXRpb24uQmxvY2tEZXZpY2VNYXBwaW5nYCByZXNvdXJjZVxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBCbG9ja0RldmljZU1hcHBpbmdQcm9wZXJ0eWBcbiAqXG4gKiBAcmV0dXJucyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6QXV0b1NjYWxpbmc6OkxhdW5jaENvbmZpZ3VyYXRpb24uQmxvY2tEZXZpY2VNYXBwaW5nYCByZXNvdXJjZS5cbiAqL1xuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIGNmbkxhdW5jaENvbmZpZ3VyYXRpb25CbG9ja0RldmljZU1hcHBpbmdQcm9wZXJ0eVRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogYW55IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBwcm9wZXJ0aWVzOyB9XG4gICAgQ2ZuTGF1bmNoQ29uZmlndXJhdGlvbl9CbG9ja0RldmljZU1hcHBpbmdQcm9wZXJ0eVZhbGlkYXRvcihwcm9wZXJ0aWVzKS5hc3NlcnRTdWNjZXNzKCk7XG4gICAgcmV0dXJuIHtcbiAgICAgICAgRGV2aWNlTmFtZTogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5kZXZpY2VOYW1lKSxcbiAgICAgICAgRWJzOiBjZm5MYXVuY2hDb25maWd1cmF0aW9uQmxvY2tEZXZpY2VQcm9wZXJ0eVRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5lYnMpLFxuICAgICAgICBOb0RldmljZTogY2RrLmJvb2xlYW5Ub0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMubm9EZXZpY2UpLFxuICAgICAgICBWaXJ0dWFsTmFtZTogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy52aXJ0dWFsTmFtZSksXG4gICAgfTtcbn1cblxuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIENmbkxhdW5jaENvbmZpZ3VyYXRpb25CbG9ja0RldmljZU1hcHBpbmdQcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0PENmbkxhdW5jaENvbmZpZ3VyYXRpb24uQmxvY2tEZXZpY2VNYXBwaW5nUHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGU+IHtcbiAgICBpZiAoY2RrLmlzUmVzb2x2YWJsZU9iamVjdChwcm9wZXJ0aWVzKSkge1xuICAgICAgICByZXR1cm4gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQocHJvcGVydGllcyk7XG4gICAgfVxuICAgIHByb3BlcnRpZXMgPSBwcm9wZXJ0aWVzID09IG51bGwgPyB7fSA6IHByb3BlcnRpZXM7XG4gICAgaWYgKHR5cGVvZiBwcm9wZXJ0aWVzICE9PSAnb2JqZWN0Jykge1xuICAgICAgICByZXR1cm4gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQocHJvcGVydGllcyk7XG4gICAgfVxuICAgIGNvbnN0IHJldCA9IG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUHJvcGVydHlPYmplY3Q8Q2ZuTGF1bmNoQ29uZmlndXJhdGlvbi5CbG9ja0RldmljZU1hcHBpbmdQcm9wZXJ0eT4oKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2RldmljZU5hbWUnLCAnRGV2aWNlTmFtZScsIGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuRGV2aWNlTmFtZSkpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnZWJzJywgJ0VicycsIHByb3BlcnRpZXMuRWJzICE9IG51bGwgPyBDZm5MYXVuY2hDb25maWd1cmF0aW9uQmxvY2tEZXZpY2VQcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLkVicykgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnbm9EZXZpY2UnLCAnTm9EZXZpY2UnLCBwcm9wZXJ0aWVzLk5vRGV2aWNlICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldEJvb2xlYW4ocHJvcGVydGllcy5Ob0RldmljZSkgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgndmlydHVhbE5hbWUnLCAnVmlydHVhbE5hbWUnLCBwcm9wZXJ0aWVzLlZpcnR1YWxOYW1lICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLlZpcnR1YWxOYW1lKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFVucmVjb2duaXplZFByb3BlcnRpZXNBc0V4dHJhKHByb3BlcnRpZXMpO1xuICAgIHJldHVybiByZXQ7XG59XG5cbmV4cG9ydCBuYW1lc3BhY2UgQ2ZuTGF1bmNoQ29uZmlndXJhdGlvbiB7XG4gICAgLyoqXG4gICAgICogYE1ldGFkYXRhT3B0aW9uc2AgaXMgYSBwcm9wZXJ0eSBvZiBbQVdTOjpBdXRvU2NhbGluZzo6TGF1bmNoQ29uZmlndXJhdGlvbl0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXMtbGF1bmNoY29uZmlnLmh0bWwpIHRoYXQgZGVzY3JpYmVzIG1ldGFkYXRhIG9wdGlvbnMgZm9yIHRoZSBpbnN0YW5jZXMuXG4gICAgICpcbiAgICAgKiBGb3IgbW9yZSBpbmZvcm1hdGlvbiwgc2VlIFtDb25maWd1cmUgdGhlIGluc3RhbmNlIG1ldGFkYXRhIG9wdGlvbnNdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9hdXRvc2NhbGluZy9lYzIvdXNlcmd1aWRlL2NyZWF0ZS1sYXVuY2gtY29uZmlnLmh0bWwjbGF1bmNoLWNvbmZpZ3VyYXRpb25zLWltZHMpIGluIHRoZSAqQW1hem9uIEVDMiBBdXRvIFNjYWxpbmcgVXNlciBHdWlkZSogLlxuICAgICAqXG4gICAgICogQHN0cnVjdFxuICAgICAqIEBzdGFiaWxpdHkgZXh0ZXJuYWxcbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXV0b3NjYWxpbmctbGF1bmNoY29uZmlndXJhdGlvbi1tZXRhZGF0YW9wdGlvbnMuaHRtbFxuICAgICAqL1xuICAgIGV4cG9ydCBpbnRlcmZhY2UgTWV0YWRhdGFPcHRpb25zUHJvcGVydHkge1xuICAgICAgICAvKipcbiAgICAgICAgICogVGhpcyBwYXJhbWV0ZXIgZW5hYmxlcyBvciBkaXNhYmxlcyB0aGUgSFRUUCBtZXRhZGF0YSBlbmRwb2ludCBvbiB5b3VyIGluc3RhbmNlcy4gSWYgdGhlIHBhcmFtZXRlciBpcyBub3Qgc3BlY2lmaWVkLCB0aGUgZGVmYXVsdCBzdGF0ZSBpcyBgZW5hYmxlZGAgLlxuICAgICAgICAgKlxuICAgICAgICAgKiA+IElmIHlvdSBzcGVjaWZ5IGEgdmFsdWUgb2YgYGRpc2FibGVkYCAsIHlvdSB3aWxsIG5vdCBiZSBhYmxlIHRvIGFjY2VzcyB5b3VyIGluc3RhbmNlIG1ldGFkYXRhLlxuICAgICAgICAgKlxuICAgICAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWF1dG9zY2FsaW5nLWxhdW5jaGNvbmZpZ3VyYXRpb24tbWV0YWRhdGFvcHRpb25zLmh0bWwjY2ZuLWF1dG9zY2FsaW5nLWxhdW5jaGNvbmZpZ3VyYXRpb24tbWV0YWRhdGFvcHRpb25zLWh0dHBlbmRwb2ludFxuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgaHR0cEVuZHBvaW50Pzogc3RyaW5nO1xuICAgICAgICAvKipcbiAgICAgICAgICogVGhlIGRlc2lyZWQgSFRUUCBQVVQgcmVzcG9uc2UgaG9wIGxpbWl0IGZvciBpbnN0YW5jZSBtZXRhZGF0YSByZXF1ZXN0cy4gVGhlIGxhcmdlciB0aGUgbnVtYmVyLCB0aGUgZnVydGhlciBpbnN0YW5jZSBtZXRhZGF0YSByZXF1ZXN0cyBjYW4gdHJhdmVsLlxuICAgICAgICAgKlxuICAgICAgICAgKiBEZWZhdWx0OiAxXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXV0b3NjYWxpbmctbGF1bmNoY29uZmlndXJhdGlvbi1tZXRhZGF0YW9wdGlvbnMuaHRtbCNjZm4tYXV0b3NjYWxpbmctbGF1bmNoY29uZmlndXJhdGlvbi1tZXRhZGF0YW9wdGlvbnMtaHR0cHB1dHJlc3BvbnNlaG9wbGltaXRcbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IGh0dHBQdXRSZXNwb25zZUhvcExpbWl0PzogbnVtYmVyO1xuICAgICAgICAvKipcbiAgICAgICAgICogVGhlIHN0YXRlIG9mIHRva2VuIHVzYWdlIGZvciB5b3VyIGluc3RhbmNlIG1ldGFkYXRhIHJlcXVlc3RzLiBJZiB0aGUgcGFyYW1ldGVyIGlzIG5vdCBzcGVjaWZpZWQgaW4gdGhlIHJlcXVlc3QsIHRoZSBkZWZhdWx0IHN0YXRlIGlzIGBvcHRpb25hbGAgLlxuICAgICAgICAgKlxuICAgICAgICAgKiBJZiB0aGUgc3RhdGUgaXMgYG9wdGlvbmFsYCAsIHlvdSBjYW4gY2hvb3NlIHRvIHJldHJpZXZlIGluc3RhbmNlIG1ldGFkYXRhIHdpdGggb3Igd2l0aG91dCBhIHNpZ25lZCB0b2tlbiBoZWFkZXIgb24geW91ciByZXF1ZXN0LiBJZiB5b3UgcmV0cmlldmUgdGhlIElBTSByb2xlIGNyZWRlbnRpYWxzIHdpdGhvdXQgYSB0b2tlbiwgdGhlIHZlcnNpb24gMS4wIHJvbGUgY3JlZGVudGlhbHMgYXJlIHJldHVybmVkLiBJZiB5b3UgcmV0cmlldmUgdGhlIElBTSByb2xlIGNyZWRlbnRpYWxzIHVzaW5nIGEgdmFsaWQgc2lnbmVkIHRva2VuLCB0aGUgdmVyc2lvbiAyLjAgcm9sZSBjcmVkZW50aWFscyBhcmUgcmV0dXJuZWQuXG4gICAgICAgICAqXG4gICAgICAgICAqIElmIHRoZSBzdGF0ZSBpcyBgcmVxdWlyZWRgICwgeW91IG11c3Qgc2VuZCBhIHNpZ25lZCB0b2tlbiBoZWFkZXIgd2l0aCBhbnkgaW5zdGFuY2UgbWV0YWRhdGEgcmV0cmlldmFsIHJlcXVlc3RzLiBJbiB0aGlzIHN0YXRlLCByZXRyaWV2aW5nIHRoZSBJQU0gcm9sZSBjcmVkZW50aWFscyBhbHdheXMgcmV0dXJucyB0aGUgdmVyc2lvbiAyLjAgY3JlZGVudGlhbHM7IHRoZSB2ZXJzaW9uIDEuMCBjcmVkZW50aWFscyBhcmUgbm90IGF2YWlsYWJsZS5cbiAgICAgICAgICpcbiAgICAgICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hdXRvc2NhbGluZy1sYXVuY2hjb25maWd1cmF0aW9uLW1ldGFkYXRhb3B0aW9ucy5odG1sI2Nmbi1hdXRvc2NhbGluZy1sYXVuY2hjb25maWd1cmF0aW9uLW1ldGFkYXRhb3B0aW9ucy1odHRwdG9rZW5zXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBodHRwVG9rZW5zPzogc3RyaW5nO1xuICAgIH1cbn1cblxuLyoqXG4gKiBEZXRlcm1pbmUgd2hldGhlciB0aGUgZ2l2ZW4gcHJvcGVydGllcyBtYXRjaCB0aG9zZSBvZiBhIGBNZXRhZGF0YU9wdGlvbnNQcm9wZXJ0eWBcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgTWV0YWRhdGFPcHRpb25zUHJvcGVydHlgXG4gKlxuICogQHJldHVybnMgdGhlIHJlc3VsdCBvZiB0aGUgdmFsaWRhdGlvbi5cbiAqL1xuZnVuY3Rpb24gQ2ZuTGF1bmNoQ29uZmlndXJhdGlvbl9NZXRhZGF0YU9wdGlvbnNQcm9wZXJ0eVZhbGlkYXRvcihwcm9wZXJ0aWVzOiBhbnkpOiBjZGsuVmFsaWRhdGlvblJlc3VsdCB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gY2RrLlZBTElEQVRJT05fU1VDQ0VTUzsgfVxuICAgIGNvbnN0IGVycm9ycyA9IG5ldyBjZGsuVmFsaWRhdGlvblJlc3VsdHMoKTtcbiAgICBpZiAodHlwZW9mIHByb3BlcnRpZXMgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIGVycm9ycy5jb2xsZWN0KG5ldyBjZGsuVmFsaWRhdGlvblJlc3VsdCgnRXhwZWN0ZWQgYW4gb2JqZWN0LCBidXQgcmVjZWl2ZWQ6ICcgKyBKU09OLnN0cmluZ2lmeShwcm9wZXJ0aWVzKSkpO1xuICAgIH1cbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2h0dHBFbmRwb2ludCcsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5odHRwRW5kcG9pbnQpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2h0dHBQdXRSZXNwb25zZUhvcExpbWl0JywgY2RrLnZhbGlkYXRlTnVtYmVyKShwcm9wZXJ0aWVzLmh0dHBQdXRSZXNwb25zZUhvcExpbWl0KSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdodHRwVG9rZW5zJywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmh0dHBUb2tlbnMpKTtcbiAgICByZXR1cm4gZXJyb3JzLndyYXAoJ3N1cHBsaWVkIHByb3BlcnRpZXMgbm90IGNvcnJlY3QgZm9yIFwiTWV0YWRhdGFPcHRpb25zUHJvcGVydHlcIicpO1xufVxuXG4vKipcbiAqIFJlbmRlcnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OkF1dG9TY2FsaW5nOjpMYXVuY2hDb25maWd1cmF0aW9uLk1ldGFkYXRhT3B0aW9uc2AgcmVzb3VyY2VcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgTWV0YWRhdGFPcHRpb25zUHJvcGVydHlgXG4gKlxuICogQHJldHVybnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OkF1dG9TY2FsaW5nOjpMYXVuY2hDb25maWd1cmF0aW9uLk1ldGFkYXRhT3B0aW9uc2AgcmVzb3VyY2UuXG4gKi9cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBjZm5MYXVuY2hDb25maWd1cmF0aW9uTWV0YWRhdGFPcHRpb25zUHJvcGVydHlUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGFueSB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gcHJvcGVydGllczsgfVxuICAgIENmbkxhdW5jaENvbmZpZ3VyYXRpb25fTWV0YWRhdGFPcHRpb25zUHJvcGVydHlWYWxpZGF0b3IocHJvcGVydGllcykuYXNzZXJ0U3VjY2VzcygpO1xuICAgIHJldHVybiB7XG4gICAgICAgIEh0dHBFbmRwb2ludDogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5odHRwRW5kcG9pbnQpLFxuICAgICAgICBIdHRwUHV0UmVzcG9uc2VIb3BMaW1pdDogY2RrLm51bWJlclRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5odHRwUHV0UmVzcG9uc2VIb3BMaW1pdCksXG4gICAgICAgIEh0dHBUb2tlbnM6IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuaHR0cFRva2VucyksXG4gICAgfTtcbn1cblxuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIENmbkxhdW5jaENvbmZpZ3VyYXRpb25NZXRhZGF0YU9wdGlvbnNQcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0PENmbkxhdW5jaENvbmZpZ3VyYXRpb24uTWV0YWRhdGFPcHRpb25zUHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGU+IHtcbiAgICBpZiAoY2RrLmlzUmVzb2x2YWJsZU9iamVjdChwcm9wZXJ0aWVzKSkge1xuICAgICAgICByZXR1cm4gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQocHJvcGVydGllcyk7XG4gICAgfVxuICAgIHByb3BlcnRpZXMgPSBwcm9wZXJ0aWVzID09IG51bGwgPyB7fSA6IHByb3BlcnRpZXM7XG4gICAgaWYgKHR5cGVvZiBwcm9wZXJ0aWVzICE9PSAnb2JqZWN0Jykge1xuICAgICAgICByZXR1cm4gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQocHJvcGVydGllcyk7XG4gICAgfVxuICAgIGNvbnN0IHJldCA9IG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUHJvcGVydHlPYmplY3Q8Q2ZuTGF1bmNoQ29uZmlndXJhdGlvbi5NZXRhZGF0YU9wdGlvbnNQcm9wZXJ0eT4oKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2h0dHBFbmRwb2ludCcsICdIdHRwRW5kcG9pbnQnLCBwcm9wZXJ0aWVzLkh0dHBFbmRwb2ludCAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5IdHRwRW5kcG9pbnQpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2h0dHBQdXRSZXNwb25zZUhvcExpbWl0JywgJ0h0dHBQdXRSZXNwb25zZUhvcExpbWl0JywgcHJvcGVydGllcy5IdHRwUHV0UmVzcG9uc2VIb3BMaW1pdCAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXROdW1iZXIocHJvcGVydGllcy5IdHRwUHV0UmVzcG9uc2VIb3BMaW1pdCkgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnaHR0cFRva2VucycsICdIdHRwVG9rZW5zJywgcHJvcGVydGllcy5IdHRwVG9rZW5zICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLkh0dHBUb2tlbnMpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkVW5yZWNvZ25pemVkUHJvcGVydGllc0FzRXh0cmEocHJvcGVydGllcyk7XG4gICAgcmV0dXJuIHJldDtcbn1cblxuLyoqXG4gKiBQcm9wZXJ0aWVzIGZvciBkZWZpbmluZyBhIGBDZm5MaWZlY3ljbGVIb29rYFxuICpcbiAqIEBzdHJ1Y3RcbiAqIEBzdGFiaWxpdHkgZXh0ZXJuYWxcbiAqXG4gKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1hdXRvc2NhbGluZy1saWZlY3ljbGVob29rLmh0bWxcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBDZm5MaWZlY3ljbGVIb29rUHJvcHMge1xuXG4gICAgLyoqXG4gICAgICogVGhlIG5hbWUgb2YgdGhlIEF1dG8gU2NhbGluZyBncm91cC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWF1dG9zY2FsaW5nLWxpZmVjeWNsZWhvb2suaHRtbCNjZm4tYXV0b3NjYWxpbmctbGlmZWN5Y2xlaG9vay1hdXRvc2NhbGluZ2dyb3VwbmFtZVxuICAgICAqL1xuICAgIHJlYWRvbmx5IGF1dG9TY2FsaW5nR3JvdXBOYW1lOiBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgbGlmZWN5Y2xlIHRyYW5zaXRpb24uIEZvciBBdXRvIFNjYWxpbmcgZ3JvdXBzLCB0aGVyZSBhcmUgdHdvIG1ham9yIGxpZmVjeWNsZSB0cmFuc2l0aW9ucy5cbiAgICAgKlxuICAgICAqIC0gVG8gY3JlYXRlIGEgbGlmZWN5Y2xlIGhvb2sgZm9yIHNjYWxlLW91dCBldmVudHMsIHNwZWNpZnkgYGF1dG9zY2FsaW5nOkVDMl9JTlNUQU5DRV9MQVVOQ0hJTkdgIC5cbiAgICAgKiAtIFRvIGNyZWF0ZSBhIGxpZmVjeWNsZSBob29rIGZvciBzY2FsZS1pbiBldmVudHMsIHNwZWNpZnkgYGF1dG9zY2FsaW5nOkVDMl9JTlNUQU5DRV9URVJNSU5BVElOR2AgLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtYXV0b3NjYWxpbmctbGlmZWN5Y2xlaG9vay5odG1sI2Nmbi1hdXRvc2NhbGluZy1saWZlY3ljbGVob29rLWxpZmVjeWNsZXRyYW5zaXRpb25cbiAgICAgKi9cbiAgICByZWFkb25seSBsaWZlY3ljbGVUcmFuc2l0aW9uOiBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgYWN0aW9uIHRoZSBBdXRvIFNjYWxpbmcgZ3JvdXAgdGFrZXMgd2hlbiB0aGUgbGlmZWN5Y2xlIGhvb2sgdGltZW91dCBlbGFwc2VzIG9yIGlmIGFuIHVuZXhwZWN0ZWQgZmFpbHVyZSBvY2N1cnMuIFRoZSBkZWZhdWx0IHZhbHVlIGlzIGBBQkFORE9OYCAuXG4gICAgICpcbiAgICAgKiBWYWxpZCB2YWx1ZXM6IGBDT05USU5VRWAgfCBgQUJBTkRPTmBcbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWF1dG9zY2FsaW5nLWxpZmVjeWNsZWhvb2suaHRtbCNjZm4tYXV0b3NjYWxpbmctbGlmZWN5Y2xlaG9vay1kZWZhdWx0cmVzdWx0XG4gICAgICovXG4gICAgcmVhZG9ubHkgZGVmYXVsdFJlc3VsdD86IHN0cmluZztcblxuICAgIC8qKlxuICAgICAqIFRoZSBtYXhpbXVtIHRpbWUsIGluIHNlY29uZHMsIHRoYXQgY2FuIGVsYXBzZSBiZWZvcmUgdGhlIGxpZmVjeWNsZSBob29rIHRpbWVzIG91dC4gVGhlIHJhbmdlIGlzIGZyb20gYDMwYCB0byBgNzIwMGAgc2Vjb25kcy4gVGhlIGRlZmF1bHQgdmFsdWUgaXMgYDM2MDBgIHNlY29uZHMgKDEgaG91cikuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1hdXRvc2NhbGluZy1saWZlY3ljbGVob29rLmh0bWwjY2ZuLWF1dG9zY2FsaW5nLWxpZmVjeWNsZWhvb2staGVhcnRiZWF0dGltZW91dFxuICAgICAqL1xuICAgIHJlYWRvbmx5IGhlYXJ0YmVhdFRpbWVvdXQ/OiBudW1iZXI7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgbmFtZSBvZiB0aGUgbGlmZWN5Y2xlIGhvb2suXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1hdXRvc2NhbGluZy1saWZlY3ljbGVob29rLmh0bWwjY2ZuLWF1dG9zY2FsaW5nLWxpZmVjeWNsZWhvb2stbGlmZWN5Y2xlaG9va25hbWVcbiAgICAgKi9cbiAgICByZWFkb25seSBsaWZlY3ljbGVIb29rTmFtZT86IHN0cmluZztcblxuICAgIC8qKlxuICAgICAqIEFkZGl0aW9uYWwgaW5mb3JtYXRpb24gdGhhdCB5b3Ugd2FudCB0byBpbmNsdWRlIGFueSB0aW1lIEFtYXpvbiBFQzIgQXV0byBTY2FsaW5nIHNlbmRzIGEgbWVzc2FnZSB0byB0aGUgbm90aWZpY2F0aW9uIHRhcmdldC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWF1dG9zY2FsaW5nLWxpZmVjeWNsZWhvb2suaHRtbCNjZm4tYXV0b3NjYWxpbmctbGlmZWN5Y2xlaG9vay1ub3RpZmljYXRpb25tZXRhZGF0YVxuICAgICAqL1xuICAgIHJlYWRvbmx5IG5vdGlmaWNhdGlvbk1ldGFkYXRhPzogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogVGhlIEFtYXpvbiBSZXNvdXJjZSBOYW1lIChBUk4pIG9mIHRoZSBub3RpZmljYXRpb24gdGFyZ2V0IHRoYXQgQW1hem9uIEVDMiBBdXRvIFNjYWxpbmcgc2VuZHMgbm90aWZpY2F0aW9ucyB0byB3aGVuIGFuIGluc3RhbmNlIGlzIGluIGEgd2FpdCBzdGF0ZSBmb3IgdGhlIGxpZmVjeWNsZSBob29rLiBZb3UgY2FuIHNwZWNpZnkgYW4gQW1hem9uIFNOUyB0b3BpYyBvciBhbiBBbWF6b24gU1FTIHF1ZXVlLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtYXV0b3NjYWxpbmctbGlmZWN5Y2xlaG9vay5odG1sI2Nmbi1hdXRvc2NhbGluZy1saWZlY3ljbGVob29rLW5vdGlmaWNhdGlvbnRhcmdldGFyblxuICAgICAqL1xuICAgIHJlYWRvbmx5IG5vdGlmaWNhdGlvblRhcmdldEFybj86IHN0cmluZztcblxuICAgIC8qKlxuICAgICAqIFRoZSBBUk4gb2YgdGhlIElBTSByb2xlIHRoYXQgYWxsb3dzIHRoZSBBdXRvIFNjYWxpbmcgZ3JvdXAgdG8gcHVibGlzaCB0byB0aGUgc3BlY2lmaWVkIG5vdGlmaWNhdGlvbiB0YXJnZXQuIEZvciBpbmZvcm1hdGlvbiBhYm91dCBjcmVhdGluZyB0aGlzIHJvbGUsIHNlZSBbQ29uZmlndXJlIGEgbm90aWZpY2F0aW9uIHRhcmdldCBmb3IgYSBsaWZlY3ljbGUgaG9va10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2F1dG9zY2FsaW5nL2VjMi91c2VyZ3VpZGUvcHJlcGFyZS1mb3ItbGlmZWN5Y2xlLW5vdGlmaWNhdGlvbnMuaHRtbCNsaWZlY3ljbGUtaG9vay1ub3RpZmljYXRpb24tdGFyZ2V0KSBpbiB0aGUgKkFtYXpvbiBFQzIgQXV0byBTY2FsaW5nIFVzZXIgR3VpZGUqIC5cbiAgICAgKlxuICAgICAqIFZhbGlkIG9ubHkgaWYgdGhlIG5vdGlmaWNhdGlvbiB0YXJnZXQgaXMgYW4gQW1hem9uIFNOUyB0b3BpYyBvciBhbiBBbWF6b24gU1FTIHF1ZXVlLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtYXV0b3NjYWxpbmctbGlmZWN5Y2xlaG9vay5odG1sI2Nmbi1hdXRvc2NhbGluZy1saWZlY3ljbGVob29rLXJvbGVhcm5cbiAgICAgKi9cbiAgICByZWFkb25seSByb2xlQXJuPzogc3RyaW5nO1xufVxuXG4vKipcbiAqIERldGVybWluZSB3aGV0aGVyIHRoZSBnaXZlbiBwcm9wZXJ0aWVzIG1hdGNoIHRob3NlIG9mIGEgYENmbkxpZmVjeWNsZUhvb2tQcm9wc2BcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgQ2ZuTGlmZWN5Y2xlSG9va1Byb3BzYFxuICpcbiAqIEByZXR1cm5zIHRoZSByZXN1bHQgb2YgdGhlIHZhbGlkYXRpb24uXG4gKi9cbmZ1bmN0aW9uIENmbkxpZmVjeWNsZUhvb2tQcm9wc1ZhbGlkYXRvcihwcm9wZXJ0aWVzOiBhbnkpOiBjZGsuVmFsaWRhdGlvblJlc3VsdCB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gY2RrLlZBTElEQVRJT05fU1VDQ0VTUzsgfVxuICAgIGNvbnN0IGVycm9ycyA9IG5ldyBjZGsuVmFsaWRhdGlvblJlc3VsdHMoKTtcbiAgICBpZiAodHlwZW9mIHByb3BlcnRpZXMgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIGVycm9ycy5jb2xsZWN0KG5ldyBjZGsuVmFsaWRhdGlvblJlc3VsdCgnRXhwZWN0ZWQgYW4gb2JqZWN0LCBidXQgcmVjZWl2ZWQ6ICcgKyBKU09OLnN0cmluZ2lmeShwcm9wZXJ0aWVzKSkpO1xuICAgIH1cbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2F1dG9TY2FsaW5nR3JvdXBOYW1lJywgY2RrLnJlcXVpcmVkVmFsaWRhdG9yKShwcm9wZXJ0aWVzLmF1dG9TY2FsaW5nR3JvdXBOYW1lKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdhdXRvU2NhbGluZ0dyb3VwTmFtZScsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5hdXRvU2NhbGluZ0dyb3VwTmFtZSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignZGVmYXVsdFJlc3VsdCcsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5kZWZhdWx0UmVzdWx0KSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdoZWFydGJlYXRUaW1lb3V0JywgY2RrLnZhbGlkYXRlTnVtYmVyKShwcm9wZXJ0aWVzLmhlYXJ0YmVhdFRpbWVvdXQpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2xpZmVjeWNsZUhvb2tOYW1lJywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmxpZmVjeWNsZUhvb2tOYW1lKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdsaWZlY3ljbGVUcmFuc2l0aW9uJywgY2RrLnJlcXVpcmVkVmFsaWRhdG9yKShwcm9wZXJ0aWVzLmxpZmVjeWNsZVRyYW5zaXRpb24pKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2xpZmVjeWNsZVRyYW5zaXRpb24nLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMubGlmZWN5Y2xlVHJhbnNpdGlvbikpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignbm90aWZpY2F0aW9uTWV0YWRhdGEnLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMubm90aWZpY2F0aW9uTWV0YWRhdGEpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ25vdGlmaWNhdGlvblRhcmdldEFybicsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5ub3RpZmljYXRpb25UYXJnZXRBcm4pKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3JvbGVBcm4nLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMucm9sZUFybikpO1xuICAgIHJldHVybiBlcnJvcnMud3JhcCgnc3VwcGxpZWQgcHJvcGVydGllcyBub3QgY29ycmVjdCBmb3IgXCJDZm5MaWZlY3ljbGVIb29rUHJvcHNcIicpO1xufVxuXG4vKipcbiAqIFJlbmRlcnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OkF1dG9TY2FsaW5nOjpMaWZlY3ljbGVIb29rYCByZXNvdXJjZVxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBDZm5MaWZlY3ljbGVIb29rUHJvcHNgXG4gKlxuICogQHJldHVybnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OkF1dG9TY2FsaW5nOjpMaWZlY3ljbGVIb29rYCByZXNvdXJjZS5cbiAqL1xuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIGNmbkxpZmVjeWNsZUhvb2tQcm9wc1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogYW55IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBwcm9wZXJ0aWVzOyB9XG4gICAgQ2ZuTGlmZWN5Y2xlSG9va1Byb3BzVmFsaWRhdG9yKHByb3BlcnRpZXMpLmFzc2VydFN1Y2Nlc3MoKTtcbiAgICByZXR1cm4ge1xuICAgICAgICBBdXRvU2NhbGluZ0dyb3VwTmFtZTogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5hdXRvU2NhbGluZ0dyb3VwTmFtZSksXG4gICAgICAgIExpZmVjeWNsZVRyYW5zaXRpb246IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMubGlmZWN5Y2xlVHJhbnNpdGlvbiksXG4gICAgICAgIERlZmF1bHRSZXN1bHQ6IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuZGVmYXVsdFJlc3VsdCksXG4gICAgICAgIEhlYXJ0YmVhdFRpbWVvdXQ6IGNkay5udW1iZXJUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuaGVhcnRiZWF0VGltZW91dCksXG4gICAgICAgIExpZmVjeWNsZUhvb2tOYW1lOiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLmxpZmVjeWNsZUhvb2tOYW1lKSxcbiAgICAgICAgTm90aWZpY2F0aW9uTWV0YWRhdGE6IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMubm90aWZpY2F0aW9uTWV0YWRhdGEpLFxuICAgICAgICBOb3RpZmljYXRpb25UYXJnZXRBUk46IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMubm90aWZpY2F0aW9uVGFyZ2V0QXJuKSxcbiAgICAgICAgUm9sZUFSTjogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5yb2xlQXJuKSxcbiAgICB9O1xufVxuXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gQ2ZuTGlmZWN5Y2xlSG9va1Byb3BzRnJvbUNsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQ8Q2ZuTGlmZWN5Y2xlSG9va1Byb3BzPiB7XG4gICAgcHJvcGVydGllcyA9IHByb3BlcnRpZXMgPT0gbnVsbCA/IHt9IDogcHJvcGVydGllcztcbiAgICBpZiAodHlwZW9mIHByb3BlcnRpZXMgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIHJldHVybiBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdChwcm9wZXJ0aWVzKTtcbiAgICB9XG4gICAgY29uc3QgcmV0ID0gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25Qcm9wZXJ0eU9iamVjdDxDZm5MaWZlY3ljbGVIb29rUHJvcHM+KCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdhdXRvU2NhbGluZ0dyb3VwTmFtZScsICdBdXRvU2NhbGluZ0dyb3VwTmFtZScsIGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuQXV0b1NjYWxpbmdHcm91cE5hbWUpKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2xpZmVjeWNsZVRyYW5zaXRpb24nLCAnTGlmZWN5Y2xlVHJhbnNpdGlvbicsIGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuTGlmZWN5Y2xlVHJhbnNpdGlvbikpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnZGVmYXVsdFJlc3VsdCcsICdEZWZhdWx0UmVzdWx0JywgcHJvcGVydGllcy5EZWZhdWx0UmVzdWx0ICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLkRlZmF1bHRSZXN1bHQpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2hlYXJ0YmVhdFRpbWVvdXQnLCAnSGVhcnRiZWF0VGltZW91dCcsIHByb3BlcnRpZXMuSGVhcnRiZWF0VGltZW91dCAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXROdW1iZXIocHJvcGVydGllcy5IZWFydGJlYXRUaW1lb3V0KSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdsaWZlY3ljbGVIb29rTmFtZScsICdMaWZlY3ljbGVIb29rTmFtZScsIHByb3BlcnRpZXMuTGlmZWN5Y2xlSG9va05hbWUgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuTGlmZWN5Y2xlSG9va05hbWUpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ25vdGlmaWNhdGlvbk1ldGFkYXRhJywgJ05vdGlmaWNhdGlvbk1ldGFkYXRhJywgcHJvcGVydGllcy5Ob3RpZmljYXRpb25NZXRhZGF0YSAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5Ob3RpZmljYXRpb25NZXRhZGF0YSkgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnbm90aWZpY2F0aW9uVGFyZ2V0QXJuJywgJ05vdGlmaWNhdGlvblRhcmdldEFSTicsIHByb3BlcnRpZXMuTm90aWZpY2F0aW9uVGFyZ2V0QVJOICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLk5vdGlmaWNhdGlvblRhcmdldEFSTikgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgncm9sZUFybicsICdSb2xlQVJOJywgcHJvcGVydGllcy5Sb2xlQVJOICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLlJvbGVBUk4pIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkVW5yZWNvZ25pemVkUHJvcGVydGllc0FzRXh0cmEocHJvcGVydGllcyk7XG4gICAgcmV0dXJuIHJldDtcbn1cblxuLyoqXG4gKiBBIENsb3VkRm9ybWF0aW9uIGBBV1M6OkF1dG9TY2FsaW5nOjpMaWZlY3ljbGVIb29rYFxuICpcbiAqIFRoZSBgQVdTOjpBdXRvU2NhbGluZzo6TGlmZWN5Y2xlSG9va2AgcmVzb3VyY2Ugc3BlY2lmaWVzIGxpZmVjeWNsZSBob29rcyBmb3IgYW4gQXV0byBTY2FsaW5nIGdyb3VwLiBUaGVzZSBob29rcyBsZXQgeW91IGNyZWF0ZSBzb2x1dGlvbnMgdGhhdCBhcmUgYXdhcmUgb2YgZXZlbnRzIGluIHRoZSBBdXRvIFNjYWxpbmcgaW5zdGFuY2UgbGlmZWN5Y2xlLCBhbmQgdGhlbiBwZXJmb3JtIGEgY3VzdG9tIGFjdGlvbiBvbiBpbnN0YW5jZXMgd2hlbiB0aGUgY29ycmVzcG9uZGluZyBsaWZlY3ljbGUgZXZlbnQgb2NjdXJzLiBBIGxpZmVjeWNsZSBob29rIHByb3ZpZGVzIGEgc3BlY2lmaWVkIGFtb3VudCBvZiB0aW1lIChvbmUgaG91ciBieSBkZWZhdWx0KSB0byB3YWl0IGZvciB0aGUgYWN0aW9uIHRvIGNvbXBsZXRlIGJlZm9yZSB0aGUgaW5zdGFuY2UgdHJhbnNpdGlvbnMgdG8gdGhlIG5leHQgc3RhdGUuXG4gKlxuICogVXNlIGxpZmVjeWNsZSBob29rcyB0byBwcmVwYXJlIG5ldyBpbnN0YW5jZXMgZm9yIHVzZSBvciB0byBkZWxheSB0aGVtIGZyb20gYmVpbmcgcmVnaXN0ZXJlZCBiZWhpbmQgYSBsb2FkIGJhbGFuY2VyIGJlZm9yZSB0aGVpciBjb25maWd1cmF0aW9uIGhhcyBiZWVuIGFwcGxpZWQgY29tcGxldGVseS4gWW91IGNhbiBhbHNvIHVzZSBsaWZlY3ljbGUgaG9va3MgdG8gcHJlcGFyZSBydW5uaW5nIGluc3RhbmNlcyB0byBiZSB0ZXJtaW5hdGVkIGJ5LCBmb3IgZXhhbXBsZSwgZG93bmxvYWRpbmcgbG9ncyBvciBvdGhlciBkYXRhLlxuICpcbiAqIEZvciBtb3JlIGluZm9ybWF0aW9uLCBzZWUgW0FtYXpvbiBFQzIgQXV0byBTY2FsaW5nIGxpZmVjeWNsZSBob29rc10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2F1dG9zY2FsaW5nL2VjMi91c2VyZ3VpZGUvbGlmZWN5Y2xlLWhvb2tzLmh0bWwpIGluIHRoZSAqQW1hem9uIEVDMiBBdXRvIFNjYWxpbmcgVXNlciBHdWlkZSogLlxuICpcbiAqIEBjbG91ZGZvcm1hdGlvblJlc291cmNlIEFXUzo6QXV0b1NjYWxpbmc6OkxpZmVjeWNsZUhvb2tcbiAqIEBzdGFiaWxpdHkgZXh0ZXJuYWxcbiAqXG4gKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1hdXRvc2NhbGluZy1saWZlY3ljbGVob29rLmh0bWxcbiAqL1xuZXhwb3J0IGNsYXNzIENmbkxpZmVjeWNsZUhvb2sgZXh0ZW5kcyBjZGsuQ2ZuUmVzb3VyY2UgaW1wbGVtZW50cyBjZGsuSUluc3BlY3RhYmxlIHtcbiAgICAvKipcbiAgICAgKiBUaGUgQ2xvdWRGb3JtYXRpb24gcmVzb3VyY2UgdHlwZSBuYW1lIGZvciB0aGlzIHJlc291cmNlIGNsYXNzLlxuICAgICAqL1xuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgQ0ZOX1JFU09VUkNFX1RZUEVfTkFNRSA9IFwiQVdTOjpBdXRvU2NhbGluZzo6TGlmZWN5Y2xlSG9va1wiO1xuXG4gICAgLyoqXG4gICAgICogQSBmYWN0b3J5IG1ldGhvZCB0aGF0IGNyZWF0ZXMgYSBuZXcgaW5zdGFuY2Ugb2YgdGhpcyBjbGFzcyBmcm9tIGFuIG9iamVjdFxuICAgICAqIGNvbnRhaW5pbmcgdGhlIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgdGhpcyByZXNvdXJjZS5cbiAgICAgKiBVc2VkIGluIHRoZSBAYXdzLWNkay9jbG91ZGZvcm1hdGlvbi1pbmNsdWRlIG1vZHVsZS5cbiAgICAgKlxuICAgICAqIEBpbnRlcm5hbFxuICAgICAqL1xuICAgIHB1YmxpYyBzdGF0aWMgX2Zyb21DbG91ZEZvcm1hdGlvbihzY29wZTogY2RrLkNvbnN0cnVjdCwgaWQ6IHN0cmluZywgcmVzb3VyY2VBdHRyaWJ1dGVzOiBhbnksIG9wdGlvbnM6IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25PcHRpb25zKTogQ2ZuTGlmZWN5Y2xlSG9vayB7XG4gICAgICAgIHJlc291cmNlQXR0cmlidXRlcyA9IHJlc291cmNlQXR0cmlidXRlcyB8fCB7fTtcbiAgICAgICAgY29uc3QgcmVzb3VyY2VQcm9wZXJ0aWVzID0gb3B0aW9ucy5wYXJzZXIucGFyc2VWYWx1ZShyZXNvdXJjZUF0dHJpYnV0ZXMuUHJvcGVydGllcyk7XG4gICAgICAgIGNvbnN0IHByb3BzUmVzdWx0ID0gQ2ZuTGlmZWN5Y2xlSG9va1Byb3BzRnJvbUNsb3VkRm9ybWF0aW9uKHJlc291cmNlUHJvcGVydGllcyk7XG4gICAgICAgIGNvbnN0IHJldCA9IG5ldyBDZm5MaWZlY3ljbGVIb29rKHNjb3BlLCBpZCwgcHJvcHNSZXN1bHQudmFsdWUpO1xuICAgICAgICBmb3IgKGNvbnN0IFtwcm9wS2V5LCBwcm9wVmFsXSBvZiBPYmplY3QuZW50cmllcyhwcm9wc1Jlc3VsdC5leHRyYVByb3BlcnRpZXMpKSAge1xuICAgICAgICAgICAgcmV0LmFkZFByb3BlcnR5T3ZlcnJpZGUocHJvcEtleSwgcHJvcFZhbCk7XG4gICAgICAgIH1cbiAgICAgICAgb3B0aW9ucy5wYXJzZXIuaGFuZGxlQXR0cmlidXRlcyhyZXQsIHJlc291cmNlQXR0cmlidXRlcywgaWQpO1xuICAgICAgICByZXR1cm4gcmV0O1xuICAgIH1cblxuICAgIC8qKlxuICAgICAqIFRoZSBuYW1lIG9mIHRoZSBBdXRvIFNjYWxpbmcgZ3JvdXAuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1hdXRvc2NhbGluZy1saWZlY3ljbGVob29rLmh0bWwjY2ZuLWF1dG9zY2FsaW5nLWxpZmVjeWNsZWhvb2stYXV0b3NjYWxpbmdncm91cG5hbWVcbiAgICAgKi9cbiAgICBwdWJsaWMgYXV0b1NjYWxpbmdHcm91cE5hbWU6IHN0cmluZztcblxuICAgIC8qKlxuICAgICAqIFRoZSBsaWZlY3ljbGUgdHJhbnNpdGlvbi4gRm9yIEF1dG8gU2NhbGluZyBncm91cHMsIHRoZXJlIGFyZSB0d28gbWFqb3IgbGlmZWN5Y2xlIHRyYW5zaXRpb25zLlxuICAgICAqXG4gICAgICogLSBUbyBjcmVhdGUgYSBsaWZlY3ljbGUgaG9vayBmb3Igc2NhbGUtb3V0IGV2ZW50cywgc3BlY2lmeSBgYXV0b3NjYWxpbmc6RUMyX0lOU1RBTkNFX0xBVU5DSElOR2AgLlxuICAgICAqIC0gVG8gY3JlYXRlIGEgbGlmZWN5Y2xlIGhvb2sgZm9yIHNjYWxlLWluIGV2ZW50cywgc3BlY2lmeSBgYXV0b3NjYWxpbmc6RUMyX0lOU1RBTkNFX1RFUk1JTkFUSU5HYCAuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1hdXRvc2NhbGluZy1saWZlY3ljbGVob29rLmh0bWwjY2ZuLWF1dG9zY2FsaW5nLWxpZmVjeWNsZWhvb2stbGlmZWN5Y2xldHJhbnNpdGlvblxuICAgICAqL1xuICAgIHB1YmxpYyBsaWZlY3ljbGVUcmFuc2l0aW9uOiBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgYWN0aW9uIHRoZSBBdXRvIFNjYWxpbmcgZ3JvdXAgdGFrZXMgd2hlbiB0aGUgbGlmZWN5Y2xlIGhvb2sgdGltZW91dCBlbGFwc2VzIG9yIGlmIGFuIHVuZXhwZWN0ZWQgZmFpbHVyZSBvY2N1cnMuIFRoZSBkZWZhdWx0IHZhbHVlIGlzIGBBQkFORE9OYCAuXG4gICAgICpcbiAgICAgKiBWYWxpZCB2YWx1ZXM6IGBDT05USU5VRWAgfCBgQUJBTkRPTmBcbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWF1dG9zY2FsaW5nLWxpZmVjeWNsZWhvb2suaHRtbCNjZm4tYXV0b3NjYWxpbmctbGlmZWN5Y2xlaG9vay1kZWZhdWx0cmVzdWx0XG4gICAgICovXG4gICAgcHVibGljIGRlZmF1bHRSZXN1bHQ6IHN0cmluZyB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIFRoZSBtYXhpbXVtIHRpbWUsIGluIHNlY29uZHMsIHRoYXQgY2FuIGVsYXBzZSBiZWZvcmUgdGhlIGxpZmVjeWNsZSBob29rIHRpbWVzIG91dC4gVGhlIHJhbmdlIGlzIGZyb20gYDMwYCB0byBgNzIwMGAgc2Vjb25kcy4gVGhlIGRlZmF1bHQgdmFsdWUgaXMgYDM2MDBgIHNlY29uZHMgKDEgaG91cikuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1hdXRvc2NhbGluZy1saWZlY3ljbGVob29rLmh0bWwjY2ZuLWF1dG9zY2FsaW5nLWxpZmVjeWNsZWhvb2staGVhcnRiZWF0dGltZW91dFxuICAgICAqL1xuICAgIHB1YmxpYyBoZWFydGJlYXRUaW1lb3V0OiBudW1iZXIgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgbmFtZSBvZiB0aGUgbGlmZWN5Y2xlIGhvb2suXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1hdXRvc2NhbGluZy1saWZlY3ljbGVob29rLmh0bWwjY2ZuLWF1dG9zY2FsaW5nLWxpZmVjeWNsZWhvb2stbGlmZWN5Y2xlaG9va25hbWVcbiAgICAgKi9cbiAgICBwdWJsaWMgbGlmZWN5Y2xlSG9va05hbWU6IHN0cmluZyB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIEFkZGl0aW9uYWwgaW5mb3JtYXRpb24gdGhhdCB5b3Ugd2FudCB0byBpbmNsdWRlIGFueSB0aW1lIEFtYXpvbiBFQzIgQXV0byBTY2FsaW5nIHNlbmRzIGEgbWVzc2FnZSB0byB0aGUgbm90aWZpY2F0aW9uIHRhcmdldC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWF1dG9zY2FsaW5nLWxpZmVjeWNsZWhvb2suaHRtbCNjZm4tYXV0b3NjYWxpbmctbGlmZWN5Y2xlaG9vay1ub3RpZmljYXRpb25tZXRhZGF0YVxuICAgICAqL1xuICAgIHB1YmxpYyBub3RpZmljYXRpb25NZXRhZGF0YTogc3RyaW5nIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogVGhlIEFtYXpvbiBSZXNvdXJjZSBOYW1lIChBUk4pIG9mIHRoZSBub3RpZmljYXRpb24gdGFyZ2V0IHRoYXQgQW1hem9uIEVDMiBBdXRvIFNjYWxpbmcgc2VuZHMgbm90aWZpY2F0aW9ucyB0byB3aGVuIGFuIGluc3RhbmNlIGlzIGluIGEgd2FpdCBzdGF0ZSBmb3IgdGhlIGxpZmVjeWNsZSBob29rLiBZb3UgY2FuIHNwZWNpZnkgYW4gQW1hem9uIFNOUyB0b3BpYyBvciBhbiBBbWF6b24gU1FTIHF1ZXVlLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtYXV0b3NjYWxpbmctbGlmZWN5Y2xlaG9vay5odG1sI2Nmbi1hdXRvc2NhbGluZy1saWZlY3ljbGVob29rLW5vdGlmaWNhdGlvbnRhcmdldGFyblxuICAgICAqL1xuICAgIHB1YmxpYyBub3RpZmljYXRpb25UYXJnZXRBcm46IHN0cmluZyB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIFRoZSBBUk4gb2YgdGhlIElBTSByb2xlIHRoYXQgYWxsb3dzIHRoZSBBdXRvIFNjYWxpbmcgZ3JvdXAgdG8gcHVibGlzaCB0byB0aGUgc3BlY2lmaWVkIG5vdGlmaWNhdGlvbiB0YXJnZXQuIEZvciBpbmZvcm1hdGlvbiBhYm91dCBjcmVhdGluZyB0aGlzIHJvbGUsIHNlZSBbQ29uZmlndXJlIGEgbm90aWZpY2F0aW9uIHRhcmdldCBmb3IgYSBsaWZlY3ljbGUgaG9va10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2F1dG9zY2FsaW5nL2VjMi91c2VyZ3VpZGUvcHJlcGFyZS1mb3ItbGlmZWN5Y2xlLW5vdGlmaWNhdGlvbnMuaHRtbCNsaWZlY3ljbGUtaG9vay1ub3RpZmljYXRpb24tdGFyZ2V0KSBpbiB0aGUgKkFtYXpvbiBFQzIgQXV0byBTY2FsaW5nIFVzZXIgR3VpZGUqIC5cbiAgICAgKlxuICAgICAqIFZhbGlkIG9ubHkgaWYgdGhlIG5vdGlmaWNhdGlvbiB0YXJnZXQgaXMgYW4gQW1hem9uIFNOUyB0b3BpYyBvciBhbiBBbWF6b24gU1FTIHF1ZXVlLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtYXV0b3NjYWxpbmctbGlmZWN5Y2xlaG9vay5odG1sI2Nmbi1hdXRvc2NhbGluZy1saWZlY3ljbGVob29rLXJvbGVhcm5cbiAgICAgKi9cbiAgICBwdWJsaWMgcm9sZUFybjogc3RyaW5nIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogQ3JlYXRlIGEgbmV3IGBBV1M6OkF1dG9TY2FsaW5nOjpMaWZlY3ljbGVIb29rYC5cbiAgICAgKlxuICAgICAqIEBwYXJhbSBzY29wZSAtIHNjb3BlIGluIHdoaWNoIHRoaXMgcmVzb3VyY2UgaXMgZGVmaW5lZFxuICAgICAqIEBwYXJhbSBpZCAgICAtIHNjb3BlZCBpZCBvZiB0aGUgcmVzb3VyY2VcbiAgICAgKiBAcGFyYW0gcHJvcHMgLSByZXNvdXJjZSBwcm9wZXJ0aWVzXG4gICAgICovXG4gICAgY29uc3RydWN0b3Ioc2NvcGU6IGNkay5Db25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBDZm5MaWZlY3ljbGVIb29rUHJvcHMpIHtcbiAgICAgICAgc3VwZXIoc2NvcGUsIGlkLCB7IHR5cGU6IENmbkxpZmVjeWNsZUhvb2suQ0ZOX1JFU09VUkNFX1RZUEVfTkFNRSwgcHJvcGVydGllczogcHJvcHMgfSk7XG4gICAgICAgIGNkay5yZXF1aXJlUHJvcGVydHkocHJvcHMsICdhdXRvU2NhbGluZ0dyb3VwTmFtZScsIHRoaXMpO1xuICAgICAgICBjZGsucmVxdWlyZVByb3BlcnR5KHByb3BzLCAnbGlmZWN5Y2xlVHJhbnNpdGlvbicsIHRoaXMpO1xuXG4gICAgICAgIHRoaXMuYXV0b1NjYWxpbmdHcm91cE5hbWUgPSBwcm9wcy5hdXRvU2NhbGluZ0dyb3VwTmFtZTtcbiAgICAgICAgdGhpcy5saWZlY3ljbGVUcmFuc2l0aW9uID0gcHJvcHMubGlmZWN5Y2xlVHJhbnNpdGlvbjtcbiAgICAgICAgdGhpcy5kZWZhdWx0UmVzdWx0ID0gcHJvcHMuZGVmYXVsdFJlc3VsdDtcbiAgICAgICAgdGhpcy5oZWFydGJlYXRUaW1lb3V0ID0gcHJvcHMuaGVhcnRiZWF0VGltZW91dDtcbiAgICAgICAgdGhpcy5saWZlY3ljbGVIb29rTmFtZSA9IHByb3BzLmxpZmVjeWNsZUhvb2tOYW1lO1xuICAgICAgICB0aGlzLm5vdGlmaWNhdGlvbk1ldGFkYXRhID0gcHJvcHMubm90aWZpY2F0aW9uTWV0YWRhdGE7XG4gICAgICAgIHRoaXMubm90aWZpY2F0aW9uVGFyZ2V0QXJuID0gcHJvcHMubm90aWZpY2F0aW9uVGFyZ2V0QXJuO1xuICAgICAgICB0aGlzLnJvbGVBcm4gPSBwcm9wcy5yb2xlQXJuO1xuICAgIH1cblxuICAgIC8qKlxuICAgICAqIEV4YW1pbmVzIHRoZSBDbG91ZEZvcm1hdGlvbiByZXNvdXJjZSBhbmQgZGlzY2xvc2VzIGF0dHJpYnV0ZXMuXG4gICAgICpcbiAgICAgKiBAcGFyYW0gaW5zcGVjdG9yIC0gdHJlZSBpbnNwZWN0b3IgdG8gY29sbGVjdCBhbmQgcHJvY2VzcyBhdHRyaWJ1dGVzXG4gICAgICpcbiAgICAgKi9cbiAgICBwdWJsaWMgaW5zcGVjdChpbnNwZWN0b3I6IGNkay5UcmVlSW5zcGVjdG9yKSB7XG4gICAgICAgIGluc3BlY3Rvci5hZGRBdHRyaWJ1dGUoXCJhd3M6Y2RrOmNsb3VkZm9ybWF0aW9uOnR5cGVcIiwgQ2ZuTGlmZWN5Y2xlSG9vay5DRk5fUkVTT1VSQ0VfVFlQRV9OQU1FKTtcbiAgICAgICAgaW5zcGVjdG9yLmFkZEF0dHJpYnV0ZShcImF3czpjZGs6Y2xvdWRmb3JtYXRpb246cHJvcHNcIiwgdGhpcy5jZm5Qcm9wZXJ0aWVzKTtcbiAgICB9XG5cbiAgICBwcm90ZWN0ZWQgZ2V0IGNmblByb3BlcnRpZXMoKTogeyBba2V5OiBzdHJpbmddOiBhbnkgfSAge1xuICAgICAgICByZXR1cm4ge1xuICAgICAgICAgICAgYXV0b1NjYWxpbmdHcm91cE5hbWU6IHRoaXMuYXV0b1NjYWxpbmdHcm91cE5hbWUsXG4gICAgICAgICAgICBsaWZlY3ljbGVUcmFuc2l0aW9uOiB0aGlzLmxpZmVjeWNsZVRyYW5zaXRpb24sXG4gICAgICAgICAgICBkZWZhdWx0UmVzdWx0OiB0aGlzLmRlZmF1bHRSZXN1bHQsXG4gICAgICAgICAgICBoZWFydGJlYXRUaW1lb3V0OiB0aGlzLmhlYXJ0YmVhdFRpbWVvdXQsXG4gICAgICAgICAgICBsaWZlY3ljbGVIb29rTmFtZTogdGhpcy5saWZlY3ljbGVIb29rTmFtZSxcbiAgICAgICAgICAgIG5vdGlmaWNhdGlvbk1ldGFkYXRhOiB0aGlzLm5vdGlmaWNhdGlvbk1ldGFkYXRhLFxuICAgICAgICAgICAgbm90aWZpY2F0aW9uVGFyZ2V0QXJuOiB0aGlzLm5vdGlmaWNhdGlvblRhcmdldEFybixcbiAgICAgICAgICAgIHJvbGVBcm46IHRoaXMucm9sZUFybixcbiAgICAgICAgfTtcbiAgICB9XG5cbiAgICBwcm90ZWN0ZWQgcmVuZGVyUHJvcGVydGllcyhwcm9wczoge1trZXk6IHN0cmluZ106IGFueX0pOiB7IFtrZXk6IHN0cmluZ106IGFueSB9ICB7XG4gICAgICAgIHJldHVybiBjZm5MaWZlY3ljbGVIb29rUHJvcHNUb0Nsb3VkRm9ybWF0aW9uKHByb3BzKTtcbiAgICB9XG59XG5cbi8qKlxuICogUHJvcGVydGllcyBmb3IgZGVmaW5pbmcgYSBgQ2ZuU2NhbGluZ1BvbGljeWBcbiAqXG4gKiBAc3RydWN0XG4gKiBAc3RhYmlsaXR5IGV4dGVybmFsXG4gKlxuICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtYXV0b3NjYWxpbmctc2NhbGluZ3BvbGljeS5odG1sXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgQ2ZuU2NhbGluZ1BvbGljeVByb3BzIHtcblxuICAgIC8qKlxuICAgICAqIFRoZSBuYW1lIG9mIHRoZSBBdXRvIFNjYWxpbmcgZ3JvdXAuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1hdXRvc2NhbGluZy1zY2FsaW5ncG9saWN5Lmh0bWwjY2ZuLWF1dG9zY2FsaW5nLXNjYWxpbmdwb2xpY3ktYXV0b3NjYWxpbmdncm91cG5hbWVcbiAgICAgKi9cbiAgICByZWFkb25seSBhdXRvU2NhbGluZ0dyb3VwTmFtZTogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogU3BlY2lmaWVzIGhvdyB0aGUgc2NhbGluZyBhZGp1c3RtZW50IGlzIGludGVycHJldGVkIChmb3IgZXhhbXBsZSwgYW4gYWJzb2x1dGUgbnVtYmVyIG9yIGEgcGVyY2VudGFnZSkuIFRoZSB2YWxpZCB2YWx1ZXMgYXJlIGBDaGFuZ2VJbkNhcGFjaXR5YCAsIGBFeGFjdENhcGFjaXR5YCAsIGFuZCBgUGVyY2VudENoYW5nZUluQ2FwYWNpdHlgIC5cbiAgICAgKlxuICAgICAqIFJlcXVpcmVkIGlmIHRoZSBwb2xpY3kgdHlwZSBpcyBgU3RlcFNjYWxpbmdgIG9yIGBTaW1wbGVTY2FsaW5nYCAuIEZvciBtb3JlIGluZm9ybWF0aW9uLCBzZWUgW1NjYWxpbmcgYWRqdXN0bWVudCB0eXBlc10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2F1dG9zY2FsaW5nL2VjMi91c2VyZ3VpZGUvYXMtc2NhbGluZy1zaW1wbGUtc3RlcC5odG1sI2FzLXNjYWxpbmctYWRqdXN0bWVudCkgaW4gdGhlICpBbWF6b24gRUMyIEF1dG8gU2NhbGluZyBVc2VyIEd1aWRlKiAuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1hdXRvc2NhbGluZy1zY2FsaW5ncG9saWN5Lmh0bWwjY2ZuLWF1dG9zY2FsaW5nLXNjYWxpbmdwb2xpY3ktYWRqdXN0bWVudHR5cGVcbiAgICAgKi9cbiAgICByZWFkb25seSBhZGp1c3RtZW50VHlwZT86IHN0cmluZztcblxuICAgIC8qKlxuICAgICAqIEEgY29vbGRvd24gcGVyaW9kLCBpbiBzZWNvbmRzLCB0aGF0IGFwcGxpZXMgdG8gYSBzcGVjaWZpYyBzaW1wbGUgc2NhbGluZyBwb2xpY3kuIFdoZW4gYSBjb29sZG93biBwZXJpb2QgaXMgc3BlY2lmaWVkIGhlcmUsIGl0IG92ZXJyaWRlcyB0aGUgZGVmYXVsdCBjb29sZG93bi5cbiAgICAgKlxuICAgICAqIFZhbGlkIG9ubHkgaWYgdGhlIHBvbGljeSB0eXBlIGlzIGBTaW1wbGVTY2FsaW5nYCAuIEZvciBtb3JlIGluZm9ybWF0aW9uLCBzZWUgW1NjYWxpbmcgY29vbGRvd25zIGZvciBBbWF6b24gRUMyIEF1dG8gU2NhbGluZ10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2F1dG9zY2FsaW5nL2VjMi91c2VyZ3VpZGUvQ29vbGRvd24uaHRtbCkgaW4gdGhlICpBbWF6b24gRUMyIEF1dG8gU2NhbGluZyBVc2VyIEd1aWRlKiAuXG4gICAgICpcbiAgICAgKiBEZWZhdWx0OiBOb25lXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1hdXRvc2NhbGluZy1zY2FsaW5ncG9saWN5Lmh0bWwjY2ZuLWF1dG9zY2FsaW5nLXNjYWxpbmdwb2xpY3ktY29vbGRvd25cbiAgICAgKi9cbiAgICByZWFkb25seSBjb29sZG93bj86IHN0cmluZztcblxuICAgIC8qKlxuICAgICAqICpOb3QgbmVlZGVkIGlmIHRoZSBkZWZhdWx0IGluc3RhbmNlIHdhcm11cCBpcyBkZWZpbmVkIGZvciB0aGUgZ3JvdXAuKlxuICAgICAqXG4gICAgICogVGhlIGVzdGltYXRlZCB0aW1lLCBpbiBzZWNvbmRzLCB1bnRpbCBhIG5ld2x5IGxhdW5jaGVkIGluc3RhbmNlIGNhbiBjb250cmlidXRlIHRvIHRoZSBDbG91ZFdhdGNoIG1ldHJpY3MuIFRoaXMgd2FybS11cCBwZXJpb2QgYXBwbGllcyB0byBpbnN0YW5jZXMgbGF1bmNoZWQgZHVlIHRvIGEgc3BlY2lmaWMgdGFyZ2V0IHRyYWNraW5nIG9yIHN0ZXAgc2NhbGluZyBwb2xpY3kuIFdoZW4gYSB3YXJtLXVwIHBlcmlvZCBpcyBzcGVjaWZpZWQgaGVyZSwgaXQgb3ZlcnJpZGVzIHRoZSBkZWZhdWx0IGluc3RhbmNlIHdhcm11cC5cbiAgICAgKlxuICAgICAqIFZhbGlkIG9ubHkgaWYgdGhlIHBvbGljeSB0eXBlIGlzIGBUYXJnZXRUcmFja2luZ1NjYWxpbmdgIG9yIGBTdGVwU2NhbGluZ2AgLlxuICAgICAqXG4gICAgICogPiBUaGUgZGVmYXVsdCBpcyB0byB1c2UgdGhlIHZhbHVlIGZvciB0aGUgZGVmYXVsdCBpbnN0YW5jZSB3YXJtdXAgZGVmaW5lZCBmb3IgdGhlIGdyb3VwLiBJZiBkZWZhdWx0IGluc3RhbmNlIHdhcm11cCBpcyBudWxsLCB0aGVuIGBFc3RpbWF0ZWRJbnN0YW5jZVdhcm11cGAgZmFsbHMgYmFjayB0byB0aGUgdmFsdWUgb2YgZGVmYXVsdCBjb29sZG93bi5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWF1dG9zY2FsaW5nLXNjYWxpbmdwb2xpY3kuaHRtbCNjZm4tYXV0b3NjYWxpbmctc2NhbGluZ3BvbGljeS1lc3RpbWF0ZWRpbnN0YW5jZXdhcm11cFxuICAgICAqL1xuICAgIHJlYWRvbmx5IGVzdGltYXRlZEluc3RhbmNlV2FybXVwPzogbnVtYmVyO1xuXG4gICAgLyoqXG4gICAgICogVGhlIGFnZ3JlZ2F0aW9uIHR5cGUgZm9yIHRoZSBDbG91ZFdhdGNoIG1ldHJpY3MuIFRoZSB2YWxpZCB2YWx1ZXMgYXJlIGBNaW5pbXVtYCAsIGBNYXhpbXVtYCAsIGFuZCBgQXZlcmFnZWAgLiBJZiB0aGUgYWdncmVnYXRpb24gdHlwZSBpcyBudWxsLCB0aGUgdmFsdWUgaXMgdHJlYXRlZCBhcyBgQXZlcmFnZWAgLlxuICAgICAqXG4gICAgICogVmFsaWQgb25seSBpZiB0aGUgcG9saWN5IHR5cGUgaXMgYFN0ZXBTY2FsaW5nYCAuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1hdXRvc2NhbGluZy1zY2FsaW5ncG9saWN5Lmh0bWwjY2ZuLWF1dG9zY2FsaW5nLXNjYWxpbmdwb2xpY3ktbWV0cmljYWdncmVnYXRpb250eXBlXG4gICAgICovXG4gICAgcmVhZG9ubHkgbWV0cmljQWdncmVnYXRpb25UeXBlPzogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogVGhlIG1pbmltdW0gdmFsdWUgdG8gc2NhbGUgYnkgd2hlbiB0aGUgYWRqdXN0bWVudCB0eXBlIGlzIGBQZXJjZW50Q2hhbmdlSW5DYXBhY2l0eWAgLiBGb3IgZXhhbXBsZSwgc3VwcG9zZSB0aGF0IHlvdSBjcmVhdGUgYSBzdGVwIHNjYWxpbmcgcG9saWN5IHRvIHNjYWxlIG91dCBhbiBBdXRvIFNjYWxpbmcgZ3JvdXAgYnkgMjUgcGVyY2VudCBhbmQgeW91IHNwZWNpZnkgYSBgTWluQWRqdXN0bWVudE1hZ25pdHVkZWAgb2YgMi4gSWYgdGhlIGdyb3VwIGhhcyA0IGluc3RhbmNlcyBhbmQgdGhlIHNjYWxpbmcgcG9saWN5IGlzIHBlcmZvcm1lZCwgMjUgcGVyY2VudCBvZiA0IGlzIDEuIEhvd2V2ZXIsIGJlY2F1c2UgeW91IHNwZWNpZmllZCBhIGBNaW5BZGp1c3RtZW50TWFnbml0dWRlYCBvZiAyLCBBbWF6b24gRUMyIEF1dG8gU2NhbGluZyBzY2FsZXMgb3V0IHRoZSBncm91cCBieSAyIGluc3RhbmNlcy5cbiAgICAgKlxuICAgICAqIFZhbGlkIG9ubHkgaWYgdGhlIHBvbGljeSB0eXBlIGlzIGBTdGVwU2NhbGluZ2Agb3IgYFNpbXBsZVNjYWxpbmdgIC4gRm9yIG1vcmUgaW5mb3JtYXRpb24sIHNlZSBbU2NhbGluZyBhZGp1c3RtZW50IHR5cGVzXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vYXV0b3NjYWxpbmcvZWMyL3VzZXJndWlkZS9hcy1zY2FsaW5nLXNpbXBsZS1zdGVwLmh0bWwjYXMtc2NhbGluZy1hZGp1c3RtZW50KSBpbiB0aGUgKkFtYXpvbiBFQzIgQXV0byBTY2FsaW5nIFVzZXIgR3VpZGUqIC5cbiAgICAgKlxuICAgICAqID4gU29tZSBBdXRvIFNjYWxpbmcgZ3JvdXBzIHVzZSBpbnN0YW5jZSB3ZWlnaHRzLiBJbiB0aGlzIGNhc2UsIHNldCB0aGUgYE1pbkFkanVzdG1lbnRNYWduaXR1ZGVgIHRvIGEgdmFsdWUgdGhhdCBpcyBhdCBsZWFzdCBhcyBsYXJnZSBhcyB5b3VyIGxhcmdlc3QgaW5zdGFuY2Ugd2VpZ2h0LlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtYXV0b3NjYWxpbmctc2NhbGluZ3BvbGljeS5odG1sI2Nmbi1hdXRvc2NhbGluZy1zY2FsaW5ncG9saWN5LW1pbmFkanVzdG1lbnRtYWduaXR1ZGVcbiAgICAgKi9cbiAgICByZWFkb25seSBtaW5BZGp1c3RtZW50TWFnbml0dWRlPzogbnVtYmVyO1xuXG4gICAgLyoqXG4gICAgICogT25lIG9mIHRoZSBmb2xsb3dpbmcgcG9saWN5IHR5cGVzOlxuICAgICAqXG4gICAgICogLSBgVGFyZ2V0VHJhY2tpbmdTY2FsaW5nYFxuICAgICAqIC0gYFN0ZXBTY2FsaW5nYFxuICAgICAqIC0gYFNpbXBsZVNjYWxpbmdgIChkZWZhdWx0KVxuICAgICAqIC0gYFByZWRpY3RpdmVTY2FsaW5nYFxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtYXV0b3NjYWxpbmctc2NhbGluZ3BvbGljeS5odG1sI2Nmbi1hdXRvc2NhbGluZy1zY2FsaW5ncG9saWN5LXBvbGljeXR5cGVcbiAgICAgKi9cbiAgICByZWFkb25seSBwb2xpY3lUeXBlPzogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogQSBwcmVkaWN0aXZlIHNjYWxpbmcgcG9saWN5LiBQcm92aWRlcyBzdXBwb3J0IGZvciBwcmVkZWZpbmVkIGFuZCBjdXN0b20gbWV0cmljcy5cbiAgICAgKlxuICAgICAqIFByZWRlZmluZWQgbWV0cmljcyBpbmNsdWRlIENQVSB1dGlsaXphdGlvbiwgbmV0d29yayBpbi9vdXQsIGFuZCB0aGUgQXBwbGljYXRpb24gTG9hZCBCYWxhbmNlciByZXF1ZXN0IGNvdW50LlxuICAgICAqXG4gICAgICogUmVxdWlyZWQgaWYgdGhlIHBvbGljeSB0eXBlIGlzIGBQcmVkaWN0aXZlU2NhbGluZ2AgLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtYXV0b3NjYWxpbmctc2NhbGluZ3BvbGljeS5odG1sI2Nmbi1hdXRvc2NhbGluZy1zY2FsaW5ncG9saWN5LXByZWRpY3RpdmVzY2FsaW5nY29uZmlndXJhdGlvblxuICAgICAqL1xuICAgIHJlYWRvbmx5IHByZWRpY3RpdmVTY2FsaW5nQ29uZmlndXJhdGlvbj86IENmblNjYWxpbmdQb2xpY3kuUHJlZGljdGl2ZVNjYWxpbmdDb25maWd1cmF0aW9uUHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgYW1vdW50IGJ5IHdoaWNoIHRvIHNjYWxlLCBiYXNlZCBvbiB0aGUgc3BlY2lmaWVkIGFkanVzdG1lbnQgdHlwZS4gQSBwb3NpdGl2ZSB2YWx1ZSBhZGRzIHRvIHRoZSBjdXJyZW50IGNhcGFjaXR5IHdoaWxlIGEgbmVnYXRpdmUgbnVtYmVyIHJlbW92ZXMgZnJvbSB0aGUgY3VycmVudCBjYXBhY2l0eS4gRm9yIGV4YWN0IGNhcGFjaXR5LCB5b3UgbXVzdCBzcGVjaWZ5IGEgcG9zaXRpdmUgdmFsdWUuXG4gICAgICpcbiAgICAgKiBSZXF1aXJlZCBpZiB0aGUgcG9saWN5IHR5cGUgaXMgYFNpbXBsZVNjYWxpbmdgIC4gKE5vdCB1c2VkIHdpdGggYW55IG90aGVyIHBvbGljeSB0eXBlLilcbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWF1dG9zY2FsaW5nLXNjYWxpbmdwb2xpY3kuaHRtbCNjZm4tYXV0b3NjYWxpbmctc2NhbGluZ3BvbGljeS1zY2FsaW5nYWRqdXN0bWVudFxuICAgICAqL1xuICAgIHJlYWRvbmx5IHNjYWxpbmdBZGp1c3RtZW50PzogbnVtYmVyO1xuXG4gICAgLyoqXG4gICAgICogQSBzZXQgb2YgYWRqdXN0bWVudHMgdGhhdCBlbmFibGUgeW91IHRvIHNjYWxlIGJhc2VkIG9uIHRoZSBzaXplIG9mIHRoZSBhbGFybSBicmVhY2guXG4gICAgICpcbiAgICAgKiBSZXF1aXJlZCBpZiB0aGUgcG9saWN5IHR5cGUgaXMgYFN0ZXBTY2FsaW5nYCAuIChOb3QgdXNlZCB3aXRoIGFueSBvdGhlciBwb2xpY3kgdHlwZS4pXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1hdXRvc2NhbGluZy1zY2FsaW5ncG9saWN5Lmh0bWwjY2ZuLWF1dG9zY2FsaW5nLXNjYWxpbmdwb2xpY3ktc3RlcGFkanVzdG1lbnRzXG4gICAgICovXG4gICAgcmVhZG9ubHkgc3RlcEFkanVzdG1lbnRzPzogQXJyYXk8Q2ZuU2NhbGluZ1BvbGljeS5TdGVwQWRqdXN0bWVudFByb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlPiB8IGNkay5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIEEgdGFyZ2V0IHRyYWNraW5nIHNjYWxpbmcgcG9saWN5LiBQcm92aWRlcyBzdXBwb3J0IGZvciBwcmVkZWZpbmVkIG9yIGN1c3RvbSBtZXRyaWNzLlxuICAgICAqXG4gICAgICogVGhlIGZvbGxvd2luZyBwcmVkZWZpbmVkIG1ldHJpY3MgYXJlIGF2YWlsYWJsZTpcbiAgICAgKlxuICAgICAqIC0gYEFTR0F2ZXJhZ2VDUFVVdGlsaXphdGlvbmBcbiAgICAgKiAtIGBBU0dBdmVyYWdlTmV0d29ya0luYFxuICAgICAqIC0gYEFTR0F2ZXJhZ2VOZXR3b3JrT3V0YFxuICAgICAqIC0gYEFMQlJlcXVlc3RDb3VudFBlclRhcmdldGBcbiAgICAgKlxuICAgICAqIElmIHlvdSBzcGVjaWZ5IGBBTEJSZXF1ZXN0Q291bnRQZXJUYXJnZXRgIGZvciB0aGUgbWV0cmljLCB5b3UgbXVzdCBzcGVjaWZ5IHRoZSBgUmVzb3VyY2VMYWJlbGAgcHJvcGVydHkgd2l0aCB0aGUgYFByZWRlZmluZWRNZXRyaWNTcGVjaWZpY2F0aW9uYCAuXG4gICAgICpcbiAgICAgKiBSZXF1aXJlZCBpZiB0aGUgcG9saWN5IHR5cGUgaXMgYFRhcmdldFRyYWNraW5nU2NhbGluZ2AgLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtYXV0b3NjYWxpbmctc2NhbGluZ3BvbGljeS5odG1sI2Nmbi1hdXRvc2NhbGluZy1zY2FsaW5ncG9saWN5LXRhcmdldHRyYWNraW5nY29uZmlndXJhdGlvblxuICAgICAqL1xuICAgIHJlYWRvbmx5IHRhcmdldFRyYWNraW5nQ29uZmlndXJhdGlvbj86IENmblNjYWxpbmdQb2xpY3kuVGFyZ2V0VHJhY2tpbmdDb25maWd1cmF0aW9uUHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGU7XG59XG5cbi8qKlxuICogRGV0ZXJtaW5lIHdoZXRoZXIgdGhlIGdpdmVuIHByb3BlcnRpZXMgbWF0Y2ggdGhvc2Ugb2YgYSBgQ2ZuU2NhbGluZ1BvbGljeVByb3BzYFxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBDZm5TY2FsaW5nUG9saWN5UHJvcHNgXG4gKlxuICogQHJldHVybnMgdGhlIHJlc3VsdCBvZiB0aGUgdmFsaWRhdGlvbi5cbiAqL1xuZnVuY3Rpb24gQ2ZuU2NhbGluZ1BvbGljeVByb3BzVmFsaWRhdG9yKHByb3BlcnRpZXM6IGFueSk6IGNkay5WYWxpZGF0aW9uUmVzdWx0IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBjZGsuVkFMSURBVElPTl9TVUNDRVNTOyB9XG4gICAgY29uc3QgZXJyb3JzID0gbmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0cygpO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgZXJyb3JzLmNvbGxlY3QobmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0KCdFeHBlY3RlZCBhbiBvYmplY3QsIGJ1dCByZWNlaXZlZDogJyArIEpTT04uc3RyaW5naWZ5KHByb3BlcnRpZXMpKSk7XG4gICAgfVxuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignYWRqdXN0bWVudFR5cGUnLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuYWRqdXN0bWVudFR5cGUpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2F1dG9TY2FsaW5nR3JvdXBOYW1lJywgY2RrLnJlcXVpcmVkVmFsaWRhdG9yKShwcm9wZXJ0aWVzLmF1dG9TY2FsaW5nR3JvdXBOYW1lKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdhdXRvU2NhbGluZ0dyb3VwTmFtZScsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5hdXRvU2NhbGluZ0dyb3VwTmFtZSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignY29vbGRvd24nLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuY29vbGRvd24pKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2VzdGltYXRlZEluc3RhbmNlV2FybXVwJywgY2RrLnZhbGlkYXRlTnVtYmVyKShwcm9wZXJ0aWVzLmVzdGltYXRlZEluc3RhbmNlV2FybXVwKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdtZXRyaWNBZ2dyZWdhdGlvblR5cGUnLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMubWV0cmljQWdncmVnYXRpb25UeXBlKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdtaW5BZGp1c3RtZW50TWFnbml0dWRlJywgY2RrLnZhbGlkYXRlTnVtYmVyKShwcm9wZXJ0aWVzLm1pbkFkanVzdG1lbnRNYWduaXR1ZGUpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3BvbGljeVR5cGUnLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMucG9saWN5VHlwZSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigncHJlZGljdGl2ZVNjYWxpbmdDb25maWd1cmF0aW9uJywgQ2ZuU2NhbGluZ1BvbGljeV9QcmVkaWN0aXZlU2NhbGluZ0NvbmZpZ3VyYXRpb25Qcm9wZXJ0eVZhbGlkYXRvcikocHJvcGVydGllcy5wcmVkaWN0aXZlU2NhbGluZ0NvbmZpZ3VyYXRpb24pKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3NjYWxpbmdBZGp1c3RtZW50JywgY2RrLnZhbGlkYXRlTnVtYmVyKShwcm9wZXJ0aWVzLnNjYWxpbmdBZGp1c3RtZW50KSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdzdGVwQWRqdXN0bWVudHMnLCBjZGsubGlzdFZhbGlkYXRvcihDZm5TY2FsaW5nUG9saWN5X1N0ZXBBZGp1c3RtZW50UHJvcGVydHlWYWxpZGF0b3IpKShwcm9wZXJ0aWVzLnN0ZXBBZGp1c3RtZW50cykpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigndGFyZ2V0VHJhY2tpbmdDb25maWd1cmF0aW9uJywgQ2ZuU2NhbGluZ1BvbGljeV9UYXJnZXRUcmFja2luZ0NvbmZpZ3VyYXRpb25Qcm9wZXJ0eVZhbGlkYXRvcikocHJvcGVydGllcy50YXJnZXRUcmFja2luZ0NvbmZpZ3VyYXRpb24pKTtcbiAgICByZXR1cm4gZXJyb3JzLndyYXAoJ3N1cHBsaWVkIHByb3BlcnRpZXMgbm90IGNvcnJlY3QgZm9yIFwiQ2ZuU2NhbGluZ1BvbGljeVByb3BzXCInKTtcbn1cblxuLyoqXG4gKiBSZW5kZXJzIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpBdXRvU2NhbGluZzo6U2NhbGluZ1BvbGljeWAgcmVzb3VyY2VcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgQ2ZuU2NhbGluZ1BvbGljeVByb3BzYFxuICpcbiAqIEByZXR1cm5zIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpBdXRvU2NhbGluZzo6U2NhbGluZ1BvbGljeWAgcmVzb3VyY2UuXG4gKi9cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBjZm5TY2FsaW5nUG9saWN5UHJvcHNUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGFueSB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gcHJvcGVydGllczsgfVxuICAgIENmblNjYWxpbmdQb2xpY3lQcm9wc1ZhbGlkYXRvcihwcm9wZXJ0aWVzKS5hc3NlcnRTdWNjZXNzKCk7XG4gICAgcmV0dXJuIHtcbiAgICAgICAgQXV0b1NjYWxpbmdHcm91cE5hbWU6IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuYXV0b1NjYWxpbmdHcm91cE5hbWUpLFxuICAgICAgICBBZGp1c3RtZW50VHlwZTogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5hZGp1c3RtZW50VHlwZSksXG4gICAgICAgIENvb2xkb3duOiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLmNvb2xkb3duKSxcbiAgICAgICAgRXN0aW1hdGVkSW5zdGFuY2VXYXJtdXA6IGNkay5udW1iZXJUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuZXN0aW1hdGVkSW5zdGFuY2VXYXJtdXApLFxuICAgICAgICBNZXRyaWNBZ2dyZWdhdGlvblR5cGU6IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMubWV0cmljQWdncmVnYXRpb25UeXBlKSxcbiAgICAgICAgTWluQWRqdXN0bWVudE1hZ25pdHVkZTogY2RrLm51bWJlclRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5taW5BZGp1c3RtZW50TWFnbml0dWRlKSxcbiAgICAgICAgUG9saWN5VHlwZTogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5wb2xpY3lUeXBlKSxcbiAgICAgICAgUHJlZGljdGl2ZVNjYWxpbmdDb25maWd1cmF0aW9uOiBjZm5TY2FsaW5nUG9saWN5UHJlZGljdGl2ZVNjYWxpbmdDb25maWd1cmF0aW9uUHJvcGVydHlUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMucHJlZGljdGl2ZVNjYWxpbmdDb25maWd1cmF0aW9uKSxcbiAgICAgICAgU2NhbGluZ0FkanVzdG1lbnQ6IGNkay5udW1iZXJUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuc2NhbGluZ0FkanVzdG1lbnQpLFxuICAgICAgICBTdGVwQWRqdXN0bWVudHM6IGNkay5saXN0TWFwcGVyKGNmblNjYWxpbmdQb2xpY3lTdGVwQWRqdXN0bWVudFByb3BlcnR5VG9DbG91ZEZvcm1hdGlvbikocHJvcGVydGllcy5zdGVwQWRqdXN0bWVudHMpLFxuICAgICAgICBUYXJnZXRUcmFja2luZ0NvbmZpZ3VyYXRpb246IGNmblNjYWxpbmdQb2xpY3lUYXJnZXRUcmFja2luZ0NvbmZpZ3VyYXRpb25Qcm9wZXJ0eVRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy50YXJnZXRUcmFja2luZ0NvbmZpZ3VyYXRpb24pLFxuICAgIH07XG59XG5cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBDZm5TY2FsaW5nUG9saWN5UHJvcHNGcm9tQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdDxDZm5TY2FsaW5nUG9saWN5UHJvcHM+IHtcbiAgICBwcm9wZXJ0aWVzID0gcHJvcGVydGllcyA9PSBudWxsID8ge30gOiBwcm9wZXJ0aWVzO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0KHByb3BlcnRpZXMpO1xuICAgIH1cbiAgICBjb25zdCByZXQgPSBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblByb3BlcnR5T2JqZWN0PENmblNjYWxpbmdQb2xpY3lQcm9wcz4oKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2F1dG9TY2FsaW5nR3JvdXBOYW1lJywgJ0F1dG9TY2FsaW5nR3JvdXBOYW1lJywgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5BdXRvU2NhbGluZ0dyb3VwTmFtZSkpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnYWRqdXN0bWVudFR5cGUnLCAnQWRqdXN0bWVudFR5cGUnLCBwcm9wZXJ0aWVzLkFkanVzdG1lbnRUeXBlICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLkFkanVzdG1lbnRUeXBlKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdjb29sZG93bicsICdDb29sZG93bicsIHByb3BlcnRpZXMuQ29vbGRvd24gIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuQ29vbGRvd24pIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2VzdGltYXRlZEluc3RhbmNlV2FybXVwJywgJ0VzdGltYXRlZEluc3RhbmNlV2FybXVwJywgcHJvcGVydGllcy5Fc3RpbWF0ZWRJbnN0YW5jZVdhcm11cCAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXROdW1iZXIocHJvcGVydGllcy5Fc3RpbWF0ZWRJbnN0YW5jZVdhcm11cCkgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnbWV0cmljQWdncmVnYXRpb25UeXBlJywgJ01ldHJpY0FnZ3JlZ2F0aW9uVHlwZScsIHByb3BlcnRpZXMuTWV0cmljQWdncmVnYXRpb25UeXBlICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLk1ldHJpY0FnZ3JlZ2F0aW9uVHlwZSkgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnbWluQWRqdXN0bWVudE1hZ25pdHVkZScsICdNaW5BZGp1c3RtZW50TWFnbml0dWRlJywgcHJvcGVydGllcy5NaW5BZGp1c3RtZW50TWFnbml0dWRlICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldE51bWJlcihwcm9wZXJ0aWVzLk1pbkFkanVzdG1lbnRNYWduaXR1ZGUpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ3BvbGljeVR5cGUnLCAnUG9saWN5VHlwZScsIHByb3BlcnRpZXMuUG9saWN5VHlwZSAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5Qb2xpY3lUeXBlKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdwcmVkaWN0aXZlU2NhbGluZ0NvbmZpZ3VyYXRpb24nLCAnUHJlZGljdGl2ZVNjYWxpbmdDb25maWd1cmF0aW9uJywgcHJvcGVydGllcy5QcmVkaWN0aXZlU2NhbGluZ0NvbmZpZ3VyYXRpb24gIT0gbnVsbCA/IENmblNjYWxpbmdQb2xpY3lQcmVkaWN0aXZlU2NhbGluZ0NvbmZpZ3VyYXRpb25Qcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLlByZWRpY3RpdmVTY2FsaW5nQ29uZmlndXJhdGlvbikgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnc2NhbGluZ0FkanVzdG1lbnQnLCAnU2NhbGluZ0FkanVzdG1lbnQnLCBwcm9wZXJ0aWVzLlNjYWxpbmdBZGp1c3RtZW50ICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldE51bWJlcihwcm9wZXJ0aWVzLlNjYWxpbmdBZGp1c3RtZW50KSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdzdGVwQWRqdXN0bWVudHMnLCAnU3RlcEFkanVzdG1lbnRzJywgcHJvcGVydGllcy5TdGVwQWRqdXN0bWVudHMgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0QXJyYXkoQ2ZuU2NhbGluZ1BvbGljeVN0ZXBBZGp1c3RtZW50UHJvcGVydHlGcm9tQ2xvdWRGb3JtYXRpb24pKHByb3BlcnRpZXMuU3RlcEFkanVzdG1lbnRzKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCd0YXJnZXRUcmFja2luZ0NvbmZpZ3VyYXRpb24nLCAnVGFyZ2V0VHJhY2tpbmdDb25maWd1cmF0aW9uJywgcHJvcGVydGllcy5UYXJnZXRUcmFja2luZ0NvbmZpZ3VyYXRpb24gIT0gbnVsbCA/IENmblNjYWxpbmdQb2xpY3lUYXJnZXRUcmFja2luZ0NvbmZpZ3VyYXRpb25Qcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLlRhcmdldFRyYWNraW5nQ29uZmlndXJhdGlvbikgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRVbnJlY29nbml6ZWRQcm9wZXJ0aWVzQXNFeHRyYShwcm9wZXJ0aWVzKTtcbiAgICByZXR1cm4gcmV0O1xufVxuXG4vKipcbiAqIEEgQ2xvdWRGb3JtYXRpb24gYEFXUzo6QXV0b1NjYWxpbmc6OlNjYWxpbmdQb2xpY3lgXG4gKlxuICogVGhlIGBBV1M6OkF1dG9TY2FsaW5nOjpTY2FsaW5nUG9saWN5YCByZXNvdXJjZSBzcGVjaWZpZXMgYW4gQW1hem9uIEVDMiBBdXRvIFNjYWxpbmcgc2NhbGluZyBwb2xpY3kgc28gdGhhdCB0aGUgQXV0byBTY2FsaW5nIGdyb3VwIGNhbiBzY2FsZSB0aGUgbnVtYmVyIG9mIGluc3RhbmNlcyBhdmFpbGFibGUgZm9yIHlvdXIgYXBwbGljYXRpb24uXG4gKlxuICogRm9yIG1vcmUgaW5mb3JtYXRpb24gYWJvdXQgdXNpbmcgc2NhbGluZyBwb2xpY2llcyB0byBzY2FsZSB5b3VyIEF1dG8gU2NhbGluZyBncm91cCBhdXRvbWF0aWNhbGx5LCBzZWUgW0R5bmFtaWMgc2NhbGluZ10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2F1dG9zY2FsaW5nL2VjMi91c2VyZ3VpZGUvYXMtc2NhbGUtYmFzZWQtb24tZGVtYW5kLmh0bWwpIGFuZCBbUHJlZGljdGl2ZSBzY2FsaW5nXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vYXV0b3NjYWxpbmcvZWMyL3VzZXJndWlkZS9lYzItYXV0by1zY2FsaW5nLXByZWRpY3RpdmUtc2NhbGluZy5odG1sKSBpbiB0aGUgKkFtYXpvbiBFQzIgQXV0byBTY2FsaW5nIFVzZXIgR3VpZGUqIC5cbiAqXG4gKiBAY2xvdWRmb3JtYXRpb25SZXNvdXJjZSBBV1M6OkF1dG9TY2FsaW5nOjpTY2FsaW5nUG9saWN5XG4gKiBAc3RhYmlsaXR5IGV4dGVybmFsXG4gKlxuICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtYXV0b3NjYWxpbmctc2NhbGluZ3BvbGljeS5odG1sXG4gKi9cbmV4cG9ydCBjbGFzcyBDZm5TY2FsaW5nUG9saWN5IGV4dGVuZHMgY2RrLkNmblJlc291cmNlIGltcGxlbWVudHMgY2RrLklJbnNwZWN0YWJsZSB7XG4gICAgLyoqXG4gICAgICogVGhlIENsb3VkRm9ybWF0aW9uIHJlc291cmNlIHR5cGUgbmFtZSBmb3IgdGhpcyByZXNvdXJjZSBjbGFzcy5cbiAgICAgKi9cbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IENGTl9SRVNPVVJDRV9UWVBFX05BTUUgPSBcIkFXUzo6QXV0b1NjYWxpbmc6OlNjYWxpbmdQb2xpY3lcIjtcblxuICAgIC8qKlxuICAgICAqIEEgZmFjdG9yeSBtZXRob2QgdGhhdCBjcmVhdGVzIGEgbmV3IGluc3RhbmNlIG9mIHRoaXMgY2xhc3MgZnJvbSBhbiBvYmplY3RcbiAgICAgKiBjb250YWluaW5nIHRoZSBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIHRoaXMgcmVzb3VyY2UuXG4gICAgICogVXNlZCBpbiB0aGUgQGF3cy1jZGsvY2xvdWRmb3JtYXRpb24taW5jbHVkZSBtb2R1bGUuXG4gICAgICpcbiAgICAgKiBAaW50ZXJuYWxcbiAgICAgKi9cbiAgICBwdWJsaWMgc3RhdGljIF9mcm9tQ2xvdWRGb3JtYXRpb24oc2NvcGU6IGNkay5Db25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHJlc291cmNlQXR0cmlidXRlczogYW55LCBvcHRpb25zOiBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uT3B0aW9ucyk6IENmblNjYWxpbmdQb2xpY3kge1xuICAgICAgICByZXNvdXJjZUF0dHJpYnV0ZXMgPSByZXNvdXJjZUF0dHJpYnV0ZXMgfHwge307XG4gICAgICAgIGNvbnN0IHJlc291cmNlUHJvcGVydGllcyA9IG9wdGlvbnMucGFyc2VyLnBhcnNlVmFsdWUocmVzb3VyY2VBdHRyaWJ1dGVzLlByb3BlcnRpZXMpO1xuICAgICAgICBjb25zdCBwcm9wc1Jlc3VsdCA9IENmblNjYWxpbmdQb2xpY3lQcm9wc0Zyb21DbG91ZEZvcm1hdGlvbihyZXNvdXJjZVByb3BlcnRpZXMpO1xuICAgICAgICBjb25zdCByZXQgPSBuZXcgQ2ZuU2NhbGluZ1BvbGljeShzY29wZSwgaWQsIHByb3BzUmVzdWx0LnZhbHVlKTtcbiAgICAgICAgZm9yIChjb25zdCBbcHJvcEtleSwgcHJvcFZhbF0gb2YgT2JqZWN0LmVudHJpZXMocHJvcHNSZXN1bHQuZXh0cmFQcm9wZXJ0aWVzKSkgIHtcbiAgICAgICAgICAgIHJldC5hZGRQcm9wZXJ0eU92ZXJyaWRlKHByb3BLZXksIHByb3BWYWwpO1xuICAgICAgICB9XG4gICAgICAgIG9wdGlvbnMucGFyc2VyLmhhbmRsZUF0dHJpYnV0ZXMocmV0LCByZXNvdXJjZUF0dHJpYnV0ZXMsIGlkKTtcbiAgICAgICAgcmV0dXJuIHJldDtcbiAgICB9XG5cbiAgICAvKipcbiAgICAgKlxuICAgICAqIEBjbG91ZGZvcm1hdGlvbkF0dHJpYnV0ZSBBcm5cbiAgICAgKi9cbiAgICBwdWJsaWMgcmVhZG9ubHkgYXR0ckFybjogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogUmV0dXJucyB0aGUgbmFtZSBvZiBhIHNjYWxpbmcgcG9saWN5LlxuICAgICAqIEBjbG91ZGZvcm1hdGlvbkF0dHJpYnV0ZSBQb2xpY3lOYW1lXG4gICAgICovXG4gICAgcHVibGljIHJlYWRvbmx5IGF0dHJQb2xpY3lOYW1lOiBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgbmFtZSBvZiB0aGUgQXV0byBTY2FsaW5nIGdyb3VwLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtYXV0b3NjYWxpbmctc2NhbGluZ3BvbGljeS5odG1sI2Nmbi1hdXRvc2NhbGluZy1zY2FsaW5ncG9saWN5LWF1dG9zY2FsaW5nZ3JvdXBuYW1lXG4gICAgICovXG4gICAgcHVibGljIGF1dG9TY2FsaW5nR3JvdXBOYW1lOiBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBTcGVjaWZpZXMgaG93IHRoZSBzY2FsaW5nIGFkanVzdG1lbnQgaXMgaW50ZXJwcmV0ZWQgKGZvciBleGFtcGxlLCBhbiBhYnNvbHV0ZSBudW1iZXIgb3IgYSBwZXJjZW50YWdlKS4gVGhlIHZhbGlkIHZhbHVlcyBhcmUgYENoYW5nZUluQ2FwYWNpdHlgICwgYEV4YWN0Q2FwYWNpdHlgICwgYW5kIGBQZXJjZW50Q2hhbmdlSW5DYXBhY2l0eWAgLlxuICAgICAqXG4gICAgICogUmVxdWlyZWQgaWYgdGhlIHBvbGljeSB0eXBlIGlzIGBTdGVwU2NhbGluZ2Agb3IgYFNpbXBsZVNjYWxpbmdgIC4gRm9yIG1vcmUgaW5mb3JtYXRpb24sIHNlZSBbU2NhbGluZyBhZGp1c3RtZW50IHR5cGVzXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vYXV0b3NjYWxpbmcvZWMyL3VzZXJndWlkZS9hcy1zY2FsaW5nLXNpbXBsZS1zdGVwLmh0bWwjYXMtc2NhbGluZy1hZGp1c3RtZW50KSBpbiB0aGUgKkFtYXpvbiBFQzIgQXV0byBTY2FsaW5nIFVzZXIgR3VpZGUqIC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWF1dG9zY2FsaW5nLXNjYWxpbmdwb2xpY3kuaHRtbCNjZm4tYXV0b3NjYWxpbmctc2NhbGluZ3BvbGljeS1hZGp1c3RtZW50dHlwZVxuICAgICAqL1xuICAgIHB1YmxpYyBhZGp1c3RtZW50VHlwZTogc3RyaW5nIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogQSBjb29sZG93biBwZXJpb2QsIGluIHNlY29uZHMsIHRoYXQgYXBwbGllcyB0byBhIHNwZWNpZmljIHNpbXBsZSBzY2FsaW5nIHBvbGljeS4gV2hlbiBhIGNvb2xkb3duIHBlcmlvZCBpcyBzcGVjaWZpZWQgaGVyZSwgaXQgb3ZlcnJpZGVzIHRoZSBkZWZhdWx0IGNvb2xkb3duLlxuICAgICAqXG4gICAgICogVmFsaWQgb25seSBpZiB0aGUgcG9saWN5IHR5cGUgaXMgYFNpbXBsZVNjYWxpbmdgIC4gRm9yIG1vcmUgaW5mb3JtYXRpb24sIHNlZSBbU2NhbGluZyBjb29sZG93bnMgZm9yIEFtYXpvbiBFQzIgQXV0byBTY2FsaW5nXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vYXV0b3NjYWxpbmcvZWMyL3VzZXJndWlkZS9Db29sZG93bi5odG1sKSBpbiB0aGUgKkFtYXpvbiBFQzIgQXV0byBTY2FsaW5nIFVzZXIgR3VpZGUqIC5cbiAgICAgKlxuICAgICAqIERlZmF1bHQ6IE5vbmVcbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWF1dG9zY2FsaW5nLXNjYWxpbmdwb2xpY3kuaHRtbCNjZm4tYXV0b3NjYWxpbmctc2NhbGluZ3BvbGljeS1jb29sZG93blxuICAgICAqL1xuICAgIHB1YmxpYyBjb29sZG93bjogc3RyaW5nIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogKk5vdCBuZWVkZWQgaWYgdGhlIGRlZmF1bHQgaW5zdGFuY2Ugd2FybXVwIGlzIGRlZmluZWQgZm9yIHRoZSBncm91cC4qXG4gICAgICpcbiAgICAgKiBUaGUgZXN0aW1hdGVkIHRpbWUsIGluIHNlY29uZHMsIHVudGlsIGEgbmV3bHkgbGF1bmNoZWQgaW5zdGFuY2UgY2FuIGNvbnRyaWJ1dGUgdG8gdGhlIENsb3VkV2F0Y2ggbWV0cmljcy4gVGhpcyB3YXJtLXVwIHBlcmlvZCBhcHBsaWVzIHRvIGluc3RhbmNlcyBsYXVuY2hlZCBkdWUgdG8gYSBzcGVjaWZpYyB0YXJnZXQgdHJhY2tpbmcgb3Igc3RlcCBzY2FsaW5nIHBvbGljeS4gV2hlbiBhIHdhcm0tdXAgcGVyaW9kIGlzIHNwZWNpZmllZCBoZXJlLCBpdCBvdmVycmlkZXMgdGhlIGRlZmF1bHQgaW5zdGFuY2Ugd2FybXVwLlxuICAgICAqXG4gICAgICogVmFsaWQgb25seSBpZiB0aGUgcG9saWN5IHR5cGUgaXMgYFRhcmdldFRyYWNraW5nU2NhbGluZ2Agb3IgYFN0ZXBTY2FsaW5nYCAuXG4gICAgICpcbiAgICAgKiA+IFRoZSBkZWZhdWx0IGlzIHRvIHVzZSB0aGUgdmFsdWUgZm9yIHRoZSBkZWZhdWx0IGluc3RhbmNlIHdhcm11cCBkZWZpbmVkIGZvciB0aGUgZ3JvdXAuIElmIGRlZmF1bHQgaW5zdGFuY2Ugd2FybXVwIGlzIG51bGwsIHRoZW4gYEVzdGltYXRlZEluc3RhbmNlV2FybXVwYCBmYWxscyBiYWNrIHRvIHRoZSB2YWx1ZSBvZiBkZWZhdWx0IGNvb2xkb3duLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtYXV0b3NjYWxpbmctc2NhbGluZ3BvbGljeS5odG1sI2Nmbi1hdXRvc2NhbGluZy1zY2FsaW5ncG9saWN5LWVzdGltYXRlZGluc3RhbmNld2FybXVwXG4gICAgICovXG4gICAgcHVibGljIGVzdGltYXRlZEluc3RhbmNlV2FybXVwOiBudW1iZXIgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgYWdncmVnYXRpb24gdHlwZSBmb3IgdGhlIENsb3VkV2F0Y2ggbWV0cmljcy4gVGhlIHZhbGlkIHZhbHVlcyBhcmUgYE1pbmltdW1gICwgYE1heGltdW1gICwgYW5kIGBBdmVyYWdlYCAuIElmIHRoZSBhZ2dyZWdhdGlvbiB0eXBlIGlzIG51bGwsIHRoZSB2YWx1ZSBpcyB0cmVhdGVkIGFzIGBBdmVyYWdlYCAuXG4gICAgICpcbiAgICAgKiBWYWxpZCBvbmx5IGlmIHRoZSBwb2xpY3kgdHlwZSBpcyBgU3RlcFNjYWxpbmdgIC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWF1dG9zY2FsaW5nLXNjYWxpbmdwb2xpY3kuaHRtbCNjZm4tYXV0b3NjYWxpbmctc2NhbGluZ3BvbGljeS1tZXRyaWNhZ2dyZWdhdGlvbnR5cGVcbiAgICAgKi9cbiAgICBwdWJsaWMgbWV0cmljQWdncmVnYXRpb25UeXBlOiBzdHJpbmcgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgbWluaW11bSB2YWx1ZSB0byBzY2FsZSBieSB3aGVuIHRoZSBhZGp1c3RtZW50IHR5cGUgaXMgYFBlcmNlbnRDaGFuZ2VJbkNhcGFjaXR5YCAuIEZvciBleGFtcGxlLCBzdXBwb3NlIHRoYXQgeW91IGNyZWF0ZSBhIHN0ZXAgc2NhbGluZyBwb2xpY3kgdG8gc2NhbGUgb3V0IGFuIEF1dG8gU2NhbGluZyBncm91cCBieSAyNSBwZXJjZW50IGFuZCB5b3Ugc3BlY2lmeSBhIGBNaW5BZGp1c3RtZW50TWFnbml0dWRlYCBvZiAyLiBJZiB0aGUgZ3JvdXAgaGFzIDQgaW5zdGFuY2VzIGFuZCB0aGUgc2NhbGluZyBwb2xpY3kgaXMgcGVyZm9ybWVkLCAyNSBwZXJjZW50IG9mIDQgaXMgMS4gSG93ZXZlciwgYmVjYXVzZSB5b3Ugc3BlY2lmaWVkIGEgYE1pbkFkanVzdG1lbnRNYWduaXR1ZGVgIG9mIDIsIEFtYXpvbiBFQzIgQXV0byBTY2FsaW5nIHNjYWxlcyBvdXQgdGhlIGdyb3VwIGJ5IDIgaW5zdGFuY2VzLlxuICAgICAqXG4gICAgICogVmFsaWQgb25seSBpZiB0aGUgcG9saWN5IHR5cGUgaXMgYFN0ZXBTY2FsaW5nYCBvciBgU2ltcGxlU2NhbGluZ2AgLiBGb3IgbW9yZSBpbmZvcm1hdGlvbiwgc2VlIFtTY2FsaW5nIGFkanVzdG1lbnQgdHlwZXNdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9hdXRvc2NhbGluZy9lYzIvdXNlcmd1aWRlL2FzLXNjYWxpbmctc2ltcGxlLXN0ZXAuaHRtbCNhcy1zY2FsaW5nLWFkanVzdG1lbnQpIGluIHRoZSAqQW1hem9uIEVDMiBBdXRvIFNjYWxpbmcgVXNlciBHdWlkZSogLlxuICAgICAqXG4gICAgICogPiBTb21lIEF1dG8gU2NhbGluZyBncm91cHMgdXNlIGluc3RhbmNlIHdlaWdodHMuIEluIHRoaXMgY2FzZSwgc2V0IHRoZSBgTWluQWRqdXN0bWVudE1hZ25pdHVkZWAgdG8gYSB2YWx1ZSB0aGF0IGlzIGF0IGxlYXN0IGFzIGxhcmdlIGFzIHlvdXIgbGFyZ2VzdCBpbnN0YW5jZSB3ZWlnaHQuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1hdXRvc2NhbGluZy1zY2FsaW5ncG9saWN5Lmh0bWwjY2ZuLWF1dG9zY2FsaW5nLXNjYWxpbmdwb2xpY3ktbWluYWRqdXN0bWVudG1hZ25pdHVkZVxuICAgICAqL1xuICAgIHB1YmxpYyBtaW5BZGp1c3RtZW50TWFnbml0dWRlOiBudW1iZXIgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBPbmUgb2YgdGhlIGZvbGxvd2luZyBwb2xpY3kgdHlwZXM6XG4gICAgICpcbiAgICAgKiAtIGBUYXJnZXRUcmFja2luZ1NjYWxpbmdgXG4gICAgICogLSBgU3RlcFNjYWxpbmdgXG4gICAgICogLSBgU2ltcGxlU2NhbGluZ2AgKGRlZmF1bHQpXG4gICAgICogLSBgUHJlZGljdGl2ZVNjYWxpbmdgXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1hdXRvc2NhbGluZy1zY2FsaW5ncG9saWN5Lmh0bWwjY2ZuLWF1dG9zY2FsaW5nLXNjYWxpbmdwb2xpY3ktcG9saWN5dHlwZVxuICAgICAqL1xuICAgIHB1YmxpYyBwb2xpY3lUeXBlOiBzdHJpbmcgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBBIHByZWRpY3RpdmUgc2NhbGluZyBwb2xpY3kuIFByb3ZpZGVzIHN1cHBvcnQgZm9yIHByZWRlZmluZWQgYW5kIGN1c3RvbSBtZXRyaWNzLlxuICAgICAqXG4gICAgICogUHJlZGVmaW5lZCBtZXRyaWNzIGluY2x1ZGUgQ1BVIHV0aWxpemF0aW9uLCBuZXR3b3JrIGluL291dCwgYW5kIHRoZSBBcHBsaWNhdGlvbiBMb2FkIEJhbGFuY2VyIHJlcXVlc3QgY291bnQuXG4gICAgICpcbiAgICAgKiBSZXF1aXJlZCBpZiB0aGUgcG9saWN5IHR5cGUgaXMgYFByZWRpY3RpdmVTY2FsaW5nYCAuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1hdXRvc2NhbGluZy1zY2FsaW5ncG9saWN5Lmh0bWwjY2ZuLWF1dG9zY2FsaW5nLXNjYWxpbmdwb2xpY3ktcHJlZGljdGl2ZXNjYWxpbmdjb25maWd1cmF0aW9uXG4gICAgICovXG4gICAgcHVibGljIHByZWRpY3RpdmVTY2FsaW5nQ29uZmlndXJhdGlvbjogQ2ZuU2NhbGluZ1BvbGljeS5QcmVkaWN0aXZlU2NhbGluZ0NvbmZpZ3VyYXRpb25Qcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZSB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIFRoZSBhbW91bnQgYnkgd2hpY2ggdG8gc2NhbGUsIGJhc2VkIG9uIHRoZSBzcGVjaWZpZWQgYWRqdXN0bWVudCB0eXBlLiBBIHBvc2l0aXZlIHZhbHVlIGFkZHMgdG8gdGhlIGN1cnJlbnQgY2FwYWNpdHkgd2hpbGUgYSBuZWdhdGl2ZSBudW1iZXIgcmVtb3ZlcyBmcm9tIHRoZSBjdXJyZW50IGNhcGFjaXR5LiBGb3IgZXhhY3QgY2FwYWNpdHksIHlvdSBtdXN0IHNwZWNpZnkgYSBwb3NpdGl2ZSB2YWx1ZS5cbiAgICAgKlxuICAgICAqIFJlcXVpcmVkIGlmIHRoZSBwb2xpY3kgdHlwZSBpcyBgU2ltcGxlU2NhbGluZ2AgLiAoTm90IHVzZWQgd2l0aCBhbnkgb3RoZXIgcG9saWN5IHR5cGUuKVxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtYXV0b3NjYWxpbmctc2NhbGluZ3BvbGljeS5odG1sI2Nmbi1hdXRvc2NhbGluZy1zY2FsaW5ncG9saWN5LXNjYWxpbmdhZGp1c3RtZW50XG4gICAgICovXG4gICAgcHVibGljIHNjYWxpbmdBZGp1c3RtZW50OiBudW1iZXIgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBBIHNldCBvZiBhZGp1c3RtZW50cyB0aGF0IGVuYWJsZSB5b3UgdG8gc2NhbGUgYmFzZWQgb24gdGhlIHNpemUgb2YgdGhlIGFsYXJtIGJyZWFjaC5cbiAgICAgKlxuICAgICAqIFJlcXVpcmVkIGlmIHRoZSBwb2xpY3kgdHlwZSBpcyBgU3RlcFNjYWxpbmdgIC4gKE5vdCB1c2VkIHdpdGggYW55IG90aGVyIHBvbGljeSB0eXBlLilcbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWF1dG9zY2FsaW5nLXNjYWxpbmdwb2xpY3kuaHRtbCNjZm4tYXV0b3NjYWxpbmctc2NhbGluZ3BvbGljeS1zdGVwYWRqdXN0bWVudHNcbiAgICAgKi9cbiAgICBwdWJsaWMgc3RlcEFkanVzdG1lbnRzOiBBcnJheTxDZm5TY2FsaW5nUG9saWN5LlN0ZXBBZGp1c3RtZW50UHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGU+IHwgY2RrLklSZXNvbHZhYmxlIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogQSB0YXJnZXQgdHJhY2tpbmcgc2NhbGluZyBwb2xpY3kuIFByb3ZpZGVzIHN1cHBvcnQgZm9yIHByZWRlZmluZWQgb3IgY3VzdG9tIG1ldHJpY3MuXG4gICAgICpcbiAgICAgKiBUaGUgZm9sbG93aW5nIHByZWRlZmluZWQgbWV0cmljcyBhcmUgYXZhaWxhYmxlOlxuICAgICAqXG4gICAgICogLSBgQVNHQXZlcmFnZUNQVVV0aWxpemF0aW9uYFxuICAgICAqIC0gYEFTR0F2ZXJhZ2VOZXR3b3JrSW5gXG4gICAgICogLSBgQVNHQXZlcmFnZU5ldHdvcmtPdXRgXG4gICAgICogLSBgQUxCUmVxdWVzdENvdW50UGVyVGFyZ2V0YFxuICAgICAqXG4gICAgICogSWYgeW91IHNwZWNpZnkgYEFMQlJlcXVlc3RDb3VudFBlclRhcmdldGAgZm9yIHRoZSBtZXRyaWMsIHlvdSBtdXN0IHNwZWNpZnkgdGhlIGBSZXNvdXJjZUxhYmVsYCBwcm9wZXJ0eSB3aXRoIHRoZSBgUHJlZGVmaW5lZE1ldHJpY1NwZWNpZmljYXRpb25gIC5cbiAgICAgKlxuICAgICAqIFJlcXVpcmVkIGlmIHRoZSBwb2xpY3kgdHlwZSBpcyBgVGFyZ2V0VHJhY2tpbmdTY2FsaW5nYCAuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1hdXRvc2NhbGluZy1zY2FsaW5ncG9saWN5Lmh0bWwjY2ZuLWF1dG9zY2FsaW5nLXNjYWxpbmdwb2xpY3ktdGFyZ2V0dHJhY2tpbmdjb25maWd1cmF0aW9uXG4gICAgICovXG4gICAgcHVibGljIHRhcmdldFRyYWNraW5nQ29uZmlndXJhdGlvbjogQ2ZuU2NhbGluZ1BvbGljeS5UYXJnZXRUcmFja2luZ0NvbmZpZ3VyYXRpb25Qcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZSB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIENyZWF0ZSBhIG5ldyBgQVdTOjpBdXRvU2NhbGluZzo6U2NhbGluZ1BvbGljeWAuXG4gICAgICpcbiAgICAgKiBAcGFyYW0gc2NvcGUgLSBzY29wZSBpbiB3aGljaCB0aGlzIHJlc291cmNlIGlzIGRlZmluZWRcbiAgICAgKiBAcGFyYW0gaWQgICAgLSBzY29wZWQgaWQgb2YgdGhlIHJlc291cmNlXG4gICAgICogQHBhcmFtIHByb3BzIC0gcmVzb3VyY2UgcHJvcGVydGllc1xuICAgICAqL1xuICAgIGNvbnN0cnVjdG9yKHNjb3BlOiBjZGsuQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogQ2ZuU2NhbGluZ1BvbGljeVByb3BzKSB7XG4gICAgICAgIHN1cGVyKHNjb3BlLCBpZCwgeyB0eXBlOiBDZm5TY2FsaW5nUG9saWN5LkNGTl9SRVNPVVJDRV9UWVBFX05BTUUsIHByb3BlcnRpZXM6IHByb3BzIH0pO1xuICAgICAgICBjZGsucmVxdWlyZVByb3BlcnR5KHByb3BzLCAnYXV0b1NjYWxpbmdHcm91cE5hbWUnLCB0aGlzKTtcbiAgICAgICAgdGhpcy5hdHRyQXJuID0gY2RrLlRva2VuLmFzU3RyaW5nKHRoaXMuZ2V0QXR0KCdBcm4nKSk7XG4gICAgICAgIHRoaXMuYXR0clBvbGljeU5hbWUgPSBjZGsuVG9rZW4uYXNTdHJpbmcodGhpcy5nZXRBdHQoJ1BvbGljeU5hbWUnKSk7XG5cbiAgICAgICAgdGhpcy5hdXRvU2NhbGluZ0dyb3VwTmFtZSA9IHByb3BzLmF1dG9TY2FsaW5nR3JvdXBOYW1lO1xuICAgICAgICB0aGlzLmFkanVzdG1lbnRUeXBlID0gcHJvcHMuYWRqdXN0bWVudFR5cGU7XG4gICAgICAgIHRoaXMuY29vbGRvd24gPSBwcm9wcy5jb29sZG93bjtcbiAgICAgICAgdGhpcy5lc3RpbWF0ZWRJbnN0YW5jZVdhcm11cCA9IHByb3BzLmVzdGltYXRlZEluc3RhbmNlV2FybXVwO1xuICAgICAgICB0aGlzLm1ldHJpY0FnZ3JlZ2F0aW9uVHlwZSA9IHByb3BzLm1ldHJpY0FnZ3JlZ2F0aW9uVHlwZTtcbiAgICAgICAgdGhpcy5taW5BZGp1c3RtZW50TWFnbml0dWRlID0gcHJvcHMubWluQWRqdXN0bWVudE1hZ25pdHVkZTtcbiAgICAgICAgdGhpcy5wb2xpY3lUeXBlID0gcHJvcHMucG9saWN5VHlwZTtcbiAgICAgICAgdGhpcy5wcmVkaWN0aXZlU2NhbGluZ0NvbmZpZ3VyYXRpb24gPSBwcm9wcy5wcmVkaWN0aXZlU2NhbGluZ0NvbmZpZ3VyYXRpb247XG4gICAgICAgIHRoaXMuc2NhbGluZ0FkanVzdG1lbnQgPSBwcm9wcy5zY2FsaW5nQWRqdXN0bWVudDtcbiAgICAgICAgdGhpcy5zdGVwQWRqdXN0bWVudHMgPSBwcm9wcy5zdGVwQWRqdXN0bWVudHM7XG4gICAgICAgIHRoaXMudGFyZ2V0VHJhY2tpbmdDb25maWd1cmF0aW9uID0gcHJvcHMudGFyZ2V0VHJhY2tpbmdDb25maWd1cmF0aW9uO1xuICAgIH1cblxuICAgIC8qKlxuICAgICAqIEV4YW1pbmVzIHRoZSBDbG91ZEZvcm1hdGlvbiByZXNvdXJjZSBhbmQgZGlzY2xvc2VzIGF0dHJpYnV0ZXMuXG4gICAgICpcbiAgICAgKiBAcGFyYW0gaW5zcGVjdG9yIC0gdHJlZSBpbnNwZWN0b3IgdG8gY29sbGVjdCBhbmQgcHJvY2VzcyBhdHRyaWJ1dGVzXG4gICAgICpcbiAgICAgKi9cbiAgICBwdWJsaWMgaW5zcGVjdChpbnNwZWN0b3I6IGNkay5UcmVlSW5zcGVjdG9yKSB7XG4gICAgICAgIGluc3BlY3Rvci5hZGRBdHRyaWJ1dGUoXCJhd3M6Y2RrOmNsb3VkZm9ybWF0aW9uOnR5cGVcIiwgQ2ZuU2NhbGluZ1BvbGljeS5DRk5fUkVTT1VSQ0VfVFlQRV9OQU1FKTtcbiAgICAgICAgaW5zcGVjdG9yLmFkZEF0dHJpYnV0ZShcImF3czpjZGs6Y2xvdWRmb3JtYXRpb246cHJvcHNcIiwgdGhpcy5jZm5Qcm9wZXJ0aWVzKTtcbiAgICB9XG5cbiAgICBwcm90ZWN0ZWQgZ2V0IGNmblByb3BlcnRpZXMoKTogeyBba2V5OiBzdHJpbmddOiBhbnkgfSAge1xuICAgICAgICByZXR1cm4ge1xuICAgICAgICAgICAgYXV0b1NjYWxpbmdHcm91cE5hbWU6IHRoaXMuYXV0b1NjYWxpbmdHcm91cE5hbWUsXG4gICAgICAgICAgICBhZGp1c3RtZW50VHlwZTogdGhpcy5hZGp1c3RtZW50VHlwZSxcbiAgICAgICAgICAgIGNvb2xkb3duOiB0aGlzLmNvb2xkb3duLFxuICAgICAgICAgICAgZXN0aW1hdGVkSW5zdGFuY2VXYXJtdXA6IHRoaXMuZXN0aW1hdGVkSW5zdGFuY2VXYXJtdXAsXG4gICAgICAgICAgICBtZXRyaWNBZ2dyZWdhdGlvblR5cGU6IHRoaXMubWV0cmljQWdncmVnYXRpb25UeXBlLFxuICAgICAgICAgICAgbWluQWRqdXN0bWVudE1hZ25pdHVkZTogdGhpcy5taW5BZGp1c3RtZW50TWFnbml0dWRlLFxuICAgICAgICAgICAgcG9saWN5VHlwZTogdGhpcy5wb2xpY3lUeXBlLFxuICAgICAgICAgICAgcHJlZGljdGl2ZVNjYWxpbmdDb25maWd1cmF0aW9uOiB0aGlzLnByZWRpY3RpdmVTY2FsaW5nQ29uZmlndXJhdGlvbixcbiAgICAgICAgICAgIHNjYWxpbmdBZGp1c3RtZW50OiB0aGlzLnNjYWxpbmdBZGp1c3RtZW50LFxuICAgICAgICAgICAgc3RlcEFkanVzdG1lbnRzOiB0aGlzLnN0ZXBBZGp1c3RtZW50cyxcbiAgICAgICAgICAgIHRhcmdldFRyYWNraW5nQ29uZmlndXJhdGlvbjogdGhpcy50YXJnZXRUcmFja2luZ0NvbmZpZ3VyYXRpb24sXG4gICAgICAgIH07XG4gICAgfVxuXG4gICAgcHJvdGVjdGVkIHJlbmRlclByb3BlcnRpZXMocHJvcHM6IHtba2V5OiBzdHJpbmddOiBhbnl9KTogeyBba2V5OiBzdHJpbmddOiBhbnkgfSAge1xuICAgICAgICByZXR1cm4gY2ZuU2NhbGluZ1BvbGljeVByb3BzVG9DbG91ZEZvcm1hdGlvbihwcm9wcyk7XG4gICAgfVxufVxuXG5leHBvcnQgbmFtZXNwYWNlIENmblNjYWxpbmdQb2xpY3kge1xuICAgIC8qKlxuICAgICAqIENvbnRhaW5zIGN1c3RvbWl6ZWQgbWV0cmljIHNwZWNpZmljYXRpb24gaW5mb3JtYXRpb24gZm9yIGEgdGFyZ2V0IHRyYWNraW5nIHNjYWxpbmcgcG9saWN5IGZvciBBbWF6b24gRUMyIEF1dG8gU2NhbGluZy5cbiAgICAgKlxuICAgICAqIFRvIGNyZWF0ZSB5b3VyIGN1c3RvbWl6ZWQgbWV0cmljIHNwZWNpZmljYXRpb246XG4gICAgICpcbiAgICAgKiAtIEFkZCB2YWx1ZXMgZm9yIGVhY2ggcmVxdWlyZWQgcHJvcGVydHkgZnJvbSBDbG91ZFdhdGNoLiBZb3UgY2FuIHVzZSBhbiBleGlzdGluZyBtZXRyaWMsIG9yIGEgbmV3IG1ldHJpYyB0aGF0IHlvdSBjcmVhdGUuIFRvIHVzZSB5b3VyIG93biBtZXRyaWMsIHlvdSBtdXN0IGZpcnN0IHB1Ymxpc2ggdGhlIG1ldHJpYyB0byBDbG91ZFdhdGNoLiBGb3IgbW9yZSBpbmZvcm1hdGlvbiwgc2VlIFtQdWJsaXNoIEN1c3RvbSBNZXRyaWNzXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQW1hem9uQ2xvdWRXYXRjaC9sYXRlc3QvbW9uaXRvcmluZy9wdWJsaXNoaW5nTWV0cmljcy5odG1sKSBpbiB0aGUgKkFtYXpvbiBDbG91ZFdhdGNoIFVzZXIgR3VpZGUqIC5cbiAgICAgKiAtIENob29zZSBhIG1ldHJpYyB0aGF0IGNoYW5nZXMgcHJvcG9ydGlvbmFsbHkgd2l0aCBjYXBhY2l0eS4gVGhlIHZhbHVlIG9mIHRoZSBtZXRyaWMgc2hvdWxkIGluY3JlYXNlIG9yIGRlY3JlYXNlIGluIGludmVyc2UgcHJvcG9ydGlvbiB0byB0aGUgbnVtYmVyIG9mIGNhcGFjaXR5IHVuaXRzLiBUaGF0IGlzLCB0aGUgdmFsdWUgb2YgdGhlIG1ldHJpYyBzaG91bGQgZGVjcmVhc2Ugd2hlbiBjYXBhY2l0eSBpbmNyZWFzZXMuXG4gICAgICpcbiAgICAgKiBGb3IgbW9yZSBpbmZvcm1hdGlvbiBhYm91dCBDbG91ZFdhdGNoLCBzZWUgW0FtYXpvbiBDbG91ZFdhdGNoIENvbmNlcHRzXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQW1hem9uQ2xvdWRXYXRjaC9sYXRlc3QvbW9uaXRvcmluZy9jbG91ZHdhdGNoX2NvbmNlcHRzLmh0bWwpIC5cbiAgICAgKlxuICAgICAqIGBDdXN0b21pemVkTWV0cmljU3BlY2lmaWNhdGlvbmAgaXMgYSBwcm9wZXJ0eSBvZiB0aGUgW0FXUzo6QXV0b1NjYWxpbmc6OlNjYWxpbmdQb2xpY3kgVGFyZ2V0VHJhY2tpbmdDb25maWd1cmF0aW9uXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hdXRvc2NhbGluZy1zY2FsaW5ncG9saWN5LXRhcmdldHRyYWNraW5nY29uZmlndXJhdGlvbi5odG1sKSBwcm9wZXJ0eSB0eXBlLlxuICAgICAqXG4gICAgICogQHN0cnVjdFxuICAgICAqIEBzdGFiaWxpdHkgZXh0ZXJuYWxcbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXV0b3NjYWxpbmctc2NhbGluZ3BvbGljeS1jdXN0b21pemVkbWV0cmljc3BlY2lmaWNhdGlvbi5odG1sXG4gICAgICovXG4gICAgZXhwb3J0IGludGVyZmFjZSBDdXN0b21pemVkTWV0cmljU3BlY2lmaWNhdGlvblByb3BlcnR5IHtcbiAgICAgICAgLyoqXG4gICAgICAgICAqIFRoZSBkaW1lbnNpb25zIG9mIHRoZSBtZXRyaWMuXG4gICAgICAgICAqXG4gICAgICAgICAqIENvbmRpdGlvbmFsOiBJZiB5b3UgcHVibGlzaGVkIHlvdXIgbWV0cmljIHdpdGggZGltZW5zaW9ucywgeW91IG11c3Qgc3BlY2lmeSB0aGUgc2FtZSBkaW1lbnNpb25zIGluIHlvdXIgc2NhbGluZyBwb2xpY3kuXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXV0b3NjYWxpbmctc2NhbGluZ3BvbGljeS1jdXN0b21pemVkbWV0cmljc3BlY2lmaWNhdGlvbi5odG1sI2Nmbi1hdXRvc2NhbGluZy1zY2FsaW5ncG9saWN5LWN1c3RvbWl6ZWRtZXRyaWNzcGVjaWZpY2F0aW9uLWRpbWVuc2lvbnNcbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IGRpbWVuc2lvbnM/OiBBcnJheTxDZm5TY2FsaW5nUG9saWN5Lk1ldHJpY0RpbWVuc2lvblByb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlPiB8IGNkay5JUmVzb2x2YWJsZTtcbiAgICAgICAgLyoqXG4gICAgICAgICAqIFRoZSBuYW1lIG9mIHRoZSBtZXRyaWMuIFRvIGdldCB0aGUgZXhhY3QgbWV0cmljIG5hbWUsIG5hbWVzcGFjZSwgYW5kIGRpbWVuc2lvbnMsIGluc3BlY3QgdGhlIFtNZXRyaWNdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BbWF6b25DbG91ZFdhdGNoL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX01ldHJpYy5odG1sKSBvYmplY3QgdGhhdCBpcyByZXR1cm5lZCBieSBhIGNhbGwgdG8gW0xpc3RNZXRyaWNzXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQW1hem9uQ2xvdWRXYXRjaC9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9MaXN0TWV0cmljcy5odG1sKSAuXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXV0b3NjYWxpbmctc2NhbGluZ3BvbGljeS1jdXN0b21pemVkbWV0cmljc3BlY2lmaWNhdGlvbi5odG1sI2Nmbi1hdXRvc2NhbGluZy1zY2FsaW5ncG9saWN5LWN1c3RvbWl6ZWRtZXRyaWNzcGVjaWZpY2F0aW9uLW1ldHJpY25hbWVcbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IG1ldHJpY05hbWU6IHN0cmluZztcbiAgICAgICAgLyoqXG4gICAgICAgICAqIFRoZSBuYW1lc3BhY2Ugb2YgdGhlIG1ldHJpYy5cbiAgICAgICAgICpcbiAgICAgICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hdXRvc2NhbGluZy1zY2FsaW5ncG9saWN5LWN1c3RvbWl6ZWRtZXRyaWNzcGVjaWZpY2F0aW9uLmh0bWwjY2ZuLWF1dG9zY2FsaW5nLXNjYWxpbmdwb2xpY3ktY3VzdG9taXplZG1ldHJpY3NwZWNpZmljYXRpb24tbmFtZXNwYWNlXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBuYW1lc3BhY2U6IHN0cmluZztcbiAgICAgICAgLyoqXG4gICAgICAgICAqIFRoZSBzdGF0aXN0aWMgb2YgdGhlIG1ldHJpYy5cbiAgICAgICAgICpcbiAgICAgICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hdXRvc2NhbGluZy1zY2FsaW5ncG9saWN5LWN1c3RvbWl6ZWRtZXRyaWNzcGVjaWZpY2F0aW9uLmh0bWwjY2ZuLWF1dG9zY2FsaW5nLXNjYWxpbmdwb2xpY3ktY3VzdG9taXplZG1ldHJpY3NwZWNpZmljYXRpb24tc3RhdGlzdGljXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBzdGF0aXN0aWM6IHN0cmluZztcbiAgICAgICAgLyoqXG4gICAgICAgICAqIFRoZSB1bml0IG9mIHRoZSBtZXRyaWMuIEZvciBhIGNvbXBsZXRlIGxpc3Qgb2YgdGhlIHVuaXRzIHRoYXQgQ2xvdWRXYXRjaCBzdXBwb3J0cywgc2VlIHRoZSBbTWV0cmljRGF0dW1dKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BbWF6b25DbG91ZFdhdGNoL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX01ldHJpY0RhdHVtLmh0bWwpIGRhdGEgdHlwZSBpbiB0aGUgKkFtYXpvbiBDbG91ZFdhdGNoIEFQSSBSZWZlcmVuY2UqIC5cbiAgICAgICAgICpcbiAgICAgICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hdXRvc2NhbGluZy1zY2FsaW5ncG9saWN5LWN1c3RvbWl6ZWRtZXRyaWNzcGVjaWZpY2F0aW9uLmh0bWwjY2ZuLWF1dG9zY2FsaW5nLXNjYWxpbmdwb2xpY3ktY3VzdG9taXplZG1ldHJpY3NwZWNpZmljYXRpb24tdW5pdFxuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgdW5pdD86IHN0cmluZztcbiAgICB9XG59XG5cbi8qKlxuICogRGV0ZXJtaW5lIHdoZXRoZXIgdGhlIGdpdmVuIHByb3BlcnRpZXMgbWF0Y2ggdGhvc2Ugb2YgYSBgQ3VzdG9taXplZE1ldHJpY1NwZWNpZmljYXRpb25Qcm9wZXJ0eWBcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgQ3VzdG9taXplZE1ldHJpY1NwZWNpZmljYXRpb25Qcm9wZXJ0eWBcbiAqXG4gKiBAcmV0dXJucyB0aGUgcmVzdWx0IG9mIHRoZSB2YWxpZGF0aW9uLlxuICovXG5mdW5jdGlvbiBDZm5TY2FsaW5nUG9saWN5X0N1c3RvbWl6ZWRNZXRyaWNTcGVjaWZpY2F0aW9uUHJvcGVydHlWYWxpZGF0b3IocHJvcGVydGllczogYW55KTogY2RrLlZhbGlkYXRpb25SZXN1bHQge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIGNkay5WQUxJREFUSU9OX1NVQ0NFU1M7IH1cbiAgICBjb25zdCBlcnJvcnMgPSBuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHRzKCk7XG4gICAgaWYgKHR5cGVvZiBwcm9wZXJ0aWVzICE9PSAnb2JqZWN0Jykge1xuICAgICAgICBlcnJvcnMuY29sbGVjdChuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHQoJ0V4cGVjdGVkIGFuIG9iamVjdCwgYnV0IHJlY2VpdmVkOiAnICsgSlNPTi5zdHJpbmdpZnkocHJvcGVydGllcykpKTtcbiAgICB9XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdkaW1lbnNpb25zJywgY2RrLmxpc3RWYWxpZGF0b3IoQ2ZuU2NhbGluZ1BvbGljeV9NZXRyaWNEaW1lbnNpb25Qcm9wZXJ0eVZhbGlkYXRvcikpKHByb3BlcnRpZXMuZGltZW5zaW9ucykpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignbWV0cmljTmFtZScsIGNkay5yZXF1aXJlZFZhbGlkYXRvcikocHJvcGVydGllcy5tZXRyaWNOYW1lKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdtZXRyaWNOYW1lJywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLm1ldHJpY05hbWUpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ25hbWVzcGFjZScsIGNkay5yZXF1aXJlZFZhbGlkYXRvcikocHJvcGVydGllcy5uYW1lc3BhY2UpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ25hbWVzcGFjZScsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5uYW1lc3BhY2UpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3N0YXRpc3RpYycsIGNkay5yZXF1aXJlZFZhbGlkYXRvcikocHJvcGVydGllcy5zdGF0aXN0aWMpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3N0YXRpc3RpYycsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5zdGF0aXN0aWMpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3VuaXQnLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMudW5pdCkpO1xuICAgIHJldHVybiBlcnJvcnMud3JhcCgnc3VwcGxpZWQgcHJvcGVydGllcyBub3QgY29ycmVjdCBmb3IgXCJDdXN0b21pemVkTWV0cmljU3BlY2lmaWNhdGlvblByb3BlcnR5XCInKTtcbn1cblxuLyoqXG4gKiBSZW5kZXJzIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpBdXRvU2NhbGluZzo6U2NhbGluZ1BvbGljeS5DdXN0b21pemVkTWV0cmljU3BlY2lmaWNhdGlvbmAgcmVzb3VyY2VcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgQ3VzdG9taXplZE1ldHJpY1NwZWNpZmljYXRpb25Qcm9wZXJ0eWBcbiAqXG4gKiBAcmV0dXJucyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6QXV0b1NjYWxpbmc6OlNjYWxpbmdQb2xpY3kuQ3VzdG9taXplZE1ldHJpY1NwZWNpZmljYXRpb25gIHJlc291cmNlLlxuICovXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gY2ZuU2NhbGluZ1BvbGljeUN1c3RvbWl6ZWRNZXRyaWNTcGVjaWZpY2F0aW9uUHJvcGVydHlUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGFueSB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gcHJvcGVydGllczsgfVxuICAgIENmblNjYWxpbmdQb2xpY3lfQ3VzdG9taXplZE1ldHJpY1NwZWNpZmljYXRpb25Qcm9wZXJ0eVZhbGlkYXRvcihwcm9wZXJ0aWVzKS5hc3NlcnRTdWNjZXNzKCk7XG4gICAgcmV0dXJuIHtcbiAgICAgICAgRGltZW5zaW9uczogY2RrLmxpc3RNYXBwZXIoY2ZuU2NhbGluZ1BvbGljeU1ldHJpY0RpbWVuc2lvblByb3BlcnR5VG9DbG91ZEZvcm1hdGlvbikocHJvcGVydGllcy5kaW1lbnNpb25zKSxcbiAgICAgICAgTWV0cmljTmFtZTogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5tZXRyaWNOYW1lKSxcbiAgICAgICAgTmFtZXNwYWNlOiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLm5hbWVzcGFjZSksXG4gICAgICAgIFN0YXRpc3RpYzogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5zdGF0aXN0aWMpLFxuICAgICAgICBVbml0OiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLnVuaXQpLFxuICAgIH07XG59XG5cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBDZm5TY2FsaW5nUG9saWN5Q3VzdG9taXplZE1ldHJpY1NwZWNpZmljYXRpb25Qcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0PENmblNjYWxpbmdQb2xpY3kuQ3VzdG9taXplZE1ldHJpY1NwZWNpZmljYXRpb25Qcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZT4ge1xuICAgIGlmIChjZGsuaXNSZXNvbHZhYmxlT2JqZWN0KHByb3BlcnRpZXMpKSB7XG4gICAgICAgIHJldHVybiBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdChwcm9wZXJ0aWVzKTtcbiAgICB9XG4gICAgcHJvcGVydGllcyA9IHByb3BlcnRpZXMgPT0gbnVsbCA/IHt9IDogcHJvcGVydGllcztcbiAgICBpZiAodHlwZW9mIHByb3BlcnRpZXMgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIHJldHVybiBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdChwcm9wZXJ0aWVzKTtcbiAgICB9XG4gICAgY29uc3QgcmV0ID0gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25Qcm9wZXJ0eU9iamVjdDxDZm5TY2FsaW5nUG9saWN5LkN1c3RvbWl6ZWRNZXRyaWNTcGVjaWZpY2F0aW9uUHJvcGVydHk+KCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdkaW1lbnNpb25zJywgJ0RpbWVuc2lvbnMnLCBwcm9wZXJ0aWVzLkRpbWVuc2lvbnMgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0QXJyYXkoQ2ZuU2NhbGluZ1BvbGljeU1ldHJpY0RpbWVuc2lvblByb3BlcnR5RnJvbUNsb3VkRm9ybWF0aW9uKShwcm9wZXJ0aWVzLkRpbWVuc2lvbnMpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ21ldHJpY05hbWUnLCAnTWV0cmljTmFtZScsIGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuTWV0cmljTmFtZSkpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnbmFtZXNwYWNlJywgJ05hbWVzcGFjZScsIGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuTmFtZXNwYWNlKSk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdzdGF0aXN0aWMnLCAnU3RhdGlzdGljJywgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5TdGF0aXN0aWMpKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ3VuaXQnLCAnVW5pdCcsIHByb3BlcnRpZXMuVW5pdCAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5Vbml0KSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFVucmVjb2duaXplZFByb3BlcnRpZXNBc0V4dHJhKHByb3BlcnRpZXMpO1xuICAgIHJldHVybiByZXQ7XG59XG5cbmV4cG9ydCBuYW1lc3BhY2UgQ2ZuU2NhbGluZ1BvbGljeSB7XG4gICAgLyoqXG4gICAgICogUmVwcmVzZW50cyBhIHNwZWNpZmljIG1ldHJpYy5cbiAgICAgKlxuICAgICAqIGBNZXRyaWNgIGlzIGEgcHJvcGVydHkgb2YgdGhlIFtBV1M6OkF1dG9TY2FsaW5nOjpTY2FsaW5nUG9saWN5IE1ldHJpY1N0YXRdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWF1dG9zY2FsaW5nLXNjYWxpbmdwb2xpY3ktbWV0cmljc3RhdC5odG1sKSBwcm9wZXJ0eSB0eXBlLlxuICAgICAqXG4gICAgICogQHN0cnVjdFxuICAgICAqIEBzdGFiaWxpdHkgZXh0ZXJuYWxcbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXV0b3NjYWxpbmctc2NhbGluZ3BvbGljeS1tZXRyaWMuaHRtbFxuICAgICAqL1xuICAgIGV4cG9ydCBpbnRlcmZhY2UgTWV0cmljUHJvcGVydHkge1xuICAgICAgICAvKipcbiAgICAgICAgICogVGhlIGRpbWVuc2lvbnMgZm9yIHRoZSBtZXRyaWMuIEZvciB0aGUgbGlzdCBvZiBhdmFpbGFibGUgZGltZW5zaW9ucywgc2VlIHRoZSBBV1MgZG9jdW1lbnRhdGlvbiBhdmFpbGFibGUgZnJvbSB0aGUgdGFibGUgaW4gW0FXUyBzZXJ2aWNlcyB0aGF0IHB1Ymxpc2ggQ2xvdWRXYXRjaCBtZXRyaWNzXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQW1hem9uQ2xvdWRXYXRjaC9sYXRlc3QvbW9uaXRvcmluZy9hd3Mtc2VydmljZXMtY2xvdWR3YXRjaC1tZXRyaWNzLmh0bWwpIGluIHRoZSAqQW1hem9uIENsb3VkV2F0Y2ggVXNlciBHdWlkZSogLlxuICAgICAgICAgKlxuICAgICAgICAgKiBDb25kaXRpb25hbDogSWYgeW91IHB1Ymxpc2hlZCB5b3VyIG1ldHJpYyB3aXRoIGRpbWVuc2lvbnMsIHlvdSBtdXN0IHNwZWNpZnkgdGhlIHNhbWUgZGltZW5zaW9ucyBpbiB5b3VyIHNjYWxpbmcgcG9saWN5LlxuICAgICAgICAgKlxuICAgICAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWF1dG9zY2FsaW5nLXNjYWxpbmdwb2xpY3ktbWV0cmljLmh0bWwjY2ZuLWF1dG9zY2FsaW5nLXNjYWxpbmdwb2xpY3ktbWV0cmljLWRpbWVuc2lvbnNcbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IGRpbWVuc2lvbnM/OiBBcnJheTxDZm5TY2FsaW5nUG9saWN5Lk1ldHJpY0RpbWVuc2lvblByb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlPiB8IGNkay5JUmVzb2x2YWJsZTtcbiAgICAgICAgLyoqXG4gICAgICAgICAqIFRoZSBuYW1lIG9mIHRoZSBtZXRyaWMuXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXV0b3NjYWxpbmctc2NhbGluZ3BvbGljeS1tZXRyaWMuaHRtbCNjZm4tYXV0b3NjYWxpbmctc2NhbGluZ3BvbGljeS1tZXRyaWMtbWV0cmljbmFtZVxuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgbWV0cmljTmFtZTogc3RyaW5nO1xuICAgICAgICAvKipcbiAgICAgICAgICogVGhlIG5hbWVzcGFjZSBvZiB0aGUgbWV0cmljLiBGb3IgbW9yZSBpbmZvcm1hdGlvbiwgc2VlIHRoZSB0YWJsZSBpbiBbQVdTIHNlcnZpY2VzIHRoYXQgcHVibGlzaCBDbG91ZFdhdGNoIG1ldHJpY3NdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BbWF6b25DbG91ZFdhdGNoL2xhdGVzdC9tb25pdG9yaW5nL2F3cy1zZXJ2aWNlcy1jbG91ZHdhdGNoLW1ldHJpY3MuaHRtbCkgaW4gdGhlICpBbWF6b24gQ2xvdWRXYXRjaCBVc2VyIEd1aWRlKiAuXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXV0b3NjYWxpbmctc2NhbGluZ3BvbGljeS1tZXRyaWMuaHRtbCNjZm4tYXV0b3NjYWxpbmctc2NhbGluZ3BvbGljeS1tZXRyaWMtbmFtZXNwYWNlXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBuYW1lc3BhY2U6IHN0cmluZztcbiAgICB9XG59XG5cbi8qKlxuICogRGV0ZXJtaW5lIHdoZXRoZXIgdGhlIGdpdmVuIHByb3BlcnRpZXMgbWF0Y2ggdGhvc2Ugb2YgYSBgTWV0cmljUHJvcGVydHlgXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYE1ldHJpY1Byb3BlcnR5YFxuICpcbiAqIEByZXR1cm5zIHRoZSByZXN1bHQgb2YgdGhlIHZhbGlkYXRpb24uXG4gKi9cbmZ1bmN0aW9uIENmblNjYWxpbmdQb2xpY3lfTWV0cmljUHJvcGVydHlWYWxpZGF0b3IocHJvcGVydGllczogYW55KTogY2RrLlZhbGlkYXRpb25SZXN1bHQge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIGNkay5WQUxJREFUSU9OX1NVQ0NFU1M7IH1cbiAgICBjb25zdCBlcnJvcnMgPSBuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHRzKCk7XG4gICAgaWYgKHR5cGVvZiBwcm9wZXJ0aWVzICE9PSAnb2JqZWN0Jykge1xuICAgICAgICBlcnJvcnMuY29sbGVjdChuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHQoJ0V4cGVjdGVkIGFuIG9iamVjdCwgYnV0IHJlY2VpdmVkOiAnICsgSlNPTi5zdHJpbmdpZnkocHJvcGVydGllcykpKTtcbiAgICB9XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdkaW1lbnNpb25zJywgY2RrLmxpc3RWYWxpZGF0b3IoQ2ZuU2NhbGluZ1BvbGljeV9NZXRyaWNEaW1lbnNpb25Qcm9wZXJ0eVZhbGlkYXRvcikpKHByb3BlcnRpZXMuZGltZW5zaW9ucykpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignbWV0cmljTmFtZScsIGNkay5yZXF1aXJlZFZhbGlkYXRvcikocHJvcGVydGllcy5tZXRyaWNOYW1lKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdtZXRyaWNOYW1lJywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLm1ldHJpY05hbWUpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ25hbWVzcGFjZScsIGNkay5yZXF1aXJlZFZhbGlkYXRvcikocHJvcGVydGllcy5uYW1lc3BhY2UpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ25hbWVzcGFjZScsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5uYW1lc3BhY2UpKTtcbiAgICByZXR1cm4gZXJyb3JzLndyYXAoJ3N1cHBsaWVkIHByb3BlcnRpZXMgbm90IGNvcnJlY3QgZm9yIFwiTWV0cmljUHJvcGVydHlcIicpO1xufVxuXG4vKipcbiAqIFJlbmRlcnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OkF1dG9TY2FsaW5nOjpTY2FsaW5nUG9saWN5Lk1ldHJpY2AgcmVzb3VyY2VcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgTWV0cmljUHJvcGVydHlgXG4gKlxuICogQHJldHVybnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OkF1dG9TY2FsaW5nOjpTY2FsaW5nUG9saWN5Lk1ldHJpY2AgcmVzb3VyY2UuXG4gKi9cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBjZm5TY2FsaW5nUG9saWN5TWV0cmljUHJvcGVydHlUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGFueSB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gcHJvcGVydGllczsgfVxuICAgIENmblNjYWxpbmdQb2xpY3lfTWV0cmljUHJvcGVydHlWYWxpZGF0b3IocHJvcGVydGllcykuYXNzZXJ0U3VjY2VzcygpO1xuICAgIHJldHVybiB7XG4gICAgICAgIERpbWVuc2lvbnM6IGNkay5saXN0TWFwcGVyKGNmblNjYWxpbmdQb2xpY3lNZXRyaWNEaW1lbnNpb25Qcm9wZXJ0eVRvQ2xvdWRGb3JtYXRpb24pKHByb3BlcnRpZXMuZGltZW5zaW9ucyksXG4gICAgICAgIE1ldHJpY05hbWU6IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMubWV0cmljTmFtZSksXG4gICAgICAgIE5hbWVzcGFjZTogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5uYW1lc3BhY2UpLFxuICAgIH07XG59XG5cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBDZm5TY2FsaW5nUG9saWN5TWV0cmljUHJvcGVydHlGcm9tQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdDxDZm5TY2FsaW5nUG9saWN5Lk1ldHJpY1Byb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlPiB7XG4gICAgaWYgKGNkay5pc1Jlc29sdmFibGVPYmplY3QocHJvcGVydGllcykpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0KHByb3BlcnRpZXMpO1xuICAgIH1cbiAgICBwcm9wZXJ0aWVzID0gcHJvcGVydGllcyA9PSBudWxsID8ge30gOiBwcm9wZXJ0aWVzO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0KHByb3BlcnRpZXMpO1xuICAgIH1cbiAgICBjb25zdCByZXQgPSBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblByb3BlcnR5T2JqZWN0PENmblNjYWxpbmdQb2xpY3kuTWV0cmljUHJvcGVydHk+KCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdkaW1lbnNpb25zJywgJ0RpbWVuc2lvbnMnLCBwcm9wZXJ0aWVzLkRpbWVuc2lvbnMgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0QXJyYXkoQ2ZuU2NhbGluZ1BvbGljeU1ldHJpY0RpbWVuc2lvblByb3BlcnR5RnJvbUNsb3VkRm9ybWF0aW9uKShwcm9wZXJ0aWVzLkRpbWVuc2lvbnMpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ21ldHJpY05hbWUnLCAnTWV0cmljTmFtZScsIGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuTWV0cmljTmFtZSkpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnbmFtZXNwYWNlJywgJ05hbWVzcGFjZScsIGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuTmFtZXNwYWNlKSk7XG4gICAgcmV0LmFkZFVucmVjb2duaXplZFByb3BlcnRpZXNBc0V4dHJhKHByb3BlcnRpZXMpO1xuICAgIHJldHVybiByZXQ7XG59XG5cbmV4cG9ydCBuYW1lc3BhY2UgQ2ZuU2NhbGluZ1BvbGljeSB7XG4gICAgLyoqXG4gICAgICogVGhlIG1ldHJpYyBkYXRhIHRvIHJldHVybi4gQWxzbyBkZWZpbmVzIHdoZXRoZXIgdGhpcyBjYWxsIGlzIHJldHVybmluZyBkYXRhIGZvciBvbmUgbWV0cmljIG9ubHksIG9yIHdoZXRoZXIgaXQgaXMgcGVyZm9ybWluZyBhIG1hdGggZXhwcmVzc2lvbiBvbiB0aGUgdmFsdWVzIG9mIHJldHVybmVkIG1ldHJpYyBzdGF0aXN0aWNzIHRvIGNyZWF0ZSBhIG5ldyB0aW1lIHNlcmllcy4gQSB0aW1lIHNlcmllcyBpcyBhIHNlcmllcyBvZiBkYXRhIHBvaW50cywgZWFjaCBvZiB3aGljaCBpcyBhc3NvY2lhdGVkIHdpdGggYSB0aW1lc3RhbXAuXG4gICAgICpcbiAgICAgKiBgTWV0cmljRGF0YVF1ZXJ5YCBpcyBhIHByb3BlcnR5IG9mIHRoZSBmb2xsb3dpbmcgcHJvcGVydHkgdHlwZXM6XG4gICAgICpcbiAgICAgKiAtIFtBV1M6OkF1dG9TY2FsaW5nOjpTY2FsaW5nUG9saWN5IFByZWRpY3RpdmVTY2FsaW5nQ3VzdG9taXplZFNjYWxpbmdNZXRyaWNdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWF1dG9zY2FsaW5nLXNjYWxpbmdwb2xpY3ktcHJlZGljdGl2ZXNjYWxpbmdjdXN0b21pemVkc2NhbGluZ21ldHJpYy5odG1sKVxuICAgICAqIC0gW0FXUzo6QXV0b1NjYWxpbmc6OlNjYWxpbmdQb2xpY3kgUHJlZGljdGl2ZVNjYWxpbmdDdXN0b21pemVkTG9hZE1ldHJpY10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXV0b3NjYWxpbmctc2NhbGluZ3BvbGljeS1wcmVkaWN0aXZlc2NhbGluZ2N1c3RvbWl6ZWRsb2FkbWV0cmljLmh0bWwpXG4gICAgICogLSBbQVdTOjpBdXRvU2NhbGluZzo6U2NhbGluZ1BvbGljeSBQcmVkaWN0aXZlU2NhbGluZ0N1c3RvbWl6ZWRDYXBhY2l0eU1ldHJpY10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXV0b3NjYWxpbmctc2NhbGluZ3BvbGljeS1wcmVkaWN0aXZlc2NhbGluZ2N1c3RvbWl6ZWRjYXBhY2l0eW1ldHJpYy5odG1sKVxuICAgICAqXG4gICAgICogUHJlZGljdGl2ZSBzY2FsaW5nIHVzZXMgdGhlIHRpbWUgc2VyaWVzIGRhdGEgcmVjZWl2ZWQgZnJvbSBDbG91ZFdhdGNoIHRvIHVuZGVyc3RhbmQgaG93IHRvIHNjaGVkdWxlIGNhcGFjaXR5IGJhc2VkIG9uIHlvdXIgaGlzdG9yaWNhbCB3b3JrbG9hZCBwYXR0ZXJucy5cbiAgICAgKlxuICAgICAqIFlvdSBjYW4gY2FsbCBmb3IgYSBzaW5nbGUgbWV0cmljIG9yIHBlcmZvcm0gbWF0aCBleHByZXNzaW9ucyBvbiBtdWx0aXBsZSBtZXRyaWNzLiBBbnkgZXhwcmVzc2lvbnMgdXNlZCBpbiBhIG1ldHJpYyBzcGVjaWZpY2F0aW9uIG11c3QgZXZlbnR1YWxseSByZXR1cm4gYSBzaW5nbGUgdGltZSBzZXJpZXMuXG4gICAgICpcbiAgICAgKiBGb3IgbW9yZSBpbmZvcm1hdGlvbiBhbmQgZXhhbXBsZXMsIHNlZSBbQWR2YW5jZWQgcHJlZGljdGl2ZSBzY2FsaW5nIHBvbGljeSBjb25maWd1cmF0aW9ucyB1c2luZyBjdXN0b20gbWV0cmljc10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2F1dG9zY2FsaW5nL2VjMi91c2VyZ3VpZGUvcHJlZGljdGl2ZS1zY2FsaW5nLWN1c3RvbWl6ZWQtbWV0cmljLXNwZWNpZmljYXRpb24uaHRtbCkgaW4gdGhlICpBbWF6b24gRUMyIEF1dG8gU2NhbGluZyBVc2VyIEd1aWRlKiAuXG4gICAgICpcbiAgICAgKiBAc3RydWN0XG4gICAgICogQHN0YWJpbGl0eSBleHRlcm5hbFxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hdXRvc2NhbGluZy1zY2FsaW5ncG9saWN5LW1ldHJpY2RhdGFxdWVyeS5odG1sXG4gICAgICovXG4gICAgZXhwb3J0IGludGVyZmFjZSBNZXRyaWNEYXRhUXVlcnlQcm9wZXJ0eSB7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBUaGUgbWF0aCBleHByZXNzaW9uIHRvIHBlcmZvcm0gb24gdGhlIHJldHVybmVkIGRhdGEsIGlmIHRoaXMgb2JqZWN0IGlzIHBlcmZvcm1pbmcgYSBtYXRoIGV4cHJlc3Npb24uIFRoaXMgZXhwcmVzc2lvbiBjYW4gdXNlIHRoZSBgSWRgIG9mIHRoZSBvdGhlciBtZXRyaWNzIHRvIHJlZmVyIHRvIHRob3NlIG1ldHJpY3MsIGFuZCBjYW4gYWxzbyB1c2UgdGhlIGBJZGAgb2Ygb3RoZXIgZXhwcmVzc2lvbnMgdG8gdXNlIHRoZSByZXN1bHQgb2YgdGhvc2UgZXhwcmVzc2lvbnMuXG4gICAgICAgICAqXG4gICAgICAgICAqIENvbmRpdGlvbmFsOiBXaXRoaW4gZWFjaCBgTWV0cmljRGF0YVF1ZXJ5YCBvYmplY3QsIHlvdSBtdXN0IHNwZWNpZnkgZWl0aGVyIGBFeHByZXNzaW9uYCBvciBgTWV0cmljU3RhdGAgLCBidXQgbm90IGJvdGguXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXV0b3NjYWxpbmctc2NhbGluZ3BvbGljeS1tZXRyaWNkYXRhcXVlcnkuaHRtbCNjZm4tYXV0b3NjYWxpbmctc2NhbGluZ3BvbGljeS1tZXRyaWNkYXRhcXVlcnktZXhwcmVzc2lvblxuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgZXhwcmVzc2lvbj86IHN0cmluZztcbiAgICAgICAgLyoqXG4gICAgICAgICAqIEEgc2hvcnQgbmFtZSB0aGF0IGlkZW50aWZpZXMgdGhlIG9iamVjdCdzIHJlc3VsdHMgaW4gdGhlIHJlc3BvbnNlLiBUaGlzIG5hbWUgbXVzdCBiZSB1bmlxdWUgYW1vbmcgYWxsIGBNZXRyaWNEYXRhUXVlcnlgIG9iamVjdHMgc3BlY2lmaWVkIGZvciBhIHNpbmdsZSBzY2FsaW5nIHBvbGljeS4gSWYgeW91IGFyZSBwZXJmb3JtaW5nIG1hdGggZXhwcmVzc2lvbnMgb24gdGhpcyBzZXQgb2YgZGF0YSwgdGhpcyBuYW1lIHJlcHJlc2VudHMgdGhhdCBkYXRhIGFuZCBjYW4gc2VydmUgYXMgYSB2YXJpYWJsZSBpbiB0aGUgbWF0aGVtYXRpY2FsIGV4cHJlc3Npb24uIFRoZSB2YWxpZCBjaGFyYWN0ZXJzIGFyZSBsZXR0ZXJzLCBudW1iZXJzLCBhbmQgdW5kZXJzY29yZXMuIFRoZSBmaXJzdCBjaGFyYWN0ZXIgbXVzdCBiZSBhIGxvd2VyY2FzZSBsZXR0ZXIuXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXV0b3NjYWxpbmctc2NhbGluZ3BvbGljeS1tZXRyaWNkYXRhcXVlcnkuaHRtbCNjZm4tYXV0b3NjYWxpbmctc2NhbGluZ3BvbGljeS1tZXRyaWNkYXRhcXVlcnktaWRcbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IGlkOiBzdHJpbmc7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBBIGh1bWFuLXJlYWRhYmxlIGxhYmVsIGZvciB0aGlzIG1ldHJpYyBvciBleHByZXNzaW9uLiBUaGlzIGlzIGVzcGVjaWFsbHkgdXNlZnVsIGlmIHRoaXMgaXMgYSBtYXRoIGV4cHJlc3Npb24sIHNvIHRoYXQgeW91IGtub3cgd2hhdCB0aGUgdmFsdWUgcmVwcmVzZW50cy5cbiAgICAgICAgICpcbiAgICAgICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hdXRvc2NhbGluZy1zY2FsaW5ncG9saWN5LW1ldHJpY2RhdGFxdWVyeS5odG1sI2Nmbi1hdXRvc2NhbGluZy1zY2FsaW5ncG9saWN5LW1ldHJpY2RhdGFxdWVyeS1sYWJlbFxuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgbGFiZWw/OiBzdHJpbmc7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBJbmZvcm1hdGlvbiBhYm91dCB0aGUgbWV0cmljIGRhdGEgdG8gcmV0dXJuLlxuICAgICAgICAgKlxuICAgICAgICAgKiBDb25kaXRpb25hbDogV2l0aGluIGVhY2ggYE1ldHJpY0RhdGFRdWVyeWAgb2JqZWN0LCB5b3UgbXVzdCBzcGVjaWZ5IGVpdGhlciBgRXhwcmVzc2lvbmAgb3IgYE1ldHJpY1N0YXRgICwgYnV0IG5vdCBib3RoLlxuICAgICAgICAgKlxuICAgICAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWF1dG9zY2FsaW5nLXNjYWxpbmdwb2xpY3ktbWV0cmljZGF0YXF1ZXJ5Lmh0bWwjY2ZuLWF1dG9zY2FsaW5nLXNjYWxpbmdwb2xpY3ktbWV0cmljZGF0YXF1ZXJ5LW1ldHJpY3N0YXRcbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IG1ldHJpY1N0YXQ/OiBDZm5TY2FsaW5nUG9saWN5Lk1ldHJpY1N0YXRQcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZTtcbiAgICAgICAgLyoqXG4gICAgICAgICAqIEluZGljYXRlcyB3aGV0aGVyIHRvIHJldHVybiB0aGUgdGltZXN0YW1wcyBhbmQgcmF3IGRhdGEgdmFsdWVzIG9mIHRoaXMgbWV0cmljLlxuICAgICAgICAgKlxuICAgICAgICAgKiBJZiB5b3UgdXNlIGFueSBtYXRoIGV4cHJlc3Npb25zLCBzcGVjaWZ5IGB0cnVlYCBmb3IgdGhpcyB2YWx1ZSBmb3Igb25seSB0aGUgZmluYWwgbWF0aCBleHByZXNzaW9uIHRoYXQgdGhlIG1ldHJpYyBzcGVjaWZpY2F0aW9uIGlzIGJhc2VkIG9uLiBZb3UgbXVzdCBzcGVjaWZ5IGBmYWxzZWAgZm9yIGBSZXR1cm5EYXRhYCBmb3IgYWxsIHRoZSBvdGhlciBtZXRyaWNzIGFuZCBleHByZXNzaW9ucyB1c2VkIGluIHRoZSBtZXRyaWMgc3BlY2lmaWNhdGlvbi5cbiAgICAgICAgICpcbiAgICAgICAgICogSWYgeW91IGFyZSBvbmx5IHJldHJpZXZpbmcgbWV0cmljcyBhbmQgbm90IHBlcmZvcm1pbmcgYW55IG1hdGggZXhwcmVzc2lvbnMsIGRvIG5vdCBzcGVjaWZ5IGFueXRoaW5nIGZvciBgUmV0dXJuRGF0YWAgLiBUaGlzIHNldHMgaXQgdG8gaXRzIGRlZmF1bHQgKCBgdHJ1ZWAgKS5cbiAgICAgICAgICpcbiAgICAgICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hdXRvc2NhbGluZy1zY2FsaW5ncG9saWN5LW1ldHJpY2RhdGFxdWVyeS5odG1sI2Nmbi1hdXRvc2NhbGluZy1zY2FsaW5ncG9saWN5LW1ldHJpY2RhdGFxdWVyeS1yZXR1cm5kYXRhXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSByZXR1cm5EYXRhPzogYm9vbGVhbiB8IGNkay5JUmVzb2x2YWJsZTtcbiAgICB9XG59XG5cbi8qKlxuICogRGV0ZXJtaW5lIHdoZXRoZXIgdGhlIGdpdmVuIHByb3BlcnRpZXMgbWF0Y2ggdGhvc2Ugb2YgYSBgTWV0cmljRGF0YVF1ZXJ5UHJvcGVydHlgXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYE1ldHJpY0RhdGFRdWVyeVByb3BlcnR5YFxuICpcbiAqIEByZXR1cm5zIHRoZSByZXN1bHQgb2YgdGhlIHZhbGlkYXRpb24uXG4gKi9cbmZ1bmN0aW9uIENmblNjYWxpbmdQb2xpY3lfTWV0cmljRGF0YVF1ZXJ5UHJvcGVydHlWYWxpZGF0b3IocHJvcGVydGllczogYW55KTogY2RrLlZhbGlkYXRpb25SZXN1bHQge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIGNkay5WQUxJREFUSU9OX1NVQ0NFU1M7IH1cbiAgICBjb25zdCBlcnJvcnMgPSBuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHRzKCk7XG4gICAgaWYgKHR5cGVvZiBwcm9wZXJ0aWVzICE9PSAnb2JqZWN0Jykge1xuICAgICAgICBlcnJvcnMuY29sbGVjdChuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHQoJ0V4cGVjdGVkIGFuIG9iamVjdCwgYnV0IHJlY2VpdmVkOiAnICsgSlNPTi5zdHJpbmdpZnkocHJvcGVydGllcykpKTtcbiAgICB9XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdleHByZXNzaW9uJywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmV4cHJlc3Npb24pKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2lkJywgY2RrLnJlcXVpcmVkVmFsaWRhdG9yKShwcm9wZXJ0aWVzLmlkKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdpZCcsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5pZCkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignbGFiZWwnLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMubGFiZWwpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ21ldHJpY1N0YXQnLCBDZm5TY2FsaW5nUG9saWN5X01ldHJpY1N0YXRQcm9wZXJ0eVZhbGlkYXRvcikocHJvcGVydGllcy5tZXRyaWNTdGF0KSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdyZXR1cm5EYXRhJywgY2RrLnZhbGlkYXRlQm9vbGVhbikocHJvcGVydGllcy5yZXR1cm5EYXRhKSk7XG4gICAgcmV0dXJuIGVycm9ycy53cmFwKCdzdXBwbGllZCBwcm9wZXJ0aWVzIG5vdCBjb3JyZWN0IGZvciBcIk1ldHJpY0RhdGFRdWVyeVByb3BlcnR5XCInKTtcbn1cblxuLyoqXG4gKiBSZW5kZXJzIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpBdXRvU2NhbGluZzo6U2NhbGluZ1BvbGljeS5NZXRyaWNEYXRhUXVlcnlgIHJlc291cmNlXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYE1ldHJpY0RhdGFRdWVyeVByb3BlcnR5YFxuICpcbiAqIEByZXR1cm5zIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpBdXRvU2NhbGluZzo6U2NhbGluZ1BvbGljeS5NZXRyaWNEYXRhUXVlcnlgIHJlc291cmNlLlxuICovXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gY2ZuU2NhbGluZ1BvbGljeU1ldHJpY0RhdGFRdWVyeVByb3BlcnR5VG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBhbnkge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIHByb3BlcnRpZXM7IH1cbiAgICBDZm5TY2FsaW5nUG9saWN5X01ldHJpY0RhdGFRdWVyeVByb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXMpLmFzc2VydFN1Y2Nlc3MoKTtcbiAgICByZXR1cm4ge1xuICAgICAgICBFeHByZXNzaW9uOiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLmV4cHJlc3Npb24pLFxuICAgICAgICBJZDogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5pZCksXG4gICAgICAgIExhYmVsOiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLmxhYmVsKSxcbiAgICAgICAgTWV0cmljU3RhdDogY2ZuU2NhbGluZ1BvbGljeU1ldHJpY1N0YXRQcm9wZXJ0eVRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5tZXRyaWNTdGF0KSxcbiAgICAgICAgUmV0dXJuRGF0YTogY2RrLmJvb2xlYW5Ub0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMucmV0dXJuRGF0YSksXG4gICAgfTtcbn1cblxuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIENmblNjYWxpbmdQb2xpY3lNZXRyaWNEYXRhUXVlcnlQcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0PENmblNjYWxpbmdQb2xpY3kuTWV0cmljRGF0YVF1ZXJ5UHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGU+IHtcbiAgICBpZiAoY2RrLmlzUmVzb2x2YWJsZU9iamVjdChwcm9wZXJ0aWVzKSkge1xuICAgICAgICByZXR1cm4gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQocHJvcGVydGllcyk7XG4gICAgfVxuICAgIHByb3BlcnRpZXMgPSBwcm9wZXJ0aWVzID09IG51bGwgPyB7fSA6IHByb3BlcnRpZXM7XG4gICAgaWYgKHR5cGVvZiBwcm9wZXJ0aWVzICE9PSAnb2JqZWN0Jykge1xuICAgICAgICByZXR1cm4gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQocHJvcGVydGllcyk7XG4gICAgfVxuICAgIGNvbnN0IHJldCA9IG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUHJvcGVydHlPYmplY3Q8Q2ZuU2NhbGluZ1BvbGljeS5NZXRyaWNEYXRhUXVlcnlQcm9wZXJ0eT4oKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2V4cHJlc3Npb24nLCAnRXhwcmVzc2lvbicsIHByb3BlcnRpZXMuRXhwcmVzc2lvbiAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5FeHByZXNzaW9uKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdpZCcsICdJZCcsIGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuSWQpKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2xhYmVsJywgJ0xhYmVsJywgcHJvcGVydGllcy5MYWJlbCAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5MYWJlbCkgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnbWV0cmljU3RhdCcsICdNZXRyaWNTdGF0JywgcHJvcGVydGllcy5NZXRyaWNTdGF0ICE9IG51bGwgPyBDZm5TY2FsaW5nUG9saWN5TWV0cmljU3RhdFByb3BlcnR5RnJvbUNsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuTWV0cmljU3RhdCkgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgncmV0dXJuRGF0YScsICdSZXR1cm5EYXRhJywgcHJvcGVydGllcy5SZXR1cm5EYXRhICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldEJvb2xlYW4ocHJvcGVydGllcy5SZXR1cm5EYXRhKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFVucmVjb2duaXplZFByb3BlcnRpZXNBc0V4dHJhKHByb3BlcnRpZXMpO1xuICAgIHJldHVybiByZXQ7XG59XG5cbmV4cG9ydCBuYW1lc3BhY2UgQ2ZuU2NhbGluZ1BvbGljeSB7XG4gICAgLyoqXG4gICAgICogYE1ldHJpY0RpbWVuc2lvbmAgc3BlY2lmaWVzIGEgbmFtZS92YWx1ZSBwYWlyIHRoYXQgaXMgcGFydCBvZiB0aGUgaWRlbnRpdHkgb2YgYSBDbG91ZFdhdGNoIG1ldHJpYyBmb3IgdGhlIGBEaW1lbnNpb25zYCBwcm9wZXJ0eSBvZiB0aGUgW0FXUzo6QXV0b1NjYWxpbmc6OlNjYWxpbmdQb2xpY3kgQ3VzdG9taXplZE1ldHJpY1NwZWNpZmljYXRpb25dKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWF1dG9zY2FsaW5nLXNjYWxpbmdwb2xpY3ktY3VzdG9taXplZG1ldHJpY3NwZWNpZmljYXRpb24uaHRtbCkgcHJvcGVydHkgdHlwZS4gRHVwbGljYXRlIGRpbWVuc2lvbnMgYXJlIG5vdCBhbGxvd2VkLlxuICAgICAqXG4gICAgICogQHN0cnVjdFxuICAgICAqIEBzdGFiaWxpdHkgZXh0ZXJuYWxcbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXV0b3NjYWxpbmctc2NhbGluZ3BvbGljeS1tZXRyaWNkaW1lbnNpb24uaHRtbFxuICAgICAqL1xuICAgIGV4cG9ydCBpbnRlcmZhY2UgTWV0cmljRGltZW5zaW9uUHJvcGVydHkge1xuICAgICAgICAvKipcbiAgICAgICAgICogVGhlIG5hbWUgb2YgdGhlIGRpbWVuc2lvbi5cbiAgICAgICAgICpcbiAgICAgICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hdXRvc2NhbGluZy1zY2FsaW5ncG9saWN5LW1ldHJpY2RpbWVuc2lvbi5odG1sI2Nmbi1hdXRvc2NhbGluZy1zY2FsaW5ncG9saWN5LW1ldHJpY2RpbWVuc2lvbi1uYW1lXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBuYW1lOiBzdHJpbmc7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBUaGUgdmFsdWUgb2YgdGhlIGRpbWVuc2lvbi5cbiAgICAgICAgICpcbiAgICAgICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hdXRvc2NhbGluZy1zY2FsaW5ncG9saWN5LW1ldHJpY2RpbWVuc2lvbi5odG1sI2Nmbi1hdXRvc2NhbGluZy1zY2FsaW5ncG9saWN5LW1ldHJpY2RpbWVuc2lvbi12YWx1ZVxuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgdmFsdWU6IHN0cmluZztcbiAgICB9XG59XG5cbi8qKlxuICogRGV0ZXJtaW5lIHdoZXRoZXIgdGhlIGdpdmVuIHByb3BlcnRpZXMgbWF0Y2ggdGhvc2Ugb2YgYSBgTWV0cmljRGltZW5zaW9uUHJvcGVydHlgXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYE1ldHJpY0RpbWVuc2lvblByb3BlcnR5YFxuICpcbiAqIEByZXR1cm5zIHRoZSByZXN1bHQgb2YgdGhlIHZhbGlkYXRpb24uXG4gKi9cbmZ1bmN0aW9uIENmblNjYWxpbmdQb2xpY3lfTWV0cmljRGltZW5zaW9uUHJvcGVydHlWYWxpZGF0b3IocHJvcGVydGllczogYW55KTogY2RrLlZhbGlkYXRpb25SZXN1bHQge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIGNkay5WQUxJREFUSU9OX1NVQ0NFU1M7IH1cbiAgICBjb25zdCBlcnJvcnMgPSBuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHRzKCk7XG4gICAgaWYgKHR5cGVvZiBwcm9wZXJ0aWVzICE9PSAnb2JqZWN0Jykge1xuICAgICAgICBlcnJvcnMuY29sbGVjdChuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHQoJ0V4cGVjdGVkIGFuIG9iamVjdCwgYnV0IHJlY2VpdmVkOiAnICsgSlNPTi5zdHJpbmdpZnkocHJvcGVydGllcykpKTtcbiAgICB9XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCduYW1lJywgY2RrLnJlcXVpcmVkVmFsaWRhdG9yKShwcm9wZXJ0aWVzLm5hbWUpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ25hbWUnLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMubmFtZSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigndmFsdWUnLCBjZGsucmVxdWlyZWRWYWxpZGF0b3IpKHByb3BlcnRpZXMudmFsdWUpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3ZhbHVlJywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLnZhbHVlKSk7XG4gICAgcmV0dXJuIGVycm9ycy53cmFwKCdzdXBwbGllZCBwcm9wZXJ0aWVzIG5vdCBjb3JyZWN0IGZvciBcIk1ldHJpY0RpbWVuc2lvblByb3BlcnR5XCInKTtcbn1cblxuLyoqXG4gKiBSZW5kZXJzIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpBdXRvU2NhbGluZzo6U2NhbGluZ1BvbGljeS5NZXRyaWNEaW1lbnNpb25gIHJlc291cmNlXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYE1ldHJpY0RpbWVuc2lvblByb3BlcnR5YFxuICpcbiAqIEByZXR1cm5zIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpBdXRvU2NhbGluZzo6U2NhbGluZ1BvbGljeS5NZXRyaWNEaW1lbnNpb25gIHJlc291cmNlLlxuICovXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gY2ZuU2NhbGluZ1BvbGljeU1ldHJpY0RpbWVuc2lvblByb3BlcnR5VG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBhbnkge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIHByb3BlcnRpZXM7IH1cbiAgICBDZm5TY2FsaW5nUG9saWN5X01ldHJpY0RpbWVuc2lvblByb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXMpLmFzc2VydFN1Y2Nlc3MoKTtcbiAgICByZXR1cm4ge1xuICAgICAgICBOYW1lOiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLm5hbWUpLFxuICAgICAgICBWYWx1ZTogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy52YWx1ZSksXG4gICAgfTtcbn1cblxuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIENmblNjYWxpbmdQb2xpY3lNZXRyaWNEaW1lbnNpb25Qcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0PENmblNjYWxpbmdQb2xpY3kuTWV0cmljRGltZW5zaW9uUHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGU+IHtcbiAgICBpZiAoY2RrLmlzUmVzb2x2YWJsZU9iamVjdChwcm9wZXJ0aWVzKSkge1xuICAgICAgICByZXR1cm4gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQocHJvcGVydGllcyk7XG4gICAgfVxuICAgIHByb3BlcnRpZXMgPSBwcm9wZXJ0aWVzID09IG51bGwgPyB7fSA6IHByb3BlcnRpZXM7XG4gICAgaWYgKHR5cGVvZiBwcm9wZXJ0aWVzICE9PSAnb2JqZWN0Jykge1xuICAgICAgICByZXR1cm4gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQocHJvcGVydGllcyk7XG4gICAgfVxuICAgIGNvbnN0IHJldCA9IG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUHJvcGVydHlPYmplY3Q8Q2ZuU2NhbGluZ1BvbGljeS5NZXRyaWNEaW1lbnNpb25Qcm9wZXJ0eT4oKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ25hbWUnLCAnTmFtZScsIGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuTmFtZSkpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgndmFsdWUnLCAnVmFsdWUnLCBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLlZhbHVlKSk7XG4gICAgcmV0LmFkZFVucmVjb2duaXplZFByb3BlcnRpZXNBc0V4dHJhKHByb3BlcnRpZXMpO1xuICAgIHJldHVybiByZXQ7XG59XG5cbmV4cG9ydCBuYW1lc3BhY2UgQ2ZuU2NhbGluZ1BvbGljeSB7XG4gICAgLyoqXG4gICAgICogYE1ldHJpY1N0YXRgIGlzIGEgcHJvcGVydHkgb2YgdGhlIFtBV1M6OkF1dG9TY2FsaW5nOjpTY2FsaW5nUG9saWN5IE1ldHJpY0RhdGFRdWVyeV0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXV0b3NjYWxpbmctc2NhbGluZ3BvbGljeS1tZXRyaWNkYXRhcXVlcnkuaHRtbCkgcHJvcGVydHkgdHlwZS5cbiAgICAgKlxuICAgICAqIFRoaXMgc3RydWN0dXJlIGRlZmluZXMgdGhlIENsb3VkV2F0Y2ggbWV0cmljIHRvIHJldHVybiwgYWxvbmcgd2l0aCB0aGUgc3RhdGlzdGljLCBwZXJpb2QsIGFuZCB1bml0LlxuICAgICAqXG4gICAgICogRm9yIG1vcmUgaW5mb3JtYXRpb24gYWJvdXQgdGhlIENsb3VkV2F0Y2ggdGVybWlub2xvZ3kgYmVsb3csIHNlZSBbQW1hem9uIENsb3VkV2F0Y2ggY29uY2VwdHNdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BbWF6b25DbG91ZFdhdGNoL2xhdGVzdC9tb25pdG9yaW5nL2Nsb3Vkd2F0Y2hfY29uY2VwdHMuaHRtbCkgaW4gdGhlICpBbWF6b24gQ2xvdWRXYXRjaCBVc2VyIEd1aWRlKiAuXG4gICAgICpcbiAgICAgKiBAc3RydWN0XG4gICAgICogQHN0YWJpbGl0eSBleHRlcm5hbFxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hdXRvc2NhbGluZy1zY2FsaW5ncG9saWN5LW1ldHJpY3N0YXQuaHRtbFxuICAgICAqL1xuICAgIGV4cG9ydCBpbnRlcmZhY2UgTWV0cmljU3RhdFByb3BlcnR5IHtcbiAgICAgICAgLyoqXG4gICAgICAgICAqIFRoZSBDbG91ZFdhdGNoIG1ldHJpYyB0byByZXR1cm4sIGluY2x1ZGluZyB0aGUgbWV0cmljIG5hbWUsIG5hbWVzcGFjZSwgYW5kIGRpbWVuc2lvbnMuIFRvIGdldCB0aGUgZXhhY3QgbWV0cmljIG5hbWUsIG5hbWVzcGFjZSwgYW5kIGRpbWVuc2lvbnMsIGluc3BlY3QgdGhlIFtNZXRyaWNdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BbWF6b25DbG91ZFdhdGNoL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX01ldHJpYy5odG1sKSBvYmplY3QgdGhhdCBpcyByZXR1cm5lZCBieSBhIGNhbGwgdG8gW0xpc3RNZXRyaWNzXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQW1hem9uQ2xvdWRXYXRjaC9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9MaXN0TWV0cmljcy5odG1sKSAuXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXV0b3NjYWxpbmctc2NhbGluZ3BvbGljeS1tZXRyaWNzdGF0Lmh0bWwjY2ZuLWF1dG9zY2FsaW5nLXNjYWxpbmdwb2xpY3ktbWV0cmljc3RhdC1tZXRyaWNcbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IG1ldHJpYzogQ2ZuU2NhbGluZ1BvbGljeS5NZXRyaWNQcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZTtcbiAgICAgICAgLyoqXG4gICAgICAgICAqIFRoZSBzdGF0aXN0aWMgdG8gcmV0dXJuLiBJdCBjYW4gaW5jbHVkZSBhbnkgQ2xvdWRXYXRjaCBzdGF0aXN0aWMgb3IgZXh0ZW5kZWQgc3RhdGlzdGljLiBGb3IgYSBsaXN0IG9mIHZhbGlkIHZhbHVlcywgc2VlIHRoZSB0YWJsZSBpbiBbU3RhdGlzdGljc10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FtYXpvbkNsb3VkV2F0Y2gvbGF0ZXN0L21vbml0b3JpbmcvY2xvdWR3YXRjaF9jb25jZXB0cy5odG1sI1N0YXRpc3RpYykgaW4gdGhlICpBbWF6b24gQ2xvdWRXYXRjaCBVc2VyIEd1aWRlKiAuXG4gICAgICAgICAqXG4gICAgICAgICAqIFRoZSBtb3N0IGNvbW1vbmx5IHVzZWQgbWV0cmljcyBmb3IgcHJlZGljdGl2ZSBzY2FsaW5nIGFyZSBgQXZlcmFnZWAgYW5kIGBTdW1gIC5cbiAgICAgICAgICpcbiAgICAgICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hdXRvc2NhbGluZy1zY2FsaW5ncG9saWN5LW1ldHJpY3N0YXQuaHRtbCNjZm4tYXV0b3NjYWxpbmctc2NhbGluZ3BvbGljeS1tZXRyaWNzdGF0LXN0YXRcbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IHN0YXQ6IHN0cmluZztcbiAgICAgICAgLyoqXG4gICAgICAgICAqIFRoZSB1bml0IHRvIHVzZSBmb3IgdGhlIHJldHVybmVkIGRhdGEgcG9pbnRzLiBGb3IgYSBjb21wbGV0ZSBsaXN0IG9mIHRoZSB1bml0cyB0aGF0IENsb3VkV2F0Y2ggc3VwcG9ydHMsIHNlZSB0aGUgW01ldHJpY0RhdHVtXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQW1hem9uQ2xvdWRXYXRjaC9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9NZXRyaWNEYXR1bS5odG1sKSBkYXRhIHR5cGUgaW4gdGhlICpBbWF6b24gQ2xvdWRXYXRjaCBBUEkgUmVmZXJlbmNlKiAuXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXV0b3NjYWxpbmctc2NhbGluZ3BvbGljeS1tZXRyaWNzdGF0Lmh0bWwjY2ZuLWF1dG9zY2FsaW5nLXNjYWxpbmdwb2xpY3ktbWV0cmljc3RhdC11bml0XG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSB1bml0Pzogc3RyaW5nO1xuICAgIH1cbn1cblxuLyoqXG4gKiBEZXRlcm1pbmUgd2hldGhlciB0aGUgZ2l2ZW4gcHJvcGVydGllcyBtYXRjaCB0aG9zZSBvZiBhIGBNZXRyaWNTdGF0UHJvcGVydHlgXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYE1ldHJpY1N0YXRQcm9wZXJ0eWBcbiAqXG4gKiBAcmV0dXJucyB0aGUgcmVzdWx0IG9mIHRoZSB2YWxpZGF0aW9uLlxuICovXG5mdW5jdGlvbiBDZm5TY2FsaW5nUG9saWN5X01ldHJpY1N0YXRQcm9wZXJ0eVZhbGlkYXRvcihwcm9wZXJ0aWVzOiBhbnkpOiBjZGsuVmFsaWRhdGlvblJlc3VsdCB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gY2RrLlZBTElEQVRJT05fU1VDQ0VTUzsgfVxuICAgIGNvbnN0IGVycm9ycyA9IG5ldyBjZGsuVmFsaWRhdGlvblJlc3VsdHMoKTtcbiAgICBpZiAodHlwZW9mIHByb3BlcnRpZXMgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIGVycm9ycy5jb2xsZWN0KG5ldyBjZGsuVmFsaWRhdGlvblJlc3VsdCgnRXhwZWN0ZWQgYW4gb2JqZWN0LCBidXQgcmVjZWl2ZWQ6ICcgKyBKU09OLnN0cmluZ2lmeShwcm9wZXJ0aWVzKSkpO1xuICAgIH1cbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ21ldHJpYycsIGNkay5yZXF1aXJlZFZhbGlkYXRvcikocHJvcGVydGllcy5tZXRyaWMpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ21ldHJpYycsIENmblNjYWxpbmdQb2xpY3lfTWV0cmljUHJvcGVydHlWYWxpZGF0b3IpKHByb3BlcnRpZXMubWV0cmljKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdzdGF0JywgY2RrLnJlcXVpcmVkVmFsaWRhdG9yKShwcm9wZXJ0aWVzLnN0YXQpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3N0YXQnLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuc3RhdCkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigndW5pdCcsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy51bml0KSk7XG4gICAgcmV0dXJuIGVycm9ycy53cmFwKCdzdXBwbGllZCBwcm9wZXJ0aWVzIG5vdCBjb3JyZWN0IGZvciBcIk1ldHJpY1N0YXRQcm9wZXJ0eVwiJyk7XG59XG5cbi8qKlxuICogUmVuZGVycyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6QXV0b1NjYWxpbmc6OlNjYWxpbmdQb2xpY3kuTWV0cmljU3RhdGAgcmVzb3VyY2VcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgTWV0cmljU3RhdFByb3BlcnR5YFxuICpcbiAqIEByZXR1cm5zIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpBdXRvU2NhbGluZzo6U2NhbGluZ1BvbGljeS5NZXRyaWNTdGF0YCByZXNvdXJjZS5cbiAqL1xuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIGNmblNjYWxpbmdQb2xpY3lNZXRyaWNTdGF0UHJvcGVydHlUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGFueSB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gcHJvcGVydGllczsgfVxuICAgIENmblNjYWxpbmdQb2xpY3lfTWV0cmljU3RhdFByb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXMpLmFzc2VydFN1Y2Nlc3MoKTtcbiAgICByZXR1cm4ge1xuICAgICAgICBNZXRyaWM6IGNmblNjYWxpbmdQb2xpY3lNZXRyaWNQcm9wZXJ0eVRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5tZXRyaWMpLFxuICAgICAgICBTdGF0OiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLnN0YXQpLFxuICAgICAgICBVbml0OiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLnVuaXQpLFxuICAgIH07XG59XG5cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBDZm5TY2FsaW5nUG9saWN5TWV0cmljU3RhdFByb3BlcnR5RnJvbUNsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQ8Q2ZuU2NhbGluZ1BvbGljeS5NZXRyaWNTdGF0UHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGU+IHtcbiAgICBpZiAoY2RrLmlzUmVzb2x2YWJsZU9iamVjdChwcm9wZXJ0aWVzKSkge1xuICAgICAgICByZXR1cm4gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQocHJvcGVydGllcyk7XG4gICAgfVxuICAgIHByb3BlcnRpZXMgPSBwcm9wZXJ0aWVzID09IG51bGwgPyB7fSA6IHByb3BlcnRpZXM7XG4gICAgaWYgKHR5cGVvZiBwcm9wZXJ0aWVzICE9PSAnb2JqZWN0Jykge1xuICAgICAgICByZXR1cm4gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQocHJvcGVydGllcyk7XG4gICAgfVxuICAgIGNvbnN0IHJldCA9IG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUHJvcGVydHlPYmplY3Q8Q2ZuU2NhbGluZ1BvbGljeS5NZXRyaWNTdGF0UHJvcGVydHk+KCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdtZXRyaWMnLCAnTWV0cmljJywgQ2ZuU2NhbGluZ1BvbGljeU1ldHJpY1Byb3BlcnR5RnJvbUNsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuTWV0cmljKSk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdzdGF0JywgJ1N0YXQnLCBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLlN0YXQpKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ3VuaXQnLCAnVW5pdCcsIHByb3BlcnRpZXMuVW5pdCAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5Vbml0KSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFVucmVjb2duaXplZFByb3BlcnRpZXNBc0V4dHJhKHByb3BlcnRpZXMpO1xuICAgIHJldHVybiByZXQ7XG59XG5cbmV4cG9ydCBuYW1lc3BhY2UgQ2ZuU2NhbGluZ1BvbGljeSB7XG4gICAgLyoqXG4gICAgICogQ29udGFpbnMgcHJlZGVmaW5lZCBtZXRyaWMgc3BlY2lmaWNhdGlvbiBpbmZvcm1hdGlvbiBmb3IgYSB0YXJnZXQgdHJhY2tpbmcgc2NhbGluZyBwb2xpY3kgZm9yIEFtYXpvbiBFQzIgQXV0byBTY2FsaW5nLlxuICAgICAqXG4gICAgICogYFByZWRlZmluZWRNZXRyaWNTcGVjaWZpY2F0aW9uYCBpcyBhIHByb3BlcnR5IG9mIHRoZSBbQVdTOjpBdXRvU2NhbGluZzo6U2NhbGluZ1BvbGljeSBUYXJnZXRUcmFja2luZ0NvbmZpZ3VyYXRpb25dKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWF1dG9zY2FsaW5nLXNjYWxpbmdwb2xpY3ktdGFyZ2V0dHJhY2tpbmdjb25maWd1cmF0aW9uLmh0bWwpIHByb3BlcnR5IHR5cGUuXG4gICAgICpcbiAgICAgKiBAc3RydWN0XG4gICAgICogQHN0YWJpbGl0eSBleHRlcm5hbFxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hdXRvc2NhbGluZy1zY2FsaW5ncG9saWN5LXByZWRlZmluZWRtZXRyaWNzcGVjaWZpY2F0aW9uLmh0bWxcbiAgICAgKi9cbiAgICBleHBvcnQgaW50ZXJmYWNlIFByZWRlZmluZWRNZXRyaWNTcGVjaWZpY2F0aW9uUHJvcGVydHkge1xuICAgICAgICAvKipcbiAgICAgICAgICogVGhlIG1ldHJpYyB0eXBlLiBUaGUgZm9sbG93aW5nIHByZWRlZmluZWQgbWV0cmljcyBhcmUgYXZhaWxhYmxlOlxuICAgICAgICAgKlxuICAgICAgICAgKiAtIGBBU0dBdmVyYWdlQ1BVVXRpbGl6YXRpb25gIC0gQXZlcmFnZSBDUFUgdXRpbGl6YXRpb24gb2YgdGhlIEF1dG8gU2NhbGluZyBncm91cC5cbiAgICAgICAgICogLSBgQVNHQXZlcmFnZU5ldHdvcmtJbmAgLSBBdmVyYWdlIG51bWJlciBvZiBieXRlcyByZWNlaXZlZCBvbiBhbGwgbmV0d29yayBpbnRlcmZhY2VzIGJ5IHRoZSBBdXRvIFNjYWxpbmcgZ3JvdXAuXG4gICAgICAgICAqIC0gYEFTR0F2ZXJhZ2VOZXR3b3JrT3V0YCAtIEF2ZXJhZ2UgbnVtYmVyIG9mIGJ5dGVzIHNlbnQgb3V0IG9uIGFsbCBuZXR3b3JrIGludGVyZmFjZXMgYnkgdGhlIEF1dG8gU2NhbGluZyBncm91cC5cbiAgICAgICAgICogLSBgQUxCUmVxdWVzdENvdW50UGVyVGFyZ2V0YCAtIEF2ZXJhZ2UgQXBwbGljYXRpb24gTG9hZCBCYWxhbmNlciByZXF1ZXN0IGNvdW50IHBlciB0YXJnZXQgZm9yIHlvdXIgQXV0byBTY2FsaW5nIGdyb3VwLlxuICAgICAgICAgKlxuICAgICAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWF1dG9zY2FsaW5nLXNjYWxpbmdwb2xpY3ktcHJlZGVmaW5lZG1ldHJpY3NwZWNpZmljYXRpb24uaHRtbCNjZm4tYXV0b3NjYWxpbmctc2NhbGluZ3BvbGljeS1wcmVkZWZpbmVkbWV0cmljc3BlY2lmaWNhdGlvbi1wcmVkZWZpbmVkbWV0cmljdHlwZVxuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgcHJlZGVmaW5lZE1ldHJpY1R5cGU6IHN0cmluZztcbiAgICAgICAgLyoqXG4gICAgICAgICAqIEEgbGFiZWwgdGhhdCB1bmlxdWVseSBpZGVudGlmaWVzIGEgc3BlY2lmaWMgQXBwbGljYXRpb24gTG9hZCBCYWxhbmNlciB0YXJnZXQgZ3JvdXAgZnJvbSB3aGljaCB0byBkZXRlcm1pbmUgdGhlIGF2ZXJhZ2UgcmVxdWVzdCBjb3VudCBzZXJ2ZWQgYnkgeW91ciBBdXRvIFNjYWxpbmcgZ3JvdXAuIFlvdSBjYW4ndCBzcGVjaWZ5IGEgcmVzb3VyY2UgbGFiZWwgdW5sZXNzIHRoZSB0YXJnZXQgZ3JvdXAgaXMgYXR0YWNoZWQgdG8gdGhlIEF1dG8gU2NhbGluZyBncm91cC5cbiAgICAgICAgICpcbiAgICAgICAgICogWW91IGNyZWF0ZSB0aGUgcmVzb3VyY2UgbGFiZWwgYnkgYXBwZW5kaW5nIHRoZSBmaW5hbCBwb3J0aW9uIG9mIHRoZSBsb2FkIGJhbGFuY2VyIEFSTiBhbmQgdGhlIGZpbmFsIHBvcnRpb24gb2YgdGhlIHRhcmdldCBncm91cCBBUk4gaW50byBhIHNpbmdsZSB2YWx1ZSwgc2VwYXJhdGVkIGJ5IGEgZm9yd2FyZCBzbGFzaCAoLykuIFRoZSBmb3JtYXQgb2YgdGhlIHJlc291cmNlIGxhYmVsIGlzOlxuICAgICAgICAgKlxuICAgICAgICAgKiBgYXBwL215LWFsYi83NzhkNDEyMzFiMTQxYTBmL3RhcmdldGdyb3VwL215LWFsYi10YXJnZXQtZ3JvdXAvOTQzZjAxN2YxMDBiZWNmZmAgLlxuICAgICAgICAgKlxuICAgICAgICAgKiBXaGVyZTpcbiAgICAgICAgICpcbiAgICAgICAgICogLSBhcHAvPGxvYWQtYmFsYW5jZXItbmFtZT4vPGxvYWQtYmFsYW5jZXItaWQ+IGlzIHRoZSBmaW5hbCBwb3J0aW9uIG9mIHRoZSBsb2FkIGJhbGFuY2VyIEFSTlxuICAgICAgICAgKiAtIHRhcmdldGdyb3VwLzx0YXJnZXQtZ3JvdXAtbmFtZT4vPHRhcmdldC1ncm91cC1pZD4gaXMgdGhlIGZpbmFsIHBvcnRpb24gb2YgdGhlIHRhcmdldCBncm91cCBBUk4uXG4gICAgICAgICAqXG4gICAgICAgICAqIFRvIGZpbmQgdGhlIEFSTiBmb3IgYW4gQXBwbGljYXRpb24gTG9hZCBCYWxhbmNlciwgdXNlIHRoZSBbRGVzY3JpYmVMb2FkQmFsYW5jZXJzXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZWxhc3RpY2xvYWRiYWxhbmNpbmcvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfRGVzY3JpYmVMb2FkQmFsYW5jZXJzLmh0bWwpIEFQSSBvcGVyYXRpb24uIFRvIGZpbmQgdGhlIEFSTiBmb3IgdGhlIHRhcmdldCBncm91cCwgdXNlIHRoZSBbRGVzY3JpYmVUYXJnZXRHcm91cHNdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9lbGFzdGljbG9hZGJhbGFuY2luZy9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9EZXNjcmliZVRhcmdldEdyb3Vwcy5odG1sKSBBUEkgb3BlcmF0aW9uLlxuICAgICAgICAgKlxuICAgICAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWF1dG9zY2FsaW5nLXNjYWxpbmdwb2xpY3ktcHJlZGVmaW5lZG1ldHJpY3NwZWNpZmljYXRpb24uaHRtbCNjZm4tYXV0b3NjYWxpbmctc2NhbGluZ3BvbGljeS1wcmVkZWZpbmVkbWV0cmljc3BlY2lmaWNhdGlvbi1yZXNvdXJjZWxhYmVsXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSByZXNvdXJjZUxhYmVsPzogc3RyaW5nO1xuICAgIH1cbn1cblxuLyoqXG4gKiBEZXRlcm1pbmUgd2hldGhlciB0aGUgZ2l2ZW4gcHJvcGVydGllcyBtYXRjaCB0aG9zZSBvZiBhIGBQcmVkZWZpbmVkTWV0cmljU3BlY2lmaWNhdGlvblByb3BlcnR5YFxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBQcmVkZWZpbmVkTWV0cmljU3BlY2lmaWNhdGlvblByb3BlcnR5YFxuICpcbiAqIEByZXR1cm5zIHRoZSByZXN1bHQgb2YgdGhlIHZhbGlkYXRpb24uXG4gKi9cbmZ1bmN0aW9uIENmblNjYWxpbmdQb2xpY3lfUHJlZGVmaW5lZE1ldHJpY1NwZWNpZmljYXRpb25Qcm9wZXJ0eVZhbGlkYXRvcihwcm9wZXJ0aWVzOiBhbnkpOiBjZGsuVmFsaWRhdGlvblJlc3VsdCB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gY2RrLlZBTElEQVRJT05fU1VDQ0VTUzsgfVxuICAgIGNvbnN0IGVycm9ycyA9IG5ldyBjZGsuVmFsaWRhdGlvblJlc3VsdHMoKTtcbiAgICBpZiAodHlwZW9mIHByb3BlcnRpZXMgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIGVycm9ycy5jb2xsZWN0KG5ldyBjZGsuVmFsaWRhdGlvblJlc3VsdCgnRXhwZWN0ZWQgYW4gb2JqZWN0LCBidXQgcmVjZWl2ZWQ6ICcgKyBKU09OLnN0cmluZ2lmeShwcm9wZXJ0aWVzKSkpO1xuICAgIH1cbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3ByZWRlZmluZWRNZXRyaWNUeXBlJywgY2RrLnJlcXVpcmVkVmFsaWRhdG9yKShwcm9wZXJ0aWVzLnByZWRlZmluZWRNZXRyaWNUeXBlKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdwcmVkZWZpbmVkTWV0cmljVHlwZScsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5wcmVkZWZpbmVkTWV0cmljVHlwZSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigncmVzb3VyY2VMYWJlbCcsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5yZXNvdXJjZUxhYmVsKSk7XG4gICAgcmV0dXJuIGVycm9ycy53cmFwKCdzdXBwbGllZCBwcm9wZXJ0aWVzIG5vdCBjb3JyZWN0IGZvciBcIlByZWRlZmluZWRNZXRyaWNTcGVjaWZpY2F0aW9uUHJvcGVydHlcIicpO1xufVxuXG4vKipcbiAqIFJlbmRlcnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OkF1dG9TY2FsaW5nOjpTY2FsaW5nUG9saWN5LlByZWRlZmluZWRNZXRyaWNTcGVjaWZpY2F0aW9uYCByZXNvdXJjZVxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBQcmVkZWZpbmVkTWV0cmljU3BlY2lmaWNhdGlvblByb3BlcnR5YFxuICpcbiAqIEByZXR1cm5zIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpBdXRvU2NhbGluZzo6U2NhbGluZ1BvbGljeS5QcmVkZWZpbmVkTWV0cmljU3BlY2lmaWNhdGlvbmAgcmVzb3VyY2UuXG4gKi9cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBjZm5TY2FsaW5nUG9saWN5UHJlZGVmaW5lZE1ldHJpY1NwZWNpZmljYXRpb25Qcm9wZXJ0eVRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogYW55IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBwcm9wZXJ0aWVzOyB9XG4gICAgQ2ZuU2NhbGluZ1BvbGljeV9QcmVkZWZpbmVkTWV0cmljU3BlY2lmaWNhdGlvblByb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXMpLmFzc2VydFN1Y2Nlc3MoKTtcbiAgICByZXR1cm4ge1xuICAgICAgICBQcmVkZWZpbmVkTWV0cmljVHlwZTogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5wcmVkZWZpbmVkTWV0cmljVHlwZSksXG4gICAgICAgIFJlc291cmNlTGFiZWw6IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMucmVzb3VyY2VMYWJlbCksXG4gICAgfTtcbn1cblxuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIENmblNjYWxpbmdQb2xpY3lQcmVkZWZpbmVkTWV0cmljU3BlY2lmaWNhdGlvblByb3BlcnR5RnJvbUNsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQ8Q2ZuU2NhbGluZ1BvbGljeS5QcmVkZWZpbmVkTWV0cmljU3BlY2lmaWNhdGlvblByb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlPiB7XG4gICAgaWYgKGNkay5pc1Jlc29sdmFibGVPYmplY3QocHJvcGVydGllcykpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0KHByb3BlcnRpZXMpO1xuICAgIH1cbiAgICBwcm9wZXJ0aWVzID0gcHJvcGVydGllcyA9PSBudWxsID8ge30gOiBwcm9wZXJ0aWVzO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0KHByb3BlcnRpZXMpO1xuICAgIH1cbiAgICBjb25zdCByZXQgPSBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblByb3BlcnR5T2JqZWN0PENmblNjYWxpbmdQb2xpY3kuUHJlZGVmaW5lZE1ldHJpY1NwZWNpZmljYXRpb25Qcm9wZXJ0eT4oKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ3ByZWRlZmluZWRNZXRyaWNUeXBlJywgJ1ByZWRlZmluZWRNZXRyaWNUeXBlJywgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5QcmVkZWZpbmVkTWV0cmljVHlwZSkpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgncmVzb3VyY2VMYWJlbCcsICdSZXNvdXJjZUxhYmVsJywgcHJvcGVydGllcy5SZXNvdXJjZUxhYmVsICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLlJlc291cmNlTGFiZWwpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkVW5yZWNvZ25pemVkUHJvcGVydGllc0FzRXh0cmEocHJvcGVydGllcyk7XG4gICAgcmV0dXJuIHJldDtcbn1cblxuZXhwb3J0IG5hbWVzcGFjZSBDZm5TY2FsaW5nUG9saWN5IHtcbiAgICAvKipcbiAgICAgKiBgUHJlZGljdGl2ZVNjYWxpbmdDb25maWd1cmF0aW9uYCBpcyBhIHByb3BlcnR5IG9mIHRoZSBbQVdTOjpBdXRvU2NhbGluZzo6U2NhbGluZ1BvbGljeV0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXMtcG9saWN5Lmh0bWwpIHJlc291cmNlIHRoYXQgc3BlY2lmaWVzIGEgcHJlZGljdGl2ZSBzY2FsaW5nIHBvbGljeSBmb3IgQW1hem9uIEVDMiBBdXRvIFNjYWxpbmcuXG4gICAgICpcbiAgICAgKiBGb3IgbW9yZSBpbmZvcm1hdGlvbiwgc2VlIFtQcmVkaWN0aXZlIHNjYWxpbmddKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9hdXRvc2NhbGluZy9lYzIvdXNlcmd1aWRlL2VjMi1hdXRvLXNjYWxpbmctcHJlZGljdGl2ZS1zY2FsaW5nLmh0bWwpIGluIHRoZSAqQW1hem9uIEVDMiBBdXRvIFNjYWxpbmcgVXNlciBHdWlkZSogLlxuICAgICAqXG4gICAgICogQHN0cnVjdFxuICAgICAqIEBzdGFiaWxpdHkgZXh0ZXJuYWxcbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXV0b3NjYWxpbmctc2NhbGluZ3BvbGljeS1wcmVkaWN0aXZlc2NhbGluZ2NvbmZpZ3VyYXRpb24uaHRtbFxuICAgICAqL1xuICAgIGV4cG9ydCBpbnRlcmZhY2UgUHJlZGljdGl2ZVNjYWxpbmdDb25maWd1cmF0aW9uUHJvcGVydHkge1xuICAgICAgICAvKipcbiAgICAgICAgICogRGVmaW5lcyB0aGUgYmVoYXZpb3IgdGhhdCBzaG91bGQgYmUgYXBwbGllZCBpZiB0aGUgZm9yZWNhc3QgY2FwYWNpdHkgYXBwcm9hY2hlcyBvciBleGNlZWRzIHRoZSBtYXhpbXVtIGNhcGFjaXR5IG9mIHRoZSBBdXRvIFNjYWxpbmcgZ3JvdXAuIERlZmF1bHRzIHRvIGBIb25vck1heENhcGFjaXR5YCBpZiBub3Qgc3BlY2lmaWVkLlxuICAgICAgICAgKlxuICAgICAgICAgKiBUaGUgZm9sbG93aW5nIGFyZSBwb3NzaWJsZSB2YWx1ZXM6XG4gICAgICAgICAqXG4gICAgICAgICAqIC0gYEhvbm9yTWF4Q2FwYWNpdHlgIC0gQW1hem9uIEVDMiBBdXRvIFNjYWxpbmcgY2Fubm90IHNjYWxlIG91dCBjYXBhY2l0eSBoaWdoZXIgdGhhbiB0aGUgbWF4aW11bSBjYXBhY2l0eS4gVGhlIG1heGltdW0gY2FwYWNpdHkgaXMgZW5mb3JjZWQgYXMgYSBoYXJkIGxpbWl0LlxuICAgICAgICAgKiAtIGBJbmNyZWFzZU1heENhcGFjaXR5YCAtIEFtYXpvbiBFQzIgQXV0byBTY2FsaW5nIGNhbiBzY2FsZSBvdXQgY2FwYWNpdHkgaGlnaGVyIHRoYW4gdGhlIG1heGltdW0gY2FwYWNpdHkgd2hlbiB0aGUgZm9yZWNhc3QgY2FwYWNpdHkgaXMgY2xvc2UgdG8gb3IgZXhjZWVkcyB0aGUgbWF4aW11bSBjYXBhY2l0eS4gVGhlIHVwcGVyIGxpbWl0IGlzIGRldGVybWluZWQgYnkgdGhlIGZvcmVjYXN0ZWQgY2FwYWNpdHkgYW5kIHRoZSB2YWx1ZSBmb3IgYE1heENhcGFjaXR5QnVmZmVyYCAuXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXV0b3NjYWxpbmctc2NhbGluZ3BvbGljeS1wcmVkaWN0aXZlc2NhbGluZ2NvbmZpZ3VyYXRpb24uaHRtbCNjZm4tYXV0b3NjYWxpbmctc2NhbGluZ3BvbGljeS1wcmVkaWN0aXZlc2NhbGluZ2NvbmZpZ3VyYXRpb24tbWF4Y2FwYWNpdHlicmVhY2hiZWhhdmlvclxuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgbWF4Q2FwYWNpdHlCcmVhY2hCZWhhdmlvcj86IHN0cmluZztcbiAgICAgICAgLyoqXG4gICAgICAgICAqIFRoZSBzaXplIG9mIHRoZSBjYXBhY2l0eSBidWZmZXIgdG8gdXNlIHdoZW4gdGhlIGZvcmVjYXN0IGNhcGFjaXR5IGlzIGNsb3NlIHRvIG9yIGV4Y2VlZHMgdGhlIG1heGltdW0gY2FwYWNpdHkuIFRoZSB2YWx1ZSBpcyBzcGVjaWZpZWQgYXMgYSBwZXJjZW50YWdlIHJlbGF0aXZlIHRvIHRoZSBmb3JlY2FzdCBjYXBhY2l0eS4gRm9yIGV4YW1wbGUsIGlmIHRoZSBidWZmZXIgaXMgMTAsIHRoaXMgbWVhbnMgYSAxMCBwZXJjZW50IGJ1ZmZlciwgc3VjaCB0aGF0IGlmIHRoZSBmb3JlY2FzdCBjYXBhY2l0eSBpcyA1MCwgYW5kIHRoZSBtYXhpbXVtIGNhcGFjaXR5IGlzIDQwLCB0aGVuIHRoZSBlZmZlY3RpdmUgbWF4aW11bSBjYXBhY2l0eSBpcyA1NS5cbiAgICAgICAgICpcbiAgICAgICAgICogSWYgc2V0IHRvIDAsIEFtYXpvbiBFQzIgQXV0byBTY2FsaW5nIG1heSBzY2FsZSBjYXBhY2l0eSBoaWdoZXIgdGhhbiB0aGUgbWF4aW11bSBjYXBhY2l0eSB0byBlcXVhbCBidXQgbm90IGV4Y2VlZCBmb3JlY2FzdCBjYXBhY2l0eS5cbiAgICAgICAgICpcbiAgICAgICAgICogUmVxdWlyZWQgaWYgdGhlIGBNYXhDYXBhY2l0eUJyZWFjaEJlaGF2aW9yYCBwcm9wZXJ0eSBpcyBzZXQgdG8gYEluY3JlYXNlTWF4Q2FwYWNpdHlgICwgYW5kIGNhbm5vdCBiZSB1c2VkIG90aGVyd2lzZS5cbiAgICAgICAgICpcbiAgICAgICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hdXRvc2NhbGluZy1zY2FsaW5ncG9saWN5LXByZWRpY3RpdmVzY2FsaW5nY29uZmlndXJhdGlvbi5odG1sI2Nmbi1hdXRvc2NhbGluZy1zY2FsaW5ncG9saWN5LXByZWRpY3RpdmVzY2FsaW5nY29uZmlndXJhdGlvbi1tYXhjYXBhY2l0eWJ1ZmZlclxuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgbWF4Q2FwYWNpdHlCdWZmZXI/OiBudW1iZXI7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBUaGlzIHN0cnVjdHVyZSBpbmNsdWRlcyB0aGUgbWV0cmljcyBhbmQgdGFyZ2V0IHV0aWxpemF0aW9uIHRvIHVzZSBmb3IgcHJlZGljdGl2ZSBzY2FsaW5nLlxuICAgICAgICAgKlxuICAgICAgICAgKiBUaGlzIGlzIGFuIGFycmF5LCBidXQgd2UgY3VycmVudGx5IG9ubHkgc3VwcG9ydCBhIHNpbmdsZSBtZXRyaWMgc3BlY2lmaWNhdGlvbi4gVGhhdCBpcywgeW91IGNhbiBzcGVjaWZ5IGEgdGFyZ2V0IHZhbHVlIGFuZCBhIHNpbmdsZSBtZXRyaWMgcGFpciwgb3IgYSB0YXJnZXQgdmFsdWUgYW5kIG9uZSBzY2FsaW5nIG1ldHJpYyBhbmQgb25lIGxvYWQgbWV0cmljLlxuICAgICAgICAgKlxuICAgICAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWF1dG9zY2FsaW5nLXNjYWxpbmdwb2xpY3ktcHJlZGljdGl2ZXNjYWxpbmdjb25maWd1cmF0aW9uLmh0bWwjY2ZuLWF1dG9zY2FsaW5nLXNjYWxpbmdwb2xpY3ktcHJlZGljdGl2ZXNjYWxpbmdjb25maWd1cmF0aW9uLW1ldHJpY3NwZWNpZmljYXRpb25zXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBtZXRyaWNTcGVjaWZpY2F0aW9uczogQXJyYXk8Q2ZuU2NhbGluZ1BvbGljeS5QcmVkaWN0aXZlU2NhbGluZ01ldHJpY1NwZWNpZmljYXRpb25Qcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZT4gfCBjZGsuSVJlc29sdmFibGU7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBUaGUgcHJlZGljdGl2ZSBzY2FsaW5nIG1vZGUuIERlZmF1bHRzIHRvIGBGb3JlY2FzdE9ubHlgIGlmIG5vdCBzcGVjaWZpZWQuXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXV0b3NjYWxpbmctc2NhbGluZ3BvbGljeS1wcmVkaWN0aXZlc2NhbGluZ2NvbmZpZ3VyYXRpb24uaHRtbCNjZm4tYXV0b3NjYWxpbmctc2NhbGluZ3BvbGljeS1wcmVkaWN0aXZlc2NhbGluZ2NvbmZpZ3VyYXRpb24tbW9kZVxuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgbW9kZT86IHN0cmluZztcbiAgICAgICAgLyoqXG4gICAgICAgICAqIFRoZSBhbW91bnQgb2YgdGltZSwgaW4gc2Vjb25kcywgYnkgd2hpY2ggdGhlIGluc3RhbmNlIGxhdW5jaCB0aW1lIGNhbiBiZSBhZHZhbmNlZC4gRm9yIGV4YW1wbGUsIHRoZSBmb3JlY2FzdCBzYXlzIHRvIGFkZCBjYXBhY2l0eSBhdCAxMDowMCBBTSwgYW5kIHlvdSBjaG9vc2UgdG8gcHJlLWxhdW5jaCBpbnN0YW5jZXMgYnkgNSBtaW51dGVzLiBJbiB0aGF0IGNhc2UsIHRoZSBpbnN0YW5jZXMgd2lsbCBiZSBsYXVuY2hlZCBhdCA5OjU1IEFNLiBUaGUgaW50ZW50aW9uIGlzIHRvIGdpdmUgcmVzb3VyY2VzIHRpbWUgdG8gYmUgcHJvdmlzaW9uZWQuIEl0IGNhbiB0YWtlIGEgZmV3IG1pbnV0ZXMgdG8gbGF1bmNoIGFuIEVDMiBpbnN0YW5jZS4gVGhlIGFjdHVhbCBhbW91bnQgb2YgdGltZSByZXF1aXJlZCBkZXBlbmRzIG9uIHNldmVyYWwgZmFjdG9ycywgc3VjaCBhcyB0aGUgc2l6ZSBvZiB0aGUgaW5zdGFuY2UgYW5kIHdoZXRoZXIgdGhlcmUgYXJlIHN0YXJ0dXAgc2NyaXB0cyB0byBjb21wbGV0ZS5cbiAgICAgICAgICpcbiAgICAgICAgICogVGhlIHZhbHVlIG11c3QgYmUgbGVzcyB0aGFuIHRoZSBmb3JlY2FzdCBpbnRlcnZhbCBkdXJhdGlvbiBvZiAzNjAwIHNlY29uZHMgKDYwIG1pbnV0ZXMpLiBEZWZhdWx0cyB0byAzMDAgc2Vjb25kcyBpZiBub3Qgc3BlY2lmaWVkLlxuICAgICAgICAgKlxuICAgICAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWF1dG9zY2FsaW5nLXNjYWxpbmdwb2xpY3ktcHJlZGljdGl2ZXNjYWxpbmdjb25maWd1cmF0aW9uLmh0bWwjY2ZuLWF1dG9zY2FsaW5nLXNjYWxpbmdwb2xpY3ktcHJlZGljdGl2ZXNjYWxpbmdjb25maWd1cmF0aW9uLXNjaGVkdWxpbmdidWZmZXJ0aW1lXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBzY2hlZHVsaW5nQnVmZmVyVGltZT86IG51bWJlcjtcbiAgICB9XG59XG5cbi8qKlxuICogRGV0ZXJtaW5lIHdoZXRoZXIgdGhlIGdpdmVuIHByb3BlcnRpZXMgbWF0Y2ggdGhvc2Ugb2YgYSBgUHJlZGljdGl2ZVNjYWxpbmdDb25maWd1cmF0aW9uUHJvcGVydHlgXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYFByZWRpY3RpdmVTY2FsaW5nQ29uZmlndXJhdGlvblByb3BlcnR5YFxuICpcbiAqIEByZXR1cm5zIHRoZSByZXN1bHQgb2YgdGhlIHZhbGlkYXRpb24uXG4gKi9cbmZ1bmN0aW9uIENmblNjYWxpbmdQb2xpY3lfUHJlZGljdGl2ZVNjYWxpbmdDb25maWd1cmF0aW9uUHJvcGVydHlWYWxpZGF0b3IocHJvcGVydGllczogYW55KTogY2RrLlZhbGlkYXRpb25SZXN1bHQge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIGNkay5WQUxJREFUSU9OX1NVQ0NFU1M7IH1cbiAgICBjb25zdCBlcnJvcnMgPSBuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHRzKCk7XG4gICAgaWYgKHR5cGVvZiBwcm9wZXJ0aWVzICE9PSAnb2JqZWN0Jykge1xuICAgICAgICBlcnJvcnMuY29sbGVjdChuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHQoJ0V4cGVjdGVkIGFuIG9iamVjdCwgYnV0IHJlY2VpdmVkOiAnICsgSlNPTi5zdHJpbmdpZnkocHJvcGVydGllcykpKTtcbiAgICB9XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdtYXhDYXBhY2l0eUJyZWFjaEJlaGF2aW9yJywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLm1heENhcGFjaXR5QnJlYWNoQmVoYXZpb3IpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ21heENhcGFjaXR5QnVmZmVyJywgY2RrLnZhbGlkYXRlTnVtYmVyKShwcm9wZXJ0aWVzLm1heENhcGFjaXR5QnVmZmVyKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdtZXRyaWNTcGVjaWZpY2F0aW9ucycsIGNkay5yZXF1aXJlZFZhbGlkYXRvcikocHJvcGVydGllcy5tZXRyaWNTcGVjaWZpY2F0aW9ucykpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignbWV0cmljU3BlY2lmaWNhdGlvbnMnLCBjZGsubGlzdFZhbGlkYXRvcihDZm5TY2FsaW5nUG9saWN5X1ByZWRpY3RpdmVTY2FsaW5nTWV0cmljU3BlY2lmaWNhdGlvblByb3BlcnR5VmFsaWRhdG9yKSkocHJvcGVydGllcy5tZXRyaWNTcGVjaWZpY2F0aW9ucykpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignbW9kZScsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5tb2RlKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdzY2hlZHVsaW5nQnVmZmVyVGltZScsIGNkay52YWxpZGF0ZU51bWJlcikocHJvcGVydGllcy5zY2hlZHVsaW5nQnVmZmVyVGltZSkpO1xuICAgIHJldHVybiBlcnJvcnMud3JhcCgnc3VwcGxpZWQgcHJvcGVydGllcyBub3QgY29ycmVjdCBmb3IgXCJQcmVkaWN0aXZlU2NhbGluZ0NvbmZpZ3VyYXRpb25Qcm9wZXJ0eVwiJyk7XG59XG5cbi8qKlxuICogUmVuZGVycyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6QXV0b1NjYWxpbmc6OlNjYWxpbmdQb2xpY3kuUHJlZGljdGl2ZVNjYWxpbmdDb25maWd1cmF0aW9uYCByZXNvdXJjZVxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBQcmVkaWN0aXZlU2NhbGluZ0NvbmZpZ3VyYXRpb25Qcm9wZXJ0eWBcbiAqXG4gKiBAcmV0dXJucyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6QXV0b1NjYWxpbmc6OlNjYWxpbmdQb2xpY3kuUHJlZGljdGl2ZVNjYWxpbmdDb25maWd1cmF0aW9uYCByZXNvdXJjZS5cbiAqL1xuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIGNmblNjYWxpbmdQb2xpY3lQcmVkaWN0aXZlU2NhbGluZ0NvbmZpZ3VyYXRpb25Qcm9wZXJ0eVRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogYW55IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBwcm9wZXJ0aWVzOyB9XG4gICAgQ2ZuU2NhbGluZ1BvbGljeV9QcmVkaWN0aXZlU2NhbGluZ0NvbmZpZ3VyYXRpb25Qcm9wZXJ0eVZhbGlkYXRvcihwcm9wZXJ0aWVzKS5hc3NlcnRTdWNjZXNzKCk7XG4gICAgcmV0dXJuIHtcbiAgICAgICAgTWF4Q2FwYWNpdHlCcmVhY2hCZWhhdmlvcjogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5tYXhDYXBhY2l0eUJyZWFjaEJlaGF2aW9yKSxcbiAgICAgICAgTWF4Q2FwYWNpdHlCdWZmZXI6IGNkay5udW1iZXJUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMubWF4Q2FwYWNpdHlCdWZmZXIpLFxuICAgICAgICBNZXRyaWNTcGVjaWZpY2F0aW9uczogY2RrLmxpc3RNYXBwZXIoY2ZuU2NhbGluZ1BvbGljeVByZWRpY3RpdmVTY2FsaW5nTWV0cmljU3BlY2lmaWNhdGlvblByb3BlcnR5VG9DbG91ZEZvcm1hdGlvbikocHJvcGVydGllcy5tZXRyaWNTcGVjaWZpY2F0aW9ucyksXG4gICAgICAgIE1vZGU6IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMubW9kZSksXG4gICAgICAgIFNjaGVkdWxpbmdCdWZmZXJUaW1lOiBjZGsubnVtYmVyVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLnNjaGVkdWxpbmdCdWZmZXJUaW1lKSxcbiAgICB9O1xufVxuXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gQ2ZuU2NhbGluZ1BvbGljeVByZWRpY3RpdmVTY2FsaW5nQ29uZmlndXJhdGlvblByb3BlcnR5RnJvbUNsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQ8Q2ZuU2NhbGluZ1BvbGljeS5QcmVkaWN0aXZlU2NhbGluZ0NvbmZpZ3VyYXRpb25Qcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZT4ge1xuICAgIGlmIChjZGsuaXNSZXNvbHZhYmxlT2JqZWN0KHByb3BlcnRpZXMpKSB7XG4gICAgICAgIHJldHVybiBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdChwcm9wZXJ0aWVzKTtcbiAgICB9XG4gICAgcHJvcGVydGllcyA9IHByb3BlcnRpZXMgPT0gbnVsbCA/IHt9IDogcHJvcGVydGllcztcbiAgICBpZiAodHlwZW9mIHByb3BlcnRpZXMgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIHJldHVybiBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdChwcm9wZXJ0aWVzKTtcbiAgICB9XG4gICAgY29uc3QgcmV0ID0gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25Qcm9wZXJ0eU9iamVjdDxDZm5TY2FsaW5nUG9saWN5LlByZWRpY3RpdmVTY2FsaW5nQ29uZmlndXJhdGlvblByb3BlcnR5PigpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnbWF4Q2FwYWNpdHlCcmVhY2hCZWhhdmlvcicsICdNYXhDYXBhY2l0eUJyZWFjaEJlaGF2aW9yJywgcHJvcGVydGllcy5NYXhDYXBhY2l0eUJyZWFjaEJlaGF2aW9yICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLk1heENhcGFjaXR5QnJlYWNoQmVoYXZpb3IpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ21heENhcGFjaXR5QnVmZmVyJywgJ01heENhcGFjaXR5QnVmZmVyJywgcHJvcGVydGllcy5NYXhDYXBhY2l0eUJ1ZmZlciAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXROdW1iZXIocHJvcGVydGllcy5NYXhDYXBhY2l0eUJ1ZmZlcikgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnbWV0cmljU3BlY2lmaWNhdGlvbnMnLCAnTWV0cmljU3BlY2lmaWNhdGlvbnMnLCBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldEFycmF5KENmblNjYWxpbmdQb2xpY3lQcmVkaWN0aXZlU2NhbGluZ01ldHJpY1NwZWNpZmljYXRpb25Qcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbikocHJvcGVydGllcy5NZXRyaWNTcGVjaWZpY2F0aW9ucykpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnbW9kZScsICdNb2RlJywgcHJvcGVydGllcy5Nb2RlICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLk1vZGUpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ3NjaGVkdWxpbmdCdWZmZXJUaW1lJywgJ1NjaGVkdWxpbmdCdWZmZXJUaW1lJywgcHJvcGVydGllcy5TY2hlZHVsaW5nQnVmZmVyVGltZSAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXROdW1iZXIocHJvcGVydGllcy5TY2hlZHVsaW5nQnVmZmVyVGltZSkgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRVbnJlY29nbml6ZWRQcm9wZXJ0aWVzQXNFeHRyYShwcm9wZXJ0aWVzKTtcbiAgICByZXR1cm4gcmV0O1xufVxuXG5leHBvcnQgbmFtZXNwYWNlIENmblNjYWxpbmdQb2xpY3kge1xuICAgIC8qKlxuICAgICAqIENvbnRhaW5zIGNhcGFjaXR5IG1ldHJpYyBpbmZvcm1hdGlvbiBmb3IgdGhlIGBDdXN0b21pemVkQ2FwYWNpdHlNZXRyaWNTcGVjaWZpY2F0aW9uYCBwcm9wZXJ0eSBvZiB0aGUgW0FXUzo6QXV0b1NjYWxpbmc6OlNjYWxpbmdQb2xpY3kgUHJlZGljdGl2ZVNjYWxpbmdNZXRyaWNTcGVjaWZpY2F0aW9uXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hdXRvc2NhbGluZy1zY2FsaW5ncG9saWN5LXByZWRpY3RpdmVzY2FsaW5nbWV0cmljc3BlY2lmaWNhdGlvbi5odG1sKSBwcm9wZXJ0eSB0eXBlLlxuICAgICAqXG4gICAgICogQHN0cnVjdFxuICAgICAqIEBzdGFiaWxpdHkgZXh0ZXJuYWxcbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXV0b3NjYWxpbmctc2NhbGluZ3BvbGljeS1wcmVkaWN0aXZlc2NhbGluZ2N1c3RvbWl6ZWRjYXBhY2l0eW1ldHJpYy5odG1sXG4gICAgICovXG4gICAgZXhwb3J0IGludGVyZmFjZSBQcmVkaWN0aXZlU2NhbGluZ0N1c3RvbWl6ZWRDYXBhY2l0eU1ldHJpY1Byb3BlcnR5IHtcbiAgICAgICAgLyoqXG4gICAgICAgICAqIE9uZSBvciBtb3JlIG1ldHJpYyBkYXRhIHF1ZXJpZXMgdG8gcHJvdmlkZSB0aGUgZGF0YSBwb2ludHMgZm9yIGEgY2FwYWNpdHkgbWV0cmljLiBVc2UgbXVsdGlwbGUgbWV0cmljIGRhdGEgcXVlcmllcyBvbmx5IGlmIHlvdSBhcmUgcGVyZm9ybWluZyBhIG1hdGggZXhwcmVzc2lvbiBvbiByZXR1cm5lZCBkYXRhLlxuICAgICAgICAgKlxuICAgICAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWF1dG9zY2FsaW5nLXNjYWxpbmdwb2xpY3ktcHJlZGljdGl2ZXNjYWxpbmdjdXN0b21pemVkY2FwYWNpdHltZXRyaWMuaHRtbCNjZm4tYXV0b3NjYWxpbmctc2NhbGluZ3BvbGljeS1wcmVkaWN0aXZlc2NhbGluZ2N1c3RvbWl6ZWRjYXBhY2l0eW1ldHJpYy1tZXRyaWNkYXRhcXVlcmllc1xuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgbWV0cmljRGF0YVF1ZXJpZXM6IEFycmF5PENmblNjYWxpbmdQb2xpY3kuTWV0cmljRGF0YVF1ZXJ5UHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGU+IHwgY2RrLklSZXNvbHZhYmxlO1xuICAgIH1cbn1cblxuLyoqXG4gKiBEZXRlcm1pbmUgd2hldGhlciB0aGUgZ2l2ZW4gcHJvcGVydGllcyBtYXRjaCB0aG9zZSBvZiBhIGBQcmVkaWN0aXZlU2NhbGluZ0N1c3RvbWl6ZWRDYXBhY2l0eU1ldHJpY1Byb3BlcnR5YFxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBQcmVkaWN0aXZlU2NhbGluZ0N1c3RvbWl6ZWRDYXBhY2l0eU1ldHJpY1Byb3BlcnR5YFxuICpcbiAqIEByZXR1cm5zIHRoZSByZXN1bHQgb2YgdGhlIHZhbGlkYXRpb24uXG4gKi9cbmZ1bmN0aW9uIENmblNjYWxpbmdQb2xpY3lfUHJlZGljdGl2ZVNjYWxpbmdDdXN0b21pemVkQ2FwYWNpdHlNZXRyaWNQcm9wZXJ0eVZhbGlkYXRvcihwcm9wZXJ0aWVzOiBhbnkpOiBjZGsuVmFsaWRhdGlvblJlc3VsdCB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gY2RrLlZBTElEQVRJT05fU1VDQ0VTUzsgfVxuICAgIGNvbnN0IGVycm9ycyA9IG5ldyBjZGsuVmFsaWRhdGlvblJlc3VsdHMoKTtcbiAgICBpZiAodHlwZW9mIHByb3BlcnRpZXMgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIGVycm9ycy5jb2xsZWN0KG5ldyBjZGsuVmFsaWRhdGlvblJlc3VsdCgnRXhwZWN0ZWQgYW4gb2JqZWN0LCBidXQgcmVjZWl2ZWQ6ICcgKyBKU09OLnN0cmluZ2lmeShwcm9wZXJ0aWVzKSkpO1xuICAgIH1cbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ21ldHJpY0RhdGFRdWVyaWVzJywgY2RrLnJlcXVpcmVkVmFsaWRhdG9yKShwcm9wZXJ0aWVzLm1ldHJpY0RhdGFRdWVyaWVzKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdtZXRyaWNEYXRhUXVlcmllcycsIGNkay5saXN0VmFsaWRhdG9yKENmblNjYWxpbmdQb2xpY3lfTWV0cmljRGF0YVF1ZXJ5UHJvcGVydHlWYWxpZGF0b3IpKShwcm9wZXJ0aWVzLm1ldHJpY0RhdGFRdWVyaWVzKSk7XG4gICAgcmV0dXJuIGVycm9ycy53cmFwKCdzdXBwbGllZCBwcm9wZXJ0aWVzIG5vdCBjb3JyZWN0IGZvciBcIlByZWRpY3RpdmVTY2FsaW5nQ3VzdG9taXplZENhcGFjaXR5TWV0cmljUHJvcGVydHlcIicpO1xufVxuXG4vKipcbiAqIFJlbmRlcnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OkF1dG9TY2FsaW5nOjpTY2FsaW5nUG9saWN5LlByZWRpY3RpdmVTY2FsaW5nQ3VzdG9taXplZENhcGFjaXR5TWV0cmljYCByZXNvdXJjZVxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBQcmVkaWN0aXZlU2NhbGluZ0N1c3RvbWl6ZWRDYXBhY2l0eU1ldHJpY1Byb3BlcnR5YFxuICpcbiAqIEByZXR1cm5zIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpBdXRvU2NhbGluZzo6U2NhbGluZ1BvbGljeS5QcmVkaWN0aXZlU2NhbGluZ0N1c3RvbWl6ZWRDYXBhY2l0eU1ldHJpY2AgcmVzb3VyY2UuXG4gKi9cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBjZm5TY2FsaW5nUG9saWN5UHJlZGljdGl2ZVNjYWxpbmdDdXN0b21pemVkQ2FwYWNpdHlNZXRyaWNQcm9wZXJ0eVRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogYW55IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBwcm9wZXJ0aWVzOyB9XG4gICAgQ2ZuU2NhbGluZ1BvbGljeV9QcmVkaWN0aXZlU2NhbGluZ0N1c3RvbWl6ZWRDYXBhY2l0eU1ldHJpY1Byb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXMpLmFzc2VydFN1Y2Nlc3MoKTtcbiAgICByZXR1cm4ge1xuICAgICAgICBNZXRyaWNEYXRhUXVlcmllczogY2RrLmxpc3RNYXBwZXIoY2ZuU2NhbGluZ1BvbGljeU1ldHJpY0RhdGFRdWVyeVByb3BlcnR5VG9DbG91ZEZvcm1hdGlvbikocHJvcGVydGllcy5tZXRyaWNEYXRhUXVlcmllcyksXG4gICAgfTtcbn1cblxuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIENmblNjYWxpbmdQb2xpY3lQcmVkaWN0aXZlU2NhbGluZ0N1c3RvbWl6ZWRDYXBhY2l0eU1ldHJpY1Byb3BlcnR5RnJvbUNsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQ8Q2ZuU2NhbGluZ1BvbGljeS5QcmVkaWN0aXZlU2NhbGluZ0N1c3RvbWl6ZWRDYXBhY2l0eU1ldHJpY1Byb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlPiB7XG4gICAgaWYgKGNkay5pc1Jlc29sdmFibGVPYmplY3QocHJvcGVydGllcykpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0KHByb3BlcnRpZXMpO1xuICAgIH1cbiAgICBwcm9wZXJ0aWVzID0gcHJvcGVydGllcyA9PSBudWxsID8ge30gOiBwcm9wZXJ0aWVzO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0KHByb3BlcnRpZXMpO1xuICAgIH1cbiAgICBjb25zdCByZXQgPSBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblByb3BlcnR5T2JqZWN0PENmblNjYWxpbmdQb2xpY3kuUHJlZGljdGl2ZVNjYWxpbmdDdXN0b21pemVkQ2FwYWNpdHlNZXRyaWNQcm9wZXJ0eT4oKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ21ldHJpY0RhdGFRdWVyaWVzJywgJ01ldHJpY0RhdGFRdWVyaWVzJywgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRBcnJheShDZm5TY2FsaW5nUG9saWN5TWV0cmljRGF0YVF1ZXJ5UHJvcGVydHlGcm9tQ2xvdWRGb3JtYXRpb24pKHByb3BlcnRpZXMuTWV0cmljRGF0YVF1ZXJpZXMpKTtcbiAgICByZXQuYWRkVW5yZWNvZ25pemVkUHJvcGVydGllc0FzRXh0cmEocHJvcGVydGllcyk7XG4gICAgcmV0dXJuIHJldDtcbn1cblxuZXhwb3J0IG5hbWVzcGFjZSBDZm5TY2FsaW5nUG9saWN5IHtcbiAgICAvKipcbiAgICAgKiBDb250YWlucyBsb2FkIG1ldHJpYyBpbmZvcm1hdGlvbiBmb3IgdGhlIGBDdXN0b21pemVkTG9hZE1ldHJpY1NwZWNpZmljYXRpb25gIHByb3BlcnR5IG9mIHRoZSBbQVdTOjpBdXRvU2NhbGluZzo6U2NhbGluZ1BvbGljeSBQcmVkaWN0aXZlU2NhbGluZ01ldHJpY1NwZWNpZmljYXRpb25dKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWF1dG9zY2FsaW5nLXNjYWxpbmdwb2xpY3ktcHJlZGljdGl2ZXNjYWxpbmdtZXRyaWNzcGVjaWZpY2F0aW9uLmh0bWwpIHByb3BlcnR5IHR5cGUuXG4gICAgICpcbiAgICAgKiBAc3RydWN0XG4gICAgICogQHN0YWJpbGl0eSBleHRlcm5hbFxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hdXRvc2NhbGluZy1zY2FsaW5ncG9saWN5LXByZWRpY3RpdmVzY2FsaW5nY3VzdG9taXplZGxvYWRtZXRyaWMuaHRtbFxuICAgICAqL1xuICAgIGV4cG9ydCBpbnRlcmZhY2UgUHJlZGljdGl2ZVNjYWxpbmdDdXN0b21pemVkTG9hZE1ldHJpY1Byb3BlcnR5IHtcbiAgICAgICAgLyoqXG4gICAgICAgICAqIE9uZSBvciBtb3JlIG1ldHJpYyBkYXRhIHF1ZXJpZXMgdG8gcHJvdmlkZSB0aGUgZGF0YSBwb2ludHMgZm9yIGEgbG9hZCBtZXRyaWMuIFVzZSBtdWx0aXBsZSBtZXRyaWMgZGF0YSBxdWVyaWVzIG9ubHkgaWYgeW91IGFyZSBwZXJmb3JtaW5nIGEgbWF0aCBleHByZXNzaW9uIG9uIHJldHVybmVkIGRhdGEuXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXV0b3NjYWxpbmctc2NhbGluZ3BvbGljeS1wcmVkaWN0aXZlc2NhbGluZ2N1c3RvbWl6ZWRsb2FkbWV0cmljLmh0bWwjY2ZuLWF1dG9zY2FsaW5nLXNjYWxpbmdwb2xpY3ktcHJlZGljdGl2ZXNjYWxpbmdjdXN0b21pemVkbG9hZG1ldHJpYy1tZXRyaWNkYXRhcXVlcmllc1xuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgbWV0cmljRGF0YVF1ZXJpZXM6IEFycmF5PENmblNjYWxpbmdQb2xpY3kuTWV0cmljRGF0YVF1ZXJ5UHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGU+IHwgY2RrLklSZXNvbHZhYmxlO1xuICAgIH1cbn1cblxuLyoqXG4gKiBEZXRlcm1pbmUgd2hldGhlciB0aGUgZ2l2ZW4gcHJvcGVydGllcyBtYXRjaCB0aG9zZSBvZiBhIGBQcmVkaWN0aXZlU2NhbGluZ0N1c3RvbWl6ZWRMb2FkTWV0cmljUHJvcGVydHlgXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYFByZWRpY3RpdmVTY2FsaW5nQ3VzdG9taXplZExvYWRNZXRyaWNQcm9wZXJ0eWBcbiAqXG4gKiBAcmV0dXJucyB0aGUgcmVzdWx0IG9mIHRoZSB2YWxpZGF0aW9uLlxuICovXG5mdW5jdGlvbiBDZm5TY2FsaW5nUG9saWN5X1ByZWRpY3RpdmVTY2FsaW5nQ3VzdG9taXplZExvYWRNZXRyaWNQcm9wZXJ0eVZhbGlkYXRvcihwcm9wZXJ0aWVzOiBhbnkpOiBjZGsuVmFsaWRhdGlvblJlc3VsdCB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gY2RrLlZBTElEQVRJT05fU1VDQ0VTUzsgfVxuICAgIGNvbnN0IGVycm9ycyA9IG5ldyBjZGsuVmFsaWRhdGlvblJlc3VsdHMoKTtcbiAgICBpZiAodHlwZW9mIHByb3BlcnRpZXMgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIGVycm9ycy5jb2xsZWN0KG5ldyBjZGsuVmFsaWRhdGlvblJlc3VsdCgnRXhwZWN0ZWQgYW4gb2JqZWN0LCBidXQgcmVjZWl2ZWQ6ICcgKyBKU09OLnN0cmluZ2lmeShwcm9wZXJ0aWVzKSkpO1xuICAgIH1cbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ21ldHJpY0RhdGFRdWVyaWVzJywgY2RrLnJlcXVpcmVkVmFsaWRhdG9yKShwcm9wZXJ0aWVzLm1ldHJpY0RhdGFRdWVyaWVzKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdtZXRyaWNEYXRhUXVlcmllcycsIGNkay5saXN0VmFsaWRhdG9yKENmblNjYWxpbmdQb2xpY3lfTWV0cmljRGF0YVF1ZXJ5UHJvcGVydHlWYWxpZGF0b3IpKShwcm9wZXJ0aWVzLm1ldHJpY0RhdGFRdWVyaWVzKSk7XG4gICAgcmV0dXJuIGVycm9ycy53cmFwKCdzdXBwbGllZCBwcm9wZXJ0aWVzIG5vdCBjb3JyZWN0IGZvciBcIlByZWRpY3RpdmVTY2FsaW5nQ3VzdG9taXplZExvYWRNZXRyaWNQcm9wZXJ0eVwiJyk7XG59XG5cbi8qKlxuICogUmVuZGVycyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6QXV0b1NjYWxpbmc6OlNjYWxpbmdQb2xpY3kuUHJlZGljdGl2ZVNjYWxpbmdDdXN0b21pemVkTG9hZE1ldHJpY2AgcmVzb3VyY2VcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgUHJlZGljdGl2ZVNjYWxpbmdDdXN0b21pemVkTG9hZE1ldHJpY1Byb3BlcnR5YFxuICpcbiAqIEByZXR1cm5zIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpBdXRvU2NhbGluZzo6U2NhbGluZ1BvbGljeS5QcmVkaWN0aXZlU2NhbGluZ0N1c3RvbWl6ZWRMb2FkTWV0cmljYCByZXNvdXJjZS5cbiAqL1xuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIGNmblNjYWxpbmdQb2xpY3lQcmVkaWN0aXZlU2NhbGluZ0N1c3RvbWl6ZWRMb2FkTWV0cmljUHJvcGVydHlUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGFueSB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gcHJvcGVydGllczsgfVxuICAgIENmblNjYWxpbmdQb2xpY3lfUHJlZGljdGl2ZVNjYWxpbmdDdXN0b21pemVkTG9hZE1ldHJpY1Byb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXMpLmFzc2VydFN1Y2Nlc3MoKTtcbiAgICByZXR1cm4ge1xuICAgICAgICBNZXRyaWNEYXRhUXVlcmllczogY2RrLmxpc3RNYXBwZXIoY2ZuU2NhbGluZ1BvbGljeU1ldHJpY0RhdGFRdWVyeVByb3BlcnR5VG9DbG91ZEZvcm1hdGlvbikocHJvcGVydGllcy5tZXRyaWNEYXRhUXVlcmllcyksXG4gICAgfTtcbn1cblxuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIENmblNjYWxpbmdQb2xpY3lQcmVkaWN0aXZlU2NhbGluZ0N1c3RvbWl6ZWRMb2FkTWV0cmljUHJvcGVydHlGcm9tQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdDxDZm5TY2FsaW5nUG9saWN5LlByZWRpY3RpdmVTY2FsaW5nQ3VzdG9taXplZExvYWRNZXRyaWNQcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZT4ge1xuICAgIGlmIChjZGsuaXNSZXNvbHZhYmxlT2JqZWN0KHByb3BlcnRpZXMpKSB7XG4gICAgICAgIHJldHVybiBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdChwcm9wZXJ0aWVzKTtcbiAgICB9XG4gICAgcHJvcGVydGllcyA9IHByb3BlcnRpZXMgPT0gbnVsbCA/IHt9IDogcHJvcGVydGllcztcbiAgICBpZiAodHlwZW9mIHByb3BlcnRpZXMgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIHJldHVybiBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdChwcm9wZXJ0aWVzKTtcbiAgICB9XG4gICAgY29uc3QgcmV0ID0gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25Qcm9wZXJ0eU9iamVjdDxDZm5TY2FsaW5nUG9saWN5LlByZWRpY3RpdmVTY2FsaW5nQ3VzdG9taXplZExvYWRNZXRyaWNQcm9wZXJ0eT4oKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ21ldHJpY0RhdGFRdWVyaWVzJywgJ01ldHJpY0RhdGFRdWVyaWVzJywgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRBcnJheShDZm5TY2FsaW5nUG9saWN5TWV0cmljRGF0YVF1ZXJ5UHJvcGVydHlGcm9tQ2xvdWRGb3JtYXRpb24pKHByb3BlcnRpZXMuTWV0cmljRGF0YVF1ZXJpZXMpKTtcbiAgICByZXQuYWRkVW5yZWNvZ25pemVkUHJvcGVydGllc0FzRXh0cmEocHJvcGVydGllcyk7XG4gICAgcmV0dXJuIHJldDtcbn1cblxuZXhwb3J0IG5hbWVzcGFjZSBDZm5TY2FsaW5nUG9saWN5IHtcbiAgICAvKipcbiAgICAgKiBDb250YWlucyBzY2FsaW5nIG1ldHJpYyBpbmZvcm1hdGlvbiBmb3IgdGhlIGBDdXN0b21pemVkU2NhbGluZ01ldHJpY1NwZWNpZmljYXRpb25gIHByb3BlcnR5IG9mIHRoZSBbQVdTOjpBdXRvU2NhbGluZzo6U2NhbGluZ1BvbGljeSBQcmVkaWN0aXZlU2NhbGluZ01ldHJpY1NwZWNpZmljYXRpb25dKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWF1dG9zY2FsaW5nLXNjYWxpbmdwb2xpY3ktcHJlZGljdGl2ZXNjYWxpbmdtZXRyaWNzcGVjaWZpY2F0aW9uLmh0bWwpIHByb3BlcnR5IHR5cGUuXG4gICAgICpcbiAgICAgKiBAc3RydWN0XG4gICAgICogQHN0YWJpbGl0eSBleHRlcm5hbFxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hdXRvc2NhbGluZy1zY2FsaW5ncG9saWN5LXByZWRpY3RpdmVzY2FsaW5nY3VzdG9taXplZHNjYWxpbmdtZXRyaWMuaHRtbFxuICAgICAqL1xuICAgIGV4cG9ydCBpbnRlcmZhY2UgUHJlZGljdGl2ZVNjYWxpbmdDdXN0b21pemVkU2NhbGluZ01ldHJpY1Byb3BlcnR5IHtcbiAgICAgICAgLyoqXG4gICAgICAgICAqIE9uZSBvciBtb3JlIG1ldHJpYyBkYXRhIHF1ZXJpZXMgdG8gcHJvdmlkZSB0aGUgZGF0YSBwb2ludHMgZm9yIGEgc2NhbGluZyBtZXRyaWMuIFVzZSBtdWx0aXBsZSBtZXRyaWMgZGF0YSBxdWVyaWVzIG9ubHkgaWYgeW91IGFyZSBwZXJmb3JtaW5nIGEgbWF0aCBleHByZXNzaW9uIG9uIHJldHVybmVkIGRhdGEuXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXV0b3NjYWxpbmctc2NhbGluZ3BvbGljeS1wcmVkaWN0aXZlc2NhbGluZ2N1c3RvbWl6ZWRzY2FsaW5nbWV0cmljLmh0bWwjY2ZuLWF1dG9zY2FsaW5nLXNjYWxpbmdwb2xpY3ktcHJlZGljdGl2ZXNjYWxpbmdjdXN0b21pemVkc2NhbGluZ21ldHJpYy1tZXRyaWNkYXRhcXVlcmllc1xuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgbWV0cmljRGF0YVF1ZXJpZXM6IEFycmF5PENmblNjYWxpbmdQb2xpY3kuTWV0cmljRGF0YVF1ZXJ5UHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGU+IHwgY2RrLklSZXNvbHZhYmxlO1xuICAgIH1cbn1cblxuLyoqXG4gKiBEZXRlcm1pbmUgd2hldGhlciB0aGUgZ2l2ZW4gcHJvcGVydGllcyBtYXRjaCB0aG9zZSBvZiBhIGBQcmVkaWN0aXZlU2NhbGluZ0N1c3RvbWl6ZWRTY2FsaW5nTWV0cmljUHJvcGVydHlgXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYFByZWRpY3RpdmVTY2FsaW5nQ3VzdG9taXplZFNjYWxpbmdNZXRyaWNQcm9wZXJ0eWBcbiAqXG4gKiBAcmV0dXJucyB0aGUgcmVzdWx0IG9mIHRoZSB2YWxpZGF0aW9uLlxuICovXG5mdW5jdGlvbiBDZm5TY2FsaW5nUG9saWN5X1ByZWRpY3RpdmVTY2FsaW5nQ3VzdG9taXplZFNjYWxpbmdNZXRyaWNQcm9wZXJ0eVZhbGlkYXRvcihwcm9wZXJ0aWVzOiBhbnkpOiBjZGsuVmFsaWRhdGlvblJlc3VsdCB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gY2RrLlZBTElEQVRJT05fU1VDQ0VTUzsgfVxuICAgIGNvbnN0IGVycm9ycyA9IG5ldyBjZGsuVmFsaWRhdGlvblJlc3VsdHMoKTtcbiAgICBpZiAodHlwZW9mIHByb3BlcnRpZXMgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIGVycm9ycy5jb2xsZWN0KG5ldyBjZGsuVmFsaWRhdGlvblJlc3VsdCgnRXhwZWN0ZWQgYW4gb2JqZWN0LCBidXQgcmVjZWl2ZWQ6ICcgKyBKU09OLnN0cmluZ2lmeShwcm9wZXJ0aWVzKSkpO1xuICAgIH1cbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ21ldHJpY0RhdGFRdWVyaWVzJywgY2RrLnJlcXVpcmVkVmFsaWRhdG9yKShwcm9wZXJ0aWVzLm1ldHJpY0RhdGFRdWVyaWVzKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdtZXRyaWNEYXRhUXVlcmllcycsIGNkay5saXN0VmFsaWRhdG9yKENmblNjYWxpbmdQb2xpY3lfTWV0cmljRGF0YVF1ZXJ5UHJvcGVydHlWYWxpZGF0b3IpKShwcm9wZXJ0aWVzLm1ldHJpY0RhdGFRdWVyaWVzKSk7XG4gICAgcmV0dXJuIGVycm9ycy53cmFwKCdzdXBwbGllZCBwcm9wZXJ0aWVzIG5vdCBjb3JyZWN0IGZvciBcIlByZWRpY3RpdmVTY2FsaW5nQ3VzdG9taXplZFNjYWxpbmdNZXRyaWNQcm9wZXJ0eVwiJyk7XG59XG5cbi8qKlxuICogUmVuZGVycyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6QXV0b1NjYWxpbmc6OlNjYWxpbmdQb2xpY3kuUHJlZGljdGl2ZVNjYWxpbmdDdXN0b21pemVkU2NhbGluZ01ldHJpY2AgcmVzb3VyY2VcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgUHJlZGljdGl2ZVNjYWxpbmdDdXN0b21pemVkU2NhbGluZ01ldHJpY1Byb3BlcnR5YFxuICpcbiAqIEByZXR1cm5zIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpBdXRvU2NhbGluZzo6U2NhbGluZ1BvbGljeS5QcmVkaWN0aXZlU2NhbGluZ0N1c3RvbWl6ZWRTY2FsaW5nTWV0cmljYCByZXNvdXJjZS5cbiAqL1xuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIGNmblNjYWxpbmdQb2xpY3lQcmVkaWN0aXZlU2NhbGluZ0N1c3RvbWl6ZWRTY2FsaW5nTWV0cmljUHJvcGVydHlUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGFueSB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gcHJvcGVydGllczsgfVxuICAgIENmblNjYWxpbmdQb2xpY3lfUHJlZGljdGl2ZVNjYWxpbmdDdXN0b21pemVkU2NhbGluZ01ldHJpY1Byb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXMpLmFzc2VydFN1Y2Nlc3MoKTtcbiAgICByZXR1cm4ge1xuICAgICAgICBNZXRyaWNEYXRhUXVlcmllczogY2RrLmxpc3RNYXBwZXIoY2ZuU2NhbGluZ1BvbGljeU1ldHJpY0RhdGFRdWVyeVByb3BlcnR5VG9DbG91ZEZvcm1hdGlvbikocHJvcGVydGllcy5tZXRyaWNEYXRhUXVlcmllcyksXG4gICAgfTtcbn1cblxuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIENmblNjYWxpbmdQb2xpY3lQcmVkaWN0aXZlU2NhbGluZ0N1c3RvbWl6ZWRTY2FsaW5nTWV0cmljUHJvcGVydHlGcm9tQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdDxDZm5TY2FsaW5nUG9saWN5LlByZWRpY3RpdmVTY2FsaW5nQ3VzdG9taXplZFNjYWxpbmdNZXRyaWNQcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZT4ge1xuICAgIGlmIChjZGsuaXNSZXNvbHZhYmxlT2JqZWN0KHByb3BlcnRpZXMpKSB7XG4gICAgICAgIHJldHVybiBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdChwcm9wZXJ0aWVzKTtcbiAgICB9XG4gICAgcHJvcGVydGllcyA9IHByb3BlcnRpZXMgPT0gbnVsbCA/IHt9IDogcHJvcGVydGllcztcbiAgICBpZiAodHlwZW9mIHByb3BlcnRpZXMgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIHJldHVybiBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdChwcm9wZXJ0aWVzKTtcbiAgICB9XG4gICAgY29uc3QgcmV0ID0gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25Qcm9wZXJ0eU9iamVjdDxDZm5TY2FsaW5nUG9saWN5LlByZWRpY3RpdmVTY2FsaW5nQ3VzdG9taXplZFNjYWxpbmdNZXRyaWNQcm9wZXJ0eT4oKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ21ldHJpY0RhdGFRdWVyaWVzJywgJ01ldHJpY0RhdGFRdWVyaWVzJywgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRBcnJheShDZm5TY2FsaW5nUG9saWN5TWV0cmljRGF0YVF1ZXJ5UHJvcGVydHlGcm9tQ2xvdWRGb3JtYXRpb24pKHByb3BlcnRpZXMuTWV0cmljRGF0YVF1ZXJpZXMpKTtcbiAgICByZXQuYWRkVW5yZWNvZ25pemVkUHJvcGVydGllc0FzRXh0cmEocHJvcGVydGllcyk7XG4gICAgcmV0dXJuIHJldDtcbn1cblxuZXhwb3J0IG5hbWVzcGFjZSBDZm5TY2FsaW5nUG9saWN5IHtcbiAgICAvKipcbiAgICAgKiBBIHN0cnVjdHVyZSB0aGF0IHNwZWNpZmllcyBhIG1ldHJpYyBzcGVjaWZpY2F0aW9uIGZvciB0aGUgYE1ldHJpY1NwZWNpZmljYXRpb25zYCBwcm9wZXJ0eSBvZiB0aGUgW0FXUzo6QXV0b1NjYWxpbmc6OlNjYWxpbmdQb2xpY3kgUHJlZGljdGl2ZVNjYWxpbmdDb25maWd1cmF0aW9uXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hdXRvc2NhbGluZy1zY2FsaW5ncG9saWN5LXByZWRpY3RpdmVzY2FsaW5nY29uZmlndXJhdGlvbi5odG1sKSBwcm9wZXJ0eSB0eXBlLlxuICAgICAqXG4gICAgICogWW91IG11c3Qgc3BlY2lmeSBlaXRoZXIgYSBtZXRyaWMgcGFpciwgb3IgYSBsb2FkIG1ldHJpYyBhbmQgYSBzY2FsaW5nIG1ldHJpYyBpbmRpdmlkdWFsbHkuIFNwZWNpZnlpbmcgYSBtZXRyaWMgcGFpciBpbnN0ZWFkIG9mIGluZGl2aWR1YWwgbWV0cmljcyBwcm92aWRlcyBhIHNpbXBsZXIgd2F5IHRvIGNvbmZpZ3VyZSBtZXRyaWNzIGZvciBhIHNjYWxpbmcgcG9saWN5LiBZb3UgY2hvb3NlIHRoZSBtZXRyaWMgcGFpciwgYW5kIHRoZSBwb2xpY3kgYXV0b21hdGljYWxseSBrbm93cyB0aGUgY29ycmVjdCBzdW0gYW5kIGF2ZXJhZ2Ugc3RhdGlzdGljcyB0byB1c2UgZm9yIHRoZSBsb2FkIG1ldHJpYyBhbmQgdGhlIHNjYWxpbmcgbWV0cmljLlxuICAgICAqXG4gICAgICogRXhhbXBsZVxuICAgICAqXG4gICAgICogLSBZb3UgY3JlYXRlIGEgcHJlZGljdGl2ZSBzY2FsaW5nIHBvbGljeSBhbmQgc3BlY2lmeSBgQUxCUmVxdWVzdENvdW50YCBhcyB0aGUgdmFsdWUgZm9yIHRoZSBtZXRyaWMgcGFpciBhbmQgYDEwMDAuMGAgYXMgdGhlIHRhcmdldCB2YWx1ZS4gRm9yIHRoaXMgdHlwZSBvZiBtZXRyaWMsIHlvdSBtdXN0IHByb3ZpZGUgdGhlIG1ldHJpYyBkaW1lbnNpb24gZm9yIHRoZSBjb3JyZXNwb25kaW5nIHRhcmdldCBncm91cCwgc28geW91IGFsc28gcHJvdmlkZSBhIHJlc291cmNlIGxhYmVsIGZvciB0aGUgQXBwbGljYXRpb24gTG9hZCBCYWxhbmNlciB0YXJnZXQgZ3JvdXAgdGhhdCBpcyBhdHRhY2hlZCB0byB5b3VyIEF1dG8gU2NhbGluZyBncm91cC5cbiAgICAgKiAtIFRoZSBudW1iZXIgb2YgcmVxdWVzdHMgdGhlIHRhcmdldCBncm91cCByZWNlaXZlcyBwZXIgbWludXRlIHByb3ZpZGVzIHRoZSBsb2FkIG1ldHJpYywgYW5kIHRoZSByZXF1ZXN0IGNvdW50IGF2ZXJhZ2VkIGJldHdlZW4gdGhlIG1lbWJlcnMgb2YgdGhlIHRhcmdldCBncm91cCBwcm92aWRlcyB0aGUgc2NhbGluZyBtZXRyaWMuIEluIENsb3VkV2F0Y2gsIHRoaXMgcmVmZXJzIHRvIHRoZSBgUmVxdWVzdENvdW50YCBhbmQgYFJlcXVlc3RDb3VudFBlclRhcmdldGAgbWV0cmljcywgcmVzcGVjdGl2ZWx5LlxuICAgICAqIC0gRm9yIG9wdGltYWwgdXNlIG9mIHByZWRpY3RpdmUgc2NhbGluZywgeW91IGFkaGVyZSB0byB0aGUgYmVzdCBwcmFjdGljZSBvZiB1c2luZyBhIGR5bmFtaWMgc2NhbGluZyBwb2xpY3kgdG8gYXV0b21hdGljYWxseSBzY2FsZSBiZXR3ZWVuIHRoZSBtaW5pbXVtIGNhcGFjaXR5IGFuZCBtYXhpbXVtIGNhcGFjaXR5IGluIHJlc3BvbnNlIHRvIHJlYWwtdGltZSBjaGFuZ2VzIGluIHJlc291cmNlIHV0aWxpemF0aW9uLlxuICAgICAqIC0gQW1hem9uIEVDMiBBdXRvIFNjYWxpbmcgY29uc3VtZXMgZGF0YSBwb2ludHMgZm9yIHRoZSBsb2FkIG1ldHJpYyBvdmVyIHRoZSBsYXN0IDE0IGRheXMgYW5kIGNyZWF0ZXMgYW4gaG91cmx5IGxvYWQgZm9yZWNhc3QgZm9yIHByZWRpY3RpdmUgc2NhbGluZy4gKEEgbWluaW11bSBvZiAyNCBob3VycyBvZiBkYXRhIGlzIHJlcXVpcmVkLilcbiAgICAgKiAtIEFmdGVyIGNyZWF0aW5nIHRoZSBsb2FkIGZvcmVjYXN0LCBBbWF6b24gRUMyIEF1dG8gU2NhbGluZyBkZXRlcm1pbmVzIHdoZW4gdG8gcmVkdWNlIG9yIGluY3JlYXNlIHRoZSBjYXBhY2l0eSBvZiB5b3VyIEF1dG8gU2NhbGluZyBncm91cCBpbiBlYWNoIGhvdXIgb2YgdGhlIGZvcmVjYXN0IHBlcmlvZCBzbyB0aGF0IHRoZSBhdmVyYWdlIG51bWJlciBvZiByZXF1ZXN0cyByZWNlaXZlZCBieSBlYWNoIGluc3RhbmNlIGlzIGFzIGNsb3NlIHRvIDEwMDAgcmVxdWVzdHMgcGVyIG1pbnV0ZSBhcyBwb3NzaWJsZSBhdCBhbGwgdGltZXMuXG4gICAgICpcbiAgICAgKiBGb3IgaW5mb3JtYXRpb24gYWJvdXQgdXNpbmcgY3VzdG9tIG1ldHJpY3Mgd2l0aCBwcmVkaWN0aXZlIHNjYWxpbmcsIHNlZSBbQWR2YW5jZWQgcHJlZGljdGl2ZSBzY2FsaW5nIHBvbGljeSBjb25maWd1cmF0aW9ucyB1c2luZyBjdXN0b20gbWV0cmljc10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2F1dG9zY2FsaW5nL2VjMi91c2VyZ3VpZGUvcHJlZGljdGl2ZS1zY2FsaW5nLWN1c3RvbWl6ZWQtbWV0cmljLXNwZWNpZmljYXRpb24uaHRtbCkgaW4gdGhlICpBbWF6b24gRUMyIEF1dG8gU2NhbGluZyBVc2VyIEd1aWRlKiAuXG4gICAgICpcbiAgICAgKiBAc3RydWN0XG4gICAgICogQHN0YWJpbGl0eSBleHRlcm5hbFxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hdXRvc2NhbGluZy1zY2FsaW5ncG9saWN5LXByZWRpY3RpdmVzY2FsaW5nbWV0cmljc3BlY2lmaWNhdGlvbi5odG1sXG4gICAgICovXG4gICAgZXhwb3J0IGludGVyZmFjZSBQcmVkaWN0aXZlU2NhbGluZ01ldHJpY1NwZWNpZmljYXRpb25Qcm9wZXJ0eSB7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBUaGUgY3VzdG9taXplZCBjYXBhY2l0eSBtZXRyaWMgc3BlY2lmaWNhdGlvbi5cbiAgICAgICAgICpcbiAgICAgICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hdXRvc2NhbGluZy1zY2FsaW5ncG9saWN5LXByZWRpY3RpdmVzY2FsaW5nbWV0cmljc3BlY2lmaWNhdGlvbi5odG1sI2Nmbi1hdXRvc2NhbGluZy1zY2FsaW5ncG9saWN5LXByZWRpY3RpdmVzY2FsaW5nbWV0cmljc3BlY2lmaWNhdGlvbi1jdXN0b21pemVkY2FwYWNpdHltZXRyaWNzcGVjaWZpY2F0aW9uXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBjdXN0b21pemVkQ2FwYWNpdHlNZXRyaWNTcGVjaWZpY2F0aW9uPzogQ2ZuU2NhbGluZ1BvbGljeS5QcmVkaWN0aXZlU2NhbGluZ0N1c3RvbWl6ZWRDYXBhY2l0eU1ldHJpY1Byb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlO1xuICAgICAgICAvKipcbiAgICAgICAgICogVGhlIGN1c3RvbWl6ZWQgbG9hZCBtZXRyaWMgc3BlY2lmaWNhdGlvbi5cbiAgICAgICAgICpcbiAgICAgICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hdXRvc2NhbGluZy1zY2FsaW5ncG9saWN5LXByZWRpY3RpdmVzY2FsaW5nbWV0cmljc3BlY2lmaWNhdGlvbi5odG1sI2Nmbi1hdXRvc2NhbGluZy1zY2FsaW5ncG9saWN5LXByZWRpY3RpdmVzY2FsaW5nbWV0cmljc3BlY2lmaWNhdGlvbi1jdXN0b21pemVkbG9hZG1ldHJpY3NwZWNpZmljYXRpb25cbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IGN1c3RvbWl6ZWRMb2FkTWV0cmljU3BlY2lmaWNhdGlvbj86IENmblNjYWxpbmdQb2xpY3kuUHJlZGljdGl2ZVNjYWxpbmdDdXN0b21pemVkTG9hZE1ldHJpY1Byb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlO1xuICAgICAgICAvKipcbiAgICAgICAgICogVGhlIGN1c3RvbWl6ZWQgc2NhbGluZyBtZXRyaWMgc3BlY2lmaWNhdGlvbi5cbiAgICAgICAgICpcbiAgICAgICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hdXRvc2NhbGluZy1zY2FsaW5ncG9saWN5LXByZWRpY3RpdmVzY2FsaW5nbWV0cmljc3BlY2lmaWNhdGlvbi5odG1sI2Nmbi1hdXRvc2NhbGluZy1zY2FsaW5ncG9saWN5LXByZWRpY3RpdmVzY2FsaW5nbWV0cmljc3BlY2lmaWNhdGlvbi1jdXN0b21pemVkc2NhbGluZ21ldHJpY3NwZWNpZmljYXRpb25cbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IGN1c3RvbWl6ZWRTY2FsaW5nTWV0cmljU3BlY2lmaWNhdGlvbj86IENmblNjYWxpbmdQb2xpY3kuUHJlZGljdGl2ZVNjYWxpbmdDdXN0b21pemVkU2NhbGluZ01ldHJpY1Byb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlO1xuICAgICAgICAvKipcbiAgICAgICAgICogVGhlIHByZWRlZmluZWQgbG9hZCBtZXRyaWMgc3BlY2lmaWNhdGlvbi5cbiAgICAgICAgICpcbiAgICAgICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hdXRvc2NhbGluZy1zY2FsaW5ncG9saWN5LXByZWRpY3RpdmVzY2FsaW5nbWV0cmljc3BlY2lmaWNhdGlvbi5odG1sI2Nmbi1hdXRvc2NhbGluZy1zY2FsaW5ncG9saWN5LXByZWRpY3RpdmVzY2FsaW5nbWV0cmljc3BlY2lmaWNhdGlvbi1wcmVkZWZpbmVkbG9hZG1ldHJpY3NwZWNpZmljYXRpb25cbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IHByZWRlZmluZWRMb2FkTWV0cmljU3BlY2lmaWNhdGlvbj86IENmblNjYWxpbmdQb2xpY3kuUHJlZGljdGl2ZVNjYWxpbmdQcmVkZWZpbmVkTG9hZE1ldHJpY1Byb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlO1xuICAgICAgICAvKipcbiAgICAgICAgICogVGhlIHByZWRlZmluZWQgbWV0cmljIHBhaXIgc3BlY2lmaWNhdGlvbiBmcm9tIHdoaWNoIEFtYXpvbiBFQzIgQXV0byBTY2FsaW5nIGRldGVybWluZXMgdGhlIGFwcHJvcHJpYXRlIHNjYWxpbmcgbWV0cmljIGFuZCBsb2FkIG1ldHJpYyB0byB1c2UuXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXV0b3NjYWxpbmctc2NhbGluZ3BvbGljeS1wcmVkaWN0aXZlc2NhbGluZ21ldHJpY3NwZWNpZmljYXRpb24uaHRtbCNjZm4tYXV0b3NjYWxpbmctc2NhbGluZ3BvbGljeS1wcmVkaWN0aXZlc2NhbGluZ21ldHJpY3NwZWNpZmljYXRpb24tcHJlZGVmaW5lZG1ldHJpY3BhaXJzcGVjaWZpY2F0aW9uXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBwcmVkZWZpbmVkTWV0cmljUGFpclNwZWNpZmljYXRpb24/OiBDZm5TY2FsaW5nUG9saWN5LlByZWRpY3RpdmVTY2FsaW5nUHJlZGVmaW5lZE1ldHJpY1BhaXJQcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZTtcbiAgICAgICAgLyoqXG4gICAgICAgICAqIFRoZSBwcmVkZWZpbmVkIHNjYWxpbmcgbWV0cmljIHNwZWNpZmljYXRpb24uXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXV0b3NjYWxpbmctc2NhbGluZ3BvbGljeS1wcmVkaWN0aXZlc2NhbGluZ21ldHJpY3NwZWNpZmljYXRpb24uaHRtbCNjZm4tYXV0b3NjYWxpbmctc2NhbGluZ3BvbGljeS1wcmVkaWN0aXZlc2NhbGluZ21ldHJpY3NwZWNpZmljYXRpb24tcHJlZGVmaW5lZHNjYWxpbmdtZXRyaWNzcGVjaWZpY2F0aW9uXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBwcmVkZWZpbmVkU2NhbGluZ01ldHJpY1NwZWNpZmljYXRpb24/OiBDZm5TY2FsaW5nUG9saWN5LlByZWRpY3RpdmVTY2FsaW5nUHJlZGVmaW5lZFNjYWxpbmdNZXRyaWNQcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZTtcbiAgICAgICAgLyoqXG4gICAgICAgICAqIFNwZWNpZmllcyB0aGUgdGFyZ2V0IHV0aWxpemF0aW9uLlxuICAgICAgICAgKlxuICAgICAgICAgKiA+IFNvbWUgbWV0cmljcyBhcmUgYmFzZWQgb24gYSBjb3VudCBpbnN0ZWFkIG9mIGEgcGVyY2VudGFnZSwgc3VjaCBhcyB0aGUgcmVxdWVzdCBjb3VudCBmb3IgYW4gQXBwbGljYXRpb24gTG9hZCBCYWxhbmNlciBvciB0aGUgbnVtYmVyIG9mIG1lc3NhZ2VzIGluIGFuIFNRUyBxdWV1ZS4gSWYgdGhlIHNjYWxpbmcgcG9saWN5IHNwZWNpZmllcyBvbmUgb2YgdGhlc2UgbWV0cmljcywgc3BlY2lmeSB0aGUgdGFyZ2V0IHV0aWxpemF0aW9uIGFzIHRoZSBvcHRpbWFsIGF2ZXJhZ2UgcmVxdWVzdCBvciBtZXNzYWdlIGNvdW50IHBlciBpbnN0YW5jZSBkdXJpbmcgYW55IG9uZS1taW51dGUgaW50ZXJ2YWwuXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXV0b3NjYWxpbmctc2NhbGluZ3BvbGljeS1wcmVkaWN0aXZlc2NhbGluZ21ldHJpY3NwZWNpZmljYXRpb24uaHRtbCNjZm4tYXV0b3NjYWxpbmctc2NhbGluZ3BvbGljeS1wcmVkaWN0aXZlc2NhbGluZ21ldHJpY3NwZWNpZmljYXRpb24tdGFyZ2V0dmFsdWVcbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IHRhcmdldFZhbHVlOiBudW1iZXI7XG4gICAgfVxufVxuXG4vKipcbiAqIERldGVybWluZSB3aGV0aGVyIHRoZSBnaXZlbiBwcm9wZXJ0aWVzIG1hdGNoIHRob3NlIG9mIGEgYFByZWRpY3RpdmVTY2FsaW5nTWV0cmljU3BlY2lmaWNhdGlvblByb3BlcnR5YFxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBQcmVkaWN0aXZlU2NhbGluZ01ldHJpY1NwZWNpZmljYXRpb25Qcm9wZXJ0eWBcbiAqXG4gKiBAcmV0dXJucyB0aGUgcmVzdWx0IG9mIHRoZSB2YWxpZGF0aW9uLlxuICovXG5mdW5jdGlvbiBDZm5TY2FsaW5nUG9saWN5X1ByZWRpY3RpdmVTY2FsaW5nTWV0cmljU3BlY2lmaWNhdGlvblByb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXM6IGFueSk6IGNkay5WYWxpZGF0aW9uUmVzdWx0IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBjZGsuVkFMSURBVElPTl9TVUNDRVNTOyB9XG4gICAgY29uc3QgZXJyb3JzID0gbmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0cygpO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgZXJyb3JzLmNvbGxlY3QobmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0KCdFeHBlY3RlZCBhbiBvYmplY3QsIGJ1dCByZWNlaXZlZDogJyArIEpTT04uc3RyaW5naWZ5KHByb3BlcnRpZXMpKSk7XG4gICAgfVxuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignY3VzdG9taXplZENhcGFjaXR5TWV0cmljU3BlY2lmaWNhdGlvbicsIENmblNjYWxpbmdQb2xpY3lfUHJlZGljdGl2ZVNjYWxpbmdDdXN0b21pemVkQ2FwYWNpdHlNZXRyaWNQcm9wZXJ0eVZhbGlkYXRvcikocHJvcGVydGllcy5jdXN0b21pemVkQ2FwYWNpdHlNZXRyaWNTcGVjaWZpY2F0aW9uKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdjdXN0b21pemVkTG9hZE1ldHJpY1NwZWNpZmljYXRpb24nLCBDZm5TY2FsaW5nUG9saWN5X1ByZWRpY3RpdmVTY2FsaW5nQ3VzdG9taXplZExvYWRNZXRyaWNQcm9wZXJ0eVZhbGlkYXRvcikocHJvcGVydGllcy5jdXN0b21pemVkTG9hZE1ldHJpY1NwZWNpZmljYXRpb24pKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2N1c3RvbWl6ZWRTY2FsaW5nTWV0cmljU3BlY2lmaWNhdGlvbicsIENmblNjYWxpbmdQb2xpY3lfUHJlZGljdGl2ZVNjYWxpbmdDdXN0b21pemVkU2NhbGluZ01ldHJpY1Byb3BlcnR5VmFsaWRhdG9yKShwcm9wZXJ0aWVzLmN1c3RvbWl6ZWRTY2FsaW5nTWV0cmljU3BlY2lmaWNhdGlvbikpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigncHJlZGVmaW5lZExvYWRNZXRyaWNTcGVjaWZpY2F0aW9uJywgQ2ZuU2NhbGluZ1BvbGljeV9QcmVkaWN0aXZlU2NhbGluZ1ByZWRlZmluZWRMb2FkTWV0cmljUHJvcGVydHlWYWxpZGF0b3IpKHByb3BlcnRpZXMucHJlZGVmaW5lZExvYWRNZXRyaWNTcGVjaWZpY2F0aW9uKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdwcmVkZWZpbmVkTWV0cmljUGFpclNwZWNpZmljYXRpb24nLCBDZm5TY2FsaW5nUG9saWN5X1ByZWRpY3RpdmVTY2FsaW5nUHJlZGVmaW5lZE1ldHJpY1BhaXJQcm9wZXJ0eVZhbGlkYXRvcikocHJvcGVydGllcy5wcmVkZWZpbmVkTWV0cmljUGFpclNwZWNpZmljYXRpb24pKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3ByZWRlZmluZWRTY2FsaW5nTWV0cmljU3BlY2lmaWNhdGlvbicsIENmblNjYWxpbmdQb2xpY3lfUHJlZGljdGl2ZVNjYWxpbmdQcmVkZWZpbmVkU2NhbGluZ01ldHJpY1Byb3BlcnR5VmFsaWRhdG9yKShwcm9wZXJ0aWVzLnByZWRlZmluZWRTY2FsaW5nTWV0cmljU3BlY2lmaWNhdGlvbikpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigndGFyZ2V0VmFsdWUnLCBjZGsucmVxdWlyZWRWYWxpZGF0b3IpKHByb3BlcnRpZXMudGFyZ2V0VmFsdWUpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3RhcmdldFZhbHVlJywgY2RrLnZhbGlkYXRlTnVtYmVyKShwcm9wZXJ0aWVzLnRhcmdldFZhbHVlKSk7XG4gICAgcmV0dXJuIGVycm9ycy53cmFwKCdzdXBwbGllZCBwcm9wZXJ0aWVzIG5vdCBjb3JyZWN0IGZvciBcIlByZWRpY3RpdmVTY2FsaW5nTWV0cmljU3BlY2lmaWNhdGlvblByb3BlcnR5XCInKTtcbn1cblxuLyoqXG4gKiBSZW5kZXJzIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpBdXRvU2NhbGluZzo6U2NhbGluZ1BvbGljeS5QcmVkaWN0aXZlU2NhbGluZ01ldHJpY1NwZWNpZmljYXRpb25gIHJlc291cmNlXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYFByZWRpY3RpdmVTY2FsaW5nTWV0cmljU3BlY2lmaWNhdGlvblByb3BlcnR5YFxuICpcbiAqIEByZXR1cm5zIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpBdXRvU2NhbGluZzo6U2NhbGluZ1BvbGljeS5QcmVkaWN0aXZlU2NhbGluZ01ldHJpY1NwZWNpZmljYXRpb25gIHJlc291cmNlLlxuICovXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gY2ZuU2NhbGluZ1BvbGljeVByZWRpY3RpdmVTY2FsaW5nTWV0cmljU3BlY2lmaWNhdGlvblByb3BlcnR5VG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBhbnkge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIHByb3BlcnRpZXM7IH1cbiAgICBDZm5TY2FsaW5nUG9saWN5X1ByZWRpY3RpdmVTY2FsaW5nTWV0cmljU3BlY2lmaWNhdGlvblByb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXMpLmFzc2VydFN1Y2Nlc3MoKTtcbiAgICByZXR1cm4ge1xuICAgICAgICBDdXN0b21pemVkQ2FwYWNpdHlNZXRyaWNTcGVjaWZpY2F0aW9uOiBjZm5TY2FsaW5nUG9saWN5UHJlZGljdGl2ZVNjYWxpbmdDdXN0b21pemVkQ2FwYWNpdHlNZXRyaWNQcm9wZXJ0eVRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5jdXN0b21pemVkQ2FwYWNpdHlNZXRyaWNTcGVjaWZpY2F0aW9uKSxcbiAgICAgICAgQ3VzdG9taXplZExvYWRNZXRyaWNTcGVjaWZpY2F0aW9uOiBjZm5TY2FsaW5nUG9saWN5UHJlZGljdGl2ZVNjYWxpbmdDdXN0b21pemVkTG9hZE1ldHJpY1Byb3BlcnR5VG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLmN1c3RvbWl6ZWRMb2FkTWV0cmljU3BlY2lmaWNhdGlvbiksXG4gICAgICAgIEN1c3RvbWl6ZWRTY2FsaW5nTWV0cmljU3BlY2lmaWNhdGlvbjogY2ZuU2NhbGluZ1BvbGljeVByZWRpY3RpdmVTY2FsaW5nQ3VzdG9taXplZFNjYWxpbmdNZXRyaWNQcm9wZXJ0eVRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5jdXN0b21pemVkU2NhbGluZ01ldHJpY1NwZWNpZmljYXRpb24pLFxuICAgICAgICBQcmVkZWZpbmVkTG9hZE1ldHJpY1NwZWNpZmljYXRpb246IGNmblNjYWxpbmdQb2xpY3lQcmVkaWN0aXZlU2NhbGluZ1ByZWRlZmluZWRMb2FkTWV0cmljUHJvcGVydHlUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMucHJlZGVmaW5lZExvYWRNZXRyaWNTcGVjaWZpY2F0aW9uKSxcbiAgICAgICAgUHJlZGVmaW5lZE1ldHJpY1BhaXJTcGVjaWZpY2F0aW9uOiBjZm5TY2FsaW5nUG9saWN5UHJlZGljdGl2ZVNjYWxpbmdQcmVkZWZpbmVkTWV0cmljUGFpclByb3BlcnR5VG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLnByZWRlZmluZWRNZXRyaWNQYWlyU3BlY2lmaWNhdGlvbiksXG4gICAgICAgIFByZWRlZmluZWRTY2FsaW5nTWV0cmljU3BlY2lmaWNhdGlvbjogY2ZuU2NhbGluZ1BvbGljeVByZWRpY3RpdmVTY2FsaW5nUHJlZGVmaW5lZFNjYWxpbmdNZXRyaWNQcm9wZXJ0eVRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5wcmVkZWZpbmVkU2NhbGluZ01ldHJpY1NwZWNpZmljYXRpb24pLFxuICAgICAgICBUYXJnZXRWYWx1ZTogY2RrLm51bWJlclRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy50YXJnZXRWYWx1ZSksXG4gICAgfTtcbn1cblxuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIENmblNjYWxpbmdQb2xpY3lQcmVkaWN0aXZlU2NhbGluZ01ldHJpY1NwZWNpZmljYXRpb25Qcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0PENmblNjYWxpbmdQb2xpY3kuUHJlZGljdGl2ZVNjYWxpbmdNZXRyaWNTcGVjaWZpY2F0aW9uUHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGU+IHtcbiAgICBpZiAoY2RrLmlzUmVzb2x2YWJsZU9iamVjdChwcm9wZXJ0aWVzKSkge1xuICAgICAgICByZXR1cm4gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQocHJvcGVydGllcyk7XG4gICAgfVxuICAgIHByb3BlcnRpZXMgPSBwcm9wZXJ0aWVzID09IG51bGwgPyB7fSA6IHByb3BlcnRpZXM7XG4gICAgaWYgKHR5cGVvZiBwcm9wZXJ0aWVzICE9PSAnb2JqZWN0Jykge1xuICAgICAgICByZXR1cm4gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQocHJvcGVydGllcyk7XG4gICAgfVxuICAgIGNvbnN0IHJldCA9IG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUHJvcGVydHlPYmplY3Q8Q2ZuU2NhbGluZ1BvbGljeS5QcmVkaWN0aXZlU2NhbGluZ01ldHJpY1NwZWNpZmljYXRpb25Qcm9wZXJ0eT4oKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2N1c3RvbWl6ZWRDYXBhY2l0eU1ldHJpY1NwZWNpZmljYXRpb24nLCAnQ3VzdG9taXplZENhcGFjaXR5TWV0cmljU3BlY2lmaWNhdGlvbicsIHByb3BlcnRpZXMuQ3VzdG9taXplZENhcGFjaXR5TWV0cmljU3BlY2lmaWNhdGlvbiAhPSBudWxsID8gQ2ZuU2NhbGluZ1BvbGljeVByZWRpY3RpdmVTY2FsaW5nQ3VzdG9taXplZENhcGFjaXR5TWV0cmljUHJvcGVydHlGcm9tQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5DdXN0b21pemVkQ2FwYWNpdHlNZXRyaWNTcGVjaWZpY2F0aW9uKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdjdXN0b21pemVkTG9hZE1ldHJpY1NwZWNpZmljYXRpb24nLCAnQ3VzdG9taXplZExvYWRNZXRyaWNTcGVjaWZpY2F0aW9uJywgcHJvcGVydGllcy5DdXN0b21pemVkTG9hZE1ldHJpY1NwZWNpZmljYXRpb24gIT0gbnVsbCA/IENmblNjYWxpbmdQb2xpY3lQcmVkaWN0aXZlU2NhbGluZ0N1c3RvbWl6ZWRMb2FkTWV0cmljUHJvcGVydHlGcm9tQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5DdXN0b21pemVkTG9hZE1ldHJpY1NwZWNpZmljYXRpb24pIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2N1c3RvbWl6ZWRTY2FsaW5nTWV0cmljU3BlY2lmaWNhdGlvbicsICdDdXN0b21pemVkU2NhbGluZ01ldHJpY1NwZWNpZmljYXRpb24nLCBwcm9wZXJ0aWVzLkN1c3RvbWl6ZWRTY2FsaW5nTWV0cmljU3BlY2lmaWNhdGlvbiAhPSBudWxsID8gQ2ZuU2NhbGluZ1BvbGljeVByZWRpY3RpdmVTY2FsaW5nQ3VzdG9taXplZFNjYWxpbmdNZXRyaWNQcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLkN1c3RvbWl6ZWRTY2FsaW5nTWV0cmljU3BlY2lmaWNhdGlvbikgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgncHJlZGVmaW5lZExvYWRNZXRyaWNTcGVjaWZpY2F0aW9uJywgJ1ByZWRlZmluZWRMb2FkTWV0cmljU3BlY2lmaWNhdGlvbicsIHByb3BlcnRpZXMuUHJlZGVmaW5lZExvYWRNZXRyaWNTcGVjaWZpY2F0aW9uICE9IG51bGwgPyBDZm5TY2FsaW5nUG9saWN5UHJlZGljdGl2ZVNjYWxpbmdQcmVkZWZpbmVkTG9hZE1ldHJpY1Byb3BlcnR5RnJvbUNsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuUHJlZGVmaW5lZExvYWRNZXRyaWNTcGVjaWZpY2F0aW9uKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdwcmVkZWZpbmVkTWV0cmljUGFpclNwZWNpZmljYXRpb24nLCAnUHJlZGVmaW5lZE1ldHJpY1BhaXJTcGVjaWZpY2F0aW9uJywgcHJvcGVydGllcy5QcmVkZWZpbmVkTWV0cmljUGFpclNwZWNpZmljYXRpb24gIT0gbnVsbCA/IENmblNjYWxpbmdQb2xpY3lQcmVkaWN0aXZlU2NhbGluZ1ByZWRlZmluZWRNZXRyaWNQYWlyUHJvcGVydHlGcm9tQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5QcmVkZWZpbmVkTWV0cmljUGFpclNwZWNpZmljYXRpb24pIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ3ByZWRlZmluZWRTY2FsaW5nTWV0cmljU3BlY2lmaWNhdGlvbicsICdQcmVkZWZpbmVkU2NhbGluZ01ldHJpY1NwZWNpZmljYXRpb24nLCBwcm9wZXJ0aWVzLlByZWRlZmluZWRTY2FsaW5nTWV0cmljU3BlY2lmaWNhdGlvbiAhPSBudWxsID8gQ2ZuU2NhbGluZ1BvbGljeVByZWRpY3RpdmVTY2FsaW5nUHJlZGVmaW5lZFNjYWxpbmdNZXRyaWNQcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLlByZWRlZmluZWRTY2FsaW5nTWV0cmljU3BlY2lmaWNhdGlvbikgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgndGFyZ2V0VmFsdWUnLCAnVGFyZ2V0VmFsdWUnLCBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldE51bWJlcihwcm9wZXJ0aWVzLlRhcmdldFZhbHVlKSk7XG4gICAgcmV0LmFkZFVucmVjb2duaXplZFByb3BlcnRpZXNBc0V4dHJhKHByb3BlcnRpZXMpO1xuICAgIHJldHVybiByZXQ7XG59XG5cbmV4cG9ydCBuYW1lc3BhY2UgQ2ZuU2NhbGluZ1BvbGljeSB7XG4gICAgLyoqXG4gICAgICogQ29udGFpbnMgbG9hZCBtZXRyaWMgaW5mb3JtYXRpb24gZm9yIHRoZSBgUHJlZGVmaW5lZExvYWRNZXRyaWNTcGVjaWZpY2F0aW9uYCBwcm9wZXJ0eSBvZiB0aGUgW0FXUzo6QXV0b1NjYWxpbmc6OlNjYWxpbmdQb2xpY3kgUHJlZGljdGl2ZVNjYWxpbmdNZXRyaWNTcGVjaWZpY2F0aW9uXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hdXRvc2NhbGluZy1zY2FsaW5ncG9saWN5LXByZWRpY3RpdmVzY2FsaW5nbWV0cmljc3BlY2lmaWNhdGlvbi5odG1sKSBwcm9wZXJ0eSB0eXBlLlxuICAgICAqXG4gICAgICogPiBEb2VzIG5vdCBhcHBseSB0byBwb2xpY2llcyB0aGF0IHVzZSBhICptZXRyaWMgcGFpciogZm9yIHRoZSBtZXRyaWMgc3BlY2lmaWNhdGlvbi5cbiAgICAgKlxuICAgICAqIEBzdHJ1Y3RcbiAgICAgKiBAc3RhYmlsaXR5IGV4dGVybmFsXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWF1dG9zY2FsaW5nLXNjYWxpbmdwb2xpY3ktcHJlZGljdGl2ZXNjYWxpbmdwcmVkZWZpbmVkbG9hZG1ldHJpYy5odG1sXG4gICAgICovXG4gICAgZXhwb3J0IGludGVyZmFjZSBQcmVkaWN0aXZlU2NhbGluZ1ByZWRlZmluZWRMb2FkTWV0cmljUHJvcGVydHkge1xuICAgICAgICAvKipcbiAgICAgICAgICogVGhlIG1ldHJpYyB0eXBlLlxuICAgICAgICAgKlxuICAgICAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWF1dG9zY2FsaW5nLXNjYWxpbmdwb2xpY3ktcHJlZGljdGl2ZXNjYWxpbmdwcmVkZWZpbmVkbG9hZG1ldHJpYy5odG1sI2Nmbi1hdXRvc2NhbGluZy1zY2FsaW5ncG9saWN5LXByZWRpY3RpdmVzY2FsaW5ncHJlZGVmaW5lZGxvYWRtZXRyaWMtcHJlZGVmaW5lZG1ldHJpY3R5cGVcbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IHByZWRlZmluZWRNZXRyaWNUeXBlOiBzdHJpbmc7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBBIGxhYmVsIHRoYXQgdW5pcXVlbHkgaWRlbnRpZmllcyBhIHNwZWNpZmljIEFwcGxpY2F0aW9uIExvYWQgQmFsYW5jZXIgdGFyZ2V0IGdyb3VwIGZyb20gd2hpY2ggdG8gZGV0ZXJtaW5lIHRoZSByZXF1ZXN0IGNvdW50IHNlcnZlZCBieSB5b3VyIEF1dG8gU2NhbGluZyBncm91cC4gWW91IGNhbid0IHNwZWNpZnkgYSByZXNvdXJjZSBsYWJlbCB1bmxlc3MgdGhlIHRhcmdldCBncm91cCBpcyBhdHRhY2hlZCB0byB0aGUgQXV0byBTY2FsaW5nIGdyb3VwLlxuICAgICAgICAgKlxuICAgICAgICAgKiBZb3UgY3JlYXRlIHRoZSByZXNvdXJjZSBsYWJlbCBieSBhcHBlbmRpbmcgdGhlIGZpbmFsIHBvcnRpb24gb2YgdGhlIGxvYWQgYmFsYW5jZXIgQVJOIGFuZCB0aGUgZmluYWwgcG9ydGlvbiBvZiB0aGUgdGFyZ2V0IGdyb3VwIEFSTiBpbnRvIGEgc2luZ2xlIHZhbHVlLCBzZXBhcmF0ZWQgYnkgYSBmb3J3YXJkIHNsYXNoICgvKS4gVGhlIGZvcm1hdCBvZiB0aGUgcmVzb3VyY2UgbGFiZWwgaXM6XG4gICAgICAgICAqXG4gICAgICAgICAqIGBhcHAvbXktYWxiLzc3OGQ0MTIzMWIxNDFhMGYvdGFyZ2V0Z3JvdXAvbXktYWxiLXRhcmdldC1ncm91cC85NDNmMDE3ZjEwMGJlY2ZmYCAuXG4gICAgICAgICAqXG4gICAgICAgICAqIFdoZXJlOlxuICAgICAgICAgKlxuICAgICAgICAgKiAtIGFwcC88bG9hZC1iYWxhbmNlci1uYW1lPi88bG9hZC1iYWxhbmNlci1pZD4gaXMgdGhlIGZpbmFsIHBvcnRpb24gb2YgdGhlIGxvYWQgYmFsYW5jZXIgQVJOXG4gICAgICAgICAqIC0gdGFyZ2V0Z3JvdXAvPHRhcmdldC1ncm91cC1uYW1lPi88dGFyZ2V0LWdyb3VwLWlkPiBpcyB0aGUgZmluYWwgcG9ydGlvbiBvZiB0aGUgdGFyZ2V0IGdyb3VwIEFSTi5cbiAgICAgICAgICpcbiAgICAgICAgICogVG8gZmluZCB0aGUgQVJOIGZvciBhbiBBcHBsaWNhdGlvbiBMb2FkIEJhbGFuY2VyLCB1c2UgdGhlIFtEZXNjcmliZUxvYWRCYWxhbmNlcnNdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9lbGFzdGljbG9hZGJhbGFuY2luZy9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9EZXNjcmliZUxvYWRCYWxhbmNlcnMuaHRtbCkgQVBJIG9wZXJhdGlvbi4gVG8gZmluZCB0aGUgQVJOIGZvciB0aGUgdGFyZ2V0IGdyb3VwLCB1c2UgdGhlIFtEZXNjcmliZVRhcmdldEdyb3Vwc10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2VsYXN0aWNsb2FkYmFsYW5jaW5nL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0Rlc2NyaWJlVGFyZ2V0R3JvdXBzLmh0bWwpIEFQSSBvcGVyYXRpb24uXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXV0b3NjYWxpbmctc2NhbGluZ3BvbGljeS1wcmVkaWN0aXZlc2NhbGluZ3ByZWRlZmluZWRsb2FkbWV0cmljLmh0bWwjY2ZuLWF1dG9zY2FsaW5nLXNjYWxpbmdwb2xpY3ktcHJlZGljdGl2ZXNjYWxpbmdwcmVkZWZpbmVkbG9hZG1ldHJpYy1yZXNvdXJjZWxhYmVsXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSByZXNvdXJjZUxhYmVsPzogc3RyaW5nO1xuICAgIH1cbn1cblxuLyoqXG4gKiBEZXRlcm1pbmUgd2hldGhlciB0aGUgZ2l2ZW4gcHJvcGVydGllcyBtYXRjaCB0aG9zZSBvZiBhIGBQcmVkaWN0aXZlU2NhbGluZ1ByZWRlZmluZWRMb2FkTWV0cmljUHJvcGVydHlgXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYFByZWRpY3RpdmVTY2FsaW5nUHJlZGVmaW5lZExvYWRNZXRyaWNQcm9wZXJ0eWBcbiAqXG4gKiBAcmV0dXJucyB0aGUgcmVzdWx0IG9mIHRoZSB2YWxpZGF0aW9uLlxuICovXG5mdW5jdGlvbiBDZm5TY2FsaW5nUG9saWN5X1ByZWRpY3RpdmVTY2FsaW5nUHJlZGVmaW5lZExvYWRNZXRyaWNQcm9wZXJ0eVZhbGlkYXRvcihwcm9wZXJ0aWVzOiBhbnkpOiBjZGsuVmFsaWRhdGlvblJlc3VsdCB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gY2RrLlZBTElEQVRJT05fU1VDQ0VTUzsgfVxuICAgIGNvbnN0IGVycm9ycyA9IG5ldyBjZGsuVmFsaWRhdGlvblJlc3VsdHMoKTtcbiAgICBpZiAodHlwZW9mIHByb3BlcnRpZXMgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIGVycm9ycy5jb2xsZWN0KG5ldyBjZGsuVmFsaWRhdGlvblJlc3VsdCgnRXhwZWN0ZWQgYW4gb2JqZWN0LCBidXQgcmVjZWl2ZWQ6ICcgKyBKU09OLnN0cmluZ2lmeShwcm9wZXJ0aWVzKSkpO1xuICAgIH1cbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3ByZWRlZmluZWRNZXRyaWNUeXBlJywgY2RrLnJlcXVpcmVkVmFsaWRhdG9yKShwcm9wZXJ0aWVzLnByZWRlZmluZWRNZXRyaWNUeXBlKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdwcmVkZWZpbmVkTWV0cmljVHlwZScsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5wcmVkZWZpbmVkTWV0cmljVHlwZSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigncmVzb3VyY2VMYWJlbCcsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5yZXNvdXJjZUxhYmVsKSk7XG4gICAgcmV0dXJuIGVycm9ycy53cmFwKCdzdXBwbGllZCBwcm9wZXJ0aWVzIG5vdCBjb3JyZWN0IGZvciBcIlByZWRpY3RpdmVTY2FsaW5nUHJlZGVmaW5lZExvYWRNZXRyaWNQcm9wZXJ0eVwiJyk7XG59XG5cbi8qKlxuICogUmVuZGVycyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6QXV0b1NjYWxpbmc6OlNjYWxpbmdQb2xpY3kuUHJlZGljdGl2ZVNjYWxpbmdQcmVkZWZpbmVkTG9hZE1ldHJpY2AgcmVzb3VyY2VcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgUHJlZGljdGl2ZVNjYWxpbmdQcmVkZWZpbmVkTG9hZE1ldHJpY1Byb3BlcnR5YFxuICpcbiAqIEByZXR1cm5zIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpBdXRvU2NhbGluZzo6U2NhbGluZ1BvbGljeS5QcmVkaWN0aXZlU2NhbGluZ1ByZWRlZmluZWRMb2FkTWV0cmljYCByZXNvdXJjZS5cbiAqL1xuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIGNmblNjYWxpbmdQb2xpY3lQcmVkaWN0aXZlU2NhbGluZ1ByZWRlZmluZWRMb2FkTWV0cmljUHJvcGVydHlUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGFueSB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gcHJvcGVydGllczsgfVxuICAgIENmblNjYWxpbmdQb2xpY3lfUHJlZGljdGl2ZVNjYWxpbmdQcmVkZWZpbmVkTG9hZE1ldHJpY1Byb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXMpLmFzc2VydFN1Y2Nlc3MoKTtcbiAgICByZXR1cm4ge1xuICAgICAgICBQcmVkZWZpbmVkTWV0cmljVHlwZTogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5wcmVkZWZpbmVkTWV0cmljVHlwZSksXG4gICAgICAgIFJlc291cmNlTGFiZWw6IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMucmVzb3VyY2VMYWJlbCksXG4gICAgfTtcbn1cblxuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIENmblNjYWxpbmdQb2xpY3lQcmVkaWN0aXZlU2NhbGluZ1ByZWRlZmluZWRMb2FkTWV0cmljUHJvcGVydHlGcm9tQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdDxDZm5TY2FsaW5nUG9saWN5LlByZWRpY3RpdmVTY2FsaW5nUHJlZGVmaW5lZExvYWRNZXRyaWNQcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZT4ge1xuICAgIGlmIChjZGsuaXNSZXNvbHZhYmxlT2JqZWN0KHByb3BlcnRpZXMpKSB7XG4gICAgICAgIHJldHVybiBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdChwcm9wZXJ0aWVzKTtcbiAgICB9XG4gICAgcHJvcGVydGllcyA9IHByb3BlcnRpZXMgPT0gbnVsbCA/IHt9IDogcHJvcGVydGllcztcbiAgICBpZiAodHlwZW9mIHByb3BlcnRpZXMgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIHJldHVybiBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdChwcm9wZXJ0aWVzKTtcbiAgICB9XG4gICAgY29uc3QgcmV0ID0gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25Qcm9wZXJ0eU9iamVjdDxDZm5TY2FsaW5nUG9saWN5LlByZWRpY3RpdmVTY2FsaW5nUHJlZGVmaW5lZExvYWRNZXRyaWNQcm9wZXJ0eT4oKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ3ByZWRlZmluZWRNZXRyaWNUeXBlJywgJ1ByZWRlZmluZWRNZXRyaWNUeXBlJywgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5QcmVkZWZpbmVkTWV0cmljVHlwZSkpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgncmVzb3VyY2VMYWJlbCcsICdSZXNvdXJjZUxhYmVsJywgcHJvcGVydGllcy5SZXNvdXJjZUxhYmVsICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLlJlc291cmNlTGFiZWwpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkVW5yZWNvZ25pemVkUHJvcGVydGllc0FzRXh0cmEocHJvcGVydGllcyk7XG4gICAgcmV0dXJuIHJldDtcbn1cblxuZXhwb3J0IG5hbWVzcGFjZSBDZm5TY2FsaW5nUG9saWN5IHtcbiAgICAvKipcbiAgICAgKiBDb250YWlucyBtZXRyaWMgcGFpciBpbmZvcm1hdGlvbiBmb3IgdGhlIGBQcmVkZWZpbmVkTWV0cmljUGFpclNwZWNpZmljYXRpb25gIHByb3BlcnR5IG9mIHRoZSBbQVdTOjpBdXRvU2NhbGluZzo6U2NhbGluZ1BvbGljeSBQcmVkaWN0aXZlU2NhbGluZ01ldHJpY1NwZWNpZmljYXRpb25dKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWF1dG9zY2FsaW5nLXNjYWxpbmdwb2xpY3ktcHJlZGljdGl2ZXNjYWxpbmdtZXRyaWNzcGVjaWZpY2F0aW9uLmh0bWwpIHByb3BlcnR5IHR5cGUuXG4gICAgICpcbiAgICAgKiBGb3IgbW9yZSBpbmZvcm1hdGlvbiwgc2VlIFtQcmVkaWN0aXZlIHNjYWxpbmddKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9hdXRvc2NhbGluZy9lYzIvdXNlcmd1aWRlL2VjMi1hdXRvLXNjYWxpbmctcHJlZGljdGl2ZS1zY2FsaW5nLmh0bWwpIGluIHRoZSAqQW1hem9uIEVDMiBBdXRvIFNjYWxpbmcgVXNlciBHdWlkZSogLlxuICAgICAqXG4gICAgICogQHN0cnVjdFxuICAgICAqIEBzdGFiaWxpdHkgZXh0ZXJuYWxcbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXV0b3NjYWxpbmctc2NhbGluZ3BvbGljeS1wcmVkaWN0aXZlc2NhbGluZ3ByZWRlZmluZWRtZXRyaWNwYWlyLmh0bWxcbiAgICAgKi9cbiAgICBleHBvcnQgaW50ZXJmYWNlIFByZWRpY3RpdmVTY2FsaW5nUHJlZGVmaW5lZE1ldHJpY1BhaXJQcm9wZXJ0eSB7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBJbmRpY2F0ZXMgd2hpY2ggbWV0cmljcyB0byB1c2UuIFRoZXJlIGFyZSB0d28gZGlmZmVyZW50IHR5cGVzIG9mIG1ldHJpY3MgZm9yIGVhY2ggbWV0cmljIHR5cGU6IG9uZSBpcyBhIGxvYWQgbWV0cmljIGFuZCBvbmUgaXMgYSBzY2FsaW5nIG1ldHJpYy4gRm9yIGV4YW1wbGUsIGlmIHRoZSBtZXRyaWMgdHlwZSBpcyBgQVNHQ1BVVXRpbGl6YXRpb25gICwgdGhlIEF1dG8gU2NhbGluZyBncm91cCdzIHRvdGFsIENQVSBtZXRyaWMgaXMgdXNlZCBhcyB0aGUgbG9hZCBtZXRyaWMsIGFuZCB0aGUgYXZlcmFnZSBDUFUgbWV0cmljIGlzIHVzZWQgZm9yIHRoZSBzY2FsaW5nIG1ldHJpYy5cbiAgICAgICAgICpcbiAgICAgICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hdXRvc2NhbGluZy1zY2FsaW5ncG9saWN5LXByZWRpY3RpdmVzY2FsaW5ncHJlZGVmaW5lZG1ldHJpY3BhaXIuaHRtbCNjZm4tYXV0b3NjYWxpbmctc2NhbGluZ3BvbGljeS1wcmVkaWN0aXZlc2NhbGluZ3ByZWRlZmluZWRtZXRyaWNwYWlyLXByZWRlZmluZWRtZXRyaWN0eXBlXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBwcmVkZWZpbmVkTWV0cmljVHlwZTogc3RyaW5nO1xuICAgICAgICAvKipcbiAgICAgICAgICogQSBsYWJlbCB0aGF0IHVuaXF1ZWx5IGlkZW50aWZpZXMgYSBzcGVjaWZpYyBBcHBsaWNhdGlvbiBMb2FkIEJhbGFuY2VyIHRhcmdldCBncm91cCBmcm9tIHdoaWNoIHRvIGRldGVybWluZSB0aGUgdG90YWwgYW5kIGF2ZXJhZ2UgcmVxdWVzdCBjb3VudCBzZXJ2ZWQgYnkgeW91ciBBdXRvIFNjYWxpbmcgZ3JvdXAuIFlvdSBjYW4ndCBzcGVjaWZ5IGEgcmVzb3VyY2UgbGFiZWwgdW5sZXNzIHRoZSB0YXJnZXQgZ3JvdXAgaXMgYXR0YWNoZWQgdG8gdGhlIEF1dG8gU2NhbGluZyBncm91cC5cbiAgICAgICAgICpcbiAgICAgICAgICogWW91IGNyZWF0ZSB0aGUgcmVzb3VyY2UgbGFiZWwgYnkgYXBwZW5kaW5nIHRoZSBmaW5hbCBwb3J0aW9uIG9mIHRoZSBsb2FkIGJhbGFuY2VyIEFSTiBhbmQgdGhlIGZpbmFsIHBvcnRpb24gb2YgdGhlIHRhcmdldCBncm91cCBBUk4gaW50byBhIHNpbmdsZSB2YWx1ZSwgc2VwYXJhdGVkIGJ5IGEgZm9yd2FyZCBzbGFzaCAoLykuIFRoZSBmb3JtYXQgb2YgdGhlIHJlc291cmNlIGxhYmVsIGlzOlxuICAgICAgICAgKlxuICAgICAgICAgKiBgYXBwL215LWFsYi83NzhkNDEyMzFiMTQxYTBmL3RhcmdldGdyb3VwL215LWFsYi10YXJnZXQtZ3JvdXAvOTQzZjAxN2YxMDBiZWNmZmAgLlxuICAgICAgICAgKlxuICAgICAgICAgKiBXaGVyZTpcbiAgICAgICAgICpcbiAgICAgICAgICogLSBhcHAvPGxvYWQtYmFsYW5jZXItbmFtZT4vPGxvYWQtYmFsYW5jZXItaWQ+IGlzIHRoZSBmaW5hbCBwb3J0aW9uIG9mIHRoZSBsb2FkIGJhbGFuY2VyIEFSTlxuICAgICAgICAgKiAtIHRhcmdldGdyb3VwLzx0YXJnZXQtZ3JvdXAtbmFtZT4vPHRhcmdldC1ncm91cC1pZD4gaXMgdGhlIGZpbmFsIHBvcnRpb24gb2YgdGhlIHRhcmdldCBncm91cCBBUk4uXG4gICAgICAgICAqXG4gICAgICAgICAqIFRvIGZpbmQgdGhlIEFSTiBmb3IgYW4gQXBwbGljYXRpb24gTG9hZCBCYWxhbmNlciwgdXNlIHRoZSBbRGVzY3JpYmVMb2FkQmFsYW5jZXJzXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZWxhc3RpY2xvYWRiYWxhbmNpbmcvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfRGVzY3JpYmVMb2FkQmFsYW5jZXJzLmh0bWwpIEFQSSBvcGVyYXRpb24uIFRvIGZpbmQgdGhlIEFSTiBmb3IgdGhlIHRhcmdldCBncm91cCwgdXNlIHRoZSBbRGVzY3JpYmVUYXJnZXRHcm91cHNdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9lbGFzdGljbG9hZGJhbGFuY2luZy9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9EZXNjcmliZVRhcmdldEdyb3Vwcy5odG1sKSBBUEkgb3BlcmF0aW9uLlxuICAgICAgICAgKlxuICAgICAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWF1dG9zY2FsaW5nLXNjYWxpbmdwb2xpY3ktcHJlZGljdGl2ZXNjYWxpbmdwcmVkZWZpbmVkbWV0cmljcGFpci5odG1sI2Nmbi1hdXRvc2NhbGluZy1zY2FsaW5ncG9saWN5LXByZWRpY3RpdmVzY2FsaW5ncHJlZGVmaW5lZG1ldHJpY3BhaXItcmVzb3VyY2VsYWJlbFxuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgcmVzb3VyY2VMYWJlbD86IHN0cmluZztcbiAgICB9XG59XG5cbi8qKlxuICogRGV0ZXJtaW5lIHdoZXRoZXIgdGhlIGdpdmVuIHByb3BlcnRpZXMgbWF0Y2ggdGhvc2Ugb2YgYSBgUHJlZGljdGl2ZVNjYWxpbmdQcmVkZWZpbmVkTWV0cmljUGFpclByb3BlcnR5YFxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBQcmVkaWN0aXZlU2NhbGluZ1ByZWRlZmluZWRNZXRyaWNQYWlyUHJvcGVydHlgXG4gKlxuICogQHJldHVybnMgdGhlIHJlc3VsdCBvZiB0aGUgdmFsaWRhdGlvbi5cbiAqL1xuZnVuY3Rpb24gQ2ZuU2NhbGluZ1BvbGljeV9QcmVkaWN0aXZlU2NhbGluZ1ByZWRlZmluZWRNZXRyaWNQYWlyUHJvcGVydHlWYWxpZGF0b3IocHJvcGVydGllczogYW55KTogY2RrLlZhbGlkYXRpb25SZXN1bHQge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIGNkay5WQUxJREFUSU9OX1NVQ0NFU1M7IH1cbiAgICBjb25zdCBlcnJvcnMgPSBuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHRzKCk7XG4gICAgaWYgKHR5cGVvZiBwcm9wZXJ0aWVzICE9PSAnb2JqZWN0Jykge1xuICAgICAgICBlcnJvcnMuY29sbGVjdChuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHQoJ0V4cGVjdGVkIGFuIG9iamVjdCwgYnV0IHJlY2VpdmVkOiAnICsgSlNPTi5zdHJpbmdpZnkocHJvcGVydGllcykpKTtcbiAgICB9XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdwcmVkZWZpbmVkTWV0cmljVHlwZScsIGNkay5yZXF1aXJlZFZhbGlkYXRvcikocHJvcGVydGllcy5wcmVkZWZpbmVkTWV0cmljVHlwZSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigncHJlZGVmaW5lZE1ldHJpY1R5cGUnLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMucHJlZGVmaW5lZE1ldHJpY1R5cGUpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3Jlc291cmNlTGFiZWwnLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMucmVzb3VyY2VMYWJlbCkpO1xuICAgIHJldHVybiBlcnJvcnMud3JhcCgnc3VwcGxpZWQgcHJvcGVydGllcyBub3QgY29ycmVjdCBmb3IgXCJQcmVkaWN0aXZlU2NhbGluZ1ByZWRlZmluZWRNZXRyaWNQYWlyUHJvcGVydHlcIicpO1xufVxuXG4vKipcbiAqIFJlbmRlcnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OkF1dG9TY2FsaW5nOjpTY2FsaW5nUG9saWN5LlByZWRpY3RpdmVTY2FsaW5nUHJlZGVmaW5lZE1ldHJpY1BhaXJgIHJlc291cmNlXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYFByZWRpY3RpdmVTY2FsaW5nUHJlZGVmaW5lZE1ldHJpY1BhaXJQcm9wZXJ0eWBcbiAqXG4gKiBAcmV0dXJucyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6QXV0b1NjYWxpbmc6OlNjYWxpbmdQb2xpY3kuUHJlZGljdGl2ZVNjYWxpbmdQcmVkZWZpbmVkTWV0cmljUGFpcmAgcmVzb3VyY2UuXG4gKi9cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBjZm5TY2FsaW5nUG9saWN5UHJlZGljdGl2ZVNjYWxpbmdQcmVkZWZpbmVkTWV0cmljUGFpclByb3BlcnR5VG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBhbnkge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIHByb3BlcnRpZXM7IH1cbiAgICBDZm5TY2FsaW5nUG9saWN5X1ByZWRpY3RpdmVTY2FsaW5nUHJlZGVmaW5lZE1ldHJpY1BhaXJQcm9wZXJ0eVZhbGlkYXRvcihwcm9wZXJ0aWVzKS5hc3NlcnRTdWNjZXNzKCk7XG4gICAgcmV0dXJuIHtcbiAgICAgICAgUHJlZGVmaW5lZE1ldHJpY1R5cGU6IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMucHJlZGVmaW5lZE1ldHJpY1R5cGUpLFxuICAgICAgICBSZXNvdXJjZUxhYmVsOiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLnJlc291cmNlTGFiZWwpLFxuICAgIH07XG59XG5cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBDZm5TY2FsaW5nUG9saWN5UHJlZGljdGl2ZVNjYWxpbmdQcmVkZWZpbmVkTWV0cmljUGFpclByb3BlcnR5RnJvbUNsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQ8Q2ZuU2NhbGluZ1BvbGljeS5QcmVkaWN0aXZlU2NhbGluZ1ByZWRlZmluZWRNZXRyaWNQYWlyUHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGU+IHtcbiAgICBpZiAoY2RrLmlzUmVzb2x2YWJsZU9iamVjdChwcm9wZXJ0aWVzKSkge1xuICAgICAgICByZXR1cm4gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQocHJvcGVydGllcyk7XG4gICAgfVxuICAgIHByb3BlcnRpZXMgPSBwcm9wZXJ0aWVzID09IG51bGwgPyB7fSA6IHByb3BlcnRpZXM7XG4gICAgaWYgKHR5cGVvZiBwcm9wZXJ0aWVzICE9PSAnb2JqZWN0Jykge1xuICAgICAgICByZXR1cm4gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQocHJvcGVydGllcyk7XG4gICAgfVxuICAgIGNvbnN0IHJldCA9IG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUHJvcGVydHlPYmplY3Q8Q2ZuU2NhbGluZ1BvbGljeS5QcmVkaWN0aXZlU2NhbGluZ1ByZWRlZmluZWRNZXRyaWNQYWlyUHJvcGVydHk+KCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdwcmVkZWZpbmVkTWV0cmljVHlwZScsICdQcmVkZWZpbmVkTWV0cmljVHlwZScsIGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuUHJlZGVmaW5lZE1ldHJpY1R5cGUpKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ3Jlc291cmNlTGFiZWwnLCAnUmVzb3VyY2VMYWJlbCcsIHByb3BlcnRpZXMuUmVzb3VyY2VMYWJlbCAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5SZXNvdXJjZUxhYmVsKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFVucmVjb2duaXplZFByb3BlcnRpZXNBc0V4dHJhKHByb3BlcnRpZXMpO1xuICAgIHJldHVybiByZXQ7XG59XG5cbmV4cG9ydCBuYW1lc3BhY2UgQ2ZuU2NhbGluZ1BvbGljeSB7XG4gICAgLyoqXG4gICAgICogQ29udGFpbnMgc2NhbGluZyBtZXRyaWMgaW5mb3JtYXRpb24gZm9yIHRoZSBgUHJlZGVmaW5lZFNjYWxpbmdNZXRyaWNTcGVjaWZpY2F0aW9uYCBwcm9wZXJ0eSBvZiB0aGUgW0FXUzo6QXV0b1NjYWxpbmc6OlNjYWxpbmdQb2xpY3kgUHJlZGljdGl2ZVNjYWxpbmdNZXRyaWNTcGVjaWZpY2F0aW9uXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hdXRvc2NhbGluZy1zY2FsaW5ncG9saWN5LXByZWRpY3RpdmVzY2FsaW5nbWV0cmljc3BlY2lmaWNhdGlvbi5odG1sKSBwcm9wZXJ0eSB0eXBlLlxuICAgICAqXG4gICAgICogPiBEb2VzIG5vdCBhcHBseSB0byBwb2xpY2llcyB0aGF0IHVzZSBhICptZXRyaWMgcGFpciogZm9yIHRoZSBtZXRyaWMgc3BlY2lmaWNhdGlvbi5cbiAgICAgKlxuICAgICAqIEBzdHJ1Y3RcbiAgICAgKiBAc3RhYmlsaXR5IGV4dGVybmFsXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWF1dG9zY2FsaW5nLXNjYWxpbmdwb2xpY3ktcHJlZGljdGl2ZXNjYWxpbmdwcmVkZWZpbmVkc2NhbGluZ21ldHJpYy5odG1sXG4gICAgICovXG4gICAgZXhwb3J0IGludGVyZmFjZSBQcmVkaWN0aXZlU2NhbGluZ1ByZWRlZmluZWRTY2FsaW5nTWV0cmljUHJvcGVydHkge1xuICAgICAgICAvKipcbiAgICAgICAgICogVGhlIG1ldHJpYyB0eXBlLlxuICAgICAgICAgKlxuICAgICAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWF1dG9zY2FsaW5nLXNjYWxpbmdwb2xpY3ktcHJlZGljdGl2ZXNjYWxpbmdwcmVkZWZpbmVkc2NhbGluZ21ldHJpYy5odG1sI2Nmbi1hdXRvc2NhbGluZy1zY2FsaW5ncG9saWN5LXByZWRpY3RpdmVzY2FsaW5ncHJlZGVmaW5lZHNjYWxpbmdtZXRyaWMtcHJlZGVmaW5lZG1ldHJpY3R5cGVcbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IHByZWRlZmluZWRNZXRyaWNUeXBlOiBzdHJpbmc7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBBIGxhYmVsIHRoYXQgdW5pcXVlbHkgaWRlbnRpZmllcyBhIHNwZWNpZmljIEFwcGxpY2F0aW9uIExvYWQgQmFsYW5jZXIgdGFyZ2V0IGdyb3VwIGZyb20gd2hpY2ggdG8gZGV0ZXJtaW5lIHRoZSBhdmVyYWdlIHJlcXVlc3QgY291bnQgc2VydmVkIGJ5IHlvdXIgQXV0byBTY2FsaW5nIGdyb3VwLiBZb3UgY2FuJ3Qgc3BlY2lmeSBhIHJlc291cmNlIGxhYmVsIHVubGVzcyB0aGUgdGFyZ2V0IGdyb3VwIGlzIGF0dGFjaGVkIHRvIHRoZSBBdXRvIFNjYWxpbmcgZ3JvdXAuXG4gICAgICAgICAqXG4gICAgICAgICAqIFlvdSBjcmVhdGUgdGhlIHJlc291cmNlIGxhYmVsIGJ5IGFwcGVuZGluZyB0aGUgZmluYWwgcG9ydGlvbiBvZiB0aGUgbG9hZCBiYWxhbmNlciBBUk4gYW5kIHRoZSBmaW5hbCBwb3J0aW9uIG9mIHRoZSB0YXJnZXQgZ3JvdXAgQVJOIGludG8gYSBzaW5nbGUgdmFsdWUsIHNlcGFyYXRlZCBieSBhIGZvcndhcmQgc2xhc2ggKC8pLiBUaGUgZm9ybWF0IG9mIHRoZSByZXNvdXJjZSBsYWJlbCBpczpcbiAgICAgICAgICpcbiAgICAgICAgICogYGFwcC9teS1hbGIvNzc4ZDQxMjMxYjE0MWEwZi90YXJnZXRncm91cC9teS1hbGItdGFyZ2V0LWdyb3VwLzk0M2YwMTdmMTAwYmVjZmZgIC5cbiAgICAgICAgICpcbiAgICAgICAgICogV2hlcmU6XG4gICAgICAgICAqXG4gICAgICAgICAqIC0gYXBwLzxsb2FkLWJhbGFuY2VyLW5hbWU+Lzxsb2FkLWJhbGFuY2VyLWlkPiBpcyB0aGUgZmluYWwgcG9ydGlvbiBvZiB0aGUgbG9hZCBiYWxhbmNlciBBUk5cbiAgICAgICAgICogLSB0YXJnZXRncm91cC88dGFyZ2V0LWdyb3VwLW5hbWU+Lzx0YXJnZXQtZ3JvdXAtaWQ+IGlzIHRoZSBmaW5hbCBwb3J0aW9uIG9mIHRoZSB0YXJnZXQgZ3JvdXAgQVJOLlxuICAgICAgICAgKlxuICAgICAgICAgKiBUbyBmaW5kIHRoZSBBUk4gZm9yIGFuIEFwcGxpY2F0aW9uIExvYWQgQmFsYW5jZXIsIHVzZSB0aGUgW0Rlc2NyaWJlTG9hZEJhbGFuY2Vyc10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2VsYXN0aWNsb2FkYmFsYW5jaW5nL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0Rlc2NyaWJlTG9hZEJhbGFuY2Vycy5odG1sKSBBUEkgb3BlcmF0aW9uLiBUbyBmaW5kIHRoZSBBUk4gZm9yIHRoZSB0YXJnZXQgZ3JvdXAsIHVzZSB0aGUgW0Rlc2NyaWJlVGFyZ2V0R3JvdXBzXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZWxhc3RpY2xvYWRiYWxhbmNpbmcvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfRGVzY3JpYmVUYXJnZXRHcm91cHMuaHRtbCkgQVBJIG9wZXJhdGlvbi5cbiAgICAgICAgICpcbiAgICAgICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hdXRvc2NhbGluZy1zY2FsaW5ncG9saWN5LXByZWRpY3RpdmVzY2FsaW5ncHJlZGVmaW5lZHNjYWxpbmdtZXRyaWMuaHRtbCNjZm4tYXV0b3NjYWxpbmctc2NhbGluZ3BvbGljeS1wcmVkaWN0aXZlc2NhbGluZ3ByZWRlZmluZWRzY2FsaW5nbWV0cmljLXJlc291cmNlbGFiZWxcbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IHJlc291cmNlTGFiZWw/OiBzdHJpbmc7XG4gICAgfVxufVxuXG4vKipcbiAqIERldGVybWluZSB3aGV0aGVyIHRoZSBnaXZlbiBwcm9wZXJ0aWVzIG1hdGNoIHRob3NlIG9mIGEgYFByZWRpY3RpdmVTY2FsaW5nUHJlZGVmaW5lZFNjYWxpbmdNZXRyaWNQcm9wZXJ0eWBcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgUHJlZGljdGl2ZVNjYWxpbmdQcmVkZWZpbmVkU2NhbGluZ01ldHJpY1Byb3BlcnR5YFxuICpcbiAqIEByZXR1cm5zIHRoZSByZXN1bHQgb2YgdGhlIHZhbGlkYXRpb24uXG4gKi9cbmZ1bmN0aW9uIENmblNjYWxpbmdQb2xpY3lfUHJlZGljdGl2ZVNjYWxpbmdQcmVkZWZpbmVkU2NhbGluZ01ldHJpY1Byb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXM6IGFueSk6IGNkay5WYWxpZGF0aW9uUmVzdWx0IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBjZGsuVkFMSURBVElPTl9TVUNDRVNTOyB9XG4gICAgY29uc3QgZXJyb3JzID0gbmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0cygpO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgZXJyb3JzLmNvbGxlY3QobmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0KCdFeHBlY3RlZCBhbiBvYmplY3QsIGJ1dCByZWNlaXZlZDogJyArIEpTT04uc3RyaW5naWZ5KHByb3BlcnRpZXMpKSk7XG4gICAgfVxuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigncHJlZGVmaW5lZE1ldHJpY1R5cGUnLCBjZGsucmVxdWlyZWRWYWxpZGF0b3IpKHByb3BlcnRpZXMucHJlZGVmaW5lZE1ldHJpY1R5cGUpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3ByZWRlZmluZWRNZXRyaWNUeXBlJywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLnByZWRlZmluZWRNZXRyaWNUeXBlKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdyZXNvdXJjZUxhYmVsJywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLnJlc291cmNlTGFiZWwpKTtcbiAgICByZXR1cm4gZXJyb3JzLndyYXAoJ3N1cHBsaWVkIHByb3BlcnRpZXMgbm90IGNvcnJlY3QgZm9yIFwiUHJlZGljdGl2ZVNjYWxpbmdQcmVkZWZpbmVkU2NhbGluZ01ldHJpY1Byb3BlcnR5XCInKTtcbn1cblxuLyoqXG4gKiBSZW5kZXJzIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpBdXRvU2NhbGluZzo6U2NhbGluZ1BvbGljeS5QcmVkaWN0aXZlU2NhbGluZ1ByZWRlZmluZWRTY2FsaW5nTWV0cmljYCByZXNvdXJjZVxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBQcmVkaWN0aXZlU2NhbGluZ1ByZWRlZmluZWRTY2FsaW5nTWV0cmljUHJvcGVydHlgXG4gKlxuICogQHJldHVybnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OkF1dG9TY2FsaW5nOjpTY2FsaW5nUG9saWN5LlByZWRpY3RpdmVTY2FsaW5nUHJlZGVmaW5lZFNjYWxpbmdNZXRyaWNgIHJlc291cmNlLlxuICovXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gY2ZuU2NhbGluZ1BvbGljeVByZWRpY3RpdmVTY2FsaW5nUHJlZGVmaW5lZFNjYWxpbmdNZXRyaWNQcm9wZXJ0eVRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogYW55IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBwcm9wZXJ0aWVzOyB9XG4gICAgQ2ZuU2NhbGluZ1BvbGljeV9QcmVkaWN0aXZlU2NhbGluZ1ByZWRlZmluZWRTY2FsaW5nTWV0cmljUHJvcGVydHlWYWxpZGF0b3IocHJvcGVydGllcykuYXNzZXJ0U3VjY2VzcygpO1xuICAgIHJldHVybiB7XG4gICAgICAgIFByZWRlZmluZWRNZXRyaWNUeXBlOiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLnByZWRlZmluZWRNZXRyaWNUeXBlKSxcbiAgICAgICAgUmVzb3VyY2VMYWJlbDogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5yZXNvdXJjZUxhYmVsKSxcbiAgICB9O1xufVxuXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gQ2ZuU2NhbGluZ1BvbGljeVByZWRpY3RpdmVTY2FsaW5nUHJlZGVmaW5lZFNjYWxpbmdNZXRyaWNQcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0PENmblNjYWxpbmdQb2xpY3kuUHJlZGljdGl2ZVNjYWxpbmdQcmVkZWZpbmVkU2NhbGluZ01ldHJpY1Byb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlPiB7XG4gICAgaWYgKGNkay5pc1Jlc29sdmFibGVPYmplY3QocHJvcGVydGllcykpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0KHByb3BlcnRpZXMpO1xuICAgIH1cbiAgICBwcm9wZXJ0aWVzID0gcHJvcGVydGllcyA9PSBudWxsID8ge30gOiBwcm9wZXJ0aWVzO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0KHByb3BlcnRpZXMpO1xuICAgIH1cbiAgICBjb25zdCByZXQgPSBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblByb3BlcnR5T2JqZWN0PENmblNjYWxpbmdQb2xpY3kuUHJlZGljdGl2ZVNjYWxpbmdQcmVkZWZpbmVkU2NhbGluZ01ldHJpY1Byb3BlcnR5PigpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgncHJlZGVmaW5lZE1ldHJpY1R5cGUnLCAnUHJlZGVmaW5lZE1ldHJpY1R5cGUnLCBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLlByZWRlZmluZWRNZXRyaWNUeXBlKSk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdyZXNvdXJjZUxhYmVsJywgJ1Jlc291cmNlTGFiZWwnLCBwcm9wZXJ0aWVzLlJlc291cmNlTGFiZWwgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuUmVzb3VyY2VMYWJlbCkgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRVbnJlY29nbml6ZWRQcm9wZXJ0aWVzQXNFeHRyYShwcm9wZXJ0aWVzKTtcbiAgICByZXR1cm4gcmV0O1xufVxuXG5leHBvcnQgbmFtZXNwYWNlIENmblNjYWxpbmdQb2xpY3kge1xuICAgIC8qKlxuICAgICAqIGBTdGVwQWRqdXN0bWVudGAgc3BlY2lmaWVzIGEgc3RlcCBhZGp1c3RtZW50IGZvciB0aGUgYFN0ZXBBZGp1c3RtZW50c2AgcHJvcGVydHkgb2YgdGhlIFtBV1M6OkF1dG9TY2FsaW5nOjpTY2FsaW5nUG9saWN5XShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hcy1wb2xpY3kuaHRtbCkgcmVzb3VyY2UuXG4gICAgICpcbiAgICAgKiBGb3IgdGhlIGZvbGxvd2luZyBleGFtcGxlcywgc3VwcG9zZSB0aGF0IHlvdSBoYXZlIGFuIGFsYXJtIHdpdGggYSBicmVhY2ggdGhyZXNob2xkIG9mIDUwOlxuICAgICAqXG4gICAgICogLSBUbyB0cmlnZ2VyIGEgc3RlcCBhZGp1c3RtZW50IHdoZW4gdGhlIG1ldHJpYyBpcyBncmVhdGVyIHRoYW4gb3IgZXF1YWwgdG8gNTAgYW5kIGxlc3MgdGhhbiA2MCwgc3BlY2lmeSBhIGxvd2VyIGJvdW5kIG9mIDAgYW5kIGFuIHVwcGVyIGJvdW5kIG9mIDEwLlxuICAgICAqIC0gVG8gdHJpZ2dlciBhIHN0ZXAgYWRqdXN0bWVudCB3aGVuIHRoZSBtZXRyaWMgaXMgZ3JlYXRlciB0aGFuIDQwIGFuZCBsZXNzIHRoYW4gb3IgZXF1YWwgdG8gNTAsIHNwZWNpZnkgYSBsb3dlciBib3VuZCBvZiAtMTAgYW5kIGFuIHVwcGVyIGJvdW5kIG9mIDAuXG4gICAgICpcbiAgICAgKiBUaGVyZSBhcmUgYSBmZXcgcnVsZXMgZm9yIHRoZSBzdGVwIGFkanVzdG1lbnRzIGZvciB5b3VyIHN0ZXAgcG9saWN5OlxuICAgICAqXG4gICAgICogLSBUaGUgcmFuZ2VzIG9mIHlvdXIgc3RlcCBhZGp1c3RtZW50cyBjYW4ndCBvdmVybGFwIG9yIGhhdmUgYSBnYXAuXG4gICAgICogLSBBdCBtb3N0IG9uZSBzdGVwIGFkanVzdG1lbnQgY2FuIGhhdmUgYSBudWxsIGxvd2VyIGJvdW5kLiBJZiBvbmUgc3RlcCBhZGp1c3RtZW50IGhhcyBhIG5lZ2F0aXZlIGxvd2VyIGJvdW5kLCB0aGVuIHRoZXJlIG11c3QgYmUgYSBzdGVwIGFkanVzdG1lbnQgd2l0aCBhIG51bGwgbG93ZXIgYm91bmQuXG4gICAgICogLSBBdCBtb3N0IG9uZSBzdGVwIGFkanVzdG1lbnQgY2FuIGhhdmUgYSBudWxsIHVwcGVyIGJvdW5kLiBJZiBvbmUgc3RlcCBhZGp1c3RtZW50IGhhcyBhIHBvc2l0aXZlIHVwcGVyIGJvdW5kLCB0aGVuIHRoZXJlIG11c3QgYmUgYSBzdGVwIGFkanVzdG1lbnQgd2l0aCBhIG51bGwgdXBwZXIgYm91bmQuXG4gICAgICogLSBUaGUgdXBwZXIgYW5kIGxvd2VyIGJvdW5kIGNhbid0IGJlIG51bGwgaW4gdGhlIHNhbWUgc3RlcCBhZGp1c3RtZW50LlxuICAgICAqXG4gICAgICogRm9yIG1vcmUgaW5mb3JtYXRpb24sIHNlZSBbU3RlcCBhZGp1c3RtZW50c10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2F1dG9zY2FsaW5nL2VjMi91c2VyZ3VpZGUvYXMtc2NhbGluZy1zaW1wbGUtc3RlcC5odG1sI2FzLXNjYWxpbmctc3RlcHMpIGluIHRoZSAqQW1hem9uIEVDMiBBdXRvIFNjYWxpbmcgVXNlciBHdWlkZSogLlxuICAgICAqXG4gICAgICogWW91IGNhbiBmaW5kIGEgc2FtcGxlIHRlbXBsYXRlIHNuaXBwZXQgaW4gdGhlIFtFeGFtcGxlc10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXMtcG9saWN5Lmh0bWwjYXdzLXByb3BlcnRpZXMtYXMtcG9saWN5LS1leGFtcGxlcykgc2VjdGlvbiBvZiB0aGUgYEFXUzo6QXV0b1NjYWxpbmc6OlNjYWxpbmdQb2xpY3lgIHJlc291cmNlLlxuICAgICAqXG4gICAgICogQHN0cnVjdFxuICAgICAqIEBzdGFiaWxpdHkgZXh0ZXJuYWxcbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXV0b3NjYWxpbmctc2NhbGluZ3BvbGljeS1zdGVwYWRqdXN0bWVudC5odG1sXG4gICAgICovXG4gICAgZXhwb3J0IGludGVyZmFjZSBTdGVwQWRqdXN0bWVudFByb3BlcnR5IHtcbiAgICAgICAgLyoqXG4gICAgICAgICAqIFRoZSBsb3dlciBib3VuZCBmb3IgdGhlIGRpZmZlcmVuY2UgYmV0d2VlbiB0aGUgYWxhcm0gdGhyZXNob2xkIGFuZCB0aGUgQ2xvdWRXYXRjaCBtZXRyaWMuIElmIHRoZSBtZXRyaWMgdmFsdWUgaXMgYWJvdmUgdGhlIGJyZWFjaCB0aHJlc2hvbGQsIHRoZSBsb3dlciBib3VuZCBpcyBpbmNsdXNpdmUgKHRoZSBtZXRyaWMgbXVzdCBiZSBncmVhdGVyIHRoYW4gb3IgZXF1YWwgdG8gdGhlIHRocmVzaG9sZCBwbHVzIHRoZSBsb3dlciBib3VuZCkuIE90aGVyd2lzZSwgaXQgaXMgZXhjbHVzaXZlICh0aGUgbWV0cmljIG11c3QgYmUgZ3JlYXRlciB0aGFuIHRoZSB0aHJlc2hvbGQgcGx1cyB0aGUgbG93ZXIgYm91bmQpLiBBIG51bGwgdmFsdWUgaW5kaWNhdGVzIG5lZ2F0aXZlIGluZmluaXR5LlxuICAgICAgICAgKlxuICAgICAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWF1dG9zY2FsaW5nLXNjYWxpbmdwb2xpY3ktc3RlcGFkanVzdG1lbnQuaHRtbCNjZm4tYXV0b3NjYWxpbmctc2NhbGluZ3BvbGljeS1zdGVwYWRqdXN0bWVudC1tZXRyaWNpbnRlcnZhbGxvd2VyYm91bmRcbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IG1ldHJpY0ludGVydmFsTG93ZXJCb3VuZD86IG51bWJlcjtcbiAgICAgICAgLyoqXG4gICAgICAgICAqIFRoZSB1cHBlciBib3VuZCBmb3IgdGhlIGRpZmZlcmVuY2UgYmV0d2VlbiB0aGUgYWxhcm0gdGhyZXNob2xkIGFuZCB0aGUgQ2xvdWRXYXRjaCBtZXRyaWMuIElmIHRoZSBtZXRyaWMgdmFsdWUgaXMgYWJvdmUgdGhlIGJyZWFjaCB0aHJlc2hvbGQsIHRoZSB1cHBlciBib3VuZCBpcyBleGNsdXNpdmUgKHRoZSBtZXRyaWMgbXVzdCBiZSBsZXNzIHRoYW4gdGhlIHRocmVzaG9sZCBwbHVzIHRoZSB1cHBlciBib3VuZCkuIE90aGVyd2lzZSwgaXQgaXMgaW5jbHVzaXZlICh0aGUgbWV0cmljIG11c3QgYmUgbGVzcyB0aGFuIG9yIGVxdWFsIHRvIHRoZSB0aHJlc2hvbGQgcGx1cyB0aGUgdXBwZXIgYm91bmQpLiBBIG51bGwgdmFsdWUgaW5kaWNhdGVzIHBvc2l0aXZlIGluZmluaXR5LlxuICAgICAgICAgKlxuICAgICAgICAgKiBUaGUgdXBwZXIgYm91bmQgbXVzdCBiZSBncmVhdGVyIHRoYW4gdGhlIGxvd2VyIGJvdW5kLlxuICAgICAgICAgKlxuICAgICAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWF1dG9zY2FsaW5nLXNjYWxpbmdwb2xpY3ktc3RlcGFkanVzdG1lbnQuaHRtbCNjZm4tYXV0b3NjYWxpbmctc2NhbGluZ3BvbGljeS1zdGVwYWRqdXN0bWVudC1tZXRyaWNpbnRlcnZhbHVwcGVyYm91bmRcbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IG1ldHJpY0ludGVydmFsVXBwZXJCb3VuZD86IG51bWJlcjtcbiAgICAgICAgLyoqXG4gICAgICAgICAqIFRoZSBhbW91bnQgYnkgd2hpY2ggdG8gc2NhbGUsIGJhc2VkIG9uIHRoZSBzcGVjaWZpZWQgYWRqdXN0bWVudCB0eXBlLiBBIHBvc2l0aXZlIHZhbHVlIGFkZHMgdG8gdGhlIGN1cnJlbnQgY2FwYWNpdHkgd2hpbGUgYSBuZWdhdGl2ZSBudW1iZXIgcmVtb3ZlcyBmcm9tIHRoZSBjdXJyZW50IGNhcGFjaXR5LlxuICAgICAgICAgKlxuICAgICAgICAgKiBUaGUgYW1vdW50IGJ5IHdoaWNoIHRvIHNjYWxlLiBUaGUgYWRqdXN0bWVudCBpcyBiYXNlZCBvbiB0aGUgdmFsdWUgdGhhdCB5b3Ugc3BlY2lmaWVkIGluIHRoZSBgQWRqdXN0bWVudFR5cGVgIHByb3BlcnR5IChlaXRoZXIgYW4gYWJzb2x1dGUgbnVtYmVyIG9yIGEgcGVyY2VudGFnZSkuIEEgcG9zaXRpdmUgdmFsdWUgYWRkcyB0byB0aGUgY3VycmVudCBjYXBhY2l0eSBhbmQgYSBuZWdhdGl2ZSBudW1iZXIgc3VidHJhY3RzIGZyb20gdGhlIGN1cnJlbnQgY2FwYWNpdHkuXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXV0b3NjYWxpbmctc2NhbGluZ3BvbGljeS1zdGVwYWRqdXN0bWVudC5odG1sI2Nmbi1hdXRvc2NhbGluZy1zY2FsaW5ncG9saWN5LXN0ZXBhZGp1c3RtZW50LXNjYWxpbmdhZGp1c3RtZW50XG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBzY2FsaW5nQWRqdXN0bWVudDogbnVtYmVyO1xuICAgIH1cbn1cblxuLyoqXG4gKiBEZXRlcm1pbmUgd2hldGhlciB0aGUgZ2l2ZW4gcHJvcGVydGllcyBtYXRjaCB0aG9zZSBvZiBhIGBTdGVwQWRqdXN0bWVudFByb3BlcnR5YFxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBTdGVwQWRqdXN0bWVudFByb3BlcnR5YFxuICpcbiAqIEByZXR1cm5zIHRoZSByZXN1bHQgb2YgdGhlIHZhbGlkYXRpb24uXG4gKi9cbmZ1bmN0aW9uIENmblNjYWxpbmdQb2xpY3lfU3RlcEFkanVzdG1lbnRQcm9wZXJ0eVZhbGlkYXRvcihwcm9wZXJ0aWVzOiBhbnkpOiBjZGsuVmFsaWRhdGlvblJlc3VsdCB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gY2RrLlZBTElEQVRJT05fU1VDQ0VTUzsgfVxuICAgIGNvbnN0IGVycm9ycyA9IG5ldyBjZGsuVmFsaWRhdGlvblJlc3VsdHMoKTtcbiAgICBpZiAodHlwZW9mIHByb3BlcnRpZXMgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIGVycm9ycy5jb2xsZWN0KG5ldyBjZGsuVmFsaWRhdGlvblJlc3VsdCgnRXhwZWN0ZWQgYW4gb2JqZWN0LCBidXQgcmVjZWl2ZWQ6ICcgKyBKU09OLnN0cmluZ2lmeShwcm9wZXJ0aWVzKSkpO1xuICAgIH1cbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ21ldHJpY0ludGVydmFsTG93ZXJCb3VuZCcsIGNkay52YWxpZGF0ZU51bWJlcikocHJvcGVydGllcy5tZXRyaWNJbnRlcnZhbExvd2VyQm91bmQpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ21ldHJpY0ludGVydmFsVXBwZXJCb3VuZCcsIGNkay52YWxpZGF0ZU51bWJlcikocHJvcGVydGllcy5tZXRyaWNJbnRlcnZhbFVwcGVyQm91bmQpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3NjYWxpbmdBZGp1c3RtZW50JywgY2RrLnJlcXVpcmVkVmFsaWRhdG9yKShwcm9wZXJ0aWVzLnNjYWxpbmdBZGp1c3RtZW50KSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdzY2FsaW5nQWRqdXN0bWVudCcsIGNkay52YWxpZGF0ZU51bWJlcikocHJvcGVydGllcy5zY2FsaW5nQWRqdXN0bWVudCkpO1xuICAgIHJldHVybiBlcnJvcnMud3JhcCgnc3VwcGxpZWQgcHJvcGVydGllcyBub3QgY29ycmVjdCBmb3IgXCJTdGVwQWRqdXN0bWVudFByb3BlcnR5XCInKTtcbn1cblxuLyoqXG4gKiBSZW5kZXJzIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpBdXRvU2NhbGluZzo6U2NhbGluZ1BvbGljeS5TdGVwQWRqdXN0bWVudGAgcmVzb3VyY2VcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgU3RlcEFkanVzdG1lbnRQcm9wZXJ0eWBcbiAqXG4gKiBAcmV0dXJucyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6QXV0b1NjYWxpbmc6OlNjYWxpbmdQb2xpY3kuU3RlcEFkanVzdG1lbnRgIHJlc291cmNlLlxuICovXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gY2ZuU2NhbGluZ1BvbGljeVN0ZXBBZGp1c3RtZW50UHJvcGVydHlUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGFueSB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gcHJvcGVydGllczsgfVxuICAgIENmblNjYWxpbmdQb2xpY3lfU3RlcEFkanVzdG1lbnRQcm9wZXJ0eVZhbGlkYXRvcihwcm9wZXJ0aWVzKS5hc3NlcnRTdWNjZXNzKCk7XG4gICAgcmV0dXJuIHtcbiAgICAgICAgTWV0cmljSW50ZXJ2YWxMb3dlckJvdW5kOiBjZGsubnVtYmVyVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLm1ldHJpY0ludGVydmFsTG93ZXJCb3VuZCksXG4gICAgICAgIE1ldHJpY0ludGVydmFsVXBwZXJCb3VuZDogY2RrLm51bWJlclRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5tZXRyaWNJbnRlcnZhbFVwcGVyQm91bmQpLFxuICAgICAgICBTY2FsaW5nQWRqdXN0bWVudDogY2RrLm51bWJlclRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5zY2FsaW5nQWRqdXN0bWVudCksXG4gICAgfTtcbn1cblxuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIENmblNjYWxpbmdQb2xpY3lTdGVwQWRqdXN0bWVudFByb3BlcnR5RnJvbUNsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQ8Q2ZuU2NhbGluZ1BvbGljeS5TdGVwQWRqdXN0bWVudFByb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlPiB7XG4gICAgaWYgKGNkay5pc1Jlc29sdmFibGVPYmplY3QocHJvcGVydGllcykpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0KHByb3BlcnRpZXMpO1xuICAgIH1cbiAgICBwcm9wZXJ0aWVzID0gcHJvcGVydGllcyA9PSBudWxsID8ge30gOiBwcm9wZXJ0aWVzO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0KHByb3BlcnRpZXMpO1xuICAgIH1cbiAgICBjb25zdCByZXQgPSBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblByb3BlcnR5T2JqZWN0PENmblNjYWxpbmdQb2xpY3kuU3RlcEFkanVzdG1lbnRQcm9wZXJ0eT4oKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ21ldHJpY0ludGVydmFsTG93ZXJCb3VuZCcsICdNZXRyaWNJbnRlcnZhbExvd2VyQm91bmQnLCBwcm9wZXJ0aWVzLk1ldHJpY0ludGVydmFsTG93ZXJCb3VuZCAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXROdW1iZXIocHJvcGVydGllcy5NZXRyaWNJbnRlcnZhbExvd2VyQm91bmQpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ21ldHJpY0ludGVydmFsVXBwZXJCb3VuZCcsICdNZXRyaWNJbnRlcnZhbFVwcGVyQm91bmQnLCBwcm9wZXJ0aWVzLk1ldHJpY0ludGVydmFsVXBwZXJCb3VuZCAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXROdW1iZXIocHJvcGVydGllcy5NZXRyaWNJbnRlcnZhbFVwcGVyQm91bmQpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ3NjYWxpbmdBZGp1c3RtZW50JywgJ1NjYWxpbmdBZGp1c3RtZW50JywgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXROdW1iZXIocHJvcGVydGllcy5TY2FsaW5nQWRqdXN0bWVudCkpO1xuICAgIHJldC5hZGRVbnJlY29nbml6ZWRQcm9wZXJ0aWVzQXNFeHRyYShwcm9wZXJ0aWVzKTtcbiAgICByZXR1cm4gcmV0O1xufVxuXG5leHBvcnQgbmFtZXNwYWNlIENmblNjYWxpbmdQb2xpY3kge1xuICAgIC8qKlxuICAgICAqIGBUYXJnZXRUcmFja2luZ0NvbmZpZ3VyYXRpb25gIGlzIGEgcHJvcGVydHkgb2YgdGhlIFtBV1M6OkF1dG9TY2FsaW5nOjpTY2FsaW5nUG9saWN5XShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hcy1wb2xpY3kuaHRtbCkgcmVzb3VyY2UgdGhhdCBzcGVjaWZpZXMgYSB0YXJnZXQgdHJhY2tpbmcgc2NhbGluZyBwb2xpY3kgY29uZmlndXJhdGlvbiBmb3IgQW1hem9uIEVDMiBBdXRvIFNjYWxpbmcuXG4gICAgICpcbiAgICAgKiBGb3IgbW9yZSBpbmZvcm1hdGlvbiBhYm91dCBzY2FsaW5nIHBvbGljaWVzLCBzZWUgW0R5bmFtaWMgc2NhbGluZ10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2F1dG9zY2FsaW5nL2VjMi91c2VyZ3VpZGUvYXMtc2NhbGUtYmFzZWQtb24tZGVtYW5kLmh0bWwpIGluIHRoZSAqQW1hem9uIEVDMiBBdXRvIFNjYWxpbmcgVXNlciBHdWlkZSogLlxuICAgICAqXG4gICAgICogQHN0cnVjdFxuICAgICAqIEBzdGFiaWxpdHkgZXh0ZXJuYWxcbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXV0b3NjYWxpbmctc2NhbGluZ3BvbGljeS10YXJnZXR0cmFja2luZ2NvbmZpZ3VyYXRpb24uaHRtbFxuICAgICAqL1xuICAgIGV4cG9ydCBpbnRlcmZhY2UgVGFyZ2V0VHJhY2tpbmdDb25maWd1cmF0aW9uUHJvcGVydHkge1xuICAgICAgICAvKipcbiAgICAgICAgICogQSBjdXN0b21pemVkIG1ldHJpYy4gWW91IG11c3Qgc3BlY2lmeSBlaXRoZXIgYSBwcmVkZWZpbmVkIG1ldHJpYyBvciBhIGN1c3RvbWl6ZWQgbWV0cmljLlxuICAgICAgICAgKlxuICAgICAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWF1dG9zY2FsaW5nLXNjYWxpbmdwb2xpY3ktdGFyZ2V0dHJhY2tpbmdjb25maWd1cmF0aW9uLmh0bWwjY2ZuLWF1dG9zY2FsaW5nLXNjYWxpbmdwb2xpY3ktdGFyZ2V0dHJhY2tpbmdjb25maWd1cmF0aW9uLWN1c3RvbWl6ZWRtZXRyaWNzcGVjaWZpY2F0aW9uXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBjdXN0b21pemVkTWV0cmljU3BlY2lmaWNhdGlvbj86IENmblNjYWxpbmdQb2xpY3kuQ3VzdG9taXplZE1ldHJpY1NwZWNpZmljYXRpb25Qcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZTtcbiAgICAgICAgLyoqXG4gICAgICAgICAqIEluZGljYXRlcyB3aGV0aGVyIHNjYWxpbmcgaW4gYnkgdGhlIHRhcmdldCB0cmFja2luZyBzY2FsaW5nIHBvbGljeSBpcyBkaXNhYmxlZC4gSWYgc2NhbGluZyBpbiBpcyBkaXNhYmxlZCwgdGhlIHRhcmdldCB0cmFja2luZyBzY2FsaW5nIHBvbGljeSBkb2Vzbid0IHJlbW92ZSBpbnN0YW5jZXMgZnJvbSB0aGUgQXV0byBTY2FsaW5nIGdyb3VwLiBPdGhlcndpc2UsIHRoZSB0YXJnZXQgdHJhY2tpbmcgc2NhbGluZyBwb2xpY3kgY2FuIHJlbW92ZSBpbnN0YW5jZXMgZnJvbSB0aGUgQXV0byBTY2FsaW5nIGdyb3VwLiBUaGUgZGVmYXVsdCBpcyBgZmFsc2VgIC5cbiAgICAgICAgICpcbiAgICAgICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hdXRvc2NhbGluZy1zY2FsaW5ncG9saWN5LXRhcmdldHRyYWNraW5nY29uZmlndXJhdGlvbi5odG1sI2Nmbi1hdXRvc2NhbGluZy1zY2FsaW5ncG9saWN5LXRhcmdldHRyYWNraW5nY29uZmlndXJhdGlvbi1kaXNhYmxlc2NhbGVpblxuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgZGlzYWJsZVNjYWxlSW4/OiBib29sZWFuIHwgY2RrLklSZXNvbHZhYmxlO1xuICAgICAgICAvKipcbiAgICAgICAgICogQSBwcmVkZWZpbmVkIG1ldHJpYy4gWW91IG11c3Qgc3BlY2lmeSBlaXRoZXIgYSBwcmVkZWZpbmVkIG1ldHJpYyBvciBhIGN1c3RvbWl6ZWQgbWV0cmljLlxuICAgICAgICAgKlxuICAgICAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWF1dG9zY2FsaW5nLXNjYWxpbmdwb2xpY3ktdGFyZ2V0dHJhY2tpbmdjb25maWd1cmF0aW9uLmh0bWwjY2ZuLWF1dG9zY2FsaW5nLXNjYWxpbmdwb2xpY3ktdGFyZ2V0dHJhY2tpbmdjb25maWd1cmF0aW9uLXByZWRlZmluZWRtZXRyaWNzcGVjaWZpY2F0aW9uXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBwcmVkZWZpbmVkTWV0cmljU3BlY2lmaWNhdGlvbj86IENmblNjYWxpbmdQb2xpY3kuUHJlZGVmaW5lZE1ldHJpY1NwZWNpZmljYXRpb25Qcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZTtcbiAgICAgICAgLyoqXG4gICAgICAgICAqIFRoZSB0YXJnZXQgdmFsdWUgZm9yIHRoZSBtZXRyaWMuXG4gICAgICAgICAqXG4gICAgICAgICAqID4gU29tZSBtZXRyaWNzIGFyZSBiYXNlZCBvbiBhIGNvdW50IGluc3RlYWQgb2YgYSBwZXJjZW50YWdlLCBzdWNoIGFzIHRoZSByZXF1ZXN0IGNvdW50IGZvciBhbiBBcHBsaWNhdGlvbiBMb2FkIEJhbGFuY2VyIG9yIHRoZSBudW1iZXIgb2YgbWVzc2FnZXMgaW4gYW4gU1FTIHF1ZXVlLiBJZiB0aGUgc2NhbGluZyBwb2xpY3kgc3BlY2lmaWVzIG9uZSBvZiB0aGVzZSBtZXRyaWNzLCBzcGVjaWZ5IHRoZSB0YXJnZXQgdXRpbGl6YXRpb24gYXMgdGhlIG9wdGltYWwgYXZlcmFnZSByZXF1ZXN0IG9yIG1lc3NhZ2UgY291bnQgcGVyIGluc3RhbmNlIGR1cmluZyBhbnkgb25lLW1pbnV0ZSBpbnRlcnZhbC5cbiAgICAgICAgICpcbiAgICAgICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hdXRvc2NhbGluZy1zY2FsaW5ncG9saWN5LXRhcmdldHRyYWNraW5nY29uZmlndXJhdGlvbi5odG1sI2Nmbi1hdXRvc2NhbGluZy1zY2FsaW5ncG9saWN5LXRhcmdldHRyYWNraW5nY29uZmlndXJhdGlvbi10YXJnZXR2YWx1ZVxuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgdGFyZ2V0VmFsdWU6IG51bWJlcjtcbiAgICB9XG59XG5cbi8qKlxuICogRGV0ZXJtaW5lIHdoZXRoZXIgdGhlIGdpdmVuIHByb3BlcnRpZXMgbWF0Y2ggdGhvc2Ugb2YgYSBgVGFyZ2V0VHJhY2tpbmdDb25maWd1cmF0aW9uUHJvcGVydHlgXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYFRhcmdldFRyYWNraW5nQ29uZmlndXJhdGlvblByb3BlcnR5YFxuICpcbiAqIEByZXR1cm5zIHRoZSByZXN1bHQgb2YgdGhlIHZhbGlkYXRpb24uXG4gKi9cbmZ1bmN0aW9uIENmblNjYWxpbmdQb2xpY3lfVGFyZ2V0VHJhY2tpbmdDb25maWd1cmF0aW9uUHJvcGVydHlWYWxpZGF0b3IocHJvcGVydGllczogYW55KTogY2RrLlZhbGlkYXRpb25SZXN1bHQge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIGNkay5WQUxJREFUSU9OX1NVQ0NFU1M7IH1cbiAgICBjb25zdCBlcnJvcnMgPSBuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHRzKCk7XG4gICAgaWYgKHR5cGVvZiBwcm9wZXJ0aWVzICE9PSAnb2JqZWN0Jykge1xuICAgICAgICBlcnJvcnMuY29sbGVjdChuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHQoJ0V4cGVjdGVkIGFuIG9iamVjdCwgYnV0IHJlY2VpdmVkOiAnICsgSlNPTi5zdHJpbmdpZnkocHJvcGVydGllcykpKTtcbiAgICB9XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdjdXN0b21pemVkTWV0cmljU3BlY2lmaWNhdGlvbicsIENmblNjYWxpbmdQb2xpY3lfQ3VzdG9taXplZE1ldHJpY1NwZWNpZmljYXRpb25Qcm9wZXJ0eVZhbGlkYXRvcikocHJvcGVydGllcy5jdXN0b21pemVkTWV0cmljU3BlY2lmaWNhdGlvbikpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignZGlzYWJsZVNjYWxlSW4nLCBjZGsudmFsaWRhdGVCb29sZWFuKShwcm9wZXJ0aWVzLmRpc2FibGVTY2FsZUluKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdwcmVkZWZpbmVkTWV0cmljU3BlY2lmaWNhdGlvbicsIENmblNjYWxpbmdQb2xpY3lfUHJlZGVmaW5lZE1ldHJpY1NwZWNpZmljYXRpb25Qcm9wZXJ0eVZhbGlkYXRvcikocHJvcGVydGllcy5wcmVkZWZpbmVkTWV0cmljU3BlY2lmaWNhdGlvbikpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigndGFyZ2V0VmFsdWUnLCBjZGsucmVxdWlyZWRWYWxpZGF0b3IpKHByb3BlcnRpZXMudGFyZ2V0VmFsdWUpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3RhcmdldFZhbHVlJywgY2RrLnZhbGlkYXRlTnVtYmVyKShwcm9wZXJ0aWVzLnRhcmdldFZhbHVlKSk7XG4gICAgcmV0dXJuIGVycm9ycy53cmFwKCdzdXBwbGllZCBwcm9wZXJ0aWVzIG5vdCBjb3JyZWN0IGZvciBcIlRhcmdldFRyYWNraW5nQ29uZmlndXJhdGlvblByb3BlcnR5XCInKTtcbn1cblxuLyoqXG4gKiBSZW5kZXJzIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpBdXRvU2NhbGluZzo6U2NhbGluZ1BvbGljeS5UYXJnZXRUcmFja2luZ0NvbmZpZ3VyYXRpb25gIHJlc291cmNlXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYFRhcmdldFRyYWNraW5nQ29uZmlndXJhdGlvblByb3BlcnR5YFxuICpcbiAqIEByZXR1cm5zIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpBdXRvU2NhbGluZzo6U2NhbGluZ1BvbGljeS5UYXJnZXRUcmFja2luZ0NvbmZpZ3VyYXRpb25gIHJlc291cmNlLlxuICovXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gY2ZuU2NhbGluZ1BvbGljeVRhcmdldFRyYWNraW5nQ29uZmlndXJhdGlvblByb3BlcnR5VG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBhbnkge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIHByb3BlcnRpZXM7IH1cbiAgICBDZm5TY2FsaW5nUG9saWN5X1RhcmdldFRyYWNraW5nQ29uZmlndXJhdGlvblByb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXMpLmFzc2VydFN1Y2Nlc3MoKTtcbiAgICByZXR1cm4ge1xuICAgICAgICBDdXN0b21pemVkTWV0cmljU3BlY2lmaWNhdGlvbjogY2ZuU2NhbGluZ1BvbGljeUN1c3RvbWl6ZWRNZXRyaWNTcGVjaWZpY2F0aW9uUHJvcGVydHlUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuY3VzdG9taXplZE1ldHJpY1NwZWNpZmljYXRpb24pLFxuICAgICAgICBEaXNhYmxlU2NhbGVJbjogY2RrLmJvb2xlYW5Ub0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuZGlzYWJsZVNjYWxlSW4pLFxuICAgICAgICBQcmVkZWZpbmVkTWV0cmljU3BlY2lmaWNhdGlvbjogY2ZuU2NhbGluZ1BvbGljeVByZWRlZmluZWRNZXRyaWNTcGVjaWZpY2F0aW9uUHJvcGVydHlUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMucHJlZGVmaW5lZE1ldHJpY1NwZWNpZmljYXRpb24pLFxuICAgICAgICBUYXJnZXRWYWx1ZTogY2RrLm51bWJlclRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy50YXJnZXRWYWx1ZSksXG4gICAgfTtcbn1cblxuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIENmblNjYWxpbmdQb2xpY3lUYXJnZXRUcmFja2luZ0NvbmZpZ3VyYXRpb25Qcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0PENmblNjYWxpbmdQb2xpY3kuVGFyZ2V0VHJhY2tpbmdDb25maWd1cmF0aW9uUHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGU+IHtcbiAgICBpZiAoY2RrLmlzUmVzb2x2YWJsZU9iamVjdChwcm9wZXJ0aWVzKSkge1xuICAgICAgICByZXR1cm4gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQocHJvcGVydGllcyk7XG4gICAgfVxuICAgIHByb3BlcnRpZXMgPSBwcm9wZXJ0aWVzID09IG51bGwgPyB7fSA6IHByb3BlcnRpZXM7XG4gICAgaWYgKHR5cGVvZiBwcm9wZXJ0aWVzICE9PSAnb2JqZWN0Jykge1xuICAgICAgICByZXR1cm4gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQocHJvcGVydGllcyk7XG4gICAgfVxuICAgIGNvbnN0IHJldCA9IG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUHJvcGVydHlPYmplY3Q8Q2ZuU2NhbGluZ1BvbGljeS5UYXJnZXRUcmFja2luZ0NvbmZpZ3VyYXRpb25Qcm9wZXJ0eT4oKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2N1c3RvbWl6ZWRNZXRyaWNTcGVjaWZpY2F0aW9uJywgJ0N1c3RvbWl6ZWRNZXRyaWNTcGVjaWZpY2F0aW9uJywgcHJvcGVydGllcy5DdXN0b21pemVkTWV0cmljU3BlY2lmaWNhdGlvbiAhPSBudWxsID8gQ2ZuU2NhbGluZ1BvbGljeUN1c3RvbWl6ZWRNZXRyaWNTcGVjaWZpY2F0aW9uUHJvcGVydHlGcm9tQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5DdXN0b21pemVkTWV0cmljU3BlY2lmaWNhdGlvbikgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnZGlzYWJsZVNjYWxlSW4nLCAnRGlzYWJsZVNjYWxlSW4nLCBwcm9wZXJ0aWVzLkRpc2FibGVTY2FsZUluICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldEJvb2xlYW4ocHJvcGVydGllcy5EaXNhYmxlU2NhbGVJbikgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgncHJlZGVmaW5lZE1ldHJpY1NwZWNpZmljYXRpb24nLCAnUHJlZGVmaW5lZE1ldHJpY1NwZWNpZmljYXRpb24nLCBwcm9wZXJ0aWVzLlByZWRlZmluZWRNZXRyaWNTcGVjaWZpY2F0aW9uICE9IG51bGwgPyBDZm5TY2FsaW5nUG9saWN5UHJlZGVmaW5lZE1ldHJpY1NwZWNpZmljYXRpb25Qcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLlByZWRlZmluZWRNZXRyaWNTcGVjaWZpY2F0aW9uKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCd0YXJnZXRWYWx1ZScsICdUYXJnZXRWYWx1ZScsIGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0TnVtYmVyKHByb3BlcnRpZXMuVGFyZ2V0VmFsdWUpKTtcbiAgICByZXQuYWRkVW5yZWNvZ25pemVkUHJvcGVydGllc0FzRXh0cmEocHJvcGVydGllcyk7XG4gICAgcmV0dXJuIHJldDtcbn1cblxuLyoqXG4gKiBQcm9wZXJ0aWVzIGZvciBkZWZpbmluZyBhIGBDZm5TY2hlZHVsZWRBY3Rpb25gXG4gKlxuICogQHN0cnVjdFxuICogQHN0YWJpbGl0eSBleHRlcm5hbFxuICpcbiAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWF1dG9zY2FsaW5nLXNjaGVkdWxlZGFjdGlvbi5odG1sXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgQ2ZuU2NoZWR1bGVkQWN0aW9uUHJvcHMge1xuXG4gICAgLyoqXG4gICAgICogVGhlIG5hbWUgb2YgdGhlIEF1dG8gU2NhbGluZyBncm91cC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWF1dG9zY2FsaW5nLXNjaGVkdWxlZGFjdGlvbi5odG1sI2Nmbi1hdXRvc2NhbGluZy1zY2hlZHVsZWRhY3Rpb24tYXV0b3NjYWxpbmdncm91cG5hbWVcbiAgICAgKi9cbiAgICByZWFkb25seSBhdXRvU2NhbGluZ0dyb3VwTmFtZTogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogVGhlIGRlc2lyZWQgY2FwYWNpdHkgaXMgdGhlIGluaXRpYWwgY2FwYWNpdHkgb2YgdGhlIEF1dG8gU2NhbGluZyBncm91cCBhZnRlciB0aGUgc2NoZWR1bGVkIGFjdGlvbiBydW5zIGFuZCB0aGUgY2FwYWNpdHkgaXQgYXR0ZW1wdHMgdG8gbWFpbnRhaW4uIEl0IGNhbiBzY2FsZSBiZXlvbmQgdGhpcyBjYXBhY2l0eSBpZiB5b3UgYWRkIG1vcmUgc2NhbGluZyBjb25kaXRpb25zLlxuICAgICAqXG4gICAgICogPiBZb3UgbXVzdCBzcGVjaWZ5IGF0IGxlYXN0IG9uZSBvZiB0aGUgZm9sbG93aW5nIHByb3BlcnRpZXM6IGBNYXhTaXplYCAsIGBNaW5TaXplYCAsIG9yIGBEZXNpcmVkQ2FwYWNpdHlgIC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWF1dG9zY2FsaW5nLXNjaGVkdWxlZGFjdGlvbi5odG1sI2Nmbi1hdXRvc2NhbGluZy1zY2hlZHVsZWRhY3Rpb24tZGVzaXJlZGNhcGFjaXR5XG4gICAgICovXG4gICAgcmVhZG9ubHkgZGVzaXJlZENhcGFjaXR5PzogbnVtYmVyO1xuXG4gICAgLyoqXG4gICAgICogVGhlIGRhdGUgYW5kIHRpbWUgZm9yIHRoZSByZWN1cnJpbmcgc2NoZWR1bGUgdG8gZW5kLCBpbiBVVEMuIEZvciBleGFtcGxlLCBgXCIyMDIxLTA2LTAxVDAwOjAwOjAwWlwiYCAuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1hdXRvc2NhbGluZy1zY2hlZHVsZWRhY3Rpb24uaHRtbCNjZm4tYXV0b3NjYWxpbmctc2NoZWR1bGVkYWN0aW9uLWVuZHRpbWVcbiAgICAgKi9cbiAgICByZWFkb25seSBlbmRUaW1lPzogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogVGhlIG1heGltdW0gc2l6ZSBvZiB0aGUgQXV0byBTY2FsaW5nIGdyb3VwLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtYXV0b3NjYWxpbmctc2NoZWR1bGVkYWN0aW9uLmh0bWwjY2ZuLWF1dG9zY2FsaW5nLXNjaGVkdWxlZGFjdGlvbi1tYXhzaXplXG4gICAgICovXG4gICAgcmVhZG9ubHkgbWF4U2l6ZT86IG51bWJlcjtcblxuICAgIC8qKlxuICAgICAqIFRoZSBtaW5pbXVtIHNpemUgb2YgdGhlIEF1dG8gU2NhbGluZyBncm91cC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWF1dG9zY2FsaW5nLXNjaGVkdWxlZGFjdGlvbi5odG1sI2Nmbi1hdXRvc2NhbGluZy1zY2hlZHVsZWRhY3Rpb24tbWluc2l6ZVxuICAgICAqL1xuICAgIHJlYWRvbmx5IG1pblNpemU/OiBudW1iZXI7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgcmVjdXJyaW5nIHNjaGVkdWxlIGZvciB0aGlzIGFjdGlvbi4gVGhpcyBmb3JtYXQgY29uc2lzdHMgb2YgZml2ZSBmaWVsZHMgc2VwYXJhdGVkIGJ5IHdoaXRlIHNwYWNlczogW01pbnV0ZV0gW0hvdXJdIFtEYXlfb2ZfTW9udGhdIFtNb250aF9vZl9ZZWFyXSBbRGF5X29mX1dlZWtdLiBUaGUgdmFsdWUgbXVzdCBiZSBpbiBxdW90ZXMgKGZvciBleGFtcGxlLCBgXCIzMCAwIDEgMSw2LDEyICpcImAgKS4gRm9yIG1vcmUgaW5mb3JtYXRpb24gYWJvdXQgdGhpcyBmb3JtYXQsIHNlZSBbQ3JvbnRhYl0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2h0dHA6Ly9jcm9udGFiLm9yZykgLlxuICAgICAqXG4gICAgICogV2hlbiBgU3RhcnRUaW1lYCBhbmQgYEVuZFRpbWVgIGFyZSBzcGVjaWZpZWQgd2l0aCBgUmVjdXJyZW5jZWAgLCB0aGV5IGZvcm0gdGhlIGJvdW5kYXJpZXMgb2Ygd2hlbiB0aGUgcmVjdXJyaW5nIGFjdGlvbiBzdGFydHMgYW5kIHN0b3BzLlxuICAgICAqXG4gICAgICogQ3JvbiBleHByZXNzaW9ucyB1c2UgVW5pdmVyc2FsIENvb3JkaW5hdGVkIFRpbWUgKFVUQykgYnkgZGVmYXVsdC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWF1dG9zY2FsaW5nLXNjaGVkdWxlZGFjdGlvbi5odG1sI2Nmbi1hdXRvc2NhbGluZy1zY2hlZHVsZWRhY3Rpb24tcmVjdXJyZW5jZVxuICAgICAqL1xuICAgIHJlYWRvbmx5IHJlY3VycmVuY2U/OiBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgZGF0ZSBhbmQgdGltZSBmb3IgdGhpcyBhY3Rpb24gdG8gc3RhcnQsIGluIFlZWVktTU0tRERUaGg6bW06c3NaIGZvcm1hdCBpbiBVVEMvR01UIG9ubHkgYW5kIGluIHF1b3RlcyAoZm9yIGV4YW1wbGUsIGBcIjIwMjEtMDYtMDFUMDA6MDA6MDBaXCJgICkuXG4gICAgICpcbiAgICAgKiBJZiB5b3Ugc3BlY2lmeSBgUmVjdXJyZW5jZWAgYW5kIGBTdGFydFRpbWVgICwgQW1hem9uIEVDMiBBdXRvIFNjYWxpbmcgcGVyZm9ybXMgdGhlIGFjdGlvbiBhdCB0aGlzIHRpbWUsIGFuZCB0aGVuIHBlcmZvcm1zIHRoZSBhY3Rpb24gYmFzZWQgb24gdGhlIHNwZWNpZmllZCByZWN1cnJlbmNlLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtYXV0b3NjYWxpbmctc2NoZWR1bGVkYWN0aW9uLmh0bWwjY2ZuLWF1dG9zY2FsaW5nLXNjaGVkdWxlZGFjdGlvbi1zdGFydHRpbWVcbiAgICAgKi9cbiAgICByZWFkb25seSBzdGFydFRpbWU/OiBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBTcGVjaWZpZXMgdGhlIHRpbWUgem9uZSBmb3IgYSBjcm9uIGV4cHJlc3Npb24uIElmIGEgdGltZSB6b25lIGlzIG5vdCBwcm92aWRlZCwgVVRDIGlzIHVzZWQgYnkgZGVmYXVsdC5cbiAgICAgKlxuICAgICAqIFZhbGlkIHZhbHVlcyBhcmUgdGhlIGNhbm9uaWNhbCBuYW1lcyBvZiB0aGUgSUFOQSB0aW1lIHpvbmVzLCBkZXJpdmVkIGZyb20gdGhlIElBTkEgVGltZSBab25lIERhdGFiYXNlIChzdWNoIGFzIGBFdGMvR01UKzlgIG9yIGBQYWNpZmljL1RhaGl0aWAgKS4gRm9yIG1vcmUgaW5mb3JtYXRpb24sIHNlZSBbaHR0cHM6Ly9lbi53aWtpcGVkaWEub3JnL3dpa2kvTGlzdF9vZl90el9kYXRhYmFzZV90aW1lX3pvbmVzXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaHR0cHM6Ly9lbi53aWtpcGVkaWEub3JnL3dpa2kvTGlzdF9vZl90el9kYXRhYmFzZV90aW1lX3pvbmVzKSAuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1hdXRvc2NhbGluZy1zY2hlZHVsZWRhY3Rpb24uaHRtbCNjZm4tYXV0b3NjYWxpbmctc2NoZWR1bGVkYWN0aW9uLXRpbWV6b25lXG4gICAgICovXG4gICAgcmVhZG9ubHkgdGltZVpvbmU/OiBzdHJpbmc7XG59XG5cbi8qKlxuICogRGV0ZXJtaW5lIHdoZXRoZXIgdGhlIGdpdmVuIHByb3BlcnRpZXMgbWF0Y2ggdGhvc2Ugb2YgYSBgQ2ZuU2NoZWR1bGVkQWN0aW9uUHJvcHNgXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYENmblNjaGVkdWxlZEFjdGlvblByb3BzYFxuICpcbiAqIEByZXR1cm5zIHRoZSByZXN1bHQgb2YgdGhlIHZhbGlkYXRpb24uXG4gKi9cbmZ1bmN0aW9uIENmblNjaGVkdWxlZEFjdGlvblByb3BzVmFsaWRhdG9yKHByb3BlcnRpZXM6IGFueSk6IGNkay5WYWxpZGF0aW9uUmVzdWx0IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBjZGsuVkFMSURBVElPTl9TVUNDRVNTOyB9XG4gICAgY29uc3QgZXJyb3JzID0gbmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0cygpO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgZXJyb3JzLmNvbGxlY3QobmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0KCdFeHBlY3RlZCBhbiBvYmplY3QsIGJ1dCByZWNlaXZlZDogJyArIEpTT04uc3RyaW5naWZ5KHByb3BlcnRpZXMpKSk7XG4gICAgfVxuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignYXV0b1NjYWxpbmdHcm91cE5hbWUnLCBjZGsucmVxdWlyZWRWYWxpZGF0b3IpKHByb3BlcnRpZXMuYXV0b1NjYWxpbmdHcm91cE5hbWUpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2F1dG9TY2FsaW5nR3JvdXBOYW1lJywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmF1dG9TY2FsaW5nR3JvdXBOYW1lKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdkZXNpcmVkQ2FwYWNpdHknLCBjZGsudmFsaWRhdGVOdW1iZXIpKHByb3BlcnRpZXMuZGVzaXJlZENhcGFjaXR5KSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdlbmRUaW1lJywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmVuZFRpbWUpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ21heFNpemUnLCBjZGsudmFsaWRhdGVOdW1iZXIpKHByb3BlcnRpZXMubWF4U2l6ZSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignbWluU2l6ZScsIGNkay52YWxpZGF0ZU51bWJlcikocHJvcGVydGllcy5taW5TaXplKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdyZWN1cnJlbmNlJywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLnJlY3VycmVuY2UpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3N0YXJ0VGltZScsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5zdGFydFRpbWUpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3RpbWVab25lJywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLnRpbWVab25lKSk7XG4gICAgcmV0dXJuIGVycm9ycy53cmFwKCdzdXBwbGllZCBwcm9wZXJ0aWVzIG5vdCBjb3JyZWN0IGZvciBcIkNmblNjaGVkdWxlZEFjdGlvblByb3BzXCInKTtcbn1cblxuLyoqXG4gKiBSZW5kZXJzIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpBdXRvU2NhbGluZzo6U2NoZWR1bGVkQWN0aW9uYCByZXNvdXJjZVxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBDZm5TY2hlZHVsZWRBY3Rpb25Qcm9wc2BcbiAqXG4gKiBAcmV0dXJucyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6QXV0b1NjYWxpbmc6OlNjaGVkdWxlZEFjdGlvbmAgcmVzb3VyY2UuXG4gKi9cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBjZm5TY2hlZHVsZWRBY3Rpb25Qcm9wc1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogYW55IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBwcm9wZXJ0aWVzOyB9XG4gICAgQ2ZuU2NoZWR1bGVkQWN0aW9uUHJvcHNWYWxpZGF0b3IocHJvcGVydGllcykuYXNzZXJ0U3VjY2VzcygpO1xuICAgIHJldHVybiB7XG4gICAgICAgIEF1dG9TY2FsaW5nR3JvdXBOYW1lOiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLmF1dG9TY2FsaW5nR3JvdXBOYW1lKSxcbiAgICAgICAgRGVzaXJlZENhcGFjaXR5OiBjZGsubnVtYmVyVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLmRlc2lyZWRDYXBhY2l0eSksXG4gICAgICAgIEVuZFRpbWU6IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuZW5kVGltZSksXG4gICAgICAgIE1heFNpemU6IGNkay5udW1iZXJUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMubWF4U2l6ZSksXG4gICAgICAgIE1pblNpemU6IGNkay5udW1iZXJUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMubWluU2l6ZSksXG4gICAgICAgIFJlY3VycmVuY2U6IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMucmVjdXJyZW5jZSksXG4gICAgICAgIFN0YXJ0VGltZTogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5zdGFydFRpbWUpLFxuICAgICAgICBUaW1lWm9uZTogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy50aW1lWm9uZSksXG4gICAgfTtcbn1cblxuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIENmblNjaGVkdWxlZEFjdGlvblByb3BzRnJvbUNsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQ8Q2ZuU2NoZWR1bGVkQWN0aW9uUHJvcHM+IHtcbiAgICBwcm9wZXJ0aWVzID0gcHJvcGVydGllcyA9PSBudWxsID8ge30gOiBwcm9wZXJ0aWVzO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0KHByb3BlcnRpZXMpO1xuICAgIH1cbiAgICBjb25zdCByZXQgPSBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblByb3BlcnR5T2JqZWN0PENmblNjaGVkdWxlZEFjdGlvblByb3BzPigpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnYXV0b1NjYWxpbmdHcm91cE5hbWUnLCAnQXV0b1NjYWxpbmdHcm91cE5hbWUnLCBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLkF1dG9TY2FsaW5nR3JvdXBOYW1lKSk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdkZXNpcmVkQ2FwYWNpdHknLCAnRGVzaXJlZENhcGFjaXR5JywgcHJvcGVydGllcy5EZXNpcmVkQ2FwYWNpdHkgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0TnVtYmVyKHByb3BlcnRpZXMuRGVzaXJlZENhcGFjaXR5KSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdlbmRUaW1lJywgJ0VuZFRpbWUnLCBwcm9wZXJ0aWVzLkVuZFRpbWUgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuRW5kVGltZSkgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnbWF4U2l6ZScsICdNYXhTaXplJywgcHJvcGVydGllcy5NYXhTaXplICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldE51bWJlcihwcm9wZXJ0aWVzLk1heFNpemUpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ21pblNpemUnLCAnTWluU2l6ZScsIHByb3BlcnRpZXMuTWluU2l6ZSAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXROdW1iZXIocHJvcGVydGllcy5NaW5TaXplKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdyZWN1cnJlbmNlJywgJ1JlY3VycmVuY2UnLCBwcm9wZXJ0aWVzLlJlY3VycmVuY2UgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuUmVjdXJyZW5jZSkgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnc3RhcnRUaW1lJywgJ1N0YXJ0VGltZScsIHByb3BlcnRpZXMuU3RhcnRUaW1lICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLlN0YXJ0VGltZSkgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgndGltZVpvbmUnLCAnVGltZVpvbmUnLCBwcm9wZXJ0aWVzLlRpbWVab25lICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLlRpbWVab25lKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFVucmVjb2duaXplZFByb3BlcnRpZXNBc0V4dHJhKHByb3BlcnRpZXMpO1xuICAgIHJldHVybiByZXQ7XG59XG5cbi8qKlxuICogQSBDbG91ZEZvcm1hdGlvbiBgQVdTOjpBdXRvU2NhbGluZzo6U2NoZWR1bGVkQWN0aW9uYFxuICpcbiAqIFRoZSBgQVdTOjpBdXRvU2NhbGluZzo6U2NoZWR1bGVkQWN0aW9uYCByZXNvdXJjZSBzcGVjaWZpZXMgYW4gQW1hem9uIEVDMiBBdXRvIFNjYWxpbmcgc2NoZWR1bGVkIGFjdGlvbiBzbyB0aGF0IHRoZSBBdXRvIFNjYWxpbmcgZ3JvdXAgY2FuIGNoYW5nZSB0aGUgbnVtYmVyIG9mIGluc3RhbmNlcyBhdmFpbGFibGUgZm9yIHlvdXIgYXBwbGljYXRpb24gaW4gcmVzcG9uc2UgdG8gcHJlZGljdGFibGUgbG9hZCBjaGFuZ2VzLlxuICpcbiAqIFdoZW4geW91IHVwZGF0ZSBhIHN0YWNrIHdpdGggYW4gQXV0byBTY2FsaW5nIGdyb3VwIGFuZCBzY2hlZHVsZWQgYWN0aW9uLCBDbG91ZEZvcm1hdGlvbiBhbHdheXMgc2V0cyB0aGUgbWluIHNpemUsIG1heCBzaXplLCBhbmQgZGVzaXJlZCBjYXBhY2l0eSBwcm9wZXJ0aWVzIG9mIHlvdXIgZ3JvdXAgdG8gdGhlIHZhbHVlcyB0aGF0IGFyZSBkZWZpbmVkIGluIHRoZSBgQVdTOjpBdXRvU2NhbGluZzo6QXV0b1NjYWxpbmdHcm91cGAgc2VjdGlvbiBvZiB5b3VyIHRlbXBsYXRlLiBIb3dldmVyLCB5b3UgbWlnaHQgbm90IHdhbnQgQ2xvdWRGb3JtYXRpb24gdG8gZG8gdGhhdCB3aGVuIHlvdSBoYXZlIGEgc2NoZWR1bGVkIGFjdGlvbiBpbiBlZmZlY3QuIFlvdSBjYW4gdXNlIGFuIFtVcGRhdGVQb2xpY3kgYXR0cmlidXRlXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtYXR0cmlidXRlLXVwZGF0ZXBvbGljeS5odG1sKSB0byBwcmV2ZW50IENsb3VkRm9ybWF0aW9uIGZyb20gY2hhbmdpbmcgdGhlIG1pbiBzaXplLCBtYXggc2l6ZSwgb3IgZGVzaXJlZCBjYXBhY2l0eSBwcm9wZXJ0eSB2YWx1ZXMgZHVyaW5nIGEgc3RhY2sgdXBkYXRlIHVubGVzcyB5b3UgbW9kaWZpZWQgdGhlIGluZGl2aWR1YWwgdmFsdWVzIGluIHlvdXIgdGVtcGxhdGUuIElmIHlvdSBoYXZlIHJvbGxpbmcgdXBkYXRlcyBlbmFibGVkLCBiZWZvcmUgeW91IGNhbiB1cGRhdGUgdGhlIEF1dG8gU2NhbGluZyBncm91cCwgeW91IG11c3Qgc3VzcGVuZCBzY2hlZHVsZWQgYWN0aW9ucyBieSBzcGVjaWZ5aW5nIGFuIFtVcGRhdGVQb2xpY3kgYXR0cmlidXRlXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtYXR0cmlidXRlLXVwZGF0ZXBvbGljeS5odG1sKSBmb3IgdGhlIEF1dG8gU2NhbGluZyBncm91cC4gWW91IGNhbiBmaW5kIGEgc2FtcGxlIHVwZGF0ZSBwb2xpY3kgZm9yIHJvbGxpbmcgdXBkYXRlcyBpbiBbQXV0byBzY2FsaW5nIHRlbXBsYXRlIHNuaXBwZXRzXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9xdWlja3JlZi1hdXRvc2NhbGluZy5odG1sKSAuXG4gKlxuICogRm9yIG1vcmUgaW5mb3JtYXRpb24sIHNlZSBbU2NoZWR1bGVkIHNjYWxpbmddKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9hdXRvc2NhbGluZy9lYzIvdXNlcmd1aWRlL3NjaGVkdWxlX3RpbWUuaHRtbCkgYW5kIFtTdXNwZW5kaW5nIGFuZCByZXN1bWluZyBzY2FsaW5nIHByb2Nlc3Nlc10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2F1dG9zY2FsaW5nL2VjMi91c2VyZ3VpZGUvYXMtc3VzcGVuZC1yZXN1bWUtcHJvY2Vzc2VzLmh0bWwpIGluIHRoZSAqQW1hem9uIEVDMiBBdXRvIFNjYWxpbmcgVXNlciBHdWlkZSogLlxuICpcbiAqIEBjbG91ZGZvcm1hdGlvblJlc291cmNlIEFXUzo6QXV0b1NjYWxpbmc6OlNjaGVkdWxlZEFjdGlvblxuICogQHN0YWJpbGl0eSBleHRlcm5hbFxuICpcbiAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWF1dG9zY2FsaW5nLXNjaGVkdWxlZGFjdGlvbi5odG1sXG4gKi9cbmV4cG9ydCBjbGFzcyBDZm5TY2hlZHVsZWRBY3Rpb24gZXh0ZW5kcyBjZGsuQ2ZuUmVzb3VyY2UgaW1wbGVtZW50cyBjZGsuSUluc3BlY3RhYmxlIHtcbiAgICAvKipcbiAgICAgKiBUaGUgQ2xvdWRGb3JtYXRpb24gcmVzb3VyY2UgdHlwZSBuYW1lIGZvciB0aGlzIHJlc291cmNlIGNsYXNzLlxuICAgICAqL1xuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgQ0ZOX1JFU09VUkNFX1RZUEVfTkFNRSA9IFwiQVdTOjpBdXRvU2NhbGluZzo6U2NoZWR1bGVkQWN0aW9uXCI7XG5cbiAgICAvKipcbiAgICAgKiBBIGZhY3RvcnkgbWV0aG9kIHRoYXQgY3JlYXRlcyBhIG5ldyBpbnN0YW5jZSBvZiB0aGlzIGNsYXNzIGZyb20gYW4gb2JqZWN0XG4gICAgICogY29udGFpbmluZyB0aGUgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiB0aGlzIHJlc291cmNlLlxuICAgICAqIFVzZWQgaW4gdGhlIEBhd3MtY2RrL2Nsb3VkZm9ybWF0aW9uLWluY2x1ZGUgbW9kdWxlLlxuICAgICAqXG4gICAgICogQGludGVybmFsXG4gICAgICovXG4gICAgcHVibGljIHN0YXRpYyBfZnJvbUNsb3VkRm9ybWF0aW9uKHNjb3BlOiBjZGsuQ29uc3RydWN0LCBpZDogc3RyaW5nLCByZXNvdXJjZUF0dHJpYnV0ZXM6IGFueSwgb3B0aW9uczogY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbk9wdGlvbnMpOiBDZm5TY2hlZHVsZWRBY3Rpb24ge1xuICAgICAgICByZXNvdXJjZUF0dHJpYnV0ZXMgPSByZXNvdXJjZUF0dHJpYnV0ZXMgfHwge307XG4gICAgICAgIGNvbnN0IHJlc291cmNlUHJvcGVydGllcyA9IG9wdGlvbnMucGFyc2VyLnBhcnNlVmFsdWUocmVzb3VyY2VBdHRyaWJ1dGVzLlByb3BlcnRpZXMpO1xuICAgICAgICBjb25zdCBwcm9wc1Jlc3VsdCA9IENmblNjaGVkdWxlZEFjdGlvblByb3BzRnJvbUNsb3VkRm9ybWF0aW9uKHJlc291cmNlUHJvcGVydGllcyk7XG4gICAgICAgIGNvbnN0IHJldCA9IG5ldyBDZm5TY2hlZHVsZWRBY3Rpb24oc2NvcGUsIGlkLCBwcm9wc1Jlc3VsdC52YWx1ZSk7XG4gICAgICAgIGZvciAoY29uc3QgW3Byb3BLZXksIHByb3BWYWxdIG9mIE9iamVjdC5lbnRyaWVzKHByb3BzUmVzdWx0LmV4dHJhUHJvcGVydGllcykpICB7XG4gICAgICAgICAgICByZXQuYWRkUHJvcGVydHlPdmVycmlkZShwcm9wS2V5LCBwcm9wVmFsKTtcbiAgICAgICAgfVxuICAgICAgICBvcHRpb25zLnBhcnNlci5oYW5kbGVBdHRyaWJ1dGVzKHJldCwgcmVzb3VyY2VBdHRyaWJ1dGVzLCBpZCk7XG4gICAgICAgIHJldHVybiByZXQ7XG4gICAgfVxuXG4gICAgLyoqXG4gICAgICogUmV0dXJucyB0aGUgbmFtZSBvZiBhIHNjaGVkdWxlZCBhY3Rpb24uXG4gICAgICogQGNsb3VkZm9ybWF0aW9uQXR0cmlidXRlIFNjaGVkdWxlZEFjdGlvbk5hbWVcbiAgICAgKi9cbiAgICBwdWJsaWMgcmVhZG9ubHkgYXR0clNjaGVkdWxlZEFjdGlvbk5hbWU6IHN0cmluZztcblxuICAgIC8qKlxuICAgICAqIFRoZSBuYW1lIG9mIHRoZSBBdXRvIFNjYWxpbmcgZ3JvdXAuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1hdXRvc2NhbGluZy1zY2hlZHVsZWRhY3Rpb24uaHRtbCNjZm4tYXV0b3NjYWxpbmctc2NoZWR1bGVkYWN0aW9uLWF1dG9zY2FsaW5nZ3JvdXBuYW1lXG4gICAgICovXG4gICAgcHVibGljIGF1dG9TY2FsaW5nR3JvdXBOYW1lOiBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgZGVzaXJlZCBjYXBhY2l0eSBpcyB0aGUgaW5pdGlhbCBjYXBhY2l0eSBvZiB0aGUgQXV0byBTY2FsaW5nIGdyb3VwIGFmdGVyIHRoZSBzY2hlZHVsZWQgYWN0aW9uIHJ1bnMgYW5kIHRoZSBjYXBhY2l0eSBpdCBhdHRlbXB0cyB0byBtYWludGFpbi4gSXQgY2FuIHNjYWxlIGJleW9uZCB0aGlzIGNhcGFjaXR5IGlmIHlvdSBhZGQgbW9yZSBzY2FsaW5nIGNvbmRpdGlvbnMuXG4gICAgICpcbiAgICAgKiA+IFlvdSBtdXN0IHNwZWNpZnkgYXQgbGVhc3Qgb25lIG9mIHRoZSBmb2xsb3dpbmcgcHJvcGVydGllczogYE1heFNpemVgICwgYE1pblNpemVgICwgb3IgYERlc2lyZWRDYXBhY2l0eWAgLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtYXV0b3NjYWxpbmctc2NoZWR1bGVkYWN0aW9uLmh0bWwjY2ZuLWF1dG9zY2FsaW5nLXNjaGVkdWxlZGFjdGlvbi1kZXNpcmVkY2FwYWNpdHlcbiAgICAgKi9cbiAgICBwdWJsaWMgZGVzaXJlZENhcGFjaXR5OiBudW1iZXIgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgZGF0ZSBhbmQgdGltZSBmb3IgdGhlIHJlY3VycmluZyBzY2hlZHVsZSB0byBlbmQsIGluIFVUQy4gRm9yIGV4YW1wbGUsIGBcIjIwMjEtMDYtMDFUMDA6MDA6MDBaXCJgIC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWF1dG9zY2FsaW5nLXNjaGVkdWxlZGFjdGlvbi5odG1sI2Nmbi1hdXRvc2NhbGluZy1zY2hlZHVsZWRhY3Rpb24tZW5kdGltZVxuICAgICAqL1xuICAgIHB1YmxpYyBlbmRUaW1lOiBzdHJpbmcgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgbWF4aW11bSBzaXplIG9mIHRoZSBBdXRvIFNjYWxpbmcgZ3JvdXAuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1hdXRvc2NhbGluZy1zY2hlZHVsZWRhY3Rpb24uaHRtbCNjZm4tYXV0b3NjYWxpbmctc2NoZWR1bGVkYWN0aW9uLW1heHNpemVcbiAgICAgKi9cbiAgICBwdWJsaWMgbWF4U2l6ZTogbnVtYmVyIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogVGhlIG1pbmltdW0gc2l6ZSBvZiB0aGUgQXV0byBTY2FsaW5nIGdyb3VwLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtYXV0b3NjYWxpbmctc2NoZWR1bGVkYWN0aW9uLmh0bWwjY2ZuLWF1dG9zY2FsaW5nLXNjaGVkdWxlZGFjdGlvbi1taW5zaXplXG4gICAgICovXG4gICAgcHVibGljIG1pblNpemU6IG51bWJlciB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIFRoZSByZWN1cnJpbmcgc2NoZWR1bGUgZm9yIHRoaXMgYWN0aW9uLiBUaGlzIGZvcm1hdCBjb25zaXN0cyBvZiBmaXZlIGZpZWxkcyBzZXBhcmF0ZWQgYnkgd2hpdGUgc3BhY2VzOiBbTWludXRlXSBbSG91cl0gW0RheV9vZl9Nb250aF0gW01vbnRoX29mX1llYXJdIFtEYXlfb2ZfV2Vla10uIFRoZSB2YWx1ZSBtdXN0IGJlIGluIHF1b3RlcyAoZm9yIGV4YW1wbGUsIGBcIjMwIDAgMSAxLDYsMTIgKlwiYCApLiBGb3IgbW9yZSBpbmZvcm1hdGlvbiBhYm91dCB0aGlzIGZvcm1hdCwgc2VlIFtDcm9udGFiXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaHR0cDovL2Nyb250YWIub3JnKSAuXG4gICAgICpcbiAgICAgKiBXaGVuIGBTdGFydFRpbWVgIGFuZCBgRW5kVGltZWAgYXJlIHNwZWNpZmllZCB3aXRoIGBSZWN1cnJlbmNlYCAsIHRoZXkgZm9ybSB0aGUgYm91bmRhcmllcyBvZiB3aGVuIHRoZSByZWN1cnJpbmcgYWN0aW9uIHN0YXJ0cyBhbmQgc3RvcHMuXG4gICAgICpcbiAgICAgKiBDcm9uIGV4cHJlc3Npb25zIHVzZSBVbml2ZXJzYWwgQ29vcmRpbmF0ZWQgVGltZSAoVVRDKSBieSBkZWZhdWx0LlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtYXV0b3NjYWxpbmctc2NoZWR1bGVkYWN0aW9uLmh0bWwjY2ZuLWF1dG9zY2FsaW5nLXNjaGVkdWxlZGFjdGlvbi1yZWN1cnJlbmNlXG4gICAgICovXG4gICAgcHVibGljIHJlY3VycmVuY2U6IHN0cmluZyB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIFRoZSBkYXRlIGFuZCB0aW1lIGZvciB0aGlzIGFjdGlvbiB0byBzdGFydCwgaW4gWVlZWS1NTS1ERFRoaDptbTpzc1ogZm9ybWF0IGluIFVUQy9HTVQgb25seSBhbmQgaW4gcXVvdGVzIChmb3IgZXhhbXBsZSwgYFwiMjAyMS0wNi0wMVQwMDowMDowMFpcImAgKS5cbiAgICAgKlxuICAgICAqIElmIHlvdSBzcGVjaWZ5IGBSZWN1cnJlbmNlYCBhbmQgYFN0YXJ0VGltZWAgLCBBbWF6b24gRUMyIEF1dG8gU2NhbGluZyBwZXJmb3JtcyB0aGUgYWN0aW9uIGF0IHRoaXMgdGltZSwgYW5kIHRoZW4gcGVyZm9ybXMgdGhlIGFjdGlvbiBiYXNlZCBvbiB0aGUgc3BlY2lmaWVkIHJlY3VycmVuY2UuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1hdXRvc2NhbGluZy1zY2hlZHVsZWRhY3Rpb24uaHRtbCNjZm4tYXV0b3NjYWxpbmctc2NoZWR1bGVkYWN0aW9uLXN0YXJ0dGltZVxuICAgICAqL1xuICAgIHB1YmxpYyBzdGFydFRpbWU6IHN0cmluZyB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIFNwZWNpZmllcyB0aGUgdGltZSB6b25lIGZvciBhIGNyb24gZXhwcmVzc2lvbi4gSWYgYSB0aW1lIHpvbmUgaXMgbm90IHByb3ZpZGVkLCBVVEMgaXMgdXNlZCBieSBkZWZhdWx0LlxuICAgICAqXG4gICAgICogVmFsaWQgdmFsdWVzIGFyZSB0aGUgY2Fub25pY2FsIG5hbWVzIG9mIHRoZSBJQU5BIHRpbWUgem9uZXMsIGRlcml2ZWQgZnJvbSB0aGUgSUFOQSBUaW1lIFpvbmUgRGF0YWJhc2UgKHN1Y2ggYXMgYEV0Yy9HTVQrOWAgb3IgYFBhY2lmaWMvVGFoaXRpYCApLiBGb3IgbW9yZSBpbmZvcm1hdGlvbiwgc2VlIFtodHRwczovL2VuLndpa2lwZWRpYS5vcmcvd2lraS9MaXN0X29mX3R6X2RhdGFiYXNlX3RpbWVfem9uZXNdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9odHRwczovL2VuLndpa2lwZWRpYS5vcmcvd2lraS9MaXN0X29mX3R6X2RhdGFiYXNlX3RpbWVfem9uZXMpIC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWF1dG9zY2FsaW5nLXNjaGVkdWxlZGFjdGlvbi5odG1sI2Nmbi1hdXRvc2NhbGluZy1zY2hlZHVsZWRhY3Rpb24tdGltZXpvbmVcbiAgICAgKi9cbiAgICBwdWJsaWMgdGltZVpvbmU6IHN0cmluZyB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIENyZWF0ZSBhIG5ldyBgQVdTOjpBdXRvU2NhbGluZzo6U2NoZWR1bGVkQWN0aW9uYC5cbiAgICAgKlxuICAgICAqIEBwYXJhbSBzY29wZSAtIHNjb3BlIGluIHdoaWNoIHRoaXMgcmVzb3VyY2UgaXMgZGVmaW5lZFxuICAgICAqIEBwYXJhbSBpZCAgICAtIHNjb3BlZCBpZCBvZiB0aGUgcmVzb3VyY2VcbiAgICAgKiBAcGFyYW0gcHJvcHMgLSByZXNvdXJjZSBwcm9wZXJ0aWVzXG4gICAgICovXG4gICAgY29uc3RydWN0b3Ioc2NvcGU6IGNkay5Db25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBDZm5TY2hlZHVsZWRBY3Rpb25Qcm9wcykge1xuICAgICAgICBzdXBlcihzY29wZSwgaWQsIHsgdHlwZTogQ2ZuU2NoZWR1bGVkQWN0aW9uLkNGTl9SRVNPVVJDRV9UWVBFX05BTUUsIHByb3BlcnRpZXM6IHByb3BzIH0pO1xuICAgICAgICBjZGsucmVxdWlyZVByb3BlcnR5KHByb3BzLCAnYXV0b1NjYWxpbmdHcm91cE5hbWUnLCB0aGlzKTtcbiAgICAgICAgdGhpcy5hdHRyU2NoZWR1bGVkQWN0aW9uTmFtZSA9IGNkay5Ub2tlbi5hc1N0cmluZyh0aGlzLmdldEF0dCgnU2NoZWR1bGVkQWN0aW9uTmFtZScpKTtcblxuICAgICAgICB0aGlzLmF1dG9TY2FsaW5nR3JvdXBOYW1lID0gcHJvcHMuYXV0b1NjYWxpbmdHcm91cE5hbWU7XG4gICAgICAgIHRoaXMuZGVzaXJlZENhcGFjaXR5ID0gcHJvcHMuZGVzaXJlZENhcGFjaXR5O1xuICAgICAgICB0aGlzLmVuZFRpbWUgPSBwcm9wcy5lbmRUaW1lO1xuICAgICAgICB0aGlzLm1heFNpemUgPSBwcm9wcy5tYXhTaXplO1xuICAgICAgICB0aGlzLm1pblNpemUgPSBwcm9wcy5taW5TaXplO1xuICAgICAgICB0aGlzLnJlY3VycmVuY2UgPSBwcm9wcy5yZWN1cnJlbmNlO1xuICAgICAgICB0aGlzLnN0YXJ0VGltZSA9IHByb3BzLnN0YXJ0VGltZTtcbiAgICAgICAgdGhpcy50aW1lWm9uZSA9IHByb3BzLnRpbWVab25lO1xuICAgIH1cblxuICAgIC8qKlxuICAgICAqIEV4YW1pbmVzIHRoZSBDbG91ZEZvcm1hdGlvbiByZXNvdXJjZSBhbmQgZGlzY2xvc2VzIGF0dHJpYnV0ZXMuXG4gICAgICpcbiAgICAgKiBAcGFyYW0gaW5zcGVjdG9yIC0gdHJlZSBpbnNwZWN0b3IgdG8gY29sbGVjdCBhbmQgcHJvY2VzcyBhdHRyaWJ1dGVzXG4gICAgICpcbiAgICAgKi9cbiAgICBwdWJsaWMgaW5zcGVjdChpbnNwZWN0b3I6IGNkay5UcmVlSW5zcGVjdG9yKSB7XG4gICAgICAgIGluc3BlY3Rvci5hZGRBdHRyaWJ1dGUoXCJhd3M6Y2RrOmNsb3VkZm9ybWF0aW9uOnR5cGVcIiwgQ2ZuU2NoZWR1bGVkQWN0aW9uLkNGTl9SRVNPVVJDRV9UWVBFX05BTUUpO1xuICAgICAgICBpbnNwZWN0b3IuYWRkQXR0cmlidXRlKFwiYXdzOmNkazpjbG91ZGZvcm1hdGlvbjpwcm9wc1wiLCB0aGlzLmNmblByb3BlcnRpZXMpO1xuICAgIH1cblxuICAgIHByb3RlY3RlZCBnZXQgY2ZuUHJvcGVydGllcygpOiB7IFtrZXk6IHN0cmluZ106IGFueSB9ICB7XG4gICAgICAgIHJldHVybiB7XG4gICAgICAgICAgICBhdXRvU2NhbGluZ0dyb3VwTmFtZTogdGhpcy5hdXRvU2NhbGluZ0dyb3VwTmFtZSxcbiAgICAgICAgICAgIGRlc2lyZWRDYXBhY2l0eTogdGhpcy5kZXNpcmVkQ2FwYWNpdHksXG4gICAgICAgICAgICBlbmRUaW1lOiB0aGlzLmVuZFRpbWUsXG4gICAgICAgICAgICBtYXhTaXplOiB0aGlzLm1heFNpemUsXG4gICAgICAgICAgICBtaW5TaXplOiB0aGlzLm1pblNpemUsXG4gICAgICAgICAgICByZWN1cnJlbmNlOiB0aGlzLnJlY3VycmVuY2UsXG4gICAgICAgICAgICBzdGFydFRpbWU6IHRoaXMuc3RhcnRUaW1lLFxuICAgICAgICAgICAgdGltZVpvbmU6IHRoaXMudGltZVpvbmUsXG4gICAgICAgIH07XG4gICAgfVxuXG4gICAgcHJvdGVjdGVkIHJlbmRlclByb3BlcnRpZXMocHJvcHM6IHtba2V5OiBzdHJpbmddOiBhbnl9KTogeyBba2V5OiBzdHJpbmddOiBhbnkgfSAge1xuICAgICAgICByZXR1cm4gY2ZuU2NoZWR1bGVkQWN0aW9uUHJvcHNUb0Nsb3VkRm9ybWF0aW9uKHByb3BzKTtcbiAgICB9XG59XG5cbi8qKlxuICogUHJvcGVydGllcyBmb3IgZGVmaW5pbmcgYSBgQ2ZuV2FybVBvb2xgXG4gKlxuICogQHN0cnVjdFxuICogQHN0YWJpbGl0eSBleHRlcm5hbFxuICpcbiAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWF1dG9zY2FsaW5nLXdhcm1wb29sLmh0bWxcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBDZm5XYXJtUG9vbFByb3BzIHtcblxuICAgIC8qKlxuICAgICAqIFRoZSBuYW1lIG9mIHRoZSBBdXRvIFNjYWxpbmcgZ3JvdXAuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1hdXRvc2NhbGluZy13YXJtcG9vbC5odG1sI2Nmbi1hdXRvc2NhbGluZy13YXJtcG9vbC1hdXRvc2NhbGluZ2dyb3VwbmFtZVxuICAgICAqL1xuICAgIHJlYWRvbmx5IGF1dG9TY2FsaW5nR3JvdXBOYW1lOiBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBJbmRpY2F0ZXMgd2hldGhlciBpbnN0YW5jZXMgaW4gdGhlIEF1dG8gU2NhbGluZyBncm91cCBjYW4gYmUgcmV0dXJuZWQgdG8gdGhlIHdhcm0gcG9vbCBvbiBzY2FsZSBpbi4gVGhlIGRlZmF1bHQgaXMgdG8gdGVybWluYXRlIGluc3RhbmNlcyBpbiB0aGUgQXV0byBTY2FsaW5nIGdyb3VwIHdoZW4gdGhlIGdyb3VwIHNjYWxlcyBpbi5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWF1dG9zY2FsaW5nLXdhcm1wb29sLmh0bWwjY2ZuLWF1dG9zY2FsaW5nLXdhcm1wb29sLWluc3RhbmNlcmV1c2Vwb2xpY3lcbiAgICAgKi9cbiAgICByZWFkb25seSBpbnN0YW5jZVJldXNlUG9saWN5PzogQ2ZuV2FybVBvb2wuSW5zdGFuY2VSZXVzZVBvbGljeVByb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogU3BlY2lmaWVzIHRoZSBtYXhpbXVtIG51bWJlciBvZiBpbnN0YW5jZXMgdGhhdCBhcmUgYWxsb3dlZCB0byBiZSBpbiB0aGUgd2FybSBwb29sIG9yIGluIGFueSBzdGF0ZSBleGNlcHQgYFRlcm1pbmF0ZWRgIGZvciB0aGUgQXV0byBTY2FsaW5nIGdyb3VwLiBUaGlzIGlzIGFuIG9wdGlvbmFsIHByb3BlcnR5LiBTcGVjaWZ5IGl0IG9ubHkgaWYgeW91IGRvIG5vdCB3YW50IHRoZSB3YXJtIHBvb2wgc2l6ZSB0byBiZSBkZXRlcm1pbmVkIGJ5IHRoZSBkaWZmZXJlbmNlIGJldHdlZW4gdGhlIGdyb3VwJ3MgbWF4aW11bSBjYXBhY2l0eSBhbmQgaXRzIGRlc2lyZWQgY2FwYWNpdHkuXG4gICAgICpcbiAgICAgKiA+IElmIGEgdmFsdWUgZm9yIGBNYXhHcm91cFByZXBhcmVkQ2FwYWNpdHlgIGlzIG5vdCBzcGVjaWZpZWQsIEFtYXpvbiBFQzIgQXV0byBTY2FsaW5nIGxhdW5jaGVzIGFuZCBtYWludGFpbnMgdGhlIGRpZmZlcmVuY2UgYmV0d2VlbiB0aGUgZ3JvdXAncyBtYXhpbXVtIGNhcGFjaXR5IGFuZCBpdHMgZGVzaXJlZCBjYXBhY2l0eS4gSWYgeW91IHNwZWNpZnkgYSB2YWx1ZSBmb3IgYE1heEdyb3VwUHJlcGFyZWRDYXBhY2l0eWAgLCBBbWF6b24gRUMyIEF1dG8gU2NhbGluZyB1c2VzIHRoZSBkaWZmZXJlbmNlIGJldHdlZW4gdGhlIGBNYXhHcm91cFByZXBhcmVkQ2FwYWNpdHlgIGFuZCB0aGUgZGVzaXJlZCBjYXBhY2l0eSBpbnN0ZWFkLlxuICAgICAqID5cbiAgICAgKiA+IFRoZSBzaXplIG9mIHRoZSB3YXJtIHBvb2wgaXMgZHluYW1pYy4gT25seSB3aGVuIGBNYXhHcm91cFByZXBhcmVkQ2FwYWNpdHlgIGFuZCBgTWluU2l6ZWAgYXJlIHNldCB0byB0aGUgc2FtZSB2YWx1ZSBkb2VzIHRoZSB3YXJtIHBvb2wgaGF2ZSBhbiBhYnNvbHV0ZSBzaXplLlxuICAgICAqXG4gICAgICogSWYgdGhlIGRlc2lyZWQgY2FwYWNpdHkgb2YgdGhlIEF1dG8gU2NhbGluZyBncm91cCBpcyBoaWdoZXIgdGhhbiB0aGUgYE1heEdyb3VwUHJlcGFyZWRDYXBhY2l0eWAgLCB0aGUgY2FwYWNpdHkgb2YgdGhlIHdhcm0gcG9vbCBpcyAwLCB1bmxlc3MgeW91IHNwZWNpZnkgYSB2YWx1ZSBmb3IgYE1pblNpemVgIC4gVG8gcmVtb3ZlIGEgdmFsdWUgdGhhdCB5b3UgcHJldmlvdXNseSBzZXQsIGluY2x1ZGUgdGhlIHByb3BlcnR5IGJ1dCBzcGVjaWZ5IC0xIGZvciB0aGUgdmFsdWUuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1hdXRvc2NhbGluZy13YXJtcG9vbC5odG1sI2Nmbi1hdXRvc2NhbGluZy13YXJtcG9vbC1tYXhncm91cHByZXBhcmVkY2FwYWNpdHlcbiAgICAgKi9cbiAgICByZWFkb25seSBtYXhHcm91cFByZXBhcmVkQ2FwYWNpdHk/OiBudW1iZXI7XG5cbiAgICAvKipcbiAgICAgKiBTcGVjaWZpZXMgdGhlIG1pbmltdW0gbnVtYmVyIG9mIGluc3RhbmNlcyB0byBtYWludGFpbiBpbiB0aGUgd2FybSBwb29sLiBUaGlzIGhlbHBzIHlvdSB0byBlbnN1cmUgdGhhdCB0aGVyZSBpcyBhbHdheXMgYSBjZXJ0YWluIG51bWJlciBvZiB3YXJtZWQgaW5zdGFuY2VzIGF2YWlsYWJsZSB0byBoYW5kbGUgdHJhZmZpYyBzcGlrZXMuIERlZmF1bHRzIHRvIDAgaWYgbm90IHNwZWNpZmllZC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWF1dG9zY2FsaW5nLXdhcm1wb29sLmh0bWwjY2ZuLWF1dG9zY2FsaW5nLXdhcm1wb29sLW1pbnNpemVcbiAgICAgKi9cbiAgICByZWFkb25seSBtaW5TaXplPzogbnVtYmVyO1xuXG4gICAgLyoqXG4gICAgICogU2V0cyB0aGUgaW5zdGFuY2Ugc3RhdGUgdG8gdHJhbnNpdGlvbiB0byBhZnRlciB0aGUgbGlmZWN5Y2xlIGFjdGlvbnMgYXJlIGNvbXBsZXRlLiBEZWZhdWx0IGlzIGBTdG9wcGVkYCAuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1hdXRvc2NhbGluZy13YXJtcG9vbC5odG1sI2Nmbi1hdXRvc2NhbGluZy13YXJtcG9vbC1wb29sc3RhdGVcbiAgICAgKi9cbiAgICByZWFkb25seSBwb29sU3RhdGU/OiBzdHJpbmc7XG59XG5cbi8qKlxuICogRGV0ZXJtaW5lIHdoZXRoZXIgdGhlIGdpdmVuIHByb3BlcnRpZXMgbWF0Y2ggdGhvc2Ugb2YgYSBgQ2ZuV2FybVBvb2xQcm9wc2BcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgQ2ZuV2FybVBvb2xQcm9wc2BcbiAqXG4gKiBAcmV0dXJucyB0aGUgcmVzdWx0IG9mIHRoZSB2YWxpZGF0aW9uLlxuICovXG5mdW5jdGlvbiBDZm5XYXJtUG9vbFByb3BzVmFsaWRhdG9yKHByb3BlcnRpZXM6IGFueSk6IGNkay5WYWxpZGF0aW9uUmVzdWx0IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBjZGsuVkFMSURBVElPTl9TVUNDRVNTOyB9XG4gICAgY29uc3QgZXJyb3JzID0gbmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0cygpO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgZXJyb3JzLmNvbGxlY3QobmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0KCdFeHBlY3RlZCBhbiBvYmplY3QsIGJ1dCByZWNlaXZlZDogJyArIEpTT04uc3RyaW5naWZ5KHByb3BlcnRpZXMpKSk7XG4gICAgfVxuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignYXV0b1NjYWxpbmdHcm91cE5hbWUnLCBjZGsucmVxdWlyZWRWYWxpZGF0b3IpKHByb3BlcnRpZXMuYXV0b1NjYWxpbmdHcm91cE5hbWUpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2F1dG9TY2FsaW5nR3JvdXBOYW1lJywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmF1dG9TY2FsaW5nR3JvdXBOYW1lKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdpbnN0YW5jZVJldXNlUG9saWN5JywgQ2ZuV2FybVBvb2xfSW5zdGFuY2VSZXVzZVBvbGljeVByb3BlcnR5VmFsaWRhdG9yKShwcm9wZXJ0aWVzLmluc3RhbmNlUmV1c2VQb2xpY3kpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ21heEdyb3VwUHJlcGFyZWRDYXBhY2l0eScsIGNkay52YWxpZGF0ZU51bWJlcikocHJvcGVydGllcy5tYXhHcm91cFByZXBhcmVkQ2FwYWNpdHkpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ21pblNpemUnLCBjZGsudmFsaWRhdGVOdW1iZXIpKHByb3BlcnRpZXMubWluU2l6ZSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigncG9vbFN0YXRlJywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLnBvb2xTdGF0ZSkpO1xuICAgIHJldHVybiBlcnJvcnMud3JhcCgnc3VwcGxpZWQgcHJvcGVydGllcyBub3QgY29ycmVjdCBmb3IgXCJDZm5XYXJtUG9vbFByb3BzXCInKTtcbn1cblxuLyoqXG4gKiBSZW5kZXJzIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpBdXRvU2NhbGluZzo6V2FybVBvb2xgIHJlc291cmNlXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYENmbldhcm1Qb29sUHJvcHNgXG4gKlxuICogQHJldHVybnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OkF1dG9TY2FsaW5nOjpXYXJtUG9vbGAgcmVzb3VyY2UuXG4gKi9cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBjZm5XYXJtUG9vbFByb3BzVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBhbnkge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIHByb3BlcnRpZXM7IH1cbiAgICBDZm5XYXJtUG9vbFByb3BzVmFsaWRhdG9yKHByb3BlcnRpZXMpLmFzc2VydFN1Y2Nlc3MoKTtcbiAgICByZXR1cm4ge1xuICAgICAgICBBdXRvU2NhbGluZ0dyb3VwTmFtZTogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5hdXRvU2NhbGluZ0dyb3VwTmFtZSksXG4gICAgICAgIEluc3RhbmNlUmV1c2VQb2xpY3k6IGNmbldhcm1Qb29sSW5zdGFuY2VSZXVzZVBvbGljeVByb3BlcnR5VG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLmluc3RhbmNlUmV1c2VQb2xpY3kpLFxuICAgICAgICBNYXhHcm91cFByZXBhcmVkQ2FwYWNpdHk6IGNkay5udW1iZXJUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMubWF4R3JvdXBQcmVwYXJlZENhcGFjaXR5KSxcbiAgICAgICAgTWluU2l6ZTogY2RrLm51bWJlclRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5taW5TaXplKSxcbiAgICAgICAgUG9vbFN0YXRlOiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLnBvb2xTdGF0ZSksXG4gICAgfTtcbn1cblxuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIENmbldhcm1Qb29sUHJvcHNGcm9tQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdDxDZm5XYXJtUG9vbFByb3BzPiB7XG4gICAgcHJvcGVydGllcyA9IHByb3BlcnRpZXMgPT0gbnVsbCA/IHt9IDogcHJvcGVydGllcztcbiAgICBpZiAodHlwZW9mIHByb3BlcnRpZXMgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIHJldHVybiBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdChwcm9wZXJ0aWVzKTtcbiAgICB9XG4gICAgY29uc3QgcmV0ID0gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25Qcm9wZXJ0eU9iamVjdDxDZm5XYXJtUG9vbFByb3BzPigpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnYXV0b1NjYWxpbmdHcm91cE5hbWUnLCAnQXV0b1NjYWxpbmdHcm91cE5hbWUnLCBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLkF1dG9TY2FsaW5nR3JvdXBOYW1lKSk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdpbnN0YW5jZVJldXNlUG9saWN5JywgJ0luc3RhbmNlUmV1c2VQb2xpY3knLCBwcm9wZXJ0aWVzLkluc3RhbmNlUmV1c2VQb2xpY3kgIT0gbnVsbCA/IENmbldhcm1Qb29sSW5zdGFuY2VSZXVzZVBvbGljeVByb3BlcnR5RnJvbUNsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuSW5zdGFuY2VSZXVzZVBvbGljeSkgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnbWF4R3JvdXBQcmVwYXJlZENhcGFjaXR5JywgJ01heEdyb3VwUHJlcGFyZWRDYXBhY2l0eScsIHByb3BlcnRpZXMuTWF4R3JvdXBQcmVwYXJlZENhcGFjaXR5ICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldE51bWJlcihwcm9wZXJ0aWVzLk1heEdyb3VwUHJlcGFyZWRDYXBhY2l0eSkgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnbWluU2l6ZScsICdNaW5TaXplJywgcHJvcGVydGllcy5NaW5TaXplICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldE51bWJlcihwcm9wZXJ0aWVzLk1pblNpemUpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ3Bvb2xTdGF0ZScsICdQb29sU3RhdGUnLCBwcm9wZXJ0aWVzLlBvb2xTdGF0ZSAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5Qb29sU3RhdGUpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkVW5yZWNvZ25pemVkUHJvcGVydGllc0FzRXh0cmEocHJvcGVydGllcyk7XG4gICAgcmV0dXJuIHJldDtcbn1cblxuLyoqXG4gKiBBIENsb3VkRm9ybWF0aW9uIGBBV1M6OkF1dG9TY2FsaW5nOjpXYXJtUG9vbGBcbiAqXG4gKiBUaGUgYEFXUzo6QXV0b1NjYWxpbmc6Oldhcm1Qb29sYCByZXNvdXJjZSBjcmVhdGVzIGEgcG9vbCBvZiBwcmUtaW5pdGlhbGl6ZWQgRUMyIGluc3RhbmNlcyB0aGF0IHNpdHMgYWxvbmdzaWRlIHRoZSBBdXRvIFNjYWxpbmcgZ3JvdXAuIFdoZW5ldmVyIHlvdXIgYXBwbGljYXRpb24gbmVlZHMgdG8gc2NhbGUgb3V0LCB0aGUgQXV0byBTY2FsaW5nIGdyb3VwIGNhbiBkcmF3IG9uIHRoZSB3YXJtIHBvb2wgdG8gbWVldCBpdHMgbmV3IGRlc2lyZWQgY2FwYWNpdHkuXG4gKlxuICogV2hlbiB5b3UgY3JlYXRlIGEgd2FybSBwb29sLCB5b3UgY2FuIGRlZmluZSBhIG1pbmltdW0gc2l6ZS4gV2hlbiB5b3VyIEF1dG8gU2NhbGluZyBncm91cCBzY2FsZXMgb3V0IGFuZCB0aGUgc2l6ZSBvZiB0aGUgd2FybSBwb29sIHNocmlua3MsIEFtYXpvbiBFQzIgQXV0byBTY2FsaW5nIGxhdW5jaGVzIG5ldyBpbnN0YW5jZXMgaW50byB0aGUgd2FybSBwb29sIHRvIG1haW50YWluIGl0cyBtaW5pbXVtIHNpemUuXG4gKlxuICogRm9yIG1vcmUgaW5mb3JtYXRpb24sIHNlZSBbV2FybSBwb29scyBmb3IgQW1hem9uIEVDMiBBdXRvIFNjYWxpbmddKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9hdXRvc2NhbGluZy9lYzIvdXNlcmd1aWRlL2VjMi1hdXRvLXNjYWxpbmctd2FybS1wb29scy5odG1sKSBpbiB0aGUgKkFtYXpvbiBFQzIgQXV0byBTY2FsaW5nIFVzZXIgR3VpZGUqIC5cbiAqXG4gKiA+IENsb3VkRm9ybWF0aW9uIHN1cHBvcnRzIHRoZSBgVXBkYXRlUG9saWN5YCBhdHRyaWJ1dGUgZm9yIEF1dG8gU2NhbGluZyBncm91cHMuIER1cmluZyBhbiB1cGRhdGUsIGlmIGBVcGRhdGVQb2xpY3lgIGlzIHNldCB0byBgQXV0b1NjYWxpbmdSb2xsaW5nVXBkYXRlYCAsIENsb3VkRm9ybWF0aW9uIHJlcGxhY2VzIGBJblNlcnZpY2VgIGluc3RhbmNlcyBvbmx5LiBJbnN0YW5jZXMgaW4gdGhlIHdhcm0gcG9vbCBhcmUgbm90IHJlcGxhY2VkLiBUaGUgZGlmZmVyZW5jZSBpbiB3aGljaCBpbnN0YW5jZXMgYXJlIHJlcGxhY2VkIGNhbiBwb3RlbnRpYWxseSByZXN1bHQgaW4gZGlmZmVyZW50IGluc3RhbmNlIGNvbmZpZ3VyYXRpb25zIGFmdGVyIHRoZSBzdGFjayB1cGRhdGUgY29tcGxldGVzLiBJZiBgVXBkYXRlUG9saWN5YCBpcyBzZXQgdG8gYEF1dG9TY2FsaW5nUmVwbGFjaW5nVXBkYXRlYCAsIHlvdSBkbyBub3QgZW5jb3VudGVyIHRoaXMgaXNzdWUgYmVjYXVzZSBDbG91ZEZvcm1hdGlvbiByZXBsYWNlcyBib3RoIHRoZSBBdXRvIFNjYWxpbmcgZ3JvdXAgYW5kIHRoZSB3YXJtIHBvb2wuXG4gKlxuICogQGNsb3VkZm9ybWF0aW9uUmVzb3VyY2UgQVdTOjpBdXRvU2NhbGluZzo6V2FybVBvb2xcbiAqIEBzdGFiaWxpdHkgZXh0ZXJuYWxcbiAqXG4gKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1hdXRvc2NhbGluZy13YXJtcG9vbC5odG1sXG4gKi9cbmV4cG9ydCBjbGFzcyBDZm5XYXJtUG9vbCBleHRlbmRzIGNkay5DZm5SZXNvdXJjZSBpbXBsZW1lbnRzIGNkay5JSW5zcGVjdGFibGUge1xuICAgIC8qKlxuICAgICAqIFRoZSBDbG91ZEZvcm1hdGlvbiByZXNvdXJjZSB0eXBlIG5hbWUgZm9yIHRoaXMgcmVzb3VyY2UgY2xhc3MuXG4gICAgICovXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBDRk5fUkVTT1VSQ0VfVFlQRV9OQU1FID0gXCJBV1M6OkF1dG9TY2FsaW5nOjpXYXJtUG9vbFwiO1xuXG4gICAgLyoqXG4gICAgICogQSBmYWN0b3J5IG1ldGhvZCB0aGF0IGNyZWF0ZXMgYSBuZXcgaW5zdGFuY2Ugb2YgdGhpcyBjbGFzcyBmcm9tIGFuIG9iamVjdFxuICAgICAqIGNvbnRhaW5pbmcgdGhlIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgdGhpcyByZXNvdXJjZS5cbiAgICAgKiBVc2VkIGluIHRoZSBAYXdzLWNkay9jbG91ZGZvcm1hdGlvbi1pbmNsdWRlIG1vZHVsZS5cbiAgICAgKlxuICAgICAqIEBpbnRlcm5hbFxuICAgICAqL1xuICAgIHB1YmxpYyBzdGF0aWMgX2Zyb21DbG91ZEZvcm1hdGlvbihzY29wZTogY2RrLkNvbnN0cnVjdCwgaWQ6IHN0cmluZywgcmVzb3VyY2VBdHRyaWJ1dGVzOiBhbnksIG9wdGlvbnM6IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25PcHRpb25zKTogQ2ZuV2FybVBvb2wge1xuICAgICAgICByZXNvdXJjZUF0dHJpYnV0ZXMgPSByZXNvdXJjZUF0dHJpYnV0ZXMgfHwge307XG4gICAgICAgIGNvbnN0IHJlc291cmNlUHJvcGVydGllcyA9IG9wdGlvbnMucGFyc2VyLnBhcnNlVmFsdWUocmVzb3VyY2VBdHRyaWJ1dGVzLlByb3BlcnRpZXMpO1xuICAgICAgICBjb25zdCBwcm9wc1Jlc3VsdCA9IENmbldhcm1Qb29sUHJvcHNGcm9tQ2xvdWRGb3JtYXRpb24ocmVzb3VyY2VQcm9wZXJ0aWVzKTtcbiAgICAgICAgY29uc3QgcmV0ID0gbmV3IENmbldhcm1Qb29sKHNjb3BlLCBpZCwgcHJvcHNSZXN1bHQudmFsdWUpO1xuICAgICAgICBmb3IgKGNvbnN0IFtwcm9wS2V5LCBwcm9wVmFsXSBvZiBPYmplY3QuZW50cmllcyhwcm9wc1Jlc3VsdC5leHRyYVByb3BlcnRpZXMpKSAge1xuICAgICAgICAgICAgcmV0LmFkZFByb3BlcnR5T3ZlcnJpZGUocHJvcEtleSwgcHJvcFZhbCk7XG4gICAgICAgIH1cbiAgICAgICAgb3B0aW9ucy5wYXJzZXIuaGFuZGxlQXR0cmlidXRlcyhyZXQsIHJlc291cmNlQXR0cmlidXRlcywgaWQpO1xuICAgICAgICByZXR1cm4gcmV0O1xuICAgIH1cblxuICAgIC8qKlxuICAgICAqIFRoZSBuYW1lIG9mIHRoZSBBdXRvIFNjYWxpbmcgZ3JvdXAuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1hdXRvc2NhbGluZy13YXJtcG9vbC5odG1sI2Nmbi1hdXRvc2NhbGluZy13YXJtcG9vbC1hdXRvc2NhbGluZ2dyb3VwbmFtZVxuICAgICAqL1xuICAgIHB1YmxpYyBhdXRvU2NhbGluZ0dyb3VwTmFtZTogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogSW5kaWNhdGVzIHdoZXRoZXIgaW5zdGFuY2VzIGluIHRoZSBBdXRvIFNjYWxpbmcgZ3JvdXAgY2FuIGJlIHJldHVybmVkIHRvIHRoZSB3YXJtIHBvb2wgb24gc2NhbGUgaW4uIFRoZSBkZWZhdWx0IGlzIHRvIHRlcm1pbmF0ZSBpbnN0YW5jZXMgaW4gdGhlIEF1dG8gU2NhbGluZyBncm91cCB3aGVuIHRoZSBncm91cCBzY2FsZXMgaW4uXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1hdXRvc2NhbGluZy13YXJtcG9vbC5odG1sI2Nmbi1hdXRvc2NhbGluZy13YXJtcG9vbC1pbnN0YW5jZXJldXNlcG9saWN5XG4gICAgICovXG4gICAgcHVibGljIGluc3RhbmNlUmV1c2VQb2xpY3k6IENmbldhcm1Qb29sLkluc3RhbmNlUmV1c2VQb2xpY3lQcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZSB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIFNwZWNpZmllcyB0aGUgbWF4aW11bSBudW1iZXIgb2YgaW5zdGFuY2VzIHRoYXQgYXJlIGFsbG93ZWQgdG8gYmUgaW4gdGhlIHdhcm0gcG9vbCBvciBpbiBhbnkgc3RhdGUgZXhjZXB0IGBUZXJtaW5hdGVkYCBmb3IgdGhlIEF1dG8gU2NhbGluZyBncm91cC4gVGhpcyBpcyBhbiBvcHRpb25hbCBwcm9wZXJ0eS4gU3BlY2lmeSBpdCBvbmx5IGlmIHlvdSBkbyBub3Qgd2FudCB0aGUgd2FybSBwb29sIHNpemUgdG8gYmUgZGV0ZXJtaW5lZCBieSB0aGUgZGlmZmVyZW5jZSBiZXR3ZWVuIHRoZSBncm91cCdzIG1heGltdW0gY2FwYWNpdHkgYW5kIGl0cyBkZXNpcmVkIGNhcGFjaXR5LlxuICAgICAqXG4gICAgICogPiBJZiBhIHZhbHVlIGZvciBgTWF4R3JvdXBQcmVwYXJlZENhcGFjaXR5YCBpcyBub3Qgc3BlY2lmaWVkLCBBbWF6b24gRUMyIEF1dG8gU2NhbGluZyBsYXVuY2hlcyBhbmQgbWFpbnRhaW5zIHRoZSBkaWZmZXJlbmNlIGJldHdlZW4gdGhlIGdyb3VwJ3MgbWF4aW11bSBjYXBhY2l0eSBhbmQgaXRzIGRlc2lyZWQgY2FwYWNpdHkuIElmIHlvdSBzcGVjaWZ5IGEgdmFsdWUgZm9yIGBNYXhHcm91cFByZXBhcmVkQ2FwYWNpdHlgICwgQW1hem9uIEVDMiBBdXRvIFNjYWxpbmcgdXNlcyB0aGUgZGlmZmVyZW5jZSBiZXR3ZWVuIHRoZSBgTWF4R3JvdXBQcmVwYXJlZENhcGFjaXR5YCBhbmQgdGhlIGRlc2lyZWQgY2FwYWNpdHkgaW5zdGVhZC5cbiAgICAgKiA+XG4gICAgICogPiBUaGUgc2l6ZSBvZiB0aGUgd2FybSBwb29sIGlzIGR5bmFtaWMuIE9ubHkgd2hlbiBgTWF4R3JvdXBQcmVwYXJlZENhcGFjaXR5YCBhbmQgYE1pblNpemVgIGFyZSBzZXQgdG8gdGhlIHNhbWUgdmFsdWUgZG9lcyB0aGUgd2FybSBwb29sIGhhdmUgYW4gYWJzb2x1dGUgc2l6ZS5cbiAgICAgKlxuICAgICAqIElmIHRoZSBkZXNpcmVkIGNhcGFjaXR5IG9mIHRoZSBBdXRvIFNjYWxpbmcgZ3JvdXAgaXMgaGlnaGVyIHRoYW4gdGhlIGBNYXhHcm91cFByZXBhcmVkQ2FwYWNpdHlgICwgdGhlIGNhcGFjaXR5IG9mIHRoZSB3YXJtIHBvb2wgaXMgMCwgdW5sZXNzIHlvdSBzcGVjaWZ5IGEgdmFsdWUgZm9yIGBNaW5TaXplYCAuIFRvIHJlbW92ZSBhIHZhbHVlIHRoYXQgeW91IHByZXZpb3VzbHkgc2V0LCBpbmNsdWRlIHRoZSBwcm9wZXJ0eSBidXQgc3BlY2lmeSAtMSBmb3IgdGhlIHZhbHVlLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtYXV0b3NjYWxpbmctd2FybXBvb2wuaHRtbCNjZm4tYXV0b3NjYWxpbmctd2FybXBvb2wtbWF4Z3JvdXBwcmVwYXJlZGNhcGFjaXR5XG4gICAgICovXG4gICAgcHVibGljIG1heEdyb3VwUHJlcGFyZWRDYXBhY2l0eTogbnVtYmVyIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogU3BlY2lmaWVzIHRoZSBtaW5pbXVtIG51bWJlciBvZiBpbnN0YW5jZXMgdG8gbWFpbnRhaW4gaW4gdGhlIHdhcm0gcG9vbC4gVGhpcyBoZWxwcyB5b3UgdG8gZW5zdXJlIHRoYXQgdGhlcmUgaXMgYWx3YXlzIGEgY2VydGFpbiBudW1iZXIgb2Ygd2FybWVkIGluc3RhbmNlcyBhdmFpbGFibGUgdG8gaGFuZGxlIHRyYWZmaWMgc3Bpa2VzLiBEZWZhdWx0cyB0byAwIGlmIG5vdCBzcGVjaWZpZWQuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1hdXRvc2NhbGluZy13YXJtcG9vbC5odG1sI2Nmbi1hdXRvc2NhbGluZy13YXJtcG9vbC1taW5zaXplXG4gICAgICovXG4gICAgcHVibGljIG1pblNpemU6IG51bWJlciB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIFNldHMgdGhlIGluc3RhbmNlIHN0YXRlIHRvIHRyYW5zaXRpb24gdG8gYWZ0ZXIgdGhlIGxpZmVjeWNsZSBhY3Rpb25zIGFyZSBjb21wbGV0ZS4gRGVmYXVsdCBpcyBgU3RvcHBlZGAgLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtYXV0b3NjYWxpbmctd2FybXBvb2wuaHRtbCNjZm4tYXV0b3NjYWxpbmctd2FybXBvb2wtcG9vbHN0YXRlXG4gICAgICovXG4gICAgcHVibGljIHBvb2xTdGF0ZTogc3RyaW5nIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogQ3JlYXRlIGEgbmV3IGBBV1M6OkF1dG9TY2FsaW5nOjpXYXJtUG9vbGAuXG4gICAgICpcbiAgICAgKiBAcGFyYW0gc2NvcGUgLSBzY29wZSBpbiB3aGljaCB0aGlzIHJlc291cmNlIGlzIGRlZmluZWRcbiAgICAgKiBAcGFyYW0gaWQgICAgLSBzY29wZWQgaWQgb2YgdGhlIHJlc291cmNlXG4gICAgICogQHBhcmFtIHByb3BzIC0gcmVzb3VyY2UgcHJvcGVydGllc1xuICAgICAqL1xuICAgIGNvbnN0cnVjdG9yKHNjb3BlOiBjZGsuQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogQ2ZuV2FybVBvb2xQcm9wcykge1xuICAgICAgICBzdXBlcihzY29wZSwgaWQsIHsgdHlwZTogQ2ZuV2FybVBvb2wuQ0ZOX1JFU09VUkNFX1RZUEVfTkFNRSwgcHJvcGVydGllczogcHJvcHMgfSk7XG4gICAgICAgIGNkay5yZXF1aXJlUHJvcGVydHkocHJvcHMsICdhdXRvU2NhbGluZ0dyb3VwTmFtZScsIHRoaXMpO1xuXG4gICAgICAgIHRoaXMuYXV0b1NjYWxpbmdHcm91cE5hbWUgPSBwcm9wcy5hdXRvU2NhbGluZ0dyb3VwTmFtZTtcbiAgICAgICAgdGhpcy5pbnN0YW5jZVJldXNlUG9saWN5ID0gcHJvcHMuaW5zdGFuY2VSZXVzZVBvbGljeTtcbiAgICAgICAgdGhpcy5tYXhHcm91cFByZXBhcmVkQ2FwYWNpdHkgPSBwcm9wcy5tYXhHcm91cFByZXBhcmVkQ2FwYWNpdHk7XG4gICAgICAgIHRoaXMubWluU2l6ZSA9IHByb3BzLm1pblNpemU7XG4gICAgICAgIHRoaXMucG9vbFN0YXRlID0gcHJvcHMucG9vbFN0YXRlO1xuICAgIH1cblxuICAgIC8qKlxuICAgICAqIEV4YW1pbmVzIHRoZSBDbG91ZEZvcm1hdGlvbiByZXNvdXJjZSBhbmQgZGlzY2xvc2VzIGF0dHJpYnV0ZXMuXG4gICAgICpcbiAgICAgKiBAcGFyYW0gaW5zcGVjdG9yIC0gdHJlZSBpbnNwZWN0b3IgdG8gY29sbGVjdCBhbmQgcHJvY2VzcyBhdHRyaWJ1dGVzXG4gICAgICpcbiAgICAgKi9cbiAgICBwdWJsaWMgaW5zcGVjdChpbnNwZWN0b3I6IGNkay5UcmVlSW5zcGVjdG9yKSB7XG4gICAgICAgIGluc3BlY3Rvci5hZGRBdHRyaWJ1dGUoXCJhd3M6Y2RrOmNsb3VkZm9ybWF0aW9uOnR5cGVcIiwgQ2ZuV2FybVBvb2wuQ0ZOX1JFU09VUkNFX1RZUEVfTkFNRSk7XG4gICAgICAgIGluc3BlY3Rvci5hZGRBdHRyaWJ1dGUoXCJhd3M6Y2RrOmNsb3VkZm9ybWF0aW9uOnByb3BzXCIsIHRoaXMuY2ZuUHJvcGVydGllcyk7XG4gICAgfVxuXG4gICAgcHJvdGVjdGVkIGdldCBjZm5Qcm9wZXJ0aWVzKCk6IHsgW2tleTogc3RyaW5nXTogYW55IH0gIHtcbiAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICAgIGF1dG9TY2FsaW5nR3JvdXBOYW1lOiB0aGlzLmF1dG9TY2FsaW5nR3JvdXBOYW1lLFxuICAgICAgICAgICAgaW5zdGFuY2VSZXVzZVBvbGljeTogdGhpcy5pbnN0YW5jZVJldXNlUG9saWN5LFxuICAgICAgICAgICAgbWF4R3JvdXBQcmVwYXJlZENhcGFjaXR5OiB0aGlzLm1heEdyb3VwUHJlcGFyZWRDYXBhY2l0eSxcbiAgICAgICAgICAgIG1pblNpemU6IHRoaXMubWluU2l6ZSxcbiAgICAgICAgICAgIHBvb2xTdGF0ZTogdGhpcy5wb29sU3RhdGUsXG4gICAgICAgIH07XG4gICAgfVxuXG4gICAgcHJvdGVjdGVkIHJlbmRlclByb3BlcnRpZXMocHJvcHM6IHtba2V5OiBzdHJpbmddOiBhbnl9KTogeyBba2V5OiBzdHJpbmddOiBhbnkgfSAge1xuICAgICAgICByZXR1cm4gY2ZuV2FybVBvb2xQcm9wc1RvQ2xvdWRGb3JtYXRpb24ocHJvcHMpO1xuICAgIH1cbn1cblxuZXhwb3J0IG5hbWVzcGFjZSBDZm5XYXJtUG9vbCB7XG4gICAgLyoqXG4gICAgICogQSBzdHJ1Y3R1cmUgdGhhdCBzcGVjaWZpZXMgYW4gaW5zdGFuY2UgcmV1c2UgcG9saWN5IGZvciB0aGUgYEluc3RhbmNlUmV1c2VQb2xpY3lgIHByb3BlcnR5IG9mIHRoZSBbQVdTOjpBdXRvU2NhbGluZzo6V2FybVBvb2xdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1hdXRvc2NhbGluZy13YXJtcG9vbC5odG1sKSByZXNvdXJjZS5cbiAgICAgKlxuICAgICAqIEZvciBtb3JlIGluZm9ybWF0aW9uLCBzZWUgW1dhcm0gcG9vbHMgZm9yIEFtYXpvbiBFQzIgQXV0byBTY2FsaW5nXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vYXV0b3NjYWxpbmcvZWMyL3VzZXJndWlkZS9lYzItYXV0by1zY2FsaW5nLXdhcm0tcG9vbHMuaHRtbCkgaW4gdGhlICpBbWF6b24gRUMyIEF1dG8gU2NhbGluZyBVc2VyIEd1aWRlKiAuXG4gICAgICpcbiAgICAgKiBAc3RydWN0XG4gICAgICogQHN0YWJpbGl0eSBleHRlcm5hbFxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hdXRvc2NhbGluZy13YXJtcG9vbC1pbnN0YW5jZXJldXNlcG9saWN5Lmh0bWxcbiAgICAgKi9cbiAgICBleHBvcnQgaW50ZXJmYWNlIEluc3RhbmNlUmV1c2VQb2xpY3lQcm9wZXJ0eSB7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBTcGVjaWZpZXMgd2hldGhlciBpbnN0YW5jZXMgaW4gdGhlIEF1dG8gU2NhbGluZyBncm91cCBjYW4gYmUgcmV0dXJuZWQgdG8gdGhlIHdhcm0gcG9vbCBvbiBzY2FsZSBpbi5cbiAgICAgICAgICpcbiAgICAgICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hdXRvc2NhbGluZy13YXJtcG9vbC1pbnN0YW5jZXJldXNlcG9saWN5Lmh0bWwjY2ZuLWF1dG9zY2FsaW5nLXdhcm1wb29sLWluc3RhbmNlcmV1c2Vwb2xpY3ktcmV1c2VvbnNjYWxlaW5cbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IHJldXNlT25TY2FsZUluPzogYm9vbGVhbiB8IGNkay5JUmVzb2x2YWJsZTtcbiAgICB9XG59XG5cbi8qKlxuICogRGV0ZXJtaW5lIHdoZXRoZXIgdGhlIGdpdmVuIHByb3BlcnRpZXMgbWF0Y2ggdGhvc2Ugb2YgYSBgSW5zdGFuY2VSZXVzZVBvbGljeVByb3BlcnR5YFxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBJbnN0YW5jZVJldXNlUG9saWN5UHJvcGVydHlgXG4gKlxuICogQHJldHVybnMgdGhlIHJlc3VsdCBvZiB0aGUgdmFsaWRhdGlvbi5cbiAqL1xuZnVuY3Rpb24gQ2ZuV2FybVBvb2xfSW5zdGFuY2VSZXVzZVBvbGljeVByb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXM6IGFueSk6IGNkay5WYWxpZGF0aW9uUmVzdWx0IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBjZGsuVkFMSURBVElPTl9TVUNDRVNTOyB9XG4gICAgY29uc3QgZXJyb3JzID0gbmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0cygpO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgZXJyb3JzLmNvbGxlY3QobmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0KCdFeHBlY3RlZCBhbiBvYmplY3QsIGJ1dCByZWNlaXZlZDogJyArIEpTT04uc3RyaW5naWZ5KHByb3BlcnRpZXMpKSk7XG4gICAgfVxuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigncmV1c2VPblNjYWxlSW4nLCBjZGsudmFsaWRhdGVCb29sZWFuKShwcm9wZXJ0aWVzLnJldXNlT25TY2FsZUluKSk7XG4gICAgcmV0dXJuIGVycm9ycy53cmFwKCdzdXBwbGllZCBwcm9wZXJ0aWVzIG5vdCBjb3JyZWN0IGZvciBcIkluc3RhbmNlUmV1c2VQb2xpY3lQcm9wZXJ0eVwiJyk7XG59XG5cbi8qKlxuICogUmVuZGVycyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6QXV0b1NjYWxpbmc6Oldhcm1Qb29sLkluc3RhbmNlUmV1c2VQb2xpY3lgIHJlc291cmNlXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYEluc3RhbmNlUmV1c2VQb2xpY3lQcm9wZXJ0eWBcbiAqXG4gKiBAcmV0dXJucyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6QXV0b1NjYWxpbmc6Oldhcm1Qb29sLkluc3RhbmNlUmV1c2VQb2xpY3lgIHJlc291cmNlLlxuICovXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gY2ZuV2FybVBvb2xJbnN0YW5jZVJldXNlUG9saWN5UHJvcGVydHlUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGFueSB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gcHJvcGVydGllczsgfVxuICAgIENmbldhcm1Qb29sX0luc3RhbmNlUmV1c2VQb2xpY3lQcm9wZXJ0eVZhbGlkYXRvcihwcm9wZXJ0aWVzKS5hc3NlcnRTdWNjZXNzKCk7XG4gICAgcmV0dXJuIHtcbiAgICAgICAgUmV1c2VPblNjYWxlSW46IGNkay5ib29sZWFuVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLnJldXNlT25TY2FsZUluKSxcbiAgICB9O1xufVxuXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gQ2ZuV2FybVBvb2xJbnN0YW5jZVJldXNlUG9saWN5UHJvcGVydHlGcm9tQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdDxDZm5XYXJtUG9vbC5JbnN0YW5jZVJldXNlUG9saWN5UHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGU+IHtcbiAgICBpZiAoY2RrLmlzUmVzb2x2YWJsZU9iamVjdChwcm9wZXJ0aWVzKSkge1xuICAgICAgICByZXR1cm4gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQocHJvcGVydGllcyk7XG4gICAgfVxuICAgIHByb3BlcnRpZXMgPSBwcm9wZXJ0aWVzID09IG51bGwgPyB7fSA6IHByb3BlcnRpZXM7XG4gICAgaWYgKHR5cGVvZiBwcm9wZXJ0aWVzICE9PSAnb2JqZWN0Jykge1xuICAgICAgICByZXR1cm4gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQocHJvcGVydGllcyk7XG4gICAgfVxuICAgIGNvbnN0IHJldCA9IG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUHJvcGVydHlPYmplY3Q8Q2ZuV2FybVBvb2wuSW5zdGFuY2VSZXVzZVBvbGljeVByb3BlcnR5PigpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgncmV1c2VPblNjYWxlSW4nLCAnUmV1c2VPblNjYWxlSW4nLCBwcm9wZXJ0aWVzLlJldXNlT25TY2FsZUluICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldEJvb2xlYW4ocHJvcGVydGllcy5SZXVzZU9uU2NhbGVJbikgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRVbnJlY29nbml6ZWRQcm9wZXJ0aWVzQXNFeHRyYShwcm9wZXJ0aWVzKTtcbiAgICByZXR1cm4gcmV0O1xufVxuIl19