"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ScheduledAction = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core");
const autoscaling_generated_1 = require("./autoscaling.generated");
/**
 * Define a scheduled scaling action
 */
class ScheduledAction extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings.monocdk_aws_autoscaling_ScheduledActionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, ScheduledAction);
            }
            throw error;
        }
        if (props.minCapacity === undefined && props.maxCapacity === undefined && props.desiredCapacity === undefined) {
            throw new Error('At least one of minCapacity, maxCapacity, or desiredCapacity is required');
        }
        // add a warning on synth when minute is not defined in a cron schedule
        props.schedule._bind(this);
        const resource = new autoscaling_generated_1.CfnScheduledAction(this, 'Resource', {
            autoScalingGroupName: props.autoScalingGroup.autoScalingGroupName,
            startTime: formatISO(props.startTime),
            endTime: formatISO(props.endTime),
            minSize: props.minCapacity,
            maxSize: props.maxCapacity,
            desiredCapacity: props.desiredCapacity,
            recurrence: props.schedule.expressionString,
            timeZone: props.timeZone,
        });
        this.scheduledActionName = resource.attrScheduledActionName;
    }
}
exports.ScheduledAction = ScheduledAction;
_a = JSII_RTTI_SYMBOL_1;
ScheduledAction[_a] = { fqn: "monocdk.aws_autoscaling.ScheduledAction", version: "1.191.0" };
function formatISO(date) {
    if (!date) {
        return undefined;
    }
    return date.getUTCFullYear() +
        '-' + pad(date.getUTCMonth() + 1) +
        '-' + pad(date.getUTCDate()) +
        'T' + pad(date.getUTCHours()) +
        ':' + pad(date.getUTCMinutes()) +
        ':' + pad(date.getUTCSeconds()) +
        'Z';
    function pad(num) {
        if (num < 10) {
            return '0' + num;
        }
        return num;
    }
}
//# sourceMappingURL=data:application/json;base64,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