"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const ec2 = require("../../aws-ec2");
/// !show
// Pick a Windows edition to use
const windows = new ec2.WindowsImage(ec2.WindowsVersion.WINDOWS_SERVER_2019_ENGLISH_FULL_BASE);
// Pick the right Amazon Linux edition. All arguments shown are optional
// and will default to these values when omitted.
const amznLinux = new ec2.AmazonLinuxImage({
    generation: ec2.AmazonLinuxGeneration.AMAZON_LINUX,
    edition: ec2.AmazonLinuxEdition.STANDARD,
    virtualization: ec2.AmazonLinuxVirt.HVM,
    storage: ec2.AmazonLinuxStorage.GENERAL_PURPOSE,
});
// For other custom (Linux) images, instantiate a `GenericLinuxImage` with
// a map giving the AMI to in for each region:
const linux = new ec2.GenericLinuxImage({
    'us-east-1': 'ami-97785bed',
    'eu-west-1': 'ami-12345678',
});
/// !hide
Array.isArray(windows);
Array.isArray(amznLinux);
Array.isArray(linux);
//# sourceMappingURL=data:application/json;base64,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