"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BackupSelection = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("../../aws-iam");
const core_1 = require("../../core");
const backup_generated_1 = require("./backup.generated");
const backupable_resources_collector_1 = require("./backupable-resources-collector");
const resource_1 = require("./resource");
/**
 * A backup selection
 */
class BackupSelection extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        this.listOfTags = [];
        this.resources = [];
        this.backupableResourcesCollector = new backupable_resources_collector_1.BackupableResourcesCollector();
        try {
            jsiiDeprecationWarnings.monocdk_aws_backup_BackupSelectionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, BackupSelection);
            }
            throw error;
        }
        const role = props.role || new iam.Role(this, 'Role', {
            assumedBy: new iam.ServicePrincipal('backup.amazonaws.com'),
        });
        role.addManagedPolicy(iam.ManagedPolicy.fromAwsManagedPolicyName('service-role/AWSBackupServiceRolePolicyForBackup'));
        if (props.allowRestores) {
            role.addManagedPolicy(iam.ManagedPolicy.fromAwsManagedPolicyName('service-role/AWSBackupServiceRolePolicyForRestores'));
        }
        this.grantPrincipal = role;
        const selection = new backup_generated_1.CfnBackupSelection(this, 'Resource', {
            backupPlanId: props.backupPlan.backupPlanId,
            backupSelection: {
                iamRoleArn: role.roleArn,
                selectionName: props.backupSelectionName || this.node.id,
                listOfTags: core_1.Lazy.any({
                    produce: () => this.listOfTags,
                }, { omitEmptyArray: true }),
                resources: core_1.Lazy.list({
                    produce: () => [...this.resources, ...this.backupableResourcesCollector.resources],
                }, { omitEmpty: true }),
            },
        });
        this.backupPlanId = selection.attrBackupPlanId;
        this.selectionId = selection.attrSelectionId;
        for (const resource of props.resources) {
            this.addResource(resource);
        }
    }
    addResource(resource) {
        if (resource.tagCondition) {
            this.listOfTags.push({
                conditionKey: resource.tagCondition.key,
                conditionType: resource.tagCondition.operation || resource_1.TagOperation.STRING_EQUALS,
                conditionValue: resource.tagCondition.value,
            });
        }
        if (resource.resource) {
            this.resources.push(resource.resource);
        }
        if (resource.construct) {
            core_1.Aspects.of(resource.construct).add(this.backupableResourcesCollector);
            // Cannot push `this.backupableResourcesCollector.resources` to
            // `this.resources` here because it has not been evaluated yet.
            // Will be concatenated to `this.resources` in a `Lazy.list`
            // in the constructor instead.
        }
    }
}
exports.BackupSelection = BackupSelection;
_a = JSII_RTTI_SYMBOL_1;
BackupSelection[_a] = { fqn: "monocdk.aws_backup.BackupSelection", version: "1.191.0" };
//# sourceMappingURL=data:application/json;base64,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