"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExposedSecret = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Exposed secret for log configuration
 */
class ExposedSecret {
    constructor(optionName, secretArn) {
        this.optionName = optionName;
        this.secretArn = secretArn;
    }
    /**
     * Use Secrets Manager Secret
     * @param optionName - The name of the option
     * @param secret - A secret from secrets manager
     */
    static fromSecretsManager(optionName, secret) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_secretsmanager_ISecret(secret);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromSecretsManager);
            }
            throw error;
        }
        return new ExposedSecret(optionName, secret.secretArn);
    }
    /**
     * User Parameters Store Parameter
     * @param optionName - The name of the option
     * @param parameter - A parameter from parameters store
     */
    static fromParametersStore(optionName, parameter) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_ssm_IParameter(parameter);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromParametersStore);
            }
            throw error;
        }
        return new ExposedSecret(optionName, parameter.parameterArn);
    }
}
exports.ExposedSecret = ExposedSecret;
_a = JSII_RTTI_SYMBOL_1;
ExposedSecret[_a] = { fqn: "monocdk.aws_batch.ExposedSecret", version: "1.191.0" };
//# sourceMappingURL=data:application/json;base64,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