"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.JobDefinitionImageConfig = void 0;
const ecs = require("../../aws-ecs");
const iam = require("../../aws-iam");
/**
 * Batch Job Task Definition
 *
 * Defines a Batch Job Task Definition. The properties of this task definition mirrors
 * those of an {@link ecs.ContainerDefinition}. This class is a wrapper on that structure.
 */
class TaskDefinition {
    constructor(props) {
        this.executionRole = props.executionRole;
    }
    /**
     * Internal function to allow the Batch Job task definition
     * to match the CDK requirements of an EC2 task definition.
     *
     * @internal
     */
    _linkContainer() { }
    /**
     * Retrieves the execution role for this task definition
     */
    obtainExecutionRole() {
        return this.executionRole;
    }
}
/**
 * The configuration for creating a batch container image.
 */
class JobDefinitionImageConfig {
    constructor(scope, container) {
        const config = this.bindImageConfig(scope, container);
        this.imageName = config.imageName;
    }
    bindImageConfig(scope, container) {
        return container.image.bind(scope, new ecs.ContainerDefinition(scope, 'Resource-Batch-Job-Container-Definition', {
            command: container.command,
            cpu: container.vcpus,
            image: container.image,
            environment: container.environment,
            linuxParameters: container.linuxParams,
            memoryLimitMiB: container.memoryLimitMiB,
            privileged: container.privileged,
            readonlyRootFilesystem: container.readOnly,
            gpuCount: container.gpuCount,
            user: container.user,
            taskDefinition: new TaskDefinition({
                executionRole: container.jobRole || new iam.LazyRole(scope, 'Resource-Batch-Task-Definition-Role', {
                    assumedBy: new iam.ServicePrincipal('batch.amazonaws.com'),
                }),
            }),
        }));
    }
}
exports.JobDefinitionImageConfig = JobDefinitionImageConfig;
//# sourceMappingURL=data:application/json;base64,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