"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RestApiOrigin = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cloudfront = require("../../aws-cloudfront");
const cdk = require("../../core");
const utils_1 = require("./private/utils");
/**
 * An Origin for an API Gateway REST API.
 */
class RestApiOrigin extends cloudfront.OriginBase {
    constructor(restApi, props = {}) {
        // urlForPath() is of the form 'https://<rest-api-id>.execute-api.<region>.amazonaws.com/<stage>'
        // Splitting on '/' gives: ['https', '', '<rest-api-id>.execute-api.<region>.amazonaws.com', '<stage>']
        // The element at index 2 is the domain name, the element at index 3 is the stage name
        super(cdk.Fn.select(2, cdk.Fn.split('/', restApi.url)), {
            originPath: `/${cdk.Fn.select(3, cdk.Fn.split('/', restApi.url))}`,
            ...props,
        });
        this.props = props;
        try {
            jsiiDeprecationWarnings.monocdk_aws_apigateway_RestApi(restApi);
            jsiiDeprecationWarnings.monocdk_aws_cloudfront_origins_RestApiOriginProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, RestApiOrigin);
            }
            throw error;
        }
        utils_1.validateSecondsInRangeOrUndefined('readTimeout', 1, 180, props.readTimeout);
        utils_1.validateSecondsInRangeOrUndefined('keepaliveTimeout', 1, 180, props.keepaliveTimeout);
    }
    renderCustomOriginConfig() {
        return {
            originSslProtocols: [cloudfront.OriginSslPolicy.TLS_V1_2],
            originProtocolPolicy: cloudfront.OriginProtocolPolicy.HTTPS_ONLY,
            originReadTimeout: this.props.readTimeout?.toSeconds(),
            originKeepaliveTimeout: this.props.keepaliveTimeout?.toSeconds(),
        };
    }
}
exports.RestApiOrigin = RestApiOrigin;
_a = JSII_RTTI_SYMBOL_1;
RestApiOrigin[_a] = { fqn: "monocdk.aws_cloudfront_origins.RestApiOrigin", version: "1.191.0" };
//# sourceMappingURL=data:application/json;base64,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