"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HeadersReferrerPolicy = exports.HeadersFrameOption = exports.ResponseHeadersPolicy = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core");
const cloudfront_generated_1 = require("./cloudfront.generated");
/**
 * A Response Headers Policy configuration
 *
 * @resource AWS::CloudFront::ResponseHeadersPolicy
 */
class ResponseHeadersPolicy extends core_1.Resource {
    constructor(scope, id, props = {}) {
        super(scope, id, {
            physicalName: props.responseHeadersPolicyName,
        });
        try {
            jsiiDeprecationWarnings.monocdk_aws_cloudfront_ResponseHeadersPolicyProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, ResponseHeadersPolicy);
            }
            throw error;
        }
        const responseHeadersPolicyName = props.responseHeadersPolicyName ?? core_1.Names.uniqueId(this);
        const resource = new cloudfront_generated_1.CfnResponseHeadersPolicy(this, 'Resource', {
            responseHeadersPolicyConfig: {
                name: responseHeadersPolicyName,
                comment: props.comment,
                corsConfig: props.corsBehavior ? this._renderCorsConfig(props.corsBehavior) : undefined,
                customHeadersConfig: props.customHeadersBehavior ? this._renderCustomHeadersConfig(props.customHeadersBehavior) : undefined,
                securityHeadersConfig: props.securityHeadersBehavior ? this._renderSecurityHeadersConfig(props.securityHeadersBehavior) : undefined,
            },
        });
        this.responseHeadersPolicyId = resource.ref;
    }
    /**
     * Import an existing Response Headers Policy from its ID.
     */
    static fromResponseHeadersPolicyId(scope, id, responseHeadersPolicyId) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.responseHeadersPolicyId = responseHeadersPolicyId;
            }
        }
        return new Import(scope, id);
    }
    static fromManagedResponseHeadersPolicy(managedResponseHeadersPolicyId) {
        return new class {
            constructor() {
                this.responseHeadersPolicyId = managedResponseHeadersPolicyId;
            }
        };
    }
    _renderCorsConfig(behavior) {
        return {
            accessControlAllowCredentials: behavior.accessControlAllowCredentials,
            accessControlAllowHeaders: { items: behavior.accessControlAllowHeaders },
            accessControlAllowMethods: { items: behavior.accessControlAllowMethods },
            accessControlAllowOrigins: { items: behavior.accessControlAllowOrigins },
            accessControlExposeHeaders: behavior.accessControlExposeHeaders ? { items: behavior.accessControlExposeHeaders } : undefined,
            accessControlMaxAgeSec: behavior.accessControlMaxAge ? behavior.accessControlMaxAge.toSeconds() : undefined,
            originOverride: behavior.originOverride,
        };
    }
    _renderCustomHeadersConfig(behavior) {
        return {
            items: behavior.customHeaders,
        };
    }
    _renderSecurityHeadersConfig(behavior) {
        return {
            contentSecurityPolicy: behavior.contentSecurityPolicy,
            contentTypeOptions: behavior.contentTypeOptions,
            frameOptions: behavior.frameOptions,
            referrerPolicy: behavior.referrerPolicy,
            strictTransportSecurity: behavior.strictTransportSecurity ? {
                ...behavior.strictTransportSecurity,
                accessControlMaxAgeSec: behavior.strictTransportSecurity.accessControlMaxAge.toSeconds(),
            } : undefined,
            xssProtection: behavior.xssProtection,
        };
    }
}
exports.ResponseHeadersPolicy = ResponseHeadersPolicy;
_a = JSII_RTTI_SYMBOL_1;
ResponseHeadersPolicy[_a] = { fqn: "monocdk.aws_cloudfront.ResponseHeadersPolicy", version: "1.191.0" };
/** Use this managed policy to allow simple CORS requests from any origin. */
ResponseHeadersPolicy.CORS_ALLOW_ALL_ORIGINS = ResponseHeadersPolicy.fromManagedResponseHeadersPolicy('60669652-455b-4ae9-85a4-c4c02393f86c');
/** Use this managed policy to allow CORS requests from any origin, including preflight requests. */
ResponseHeadersPolicy.CORS_ALLOW_ALL_ORIGINS_WITH_PREFLIGHT = ResponseHeadersPolicy.fromManagedResponseHeadersPolicy('5cc3b908-e619-4b99-88e5-2cf7f45965bd');
/** Use this managed policy to add a set of security headers to all responses that CloudFront sends to viewers. */
ResponseHeadersPolicy.SECURITY_HEADERS = ResponseHeadersPolicy.fromManagedResponseHeadersPolicy('67f7725c-6f97-4210-82d7-5512b31e9d03');
/** Use this managed policy to allow simple CORS requests from any origin and add a set of security headers to all responses that CloudFront sends to viewers. */
ResponseHeadersPolicy.CORS_ALLOW_ALL_ORIGINS_AND_SECURITY_HEADERS = ResponseHeadersPolicy.fromManagedResponseHeadersPolicy('e61eb60c-9c35-4d20-a928-2b84e02af89c');
/** Use this managed policy to allow CORS requests from any origin, including preflight requests, and add a set of security headers to all responses that CloudFront sends to viewers. */
ResponseHeadersPolicy.CORS_ALLOW_ALL_ORIGINS_WITH_PREFLIGHT_AND_SECURITY_HEADERS = ResponseHeadersPolicy.fromManagedResponseHeadersPolicy('eaab4381-ed33-4a86-88ca-d9558dc6cd63');
/**
 * Enum representing possible values of the X-Frame-Options HTTP response header.
 */
var HeadersFrameOption;
(function (HeadersFrameOption) {
    /**
     * The page can only be displayed in a frame on the same origin as the page itself.
     */
    HeadersFrameOption["DENY"] = "DENY";
    /**
     * The page can only be displayed in a frame on the specified origin.
     */
    HeadersFrameOption["SAMEORIGIN"] = "SAMEORIGIN";
})(HeadersFrameOption = exports.HeadersFrameOption || (exports.HeadersFrameOption = {}));
/**
 * Enum representing possible values of the Referrer-Policy HTTP response header.
 */
var HeadersReferrerPolicy;
(function (HeadersReferrerPolicy) {
    /**
     * The referrer policy is not set.
     */
    HeadersReferrerPolicy["NO_REFERRER"] = "no-referrer";
    /**
     * The referrer policy is no-referrer-when-downgrade.
     */
    HeadersReferrerPolicy["NO_REFERRER_WHEN_DOWNGRADE"] = "no-referrer-when-downgrade";
    /**
     * The referrer policy is origin.
     */
    HeadersReferrerPolicy["ORIGIN"] = "origin";
    /**
     * The referrer policy is origin-when-cross-origin.
     */
    HeadersReferrerPolicy["ORIGIN_WHEN_CROSS_ORIGIN"] = "origin-when-cross-origin";
    /**
     * The referrer policy is same-origin.
     */
    HeadersReferrerPolicy["SAME_ORIGIN"] = "same-origin";
    /**
     * The referrer policy is strict-origin.
     */
    HeadersReferrerPolicy["STRICT_ORIGIN"] = "strict-origin";
    /**
     * The referrer policy is strict-origin-when-cross-origin.
     */
    HeadersReferrerPolicy["STRICT_ORIGIN_WHEN_CROSS_ORIGIN"] = "strict-origin-when-cross-origin";
    /**
     * The referrer policy is unsafe-url.
     */
    HeadersReferrerPolicy["UNSAFE_URL"] = "unsafe-url";
})(HeadersReferrerPolicy = exports.HeadersReferrerPolicy || (exports.HeadersReferrerPolicy = {}));
//# sourceMappingURL=data:application/json;base64,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