"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnTrail = exports.CfnEventDataStore = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright 2012-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
// Generated from the AWS CloudFormation Resource Specification
// See: docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-resource-specification.html
// @cfn2ts:meta@ {"generated":"2023-01-31T17:49:06.250Z","fingerprint":"Cz4EmJ2mHlHpDfTBcIfD2CS9F64cyE8RErhngFrRpIQ="}
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
const cdk = require("../../core");
const cfn_parse = require("../../core/lib/helpers-internal");
/**
 * Determine whether the given properties match those of a `CfnEventDataStoreProps`
 *
 * @param properties - the TypeScript properties of a `CfnEventDataStoreProps`
 *
 * @returns the result of the validation.
 */
function CfnEventDataStorePropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('advancedEventSelectors', cdk.listValidator(CfnEventDataStore_AdvancedEventSelectorPropertyValidator))(properties.advancedEventSelectors));
    errors.collect(cdk.propertyValidator('kmsKeyId', cdk.validateString)(properties.kmsKeyId));
    errors.collect(cdk.propertyValidator('multiRegionEnabled', cdk.validateBoolean)(properties.multiRegionEnabled));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('organizationEnabled', cdk.validateBoolean)(properties.organizationEnabled));
    errors.collect(cdk.propertyValidator('retentionPeriod', cdk.validateNumber)(properties.retentionPeriod));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    errors.collect(cdk.propertyValidator('terminationProtectionEnabled', cdk.validateBoolean)(properties.terminationProtectionEnabled));
    return errors.wrap('supplied properties not correct for "CfnEventDataStoreProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::CloudTrail::EventDataStore` resource
 *
 * @param properties - the TypeScript properties of a `CfnEventDataStoreProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::CloudTrail::EventDataStore` resource.
 */
// @ts-ignore TS6133
function cfnEventDataStorePropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnEventDataStorePropsValidator(properties).assertSuccess();
    return {
        AdvancedEventSelectors: cdk.listMapper(cfnEventDataStoreAdvancedEventSelectorPropertyToCloudFormation)(properties.advancedEventSelectors),
        KmsKeyId: cdk.stringToCloudFormation(properties.kmsKeyId),
        MultiRegionEnabled: cdk.booleanToCloudFormation(properties.multiRegionEnabled),
        Name: cdk.stringToCloudFormation(properties.name),
        OrganizationEnabled: cdk.booleanToCloudFormation(properties.organizationEnabled),
        RetentionPeriod: cdk.numberToCloudFormation(properties.retentionPeriod),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
        TerminationProtectionEnabled: cdk.booleanToCloudFormation(properties.terminationProtectionEnabled),
    };
}
// @ts-ignore TS6133
function CfnEventDataStorePropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('advancedEventSelectors', 'AdvancedEventSelectors', properties.AdvancedEventSelectors != null ? cfn_parse.FromCloudFormation.getArray(CfnEventDataStoreAdvancedEventSelectorPropertyFromCloudFormation)(properties.AdvancedEventSelectors) : undefined);
    ret.addPropertyResult('kmsKeyId', 'KmsKeyId', properties.KmsKeyId != null ? cfn_parse.FromCloudFormation.getString(properties.KmsKeyId) : undefined);
    ret.addPropertyResult('multiRegionEnabled', 'MultiRegionEnabled', properties.MultiRegionEnabled != null ? cfn_parse.FromCloudFormation.getBoolean(properties.MultiRegionEnabled) : undefined);
    ret.addPropertyResult('name', 'Name', properties.Name != null ? cfn_parse.FromCloudFormation.getString(properties.Name) : undefined);
    ret.addPropertyResult('organizationEnabled', 'OrganizationEnabled', properties.OrganizationEnabled != null ? cfn_parse.FromCloudFormation.getBoolean(properties.OrganizationEnabled) : undefined);
    ret.addPropertyResult('retentionPeriod', 'RetentionPeriod', properties.RetentionPeriod != null ? cfn_parse.FromCloudFormation.getNumber(properties.RetentionPeriod) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addPropertyResult('terminationProtectionEnabled', 'TerminationProtectionEnabled', properties.TerminationProtectionEnabled != null ? cfn_parse.FromCloudFormation.getBoolean(properties.TerminationProtectionEnabled) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::CloudTrail::EventDataStore`
 *
 * Creates a new event data store.
 *
 * @cloudformationResource AWS::CloudTrail::EventDataStore
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-eventdatastore.html
 */
class CfnEventDataStore extends cdk.CfnResource {
    /**
     * Create a new `AWS::CloudTrail::EventDataStore`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props = {}) {
        super(scope, id, { type: CfnEventDataStore.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.monocdk_Construct(scope);
            jsiiDeprecationWarnings.monocdk_aws_cloudtrail_CfnEventDataStoreProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnEventDataStore);
            }
            throw error;
        }
        this.attrCreatedTimestamp = cdk.Token.asString(this.getAtt('CreatedTimestamp'));
        this.attrEventDataStoreArn = cdk.Token.asString(this.getAtt('EventDataStoreArn'));
        this.attrStatus = cdk.Token.asString(this.getAtt('Status'));
        this.attrUpdatedTimestamp = cdk.Token.asString(this.getAtt('UpdatedTimestamp'));
        this.advancedEventSelectors = props.advancedEventSelectors;
        this.kmsKeyId = props.kmsKeyId;
        this.multiRegionEnabled = props.multiRegionEnabled;
        this.name = props.name;
        this.organizationEnabled = props.organizationEnabled;
        this.retentionPeriod = props.retentionPeriod;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::CloudTrail::EventDataStore", props.tags, { tagPropertyName: 'tags' });
        this.terminationProtectionEnabled = props.terminationProtectionEnabled;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnEventDataStorePropsFromCloudFormation(resourceProperties);
        const ret = new CfnEventDataStore(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.monocdk_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnEventDataStore.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            advancedEventSelectors: this.advancedEventSelectors,
            kmsKeyId: this.kmsKeyId,
            multiRegionEnabled: this.multiRegionEnabled,
            name: this.name,
            organizationEnabled: this.organizationEnabled,
            retentionPeriod: this.retentionPeriod,
            tags: this.tags.renderTags(),
            terminationProtectionEnabled: this.terminationProtectionEnabled,
        };
    }
    renderProperties(props) {
        return cfnEventDataStorePropsToCloudFormation(props);
    }
}
exports.CfnEventDataStore = CfnEventDataStore;
_a = JSII_RTTI_SYMBOL_1;
CfnEventDataStore[_a] = { fqn: "monocdk.aws_cloudtrail.CfnEventDataStore", version: "1.191.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnEventDataStore.CFN_RESOURCE_TYPE_NAME = "AWS::CloudTrail::EventDataStore";
/**
 * Determine whether the given properties match those of a `AdvancedEventSelectorProperty`
 *
 * @param properties - the TypeScript properties of a `AdvancedEventSelectorProperty`
 *
 * @returns the result of the validation.
 */
function CfnEventDataStore_AdvancedEventSelectorPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('fieldSelectors', cdk.requiredValidator)(properties.fieldSelectors));
    errors.collect(cdk.propertyValidator('fieldSelectors', cdk.listValidator(CfnEventDataStore_AdvancedFieldSelectorPropertyValidator))(properties.fieldSelectors));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    return errors.wrap('supplied properties not correct for "AdvancedEventSelectorProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::CloudTrail::EventDataStore.AdvancedEventSelector` resource
 *
 * @param properties - the TypeScript properties of a `AdvancedEventSelectorProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::CloudTrail::EventDataStore.AdvancedEventSelector` resource.
 */
// @ts-ignore TS6133
function cfnEventDataStoreAdvancedEventSelectorPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnEventDataStore_AdvancedEventSelectorPropertyValidator(properties).assertSuccess();
    return {
        FieldSelectors: cdk.listMapper(cfnEventDataStoreAdvancedFieldSelectorPropertyToCloudFormation)(properties.fieldSelectors),
        Name: cdk.stringToCloudFormation(properties.name),
    };
}
// @ts-ignore TS6133
function CfnEventDataStoreAdvancedEventSelectorPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('fieldSelectors', 'FieldSelectors', cfn_parse.FromCloudFormation.getArray(CfnEventDataStoreAdvancedFieldSelectorPropertyFromCloudFormation)(properties.FieldSelectors));
    ret.addPropertyResult('name', 'Name', properties.Name != null ? cfn_parse.FromCloudFormation.getString(properties.Name) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `AdvancedFieldSelectorProperty`
 *
 * @param properties - the TypeScript properties of a `AdvancedFieldSelectorProperty`
 *
 * @returns the result of the validation.
 */
function CfnEventDataStore_AdvancedFieldSelectorPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('endsWith', cdk.listValidator(cdk.validateString))(properties.endsWith));
    errors.collect(cdk.propertyValidator('equalTo', cdk.listValidator(cdk.validateString))(properties.equalTo));
    errors.collect(cdk.propertyValidator('field', cdk.requiredValidator)(properties.field));
    errors.collect(cdk.propertyValidator('field', cdk.validateString)(properties.field));
    errors.collect(cdk.propertyValidator('notEndsWith', cdk.listValidator(cdk.validateString))(properties.notEndsWith));
    errors.collect(cdk.propertyValidator('notEquals', cdk.listValidator(cdk.validateString))(properties.notEquals));
    errors.collect(cdk.propertyValidator('notStartsWith', cdk.listValidator(cdk.validateString))(properties.notStartsWith));
    errors.collect(cdk.propertyValidator('startsWith', cdk.listValidator(cdk.validateString))(properties.startsWith));
    return errors.wrap('supplied properties not correct for "AdvancedFieldSelectorProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::CloudTrail::EventDataStore.AdvancedFieldSelector` resource
 *
 * @param properties - the TypeScript properties of a `AdvancedFieldSelectorProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::CloudTrail::EventDataStore.AdvancedFieldSelector` resource.
 */
// @ts-ignore TS6133
function cfnEventDataStoreAdvancedFieldSelectorPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnEventDataStore_AdvancedFieldSelectorPropertyValidator(properties).assertSuccess();
    return {
        EndsWith: cdk.listMapper(cdk.stringToCloudFormation)(properties.endsWith),
        Equals: cdk.listMapper(cdk.stringToCloudFormation)(properties.equalTo),
        Field: cdk.stringToCloudFormation(properties.field),
        NotEndsWith: cdk.listMapper(cdk.stringToCloudFormation)(properties.notEndsWith),
        NotEquals: cdk.listMapper(cdk.stringToCloudFormation)(properties.notEquals),
        NotStartsWith: cdk.listMapper(cdk.stringToCloudFormation)(properties.notStartsWith),
        StartsWith: cdk.listMapper(cdk.stringToCloudFormation)(properties.startsWith),
    };
}
// @ts-ignore TS6133
function CfnEventDataStoreAdvancedFieldSelectorPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('endsWith', 'EndsWith', properties.EndsWith != null ? cfn_parse.FromCloudFormation.getStringArray(properties.EndsWith) : undefined);
    ret.addPropertyResult('equalTo', 'Equals', properties.Equals != null ? cfn_parse.FromCloudFormation.getStringArray(properties.Equals) : undefined);
    ret.addPropertyResult('field', 'Field', cfn_parse.FromCloudFormation.getString(properties.Field));
    ret.addPropertyResult('notEndsWith', 'NotEndsWith', properties.NotEndsWith != null ? cfn_parse.FromCloudFormation.getStringArray(properties.NotEndsWith) : undefined);
    ret.addPropertyResult('notEquals', 'NotEquals', properties.NotEquals != null ? cfn_parse.FromCloudFormation.getStringArray(properties.NotEquals) : undefined);
    ret.addPropertyResult('notStartsWith', 'NotStartsWith', properties.NotStartsWith != null ? cfn_parse.FromCloudFormation.getStringArray(properties.NotStartsWith) : undefined);
    ret.addPropertyResult('startsWith', 'StartsWith', properties.StartsWith != null ? cfn_parse.FromCloudFormation.getStringArray(properties.StartsWith) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnTrailProps`
 *
 * @param properties - the TypeScript properties of a `CfnTrailProps`
 *
 * @returns the result of the validation.
 */
function CfnTrailPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('cloudWatchLogsLogGroupArn', cdk.validateString)(properties.cloudWatchLogsLogGroupArn));
    errors.collect(cdk.propertyValidator('cloudWatchLogsRoleArn', cdk.validateString)(properties.cloudWatchLogsRoleArn));
    errors.collect(cdk.propertyValidator('enableLogFileValidation', cdk.validateBoolean)(properties.enableLogFileValidation));
    errors.collect(cdk.propertyValidator('eventSelectors', cdk.listValidator(CfnTrail_EventSelectorPropertyValidator))(properties.eventSelectors));
    errors.collect(cdk.propertyValidator('includeGlobalServiceEvents', cdk.validateBoolean)(properties.includeGlobalServiceEvents));
    errors.collect(cdk.propertyValidator('insightSelectors', cdk.listValidator(CfnTrail_InsightSelectorPropertyValidator))(properties.insightSelectors));
    errors.collect(cdk.propertyValidator('isLogging', cdk.requiredValidator)(properties.isLogging));
    errors.collect(cdk.propertyValidator('isLogging', cdk.validateBoolean)(properties.isLogging));
    errors.collect(cdk.propertyValidator('isMultiRegionTrail', cdk.validateBoolean)(properties.isMultiRegionTrail));
    errors.collect(cdk.propertyValidator('isOrganizationTrail', cdk.validateBoolean)(properties.isOrganizationTrail));
    errors.collect(cdk.propertyValidator('kmsKeyId', cdk.validateString)(properties.kmsKeyId));
    errors.collect(cdk.propertyValidator('s3BucketName', cdk.requiredValidator)(properties.s3BucketName));
    errors.collect(cdk.propertyValidator('s3BucketName', cdk.validateString)(properties.s3BucketName));
    errors.collect(cdk.propertyValidator('s3KeyPrefix', cdk.validateString)(properties.s3KeyPrefix));
    errors.collect(cdk.propertyValidator('snsTopicName', cdk.validateString)(properties.snsTopicName));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    errors.collect(cdk.propertyValidator('trailName', cdk.validateString)(properties.trailName));
    return errors.wrap('supplied properties not correct for "CfnTrailProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::CloudTrail::Trail` resource
 *
 * @param properties - the TypeScript properties of a `CfnTrailProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::CloudTrail::Trail` resource.
 */
// @ts-ignore TS6133
function cfnTrailPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnTrailPropsValidator(properties).assertSuccess();
    return {
        IsLogging: cdk.booleanToCloudFormation(properties.isLogging),
        S3BucketName: cdk.stringToCloudFormation(properties.s3BucketName),
        CloudWatchLogsLogGroupArn: cdk.stringToCloudFormation(properties.cloudWatchLogsLogGroupArn),
        CloudWatchLogsRoleArn: cdk.stringToCloudFormation(properties.cloudWatchLogsRoleArn),
        EnableLogFileValidation: cdk.booleanToCloudFormation(properties.enableLogFileValidation),
        EventSelectors: cdk.listMapper(cfnTrailEventSelectorPropertyToCloudFormation)(properties.eventSelectors),
        IncludeGlobalServiceEvents: cdk.booleanToCloudFormation(properties.includeGlobalServiceEvents),
        InsightSelectors: cdk.listMapper(cfnTrailInsightSelectorPropertyToCloudFormation)(properties.insightSelectors),
        IsMultiRegionTrail: cdk.booleanToCloudFormation(properties.isMultiRegionTrail),
        IsOrganizationTrail: cdk.booleanToCloudFormation(properties.isOrganizationTrail),
        KMSKeyId: cdk.stringToCloudFormation(properties.kmsKeyId),
        S3KeyPrefix: cdk.stringToCloudFormation(properties.s3KeyPrefix),
        SnsTopicName: cdk.stringToCloudFormation(properties.snsTopicName),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
        TrailName: cdk.stringToCloudFormation(properties.trailName),
    };
}
// @ts-ignore TS6133
function CfnTrailPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('isLogging', 'IsLogging', cfn_parse.FromCloudFormation.getBoolean(properties.IsLogging));
    ret.addPropertyResult('s3BucketName', 'S3BucketName', cfn_parse.FromCloudFormation.getString(properties.S3BucketName));
    ret.addPropertyResult('cloudWatchLogsLogGroupArn', 'CloudWatchLogsLogGroupArn', properties.CloudWatchLogsLogGroupArn != null ? cfn_parse.FromCloudFormation.getString(properties.CloudWatchLogsLogGroupArn) : undefined);
    ret.addPropertyResult('cloudWatchLogsRoleArn', 'CloudWatchLogsRoleArn', properties.CloudWatchLogsRoleArn != null ? cfn_parse.FromCloudFormation.getString(properties.CloudWatchLogsRoleArn) : undefined);
    ret.addPropertyResult('enableLogFileValidation', 'EnableLogFileValidation', properties.EnableLogFileValidation != null ? cfn_parse.FromCloudFormation.getBoolean(properties.EnableLogFileValidation) : undefined);
    ret.addPropertyResult('eventSelectors', 'EventSelectors', properties.EventSelectors != null ? cfn_parse.FromCloudFormation.getArray(CfnTrailEventSelectorPropertyFromCloudFormation)(properties.EventSelectors) : undefined);
    ret.addPropertyResult('includeGlobalServiceEvents', 'IncludeGlobalServiceEvents', properties.IncludeGlobalServiceEvents != null ? cfn_parse.FromCloudFormation.getBoolean(properties.IncludeGlobalServiceEvents) : undefined);
    ret.addPropertyResult('insightSelectors', 'InsightSelectors', properties.InsightSelectors != null ? cfn_parse.FromCloudFormation.getArray(CfnTrailInsightSelectorPropertyFromCloudFormation)(properties.InsightSelectors) : undefined);
    ret.addPropertyResult('isMultiRegionTrail', 'IsMultiRegionTrail', properties.IsMultiRegionTrail != null ? cfn_parse.FromCloudFormation.getBoolean(properties.IsMultiRegionTrail) : undefined);
    ret.addPropertyResult('isOrganizationTrail', 'IsOrganizationTrail', properties.IsOrganizationTrail != null ? cfn_parse.FromCloudFormation.getBoolean(properties.IsOrganizationTrail) : undefined);
    ret.addPropertyResult('kmsKeyId', 'KMSKeyId', properties.KMSKeyId != null ? cfn_parse.FromCloudFormation.getString(properties.KMSKeyId) : undefined);
    ret.addPropertyResult('s3KeyPrefix', 'S3KeyPrefix', properties.S3KeyPrefix != null ? cfn_parse.FromCloudFormation.getString(properties.S3KeyPrefix) : undefined);
    ret.addPropertyResult('snsTopicName', 'SnsTopicName', properties.SnsTopicName != null ? cfn_parse.FromCloudFormation.getString(properties.SnsTopicName) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addPropertyResult('trailName', 'TrailName', properties.TrailName != null ? cfn_parse.FromCloudFormation.getString(properties.TrailName) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::CloudTrail::Trail`
 *
 * Creates a trail that specifies the settings for delivery of log data to an Amazon S3 bucket.
 *
 * @cloudformationResource AWS::CloudTrail::Trail
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-trail.html
 */
class CfnTrail extends cdk.CfnResource {
    /**
     * Create a new `AWS::CloudTrail::Trail`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnTrail.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.monocdk_Construct(scope);
            jsiiDeprecationWarnings.monocdk_aws_cloudtrail_CfnTrailProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnTrail);
            }
            throw error;
        }
        cdk.requireProperty(props, 'isLogging', this);
        cdk.requireProperty(props, 's3BucketName', this);
        this.attrArn = cdk.Token.asString(this.getAtt('Arn'));
        this.attrSnsTopicArn = cdk.Token.asString(this.getAtt('SnsTopicArn'));
        this.isLogging = props.isLogging;
        this.s3BucketName = props.s3BucketName;
        this.cloudWatchLogsLogGroupArn = props.cloudWatchLogsLogGroupArn;
        this.cloudWatchLogsRoleArn = props.cloudWatchLogsRoleArn;
        this.enableLogFileValidation = props.enableLogFileValidation;
        this.eventSelectors = props.eventSelectors;
        this.includeGlobalServiceEvents = props.includeGlobalServiceEvents;
        this.insightSelectors = props.insightSelectors;
        this.isMultiRegionTrail = props.isMultiRegionTrail;
        this.isOrganizationTrail = props.isOrganizationTrail;
        this.kmsKeyId = props.kmsKeyId;
        this.s3KeyPrefix = props.s3KeyPrefix;
        this.snsTopicName = props.snsTopicName;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::CloudTrail::Trail", props.tags, { tagPropertyName: 'tags' });
        this.trailName = props.trailName;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnTrailPropsFromCloudFormation(resourceProperties);
        const ret = new CfnTrail(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.monocdk_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnTrail.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            isLogging: this.isLogging,
            s3BucketName: this.s3BucketName,
            cloudWatchLogsLogGroupArn: this.cloudWatchLogsLogGroupArn,
            cloudWatchLogsRoleArn: this.cloudWatchLogsRoleArn,
            enableLogFileValidation: this.enableLogFileValidation,
            eventSelectors: this.eventSelectors,
            includeGlobalServiceEvents: this.includeGlobalServiceEvents,
            insightSelectors: this.insightSelectors,
            isMultiRegionTrail: this.isMultiRegionTrail,
            isOrganizationTrail: this.isOrganizationTrail,
            kmsKeyId: this.kmsKeyId,
            s3KeyPrefix: this.s3KeyPrefix,
            snsTopicName: this.snsTopicName,
            tags: this.tags.renderTags(),
            trailName: this.trailName,
        };
    }
    renderProperties(props) {
        return cfnTrailPropsToCloudFormation(props);
    }
}
exports.CfnTrail = CfnTrail;
_b = JSII_RTTI_SYMBOL_1;
CfnTrail[_b] = { fqn: "monocdk.aws_cloudtrail.CfnTrail", version: "1.191.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnTrail.CFN_RESOURCE_TYPE_NAME = "AWS::CloudTrail::Trail";
/**
 * Determine whether the given properties match those of a `DataResourceProperty`
 *
 * @param properties - the TypeScript properties of a `DataResourceProperty`
 *
 * @returns the result of the validation.
 */
function CfnTrail_DataResourcePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('type', cdk.requiredValidator)(properties.type));
    errors.collect(cdk.propertyValidator('type', cdk.validateString)(properties.type));
    errors.collect(cdk.propertyValidator('values', cdk.listValidator(cdk.validateString))(properties.values));
    return errors.wrap('supplied properties not correct for "DataResourceProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::CloudTrail::Trail.DataResource` resource
 *
 * @param properties - the TypeScript properties of a `DataResourceProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::CloudTrail::Trail.DataResource` resource.
 */
// @ts-ignore TS6133
function cfnTrailDataResourcePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnTrail_DataResourcePropertyValidator(properties).assertSuccess();
    return {
        Type: cdk.stringToCloudFormation(properties.type),
        Values: cdk.listMapper(cdk.stringToCloudFormation)(properties.values),
    };
}
// @ts-ignore TS6133
function CfnTrailDataResourcePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('type', 'Type', cfn_parse.FromCloudFormation.getString(properties.Type));
    ret.addPropertyResult('values', 'Values', properties.Values != null ? cfn_parse.FromCloudFormation.getStringArray(properties.Values) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `EventSelectorProperty`
 *
 * @param properties - the TypeScript properties of a `EventSelectorProperty`
 *
 * @returns the result of the validation.
 */
function CfnTrail_EventSelectorPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('dataResources', cdk.listValidator(CfnTrail_DataResourcePropertyValidator))(properties.dataResources));
    errors.collect(cdk.propertyValidator('excludeManagementEventSources', cdk.listValidator(cdk.validateString))(properties.excludeManagementEventSources));
    errors.collect(cdk.propertyValidator('includeManagementEvents', cdk.validateBoolean)(properties.includeManagementEvents));
    errors.collect(cdk.propertyValidator('readWriteType', cdk.validateString)(properties.readWriteType));
    return errors.wrap('supplied properties not correct for "EventSelectorProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::CloudTrail::Trail.EventSelector` resource
 *
 * @param properties - the TypeScript properties of a `EventSelectorProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::CloudTrail::Trail.EventSelector` resource.
 */
// @ts-ignore TS6133
function cfnTrailEventSelectorPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnTrail_EventSelectorPropertyValidator(properties).assertSuccess();
    return {
        DataResources: cdk.listMapper(cfnTrailDataResourcePropertyToCloudFormation)(properties.dataResources),
        ExcludeManagementEventSources: cdk.listMapper(cdk.stringToCloudFormation)(properties.excludeManagementEventSources),
        IncludeManagementEvents: cdk.booleanToCloudFormation(properties.includeManagementEvents),
        ReadWriteType: cdk.stringToCloudFormation(properties.readWriteType),
    };
}
// @ts-ignore TS6133
function CfnTrailEventSelectorPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('dataResources', 'DataResources', properties.DataResources != null ? cfn_parse.FromCloudFormation.getArray(CfnTrailDataResourcePropertyFromCloudFormation)(properties.DataResources) : undefined);
    ret.addPropertyResult('excludeManagementEventSources', 'ExcludeManagementEventSources', properties.ExcludeManagementEventSources != null ? cfn_parse.FromCloudFormation.getStringArray(properties.ExcludeManagementEventSources) : undefined);
    ret.addPropertyResult('includeManagementEvents', 'IncludeManagementEvents', properties.IncludeManagementEvents != null ? cfn_parse.FromCloudFormation.getBoolean(properties.IncludeManagementEvents) : undefined);
    ret.addPropertyResult('readWriteType', 'ReadWriteType', properties.ReadWriteType != null ? cfn_parse.FromCloudFormation.getString(properties.ReadWriteType) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `InsightSelectorProperty`
 *
 * @param properties - the TypeScript properties of a `InsightSelectorProperty`
 *
 * @returns the result of the validation.
 */
function CfnTrail_InsightSelectorPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('insightType', cdk.validateString)(properties.insightType));
    return errors.wrap('supplied properties not correct for "InsightSelectorProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::CloudTrail::Trail.InsightSelector` resource
 *
 * @param properties - the TypeScript properties of a `InsightSelectorProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::CloudTrail::Trail.InsightSelector` resource.
 */
// @ts-ignore TS6133
function cfnTrailInsightSelectorPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnTrail_InsightSelectorPropertyValidator(properties).assertSuccess();
    return {
        InsightType: cdk.stringToCloudFormation(properties.insightType),
    };
}
// @ts-ignore TS6133
function CfnTrailInsightSelectorPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('insightType', 'InsightType', properties.InsightType != null ? cfn_parse.FromCloudFormation.getString(properties.InsightType) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
//# sourceMappingURL=data:application/json;base64,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