"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const iam = require("../../aws-iam");
const lambda = require("../../aws-lambda");
const s3 = require("../../aws-s3");
const cdk = require("../../core");
const cloudtrail = require("../lib");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'integ-cloudtrail');
const bucket = new s3.Bucket(stack, 'Bucket', {
    removalPolicy: cdk.RemovalPolicy.DESTROY,
    autoDeleteObjects: true,
});
const lambdaFunction = new lambda.Function(stack, 'LambdaFunction', {
    runtime: lambda.Runtime.NODEJS_14_X,
    handler: 'hello.handler',
    code: lambda.Code.fromInline('exports.handler = {}'),
});
// using exctecy the same code as inside the cloudtrail class to produce the supplied bucket and policy
const cloudTrailPrincipal = new iam.ServicePrincipal('cloudtrail.amazonaws.com');
const Trailbucket = new s3.Bucket(stack, 'S3', {
    encryption: s3.BucketEncryption.UNENCRYPTED,
    removalPolicy: cdk.RemovalPolicy.DESTROY,
    autoDeleteObjects: true,
});
Trailbucket.addToResourcePolicy(new iam.PolicyStatement({
    resources: [Trailbucket.bucketArn],
    actions: ['s3:GetBucketAcl'],
    principals: [cloudTrailPrincipal],
}));
Trailbucket.addToResourcePolicy(new iam.PolicyStatement({
    resources: [Trailbucket.arnForObjects(`AWSLogs/${cdk.Stack.of(stack).account}/*`)],
    actions: ['s3:PutObject'],
    principals: [cloudTrailPrincipal],
    conditions: {
        StringEquals: { 's3:x-amz-acl': 'bucket-owner-full-control' },
    },
}));
const trail = new cloudtrail.Trail(stack, 'Trail', { bucket: Trailbucket });
trail.addLambdaEventSelector([lambdaFunction]);
trail.addS3EventSelector([{ bucket }]);
app.synth();
//# sourceMappingURL=data:application/json;base64,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