"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApplicationScalingAction = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Use an ApplicationAutoScaling StepScalingAction as an Alarm Action
 */
class ApplicationScalingAction {
    constructor(stepScalingAction) {
        this.stepScalingAction = stepScalingAction;
        try {
            jsiiDeprecationWarnings.monocdk_aws_applicationautoscaling_StepScalingAction(stepScalingAction);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, ApplicationScalingAction);
            }
            throw error;
        }
    }
    /**
     * Returns an alarm action configuration to use an ApplicationScaling StepScalingAction
     * as an alarm action
     */
    bind(_scope, _alarm) {
        try {
            jsiiDeprecationWarnings.monocdk_Construct(_scope);
            jsiiDeprecationWarnings.monocdk_aws_cloudwatch_IAlarm(_alarm);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        return { alarmActionArn: this.stepScalingAction.scalingPolicyArn };
    }
}
exports.ApplicationScalingAction = ApplicationScalingAction;
_a = JSII_RTTI_SYMBOL_1;
ApplicationScalingAction[_a] = { fqn: "monocdk.aws_cloudwatch_actions.ApplicationScalingAction", version: "1.191.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXBwc2NhbGluZy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImFwcHNjYWxpbmcudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBT0E7O0dBRUc7QUFDSCxNQUFhLHdCQUF3QjtJQUNuQyxZQUE2QixpQkFBK0M7UUFBL0Msc0JBQWlCLEdBQWpCLGlCQUFpQixDQUE4Qjs7Ozs7OytDQURqRSx3QkFBd0I7Ozs7S0FFbEM7SUFFRDs7O09BR0c7SUFDSSxJQUFJLENBQUMsTUFBaUIsRUFBRSxNQUF5Qjs7Ozs7Ozs7Ozs7UUFDdEQsT0FBTyxFQUFFLGNBQWMsRUFBRSxJQUFJLENBQUMsaUJBQWlCLENBQUMsZ0JBQWdCLEVBQUUsQ0FBQztLQUNwRTs7QUFWSCw0REFXQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGFwcHNjYWxpbmcgZnJvbSAnLi4vLi4vYXdzLWFwcGxpY2F0aW9uYXV0b3NjYWxpbmcnO1xuaW1wb3J0ICogYXMgY2xvdWR3YXRjaCBmcm9tICcuLi8uLi9hd3MtY2xvdWR3YXRjaCc7XG5cbi8vIGtlZXAgdGhpcyBpbXBvcnQgc2VwYXJhdGUgZnJvbSBvdGhlciBpbXBvcnRzIHRvIHJlZHVjZSBjaGFuY2UgZm9yIG1lcmdlIGNvbmZsaWN0cyB3aXRoIHYyLW1haW5cbi8vIGVzbGludC1kaXNhYmxlLW5leHQtbGluZSBuby1kdXBsaWNhdGUtaW1wb3J0cywgaW1wb3J0L29yZGVyXG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICcuLi8uLi9jb3JlJztcblxuLyoqXG4gKiBVc2UgYW4gQXBwbGljYXRpb25BdXRvU2NhbGluZyBTdGVwU2NhbGluZ0FjdGlvbiBhcyBhbiBBbGFybSBBY3Rpb25cbiAqL1xuZXhwb3J0IGNsYXNzIEFwcGxpY2F0aW9uU2NhbGluZ0FjdGlvbiBpbXBsZW1lbnRzIGNsb3Vkd2F0Y2guSUFsYXJtQWN0aW9uIHtcbiAgY29uc3RydWN0b3IocHJpdmF0ZSByZWFkb25seSBzdGVwU2NhbGluZ0FjdGlvbjogYXBwc2NhbGluZy5TdGVwU2NhbGluZ0FjdGlvbikge1xuICB9XG5cbiAgLyoqXG4gICAqIFJldHVybnMgYW4gYWxhcm0gYWN0aW9uIGNvbmZpZ3VyYXRpb24gdG8gdXNlIGFuIEFwcGxpY2F0aW9uU2NhbGluZyBTdGVwU2NhbGluZ0FjdGlvblxuICAgKiBhcyBhbiBhbGFybSBhY3Rpb25cbiAgICovXG4gIHB1YmxpYyBiaW5kKF9zY29wZTogQ29uc3RydWN0LCBfYWxhcm06IGNsb3Vkd2F0Y2guSUFsYXJtKTogY2xvdWR3YXRjaC5BbGFybUFjdGlvbkNvbmZpZyB7XG4gICAgcmV0dXJuIHsgYWxhcm1BY3Rpb25Bcm46IHRoaXMuc3RlcFNjYWxpbmdBY3Rpb24uc2NhbGluZ1BvbGljeUFybiB9O1xuICB9XG59XG4iXX0=