"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SsmAction = exports.OpsItemCategory = exports.OpsItemSeverity = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core");
/**
 * Types of OpsItem severity available
 */
var OpsItemSeverity;
(function (OpsItemSeverity) {
    /**
     * Set the severity to critical
     */
    OpsItemSeverity["CRITICAL"] = "1";
    /**
     * Set the severity to high
     */
    OpsItemSeverity["HIGH"] = "2";
    /**
     * Set the severity to medium
     */
    OpsItemSeverity["MEDIUM"] = "3";
    /**
     * Set the severity to low
     */
    OpsItemSeverity["LOW"] = "4";
})(OpsItemSeverity = exports.OpsItemSeverity || (exports.OpsItemSeverity = {}));
/**
 * Types of OpsItem category available
 */
var OpsItemCategory;
(function (OpsItemCategory) {
    /**
     * Set the category to availability
     */
    OpsItemCategory["AVAILABILITY"] = "Availability";
    /**
     * Set the category to cost
     */
    OpsItemCategory["COST"] = "Cost";
    /**
     * Set the category to performance
     */
    OpsItemCategory["PERFORMANCE"] = "Performance";
    /**
     * Set the category to recovery
     */
    OpsItemCategory["RECOVERY"] = "Recovery";
    /**
     * Set the category to security
     */
    OpsItemCategory["SECURITY"] = "Security";
})(OpsItemCategory = exports.OpsItemCategory || (exports.OpsItemCategory = {}));
/**
 * Use an SSM OpsItem action as an Alarm action
 */
class SsmAction {
    constructor(severity, category) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_cloudwatch_actions_OpsItemSeverity(severity);
            jsiiDeprecationWarnings.monocdk_aws_cloudwatch_actions_OpsItemCategory(category);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, SsmAction);
            }
            throw error;
        }
        this.severity = severity;
        this.category = category;
    }
    /**
     * Returns an alarm action configuration to use an SSM OpsItem action as an alarm action
     */
    bind(_scope, _alarm) {
        try {
            jsiiDeprecationWarnings.monocdk_Construct(_scope);
            jsiiDeprecationWarnings.monocdk_aws_cloudwatch_IAlarm(_alarm);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        if (this.category === undefined) {
            return { alarmActionArn: `arn:${core_1.Stack.of(_scope).partition}:ssm:${core_1.Stack.of(_scope).region}:${core_1.Stack.of(_scope).account}:opsitem:${this.severity}` };
        }
        else {
            return { alarmActionArn: `arn:${core_1.Stack.of(_scope).partition}:ssm:${core_1.Stack.of(_scope).region}:${core_1.Stack.of(_scope).account}:opsitem:${this.severity}#CATEGORY=${this.category}` };
        }
    }
}
exports.SsmAction = SsmAction;
_a = JSII_RTTI_SYMBOL_1;
SsmAction[_a] = { fqn: "monocdk.aws_cloudwatch_actions.SsmAction", version: "1.191.0" };
//# sourceMappingURL=data:application/json;base64,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