"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Cache = exports.LocalCacheMode = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core");
/**
 * Local cache modes to enable for the CodeBuild Project
 */
var LocalCacheMode;
(function (LocalCacheMode) {
    /**
     * Caches Git metadata for primary and secondary sources
     */
    LocalCacheMode["SOURCE"] = "LOCAL_SOURCE_CACHE";
    /**
     * Caches existing Docker layers
     */
    LocalCacheMode["DOCKER_LAYER"] = "LOCAL_DOCKER_LAYER_CACHE";
    /**
     * Caches directories you specify in the buildspec file
     */
    LocalCacheMode["CUSTOM"] = "LOCAL_CUSTOM_CACHE";
})(LocalCacheMode = exports.LocalCacheMode || (exports.LocalCacheMode = {}));
/**
 * Cache options for CodeBuild Project.
 * A cache can store reusable pieces of your build environment and use them across multiple builds.
 * @see https://docs.aws.amazon.com/codebuild/latest/userguide/build-caching.html
 */
class Cache {
    static none() {
        return {
            _toCloudFormation() {
                return { type: 'NO_CACHE' };
            },
            _bind() {
            },
        };
    }
    /**
     * Create a local caching strategy.
     * @param modes the mode(s) to enable for local caching
     */
    static local(...modes) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_codebuild_LocalCacheMode(modes);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.local);
            }
            throw error;
        }
        return {
            _toCloudFormation: () => ({
                type: 'LOCAL',
                modes,
            }),
            _bind: () => { return; },
        };
    }
    /**
     * Create an S3 caching strategy.
     * @param bucket the S3 bucket to use for caching
     * @param options additional options to pass to the S3 caching
     */
    static bucket(bucket, options) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_s3_IBucket(bucket);
            jsiiDeprecationWarnings.monocdk_aws_codebuild_BucketCacheOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bucket);
            }
            throw error;
        }
        return {
            _toCloudFormation: () => ({
                type: 'S3',
                location: core_1.Fn.join('/', [bucket.bucketName, options && options.prefix || core_1.Aws.NO_VALUE]),
            }),
            _bind: (project) => {
                bucket.grantReadWrite(project);
            },
        };
    }
}
exports.Cache = Cache;
_a = JSII_RTTI_SYMBOL_1;
Cache[_a] = { fqn: "monocdk.aws_codebuild.Cache", version: "1.191.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY2FjaGUuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJjYWNoZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7QUFDQSxxQ0FBcUM7QUFXckM7O0dBRUc7QUFDSCxJQUFZLGNBZVg7QUFmRCxXQUFZLGNBQWM7SUFDeEI7O09BRUc7SUFDSCwrQ0FBNkIsQ0FBQTtJQUU3Qjs7T0FFRztJQUNILDJEQUF5QyxDQUFBO0lBRXpDOztPQUVHO0lBQ0gsK0NBQTZCLENBQUE7QUFDL0IsQ0FBQyxFQWZXLGNBQWMsR0FBZCxzQkFBYyxLQUFkLHNCQUFjLFFBZXpCO0FBRUQ7Ozs7R0FJRztBQUNILE1BQXNCLEtBQUs7SUFDbEIsTUFBTSxDQUFDLElBQUk7UUFDaEIsT0FBTztZQUNMLGlCQUFpQjtnQkFDZixPQUFPLEVBQUUsSUFBSSxFQUFFLFVBQVUsRUFBRSxDQUFDO1lBQzlCLENBQUM7WUFDRCxLQUFLO1lBQ0wsQ0FBQztTQUNGLENBQUM7S0FDSDtJQUVEOzs7T0FHRztJQUNJLE1BQU0sQ0FBQyxLQUFLLENBQUMsR0FBRyxLQUF1Qjs7Ozs7Ozs7OztRQUM1QyxPQUFPO1lBQ0wsaUJBQWlCLEVBQUUsR0FBRyxFQUFFLENBQUMsQ0FBQztnQkFDeEIsSUFBSSxFQUFFLE9BQU87Z0JBQ2IsS0FBSzthQUNOLENBQUM7WUFDRixLQUFLLEVBQUUsR0FBRyxFQUFFLEdBQUcsT0FBTyxDQUFDLENBQUM7U0FDekIsQ0FBQztLQUNIO0lBRUQ7Ozs7T0FJRztJQUNJLE1BQU0sQ0FBQyxNQUFNLENBQUMsTUFBZSxFQUFFLE9BQTRCOzs7Ozs7Ozs7OztRQUNoRSxPQUFPO1lBQ0wsaUJBQWlCLEVBQUUsR0FBRyxFQUFFLENBQUMsQ0FBQztnQkFDeEIsSUFBSSxFQUFFLElBQUk7Z0JBQ1YsUUFBUSxFQUFFLFNBQUUsQ0FBQyxJQUFJLENBQUMsR0FBRyxFQUFFLENBQUMsTUFBTSxDQUFDLFVBQVUsRUFBRSxPQUFPLElBQUksT0FBTyxDQUFDLE1BQU0sSUFBSSxVQUFHLENBQUMsUUFBUSxDQUFDLENBQUM7YUFDdkYsQ0FBQztZQUNGLEtBQUssRUFBRSxDQUFDLE9BQU8sRUFBRSxFQUFFO2dCQUNqQixNQUFNLENBQUMsY0FBYyxDQUFDLE9BQU8sQ0FBQyxDQUFDO1lBQ2pDLENBQUM7U0FDRixDQUFDO0tBQ0g7O0FBeENILHNCQW1EQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IElCdWNrZXQgfSBmcm9tICcuLi8uLi9hd3MtczMnO1xuaW1wb3J0IHsgQXdzLCBGbiB9IGZyb20gJy4uLy4uL2NvcmUnO1xuaW1wb3J0IHsgQ2ZuUHJvamVjdCB9IGZyb20gJy4vY29kZWJ1aWxkLmdlbmVyYXRlZCc7XG5pbXBvcnQgeyBJUHJvamVjdCB9IGZyb20gJy4vcHJvamVjdCc7XG5cbmV4cG9ydCBpbnRlcmZhY2UgQnVja2V0Q2FjaGVPcHRpb25zIHtcbiAgLyoqXG4gICAqIFRoZSBwcmVmaXggdG8gdXNlIHRvIHN0b3JlIHRoZSBjYWNoZSBpbiB0aGUgYnVja2V0XG4gICAqL1xuICByZWFkb25seSBwcmVmaXg/OiBzdHJpbmc7XG59XG5cbi8qKlxuICogTG9jYWwgY2FjaGUgbW9kZXMgdG8gZW5hYmxlIGZvciB0aGUgQ29kZUJ1aWxkIFByb2plY3RcbiAqL1xuZXhwb3J0IGVudW0gTG9jYWxDYWNoZU1vZGUge1xuICAvKipcbiAgICogQ2FjaGVzIEdpdCBtZXRhZGF0YSBmb3IgcHJpbWFyeSBhbmQgc2Vjb25kYXJ5IHNvdXJjZXNcbiAgICovXG4gIFNPVVJDRSA9ICdMT0NBTF9TT1VSQ0VfQ0FDSEUnLFxuXG4gIC8qKlxuICAgKiBDYWNoZXMgZXhpc3RpbmcgRG9ja2VyIGxheWVyc1xuICAgKi9cbiAgRE9DS0VSX0xBWUVSID0gJ0xPQ0FMX0RPQ0tFUl9MQVlFUl9DQUNIRScsXG5cbiAgLyoqXG4gICAqIENhY2hlcyBkaXJlY3RvcmllcyB5b3Ugc3BlY2lmeSBpbiB0aGUgYnVpbGRzcGVjIGZpbGVcbiAgICovXG4gIENVU1RPTSA9ICdMT0NBTF9DVVNUT01fQ0FDSEUnLFxufVxuXG4vKipcbiAqIENhY2hlIG9wdGlvbnMgZm9yIENvZGVCdWlsZCBQcm9qZWN0LlxuICogQSBjYWNoZSBjYW4gc3RvcmUgcmV1c2FibGUgcGllY2VzIG9mIHlvdXIgYnVpbGQgZW52aXJvbm1lbnQgYW5kIHVzZSB0aGVtIGFjcm9zcyBtdWx0aXBsZSBidWlsZHMuXG4gKiBAc2VlIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9jb2RlYnVpbGQvbGF0ZXN0L3VzZXJndWlkZS9idWlsZC1jYWNoaW5nLmh0bWxcbiAqL1xuZXhwb3J0IGFic3RyYWN0IGNsYXNzIENhY2hlIHtcbiAgcHVibGljIHN0YXRpYyBub25lKCk6IENhY2hlIHtcbiAgICByZXR1cm4ge1xuICAgICAgX3RvQ2xvdWRGb3JtYXRpb24oKTogQ2ZuUHJvamVjdC5Qcm9qZWN0Q2FjaGVQcm9wZXJ0eSB8IHVuZGVmaW5lZCB7XG4gICAgICAgIHJldHVybiB7IHR5cGU6ICdOT19DQUNIRScgfTtcbiAgICAgIH0sXG4gICAgICBfYmluZCgpOiB2b2lkIHtcbiAgICAgIH0sXG4gICAgfTtcbiAgfVxuXG4gIC8qKlxuICAgKiBDcmVhdGUgYSBsb2NhbCBjYWNoaW5nIHN0cmF0ZWd5LlxuICAgKiBAcGFyYW0gbW9kZXMgdGhlIG1vZGUocykgdG8gZW5hYmxlIGZvciBsb2NhbCBjYWNoaW5nXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIGxvY2FsKC4uLm1vZGVzOiBMb2NhbENhY2hlTW9kZVtdKTogQ2FjaGUge1xuICAgIHJldHVybiB7XG4gICAgICBfdG9DbG91ZEZvcm1hdGlvbjogKCkgPT4gKHtcbiAgICAgICAgdHlwZTogJ0xPQ0FMJyxcbiAgICAgICAgbW9kZXMsXG4gICAgICB9KSxcbiAgICAgIF9iaW5kOiAoKSA9PiB7IHJldHVybjsgfSxcbiAgICB9O1xuICB9XG5cbiAgLyoqXG4gICAqIENyZWF0ZSBhbiBTMyBjYWNoaW5nIHN0cmF0ZWd5LlxuICAgKiBAcGFyYW0gYnVja2V0IHRoZSBTMyBidWNrZXQgdG8gdXNlIGZvciBjYWNoaW5nXG4gICAqIEBwYXJhbSBvcHRpb25zIGFkZGl0aW9uYWwgb3B0aW9ucyB0byBwYXNzIHRvIHRoZSBTMyBjYWNoaW5nXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIGJ1Y2tldChidWNrZXQ6IElCdWNrZXQsIG9wdGlvbnM/OiBCdWNrZXRDYWNoZU9wdGlvbnMpOiBDYWNoZSB7XG4gICAgcmV0dXJuIHtcbiAgICAgIF90b0Nsb3VkRm9ybWF0aW9uOiAoKSA9PiAoe1xuICAgICAgICB0eXBlOiAnUzMnLFxuICAgICAgICBsb2NhdGlvbjogRm4uam9pbignLycsIFtidWNrZXQuYnVja2V0TmFtZSwgb3B0aW9ucyAmJiBvcHRpb25zLnByZWZpeCB8fCBBd3MuTk9fVkFMVUVdKSxcbiAgICAgIH0pLFxuICAgICAgX2JpbmQ6IChwcm9qZWN0KSA9PiB7XG4gICAgICAgIGJ1Y2tldC5ncmFudFJlYWRXcml0ZShwcm9qZWN0KTtcbiAgICAgIH0sXG4gICAgfTtcbiAgfVxuXG4gIC8qKlxuICAgKiBAaW50ZXJuYWxcbiAgICovXG4gIHB1YmxpYyBhYnN0cmFjdCBfdG9DbG91ZEZvcm1hdGlvbigpOiBDZm5Qcm9qZWN0LlByb2plY3RDYWNoZVByb3BlcnR5IHwgdW5kZWZpbmVkO1xuXG4gIC8qKlxuICAgKiBAaW50ZXJuYWxcbiAgICovXG4gIHB1YmxpYyBhYnN0cmFjdCBfYmluZChwcm9qZWN0OiBJUHJvamVjdCk6IHZvaWQ7XG59XG4iXX0=