"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PipelineNotificationEvents = exports.Action = exports.GlobalVariables = exports.ActionCategory = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const events = require("../../aws-events");
const core_1 = require("../../core");
var ActionCategory;
(function (ActionCategory) {
    ActionCategory["SOURCE"] = "Source";
    ActionCategory["BUILD"] = "Build";
    ActionCategory["TEST"] = "Test";
    ActionCategory["APPROVAL"] = "Approval";
    ActionCategory["DEPLOY"] = "Deploy";
    ActionCategory["INVOKE"] = "Invoke";
})(ActionCategory = exports.ActionCategory || (exports.ActionCategory = {}));
/**
 * The CodePipeline variables that are global,
 * not bound to a specific action.
 * This class defines a bunch of static fields that represent the different variables.
 * These can be used can be used in any action configuration.
 */
class GlobalVariables {
}
exports.GlobalVariables = GlobalVariables;
_a = JSII_RTTI_SYMBOL_1;
GlobalVariables[_a] = { fqn: "monocdk.aws_codepipeline.GlobalVariables", version: "1.191.0" };
/** The identifier of the current pipeline execution. */
GlobalVariables.executionId = '#{codepipeline.PipelineExecutionId}';
/**
 * Low-level class for generic CodePipeline Actions implementing the {@link IAction} interface.
 * Contains some common logic that can be re-used by all {@link IAction} implementations.
 * If you're writing your own Action class,
 * feel free to extend this class.
 */
class Action {
    constructor() {
        this._variableReferenced = false;
        this._namespaceToken = core_1.Lazy.string({
            produce: () => {
                // make sure the action was bound (= added to a pipeline)
                if (this._actualNamespace === undefined) {
                    throw new Error(`Cannot reference variables of action '${this.actionProperties.actionName}', ` +
                        'as that action was never added to a pipeline');
                }
                else {
                    return this._customerProvidedNamespace !== undefined
                        // if a customer passed a namespace explicitly, always use that
                        ? this._customerProvidedNamespace
                        // otherwise, only return a namespace if any variable was referenced
                        : (this._variableReferenced ? this._actualNamespace : undefined);
                }
            },
        });
    }
    get actionProperties() {
        if (this.__actionProperties === undefined) {
            const actionProperties = this.providedActionProperties;
            this._customerProvidedNamespace = actionProperties.variablesNamespace;
            this.__actionProperties = {
                ...actionProperties,
                variablesNamespace: this._customerProvidedNamespace === undefined
                    ? this._namespaceToken
                    : this._customerProvidedNamespace,
            };
        }
        return this.__actionProperties;
    }
    bind(scope, stage, options) {
        try {
            jsiiDeprecationWarnings.monocdk_Construct(scope);
            jsiiDeprecationWarnings.monocdk_aws_codepipeline_IStage(stage);
            jsiiDeprecationWarnings.monocdk_aws_codepipeline_ActionBindOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        this.__pipeline = stage.pipeline;
        this.__stage = stage;
        this.__scope = scope;
        this._actualNamespace = this._customerProvidedNamespace === undefined
            // default a namespace name, based on the stage and action names
            ? `${stage.stageName}_${this.actionProperties.actionName}_NS`
            : this._customerProvidedNamespace;
        return this.bound(scope, stage, options);
    }
    onStateChange(name, target, options) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_events_IRuleTarget(target);
            jsiiDeprecationWarnings.monocdk_aws_events_RuleProps(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.onStateChange);
            }
            throw error;
        }
        const rule = new events.Rule(this._scope, name, options);
        rule.addTarget(target);
        rule.addEventPattern({
            detailType: ['CodePipeline Action Execution State Change'],
            source: ['aws.codepipeline'],
            resources: [this._pipeline.pipelineArn],
            detail: {
                stage: [this._stage.stageName],
                action: [this.actionProperties.actionName],
            },
        });
        return rule;
    }
    variableExpression(variableName) {
        this._variableReferenced = true;
        return `#{${this._namespaceToken}.${variableName}}`;
    }
    get _pipeline() {
        if (this.__pipeline) {
            return this.__pipeline;
        }
        else {
            throw new Error('Action must be added to a stage that is part of a pipeline before using onStateChange');
        }
    }
    get _stage() {
        if (this.__stage) {
            return this.__stage;
        }
        else {
            throw new Error('Action must be added to a stage that is part of a pipeline before using onStateChange');
        }
    }
    /**
     * Retrieves the Construct scope of this Action.
     * Only available after the Action has been added to a Stage,
     * and that Stage to a Pipeline.
     */
    get _scope() {
        if (this.__scope) {
            return this.__scope;
        }
        else {
            throw new Error('Action must be added to a stage that is part of a pipeline first');
        }
    }
}
exports.Action = Action;
_b = JSII_RTTI_SYMBOL_1;
Action[_b] = { fqn: "monocdk.aws_codepipeline.Action", version: "1.191.0" };
/**
 * The list of event types for AWS Codepipeline Pipeline
 * @see https://docs.aws.amazon.com/dtconsole/latest/userguide/concepts.html#events-ref-pipeline
 */
var PipelineNotificationEvents;
(function (PipelineNotificationEvents) {
    /**
     * Trigger notification when pipeline execution failed
     */
    PipelineNotificationEvents["PIPELINE_EXECUTION_FAILED"] = "codepipeline-pipeline-pipeline-execution-failed";
    /**
     * Trigger notification when pipeline execution canceled
     */
    PipelineNotificationEvents["PIPELINE_EXECUTION_CANCELED"] = "codepipeline-pipeline-pipeline-execution-canceled";
    /**
     * Trigger notification when pipeline execution started
     */
    PipelineNotificationEvents["PIPELINE_EXECUTION_STARTED"] = "codepipeline-pipeline-pipeline-execution-started";
    /**
     * Trigger notification when pipeline execution resumed
     */
    PipelineNotificationEvents["PIPELINE_EXECUTION_RESUMED"] = "codepipeline-pipeline-pipeline-execution-resumed";
    /**
     * Trigger notification when pipeline execution succeeded
     */
    PipelineNotificationEvents["PIPELINE_EXECUTION_SUCCEEDED"] = "codepipeline-pipeline-pipeline-execution-succeeded";
    /**
     * Trigger notification when pipeline execution superseded
     */
    PipelineNotificationEvents["PIPELINE_EXECUTION_SUPERSEDED"] = "codepipeline-pipeline-pipeline-execution-superseded";
    /**
     * Trigger notification when pipeline stage execution started
     */
    PipelineNotificationEvents["STAGE_EXECUTION_STARTED"] = "codepipeline-pipeline-stage-execution-started";
    /**
    * Trigger notification when pipeline stage execution succeeded
    */
    PipelineNotificationEvents["STAGE_EXECUTION_SUCCEEDED"] = "codepipeline-pipeline-stage-execution-succeeded";
    /**
    * Trigger notification when pipeline stage execution resumed
    */
    PipelineNotificationEvents["STAGE_EXECUTION_RESUMED"] = "codepipeline-pipeline-stage-execution-resumed";
    /**
    * Trigger notification when pipeline stage execution canceled
    */
    PipelineNotificationEvents["STAGE_EXECUTION_CANCELED"] = "codepipeline-pipeline-stage-execution-canceled";
    /**
    * Trigger notification when pipeline stage execution failed
    */
    PipelineNotificationEvents["STAGE_EXECUTION_FAILED"] = "codepipeline-pipeline-stage-execution-failed";
    /**
     * Trigger notification when pipeline action execution succeeded
     */
    PipelineNotificationEvents["ACTION_EXECUTION_SUCCEEDED"] = "codepipeline-pipeline-action-execution-succeeded";
    /**
     * Trigger notification when pipeline action execution failed
     */
    PipelineNotificationEvents["ACTION_EXECUTION_FAILED"] = "codepipeline-pipeline-action-execution-failed";
    /**
     * Trigger notification when pipeline action execution canceled
     */
    PipelineNotificationEvents["ACTION_EXECUTION_CANCELED"] = "codepipeline-pipeline-action-execution-canceled";
    /**
     * Trigger notification when pipeline action execution started
     */
    PipelineNotificationEvents["ACTION_EXECUTION_STARTED"] = "codepipeline-pipeline-action-execution-started";
    /**
     * Trigger notification when pipeline manual approval failed
     */
    PipelineNotificationEvents["MANUAL_APPROVAL_FAILED"] = "codepipeline-pipeline-manual-approval-failed";
    /**
     * Trigger notification when pipeline manual approval needed
     */
    PipelineNotificationEvents["MANUAL_APPROVAL_NEEDED"] = "codepipeline-pipeline-manual-approval-needed";
    /**
     * Trigger notification when pipeline manual approval succeeded
     */
    PipelineNotificationEvents["MANUAL_APPROVAL_SUCCEEDED"] = "codepipeline-pipeline-manual-approval-succeeded";
})(PipelineNotificationEvents = exports.PipelineNotificationEvents || (exports.PipelineNotificationEvents = {}));
//# sourceMappingURL=data:application/json;base64,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