"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserPoolAuthenticationProvider = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core");
const constructs_1 = require("constructs");
/**
 * Defines a User Pool Authentication Provider
 */
class UserPoolAuthenticationProvider {
    constructor(props) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_cognito_identitypool_UserPoolAuthenticationProviderProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, UserPoolAuthenticationProvider);
            }
            throw error;
        }
        this.userPool = props.userPool;
        this.userPoolClient = props.userPoolClient || this.userPool.addClient('UserPoolAuthenticationProviderClient');
        this.disableServerSideTokenCheck = props.disableServerSideTokenCheck ?? false;
    }
    bind(scope, identityPool, _options) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_cognito_identitypool_IIdentityPool(identityPool);
            jsiiDeprecationWarnings.monocdk_aws_cognito_identitypool_UserPoolAuthenticationProviderBindOptions(_options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        constructs_1.Node.of(identityPool).addDependency(this.userPool);
        constructs_1.Node.of(identityPool).addDependency(this.userPoolClient);
        const region = core_1.Stack.of(scope).region;
        const urlSuffix = core_1.Stack.of(scope).urlSuffix;
        return {
            clientId: this.userPoolClient.userPoolClientId,
            providerName: `cognito-idp.${region}.${urlSuffix}/${this.userPool.userPoolId}`,
            serverSideTokenCheck: !this.disableServerSideTokenCheck,
        };
    }
}
exports.UserPoolAuthenticationProvider = UserPoolAuthenticationProvider;
_a = JSII_RTTI_SYMBOL_1;
UserPoolAuthenticationProvider[_a] = { fqn: "monocdk.aws_cognito_identitypool.UserPoolAuthenticationProvider", version: "1.191.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaWRlbnRpdHlwb29sLXVzZXItcG9vbC1hdXRoZW50aWNhdGlvbi1wcm92aWRlci5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImlkZW50aXR5cG9vbC11c2VyLXBvb2wtYXV0aGVudGljYXRpb24tcHJvdmlkZXIudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBSUEscUNBQW1DO0FBQ25DLDJDQUVvQjtBQXFFcEI7O0dBRUc7QUFDSCxNQUFhLDhCQUE4QjtJQWdCekMsWUFBWSxLQUEwQzs7Ozs7OytDQWhCM0MsOEJBQThCOzs7O1FBaUJ2QyxJQUFJLENBQUMsUUFBUSxHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUM7UUFDL0IsSUFBSSxDQUFDLGNBQWMsR0FBRyxLQUFLLENBQUMsY0FBYyxJQUFJLElBQUksQ0FBQyxRQUFRLENBQUMsU0FBUyxDQUFDLHNDQUFzQyxDQUFDLENBQUM7UUFDOUcsSUFBSSxDQUFDLDJCQUEyQixHQUFHLEtBQUssQ0FBQywyQkFBMkIsSUFBSSxLQUFLLENBQUM7S0FDL0U7SUFFTSxJQUFJLENBQ1QsS0FBZ0IsRUFDaEIsWUFBMkIsRUFDM0IsUUFBb0Q7Ozs7Ozs7Ozs7O1FBRXBELGlCQUFJLENBQUMsRUFBRSxDQUFDLFlBQVksQ0FBQyxDQUFDLGFBQWEsQ0FBQyxJQUFJLENBQUMsUUFBUSxDQUFDLENBQUM7UUFDbkQsaUJBQUksQ0FBQyxFQUFFLENBQUMsWUFBWSxDQUFDLENBQUMsYUFBYSxDQUFDLElBQUksQ0FBQyxjQUFjLENBQUMsQ0FBQztRQUN6RCxNQUFNLE1BQU0sR0FBRyxZQUFLLENBQUMsRUFBRSxDQUFDLEtBQUssQ0FBQyxDQUFDLE1BQU0sQ0FBQztRQUN0QyxNQUFNLFNBQVMsR0FBRyxZQUFLLENBQUMsRUFBRSxDQUFDLEtBQUssQ0FBQyxDQUFDLFNBQVMsQ0FBQztRQUU1QyxPQUFPO1lBQ0wsUUFBUSxFQUFFLElBQUksQ0FBQyxjQUFjLENBQUMsZ0JBQWdCO1lBQzlDLFlBQVksRUFBRSxlQUFlLE1BQU0sSUFBSSxTQUFTLElBQUksSUFBSSxDQUFDLFFBQVEsQ0FBQyxVQUFVLEVBQUU7WUFDOUUsb0JBQW9CLEVBQUUsQ0FBQyxJQUFJLENBQUMsMkJBQTJCO1NBQ3hELENBQUM7S0FDSDs7QUFyQ0gsd0VBc0NDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHtcbiAgSVVzZXJQb29sLFxuICBJVXNlclBvb2xDbGllbnQsXG59IGZyb20gJy4uLy4uL2F3cy1jb2duaXRvJztcbmltcG9ydCB7IFN0YWNrIH0gZnJvbSAnLi4vLi4vY29yZSc7XG5pbXBvcnQge1xuICBDb25zdHJ1Y3QsIE5vZGUsXG59IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0IHsgSUlkZW50aXR5UG9vbCB9IGZyb20gJy4vaWRlbnRpdHlwb29sJztcblxuLyoqXG4gKiBSZXByZXNlbnRzIHRoZSBjb25jZXB0IG9mIGEgVXNlciBQb29sIEF1dGhlbnRpY2F0aW9uIFByb3ZpZGVyLlxuICogWW91IHVzZSB1c2VyIHBvb2wgYXV0aGVudGljYXRpb24gcHJvdmlkZXJzIHRvIGNvbmZpZ3VyZSBVc2VyIFBvb2xzXG4gKiBhbmQgVXNlciBQb29sIENsaWVudHMgZm9yIHVzZSB3aXRoIElkZW50aXR5IFBvb2xzXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgSVVzZXJQb29sQXV0aGVudGljYXRpb25Qcm92aWRlciB7XG4gIC8qKlxuICAgKiBUaGUgbWV0aG9kIGNhbGxlZCB3aGVuIGEgZ2l2ZW4gVXNlciBQb29sIEF1dGhlbnRpY2F0aW9uIFByb3ZpZGVyIGlzIGFkZGVkXG4gICAqIChmb3IgdGhlIGZpcnN0IHRpbWUpIHRvIGFuIElkZW50aXR5IFBvb2wuXG4gICAqL1xuICBiaW5kKFxuICAgIHNjb3BlOiBDb25zdHJ1Y3QsXG4gICAgaWRlbnRpdHlQb29sOiBJSWRlbnRpdHlQb29sLFxuICAgIG9wdGlvbnM/OiBVc2VyUG9vbEF1dGhlbnRpY2F0aW9uUHJvdmlkZXJCaW5kT3B0aW9uc1xuICApOiBVc2VyUG9vbEF1dGhlbnRpY2F0aW9uUHJvdmlkZXJCaW5kQ29uZmlnO1xufVxuXG4vKipcbiAqIFByb3BzIGZvciB0aGUgVXNlciBQb29sIEF1dGhlbnRpY2F0aW9uIFByb3ZpZGVyXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgVXNlclBvb2xBdXRoZW50aWNhdGlvblByb3ZpZGVyUHJvcHMge1xuICAvKipcbiAgICogVGhlIFVzZXIgUG9vbCBvZiB0aGUgQXNzb2NpYXRlZCBJZGVudGl0eSBQcm92aWRlcnNcbiAgICovXG4gIHJlYWRvbmx5IHVzZXJQb29sOiBJVXNlclBvb2w7XG5cbiAgLyoqXG4gICAqIFRoZSBVc2VyIFBvb2wgQ2xpZW50IGZvciB0aGUgcHJvdmlkZWQgVXNlciBQb29sXG4gICAqIEBkZWZhdWx0IC0gQSBkZWZhdWx0IHVzZXIgcG9vbCBjbGllbnQgd2lsbCBiZSBhZGRlZCB0byBVc2VyIFBvb2xcbiAgICovXG4gIHJlYWRvbmx5IHVzZXJQb29sQ2xpZW50PzogSVVzZXJQb29sQ2xpZW50O1xuXG4gIC8qKlxuICAgKiBTZXR0aW5nIHRoaXMgdG8gdHJ1ZSB0dXJucyBvZmYgaWRlbnRpdHkgcG9vbCBjaGVja3MgZm9yIHRoaXMgdXNlciBwb29sIHRvIG1ha2Ugc3VyZSB0aGUgdXNlciBoYXMgbm90IGJlZW4gZ2xvYmFsbHkgc2lnbmVkIG91dCBvciBkZWxldGVkIGJlZm9yZSB0aGUgaWRlbnRpdHkgcG9vbCBwcm92aWRlcyBhbiBPSURDIHRva2VuIG9yIEFXUyBjcmVkZW50aWFscyBmb3IgdGhlIHVzZXJcbiAgICogQHNlZSBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1jb2duaXRvLWlkZW50aXR5cG9vbC1jb2duaXRvaWRlbnRpdHlwcm92aWRlci5odG1sXG4gICAqIEBkZWZhdWx0IGZhbHNlXG4gICAqL1xuICByZWFkb25seSBkaXNhYmxlU2VydmVyU2lkZVRva2VuQ2hlY2s/OiBib29sZWFuO1xuXG59XG5cbi8qKlxuICogUmVwcmVzZW50cyBVc2VyUG9vbEF1dGhlbnRpY2F0aW9uUHJvdmlkZXIgQmluZCBPcHRpb25zXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgVXNlclBvb2xBdXRoZW50aWNhdGlvblByb3ZpZGVyQmluZE9wdGlvbnMge31cblxuLyoqXG4gKiBSZXByZXNlbnRzIGEgVXNlclBvb2xBdXRoZW50aWNhdGlvblByb3ZpZGVyIEJpbmQgQ29uZmlndXJhdGlvblxuICovXG5leHBvcnQgaW50ZXJmYWNlIFVzZXJQb29sQXV0aGVudGljYXRpb25Qcm92aWRlckJpbmRDb25maWcge1xuICAvKipcbiAgICogQ2xpZW50IElkIG9mIHRoZSBBc3NvY2lhdGVkIFVzZXIgUG9vbCBDbGllbnRcbiAgICovXG4gIHJlYWRvbmx5IGNsaWVudElkOiBzdHJpbmdcblxuICAvKipcbiAgICogVGhlIGlkZW50aXR5IHByb3ZpZGVycyBhc3NvY2lhdGVkIHdpdGggdGhlIFVzZXJQb29sXG4gICAqL1xuICByZWFkb25seSBwcm92aWRlck5hbWU6IHN0cmluZztcblxuICAvKipcbiAgICogV2hldGhlciB0byBlbmFibGUgdGhlIGlkZW50aXR5IHBvb2wncyBzZXJ2ZXIgc2lkZSB0b2tlbiBjaGVja1xuICAgKi9cbiAgcmVhZG9ubHkgc2VydmVyU2lkZVRva2VuQ2hlY2s6IGJvb2xlYW47XG59XG5cbi8qKlxuICogRGVmaW5lcyBhIFVzZXIgUG9vbCBBdXRoZW50aWNhdGlvbiBQcm92aWRlclxuICovXG5leHBvcnQgY2xhc3MgVXNlclBvb2xBdXRoZW50aWNhdGlvblByb3ZpZGVyIGltcGxlbWVudHMgSVVzZXJQb29sQXV0aGVudGljYXRpb25Qcm92aWRlciB7XG5cbiAgLyoqXG4gICAqIFRoZSBVc2VyIFBvb2wgb2YgdGhlIEFzc29jaWF0ZWQgSWRlbnRpdHkgUHJvdmlkZXJzXG4gICAqL1xuICBwcml2YXRlIHVzZXJQb29sOiBJVXNlclBvb2w7XG5cbiAgLyoqXG4gICAqIFRoZSBVc2VyIFBvb2wgQ2xpZW50IGZvciB0aGUgcHJvdmlkZWQgVXNlciBQb29sXG4gICAqL1xuICBwcml2YXRlIHVzZXJQb29sQ2xpZW50OiBJVXNlclBvb2xDbGllbnQ7XG5cbiAgLyoqXG4gICAqIFdoZXRoZXIgdG8gZGlzYWJsZSB0aGUgcG9vbCdzIGRlZmF1bHQgc2VydmVyIHNpZGUgdG9rZW4gY2hlY2tcbiAgICovXG4gIHByaXZhdGUgZGlzYWJsZVNlcnZlclNpZGVUb2tlbkNoZWNrOiBib29sZWFuXG4gIGNvbnN0cnVjdG9yKHByb3BzOiBVc2VyUG9vbEF1dGhlbnRpY2F0aW9uUHJvdmlkZXJQcm9wcykge1xuICAgIHRoaXMudXNlclBvb2wgPSBwcm9wcy51c2VyUG9vbDtcbiAgICB0aGlzLnVzZXJQb29sQ2xpZW50ID0gcHJvcHMudXNlclBvb2xDbGllbnQgfHwgdGhpcy51c2VyUG9vbC5hZGRDbGllbnQoJ1VzZXJQb29sQXV0aGVudGljYXRpb25Qcm92aWRlckNsaWVudCcpO1xuICAgIHRoaXMuZGlzYWJsZVNlcnZlclNpZGVUb2tlbkNoZWNrID0gcHJvcHMuZGlzYWJsZVNlcnZlclNpZGVUb2tlbkNoZWNrID8/IGZhbHNlO1xuICB9XG5cbiAgcHVibGljIGJpbmQoXG4gICAgc2NvcGU6IENvbnN0cnVjdCxcbiAgICBpZGVudGl0eVBvb2w6IElJZGVudGl0eVBvb2wsXG4gICAgX29wdGlvbnM/OiBVc2VyUG9vbEF1dGhlbnRpY2F0aW9uUHJvdmlkZXJCaW5kT3B0aW9ucyxcbiAgKTogVXNlclBvb2xBdXRoZW50aWNhdGlvblByb3ZpZGVyQmluZENvbmZpZyB7XG4gICAgTm9kZS5vZihpZGVudGl0eVBvb2wpLmFkZERlcGVuZGVuY3kodGhpcy51c2VyUG9vbCk7XG4gICAgTm9kZS5vZihpZGVudGl0eVBvb2wpLmFkZERlcGVuZGVuY3kodGhpcy51c2VyUG9vbENsaWVudCk7XG4gICAgY29uc3QgcmVnaW9uID0gU3RhY2sub2Yoc2NvcGUpLnJlZ2lvbjtcbiAgICBjb25zdCB1cmxTdWZmaXggPSBTdGFjay5vZihzY29wZSkudXJsU3VmZml4O1xuXG4gICAgcmV0dXJuIHtcbiAgICAgIGNsaWVudElkOiB0aGlzLnVzZXJQb29sQ2xpZW50LnVzZXJQb29sQ2xpZW50SWQsXG4gICAgICBwcm92aWRlck5hbWU6IGBjb2duaXRvLWlkcC4ke3JlZ2lvbn0uJHt1cmxTdWZmaXh9LyR7dGhpcy51c2VyUG9vbC51c2VyUG9vbElkfWAsXG4gICAgICBzZXJ2ZXJTaWRlVG9rZW5DaGVjazogIXRoaXMuZGlzYWJsZVNlcnZlclNpZGVUb2tlbkNoZWNrLFxuICAgIH07XG4gIH1cbn0iXX0=