"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClusterParameterGroup = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core");
const docdb_generated_1 = require("./docdb.generated");
/**
 * A new cluster or instance parameter group
 */
class ClusterParameterGroupBase extends core_1.Resource {
    /**
     * Imports a parameter group
     */
    static fromParameterGroupName(scope, id, parameterGroupName) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.parameterGroupName = parameterGroupName;
            }
        }
        return new Import(scope, id);
    }
}
/**
 * A cluster parameter group
 *
 * @resource AWS::DocDB::DBClusterParameterGroup
 */
class ClusterParameterGroup extends ClusterParameterGroupBase {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings.monocdk_aws_docdb_ClusterParameterGroupProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, ClusterParameterGroup);
            }
            throw error;
        }
        const resource = new docdb_generated_1.CfnDBClusterParameterGroup(this, 'Resource', {
            name: props.dbClusterParameterGroupName,
            description: props.description || `Cluster parameter group for ${props.family}`,
            family: props.family,
            parameters: props.parameters,
        });
        this.parameterGroupName = resource.ref;
    }
}
exports.ClusterParameterGroup = ClusterParameterGroup;
_a = JSII_RTTI_SYMBOL_1;
ClusterParameterGroup[_a] = { fqn: "monocdk.aws_docdb.ClusterParameterGroup", version: "1.191.0" };
//# sourceMappingURL=data:application/json;base64,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