"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const ec2 = require("../../aws-ec2");
const cdk = require("../../core");
const docdb = require("../lib");
/*
 * Stack verification steps:
 * * aws secretsmanager describe-secret --secret-id <deployed secret arn>
 * * aws lambda get-function --function-name <lambda arn from "RotationLambdaARN" in previous output
 *   * verify the lambda has the tag "serverlessrepo:applicationId" with the value
 *     "arn:aws:serverlessrepo:us-east-1:297356227824:applications/SecretsManagerMongoDBRotationSingleUser"
 */
const app = new cdk.App();
const stack = new cdk.Stack(app, 'aws-cdk-docdb-cluster-rotation');
const vpc = new ec2.Vpc(stack, 'VPC');
/// !show
const cluster = new docdb.DatabaseCluster(stack, 'Database', {
    masterUser: {
        username: 'docdb',
    },
    instanceType: ec2.InstanceType.of(ec2.InstanceClass.R5, ec2.InstanceSize.LARGE),
    vpc,
    removalPolicy: cdk.RemovalPolicy.DESTROY,
});
cluster.addRotationSingleUser();
/// !hide
app.synth();
//# sourceMappingURL=data:application/json;base64,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