"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/// !cdk-integ *
const cdk = require("../../core");
const ec2 = require("../lib");
// keep this import separate from other imports to reduce chance for merge conflicts with v2-main
// eslint-disable-next-line no-duplicate-imports, import/order
const core_1 = require("../../core");
const app = new cdk.App();
class ConstructThatTakesAVpc extends core_1.Construct {
    constructor(scope, id, _props) {
        super(scope, id);
    }
}
/// !show
/**
 * Stack1 creates the VPC
 */
class Stack1 extends cdk.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.vpc = new ec2.Vpc(this, 'VPC');
    }
}
/**
 * Stack2 consumes the VPC
 */
class Stack2 extends cdk.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        // Pass the VPC to a construct that needs it
        new ConstructThatTakesAVpc(this, 'Construct', {
            vpc: props.vpc,
        });
    }
}
const stack1 = new Stack1(app, 'Stack1');
const stack2 = new Stack2(app, 'Stack2', {
    vpc: stack1.vpc,
});
/// !hide
Array.isArray(stack2);
app.synth();
//# sourceMappingURL=data:application/json;base64,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