"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PublicGalleryAuthorizationToken = exports.AuthorizationToken = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("../../aws-iam");
/**
 * Authorization token to access private ECR repositories in the current environment via Docker CLI.
 *
 * @see https://docs.aws.amazon.com/AmazonECR/latest/userguide/registry_auth.html
 */
class AuthorizationToken {
    constructor() {
    }
    /**
     * Grant access to retrieve an authorization token.
     */
    static grantRead(grantee) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_iam_IGrantable(grantee);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.grantRead);
            }
            throw error;
        }
        grantee.grantPrincipal.addToPrincipalPolicy(new iam.PolicyStatement({
            actions: ['ecr:GetAuthorizationToken'],
            // GetAuthorizationToken only allows '*'. See https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonelasticcontainerregistry.html#amazonelasticcontainerregistry-actions-as-permissions
            resources: ['*'],
        }));
    }
}
exports.AuthorizationToken = AuthorizationToken;
_a = JSII_RTTI_SYMBOL_1;
AuthorizationToken[_a] = { fqn: "monocdk.aws_ecr.AuthorizationToken", version: "1.191.0" };
/**
 * Authorization token to access the global public ECR Gallery via Docker CLI.
 *
 * @see https://docs.aws.amazon.com/AmazonECR/latest/public/public-registries.html#public-registry-auth
 */
class PublicGalleryAuthorizationToken {
    constructor() {
    }
    /**
     * Grant access to retrieve an authorization token.
     */
    static grantRead(grantee) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_iam_IGrantable(grantee);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.grantRead);
            }
            throw error;
        }
        grantee.grantPrincipal.addToPrincipalPolicy(new iam.PolicyStatement({
            actions: ['ecr-public:GetAuthorizationToken', 'sts:GetServiceBearerToken'],
            // GetAuthorizationToken only allows '*'. See https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonelasticcontainerregistry.html#amazonelasticcontainerregistry-actions-as-permissions
            // GetServiceBearerToken only allows '*'. See https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssecuritytokenservice.html#awssecuritytokenservice-actions-as-permissions
            resources: ['*'],
        }));
    }
}
exports.PublicGalleryAuthorizationToken = PublicGalleryAuthorizationToken;
_b = JSII_RTTI_SYMBOL_1;
PublicGalleryAuthorizationToken[_b] = { fqn: "monocdk.aws_ecr.PublicGalleryAuthorizationToken", version: "1.191.0" };
//# sourceMappingURL=data:application/json;base64,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