"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ScheduledFargateTask = void 0;
const jsiiDeprecationWarnings = require("../../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_ecs_1 = require("../../../aws-ecs");
const aws_events_targets_1 = require("../../../aws-events-targets");
const scheduled_task_base_1 = require("../base/scheduled-task-base");
/**
 * A scheduled Fargate task that will be initiated off of CloudWatch Events.
 */
class ScheduledFargateTask extends scheduled_task_base_1.ScheduledTaskBase {
    /**
     * Constructs a new instance of the ScheduledFargateTask class.
     */
    constructor(scope, id, props) {
        super(scope, id, props);
        try {
            jsiiDeprecationWarnings.monocdk_aws_ecs_patterns_ScheduledFargateTaskProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, ScheduledFargateTask);
            }
            throw error;
        }
        if (props.scheduledFargateTaskDefinitionOptions && props.scheduledFargateTaskImageOptions) {
            throw new Error('You must specify either a scheduledFargateTaskDefinitionOptions or scheduledFargateTaskOptions, not both.');
        }
        else if (props.scheduledFargateTaskDefinitionOptions) {
            this.taskDefinition = props.scheduledFargateTaskDefinitionOptions.taskDefinition;
        }
        else if (props.scheduledFargateTaskImageOptions) {
            const taskImageOptions = props.scheduledFargateTaskImageOptions;
            this.taskDefinition = new aws_ecs_1.FargateTaskDefinition(this, 'ScheduledTaskDef', {
                memoryLimitMiB: taskImageOptions.memoryLimitMiB || 512,
                cpu: taskImageOptions.cpu || 256,
            });
            this.taskDefinition.addContainer('ScheduledContainer', {
                image: taskImageOptions.image,
                command: taskImageOptions.command,
                environment: taskImageOptions.environment,
                secrets: taskImageOptions.secrets,
                logging: taskImageOptions.logDriver ?? this.createAWSLogDriver(this.node.id),
            });
        }
        else {
            throw new Error('You must specify one of: taskDefinition or image');
        }
        // Use the EcsTask as the target of the EventRule
        this.task = new aws_events_targets_1.EcsTask({
            cluster: this.cluster,
            taskDefinition: this.taskDefinition,
            taskCount: this.desiredTaskCount,
            subnetSelection: this.subnetSelection,
            platformVersion: props.platformVersion,
            securityGroups: props.securityGroups,
        });
        this.addTaskAsTarget(this.task);
    }
}
exports.ScheduledFargateTask = ScheduledFargateTask;
_a = JSII_RTTI_SYMBOL_1;
ScheduledFargateTask[_a] = { fqn: "monocdk.aws_ecs_patterns.ScheduledFargateTask", version: "1.191.0" };
//# sourceMappingURL=data:application/json;base64,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