"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ImportedTaskDefinition = void 0;
const core_1 = require("../../../core");
const task_definition_1 = require("./task-definition");
/**
 * Task definition reference of an imported task
 */
class ImportedTaskDefinition extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        /**
         * Execution role for this task definition
         */
        this.executionRole = undefined;
        this.compatibility = props.compatibility ?? task_definition_1.Compatibility.EC2_AND_FARGATE;
        this.taskDefinitionArn = props.taskDefinitionArn;
        this._taskRole = props.taskRole;
        this._networkMode = props.networkMode;
    }
    get networkMode() {
        if (this._networkMode == undefined) {
            throw new Error('This operation requires the networkMode in ImportedTaskDefinition to be defined. ' +
                'Add the \'networkMode\' in ImportedTaskDefinitionProps to instantiate ImportedTaskDefinition');
        }
        else {
            return this._networkMode;
        }
    }
    get taskRole() {
        if (this._taskRole == undefined) {
            throw new Error('This operation requires the taskRole in ImportedTaskDefinition to be defined. ' +
                'Add the \'taskRole\' in ImportedTaskDefinitionProps to instantiate ImportedTaskDefinition');
        }
        else {
            return this._taskRole;
        }
    }
    /**
     * Return true if the task definition can be run on an EC2 cluster
     */
    get isEc2Compatible() {
        return task_definition_1.isEc2Compatible(this.compatibility);
    }
    /**
     * Return true if the task definition can be run on a Fargate cluster
     */
    get isFargateCompatible() {
        return task_definition_1.isFargateCompatible(this.compatibility);
    }
    /**
     * Return true if the task definition can be run on a ECS Anywhere cluster
     */
    get isExternalCompatible() {
        return task_definition_1.isExternalCompatible(this.compatibility);
    }
}
exports.ImportedTaskDefinition = ImportedTaskDefinition;
//# sourceMappingURL=data:application/json;base64,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