"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ContainerImage = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_ecr_assets_1 = require("../../aws-ecr-assets");
/**
 * Constructs for types of container images
 */
class ContainerImage {
    /**
     * Reference an image on DockerHub or another online registry
     */
    static fromRegistry(name, props = {}) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_ecs_RepositoryImageProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromRegistry);
            }
            throw error;
        }
        return new repository_1.RepositoryImage(name, props);
    }
    /**
     * Reference an image in an ECR repository
     */
    static fromEcrRepository(repository, tag = 'latest') {
        try {
            jsiiDeprecationWarnings.monocdk_aws_ecr_IRepository(repository);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromEcrRepository);
            }
            throw error;
        }
        return new ecr_1.EcrImage(repository, tag);
    }
    /**
     * Reference an image that's constructed directly from sources on disk.
     *
     * If you already have a `DockerImageAsset` instance, you can use the
     * `ContainerImage.fromDockerImageAsset` method instead.
     *
     * @param directory The directory containing the Dockerfile
     */
    static fromAsset(directory, props = {}) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_ecs_AssetImageProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromAsset);
            }
            throw error;
        }
        return new asset_image_1.AssetImage(directory, props);
    }
    /**
     * Use an existing `DockerImageAsset` for this container image.
     *
     * @param asset The `DockerImageAsset` to use for this container definition.
     */
    static fromDockerImageAsset(asset) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_ecr_assets_DockerImageAsset(asset);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromDockerImageAsset);
            }
            throw error;
        }
        return {
            bind(_scope, containerDefinition) {
                asset.repository.grantPull(containerDefinition.taskDefinition.obtainExecutionRole());
                return {
                    imageName: asset.imageUri,
                };
            },
        };
    }
    /**
     * Use an existing tarball for this container image.
     *
     * Use this method if the container image has already been created by another process (e.g. jib)
     * and you want to add it as a container image asset.
     *
     * @param tarballFile Absolute path to the tarball. You can use language-specific idioms (such as `__dirname` in Node.js)
     *                    to create an absolute path based on the current script running directory.
     */
    static fromTarball(tarballFile) {
        return {
            bind(scope, containerDefinition) {
                const asset = new aws_ecr_assets_1.TarballImageAsset(scope, 'Tarball', { tarballFile });
                asset.repository.grantPull(containerDefinition.taskDefinition.obtainExecutionRole());
                return {
                    imageName: asset.imageUri,
                };
            },
        };
    }
}
exports.ContainerImage = ContainerImage;
_a = JSII_RTTI_SYMBOL_1;
ContainerImage[_a] = { fqn: "monocdk.aws_ecs.ContainerImage", version: "1.191.0" };
const asset_image_1 = require("./images/asset-image");
const ecr_1 = require("./images/ecr");
const repository_1 = require("./images/repository");
//# sourceMappingURL=data:application/json;base64,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