"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExternalTaskDefinition = void 0;
const jsiiDeprecationWarnings = require("../../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const _imported_task_definition_1 = require("../../lib/base/_imported-task-definition");
const task_definition_1 = require("../base/task-definition");
/**
 * The details of a task definition run on an External cluster.
 *
 * @resource AWS::ECS::TaskDefinition
 */
class ExternalTaskDefinition extends task_definition_1.TaskDefinition {
    /**
     * Constructs a new instance of the ExternalTaskDefinition class.
     */
    constructor(scope, id, props = {}) {
        super(scope, id, {
            ...props,
            compatibility: task_definition_1.Compatibility.EXTERNAL,
            networkMode: task_definition_1.NetworkMode.BRIDGE,
        });
        try {
            jsiiDeprecationWarnings.monocdk_aws_ecs_ExternalTaskDefinitionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, ExternalTaskDefinition);
            }
            throw error;
        }
    }
    /**
     * Imports a task definition from the specified task definition ARN.
     */
    static fromEc2TaskDefinitionArn(scope, id, externalTaskDefinitionArn) {
        return new _imported_task_definition_1.ImportedTaskDefinition(scope, id, {
            taskDefinitionArn: externalTaskDefinitionArn,
        });
    }
    /**
     * Imports an existing External task definition from its attributes
     */
    static fromExternalTaskDefinitionAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_ecs_ExternalTaskDefinitionAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromExternalTaskDefinitionAttributes);
            }
            throw error;
        }
        return new _imported_task_definition_1.ImportedTaskDefinition(scope, id, {
            taskDefinitionArn: attrs.taskDefinitionArn,
            compatibility: task_definition_1.Compatibility.EXTERNAL,
            networkMode: task_definition_1.NetworkMode.BRIDGE,
            taskRole: attrs.taskRole,
        });
    }
    /**
     * Overriden method to throw error as interface accelerators are not supported for external tasks
     */
    addInferenceAccelerator(_inferenceAccelerator) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_ecs_InferenceAccelerator(_inferenceAccelerator);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addInferenceAccelerator);
            }
            throw error;
        }
        throw new Error('Cannot use inference accelerators on tasks that run on External service');
    }
}
exports.ExternalTaskDefinition = ExternalTaskDefinition;
_a = JSII_RTTI_SYMBOL_1;
ExternalTaskDefinition[_a] = { fqn: "monocdk.aws_ecs.ExternalTaskDefinition", version: "1.191.0" };
//# sourceMappingURL=data:application/json;base64,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