"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FargateTaskDefinition = void 0;
const jsiiDeprecationWarnings = require("../../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../../core");
const _imported_task_definition_1 = require("../base/_imported-task-definition");
const task_definition_1 = require("../base/task-definition");
/**
 * The details of a task definition run on a Fargate cluster.
 *
 * @resource AWS::ECS::TaskDefinition
 */
class FargateTaskDefinition extends task_definition_1.TaskDefinition {
    /**
     * Constructs a new instance of the FargateTaskDefinition class.
     */
    constructor(scope, id, props = {}) {
        super(scope, id, {
            ...props,
            cpu: props.cpu !== undefined ? core_1.Tokenization.stringifyNumber(props.cpu) : '256',
            memoryMiB: props.memoryLimitMiB !== undefined ? core_1.Tokenization.stringifyNumber(props.memoryLimitMiB) : '512',
            compatibility: task_definition_1.Compatibility.FARGATE,
            networkMode: task_definition_1.NetworkMode.AWS_VPC,
        });
        /**
         * The Docker networking mode to use for the containers in the task. Fargate tasks require the awsvpc network mode.
         */
        this.networkMode = task_definition_1.NetworkMode.AWS_VPC;
        try {
            jsiiDeprecationWarnings.monocdk_aws_ecs_FargateTaskDefinitionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, FargateTaskDefinition);
            }
            throw error;
        }
        // eslint-disable-next-line max-len
        if (props.ephemeralStorageGiB && !core_1.Token.isUnresolved(props.ephemeralStorageGiB) && (props.ephemeralStorageGiB < 21 || props.ephemeralStorageGiB > 200)) {
            throw new Error('Ephemeral storage size must be between 21GiB and 200GiB');
        }
        this.ephemeralStorageGiB = props.ephemeralStorageGiB;
    }
    /**
     * Imports a task definition from the specified task definition ARN.
     */
    static fromFargateTaskDefinitionArn(scope, id, fargateTaskDefinitionArn) {
        return new _imported_task_definition_1.ImportedTaskDefinition(scope, id, { taskDefinitionArn: fargateTaskDefinitionArn });
    }
    /**
     * Import an existing Fargate task definition from its attributes
     */
    static fromFargateTaskDefinitionAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_ecs_FargateTaskDefinitionAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromFargateTaskDefinitionAttributes);
            }
            throw error;
        }
        return new _imported_task_definition_1.ImportedTaskDefinition(scope, id, {
            taskDefinitionArn: attrs.taskDefinitionArn,
            compatibility: task_definition_1.Compatibility.FARGATE,
            networkMode: attrs.networkMode,
            taskRole: attrs.taskRole,
        });
    }
}
exports.FargateTaskDefinition = FargateTaskDefinition;
_a = JSII_RTTI_SYMBOL_1;
FargateTaskDefinition[_a] = { fqn: "monocdk.aws_ecs.FargateTaskDefinition", version: "1.191.0" };
//# sourceMappingURL=data:application/json;base64,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