"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RepositoryImage = void 0;
const jsiiDeprecationWarnings = require("../../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../../core");
const container_image_1 = require("../container-image");
/**
 * Regex pattern to check if it is an ECR image URL.
 *
 */
const ECR_IMAGE_REGEX = /(^[a-zA-Z0-9][a-zA-Z0-9-_]*).dkr.ecr.([a-zA-Z0-9][a-zA-Z0-9-_]*).amazonaws.com(.cn)?\/.*/;
/**
 * An image hosted in a public or private repository. For images hosted in Amazon ECR, see
 * [EcrImage](https://docs.aws.amazon.com/AmazonECR/latest/userguide/images.html).
 */
class RepositoryImage extends container_image_1.ContainerImage {
    /**
     * Constructs a new instance of the RepositoryImage class.
     */
    constructor(imageName, props = {}) {
        super();
        this.imageName = imageName;
        this.props = props;
        try {
            jsiiDeprecationWarnings.monocdk_aws_ecs_RepositoryImageProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, RepositoryImage);
            }
            throw error;
        }
    }
    bind(scope, containerDefinition) {
        try {
            jsiiDeprecationWarnings.monocdk_Construct(scope);
            jsiiDeprecationWarnings.monocdk_aws_ecs_ContainerDefinition(containerDefinition);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        // name could be a Token - in that case, skip validation altogether
        if (!core_1.Token.isUnresolved(this.imageName) && ECR_IMAGE_REGEX.test(this.imageName)) {
            core_1.Annotations.of(scope).addWarning("Proper policies need to be attached before pulling from ECR repository, or use 'fromEcrRepository'.");
        }
        if (this.props.credentials) {
            this.props.credentials.grantRead(containerDefinition.taskDefinition.obtainExecutionRole());
        }
        return {
            imageName: this.imageName,
            repositoryCredentials: this.props.credentials && {
                credentialsParameter: this.props.credentials.secretArn,
            },
        };
    }
}
exports.RepositoryImage = RepositoryImage;
_a = JSII_RTTI_SYMBOL_1;
RepositoryImage[_a] = { fqn: "monocdk.aws_ecs.RepositoryImage", version: "1.191.0" };
//# sourceMappingURL=data:application/json;base64,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