"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GelfLogDriver = exports.GelfCompressionType = void 0;
const jsiiDeprecationWarnings = require("../../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const log_driver_1 = require("./log-driver");
const utils_1 = require("./utils");
/**
 * The type of compression the GELF driver uses to compress each log message.
 */
var GelfCompressionType;
(function (GelfCompressionType) {
    GelfCompressionType["GZIP"] = "gzip";
    GelfCompressionType["ZLIB"] = "zlib";
    GelfCompressionType["NONE"] = "none";
})(GelfCompressionType = exports.GelfCompressionType || (exports.GelfCompressionType = {}));
/**
 * A log driver that sends log information to journald Logs.
 */
class GelfLogDriver extends log_driver_1.LogDriver {
    /**
     * Constructs a new instance of the GelfLogDriver class.
     *
     * @param props the gelf log driver configuration options.
     */
    constructor(props) {
        super();
        this.props = props;
        try {
            jsiiDeprecationWarnings.monocdk_aws_ecs_GelfLogDriverProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, GelfLogDriver);
            }
            throw error;
        }
        // Validation
        if (props.compressionLevel) {
            utils_1.ensureInRange(props.compressionLevel, -1, 9);
        }
        if (props.tcpMaxReconnect) {
            utils_1.ensurePositiveInteger(props.tcpMaxReconnect);
        }
    }
    /**
     * Called when the log driver is configured on a container
     */
    bind(_scope, _containerDefinition) {
        try {
            jsiiDeprecationWarnings.monocdk_Construct(_scope);
            jsiiDeprecationWarnings.monocdk_aws_ecs_ContainerDefinition(_containerDefinition);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        return {
            logDriver: 'gelf',
            options: utils_1.stringifyOptions({
                'gelf-address': this.props.address,
                'gelf-compression-type': this.props.compressionType,
                'gelf-compression-level': this.props.compressionLevel,
                'gelf-tcp-max-reconnect': this.props.tcpMaxReconnect,
                'gelf-tcp-reconnect-delay': this.props.tcpReconnectDelay && this.props.tcpReconnectDelay.toSeconds(),
                ...utils_1.renderCommonLogDriverOptions(this.props),
            }),
        };
    }
}
exports.GelfLogDriver = GelfLogDriver;
_a = JSII_RTTI_SYMBOL_1;
GelfLogDriver[_a] = { fqn: "monocdk.aws_ecs.GelfLogDriver", version: "1.191.0" };
//# sourceMappingURL=data:application/json;base64,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