"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GenericLogDriver = void 0;
const jsiiDeprecationWarnings = require("../../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const log_driver_1 = require("./log-driver");
const utils_1 = require("./utils");
/**
 * A log driver that sends logs to the specified driver.
 */
class GenericLogDriver extends log_driver_1.LogDriver {
    /**
     * Constructs a new instance of the GenericLogDriver class.
     *
     * @param props the generic log driver configuration options.
     */
    constructor(props) {
        super();
        try {
            jsiiDeprecationWarnings.monocdk_aws_ecs_GenericLogDriverProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, GenericLogDriver);
            }
            throw error;
        }
        this.logDriver = props.logDriver;
        this.options = props.options || {};
        this.secretOptions = props.secretOptions;
    }
    /**
     * Called when the log driver is configured on a container.
     */
    bind(_scope, _containerDefinition) {
        try {
            jsiiDeprecationWarnings.monocdk_Construct(_scope);
            jsiiDeprecationWarnings.monocdk_aws_ecs_ContainerDefinition(_containerDefinition);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        return {
            logDriver: this.logDriver,
            options: utils_1.removeEmpty(this.options),
            secretOptions: this.secretOptions && utils_1.renderLogDriverSecretOptions(this.secretOptions, _containerDefinition.taskDefinition),
        };
    }
}
exports.GenericLogDriver = GenericLogDriver;
_a = JSII_RTTI_SYMBOL_1;
GenericLogDriver[_a] = { fqn: "monocdk.aws_ecs.GenericLogDriver", version: "1.191.0" };
//# sourceMappingURL=data:application/json;base64,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