"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LogDriver = void 0;
const jsiiDeprecationWarnings = require("../../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_log_driver_1 = require("./aws-log-driver");
/**
 * The base class for log drivers.
 */
class LogDriver {
    /**
     * Creates a log driver configuration that sends log information to CloudWatch Logs.
     */
    static awsLogs(props) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_ecs_AwsLogDriverProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.awsLogs);
            }
            throw error;
        }
        return new aws_log_driver_1.AwsLogDriver(props);
    }
}
exports.LogDriver = LogDriver;
_a = JSII_RTTI_SYMBOL_1;
LogDriver[_a] = { fqn: "monocdk.aws_ecs.LogDriver", version: "1.191.0" };
//# sourceMappingURL=data:application/json;base64,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