"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.renderLogDriverSecretOptions = exports.joinWithCommas = exports.renderCommonLogDriverOptions = exports.stringifyOptions = exports.ensureInRange = exports.ensurePositiveInteger = exports.removeEmpty = void 0;
const core_1 = require("../../../core");
/**
 * Remove undefined values from a dictionary
 */
function removeEmpty(x) {
    for (const key of Object.keys(x)) {
        if (x[key] === undefined) {
            delete x[key];
        }
    }
    return x;
}
exports.removeEmpty = removeEmpty;
/**
 * Checks that a value is a positive integer
 */
function ensurePositiveInteger(val) {
    if (!core_1.Token.isUnresolved(val) && Number.isInteger(val) && val < 0) {
        throw new Error(`\`${val}\` must be a positive integer.`);
    }
}
exports.ensurePositiveInteger = ensurePositiveInteger;
/**
 * Checks that a value is contained in a range of two other values
 */
function ensureInRange(val, start, end) {
    if (!core_1.Token.isUnresolved(val) && !(val >= start && val <= end)) {
        throw new Error(`\`${val}\` must be within range ${start}:${end}`);
    }
}
exports.ensureInRange = ensureInRange;
function stringifyOptions(options) {
    const _options = {};
    const filteredOptions = removeEmpty(options);
    for (const [key, value] of Object.entries(filteredOptions)) {
        // Convert value to string
        _options[key] = core_1.SecretValue.isSecretValue(value) ? value.unsafeUnwrap() : `${value}`;
    }
    return _options;
}
exports.stringifyOptions = stringifyOptions;
function renderCommonLogDriverOptions(opts) {
    return {
        'tag': opts.tag,
        'labels': joinWithCommas(opts.labels),
        'env': joinWithCommas(opts.env),
        'env-regex': opts.envRegex,
    };
}
exports.renderCommonLogDriverOptions = renderCommonLogDriverOptions;
function joinWithCommas(xs) {
    return xs && xs.join(',');
}
exports.joinWithCommas = joinWithCommas;
function renderLogDriverSecretOptions(secretValue, taskDefinition) {
    const secrets = [];
    for (const [name, secret] of Object.entries(secretValue)) {
        secret.grantRead(taskDefinition.obtainExecutionRole());
        secrets.push({
            name,
            valueFrom: secret.arn,
        });
    }
    return secrets;
}
exports.renderLogDriverSecretOptions = renderLogDriverSecretOptions;
//# sourceMappingURL=data:application/json;base64,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