"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.OperatingSystemFamily = exports.CpuArchitecture = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * The CpuArchitecture for Fargate Runtime Platform.
 */
class CpuArchitecture {
    /**
     *
     * @param _cpuArchitecture The CPU architecture.
     */
    constructor(_cpuArchitecture) {
        this._cpuArchitecture = _cpuArchitecture;
    }
    /**
     * Other cpu architecture.
     *
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-runtimeplatform.html#cfn-ecs-taskdefinition-runtimeplatform-cpuarchitecture for all available cpu architecture.
     *
     * @param cpuArchitecture cpu architecture.
     *
     */
    static of(cpuArchitecture) { return new CpuArchitecture(cpuArchitecture); }
}
exports.CpuArchitecture = CpuArchitecture;
_a = JSII_RTTI_SYMBOL_1;
CpuArchitecture[_a] = { fqn: "monocdk.aws_ecs.CpuArchitecture", version: "1.191.0" };
/**
 * ARM64
 */
CpuArchitecture.ARM64 = CpuArchitecture.of('ARM64');
/**
 * X86_64
 */
CpuArchitecture.X86_64 = CpuArchitecture.of('X86_64');
/**
 * The operating system for Fargate Runtime Platform.
 */
class OperatingSystemFamily {
    /**
     *
     * @param _operatingSystemFamily The operating system family.
     */
    constructor(_operatingSystemFamily) {
        this._operatingSystemFamily = _operatingSystemFamily;
    }
    /**
     * Other operating system family.
     *
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-runtimeplatform.html#cfn-ecs-taskdefinition-runtimeplatform-operatingsystemfamily for all available operating system family.
     *
     * @param family operating system family.
     *
     */
    static of(family) { return new OperatingSystemFamily(family); }
}
exports.OperatingSystemFamily = OperatingSystemFamily;
_b = JSII_RTTI_SYMBOL_1;
OperatingSystemFamily[_b] = { fqn: "monocdk.aws_ecs.OperatingSystemFamily", version: "1.191.0" };
/**
 * LINUX
 */
OperatingSystemFamily.LINUX = OperatingSystemFamily.of('LINUX');
/**
 * WINDOWS_SERVER_2004_CORE
 */
OperatingSystemFamily.WINDOWS_SERVER_2004_CORE = OperatingSystemFamily.of('WINDOWS_SERVER_2004_CORE');
/**
 * WINDOWS_SERVER_2016_FULL
 */
OperatingSystemFamily.WINDOWS_SERVER_2016_FULL = OperatingSystemFamily.of('WINDOWS_SERVER_2016_FULL');
/**
 * WINDOWS_SERVER_2019_CORE
 */
OperatingSystemFamily.WINDOWS_SERVER_2019_CORE = OperatingSystemFamily.of('WINDOWS_SERVER_2019_CORE');
/**
 * WINDOWS_SERVER_2019_FULL
 */
OperatingSystemFamily.WINDOWS_SERVER_2019_FULL = OperatingSystemFamily.of('WINDOWS_SERVER_2019_FULL');
/**
 * WINDOWS_SERVER_2022_CORE
 */
OperatingSystemFamily.WINDOWS_SERVER_2022_CORE = OperatingSystemFamily.of('WINDOWS_SERVER_2022_CORE');
/**
 * WINDOWS_SERVER_2022_FULL
 */
OperatingSystemFamily.WINDOWS_SERVER_2022_FULL = OperatingSystemFamily.of('WINDOWS_SERVER_2022_FULL');
/**
 * WINDOWS_SERVER_20H2_CORE
 */
OperatingSystemFamily.WINDOWS_SERVER_20H2_CORE = OperatingSystemFamily.of('WINDOWS_SERVER_20H2_CORE');
//# sourceMappingURL=data:application/json;base64,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