"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.renderUserData = void 0;
const core_1 = require("../../core");
const spot_interrupt_handler_1 = require("./spot-interrupt-handler");
function renderUserData(clusterName, autoScalingGroup, options = {}) {
    const stack = core_1.Stack.of(autoScalingGroup);
    // determine logical id of ASG so we can signal cloudformation
    const cfn = autoScalingGroup.node.defaultChild;
    const asgLogicalId = cfn.logicalId;
    const extraArgs = new Array();
    extraArgs.push(`--use-max-pods ${options.useMaxPods ?? true}`);
    if (options.awsApiRetryAttempts) {
        extraArgs.push(`--aws-api-retry-attempts ${options.awsApiRetryAttempts}`);
    }
    if (options.enableDockerBridge) {
        extraArgs.push('--enable-docker-bridge');
    }
    if (options.dockerConfigJson) {
        extraArgs.push(`--docker-config-json '${options.dockerConfigJson}'`);
    }
    if (options.additionalArgs) {
        extraArgs.push(options.additionalArgs);
    }
    const commandLineSuffix = extraArgs.join(' ');
    const kubeletExtraArgsSuffix = options.kubeletExtraArgs || '';
    // determine lifecycle label based on whether the ASG has a spot price.
    const lifecycleLabel = autoScalingGroup.spotPrice ? spot_interrupt_handler_1.LifecycleLabel.SPOT : spot_interrupt_handler_1.LifecycleLabel.ON_DEMAND;
    const withTaints = autoScalingGroup.spotPrice ? '--register-with-taints=spotInstance=true:PreferNoSchedule' : '';
    const kubeletExtraArgs = `--node-labels lifecycle=${lifecycleLabel} ${withTaints} ${kubeletExtraArgsSuffix}`.trim();
    return [
        'set -o xtrace',
        `/etc/eks/bootstrap.sh ${clusterName} --kubelet-extra-args "${kubeletExtraArgs}" ${commandLineSuffix}`.trim(),
        `/opt/aws/bin/cfn-signal --exit-code $? --stack ${stack.stackName} --resource ${asgLogicalId} --region ${stack.region}`,
    ];
}
exports.renderUserData = renderUserData;
//# sourceMappingURL=data:application/json;base64,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