"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isComplete = exports.onEvent = void 0;
// eslint-disable-next-line import/no-extraneous-dependencies
const aws = require("aws-sdk");
const cluster_1 = require("./cluster");
const consts = require("./consts");
const fargate_1 = require("./fargate");
// eslint-disable-next-line @typescript-eslint/no-require-imports, import/no-extraneous-dependencies
const ProxyAgent = require('proxy-agent');
aws.config.logger = console;
aws.config.update({
    httpOptions: { agent: new ProxyAgent() },
});
let eks;
const defaultEksClient = {
    createCluster: req => getEksClient().createCluster(req).promise(),
    deleteCluster: req => getEksClient().deleteCluster(req).promise(),
    describeCluster: req => getEksClient().describeCluster(req).promise(),
    describeUpdate: req => getEksClient().describeUpdate(req).promise(),
    updateClusterConfig: req => getEksClient().updateClusterConfig(req).promise(),
    updateClusterVersion: req => getEksClient().updateClusterVersion(req).promise(),
    createFargateProfile: req => getEksClient().createFargateProfile(req).promise(),
    deleteFargateProfile: req => getEksClient().deleteFargateProfile(req).promise(),
    describeFargateProfile: req => getEksClient().describeFargateProfile(req).promise(),
    configureAssumeRole: req => {
        console.log(JSON.stringify({ assumeRole: req }, undefined, 2));
        const creds = new aws.ChainableTemporaryCredentials({
            params: req,
        });
        eks = new aws.EKS({ credentials: creds });
    },
};
function getEksClient() {
    if (!eks) {
        throw new Error('EKS client not initialized (call "configureAssumeRole")');
    }
    return eks;
}
async function onEvent(event) {
    const provider = createResourceHandler(event);
    return provider.onEvent();
}
exports.onEvent = onEvent;
async function isComplete(event) {
    const provider = createResourceHandler(event);
    return provider.isComplete();
}
exports.isComplete = isComplete;
function createResourceHandler(event) {
    switch (event.ResourceType) {
        case consts.CLUSTER_RESOURCE_TYPE: return new cluster_1.ClusterResourceHandler(defaultEksClient, event);
        case consts.FARGATE_PROFILE_RESOURCE_TYPE: return new fargate_1.FargateProfileResourceHandler(defaultEksClient, event);
        default:
            throw new Error(`Unsupported resource type "${event.ResourceType}`);
    }
}
//# sourceMappingURL=data:application/json;base64,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