"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HelmChart = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core");
const kubectl_provider_1 = require("./kubectl-provider");
// v2 - keep this import as a separate section to reduce merge conflict when forward merging with the v2 branch.
// eslint-disable-next-line
const core_2 = require("../../core");
/**
 * Represents a helm chart within the Kubernetes system.
 *
 * Applies/deletes the resources using `kubectl` in sync with the resource.
 */
class HelmChart extends core_2.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings.monocdk_aws_eks_HelmChartProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, HelmChart);
            }
            throw error;
        }
        const stack = core_1.Stack.of(this);
        const provider = kubectl_provider_1.KubectlProvider.getOrCreate(this, props.cluster);
        const timeout = props.timeout?.toSeconds();
        if (timeout && timeout > 900) {
            throw new Error('Helm chart timeout cannot be higher than 15 minutes.');
        }
        if (!props.chart && !props.chartAsset) {
            throw new Error("Either 'chart' or 'chartAsset' must be specified to install a helm chart");
        }
        if (props.chartAsset && (props.repository || props.version)) {
            throw new Error("Neither 'repository' nor 'version' can be used when configuring 'chartAsset'");
        }
        // default not to wait
        const wait = props.wait ?? false;
        // default to create new namespace
        const createNamespace = props.createNamespace ?? true;
        props.chartAsset?.grantRead(provider.handlerRole);
        new core_1.CustomResource(this, 'Resource', {
            serviceToken: provider.serviceToken,
            resourceType: HelmChart.RESOURCE_TYPE,
            properties: {
                ClusterName: props.cluster.clusterName,
                RoleArn: provider.roleArn,
                Release: props.release ?? core_1.Names.uniqueId(this).slice(-53).toLowerCase(),
                Chart: props.chart,
                ChartAssetURL: props.chartAsset?.s3ObjectUrl,
                Version: props.version,
                Wait: wait || undefined,
                Timeout: timeout ? `${timeout.toString()}s` : undefined,
                Values: (props.values ? stack.toJsonString(props.values) : undefined),
                Namespace: props.namespace ?? 'default',
                Repository: props.repository,
                CreateNamespace: createNamespace || undefined,
            },
        });
    }
}
exports.HelmChart = HelmChart;
_a = JSII_RTTI_SYMBOL_1;
HelmChart[_a] = { fqn: "monocdk.aws_eks.HelmChart", version: "1.191.0" };
/**
 * The CloudFormation resource type.
 */
HelmChart.RESOURCE_TYPE = 'Custom::AWSCDK-EKS-HelmChart';
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaGVsbS1jaGFydC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImhlbG0tY2hhcnQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBQ0EscUNBQW9FO0FBR3BFLHlEQUFxRDtBQUVyRCxnSEFBZ0g7QUFDaEgsMkJBQTJCO0FBQzNCLHFDQUF3RDtBQXFGeEQ7Ozs7R0FJRztBQUNILE1BQWEsU0FBVSxTQUFRLGdCQUFhO0lBTTFDLFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBcUI7UUFDN0QsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQzs7Ozs7OytDQVBSLFNBQVM7Ozs7UUFTbEIsTUFBTSxLQUFLLEdBQUcsWUFBSyxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUU3QixNQUFNLFFBQVEsR0FBRyxrQ0FBZSxDQUFDLFdBQVcsQ0FBQyxJQUFJLEVBQUUsS0FBSyxDQUFDLE9BQU8sQ0FBQyxDQUFDO1FBRWxFLE1BQU0sT0FBTyxHQUFHLEtBQUssQ0FBQyxPQUFPLEVBQUUsU0FBUyxFQUFFLENBQUM7UUFDM0MsSUFBSSxPQUFPLElBQUksT0FBTyxHQUFHLEdBQUcsRUFBRTtZQUM1QixNQUFNLElBQUksS0FBSyxDQUFDLHNEQUFzRCxDQUFDLENBQUM7U0FDekU7UUFFRCxJQUFJLENBQUMsS0FBSyxDQUFDLEtBQUssSUFBSSxDQUFDLEtBQUssQ0FBQyxVQUFVLEVBQUU7WUFDckMsTUFBTSxJQUFJLEtBQUssQ0FBQywwRUFBMEUsQ0FBQyxDQUFDO1NBQzdGO1FBRUQsSUFBSSxLQUFLLENBQUMsVUFBVSxJQUFJLENBQUMsS0FBSyxDQUFDLFVBQVUsSUFBSSxLQUFLLENBQUMsT0FBTyxDQUFDLEVBQUU7WUFDM0QsTUFBTSxJQUFJLEtBQUssQ0FDYiw4RUFBOEUsQ0FDL0UsQ0FBQztTQUNIO1FBRUQsc0JBQXNCO1FBQ3RCLE1BQU0sSUFBSSxHQUFHLEtBQUssQ0FBQyxJQUFJLElBQUksS0FBSyxDQUFDO1FBQ2pDLGtDQUFrQztRQUNsQyxNQUFNLGVBQWUsR0FBRyxLQUFLLENBQUMsZUFBZSxJQUFJLElBQUksQ0FBQztRQUV0RCxLQUFLLENBQUMsVUFBVSxFQUFFLFNBQVMsQ0FBQyxRQUFRLENBQUMsV0FBVyxDQUFDLENBQUM7UUFFbEQsSUFBSSxxQkFBYyxDQUFDLElBQUksRUFBRSxVQUFVLEVBQUU7WUFDbkMsWUFBWSxFQUFFLFFBQVEsQ0FBQyxZQUFZO1lBQ25DLFlBQVksRUFBRSxTQUFTLENBQUMsYUFBYTtZQUNyQyxVQUFVLEVBQUU7Z0JBQ1YsV0FBVyxFQUFFLEtBQUssQ0FBQyxPQUFPLENBQUMsV0FBVztnQkFDdEMsT0FBTyxFQUFFLFFBQVEsQ0FBQyxPQUFPO2dCQUN6QixPQUFPLEVBQUUsS0FBSyxDQUFDLE9BQU8sSUFBSSxZQUFLLENBQUMsUUFBUSxDQUFDLElBQUksQ0FBQyxDQUFDLEtBQUssQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLFdBQVcsRUFBRTtnQkFDdkUsS0FBSyxFQUFFLEtBQUssQ0FBQyxLQUFLO2dCQUNsQixhQUFhLEVBQUUsS0FBSyxDQUFDLFVBQVUsRUFBRSxXQUFXO2dCQUM1QyxPQUFPLEVBQUUsS0FBSyxDQUFDLE9BQU87Z0JBQ3RCLElBQUksRUFBRSxJQUFJLElBQUksU0FBUztnQkFDdkIsT0FBTyxFQUFFLE9BQU8sQ0FBQyxDQUFDLENBQUMsR0FBRyxPQUFPLENBQUMsUUFBUSxFQUFFLEdBQUcsQ0FBQyxDQUFDLENBQUMsU0FBUztnQkFDdkQsTUFBTSxFQUFFLENBQUMsS0FBSyxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUMsS0FBSyxDQUFDLFlBQVksQ0FBQyxLQUFLLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQztnQkFDckUsU0FBUyxFQUFFLEtBQUssQ0FBQyxTQUFTLElBQUksU0FBUztnQkFDdkMsVUFBVSxFQUFFLEtBQUssQ0FBQyxVQUFVO2dCQUM1QixlQUFlLEVBQUUsZUFBZSxJQUFJLFNBQVM7YUFDOUM7U0FDRixDQUFDLENBQUM7S0FDSjs7QUFyREgsOEJBc0RDOzs7QUFyREM7O0dBRUc7QUFDb0IsdUJBQWEsR0FBRyw4QkFBOEIsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEFzc2V0IH0gZnJvbSAnLi4vLi4vYXdzLXMzLWFzc2V0cyc7XG5pbXBvcnQgeyBDdXN0b21SZXNvdXJjZSwgRHVyYXRpb24sIE5hbWVzLCBTdGFjayB9IGZyb20gJy4uLy4uL2NvcmUnO1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5pbXBvcnQgeyBJQ2x1c3RlciB9IGZyb20gJy4vY2x1c3Rlcic7XG5pbXBvcnQgeyBLdWJlY3RsUHJvdmlkZXIgfSBmcm9tICcuL2t1YmVjdGwtcHJvdmlkZXInO1xuXG4vLyB2MiAtIGtlZXAgdGhpcyBpbXBvcnQgYXMgYSBzZXBhcmF0ZSBzZWN0aW9uIHRvIHJlZHVjZSBtZXJnZSBjb25mbGljdCB3aGVuIGZvcndhcmQgbWVyZ2luZyB3aXRoIHRoZSB2MiBicmFuY2guXG4vLyBlc2xpbnQtZGlzYWJsZS1uZXh0LWxpbmVcbmltcG9ydCB7IENvbnN0cnVjdCBhcyBDb3JlQ29uc3RydWN0IH0gZnJvbSAnLi4vLi4vY29yZSc7XG5cbi8qKlxuICogSGVsbSBDaGFydCBvcHRpb25zLlxuICovXG5cbmV4cG9ydCBpbnRlcmZhY2UgSGVsbUNoYXJ0T3B0aW9ucyB7XG4gIC8qKlxuICAgKiBUaGUgbmFtZSBvZiB0aGUgY2hhcnQuXG4gICAqIEVpdGhlciB0aGlzIG9yIGBjaGFydEFzc2V0YCBtdXN0IGJlIHNwZWNpZmllZC5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBObyBjaGFydCBuYW1lLiBJbXBsaWVzIGBjaGFydEFzc2V0YCBpcyB1c2VkLlxuICAgKi9cbiAgcmVhZG9ubHkgY2hhcnQ/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFRoZSBuYW1lIG9mIHRoZSByZWxlYXNlLlxuICAgKiBAZGVmYXVsdCAtIElmIG5vIHJlbGVhc2UgbmFtZSBpcyBnaXZlbiwgaXQgd2lsbCB1c2UgdGhlIGxhc3QgNTMgY2hhcmFjdGVycyBvZiB0aGUgbm9kZSdzIHVuaXF1ZSBpZC5cbiAgICovXG4gIHJlYWRvbmx5IHJlbGVhc2U/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFRoZSBjaGFydCB2ZXJzaW9uIHRvIGluc3RhbGwuXG4gICAqIEBkZWZhdWx0IC0gSWYgdGhpcyBpcyBub3Qgc3BlY2lmaWVkLCB0aGUgbGF0ZXN0IHZlcnNpb24gaXMgaW5zdGFsbGVkXG4gICAqL1xuICByZWFkb25seSB2ZXJzaW9uPzogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBUaGUgcmVwb3NpdG9yeSB3aGljaCBjb250YWlucyB0aGUgY2hhcnQuIEZvciBleGFtcGxlOiBodHRwczovL2t1YmVybmV0ZXMtY2hhcnRzLnN0b3JhZ2UuZ29vZ2xlYXBpcy5jb20vXG4gICAqIEBkZWZhdWx0IC0gTm8gcmVwb3NpdG9yeSB3aWxsIGJlIHVzZWQsIHdoaWNoIG1lYW5zIHRoYXQgdGhlIGNoYXJ0IG5lZWRzIHRvIGJlIGFuIGFic29sdXRlIFVSTC5cbiAgICovXG4gIHJlYWRvbmx5IHJlcG9zaXRvcnk/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICogVGhlIGNoYXJ0IGluIHRoZSBmb3JtIG9mIGFuIGFzc2V0LlxuICAqIEVpdGhlciB0aGlzIG9yIGBjaGFydGAgbXVzdCBiZSBzcGVjaWZpZWQuXG4gICpcbiAgKiBAZGVmYXVsdCAtIE5vIGNoYXJ0IGFzc2V0LiBJbXBsaWVzIGBjaGFydGAgaXMgdXNlZC5cbiAgKi9cbiAgcmVhZG9ubHkgY2hhcnRBc3NldD86IEFzc2V0O1xuXG4gIC8qKlxuICAgKiBUaGUgS3ViZXJuZXRlcyBuYW1lc3BhY2Ugc2NvcGUgb2YgdGhlIHJlcXVlc3RzLlxuICAgKiBAZGVmYXVsdCBkZWZhdWx0XG4gICAqL1xuICByZWFkb25seSBuYW1lc3BhY2U/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFRoZSB2YWx1ZXMgdG8gYmUgdXNlZCBieSB0aGUgY2hhcnQuXG4gICAqIEBkZWZhdWx0IC0gTm8gdmFsdWVzIGFyZSBwcm92aWRlZCB0byB0aGUgY2hhcnQuXG4gICAqL1xuICByZWFkb25seSB2YWx1ZXM/OiB7W2tleTogc3RyaW5nXTogYW55fTtcblxuICAvKipcbiAgICogV2hldGhlciBvciBub3QgSGVsbSBzaG91bGQgd2FpdCB1bnRpbCBhbGwgUG9kcywgUFZDcywgU2VydmljZXMsIGFuZCBtaW5pbXVtIG51bWJlciBvZiBQb2RzIG9mIGFcbiAgICogRGVwbG95bWVudCwgU3RhdGVmdWxTZXQsIG9yIFJlcGxpY2FTZXQgYXJlIGluIGEgcmVhZHkgc3RhdGUgYmVmb3JlIG1hcmtpbmcgdGhlIHJlbGVhc2UgYXMgc3VjY2Vzc2Z1bC5cbiAgICogQGRlZmF1bHQgLSBIZWxtIHdpbGwgbm90IHdhaXQgYmVmb3JlIG1hcmtpbmcgcmVsZWFzZSBhcyBzdWNjZXNzZnVsXG4gICAqL1xuICByZWFkb25seSB3YWl0PzogYm9vbGVhbjtcblxuICAvKipcbiAgICogQW1vdW50IG9mIHRpbWUgdG8gd2FpdCBmb3IgYW55IGluZGl2aWR1YWwgS3ViZXJuZXRlcyBvcGVyYXRpb24uIE1heGltdW0gMTUgbWludXRlcy5cbiAgICogQGRlZmF1bHQgRHVyYXRpb24ubWludXRlcyg1KVxuICAgKi9cbiAgcmVhZG9ubHkgdGltZW91dD86IER1cmF0aW9uO1xuXG4gIC8qKlxuICAgKiBjcmVhdGUgbmFtZXNwYWNlIGlmIG5vdCBleGlzdFxuICAgKiBAZGVmYXVsdCB0cnVlXG4gICAqL1xuICByZWFkb25seSBjcmVhdGVOYW1lc3BhY2U/OiBib29sZWFuO1xufVxuXG4vKipcbiAqIEhlbG0gQ2hhcnQgcHJvcGVydGllcy5cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBIZWxtQ2hhcnRQcm9wcyBleHRlbmRzIEhlbG1DaGFydE9wdGlvbnMge1xuICAvKipcbiAgICogVGhlIEVLUyBjbHVzdGVyIHRvIGFwcGx5IHRoaXMgY29uZmlndXJhdGlvbiB0by5cbiAgICpcbiAgICogW2Rpc2FibGUtYXdzbGludDpyZWYtdmlhLWludGVyZmFjZV1cbiAgICovXG4gIHJlYWRvbmx5IGNsdXN0ZXI6IElDbHVzdGVyO1xufVxuXG4vKipcbiAqIFJlcHJlc2VudHMgYSBoZWxtIGNoYXJ0IHdpdGhpbiB0aGUgS3ViZXJuZXRlcyBzeXN0ZW0uXG4gKlxuICogQXBwbGllcy9kZWxldGVzIHRoZSByZXNvdXJjZXMgdXNpbmcgYGt1YmVjdGxgIGluIHN5bmMgd2l0aCB0aGUgcmVzb3VyY2UuXG4gKi9cbmV4cG9ydCBjbGFzcyBIZWxtQ2hhcnQgZXh0ZW5kcyBDb3JlQ29uc3RydWN0IHtcbiAgLyoqXG4gICAqIFRoZSBDbG91ZEZvcm1hdGlvbiByZXNvdXJjZSB0eXBlLlxuICAgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBSRVNPVVJDRV9UWVBFID0gJ0N1c3RvbTo6QVdTQ0RLLUVLUy1IZWxtQ2hhcnQnO1xuXG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBIZWxtQ2hhcnRQcm9wcykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCk7XG5cbiAgICBjb25zdCBzdGFjayA9IFN0YWNrLm9mKHRoaXMpO1xuXG4gICAgY29uc3QgcHJvdmlkZXIgPSBLdWJlY3RsUHJvdmlkZXIuZ2V0T3JDcmVhdGUodGhpcywgcHJvcHMuY2x1c3Rlcik7XG5cbiAgICBjb25zdCB0aW1lb3V0ID0gcHJvcHMudGltZW91dD8udG9TZWNvbmRzKCk7XG4gICAgaWYgKHRpbWVvdXQgJiYgdGltZW91dCA+IDkwMCkge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKCdIZWxtIGNoYXJ0IHRpbWVvdXQgY2Fubm90IGJlIGhpZ2hlciB0aGFuIDE1IG1pbnV0ZXMuJyk7XG4gICAgfVxuXG4gICAgaWYgKCFwcm9wcy5jaGFydCAmJiAhcHJvcHMuY2hhcnRBc3NldCkge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKFwiRWl0aGVyICdjaGFydCcgb3IgJ2NoYXJ0QXNzZXQnIG11c3QgYmUgc3BlY2lmaWVkIHRvIGluc3RhbGwgYSBoZWxtIGNoYXJ0XCIpO1xuICAgIH1cblxuICAgIGlmIChwcm9wcy5jaGFydEFzc2V0ICYmIChwcm9wcy5yZXBvc2l0b3J5IHx8IHByb3BzLnZlcnNpb24pKSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoXG4gICAgICAgIFwiTmVpdGhlciAncmVwb3NpdG9yeScgbm9yICd2ZXJzaW9uJyBjYW4gYmUgdXNlZCB3aGVuIGNvbmZpZ3VyaW5nICdjaGFydEFzc2V0J1wiLFxuICAgICAgKTtcbiAgICB9XG5cbiAgICAvLyBkZWZhdWx0IG5vdCB0byB3YWl0XG4gICAgY29uc3Qgd2FpdCA9IHByb3BzLndhaXQgPz8gZmFsc2U7XG4gICAgLy8gZGVmYXVsdCB0byBjcmVhdGUgbmV3IG5hbWVzcGFjZVxuICAgIGNvbnN0IGNyZWF0ZU5hbWVzcGFjZSA9IHByb3BzLmNyZWF0ZU5hbWVzcGFjZSA/PyB0cnVlO1xuXG4gICAgcHJvcHMuY2hhcnRBc3NldD8uZ3JhbnRSZWFkKHByb3ZpZGVyLmhhbmRsZXJSb2xlKTtcblxuICAgIG5ldyBDdXN0b21SZXNvdXJjZSh0aGlzLCAnUmVzb3VyY2UnLCB7XG4gICAgICBzZXJ2aWNlVG9rZW46IHByb3ZpZGVyLnNlcnZpY2VUb2tlbixcbiAgICAgIHJlc291cmNlVHlwZTogSGVsbUNoYXJ0LlJFU09VUkNFX1RZUEUsXG4gICAgICBwcm9wZXJ0aWVzOiB7XG4gICAgICAgIENsdXN0ZXJOYW1lOiBwcm9wcy5jbHVzdGVyLmNsdXN0ZXJOYW1lLFxuICAgICAgICBSb2xlQXJuOiBwcm92aWRlci5yb2xlQXJuLCAvLyBUT0RPOiBiYWtlIGludG8gdGhlIHByb3ZpZGVyJ3MgZW52aXJvbm1lbnRcbiAgICAgICAgUmVsZWFzZTogcHJvcHMucmVsZWFzZSA/PyBOYW1lcy51bmlxdWVJZCh0aGlzKS5zbGljZSgtNTMpLnRvTG93ZXJDYXNlKCksIC8vIEhlbG0gaGFzIGEgNTMgY2hhcmFjdGVyIGxpbWl0IGZvciB0aGUgbmFtZVxuICAgICAgICBDaGFydDogcHJvcHMuY2hhcnQsXG4gICAgICAgIENoYXJ0QXNzZXRVUkw6IHByb3BzLmNoYXJ0QXNzZXQ/LnMzT2JqZWN0VXJsLFxuICAgICAgICBWZXJzaW9uOiBwcm9wcy52ZXJzaW9uLFxuICAgICAgICBXYWl0OiB3YWl0IHx8IHVuZGVmaW5lZCwgLy8gcHJvcHMgYXJlIHN0cmluZ2lmaWVkIHNvIHdlIGVuY29kZSDigJxmYWxzZeKAnSBhcyB1bmRlZmluZWRcbiAgICAgICAgVGltZW91dDogdGltZW91dCA/IGAke3RpbWVvdXQudG9TdHJpbmcoKX1zYCA6IHVuZGVmaW5lZCwgLy8gSGVsbSB2MyBleHBlY3RzIGR1cmF0aW9uIGluc3RlYWQgb2YgaW50ZWdlclxuICAgICAgICBWYWx1ZXM6IChwcm9wcy52YWx1ZXMgPyBzdGFjay50b0pzb25TdHJpbmcocHJvcHMudmFsdWVzKSA6IHVuZGVmaW5lZCksXG4gICAgICAgIE5hbWVzcGFjZTogcHJvcHMubmFtZXNwYWNlID8/ICdkZWZhdWx0JyxcbiAgICAgICAgUmVwb3NpdG9yeTogcHJvcHMucmVwb3NpdG9yeSxcbiAgICAgICAgQ3JlYXRlTmFtZXNwYWNlOiBjcmVhdGVOYW1lc3BhY2UgfHwgdW5kZWZpbmVkLFxuICAgICAgfSxcbiAgICB9KTtcbiAgfVxufVxuIl19