"use strict";
// Copyright 2012-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
Object.defineProperty(exports, "__esModule", { value: true });
exports.ELBMetrics = void 0;
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
class ELBMetrics {
    static backendConnectionErrorsSum(dimensions) {
        return {
            namespace: 'AWS/ELB',
            metricName: 'BackendConnectionErrors',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static desyncMitigationModeNonCompliantRequestCountSum(dimensions) {
        return {
            namespace: 'AWS/ELB',
            metricName: 'DesyncMitigationMode_NonCompliant_Request_Count',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static httpCodeBackend2XxSum(dimensions) {
        return {
            namespace: 'AWS/ELB',
            metricName: 'HTTPCode_Backend_2XX',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static httpCodeBackend3XxSum(dimensions) {
        return {
            namespace: 'AWS/ELB',
            metricName: 'HTTPCode_Backend_3XX',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static httpCodeBackend4XxSum(dimensions) {
        return {
            namespace: 'AWS/ELB',
            metricName: 'HTTPCode_Backend_4XX',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static httpCodeBackend5XxSum(dimensions) {
        return {
            namespace: 'AWS/ELB',
            metricName: 'HTTPCode_Backend_5XX',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static httpCodeElb4XxSum(dimensions) {
        return {
            namespace: 'AWS/ELB',
            metricName: 'HTTPCode_ELB_4XX',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static httpCodeElb5XxSum(dimensions) {
        return {
            namespace: 'AWS/ELB',
            metricName: 'HTTPCode_ELB_5XX',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static healthyHostCountAverage(dimensions) {
        return {
            namespace: 'AWS/ELB',
            metricName: 'HealthyHostCount',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static latencyAverage(dimensions) {
        return {
            namespace: 'AWS/ELB',
            metricName: 'Latency',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static requestCountSum(dimensions) {
        return {
            namespace: 'AWS/ELB',
            metricName: 'RequestCount',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static spilloverCountSum(dimensions) {
        return {
            namespace: 'AWS/ELB',
            metricName: 'SpilloverCount',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static surgeQueueLengthAverage(dimensions) {
        return {
            namespace: 'AWS/ELB',
            metricName: 'SurgeQueueLength',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static unHealthyHostCountAverage(dimensions) {
        return {
            namespace: 'AWS/ELB',
            metricName: 'UnHealthyHostCount',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
}
exports.ELBMetrics = ELBMetrics;
//# sourceMappingURL=data:application/json;base64,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