"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IpTarget = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const elbv2 = require("../../aws-elasticloadbalancingv2");
/**
 * An IP address that is a target for load balancing.
 *
 * Specify IP addresses from the subnets of the virtual private cloud (VPC) for
 * the target group, the RFC 1918 range (10.0.0.0/8, 172.16.0.0/12, and
 * 192.168.0.0/16), and the RFC 6598 range (100.64.0.0/10). You can't specify
 * publicly routable IP addresses.
 *
 * If you register a target of this type, you are responsible for making
 * sure the load balancer's security group can send packets to the IP address.
 */
class IpTarget {
    /**
     * Create a new IPAddress target
     *
     * The availabilityZone parameter determines whether the target receives
     * traffic from the load balancer nodes in the specified Availability Zone
     * or from all enabled Availability Zones for the load balancer.
     *
     * This parameter is not supported if the target type of the target group
     * is instance. If the IP address is in a subnet of the VPC for the target
     * group, the Availability Zone is automatically detected and this
     * parameter is optional. If the IP address is outside the VPC, this
     * parameter is required.
     *
     * With an Application Load Balancer, if the IP address is outside the VPC
     * for the target group, the only supported value is all.
     *
     * Default is automatic.
     *
     * @param ipAddress The IP Address to load balance to
     * @param port Override the group's default port
     * @param availabilityZone Availability zone to send traffic from
     */
    constructor(ipAddress, port, availabilityZone) {
        this.ipAddress = ipAddress;
        this.port = port;
        this.availabilityZone = availabilityZone;
    }
    /**
     * Register this instance target with a load balancer
     *
     * Don't call this, it is called automatically when you add the target to a
     * load balancer.
     */
    attachToApplicationTargetGroup(targetGroup) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_elasticloadbalancingv2_IApplicationTargetGroup(targetGroup);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.attachToApplicationTargetGroup);
            }
            throw error;
        }
        return this.attach(targetGroup);
    }
    /**
     * Register this instance target with a load balancer
     *
     * Don't call this, it is called automatically when you add the target to a
     * load balancer.
     */
    attachToNetworkTargetGroup(targetGroup) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_elasticloadbalancingv2_INetworkTargetGroup(targetGroup);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.attachToNetworkTargetGroup);
            }
            throw error;
        }
        return this.attach(targetGroup);
    }
    attach(_targetGroup) {
        return {
            targetType: elbv2.TargetType.IP,
            targetJson: { id: this.ipAddress, port: this.port, availabilityZone: this.availabilityZone },
        };
    }
}
exports.IpTarget = IpTarget;
_a = JSII_RTTI_SYMBOL_1;
IpTarget[_a] = { fqn: "monocdk.aws_elasticloadbalancingv2_targets.IpTarget", version: "1.191.0" };
//# sourceMappingURL=data:application/json;base64,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