"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApiDestination = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("../../aws-iam");
const util_1 = require("./util");
/**
 * Use an API Destination rule target.
 */
class ApiDestination {
    constructor(apiDestination, props = {}) {
        this.apiDestination = apiDestination;
        this.props = props;
        try {
            jsiiDeprecationWarnings.monocdk_aws_events_IApiDestination(apiDestination);
            jsiiDeprecationWarnings.monocdk_aws_events_targets_ApiDestinationProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, ApiDestination);
            }
            throw error;
        }
    }
    /**
     * Returns a RuleTarget that can be used to trigger API destinations
     * from an EventBridge event.
     */
    bind(_rule, _id) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_events_IRule(_rule);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        const httpParameters = !!this.props.headerParameters ??
            !!this.props.pathParameterValues ??
            !!this.props.queryStringParameters
            ? {
                headerParameters: this.props.headerParameters,
                pathParameterValues: this.props.pathParameterValues,
                queryStringParameters: this.props.queryStringParameters,
            } : undefined;
        if (this.props?.deadLetterQueue) {
            util_1.addToDeadLetterQueueResourcePolicy(_rule, this.props.deadLetterQueue);
        }
        const role = this.props?.eventRole ?? util_1.singletonEventRole(this.apiDestination);
        role.addToPrincipalPolicy(new iam.PolicyStatement({
            resources: [this.apiDestination.apiDestinationArn],
            actions: ['events:InvokeApiDestination'],
        }));
        return {
            ...(this.props ? util_1.bindBaseTargetConfig(this.props) : {}),
            arn: this.apiDestination.apiDestinationArn,
            role,
            input: this.props.event,
            targetResource: this.apiDestination,
            httpParameters,
        };
    }
}
exports.ApiDestination = ApiDestination;
_a = JSII_RTTI_SYMBOL_1;
ApiDestination[_a] = { fqn: "monocdk.aws_events_targets.ApiDestination", version: "1.191.0" };
//# sourceMappingURL=data:application/json;base64,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