"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApiGateway = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("../../aws-iam");
const util_1 = require("./util");
/**
 * Use an API Gateway REST APIs as a target for Amazon EventBridge rules.
 */
class ApiGateway {
    constructor(restApi, props) {
        this.restApi = restApi;
        this.props = props;
        try {
            jsiiDeprecationWarnings.monocdk_aws_apigateway_RestApi(restApi);
            jsiiDeprecationWarnings.monocdk_aws_events_targets_ApiGatewayProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, ApiGateway);
            }
            throw error;
        }
    }
    /**
     * Returns a RuleTarget that can be used to trigger this API Gateway REST APIs
     * as a result from an EventBridge event.
     *
     * @see https://docs.aws.amazon.com/eventbridge/latest/userguide/resource-based-policies-eventbridge.html#sqs-permissions
     */
    bind(rule, _id) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_events_IRule(rule);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        if (this.props?.deadLetterQueue) {
            util_1.addToDeadLetterQueueResourcePolicy(rule, this.props.deadLetterQueue);
        }
        const wildcardCountsInPath = this.props?.path?.match(/\*/g)?.length ?? 0;
        if (wildcardCountsInPath !== (this.props?.pathParameterValues || []).length) {
            throw new Error('The number of wildcards in the path does not match the number of path pathParameterValues.');
        }
        const restApiArn = this.restApi.arnForExecuteApi(this.props?.method, this.props?.path || '/', this.props?.stage || this.restApi.deploymentStage.stageName);
        const role = this.props?.eventRole || util_1.singletonEventRole(this.restApi);
        role.addToPrincipalPolicy(new iam.PolicyStatement({
            resources: [restApiArn],
            actions: [
                'execute-api:Invoke',
                'execute-api:ManageConnections',
            ],
        }));
        return {
            ...(this.props ? util_1.bindBaseTargetConfig(this.props) : {}),
            arn: restApiArn,
            role,
            deadLetterConfig: this.props?.deadLetterQueue && { arn: this.props.deadLetterQueue?.queueArn },
            input: this.props?.postBody,
            targetResource: this.restApi,
            httpParameters: {
                headerParameters: this.props?.headerParameters,
                queryStringParameters: this.props?.queryStringParameters,
                pathParameterValues: this.props?.pathParameterValues,
            },
        };
    }
}
exports.ApiGateway = ApiGateway;
_a = JSII_RTTI_SYMBOL_1;
ApiGateway[_a] = { fqn: "monocdk.aws_events_targets.ApiGateway", version: "1.191.0" };
//# sourceMappingURL=data:application/json;base64,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