"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CodePipeline = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("../../aws-iam");
const util_1 = require("./util");
/**
 * Allows the pipeline to be used as an EventBridge rule target.
 */
class CodePipeline {
    constructor(pipeline, options = {}) {
        this.pipeline = pipeline;
        this.options = options;
        try {
            jsiiDeprecationWarnings.monocdk_aws_codepipeline_IPipeline(pipeline);
            jsiiDeprecationWarnings.monocdk_aws_events_targets_CodePipelineTargetOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CodePipeline);
            }
            throw error;
        }
    }
    bind(_rule, _id) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_events_IRule(_rule);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        const role = this.options.eventRole || util_1.singletonEventRole(this.pipeline);
        role.addToPrincipalPolicy(new iam.PolicyStatement({
            resources: [this.pipeline.pipelineArn],
            actions: ['codepipeline:StartPipelineExecution'],
        }));
        return {
            ...util_1.bindBaseTargetConfig(this.options),
            id: '',
            arn: this.pipeline.pipelineArn,
            role,
            targetResource: this.pipeline,
        };
    }
}
exports.CodePipeline = CodePipeline;
_a = JSII_RTTI_SYMBOL_1;
CodePipeline[_a] = { fqn: "monocdk.aws_events_targets.CodePipeline", version: "1.191.0" };
//# sourceMappingURL=data:application/json;base64,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