"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KinesisFirehoseStream = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("../../aws-iam");
const util_1 = require("./util");
/**
 * Customize the Firehose Stream Event Target
 */
class KinesisFirehoseStream {
    constructor(stream, props = {}) {
        this.stream = stream;
        this.props = props;
        try {
            jsiiDeprecationWarnings.monocdk_aws_kinesisfirehose_CfnDeliveryStream(stream);
            jsiiDeprecationWarnings.monocdk_aws_events_targets_KinesisFirehoseStreamProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, KinesisFirehoseStream);
            }
            throw error;
        }
    }
    /**
     * Returns a RuleTarget that can be used to trigger this Firehose Stream as a
     * result from a Event Bridge event.
     */
    bind(_rule, _id) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_events_IRule(_rule);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        const role = util_1.singletonEventRole(this.stream);
        role.addToPrincipalPolicy(new iam.PolicyStatement({
            actions: ['firehose:PutRecord', 'firehose:PutRecordBatch'],
            resources: [this.stream.attrArn],
        }));
        return {
            arn: this.stream.attrArn,
            role,
            input: this.props.message,
            targetResource: this.stream,
        };
    }
}
exports.KinesisFirehoseStream = KinesisFirehoseStream;
_a = JSII_RTTI_SYMBOL_1;
KinesisFirehoseStream[_a] = { fqn: "monocdk.aws_events_targets.KinesisFirehoseStream", version: "1.191.0" };
//# sourceMappingURL=data:application/json;base64,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