"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KinesisStream = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("../../aws-iam");
const util_1 = require("./util");
/**
 * Use a Kinesis Stream as a target for AWS CloudWatch event rules.
 *
 * @example
 *   /// fixture=withRepoAndKinesisStream
 *   // put to a Kinesis stream every time code is committed
 *   // to a CodeCommit repository
 *   repository.onCommit('onCommit', { target: new targets.KinesisStream(stream) });
 *
 */
class KinesisStream {
    constructor(stream, props = {}) {
        this.stream = stream;
        this.props = props;
        try {
            jsiiDeprecationWarnings.monocdk_aws_kinesis_IStream(stream);
            jsiiDeprecationWarnings.monocdk_aws_events_targets_KinesisStreamProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, KinesisStream);
            }
            throw error;
        }
    }
    /**
     * Returns a RuleTarget that can be used to trigger this Kinesis Stream as a
     * result from a CloudWatch event.
     */
    bind(_rule, _id) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_events_IRule(_rule);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        const role = util_1.singletonEventRole(this.stream);
        role.addToPrincipalPolicy(new iam.PolicyStatement({
            actions: ['kinesis:PutRecord', 'kinesis:PutRecords'],
            resources: [this.stream.streamArn],
        }));
        return {
            arn: this.stream.streamArn,
            role,
            input: this.props.message,
            targetResource: this.stream,
            kinesisParameters: this.props.partitionKeyPath ? { partitionKeyPath: this.props.partitionKeyPath } : undefined,
        };
    }
}
exports.KinesisStream = KinesisStream;
_a = JSII_RTTI_SYMBOL_1;
KinesisStream[_a] = { fqn: "monocdk.aws_events_targets.KinesisStream", version: "1.191.0" };
//# sourceMappingURL=data:application/json;base64,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