import * as events from '../../aws-events';
import * as logs from '../../aws-logs';
import { TargetBaseProps } from './util';
/**
 * Customize the CloudWatch LogGroup Event Target
 */
export interface LogGroupProps extends TargetBaseProps {
    /**
     * The event to send to the CloudWatch LogGroup
     *
     * This will be the event logged into the CloudWatch LogGroup
     *
     * @default - the entire EventBridge event
     */
    readonly event?: events.RuleTargetInput;
}
/**
 * Use an AWS CloudWatch LogGroup as an event rule target.
 */
export declare class CloudWatchLogGroup implements events.IRuleTarget {
    private readonly logGroup;
    private readonly props;
    constructor(logGroup: logs.ILogGroup, props?: LogGroupProps);
    /**
     * Returns a RuleTarget that can be used to log an event into a CloudWatch LogGroup
     */
    bind(_rule: events.IRule, _id?: string): events.RuleTargetConfig;
}
