"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudWatchLogGroup = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("../../aws-iam");
const cdk = require("../../core");
const core_1 = require("../../core");
const log_group_resource_policy_1 = require("./log-group-resource-policy");
const util_1 = require("./util");
/**
 * Use an AWS CloudWatch LogGroup as an event rule target.
 */
class CloudWatchLogGroup {
    constructor(logGroup, props = {}) {
        this.logGroup = logGroup;
        this.props = props;
        try {
            jsiiDeprecationWarnings.monocdk_aws_logs_ILogGroup(logGroup);
            jsiiDeprecationWarnings.monocdk_aws_events_targets_LogGroupProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CloudWatchLogGroup);
            }
            throw error;
        }
    }
    /**
     * Returns a RuleTarget that can be used to log an event into a CloudWatch LogGroup
     */
    bind(_rule, _id) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_events_IRule(_rule);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        // Use a custom resource to set the log group resource policy since it is not supported by CDK and cfn.
        const resourcePolicyId = `EventsLogGroupPolicy${cdk.Names.nodeUniqueId(_rule.node)}`;
        const logGroupStack = cdk.Stack.of(this.logGroup);
        if (!this.logGroup.node.tryFindChild(resourcePolicyId)) {
            new log_group_resource_policy_1.LogGroupResourcePolicy(logGroupStack, resourcePolicyId, {
                policyStatements: [new iam.PolicyStatement({
                        effect: iam.Effect.ALLOW,
                        actions: ['logs:PutLogEvents', 'logs:CreateLogStream'],
                        resources: [this.logGroup.logGroupArn],
                        principals: [new iam.ServicePrincipal('events.amazonaws.com')],
                    })],
            });
        }
        return {
            ...util_1.bindBaseTargetConfig(this.props),
            arn: logGroupStack.formatArn({
                service: 'logs',
                resource: 'log-group',
                arnFormat: core_1.ArnFormat.COLON_RESOURCE_NAME,
                resourceName: this.logGroup.logGroupName,
            }),
            input: this.props.event,
            targetResource: this.logGroup,
        };
    }
}
exports.CloudWatchLogGroup = CloudWatchLogGroup;
_a = JSII_RTTI_SYMBOL_1;
CloudWatchLogGroup[_a] = { fqn: "monocdk.aws_events_targets.CloudWatchLogGroup", version: "1.191.0" };
//# sourceMappingURL=data:application/json;base64,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